#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

#define XPAR_XCFRAME_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_COMPATIBLE "xlnx,psv-pmc-cfi-cframe-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_BASEADDR 0xf12d0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0_HIGHADDR 0xf12d0fff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFI_CFRAME_0 */
#define XPAR_XCFRAME_0_BASEADDR 0xf12d0000
#define XPAR_XCFRAME_0_HIGHADDR 0xf12d0fff
#define XPAR_XCFRAME_0_COMPATIBLE "xlnx,psv-pmc-cfi-cframe-1.0"

#define XPAR_XCFUPMC_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_COMPATIBLE "xlnx,psv-pmc-cfu-apb-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_BASEADDR 0xf12b0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0_HIGHADDR 0xf12bffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_CFU_APB_0 */
#define XPAR_XCFUPMC_0_BASEADDR 0xf12b0000
#define XPAR_XCFUPMC_0_HIGHADDR 0xf12bffff
#define XPAR_XCFUPMC_0_COMPATIBLE "xlnx,psv-pmc-cfu-apb-1.0"

#define XPAR_XCSUDMA_NUM_INSTANCES 2

/* Definitions for peripheral DMA0 */
#define XPAR_DMA0_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_DMA0_BASEADDR 0xf11c0000
#define XPAR_DMA0_HIGHADDR 0xf11cffff
#define XPAR_DMA0_DMA_TYPE 0x1
#define XPAR_DMA0_INTERRUPTS 0x4083

/* Canonical definitions for peripheral DMA0 */
#define XPAR_XCSUDMA_0_BASEADDR 0xf11c0000
#define XPAR_XCSUDMA_0_HIGHADDR 0xf11cffff
#define XPAR_XCSUDMA_0_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_XCSUDMA_0_DMA_TYPE 0x1
#define XPAR_XCSUDMA_0_INTERRUPTS 0x4083

/* Definitions for peripheral DMA1 */
#define XPAR_DMA1_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_DMA1_BASEADDR 0xf11d0000
#define XPAR_DMA1_HIGHADDR 0xf11dffff
#define XPAR_DMA1_DMA_TYPE 0x2
#define XPAR_DMA1_INTERRUPTS 0x4084

/* Canonical definitions for peripheral DMA1 */
#define XPAR_XCSUDMA_1_BASEADDR 0xf11d0000
#define XPAR_XCSUDMA_1_HIGHADDR 0xf11dffff
#define XPAR_XCSUDMA_1_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_XCSUDMA_1_DMA_TYPE 0x2
#define XPAR_XCSUDMA_1_INTERRUPTS 0x4084

#define XPAR_XGPIOPS_NUM_INSTANCES 2

/* Definitions for peripheral GPIO0 */
#define XPAR_GPIO0_COMPATIBLE "xlnx,versal-gpio-1.0"
#define XPAR_GPIO0_BASEADDR 0xff0b0000
#define XPAR_GPIO0_HIGHADDR 0xff0b0fff
#define XPAR_GPIO0_INTERRUPTS 0x400d

/* Canonical definitions for peripheral GPIO0 */
#define XPAR_XGPIOPS_0_BASEADDR 0xff0b0000
#define XPAR_XGPIOPS_0_HIGHADDR 0xff0b0fff
#define XPAR_XGPIOPS_0_COMPATIBLE "xlnx,versal-gpio-1.0"
#define XPAR_XGPIOPS_0_INTERRUPTS 0x400d

/* Definitions for peripheral GPIO1 */
#define XPAR_GPIO1_COMPATIBLE "xlnx,pmc-gpio-1.0"
#define XPAR_GPIO1_BASEADDR 0xf1020000
#define XPAR_GPIO1_HIGHADDR 0xf1020fff
#define XPAR_GPIO1_INTERRUPTS 0x407a

/* Canonical definitions for peripheral GPIO1 */
#define XPAR_XGPIOPS_1_BASEADDR 0xf1020000
#define XPAR_XGPIOPS_1_HIGHADDR 0xf1020fff
#define XPAR_XGPIOPS_1_COMPATIBLE "xlnx,pmc-gpio-1.0"
#define XPAR_XGPIOPS_1_INTERRUPTS 0x407a

#define XPAR_XIICPS_NUM_INSTANCES 2

/* Definitions for peripheral I2C0 */
#define XPAR_I2C0_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_I2C0_BASEADDR 0xff020000
#define XPAR_I2C0_HIGHADDR 0xff020fff
#define XPAR_I2C0_CLOCK_FREQ 0x5f5e0a4
#define XPAR_I2C0_INTERRUPTS 0x400e
#define XPAR_I2C0_CLOCKS 0x62

/* Canonical definitions for peripheral I2C0 */
#define XPAR_XIICPS_0_BASEADDR 0xff020000
#define XPAR_XIICPS_0_HIGHADDR 0xff020fff
#define XPAR_XIICPS_0_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_XIICPS_0_CLOCK_FREQ 0x5f5e0a4
#define XPAR_XIICPS_0_CLOCKS 0x62
#define XPAR_XIICPS_0_INTERRUPTS 0x400e

/* Definitions for peripheral I2C1 */
#define XPAR_I2C1_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_I2C1_BASEADDR 0xff030000
#define XPAR_I2C1_HIGHADDR 0xff030fff
#define XPAR_I2C1_CLOCK_FREQ 0x5f5e0a4
#define XPAR_I2C1_INTERRUPTS 0x400f
#define XPAR_I2C1_CLOCKS 0x63

/* Canonical definitions for peripheral I2C1 */
#define XPAR_XIICPS_1_BASEADDR 0xff030000
#define XPAR_XIICPS_1_HIGHADDR 0xff030fff
#define XPAR_XIICPS_1_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_XIICPS_1_CLOCK_FREQ 0x5f5e0a4
#define XPAR_XIICPS_1_CLOCKS 0x63
#define XPAR_XIICPS_1_INTERRUPTS 0x400f

#define XPAR_XIOMODULE_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_COMPATIBLE "xlnx,iomodule-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_BASEADDR 0xffc80000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_HIGHADDR 0xffc87fff
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_HAS_FAST 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_BASE_VECTORS 0xffc00000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_ADDR_WIDTH 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_LEVEL_EDGE 0x7fff
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_OPTIONS 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_CLOCK_FREQ 0x5f5e100
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_BAUDRATE 0x1c200
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_USED_0 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_USED_1 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_USED_2 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_USED_3 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_SIZE_0 32
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_SIZE_1 32
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_SIZE_2 32
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_SIZE_3 32
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_MASK_0 4294967295
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_MASK_1 4294967295
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_MASK_2 4294967295
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_MASK_3 4294967295
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_PRESCALER_0 9
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_PRESCALER_1 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_PRESCALER_2 9
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_PRESCALER_3 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_READABLE_0 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_READABLE_1 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_READABLE_2 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT_READABLE_3 1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO_INIT_0 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO_INIT_1 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO_INIT_2 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO_INIT_3 0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_MAX_INTR_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_INTR_SIZE 0x10
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_USE_EXT_INTR 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_INTC_POSITIVE 0xffff
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_PROG_BAUDRATE 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_DATA_BITS 0x8
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_USE_PARITY 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_ODD_PARITY 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_RX_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_TX_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_UART_RX 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_UART_TX 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_UART_ERROR_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_FIT1 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT1_NO_CLOCKS 0x1848
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT1_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_FIT2 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT2_NO_CLOCKS 0x1848
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT2_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_FIT3 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT3_NO_CLOCKS 0x1848
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT3_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_FIT4 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT4_NO_CLOCKS 0x1848
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FIT4_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_PIT1 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT1_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT1_READABLE 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT1_PRESCALER 0x9
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT1_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_PIT2 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT2_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT2_READABLE 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT2_PRESCALER 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT2_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_PIT3 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT3_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT3_READABLE 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT3_PRESCALER 0x9
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT3_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_PIT4 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT4_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT4_READABLE 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT4_PRESCALER 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_PIT4_INTERRUPT 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPO1 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO1_SIZE 0x3
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO1_INIT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPO2 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO2_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO2_INIT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPO3 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO3_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO3_INIT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPO4 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO4_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPO4_INIT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPI1 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI1_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI1_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPI2 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI2_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI2_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPI3 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI3_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI3_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_GPI4 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI4_SIZE 0x20
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_GPI4_INTERRUPT 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_USE_IO_BUS 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_IO_MASK 0xfffe0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0_FREQ 0x5f5e100

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_IOMODULE_0 */
#define XPAR_XIOMODULE_0_BASEADDR 0xffc80000
#define XPAR_XIOMODULE_0_HIGHADDR 0xffc87fff
#define XPAR_XIOMODULE_0_COMPATIBLE "xlnx,iomodule-1.0"
#define XPAR_XIOMODULE_0_CLOCK_FREQ 0x5f5e100
#define XPAR_XIOMODULE_0_FIT1_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT1_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FIT2_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT2_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FIT3_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT3_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FIT4_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT4_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FREQ 0x5f5e100
#define XPAR_XIOMODULE_0_GPO_INIT_0 0
#define XPAR_XIOMODULE_0_GPO_INIT_1 0
#define XPAR_XIOMODULE_0_GPO_INIT_2 0
#define XPAR_XIOMODULE_0_GPO_INIT_3 0
#define XPAR_XIOMODULE_0_GPO1_SIZE 0x3
#define XPAR_XIOMODULE_0_GPO1_INIT 0x0
#define XPAR_XIOMODULE_0_GPO2_SIZE 0x20
#define XPAR_XIOMODULE_0_GPO2_INIT 0x0
#define XPAR_XIOMODULE_0_GPO3_SIZE 0x20
#define XPAR_XIOMODULE_0_GPO3_INIT 0x0
#define XPAR_XIOMODULE_0_GPO4_SIZE 0x20
#define XPAR_XIOMODULE_0_GPO4_INIT 0x0
#define XPAR_XIOMODULE_0_GPI1_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI1_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_GPI2_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI2_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_GPI3_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI3_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_GPI4_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI4_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_INTC_HAS_FAST 0x0
#define XPAR_XIOMODULE_0_INTC_BASE_VECTORS 0xffc00000
#define XPAR_XIOMODULE_0_INTC_ADDR_WIDTH 0x20
#define XPAR_XIOMODULE_0_INTC_LEVEL_EDGE 0x7fff
#define XPAR_XIOMODULE_0_INTC_INTR_SIZE 0x10
#define XPAR_XIOMODULE_0_INTC_USE_EXT_INTR 0x1
#define XPAR_XIOMODULE_0_INTC_POSITIVE 0xffff
#define XPAR_XIOMODULE_0_IO_MASK 0xfffe0000
#define XPAR_XIOMODULE_0_MAX_INTR_SIZE 0x20
#define XPAR_XIOMODULE_0_OPTIONS 0x1
#define XPAR_XIOMODULE_0_PIT_USED_0 1
#define XPAR_XIOMODULE_0_PIT_USED_1 1
#define XPAR_XIOMODULE_0_PIT_USED_2 1
#define XPAR_XIOMODULE_0_PIT_USED_3 1
#define XPAR_XIOMODULE_0_PIT_SIZE_0 32
#define XPAR_XIOMODULE_0_PIT_SIZE_1 32
#define XPAR_XIOMODULE_0_PIT_SIZE_2 32
#define XPAR_XIOMODULE_0_PIT_SIZE_3 32
#define XPAR_XIOMODULE_0_PIT_MASK_0 4294967295
#define XPAR_XIOMODULE_0_PIT_MASK_1 4294967295
#define XPAR_XIOMODULE_0_PIT_MASK_2 4294967295
#define XPAR_XIOMODULE_0_PIT_MASK_3 4294967295
#define XPAR_XIOMODULE_0_PIT_PRESCALER_0 9
#define XPAR_XIOMODULE_0_PIT_PRESCALER_1 0
#define XPAR_XIOMODULE_0_PIT_PRESCALER_2 9
#define XPAR_XIOMODULE_0_PIT_PRESCALER_3 0
#define XPAR_XIOMODULE_0_PIT_READABLE_0 1
#define XPAR_XIOMODULE_0_PIT_READABLE_1 1
#define XPAR_XIOMODULE_0_PIT_READABLE_2 1
#define XPAR_XIOMODULE_0_PIT_READABLE_3 1
#define XPAR_XIOMODULE_0_PIT1_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT1_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT1_PRESCALER 0x9
#define XPAR_XIOMODULE_0_PIT1_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_PIT2_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT2_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT2_PRESCALER 0x0
#define XPAR_XIOMODULE_0_PIT2_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_PIT3_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT3_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT3_PRESCALER 0x9
#define XPAR_XIOMODULE_0_PIT3_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_PIT4_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT4_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT4_PRESCALER 0x0
#define XPAR_XIOMODULE_0_PIT4_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_UART_BAUDRATE 0x1c200
#define XPAR_XIOMODULE_0_UART_PROG_BAUDRATE 0x1
#define XPAR_XIOMODULE_0_UART_DATA_BITS 0x8
#define XPAR_XIOMODULE_0_UART_USE_PARITY 0x0
#define XPAR_XIOMODULE_0_UART_ODD_PARITY 0x0
#define XPAR_XIOMODULE_0_UART_RX_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_UART_TX_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_USE_UART_RX 0x1
#define XPAR_XIOMODULE_0_USE_UART_TX 0x1
#define XPAR_XIOMODULE_0_UART_ERROR_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_USE_FIT1 0x0
#define XPAR_XIOMODULE_0_USE_FIT2 0x0
#define XPAR_XIOMODULE_0_USE_FIT3 0x0
#define XPAR_XIOMODULE_0_USE_FIT4 0x0
#define XPAR_XIOMODULE_0_USE_PIT1 0x1
#define XPAR_XIOMODULE_0_USE_PIT2 0x1
#define XPAR_XIOMODULE_0_USE_PIT3 0x1
#define XPAR_XIOMODULE_0_USE_PIT4 0x1
#define XPAR_XIOMODULE_0_USE_GPO1 0x1
#define XPAR_XIOMODULE_0_USE_GPO2 0x0
#define XPAR_XIOMODULE_0_USE_GPO3 0x0
#define XPAR_XIOMODULE_0_USE_GPO4 0x0
#define XPAR_XIOMODULE_0_USE_GPI1 0x0
#define XPAR_XIOMODULE_0_USE_GPI2 0x0
#define XPAR_XIOMODULE_0_USE_GPI3 0x0
#define XPAR_XIOMODULE_0_USE_GPI4 0x0
#define XPAR_XIOMODULE_0_USE_IO_BUS 0x0

#define XPAR_XIPIPSU_NUM_INSTANCES 1

/* Definitions for peripheral IPI_PSM */
#define XPAR_IPI_PSM_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_IPI_PSM_BASEADDR 0xff310000
#define XPAR_IPI_PSM_HIGHADDR 0xff31001f
#define XPAR_IPI_PSM_IPI_BITMASK 0x1
#define XPAR_IPI_PSM_IPI_BUF_INDEX 0x0
#define XPAR_IPI_PSM_INTERRUPTS 0x401d
#define XPAR_IPI_PSM_INTR 0x3d
#define XPAR_IPI_PSM_IPI_TARGET_COUNT 0xa
#define XPAR_IPI_PSM_0_IPI_BITMASK 0x4
#define XPAR_IPI_PSM_0_IPI_BUF_INDEX 0x2
#define XPAR_IPI_PSM_1_IPI_BITMASK 0x8
#define XPAR_IPI_PSM_1_IPI_BUF_INDEX 0x3
#define XPAR_IPI_PSM_2_IPI_BITMASK 0x10
#define XPAR_IPI_PSM_2_IPI_BUF_INDEX 0x4
#define XPAR_IPI_PSM_3_IPI_BITMASK 0x20
#define XPAR_IPI_PSM_3_IPI_BUF_INDEX 0x5
#define XPAR_IPI_PSM_4_IPI_BITMASK 0x40
#define XPAR_IPI_PSM_4_IPI_BUF_INDEX 0x6
#define XPAR_IPI_PSM_5_IPI_BITMASK 0x80
#define XPAR_IPI_PSM_5_IPI_BUF_INDEX 0x7
#define XPAR_IPI_PSM_6_IPI_BITMASK 0x200
#define XPAR_IPI_PSM_6_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PSM_7_IPI_BITMASK 0x2
#define XPAR_IPI_PSM_7_IPI_BUF_INDEX 0x1
#define XPAR_IPI_PSM_8_IPI_BITMASK 0x100
#define XPAR_IPI_PSM_8_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PSM_9_IPI_BITMASK 0x1
#define XPAR_IPI_PSM_9_IPI_BUF_INDEX 0x0

/* Canonical definitions for peripheral IPI_PSM */
#define XPAR_XIPIPSU_0_BASEADDR 0xff310000
#define XPAR_XIPIPSU_0_HIGHADDR 0xff31001f
#define XPAR_XIPIPSU_0_INTR 0x3d
#define XPAR_XIPIPSU_0_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_XIPIPSU_0_IPI_BITMASK 0x1
#define XPAR_XIPIPSU_0_IPI_BUF_INDEX 0x0
#define XPAR_XIPIPSU_0_INTERRUPTS 0x401d
#define XPAR_XIPIPSU_0_IPI_TARGET_COUNT 0xa
#define XPAR_XIPIPSU_0_CH0_IPI_BITMASK 0x4
#define XPAR_XIPIPSU_0_CH0_IPI_BUF_INDEX 0x2
#define XPAR_XIPIPSU_0_CH1_IPI_BITMASK 0x8
#define XPAR_XIPIPSU_0_CH1_IPI_BUF_INDEX 0x3
#define XPAR_XIPIPSU_0_CH2_IPI_BITMASK 0x10
#define XPAR_XIPIPSU_0_CH2_IPI_BUF_INDEX 0x4
#define XPAR_XIPIPSU_0_CH3_IPI_BITMASK 0x20
#define XPAR_XIPIPSU_0_CH3_IPI_BUF_INDEX 0x5
#define XPAR_XIPIPSU_0_CH4_IPI_BITMASK 0x40
#define XPAR_XIPIPSU_0_CH4_IPI_BUF_INDEX 0x6
#define XPAR_XIPIPSU_0_CH5_IPI_BITMASK 0x80
#define XPAR_XIPIPSU_0_CH5_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_0_CH6_IPI_BITMASK 0x200
#define XPAR_XIPIPSU_0_CH6_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH7_IPI_BITMASK 0x2
#define XPAR_XIPIPSU_0_CH7_IPI_BUF_INDEX 0x1
#define XPAR_XIPIPSU_0_CH8_IPI_BITMASK 0x100
#define XPAR_XIPIPSU_0_CH8_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH9_IPI_BITMASK 0x1
#define XPAR_XIPIPSU_0_CH9_IPI_BUF_INDEX 0x0

#define XPAR_XOSPIPSV_NUM_INSTANCES 1

/* Definitions for peripheral OSPI */
#define XPAR_OSPI_COMPATIBLE "xlnx,versal-ospi-1.0"
#define XPAR_OSPI_BASEADDR 0xf1010000
#define XPAR_OSPI_HIGHADDR 0xf101ffff
#define XPAR_OSPI_BASEADDR_1 0xc0000000
#define XPAR_OSPI_OSPI_CLK_FREQ_HZ 0xbebc149
#define XPAR_OSPI_IS_CACHE_COHERENT 0x0
#define XPAR_OSPI_OSPI_MODE 0x0
#define XPAR_OSPI_INTERRUPTS 0x407c

/* Canonical definitions for peripheral OSPI */
#define XPAR_XOSPIPSV_0_BASEADDR 0xf1010000
#define XPAR_XOSPIPSV_0_HIGHADDR 0xf101ffff
#define XPAR_XOSPIPSV_0_COMPATIBLE "xlnx,versal-ospi-1.0"
#define XPAR_XOSPIPSV_0_IS_CACHE_COHERENT 0x0
#define XPAR_XOSPIPSV_0_INTERRUPTS 0x407c
#define XPAR_XOSPIPSV_0_OSPI_CLK_FREQ_HZ 0xbebc149
#define XPAR_XOSPIPSV_0_OSPI_MODE 0x0

#define XPAR_XRTCPSU_NUM_INSTANCES 1

/* Definitions for peripheral RTC */
#define XPAR_RTC_COMPATIBLE "xlnx,zynqmp-rtc"
#define XPAR_RTC_BASEADDR 0xf12a0000
#define XPAR_RTC_HIGHADDR 0xf12a00ff
#define XPAR_RTC_INTERRUPTS 0x408e
#define XPAR_RTC_INTERRUPTS_1 0x408f

/* Canonical definitions for peripheral RTC */
#define XPAR_XRTCPSU_0_BASEADDR 0xf12a0000
#define XPAR_XRTCPSU_0_HIGHADDR 0xf12a00ff
#define XPAR_XRTCPSU_0_COMPATIBLE "xlnx,zynqmp-rtc"
#define XPAR_XRTCPSU_0_INTERRUPTS 0x408e

#define XPAR_XSDPS_NUM_INSTANCES 1

/* Definitions for peripheral SDHCI0 */
#define XPAR_SDHCI0_COMPATIBLE "xlnx,versal-8.9a"
#define XPAR_SDHCI0_BASEADDR 0xf1040000
#define XPAR_SDHCI0_HIGHADDR 0xf104ffff
#define XPAR_SDHCI0_SDIO_CLK_FREQ_HZ 0xbebc149
#define XPAR_SDHCI0_HAS_CD 0x0
#define XPAR_SDHCI0_HAS_WP 0x0
#define XPAR_SDHCI0_BUS_WIDTH 0x8
#define XPAR_SDHCI0_MIO_BANK 0x0
#define XPAR_SDHCI0_HAS_EMIO 0x0
#define XPAR_SDHCI0_SLOT_TYPE 0x1
#define XPAR_SDHCI0_IS_CACHE_COHERENT 0x0
#define XPAR_SDHCI0_CLOCKS 0x3b
#define XPAR_SDHCI0_CLK_50_SDR_ITAP_DLY 0x2c
#define XPAR_SDHCI0_CLK_50_SDR_OTAP_DLY 0x5
#define XPAR_SDHCI0_CLK_50_DDR_ITAP_DLY 0x1e
#define XPAR_SDHCI0_CLK_50_DDR_OTAP_DLY 0x5
#define XPAR_SDHCI0_CLK_100_SDR_OTAP_DLY 0x0
#define XPAR_SDHCI0_CLK_200_SDR_OTAP_DLY 0x2

/* Canonical definitions for peripheral SDHCI0 */
#define XPAR_XSDPS_0_BASEADDR 0xf1040000
#define XPAR_XSDPS_0_HIGHADDR 0xf104ffff
#define XPAR_XSDPS_0_BUS_WIDTH 0x8
#define XPAR_XSDPS_0_COMPATIBLE "xlnx,versal-8.9a"
#define XPAR_XSDPS_0_CLOCKS 0x3b
#define XPAR_XSDPS_0_CLK_50_SDR_ITAP_DLY 0x2c
#define XPAR_XSDPS_0_CLK_50_SDR_OTAP_DLY 0x5
#define XPAR_XSDPS_0_CLK_50_DDR_ITAP_DLY 0x1e
#define XPAR_XSDPS_0_CLK_50_DDR_OTAP_DLY 0x5
#define XPAR_XSDPS_0_CLK_100_SDR_OTAP_DLY 0x0
#define XPAR_XSDPS_0_CLK_200_SDR_OTAP_DLY 0x2
#define XPAR_XSDPS_0_HAS_CD 0x0
#define XPAR_XSDPS_0_HAS_WP 0x0
#define XPAR_XSDPS_0_HAS_EMIO 0x0
#define XPAR_XSDPS_0_IS_CACHE_COHERENT 0x0
#define XPAR_XSDPS_0_MIO_BANK 0x0
#define XPAR_XSDPS_0_SDIO_CLK_FREQ_HZ 0xbebc149
#define XPAR_XSDPS_0_SLOT_TYPE 0x1

#define XPAR_XSPIPS_NUM_INSTANCES 1

/* Definitions for peripheral SPI0 */
#define XPAR_SPI0_COMPATIBLE "cdns,spi-r1p6"
#define XPAR_SPI0_BASEADDR 0xff040000
#define XPAR_SPI0_HIGHADDR 0xff040fff
#define XPAR_SPI0_SPI_CLK_FREQ_HZ 0xbebc149
#define XPAR_SPI0_INTERRUPTS 0x4010

/* Canonical definitions for peripheral SPI0 */
#define XPAR_XSPIPS_0_BASEADDR 0xff040000
#define XPAR_XSPIPS_0_HIGHADDR 0xff040fff
#define XPAR_XSPIPS_0_COMPATIBLE "cdns,spi-r1p6"
#define XPAR_XSPIPS_0_INTERRUPTS 0x4010
#define XPAR_XSPIPS_0_SPI_CLK_FREQ_HZ 0xbebc149

#define XPAR_XSYSMONPSV_NUM_INSTANCES 1

/* Definitions for peripheral SYSMON0 */
#define XPAR_SYSMON0_COMPATIBLE "xlnx,versal-sysmon"
#define XPAR_SYSMON0_BASEADDR 0xf1270000
#define XPAR_SYSMON0_HIGHADDR 0xf1273fff

/* Canonical definitions for peripheral SYSMON0 */
#define XPAR_XSYSMONPSV_0_BASEADDR 0xf1270000
#define XPAR_XSYSMONPSV_0_HIGHADDR 0xf1273fff
#define XPAR_XSYSMONPSV_0_COMPATIBLE "xlnx,versal-sysmon"

#define XPAR_TMR_INJECT_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0_COMPATIBLE "xlnx,tmr-inject-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0_BASEADDR 0xffcd0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0_HIGHADDR 0xffcdffff
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0_MAGIC 0x27
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0_CPU_ID 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0_MASK 0x50000

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_INJECT_0 */
#define XPAR_TMR_INJECT_0_BASEADDR 0xffcd0000
#define XPAR_TMR_INJECT_0_HIGHADDR 0xffcdffff
#define XPAR_TMR_INJECT_0_COMPATIBLE "xlnx,tmr-inject-1.0"
#define XPAR_TMR_INJECT_0_CPU_ID 0x1
#define XPAR_TMR_INJECT_0_MAGIC 0x27
#define XPAR_TMR_INJECT_0_MASK 0x50000

#define XPAR_TMR_MANAGER_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_COMPATIBLE "xlnx,tmr-manager-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_BASEADDR 0xffcc0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_HIGHADDR 0xffccffff
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_BRK_DELAY_RST_VALUE 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_MASK_RST_VALUE 0xffffffffffffffff
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_MAGIC1 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_MAGIC2 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_UE_IS_FATAL 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_UE_WIDTH 0x3
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_NO_OF_COMPARATORS 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_COMPARATORS_MASK 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_WATCHDOG 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_WATCHDOG_WIDTH 0x1e
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_SEM_INTERFACE 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG_WIDTH 0xa
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_BRK_DELAY_WIDTH 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_TMR 0x1
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_TEST_COMPARATOR 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_STRICT_MISCOMPARE 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_USE_DEBUG_DISABLE 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_USE_TMR_DISABLE 0x0
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0_MASK 0x50000

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_TMR_MANAGER_0 */
#define XPAR_TMR_MANAGER_0_BASEADDR 0xffcc0000
#define XPAR_TMR_MANAGER_0_HIGHADDR 0xffccffff
#define XPAR_TMR_MANAGER_0_BRK_DELAY_RST_VALUE 0x0
#define XPAR_TMR_MANAGER_0_BRK_DELAY_WIDTH 0x0
#define XPAR_TMR_MANAGER_0_COMPATIBLE "xlnx,tmr-manager-1.0"
#define XPAR_TMR_MANAGER_0_COMPARATORS_MASK 0x0
#define XPAR_TMR_MANAGER_0_MASK_RST_VALUE 0xffffffffffffffff
#define XPAR_TMR_MANAGER_0_MAGIC1 0x0
#define XPAR_TMR_MANAGER_0_MAGIC2 0x0
#define XPAR_TMR_MANAGER_0_MASK 0x50000
#define XPAR_TMR_MANAGER_0_NO_OF_COMPARATORS 0x1
#define XPAR_TMR_MANAGER_0_SEM_INTERFACE 0x0
#define XPAR_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG 0x0
#define XPAR_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG_WIDTH 0xa
#define XPAR_TMR_MANAGER_0_STRICT_MISCOMPARE 0x0
#define XPAR_TMR_MANAGER_0_TMR 0x1
#define XPAR_TMR_MANAGER_0_TEST_COMPARATOR 0x0
#define XPAR_TMR_MANAGER_0_UE_IS_FATAL 0x0
#define XPAR_TMR_MANAGER_0_UE_WIDTH 0x3
#define XPAR_TMR_MANAGER_0_USE_DEBUG_DISABLE 0x0
#define XPAR_TMR_MANAGER_0_USE_TMR_DISABLE 0x0
#define XPAR_TMR_MANAGER_0_WATCHDOG 0x0
#define XPAR_TMR_MANAGER_0_WATCHDOG_WIDTH 0x1e

#define XPAR_XTRNGPSV_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_COMPATIBLE "xlnx,psv-pmc-trng-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_BASEADDR 0xf1230000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG_HIGHADDR 0xf123ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_TRNG */
#define XPAR_XTRNGPSV_0_BASEADDR 0xf1230000
#define XPAR_XTRNGPSV_0_HIGHADDR 0xf123ffff
#define XPAR_XTRNGPSV_0_COMPATIBLE "xlnx,psv-pmc-trng-1.0"

#define XPAR_XTTCPS_NUM_INSTANCES 4

/* Definitions for peripheral TTC0 */
#define XPAR_TTC0_COMPATIBLE "cdns,ttc"
#define XPAR_TTC0_BASEADDR 0xff0e0000
#define XPAR_TTC0_HIGHADDR 0xff0e0fff
#define XPAR_TTC0_CLOCK_FREQ 0x8f0d0f7
#define XPAR_TTC0_INTERRUPTS 0x4025
#define XPAR_TTC0_INTERRUPTS_1 0x4026
#define XPAR_TTC0_INTERRUPTS_2 0x4027
#define XPAR_TTC0_TTC_CLK0_CLKSRC 0x0

/* Canonical definitions for peripheral TTC0 */
#define XPAR_XTTCPS_0_BASEADDR 0xff0e0000
#define XPAR_XTTCPS_0_HIGHADDR 0xff0e0fff
#define XPAR_XTTCPS_0_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_0_CLOCK_FREQ 0x8f0d0f7
#define XPAR_XTTCPS_0_INTERRUPTS 0x4025
#define XPAR_XTTCPS_0_TTC_CLK0_CLKSRC 0x0

/* Definitions for peripheral TTC1 */
#define XPAR_TTC1_COMPATIBLE "cdns,ttc"
#define XPAR_TTC1_BASEADDR 0xff0f0000
#define XPAR_TTC1_HIGHADDR 0xff0f0fff
#define XPAR_TTC1_CLOCK_FREQ 0x8f0d0f7
#define XPAR_TTC1_INTERRUPTS 0x4028
#define XPAR_TTC1_INTERRUPTS_1 0x4029
#define XPAR_TTC1_INTERRUPTS_2 0x402a
#define XPAR_TTC1_TTC_CLK0_CLKSRC 0x0

/* Canonical definitions for peripheral TTC1 */
#define XPAR_XTTCPS_1_BASEADDR 0xff0f0000
#define XPAR_XTTCPS_1_HIGHADDR 0xff0f0fff
#define XPAR_XTTCPS_1_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_1_CLOCK_FREQ 0x8f0d0f7
#define XPAR_XTTCPS_1_INTERRUPTS 0x4028
#define XPAR_XTTCPS_1_TTC_CLK0_CLKSRC 0x0

/* Definitions for peripheral TTC2 */
#define XPAR_TTC2_COMPATIBLE "cdns,ttc"
#define XPAR_TTC2_BASEADDR 0xff100000
#define XPAR_TTC2_HIGHADDR 0xff100fff
#define XPAR_TTC2_CLOCK_FREQ 0x8f0d0f7
#define XPAR_TTC2_INTERRUPTS 0x402b
#define XPAR_TTC2_INTERRUPTS_1 0x402c
#define XPAR_TTC2_INTERRUPTS_2 0x402d
#define XPAR_TTC2_TTC_CLK0_CLKSRC 0x0

/* Canonical definitions for peripheral TTC2 */
#define XPAR_XTTCPS_2_BASEADDR 0xff100000
#define XPAR_XTTCPS_2_HIGHADDR 0xff100fff
#define XPAR_XTTCPS_2_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_2_CLOCK_FREQ 0x8f0d0f7
#define XPAR_XTTCPS_2_INTERRUPTS 0x402b
#define XPAR_XTTCPS_2_TTC_CLK0_CLKSRC 0x0

/* Definitions for peripheral TTC3 */
#define XPAR_TTC3_COMPATIBLE "cdns,ttc"
#define XPAR_TTC3_BASEADDR 0xff110000
#define XPAR_TTC3_HIGHADDR 0xff110fff
#define XPAR_TTC3_CLOCK_FREQ 0x8f0d0f7
#define XPAR_TTC3_INTERRUPTS 0x402e
#define XPAR_TTC3_INTERRUPTS_1 0x402f
#define XPAR_TTC3_INTERRUPTS_2 0x4030
#define XPAR_TTC3_TTC_CLK0_CLKSRC 0x0

/* Canonical definitions for peripheral TTC3 */
#define XPAR_XTTCPS_3_BASEADDR 0xff110000
#define XPAR_XTTCPS_3_HIGHADDR 0xff110fff
#define XPAR_XTTCPS_3_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_3_CLOCK_FREQ 0x8f0d0f7
#define XPAR_XTTCPS_3_INTERRUPTS 0x402e
#define XPAR_XTTCPS_3_TTC_CLK0_CLKSRC 0x0

#define XPAR_XUARTLITE_NUM_INSTANCES 1

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_COMPATIBLE "xlnx,psv-pmc-ppu1-mdm-1.0"
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_BASEADDR 0xf0310000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0_HIGHADDR 0xf0317fff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_PPU1_MDM_0 */
#define XPAR_XUARTLITE_0_BASEADDR 0xf0310000
#define XPAR_XUARTLITE_0_HIGHADDR 0xf0317fff
#define XPAR_XUARTLITE_0_COMPATIBLE "xlnx,psv-pmc-ppu1-mdm-1.0"

#define XPAR_XUARTPSV_NUM_INSTANCES 2

/* Definitions for peripheral SERIAL0 */
#define XPAR_SERIAL0_COMPATIBLE "arm,pl011"
#define XPAR_SERIAL0_BASEADDR 0xff000000
#define XPAR_SERIAL0_HIGHADDR 0xff000fff
#define XPAR_SERIAL0_CLOCK_FREQ 0x5f5e0a4
#define XPAR_SERIAL0_BAUDRATE 0x1c200
#define XPAR_SERIAL0_INTERRUPTS 0x4012

/* Canonical definitions for peripheral SERIAL0 */
#define XPAR_XUARTPSV_0_BASEADDR 0xff000000
#define XPAR_XUARTPSV_0_HIGHADDR 0xff000fff
#define XPAR_XUARTPSV_0_BAUDRATE 0x1c200
#define XPAR_XUARTPSV_0_COMPATIBLE "arm,pl011"
#define XPAR_XUARTPSV_0_CLOCK_FREQ 0x5f5e0a4
#define XPAR_XUARTPSV_0_INTERRUPTS 0x4012

/* Definitions for peripheral SERIAL1 */
#define XPAR_SERIAL1_COMPATIBLE "arm,pl011"
#define XPAR_SERIAL1_BASEADDR 0xff010000
#define XPAR_SERIAL1_HIGHADDR 0xff010fff
#define XPAR_SERIAL1_CLOCK_FREQ 0x5f5e0a4
#define XPAR_SERIAL1_BAUDRATE 0x1c200
#define XPAR_SERIAL1_INTERRUPTS 0x4013

/* Canonical definitions for peripheral SERIAL1 */
#define XPAR_XUARTPSV_1_BASEADDR 0xff010000
#define XPAR_XUARTPSV_1_HIGHADDR 0xff010fff
#define XPAR_XUARTPSV_1_BAUDRATE 0x1c200
#define XPAR_XUARTPSV_1_COMPATIBLE "arm,pl011"
#define XPAR_XUARTPSV_1_CLOCK_FREQ 0x5f5e0a4
#define XPAR_XUARTPSV_1_INTERRUPTS 0x4013

#define XPAR_XZDMA_NUM_INSTANCES 8

/* Definitions for peripheral LPD_DMA_CHAN0 */
#define XPAR_LPD_DMA_CHAN0_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN0_BASEADDR 0xffa80000
#define XPAR_LPD_DMA_CHAN0_HIGHADDR 0xffa80fff
#define XPAR_LPD_DMA_CHAN0_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN0_INTERRUPTS 0x403c

/* Canonical definitions for peripheral LPD_DMA_CHAN0 */
#define XPAR_XZDMA_0_BASEADDR 0xffa80000
#define XPAR_XZDMA_0_HIGHADDR 0xffa80fff
#define XPAR_XZDMA_0_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_0_DMA_MODE 0x1
#define XPAR_XZDMA_0_INTERRUPTS 0x403c

/* Definitions for peripheral LPD_DMA_CHAN1 */
#define XPAR_LPD_DMA_CHAN1_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN1_BASEADDR 0xffa90000
#define XPAR_LPD_DMA_CHAN1_HIGHADDR 0xffa90fff
#define XPAR_LPD_DMA_CHAN1_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN1_INTERRUPTS 0x403d

/* Canonical definitions for peripheral LPD_DMA_CHAN1 */
#define XPAR_XZDMA_1_BASEADDR 0xffa90000
#define XPAR_XZDMA_1_HIGHADDR 0xffa90fff
#define XPAR_XZDMA_1_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_1_DMA_MODE 0x1
#define XPAR_XZDMA_1_INTERRUPTS 0x403d

/* Definitions for peripheral LPD_DMA_CHAN2 */
#define XPAR_LPD_DMA_CHAN2_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN2_BASEADDR 0xffaa0000
#define XPAR_LPD_DMA_CHAN2_HIGHADDR 0xffaa0fff
#define XPAR_LPD_DMA_CHAN2_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN2_INTERRUPTS 0x403e

/* Canonical definitions for peripheral LPD_DMA_CHAN2 */
#define XPAR_XZDMA_2_BASEADDR 0xffaa0000
#define XPAR_XZDMA_2_HIGHADDR 0xffaa0fff
#define XPAR_XZDMA_2_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_2_DMA_MODE 0x1
#define XPAR_XZDMA_2_INTERRUPTS 0x403e

/* Definitions for peripheral LPD_DMA_CHAN3 */
#define XPAR_LPD_DMA_CHAN3_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN3_BASEADDR 0xffab0000
#define XPAR_LPD_DMA_CHAN3_HIGHADDR 0xffab0fff
#define XPAR_LPD_DMA_CHAN3_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN3_INTERRUPTS 0x403f

/* Canonical definitions for peripheral LPD_DMA_CHAN3 */
#define XPAR_XZDMA_3_BASEADDR 0xffab0000
#define XPAR_XZDMA_3_HIGHADDR 0xffab0fff
#define XPAR_XZDMA_3_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_3_DMA_MODE 0x1
#define XPAR_XZDMA_3_INTERRUPTS 0x403f

/* Definitions for peripheral LPD_DMA_CHAN4 */
#define XPAR_LPD_DMA_CHAN4_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN4_BASEADDR 0xffac0000
#define XPAR_LPD_DMA_CHAN4_HIGHADDR 0xffac0fff
#define XPAR_LPD_DMA_CHAN4_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN4_INTERRUPTS 0x4040

/* Canonical definitions for peripheral LPD_DMA_CHAN4 */
#define XPAR_XZDMA_4_BASEADDR 0xffac0000
#define XPAR_XZDMA_4_HIGHADDR 0xffac0fff
#define XPAR_XZDMA_4_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_4_DMA_MODE 0x1
#define XPAR_XZDMA_4_INTERRUPTS 0x4040

/* Definitions for peripheral LPD_DMA_CHAN5 */
#define XPAR_LPD_DMA_CHAN5_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN5_BASEADDR 0xffad0000
#define XPAR_LPD_DMA_CHAN5_HIGHADDR 0xffad0fff
#define XPAR_LPD_DMA_CHAN5_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN5_INTERRUPTS 0x4041

/* Canonical definitions for peripheral LPD_DMA_CHAN5 */
#define XPAR_XZDMA_5_BASEADDR 0xffad0000
#define XPAR_XZDMA_5_HIGHADDR 0xffad0fff
#define XPAR_XZDMA_5_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_5_DMA_MODE 0x1
#define XPAR_XZDMA_5_INTERRUPTS 0x4041

/* Definitions for peripheral LPD_DMA_CHAN6 */
#define XPAR_LPD_DMA_CHAN6_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN6_BASEADDR 0xffae0000
#define XPAR_LPD_DMA_CHAN6_HIGHADDR 0xffae0fff
#define XPAR_LPD_DMA_CHAN6_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN6_INTERRUPTS 0x4042

/* Canonical definitions for peripheral LPD_DMA_CHAN6 */
#define XPAR_XZDMA_6_BASEADDR 0xffae0000
#define XPAR_XZDMA_6_HIGHADDR 0xffae0fff
#define XPAR_XZDMA_6_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_6_DMA_MODE 0x1
#define XPAR_XZDMA_6_INTERRUPTS 0x4042

/* Definitions for peripheral LPD_DMA_CHAN7 */
#define XPAR_LPD_DMA_CHAN7_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN7_BASEADDR 0xffaf0000
#define XPAR_LPD_DMA_CHAN7_HIGHADDR 0xffaf0fff
#define XPAR_LPD_DMA_CHAN7_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN7_INTERRUPTS 0x4043

/* Canonical definitions for peripheral LPD_DMA_CHAN7 */
#define XPAR_XZDMA_7_BASEADDR 0xffaf0000
#define XPAR_XZDMA_7_HIGHADDR 0xffaf0fff
#define XPAR_XZDMA_7_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_7_DMA_MODE 0x1
#define XPAR_XZDMA_7_INTERRUPTS 0x4043

/* Definitions for peripheral CCI */
#define XPAR_CCI_BASEADDR 0xfd000000
#define XPAR_CCI_HIGHADDR 0xfd00ffff

/* Canonical definitions for peripheral CCI */
#define XPAR_PSV_FPD_MAINCCI_0_BASEADDR 0xfd000000
#define XPAR_PSV_FPD_MAINCCI_0_HIGHADDR 0xfd00ffff

/* Definitions for peripheral SMMU */
#define XPAR_SMMU_BASEADDR 0xfd800000
#define XPAR_SMMU_HIGHADDR 0xfd83ffff

/* Canonical definitions for peripheral SMMU */
#define XPAR_PSV_FPD_SMMUTCU_0_BASEADDR 0xfd800000
#define XPAR_PSV_FPD_SMMUTCU_0_HIGHADDR 0xfd83ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_CTI_BASEADDR 0xf0d10000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_CTI_HIGHADDR 0xf0d1ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_CTI */
#define XPAR_PSV_CORESIGHT_A720_CTI_0_BASEADDR 0xf0d10000
#define XPAR_PSV_CORESIGHT_A720_CTI_0_HIGHADDR 0xf0d1ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_DBG */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_DBG_BASEADDR 0xf0d00000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_DBG_HIGHADDR 0xf0d0ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_DBG */
#define XPAR_PSV_CORESIGHT_A720_DBG_0_BASEADDR 0xf0d00000
#define XPAR_PSV_CORESIGHT_A720_DBG_0_HIGHADDR 0xf0d0ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_ETM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_ETM_BASEADDR 0xf0d30000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_ETM_HIGHADDR 0xf0d3ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_ETM */
#define XPAR_PSV_CORESIGHT_A720_ETM_0_BASEADDR 0xf0d30000
#define XPAR_PSV_CORESIGHT_A720_ETM_0_HIGHADDR 0xf0d3ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_PMU */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_PMU_BASEADDR 0xf0d20000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_PMU_HIGHADDR 0xf0d2ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A720_PMU */
#define XPAR_PSV_CORESIGHT_A720_PMU_0_BASEADDR 0xf0d20000
#define XPAR_PSV_CORESIGHT_A720_PMU_0_HIGHADDR 0xf0d2ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_CTI_BASEADDR 0xf0d50000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_CTI_HIGHADDR 0xf0d5ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_CTI */
#define XPAR_PSV_CORESIGHT_A721_CTI_0_BASEADDR 0xf0d50000
#define XPAR_PSV_CORESIGHT_A721_CTI_0_HIGHADDR 0xf0d5ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_DBG */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_DBG_BASEADDR 0xf0d40000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_DBG_HIGHADDR 0xf0d4ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_DBG */
#define XPAR_PSV_CORESIGHT_A721_DBG_0_BASEADDR 0xf0d40000
#define XPAR_PSV_CORESIGHT_A721_DBG_0_HIGHADDR 0xf0d4ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_ETM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_ETM_BASEADDR 0xf0d70000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_ETM_HIGHADDR 0xf0d7ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_ETM */
#define XPAR_PSV_CORESIGHT_A721_ETM_0_BASEADDR 0xf0d70000
#define XPAR_PSV_CORESIGHT_A721_ETM_0_HIGHADDR 0xf0d7ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_PMU */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_PMU_BASEADDR 0xf0d60000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_PMU_HIGHADDR 0xf0d6ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_A721_PMU */
#define XPAR_PSV_CORESIGHT_A721_PMU_0_BASEADDR 0xf0d60000
#define XPAR_PSV_CORESIGHT_A721_PMU_0_HIGHADDR 0xf0d6ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_CTI_BASEADDR 0xf0ca0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_CTI_HIGHADDR 0xf0caffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_CTI */
#define XPAR_PSV_CORESIGHT_APU_CTI_0_BASEADDR 0xf0ca0000
#define XPAR_PSV_CORESIGHT_APU_CTI_0_HIGHADDR 0xf0caffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ELA */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ELA_BASEADDR 0xf0c60000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ELA_HIGHADDR 0xf0c6ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ELA */
#define XPAR_PSV_CORESIGHT_APU_ELA_0_BASEADDR 0xf0c60000
#define XPAR_PSV_CORESIGHT_APU_ELA_0_HIGHADDR 0xf0c6ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ETF */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ETF_BASEADDR 0xf0c30000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ETF_HIGHADDR 0xf0c3ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_ETF */
#define XPAR_PSV_CORESIGHT_APU_ETF_0_BASEADDR 0xf0c30000
#define XPAR_PSV_CORESIGHT_APU_ETF_0_HIGHADDR 0xf0c3ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_FUN */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_FUN_BASEADDR 0xf0c20000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_FUN_HIGHADDR 0xf0c2ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_APU_FUN */
#define XPAR_PSV_CORESIGHT_APU_FUN_0_BASEADDR 0xf0c20000
#define XPAR_PSV_CORESIGHT_APU_FUN_0_HIGHADDR 0xf0c2ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ATM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ATM_BASEADDR 0xf0f80000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ATM_HIGHADDR 0xf0f8ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ATM */
#define XPAR_PSV_CORESIGHT_CPM_ATM_0_BASEADDR 0xf0f80000
#define XPAR_PSV_CORESIGHT_CPM_ATM_0_HIGHADDR 0xf0f8ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2A */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2A_BASEADDR 0xf0fa0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2A_HIGHADDR 0xf0faffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2A */
#define XPAR_PSV_CORESIGHT_CPM_CTI2A_0_BASEADDR 0xf0fa0000
#define XPAR_PSV_CORESIGHT_CPM_CTI2A_0_HIGHADDR 0xf0faffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2D */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2D_BASEADDR 0xf0fd0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2D_HIGHADDR 0xf0fdffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_CTI2D */
#define XPAR_PSV_CORESIGHT_CPM_CTI2D_0_BASEADDR 0xf0fd0000
#define XPAR_PSV_CORESIGHT_CPM_CTI2D_0_HIGHADDR 0xf0fdffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2A */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2A_BASEADDR 0xf0f40000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2A_HIGHADDR 0xf0f4ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2A */
#define XPAR_PSV_CORESIGHT_CPM_ELA2A_0_BASEADDR 0xf0f40000
#define XPAR_PSV_CORESIGHT_CPM_ELA2A_0_HIGHADDR 0xf0f4ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2B */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2B_BASEADDR 0xf0f50000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2B_HIGHADDR 0xf0f5ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2B */
#define XPAR_PSV_CORESIGHT_CPM_ELA2B_0_BASEADDR 0xf0f50000
#define XPAR_PSV_CORESIGHT_CPM_ELA2B_0_HIGHADDR 0xf0f5ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2C */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2C_BASEADDR 0xf0f60000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2C_HIGHADDR 0xf0f6ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2C */
#define XPAR_PSV_CORESIGHT_CPM_ELA2C_0_BASEADDR 0xf0f60000
#define XPAR_PSV_CORESIGHT_CPM_ELA2C_0_HIGHADDR 0xf0f6ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2D */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2D_BASEADDR 0xf0f70000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2D_HIGHADDR 0xf0f7ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ELA2D */
#define XPAR_PSV_CORESIGHT_CPM_ELA2D_0_BASEADDR 0xf0f70000
#define XPAR_PSV_CORESIGHT_CPM_ELA2D_0_HIGHADDR 0xf0f7ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_FUN */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_FUN_BASEADDR 0xf0f20000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_FUN_HIGHADDR 0xf0f2ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_FUN */
#define XPAR_PSV_CORESIGHT_CPM_FUN_0_BASEADDR 0xf0f20000
#define XPAR_PSV_CORESIGHT_CPM_FUN_0_HIGHADDR 0xf0f2ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ROM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ROM_BASEADDR 0xf0f00000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ROM_HIGHADDR 0xf0f0ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_CPM_ROM */
#define XPAR_PSV_CORESIGHT_CPM_ROM_0_BASEADDR 0xf0f00000
#define XPAR_PSV_CORESIGHT_CPM_ROM_0_HIGHADDR 0xf0f0ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_ATM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_ATM_BASEADDR 0xf0b80000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_ATM_HIGHADDR 0xf0b8ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_ATM */
#define XPAR_PSV_CORESIGHT_FPD_ATM_0_BASEADDR 0xf0b80000
#define XPAR_PSV_CORESIGHT_FPD_ATM_0_HIGHADDR 0xf0b8ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1B */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1B_BASEADDR 0xf0bb0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1B_HIGHADDR 0xf0bbffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1B */
#define XPAR_PSV_CORESIGHT_FPD_CTI1B_0_BASEADDR 0xf0bb0000
#define XPAR_PSV_CORESIGHT_FPD_CTI1B_0_HIGHADDR 0xf0bbffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1C */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1C_BASEADDR 0xf0bc0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1C_HIGHADDR 0xf0bcffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1C */
#define XPAR_PSV_CORESIGHT_FPD_CTI1C_0_BASEADDR 0xf0bc0000
#define XPAR_PSV_CORESIGHT_FPD_CTI1C_0_HIGHADDR 0xf0bcffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1D */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1D_BASEADDR 0xf0bd0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1D_HIGHADDR 0xf0bdffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_CTI1D */
#define XPAR_PSV_CORESIGHT_FPD_CTI1D_0_BASEADDR 0xf0bd0000
#define XPAR_PSV_CORESIGHT_FPD_CTI1D_0_HIGHADDR 0xf0bdffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM_BASEADDR 0xf0b70000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM_HIGHADDR 0xf0b7ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_FPD_STM */
#define XPAR_PSV_CORESIGHT_FPD_STM_0_BASEADDR 0xf0b70000
#define XPAR_PSV_CORESIGHT_FPD_STM_0_HIGHADDR 0xf0b7ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_ATM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_ATM_BASEADDR 0xf0980000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_ATM_HIGHADDR 0xf098ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_ATM */
#define XPAR_PSV_CORESIGHT_LPD_ATM_0_BASEADDR 0xf0980000
#define XPAR_PSV_CORESIGHT_LPD_ATM_0_HIGHADDR 0xf098ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_CTI_BASEADDR 0xf09d0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_CTI_HIGHADDR 0xf09dffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_LPD_CTI */
#define XPAR_PSV_CORESIGHT_LPD_CTI_0_BASEADDR 0xf09d0000
#define XPAR_PSV_CORESIGHT_LPD_CTI_0_HIGHADDR 0xf09dffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_PMC_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_PMC_CTI_BASEADDR 0xf08d0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_PMC_CTI_HIGHADDR 0xf08dffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_PMC_CTI */
#define XPAR_PSV_CORESIGHT_PMC_CTI_0_BASEADDR 0xf08d0000
#define XPAR_PSV_CORESIGHT_PMC_CTI_0_HIGHADDR 0xf08dffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R50_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R50_CTI_BASEADDR 0xf0a10000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R50_CTI_HIGHADDR 0xf0a1ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R50_CTI */
#define XPAR_PSV_CORESIGHT_R50_CTI_0_BASEADDR 0xf0a10000
#define XPAR_PSV_CORESIGHT_R50_CTI_0_HIGHADDR 0xf0a1ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R51_CTI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R51_CTI_BASEADDR 0xf0a50000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R51_CTI_HIGHADDR 0xf0a5ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CORESIGHT_R51_CTI */
#define XPAR_PSV_CORESIGHT_R51_CTI_0_BASEADDR 0xf0a50000
#define XPAR_PSV_CORESIGHT_R51_CTI_0_HIGHADDR 0xf0a5ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0_BASEADDR 0xfd1a0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0_HIGHADDR 0xfd2dffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRF_0 */
#define XPAR_PSV_CRF_0_BASEADDR 0xfd1a0000
#define XPAR_PSV_CRF_0_HIGHADDR 0xfd2dffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0_BASEADDR 0xff5e0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0_HIGHADDR 0xff8dffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRL_0 */
#define XPAR_PSV_CRL_0_BASEADDR 0xff5e0000
#define XPAR_PSV_CRL_0_HIGHADDR 0xff8dffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0_BASEADDR 0xf1260000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0_HIGHADDR 0xf126ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_CRP_0 */
#define XPAR_PSV_CRP_0_BASEADDR 0xf1260000
#define XPAR_PSV_CRP_0_HIGHADDR 0xf126ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0_BASEADDR 0xfd360000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0_HIGHADDR 0xfd36ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_0 */
#define XPAR_PSV_FPD_AFI_0_BASEADDR 0xfd360000
#define XPAR_PSV_FPD_AFI_0_HIGHADDR 0xfd36ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2_BASEADDR 0xfd380000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2_HIGHADDR 0xfd38ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_AFI_2 */
#define XPAR_PSV_FPD_AFI_1_BASEADDR 0xfd380000
#define XPAR_PSV_FPD_AFI_1_HIGHADDR 0xfd38ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0_BASEADDR 0xfd5e0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0_HIGHADDR 0xfd5effff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_CCI_0 */
#define XPAR_PSV_FPD_CCI_0_BASEADDR 0xfd5e0000
#define XPAR_PSV_FPD_CCI_0_HIGHADDR 0xfd5effff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0_BASEADDR 0xfd700000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0_HIGHADDR 0xfd7fffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_GPV_0 */
#define XPAR_PSV_FPD_GPV_0_BASEADDR 0xfd700000
#define XPAR_PSV_FPD_GPV_0_HIGHADDR 0xfd7fffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0_BASEADDR 0xfd610000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0_HIGHADDR 0xfd61ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_0 */
#define XPAR_PSV_FPD_SLCR_0_BASEADDR 0xfd610000
#define XPAR_PSV_FPD_SLCR_0_HIGHADDR 0xfd61ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0_BASEADDR 0xfd690000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0_HIGHADDR 0xfd69ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SLCR_SECURE_0 */
#define XPAR_PSV_FPD_SLCR_SECURE_0_BASEADDR 0xfd690000
#define XPAR_PSV_FPD_SLCR_SECURE_0_HIGHADDR 0xfd69ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0_BASEADDR 0xfd5f0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0_HIGHADDR 0xfd5fffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_FPD_SMMU_0 */
#define XPAR_PSV_FPD_SMMU_0_BASEADDR 0xfd5f0000
#define XPAR_PSV_FPD_SMMU_0_HIGHADDR 0xfd5fffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0_BASEADDR 0xff9b0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0_HIGHADDR 0xff9bffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_AFI_0 */
#define XPAR_PSV_LPD_AFI_0_BASEADDR 0xff9b0000
#define XPAR_PSV_LPD_AFI_0_HIGHADDR 0xff9bffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0_BASEADDR 0xff0a0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0_HIGHADDR 0xff0affff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_PSV_LPD_IOU_SECURE_SLCR_0_BASEADDR 0xff0a0000
#define XPAR_PSV_LPD_IOU_SECURE_SLCR_0_HIGHADDR 0xff0affff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0_BASEADDR 0xff080000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0_HIGHADDR 0xff09ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_IOU_SLCR_0 */
#define XPAR_PSV_LPD_IOU_SLCR_0_BASEADDR 0xff080000
#define XPAR_PSV_LPD_IOU_SLCR_0_HIGHADDR 0xff09ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0_BASEADDR 0xff410000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0_HIGHADDR 0xff50ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_0 */
#define XPAR_PSV_LPD_SLCR_0_BASEADDR 0xff410000
#define XPAR_PSV_LPD_SLCR_0_HIGHADDR 0xff50ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0_BASEADDR 0xff510000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0_HIGHADDR 0xff54ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_LPD_SLCR_SECURE_0 */
#define XPAR_PSV_LPD_SLCR_SECURE_0_BASEADDR 0xff510000
#define XPAR_PSV_LPD_SLCR_SECURE_0_HIGHADDR 0xff54ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL_BASEADDR 0xff960000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL_HIGHADDR 0xff96ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_OCM_CTRL */
#define XPAR_PSV_OCM_0_BASEADDR 0xff960000
#define XPAR_PSV_OCM_0_HIGHADDR 0xff96ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES_BASEADDR 0xf11e0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES_HIGHADDR 0xf11effff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_AES */
#define XPAR_PSV_PMC_AES_0_BASEADDR 0xf11e0000
#define XPAR_PSV_PMC_AES_0_HIGHADDR 0xf11effff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL_BASEADDR 0xf11f0000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL_HIGHADDR 0xf11fffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_BBRAM_CTRL */
#define XPAR_PSV_PMC_BBRAM_CTRL_0_BASEADDR 0xf11f0000
#define XPAR_PSV_PMC_BBRAM_CTRL_0_HIGHADDR 0xf11fffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE_BASEADDR 0xf1250000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE_HIGHADDR 0xf125ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CACHE */
#define XPAR_PSV_PMC_EFUSE_CACHE_0_BASEADDR 0xf1250000
#define XPAR_PSV_PMC_EFUSE_CACHE_0_HIGHADDR 0xf125ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL_BASEADDR 0xf1240000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL_HIGHADDR 0xf124ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_EFUSE_CTRL */
#define XPAR_PSV_PMC_EFUSE_CTRL_0_BASEADDR 0xf1240000
#define XPAR_PSV_PMC_EFUSE_CTRL_0_HIGHADDR 0xf124ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0_BASEADDR 0xf1110000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0_HIGHADDR 0xf115ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_GLOBAL_0 */
#define XPAR_PSV_PMC_GLOBAL_0_BASEADDR 0xf1110000
#define XPAR_PSV_PMC_GLOBAL_0_HIGHADDR 0xf115ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI_BASEADDR 0xf6000000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI_HIGHADDR 0xf7ffffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RAM_NPI */
#define XPAR_PSV_PMC_RAM_NPI_0_BASEADDR 0xf6000000
#define XPAR_PSV_PMC_RAM_NPI_0_HIGHADDR 0xf7ffffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA_BASEADDR 0xf1200000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA_HIGHADDR 0xf120ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_RSA */
#define XPAR_PSV_PMC_RSA_0_BASEADDR 0xf1200000
#define XPAR_PSV_PMC_RSA_0_HIGHADDR 0xf120ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA_BASEADDR 0xf1210000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA_HIGHADDR 0xf121ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SHA */
#define XPAR_PSV_PMC_SHA_0_BASEADDR 0xf1210000
#define XPAR_PSV_PMC_SHA_0_HIGHADDR 0xf121ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT_BASEADDR 0xf1220000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT_HIGHADDR 0xf122ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT */
#define XPAR_PSV_PMC_SLAVE_BOOT_0_BASEADDR 0xf1220000
#define XPAR_PSV_PMC_SLAVE_BOOT_0_HIGHADDR 0xf122ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT_STREAM */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT_STREAM_BASEADDR 0xf2100000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT_STREAM_HIGHADDR 0xf210ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PMC_SLAVE_BOOT_STREAM */
#define XPAR_PSV_PMC_SLAVE_BOOT_STREAM_0_BASEADDR 0xf2100000
#define XPAR_PSV_PMC_SLAVE_BOOT_STREAM_0_HIGHADDR 0xf210ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG_BASEADDR 0xffc90000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG_HIGHADDR 0xffc9efff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_GLOBAL_REG */
#define XPAR_PSV_PSM_GLOBAL_REG_0_BASEADDR 0xffc90000
#define XPAR_PSV_PSM_GLOBAL_REG_0_HIGHADDR 0xffc9efff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_DATA_CNTLR */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_DATA_CNTLR_BASEADDR 0xffc20000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_DATA_CNTLR_HIGHADDR 0xffc3ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_DATA_CNTLR */
#define XPAR_PSM_PPU_0_BASEADDR 0xffc20000
#define XPAR_PSM_PPU_0_HIGHADDR 0xffc3ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_INSTR_CNTLR */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_INSTR_CNTLR_BASEADDR 0xffc00000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_INSTR_CNTLR_HIGHADDR 0xffc1ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_PSM_RAM_INSTR_CNTLR */
#define XPAR_RAM_INSTR_CNTLR_0_BASEADDR 0xffc00000
#define XPAR_RAM_INSTR_CNTLR_0_HIGHADDR 0xffc1ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0_BASEADDR 0xff130000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0_HIGHADDR 0xff13ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTR_0 */
#define XPAR_PSV_SCNTR_0_BASEADDR 0xff130000
#define XPAR_PSV_SCNTR_0_HIGHADDR 0xff13ffff

/* Definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0 */
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0_BASEADDR 0xff140000
#define XPAR_VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0_HIGHADDR 0xff14ffff

/* Canonical definitions for peripheral VERSAL_CIPS_0_PSPMC_0_PSV_SCNTRS_0 */
#define XPAR_PSV_SCNTRS_0_BASEADDR 0xff140000
#define XPAR_PSV_SCNTRS_0_HIGHADDR 0xff14ffff

/* Definitions for peripheral PSV_R5_0_ATCM_GLOBAL */
#define XPAR_PSV_R5_0_ATCM_GLOBAL_BASEADDR 0xffe00000
#define XPAR_PSV_R5_0_ATCM_GLOBAL_HIGHADDR 0xffe0ffff

/* Canonical definitions for peripheral PSV_R5_0_ATCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_0_BASEADDR 0xffe00000
#define XPAR_PSV_TCM_GLOBAL_0_HIGHADDR 0xffe0ffff

/* Definitions for peripheral PSV_R5_1_ATCM_GLOBAL */
#define XPAR_PSV_R5_1_ATCM_GLOBAL_BASEADDR 0xffe90000
#define XPAR_PSV_R5_1_ATCM_GLOBAL_HIGHADDR 0xffe9ffff

/* Canonical definitions for peripheral PSV_R5_1_ATCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_1_BASEADDR 0xffe90000
#define XPAR_PSV_TCM_GLOBAL_1_HIGHADDR 0xffe9ffff

/* Definitions for peripheral PSV_R5_1_BTCM_GLOBAL */
#define XPAR_PSV_R5_1_BTCM_GLOBAL_BASEADDR 0xffeb0000
#define XPAR_PSV_R5_1_BTCM_GLOBAL_HIGHADDR 0xffebffff

/* Canonical definitions for peripheral PSV_R5_1_BTCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_2_BASEADDR 0xffeb0000
#define XPAR_PSV_TCM_GLOBAL_2_HIGHADDR 0xffebffff

/* Definitions for peripheral LPD_XPPU */
#define XPAR_LPD_XPPU_BASEADDR 0xff990000
#define XPAR_LPD_XPPU_HIGHADDR 0xff991fff

/* Canonical definitions for peripheral LPD_XPPU */
#define XPAR_PSV_LPD_XPPU_0_BASEADDR 0xff990000
#define XPAR_PSV_LPD_XPPU_0_HIGHADDR 0xff991fff

/* Definitions for peripheral PMC_XPPU */
#define XPAR_PMC_XPPU_BASEADDR 0xf1310000
#define XPAR_PMC_XPPU_HIGHADDR 0xf1311fff

/* Canonical definitions for peripheral PMC_XPPU */
#define XPAR_PSV_PMC_XPPU_0_BASEADDR 0xf1310000
#define XPAR_PSV_PMC_XPPU_0_HIGHADDR 0xf1311fff

/* Definitions for peripheral PMC_XPPU_NPI */
#define XPAR_PMC_XPPU_NPI_BASEADDR 0xf1300000
#define XPAR_PMC_XPPU_NPI_HIGHADDR 0xf1301fff

/* Canonical definitions for peripheral PMC_XPPU_NPI */
#define XPAR_PSV_PMC_XPPU_NPI_0_BASEADDR 0xf1300000
#define XPAR_PSV_PMC_XPPU_NPI_0_HIGHADDR 0xf1301fff

/* Definitions for peripheral FPD_XMPU */
#define XPAR_FPD_XMPU_BASEADDR 0xfd390000
#define XPAR_FPD_XMPU_HIGHADDR 0xfd390fff

/* Canonical definitions for peripheral FPD_XMPU */
#define XPAR_PSV_FPD_SLAVE_XMPU_0_BASEADDR 0xfd390000
#define XPAR_PSV_FPD_SLAVE_XMPU_0_HIGHADDR 0xfd390fff

/* Definitions for peripheral PMC_XMPU */
#define XPAR_PMC_XMPU_BASEADDR 0xf12f0000
#define XPAR_PMC_XMPU_HIGHADDR 0xf12f0fff

/* Canonical definitions for peripheral PMC_XMPU */
#define XPAR_PSV_PMC_XMPU_0_BASEADDR 0xf12f0000
#define XPAR_PSV_PMC_XMPU_0_HIGHADDR 0xf12f0fff

/* Definitions for peripheral OCM_XMPU */
#define XPAR_OCM_XMPU_BASEADDR 0xff980000
#define XPAR_OCM_XMPU_HIGHADDR 0xff980fff

/* Canonical definitions for peripheral OCM_XMPU */
#define XPAR_PSV_OCM_XMPU_0_BASEADDR 0xff980000
#define XPAR_PSV_OCM_XMPU_0_HIGHADDR 0xff980fff

/*  BOARD definition */
#define XPS_BOARD_V80

#define XPAR_AXI_NOC_DDR_LOW_0_BASEADDR 0x0
#define XPAR_AXI_NOC_DDR_LOW_0_HIGHADDR 0x7fffffff
#define XPAR_PSV_OCM_0_BASEADDRESS 0xfffc0000
#define XPAR_PSV_OCM_0_HIGHADDRESS 0xffffffff

/*  CPU parameters definition */
#define XPAR_PSV_PSM_UNALIGNED_EXCEPTIONS 1
#define XPAR_PSV_PSM_FPU_EXCEPTION 0
#define XPAR_PSV_PSM_FSL_EXCEPTION 0
#define XPAR_PSV_PSM_DIV_ZERO_EXCEPTION 1
#define XPAR_PSV_PSM_ILL_OPCODE_EXCEPTION 1
#define XPAR_PSV_PSM_USE_STACK_PROTECTION 1
#define XPAR_PSV_PSM_FREQ 100000000
#define XPAR_PSV_PSM_USE_MSR_INSTR 1
#define XPAR_PSV_PSM_D_CACHE_LINE_SIZE 16
#define XPAR_PSV_PSM_DCACHE_ALWAYS_USED 0
#define XPAR_PSV_PSM_D_CACHE_SIZE 8192
#define XPAR_PSV_PSM_I_CACHE_LINE_SIZE 16
#define XPAR_PSV_PSM_I_CACHE_SIZE 8192
#define XPAR_PSV_PSM_ADDR_TAG_BITS 0
#define XPAR_PSV_PSM_ALLOW_DCACHE_WR 1
#define XPAR_PSV_PSM_ALLOW_ICACHE_WR 1
#define XPAR_PSV_PSM_AREA_OPTIMIZED 0
#define XPAR_PSV_PSM_CACHE_BYTE_SIZE 8192
#define XPAR_PSV_PSM_D_LMB 1
#define XPAR_PSV_PSM_I_LMB 1
#define XPAR_PSV_PSM_DCACHE_ADDR_TAG 0
#define XPAR_PSV_PSM_DCACHE_BYTE_SIZE 8192
#define XPAR_PSV_PSM_DCACHE_LINE_LEN 4
#define XPAR_PSV_PSM_DCACHE_USE_WRITEBACK 0
#define XPAR_PSV_PSM_DEBUG_ENABLED 1
#define XPAR_PSV_PSM_DYNAMIC_BUS_SIZING 0
#define XPAR_PSV_PSM_EDGE_IS_POSITIVE 1
#define XPAR_PSV_PSM_ENDIANNESS 1
#define XPAR_PSV_PSM_FSL_LINKS 0
#define XPAR_PSV_PSM_ICACHE_ALWAYS_USED 0
#define XPAR_PSV_PSM_ICACHE_LINE_LEN 4
#define XPAR_PSV_PSM_INTERCONNECT 2
#define XPAR_PSV_PSM_INTERRUPT_IS_EDGE 0
#define XPAR_PSV_PSM_MMU_DTLB_SIZE 4
#define XPAR_PSV_PSM_MMU_ITLB_SIZE 2
#define XPAR_PSV_PSM_MMU_TLB_ACCESS 3
#define XPAR_PSV_PSM_MMU_ZONES 16
#define XPAR_PSV_PSM_NUMBER_OF_PC_BRK 2
#define XPAR_PSV_PSM_NUMBER_OF_RD_ADDR_BRK 1
#define XPAR_PSV_PSM_NUMBER_OF_WR_ADDR_BRK 1
#define XPAR_PSV_PSM_OPCODE_0X0_ILLEGAL 1
#define XPAR_PSV_PSM_PVR 2
#define XPAR_PSV_PSM_PVR_USER2 0
#define XPAR_PSV_PSM_RESET_MSR 0
#define XPAR_PSV_PSM_SCO 0
#define XPAR_PSV_PSM_USE_BARREL 1
#define XPAR_PSV_PSM_USE_DCACHE 0
#define XPAR_PSV_PSM_USE_DIV 1
#define XPAR_PSV_PSM_USE_EXT_BRK 0
#define XPAR_PSV_PSM_USE_EXT_NM_BRK 0
#define XPAR_PSV_PSM_USE_EXTENDED_FSL_INSTR 0
#define XPAR_PSV_PSM_USE_FPU 0
#define XPAR_PSV_PSM_USE_HW_MUL 2
#define XPAR_PSV_PSM_USE_ICACHE 0
#define XPAR_PSV_PSM_USE_INTERRUPT 1
#define XPAR_PSV_PSM_USE_MMU 0
#define XPAR_PSV_PSM_USE_PCMP_INSTR 1
#define XPAR_PSV_PSM_D_CACHE_BASEADDR 0
#define XPAR_PSV_PSM_D_CACHE_HIGHADDR 1073741823
#define XPAR_PSV_PSM_I_CACHE_BASEADDR 0
#define XPAR_PSV_PSM_I_CACHE_HIGHADDR 1073741823
#define XPAR_PSV_PSM_REG 1
#define XPAR_PSV_PSM_BASE_VECTORS 4290772992

#define XPAR_CPU_CORE_CLOCK_FREQ_HZ 100000000

#define XPAR_MICROBLAZE_DDR_RESERVE_SA 0

#define XPAR_MICROBLAZE_ADDR_SIZE 32
#define XPAR_PSU_PSS_REF_CLK_FREQ_HZ 33333300

/* Number of SLRs */
#define NUMBER_OF_SLRS 0x3

/* Device ID */
#define XPAR_DEVICE_ID "xcv80"

#endif  /* end of protection macro */