/******************************************************************************
* Copyright (c) 2019 - 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file versal_2ve_2vm/xplmi_error_node.h
*
* This is the file which contains node IDs information for versal_net error
* events.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date        Changes
* ----- ---- -------- -------------------------------------------------------
* 1.00  sk   08/26/2024 Initial release EAM Table
*       sk   09/20/2024 Added defines for errors in LPDSLCR
*
* </pre>
*
* @note
*
******************************************************************************/
#ifndef XPLMI_ERROR_NODE_H
#define XPLMI_ERROR_NODE_H

#ifdef __cplusplus
extern "C" {
#endif

/**@cond xplmi_internal
 * @{
 */

/***************************** Include Files *********************************/

/************************** Constant Definitions *****************************/
/* Error Event Node Ids */
#define XPLMI_NODE_TYPE_MASK		(0xFC000U)
#define XPLMI_NODE_TYPE_SHIFT		(0xEU)

typedef enum {
	/* Event error types */
	XPLMI_NODETYPE_EVENT_PMC_ERR1 = 0x0,/**< 0x0 */
	XPLMI_NODETYPE_EVENT_PMC_ERR2, /**< 0x1 */
	XPLMI_NODETYPE_EVENT_PMC_ERR3, /**< 0x2 */
	XPLMI_NODETYPE_EVENT_LPDSLCR_ERR0, /**< 0x3 */
	XPLMI_NODETYPE_EVENT_LPDSLCR_ERR1, /**< 0x4 */
	XPLMI_NODETYPE_EVENT_LPDSLCR_ERR2, /**< 0x5 */
	XPLMI_NODETYPE_EVENT_LPDSLCR_ERR3, /**< 0x6 */
	XPLMI_NODETYPE_EVENT_SW_ERR,   /**< 0x7 */
} XPlmi_EventType;

/* PMC ERR1 errors */
#define XPLMI_ERROR_BOOT_CR		(0x0U)
#define XPLMI_ERROR_BOOT_NCR		(0x1U)
#define XPLMI_ERROR_FW_CR		(0x2U)
#define XPLMI_ERROR_FW_NCR		(0x3U)
#define XPLMI_ERROR_GSW_CR		(0x4U)
#define XPLMI_ERROR_GSW_NCR		(0x5U)
#define XPLMI_ERROR_CFU			(0x6U)
#define XPLMI_ERROR_CFRAME		(0x7U)
#define XPLMI_ERROR_RSVD_0		(0x8U)
#define XPLMI_ERROR_RSVD_1		(0x9U)
#define XPLMI_ERROR_DDRMB_CR		(0xAU)
#define XPLMI_ERROR_DDRMB_NCR		(0xBU)
#define XPLMI_ERROR_NOCTYPE1_CR		(0xCU)
#define XPLMI_ERROR_NOCTYPE1_NCR	(0xDU)
#define XPLMI_ERROR_NOCUSER		(0xEU)
#define XPLMI_ERROR_MMCM		(0xFU)
#define XPLMI_ERROR_AIE_CR		(0x10U)
#define XPLMI_ERROR_AIE_NCR		(0x11U)
#define XPLMI_ERROR_DDRMC_CR		(0x12U)
#define XPLMI_ERROR_DDRMC_NCR		(0x13U)
#define XPLMI_ERROR_GT_CR		(0x14U)
#define XPLMI_ERROR_GT_NCR		(0x15U)
#define XPLMI_ERROR_PLSMON_CR		(0x16U)
#define XPLMI_ERROR_PLSMON_NCR		(0x17U)
#define XPLMI_ERROR_PL0			(0x18U)
#define XPLMI_ERROR_PL1			(0x19U)
#define XPLMI_ERROR_PL2			(0x1AU)
#define XPLMI_ERROR_PL3			(0x1BU)
#define XPLMI_ERROR_NPIROOT		(0x1CU)
#define XPLMI_ERROR_SSIT3		(0x1DU)
#define XPLMI_ERROR_SSIT4		(0x1EU)
#define XPLMI_ERROR_SSIT5		(0x1FU)
#define XPLMI_ERROR_PMCERR1_MAX		(0x20U)

/* PMC ERR2 errors */
#define XPLMI_ERROR_PMCAPB		(0x20U)
#define XPLMI_ERROR_PMCROM		(0x21U)
#define XPLMI_ERROR_MB_FATAL0		(0x22U)
#define XPLMI_ERROR_MB_FATAL1		(0x23U)
#define XPLMI_ERROR_PMC_RSRV0		(0x24U)
#define XPLMI_ERROR_PMC_CR		(0x25U)
#define XPLMI_ERROR_PMC_NCR		(0x26U)
#define XPLMI_ERROR_PMCSMON0		(0x27U)
#define XPLMI_ERROR_PMCSMON1		(0x28U)
#define XPLMI_ERROR_PMCSMON2		(0x29U)
#define XPLMI_ERROR_PMCSMON3		(0x2AU)
#define XPLMI_ERROR_PMCSMON4		(0x2BU)
#define XPLMI_ERROR_PMC_RSRV1		(0x2CU)
#define XPLMI_ERROR_PMC_RSRV2		(0x2DU)
#define XPLMI_ERROR_PMC_RSRV3		(0x2EU)
#define XPLMI_ERROR_PMCSMON8		(0x2FU)
#define XPLMI_ERROR_PMCSMON9		(0x30U)
#define XPLMI_ERROR_CFI			(0x31U)
#define XPLMI_ERROR_SEUCRC		(0x32U)
#define XPLMI_ERROR_SEUECC		(0x33U)
#define XPLMI_ERROR_PMX_WWDT		(0x34U)
#define XPLMI_ERROR_PMC_RSRV4		(0x35U)
#define XPLMI_ERROR_RTCALARM		(0x36U)
#define XPLMI_ERROR_NPLL		(0x37U)
#define XPLMI_ERROR_PPLL		(0x38U)
#define XPLMI_ERROR_CLKMON		(0x39U)
#define XPLMI_ERROR_PMC_RSRV5		(0x3AU)
#define XPLMI_ERROR_INT_PMX_CORR_ERR	(0x3BU)
#define XPLMI_ERROR_INT_PMX_UNCORR_ERR	(0x3CU)
#define XPLMI_ERROR_SSIT0		(0x3DU)
#define XPLMI_ERROR_SSIT1		(0x3EU)
#define XPLMI_ERROR_SSIT2		(0x3FU)
#define XPLMI_ERROR_PMCERR2_MAX		(0x40U)

/* PMC ERR3 errors */
#define XPLMI_ERROR_IOU_CR		(0x40U)
#define XPLMI_ERROR_IOU_NCR		(0x41U)
#define XPLMI_ERROR_DFX_UXPT_ACT	(0x42U)
#define XPLMI_ERROR_DICE_CDI_PAR	(0x43U)
#define XPLMI_ERROR_DEVIK_PRIV		(0x44U)
#define XPLMI_ERROR_NXTSW_CDI_PAR	(0x45U)
#define XPLMI_ERROR_DEVAK_PRIV		(0x46U)
#define XPLMI_ERROR_DME_PUB_X		(0x47U)
#define XPLMI_ERROR_DME_PUB_Y		(0x48U)
#define XPLMI_ERROR_DEVAK_PUB_X		(0x49U)
#define XPLMI_ERROR_DEVAK_PUB_Y		(0x4AU)
#define XPLMI_ERROR_DEVIK_PUB_X		(0x4BU)
#define XPLMI_ERROR_DEVIK_PUB_Y		(0x4CU)
#define XPLMI_ERROR_PCR_PAR		(0x4DU)
#define XPLMI_ERROR_PSX_EAM_E0		(0x4EU)
#define XPLMI_ERROR_PSX_EAM_E1		(0x4FU)
#define XPLMI_ERROR_PSX_EAM_E2		(0x50U)
#define XPLMI_ERROR_PSX_EAM_E3		(0x51U)
#define XPLMI_ERROR_ASU_EAM_GD		(0x52U)
#define XPLMI_ERROR_PMC_EAM_GD		(0x53U)
#define XPLMI_ERROR_PMC_EAM_SMIRQ0		(0x54U)
#define XPLMI_ERROR_PMC_EAM_SMIRQ1		(0x55U)
#define XPLMI_ERROR_PMC_EAM_PRAM		(0x56U)
#define XPLMI_ERROR_PMC_EAM_AGERR		(0x57U)
#define XPLMI_ERROR_PMC_EAM_UFSFE		(0x58U)
#define XPLMI_ERROR_PMCERR3_MAX		(0x59U)

/* LPD SLCR ERR0 errors */
#define XPLMI_ERROR_PS_SW_CR			(0x60U)
#define XPLMI_ERROR_PS_SW_NCR			(0x61U)
#define XPLMI_ERROR_USB_ERR			(0x62U)
#define XPLMI_ERROR_LPX_DFX			(0x63U)
#define XPLMI_ERROR_UFSHC_FE_IRQ		(0x64U)
#define XPLMI_ERROR_APLL1_LOCK			(0x65U)
#define XPLMI_ERROR_APLL2_LOCK			(0x66U)
#define XPLMI_ERROR_RPLL_LOCK			(0x67U)
#define XPLMI_ERROR_FLXPLL_LOCK			(0x68U)
#define XPLMI_ERROR_INT_LPXASILB_CR		(0x69U)
#define XPLMI_ERROR_INT_LPXASILB_NCR		(0x6AU)
#define XPLMI_ERROR_INT_LPXASILD_CR		(0x6BU)
#define XPLMI_ERROR_INT_LPXASILD_NCR		(0x6CU)
#define XPLMI_ERROR_INT_FPXASILD_CR		(0x6DU)
#define XPLMI_ERROR_INT_FPXASILD_NCR		(0x6EU)
#define XPLMI_ERROR_INT_FPXASILB_CR		(0x6FU)
#define XPLMI_ERROR_INT_FPXASILB_NCR		(0x70U)
#define XPLMI_ERROR_INT_SPLIT_CR		(0x71U)
#define XPLMI_ERROR_INT_SPLIT_NCR		(0x72U)
#define XPLMI_ERROR_RSVD_2			(0x73U)
#define XPLMI_ERROR_RSVD_3			(0x74U)
#define XPLMI_ERROR_RSVD_4			(0x75U)
#define XPLMI_ERROR_RSVD_5			(0x76U)
#define XPLMI_ERROR_NOC_NMU_FIREWALL_WR_ERR	(0x77U)
#define XPLMI_ERROR_NOC_NMU_FIREWALL_RD_ERR	(0x78U)
#define XPLMI_ERROR_NOC_NSU_FIREWALL_ERR	(0x79U)
#define XPLMI_ERROR_GIC_FMU_ERR			(0x7AU)
#define XPLMI_ERROR_GIC_FMU_FAULT		(0x7BU)
#define XPLMI_ERROR_RSVD_6			(0x7CU)
#define XPLMI_ERROR_RSVD_7			(0x7DU)
#define XPLMI_ERROR_IPI_ERR			(0x7EU)
#define XPLMI_ERROR_FPD_CPI			(0x7FU)
#define XPLMI_ERROR_LPDSLCRERR0_MAX		(0x80U)

/* LPD SLCR ERR1 errors */
#define XPLMI_ERROR_FPD_WDT0				(0x80U)
#define XPLMI_ERROR_FPD_WDT1				(0x81U)
#define XPLMI_ERROR_FPD_WDT2				(0x82U)
#define XPLMI_ERROR_FPD_WDT3				(0x83U)
#define XPLMI_ERROR_PSXC_SPLITTER0_NON_FATAL_ERR	(0x84U)
#define XPLMI_ERROR_PSXC_SPLITTER1_NON_FATAL_ERR	(0x85U)
#define XPLMI_ERROR_PSXC_SPLITTER2_NON_FATAL_ERR	(0x86U)
#define XPLMI_ERROR_PSXC_SPLITTER3_NON_FATAL_ERR	(0x87U)
#define XPLMI_ERROR_PSXC_SPLITTER_FATAL_ERR		(0x88U)
#define XPLMI_ERROR_GIC_ERR				(0x89U)
#define XPLMI_ERROR_GIC_FAULT    			(0x8AU)
#define XPLMI_ERROR_CMN_FAULT				(0x8BU)
#define XPLMI_ERROR_CMN_ERR			 	(0x8CU)
#define XPLMI_ERROR_ACP_ERR				(0x8DU)
#define XPLMI_ERROR_FPD_APU0_ERI			(0x8EU)
#define XPLMI_ERROR_FPD_APU0_FHI			(0x8FU)
#define XPLMI_ERROR_FPD_APU1_ERI			(0x90U)
#define XPLMI_ERROR_FPD_APU1_FHI			(0x91U)
#define XPLMI_ERROR_FPD_APU2_ERI			(0x92U)
#define XPLMI_ERROR_FPD_APU2_FHI			(0x93U)
#define XPLMI_ERROR_FPD_APU3_ERI			(0x94U)
#define XPLMI_ERROR_FPD_APU3_FHI			(0x95U)
#define XPLMI_ERROR_FPD_MMU_ERR				(0x96U)
#define XPLMI_ERROR_FPD_MMU_FAULT			(0x97U)
#define XPLMI_ERROR_FPD_SLCR_ERR			(0x98U)
#define XPLMI_ERROR_FPD_SLCR_SECURE_ERR			(0x99U)
#define XPLMI_ERROR_FPX_AFIFM0_NONFATAL_ERR		(0x9AU)
#define XPLMI_ERROR_FPX_AFIFM1_NONFATAL_ERR		(0x9BU)
#define XPLMI_ERROR_FPX_AFIFM2_NONFATAL_ERR		(0x9CU)
#define XPLMI_ERROR_FPX_AFIFM3_NONFATAL_ERR		(0x9DU)
#define XPLMI_ERROR_FPX_AFIFS_CORR_ERR			(0x9EU)
#define XPLMI_ERROR_FPX_AFIFS_UNCORR_ERR		(0x9FU)
#define XPLMI_ERROR_LPDSLCRERR1_MAX			(0xA0U)

/* LPD SLCR ERR2 errors */
#define XPLMI_ERROR_RPUA_CORE_CLUSTER_FATAL		(0xA0U)
#define XPLMI_ERROR_RPUA_CORE0_NON_FATAL		(0xA1U)
#define XPLMI_ERROR_RPUA_CORE1_NON_FATAL		(0xA2U)
#define XPLMI_ERROR_RPUB_CORE_CLUSTER_FATAL		(0xA3U)
#define XPLMI_ERROR_RPUB_CORE0_NON_FATAL		(0xA4U)
#define XPLMI_ERROR_RPUB_CORE1_NON_FATAL		(0xA5U)
#define XPLMI_ERROR_RPUC_CORE_CLUSTER_FATAL		(0xA6U)
#define XPLMI_ERROR_RPUC_CORE0_NON_FATAL		(0xA7U)
#define XPLMI_ERROR_RPUC_CORE1_NON_FATAL		(0xA8U)
#define XPLMI_ERROR_RPUD_CORE_CLUSTER_FATAL		(0xA9U)
#define XPLMI_ERROR_RPUD_CORE0_NON_FATAL    		(0xAAU)
#define XPLMI_ERROR_RPUD_CORE1_NON_FATAL		(0xABU)
#define XPLMI_ERROR_RPUE_CORE_CLUSTER_FATAL		(0xACU)
#define XPLMI_ERROR_RPUE_CORE0_NON_FATAL		(0xADU)
#define XPLMI_ERROR_RPUE_CORE1_NON_FATAL		(0xAEU)
#define XPLMI_ERROR_RPU_PCIL_ERR    			(0xAFU)
#define XPLMI_ERROR_OCM0_NONFATAL_ERR			(0xB0U)
#define XPLMI_ERROR_OCM0_FATAL_ERR			(0xB1U)
#define XPLMI_ERROR_OCM1_NONFATAL_ERR			(0xB2U)
#define XPLMI_ERROR_OCM1_FATAL_ERR			(0xB3U)
#define XPLMI_ERROR_OCM2_NONFATAL_ERR    		(0xB4U)
#define XPLMI_ERROR_OCM2_FATAL_ERR			(0xB5U)
#define XPLMI_ERROR_OCM3_NONFATAL_ERR			(0xB6U)
#define XPLMI_ERROR_OCM3_FATAL_ERR			(0xB7U)
#define XPLMI_ERROR_LPX_WWDT0				(0xB8U)
#define XPLMI_ERROR_LPX_WWDT1				(0xB9U)
#define XPLMI_ERROR_LPX_WWDT2				(0xBAU)
#define XPLMI_ERROR_LPX_WWDT3				(0xBBU)
#define XPLMI_ERROR_LPX_WWDT4				(0xBCU)
#define XPLMI_ERROR_ADMA_LS_ERR				(0xBDU)
#define XPLMI_ERROR_LPX_GLITCH_DET0			(0xBEU)
#define XPLMI_ERROR_LPX_GLITCH_DET1			(0xBFU)
#define XPLMI_ERROR_LPDSLCRERR2_MAX			(0xC0U)

/* LPD SLCR ERR3 errors */
#define XPLMI_ERROR_FPD_CRF			(0xC0U)
#define XPLMI_ERROR_LPD_MON_ERR			(0xC1U)
#define XPLMI_ERROR_AFIFM_FATAL_ERR		(0xC2U)
#define XPLMI_ERROR_LPX_AFIFM_NONFATAL_ERR	(0xC3U)
#define XPLMI_ERROR_LPD_ASU_FATAL		(0xC4U)
#define XPLMI_ERROR_LPD_ASU_NON_FATAL		(0xC5U)
#define XPLMI_ERROR_LPX_AFIFS_CORR_ERR		(0xC6U)
#define XPLMI_ERROR_LPX_AFIFS_UNCORR_ERR	(0xC7U)
#define XPLMI_ERROR_MMI_CORR_EVENT		(0xC8U)
#define XPLMI_ERROR_MMI_UNCORR_EVENT		(0xC9U)
#define XPLMI_ERROR_MMI_GPU_COR_EVENT		(0xCAU)
#define XPLMI_ERROR_MMI_PCIE0_COR_EVENT		(0xCBU)
#define XPLMI_ERROR_MMI_PCIE1_COR_EVENT		(0xCCU)
#define XPLMI_ERROR_MMI_GEM_COR_EVENT		(0xCDU)
#define XPLMI_ERROR_MMI_DC_COR_EVENT		(0xCEU)
#define XPLMI_ERROR_MMI_UDH_COR_EVENT		(0xCFU)
#define XPLMI_ERROR_ADMA_ERR1			(0xD0U)
#define XPLMI_ERROR_ADMA_ERR2			(0xD1U)
#define XPLMI_ERROR_ADMA_ERR3			(0xD2U)
#define XPLMI_ERROR_ADMA_ERR4			(0xD3U)
#define XPLMI_ERROR_ADMA_ERR5			(0xD4U)
#define XPLMI_ERROR_ADMA_ERR6			(0xD5U)
#define XPLMI_ERROR_ADMA_ERR7			(0xD6U)
#define XPLMI_ERROR_ADMA_ERR8			(0xD7U)
#define XPLMI_ERROR_SDMA_ERR1			(0xD8U)
#define XPLMI_ERROR_SDMA_ERR2			(0xD9U)
#define XPLMI_ERROR_SDMA_ERR3			(0xDAU)
#define XPLMI_ERROR_SDMA_ERR4			(0xDBU)
#define XPLMI_ERROR_SDMA_ERR5			(0xDCU)
#define XPLMI_ERROR_SDMA_ERR6			(0xDDU)
#define XPLMI_ERROR_SDMA_ERR7			(0xDEU)
#define XPLMI_ERROR_SDMA_ERR8			(0xDFU)
#define XPLMI_ERROR_LPDSLCR_ERR3_MAX		(0xE0U)

/* Software Errors */
/* Health Boot Monitoring errors */
#define XPLMI_ERROR_HB_MON_0		(0xE0U)
#define XPLMI_ERROR_HB_MON_1		(0xE1U)
#define XPLMI_ERROR_HB_MON_2		(0xE2U)
#define XPLMI_ERROR_HB_MON_3		(0xE3U)
#define XPLMI_ERROR_PLM_EXCEPTION	(0xE4U)
#define XPLMI_ERROR_DEV_STATE_CHANGE 	(0xE5U)
#define XPLMI_ERROR_PCR_LOG_UPDATE	(0xE6U)
/* XilSem CE & UE errors */
#define XPLMI_ERROR_CRAM_CE		(0xE7U)
#define XPLMI_ERROR_CRAM_UE		(0xE8U)
#define XPLMI_ERROR_NPI_UE		(0xE9U)
#define XPLMI_ERROR_SW_ERR_MAX		(0xEAU)

#define PSX_EAM_E0_BIT_SHIFT		14U
#define PSX_EAM_E1_BIT_SHIFT		15U
#define PSX_EAM_E2_BIT_SHIFT		16U
#define PSX_EAM_E3_BIT_SHIFT		17U

#define XPLMI_ERROR_LPDSLCR_ERR_MAX		XPLMI_ERROR_LPDSLCR_ERR3_MAX
#define XPLMI_ERROR_PMCERR_MAX			XPLMI_ERROR_PMCERR3_MAX
#define GET_LPDSLCR_ERR_START(ErrIndex)		(XPLMI_ERROR_PS_SW_CR + \
						(ErrIndex * XPLMI_REG_MAX_ERRORS))
#define GET_LPDSLCR_ERR_END(ErrIndex)		(XPLMI_ERROR_LPDSLCRERR0_MAX + \
						(ErrIndex * XPLMI_REG_MAX_ERRORS))

#define GET_LPDSLCR_PMC3_ERR_MASK(ErrIndex)	(LPD_SLCR_EAM_PMC3_ERR0_MASK + \
						(ErrIndex * LPD_SLCR_GLOBAL_REG_ERR_OFFSET))
#define GET_LPDSLCR_PMC2_ERR_MASK(ErrIndex)	(LPD_SLCR_EAM_PMC2_ERR0_MASK + \
						(ErrIndex * LPD_SLCR_GLOBAL_REG_ERR_OFFSET))
#define GET_LPDSLCR_PMC1_ERR_MASK(ErrIndex)	(LPD_SLCR_EAM_PMC1_ERR0_MASK + \
						(ErrIndex * LPD_SLCR_GLOBAL_REG_ERR_OFFSET))
#define GET_LPDSLCR_PMC0_ERR_MASK(ErrIndex)	(LPD_SLCR_EAM_PMC0_ERR0_MASK + \
						(ErrIndex * LPD_SLCR_GLOBAL_REG_ERR_OFFSET))
/**************************** Type Definitions *******************************/

/***************** Macros (Inline Functions) Definitions *********************/

/************************** Function Prototypes ******************************/

/************************** Variable Definitions *****************************/

/*****************************************************************************/

/**
 * @}
 * @endcond
 */

#ifdef __cplusplus
}
#endif

#endif /* XPLMI_ERROR_NODE_H */
