#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

#define XPAR_XCANFD_NUM_INSTANCES 4

/* Definitions for peripheral CAN0 */
#define XPAR_CAN0_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_CAN0_BASEADDR 0xf19e0000
#define XPAR_CAN0_HIGHADDR 0xf19e5fff
#define XPAR_CAN0_RX_MODE 0x0
#define XPAR_CAN0_NUM_OF_RX_MB_BUF 0x30
#define XPAR_CAN0_NUM_OF_TX_BUF 0x20
#define XPAR_CAN0_INTERRUPTS 0x401b
#define XPAR_CAN0_CAN_CLK_FREQ_HZ 0x98961be

/* Canonical definitions for peripheral CAN0 */
#define XPAR_XCANFD_0_BASEADDR 0xf19e0000
#define XPAR_XCANFD_0_HIGHADDR 0xf19e5fff
#define XPAR_XCANFD_0_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_XCANFD_0_CAN_CLK_FREQ_HZ 0x98961be
#define XPAR_XCANFD_0_INTERRUPTS 0x401b
#define XPAR_XCANFD_0_NUM_OF_RX_MB_BUF 0x30
#define XPAR_XCANFD_0_NUM_OF_TX_BUF 0x20
#define XPAR_XCANFD_0_RX_MODE 0x0

/* Definitions for peripheral CAN1 */
#define XPAR_CAN1_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_CAN1_BASEADDR 0xf19f0000
#define XPAR_CAN1_HIGHADDR 0xf19f5fff
#define XPAR_CAN1_RX_MODE 0x0
#define XPAR_CAN1_NUM_OF_RX_MB_BUF 0x30
#define XPAR_CAN1_NUM_OF_TX_BUF 0x20
#define XPAR_CAN1_INTERRUPTS 0x401c
#define XPAR_CAN1_CAN_CLK_FREQ_HZ 0x98961be

/* Canonical definitions for peripheral CAN1 */
#define XPAR_XCANFD_1_BASEADDR 0xf19f0000
#define XPAR_XCANFD_1_HIGHADDR 0xf19f5fff
#define XPAR_XCANFD_1_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_XCANFD_1_CAN_CLK_FREQ_HZ 0x98961be
#define XPAR_XCANFD_1_INTERRUPTS 0x401c
#define XPAR_XCANFD_1_NUM_OF_RX_MB_BUF 0x30
#define XPAR_XCANFD_1_NUM_OF_TX_BUF 0x20
#define XPAR_XCANFD_1_RX_MODE 0x0

/* Definitions for peripheral CAN2 */
#define XPAR_CAN2_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_CAN2_BASEADDR 0xf1a00000
#define XPAR_CAN2_HIGHADDR 0xf1a05fff
#define XPAR_CAN2_RX_MODE 0x0
#define XPAR_CAN2_NUM_OF_RX_MB_BUF 0x30
#define XPAR_CAN2_NUM_OF_TX_BUF 0x20
#define XPAR_CAN2_INTERRUPTS 0x405f
#define XPAR_CAN2_CAN_CLK_FREQ_HZ 0x98961be

/* Canonical definitions for peripheral CAN2 */
#define XPAR_XCANFD_2_BASEADDR 0xf1a00000
#define XPAR_XCANFD_2_HIGHADDR 0xf1a05fff
#define XPAR_XCANFD_2_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_XCANFD_2_CAN_CLK_FREQ_HZ 0x98961be
#define XPAR_XCANFD_2_INTERRUPTS 0x405f
#define XPAR_XCANFD_2_NUM_OF_RX_MB_BUF 0x30
#define XPAR_XCANFD_2_NUM_OF_TX_BUF 0x20
#define XPAR_XCANFD_2_RX_MODE 0x0

/* Definitions for peripheral CAN3 */
#define XPAR_CAN3_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_CAN3_BASEADDR 0xf1a10000
#define XPAR_CAN3_HIGHADDR 0xf1a15fff
#define XPAR_CAN3_RX_MODE 0x0
#define XPAR_CAN3_NUM_OF_RX_MB_BUF 0x30
#define XPAR_CAN3_NUM_OF_TX_BUF 0x20
#define XPAR_CAN3_INTERRUPTS 0x4060
#define XPAR_CAN3_CAN_CLK_FREQ_HZ 0x98961be

/* Canonical definitions for peripheral CAN3 */
#define XPAR_XCANFD_3_BASEADDR 0xf1a10000
#define XPAR_XCANFD_3_HIGHADDR 0xf1a15fff
#define XPAR_XCANFD_3_COMPATIBLE "xlnx,canfd-2.0"
#define XPAR_XCANFD_3_CAN_CLK_FREQ_HZ 0x98961be
#define XPAR_XCANFD_3_INTERRUPTS 0x4060
#define XPAR_XCANFD_3_NUM_OF_RX_MB_BUF 0x30
#define XPAR_XCANFD_3_NUM_OF_TX_BUF 0x20
#define XPAR_XCANFD_3_RX_MODE 0x0

#define XPAR_XCFRAME_NUM_INSTANCES 1

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_CFI_CFRAME_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_CFI_CFRAME_0_COMPATIBLE "xlnx,pmc-cfi-cframe-11.0"
#define XPAR_PS_WIZARD_0_PS11_0_PMC_CFI_CFRAME_0_BASEADDR 0xf12d0000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_CFI_CFRAME_0_HIGHADDR 0xf12d0fff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_CFI_CFRAME_0 */
#define XPAR_XCFRAME_0_BASEADDR 0xf12d0000
#define XPAR_XCFRAME_0_HIGHADDR 0xf12d0fff
#define XPAR_XCFRAME_0_COMPATIBLE "xlnx,pmc-cfi-cframe-11.0"

#define XPAR_XCFUPMC_NUM_INSTANCES 1

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_CFU_APB_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_CFU_APB_0_COMPATIBLE "xlnx,pmc-cfu-apb-11.0"
#define XPAR_PS_WIZARD_0_PS11_0_PMC_CFU_APB_0_BASEADDR 0xf12b0000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_CFU_APB_0_HIGHADDR 0xf12bffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_CFU_APB_0 */
#define XPAR_XCFUPMC_0_BASEADDR 0xf12b0000
#define XPAR_XCFUPMC_0_HIGHADDR 0xf12bffff
#define XPAR_XCFUPMC_0_COMPATIBLE "xlnx,pmc-cfu-apb-11.0"

#define XPAR_XCSUDMA_NUM_INSTANCES 2

/* Definitions for peripheral DMA0 */
#define XPAR_DMA0_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_DMA0_BASEADDR 0xf11c0000
#define XPAR_DMA0_HIGHADDR 0xf11cffff
#define XPAR_DMA0_DMA_TYPE 0x1
#define XPAR_DMA0_INTERRUPTS 0x40e0

/* Canonical definitions for peripheral DMA0 */
#define XPAR_XCSUDMA_0_BASEADDR 0xf11c0000
#define XPAR_XCSUDMA_0_HIGHADDR 0xf11cffff
#define XPAR_XCSUDMA_0_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_XCSUDMA_0_DMA_TYPE 0x1
#define XPAR_XCSUDMA_0_INTERRUPTS 0x40e0

/* Definitions for peripheral DMA1 */
#define XPAR_DMA1_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_DMA1_BASEADDR 0xf11d0000
#define XPAR_DMA1_HIGHADDR 0xf11dffff
#define XPAR_DMA1_DMA_TYPE 0x2
#define XPAR_DMA1_INTERRUPTS 0x40e1

/* Canonical definitions for peripheral DMA1 */
#define XPAR_XCSUDMA_1_BASEADDR 0xf11d0000
#define XPAR_XCSUDMA_1_HIGHADDR 0xf11dffff
#define XPAR_XCSUDMA_1_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_XCSUDMA_1_DMA_TYPE 0x2
#define XPAR_XCSUDMA_1_INTERRUPTS 0x40e1

#define XPAR_XDCSUB_NUM_INSTANCES 1

/* Definitions for peripheral MMI_DC */
#define XPAR_MMI_DC_COMPATIBLE "amd,mmi-dc-1.0"
#define XPAR_MMI_DC_BASEADDR 0xedd00000
#define XPAR_MMI_DC_HIGHADDR 0xedd00fff
#define XPAR_MMI_DC_BASEADDR_1 0xedd0a000
#define XPAR_MMI_DC_BASEADDR_2 0xedd0b000
#define XPAR_MMI_DC_BASEADDR_3 0xedd0c000
#define XPAR_MMI_DC_BASEADDR_4 0xedd0d000
#define XPAR_MMI_DC_REG_NAMES "dp"
#define XPAR_MMI_DC_INTERRUPTS 0x40b3
#define XPAR_MMI_DC_DC_OPERATING_MODE "DC_Functional"
#define XPAR_MMI_DC_DC_PRESENTATION_MODE "Non_Live"
#define XPAR_MMI_DC_DC_LIVE_VIDEO_SELECT "None"
#define XPAR_MMI_DC_DC_LIVE_VIDEO01_MODE "None"
#define XPAR_MMI_DC_DC_LIVE_VIDEO02_MODE "None"
#define XPAR_MMI_DC_DC_LIVE_VIDEO_ALPHA_EN 0x0
#define XPAR_MMI_DC_DC_LIVE_VIDEO_SDP_EN 0x0
#define XPAR_MMI_DC_DC_STREAMS 0x0
#define XPAR_MMI_DC_DC_STREAM0_MODE "None"
#define XPAR_MMI_DC_DC_STREAM0_PIXEL_MODE "None"
#define XPAR_MMI_DC_DC_STREAM0_SDP_EN 0x0
#define XPAR_MMI_DC_DC_STREAM1_MODE "None"
#define XPAR_MMI_DC_DC_STREAM1_PIXEL_MODE "None"
#define XPAR_MMI_DC_DC_STREAM1_SDP_EN 0x0
#define XPAR_MMI_DC_DC_STREAM2_MODE "None"
#define XPAR_MMI_DC_DC_STREAM2_PIXEL_MODE "None"
#define XPAR_MMI_DC_DC_STREAM2_SDP_EN 0x0
#define XPAR_MMI_DC_DC_STREAM3_MODE "None"
#define XPAR_MMI_DC_DC_STREAM3_PIXEL_MODE "None"
#define XPAR_MMI_DC_DC_STREAM3_SDP_EN 0x0

/* Canonical definitions for peripheral MMI_DC */
#define XPAR_XDCSUB_0_BASEADDR 0xedd00000
#define XPAR_XDCSUB_0_HIGHADDR 0xedd00fff
#define XPAR_XDCSUB_0_COMPATIBLE "amd,mmi-dc-1.0"
#define XPAR_XDCSUB_0_DC_OPERATING_MODE "DC_Functional"
#define XPAR_XDCSUB_0_DC_PRESENTATION_MODE "Non_Live"
#define XPAR_XDCSUB_0_DC_LIVE_VIDEO_SELECT "None"
#define XPAR_XDCSUB_0_DC_LIVE_VIDEO01_MODE "None"
#define XPAR_XDCSUB_0_DC_LIVE_VIDEO02_MODE "None"
#define XPAR_XDCSUB_0_DC_LIVE_VIDEO_ALPHA_EN 0x0
#define XPAR_XDCSUB_0_DC_LIVE_VIDEO_SDP_EN 0x0
#define XPAR_XDCSUB_0_DC_STREAMS 0x0
#define XPAR_XDCSUB_0_DC_STREAM0_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM0_PIXEL_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM0_SDP_EN 0x0
#define XPAR_XDCSUB_0_DC_STREAM1_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM1_PIXEL_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM1_SDP_EN 0x0
#define XPAR_XDCSUB_0_DC_STREAM2_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM2_PIXEL_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM2_SDP_EN 0x0
#define XPAR_XDCSUB_0_DC_STREAM3_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM3_PIXEL_MODE "None"
#define XPAR_XDCSUB_0_DC_STREAM3_SDP_EN 0x0
#define XPAR_XDCSUB_0_INTERRUPTS 0x40b3
#define XPAR_XDCSUB_0_REG_NAMES "dp"

#define XPAR_XEMACPS_NUM_INSTANCES 2

/* Definitions for peripheral GEM0 */
#define XPAR_GEM0_COMPATIBLE "xlnx,versal-gem"
#define XPAR_GEM0_BASEADDR 0xf1a60000
#define XPAR_GEM0_HIGHADDR 0xf1a60fff
#define XPAR_GEM0_DMA_COHERENT 0x1
#define XPAR_GEM0_INTERRUPTS 0x4027
#define XPAR_GEM0_INTERRUPTS_1 0x4027
#define XPAR_GEM0_PHY_MODE "rgmii-id"
#define XPAR_GEM0_PHY_HANDLE 0x1

/* Canonical definitions for peripheral GEM0 */
#define XPAR_XEMACPS_0_BASEADDR 0xf1a60000
#define XPAR_XEMACPS_0_HIGHADDR 0xf1a60fff
#define XPAR_XEMACPS_0_COMPATIBLE "xlnx,versal-gem"
#define XPAR_XEMACPS_0_DMA_COHERENT 0x1
#define XPAR_XEMACPS_0_INTERRUPTS 0x4027
#define XPAR_XEMACPS_0_PHY_MODE "rgmii-id"
#define XPAR_XEMACPS_0_PHY_HANDLE 0x1

/* Definitions for peripheral MMI_10GBE */
#define XPAR_MMI_10GBE_COMPATIBLE "amd,versal2-10gbe"
#define XPAR_MMI_10GBE_BASEADDR 0xed920000
#define XPAR_MMI_10GBE_HIGHADDR 0xed920fff
#define XPAR_MMI_10GBE_INTERRUPTS 0x40a4
#define XPAR_MMI_10GBE_INTERRUPTS_1 0x40a4
#define XPAR_MMI_10GBE_INTERRUPTS_2 0x40a4
#define XPAR_MMI_10GBE_INTERRUPTS_3 0x40a4
#define XPAR_MMI_10GBE_PHY_MODE "10gbase-r"

/* Canonical definitions for peripheral MMI_10GBE */
#define XPAR_XEMACPS_1_BASEADDR 0xed920000
#define XPAR_XEMACPS_1_HIGHADDR 0xed920fff
#define XPAR_XEMACPS_1_COMPATIBLE "amd,versal2-10gbe"
#define XPAR_XEMACPS_1_INTERRUPTS 0x40a4
#define XPAR_XEMACPS_1_PHY_MODE "10gbase-r"

#define XPAR_XGPIOPS_NUM_INSTANCES 1

/* Definitions for peripheral GPIO0 */
#define XPAR_GPIO0_COMPATIBLE "xlnx,versal-gpio-1.0"
#define XPAR_GPIO0_BASEADDR 0xf1a50000
#define XPAR_GPIO0_HIGHADDR 0xf1a50fff
#define XPAR_GPIO0_INTERRUPTS 0x4014

/* Canonical definitions for peripheral GPIO0 */
#define XPAR_XGPIOPS_0_BASEADDR 0xf1a50000
#define XPAR_XGPIOPS_0_HIGHADDR 0xf1a50fff
#define XPAR_XGPIOPS_0_COMPATIBLE "xlnx,versal-gpio-1.0"
#define XPAR_XGPIOPS_0_INTERRUPTS 0x4014

#define XPAR_XIICPS_NUM_INSTANCES 2

/* Definitions for peripheral I2C0 */
#define XPAR_I2C0_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_I2C0_BASEADDR 0xf1940000
#define XPAR_I2C0_HIGHADDR 0xf1940fff
#define XPAR_I2C0_CLOCK_FREQ 0x98961be
#define XPAR_I2C0_INTERRUPTS 0x4015
#define XPAR_I2C0_CLOCKS 0x9d

/* Canonical definitions for peripheral I2C0 */
#define XPAR_XIICPS_0_BASEADDR 0xf1940000
#define XPAR_XIICPS_0_HIGHADDR 0xf1940fff
#define XPAR_XIICPS_0_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_XIICPS_0_CLOCK_FREQ 0x98961be
#define XPAR_XIICPS_0_CLOCKS 0x9d
#define XPAR_XIICPS_0_INTERRUPTS 0x4015

/* Definitions for peripheral I2C1 */
#define XPAR_I2C1_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_I2C1_BASEADDR 0xf1950000
#define XPAR_I2C1_HIGHADDR 0xf1950fff
#define XPAR_I2C1_CLOCK_FREQ 0x98961be
#define XPAR_I2C1_INTERRUPTS 0x4016
#define XPAR_I2C1_CLOCKS 0x9f

/* Canonical definitions for peripheral I2C1 */
#define XPAR_XIICPS_1_BASEADDR 0xf1950000
#define XPAR_XIICPS_1_HIGHADDR 0xf1950fff
#define XPAR_XIICPS_1_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_XIICPS_1_CLOCK_FREQ 0x98961be
#define XPAR_XIICPS_1_CLOCKS 0x9f
#define XPAR_XIICPS_1_INTERRUPTS 0x4016

#define XPAR_XIOMODULE_NUM_INSTANCES 1

/* Definitions for peripheral IOMODULE0 */
#define XPAR_IOMODULE0_COMPATIBLE "xlnx,iomodule-3.1"
#define XPAR_IOMODULE0_BASEADDR 0xf0300000
#define XPAR_IOMODULE0_HIGHADDR 0xf0300fff
#define XPAR_IOMODULE0_BASEADDR_1 0xffffffffffffffff
#define XPAR_IOMODULE0_INTC_HAS_FAST 0x0
#define XPAR_IOMODULE0_INTC_BASE_VECTORS 0xf0240000
#define XPAR_IOMODULE0_INTC_ADDR_WIDTH 0x20
#define XPAR_IOMODULE0_INTC_LEVEL_EDGE 0x7fff
#define XPAR_IOMODULE0_OPTIONS 0x1
#define XPAR_IOMODULE0_CLOCK_FREQ 0x5f5e100
#define XPAR_IOMODULE0_UART_BAUDRATE 0x1c200
#define XPAR_IOMODULE0_PIT_USED_0 1
#define XPAR_IOMODULE0_PIT_USED_1 1
#define XPAR_IOMODULE0_PIT_USED_2 1
#define XPAR_IOMODULE0_PIT_USED_3 1
#define XPAR_IOMODULE0_PIT_SIZE_0 32
#define XPAR_IOMODULE0_PIT_SIZE_1 32
#define XPAR_IOMODULE0_PIT_SIZE_2 32
#define XPAR_IOMODULE0_PIT_SIZE_3 32
#define XPAR_IOMODULE0_PIT_MASK_0 4294967295
#define XPAR_IOMODULE0_PIT_MASK_1 4294967295
#define XPAR_IOMODULE0_PIT_MASK_2 4294967295
#define XPAR_IOMODULE0_PIT_MASK_3 4294967295
#define XPAR_IOMODULE0_PIT_PRESCALER_0 9
#define XPAR_IOMODULE0_PIT_PRESCALER_1 0
#define XPAR_IOMODULE0_PIT_PRESCALER_2 9
#define XPAR_IOMODULE0_PIT_PRESCALER_3 0
#define XPAR_IOMODULE0_PIT_READABLE_0 1
#define XPAR_IOMODULE0_PIT_READABLE_1 1
#define XPAR_IOMODULE0_PIT_READABLE_2 1
#define XPAR_IOMODULE0_PIT_READABLE_3 1
#define XPAR_IOMODULE0_GPO_INIT_0 0
#define XPAR_IOMODULE0_GPO_INIT_1 0
#define XPAR_IOMODULE0_GPO_INIT_2 0
#define XPAR_IOMODULE0_GPO_INIT_3 0
#define XPAR_IOMODULE0_MAX_INTR_SIZE 0x20
#define XPAR_IOMODULE0_INTC_INTR_SIZE 0x10
#define XPAR_IOMODULE0_INTC_USE_EXT_INTR 0x1
#define XPAR_IOMODULE0_INTC_POSITIVE 0xffff
#define XPAR_IOMODULE0_UART_PROG_BAUDRATE 0x1
#define XPAR_IOMODULE0_UART_DATA_BITS 0x8
#define XPAR_IOMODULE0_UART_USE_PARITY 0x0
#define XPAR_IOMODULE0_UART_ODD_PARITY 0x0
#define XPAR_IOMODULE0_UART_RX_INTERRUPT 0x1
#define XPAR_IOMODULE0_UART_TX_INTERRUPT 0x1
#define XPAR_IOMODULE0_USE_UART_RX 0x1
#define XPAR_IOMODULE0_USE_UART_TX 0x1
#define XPAR_IOMODULE0_UART_ERROR_INTERRUPT 0x1
#define XPAR_IOMODULE0_USE_FIT1 0x0
#define XPAR_IOMODULE0_FIT1_NO_CLOCKS 0x1848
#define XPAR_IOMODULE0_FIT1_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_FIT2 0x0
#define XPAR_IOMODULE0_FIT2_NO_CLOCKS 0x1848
#define XPAR_IOMODULE0_FIT2_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_FIT3 0x0
#define XPAR_IOMODULE0_FIT3_NO_CLOCKS 0x1848
#define XPAR_IOMODULE0_FIT3_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_FIT4 0x0
#define XPAR_IOMODULE0_FIT4_NO_CLOCKS 0x1848
#define XPAR_IOMODULE0_FIT4_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_PIT1 0x1
#define XPAR_IOMODULE0_PIT1_SIZE 0x20
#define XPAR_IOMODULE0_PIT1_READABLE 0x1
#define XPAR_IOMODULE0_PIT1_PRESCALER 0x9
#define XPAR_IOMODULE0_PIT1_INTERRUPT 0x1
#define XPAR_IOMODULE0_USE_PIT2 0x1
#define XPAR_IOMODULE0_PIT2_SIZE 0x20
#define XPAR_IOMODULE0_PIT2_READABLE 0x1
#define XPAR_IOMODULE0_PIT2_PRESCALER 0x0
#define XPAR_IOMODULE0_PIT2_INTERRUPT 0x1
#define XPAR_IOMODULE0_USE_PIT3 0x1
#define XPAR_IOMODULE0_PIT3_SIZE 0x20
#define XPAR_IOMODULE0_PIT3_READABLE 0x1
#define XPAR_IOMODULE0_PIT3_PRESCALER 0x9
#define XPAR_IOMODULE0_PIT3_INTERRUPT 0x1
#define XPAR_IOMODULE0_USE_PIT4 0x1
#define XPAR_IOMODULE0_PIT4_SIZE 0x20
#define XPAR_IOMODULE0_PIT4_READABLE 0x1
#define XPAR_IOMODULE0_PIT4_PRESCALER 0x0
#define XPAR_IOMODULE0_PIT4_INTERRUPT 0x1
#define XPAR_IOMODULE0_USE_GPO1 0x1
#define XPAR_IOMODULE0_GPO1_SIZE 0x3
#define XPAR_IOMODULE0_GPO1_INIT 0x0
#define XPAR_IOMODULE0_USE_GPO2 0x0
#define XPAR_IOMODULE0_GPO2_SIZE 0x20
#define XPAR_IOMODULE0_GPO2_INIT 0x0
#define XPAR_IOMODULE0_USE_GPO3 0x0
#define XPAR_IOMODULE0_GPO3_SIZE 0x20
#define XPAR_IOMODULE0_GPO3_INIT 0x0
#define XPAR_IOMODULE0_USE_GPO4 0x0
#define XPAR_IOMODULE0_GPO4_SIZE 0x20
#define XPAR_IOMODULE0_GPO4_INIT 0x0
#define XPAR_IOMODULE0_USE_GPI1 0x0
#define XPAR_IOMODULE0_GPI1_SIZE 0x20
#define XPAR_IOMODULE0_GPI1_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_GPI2 0x0
#define XPAR_IOMODULE0_GPI2_SIZE 0x20
#define XPAR_IOMODULE0_GPI2_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_GPI3 0x0
#define XPAR_IOMODULE0_GPI3_SIZE 0x20
#define XPAR_IOMODULE0_GPI3_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_GPI4 0x0
#define XPAR_IOMODULE0_GPI4_SIZE 0x20
#define XPAR_IOMODULE0_GPI4_INTERRUPT 0x0
#define XPAR_IOMODULE0_USE_IO_BUS 0x0
#define XPAR_IOMODULE0_IO_MASK 0xfffe0000
#define XPAR_IOMODULE0_FREQ 0x5f5e100

/* Canonical definitions for peripheral IOMODULE0 */
#define XPAR_XIOMODULE_0_BASEADDR 0xf0300000
#define XPAR_XIOMODULE_0_HIGHADDR 0xf0300fff
#define XPAR_XIOMODULE_0_COMPATIBLE "xlnx,iomodule-3.1"
#define XPAR_XIOMODULE_0_CLOCK_FREQ 0x5f5e100
#define XPAR_XIOMODULE_0_FIT1_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT1_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FIT2_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT2_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FIT3_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT3_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FIT4_NO_CLOCKS 0x1848
#define XPAR_XIOMODULE_0_FIT4_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_FREQ 0x5f5e100
#define XPAR_XIOMODULE_0_GPO_INIT_0 0
#define XPAR_XIOMODULE_0_GPO_INIT_1 0
#define XPAR_XIOMODULE_0_GPO_INIT_2 0
#define XPAR_XIOMODULE_0_GPO_INIT_3 0
#define XPAR_XIOMODULE_0_GPO1_SIZE 0x3
#define XPAR_XIOMODULE_0_GPO1_INIT 0x0
#define XPAR_XIOMODULE_0_GPO2_SIZE 0x20
#define XPAR_XIOMODULE_0_GPO2_INIT 0x0
#define XPAR_XIOMODULE_0_GPO3_SIZE 0x20
#define XPAR_XIOMODULE_0_GPO3_INIT 0x0
#define XPAR_XIOMODULE_0_GPO4_SIZE 0x20
#define XPAR_XIOMODULE_0_GPO4_INIT 0x0
#define XPAR_XIOMODULE_0_GPI1_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI1_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_GPI2_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI2_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_GPI3_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI3_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_GPI4_SIZE 0x20
#define XPAR_XIOMODULE_0_GPI4_INTERRUPT 0x0
#define XPAR_XIOMODULE_0_INTC_HAS_FAST 0x0
#define XPAR_XIOMODULE_0_INTC_BASE_VECTORS 0xf0240000
#define XPAR_XIOMODULE_0_INTC_ADDR_WIDTH 0x20
#define XPAR_XIOMODULE_0_INTC_LEVEL_EDGE 0x7fff
#define XPAR_XIOMODULE_0_INTC_INTR_SIZE 0x10
#define XPAR_XIOMODULE_0_INTC_USE_EXT_INTR 0x1
#define XPAR_XIOMODULE_0_INTC_POSITIVE 0xffff
#define XPAR_XIOMODULE_0_IO_MASK 0xfffe0000
#define XPAR_XIOMODULE_0_MAX_INTR_SIZE 0x20
#define XPAR_XIOMODULE_0_OPTIONS 0x1
#define XPAR_XIOMODULE_0_PIT_USED_0 1
#define XPAR_XIOMODULE_0_PIT_USED_1 1
#define XPAR_XIOMODULE_0_PIT_USED_2 1
#define XPAR_XIOMODULE_0_PIT_USED_3 1
#define XPAR_XIOMODULE_0_PIT_SIZE_0 32
#define XPAR_XIOMODULE_0_PIT_SIZE_1 32
#define XPAR_XIOMODULE_0_PIT_SIZE_2 32
#define XPAR_XIOMODULE_0_PIT_SIZE_3 32
#define XPAR_XIOMODULE_0_PIT_MASK_0 4294967295
#define XPAR_XIOMODULE_0_PIT_MASK_1 4294967295
#define XPAR_XIOMODULE_0_PIT_MASK_2 4294967295
#define XPAR_XIOMODULE_0_PIT_MASK_3 4294967295
#define XPAR_XIOMODULE_0_PIT_PRESCALER_0 9
#define XPAR_XIOMODULE_0_PIT_PRESCALER_1 0
#define XPAR_XIOMODULE_0_PIT_PRESCALER_2 9
#define XPAR_XIOMODULE_0_PIT_PRESCALER_3 0
#define XPAR_XIOMODULE_0_PIT_READABLE_0 1
#define XPAR_XIOMODULE_0_PIT_READABLE_1 1
#define XPAR_XIOMODULE_0_PIT_READABLE_2 1
#define XPAR_XIOMODULE_0_PIT_READABLE_3 1
#define XPAR_XIOMODULE_0_PIT1_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT1_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT1_PRESCALER 0x9
#define XPAR_XIOMODULE_0_PIT1_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_PIT2_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT2_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT2_PRESCALER 0x0
#define XPAR_XIOMODULE_0_PIT2_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_PIT3_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT3_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT3_PRESCALER 0x9
#define XPAR_XIOMODULE_0_PIT3_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_PIT4_SIZE 0x20
#define XPAR_XIOMODULE_0_PIT4_READABLE 0x1
#define XPAR_XIOMODULE_0_PIT4_PRESCALER 0x0
#define XPAR_XIOMODULE_0_PIT4_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_UART_BAUDRATE 0x1c200
#define XPAR_XIOMODULE_0_UART_PROG_BAUDRATE 0x1
#define XPAR_XIOMODULE_0_UART_DATA_BITS 0x8
#define XPAR_XIOMODULE_0_UART_USE_PARITY 0x0
#define XPAR_XIOMODULE_0_UART_ODD_PARITY 0x0
#define XPAR_XIOMODULE_0_UART_RX_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_UART_TX_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_USE_UART_RX 0x1
#define XPAR_XIOMODULE_0_USE_UART_TX 0x1
#define XPAR_XIOMODULE_0_UART_ERROR_INTERRUPT 0x1
#define XPAR_XIOMODULE_0_USE_FIT1 0x0
#define XPAR_XIOMODULE_0_USE_FIT2 0x0
#define XPAR_XIOMODULE_0_USE_FIT3 0x0
#define XPAR_XIOMODULE_0_USE_FIT4 0x0
#define XPAR_XIOMODULE_0_USE_PIT1 0x1
#define XPAR_XIOMODULE_0_USE_PIT2 0x1
#define XPAR_XIOMODULE_0_USE_PIT3 0x1
#define XPAR_XIOMODULE_0_USE_PIT4 0x1
#define XPAR_XIOMODULE_0_USE_GPO1 0x1
#define XPAR_XIOMODULE_0_USE_GPO2 0x0
#define XPAR_XIOMODULE_0_USE_GPO3 0x0
#define XPAR_XIOMODULE_0_USE_GPO4 0x0
#define XPAR_XIOMODULE_0_USE_GPI1 0x0
#define XPAR_XIOMODULE_0_USE_GPI2 0x0
#define XPAR_XIOMODULE_0_USE_GPI3 0x0
#define XPAR_XIOMODULE_0_USE_GPI4 0x0
#define XPAR_XIOMODULE_0_USE_IO_BUS 0x0

#define XPAR_XIPIPSU_NUM_INSTANCES 2

/* Definitions for peripheral IPI_PMC */
#define XPAR_IPI_PMC_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_IPI_PMC_BASEADDR 0xeb320000
#define XPAR_IPI_PMC_HIGHADDR 0xeb32001f
#define XPAR_IPI_PMC_IPI_BITMASK 0x2
#define XPAR_IPI_PMC_IPI_BUF_INDEX 0x1
#define XPAR_IPI_PMC_INTERRUPTS 0x403b
#define XPAR_IPI_PMC_INTR 0x5b
#define XPAR_IPI_PMC_IPI_TARGET_COUNT 0x10
#define XPAR_IPI_PMC_0_IPI_BITMASK 0x1
#define XPAR_IPI_PMC_0_IPI_BUF_INDEX 0x0
#define XPAR_IPI_PMC_1_IPI_BITMASK 0x4
#define XPAR_IPI_PMC_1_IPI_BUF_INDEX 0x2
#define XPAR_IPI_PMC_2_IPI_BITMASK 0x8
#define XPAR_IPI_PMC_2_IPI_BUF_INDEX 0x3
#define XPAR_IPI_PMC_3_IPI_BITMASK 0x400
#define XPAR_IPI_PMC_3_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_4_IPI_BITMASK 0x10
#define XPAR_IPI_PMC_4_IPI_BUF_INDEX 0x4
#define XPAR_IPI_PMC_5_IPI_BITMASK 0x800
#define XPAR_IPI_PMC_5_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_6_IPI_BITMASK 0x20
#define XPAR_IPI_PMC_6_IPI_BUF_INDEX 0x5
#define XPAR_IPI_PMC_7_IPI_BITMASK 0x1000
#define XPAR_IPI_PMC_7_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_8_IPI_BITMASK 0x40
#define XPAR_IPI_PMC_8_IPI_BUF_INDEX 0x6
#define XPAR_IPI_PMC_9_IPI_BITMASK 0x2000
#define XPAR_IPI_PMC_9_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_10_IPI_BITMASK 0x80
#define XPAR_IPI_PMC_10_IPI_BUF_INDEX 0x7
#define XPAR_IPI_PMC_11_IPI_BITMASK 0x4000
#define XPAR_IPI_PMC_11_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_12_IPI_BITMASK 0x200
#define XPAR_IPI_PMC_12_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_13_IPI_BITMASK 0x8000
#define XPAR_IPI_PMC_13_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_14_IPI_BITMASK 0x2
#define XPAR_IPI_PMC_14_IPI_BUF_INDEX 0x1
#define XPAR_IPI_PMC_15_IPI_BITMASK 0x100
#define XPAR_IPI_PMC_15_IPI_BUF_INDEX 0xffff

/* Canonical definitions for peripheral IPI_PMC */
#define XPAR_XIPIPSU_0_BASEADDR 0xeb320000
#define XPAR_XIPIPSU_0_HIGHADDR 0xeb32001f
#define XPAR_XIPIPSU_0_INTR 0x5b
#define XPAR_XIPIPSU_0_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_XIPIPSU_0_IPI_BITMASK 0x2
#define XPAR_XIPIPSU_0_IPI_BUF_INDEX 0x1
#define XPAR_XIPIPSU_0_INTERRUPTS 0x403b
#define XPAR_XIPIPSU_0_IPI_TARGET_COUNT 0x10
#define XPAR_XIPIPSU_0_CH0_IPI_BITMASK 0x1
#define XPAR_XIPIPSU_0_CH0_IPI_BUF_INDEX 0x0
#define XPAR_XIPIPSU_0_CH1_IPI_BITMASK 0x4
#define XPAR_XIPIPSU_0_CH1_IPI_BUF_INDEX 0x2
#define XPAR_XIPIPSU_0_CH2_IPI_BITMASK 0x8
#define XPAR_XIPIPSU_0_CH2_IPI_BUF_INDEX 0x3
#define XPAR_XIPIPSU_0_CH3_IPI_BITMASK 0x400
#define XPAR_XIPIPSU_0_CH3_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH4_IPI_BITMASK 0x10
#define XPAR_XIPIPSU_0_CH4_IPI_BUF_INDEX 0x4
#define XPAR_XIPIPSU_0_CH5_IPI_BITMASK 0x800
#define XPAR_XIPIPSU_0_CH5_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH6_IPI_BITMASK 0x20
#define XPAR_XIPIPSU_0_CH6_IPI_BUF_INDEX 0x5
#define XPAR_XIPIPSU_0_CH7_IPI_BITMASK 0x1000
#define XPAR_XIPIPSU_0_CH7_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH8_IPI_BITMASK 0x40
#define XPAR_XIPIPSU_0_CH8_IPI_BUF_INDEX 0x6
#define XPAR_XIPIPSU_0_CH9_IPI_BITMASK 0x2000
#define XPAR_XIPIPSU_0_CH9_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH10_IPI_BITMASK 0x80
#define XPAR_XIPIPSU_0_CH10_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_0_CH11_IPI_BITMASK 0x4000
#define XPAR_XIPIPSU_0_CH11_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH12_IPI_BITMASK 0x200
#define XPAR_XIPIPSU_0_CH12_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH13_IPI_BITMASK 0x8000
#define XPAR_XIPIPSU_0_CH13_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH14_IPI_BITMASK 0x2
#define XPAR_XIPIPSU_0_CH14_IPI_BUF_INDEX 0x1
#define XPAR_XIPIPSU_0_CH15_IPI_BITMASK 0x100
#define XPAR_XIPIPSU_0_CH15_IPI_BUF_INDEX 0xffff

/* Definitions for peripheral IPI_PMC_NOBUF */
#define XPAR_IPI_PMC_NOBUF_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_IPI_PMC_NOBUF_BASEADDR 0xeb390000
#define XPAR_IPI_PMC_NOBUF_HIGHADDR 0xeb39001f
#define XPAR_IPI_PMC_NOBUF_IPI_BITMASK 0x100
#define XPAR_IPI_PMC_NOBUF_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_INTERRUPTS 0x403c
#define XPAR_IPI_PMC_NOBUF_INTR 0x5c
#define XPAR_IPI_PMC_NOBUF_IPI_TARGET_COUNT 0x10
#define XPAR_IPI_PMC_NOBUF_0_IPI_BITMASK 0x1
#define XPAR_IPI_PMC_NOBUF_0_IPI_BUF_INDEX 0x0
#define XPAR_IPI_PMC_NOBUF_1_IPI_BITMASK 0x4
#define XPAR_IPI_PMC_NOBUF_1_IPI_BUF_INDEX 0x2
#define XPAR_IPI_PMC_NOBUF_2_IPI_BITMASK 0x8
#define XPAR_IPI_PMC_NOBUF_2_IPI_BUF_INDEX 0x3
#define XPAR_IPI_PMC_NOBUF_3_IPI_BITMASK 0x400
#define XPAR_IPI_PMC_NOBUF_3_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_4_IPI_BITMASK 0x10
#define XPAR_IPI_PMC_NOBUF_4_IPI_BUF_INDEX 0x4
#define XPAR_IPI_PMC_NOBUF_5_IPI_BITMASK 0x800
#define XPAR_IPI_PMC_NOBUF_5_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_6_IPI_BITMASK 0x20
#define XPAR_IPI_PMC_NOBUF_6_IPI_BUF_INDEX 0x5
#define XPAR_IPI_PMC_NOBUF_7_IPI_BITMASK 0x1000
#define XPAR_IPI_PMC_NOBUF_7_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_8_IPI_BITMASK 0x40
#define XPAR_IPI_PMC_NOBUF_8_IPI_BUF_INDEX 0x6
#define XPAR_IPI_PMC_NOBUF_9_IPI_BITMASK 0x2000
#define XPAR_IPI_PMC_NOBUF_9_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_10_IPI_BITMASK 0x80
#define XPAR_IPI_PMC_NOBUF_10_IPI_BUF_INDEX 0x7
#define XPAR_IPI_PMC_NOBUF_11_IPI_BITMASK 0x4000
#define XPAR_IPI_PMC_NOBUF_11_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_12_IPI_BITMASK 0x200
#define XPAR_IPI_PMC_NOBUF_12_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_13_IPI_BITMASK 0x8000
#define XPAR_IPI_PMC_NOBUF_13_IPI_BUF_INDEX 0xffff
#define XPAR_IPI_PMC_NOBUF_14_IPI_BITMASK 0x2
#define XPAR_IPI_PMC_NOBUF_14_IPI_BUF_INDEX 0x1
#define XPAR_IPI_PMC_NOBUF_15_IPI_BITMASK 0x100
#define XPAR_IPI_PMC_NOBUF_15_IPI_BUF_INDEX 0xffff

/* Canonical definitions for peripheral IPI_PMC_NOBUF */
#define XPAR_XIPIPSU_1_BASEADDR 0xeb390000
#define XPAR_XIPIPSU_1_HIGHADDR 0xeb39001f
#define XPAR_XIPIPSU_1_INTR 0x5c
#define XPAR_XIPIPSU_1_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_XIPIPSU_1_IPI_BITMASK 0x100
#define XPAR_XIPIPSU_1_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_INTERRUPTS 0x403c
#define XPAR_XIPIPSU_1_IPI_TARGET_COUNT 0x10
#define XPAR_XIPIPSU_1_CH0_IPI_BITMASK 0x1
#define XPAR_XIPIPSU_1_CH0_IPI_BUF_INDEX 0x0
#define XPAR_XIPIPSU_1_CH1_IPI_BITMASK 0x4
#define XPAR_XIPIPSU_1_CH1_IPI_BUF_INDEX 0x2
#define XPAR_XIPIPSU_1_CH2_IPI_BITMASK 0x8
#define XPAR_XIPIPSU_1_CH2_IPI_BUF_INDEX 0x3
#define XPAR_XIPIPSU_1_CH3_IPI_BITMASK 0x400
#define XPAR_XIPIPSU_1_CH3_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH4_IPI_BITMASK 0x10
#define XPAR_XIPIPSU_1_CH4_IPI_BUF_INDEX 0x4
#define XPAR_XIPIPSU_1_CH5_IPI_BITMASK 0x800
#define XPAR_XIPIPSU_1_CH5_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH6_IPI_BITMASK 0x20
#define XPAR_XIPIPSU_1_CH6_IPI_BUF_INDEX 0x5
#define XPAR_XIPIPSU_1_CH7_IPI_BITMASK 0x1000
#define XPAR_XIPIPSU_1_CH7_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH8_IPI_BITMASK 0x40
#define XPAR_XIPIPSU_1_CH8_IPI_BUF_INDEX 0x6
#define XPAR_XIPIPSU_1_CH9_IPI_BITMASK 0x2000
#define XPAR_XIPIPSU_1_CH9_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH10_IPI_BITMASK 0x80
#define XPAR_XIPIPSU_1_CH10_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_1_CH11_IPI_BITMASK 0x4000
#define XPAR_XIPIPSU_1_CH11_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH12_IPI_BITMASK 0x200
#define XPAR_XIPIPSU_1_CH12_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH13_IPI_BITMASK 0x8000
#define XPAR_XIPIPSU_1_CH13_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_1_CH14_IPI_BITMASK 0x2
#define XPAR_XIPIPSU_1_CH14_IPI_BUF_INDEX 0x1
#define XPAR_XIPIPSU_1_CH15_IPI_BITMASK 0x100
#define XPAR_XIPIPSU_1_CH15_IPI_BUF_INDEX 0xffff

#define XPAR_XMMIDP_NUM_INSTANCES 1

/* Definitions for peripheral MMI_DPTX */
#define XPAR_MMI_DPTX_COMPATIBLE "amd,mmi-dptx-1.0"
#define XPAR_MMI_DPTX_BASEADDR 0xede00000
#define XPAR_MMI_DPTX_HIGHADDR 0xede3ffff
#define XPAR_MMI_DPTX_BASEADDR_1 0xedeb0000
#define XPAR_MMI_DPTX_REG_NAMES_0 1685061736
#define XPAR_MMI_DPTX_REG_NAMES_1 1684238336
#define XPAR_MMI_DPTX_INTERRUPTS 0x40b2
#define XPAR_MMI_DPTX_INTERRUPTS_1 0x40a7
#define XPAR_MMI_DPTX_INTERRUPT_NAMES "dptx"
#define XPAR_MMI_DPTX_DP_LANES 0x2

/* Canonical definitions for peripheral MMI_DPTX */
#define XPAR_XMMIDP_0_BASEADDR 0xede00000
#define XPAR_XMMIDP_0_HIGHADDR 0xede3ffff
#define XPAR_XMMIDP_0_COMPATIBLE "amd,mmi-dptx-1.0"
#define XPAR_XMMIDP_0_DP_LANES 0x2
#define XPAR_XMMIDP_0_INTERRUPTS 0x40b2
#define XPAR_XMMIDP_0_INTERRUPT_NAMES "dptx"
#define XPAR_XMMIDP_0_REG_NAMES_0 1685061736
#define XPAR_XMMIDP_0_REG_NAMES_1 1684238336

#define XPAR_XOSPIPSV_NUM_INSTANCES 1

/* Definitions for peripheral OSPI */
#define XPAR_OSPI_COMPATIBLE "amd,versal2-ospi"
#define XPAR_OSPI_BASEADDR 0xf1010000
#define XPAR_OSPI_HIGHADDR 0xf101ffff
#define XPAR_OSPI_BASEADDR_1 0xc0000000
#define XPAR_OSPI_OSPI_CLK_FREQ_HZ 0xbebba31
#define XPAR_OSPI_IS_CACHE_COHERENT 0x0
#define XPAR_OSPI_OSPI_MODE 0x0
#define XPAR_OSPI_INTERRUPTS 0x40d8
#define XPAR_OSPI_OSPI_BUS_WIDTH 0x8

/* Canonical definitions for peripheral OSPI */
#define XPAR_XOSPIPSV_0_BASEADDR 0xf1010000
#define XPAR_XOSPIPSV_0_HIGHADDR 0xf101ffff
#define XPAR_XOSPIPSV_0_COMPATIBLE "amd,versal2-ospi"
#define XPAR_XOSPIPSV_0_IS_CACHE_COHERENT 0x0
#define XPAR_XOSPIPSV_0_INTERRUPTS 0x40d8
#define XPAR_XOSPIPSV_0_OSPI_CLK_FREQ_HZ 0xbebba31
#define XPAR_XOSPIPSV_0_OSPI_MODE 0x0
#define XPAR_XOSPIPSV_0_OSPI_BUS_WIDTH 0x8

#define XPAR_XRTCPSU_NUM_INSTANCES 1

/* Definitions for peripheral RTC */
#define XPAR_RTC_COMPATIBLE "xlnx,zynqmp-rtc"
#define XPAR_RTC_BASEADDR 0xf12a0000
#define XPAR_RTC_HIGHADDR 0xf12a00ff
#define XPAR_RTC_INTERRUPTS 0x40c8
#define XPAR_RTC_INTERRUPTS_1 0x40c9

/* Canonical definitions for peripheral RTC */
#define XPAR_XRTCPSU_0_BASEADDR 0xf12a0000
#define XPAR_XRTCPSU_0_HIGHADDR 0xf12a00ff
#define XPAR_XRTCPSU_0_COMPATIBLE "xlnx,zynqmp-rtc"
#define XPAR_XRTCPSU_0_INTERRUPTS 0x40c8

#define XPAR_XSYSMONPSV_NUM_INSTANCES 1

/* Definitions for peripheral SYSMON0 */
#define XPAR_SYSMON0_COMPATIBLE "xlnx,versal-sysmon"
#define XPAR_SYSMON0_BASEADDR 0xf1270000
#define XPAR_SYSMON0_HIGHADDR 0xf1273fff

/* Canonical definitions for peripheral SYSMON0 */
#define XPAR_XSYSMONPSV_0_BASEADDR 0xf1270000
#define XPAR_XSYSMONPSV_0_HIGHADDR 0xf1273fff
#define XPAR_XSYSMONPSV_0_COMPATIBLE "xlnx,versal-sysmon"

#define XPAR_TMR_INJECT_NUM_INSTANCES 1

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0_COMPATIBLE "xlnx,tmr-inject-11.0"
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0_BASEADDR 0xf0083000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0_HIGHADDR 0xf0083fff
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0_MAGIC 0x27
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0_CPU_ID 0x1
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0_MASK 0x84000

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_TMR_INJECT_0 */
#define XPAR_TMR_INJECT_0_BASEADDR 0xf0083000
#define XPAR_TMR_INJECT_0_HIGHADDR 0xf0083fff
#define XPAR_TMR_INJECT_0_COMPATIBLE "xlnx,tmr-inject-11.0"
#define XPAR_TMR_INJECT_0_CPU_ID 0x1
#define XPAR_TMR_INJECT_0_MAGIC 0x27
#define XPAR_TMR_INJECT_0_MASK 0x84000

#define XPAR_TMR_MANAGER_NUM_INSTANCES 1

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_COMPATIBLE "xlnx,tmr-manager-11.0"
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_BASEADDR 0xf0303000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_HIGHADDR 0xf0303fff
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_BRK_DELAY_RST_VALUE 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_MASK_RST_VALUE 0xffffffffffffffff
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_MAGIC1 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_MAGIC2 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_UE_IS_FATAL 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_UE_WIDTH 0x3
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_NO_OF_COMPARATORS 0x1
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_COMPARATORS_MASK 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_WATCHDOG 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_WATCHDOG_WIDTH 0x1e
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_SEM_INTERFACE 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG_WIDTH 0xa
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_BRK_DELAY_WIDTH 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_TMR 0x1
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_TEST_COMPARATOR 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_STRICT_MISCOMPARE 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_USE_DEBUG_DISABLE 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_USE_TMR_DISABLE 0x0
#define XPAR_PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0_MASK 0x83000

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_TMR_MANAGER_0 */
#define XPAR_TMR_MANAGER_0_BASEADDR 0xf0303000
#define XPAR_TMR_MANAGER_0_HIGHADDR 0xf0303fff
#define XPAR_TMR_MANAGER_0_BRK_DELAY_RST_VALUE 0x0
#define XPAR_TMR_MANAGER_0_BRK_DELAY_WIDTH 0x0
#define XPAR_TMR_MANAGER_0_COMPATIBLE "xlnx,tmr-manager-11.0"
#define XPAR_TMR_MANAGER_0_COMPARATORS_MASK 0x0
#define XPAR_TMR_MANAGER_0_MASK_RST_VALUE 0xffffffffffffffff
#define XPAR_TMR_MANAGER_0_MAGIC1 0x0
#define XPAR_TMR_MANAGER_0_MAGIC2 0x0
#define XPAR_TMR_MANAGER_0_MASK 0x83000
#define XPAR_TMR_MANAGER_0_NO_OF_COMPARATORS 0x1
#define XPAR_TMR_MANAGER_0_SEM_INTERFACE 0x0
#define XPAR_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG 0x0
#define XPAR_TMR_MANAGER_0_SEM_HEARTBEAT_WATCHDOG_WIDTH 0xa
#define XPAR_TMR_MANAGER_0_STRICT_MISCOMPARE 0x0
#define XPAR_TMR_MANAGER_0_TMR 0x1
#define XPAR_TMR_MANAGER_0_TEST_COMPARATOR 0x0
#define XPAR_TMR_MANAGER_0_UE_IS_FATAL 0x0
#define XPAR_TMR_MANAGER_0_UE_WIDTH 0x3
#define XPAR_TMR_MANAGER_0_USE_DEBUG_DISABLE 0x0
#define XPAR_TMR_MANAGER_0_USE_TMR_DISABLE 0x0
#define XPAR_TMR_MANAGER_0_WATCHDOG 0x0
#define XPAR_TMR_MANAGER_0_WATCHDOG_WIDTH 0x1e

#define XPAR_XTRNGPSX_NUM_INSTANCES 1

/* Definitions for peripheral PMC_TRNG */
#define XPAR_PMC_TRNG_COMPATIBLE "xlnx,pmc-trng-11.0"
#define XPAR_PMC_TRNG_BASEADDR 0xf1230000
#define XPAR_PMC_TRNG_HIGHADDR 0xf123ffff

/* Canonical definitions for peripheral PMC_TRNG */
#define XPAR_XTRNGPSX_0_BASEADDR 0xf1230000
#define XPAR_XTRNGPSX_0_HIGHADDR 0xf123ffff
#define XPAR_XTRNGPSX_0_COMPATIBLE "xlnx,pmc-trng-11.0"

#define XPAR_XTTCPS_NUM_INSTANCES 8

/* Definitions for peripheral TTC0 */
#define XPAR_TTC0_COMPATIBLE "cdns,ttc"
#define XPAR_TTC0_BASEADDR 0xf1e60000
#define XPAR_TTC0_HIGHADDR 0xf1e60fff
#define XPAR_TTC0_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC0_INTERRUPTS 0x402b
#define XPAR_TTC0_INTERRUPTS_1 0x402b
#define XPAR_TTC0_INTERRUPTS_2 0x402b
#define XPAR_TTC0_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC0 */
#define XPAR_XTTCPS_0_BASEADDR 0xf1e60000
#define XPAR_XTTCPS_0_HIGHADDR 0xf1e60fff
#define XPAR_XTTCPS_0_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_0_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_0_INTERRUPTS 0x402b
#define XPAR_XTTCPS_0_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC1 */
#define XPAR_TTC1_COMPATIBLE "cdns,ttc"
#define XPAR_TTC1_BASEADDR 0xf1e70000
#define XPAR_TTC1_HIGHADDR 0xf1e70fff
#define XPAR_TTC1_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC1_INTERRUPTS 0x402c
#define XPAR_TTC1_INTERRUPTS_1 0x402c
#define XPAR_TTC1_INTERRUPTS_2 0x402c
#define XPAR_TTC1_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC1 */
#define XPAR_XTTCPS_1_BASEADDR 0xf1e70000
#define XPAR_XTTCPS_1_HIGHADDR 0xf1e70fff
#define XPAR_XTTCPS_1_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_1_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_1_INTERRUPTS 0x402c
#define XPAR_XTTCPS_1_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC2 */
#define XPAR_TTC2_COMPATIBLE "cdns,ttc"
#define XPAR_TTC2_BASEADDR 0xf1e80000
#define XPAR_TTC2_HIGHADDR 0xf1e80fff
#define XPAR_TTC2_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC2_INTERRUPTS 0x402d
#define XPAR_TTC2_INTERRUPTS_1 0x402d
#define XPAR_TTC2_INTERRUPTS_2 0x402d
#define XPAR_TTC2_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC2 */
#define XPAR_XTTCPS_2_BASEADDR 0xf1e80000
#define XPAR_XTTCPS_2_HIGHADDR 0xf1e80fff
#define XPAR_XTTCPS_2_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_2_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_2_INTERRUPTS 0x402d
#define XPAR_XTTCPS_2_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC3 */
#define XPAR_TTC3_COMPATIBLE "cdns,ttc"
#define XPAR_TTC3_BASEADDR 0xf1e90000
#define XPAR_TTC3_HIGHADDR 0xf1e90fff
#define XPAR_TTC3_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC3_INTERRUPTS 0x402e
#define XPAR_TTC3_INTERRUPTS_1 0x402e
#define XPAR_TTC3_INTERRUPTS_2 0x402e
#define XPAR_TTC3_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC3 */
#define XPAR_XTTCPS_3_BASEADDR 0xf1e90000
#define XPAR_XTTCPS_3_HIGHADDR 0xf1e90fff
#define XPAR_XTTCPS_3_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_3_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_3_INTERRUPTS 0x402e
#define XPAR_XTTCPS_3_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC4 */
#define XPAR_TTC4_COMPATIBLE "cdns,ttc"
#define XPAR_TTC4_BASEADDR 0xf1ea0000
#define XPAR_TTC4_HIGHADDR 0xf1ea0fff
#define XPAR_TTC4_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC4_INTERRUPTS 0x402f
#define XPAR_TTC4_INTERRUPTS_1 0x402f
#define XPAR_TTC4_INTERRUPTS_2 0x402f
#define XPAR_TTC4_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC4 */
#define XPAR_XTTCPS_4_BASEADDR 0xf1ea0000
#define XPAR_XTTCPS_4_HIGHADDR 0xf1ea0fff
#define XPAR_XTTCPS_4_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_4_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_4_INTERRUPTS 0x402f
#define XPAR_XTTCPS_4_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC5 */
#define XPAR_TTC5_COMPATIBLE "cdns,ttc"
#define XPAR_TTC5_BASEADDR 0xf1eb0000
#define XPAR_TTC5_HIGHADDR 0xf1eb0fff
#define XPAR_TTC5_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC5_INTERRUPTS 0x4030
#define XPAR_TTC5_INTERRUPTS_1 0x4030
#define XPAR_TTC5_INTERRUPTS_2 0x4030
#define XPAR_TTC5_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC5 */
#define XPAR_XTTCPS_5_BASEADDR 0xf1eb0000
#define XPAR_XTTCPS_5_HIGHADDR 0xf1eb0fff
#define XPAR_XTTCPS_5_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_5_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_5_INTERRUPTS 0x4030
#define XPAR_XTTCPS_5_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC6 */
#define XPAR_TTC6_COMPATIBLE "cdns,ttc"
#define XPAR_TTC6_BASEADDR 0xf1ec0000
#define XPAR_TTC6_HIGHADDR 0xf1ec0fff
#define XPAR_TTC6_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC6_INTERRUPTS 0x4031
#define XPAR_TTC6_INTERRUPTS_1 0x4031
#define XPAR_TTC6_INTERRUPTS_2 0x4031
#define XPAR_TTC6_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC6 */
#define XPAR_XTTCPS_6_BASEADDR 0xf1ec0000
#define XPAR_XTTCPS_6_HIGHADDR 0xf1ec0fff
#define XPAR_XTTCPS_6_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_6_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_6_INTERRUPTS 0x4031
#define XPAR_XTTCPS_6_TTC_CLK0_CLKSRC "APB"

/* Definitions for peripheral TTC7 */
#define XPAR_TTC7_COMPATIBLE "cdns,ttc"
#define XPAR_TTC7_BASEADDR 0xf1ed0000
#define XPAR_TTC7_HIGHADDR 0xf1ed0fff
#define XPAR_TTC7_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC7_INTERRUPTS 0x4032
#define XPAR_TTC7_INTERRUPTS_1 0x4032
#define XPAR_TTC7_INTERRUPTS_2 0x4032
#define XPAR_TTC7_TTC_CLK0_CLKSRC "APB"

/* Canonical definitions for peripheral TTC7 */
#define XPAR_XTTCPS_7_BASEADDR 0xf1ed0000
#define XPAR_XTTCPS_7_HIGHADDR 0xf1ed0fff
#define XPAR_XTTCPS_7_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_7_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_7_INTERRUPTS 0x4032
#define XPAR_XTTCPS_7_TTC_CLK0_CLKSRC "APB"

#define XPAR_XUARTPSV_NUM_INSTANCES 2

/* Definitions for peripheral SERIAL0 */
#define XPAR_SERIAL0_COMPATIBLE "arm,pl011"
#define XPAR_SERIAL0_BASEADDR 0xf1920000
#define XPAR_SERIAL0_HIGHADDR 0xf1920fff
#define XPAR_SERIAL0_CLOCK_FREQ 0x5f5dd19
#define XPAR_SERIAL0_BAUDRATE 0x1c200
#define XPAR_SERIAL0_INTERRUPTS 0x4019

/* Canonical definitions for peripheral SERIAL0 */
#define XPAR_XUARTPSV_0_BASEADDR 0xf1920000
#define XPAR_XUARTPSV_0_HIGHADDR 0xf1920fff
#define XPAR_XUARTPSV_0_BAUDRATE 0x1c200
#define XPAR_XUARTPSV_0_COMPATIBLE "arm,pl011"
#define XPAR_XUARTPSV_0_CLOCK_FREQ 0x5f5dd19
#define XPAR_XUARTPSV_0_INTERRUPTS 0x4019

/* Definitions for peripheral SERIAL1 */
#define XPAR_SERIAL1_COMPATIBLE "arm,pl011"
#define XPAR_SERIAL1_BASEADDR 0xf1930000
#define XPAR_SERIAL1_HIGHADDR 0xf1930fff
#define XPAR_SERIAL1_CLOCK_FREQ 0x5f5dd19
#define XPAR_SERIAL1_BAUDRATE 0x1c200
#define XPAR_SERIAL1_INTERRUPTS 0x401a

/* Canonical definitions for peripheral SERIAL1 */
#define XPAR_XUARTPSV_1_BASEADDR 0xf1930000
#define XPAR_XUARTPSV_1_HIGHADDR 0xf1930fff
#define XPAR_XUARTPSV_1_BAUDRATE 0x1c200
#define XPAR_XUARTPSV_1_COMPATIBLE "arm,pl011"
#define XPAR_XUARTPSV_1_CLOCK_FREQ 0x5f5dd19
#define XPAR_XUARTPSV_1_INTERRUPTS 0x401a

#define XPAR_XUFSPSXC_NUM_INSTANCES 1

/* Definitions for peripheral UFSHC */
#define XPAR_UFSHC_COMPATIBLE "amd,versal2-ufs"
#define XPAR_UFSHC_BASEADDR 0xf10b0000
#define XPAR_UFSHC_HIGHADDR 0xf10b00ff
#define XPAR_UFSHC_CLK_FREQ_HZ 0x11e19751
#define XPAR_UFSHC_CFG_CLK_FREQ_HZ 0x18cba80
#define XPAR_UFSHC_REF_PAD_CLK_FREQ_HZ 0x18cba80
#define XPAR_UFSHC_IS_CACHE_COHERENT 0x0
#define XPAR_UFSHC_INTERRUPTS 0x40ea

/* Canonical definitions for peripheral UFSHC */
#define XPAR_XUFSPSXC_0_BASEADDR 0xf10b0000
#define XPAR_XUFSPSXC_0_HIGHADDR 0xf10b00ff
#define XPAR_XUFSPSXC_0_COMPATIBLE "amd,versal2-ufs"
#define XPAR_XUFSPSXC_0_CLK_FREQ_HZ 0x11e19751
#define XPAR_XUFSPSXC_0_CFG_CLK_FREQ_HZ 0x18cba80
#define XPAR_XUFSPSXC_0_IS_CACHE_COHERENT 0x0
#define XPAR_XUFSPSXC_0_INTERRUPTS 0x40ea
#define XPAR_XUFSPSXC_0_REF_PAD_CLK_FREQ_HZ 0x18cba80

#define XPAR_XUSBPSU_NUM_INSTANCES 2

/* Definitions for peripheral DWC3_1 */
#define XPAR_DWC3_1_COMPATIBLE "snps,dwc3"
#define XPAR_DWC3_1_BASEADDR 0xf1c00000
#define XPAR_DWC3_1_HIGHADDR 0xf1c0ffff
#define XPAR_DWC3_1_DMA_COHERENT 0x1
#define XPAR_DWC3_1_INTERRUPTS 0x4022
#define XPAR_DWC3_1_INTERRUPTS_1 0x4022
#define XPAR_DWC3_1_INTERRUPTS_2 0x4026
#define XPAR_DWC3_1_INTERRUPTS_3 0x4063

/* Canonical definitions for peripheral DWC3_1 */
#define XPAR_XUSBPSU_0_BASEADDR 0xf1c00000
#define XPAR_XUSBPSU_0_HIGHADDR 0xf1c0ffff
#define XPAR_XUSBPSU_0_COMPATIBLE "snps,dwc3"
#define XPAR_XUSBPSU_0_DMA_COHERENT 0x1
#define XPAR_XUSBPSU_0_INTERRUPTS 0x4022

/* Definitions for peripheral MMI_DWC3 */
#define XPAR_MMI_DWC3_COMPATIBLE "snps,dwc3"
#define XPAR_MMI_DWC3_BASEADDR 0xedec0000
#define XPAR_MMI_DWC3_HIGHADDR 0xedecffff
#define XPAR_MMI_DWC3_INTERRUPTS 0x40bf
#define XPAR_MMI_DWC3_INTERRUPTS_1 0x40bf

/* Canonical definitions for peripheral MMI_DWC3 */
#define XPAR_XUSBPSU_1_BASEADDR 0xedec0000
#define XPAR_XUSBPSU_1_HIGHADDR 0xedecffff
#define XPAR_XUSBPSU_1_COMPATIBLE "snps,dwc3"
#define XPAR_XUSBPSU_1_INTERRUPTS 0x40bf

#define XPAR_XXDMAPCIE_NUM_INSTANCES 1

/* Definitions for peripheral MDB_PCIE0 */
#define XPAR_MDB_PCIE0_COMPATIBLE "amd,versal2-mdb-host"
#define XPAR_MDB_PCIE0_BASEADDR 0xed931000
#define XPAR_MDB_PCIE0_HIGHADDR 0xed932fff
#define XPAR_MDB_PCIE0_BASEADDR_1 0x100000100000
#define XPAR_MDB_PCIE0_BASEADDR_2 0x100000000000
#define XPAR_MDB_PCIE0_BASEADDR_3 0xed860000
#define XPAR_MDB_PCIE0_NUM_OF_BARS 0x2
#define XPAR_MDB_PCIE0_PORT_TYPE 0x1
#define XPAR_MDB_PCIE0_IATU_ADDRESS 0xed860000
#define XPAR_MDB_PCIE0_CSR_SLCR 0x100000000000
#define XPAR_MDB_PCIE0_RANGES_BASEADDR_0 0xa0000000
#define XPAR_MDB_PCIE0_RANGES_HIGHADDR_0 0xa7ffffff
#define XPAR_MDB_PCIE0_RANGES_BASEADDR_1 0x110000000000
#define XPAR_MDB_PCIE0_RANGES_HIGHADDR_1 0x11ffffffffff

/* Canonical definitions for peripheral MDB_PCIE0 */
#define XPAR_XXDMAPCIE_0_BASEADDR 0xed931000
#define XPAR_XXDMAPCIE_0_HIGHADDR 0xed932fff
#define XPAR_XXDMAPCIE_0_COMPATIBLE "amd,versal2-mdb-host"
#define XPAR_XXDMAPCIE_0_CSR_SLCR 0x100000000000
#define XPAR_XXDMAPCIE_0_IATU_ADDRESS 0xed860000
#define XPAR_XXDMAPCIE_0_NUM_OF_BARS 0x2
#define XPAR_XXDMAPCIE_0_PORT_TYPE 0x1
#define XPAR_XXDMAPCIE_0_RANGES_BASEADDR_0 0xa0000000
#define XPAR_XXDMAPCIE_0_RANGES_HIGHADDR_0 0xa7ffffff
#define XPAR_XXDMAPCIE_0_RANGES_BASEADDR_1 0x110000000000
#define XPAR_XXDMAPCIE_0_RANGES_HIGHADDR_1 0x11ffffffffff

#define XPAR_XZDMA_NUM_INSTANCES 8

/* Definitions for peripheral ADMA0 */
#define XPAR_ADMA0_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA0_BASEADDR 0xebd00000
#define XPAR_ADMA0_HIGHADDR 0xebd00fff
#define XPAR_ADMA0_DMA_MODE 0x1
#define XPAR_ADMA0_DMA_COHERENT 0x1
#define XPAR_ADMA0_INTERRUPTS 0x4048

/* Canonical definitions for peripheral ADMA0 */
#define XPAR_XZDMA_0_BASEADDR 0xebd00000
#define XPAR_XZDMA_0_HIGHADDR 0xebd00fff
#define XPAR_XZDMA_0_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_0_DMA_MODE 0x1
#define XPAR_XZDMA_0_DMA_COHERENT 0x1
#define XPAR_XZDMA_0_INTERRUPTS 0x4048

/* Definitions for peripheral ADMA1 */
#define XPAR_ADMA1_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA1_BASEADDR 0xebd10000
#define XPAR_ADMA1_HIGHADDR 0xebd10fff
#define XPAR_ADMA1_DMA_MODE 0x1
#define XPAR_ADMA1_DMA_COHERENT 0x1
#define XPAR_ADMA1_INTERRUPTS 0x4049

/* Canonical definitions for peripheral ADMA1 */
#define XPAR_XZDMA_1_BASEADDR 0xebd10000
#define XPAR_XZDMA_1_HIGHADDR 0xebd10fff
#define XPAR_XZDMA_1_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_1_DMA_MODE 0x1
#define XPAR_XZDMA_1_DMA_COHERENT 0x1
#define XPAR_XZDMA_1_INTERRUPTS 0x4049

/* Definitions for peripheral ADMA2 */
#define XPAR_ADMA2_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA2_BASEADDR 0xebd20000
#define XPAR_ADMA2_HIGHADDR 0xebd20fff
#define XPAR_ADMA2_DMA_MODE 0x1
#define XPAR_ADMA2_DMA_COHERENT 0x1
#define XPAR_ADMA2_INTERRUPTS 0x404a

/* Canonical definitions for peripheral ADMA2 */
#define XPAR_XZDMA_2_BASEADDR 0xebd20000
#define XPAR_XZDMA_2_HIGHADDR 0xebd20fff
#define XPAR_XZDMA_2_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_2_DMA_MODE 0x1
#define XPAR_XZDMA_2_DMA_COHERENT 0x1
#define XPAR_XZDMA_2_INTERRUPTS 0x404a

/* Definitions for peripheral ADMA3 */
#define XPAR_ADMA3_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA3_BASEADDR 0xebd30000
#define XPAR_ADMA3_HIGHADDR 0xebd30fff
#define XPAR_ADMA3_DMA_MODE 0x1
#define XPAR_ADMA3_DMA_COHERENT 0x1
#define XPAR_ADMA3_INTERRUPTS 0x404b

/* Canonical definitions for peripheral ADMA3 */
#define XPAR_XZDMA_3_BASEADDR 0xebd30000
#define XPAR_XZDMA_3_HIGHADDR 0xebd30fff
#define XPAR_XZDMA_3_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_3_DMA_MODE 0x1
#define XPAR_XZDMA_3_DMA_COHERENT 0x1
#define XPAR_XZDMA_3_INTERRUPTS 0x404b

/* Definitions for peripheral ADMA4 */
#define XPAR_ADMA4_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA4_BASEADDR 0xebd40000
#define XPAR_ADMA4_HIGHADDR 0xebd40fff
#define XPAR_ADMA4_DMA_MODE 0x1
#define XPAR_ADMA4_DMA_COHERENT 0x1
#define XPAR_ADMA4_INTERRUPTS 0x404c

/* Canonical definitions for peripheral ADMA4 */
#define XPAR_XZDMA_4_BASEADDR 0xebd40000
#define XPAR_XZDMA_4_HIGHADDR 0xebd40fff
#define XPAR_XZDMA_4_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_4_DMA_MODE 0x1
#define XPAR_XZDMA_4_DMA_COHERENT 0x1
#define XPAR_XZDMA_4_INTERRUPTS 0x404c

/* Definitions for peripheral ADMA5 */
#define XPAR_ADMA5_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA5_BASEADDR 0xebd50000
#define XPAR_ADMA5_HIGHADDR 0xebd50fff
#define XPAR_ADMA5_DMA_MODE 0x1
#define XPAR_ADMA5_DMA_COHERENT 0x1
#define XPAR_ADMA5_INTERRUPTS 0x404d

/* Canonical definitions for peripheral ADMA5 */
#define XPAR_XZDMA_5_BASEADDR 0xebd50000
#define XPAR_XZDMA_5_HIGHADDR 0xebd50fff
#define XPAR_XZDMA_5_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_5_DMA_MODE 0x1
#define XPAR_XZDMA_5_DMA_COHERENT 0x1
#define XPAR_XZDMA_5_INTERRUPTS 0x404d

/* Definitions for peripheral ADMA6 */
#define XPAR_ADMA6_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA6_BASEADDR 0xebd60000
#define XPAR_ADMA6_HIGHADDR 0xebd60fff
#define XPAR_ADMA6_DMA_MODE 0x1
#define XPAR_ADMA6_DMA_COHERENT 0x1
#define XPAR_ADMA6_INTERRUPTS 0x404e

/* Canonical definitions for peripheral ADMA6 */
#define XPAR_XZDMA_6_BASEADDR 0xebd60000
#define XPAR_XZDMA_6_HIGHADDR 0xebd60fff
#define XPAR_XZDMA_6_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_6_DMA_MODE 0x1
#define XPAR_XZDMA_6_DMA_COHERENT 0x1
#define XPAR_XZDMA_6_INTERRUPTS 0x404e

/* Definitions for peripheral ADMA7 */
#define XPAR_ADMA7_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_ADMA7_BASEADDR 0xebd70000
#define XPAR_ADMA7_HIGHADDR 0xebd70fff
#define XPAR_ADMA7_DMA_MODE 0x1
#define XPAR_ADMA7_DMA_COHERENT 0x1
#define XPAR_ADMA7_INTERRUPTS 0x404f

/* Canonical definitions for peripheral ADMA7 */
#define XPAR_XZDMA_7_BASEADDR 0xebd70000
#define XPAR_XZDMA_7_HIGHADDR 0xebd70fff
#define XPAR_XZDMA_7_COMPATIBLE "amd,versal2-dma-1.0"
#define XPAR_XZDMA_7_DMA_MODE 0x1
#define XPAR_XZDMA_7_DMA_COHERENT 0x1
#define XPAR_XZDMA_7_INTERRUPTS 0x404f

/* Definitions for peripheral MMI_DCDMA */
#define XPAR_MMI_DCDMA_BASEADDR 0xedd10000
#define XPAR_MMI_DCDMA_HIGHADDR 0xedd10fff

/* Definitions for peripheral USB1 */
#define XPAR_USB1_BASEADDR 0xf1ef0000
#define XPAR_USB1_HIGHADDR 0xf1ef00ff

/* Canonical definitions for peripheral USB1 */
#define XPAR_USB_0_BASEADDR 0xf1ef0000
#define XPAR_USB_0_HIGHADDR 0xf1ef00ff

/* Definitions for peripheral R52_0A_ATCM_GLOBAL */
#define XPAR_R52_0A_ATCM_GLOBAL_BASEADDR 0xeba00000
#define XPAR_R52_0A_ATCM_GLOBAL_HIGHADDR 0xeba0ffff

/* Canonical definitions for peripheral R52_0A_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_0_BASEADDR 0xeba00000
#define XPAR_R52_ATCM_GLOBAL_0_HIGHADDR 0xeba0ffff

/* Definitions for peripheral R52_0A_BTCM_GLOBAL */
#define XPAR_R52_0A_BTCM_GLOBAL_BASEADDR 0xeba10000
#define XPAR_R52_0A_BTCM_GLOBAL_HIGHADDR 0xeba17fff

/* Canonical definitions for peripheral R52_0A_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_0_BASEADDR 0xeba10000
#define XPAR_R52_BTCM_GLOBAL_0_HIGHADDR 0xeba17fff

/* Definitions for peripheral R52_0A_CTCM_GLOBAL */
#define XPAR_R52_0A_CTCM_GLOBAL_BASEADDR 0xeba20000
#define XPAR_R52_0A_CTCM_GLOBAL_HIGHADDR 0xeba27fff

/* Canonical definitions for peripheral R52_0A_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_0_BASEADDR 0xeba20000
#define XPAR_R52_CTCM_GLOBAL_0_HIGHADDR 0xeba27fff

/* Definitions for peripheral R52_0B_ATCM_GLOBAL */
#define XPAR_R52_0B_ATCM_GLOBAL_BASEADDR 0xeba80000
#define XPAR_R52_0B_ATCM_GLOBAL_HIGHADDR 0xeba8ffff

/* Canonical definitions for peripheral R52_0B_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_1_BASEADDR 0xeba80000
#define XPAR_R52_ATCM_GLOBAL_1_HIGHADDR 0xeba8ffff

/* Definitions for peripheral R52_0B_BTCM_GLOBAL */
#define XPAR_R52_0B_BTCM_GLOBAL_BASEADDR 0xeba90000
#define XPAR_R52_0B_BTCM_GLOBAL_HIGHADDR 0xeba97fff

/* Canonical definitions for peripheral R52_0B_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_1_BASEADDR 0xeba90000
#define XPAR_R52_BTCM_GLOBAL_1_HIGHADDR 0xeba97fff

/* Definitions for peripheral R52_0B_CTCM_GLOBAL */
#define XPAR_R52_0B_CTCM_GLOBAL_BASEADDR 0xebaa0000
#define XPAR_R52_0B_CTCM_GLOBAL_HIGHADDR 0xebaa7fff

/* Canonical definitions for peripheral R52_0B_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_1_BASEADDR 0xebaa0000
#define XPAR_R52_CTCM_GLOBAL_1_HIGHADDR 0xebaa7fff

/* Definitions for peripheral R52_0C_ATCM_GLOBAL */
#define XPAR_R52_0C_ATCM_GLOBAL_BASEADDR 0xebb00000
#define XPAR_R52_0C_ATCM_GLOBAL_HIGHADDR 0xebb0ffff

/* Canonical definitions for peripheral R52_0C_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_2_BASEADDR 0xebb00000
#define XPAR_R52_ATCM_GLOBAL_2_HIGHADDR 0xebb0ffff

/* Definitions for peripheral R52_0C_BTCM_GLOBAL */
#define XPAR_R52_0C_BTCM_GLOBAL_BASEADDR 0xebb10000
#define XPAR_R52_0C_BTCM_GLOBAL_HIGHADDR 0xebb17fff

/* Canonical definitions for peripheral R52_0C_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_2_BASEADDR 0xebb10000
#define XPAR_R52_BTCM_GLOBAL_2_HIGHADDR 0xebb17fff

/* Definitions for peripheral R52_0C_CTCM_GLOBAL */
#define XPAR_R52_0C_CTCM_GLOBAL_BASEADDR 0xebb20000
#define XPAR_R52_0C_CTCM_GLOBAL_HIGHADDR 0xebb27fff

/* Canonical definitions for peripheral R52_0C_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_2_BASEADDR 0xebb20000
#define XPAR_R52_CTCM_GLOBAL_2_HIGHADDR 0xebb27fff

/* Definitions for peripheral R52_0D_ATCM_GLOBAL */
#define XPAR_R52_0D_ATCM_GLOBAL_BASEADDR 0xebb80000
#define XPAR_R52_0D_ATCM_GLOBAL_HIGHADDR 0xebb8ffff

/* Canonical definitions for peripheral R52_0D_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_3_BASEADDR 0xebb80000
#define XPAR_R52_ATCM_GLOBAL_3_HIGHADDR 0xebb8ffff

/* Definitions for peripheral R52_0D_BTCM_GLOBAL */
#define XPAR_R52_0D_BTCM_GLOBAL_BASEADDR 0xebb90000
#define XPAR_R52_0D_BTCM_GLOBAL_HIGHADDR 0xebb97fff

/* Canonical definitions for peripheral R52_0D_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_3_BASEADDR 0xebb90000
#define XPAR_R52_BTCM_GLOBAL_3_HIGHADDR 0xebb97fff

/* Definitions for peripheral R52_0D_CTCM_GLOBAL */
#define XPAR_R52_0D_CTCM_GLOBAL_BASEADDR 0xebba0000
#define XPAR_R52_0D_CTCM_GLOBAL_HIGHADDR 0xebba7fff

/* Canonical definitions for peripheral R52_0D_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_3_BASEADDR 0xebba0000
#define XPAR_R52_CTCM_GLOBAL_3_HIGHADDR 0xebba7fff

/* Definitions for peripheral R52_0E_ATCM_GLOBAL */
#define XPAR_R52_0E_ATCM_GLOBAL_BASEADDR 0xebc00000
#define XPAR_R52_0E_ATCM_GLOBAL_HIGHADDR 0xebc0ffff

/* Canonical definitions for peripheral R52_0E_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_4_BASEADDR 0xebc00000
#define XPAR_R52_ATCM_GLOBAL_4_HIGHADDR 0xebc0ffff

/* Definitions for peripheral R52_0E_BTCM_GLOBAL */
#define XPAR_R52_0E_BTCM_GLOBAL_BASEADDR 0xebc10000
#define XPAR_R52_0E_BTCM_GLOBAL_HIGHADDR 0xebc17fff

/* Canonical definitions for peripheral R52_0E_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_4_BASEADDR 0xebc10000
#define XPAR_R52_BTCM_GLOBAL_4_HIGHADDR 0xebc17fff

/* Definitions for peripheral R52_0E_CTCM_GLOBAL */
#define XPAR_R52_0E_CTCM_GLOBAL_BASEADDR 0xebc20000
#define XPAR_R52_0E_CTCM_GLOBAL_HIGHADDR 0xebc27fff

/* Canonical definitions for peripheral R52_0E_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_4_BASEADDR 0xebc20000
#define XPAR_R52_CTCM_GLOBAL_4_HIGHADDR 0xebc27fff

/* Definitions for peripheral R52_1A_ATCM_GLOBAL */
#define XPAR_R52_1A_ATCM_GLOBAL_BASEADDR 0xeba40000
#define XPAR_R52_1A_ATCM_GLOBAL_HIGHADDR 0xeba4ffff

/* Canonical definitions for peripheral R52_1A_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_5_BASEADDR 0xeba40000
#define XPAR_R52_ATCM_GLOBAL_5_HIGHADDR 0xeba4ffff

/* Definitions for peripheral R52_1A_BTCM_GLOBAL */
#define XPAR_R52_1A_BTCM_GLOBAL_BASEADDR 0xeba50000
#define XPAR_R52_1A_BTCM_GLOBAL_HIGHADDR 0xeba57fff

/* Canonical definitions for peripheral R52_1A_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_5_BASEADDR 0xeba50000
#define XPAR_R52_BTCM_GLOBAL_5_HIGHADDR 0xeba57fff

/* Definitions for peripheral R52_1A_CTCM_GLOBAL */
#define XPAR_R52_1A_CTCM_GLOBAL_BASEADDR 0xeba60000
#define XPAR_R52_1A_CTCM_GLOBAL_HIGHADDR 0xeba67fff

/* Canonical definitions for peripheral R52_1A_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_5_BASEADDR 0xeba60000
#define XPAR_R52_CTCM_GLOBAL_5_HIGHADDR 0xeba67fff

/* Definitions for peripheral R52_1B_ATCM_GLOBAL */
#define XPAR_R52_1B_ATCM_GLOBAL_BASEADDR 0xebac0000
#define XPAR_R52_1B_ATCM_GLOBAL_HIGHADDR 0xebacffff

/* Canonical definitions for peripheral R52_1B_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_6_BASEADDR 0xebac0000
#define XPAR_R52_ATCM_GLOBAL_6_HIGHADDR 0xebacffff

/* Definitions for peripheral R52_1B_BTCM_GLOBAL */
#define XPAR_R52_1B_BTCM_GLOBAL_BASEADDR 0xebad0000
#define XPAR_R52_1B_BTCM_GLOBAL_HIGHADDR 0xebad7fff

/* Canonical definitions for peripheral R52_1B_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_6_BASEADDR 0xebad0000
#define XPAR_R52_BTCM_GLOBAL_6_HIGHADDR 0xebad7fff

/* Definitions for peripheral R52_1B_CTCM_GLOBAL */
#define XPAR_R52_1B_CTCM_GLOBAL_BASEADDR 0xebae0000
#define XPAR_R52_1B_CTCM_GLOBAL_HIGHADDR 0xebae7fff

/* Canonical definitions for peripheral R52_1B_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_6_BASEADDR 0xebae0000
#define XPAR_R52_CTCM_GLOBAL_6_HIGHADDR 0xebae7fff

/* Definitions for peripheral R52_1C_ATCM_GLOBAL */
#define XPAR_R52_1C_ATCM_GLOBAL_BASEADDR 0xebb40000
#define XPAR_R52_1C_ATCM_GLOBAL_HIGHADDR 0xebb4ffff

/* Canonical definitions for peripheral R52_1C_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_7_BASEADDR 0xebb40000
#define XPAR_R52_ATCM_GLOBAL_7_HIGHADDR 0xebb4ffff

/* Definitions for peripheral R52_1C_BTCM_GLOBAL */
#define XPAR_R52_1C_BTCM_GLOBAL_BASEADDR 0xebb50000
#define XPAR_R52_1C_BTCM_GLOBAL_HIGHADDR 0xebb57fff

/* Canonical definitions for peripheral R52_1C_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_7_BASEADDR 0xebb50000
#define XPAR_R52_BTCM_GLOBAL_7_HIGHADDR 0xebb57fff

/* Definitions for peripheral R52_1C_CTCM_GLOBAL */
#define XPAR_R52_1C_CTCM_GLOBAL_BASEADDR 0xebb60000
#define XPAR_R52_1C_CTCM_GLOBAL_HIGHADDR 0xebb67fff

/* Canonical definitions for peripheral R52_1C_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_7_BASEADDR 0xebb60000
#define XPAR_R52_CTCM_GLOBAL_7_HIGHADDR 0xebb67fff

/* Definitions for peripheral R52_1D_ATCM_GLOBAL */
#define XPAR_R52_1D_ATCM_GLOBAL_BASEADDR 0xebbc0000
#define XPAR_R52_1D_ATCM_GLOBAL_HIGHADDR 0xebbcffff

/* Canonical definitions for peripheral R52_1D_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_8_BASEADDR 0xebbc0000
#define XPAR_R52_ATCM_GLOBAL_8_HIGHADDR 0xebbcffff

/* Definitions for peripheral R52_1D_BTCM_GLOBAL */
#define XPAR_R52_1D_BTCM_GLOBAL_BASEADDR 0xebbd0000
#define XPAR_R52_1D_BTCM_GLOBAL_HIGHADDR 0xebbd7fff

/* Canonical definitions for peripheral R52_1D_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_8_BASEADDR 0xebbd0000
#define XPAR_R52_BTCM_GLOBAL_8_HIGHADDR 0xebbd7fff

/* Definitions for peripheral R52_1D_CTCM_GLOBAL */
#define XPAR_R52_1D_CTCM_GLOBAL_BASEADDR 0xebbe0000
#define XPAR_R52_1D_CTCM_GLOBAL_HIGHADDR 0xebbe7fff

/* Canonical definitions for peripheral R52_1D_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_8_BASEADDR 0xebbe0000
#define XPAR_R52_CTCM_GLOBAL_8_HIGHADDR 0xebbe7fff

/* Definitions for peripheral R52_1E_ATCM_GLOBAL */
#define XPAR_R52_1E_ATCM_GLOBAL_BASEADDR 0xebc40000
#define XPAR_R52_1E_ATCM_GLOBAL_HIGHADDR 0xebc4ffff

/* Canonical definitions for peripheral R52_1E_ATCM_GLOBAL */
#define XPAR_R52_ATCM_GLOBAL_9_BASEADDR 0xebc40000
#define XPAR_R52_ATCM_GLOBAL_9_HIGHADDR 0xebc4ffff

/* Definitions for peripheral R52_1E_BTCM_GLOBAL */
#define XPAR_R52_1E_BTCM_GLOBAL_BASEADDR 0xebc50000
#define XPAR_R52_1E_BTCM_GLOBAL_HIGHADDR 0xebc57fff

/* Canonical definitions for peripheral R52_1E_BTCM_GLOBAL */
#define XPAR_R52_BTCM_GLOBAL_9_BASEADDR 0xebc50000
#define XPAR_R52_BTCM_GLOBAL_9_HIGHADDR 0xebc57fff

/* Definitions for peripheral R52_1E_CTCM_GLOBAL */
#define XPAR_R52_1E_CTCM_GLOBAL_BASEADDR 0xebc60000
#define XPAR_R52_1E_CTCM_GLOBAL_HIGHADDR 0xebc67fff

/* Canonical definitions for peripheral R52_1E_CTCM_GLOBAL */
#define XPAR_R52_CTCM_GLOBAL_9_BASEADDR 0xebc60000
#define XPAR_R52_CTCM_GLOBAL_9_HIGHADDR 0xebc67fff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_COMMON */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_COMMON_BASEADDR 0xeda00000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_COMMON_HIGHADDR 0xedcfffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_COMMON */
#define XPAR_MMI_COMMON_0_BASEADDR 0xeda00000
#define XPAR_MMI_COMMON_0_HIGHADDR 0xedcfffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_GTYP_CFG */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_GTYP_CFG_BASEADDR 0xed900000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_GTYP_CFG_HIGHADDR 0xed91ffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_GTYP_CFG */
#define XPAR_MMI_GTYP_CFG_0_BASEADDR 0xed900000
#define XPAR_MMI_GTYP_CFG_0_HIGHADDR 0xed91ffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_HDCP */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_HDCP_BASEADDR 0xedeb0000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_HDCP_HIGHADDR 0xedeb7fff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_HDCP */
#define XPAR_MMI_HDCP_0_BASEADDR 0xedeb0000
#define XPAR_MMI_HDCP_0_HIGHADDR 0xedeb7fff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_PCIE0 */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_PCIE0_BASEADDR 0xed800000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_PCIE0_HIGHADDR 0xed87ffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_PCIE0 */
#define XPAR_MMI_PCIE0_0_BASEADDR 0xed800000
#define XPAR_MMI_PCIE0_0_HIGHADDR 0xed87ffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_PIPE_GEM_SLCR */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_PIPE_GEM_SLCR_BASEADDR 0xed930000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_PIPE_GEM_SLCR_HIGHADDR 0xed930fff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_PIPE_GEM_SLCR */
#define XPAR_MMI_PIPE_GEM_SLCR_0_BASEADDR 0xed930000
#define XPAR_MMI_PIPE_GEM_SLCR_0_HIGHADDR 0xed930fff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_TRNG */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_TRNG_BASEADDR 0xede80000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_TRNG_HIGHADDR 0xede8ffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_TRNG */
#define XPAR_MMI_TRNG_0_BASEADDR 0xede80000
#define XPAR_MMI_TRNG_0_HIGHADDR 0xede8ffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_UDH_PLL */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_UDH_PLL_BASEADDR 0xede90000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_UDH_PLL_HIGHADDR 0xede9ffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_UDH_PLL */
#define XPAR_MMI_UDH_PLL_0_BASEADDR 0xede90000
#define XPAR_MMI_UDH_PLL_0_HIGHADDR 0xede9ffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_UDH_SLCR */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_UDH_SLCR_BASEADDR 0xedea0000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_UDH_SLCR_HIGHADDR 0xedeaffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_UDH_SLCR */
#define XPAR_MMI_UDH_SLCR_0_BASEADDR 0xedea0000
#define XPAR_MMI_UDH_SLCR_0_HIGHADDR 0xedeaffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_USB2PHY */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_USB2PHY_BASEADDR 0xedebc000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_USB2PHY_HIGHADDR 0xedebffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_USB2PHY */
#define XPAR_MMI_USB2PHY_0_BASEADDR 0xedebc000
#define XPAR_MMI_USB2PHY_0_HIGHADDR 0xedebffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_USB3PHY_CRPARA */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_USB3PHY_CRPARA_BASEADDR 0xede40000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_USB3PHY_CRPARA_HIGHADDR 0xede7ffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_USB3PHY_CRPARA */
#define XPAR_MMI_USB3PHY_CRPARA_0_BASEADDR 0xede40000
#define XPAR_MMI_USB3PHY_CRPARA_0_HIGHADDR 0xede7ffff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_USB3PHY_TCA */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_USB3PHY_TCA_BASEADDR 0xedeb8000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_USB3PHY_TCA_HIGHADDR 0xedebbfff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_USB3PHY_TCA */
#define XPAR_MMI_USB3PHY_TCA_0_BASEADDR 0xedeb8000
#define XPAR_MMI_USB3PHY_TCA_0_HIGHADDR 0xedebbfff

/* Definitions for peripheral PS_WIZARD_0_MMI_0_MMI_PCIE_REGION_0 */
#define XPAR_PS_WIZARD_0_MMI_0_MMI_PCIE_REGION_0_BASEADDR 0xa0000000
#define XPAR_PS_WIZARD_0_MMI_0_MMI_PCIE_REGION_0_HIGHADDR 0xafffffff

/* Canonical definitions for peripheral PS_WIZARD_0_MMI_0_MMI_PCIE_REGION_0 */
#define XPAR_MMI_PCIE_REGION_0_0_BASEADDR 0xa0000000
#define XPAR_MMI_PCIE_REGION_0_0_HIGHADDR 0xafffffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_AES */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_AES_BASEADDR 0xf11e0000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_AES_HIGHADDR 0xf11effff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_AES */
#define XPAR_PMC_AES_0_BASEADDR 0xf11e0000
#define XPAR_PMC_AES_0_HIGHADDR 0xf11effff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_BBRAM_CTRL */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_BBRAM_CTRL_BASEADDR 0xf11f0000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_BBRAM_CTRL_HIGHADDR 0xf11fffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_BBRAM_CTRL */
#define XPAR_PMC_BBRAM_CTRL_0_BASEADDR 0xf11f0000
#define XPAR_PMC_BBRAM_CTRL_0_HIGHADDR 0xf11fffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_CRF_0 */
#define XPAR_PS_WIZARD_0_PS11_0_CRF_0_BASEADDR 0xec200000
#define XPAR_PS_WIZARD_0_PS11_0_CRF_0_HIGHADDR 0xec2fffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_CRF_0 */
#define XPAR_CRF_0_BASEADDR 0xec200000
#define XPAR_CRF_0_HIGHADDR 0xec2fffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_CRL_0 */
#define XPAR_PS_WIZARD_0_PS11_0_CRL_0_BASEADDR 0xeb5e0000
#define XPAR_PS_WIZARD_0_PS11_0_CRL_0_HIGHADDR 0xeb8dffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_CRL_0 */
#define XPAR_CRL_0_BASEADDR 0xeb5e0000
#define XPAR_CRL_0_HIGHADDR 0xeb8dffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_CRP_0 */
#define XPAR_PS_WIZARD_0_PS11_0_CRP_0_BASEADDR 0xf1260000
#define XPAR_PS_WIZARD_0_PS11_0_CRP_0_HIGHADDR 0xf126ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_CRP_0 */
#define XPAR_CRP_0_BASEADDR 0xf1260000
#define XPAR_CRP_0_HIGHADDR 0xf126ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_CORESIGHT_FPD_STM */
#define XPAR_PS_WIZARD_0_PS11_0_CORESIGHT_FPD_STM_BASEADDR 0xf0c40000
#define XPAR_PS_WIZARD_0_PS11_0_CORESIGHT_FPD_STM_HIGHADDR 0xf0c43fff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_CORESIGHT_FPD_STM */
#define XPAR_CORESIGHT_FPD_STM_0_BASEADDR 0xf0c40000
#define XPAR_CORESIGHT_FPD_STM_0_HIGHADDR 0xf0c43fff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_CORESIGHT_LPD_ATM */
#define XPAR_PS_WIZARD_0_PS11_0_CORESIGHT_LPD_ATM_BASEADDR 0xf08f0000
#define XPAR_PS_WIZARD_0_PS11_0_CORESIGHT_LPD_ATM_HIGHADDR 0xf08fefff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_CORESIGHT_LPD_ATM */
#define XPAR_CORESIGHT_LPD_ATM_0_BASEADDR 0xf08f0000
#define XPAR_CORESIGHT_LPD_ATM_0_HIGHADDR 0xf08fefff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RSA */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RSA_BASEADDR 0xf1200000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RSA_HIGHADDR 0xf120ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RSA */
#define XPAR_PMC_RSA_0_BASEADDR 0xf1200000
#define XPAR_PMC_RSA_0_HIGHADDR 0xf120ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_EFUSE_CACHE */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_EFUSE_CACHE_BASEADDR 0xf1250000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_EFUSE_CACHE_HIGHADDR 0xf125ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_EFUSE_CACHE */
#define XPAR_PMC_EFUSE_CACHE_0_BASEADDR 0xf1250000
#define XPAR_PMC_EFUSE_CACHE_0_HIGHADDR 0xf125ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_EFUSE_CTRL */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_EFUSE_CTRL_BASEADDR 0xf1240000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_EFUSE_CTRL_HIGHADDR 0xf124ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_EFUSE_CTRL */
#define XPAR_PMC_EFUSE_CTRL_0_BASEADDR 0xf1240000
#define XPAR_PMC_EFUSE_CTRL_0_HIGHADDR 0xf124ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_0 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_0_BASEADDR 0xec880000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_0_HIGHADDR 0xec88ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_0 */
#define XPAR_FPD_AFI_0_BASEADDR 0xec880000
#define XPAR_FPD_AFI_0_HIGHADDR 0xec88ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_1 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_1_BASEADDR 0xec890000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_1_HIGHADDR 0xec89ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_1 */
#define XPAR_FPD_AFI_1_BASEADDR 0xec890000
#define XPAR_FPD_AFI_1_HIGHADDR 0xec89ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_2 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_2_BASEADDR 0xec8a0000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_2_HIGHADDR 0xec8affff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_2 */
#define XPAR_FPD_AFI_2_BASEADDR 0xec8a0000
#define XPAR_FPD_AFI_2_HIGHADDR 0xec8affff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_3 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_3_BASEADDR 0xec8b0000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_AFI_3_HIGHADDR 0xec8bffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_AFI_3 */
#define XPAR_FPD_AFI_3_BASEADDR 0xec8b0000
#define XPAR_FPD_AFI_3_HIGHADDR 0xec8bffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_APU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_APU_0_BASEADDR 0xecc00000
#define XPAR_PS_WIZARD_0_PS11_0_APU_0_HIGHADDR 0xecc0ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_APU_0 */
#define XPAR_APU_0_BASEADDR 0xecc00000
#define XPAR_APU_0_HIGHADDR 0xecc0ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_APU_1 */
#define XPAR_PS_WIZARD_0_PS11_0_APU_1_BASEADDR 0xecd00000
#define XPAR_PS_WIZARD_0_PS11_0_APU_1_HIGHADDR 0xecd0ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_APU_1 */
#define XPAR_APU_1_BASEADDR 0xecd00000
#define XPAR_APU_1_HIGHADDR 0xecd0ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_APU_2 */
#define XPAR_PS_WIZARD_0_PS11_0_APU_2_BASEADDR 0xece00000
#define XPAR_PS_WIZARD_0_PS11_0_APU_2_HIGHADDR 0xece0ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_APU_2 */
#define XPAR_APU_2_BASEADDR 0xece00000
#define XPAR_APU_2_HIGHADDR 0xece0ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_APU_3 */
#define XPAR_PS_WIZARD_0_PS11_0_APU_3_BASEADDR 0xecf00000
#define XPAR_PS_WIZARD_0_PS11_0_APU_3_HIGHADDR 0xecf0ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_APU_3 */
#define XPAR_APU_3_BASEADDR 0xecf00000
#define XPAR_APU_3_HIGHADDR 0xecf0ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLCR_0 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLCR_0_BASEADDR 0xec8c0000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLCR_0_HIGHADDR 0xec8cffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLCR_0 */
#define XPAR_FPD_SLCR_0_BASEADDR 0xec8c0000
#define XPAR_FPD_SLCR_0_HIGHADDR 0xec8cffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLCR_SECURE_0 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLCR_SECURE_0_BASEADDR 0xec8e0000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLCR_SECURE_0_HIGHADDR 0xec8effff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLCR_SECURE_0 */
#define XPAR_FPD_SLCR_SECURE_0_BASEADDR 0xec8e0000
#define XPAR_FPD_SLCR_SECURE_0_HIGHADDR 0xec8effff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLV_ASILB_XMPU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLV_ASILB_XMPU_0_BASEADDR 0xec820000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLV_ASILB_XMPU_0_HIGHADDR 0xec82ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLV_ASILB_XMPU_0 */
#define XPAR_FPD_SLV_ASILB_XMPU_0_BASEADDR 0xec820000
#define XPAR_FPD_SLV_ASILB_XMPU_0_HIGHADDR 0xec82ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLV_ASILD_XMPU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLV_ASILD_XMPU_0_BASEADDR 0xec810000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SLV_ASILD_XMPU_0_HIGHADDR 0xec81ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SLV_ASILD_XMPU_0 */
#define XPAR_FPD_SLV_ASILD_XMPU_0_BASEADDR 0xec810000
#define XPAR_FPD_SLV_ASILD_XMPU_0_HIGHADDR 0xec81ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SYSTMR_CTRL */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SYSTMR_CTRL_BASEADDR 0xec920000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SYSTMR_CTRL_HIGHADDR 0xec92ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SYSTMR_CTRL */
#define XPAR_FPD_SYSTMR_CTRL_0_BASEADDR 0xec920000
#define XPAR_FPD_SYSTMR_CTRL_0_HIGHADDR 0xec92ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SYSTMR_READ */
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SYSTMR_READ_BASEADDR 0xec910000
#define XPAR_PS_WIZARD_0_PS11_0_FPD_SYSTMR_READ_HIGHADDR 0xec91ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_FPD_SYSTMR_READ */
#define XPAR_FPD_SYSTMR_READ_0_BASEADDR 0xec910000
#define XPAR_FPD_SYSTMR_READ_0_HIGHADDR 0xec91ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_AFI_0 */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_AFI_0_BASEADDR 0xeb9b0000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_AFI_0_HIGHADDR 0xeb9bffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_AFI_0 */
#define XPAR_LPD_AFI_0_BASEADDR 0xeb9b0000
#define XPAR_LPD_AFI_0_HIGHADDR 0xeb9bffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_IOU_SECURE_SLCR_0_BASEADDR 0xf1a40000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_IOU_SECURE_SLCR_0_HIGHADDR 0xf1a4ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_LPD_IOU_SECURE_SLCR_0_BASEADDR 0xf1a40000
#define XPAR_LPD_IOU_SECURE_SLCR_0_HIGHADDR 0xf1a4ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_IOU_SLCR_0 */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_IOU_SLCR_0_BASEADDR 0xf1a20000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_IOU_SLCR_0_HIGHADDR 0xf1a3ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_IOU_SLCR_0 */
#define XPAR_LPD_IOU_SLCR_0_BASEADDR 0xf1a20000
#define XPAR_LPD_IOU_SLCR_0_HIGHADDR 0xf1a3ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SLCR_0 */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SLCR_0_BASEADDR 0xeb410000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SLCR_0_HIGHADDR 0xeb50ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SLCR_0 */
#define XPAR_LPD_SLCR_0_BASEADDR 0xeb410000
#define XPAR_LPD_SLCR_0_HIGHADDR 0xeb50ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SLCR_SECURE_0 */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SLCR_SECURE_0_BASEADDR 0xeb510000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SLCR_SECURE_0_HIGHADDR 0xeb54ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SLCR_SECURE_0 */
#define XPAR_LPD_SLCR_SECURE_0_BASEADDR 0xeb510000
#define XPAR_LPD_SLCR_SECURE_0_HIGHADDR 0xeb54ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SYSTMR_CTRL */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SYSTMR_CTRL_BASEADDR 0xea470000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SYSTMR_CTRL_HIGHADDR 0xea47ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SYSTMR_CTRL */
#define XPAR_LPD_SYSTMR_CTRL_0_BASEADDR 0xea470000
#define XPAR_LPD_SYSTMR_CTRL_0_HIGHADDR 0xea47ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SYSTMR_READ */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SYSTMR_READ_BASEADDR 0xea460000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_SYSTMR_READ_HIGHADDR 0xea46ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_SYSTMR_READ */
#define XPAR_LPD_SYSTMR_READ_0_BASEADDR 0xea460000
#define XPAR_LPD_SYSTMR_READ_0_HIGHADDR 0xea46ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_LPD_XPPU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_LPD_XPPU_0_BASEADDR 0xeb990000
#define XPAR_PS_WIZARD_0_PS11_0_LPD_XPPU_0_HIGHADDR 0xeb99ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_LPD_XPPU_0 */
#define XPAR_LPD_XPPU_0_BASEADDR 0xeb990000
#define XPAR_LPD_XPPU_0_HIGHADDR 0xeb99ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_0 */
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_0_BASEADDR 0xeb5d0000
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_0_HIGHADDR 0xeb5dffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_0 */
#define XPAR_OCM_0_BASEADDR 0xeb5d0000
#define XPAR_OCM_0_HIGHADDR 0xeb5dffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_OCM_XMPU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_OCM_XMPU_0_BASEADDR 0xeb400000
#define XPAR_PS_WIZARD_0_PS11_0_OCM_XMPU_0_HIGHADDR 0xeb40ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_OCM_XMPU_0 */
#define XPAR_OCM_XMPU_0_BASEADDR 0xeb400000
#define XPAR_OCM_XMPU_0_HIGHADDR 0xeb40ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_1 */
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_1_BASEADDR 0xeb960000
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_1_HIGHADDR 0xeb96ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_1 */
#define XPAR_OCM_1_BASEADDR 0xeb960000
#define XPAR_OCM_1_HIGHADDR 0xeb96ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_OCM_XMPU_1 */
#define XPAR_PS_WIZARD_0_PS11_0_OCM_XMPU_1_BASEADDR 0xeb980000
#define XPAR_PS_WIZARD_0_PS11_0_OCM_XMPU_1_HIGHADDR 0xeb98ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_OCM_XMPU_1 */
#define XPAR_OCM_XMPU_1_BASEADDR 0xeb980000
#define XPAR_OCM_XMPU_1_HIGHADDR 0xeb98ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_2 */
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_2_BASEADDR 0xeb9d0000
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_2_HIGHADDR 0xeb9dffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_2 */
#define XPAR_OCM_2_BASEADDR 0xeb9d0000
#define XPAR_OCM_2_HIGHADDR 0xeb9dffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_3 */
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_3_BASEADDR 0xeaa00000
#define XPAR_PS_WIZARD_0_PS11_0_OCM_CTRL_3_HIGHADDR 0xeaa0ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_OCM_CTRL_3 */
#define XPAR_OCM_3_BASEADDR 0xeaa00000
#define XPAR_OCM_3_HIGHADDR 0xeaa0ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_GLOBAL_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_GLOBAL_0_BASEADDR 0xf1110000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_GLOBAL_0_HIGHADDR 0xf115ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_GLOBAL_0 */
#define XPAR_PMC_GLOBAL_0_BASEADDR 0xf1110000
#define XPAR_PMC_GLOBAL_0_HIGHADDR 0xf115ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RAM_NPI */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RAM_NPI_BASEADDR 0xf6000000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RAM_NPI_HIGHADDR 0xf7ffffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RAM_NPI */
#define XPAR_PMC_RAM_NPI_0_BASEADDR 0xf6000000
#define XPAR_PMC_RAM_NPI_0_HIGHADDR 0xf7ffffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT_BASEADDR 0xf1220000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT_HIGHADDR 0xf122ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT */
#define XPAR_PMC_SLAVE_BOOT_0_BASEADDR 0xf1220000
#define XPAR_PMC_SLAVE_BOOT_0_HIGHADDR 0xf122ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT_STREAM */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT_STREAM_BASEADDR 0xf2100000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT_STREAM_HIGHADDR 0xf210ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SLAVE_BOOT_STREAM */
#define XPAR_PMC_SLAVE_BOOT_STREAM_0_BASEADDR 0xf2100000
#define XPAR_PMC_SLAVE_BOOT_STREAM_0_HIGHADDR 0xf210ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_XMPU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_XMPU_0_BASEADDR 0xf12f0000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_XMPU_0_HIGHADDR 0xf12fffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_XMPU_0 */
#define XPAR_PMC_XMPU_0_BASEADDR 0xf12f0000
#define XPAR_PMC_XMPU_0_HIGHADDR 0xf12fffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_XPPU_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_XPPU_0_BASEADDR 0xf1310000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_XPPU_0_HIGHADDR 0xf131ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_XPPU_0 */
#define XPAR_PMC_XPPU_0_BASEADDR 0xf1310000
#define XPAR_PMC_XPPU_0_HIGHADDR 0xf131ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_XPPU_NPI_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_XPPU_NPI_0_BASEADDR 0xf1300000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_XPPU_NPI_0_HIGHADDR 0xf130ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_XPPU_NPI_0 */
#define XPAR_PMC_XPPU_NPI_0_BASEADDR 0xf1300000
#define XPAR_PMC_XPPU_NPI_0_HIGHADDR 0xf130ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_PPU1_MDM_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_PPU1_MDM_0_BASEADDR 0xf0310000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_PPU1_MDM_0_HIGHADDR 0xf0317fff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_PPU1_MDM_0 */
#define XPAR_PMC_PPU1_MDM_0_BASEADDR 0xf0310000
#define XPAR_PMC_PPU1_MDM_0_HIGHADDR 0xf0317fff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RAM_DATA_CNTLR */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RAM_DATA_CNTLR_BASEADDR 0xf0280000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RAM_DATA_CNTLR_HIGHADDR 0xf029ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RAM_DATA_CNTLR */
#define XPAR_RAM_DATA_CNTLR_0_BASEADDR 0xf0280000
#define XPAR_RAM_DATA_CNTLR_0_HIGHADDR 0xf029ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RAM_INSTR_CNTLR */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RAM_INSTR_CNTLR_BASEADDR 0xf0200000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_RAM_INSTR_CNTLR_HIGHADDR 0xf027ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_RAM_INSTR_CNTLR */
#define XPAR_RAM_INSTR_CNTLR_0_BASEADDR 0xf0200000
#define XPAR_RAM_INSTR_CNTLR_0_HIGHADDR 0xf027ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SHA2 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SHA2_BASEADDR 0xf1800000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SHA2_HIGHADDR 0xf180ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SHA2 */
#define XPAR_PMC_SHA2_0_BASEADDR 0xf1800000
#define XPAR_PMC_SHA2_0_HIGHADDR 0xf180ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SHA3 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SHA3_BASEADDR 0xf1210000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_SHA3_HIGHADDR 0xf121ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_SHA3 */
#define XPAR_PMC_SHA3_0_BASEADDR 0xf1210000
#define XPAR_PMC_SHA3_0_HIGHADDR 0xf121ffff

/* Definitions for peripheral PS_WIZARD_0_PS11_0_PMC_UFS_0 */
#define XPAR_PS_WIZARD_0_PS11_0_PMC_UFS_0_BASEADDR 0xf10a0000
#define XPAR_PS_WIZARD_0_PS11_0_PMC_UFS_0_HIGHADDR 0xf10affff

/* Canonical definitions for peripheral PS_WIZARD_0_PS11_0_PMC_UFS_0 */
#define XPAR_PMC_UFS_0_BASEADDR 0xf10a0000
#define XPAR_PMC_UFS_0_HIGHADDR 0xf10affff

#define XPAR_AXI_NOC2_DDR_LOW_0_BASEADDR 0x0
#define XPAR_AXI_NOC2_DDR_LOW_0_HIGHADDR 0x7fffffff
#define XPAR_OCM_RAM_0_BASEADDRESS 0xbbf00000
#define XPAR_OCM_RAM_0_HIGHADDRESS 0xbbf7ffff
#define XPAR_OCM_RAM_1_BASEADDRESS 0xbbf80000
#define XPAR_OCM_RAM_1_HIGHADDRESS 0xbbffffff
#define XPAR_OCM_RAM_2_BASEADDRESS 0xbbe00000
#define XPAR_OCM_RAM_2_HIGHADDRESS 0xbbe7ffff
#define XPAR_OCM_RAM_3_BASEADDRESS 0xbbe80000
#define XPAR_OCM_RAM_3_HIGHADDRESS 0xbbefffff

/*  CPU parameters definition */
#define XPAR_PMC_UNALIGNED_EXCEPTIONS 1
#define XPAR_PMC_FPU_EXCEPTION 0
#define XPAR_PMC_FSL_EXCEPTION 0
#define XPAR_PMC_DIV_ZERO_EXCEPTION 1
#define XPAR_PMC_ILL_OPCODE_EXCEPTION 1
#define XPAR_PMC_USE_STACK_PROTECTION 1
#define XPAR_PMC_FREQ 320000000
#define XPAR_PMC_USE_MSR_INSTR 1
#define XPAR_PMC_D_CACHE_LINE_SIZE 16
#define XPAR_PMC_DCACHE_ALWAYS_USED 0
#define XPAR_PMC_D_CACHE_SIZE 8192
#define XPAR_PMC_I_CACHE_LINE_SIZE 16
#define XPAR_PMC_I_CACHE_SIZE 8192
#define XPAR_PMC_ADDR_TAG_BITS 0
#define XPAR_PMC_ALLOW_DCACHE_WR 1
#define XPAR_PMC_ALLOW_ICACHE_WR 1
#define XPAR_PMC_AREA_OPTIMIZED 0
#define XPAR_PMC_CACHE_BYTE_SIZE 8192
#define XPAR_PMC_D_LMB 1
#define XPAR_PMC_I_LMB 1
#define XPAR_PMC_DCACHE_ADDR_TAG 0
#define XPAR_PMC_DCACHE_BYTE_SIZE 8192
#define XPAR_PMC_DCACHE_LINE_LEN 4
#define XPAR_PMC_DCACHE_USE_WRITEBACK 0
#define XPAR_PMC_DEBUG_ENABLED 1
#define XPAR_PMC_DYNAMIC_BUS_SIZING 0
#define XPAR_PMC_EDGE_IS_POSITIVE 1
#define XPAR_PMC_ENDIANNESS 1
#define XPAR_PMC_FSL_LINKS 0
#define XPAR_PMC_ICACHE_ALWAYS_USED 0
#define XPAR_PMC_ICACHE_LINE_LEN 4
#define XPAR_PMC_INTERCONNECT 2
#define XPAR_PMC_INTERRUPT_IS_EDGE 0
#define XPAR_PMC_MMU_DTLB_SIZE 4
#define XPAR_PMC_MMU_ITLB_SIZE 2
#define XPAR_PMC_MMU_TLB_ACCESS 3
#define XPAR_PMC_MMU_ZONES 16
#define XPAR_PMC_NUMBER_OF_PC_BRK 2
#define XPAR_PMC_NUMBER_OF_RD_ADDR_BRK 1
#define XPAR_PMC_NUMBER_OF_WR_ADDR_BRK 1
#define XPAR_PMC_OPCODE_0X0_ILLEGAL 1
#define XPAR_PMC_PVR 2
#define XPAR_PMC_PVR_USER2 0
#define XPAR_PMC_RESET_MSR 0
#define XPAR_PMC_SCO 0
#define XPAR_PMC_USE_BARREL 1
#define XPAR_PMC_USE_DCACHE 0
#define XPAR_PMC_USE_DIV 1
#define XPAR_PMC_USE_EXT_BRK 0
#define XPAR_PMC_USE_EXT_NM_BRK 0
#define XPAR_PMC_USE_EXTENDED_FSL_INSTR 0
#define XPAR_PMC_USE_FPU 0
#define XPAR_PMC_USE_HW_MUL 2
#define XPAR_PMC_USE_ICACHE 0
#define XPAR_PMC_USE_INTERRUPT 1
#define XPAR_PMC_USE_MMU 0
#define XPAR_PMC_USE_PCMP_INSTR 1
#define XPAR_PMC_D_CACHE_BASEADDR 0
#define XPAR_PMC_D_CACHE_HIGHADDR 1073741823
#define XPAR_PMC_I_CACHE_BASEADDR 0
#define XPAR_PMC_I_CACHE_HIGHADDR 1073741823
#define XPAR_PMC_REG 0
#define XPAR_PMC_BASE_VECTORS 4028891136

#define XPAR_CPU_CORE_CLOCK_FREQ_HZ 320000000

#define XPAR_MICROBLAZE_DDR_RESERVE_SA 0

#define XPAR_MICROBLAZE_ADDR_SIZE 32
#define XPAR_PSU_PSS_REF_CLK_FREQ_HZ 33333000

/* Number of SLRs */
#define NUMBER_OF_SLRS 0x1

/* Device ID */
#define XPAR_DEVICE_ID "xc2ve3858"

#endif  /* end of protection macro */