/******************************************************************************
* Copyright (c) 2024 - 2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*
 * This is an automatically generated file from script.
 * Please do not modify this!
 */
#ifndef XPM_NODE_H_
#define XPM_NODE_H_

#include <xil_types.h>
#include <xstatus.h>
#include "xpm_nodeid.h"
#include "xpm_common.h"

#ifdef __cplusplus
extern "C" {
#endif

#define NODE_IDLE_DONE			(0x4U)

/**
 * The node class.  This is the base class for all the power, clock, pin and
 * reset node classes.
 */
typedef struct XPm_Node {
	u32 Id;	/**< Node ID: For XilPM clock and pin APIs */
	u32 BaseAddress; /**< Base address: Specify to node type */
	u16 LatencyMarg; /**< lowest latency requirement - powerup latency */
	u8  State; /**< Node state: Specific to node type */
	u8  Flags;
} XPm_Node;

/************************** Function Prototypes ******************************/
void XPmNode_Init(XPm_Node *Node, u32 Id, u8 State, u32 BaseAddress);

#define NODE_CLASS_SHIFT	26U
#define NODE_SUBCLASS_SHIFT	20U
#define NODE_TYPE_SHIFT		14U
#define NODE_INDEX_SHIFT	0U
#define NODE_CLASS_MASK_BITS    0x3FU
#define NODE_SUBCLASS_MASK_BITS 0x3FU
#define NODE_TYPE_MASK_BITS     0x3FU
#define NODE_INDEX_MASK_BITS    0x3FFFU
#define NODE_CLASS_MASK         ((u32)NODE_CLASS_MASK_BITS << NODE_CLASS_SHIFT)
#define NODE_SUBCLASS_MASK      ((u32)NODE_SUBCLASS_MASK_BITS << NODE_SUBCLASS_SHIFT)
#define NODE_TYPE_MASK          ((u32)NODE_TYPE_MASK_BITS << NODE_TYPE_SHIFT)
#define NODE_INDEX_MASK         ((u32)NODE_INDEX_MASK_BITS << NODE_INDEX_SHIFT)

#define NODEID(CLASS, SUBCLASS, TYPE, INDEX)	\
	((((CLASS) & NODE_CLASS_MASK_BITS) << NODE_CLASS_SHIFT) | \
	(((SUBCLASS) & NODE_SUBCLASS_MASK_BITS) << NODE_SUBCLASS_SHIFT) | \
	(((TYPE) & NODE_TYPE_MASK_BITS) << NODE_TYPE_SHIFT) | \
	(((INDEX) & NODE_INDEX_MASK_BITS) << NODE_INDEX_SHIFT))

#define NODECLASS(ID)		(((ID) & NODE_CLASS_MASK) >> NODE_CLASS_SHIFT)
#define NODESUBCLASS(ID)	(((ID) & NODE_SUBCLASS_MASK) >> NODE_SUBCLASS_SHIFT)
#define NODETYPE(ID)		(((ID) & NODE_TYPE_MASK) >> NODE_TYPE_SHIFT)
#define NODEINDEX(ID)		(((ID) & NODE_INDEX_MASK) >> NODE_INDEX_SHIFT)

#define LMIONODEID(PIN_NUM)	NODEID(XPM_NODECLASS_STMIC,\
	XPM_NODESUBCL_PIN, XPM_NODETYPE_LPD_MIO, (PIN_NUM) + XPM_NODEIDX_STMIC_LMIO_0)

#define PMIONODEID(PIN_NUM)	NODEID(XPM_NODECLASS_STMIC,\
	XPM_NODESUBCL_PIN, XPM_NODETYPE_PMC_MIO, (PIN_NUM) + XPM_NODEIDX_STMIC_PMIO_0)

/* Node class types */
typedef enum {
	XPM_NODECLASS_MIN = 0x0,
	XPM_NODECLASS_POWER = 0x1,
	XPM_NODECLASS_CLOCK = 0x2,
	XPM_NODECLASS_RESET = 0x3,
	XPM_NODECLASS_MEMIC = 0x4,
	XPM_NODECLASS_STMIC = 0x5,
	XPM_NODECLASS_DEVICE = 0x6,
	XPM_NODECLASS_SUBSYSTEM = 0x7,
	XPM_NODECLASS_ISOLATION = 0x8,
	XPM_NODECLASS_PROTECTION = 0x9,
	XPM_NODECLASS_EVENT = 0xA,
	XPM_NODECLASS_MONITOR = 0xB,
	XPM_NODECLASS_REGNODE = 0xC,
	XPM_NODECLASS_MISC = 0xD,
	XPM_NODECLASS_MAX = 0xE
} XPm_NodeClass;


/* Node subclass types */
/* Power node subclass */
typedef enum {
	XPM_NODESUBCL_POWER_MIN = 0x0,
	XPM_NODESUBCL_POWER_ISLAND = 0x1,
	XPM_NODESUBCL_POWER_DOMAIN = 0x2,
	XPM_NODESUBCL_POWER_RAIL = 0x3,
	XPM_NODESUBCL_POWER_REGULATOR = 0x4,
	XPM_NODESUBCL_POWER_DOMAIN_CTRL = 0x5,
	XPM_NODESUBCL_POWER_MAX = 0x6
} XPm_PowerNodeSubclass;

/* Clock node subclass */
typedef enum {
	XPM_NODESUBCL_CLOCK_MIN = 0x0,
	XPM_NODESUBCL_CLOCK_PLL = 0x1,
	XPM_NODESUBCL_CLOCK_OUT = 0x2,
	XPM_NODESUBCL_CLOCK_REF = 0x3,
	XPM_NODESUBCL_CLOCK_MAX = 0x4
} XPm_ClockNodeSubclass;

/* Reset node subclass */
typedef enum {
	XPM_NODESUBCL_RESET_MIN = 0x0,
	XPM_NODESUBCL_RESET_PERIPHERAL = 0x1,
	XPM_NODESUBCL_RESET_DBG = 0x2,
	XPM_NODESUBCL_RESET_POR = 0x3,
	XPM_NODESUBCL_RESET_SRST = 0x4,
	XPM_NODESUBCL_RESET_WARM = 0x5,
	XPM_NODESUBCL_RESET_COLD = 0x6,
	XPM_NODESUBCL_RESET_MAX = 0x7
} XPm_ResetNodeSubclass;

/* MEMIC node subclass */
typedef enum {
	XPM_NODESUBCL_MEMIC_NOC = 0x0,
	XPM_NODESUBCL_MEMIC_MAX = 0x1
} XPm_MemicNodeSubclass;

/* Pin node subclass */
typedef enum {
	XPM_NODESUBCL_PIN_MIN = 0x0,
	XPM_NODESUBCL_PIN = 0x1,
	XPM_NODESUBCL_PIN_MAX = 0x2
} XPm_PinNodeSubclass;

/* Device node subclass */
typedef enum {
	XPM_NODESUBCL_DEV_MIN = 0x0,
	XPM_NODESUBCL_DEV_CORE = 0x1,
	XPM_NODESUBCL_DEV_PERIPH = 0x2,
	XPM_NODESUBCL_DEV_MEM = 0x3,
	XPM_NODESUBCL_DEV_SOC = 0x4,
	XPM_NODESUBCL_DEV_MEM_CTRLR = 0x5,
	XPM_NODESUBCL_DEV_PHY = 0x6,
	XPM_NODESUBCL_DEV_PL = 0x7,
	XPM_NODESUBCL_DEV_AIE = 0x8,
	XPM_NODESUBCL_DEV_MEM_REGN = 0x9,
	XPM_NODESUBCL_DEV_MAX = 0xA
} XPm_DeviceNodeSubclass;

/* Subsystem node subclass */
typedef enum {
	XPM_NODESUBCL_SUBSYSTEM = 0x0,
	XPM_NODESUBCL_SUBSYSTEM_MAX = 0x1
} XPm_SubsystemNodeSubclass;

/* Isolation subclasses */
typedef enum {
	XPM_NODESUBCL_ISOLATION = 0x0,
	XPM_NODESUBCL_ISOLATION_MAX = 0x1
} XPm_IsolationNodeSubclass;

/* Protection node subclasses */
typedef enum {
	XPM_NODESUBCL_PROT_XPPU = 0x0,
	XPM_NODESUBCL_PROT_XMPU = 0x1,
	XPM_NODESUBCL_PROT_XMPU_MAX = 0x2
} XPm_ProtNodeSubclass;

/* Monitor subclasses */
typedef enum {
	XPM_NODESUBCL_MONITOR_SYSMON = 0x0,
	XPM_NODESUBCL_MONITOR_MAX = 0x1
} XPm_MonitorNodeSubclass;

/* Register node subclasses */
typedef enum {
	XPM_NODESUBCL_REGNODE_PREDEF = 0x0,
	XPM_NODESUBCL_REGNODE_USERDEF = 0x1,
	XPM_NODESUBCL_REGNODE_MAX = 0x2
} XPm_RegNodeSubclass;

/* Misc node subclasses */
typedef enum {
	XPM_NODESUBCL_MISC = 0x0,
	XPM_NODESUBCL_MISC_MAX = 0x1
} XPm_MiscNodeSubclass;


/* Node types */
/* Power node type */
typedef enum {
	XPM_NODETYPE_POWER_MIN = 0x0,
	XPM_NODETYPE_POWER_ISLAND = 0x1,
	XPM_NODETYPE_POWER_DOMAIN_PMC = 0x2,
	XPM_NODETYPE_POWER_DOMAIN_PS_FULL = 0x3,
	XPM_NODETYPE_POWER_DOMAIN_PS_LOW = 0x4,
	XPM_NODETYPE_POWER_DOMAIN_NOC = 0x5,
	XPM_NODETYPE_POWER_DOMAIN_CPM = 0x6,
	XPM_NODETYPE_POWER_DOMAIN_ME = 0x7,
	XPM_NODETYPE_POWER_DOMAIN_PL = 0x8,
	XPM_NODETYPE_POWER_ISLAND_XRAM = 0x9,
	XPM_NODETYPE_POWER_RAIL = 0xA,
	XPM_NODETYPE_POWER_REGULATOR = 0xB,
	XPM_NODETYPE_POWER_DOMAIN_HNICX = 0xC,
	XPM_NODETYPE_POWER_DOMAIN_CTRL = 0xD,
	XPM_NODETYPE_POWER_MAX = 0xE
} XPm_PowerNodeType;

/* Clock node type */
typedef enum {
	XPM_NODETYPE_CLOCK_MIN = 0x0,
	XPM_NODETYPE_CLOCK_PLL = 0x1,
	XPM_NODETYPE_CLOCK_OUT = 0x2,
	XPM_NODETYPE_CLOCK_REF = 0x3,
	XPM_NODETYPE_CLOCK_SUBNODE = 0x4,
	XPM_NODETYPE_CLOCK_MAX = 0x5
} XPm_ClockNodeType;

/* Reset node type */
typedef enum {
	XPM_NODETYPE_RESET_MIN = 0x0,
	XPM_NODETYPE_RESET_PERIPHERAL = 0x1,
	XPM_NODETYPE_RESET_DBG = 0x2,
	XPM_NODETYPE_RESET_POR = 0x3,
	XPM_NODETYPE_RESET_SRST = 0x4,
	XPM_NODETYPE_RESET_WARM = 0x5,
	XPM_NODETYPE_RESET_COLD = 0x6,
	XPM_NODETYPE_RESET_MAX = 0x7
} XPm_ResetNodeType;

/* MEMIC node type */
typedef enum {
	XPM_NODETYPE_MEMIC_MASTER = 0x0,
	XPM_NODETYPE_MEMIC_SLAVE = 0x1,
	XPM_NODETYPE_MEMIC_MAX = 0x2
} XPm_MemicNodeType;

/* Pin node type */
typedef enum {
	XPM_NODETYPE_PIN_MIN = 0x0,
	XPM_NODETYPE_LPD_MIO = 0x1,
	XPM_NODETYPE_PMC_MIO = 0x2,
	XPM_NODETYPE_PIN_MAX = 0x3
} XPm_PinNodeType;

/* Device node type */
typedef enum {
	XPM_NODETYPE_DEV_MIN = 0x0,
	XPM_NODETYPE_DEV_CORE_PMC = 0x1,
	XPM_NODETYPE_DEV_CORE_PSM = 0x2,
	XPM_NODETYPE_DEV_CORE_APU = 0x3,
	XPM_NODETYPE_DEV_CORE_RPU = 0x4,
	XPM_NODETYPE_DEV_OCM = 0x5,
	XPM_NODETYPE_DEV_TCM = 0x6,
	XPM_NODETYPE_DEV_L2CACHE = 0x7,
	XPM_NODETYPE_DEV_DDR = 0x8,
	XPM_NODETYPE_DEV_PERIPH = 0x9,
	XPM_NODETYPE_DEV_SOC = 0xA,
	XPM_NODETYPE_DEV_GT = 0xB,
	XPM_NODETYPE_DEV_EFUSE = 0xC,
	XPM_NODETYPE_DEV_XRAM = 0xD,
	XPM_NODETYPE_DEV_RESERVED_0 = 0xE,
	XPM_NODETYPE_DEV_RESERVED_1 = 0xF,
	XPM_NODETYPE_DEV_HBM = 0x10,
	XPM_NODETYPE_DEV_VDU = 0x11,
	XPM_NODETYPE_DEV_GGS = 0x12,
	XPM_NODETYPE_DEV_PGGS = 0x13,
	XPM_NODETYPE_DEV_HB_MON = 0x14,
	XPM_NODETYPE_DEV_BFRB = 0x15,
	XPM_NODETYPE_DEV_ADC = 0x16,
	XPM_NODETYPE_DEV_DAC = 0x17,
	XPM_NODETYPE_DEV_CORE_ASU = 0x18,
	XPM_NODETYPE_DEV_MAX = 0x19
} XPm_DeviceNodeType;

/* Memory region node type */
typedef enum {
	XPM_NODETYPE_DEV_MEM_REGN = 0x0,
	XPM_NODETYPE_DEV_MEM_REGN_MAX = 0x1
} XPm_MemRegnNodeType;

/* Subsystem node type */
typedef enum {
	XPM_NODETYPE_SUBSYSTEM = 0x0,
	XPM_NODETYPE_SUBSYSTEM_MAX = 0x1
} XPm_SubsystemNodeType;

/* Isolation node type */
typedef enum {
	XPM_NODETYPE_ISOLATION = 0x0,
	XPM_NODETYPE_ISOLATION_MAX = 0x1
} XPm_IsolationNodeType;

/* Protection node typees */
typedef enum {
	XPM_NODETYPE_PROTECTION = 0x0,
	XPM_NODETYPE_PROTECTION_MAX = 0x1
} XPm_ProtNodeType;

/* Monitor node type */
typedef enum {
	XPM_NODETYPE_MONITOR_SYSMON_PMC = 0x0,
	XPM_NODETYPE_MONITOR_SYSMON_PS = 0x1,
	XPM_NODETYPE_MONITOR_SYSMON_NPD = 0x2,
	XPM_NODETYPE_MONITOR_SYSMON_CPM5N = 0x3,
	XPM_NODETYPE_MONITOR_MAX = 0x4
} XPm_MonitorNodeType;

/* Register node typees */
typedef enum {
	XPM_NODETYPE_REGNODE_GENERIC = 0x0,
	XPM_NODETYPE_REGNODE_MAX = 0x1
} XPm_RegNodeType;

/* Misc node typees */
typedef enum {
	XPM_NODETYPE_MISC = 0x0,
	XPM_NODETYPE_MISC_MAX = 0x1
} XPm_MiscNodeType;


/* Node index */
/* Power node index */
typedef enum {
	XPM_NODEIDX_POWER_MIN = 0x0,
	XPM_NODEIDX_POWER_PMC = 0x1,
	XPM_NODEIDX_POWER_LPD = 0x2,
	XPM_NODEIDX_POWER_FPD = 0x3,
	XPM_NODEIDX_POWER_NOC = 0x4,
	XPM_NODEIDX_POWER_ME = 0x5,
	XPM_NODEIDX_POWER_PLD = 0x6,
	XPM_NODEIDX_POWER_CPM = 0x7,
	XPM_NODEIDX_POWER_PL_SYSMON = 0x8,
	XPM_NODEIDX_POWER_RPU0_0 = 0x9,
	XPM_NODEIDX_POWER_GEM0 = 0xA,
	XPM_NODEIDX_POWER_GEM1 = 0xB,
	XPM_NODEIDX_POWER_OCM_0 = 0xC,
	XPM_NODEIDX_POWER_OCM_1 = 0xD,
	XPM_NODEIDX_POWER_OCM_2 = 0xE,
	XPM_NODEIDX_POWER_OCM_3 = 0xF,
	XPM_NODEIDX_POWER_TCM_0_A = 0x10,
	XPM_NODEIDX_POWER_TCM_0_B = 0x11,
	XPM_NODEIDX_POWER_TCM_1_A = 0x12,
	XPM_NODEIDX_POWER_TCM_1_B = 0x13,
	XPM_NODEIDX_POWER_ACPU_0 = 0x14,
	XPM_NODEIDX_POWER_ACPU_1 = 0x15,
	XPM_NODEIDX_POWER_L2_BANK_0 = 0x16,
	XPM_NODEIDX_POWER_XRAM_0 = 0x17,
	XPM_NODEIDX_POWER_XRAM_1 = 0x18,
	XPM_NODEIDX_POWER_XRAM_2 = 0x19,
	XPM_NODEIDX_POWER_XRAM_3 = 0x1A,
	XPM_NODEIDX_POWER_XRAM_4 = 0x1B,
	XPM_NODEIDX_POWER_XRAM_5 = 0x1C,
	XPM_NODEIDX_POWER_XRAM_6 = 0x1D,
	XPM_NODEIDX_POWER_XRAM_7 = 0x1E,
	XPM_NODEIDX_POWER_XRAM_8 = 0x1F,
	XPM_NODEIDX_POWER_XRAM_9 = 0x20,
	XPM_NODEIDX_POWER_XRAM_10 = 0x21,
	XPM_NODEIDX_POWER_XRAM_11 = 0x22,
	XPM_NODEIDX_POWER_XRAM_12 = 0x23,
	XPM_NODEIDX_POWER_XRAM_13 = 0x24,
	XPM_NODEIDX_POWER_XRAM_14 = 0x25,
	XPM_NODEIDX_POWER_XRAM_15 = 0x26,
	XPM_NODEIDX_POWER_CPM5 = 0x27,
	XPM_NODEIDX_POWER_ME2 = 0x28,
	XPM_NODEIDX_POWER_VCCINT_PMC = 0x29,
	XPM_NODEIDX_POWER_VCCAUX_PMC = 0x2A,
	XPM_NODEIDX_POWER_VCCINT_PSLP = 0x2B,
	XPM_NODEIDX_POWER_VCCINT_PSFP = 0x2C,
	XPM_NODEIDX_POWER_VCCINT_SOC = 0x2D,
	XPM_NODEIDX_POWER_VCCINT_RAM = 0x2E,
	XPM_NODEIDX_POWER_VCCAUX = 0x2F,
	XPM_NODEIDX_POWER_VCCINT_PL = 0x30,
	XPM_NODEIDX_POWER_HNICX = 0x31,
	XPM_NODEIDX_POWER_CPM5N = 0x32,
	XPM_NODEIDX_POWER_ACPU_0_0 = 0x33,
	XPM_NODEIDX_POWER_ACPU_0_1 = 0x34,
	XPM_NODEIDX_POWER_ACPU_0_2 = 0x35,
	XPM_NODEIDX_POWER_ACPU_0_3 = 0x36,
	XPM_NODEIDX_POWER_ACPU_1_0 = 0x37,
	XPM_NODEIDX_POWER_ACPU_1_1 = 0x38,
	XPM_NODEIDX_POWER_ACPU_1_2 = 0x39,
	XPM_NODEIDX_POWER_ACPU_1_3 = 0x3A,
	XPM_NODEIDX_POWER_ACPU_2_0 = 0x3B,
	XPM_NODEIDX_POWER_ACPU_2_1 = 0x3C,
	XPM_NODEIDX_POWER_ACPU_2_2 = 0x3D,
	XPM_NODEIDX_POWER_ACPU_2_3 = 0x3E,
	XPM_NODEIDX_POWER_ACPU_3_0 = 0x3F,
	XPM_NODEIDX_POWER_ACPU_3_1 = 0x40,
	XPM_NODEIDX_POWER_ACPU_3_2 = 0x41,
	XPM_NODEIDX_POWER_ACPU_3_3 = 0x42,
	XPM_NODEIDX_POWER_RPU_A_0 = 0x43,
	XPM_NODEIDX_POWER_RPU_A_1 = 0x44,
	XPM_NODEIDX_POWER_RPU_B_0 = 0x45,
	XPM_NODEIDX_POWER_RPU_B_1 = 0x46,
	XPM_NODEIDX_POWER_OCM_0_0 = 0x47,
	XPM_NODEIDX_POWER_OCM_0_1 = 0x48,
	XPM_NODEIDX_POWER_OCM_0_2 = 0x49,
	XPM_NODEIDX_POWER_OCM_0_3 = 0x4A,
	XPM_NODEIDX_POWER_OCM_1_0 = 0x4B,
	XPM_NODEIDX_POWER_OCM_1_1 = 0x4C,
	XPM_NODEIDX_POWER_OCM_1_2 = 0x4D,
	XPM_NODEIDX_POWER_OCM_1_3 = 0x4E,
	XPM_NODEIDX_POWER_FPD_DOMAIN_CTRL = 0x4F,
	XPM_NODEIDX_POWER_PLD_DOMAIN_CTRL = 0x50,
	XPM_NODEIDX_POWER_VCCINT_CPM5N = 0x51,
	XPM_NODEIDX_POWER_OCM_2_0 = 0x52,
	XPM_NODEIDX_POWER_OCM_2_1 = 0x53,
	XPM_NODEIDX_POWER_OCM_2_2 = 0x54,
	XPM_NODEIDX_POWER_OCM_2_3 = 0x55,
	XPM_NODEIDX_POWER_OCM_3_0 = 0x56,
	XPM_NODEIDX_POWER_OCM_3_1 = 0x57,
	XPM_NODEIDX_POWER_OCM_3_2 = 0x58,
	XPM_NODEIDX_POWER_OCM_3_3 = 0x59,
	XPM_NODEIDX_POWER_TCM_0_C = 0x5A,
	XPM_NODEIDX_POWER_TCM_0_D = 0x5B,
	XPM_NODEIDX_POWER_TCM_0_E = 0x5C,
	XPM_NODEIDX_POWER_TCM_1_C = 0x5D,
	XPM_NODEIDX_POWER_TCM_1_D = 0x5E,
	XPM_NODEIDX_POWER_TCM_1_E = 0x5F,
	XPM_NODEIDX_POWER_CPM6 = 0x60,
	XPM_NODEIDX_POWER_VCCINT_ME = 0x61,
	XPM_NODEIDX_POWER_MAX = 0x62
} XPm_PowerNodeIdx;

/* Power regulator node index */
typedef enum {
	XPM_NODEIDX_POWER_REGULATOR_0 = 0x0,
	XPM_NODEIDX_POWER_REGULATOR_MAX = 0x8
} XPm_RegulatorNodeIdx;

/* Clock node index */
typedef enum {
	XPM_NODEIDX_CLK_MIN = 0x0,
	XPM_NODEIDX_CLK_PMC_PLL = 0x1,
	XPM_NODEIDX_CLK_APU_PLL = 0x2,
	XPM_NODEIDX_CLK_RPU_PLL = 0x3,
	XPM_NODEIDX_CLK_CPM_PLL = 0x4,
	XPM_NODEIDX_CLK_NOC_PLL = 0x5,
	XPM_NODEIDX_CLK_PLL_MAX = 0x6,
	XPM_NODEIDX_CLK_PMC_PRESRC = 0x7,
	XPM_NODEIDX_CLK_PMC_POSTCLK = 0x8,
	XPM_NODEIDX_CLK_PMC_PLL_OUT = 0x9,
	XPM_NODEIDX_CLK_PPLL = 0xA,
	XPM_NODEIDX_CLK_NOC_PRESRC = 0xB,
	XPM_NODEIDX_CLK_NOC_POSTCLK = 0xC,
	XPM_NODEIDX_CLK_NOC_PLL_OUT = 0xD,
	XPM_NODEIDX_CLK_NPLL = 0xE,
	XPM_NODEIDX_CLK_APU_PRESRC = 0xF,
	XPM_NODEIDX_CLK_APU_POSTCLK = 0x10,
	XPM_NODEIDX_CLK_APU_PLL_OUT = 0x11,
	XPM_NODEIDX_CLK_APLL = 0x12,
	XPM_NODEIDX_CLK_RPU_PRESRC = 0x13,
	XPM_NODEIDX_CLK_RPU_POSTCLK = 0x14,
	XPM_NODEIDX_CLK_RPU_PLL_OUT = 0x15,
	XPM_NODEIDX_CLK_RPLL = 0x16,
	XPM_NODEIDX_CLK_CPM_PRESRC = 0x17,
	XPM_NODEIDX_CLK_CPM_POSTCLK = 0x18,
	XPM_NODEIDX_CLK_CPM_PLL_OUT = 0x19,
	XPM_NODEIDX_CLK_CPLL = 0x1A,
	XPM_NODEIDX_CLK_PPLL_TO_XPD = 0x1B,
	XPM_NODEIDX_CLK_NPLL_TO_XPD = 0x1C,
	XPM_NODEIDX_CLK_APLL_TO_XPD = 0x1D,
	XPM_NODEIDX_CLK_RPLL_TO_XPD = 0x1E,
	XPM_NODEIDX_CLK_EFUSE_REF = 0x1F,
	XPM_NODEIDX_CLK_SYSMON_REF = 0x20,
	XPM_NODEIDX_CLK_IRO_SUSPEND_REF = 0x21,
	XPM_NODEIDX_CLK_USB_SUSPEND = 0x22,
	XPM_NODEIDX_CLK_SWITCH_TIMEOUT = 0x23,
	XPM_NODEIDX_CLK_RCLK_PMC = 0x24,
	XPM_NODEIDX_CLK_RCLK_LPD = 0x25,
	XPM_NODEIDX_CLK_WDT = 0x26,
	XPM_NODEIDX_CLK_TTC0 = 0x27,
	XPM_NODEIDX_CLK_TTC1 = 0x28,
	XPM_NODEIDX_CLK_TTC2 = 0x29,
	XPM_NODEIDX_CLK_TTC3 = 0x2A,
	XPM_NODEIDX_CLK_GEM_TSU = 0x2B,
	XPM_NODEIDX_CLK_GEM_TSU_LB = 0x2C,
	XPM_NODEIDX_CLK_MUXED_IRO_DIV2 = 0x2D,
	XPM_NODEIDX_CLK_MUXED_IRO_DIV4 = 0x2E,
	XPM_NODEIDX_CLK_PSM_REF = 0x2F,
	XPM_NODEIDX_CLK_GEM0_RX = 0x30,
	XPM_NODEIDX_CLK_GEM0_TX = 0x31,
	XPM_NODEIDX_CLK_GEM1_RX = 0x32,
	XPM_NODEIDX_CLK_GEM1_TX = 0x33,
	XPM_NODEIDX_CLK_CPM_CORE_REF = 0x34,
	XPM_NODEIDX_CLK_CPM_LSBUS_REF = 0x35,
	XPM_NODEIDX_CLK_CPM_DBG_REF = 0x36,
	XPM_NODEIDX_CLK_CPM_AUX0_REF = 0x37,
	XPM_NODEIDX_CLK_CPM_AUX1_REF = 0x38,
	XPM_NODEIDX_CLK_QSPI_REF = 0x39,
	XPM_NODEIDX_CLK_OSPI_REF = 0x3A,
	XPM_NODEIDX_CLK_SDIO0_REF = 0x3B,
	XPM_NODEIDX_CLK_SDIO1_REF = 0x3C,
	XPM_NODEIDX_CLK_PMC_LSBUS_REF = 0x3D,
	XPM_NODEIDX_CLK_I2C_REF = 0x3E,
	XPM_NODEIDX_CLK_TEST_PATTERN_REF = 0x3F,
	XPM_NODEIDX_CLK_DFT_OSC_REF = 0x40,
	XPM_NODEIDX_CLK_PMC_PL0_REF = 0x41,
	XPM_NODEIDX_CLK_PMC_PL1_REF = 0x42,
	XPM_NODEIDX_CLK_PMC_PL2_REF = 0x43,
	XPM_NODEIDX_CLK_PMC_PL3_REF = 0x44,
	XPM_NODEIDX_CLK_CFU_REF = 0x45,
	XPM_NODEIDX_CLK_SPARE_REF = 0x46,
	XPM_NODEIDX_CLK_NPI_REF = 0x47,
	XPM_NODEIDX_CLK_HSM0_REF = 0x48,
	XPM_NODEIDX_CLK_HSM1_REF = 0x49,
	XPM_NODEIDX_CLK_SD_DLL_REF = 0x4A,
	XPM_NODEIDX_CLK_FPD_TOP_SWITCH = 0x4B,
	XPM_NODEIDX_CLK_FPD_LSBUS = 0x4C,
	XPM_NODEIDX_CLK_ACPU = 0x4D,
	XPM_NODEIDX_CLK_DBG_TRACE = 0x4E,
	XPM_NODEIDX_CLK_DBG_FPD = 0x4F,
	XPM_NODEIDX_CLK_LPD_TOP_SWITCH = 0x50,
	XPM_NODEIDX_CLK_ADMA = 0x51,
	XPM_NODEIDX_CLK_LPD_LSBUS = 0x52,
	XPM_NODEIDX_CLK_CPU_R5 = 0x53,
	XPM_NODEIDX_CLK_CPU_R5_CORE = 0x54,
	XPM_NODEIDX_CLK_CPU_R5_OCM = 0x55,
	XPM_NODEIDX_CLK_CPU_R5_OCM2 = 0x56,
	XPM_NODEIDX_CLK_IOU_SWITCH = 0x57,
	XPM_NODEIDX_CLK_GEM0_REF = 0x58,
	XPM_NODEIDX_CLK_GEM1_REF = 0x59,
	XPM_NODEIDX_CLK_GEM_TSU_REF = 0x5A,
	XPM_NODEIDX_CLK_USB0_BUS_REF = 0x5B,
	XPM_NODEIDX_CLK_UART0_REF = 0x5C,
	XPM_NODEIDX_CLK_UART1_REF = 0x5D,
	XPM_NODEIDX_CLK_SPI0_REF = 0x5E,
	XPM_NODEIDX_CLK_SPI1_REF = 0x5F,
	XPM_NODEIDX_CLK_CAN0_REF = 0x60,
	XPM_NODEIDX_CLK_CAN1_REF = 0x61,
	XPM_NODEIDX_CLK_I2C0_REF = 0x62,
	XPM_NODEIDX_CLK_I2C1_REF = 0x63,
	XPM_NODEIDX_CLK_DBG_LPD = 0x64,
	XPM_NODEIDX_CLK_TIMESTAMP_REF = 0x65,
	XPM_NODEIDX_CLK_DBG_TSTMP = 0x66,
	XPM_NODEIDX_CLK_CPM_TOPSW_REF = 0x67,
	XPM_NODEIDX_CLK_USB3_DUAL_REF = 0x68,
	XPM_NODEIDX_CLK_OUTCLK_MAX = 0x69,
	XPM_NODEIDX_CLK_REF_CLK = 0x6A,
	XPM_NODEIDX_CLK_PL_ALT_REF_CLK = 0x6B,
	XPM_NODEIDX_CLK_MUXED_IRO = 0x6C,
	XPM_NODEIDX_CLK_PL_EXT = 0x6D,
	XPM_NODEIDX_CLK_PL_LB = 0x6E,
	XPM_NODEIDX_CLK_MIO_50_OR_51 = 0x6F,
	XPM_NODEIDX_CLK_MIO_24_OR_25 = 0x70,
	XPM_NODEIDX_CLK_EMIO = 0x71,
	XPM_NODEIDX_CLK_MIO = 0x72,
	XPM_NODEIDX_CLK_REF_MAX = 0x73,
	XPM_NODEIDX_CLK_XRAM_MAIN_CLK = 0x74,
	XPM_NODEIDX_CLK_XRAM_APB = 0x75,
	XPM_NODEIDX_CLK_PL_PMC_ALT_REF_CLK = 0x76,
	XPM_NODEIDX_CLK_PL_LPD_ALT_REF_CLK = 0x77,
	XPM_NODEIDX_CLK_PL_FPD_ALT_REF_CLK = 0x78,
	XPM_NODEIDX_CLK_CPM_DMA_ALT_REF = 0x79,
	XPM_NODEIDX_CLK_CPM_AUX2_REF = 0x7A,
	XPM_NODEIDX_CLK_CPM5N_PRESRC = 0x7B,
	XPM_NODEIDX_CLK_CPM5N_POSTCLK = 0x7C,
	XPM_NODEIDX_CLK_CPM5N_PLL_OUT = 0x7D,
	XPM_NODEIDX_CLK_APU1_PRESRC = 0x7E,
	XPM_NODEIDX_CLK_APU1_POSTCLK = 0x7F,
	XPM_NODEIDX_CLK_APU_PLL1_OUT = 0x80,
	XPM_NODEIDX_CLK_APLL1 = 0x81,
	XPM_NODEIDX_CLK_APU2_PRESRC = 0x82,
	XPM_NODEIDX_CLK_APU2_POSTCLK = 0x83,
	XPM_NODEIDX_CLK_APU_PLL2_OUT = 0x84,
	XPM_NODEIDX_CLK_APLL2 = 0x85,
	XPM_NODEIDX_CLK_FLX_PRESRC = 0x86,
	XPM_NODEIDX_CLK_FLX_POSTCLK = 0x87,
	XPM_NODEIDX_CLK_FLX_PLL_OUT = 0x88,
	XPM_NODEIDX_CLK_FLXPLL = 0x89,
	XPM_NODEIDX_CLK_IRO = 0x8A,
	XPM_NODEIDX_CLK_IN_REF = 0x8B,
	XPM_NODEIDX_CLK_OSCCLK_DIV2 = 0x8C,
	XPM_NODEIDX_CLK_CPM5N_DBG_REF = 0x8D,
	XPM_NODEIDX_CLK_CPM5N_AUX1_REF = 0x8E,
	XPM_NODEIDX_CLK_CPM5N_TOPSW_REF = 0x8F,
	XPM_NODEIDX_CLK_CPM5N_AUX0_REF = 0x90,
	XPM_NODEIDX_CLK_CPM5N_DMA_ALT = 0x91,
	XPM_NODEIDX_CLK_CPM5N_AUX2_REF = 0x92,
	XPM_NODEIDX_CLK_CPM5N_CORE_REF = 0x93,
	XPM_NODEIDX_CLK_PMC_RCLK = 0x94,
	XPM_NODEIDX_CLK_FPD_RCLK = 0x95,
	XPM_NODEIDX_CLK_FPD_WWDT_PLL = 0x96,
	XPM_NODEIDX_CLK_PERIPH = 0x97,
	XPM_NODEIDX_CLK_ACPU0 = 0x98,
	XPM_NODEIDX_CLK_ACPU3 = 0x99,
	XPM_NODEIDX_CLK_ACPU2 = 0x9A,
	XPM_NODEIDX_CLK_ACPU1 = 0x9B,
	XPM_NODEIDX_CLK_FPD_PKI_DIV = 0x9C,
	XPM_NODEIDX_CLK_I3C0_REF = 0x9D,
	XPM_NODEIDX_CLK_CAN0_REF_2X = 0x9E,
	XPM_NODEIDX_CLK_I3C1_REF = 0x9F,
	XPM_NODEIDX_CLK_LPD_RCLK = 0xA0,
	XPM_NODEIDX_CLK_GEM1_REF_TX = 0xA1,
	XPM_NODEIDX_CLK_GEM1_REF_RX = 0xA2,
	XPM_NODEIDX_CLK_RPU = 0xA3,
	XPM_NODEIDX_CLK_RPU_OCM = 0xA4,
	XPM_NODEIDX_CLK_RPU_XRAM = 0xA5,
	XPM_NODEIDX_CLK_RPU_CLUSTERB = 0xA6,
	XPM_NODEIDX_CLK_RPU_CLUSTERA = 0xA7,
	XPM_NODEIDX_CLK_GEM0_REF_TX = 0xA8,
	XPM_NODEIDX_CLK_GEM0_REF_RX = 0xA9,
	XPM_NODEIDX_CLK_PSM = 0xAA,
	XPM_NODEIDX_CLK_CPM_TOPSW = 0xAB,
	XPM_NODEIDX_CLK_CAN1_REF_2X = 0xAC,
	XPM_NODEIDX_CLK_LPD_WWDT_PLL = 0xAD,
	XPM_NODEIDX_CLK_USB1_BUS_REF = 0xAE,
	XPM_NODEIDX_CLK_LPD_TOP_SWITCH_ADMA = 0xAF,
	XPM_NODEIDX_CLK_FPD_TOPSW_MUX = 0xB0,
	XPM_NODEIDX_CLK_CPM5N_PLL = 0xB1,
	XPM_NODEIDX_CLK_APU_PLL1 = 0xB2,
	XPM_NODEIDX_CLK_APU_PLL2 = 0xB3,
	XPM_NODEIDX_CLK_FLX_PLL = 0xB4,
	XPM_NODEIDX_CLK_FPD_WWDT0 = 0xB5,
	XPM_NODEIDX_CLK_FPD_WWDT1 = 0xB6,
	XPM_NODEIDX_CLK_FPD_WWDT2 = 0xB7,
	XPM_NODEIDX_CLK_FPD_WWDT3 = 0xB8,
	XPM_NODEIDX_CLK_LPD_WWDT0 = 0xB9,
	XPM_NODEIDX_CLK_LPD_WWDT1 = 0xBA,
	XPM_NODEIDX_CLK_I3C4_REF = 0xBB,
	XPM_NODEIDX_CLK_I3C3_REF = 0xBC,
	XPM_NODEIDX_CLK_I3C2_REF = 0xBD,
	XPM_NODEIDX_CLK_RPU_CLUSTERC = 0xBE,
	XPM_NODEIDX_CLK_RPU_CLUSTERD = 0xBF,
	XPM_NODEIDX_CLK_RPU_CLUSTERE = 0xC0,
	XPM_NODEIDX_CLK_CAN2_REF_2X = 0xC1,
	XPM_NODEIDX_CLK_LPD_TOP_SWITCH_SDMA = 0xC2,
	XPM_NODEIDX_CLK_I3C7_REF = 0xC3,
	XPM_NODEIDX_CLK_I3C6_REF = 0xC4,
	XPM_NODEIDX_CLK_ASU = 0xC5,
	XPM_NODEIDX_CLK_CAN3_REF_2X = 0xC6,
	XPM_NODEIDX_CLK_I3C5_REF = 0xC7,
	XPM_NODEIDX_CLK_UFS_REF = 0xC8,
	XPM_NODEIDX_CLK_LPD_WWDT2 = 0xC9,
	XPM_NODEIDX_CLK_LPD_WWDT3 = 0xCA,
	XPM_NODEIDX_CLK_LPD_WWDT4 = 0xCB,
	XPM_NODEIDX_CLK_TTC4 = 0xCC,
	XPM_NODEIDX_CLK_TTC5 = 0xCD,
	XPM_NODEIDX_CLK_TTC6 = 0xCE,
	XPM_NODEIDX_CLK_TTC7 = 0xCF,
	XPM_NODEIDX_CLK_MMI_DRD_REF_CLK = 0xD0,
	XPM_NODEIDX_CLK_UDH_PRESRC = 0xD1,
	XPM_NODEIDX_CLK_UDHPLL = 0xD2,
	XPM_NODEIDX_CLK_UDH_PLL = 0xD3,
	XPM_NODEIDX_CLK_MMI_PRESRC = 0xD4,
	XPM_NODEIDX_CLK_MMI_POSTCLK = 0xD5,
	XPM_NODEIDX_CLK_MMI_PLL_OUT = 0xD6,
	XPM_NODEIDX_CLK_MMIPLL = 0xD7,
	XPM_NODEIDX_CLK_PL_PIXEL = 0xD8,
	XPM_NODEIDX_CLK_GPU_PLL = 0xD9,
	XPM_NODEIDX_CLK_DC_PIXEL = 0xDA,
	XPM_NODEIDX_CLK_MMI_GPU_REF = 0xDB,
	XPM_NODEIDX_CLK_MMI_AUX0_REF = 0xDC,
	XPM_NODEIDX_CLK_PS_AXI_DMA = 0xDD,
	XPM_NODEIDX_CLK_MMI_PLL = 0xDE,
	XPM_NODEIDX_CLK_MMI_AUX1_REF = 0xDF,
	XPM_NODEIDX_CLK_MAX = 0xE0
} XPm_ClockNodeIdx;

/* Reset node index */
typedef enum {
	XPM_NODEIDX_RST_MIN = 0x0,
	XPM_NODEIDX_RST_PMC_POR = 0x1,
	XPM_NODEIDX_RST_PMC = 0x2,
	XPM_NODEIDX_RST_PS_POR = 0x3,
	XPM_NODEIDX_RST_PL_POR = 0x4,
	XPM_NODEIDX_RST_NOC_POR = 0x5,
	XPM_NODEIDX_RST_FPD_POR = 0x6,
	XPM_NODEIDX_RST_ACPU_0_POR = 0x7,
	XPM_NODEIDX_RST_ACPU_1_POR = 0x8,
	XPM_NODEIDX_RST_OCM2_POR = 0x9,
	XPM_NODEIDX_RST_PS_SRST = 0xA,
	XPM_NODEIDX_RST_PL_SRST = 0xB,
	XPM_NODEIDX_RST_NOC = 0xC,
	XPM_NODEIDX_RST_NPI = 0xD,
	XPM_NODEIDX_RST_SYS_RST_1 = 0xE,
	XPM_NODEIDX_RST_SYS_RST_2 = 0xF,
	XPM_NODEIDX_RST_SYS_RST_3 = 0x10,
	XPM_NODEIDX_RST_FPD = 0x11,
	XPM_NODEIDX_RST_PL0 = 0x12,
	XPM_NODEIDX_RST_PL1 = 0x13,
	XPM_NODEIDX_RST_PL2 = 0x14,
	XPM_NODEIDX_RST_PL3 = 0x15,
	XPM_NODEIDX_RST_APU = 0x16,
	XPM_NODEIDX_RST_ACPU_0 = 0x17,
	XPM_NODEIDX_RST_ACPU_1 = 0x18,
	XPM_NODEIDX_RST_ACPU_L2 = 0x19,
	XPM_NODEIDX_RST_ACPU_GIC = 0x1A,
	XPM_NODEIDX_RST_RPU_ISLAND = 0x1B,
	XPM_NODEIDX_RST_RPU_AMBA = 0x1C,
	XPM_NODEIDX_RST_R5_0 = 0x1D,
	XPM_NODEIDX_RST_R5_1 = 0x1E,
	XPM_NODEIDX_RST_SYSMON_PMC_SEQ_RST = 0x1F,
	XPM_NODEIDX_RST_SYSMON_PMC_CFG_RST = 0x20,
	XPM_NODEIDX_RST_SYSMON_FPD_CFG_RST = 0x21,
	XPM_NODEIDX_RST_SYSMON_FPD_SEQ_RST = 0x22,
	XPM_NODEIDX_RST_SYSMON_LPD = 0x23,
	XPM_NODEIDX_RST_PDMA_RST1 = 0x24,
	XPM_NODEIDX_RST_PDMA_RST0 = 0x25,
	XPM_NODEIDX_RST_ADMA = 0x26,
	XPM_NODEIDX_RST_TIMESTAMP = 0x27,
	XPM_NODEIDX_RST_OCM = 0x28,
	XPM_NODEIDX_RST_OCM2_RST = 0x29,
	XPM_NODEIDX_RST_IPI = 0x2A,
	XPM_NODEIDX_RST_SBI = 0x2B,
	XPM_NODEIDX_RST_LPD = 0x2C,
	XPM_NODEIDX_RST_QSPI = 0x2D,
	XPM_NODEIDX_RST_OSPI = 0x2E,
	XPM_NODEIDX_RST_SDIO_0 = 0x2F,
	XPM_NODEIDX_RST_SDIO_1 = 0x30,
	XPM_NODEIDX_RST_I2C_PMC = 0x31,
	XPM_NODEIDX_RST_GPIO_PMC = 0x32,
	XPM_NODEIDX_RST_GEM_0 = 0x33,
	XPM_NODEIDX_RST_GEM_1 = 0x34,
	XPM_NODEIDX_RST_SPARE = 0x35,
	XPM_NODEIDX_RST_USB_0 = 0x36,
	XPM_NODEIDX_RST_UART_0 = 0x37,
	XPM_NODEIDX_RST_UART_1 = 0x38,
	XPM_NODEIDX_RST_SPI_0 = 0x39,
	XPM_NODEIDX_RST_SPI_1 = 0x3A,
	XPM_NODEIDX_RST_CAN_FD_0 = 0x3B,
	XPM_NODEIDX_RST_CAN_FD_1 = 0x3C,
	XPM_NODEIDX_RST_I2C_0 = 0x3D,
	XPM_NODEIDX_RST_I2C_1 = 0x3E,
	XPM_NODEIDX_RST_GPIO_LPD = 0x3F,
	XPM_NODEIDX_RST_TTC_0 = 0x40,
	XPM_NODEIDX_RST_TTC_1 = 0x41,
	XPM_NODEIDX_RST_TTC_2 = 0x42,
	XPM_NODEIDX_RST_TTC_3 = 0x43,
	XPM_NODEIDX_RST_SWDT_FPD = 0x44,
	XPM_NODEIDX_RST_SWDT_LPD = 0x45,
	XPM_NODEIDX_RST_USB = 0x46,
	XPM_NODEIDX_RST_DPC = 0x47,
	XPM_NODEIDX_RST_PMCDBG = 0x48,
	XPM_NODEIDX_RST_DBG_TRACE = 0x49,
	XPM_NODEIDX_RST_DBG_FPD = 0x4A,
	XPM_NODEIDX_RST_DBG_TSTMP = 0x4B,
	XPM_NODEIDX_RST_RPU0_DBG = 0x4C,
	XPM_NODEIDX_RST_RPU1_DBG = 0x4D,
	XPM_NODEIDX_RST_HSDP = 0x4E,
	XPM_NODEIDX_RST_DBG_LPD = 0x4F,
	XPM_NODEIDX_RST_CPM_POR = 0x50,
	XPM_NODEIDX_RST_CPM = 0x51,
	XPM_NODEIDX_RST_CPMDBG = 0x52,
	XPM_NODEIDX_RST_PCIE_CFG = 0x53,
	XPM_NODEIDX_RST_PCIE_CORE0 = 0x54,
	XPM_NODEIDX_RST_PCIE_CORE1 = 0x55,
	XPM_NODEIDX_RST_PCIE_DMA = 0x56,
	XPM_NODEIDX_RST_CMN = 0x57,
	XPM_NODEIDX_RST_L2_0 = 0x58,
	XPM_NODEIDX_RST_L2_1 = 0x59,
	XPM_NODEIDX_RST_ADDR_REMAP = 0x5A,
	XPM_NODEIDX_RST_CPI0 = 0x5B,
	XPM_NODEIDX_RST_CPI1 = 0x5C,
	XPM_NODEIDX_RST_XRAM = 0x5D,
	XPM_NODEIDX_RST_AIE_ARRAY = 0x5E,
	XPM_NODEIDX_RST_AIE_SHIM = 0x5F,
	XPM_NODEIDX_RST_PCIE_DMA1 = 0x60,
	XPM_NODEIDX_RST_GTY_1 = 0x61,
	XPM_NODEIDX_RST_GTY_3 = 0x62,
	XPM_NODEIDX_RST_GTY_2 = 0x63,
	XPM_NODEIDX_RST_DMA_CONFIG_POR = 0x64,
	XPM_NODEIDX_RST_CDX = 0x65,
	XPM_NODEIDX_RST_PCIE0_CONFIG = 0x66,
	XPM_NODEIDX_RST_PCIE_CONFIG_POR = 0x67,
	XPM_NODEIDX_RST_DPU = 0x68,
	XPM_NODEIDX_RST_CDX_CONFIG = 0x69,
	XPM_NODEIDX_RST_PCIE_1 = 0x6A,
	XPM_NODEIDX_RST_PCIE_0 = 0x6B,
	XPM_NODEIDX_RST_PCIE_3 = 0x6C,
	XPM_NODEIDX_RST_PCIE_2 = 0x6D,
	XPM_NODEIDX_RST_PCIE1_CONFIG = 0x6E,
	XPM_NODEIDX_RST_PCIE3_CONFIG = 0x6F,
	XPM_NODEIDX_RST_DPU_CONFIG = 0x70,
	XPM_NODEIDX_RST_PCIE2_CONFIG = 0x71,
	XPM_NODEIDX_RST_RAM_0 = 0x72,
	XPM_NODEIDX_RST_RAM_1 = 0x73,
	XPM_NODEIDX_RST_ECO_2_R1_SECO = 0x74,
	XPM_NODEIDX_RST_ECO_1_R0_SECO = 0x75,
	XPM_NODEIDX_RST_XPD_SOFT_CLK_0 = 0x76,
	XPM_NODEIDX_RST_ECO_0_R0_SECO = 0x77,
	XPM_NODEIDX_RST_USB1_PHY = 0x78,
	XPM_NODEIDX_RST_WWDT = 0x79,
	XPM_NODEIDX_RST_RESERVED_1 = 0x7A,
	XPM_NODEIDX_RST_UDH_DRD = 0x7B,
	XPM_NODEIDX_RST_UFS_PHY = 0x7C,
	XPM_NODEIDX_RST_PMC_SRST = 0x7D,
	XPM_NODEIDX_RST_SYSMON_CFG_CPM5N = 0x7E,
	XPM_NODEIDX_RST_SYSMON_CFG_PMC = 0x7F,
	XPM_NODEIDX_RST_SYSMON_SEQ_CPM5N = 0x80,
	XPM_NODEIDX_RST_SYSMON_SEQ_PMC = 0x81,
	XPM_NODEIDX_RST_USB0_PHY = 0x82,
	XPM_NODEIDX_RST_PDMA_1 = 0x83,
	XPM_NODEIDX_RST_PDMA_0 = 0x84,
	XPM_NODEIDX_RST_I2C = 0x85,
	XPM_NODEIDX_RST_DBG_CPM5N = 0x86,
	XPM_NODEIDX_RST_DBG_PMC = 0x87,
	XPM_NODEIDX_RST_DBG_DPC = 0x88,
	XPM_NODEIDX_RST_PKI = 0x89,
	XPM_NODEIDX_RST_FPD_SWDT_2 = 0x8A,
	XPM_NODEIDX_RST_FMU = 0x8B,
	XPM_NODEIDX_RST_FPD_SWDT_1 = 0x8C,
	XPM_NODEIDX_RST_MMU_TBU_3 = 0x8D,
	XPM_NODEIDX_RST_MMU_GLOBAL = 0x8E,
	XPM_NODEIDX_RST_MMU_TBU_4 = 0x8F,
	XPM_NODEIDX_RST_MMU_TBU_9 = 0x90,
	XPM_NODEIDX_RST_MMU_TBU_5 = 0x91,
	XPM_NODEIDX_RST_MMU_TBU_0 = 0x92,
	XPM_NODEIDX_RST_MMU_TBU_7 = 0x93,
	XPM_NODEIDX_RST_MMU_TBU_1 = 0x94,
	XPM_NODEIDX_RST_MMU_TBU_8 = 0x95,
	XPM_NODEIDX_RST_MMU_TBU_6 = 0x96,
	XPM_NODEIDX_RST_MMU_TBU_10 = 0x97,
	XPM_NODEIDX_RST_MMU_TBU_2 = 0x98,
	XPM_NODEIDX_RST_APU3_CORE1_WARM = 0x99,
	XPM_NODEIDX_RST_APU3_CORE3_COLD = 0x9A,
	XPM_NODEIDX_RST_APU3_CORE0_COLD = 0x9B,
	XPM_NODEIDX_RST_APU3_CORE1_COLD = 0x9C,
	XPM_NODEIDX_RST_APU3_CLUSTER_COLD = 0x9D,
	XPM_NODEIDX_RST_APU3_CORE0_WARM = 0x9E,
	XPM_NODEIDX_RST_APU3_CORE2_COLD = 0x9F,
	XPM_NODEIDX_RST_APU3_CORE2_WARM = 0xA0,
	XPM_NODEIDX_RST_APU3_CORE3_WARM = 0xA1,
	XPM_NODEIDX_RST_APU3_CLUSTER_WARM = 0xA2,
	XPM_NODEIDX_RST_FPD_SWDT_3 = 0xA3,
	XPM_NODEIDX_RST_APU1_CORE1_WARM = 0xA4,
	XPM_NODEIDX_RST_APU1_CORE3_COLD = 0xA5,
	XPM_NODEIDX_RST_APU1_CORE0_COLD = 0xA6,
	XPM_NODEIDX_RST_APU1_CORE1_COLD = 0xA7,
	XPM_NODEIDX_RST_APU1_CLUSTER_COLD = 0xA8,
	XPM_NODEIDX_RST_APU1_CORE0_WARM = 0xA9,
	XPM_NODEIDX_RST_APU1_CORE2_COLD = 0xAA,
	XPM_NODEIDX_RST_APU1_CORE2_WARM = 0xAB,
	XPM_NODEIDX_RST_APU1_CORE3_WARM = 0xAC,
	XPM_NODEIDX_RST_APU1_CLUSTER_WARM = 0xAD,
	XPM_NODEIDX_RST_CPI = 0xAE,
	XPM_NODEIDX_RST_APU0_CORE1_WARM = 0xAF,
	XPM_NODEIDX_RST_APU0_CORE3_COLD = 0xB0,
	XPM_NODEIDX_RST_APU0_CORE0_COLD = 0xB1,
	XPM_NODEIDX_RST_APU0_CORE1_COLD = 0xB2,
	XPM_NODEIDX_RST_APU0_CLUSTER_COLD = 0xB3,
	XPM_NODEIDX_RST_APU0_CORE0_WARM = 0xB4,
	XPM_NODEIDX_RST_APU0_CORE2_COLD = 0xB5,
	XPM_NODEIDX_RST_APU0_CORE2_WARM = 0xB6,
	XPM_NODEIDX_RST_APU0_CORE3_WARM = 0xB7,
	XPM_NODEIDX_RST_APU0_CLUSTER_WARM = 0xB8,
	XPM_NODEIDX_RST_FPD_SWDT_0 = 0xB9,
	XPM_NODEIDX_RST_APU2_CORE1_WARM = 0xBA,
	XPM_NODEIDX_RST_APU2_CORE3_COLD = 0xBB,
	XPM_NODEIDX_RST_APU2_CORE0_COLD = 0xBC,
	XPM_NODEIDX_RST_APU2_CORE1_COLD = 0xBD,
	XPM_NODEIDX_RST_APU2_CLUSTER_COLD = 0xBE,
	XPM_NODEIDX_RST_APU2_CORE0_WARM = 0xBF,
	XPM_NODEIDX_RST_APU2_CORE2_COLD = 0xC0,
	XPM_NODEIDX_RST_APU2_CORE2_WARM = 0xC1,
	XPM_NODEIDX_RST_APU2_CORE3_WARM = 0xC2,
	XPM_NODEIDX_RST_APU2_CLUSTER_WARM = 0xC3,
	XPM_NODEIDX_RST_CMN_CXS = 0xC4,
	XPM_NODEIDX_RST_CMN_CGL = 0xC5,
	XPM_NODEIDX_RST_USB_1 = 0xC6,
	XPM_NODEIDX_RST_SWDT_1 = 0xC7,
	XPM_NODEIDX_RST_SWDT_0 = 0xC8,
	XPM_NODEIDX_RST_RPU_A_GD = 0xC9,
	XPM_NODEIDX_RST_RPU_B_GD = 0xCA,
	XPM_NODEIDX_RST_RPU_CORE0A = 0xCB,
	XPM_NODEIDX_RST_RPU_CORE0A_POR = 0xCC,
	XPM_NODEIDX_RST_RPU_CORE0B_POR = 0xCD,
	XPM_NODEIDX_RST_RPU_A_GD_TOP = 0xCE,
	XPM_NODEIDX_RST_RPU_CORE1B = 0xCF,
	XPM_NODEIDX_RST_RPU_B_TOPRESET = 0xD0,
	XPM_NODEIDX_RST_RPU_CORE1B_POR = 0xD1,
	XPM_NODEIDX_RST_RPU_CORE1A = 0xD2,
	XPM_NODEIDX_RST_RPU_B_GD_TOP = 0xD3,
	XPM_NODEIDX_RST_RPU_A_TOPRESET = 0xD4,
	XPM_NODEIDX_RST_RPU_B_DBGRST = 0xD5,
	XPM_NODEIDX_RST_RPU_A_DCLS_TOPRESET = 0xD6,
	XPM_NODEIDX_RST_RPU_CORE1A_POR = 0xD7,
	XPM_NODEIDX_RST_RPU_B_DCLS_TOPRESET = 0xD8,
	XPM_NODEIDX_RST_RPU_A_DBGRST = 0xD9,
	XPM_NODEIDX_RST_RPU_CORE0B = 0xDA,
	XPM_NODEIDX_RST_SYSMON_CFG_FPD = 0xDB,
	XPM_NODEIDX_RST_SYSMON_CFG_LPD = 0xDC,
	XPM_NODEIDX_RST_SYSMON_SEQ_FPD = 0xDD,
	XPM_NODEIDX_RST_SYSMON_SEQ_LPD = 0xDE,
	XPM_NODEIDX_RST_I3C_1 = 0xDF,
	XPM_NODEIDX_RST_I3C_0 = 0xE0,
	XPM_NODEIDX_RST_FPD_SRST = 0xE1,
	XPM_NODEIDX_RST_DBG_LPD_HSDP = 0xE2,
	XPM_NODEIDX_RST_PSM_MODE_WAKEUP = 0xE3,
	XPM_NODEIDX_RST_PSM_MODE_MODE = 0xE4,
	XPM_NODEIDX_RST_TIMESTAMP_FPD = 0xE5,
	XPM_NODEIDX_RST_TIMESTAMP_LPD = 0xE6,
	XPM_NODEIDX_RST_SWDT_4 = 0xE7,
	XPM_NODEIDX_RST_SWDT_3 = 0xE8,
	XPM_NODEIDX_RST_SWDT_2 = 0xE9,
	XPM_NODEIDX_RST_OCM_3 = 0xEA,
	XPM_NODEIDX_RST_OCM_2 = 0xEB,
	XPM_NODEIDX_RST_OCM_1 = 0xEC,
	XPM_NODEIDX_RST_OCM_0 = 0xED,
	XPM_NODEIDX_RST_ASU_GD_TOP = 0xEE,
	XPM_NODEIDX_RST_ASU_GD = 0xEF,
	XPM_NODEIDX_RST_RPU_GD_0_TOP = 0xF0,
	XPM_NODEIDX_RST_RPU_GD_0 = 0xF1,
	XPM_NODEIDX_RST_RPU_GD_1_TOP = 0xF2,
	XPM_NODEIDX_RST_RPU_GD_1 = 0xF3,
	XPM_NODEIDX_RST_RPU_CORE1C = 0xF4,
	XPM_NODEIDX_RST_RPU_C_TOPRESET = 0xF5,
	XPM_NODEIDX_RST_RPU_CORE1C_POR = 0xF6,
	XPM_NODEIDX_RST_RPU_CORE0C = 0xF7,
	XPM_NODEIDX_RST_RPU_CORE0C_POR = 0xF8,
	XPM_NODEIDX_RST_RPU_CORE1E = 0xF9,
	XPM_NODEIDX_RST_RPU_E_TOPRESET = 0xFA,
	XPM_NODEIDX_RST_RPU_CORE1E_POR = 0xFB,
	XPM_NODEIDX_RST_RPU_CORE0E = 0xFC,
	XPM_NODEIDX_RST_RPU_CORE0E_POR = 0xFD,
	XPM_NODEIDX_RST_RPU_CORE1D = 0xFE,
	XPM_NODEIDX_RST_RPU_D_TOPRESET = 0xFF,
	XPM_NODEIDX_RST_RPU_CORE1D_POR = 0x100,
	XPM_NODEIDX_RST_RPU_CORE0D = 0x101,
	XPM_NODEIDX_RST_RPU_CORE0D_POR = 0x102,
	XPM_NODEIDX_RST_UFS = 0x103,
	XPM_NODEIDX_RST_CAN_FD_2 = 0x104,
	XPM_NODEIDX_RST_CAN_FD_3 = 0x105,
	XPM_NODEIDX_RST_I3C_2 = 0x106,
	XPM_NODEIDX_RST_I3C_3 = 0x107,
	XPM_NODEIDX_RST_I3C_4 = 0x108,
	XPM_NODEIDX_RST_I3C_5 = 0x109,
	XPM_NODEIDX_RST_I3C_6 = 0x10A,
	XPM_NODEIDX_RST_I3C_7 = 0x10B,
	XPM_NODEIDX_RST_TTC_4 = 0x10C,
	XPM_NODEIDX_RST_TTC_5 = 0x10D,
	XPM_NODEIDX_RST_TTC_6 = 0x10E,
	XPM_NODEIDX_RST_TTC_7 = 0x10F,
	XPM_NODEIDX_RST_GT_CPM6 = 0x110,
	XPM_NODEIDX_RST_LSBUS_CTRL = 0x111,
	XPM_NODEIDX_RST_SYSMON_CFG_CPM6 = 0x112,
	XPM_NODEIDX_RST_SYSMON_SEQ_CPM6 = 0x113,
	XPM_NODEIDX_RST_CPM_CORE_MISC = 0x114,
	XPM_NODEIDX_RST_XAPE0 = 0x115,
	XPM_NODEIDX_RST_XAPE1 = 0x116,
	XPM_NODEIDX_RST_INTC_LPBK = 0x117,
	XPM_NODEIDX_RST_CHIPPIPE_SRST = 0x118,
	XPM_NODEIDX_RST_DC = 0x119,
	XPM_NODEIDX_RST_GPU = 0x11A,
	XPM_NODEIDX_RST_GPU_RECOV = 0x11B,
	XPM_NODEIDX_RST_ASU_MB_SOFT = 0x11C,
	XPM_NODEIDX_RST_UDH_AUX = 0x11D,
	XPM_NODEIDX_RST_UDH_DP = 0x11E,
	XPM_NODEIDX_RST_UDH_HDCPRAM = 0x11F,
	XPM_NODEIDX_RST_MAX = 0x120
} XPm_ResetNodeIdx;

/* MEMIC node index */
typedef enum {
	XPM_NODEIDX_MEMIC_NMU_0 = 0x0,
	XPM_NODEIDX_MEMIC_NMU_1 = 0x1,
	XPM_NODEIDX_MEMIC_NMU_2 = 0x2,
	XPM_NODEIDX_MEMIC_NMU_3 = 0x3,
	XPM_NODEIDX_MEMIC_NMU_4 = 0x4,
	XPM_NODEIDX_MEMIC_NMU_5 = 0x5,
	XPM_NODEIDX_MEMIC_NMU_6 = 0x6,
	XPM_NODEIDX_MEMIC_NMU_7 = 0x7,
	XPM_NODEIDX_MEMIC_NMU_8 = 0x8,
	XPM_NODEIDX_MEMIC_NMU_9 = 0x9,
	XPM_NODEIDX_MEMIC_NMU_10 = 0xA,
	XPM_NODEIDX_MEMIC_NMU_11 = 0xB,
	XPM_NODEIDX_MEMIC_NMU_12 = 0xC,
	XPM_NODEIDX_MEMIC_NMU_13 = 0xD,
	XPM_NODEIDX_MEMIC_NMU_14 = 0xE,
	XPM_NODEIDX_MEMIC_NMU_15 = 0xF,
	XPM_NODEIDX_MEMIC_NMU_16 = 0x10,
	XPM_NODEIDX_MEMIC_NMU_17 = 0x11,
	XPM_NODEIDX_MEMIC_NMU_18 = 0x12,
	XPM_NODEIDX_MEMIC_NMU_19 = 0x13,
	XPM_NODEIDX_MEMIC_NMU_20 = 0x14,
	XPM_NODEIDX_MEMIC_NMU_21 = 0x15,
	XPM_NODEIDX_MEMIC_NMU_22 = 0x16,
	XPM_NODEIDX_MEMIC_NMU_23 = 0x17,
	XPM_NODEIDX_MEMIC_NMU_24 = 0x18,
	XPM_NODEIDX_MEMIC_NMU_25 = 0x19,
	XPM_NODEIDX_MEMIC_NMU_26 = 0x1A,
	XPM_NODEIDX_MEMIC_NMU_27 = 0x1B,
	XPM_NODEIDX_MEMIC_NMU_28 = 0x1C,
	XPM_NODEIDX_MEMIC_NMU_29 = 0x1D,
	XPM_NODEIDX_MEMIC_NMU_30 = 0x1E,
	XPM_NODEIDX_MEMIC_NMU_31 = 0x1F,
	XPM_NODEIDX_MEMIC_NMU_32 = 0x20,
	XPM_NODEIDX_MEMIC_NMU_33 = 0x21,
	XPM_NODEIDX_MEMIC_NMU_34 = 0x22,
	XPM_NODEIDX_MEMIC_NMU_35 = 0x23,
	XPM_NODEIDX_MEMIC_NMU_36 = 0x24,
	XPM_NODEIDX_MEMIC_NMU_37 = 0x25,
	XPM_NODEIDX_MEMIC_NMU_38 = 0x26,
	XPM_NODEIDX_MEMIC_NMU_39 = 0x27,
	XPM_NODEIDX_MEMIC_NMU_40 = 0x28,
	XPM_NODEIDX_MEMIC_NMU_41 = 0x29,
	XPM_NODEIDX_MEMIC_NMU_42 = 0x2A,
	XPM_NODEIDX_MEMIC_NMU_43 = 0x2B,
	XPM_NODEIDX_MEMIC_NMU_44 = 0x2C,
	XPM_NODEIDX_MEMIC_NMU_45 = 0x2D,
	XPM_NODEIDX_MEMIC_NMU_46 = 0x2E,
	XPM_NODEIDX_MEMIC_NMU_47 = 0x2F,
	XPM_NODEIDX_MEMIC_NMU_48 = 0x30,
	XPM_NODEIDX_MEMIC_NMU_49 = 0x31,
	XPM_NODEIDX_MEMIC_NMU_50 = 0x32,
	XPM_NODEIDX_MEMIC_NMU_51 = 0x33,
	XPM_NODEIDX_MEMIC_NMU_52 = 0x34,
	XPM_NODEIDX_MEMIC_NMU_53 = 0x35,
	XPM_NODEIDX_MEMIC_NSU_0 = 0x36,
	XPM_NODEIDX_MEMIC_NSU_1 = 0x37,
	XPM_NODEIDX_MEMIC_NSU_2 = 0x38,
	XPM_NODEIDX_MEMIC_NSU_3 = 0x39,
	XPM_NODEIDX_MEMIC_NSU_4 = 0x3A,
	XPM_NODEIDX_MEMIC_NSU_5 = 0x3B,
	XPM_NODEIDX_MEMIC_NSU_6 = 0x3C,
	XPM_NODEIDX_MEMIC_NSU_7 = 0x3D,
	XPM_NODEIDX_MEMIC_NSU_8 = 0x3E,
	XPM_NODEIDX_MEMIC_NSU_9 = 0x3F,
	XPM_NODEIDX_MEMIC_NSU_10 = 0x40,
	XPM_NODEIDX_MEMIC_NSU_11 = 0x41,
	XPM_NODEIDX_MEMIC_NSU_12 = 0x42,
	XPM_NODEIDX_MEMIC_NSU_13 = 0x43,
	XPM_NODEIDX_MEMIC_NSU_14 = 0x44,
	XPM_NODEIDX_MEMIC_NSU_15 = 0x45,
	XPM_NODEIDX_MEMIC_NSU_16 = 0x46,
	XPM_NODEIDX_MEMIC_NSU_17 = 0x47,
	XPM_NODEIDX_MEMIC_NSU_18 = 0x48,
	XPM_NODEIDX_MEMIC_NSU_19 = 0x49,
	XPM_NODEIDX_MEMIC_NSU_20 = 0x4A,
	XPM_NODEIDX_MEMIC_NSU_21 = 0x4B,
	XPM_NODEIDX_MEMIC_NSU_22 = 0x4C,
	XPM_NODEIDX_MEMIC_NSU_23 = 0x4D,
	XPM_NODEIDX_MEMIC_NSU_24 = 0x4E,
	XPM_NODEIDX_MEMIC_NSU_25 = 0x4F,
	XPM_NODEIDX_MEMIC_NSU_26 = 0x50,
	XPM_NODEIDX_MEMIC_NSU_27 = 0x51,
	XPM_NODEIDX_MEMIC_NSU_28 = 0x52,
	XPM_NODEIDX_MEMIC_NSU_29 = 0x53,
	XPM_NODEIDX_MEMIC_NSU_30 = 0x54,
	XPM_NODEIDX_MEMIC_NSU_31 = 0x55,
	XPM_NODEIDX_MEMIC_NSU_32 = 0x56,
	XPM_NODEIDX_MEMIC_NSU_33 = 0x57,
	XPM_NODEIDX_MEMIC_NSU_34 = 0x58,
	XPM_NODEIDX_MEMIC_NSU_35 = 0x59,
	XPM_NODEIDX_MEMIC_NSU_36 = 0x5A,
	XPM_NODEIDX_MEMIC_NSU_37 = 0x5B,
	XPM_NODEIDX_MEMIC_NSU_38 = 0x5C,
	XPM_NODEIDX_MEMIC_NSU_39 = 0x5D,
	XPM_NODEIDX_MEMIC_NSU_40 = 0x5E,
	XPM_NODEIDX_MEMIC_NSU_41 = 0x5F,
	XPM_NODEIDX_MEMIC_NSU_42 = 0x60,
	XPM_NODEIDX_MEMIC_NSU_43 = 0x61,
	XPM_NODEIDX_MEMIC_NSU_44 = 0x62,
	XPM_NODEIDX_MEMIC_NSU_45 = 0x63,
	XPM_NODEIDX_MEMIC_NSU_46 = 0x64,
	XPM_NODEIDX_MEMIC_NSU_47 = 0x65,
	XPM_NODEIDX_MEMIC_NSU_48 = 0x66,
	XPM_NODEIDX_MEMIC_NSU_49 = 0x67,
	XPM_NODEIDX_MEMIC_NMU_54 = 0x68,
	XPM_NODEIDX_MEMIC_NMU_55 = 0x69,
	XPM_NODEIDX_MEMIC_NMU_56 = 0x6A,
	XPM_NODEIDX_MEMIC_NMU_57 = 0x6B,
	XPM_NODEIDX_MEMIC_NMU_58 = 0x6C,
	XPM_NODEIDX_MEMIC_NMU_59 = 0x6D,
	XPM_NODEIDX_MEMIC_NMU_60 = 0x6E,
	XPM_NODEIDX_MEMIC_NMU_61 = 0x6F,
	XPM_NODEIDX_MEMIC_NMU_62 = 0x70,
	XPM_NODEIDX_MEMIC_NMU_63 = 0x71,
	XPM_NODEIDX_MEMIC_NMU_64 = 0x72,
	XPM_NODEIDX_MEMIC_NMU_65 = 0x73,
	XPM_NODEIDX_MEMIC_NMU_66 = 0x74,
	XPM_NODEIDX_MEMIC_NMU_67 = 0x75,
	XPM_NODEIDX_MEMIC_NMU_68 = 0x76,
	XPM_NODEIDX_MEMIC_NMU_69 = 0x77,
	XPM_NODEIDX_MEMIC_NMU_70 = 0x78,
	XPM_NODEIDX_MEMIC_NMU_71 = 0x79,
	XPM_NODEIDX_MEMIC_NMU_72 = 0x7A,
	XPM_NODEIDX_MEMIC_NMU_73 = 0x7B,
	XPM_NODEIDX_MEMIC_NMU_74 = 0x7C,
	XPM_NODEIDX_MEMIC_NMU_75 = 0x7D,
	XPM_NODEIDX_MEMIC_NMU_76 = 0x7E,
	XPM_NODEIDX_MEMIC_NMU_77 = 0x7F,
	XPM_NODEIDX_MEMIC_NMU_78 = 0x80,
	XPM_NODEIDX_MEMIC_NMU_79 = 0x81,
	XPM_NODEIDX_MEMIC_NMU_80 = 0x82,
	XPM_NODEIDX_MEMIC_NMU_81 = 0x83,
	XPM_NODEIDX_MEMIC_NMU_82 = 0x84,
	XPM_NODEIDX_MEMIC_NMU_83 = 0x85,
	XPM_NODEIDX_MEMIC_NMU_84 = 0x86,
	XPM_NODEIDX_MEMIC_NMU_85 = 0x87,
	XPM_NODEIDX_MEMIC_NMU_86 = 0x88,
	XPM_NODEIDX_MEMIC_NMU_87 = 0x89,
	XPM_NODEIDX_MEMIC_NMU_88 = 0x8A,
	XPM_NODEIDX_MEMIC_NMU_89 = 0x8B,
	XPM_NODEIDX_MEMIC_NMU_90 = 0x8C,
	XPM_NODEIDX_MEMIC_NMU_91 = 0x8D,
	XPM_NODEIDX_MEMIC_NMU_92 = 0x8E,
	XPM_NODEIDX_MEMIC_NMU_93 = 0x8F,
	XPM_NODEIDX_MEMIC_NMU_94 = 0x90,
	XPM_NODEIDX_MEMIC_NMU_95 = 0x91,
	XPM_NODEIDX_MEMIC_NMU_96 = 0x92,
	XPM_NODEIDX_MEMIC_NMU_97 = 0x93,
	XPM_NODEIDX_MEMIC_NSU_50 = 0x94,
	XPM_NODEIDX_MEMIC_NSU_51 = 0x95,
	XPM_NODEIDX_MEMIC_NSU_52 = 0x96,
	XPM_NODEIDX_MEMIC_NSU_53 = 0x97,
	XPM_NODEIDX_MEMIC_NSU_54 = 0x98,
	XPM_NODEIDX_MEMIC_NSU_55 = 0x99,
	XPM_NODEIDX_MEMIC_NSU_56 = 0x9A,
	XPM_NODEIDX_MEMIC_NSU_57 = 0x9B,
	XPM_NODEIDX_MEMIC_MAX = 0x9C
} XPm_MemicNodeIdx;

/* Pin node index */
typedef enum {
	XPM_NODEIDX_STMIC_MIN = 0x0,
	XPM_NODEIDX_STMIC_LMIO_0 = 0x1,
	XPM_NODEIDX_STMIC_LMIO_1 = 0x2,
	XPM_NODEIDX_STMIC_LMIO_2 = 0x3,
	XPM_NODEIDX_STMIC_LMIO_3 = 0x4,
	XPM_NODEIDX_STMIC_LMIO_4 = 0x5,
	XPM_NODEIDX_STMIC_LMIO_5 = 0x6,
	XPM_NODEIDX_STMIC_LMIO_6 = 0x7,
	XPM_NODEIDX_STMIC_LMIO_7 = 0x8,
	XPM_NODEIDX_STMIC_LMIO_8 = 0x9,
	XPM_NODEIDX_STMIC_LMIO_9 = 0xA,
	XPM_NODEIDX_STMIC_LMIO_10 = 0xB,
	XPM_NODEIDX_STMIC_LMIO_11 = 0xC,
	XPM_NODEIDX_STMIC_LMIO_12 = 0xD,
	XPM_NODEIDX_STMIC_LMIO_13 = 0xE,
	XPM_NODEIDX_STMIC_LMIO_14 = 0xF,
	XPM_NODEIDX_STMIC_LMIO_15 = 0x10,
	XPM_NODEIDX_STMIC_LMIO_16 = 0x11,
	XPM_NODEIDX_STMIC_LMIO_17 = 0x12,
	XPM_NODEIDX_STMIC_LMIO_18 = 0x13,
	XPM_NODEIDX_STMIC_LMIO_19 = 0x14,
	XPM_NODEIDX_STMIC_LMIO_20 = 0x15,
	XPM_NODEIDX_STMIC_LMIO_21 = 0x16,
	XPM_NODEIDX_STMIC_LMIO_22 = 0x17,
	XPM_NODEIDX_STMIC_LMIO_23 = 0x18,
	XPM_NODEIDX_STMIC_LMIO_24 = 0x19,
	XPM_NODEIDX_STMIC_LMIO_25 = 0x1A,
	XPM_NODEIDX_STMIC_PMIO_0 = 0x1B,
	XPM_NODEIDX_STMIC_PMIO_1 = 0x1C,
	XPM_NODEIDX_STMIC_PMIO_2 = 0x1D,
	XPM_NODEIDX_STMIC_PMIO_3 = 0x1E,
	XPM_NODEIDX_STMIC_PMIO_4 = 0x1F,
	XPM_NODEIDX_STMIC_PMIO_5 = 0x20,
	XPM_NODEIDX_STMIC_PMIO_6 = 0x21,
	XPM_NODEIDX_STMIC_PMIO_7 = 0x22,
	XPM_NODEIDX_STMIC_PMIO_8 = 0x23,
	XPM_NODEIDX_STMIC_PMIO_9 = 0x24,
	XPM_NODEIDX_STMIC_PMIO_10 = 0x25,
	XPM_NODEIDX_STMIC_PMIO_11 = 0x26,
	XPM_NODEIDX_STMIC_PMIO_12 = 0x27,
	XPM_NODEIDX_STMIC_PMIO_13 = 0x28,
	XPM_NODEIDX_STMIC_PMIO_14 = 0x29,
	XPM_NODEIDX_STMIC_PMIO_15 = 0x2A,
	XPM_NODEIDX_STMIC_PMIO_16 = 0x2B,
	XPM_NODEIDX_STMIC_PMIO_17 = 0x2C,
	XPM_NODEIDX_STMIC_PMIO_18 = 0x2D,
	XPM_NODEIDX_STMIC_PMIO_19 = 0x2E,
	XPM_NODEIDX_STMIC_PMIO_20 = 0x2F,
	XPM_NODEIDX_STMIC_PMIO_21 = 0x30,
	XPM_NODEIDX_STMIC_PMIO_22 = 0x31,
	XPM_NODEIDX_STMIC_PMIO_23 = 0x32,
	XPM_NODEIDX_STMIC_PMIO_24 = 0x33,
	XPM_NODEIDX_STMIC_PMIO_25 = 0x34,
	XPM_NODEIDX_STMIC_PMIO_26 = 0x35,
	XPM_NODEIDX_STMIC_PMIO_27 = 0x36,
	XPM_NODEIDX_STMIC_PMIO_28 = 0x37,
	XPM_NODEIDX_STMIC_PMIO_29 = 0x38,
	XPM_NODEIDX_STMIC_PMIO_30 = 0x39,
	XPM_NODEIDX_STMIC_PMIO_31 = 0x3A,
	XPM_NODEIDX_STMIC_PMIO_32 = 0x3B,
	XPM_NODEIDX_STMIC_PMIO_33 = 0x3C,
	XPM_NODEIDX_STMIC_PMIO_34 = 0x3D,
	XPM_NODEIDX_STMIC_PMIO_35 = 0x3E,
	XPM_NODEIDX_STMIC_PMIO_36 = 0x3F,
	XPM_NODEIDX_STMIC_PMIO_37 = 0x40,
	XPM_NODEIDX_STMIC_PMIO_38 = 0x41,
	XPM_NODEIDX_STMIC_PMIO_39 = 0x42,
	XPM_NODEIDX_STMIC_PMIO_40 = 0x43,
	XPM_NODEIDX_STMIC_PMIO_41 = 0x44,
	XPM_NODEIDX_STMIC_PMIO_42 = 0x45,
	XPM_NODEIDX_STMIC_PMIO_43 = 0x46,
	XPM_NODEIDX_STMIC_PMIO_44 = 0x47,
	XPM_NODEIDX_STMIC_PMIO_45 = 0x48,
	XPM_NODEIDX_STMIC_PMIO_46 = 0x49,
	XPM_NODEIDX_STMIC_PMIO_47 = 0x4A,
	XPM_NODEIDX_STMIC_PMIO_48 = 0x4B,
	XPM_NODEIDX_STMIC_PMIO_49 = 0x4C,
	XPM_NODEIDX_STMIC_PMIO_50 = 0x4D,
	XPM_NODEIDX_STMIC_PMIO_51 = 0x4E,
	XPM_NODEIDX_STMIC_MAX = 0x4F
} XPm_PinNodeIdx;

/* Device node index */
typedef enum {
	XPM_NODEIDX_DEV_MIN = 0x0,
	XPM_NODEIDX_DEV_PMC_PROC = 0x1,
	XPM_NODEIDX_DEV_PSM_PROC = 0x2,
	XPM_NODEIDX_DEV_ACPU_0 = 0x3,
	XPM_NODEIDX_DEV_ACPU_1 = 0x4,
	XPM_NODEIDX_DEV_RPU0_0 = 0x5,
	XPM_NODEIDX_DEV_RPU0_1 = 0x6,
	XPM_NODEIDX_DEV_OCM_0 = 0x7,
	XPM_NODEIDX_DEV_OCM_1 = 0x8,
	XPM_NODEIDX_DEV_OCM_2 = 0x9,
	XPM_NODEIDX_DEV_OCM_3 = 0xA,
	XPM_NODEIDX_DEV_TCM_0_A = 0xB,
	XPM_NODEIDX_DEV_TCM_0_B = 0xC,
	XPM_NODEIDX_DEV_TCM_1_A = 0xD,
	XPM_NODEIDX_DEV_TCM_1_B = 0xE,
	XPM_NODEIDX_DEV_L2_BANK_0 = 0xF,
	XPM_NODEIDX_DEV_DDR_0 = 0x10,
	XPM_NODEIDX_DEV_DDR_1 = 0x11,
	XPM_NODEIDX_DEV_DDR_2 = 0x12,
	XPM_NODEIDX_DEV_DDR_3 = 0x13,
	XPM_NODEIDX_DEV_DDR_4 = 0x14,
	XPM_NODEIDX_DEV_DDR_5 = 0x15,
	XPM_NODEIDX_DEV_DDR_6 = 0x16,
	XPM_NODEIDX_DEV_DDR_7 = 0x17,
	XPM_NODEIDX_DEV_USB_0 = 0x18,
	XPM_NODEIDX_DEV_GEM_0 = 0x19,
	XPM_NODEIDX_DEV_GEM_1 = 0x1A,
	XPM_NODEIDX_DEV_SPI_0 = 0x1B,
	XPM_NODEIDX_DEV_SPI_1 = 0x1C,
	XPM_NODEIDX_DEV_I2C_0 = 0x1D,
	XPM_NODEIDX_DEV_I2C_1 = 0x1E,
	XPM_NODEIDX_DEV_CAN_FD_0 = 0x1F,
	XPM_NODEIDX_DEV_CAN_FD_1 = 0x20,
	XPM_NODEIDX_DEV_UART_0 = 0x21,
	XPM_NODEIDX_DEV_UART_1 = 0x22,
	XPM_NODEIDX_DEV_GPIO = 0x23,
	XPM_NODEIDX_DEV_TTC_0 = 0x24,
	XPM_NODEIDX_DEV_TTC_1 = 0x25,
	XPM_NODEIDX_DEV_TTC_2 = 0x26,
	XPM_NODEIDX_DEV_TTC_3 = 0x27,
	XPM_NODEIDX_DEV_SWDT_LPD = 0x28,
	XPM_NODEIDX_DEV_SWDT_FPD = 0x29,
	XPM_NODEIDX_DEV_OSPI = 0x2A,
	XPM_NODEIDX_DEV_QSPI = 0x2B,
	XPM_NODEIDX_DEV_GPIO_PMC = 0x2C,
	XPM_NODEIDX_DEV_I2C_PMC = 0x2D,
	XPM_NODEIDX_DEV_SDIO_0 = 0x2E,
	XPM_NODEIDX_DEV_SDIO_1 = 0x2F,
	XPM_NODEIDX_DEV_PL_0 = 0x30,
	XPM_NODEIDX_DEV_PL_1 = 0x31,
	XPM_NODEIDX_DEV_PL_2 = 0x32,
	XPM_NODEIDX_DEV_PL_3 = 0x33,
	XPM_NODEIDX_DEV_RTC = 0x34,
	XPM_NODEIDX_DEV_ADMA_0 = 0x35,
	XPM_NODEIDX_DEV_ADMA_1 = 0x36,
	XPM_NODEIDX_DEV_ADMA_2 = 0x37,
	XPM_NODEIDX_DEV_ADMA_3 = 0x38,
	XPM_NODEIDX_DEV_ADMA_4 = 0x39,
	XPM_NODEIDX_DEV_ADMA_5 = 0x3A,
	XPM_NODEIDX_DEV_ADMA_6 = 0x3B,
	XPM_NODEIDX_DEV_ADMA_7 = 0x3C,
	XPM_NODEIDX_DEV_IPI_0 = 0x3D,
	XPM_NODEIDX_DEV_IPI_1 = 0x3E,
	XPM_NODEIDX_DEV_IPI_2 = 0x3F,
	XPM_NODEIDX_DEV_IPI_3 = 0x40,
	XPM_NODEIDX_DEV_IPI_4 = 0x41,
	XPM_NODEIDX_DEV_IPI_5 = 0x42,
	XPM_NODEIDX_DEV_IPI_6 = 0x43,
	XPM_NODEIDX_DEV_SOC = 0x44,
	XPM_NODEIDX_DEV_DDRMC_0 = 0x45,
	XPM_NODEIDX_DEV_DDRMC_1 = 0x46,
	XPM_NODEIDX_DEV_DDRMC_2 = 0x47,
	XPM_NODEIDX_DEV_DDRMC_3 = 0x48,
	XPM_NODEIDX_DEV_GT_0 = 0x49,
	XPM_NODEIDX_DEV_GT_1 = 0x4A,
	XPM_NODEIDX_DEV_GT_2 = 0x4B,
	XPM_NODEIDX_DEV_GT_3 = 0x4C,
	XPM_NODEIDX_DEV_GT_4 = 0x4D,
	XPM_NODEIDX_DEV_GT_5 = 0x4E,
	XPM_NODEIDX_DEV_GT_6 = 0x4F,
	XPM_NODEIDX_DEV_GT_7 = 0x50,
	XPM_NODEIDX_DEV_GT_8 = 0x51,
	XPM_NODEIDX_DEV_GT_9 = 0x52,
	XPM_NODEIDX_DEV_GT_10 = 0x53,
	XPM_NODEIDX_DEV_EFUSE_CACHE = 0x54,
	XPM_NODEIDX_DEV_AMS_ROOT = 0x55,
	XPM_NODEIDX_DEV_XRAM_0 = 0x56,
	XPM_NODEIDX_DEV_XRAM_1 = 0x57,
	XPM_NODEIDX_DEV_XRAM_2 = 0x58,
	XPM_NODEIDX_DEV_XRAM_3 = 0x59,
	XPM_NODEIDX_DEV_XRAM_4 = 0x5A,
	XPM_NODEIDX_DEV_XRAM_5 = 0x5B,
	XPM_NODEIDX_DEV_XRAM_6 = 0x5C,
	XPM_NODEIDX_DEV_XRAM_7 = 0x5D,
	XPM_NODEIDX_DEV_XRAM_8 = 0x5E,
	XPM_NODEIDX_DEV_XRAM_9 = 0x5F,
	XPM_NODEIDX_DEV_XRAM_10 = 0x60,
	XPM_NODEIDX_DEV_XRAM_11 = 0x61,
	XPM_NODEIDX_DEV_XRAM_12 = 0x62,
	XPM_NODEIDX_DEV_XRAM_13 = 0x63,
	XPM_NODEIDX_DEV_XRAM_14 = 0x64,
	XPM_NODEIDX_DEV_XRAM_15 = 0x65,
	XPM_NODEIDX_DEV_GTM_0 = 0x66,
	XPM_NODEIDX_DEV_GTM_1 = 0x67,
	XPM_NODEIDX_DEV_GTM_2 = 0x68,
	XPM_NODEIDX_DEV_GTM_3 = 0x69,
	XPM_NODEIDX_DEV_GTM_4 = 0x6A,
	XPM_NODEIDX_DEV_GTYP_0 = 0x6B,
	XPM_NODEIDX_DEV_GTYP_1 = 0x6C,
	XPM_NODEIDX_DEV_GTYP_2 = 0x6D,
	XPM_NODEIDX_DEV_GTYP_CPM5_0 = 0x6E,
	XPM_NODEIDX_DEV_GTYP_CPM5_1 = 0x6F,
	XPM_NODEIDX_DEV_GTYP_CPM5_2 = 0x70,
	XPM_NODEIDX_DEV_GTYP_CPM5_3 = 0x71,
	XPM_NODEIDX_DEV_AIE = 0x72,
	XPM_NODEIDX_DEV_IPI_PMC = 0x73,
	XPM_NODEIDX_DEV_GTM_5 = 0x74,
	XPM_NODEIDX_DEV_GTM_6 = 0x75,
	XPM_NODEIDX_DEV_GTM_7 = 0x76,
	XPM_NODEIDX_DEV_GTM_8 = 0x77,
	XPM_NODEIDX_DEV_GTM_9 = 0x78,
	XPM_NODEIDX_DEV_HBMMC_0 = 0x79,
	XPM_NODEIDX_DEV_HBMMC_1 = 0x7A,
	XPM_NODEIDX_DEV_HBMMC_2 = 0x7B,
	XPM_NODEIDX_DEV_HBMMC_3 = 0x7C,
	XPM_NODEIDX_DEV_HBMMC_4 = 0x7D,
	XPM_NODEIDX_DEV_HBMMC_5 = 0x7E,
	XPM_NODEIDX_DEV_HBMMC_6 = 0x7F,
	XPM_NODEIDX_DEV_HBMMC_7 = 0x80,
	XPM_NODEIDX_DEV_HBMMC_8 = 0x81,
	XPM_NODEIDX_DEV_HBMMC_9 = 0x82,
	XPM_NODEIDX_DEV_HBMMC_10 = 0x83,
	XPM_NODEIDX_DEV_HBMMC_11 = 0x84,
	XPM_NODEIDX_DEV_HBMMC_12 = 0x85,
	XPM_NODEIDX_DEV_HBMMC_13 = 0x86,
	XPM_NODEIDX_DEV_HBMMC_14 = 0x87,
	XPM_NODEIDX_DEV_HBMMC_15 = 0x88,
	XPM_NODEIDX_DEV_GTYP_3 = 0x89,
	XPM_NODEIDX_DEV_GTYP_4 = 0x8A,
	XPM_NODEIDX_DEV_GTYP_5 = 0x8B,
	XPM_NODEIDX_DEV_GTYP_6 = 0x8C,
	XPM_NODEIDX_DEV_GTYP_7 = 0x8D,
	XPM_NODEIDX_DEV_GTYP_8 = 0x8E,
	XPM_NODEIDX_DEV_GTYP_9 = 0x8F,
	XPM_NODEIDX_DEV_HBM_0 = 0x90,
	XPM_NODEIDX_DEV_VDU_0 = 0x91,
	XPM_NODEIDX_DEV_VDU_1 = 0x92,
	XPM_NODEIDX_DEV_VDU_2 = 0x93,
	XPM_NODEIDX_DEV_VDU_3 = 0x94,
	XPM_NODEIDX_DEV_GTM_10 = 0x95,
	XPM_NODEIDX_DEV_GTM_11 = 0x96,
	XPM_NODEIDX_DEV_GTM_12 = 0x97,
	XPM_NODEIDX_DEV_GTM_13 = 0x98,
	XPM_NODEIDX_DEV_GTM_14 = 0x99,
	XPM_NODEIDX_DEV_GTM_15 = 0x9A,
	XPM_NODEIDX_DEV_GTM_16 = 0x9B,
	XPM_NODEIDX_DEV_GTM_17 = 0x9C,
	XPM_NODEIDX_DEV_GTM_18 = 0x9D,
	XPM_NODEIDX_DEV_GTM_19 = 0x9E,
	XPM_NODEIDX_DEV_GTM_20 = 0x9F,
	XPM_NODEIDX_DEV_GTM_21 = 0xA0,
	XPM_NODEIDX_DEV_GTM_22 = 0xA1,
	XPM_NODEIDX_DEV_GTM_23 = 0xA2,
	XPM_NODEIDX_DEV_BFRB_0 = 0xA3,
	XPM_NODEIDX_DEV_BFRB_1 = 0xA4,
	XPM_NODEIDX_DEV_BFRB_2 = 0xA5,
	XPM_NODEIDX_DEV_BFRB_3 = 0xA6,
	XPM_NODEIDX_DEV_BFRB_4 = 0xA7,
	XPM_NODEIDX_DEV_BFRB_5 = 0xA8,
	XPM_NODEIDX_DEV_BFRB_6 = 0xA9,
	XPM_NODEIDX_DEV_BFRB_7 = 0xAA,
	XPM_NODEIDX_DEV_BFRB_8 = 0xAB,
	XPM_NODEIDX_DEV_BFRB_9 = 0xAC,
	XPM_NODEIDX_DEV_BFRB_10 = 0xAD,
	XPM_NODEIDX_DEV_BFRB_11 = 0xAE,
	XPM_NODEIDX_DEV_ACPU_0_0 = 0xAF,
	XPM_NODEIDX_DEV_ACPU_0_1 = 0xB0,
	XPM_NODEIDX_DEV_ACPU_0_2 = 0xB1,
	XPM_NODEIDX_DEV_ACPU_0_3 = 0xB2,
	XPM_NODEIDX_DEV_ACPU_1_0 = 0xB3,
	XPM_NODEIDX_DEV_ACPU_1_1 = 0xB4,
	XPM_NODEIDX_DEV_ACPU_1_2 = 0xB5,
	XPM_NODEIDX_DEV_ACPU_1_3 = 0xB6,
	XPM_NODEIDX_DEV_ACPU_2_0 = 0xB7,
	XPM_NODEIDX_DEV_ACPU_2_1 = 0xB8,
	XPM_NODEIDX_DEV_ACPU_2_2 = 0xB9,
	XPM_NODEIDX_DEV_ACPU_2_3 = 0xBA,
	XPM_NODEIDX_DEV_ACPU_3_0 = 0xBB,
	XPM_NODEIDX_DEV_ACPU_3_1 = 0xBC,
	XPM_NODEIDX_DEV_ACPU_3_2 = 0xBD,
	XPM_NODEIDX_DEV_ACPU_3_3 = 0xBE,
	XPM_NODEIDX_DEV_RPU_A_0 = 0xBF,
	XPM_NODEIDX_DEV_RPU_A_1 = 0xC0,
	XPM_NODEIDX_DEV_RPU_B_0 = 0xC1,
	XPM_NODEIDX_DEV_RPU_B_1 = 0xC2,
	XPM_NODEIDX_DEV_OCM_0_0 = 0xC3,
	XPM_NODEIDX_DEV_OCM_0_1 = 0xC4,
	XPM_NODEIDX_DEV_OCM_0_2 = 0xC5,
	XPM_NODEIDX_DEV_OCM_0_3 = 0xC6,
	XPM_NODEIDX_DEV_OCM_1_0 = 0xC7,
	XPM_NODEIDX_DEV_OCM_1_1 = 0xC8,
	XPM_NODEIDX_DEV_OCM_1_2 = 0xC9,
	XPM_NODEIDX_DEV_OCM_1_3 = 0xCA,
	XPM_NODEIDX_DEV_TCM_A_0A = 0xCB,
	XPM_NODEIDX_DEV_TCM_A_0B = 0xCC,
	XPM_NODEIDX_DEV_TCM_A_0C = 0xCD,
	XPM_NODEIDX_DEV_TCM_A_1A = 0xCE,
	XPM_NODEIDX_DEV_TCM_A_1B = 0xCF,
	XPM_NODEIDX_DEV_TCM_A_1C = 0xD0,
	XPM_NODEIDX_DEV_TCM_B_0A = 0xD1,
	XPM_NODEIDX_DEV_TCM_B_0B = 0xD2,
	XPM_NODEIDX_DEV_TCM_B_0C = 0xD3,
	XPM_NODEIDX_DEV_TCM_B_1A = 0xD4,
	XPM_NODEIDX_DEV_TCM_B_1B = 0xD5,
	XPM_NODEIDX_DEV_TCM_B_1C = 0xD6,
	XPM_NODEIDX_DEV_USB_1 = 0xD7,
	XPM_NODEIDX_DEV_PMC_WWDT = 0xD8,
	XPM_NODEIDX_DEV_LPD_SWDT_0 = 0xD9,
	XPM_NODEIDX_DEV_LPD_SWDT_1 = 0xDA,
	XPM_NODEIDX_DEV_FPD_SWDT_0 = 0xDB,
	XPM_NODEIDX_DEV_FPD_SWDT_1 = 0xDC,
	XPM_NODEIDX_DEV_FPD_SWDT_2 = 0xDD,
	XPM_NODEIDX_DEV_FPD_SWDT_3 = 0xDE,
	XPM_NODEIDX_DEV_DDRMC_4 = 0xDF,
	XPM_NODEIDX_DEV_DDRMC_5 = 0xE0,
	XPM_NODEIDX_DEV_DDRMC_6 = 0xE1,
	XPM_NODEIDX_DEV_DDRMC_7 = 0xE2,
	XPM_NODEIDX_DEV_IPI_NOBUF_1 = 0xE3,
	XPM_NODEIDX_DEV_IPI_NOBUF_2 = 0xE4,
	XPM_NODEIDX_DEV_IPI_NOBUF_3 = 0xE5,
	XPM_NODEIDX_DEV_IPI_NOBUF_4 = 0xE6,
	XPM_NODEIDX_DEV_IPI_NOBUF_5 = 0xE7,
	XPM_NODEIDX_DEV_IPI_NOBUF_6 = 0xE8,
	XPM_NODEIDX_DEV_ADC_0 = 0xE9,
	XPM_NODEIDX_DEV_ADC_1 = 0xEA,
	XPM_NODEIDX_DEV_ADC_2 = 0xEB,
	XPM_NODEIDX_DEV_ADC_3 = 0xEC,
	XPM_NODEIDX_DEV_DAC_0 = 0xED,
	XPM_NODEIDX_DEV_DAC_1 = 0xEE,
	XPM_NODEIDX_DEV_DAC_2 = 0xEF,
	XPM_NODEIDX_DEV_DAC_3 = 0xF0,
	XPM_NODEIDX_DEV_RPU_C_0 = 0xF1,
	XPM_NODEIDX_DEV_RPU_C_1 = 0xF2,
	XPM_NODEIDX_DEV_RPU_D_0 = 0xF3,
	XPM_NODEIDX_DEV_RPU_D_1 = 0xF4,
	XPM_NODEIDX_DEV_RPU_E_0 = 0xF5,
	XPM_NODEIDX_DEV_RPU_E_1 = 0xF6,
	XPM_NODEIDX_DEV_ASU = 0xF7,
	XPM_NODEIDX_DEV_OCM_2_0 = 0xF8,
	XPM_NODEIDX_DEV_OCM_2_1 = 0xF9,
	XPM_NODEIDX_DEV_OCM_2_2 = 0xFA,
	XPM_NODEIDX_DEV_OCM_2_3 = 0xFB,
	XPM_NODEIDX_DEV_OCM_3_0 = 0xFC,
	XPM_NODEIDX_DEV_OCM_3_1 = 0xFD,
	XPM_NODEIDX_DEV_OCM_3_2 = 0xFE,
	XPM_NODEIDX_DEV_OCM_3_3 = 0xFF,
	XPM_NODEIDX_DEV_TCM_C_0A = 0x100,
	XPM_NODEIDX_DEV_TCM_C_0B = 0x101,
	XPM_NODEIDX_DEV_TCM_C_0C = 0x102,
	XPM_NODEIDX_DEV_TCM_C_1A = 0x103,
	XPM_NODEIDX_DEV_TCM_C_1B = 0x104,
	XPM_NODEIDX_DEV_TCM_C_1C = 0x105,
	XPM_NODEIDX_DEV_TCM_D_0A = 0x106,
	XPM_NODEIDX_DEV_TCM_D_0B = 0x107,
	XPM_NODEIDX_DEV_TCM_D_0C = 0x108,
	XPM_NODEIDX_DEV_TCM_D_1A = 0x109,
	XPM_NODEIDX_DEV_TCM_D_1B = 0x10A,
	XPM_NODEIDX_DEV_TCM_D_1C = 0x10B,
	XPM_NODEIDX_DEV_TCM_E_0A = 0x10C,
	XPM_NODEIDX_DEV_TCM_E_0B = 0x10D,
	XPM_NODEIDX_DEV_TCM_E_0C = 0x10E,
	XPM_NODEIDX_DEV_TCM_E_1A = 0x10F,
	XPM_NODEIDX_DEV_TCM_E_1B = 0x110,
	XPM_NODEIDX_DEV_TCM_E_1C = 0x111,
	XPM_NODEIDX_DEV_LPD_SWDT_2 = 0x112,
	XPM_NODEIDX_DEV_LPD_SWDT_3 = 0x113,
	XPM_NODEIDX_DEV_LPD_SWDT_4 = 0x114,
	XPM_NODEIDX_DEV_IPI_ASU = 0x115,
	XPM_NODEIDX_DEV_UFS = 0x116,
	XPM_NODEIDX_DEV_I2C_2 = 0x117,
	XPM_NODEIDX_DEV_I2C_3 = 0x118,
	XPM_NODEIDX_DEV_I2C_4 = 0x119,
	XPM_NODEIDX_DEV_I2C_5 = 0x11A,
	XPM_NODEIDX_DEV_I2C_6 = 0x11B,
	XPM_NODEIDX_DEV_I2C_7 = 0x11C,
	XPM_NODEIDX_DEV_CAN_FD_2 = 0x11D,
	XPM_NODEIDX_DEV_CAN_FD_3 = 0x11E,
	XPM_NODEIDX_DEV_TTC_4 = 0x11F,
	XPM_NODEIDX_DEV_TTC_5 = 0x120,
	XPM_NODEIDX_DEV_TTC_6 = 0x121,
	XPM_NODEIDX_DEV_TTC_7 = 0x122,
	XPM_NODEIDX_DEV_GTMPW_CPM6_0 = 0x123,
	XPM_NODEIDX_DEV_GTMPW_CPM6_1 = 0x124,
	XPM_NODEIDX_DEV_GTMPW_CPM6_2 = 0x125,
	XPM_NODEIDX_DEV_GTMPW_CPM6_3 = 0x126,
	XPM_NODEIDX_DEV_GTMPW_0 = 0x127,
	XPM_NODEIDX_DEV_GTMPW_1 = 0x128,
	XPM_NODEIDX_DEV_GTMPW_2 = 0x129,
	XPM_NODEIDX_DEV_GTMPW_3 = 0x12A,
	XPM_NODEIDX_DEV_GTMPW_4 = 0x12B,
	XPM_NODEIDX_DEV_GTMPW_5 = 0x12C,
	XPM_NODEIDX_DEV_GTMPW_6 = 0x12D,
	XPM_NODEIDX_DEV_GTMPW_7 = 0x12E,
	XPM_NODEIDX_DEV_GTMPW_8 = 0x12F,
	XPM_NODEIDX_DEV_GTMPW_9 = 0x130,
	XPM_NODEIDX_DEV_GTMPW_10 = 0x131,
	XPM_NODEIDX_DEV_GTMPW_11 = 0x132,
	XPM_NODEIDX_DEV_GTMPW_12 = 0x133,
	XPM_NODEIDX_DEV_GTMPW_13 = 0x134,
	XPM_NODEIDX_DEV_MMI_USB_DRD = 0x135,
	XPM_NODEIDX_DEV_MMI_GPU = 0x136,
	XPM_NODEIDX_DEV_MMI_DC = 0x137,
	XPM_NODEIDX_DEV_MMI_HDCP = 0x138,
	XPM_NODEIDX_DEV_MMI_DP = 0x139,
	XPM_NODEIDX_DEV_MAX = 0x13A
} XPm_DeviceNodeIdx;

/* PL Device node index */
typedef enum {
	XPM_NODEIDX_DEV_PLD_0 = 0x0,
	XPM_NODEIDX_DEV_PLD_MAX = 0x10
} XPm_PlDeviceNodeIdx;

/* Memory region device node index */
typedef enum {
	XPM_NODEIDX_DEV_MEM_REGN_MIN = 0x0,
	XPM_NODEIDX_DEV_MEM_REGN_MAX = 0x40
} XPm_MemRegnDeviceNodeIdx;

/* Virtual device node index */
typedef enum {
	XPM_NODEIDX_DEV_GGS_0 = 0x0,
	XPM_NODEIDX_DEV_GGS_1 = 0x1,
	XPM_NODEIDX_DEV_GGS_2 = 0x2,
	XPM_NODEIDX_DEV_GGS_3 = 0x3,
	XPM_NODEIDX_DEV_PGGS_0 = 0x4,
	XPM_NODEIDX_DEV_PGGS_1 = 0x5,
	XPM_NODEIDX_DEV_PGGS_RESERVED_0 = 0x6,
	XPM_NODEIDX_DEV_PGGS_RESERVED_1 = 0x7,
	XPM_NODEIDX_DEV_VIRT_MAX = 0x8
} XPm_VirtualDeviceNodeIdx;

/* Healthy boot monitor node index */
typedef enum {
	XPM_NODEIDX_DEV_HB_MON_0 = 0x0,
	XPM_NODEIDX_DEV_HB_MON_1 = 0x1,
	XPM_NODEIDX_DEV_HB_MON_2 = 0x2,
	XPM_NODEIDX_DEV_HB_MON_3 = 0x3,
	XPM_NODEIDX_DEV_HB_MON_MAX = 0x4
} XPm_HBMonDeviceNodeIdx;

/* AIE Device node index */
typedef enum {
	XPM_NODEIDX_DEV_AIE_0 = 0x0,
	XPM_NODEIDX_DEV_AIE_MAX = 0x10
} XPm_AieDeviceNodeIdx;

/* Subsystem node index */
typedef enum {
	XPM_NODEIDX_SUBSYS_DEFAULT = 0x0,
	XPM_NODEIDX_SUBSYS_PMC = 0x1,
	XPM_NODEIDX_SUBSYS_MAX = 0x10
} XPm_SubsystemNodeIdx;

/* Isolation node index */
typedef enum {
	XPM_NODEIDX_ISO_FPD_PL_TEST = 0x0,
	XPM_NODEIDX_ISO_FPD_PL = 0x1,
	XPM_NODEIDX_ISO_FPD_SOC = 0x2,
	XPM_NODEIDX_ISO_LPD_CPM_DFX = 0x3,
	XPM_NODEIDX_ISO_LPD_CPM = 0x4,
	XPM_NODEIDX_ISO_LPD_PL_TEST = 0x5,
	XPM_NODEIDX_ISO_LPD_PL = 0x6,
	XPM_NODEIDX_ISO_LPD_SOC = 0x7,
	XPM_NODEIDX_ISO_PMC_LPD_DFX = 0x8,
	XPM_NODEIDX_ISO_PMC_LPD = 0x9,
	XPM_NODEIDX_ISO_PMC_PL_CFRAME = 0xA,
	XPM_NODEIDX_ISO_PMC_PL_TEST = 0xB,
	XPM_NODEIDX_ISO_PMC_PL = 0xC,
	XPM_NODEIDX_ISO_PMC_SOC_NPI = 0xD,
	XPM_NODEIDX_ISO_PMC_SOC = 0xE,
	XPM_NODEIDX_ISO_PL_SOC = 0xF,
	XPM_NODEIDX_ISO_VCCAUX_SOC = 0x10,
	XPM_NODEIDX_ISO_VCCRAM_SOC = 0x11,
	XPM_NODEIDX_ISO_VCCAUX_VCCRAM = 0x12,
	XPM_NODEIDX_ISO_PL_CPM_PCIEA0_ATTR = 0x13,
	XPM_NODEIDX_ISO_PL_CPM_PCIEA1_ATTR = 0x14,
	XPM_NODEIDX_ISO_PL_CPM_RST_CPI0 = 0x15,
	XPM_NODEIDX_ISO_PL_CPM_RST_CPI1 = 0x16,
	XPM_NODEIDX_ISO_GEM_TSU_CLK = 0x17,
	XPM_NODEIDX_ISO_GEM0_TXRX_CLK = 0x18,
	XPM_NODEIDX_ISO_GEM1_TXRX_CLK = 0x19,
	XPM_NODEIDX_ISO_CPM5_PL = 0x1A,
	XPM_NODEIDX_ISO_CPM5_PL_AXIMM = 0x1B,
	XPM_NODEIDX_ISO_CPM5_PL_CHI0 = 0x1C,
	XPM_NODEIDX_ISO_CPM5_PL_CHI1 = 0x1D,
	XPM_NODEIDX_ISO_CPM5_PL_TST = 0x1E,
	XPM_NODEIDX_ISO_CPM5_PL_PCIEA0_MPIO = 0x1F,
	XPM_NODEIDX_ISO_CPM5_PL_PCIEA1_MPIO = 0x20,
	XPM_NODEIDX_ISO_CPM5_RAM = 0x21,
	XPM_NODEIDX_ISO_LPD_CPM5 = 0x22,
	XPM_NODEIDX_ISO_LPD_CPM5_DFX = 0x23,
	XPM_NODEIDX_ISO_XRAM_PL_AXI0 = 0x24,
	XPM_NODEIDX_ISO_XRAM_PL_AXI1 = 0x25,
	XPM_NODEIDX_ISO_XRAM_PL_AXI2 = 0x26,
	XPM_NODEIDX_ISO_XRAM_PL_AXILITE = 0x27,
	XPM_NODEIDX_ISO_XRAM_PL_FABRIC = 0x28,
	XPM_NODEIDX_ISO_CPM5_PL_DFX = 0x29,
	XPM_NODEIDX_ISO_CPM5_GT = 0x2A,
	XPM_NODEIDX_ISO_CPM5_GT_DFX = 0x2B,
	XPM_NODEIDX_ISO_PL_MISC_N = 0x2C,
	XPM_NODEIDX_ISO_PL_TEST_N = 0x2D,
	XPM_NODEIDX_ISO_TNOC_AXI_N = 0x2E,
	XPM_NODEIDX_ISO_PL_AXIST0_N = 0x2F,
	XPM_NODEIDX_ISO_PL_AXIST1_N = 0x30,
	XPM_NODEIDX_ISO_FPD_CPM5 = 0x31,
	XPM_NODEIDX_ISO_LPD_FPD_DFX = 0x32,
	XPM_NODEIDX_ISO_LPD_FPD = 0x33,
	XPM_NODEIDX_ISO_CPM5_LPD_DFX = 0x34,
	XPM_NODEIDX_ISO_FPD_CPM5_DFX = 0x35,
	XPM_NODEIDX_ISO_LPD_OCM2_DFX = 0x36,
	XPM_NODEIDX_ISO_LPD_OCM2 = 0x37,
	XPM_NODEIDX_ISO_CPM5_LPD = 0x38,
	XPM_NODEIDX_ISO_XRAM_PL_MAIN_CLK = 0x39,
	XPM_NODEIDX_ISO_PL_AXI_FPD0 = 0x3A,
	XPM_NODEIDX_ISO_PL_AXI_FPD1 = 0x3B,
	XPM_NODEIDX_ISO_PL_AXI_FPD2 = 0x3C,
	XPM_NODEIDX_ISO_PL_AXI_FPD3 = 0x3D,
	XPM_NODEIDX_ISO_FPD_AXI_PL = 0x3E,
	XPM_NODEIDX_ISO_PL_AXI_LPD = 0x3F,
	XPM_NODEIDX_ISO_LPD_AXI_PL = 0x40,
	XPM_NODEIDX_ISO_PL_CHI_FPD = 0x41,
	XPM_NODEIDX_ISO_PL_ACP_APU0 = 0x42,
	XPM_NODEIDX_ISO_PL_ACP_APU1 = 0x43,
	XPM_NODEIDX_ISO_PL_ACP_APU2 = 0x44,
	XPM_NODEIDX_ISO_PL_ACP_APU3 = 0x45,
	XPM_NODEIDX_ISO_PL_PS_DTI0 = 0x46,
	XPM_NODEIDX_ISO_PL_PS_DTI1 = 0x47,
	XPM_NODEIDX_ISO_CPM5_NOC_DFX = 0x48,
	XPM_NODEIDX_ISO_CPM5_NOC = 0x49,
	XPM_NODEIDX_ISO_MMI_PL_GEM_N = 0x4A,
	XPM_NODEIDX_ISO_MMI_PL_DC_N = 0x4B,
	XPM_NODEIDX_ISO_MMI_N = 0x4C,
	XPM_NODEIDX_ISO_MMI_PL_TEST_N = 0x4D,
	XPM_NODEIDX_ISO_MMI_PL_MISC_N = 0x4E,
	XPM_NODEIDX_ISO_LPD_CPM6_DFX = 0x4F,
	XPM_NODEIDX_ISO_LPD_CPM6 = 0x50,
	XPM_NODEIDX_ISO_ASU_PL_DATA = 0x51,
	XPM_NODEIDX_ISO_ASU_PL_KEY = 0x52,
	XPM_NODEIDX_ISO_MAX = 0x53
} XPm_IsolationNodeIdx;

/* Protection node indexes */
typedef enum {
	XPM_NODEIDX_PROT_MIN = 0x0,
	XPM_NODEIDX_PROT_XPPU_LPD = 0x1,
	XPM_NODEIDX_PROT_XPPU_PMC = 0x2,
	XPM_NODEIDX_PROT_XPPU_PMC_NPI = 0x3,
	XPM_NODEIDX_PROT_XMPU_FPD_SLAVES = 0x4,
	XPM_NODEIDX_PROT_XMPU_OCM = 0x5,
	XPM_NODEIDX_PROT_XMPU_PMC = 0x6,
	XPM_NODEIDX_PROT_XMPU_XRAM_0 = 0x7,
	XPM_NODEIDX_PROT_XMPU_XRAM_1 = 0x8,
	XPM_NODEIDX_PROT_XMPU_XRAM_2 = 0x9,
	XPM_NODEIDX_PROT_XMPU_XRAM_3 = 0xA,
	XPM_NODEIDX_PROT_MAX = 0xB
} XPm_ProtNodeIdx;

/* Monitor node index */
typedef enum {
	XPM_NODEIDX_MONITOR_MIN = 0x0,
	XPM_NODEIDX_MONITOR_SYSMON_PMC_0 = 0x1,
	XPM_NODEIDX_MONITOR_SYSMON_PMC_1 = 0x2,
	XPM_NODEIDX_MONITOR_SYSMON_PS_LPD = 0x3,
	XPM_NODEIDX_MONITOR_SYSMON_PS_FPD = 0x4,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_0 = 0x5,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_1 = 0x6,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_2 = 0x7,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_3 = 0x8,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_4 = 0x9,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_5 = 0xA,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_6 = 0xB,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_7 = 0xC,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_8 = 0xD,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_9 = 0xE,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_10 = 0xF,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_11 = 0x10,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_12 = 0x11,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_13 = 0x12,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_14 = 0x13,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_15 = 0x14,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_16 = 0x15,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_17 = 0x16,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_18 = 0x17,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_19 = 0x18,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_20 = 0x19,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_21 = 0x1A,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_22 = 0x1B,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_23 = 0x1C,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_24 = 0x1D,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_25 = 0x1E,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_26 = 0x1F,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_27 = 0x20,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_28 = 0x21,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_29 = 0x22,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_30 = 0x23,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_31 = 0x24,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_32 = 0x25,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_33 = 0x26,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_34 = 0x27,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_35 = 0x28,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_36 = 0x29,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_37 = 0x2A,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_38 = 0x2B,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_39 = 0x2C,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_40 = 0x2D,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_41 = 0x2E,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_42 = 0x2F,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_43 = 0x30,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_44 = 0x31,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_45 = 0x32,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_46 = 0x33,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_47 = 0x34,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_48 = 0x35,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_49 = 0x36,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_50 = 0x37,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_51 = 0x38,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_52 = 0x39,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_53 = 0x3A,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_54 = 0x3B,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_55 = 0x3C,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_56 = 0x3D,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_57 = 0x3E,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_58 = 0x3F,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_59 = 0x40,
	XPM_NODEIDX_MONITOR_SYSMON_NPD_MAX = 0x41,
	XPM_NODEIDX_MONITOR_SYSMON_LPD = 0x42,
	XPM_NODEIDX_MONITOR_SYSMON_CPM5N = 0x43,
	XPM_NODEIDX_MONITOR_SYSMON_FPD_0 = 0x44,
	XPM_NODEIDX_MONITOR_SYSMON_FPD_1 = 0x45,
	XPM_NODEIDX_MONITOR_SYSMON_FPD_2 = 0x46,
	XPM_NODEIDX_MONITOR_SYSMON_FPD_3 = 0x47,
	XPM_NODEIDX_MONITOR_MAX = 0x48
} XPm_MonitorNodeIdx;

/* Misc node indexes */
typedef enum {
	XPM_NODEIDX_MISC_MJTAG_WA_IMG = 0x0,
	XPM_NODEIDX_MISC_READBACK_PDI_IMG = 0x1
} XPm_MiscNodeIdx;

/* Register node index */
typedef enum {
	XPM_NODEIDX_REG_MIN = 0x0,
	XPM_NODEIDX_REG_CRP = 0x1,
	XPM_NODEIDX_REG_PMC_IOU_SLCR = 0x2,
	XPM_NODEIDX_REG_EFUSE_CACHE = 0x3,
	XPM_NODEIDX_REG_PMC_GLOBAL = 0x4,
	XPM_NODEIDX_REG_MMI_UDH_SLCR = 0x5,
	XPM_NODEIDX_REG_MAX = 0x6
} XPm_RegNodeIdx;


#ifdef __cplusplus
}
#endif

#endif /* XPM_NODE_H_ */
