/******************************************************************************
* Copyright (C) 2013 - 2022 Xilinx, Inc.  All rights reserved.
* Copyright (C) 2022 - 2023 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

#ifndef CFU_APB_H_
#define CFU_APB_H_

#ifdef __cplusplus
extern "C" {
#endif

/**@cond cfu_apb_internal
 * @{
 */

/**
 * CFU_APB Base Address
 */
#define CFU_APB_BASEADDR	(0XF12B0000U)

/**
 * Register: CFU_APB_CFU_ISR
 */
#define CFU_APB_CFU_ISR	(CFU_APB_BASEADDR + 0X00000000U)

#define CFU_APB_CFU_ISR_SEU_ENDOFCALIB_MASK    (0X00000001U)
#define CFU_APB_CFU_ISR_DECOMP_ERROR_MASK	(0X00000040U)
#define CFU_APB_CFU_ISR_BAD_CFI_PACKET_MASK	(0X00000020U)
#define CFU_APB_CFU_ISR_AXI_ALIGN_ERROR_MASK	(0X00000010U)
#define CFU_APB_CFU_ISR_CFI_ROW_ERROR_MASK	(0X00000008U)
#define CFU_APB_CFU_ISR_CRC32_ERROR_MASK	(0X00000004U)
#define CFU_APB_CFU_ISR_CRC8_ERROR_MASK	(0X00000002U)

/**
 * Register: CFU_APB_CFU_ITR
 */
#define CFU_APB_CFU_ITR	(CFU_APB_BASEADDR + 0X00000010U)

/**
 * Register: CFU_APB_CFU_PROTECT
 */
#define CFU_APB_CFU_PROTECT	(CFU_APB_BASEADDR + 0X00000014U)

#define CFU_APB_CFU_PROTECT_ACTIVE_SHIFT	(0U)
#define CFU_APB_CFU_PROTECT_ACTIVE_WIDTH	(1U)
#define CFU_APB_CFU_PROTECT_ACTIVE_MASK	(0X00000001U)

/**
 * Register: CFU_APB_CFU_FGCR
 */
#define CFU_APB_CFU_FGCR	(CFU_APB_BASEADDR + 0X00000018U)
#define CFU_APB_CFU_FGCR_SC_HBC_TRIGGER_MASK	(0X00002000U)
#define CFU_APB_CFU_FGCR_GRESTORE_MASK	(0X00000020U)
#define CFU_APB_CFU_FGCR_GLUTMASK_MASK    (0X00000008U)
#define CFU_APB_CFU_FGCR_EN_GLOBS_B_MASK	(0X00000004U)
#define CFU_APB_CFU_FGCR_EOS_MASK	(0X00000002U)
#define CFU_APB_CFU_FGCR_INIT_COMPLETE_MASK	(0X00000001U)

/**
 * Register: CFU_APB_CFU_CTL
 */
#define CFU_APB_CFU_CTL	(CFU_APB_BASEADDR + 0X0000001CU)
#define CFU_APB_CFU_CTL_SLVERR_EN_MASK	(0X00004000U)
#define CFU_APB_CFU_CTL_IGNORE_CFI_ERROR_MASK	(0X00000080U)
#define CFU_APB_CFU_CTL_CFRAME_DISABLE_MASK	(0X00000040U)
#define CFU_APB_CFU_CTL_DECOMPRESS_MASK	(0X00000004U)
#define CFU_APB_CFU_CTL_SEU_GO_MASK	(0X00000002U)
#define CFU_APB_CFU_CTL_CFI_LOCAL_RESET_MASK	(0X00000001U)

/**
 * Register: CFU_APB_CFU_MASK
 */
#define CFU_APB_CFU_MASK	(CFU_APB_BASEADDR + 0X00000028U)

/**
 * Register: CFU_APB_CFU_ROW_RANGE
 */
#define CFU_APB_CFU_ROW_RANGE    (CFU_APB_BASEADDR + 0X0000006CU)
#define CFU_APB_CFU_ROW_RANGE_NUM_MASK    (0X0000001FU)

/**
 * Register: CFU_APB_CFU_STATUS
 */
#define CFU_APB_CFU_STATUS	(CFU_APB_BASEADDR + 0X00000100U)
#define CFU_APB_CFU_STATUS_SCAN_CLEAR_PASS_MASK	(0X00002000U)
#define CFU_APB_CFU_STATUS_SCAN_CLEAR_DONE_MASK	(0X00000008U)
#define CFU_APB_CFU_STATUS_HC_COMPLETE_MASK	(0X00000004U)
#define CFU_APB_CFU_STATUS_CFI_CFRAME_BUSY_MASK	(0X00000002U)

/**
 * Register: CFU_APB_CFU_QWORD_CNT
 */
#define CFU_APB_CFU_QWORD_CNT    ((CFU_APB_BASEADDR) + 0x00000108U)
#define CFU_APB_CFU_QWORD_CNT_NUM_MASK    (0xFFFFFFFFU)

/**
 * @}
 * @endcond
 */

#ifdef __cplusplus
}
#endif

#endif /* CFU_APB_H_ */
