# -*- coding: utf-8 -*-
import sys
import types
import os
import getopt
import re
from pathlib import Path
from pathlib import PurePath
from io import StringIO
import contextlib
import importlib
from lopper import Lopper
from lopper import LopperFmt
import lopper
from lopper.tree import *
from re import *
import numpy as np

sys.path.append(os.path.dirname(__file__))
from bmcmake_metadata_xlnx import *
from baremetalconfig_xlnx import *

def is_compat(node, compat_string_to_test):
    if re.search( "module,zuplus_config", compat_string_to_test):
        return xppu
    return ""

def parity(integer):
    count = 0
    parity = 0
    for i in range(0, len(integer)):
        if integer[i] == 1:
            count = count + 1
    if count%2 == 1:
        parity = 1
    return parity



def config(cpu_name, reg_value, setting):
    #Aperture permission offset dictionary
    offset_dict = {'0xff000000' : 'LPD_XPPU_CFG_APERPERM_000_OFFSET', '0xff010000' : 'LPD_XPPU_CFG_APERPERM_001_OFFSET', '0xff020000' : 'LPD_XPPU_CFG_APERPERM_002_OFFSET', '0xff030000' : 'LPD_XPPU_CFG_APERPERM_003_OFFSET', '0xff040000' : 'LPD_XPPU_CFG_APERPERM_004_OFFSET', '0xff050000' : 'LPD_XPPU_CFG_APERPERM_005_OFFSET', '0xff060000' : 'LPD_XPPU_CFG_APERPERM_006_OFFSET', '0xff070000' : 'LPD_XPPU_CFG_APERPERM_007_OFFSET', '0xff080000' : 'LPD_XPPU_CFG_APERPERM_008_OFFSET', '0xff090000' : 'LPD_XPPU_CFG_APERPERM_009_OFFSET', '0xff0a0000' : 'LPD_XPPU_CFG_APERPERM_010_OFFSET', '0xff0b0000' : 'LPD_XPPU_CFG_APERPERM_011_OFFSET', '0xff0c0000' : 'LPD_XPPU_CFG_APERPERM_012_OFFSET', '0xff0d0000' : 'LPD_XPPU_CFG_APERPERM_013_OFFSET', '0xff0e0000' : 'LPD_XPPU_CFG_APERPERM_014_OFFSET', '0xff0f0000' : 'LPD_XPPU_CFG_APERPERM_015_OFFSET', '0xff100000' : 'LPD_XPPU_CFG_APERPERM_016_OFFSET', '0xff110000' : 'LPD_XPPU_CFG_APERPERM_017_OFFSET', '0xff120000' : 'LPD_XPPU_CFG_APERPERM_018_OFFSET', '0xff130000' : 'LPD_XPPU_CFG_APERPERM_019_OFFSET', '0xff140000' : 'LPD_XPPU_CFG_APERPERM_020_OFFSET', '0xff150000' : 'LPD_XPPU_CFG_APERPERM_021_OFFSET', '0xff160000' : 'LPD_XPPU_CFG_APERPERM_022_OFFSET', '0xff170000' : 'LPD_XPPU_CFG_APERPERM_023_OFFSET', '0xff240000' : 'LPD_XPPU_CFG_APERPERM_036_OFFSET', '0xff250000' : 'LPD_XPPU_CFG_APERPERM_037_OFFSET', '0xff260000' : 'LPD_XPPU_CFG_APERPERM_038_OFFSET', '0xff270000' : 'LPD_XPPU_CFG_APERPERM_039_OFFSET', '0xff280000' : 'LPD_XPPU_CFG_APERPERM_040_OFFSET', '0xff290000' : 'LPD_XPPU_CFG_APERPERM_041_OFFSET', '0xff2a0000' : 'LPD_XPPU_CFG_APERPERM_042_OFFSET', '0xff2b0000' : 'LPD_XPPU_CFG_APERPERM_043_OFFSET', '0xff2c0000' : 'LPD_XPPU_CFG_APERPERM_044_OFFSET', '0xff2d0000' : 'LPD_XPPU_CFG_APERPERM_045_OFFSET', '0xff2e0000' : 'LPD_XPPU_CFG_APERPERM_046_OFFSET', '0xff2f0000' : 'LPD_XPPU_CFG_APERPERM_047_OFFSET', '0xff340000' : 'LPD_XPPU_CFG_APERPERM_052_OFFSET', '0xff350000' : 'LPD_XPPU_CFG_APERPERM_053_OFFSET', '0xff360000' : 'LPD_XPPU_CFG_APERPERM_054_OFFSET', '0xff370000' : 'LPD_XPPU_CFG_APERPERM_055_OFFSET', '0xff380000' : 'LPD_XPPU_CFG_APERPERM_056_OFFSET', '0xff390000' : 'LPD_XPPU_CFG_APERPERM_057_OFFSET', '0xff3a0000' : 'LPD_XPPU_CFG_APERPERM_058_OFFSET', '0xff3b0000' : 'LPD_XPPU_CFG_APERPERM_059_OFFSET', '0xff3c0000' : 'LPD_XPPU_CFG_APERPERM_060_OFFSET', '0xff3d0000' : 'LPD_XPPU_CFG_APERPERM_061_OFFSET', '0xff3e0000' : 'LPD_XPPU_CFG_APERPERM_062_OFFSET', '0xff3f0000' : 'LPD_XPPU_CFG_APERPERM_063_OFFSET', '0xff400000' : 'LPD_XPPU_CFG_APERPERM_064_OFFSET', '0xff4b0000' : 'LPD_XPPU_CFG_APERPERM_075_OFFSET', '0xff4c0000' : 'LPD_XPPU_CFG_APERPERM_076_OFFSET', '0xff4d0000' : 'LPD_XPPU_CFG_APERPERM_077_OFFSET', '0xff4e0000' : 'LPD_XPPU_CFG_APERPERM_078_OFFSET', '0xff4f0000' : 'LPD_XPPU_CFG_APERPERM_079_OFFSET', '0xff500000' : 'LPD_XPPU_CFG_APERPERM_080_OFFSET', '0xff510000' : 'LPD_XPPU_CFG_APERPERM_081_OFFSET', '0xff520000' : 'LPD_XPPU_CFG_APERPERM_082_OFFSET', '0xff530000' : 'LPD_XPPU_CFG_APERPERM_083_OFFSET', '0xff540000' : 'LPD_XPPU_CFG_APERPERM_084_OFFSET', '0xff550000' : 'LPD_XPPU_CFG_APERPERM_085_OFFSET', '0xff560000' : 'LPD_XPPU_CFG_APERPERM_086_OFFSET', '0xff570000' : 'LPD_XPPU_CFG_APERPERM_087_OFFSET', '0xff580000' : 'LPD_XPPU_CFG_APERPERM_088_OFFSET', '0xff590000' : 'LPD_XPPU_CFG_APERPERM_089_OFFSET', '0xff5a0000' : 'LPD_XPPU_CFG_APERPERM_090_OFFSET', '0xff5b0000' : 'LPD_XPPU_CFG_APERPERM_091_OFFSET', '0xff5c0000' : 'LPD_XPPU_CFG_APERPERM_092_OFFSET', '0xff5d0000' : 'LPD_XPPU_CFG_APERPERM_093_OFFSET', '0xff860000' : 'LPD_XPPU_CFG_APERPERM_134_OFFSET', '0xff870000' : 'LPD_XPPU_CFG_APERPERM_135_OFFSET', '0xff880000' : 'LPD_XPPU_CFG_APERPERM_136_OFFSET', '0xff890000' : 'LPD_XPPU_CFG_APERPERM_137_OFFSET', '0xff8a0000' : 'LPD_XPPU_CFG_APERPERM_138_OFFSET', '0xff8b0000' : 'LPD_XPPU_CFG_APERPERM_139_OFFSET', '0xff8c0000' : 'LPD_XPPU_CFG_APERPERM_140_OFFSET', '0xff8d0000' : 'LPD_XPPU_CFG_APERPERM_141_OFFSET', '0xff8e0000' : 'LPD_XPPU_CFG_APERPERM_142_OFFSET', '0xff8f0000' : 'LPD_XPPU_CFG_APERPERM_143_OFFSET', '0xff900000' : 'LPD_XPPU_CFG_APERPERM_144_OFFSET', '0xff910000' : 'LPD_XPPU_CFG_APERPERM_145_OFFSET', '0xff920000' : 'LPD_XPPU_CFG_APERPERM_146_OFFSET', '0xff930000' : 'LPD_XPPU_CFG_APERPERM_147_OFFSET', '0xff940000' : 'LPD_XPPU_CFG_APERPERM_148_OFFSET', '0xff950000' : 'LPD_XPPU_CFG_APERPERM_149_OFFSET', '0xff960000' : 'LPD_XPPU_CFG_APERPERM_150_OFFSET', '0xff970000' : 'LPD_XPPU_CFG_APERPERM_151_OFFSET', '0xff980000' : 'LPD_XPPU_CFG_APERPERM_152_OFFSET', '0xff990000' : 'LPD_XPPU_CFG_APERPERM_153_OFFSET', '0xff9b0000' : 'LPD_XPPU_CFG_APERPERM_155_OFFSET', '0xff9c0000' : 'LPD_XPPU_CFG_APERPERM_156_OFFSET', '0xff9d0000' : 'LPD_XPPU_CFG_APERPERM_157_OFFSET', '0xff9e0000' : 'LPD_XPPU_CFG_APERPERM_158_OFFSET', '0xffa00000' : 'LPD_XPPU_CFG_APERPERM_160_OFFSET', '0xffa10000' : 'LPD_XPPU_CFG_APERPERM_161_OFFSET', '0xffa50000' : 'LPD_XPPU_CFG_APERPERM_165_OFFSET', '0xffa60000' : 'LPD_XPPU_CFG_APERPERM_166_OFFSET', '0xffa80000' : 'LPD_XPPU_CFG_APERPERM_168_OFFSET', '0xffa90000' : 'LPD_XPPU_CFG_APERPERM_169_OFFSET', '0xffaa0000' : 'LPD_XPPU_CFG_APERPERM_170_OFFSET', '0xffab0000' : 'LPD_XPPU_CFG_APERPERM_171_OFFSET', '0xffac0000' : 'LPD_XPPU_CFG_APERPERM_172_OFFSET', '0xffad0000' : 'LPD_XPPU_CFG_APERPERM_173_OFFSET', '0xffae0000' : 'LPD_XPPU_CFG_APERPERM_174_OFFSET', '0xffaf0000' : 'LPD_XPPU_CFG_APERPERM_175_OFFSET', '0xffc30000' : 'LPD_XPPU_CFG_APERPERM_195_OFFSET', '0xffc80000' : 'LPD_XPPU_CFG_APERPERM_200_OFFSET', '0xffca0000' : 'LPD_XPPU_CFG_APERPERM_202_OFFSET', '0xffcb0000' : 'LPD_XPPU_CFG_APERPERM_203_OFFSET', '0xffce0000' : 'LPD_XPPU_CFG_APERPERM_206_OFFSET', '0xffcf0000' : 'LPD_XPPU_CFG_APERPERM_207_OFFSET', '0xffd80000' : 'LPD_XPPU_CFG_APERPERM_216_OFFSET', '0xfe000000' : 'LPD_XPPU_CFG_APERPERM_384_OFFSET', '0xfe100000' : 'LPD_XPPU_CFG_APERPERM_385_OFFSET', '0xfe200000' : 'LPD_XPPU_CFG_APERPERM_386_OFFSET', '0xfe300000' : 'LPD_XPPU_CFG_APERPERM_387_OFFSET', '0xfe400000' : 'LPD_XPPU_CFG_APERPERM_388_OFFSET', '0xfe500000' : 'LPD_XPPU_CFG_APERPERM_389_OFFSET', '0xfe600000' : 'LPD_XPPU_CFG_APERPERM_390_OFFSET', '0xfe700000' : 'LPD_XPPU_CFG_APERPERM_391_OFFSET', '0xfe800000' : 'LPD_XPPU_CFG_APERPERM_392_OFFSET', '0xfe900000' : 'LPD_XPPU_CFG_APERPERM_393_OFFSET', '0xfea00000' : 'LPD_XPPU_CFG_APERPERM_394_OFFSET', '0xfeb00000' : 'LPD_XPPU_CFG_APERPERM_395_OFFSET', '0xfec00000' : 'LPD_XPPU_CFG_APERPERM_396_OFFSET', '0xfed00000' : 'LPD_XPPU_CFG_APERPERM_397_OFFSET', '0xfee00000' : 'LPD_XPPU_CFG_APERPERM_398_OFFSET', '0xfef00000' : 'LPD_XPPU_CFG_APERPERM_399_OFFSET', '0xc0000000' : 'LPD_XPPU_CFG_APERPERM_400_OFFSET'}
    #CPU dictionary
    cpu_dict = { 'cpus_a53' : 'APU', 'cpus_r5' : 'RPU'}
    master = cpu_dict[cpu_name]
    offset_value = ['' for offset_value in range(len(reg_value))]
    for i in range(0, len(offset_value)):
        offset_value[i] = offset_value[i]+offset_dict[reg_value[i]]
    setting_bin = []
    for i in range(0, len(setting)):
        setting_bin.append(bin(setting[i]).replace("0b", "").zfill(32))
    
    value = np.zeros(shape=(len(setting_bin),32), dtype = int)
    par_0 = np.zeros(shape=(len(setting_bin),6), dtype = int)
    par_1 = np.zeros(shape=(len(setting_bin),5), dtype = int)
    par_2 = np.zeros(shape=(len(setting_bin),5), dtype = int)
    par_3 = np.zeros(shape=(len(setting_bin),5), dtype = int)

    final_line = ["" for final_line in range(len(setting_bin))]
    value_str = ["" for value_str in range(len(setting_bin))] 
    value_hex = ["" for value_hex in range(len(setting_bin))]
    for i in range(0, len(setting_bin)):
    #value = []
        #for j in range(0,32):
         #   value[i].append(0)
        value[i][24]=1  

        if setting_bin[i][29]==setting_bin[i][30]:
            if master == "APU":
                value[i][25] = 1
            elif master == "RPU":
                value[i][20] = 1

        else:
            if master == "APU":
                value[i][26] = 1
            elif master == "RPU":
                value[i][21] = 1 
 
        if setting_bin[i][31] == "0":
            value[i][4] =1
    
        par_0[i][0] = value[i][4]
        for j in range(12,17):
            for k in range(1,len(par_0[i])):
                par_0[i][k] = value[i][j]
        value[i][0] = parity(par_0[i])
    
        for j in range(17,22):
            for k in range(0,len(par_1[i])):
                par_1[i][k] = value[i][j]
        value[i][1] = parity(par_1[i])
        
        for j in range(22,27):
            for k in range(0,len(par_2[i])):
                par_2[i][k] = value[i][j]
        value[i][2] = parity(par_2[i])
        
        for j in range(27,32):
            for k in range(0,len(par_3[i])):
                par_3[i][k] = value[i][j]
        value[i][3] = parity(par_3[i])
    
        #value_str = ""
        for j in range(0, len(value[i])):
            value_str[i] = value_str[i] + str(value[i][j])
    
        value_hex[i] = hex(int(str(value_str[i]), 2))

        final_line[i] = "	PSU_Mask_Write(" + str(offset_value[i]) + ", " + "0xF80FFFFFU" + ", " + str(value_hex[i]) +"U);"
    
    return final_line
        


def xppu(tgt_node, sdt, options):
    root_node = sdt.tree[tgt_node]
    root_sub_nodes = root_node.subnodes()
    node_list = []
    chosen_node = ""
    # Traverse the tree and find the nodes having status=ok property
    for node in root_sub_nodes:
        
        try:
            access = node["access"].value
            cpu = node["cpus"].value
            print(access, cpu)
	
        except:
            pass
    
    peripheral = []
    setting = []
    parent_node = []
    name = []
    parent_node_cpu = sdt.FDT.node_offset_by_phandle(cpu[0])
    name_cpu = sdt.FDT.get_name(parent_node_cpu)
    print(name_cpu)
    access_len = int(len(access))
    print(access_len)
    for i in range(0, access_len):
        if i%2 == 0:
            peripheral.append(access[i])
            setting.append(access[i+1])
    print(peripheral, setting)
    
    
    for i in range(0, len(peripheral)):
        parent_node.append(sdt.FDT.node_offset_by_phandle(peripheral[i]))

    for i in range(0, len(parent_node)):
        name.append(sdt.FDT.get_name(parent_node[i]))
    print(name)

       
    reg_value = ["" for reg_value in range(len(name))]
    for i in range(0, len(name)):
        for j in range(0, len(name[i])):
            if name[i][j] == str("@"):
                for k in range(j+1, len(name[i])):
                    reg_value[i] = reg_value[i] + name[i][k] 
                reg_value[i] = "0x" + reg_value[i]
                break 
    print(reg_value)
    xppu_masterid_lines = "/*\n    * MASTER ID LIST\n    */\n    /*\n    * Register : MASTER_ID00 @ 0XFF980100\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID00_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID00_MIDM                           72\n\n    * Predefined Master ID for PMU\n    *  PSU_LPD_XPPU_CFG_MASTER_ID00_MID                            72\n\n    * Master ID 00 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980100, 0x43FF03FFU ,0x00480048U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID00_OFFSET,\n		0x43FF03FFU, 0x00480048U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID01 @ 0XFF980104\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID01_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID01_MIDM                           80\n\n    * Predefined Master ID for RPU0\n    *  PSU_LPD_XPPU_CFG_MASTER_ID01_MID                            80\n\n    * Master ID 01 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980104, 0x43FF03FFU ,0x00500050U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID01_OFFSET,\n		0x43FF03FFU, 0x00500050U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID02 @ 0XFF980108\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID02_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID02_MIDM                           98\n\n    * Predefined Master ID for RPU1\n     *  PSU_LPD_XPPU_CFG_MASTER_ID02_MID                            96\n\n    * Master ID 02 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980108, 0x43FF03FFU ,0x00620060U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID02_OFFSET,\n		0x43FF03FFU, 0x00620060U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID03 @ 0XFF98010C\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID03_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID03_MIDM                           192\n\n    * Predefined Master ID for APU\n    *  PSU_LPD_XPPU_CFG_MASTER_ID03_MID                            192\n\n    * Master ID 03 Register\n    * (OFFSET, MASK, VALUE)      (0XFF98010C, 0x43FF03FFU ,0x00C000C0U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID03_OFFSET,\n		0x43FF03FFU, 0x00C000C0U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID04 @ 0XFF980110\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID04_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID04_MIDM                           512\n\n    * Predefined Master ID for A53 Core 0\n    *  PSU_LPD_XPPU_CFG_MASTER_ID04_MID                            512\n\n    * Master ID 04 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980110, 0x43FF03FFU ,0x02000200U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID04_OFFSET,\n		0x43FF03FFU, 0x02000200U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID05 @ 0XFF980114\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID05_MIDR                           1\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID05_MIDM                           704\n\n    * Predefined Master ID for A53 Core 1\n    *  PSU_LPD_XPPU_CFG_MASTER_ID05_MID                            128\n\n    * Master ID 05 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980114, 0x43FF03FFU ,0x42C00080U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID05_OFFSET,\n		0x43FF03FFU, 0x42C00080U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID06 @ 0XFF980118\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID06_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID06_MIDM                           704\n\n    * Predefined Master ID for A53 Core 2\n    *  PSU_LPD_XPPU_CFG_MASTER_ID06_MID                            128\n\n    * Master ID 06 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980118, 0x43FF03FFU ,0x02C00080U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID06_OFFSET,\n		0x43FF03FFU, 0x02C00080U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID07 @ 0XFF98011C\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID07_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID07_MIDM                           1023\n\n    * Predefined Master ID for A53 Core 3\n    *  PSU_LPD_XPPU_CFG_MASTER_ID07_MID                            98\n\n    * Master ID 07 Register\n    * (OFFSET, MASK, VALUE)      (0XFF98011C, 0x43FF03FFU ,0x03FF0062U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID07_OFFSET,\n		0x43FF03FFU, 0x03FF0062U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID08 @ 0XFF980120\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID08_MIDR                           1\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID08_MIDM                           1023\n\n    * Programmable Master ID\n    *  PSU_LPD_XPPU_CFG_MASTER_ID08_MID                            64\n\n    * Master ID 08 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980120, 0x43FF03FFU ,0x43FF0040U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID08_OFFSET,\n		0x43FF03FFU, 0x43FF0040U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID09 @ 0XFF980124\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID09_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID09_MIDM                           1023\n\n    * Programmable Master ID\n    *  PSU_LPD_XPPU_CFG_MASTER_ID09_MID                            64\n\n    * Master ID 09 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980124, 0x43FF03FFU ,0x03FF0040U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID09_OFFSET,\n		0x43FF03FFU, 0x03FF0040U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID10 @ 0XFF980128\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID10_MIDR                           1\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID10_MIDM                           720\n\n    * Programmable Master ID\n\n    *  PSU_LPD_XPPU_CFG_MASTER_ID10_MID                            0\n\n    * Master ID 10 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980128, 0x43FF03FFU ,0x42D00000U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID10_OFFSET,\n		0x43FF03FFU, 0x42D00000U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID11 @ 0XFF98012C\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID11_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID11_MIDM                           720\n\n    * Programmable Master ID\n    *  PSU_LPD_XPPU_CFG_MASTER_ID11_MID                            0\n\n    * Master ID 11 Register\n    * (OFFSET, MASK, VALUE)      (0XFF98012C, 0x43FF03FFU ,0x02D00000U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID11_OFFSET,\n		0x43FF03FFU, 0x02D00000U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID12 @ 0XFF980130\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID12_MIDR                           1\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID12_MIDM                           720\n\n    * Programmable Master ID\n    *  PSU_LPD_XPPU_CFG_MASTER_ID12_MID                            16\n\n    * Master ID 12 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980130, 0x43FF03FFU ,0x42D00010U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID12_OFFSET,\n		0x43FF03FFU, 0x42D00010U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID13 @ 0XFF980134\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID13_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID13_MIDM                           720\n\n    * Programmable Master ID\n    *  PSU_LPD_XPPU_CFG_MASTER_ID13_MID                            16\n\n    * Master ID 13 Register\n    * (OFFSET, MASK, VALUE)      (0XFF980134, 0x43FF03FFU ,0x02D00010U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID13_OFFSET,\n		0x43FF03FFU, 0x02D00010U);\n/*##################################################################### */\n\n    /*\n    * Register : MASTER_ID19 @ 0XFF98014C\n\n    * If set, only read transactions are allowed for the masters matching this\n    *  register\n    *  PSU_LPD_XPPU_CFG_MASTER_ID19_MIDR                           0\n\n    * Mask to be applied before comparing\n    *  PSU_LPD_XPPU_CFG_MASTER_ID19_MIDM                           0\n\n    * Programmable Master ID\n    *  PSU_LPD_XPPU_CFG_MASTER_ID19_MID                            0\n\n    * Master ID 19 Register\n    * (OFFSET, MASK, VALUE)      (0XFF98014C, 0x43FF03FFU ,0x00000000U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_MASTER_ID19_OFFSET,\n		0x43FF03FFU, 0x00000000U);\n/*##################################################################### */"

    xppu_masterid_data = xppu_masterid_lines.splitlines()
    
    xppu_aperperm_lines = "   /*\n    * APERTURE NAME: RPU_UNUSED_12, START ADDRESS: FF080000, END ADDRESS: FF09\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: RPU_UNUSED_12, START ADDRESS: FF080000, END ADDRESS: FF09\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: GPIO, START ADDRESS: FF0A0000, END ADDRESS: FF0AFFFF\n    */\n    /*\n    * APERTURE NAME: GEM0, START ADDRESS: FF0B0000, END ADDRESS: FF0BFFFF\n    */\n    /*\n    * APERTURE NAME: GEM1, START ADDRESS: FF0C0000, END ADDRESS: FF0CFFFF\n    */\n    /*\n    * APERTURE NAME: GEM2, START ADDRESS: FF0D0000, END ADDRESS: FF0DFFFF\n    */\n    /*\n    * APERTURE NAME: GEM3, START ADDRESS: FF0E0000, END ADDRESS: FF0EFFFF\n    */\n    /*\n    * APERTURE NAME: QSPI, START ADDRESS: FF0F0000, END ADDRESS: FF0FFFFF\n    */\n    /*\n    * APERTURE NAME: NAND, START ADDRESS: FF100000, END ADDRESS: FF10FFFF\n    */\n    /*\n    * APERTURE NAME: TTC0, START ADDRESS: FF110000, END ADDRESS: FF11FFFF\n    */\n    /*\n    * APERTURE NAME: TTC1, START ADDRESS: FF120000, END ADDRESS: FF12FFFF\n    */\n    /*\n    * APERTURE NAME: TTC2, START ADDRESS: FF130000, END ADDRESS: FF13FFFF\n    */\n    /*\n    * APERTURE NAME: TTC3, START ADDRESS: FF140000, END ADDRESS: FF14FFFF\n    */\n    /*\n    * APERTURE NAME: SWDT, START ADDRESS: FF150000, END ADDRESS: FF15FFFF\n    */\n    /*\n    * APERTURE NAME: SD0, START ADDRESS: FF160000, END ADDRESS: FF16FFFF\n    */\n    /*\n    * APERTURE NAME: SD1, START ADDRESS: FF170000, END ADDRESS: FF17FFFF\n    */\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_024 @ 0XFF981060\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_024_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_024_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_024_PARITY                        0x0\n\n    * Entry 024 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00180000\n    * (OFFSET, MASK, VALUE)      (0XFF981060, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_024_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_025 @ 0XFF981064\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_025_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_025_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_025_PARITY                        0x0\n\n    * Entry 025 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00190000\n    * (OFFSET, MASK, VALUE)      (0XFF981064, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_025_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_026 @ 0XFF981068\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_026_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_026_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_026_PARITY                        0x0\n\n    * Entry 026 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x001A0000\n    * (OFFSET, MASK, VALUE)      (0XFF981068, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_026_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_027 @ 0XFF98106C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_027_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_027_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_027_PARITY                        0x0\n\n    * Entry 027 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x001B0000\n    * (OFFSET, MASK, VALUE)      (0XFF98106C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_027_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_028 @ 0XFF981070\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_028_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_028_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_028_PARITY                        0x0\n\n    * Entry 028 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x001C0000\n    * (OFFSET, MASK, VALUE)      (0XFF981070, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_028_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_029 @ 0XFF981074\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_029_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_029_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_029_PARITY                        0x0\n\n    * Entry 029 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x001D0000\n    * (OFFSET, MASK, VALUE)      (0XFF981074, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_029_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_030 @ 0XFF981078\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_030_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_030_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_030_PARITY                        0x0\n\n    * Entry 030 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x001E0000\n    * (OFFSET, MASK, VALUE)      (0XFF981078, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_030_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_031 @ 0XFF98107C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_031_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_031_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_031_PARITY                        0x0\n\n    * Entry 031 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x001F0000\n    * (OFFSET, MASK, VALUE)      (0XFF98107C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_031_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_032 @ 0XFF981080\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_032_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_032_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_032_PARITY                        0x0\n\n    * Entry 032 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00200000\n    * (OFFSET, MASK, VALUE)      (0XFF981080, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_032_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_033 @ 0XFF981084\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_033_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_033_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_033_PARITY                        0x0\n\n    * Entry 033 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00210000\n    * (OFFSET, MASK, VALUE)      (0XFF981084, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_033_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_034 @ 0XFF981088\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_034_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_034_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_034_PARITY                        0x0\n\n    * Entry 034 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00220000\n    * (OFFSET, MASK, VALUE)      (0XFF981088, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_034_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SLCR, START ADDRESS: FF180000, END ADDRESS: FF23FFFF\n    */\n    /*\n    * Register : APERPERM_035 @ 0XFF98108C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_035_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_035_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_035_PARITY                        0x0\n\n    * Entry 035 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00230000\n    * (OFFSET, MASK, VALUE)      (0XFF98108C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_035_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IOU_SECURE_SLCR, START ADDRESS: FF240000, END ADDRESS: FF\n    * 24FFFF\n    */\n    /*\n    * APERTURE NAME: IOU_SCNTR, START ADDRESS: FF250000, END ADDRESS: FF25FFFF\n    */\n    /*\n    * APERTURE NAME: IOU_SCNTRS, START ADDRESS: FF260000, END ADDRESS: FF26FFF\n    * F\n    */\n    /*\n    * APERTURE NAME: RPU_UNUSED_11, START ADDRESS: FF270000, END ADDRESS: FF2A\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: RPU_UNUSED_11, START ADDRESS: FF270000, END ADDRESS: FF2A\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: RPU_UNUSED_11, START ADDRESS: FF270000, END ADDRESS: FF2A\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: RPU_UNUSED_11, START ADDRESS: FF270000, END ADDRESS: FF2A\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_14, START ADDRESS: FF2B0000, END ADDRESS: FF2F\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_14, START ADDRESS: FF2B0000, END ADDRESS: FF2F\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_14, START ADDRESS: FF2B0000, END ADDRESS: FF2F\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_14, START ADDRESS: FF2B0000, END ADDRESS: FF2F\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_14, START ADDRESS: FF2B0000, END ADDRESS: FF2F\n    * FFFF\n    */\n    /*\n    * APERTURE NAME: IPI_0, START ADDRESS: FF300000, END ADDRESS: FF30FFFF\n    */\n    /*\n    * Register : APERPERM_048 @ 0XFF9810C0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_048_PERMISSION                    0x40\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_048_TRUSTZONE                     0x1\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_048_PARITY                        0x0\n\n    * Entry 048 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00300000\n    * (OFFSET, MASK, VALUE)      (0XFF9810C0, 0xF80FFFFFU ,0x08000040U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_048_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IPI_1, START ADDRESS: FF310000, END ADDRESS: FF31FFFF\n    */\n    /*\n    * Register : APERPERM_049 @ 0XFF9810C4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_049_PERMISSION                    0x800\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_049_TRUSTZONE                     0x1\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_049_PARITY                        0x0\n\n    * Entry 049 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00310000\n    * (OFFSET, MASK, VALUE)      (0XFF9810C4, 0xF80FFFFFU ,0x08000800U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_049_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IPI_2, START ADDRESS: FF320000, END ADDRESS: FF32FFFF\n    */\n    /*\n    * Register : APERPERM_050 @ 0XFF9810C8\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_050_PERMISSION                    0x2000\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_050_TRUSTZONE                     0x1\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_050_PARITY                        0x0\n\n    * Entry 050 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00320000\n    * (OFFSET, MASK, VALUE)      (0XFF9810C8, 0xF80FFFFFU ,0x08002000U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_050_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IPI_PMU, START ADDRESS: FF330000, END ADDRESS: FF33FFFF\n    */\n    /*\n    * Register : APERPERM_051 @ 0XFF9810CC\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_051_PERMISSION                    0x200\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_051_TRUSTZONE                     0x1\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_051_PARITY                        0x0\n\n    * Entry 051 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00330000\n    * (OFFSET, MASK, VALUE)      (0XFF9810CC, 0xF80FFFFFU ,0x08000200U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_051_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: IPI_7, START ADDRESS: FF340000, END ADDRESS: FF34FFFF\n    */\n    /*\n    * APERTURE NAME: IPI_8, START ADDRESS: FF350000, END ADDRESS: FF35FFFF\n    */\n    /*\n    * APERTURE NAME: IPI_9, START ADDRESS: FF360000, END ADDRESS: FF36FFFF\n    */\n    /*\n    * APERTURE NAME: IPI_10, START ADDRESS: FF370000, END ADDRESS: FF37FFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: IPI_CTRL, START ADDRESS: FF380000, END ADDRESS: FF3FFFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_1, START ADDRESS: FF400000, END ADDRESS: FF40F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_065 @ 0XFF981104\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_065_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_065_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_065_PARITY                        0x0\n\n    * Entry 065 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00410000\n    * (OFFSET, MASK, VALUE)      (0XFF981104, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_065_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_066 @ 0XFF981108\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_066_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_066_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_066_PARITY                        0x0\n\n    * Entry 066 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00420000\n    * (OFFSET, MASK, VALUE)      (0XFF981108, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_066_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_067 @ 0XFF98110C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_067_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_067_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_067_PARITY                        0x0\n\n    * Entry 067 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00430000\n    * (OFFSET, MASK, VALUE)      (0XFF98110C, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_067_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_068 @ 0XFF981110\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_068_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_068_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_068_PARITY                        0x0\n\n    * Entry 068 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00440000\n    * (OFFSET, MASK, VALUE)      (0XFF981110, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_068_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_069 @ 0XFF981114\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_069_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_069_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_069_PARITY                        0x0\n\n    * Entry 069 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00450000\n    * (OFFSET, MASK, VALUE)      (0XFF981114, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_069_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_070 @ 0XFF981118\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_070_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_070_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_070_PARITY                        0x0\n\n    * Entry 070 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00460000\n    * (OFFSET, MASK, VALUE)      (0XFF981118, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_070_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_071 @ 0XFF98111C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_071_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_071_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_071_PARITY                        0x0\n\n    * Entry 071 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00470000\n    * (OFFSET, MASK, VALUE)      (0XFF98111C, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_071_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_072 @ 0XFF981120\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_072_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_072_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_072_PARITY                        0x0\n\n    * Entry 072 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00480000\n    * (OFFSET, MASK, VALUE)      (0XFF981120, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_072_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_073 @ 0XFF981124\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_073_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_073_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_073_PARITY                        0x0\n\n    * Entry 073 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00490000\n    * (OFFSET, MASK, VALUE)      (0XFF981124, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_073_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR, START ADDRESS: FF410000, END ADDRESS: FF4AFFFF\n    */\n    /*\n    * Register : APERPERM_074 @ 0XFF981128\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_074_PERMISSION                    0x280\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_074_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_074_PARITY                        0x0\n\n    * Entry 074 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x004A0000\n    * (OFFSET, MASK, VALUE)      (0XFF981128, 0xF80FFFFFU ,0x00000280U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_074_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_SLCR_SECURE, START ADDRESS: FF4B0000, END ADDRESS: FF\n    * 4DFFFF\n    */\n    /*\n    * APERTURE NAME: LPD_SLCR_SECURE, START ADDRESS: FF4B0000, END ADDRESS: FF\n    * 4DFFFF\n    */\n    /*\n    * APERTURE NAME: LPD_SLCR_SECURE, START ADDRESS: FF4B0000, END ADDRESS: FF\n    * 4DFFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_2, START ADDRESS: FF4E0000, END ADDRESS: FF5DF\n    * FFF\n    */\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_094 @ 0XFF981178\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_094_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_094_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_094_PARITY                        0x0\n    * Entry 094 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x005E0000\n    * (OFFSET, MASK, VALUE)      (0XFF981178, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_094_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_095 @ 0XFF98117C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_095_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_095_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_095_PARITY                        0x0\n\n    * Entry 095 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x005F0000\n    * (OFFSET, MASK, VALUE)      (0XFF98117C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_095_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_096 @ 0XFF981180\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_096_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_096_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_096_PARITY                        0x0\n\n    * Entry 096 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00600000\n    * (OFFSET, MASK, VALUE)      (0XFF981180, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_096_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_097 @ 0XFF981184\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_097_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_097_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_097_PARITY                        0x0\n\n    * Entry 097 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00610000\n    * (OFFSET, MASK, VALUE)      (0XFF981184, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_097_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_098 @ 0XFF981188\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_098_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_098_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_098_PARITY                        0x0\n\n    * Entry 098 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00620000\n    * (OFFSET, MASK, VALUE)      (0XFF981188, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_098_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n   /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_099 @ 0XFF98118C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_099_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_099_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_099_PARITY                        0x0\n\n    * Entry 099 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00630000\n    * (OFFSET, MASK, VALUE)      (0XFF98118C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_099_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_100 @ 0XFF981190\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_100_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_100_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_100_PARITY                        0x0\n\n    * Entry 100 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00640000\n    * (OFFSET, MASK, VALUE)      (0XFF981190, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_100_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_101 @ 0XFF981194\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_101_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_101_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_101_PARITY                        0x0\n\n    * Entry 101 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00650000\n    * (OFFSET, MASK, VALUE)      (0XFF981194, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_101_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_102 @ 0XFF981198\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_102_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_102_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_102_PARITY                        0x0\n\n    * Entry 102 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00660000\n    * (OFFSET, MASK, VALUE)      (0XFF981198, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_102_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_103 @ 0XFF98119C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_103_PERMISSION                    0x2adf\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_103_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_103_PARITY                        0x0\n\n    * Entry 103 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00670000\n    * (OFFSET, MASK, VALUE)      (0XFF98119C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_103_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_104 @ 0XFF9811A0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_104_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_104_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_104_PARITY                        0x0\n\n    * Entry 104 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00680000\n    * (OFFSET, MASK, VALUE)      (0XFF9811A0, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_104_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_105 @ 0XFF9811A4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_105_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_105_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_105_PARITY                        0x0\n\n    * Entry 105 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00690000\n    * (OFFSET, MASK, VALUE)      (0XFF9811A4, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_105_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_106 @ 0XFF9811A8\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_106_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_106_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_106_PARITY                        0x0\n\n    * Entry 106 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x006A0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811A8, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_106_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_107 @ 0XFF9811AC\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_107_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_107_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_107_PARITY                        0x0\n\n    * Entry 107 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x006B0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811AC, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_107_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_108 @ 0XFF9811B0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_108_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_108_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_108_PARITY                        0x0\n\n    * Entry 108 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x006C0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811B0, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_108_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_109 @ 0XFF9811B4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_109_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_109_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_109_PARITY                        0x0\n\n    * Entry 109 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x006D0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811B4, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_109_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_110 @ 0XFF9811B8\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_110_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_110_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_110_PARITY                        0x0\n\n    * Entry 110 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x006E0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811B8, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_110_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n   /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_111 @ 0XFF9811BC\n\n   * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_111_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_111_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_111_PARITY                        0x0\n\n    * Entry 111 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x006F0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811BC, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_111_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_112 @ 0XFF9811C0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_112_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_112_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_112_PARITY                        0x0\n\n    * Entry 112 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00700000\n    * (OFFSET, MASK, VALUE)      (0XFF9811C0, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_112_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_113 @ 0XFF9811C4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_113_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_113_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_113_PARITY                        0x0\n\n    * Entry 113 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00710000\n    * (OFFSET, MASK, VALUE)      (0XFF9811C4, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_113_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_114 @ 0XFF9811C8\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_114_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_114_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_114_PARITY                        0x0\n\n    * Entry 114 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00720000\n    * (OFFSET, MASK, VALUE)      (0XFF9811C8, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_114_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_115 @ 0XFF9811CC\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_115_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_115_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_115_PARITY                        0x0\n\n    * Entry 115 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00730000\n    * (OFFSET, MASK, VALUE)      (0XFF9811CC, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_115_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_116 @ 0XFF9811D0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_116_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_116_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_116_PARITY                        0x0\n\n    * Entry 116 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00740000\n    * (OFFSET, MASK, VALUE)      (0XFF9811D0, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_116_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_117 @ 0XFF9811D4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_117_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_117_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_117_PARITY                        0x0\n\n    * Entry 117 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00750000\n    * (OFFSET, MASK, VALUE)      (0XFF9811D4, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_117_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_118 @ 0XFF9811D8\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_118_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_118_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_118_PARITY                        0x0\n\n    * Entry 118 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00760000\n    * (OFFSET, MASK, VALUE)      (0XFF9811D8, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_118_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_119 @ 0XFF9811DC\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_119_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_119_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_119_PARITY                        0x0\n\n    * Entry 119 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00770000\n    * (OFFSET, MASK, VALUE)      (0XFF9811DC, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_119_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_120 @ 0XFF9811E0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_120_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_120_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_120_PARITY                        0x0\n\n    * Entry 120 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00780000\n    * (OFFSET, MASK, VALUE)      (0XFF9811E0, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_120_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_121 @ 0XFF9811E4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_121_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_121_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_121_PARITY                        0x0\n\n    * Entry 121 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00790000\n    * (OFFSET, MASK, VALUE)      (0XFF9811E4, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_121_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_122 @ 0XFF9811E8\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_122_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_122_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_122_PARITY                        0x0\n\n    * Entry 122 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x007A0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811E8, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_122_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_123 @ 0XFF9811EC\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_123_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_123_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_123_PARITY                        0x0\n\n    * Entry 123 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x007B0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811EC, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_123_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_124 @ 0XFF9811F0\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_124_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_124_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_124_PARITY                        0x0\n\n    * Entry 124 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x007C0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811F0, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_124_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_125 @ 0XFF9811F4\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_125_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_125_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_125_PARITY                        0x0\n\n    * Entry 125 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x007D0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811F4, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_125_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_126 @ 0XFF9811F8\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_126_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_126_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_126_PARITY                        0x0\n\n    * Entry 126 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x007E0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811F8, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_126_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_127 @ 0XFF9811FC\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_127_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_127_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_127_PARITY                        0x0\n\n    * Entry 127 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x007F0000\n    * (OFFSET, MASK, VALUE)      (0XFF9811FC, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_127_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_128 @ 0XFF981200\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_128_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_128_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_128_PARITY                        0x0\n\n    * Entry 128 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00800000\n    * (OFFSET, MASK, VALUE)      (0XFF981200, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_128_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_129 @ 0XFF981204\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_129_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_129_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_129_PARITY                        0x0\n\n    * Entry 129 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00810000\n    * (OFFSET, MASK, VALUE)      (0XFF981204, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_129_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_130 @ 0XFF981208\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_130_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_130_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_130_PARITY                        0x0\n\n    * Entry 130 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00820000\n    * (OFFSET, MASK, VALUE)      (0XFF981208, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_130_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_131 @ 0XFF98120C\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_131_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_131_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_131_PARITY                        0x0\n\n    * Entry 131 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00830000\n    * (OFFSET, MASK, VALUE)      (0XFF98120C, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_131_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_132 @ 0XFF981210\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_132_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_132_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_132_PARITY                        0x0\n\n    * Entry 132 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00840000\n    * (OFFSET, MASK, VALUE)      (0XFF981210, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_132_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: CRL_APB, START ADDRESS: FF5E0000, END ADDRESS: FF85FFFF\n    */\n    /*\n    * Register : APERPERM_133 @ 0XFF981214\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_133_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_133_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_133_PARITY                        0x0\n\n    * Entry 133 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x00850000\n    * (OFFSET, MASK, VALUE)      (0XFF981214, 0xF80FFFFFU ,0x00002ADFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_133_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_3, START ADDRESS: FF860000, END ADDRESS: FF95F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: OCM_SLCR, START ADDRESS: FF960000, END ADDRESS: FF96FFFF\n    */\n    /*\n    * APERTURE NAME: LPD_UNUSED_4, START ADDRESS: FF970000, END ADDRESS: FF97F\n    * FFF\n    */\n    /*\n    * APERTURE NAME: LPD_XPPU, START ADDRESS: FF980000, END ADDRESS: FF99FFFF\n    */\n    /*\n    * APERTURE NAME: RPU, START ADDRESS: FF9A0000, END ADDRESS: FF9AFFFF\n    */\n    /*\n    * Register : APERPERM_154 @ 0XFF981268\n\n    * This field defines the MASTER ID match criteria. Each entry in the IDL c\n    * orresponds to a bit in this field. 0=not match, 1=match.\n    *  PSU_LPD_XPPU_CFG_APERPERM_154_PERMISSION                    0x2adf\n\n    * 1=secure or non-secure transactions are allowed 0=only secure transactio\n    * na are allowed\n    *  PSU_LPD_XPPU_CFG_APERPERM_154_TRUSTZONE                     0x0\n\n    * SW must calculate and set up parity, if parity check is enabled by the C\n    * TRL register. 31: parity for bits 19:15 30: parity for bits 14:10 29: pa\n    * rity for bits 9:5 28: parity for bits 27, 4:0\n    *  PSU_LPD_XPPU_CFG_APERPERM_154_PARITY                        0x0\n\n    * Entry 154 of the Aperture Permission List, for the 64K-byte aperture at\n    * BASE_64KB + 0x009A0000\n    * (OFFSET, MASK, VALUE)      (0XFF981268, 0xF80FFFFFU ,0x00002ADFU)\n    */	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_154_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_167_OFFSET,\n		0xF80FFFFFU, 0x00000280U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_204_OFFSET,\n		0xF80FFFFFU, 0x00002ADFU);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_256_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_257_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_258_OFFSET,\n		0xF80FFFFFU, 0x08001800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_259_OFFSET,\n		0xF80FFFFFU, 0x08002400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_260_OFFSET,\n		0xF80FFFFFU, 0x08000820U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_261_OFFSET,\n		0xF80FFFFFU, 0x08000440U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_262_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_263_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_264_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_265_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_266_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_267_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_268_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_269_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\nPSU_Mask_Write(LPD_XPPU_CFG_APERPERM_270_OFFSET,\n		0xF80FFFFFU, 0x08000900U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_271_OFFSET,\n		0xF80FFFFFU, 0x08000600U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_272_OFFSET,\n		0xF80FFFFFU, 0x08002400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_273_OFFSET,\n		0xF80FFFFFU, 0x08001800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_274_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_275_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_276_OFFSET,\n		0xF80FFFFFU, 0x08002020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_277_OFFSET,\n		0xF80FFFFFU, 0x08001040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_278_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_279_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_280_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_281_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_282_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_283_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_284_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_285_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_286_OFFSET,\n		0xF80FFFFFU, 0x08002100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_287_OFFSET,\n		0xF80FFFFFU, 0x08001200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_288_OFFSET,\n		0xF80FFFFFU, 0x08000440U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_289_OFFSET,\n		0xF80FFFFFU, 0x08000820U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_290_OFFSET,\n		0xF80FFFFFU, 0x08001040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_291_OFFSET,\n		0xF80FFFFFU, 0x08002020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_292_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_293_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_294_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_295_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_296_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_297_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_298_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_299_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_300_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_301_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_302_OFFSET,\n		0xF80FFFFFU, 0x08000140U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_303_OFFSET,\n		0xF80FFFFFU, 0x08000220U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_304_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_305_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_306_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_307_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_308_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_309_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_318_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_319_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_320_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_321_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_322_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_323_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_324_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_325_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_334_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_335_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_336_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_337_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_338_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_339_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_340_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_341_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_350_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_351_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_352_OFFSET,\n		0xF80FFFFFU, 0x08000400U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_353_OFFSET,\n		0xF80FFFFFU, 0x08000800U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_354_OFFSET,\n		0xF80FFFFFU, 0x08001000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_355_OFFSET,\n		0xF80FFFFFU, 0x08002000U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_356_OFFSET,\n		0xF80FFFFFU, 0x08000020U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_357_OFFSET,\n		0xF80FFFFFU, 0x08000040U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_366_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_367_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_368_OFFSET,\n		0xF80FFFFFU, 0x08000600U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_369_OFFSET,\n		0xF80FFFFFU, 0x08000900U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_370_OFFSET,\n		0xF80FFFFFU, 0x08001200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_371_OFFSET,\n		0xF80FFFFFU, 0x08002100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_372_OFFSET,\n		0xF80FFFFFU, 0x08000220U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_373_OFFSET,\n		0xF80FFFFFU, 0x08000140U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_374_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_375_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_376_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_377_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_378_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_379_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_380_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_381_OFFSET,\n		0xF80FFFFFU, 0x08000100U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_382_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	PSU_Mask_Write(LPD_XPPU_CFG_APERPERM_383_OFFSET,\n		0xF80FFFFFU, 0x08000200U);\n/*##################################################################### */\n\n	/*\n	* Register : IEN @ 0XFF980018\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_APER_PARITY                            0X1\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_APER_TZ                                0X1\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_APER_PERM                              0X1\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_MID_PARITY                             0X1\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_MID_RO                                 0X1\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_MID_MISS                               0X1\n\n    * See Interuppt Status Register for details\n    *  PSU_LPD_XPPU_CFG_IEN_INV_APB                                0X1\n\n    * Interrupt Enable Register\n    * (OFFSET, MASK, VALUE)      (0XFF980018, 0x000000EFU ,0x000000EFU)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_IEN_OFFSET, 0x000000EFU, 0x000000EFU);\n/*##################################################################### */\n\n    /*\n    * XPPU CONTROL\n    */\n    /*\n    * Register : err_ctrl @ 0XFF9CFFEC\n\n    * Whether an APB access to the hole region and to an unimplemented regis\n    * ter space causes PSLVERR\n    *  PSU_LPD_XPPU_SINK_ERR_CTRL_PSLVERR                          1\n\n    * Error control register\n    * (OFFSET, MASK, VALUE)      (0XFF9CFFEC, 0x00000001U ,0x00000001U)\n    */\n	PSU_Mask_Write(LPD_XPPU_SINK_ERR_CTRL_OFFSET,\n		0x00000001U, 0x00000001U);\n/*##################################################################### */\n\n    /*\n    * Register : CTRL @ 0XFF980000\n\n    * 0=Bypass XPPU (transparent) 1=Enable XPPU permission checking\n    *  PSU_LPD_XPPU_CFG_CTRL_ENABLE                                1\n\n    * XPPU Control Register\n    * (OFFSET, MASK, VALUE)      (0XFF980000, 0x00000001U ,0x00000001U)\n    */\n	PSU_Mask_Write(LPD_XPPU_CFG_CTRL_OFFSET, 0x00000001U, 0x00000001U);\n/*##################################################################### */"


    xppu_aperperm_data = xppu_aperperm_lines.splitlines()

    txt = "unsigned long APER_OFFSET = 0xFF981000;\nint i = 0;\n\nfor (; i <= 400; i++) {\n		PSU_Mask_Write(APER_OFFSET, 0xF80FFFFFU, 0x08080000U);\n		APER_OFFSET = APER_OFFSET + 0x4;\n	}"
    xppu_aper_ram = txt.splitlines()

    final_lines = config(name_cpu, reg_value, setting)
    print(final_lines)
    o = open(str(options['args'][0]), "rt")
    code = o.readlines()
    line_number = []
    code_lines = []
    new_lines = []

    for i, line in enumerate(code):
        line_number.append(i+1)
        code_lines.append(line)
    a = 0
    b = 0
    c = 0
    d = 0
    e = 0

    for i in range(0,len(line_number)):
        if "psu_init_xppu_aper_ram();" in code_lines[i]:
            a= i
            break
    for i in range(0,len(line_number)):
        if "psu_init_xppu_aper_ram(void)" in code_lines[i]:
            b=i
            break
    for i in range(b, len(line_number)):
        if "return" in code_lines[i]:
            c = i
            break
    for i in range(0,len(line_number)):
        if "psu_lpd_xppu_data(void)" in code_lines[i]:
            d = i
            break

    for i in range(d, len(line_number)):
        if "return" in code_lines[i]:
            e = i
            break
   
    for i in range(0,d+2):
        new_lines.append(code_lines[i])

    for i in range(0, len(xppu_masterid_data)):
        new_lines.append(xppu_masterid_data[i])
 
    for i in range(0, len(final_lines)):
        new_lines.append(str(final_lines[i]))

    for i in range(0,len(xppu_aperperm_data)):
        new_lines.append(xppu_aperperm_data[i])

    for i in range(e,b+2):
        new_lines.append(code_lines[i])

    for i in range(0,len(xppu_aper_ram)):
        new_lines.append(xppu_aper_ram[i])

    for i in range(b+2, c+1):
        new_lines.append(code_lines[i])

    for i in range(c+1, a+1):
        new_lines.append(code_lines[i])

    new_lines.append(str("	psu_lpd_xppu_data();"))
	
    for i in range(a+2,(len(line_number)+1)):
        new_lines.append(code_lines[i-1])

    n = open(str(options['args'][1]), "w")
    for i in range(0, (len(new_lines))):
        n.write(new_lines[i])
        n.write("\n")
    o.close()
    n.close()     
    return 0
    
