#ifndef XPARAMETERS_H   /* prevent circular inclusions */
#define XPARAMETERS_H   /* by using protection macros */

#define XPAR_XBRAM_NUM_INSTANCES 1

/* Definitions for peripheral AXI_BRAM_CTRL_0 */
#define XPAR_AXI_BRAM_CTRL_0_COMPATIBLE "xlnx,axi-bram-ctrl-4.1"
#define XPAR_AXI_BRAM_CTRL_0_BASEADDR 0xa4000000
#define XPAR_AXI_BRAM_CTRL_0_HIGHADDR 0xa4001fff
#define XPAR_AXI_BRAM_CTRL_0_DATA_WIDTH 0x20
#define XPAR_AXI_BRAM_CTRL_0_ECC 0x0
#define XPAR_AXI_BRAM_CTRL_0_FAULT_INJECT 0x0
#define XPAR_AXI_BRAM_CTRL_0_ECC_ONOFF_RESET_VALUE 0x0

/* Canonical definitions for peripheral AXI_BRAM_CTRL_0 */
#define XPAR_XBRAM_0_BASEADDR 0xa4000000
#define XPAR_XBRAM_0_HIGHADDR 0xa4001fff
#define XPAR_XBRAM_0_COMPATIBLE "xlnx,axi-bram-ctrl-4.1"
#define XPAR_XBRAM_0_DATA_WIDTH 0x20
#define XPAR_XBRAM_0_ECC 0x0
#define XPAR_XBRAM_0_ECC_ONOFF_RESET_VALUE 0x0
#define XPAR_XBRAM_0_FAULT_INJECT 0x0

#define XPAR_XCFRAME_NUM_INSTANCES 1

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_CFI_CFRAME_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_CFI_CFRAME_0_COMPATIBLE "xlnx,psv-pmc-cfi-cframe-11.0"
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_CFI_CFRAME_0_BASEADDR 0xf12d0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_CFI_CFRAME_0_HIGHADDR 0xf12d0fff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_CFI_CFRAME_0 */
#define XPAR_XCFRAME_0_BASEADDR 0xf12d0000
#define XPAR_XCFRAME_0_HIGHADDR 0xf12d0fff
#define XPAR_XCFRAME_0_COMPATIBLE "xlnx,psv-pmc-cfi-cframe-11.0"

#define XPAR_XCFUPMC_NUM_INSTANCES 1

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_CFU_APB_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_CFU_APB_0_COMPATIBLE "xlnx,psv-pmc-cfu-apb-11.0"
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_CFU_APB_0_BASEADDR 0xf12b0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_CFU_APB_0_HIGHADDR 0xf12bffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_CFU_APB_0 */
#define XPAR_XCFUPMC_0_BASEADDR 0xf12b0000
#define XPAR_XCFUPMC_0_HIGHADDR 0xf12bffff
#define XPAR_XCFUPMC_0_COMPATIBLE "xlnx,psv-pmc-cfu-apb-11.0"

#define XPAR_XCORESIGHTPS_DCC_NUM_INSTANCES 1

/* Definitions for peripheral CORESIGHT */
#define XPAR_CORESIGHT_COMPATIBLE "xlnx,coresight-1.0"
#define XPAR_CORESIGHT_BASEADDR 0xf0800000
#define XPAR_CORESIGHT_HIGHADDR 0xf080ffff

/* Canonical definitions for peripheral CORESIGHT */
#define XPAR_XCORESIGHTPS_DCC_0_BASEADDR 0xf0800000
#define XPAR_XCORESIGHTPS_DCC_0_HIGHADDR 0xf080ffff
#define XPAR_XCORESIGHTPS_DCC_0_COMPATIBLE "xlnx,coresight-1.0"

#define XPAR_XCSUDMA_NUM_INSTANCES 2

/* Definitions for peripheral DMA0 */
#define XPAR_DMA0_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_DMA0_BASEADDR 0xf11c0000
#define XPAR_DMA0_HIGHADDR 0xf11cffff
#define XPAR_DMA0_DMA_TYPE 0x1
#define XPAR_DMA0_INTERRUPTS 0x4083
#define XPAR_DMA0_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral DMA0 */
#define XPAR_XCSUDMA_0_BASEADDR 0xf11c0000
#define XPAR_XCSUDMA_0_HIGHADDR 0xf11cffff
#define XPAR_XCSUDMA_0_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_XCSUDMA_0_DMA_TYPE 0x1
#define XPAR_XCSUDMA_0_INTERRUPTS 0x4083
#define XPAR_XCSUDMA_0_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral DMA1 */
#define XPAR_DMA1_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_DMA1_BASEADDR 0xf11d0000
#define XPAR_DMA1_HIGHADDR 0xf11dffff
#define XPAR_DMA1_DMA_TYPE 0x2
#define XPAR_DMA1_INTERRUPTS 0x4084
#define XPAR_DMA1_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral DMA1 */
#define XPAR_XCSUDMA_1_BASEADDR 0xf11d0000
#define XPAR_XCSUDMA_1_HIGHADDR 0xf11dffff
#define XPAR_XCSUDMA_1_COMPATIBLE "xlnx,zynqmp-csudma-1.0"
#define XPAR_XCSUDMA_1_DMA_TYPE 0x2
#define XPAR_XCSUDMA_1_INTERRUPTS 0x4084
#define XPAR_XCSUDMA_1_INTERRUPT_PARENT 0xf9000000

#define XPAR_XEMACPS_NUM_INSTANCES 1

/* Definitions for peripheral GEM0 */
#define XPAR_GEM0_COMPATIBLE "xlnx,versal-gem"
#define XPAR_GEM0_BASEADDR 0xff0c0000
#define XPAR_GEM0_HIGHADDR 0xff0c0fff
#define XPAR_GEM0_INTERRUPTS 0x4038
#define XPAR_GEM0_INTERRUPTS_1 0x4038
#define XPAR_GEM0_INTERRUPT_PARENT 0xf9000000
#define XPAR_GEM0_PHY_MODE "rgmii-id"
#define XPAR_GEM0_PHY_HANDLE 0x1

/* Canonical definitions for peripheral GEM0 */
#define XPAR_XEMACPS_0_BASEADDR 0xff0c0000
#define XPAR_XEMACPS_0_HIGHADDR 0xff0c0fff
#define XPAR_XEMACPS_0_COMPATIBLE "xlnx,versal-gem"
#define XPAR_XEMACPS_0_INTERRUPTS 0x4038
#define XPAR_XEMACPS_0_INTERRUPT_PARENT 0xf9000000
#define XPAR_XEMACPS_0_PHY_MODE "rgmii-id"
#define XPAR_XEMACPS_0_PHY_HANDLE 0x1

#define XPAR_XGPIO_NUM_INSTANCES 3

/* Definitions for peripheral AXI_GPIO_0 */
#define XPAR_AXI_GPIO_0_COMPATIBLE "xlnx,axi-gpio-2.0"
#define XPAR_AXI_GPIO_0_BASEADDR 0xa6010000
#define XPAR_AXI_GPIO_0_HIGHADDR 0xa601ffff
#define XPAR_AXI_GPIO_0_INTERRUPT_PRESENT 0x0
#define XPAR_AXI_GPIO_0_IS_DUAL 0x0
#define XPAR_AXI_GPIO_0_GPIO_WIDTH 0x4

/* Canonical definitions for peripheral AXI_GPIO_0 */
#define XPAR_XGPIO_0_BASEADDR 0xa6010000
#define XPAR_XGPIO_0_HIGHADDR 0xa601ffff
#define XPAR_XGPIO_0_COMPATIBLE "xlnx,axi-gpio-2.0"
#define XPAR_XGPIO_0_GPIO_WIDTH 0x4
#define XPAR_XGPIO_0_INTERRUPT_PRESENT 0x0
#define XPAR_XGPIO_0_IS_DUAL 0x0

/* Definitions for peripheral AXI_GPIO_1 */
#define XPAR_AXI_GPIO_1_COMPATIBLE "xlnx,axi-gpio-2.0"
#define XPAR_AXI_GPIO_1_BASEADDR 0xa6020000
#define XPAR_AXI_GPIO_1_HIGHADDR 0xa602ffff
#define XPAR_AXI_GPIO_1_INTERRUPT_PRESENT 0x0
#define XPAR_AXI_GPIO_1_IS_DUAL 0x0
#define XPAR_AXI_GPIO_1_GPIO_WIDTH 0x4

/* Canonical definitions for peripheral AXI_GPIO_1 */
#define XPAR_XGPIO_1_BASEADDR 0xa6020000
#define XPAR_XGPIO_1_HIGHADDR 0xa602ffff
#define XPAR_XGPIO_1_COMPATIBLE "xlnx,axi-gpio-2.0"
#define XPAR_XGPIO_1_GPIO_WIDTH 0x4
#define XPAR_XGPIO_1_INTERRUPT_PRESENT 0x0
#define XPAR_XGPIO_1_IS_DUAL 0x0

/* Definitions for peripheral AXI_GPIO_2 */
#define XPAR_AXI_GPIO_2_COMPATIBLE "xlnx,axi-gpio-2.0"
#define XPAR_AXI_GPIO_2_BASEADDR 0xa6030000
#define XPAR_AXI_GPIO_2_HIGHADDR 0xa603ffff
#define XPAR_AXI_GPIO_2_INTERRUPT_PRESENT 0x0
#define XPAR_AXI_GPIO_2_IS_DUAL 0x0
#define XPAR_AXI_GPIO_2_GPIO_WIDTH 0x2

/* Canonical definitions for peripheral AXI_GPIO_2 */
#define XPAR_XGPIO_2_BASEADDR 0xa6030000
#define XPAR_XGPIO_2_HIGHADDR 0xa603ffff
#define XPAR_XGPIO_2_COMPATIBLE "xlnx,axi-gpio-2.0"
#define XPAR_XGPIO_2_GPIO_WIDTH 0x2
#define XPAR_XGPIO_2_INTERRUPT_PRESENT 0x0
#define XPAR_XGPIO_2_IS_DUAL 0x0

#define XPAR_XIICPS_NUM_INSTANCES 2

/* Definitions for peripheral I2C0 */
#define XPAR_I2C0_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_I2C0_BASEADDR 0xff020000
#define XPAR_I2C0_HIGHADDR 0xff020fff
#define XPAR_I2C0_CLOCK_FREQ 0x5f5dd19
#define XPAR_I2C0_INTERRUPTS 0x400e
#define XPAR_I2C0_INTERRUPT_PARENT 0xf9000000
#define XPAR_I2C0_CLOCKS 0x62

/* Canonical definitions for peripheral I2C0 */
#define XPAR_XIICPS_0_BASEADDR 0xff020000
#define XPAR_XIICPS_0_HIGHADDR 0xff020fff
#define XPAR_XIICPS_0_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_XIICPS_0_CLOCK_FREQ 0x5f5dd19
#define XPAR_XIICPS_0_CLOCKS 0x62
#define XPAR_XIICPS_0_INTERRUPTS 0x400e
#define XPAR_XIICPS_0_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral I2C1 */
#define XPAR_I2C1_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_I2C1_BASEADDR 0xff030000
#define XPAR_I2C1_HIGHADDR 0xff030fff
#define XPAR_I2C1_CLOCK_FREQ 0x5f5dd19
#define XPAR_I2C1_INTERRUPTS 0x400f
#define XPAR_I2C1_INTERRUPT_PARENT 0xf9000000
#define XPAR_I2C1_CLOCKS 0x63

/* Canonical definitions for peripheral I2C1 */
#define XPAR_XIICPS_1_BASEADDR 0xff030000
#define XPAR_XIICPS_1_HIGHADDR 0xff030fff
#define XPAR_XIICPS_1_COMPATIBLE "cdns,i2c-r1p14"
#define XPAR_XIICPS_1_CLOCK_FREQ 0x5f5dd19
#define XPAR_XIICPS_1_CLOCKS 0x63
#define XPAR_XIICPS_1_INTERRUPTS 0x400f
#define XPAR_XIICPS_1_INTERRUPT_PARENT 0xf9000000

#define XPAR_XIPIPSU_NUM_INSTANCES 1

/* Definitions for peripheral IPI2 */
#define XPAR_IPI2_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_IPI2_BASEADDR 0xff350000
#define XPAR_IPI2_HIGHADDR 0xff35001f
#define XPAR_IPI2_IPI_BITMASK 0x10
#define XPAR_IPI2_IPI_BUF_INDEX 0x4
#define XPAR_IPI2_INTERRUPTS 0x4020
#define XPAR_IPI2_INTR 0x40
#define XPAR_IPI2_INTERRUPT_PARENT 0xf9000000
#define XPAR_IPI2_IPI_TARGET_COUNT 0xa
#define XPAR_IPI2_0_IPI_BITMASK 0x4
#define XPAR_IPI2_0_IPI_BUF_INDEX 0x2
#define XPAR_IPI2_1_IPI_BITMASK 0x8
#define XPAR_IPI2_1_IPI_BUF_INDEX 0x3
#define XPAR_IPI2_2_IPI_BITMASK 0x10
#define XPAR_IPI2_2_IPI_BUF_INDEX 0x4
#define XPAR_IPI2_3_IPI_BITMASK 0x20
#define XPAR_IPI2_3_IPI_BUF_INDEX 0x5
#define XPAR_IPI2_4_IPI_BITMASK 0x40
#define XPAR_IPI2_4_IPI_BUF_INDEX 0x6
#define XPAR_IPI2_5_IPI_BITMASK 0x80
#define XPAR_IPI2_5_IPI_BUF_INDEX 0x7
#define XPAR_IPI2_6_IPI_BITMASK 0x200
#define XPAR_IPI2_6_IPI_BUF_INDEX 0xffff
#define XPAR_IPI2_7_IPI_BITMASK 0x2
#define XPAR_IPI2_7_IPI_BUF_INDEX 0x1
#define XPAR_IPI2_8_IPI_BITMASK 0x100
#define XPAR_IPI2_8_IPI_BUF_INDEX 0xffff
#define XPAR_IPI2_9_IPI_BITMASK 0x1
#define XPAR_IPI2_9_IPI_BUF_INDEX 0x0

/* Canonical definitions for peripheral IPI2 */
#define XPAR_XIPIPSU_0_BASEADDR 0xff350000
#define XPAR_XIPIPSU_0_HIGHADDR 0xff35001f
#define XPAR_XIPIPSU_0_INTR 0x40
#define XPAR_XIPIPSU_0_COMPATIBLE "xlnx,zynqmp-ipi-mailbox"
#define XPAR_XIPIPSU_0_IPI_BITMASK 0x10
#define XPAR_XIPIPSU_0_IPI_BUF_INDEX 0x4
#define XPAR_XIPIPSU_0_INTERRUPTS 0x4020
#define XPAR_XIPIPSU_0_INTERRUPT_PARENT 0xf9000000
#define XPAR_XIPIPSU_0_IPI_TARGET_COUNT 0xa
#define XPAR_XIPIPSU_0_CH0_IPI_BITMASK 0x4
#define XPAR_XIPIPSU_0_CH0_IPI_BUF_INDEX 0x2
#define XPAR_XIPIPSU_0_CH1_IPI_BITMASK 0x8
#define XPAR_XIPIPSU_0_CH1_IPI_BUF_INDEX 0x3
#define XPAR_XIPIPSU_0_CH2_IPI_BITMASK 0x10
#define XPAR_XIPIPSU_0_CH2_IPI_BUF_INDEX 0x4
#define XPAR_XIPIPSU_0_CH3_IPI_BITMASK 0x20
#define XPAR_XIPIPSU_0_CH3_IPI_BUF_INDEX 0x5
#define XPAR_XIPIPSU_0_CH4_IPI_BITMASK 0x40
#define XPAR_XIPIPSU_0_CH4_IPI_BUF_INDEX 0x6
#define XPAR_XIPIPSU_0_CH5_IPI_BITMASK 0x80
#define XPAR_XIPIPSU_0_CH5_IPI_BUF_INDEX 0x7
#define XPAR_XIPIPSU_0_CH6_IPI_BITMASK 0x200
#define XPAR_XIPIPSU_0_CH6_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH7_IPI_BITMASK 0x2
#define XPAR_XIPIPSU_0_CH7_IPI_BUF_INDEX 0x1
#define XPAR_XIPIPSU_0_CH8_IPI_BITMASK 0x100
#define XPAR_XIPIPSU_0_CH8_IPI_BUF_INDEX 0xffff
#define XPAR_XIPIPSU_0_CH9_IPI_BITMASK 0x1
#define XPAR_XIPIPSU_0_CH9_IPI_BUF_INDEX 0x0

#define XPAR_XOSPIPSV_NUM_INSTANCES 1

/* Definitions for peripheral OSPI */
#define XPAR_OSPI_COMPATIBLE "xlnx,versal-ospi-1.0"
#define XPAR_OSPI_BASEADDR 0xf1010000
#define XPAR_OSPI_HIGHADDR 0xf101ffff
#define XPAR_OSPI_BASEADDR_1 0xc0000000
#define XPAR_OSPI_OSPI_CLK_FREQ_HZ 0xbebba31
#define XPAR_OSPI_IS_CACHE_COHERENT 0x0
#define XPAR_OSPI_OSPI_MODE 0x0
#define XPAR_OSPI_INTERRUPTS 0x407c
#define XPAR_OSPI_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral OSPI */
#define XPAR_XOSPIPSV_0_BASEADDR 0xf1010000
#define XPAR_XOSPIPSV_0_HIGHADDR 0xf101ffff
#define XPAR_XOSPIPSV_0_COMPATIBLE "xlnx,versal-ospi-1.0"
#define XPAR_XOSPIPSV_0_IS_CACHE_COHERENT 0x0
#define XPAR_XOSPIPSV_0_INTERRUPTS 0x407c
#define XPAR_XOSPIPSV_0_INTERRUPT_PARENT 0xf9000000
#define XPAR_XOSPIPSV_0_OSPI_CLK_FREQ_HZ 0xbebba31
#define XPAR_XOSPIPSV_0_OSPI_MODE 0x0

#define XPAR_XRTCPSU_NUM_INSTANCES 1

/* Definitions for peripheral RTC */
#define XPAR_RTC_COMPATIBLE "xlnx,zynqmp-rtc"
#define XPAR_RTC_BASEADDR 0xf12a0000
#define XPAR_RTC_HIGHADDR 0xf12a00ff
#define XPAR_RTC_INTERRUPTS 0x408e
#define XPAR_RTC_INTERRUPTS_1 0x408f
#define XPAR_RTC_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral RTC */
#define XPAR_XRTCPSU_0_BASEADDR 0xf12a0000
#define XPAR_XRTCPSU_0_HIGHADDR 0xf12a00ff
#define XPAR_XRTCPSU_0_COMPATIBLE "xlnx,zynqmp-rtc"
#define XPAR_XRTCPSU_0_INTERRUPTS 0x408e
#define XPAR_XRTCPSU_0_INTERRUPT_PARENT 0xf9000000

#define XPAR_XSCUGIC_NUM_INSTANCES 1

/* Definitions for peripheral GIC_R5 */
#define XPAR_GIC_R5_COMPATIBLE "arm,pl390"
#define XPAR_GIC_R5_BASEADDR 0xf9000000
#define XPAR_GIC_R5_HIGHADDR 0xf9000fff
#define XPAR_GIC_R5_BASEADDR_1 0xf9001000

/* Canonical definitions for peripheral GIC_R5 */
#define XPAR_XSCUGIC_0_BASEADDR 0xf9000000
#define XPAR_XSCUGIC_0_HIGHADDR 0xf9000fff
#define XPAR_XSCUGIC_0_COMPATIBLE "arm,pl390"

#define XPAR_XSDPS_NUM_INSTANCES 1

/* Definitions for peripheral SDHCI1 */
#define XPAR_SDHCI1_COMPATIBLE "xlnx,versal-8.9a"
#define XPAR_SDHCI1_BASEADDR 0xf1050000
#define XPAR_SDHCI1_HIGHADDR 0xf105ffff
#define XPAR_SDHCI1_SDIO_CLK_FREQ_HZ 0xbebba31
#define XPAR_SDHCI1_HAS_CD 0x1
#define XPAR_SDHCI1_HAS_WP 0x0
#define XPAR_SDHCI1_BUS_WIDTH 0x8
#define XPAR_SDHCI1_MIO_BANK 0x1
#define XPAR_SDHCI1_HAS_EMIO 0x0
#define XPAR_SDHCI1_SLOT_TYPE 0x4
#define XPAR_SDHCI1_IS_CACHE_COHERENT 0x0
#define XPAR_SDHCI1_CLOCKS 0x3c
#define XPAR_SDHCI1_CLK_50_SDR_ITAP_DLY 0x25
#define XPAR_SDHCI1_CLK_50_SDR_OTAP_DLY 0x4
#define XPAR_SDHCI1_CLK_50_DDR_ITAP_DLY 0x2a
#define XPAR_SDHCI1_CLK_50_DDR_OTAP_DLY 0x3
#define XPAR_SDHCI1_CLK_100_SDR_OTAP_DLY 0x3
#define XPAR_SDHCI1_CLK_200_SDR_OTAP_DLY 0x2

/* Canonical definitions for peripheral SDHCI1 */
#define XPAR_XSDPS_0_BASEADDR 0xf1050000
#define XPAR_XSDPS_0_HIGHADDR 0xf105ffff
#define XPAR_XSDPS_0_BUS_WIDTH 0x8
#define XPAR_XSDPS_0_COMPATIBLE "xlnx,versal-8.9a"
#define XPAR_XSDPS_0_CLOCKS 0x3c
#define XPAR_XSDPS_0_CLK_50_SDR_ITAP_DLY 0x25
#define XPAR_XSDPS_0_CLK_50_SDR_OTAP_DLY 0x4
#define XPAR_XSDPS_0_CLK_50_DDR_ITAP_DLY 0x2a
#define XPAR_XSDPS_0_CLK_50_DDR_OTAP_DLY 0x3
#define XPAR_XSDPS_0_CLK_100_SDR_OTAP_DLY 0x3
#define XPAR_XSDPS_0_CLK_200_SDR_OTAP_DLY 0x2
#define XPAR_XSDPS_0_HAS_CD 0x1
#define XPAR_XSDPS_0_HAS_WP 0x0
#define XPAR_XSDPS_0_HAS_EMIO 0x0
#define XPAR_XSDPS_0_IS_CACHE_COHERENT 0x0
#define XPAR_XSDPS_0_MIO_BANK 0x1
#define XPAR_XSDPS_0_SDIO_CLK_FREQ_HZ 0xbebba31
#define XPAR_XSDPS_0_SLOT_TYPE 0x4

#define XPAR_XSYSMONPSV_NUM_INSTANCES 1

/* Definitions for peripheral SYSMON0 */
#define XPAR_SYSMON0_COMPATIBLE "xlnx,versal-sysmon"
#define XPAR_SYSMON0_BASEADDR 0xf1270000
#define XPAR_SYSMON0_HIGHADDR 0xf1273fff

/* Canonical definitions for peripheral SYSMON0 */
#define XPAR_XSYSMONPSV_0_BASEADDR 0xf1270000
#define XPAR_XSYSMONPSV_0_HIGHADDR 0xf1273fff
#define XPAR_XSYSMONPSV_0_COMPATIBLE "xlnx,versal-sysmon"

#define XPAR_XTTCPS_NUM_INSTANCES 1

/* Definitions for peripheral TTC0 */
#define XPAR_TTC0_COMPATIBLE "cdns,ttc"
#define XPAR_TTC0_BASEADDR 0xff0e0000
#define XPAR_TTC0_HIGHADDR 0xff0e0fff
#define XPAR_TTC0_CLOCK_FREQ 0x8f0cba9
#define XPAR_TTC0_INTERRUPTS 0x4025
#define XPAR_TTC0_INTERRUPTS_1 0x4026
#define XPAR_TTC0_INTERRUPTS_2 0x4027
#define XPAR_TTC0_INTERRUPT_PARENT 0xf9000000
#define XPAR_TTC0_TTC_CLK0_CLKSRC 0x1

/* Canonical definitions for peripheral TTC0 */
#define XPAR_XTTCPS_0_BASEADDR 0xff0e0000
#define XPAR_XTTCPS_0_HIGHADDR 0xff0e0fff
#define XPAR_XTTCPS_0_COMPATIBLE "cdns,ttc"
#define XPAR_XTTCPS_0_CLOCK_FREQ 0x8f0cba9
#define XPAR_XTTCPS_0_INTERRUPTS 0x4025
#define XPAR_XTTCPS_0_INTERRUPT_PARENT 0xf9000000
#define XPAR_XTTCPS_0_TTC_CLK0_CLKSRC 0x1

#define XPAR_XUARTNS550_NUM_INSTANCES 1

/* Definitions for peripheral AXI_UART16550_0 */
#define XPAR_AXI_UART16550_0_COMPATIBLE "xlnx,axi-uart16550-2.0"
#define XPAR_AXI_UART16550_0_BASEADDR 0xa6000000
#define XPAR_AXI_UART16550_0_HIGHADDR 0xa600ffff
#define XPAR_AXI_UART16550_0_CLOCK_FREQ 0x5f5dd18

/* Canonical definitions for peripheral AXI_UART16550_0 */
#define XPAR_XUARTNS550_0_BASEADDR 0xa6000000
#define XPAR_XUARTNS550_0_HIGHADDR 0xa600ffff
#define XPAR_XUARTNS550_0_COMPATIBLE "xlnx,axi-uart16550-2.0"
#define XPAR_XUARTNS550_0_CLOCK_FREQ 0x5f5dd18

#define XPAR_XUARTPSV_NUM_INSTANCES 2

/* Definitions for peripheral SERIAL0 */
#define XPAR_SERIAL0_COMPATIBLE "arm,pl011"
#define XPAR_SERIAL0_BASEADDR 0xff000000
#define XPAR_SERIAL0_HIGHADDR 0xff000fff
#define XPAR_SERIAL0_CLOCK_FREQ 0x5f5dd19
#define XPAR_SERIAL0_BAUDRATE 0x1c200
#define XPAR_SERIAL0_INTERRUPTS 0x4012
#define XPAR_SERIAL0_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral SERIAL0 */
#define XPAR_XUARTPSV_0_BASEADDR 0xff000000
#define XPAR_XUARTPSV_0_HIGHADDR 0xff000fff
#define XPAR_XUARTPSV_0_BAUDRATE 0x1c200
#define XPAR_XUARTPSV_0_COMPATIBLE "arm,pl011"
#define XPAR_XUARTPSV_0_CLOCK_FREQ 0x5f5dd19
#define XPAR_XUARTPSV_0_INTERRUPTS 0x4012
#define XPAR_XUARTPSV_0_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral SERIAL1 */
#define XPAR_SERIAL1_COMPATIBLE "arm,pl011"
#define XPAR_SERIAL1_BASEADDR 0xff010000
#define XPAR_SERIAL1_HIGHADDR 0xff010fff
#define XPAR_SERIAL1_CLOCK_FREQ 0x5f5dd19
#define XPAR_SERIAL1_BAUDRATE 0x1c200
#define XPAR_SERIAL1_INTERRUPTS 0x4013
#define XPAR_SERIAL1_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral SERIAL1 */
#define XPAR_XUARTPSV_1_BASEADDR 0xff010000
#define XPAR_XUARTPSV_1_HIGHADDR 0xff010fff
#define XPAR_XUARTPSV_1_BAUDRATE 0x1c200
#define XPAR_XUARTPSV_1_COMPATIBLE "arm,pl011"
#define XPAR_XUARTPSV_1_CLOCK_FREQ 0x5f5dd19
#define XPAR_XUARTPSV_1_INTERRUPTS 0x4013
#define XPAR_XUARTPSV_1_INTERRUPT_PARENT 0xf9000000

#define XPAR_XUSBPSU_NUM_INSTANCES 1

/* Definitions for peripheral DWC3_0 */
#define XPAR_DWC3_0_COMPATIBLE "snps,dwc3"
#define XPAR_DWC3_0_BASEADDR 0xfe200000
#define XPAR_DWC3_0_HIGHADDR 0xfe20ffff
#define XPAR_DWC3_0_ENABLE_SUPERSPEED 0x0
#define XPAR_DWC3_0_INTERRUPTS 0x4016
#define XPAR_DWC3_0_INTERRUPTS_1 0x4016
#define XPAR_DWC3_0_INTERRUPTS_2 0x401a
#define XPAR_DWC3_0_INTERRUPTS_3 0x404a
#define XPAR_DWC3_0_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral DWC3_0 */
#define XPAR_XUSBPSU_0_BASEADDR 0xfe200000
#define XPAR_XUSBPSU_0_HIGHADDR 0xfe20ffff
#define XPAR_XUSBPSU_0_COMPATIBLE "snps,dwc3"
#define XPAR_XUSBPSU_0_ENABLE_SUPERSPEED 0x0
#define XPAR_XUSBPSU_0_INTERRUPTS 0x4016
#define XPAR_XUSBPSU_0_INTERRUPT_PARENT 0xf9000000

#define XPAR_XZDMA_NUM_INSTANCES 8

/* Definitions for peripheral LPD_DMA_CHAN0 */
#define XPAR_LPD_DMA_CHAN0_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN0_BASEADDR 0xffa80000
#define XPAR_LPD_DMA_CHAN0_HIGHADDR 0xffa80fff
#define XPAR_LPD_DMA_CHAN0_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN0_INTERRUPTS 0x403c
#define XPAR_LPD_DMA_CHAN0_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN0 */
#define XPAR_XZDMA_0_BASEADDR 0xffa80000
#define XPAR_XZDMA_0_HIGHADDR 0xffa80fff
#define XPAR_XZDMA_0_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_0_DMA_MODE 0x1
#define XPAR_XZDMA_0_INTERRUPTS 0x403c
#define XPAR_XZDMA_0_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN1 */
#define XPAR_LPD_DMA_CHAN1_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN1_BASEADDR 0xffa90000
#define XPAR_LPD_DMA_CHAN1_HIGHADDR 0xffa90fff
#define XPAR_LPD_DMA_CHAN1_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN1_INTERRUPTS 0x403d
#define XPAR_LPD_DMA_CHAN1_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN1 */
#define XPAR_XZDMA_1_BASEADDR 0xffa90000
#define XPAR_XZDMA_1_HIGHADDR 0xffa90fff
#define XPAR_XZDMA_1_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_1_DMA_MODE 0x1
#define XPAR_XZDMA_1_INTERRUPTS 0x403d
#define XPAR_XZDMA_1_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN2 */
#define XPAR_LPD_DMA_CHAN2_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN2_BASEADDR 0xffaa0000
#define XPAR_LPD_DMA_CHAN2_HIGHADDR 0xffaa0fff
#define XPAR_LPD_DMA_CHAN2_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN2_INTERRUPTS 0x403e
#define XPAR_LPD_DMA_CHAN2_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN2 */
#define XPAR_XZDMA_2_BASEADDR 0xffaa0000
#define XPAR_XZDMA_2_HIGHADDR 0xffaa0fff
#define XPAR_XZDMA_2_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_2_DMA_MODE 0x1
#define XPAR_XZDMA_2_INTERRUPTS 0x403e
#define XPAR_XZDMA_2_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN3 */
#define XPAR_LPD_DMA_CHAN3_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN3_BASEADDR 0xffab0000
#define XPAR_LPD_DMA_CHAN3_HIGHADDR 0xffab0fff
#define XPAR_LPD_DMA_CHAN3_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN3_INTERRUPTS 0x403f
#define XPAR_LPD_DMA_CHAN3_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN3 */
#define XPAR_XZDMA_3_BASEADDR 0xffab0000
#define XPAR_XZDMA_3_HIGHADDR 0xffab0fff
#define XPAR_XZDMA_3_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_3_DMA_MODE 0x1
#define XPAR_XZDMA_3_INTERRUPTS 0x403f
#define XPAR_XZDMA_3_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN4 */
#define XPAR_LPD_DMA_CHAN4_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN4_BASEADDR 0xffac0000
#define XPAR_LPD_DMA_CHAN4_HIGHADDR 0xffac0fff
#define XPAR_LPD_DMA_CHAN4_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN4_INTERRUPTS 0x4040
#define XPAR_LPD_DMA_CHAN4_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN4 */
#define XPAR_XZDMA_4_BASEADDR 0xffac0000
#define XPAR_XZDMA_4_HIGHADDR 0xffac0fff
#define XPAR_XZDMA_4_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_4_DMA_MODE 0x1
#define XPAR_XZDMA_4_INTERRUPTS 0x4040
#define XPAR_XZDMA_4_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN5 */
#define XPAR_LPD_DMA_CHAN5_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN5_BASEADDR 0xffad0000
#define XPAR_LPD_DMA_CHAN5_HIGHADDR 0xffad0fff
#define XPAR_LPD_DMA_CHAN5_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN5_INTERRUPTS 0x4041
#define XPAR_LPD_DMA_CHAN5_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN5 */
#define XPAR_XZDMA_5_BASEADDR 0xffad0000
#define XPAR_XZDMA_5_HIGHADDR 0xffad0fff
#define XPAR_XZDMA_5_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_5_DMA_MODE 0x1
#define XPAR_XZDMA_5_INTERRUPTS 0x4041
#define XPAR_XZDMA_5_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN6 */
#define XPAR_LPD_DMA_CHAN6_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN6_BASEADDR 0xffae0000
#define XPAR_LPD_DMA_CHAN6_HIGHADDR 0xffae0fff
#define XPAR_LPD_DMA_CHAN6_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN6_INTERRUPTS 0x4042
#define XPAR_LPD_DMA_CHAN6_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN6 */
#define XPAR_XZDMA_6_BASEADDR 0xffae0000
#define XPAR_XZDMA_6_HIGHADDR 0xffae0fff
#define XPAR_XZDMA_6_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_6_DMA_MODE 0x1
#define XPAR_XZDMA_6_INTERRUPTS 0x4042
#define XPAR_XZDMA_6_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral LPD_DMA_CHAN7 */
#define XPAR_LPD_DMA_CHAN7_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_LPD_DMA_CHAN7_BASEADDR 0xffaf0000
#define XPAR_LPD_DMA_CHAN7_HIGHADDR 0xffaf0fff
#define XPAR_LPD_DMA_CHAN7_DMA_MODE 0x1
#define XPAR_LPD_DMA_CHAN7_INTERRUPTS 0x4043
#define XPAR_LPD_DMA_CHAN7_INTERRUPT_PARENT 0xf9000000

/* Canonical definitions for peripheral LPD_DMA_CHAN7 */
#define XPAR_XZDMA_7_BASEADDR 0xffaf0000
#define XPAR_XZDMA_7_HIGHADDR 0xffaf0fff
#define XPAR_XZDMA_7_COMPATIBLE "xlnx,zynqmp-dma-1.0"
#define XPAR_XZDMA_7_DMA_MODE 0x1
#define XPAR_XZDMA_7_INTERRUPTS 0x4043
#define XPAR_XZDMA_7_INTERRUPT_PARENT 0xf9000000

/* Definitions for peripheral CCI */
#define XPAR_CCI_BASEADDR 0xfd000000
#define XPAR_CCI_HIGHADDR 0xfd00ffff

/* Canonical definitions for peripheral CCI */
#define XPAR_PSV_FPD_MAINCCI_0_BASEADDR 0xfd000000
#define XPAR_PSV_FPD_MAINCCI_0_HIGHADDR 0xfd00ffff

/* Definitions for peripheral SMMU */
#define XPAR_SMMU_BASEADDR 0xfd800000
#define XPAR_SMMU_HIGHADDR 0xfd83ffff

/* Canonical definitions for peripheral SMMU */
#define XPAR_PSV_FPD_SMMUTCU_0_BASEADDR 0xfd800000
#define XPAR_PSV_FPD_SMMUTCU_0_HIGHADDR 0xfd83ffff

/* Definitions for peripheral USB0 */
#define XPAR_USB0_BASEADDR 0xff9d0000
#define XPAR_USB0_HIGHADDR 0xff9d00ff

/* Canonical definitions for peripheral USB0 */
#define XPAR_PSV_USB_0_BASEADDR 0xff9d0000
#define XPAR_PSV_USB_0_HIGHADDR 0xff9d00ff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_AES */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_AES_BASEADDR 0xf11e0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_AES_HIGHADDR 0xf11effff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_AES */
#define XPAR_PSV_PMC_AES_0_BASEADDR 0xf11e0000
#define XPAR_PSV_PMC_AES_0_HIGHADDR 0xf11effff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_BBRAM_CTRL */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_BBRAM_CTRL_BASEADDR 0xf11f0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_BBRAM_CTRL_HIGHADDR 0xf11fffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_BBRAM_CTRL */
#define XPAR_PSV_PMC_BBRAM_CTRL_0_BASEADDR 0xf11f0000
#define XPAR_PSV_PMC_BBRAM_CTRL_0_HIGHADDR 0xf11fffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CRF_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CRF_0_BASEADDR 0xfd1a0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CRF_0_HIGHADDR 0xfd2dffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CRF_0 */
#define XPAR_PSV_CRF_0_BASEADDR 0xfd1a0000
#define XPAR_PSV_CRF_0_HIGHADDR 0xfd2dffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CRL_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CRL_0_BASEADDR 0xff5e0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CRL_0_HIGHADDR 0xff8dffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CRL_0 */
#define XPAR_PSV_CRL_0_BASEADDR 0xff5e0000
#define XPAR_PSV_CRL_0_HIGHADDR 0xff8dffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CRP_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CRP_0_BASEADDR 0xf1260000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CRP_0_HIGHADDR 0xf126ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CRP_0 */
#define XPAR_PSV_CRP_0_BASEADDR 0xf1260000
#define XPAR_PSV_CRP_0_HIGHADDR 0xf126ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_CTI */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_CTI_BASEADDR 0xf0d10000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_CTI_HIGHADDR 0xf0d1ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_CTI */
#define XPAR_PSV_CORESIGHT_A720_CTI_0_BASEADDR 0xf0d10000
#define XPAR_PSV_CORESIGHT_A720_CTI_0_HIGHADDR 0xf0d1ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_DBG */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_DBG_BASEADDR 0xf0d00000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_DBG_HIGHADDR 0xf0d0ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_DBG */
#define XPAR_PSV_CORESIGHT_A720_DBG_0_BASEADDR 0xf0d00000
#define XPAR_PSV_CORESIGHT_A720_DBG_0_HIGHADDR 0xf0d0ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_ETM */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_ETM_BASEADDR 0xf0d30000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_ETM_HIGHADDR 0xf0d3ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_ETM */
#define XPAR_PSV_CORESIGHT_A720_ETM_0_BASEADDR 0xf0d30000
#define XPAR_PSV_CORESIGHT_A720_ETM_0_HIGHADDR 0xf0d3ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_PMU */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_PMU_BASEADDR 0xf0d20000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_PMU_HIGHADDR 0xf0d2ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A720_PMU */
#define XPAR_PSV_CORESIGHT_A720_PMU_0_BASEADDR 0xf0d20000
#define XPAR_PSV_CORESIGHT_A720_PMU_0_HIGHADDR 0xf0d2ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_CTI */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_CTI_BASEADDR 0xf0d50000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_CTI_HIGHADDR 0xf0d5ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_CTI */
#define XPAR_PSV_CORESIGHT_A721_CTI_0_BASEADDR 0xf0d50000
#define XPAR_PSV_CORESIGHT_A721_CTI_0_HIGHADDR 0xf0d5ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_DBG */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_DBG_BASEADDR 0xf0d40000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_DBG_HIGHADDR 0xf0d4ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_DBG */
#define XPAR_PSV_CORESIGHT_A721_DBG_0_BASEADDR 0xf0d40000
#define XPAR_PSV_CORESIGHT_A721_DBG_0_HIGHADDR 0xf0d4ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_ETM */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_ETM_BASEADDR 0xf0d70000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_ETM_HIGHADDR 0xf0d7ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_ETM */
#define XPAR_PSV_CORESIGHT_A721_ETM_0_BASEADDR 0xf0d70000
#define XPAR_PSV_CORESIGHT_A721_ETM_0_HIGHADDR 0xf0d7ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_PMU */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_PMU_BASEADDR 0xf0d60000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_PMU_HIGHADDR 0xf0d6ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_A721_PMU */
#define XPAR_PSV_CORESIGHT_A721_PMU_0_BASEADDR 0xf0d60000
#define XPAR_PSV_CORESIGHT_A721_PMU_0_HIGHADDR 0xf0d6ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_CTI */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_CTI_BASEADDR 0xf0ca0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_CTI_HIGHADDR 0xf0caffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_CTI */
#define XPAR_PSV_CORESIGHT_APU_CTI_0_BASEADDR 0xf0ca0000
#define XPAR_PSV_CORESIGHT_APU_CTI_0_HIGHADDR 0xf0caffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ELA */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ELA_BASEADDR 0xf0c60000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ELA_HIGHADDR 0xf0c6ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ELA */
#define XPAR_PSV_CORESIGHT_APU_ELA_0_BASEADDR 0xf0c60000
#define XPAR_PSV_CORESIGHT_APU_ELA_0_HIGHADDR 0xf0c6ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ETF */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ETF_BASEADDR 0xf0c30000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ETF_HIGHADDR 0xf0c3ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_ETF */
#define XPAR_PSV_CORESIGHT_APU_ETF_0_BASEADDR 0xf0c30000
#define XPAR_PSV_CORESIGHT_APU_ETF_0_HIGHADDR 0xf0c3ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_FUN */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_FUN_BASEADDR 0xf0c20000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_FUN_HIGHADDR 0xf0c2ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_APU_FUN */
#define XPAR_PSV_CORESIGHT_APU_FUN_0_BASEADDR 0xf0c20000
#define XPAR_PSV_CORESIGHT_APU_FUN_0_HIGHADDR 0xf0c2ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_ATM */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_ATM_BASEADDR 0xf0b80000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_ATM_HIGHADDR 0xf0b8ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_ATM */
#define XPAR_PSV_CORESIGHT_FPD_ATM_0_BASEADDR 0xf0b80000
#define XPAR_PSV_CORESIGHT_FPD_ATM_0_HIGHADDR 0xf0b8ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_STM */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_STM_BASEADDR 0xf0b70000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_STM_HIGHADDR 0xf0b7ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_FPD_STM */
#define XPAR_PSV_CORESIGHT_FPD_STM_0_BASEADDR 0xf0b70000
#define XPAR_PSV_CORESIGHT_FPD_STM_0_HIGHADDR 0xf0b7ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_LPD_ATM */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_LPD_ATM_BASEADDR 0xf0980000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_LPD_ATM_HIGHADDR 0xf098ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_CORESIGHT_LPD_ATM */
#define XPAR_PSV_CORESIGHT_LPD_ATM_0_BASEADDR 0xf0980000
#define XPAR_PSV_CORESIGHT_LPD_ATM_0_HIGHADDR 0xf098ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_RSA */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_RSA_BASEADDR 0xf1200000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_RSA_HIGHADDR 0xf120ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_RSA */
#define XPAR_PSV_PMC_RSA_0_BASEADDR 0xf1200000
#define XPAR_PSV_PMC_RSA_0_HIGHADDR 0xf120ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CACHE */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CACHE_BASEADDR 0xf1250000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CACHE_HIGHADDR 0xf125ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CACHE */
#define XPAR_PSV_PMC_EFUSE_CACHE_0_BASEADDR 0xf1250000
#define XPAR_PSV_PMC_EFUSE_CACHE_0_HIGHADDR 0xf125ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CTRL */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CTRL_BASEADDR 0xf1240000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CTRL_HIGHADDR 0xf124ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_EFUSE_CTRL */
#define XPAR_PSV_PMC_EFUSE_CTRL_0_BASEADDR 0xf1240000
#define XPAR_PSV_PMC_EFUSE_CTRL_0_HIGHADDR 0xf124ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_0_BASEADDR 0xfd360000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_0_HIGHADDR 0xfd36ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_0 */
#define XPAR_PSV_FPD_AFI_0_BASEADDR 0xfd360000
#define XPAR_PSV_FPD_AFI_0_HIGHADDR 0xfd36ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_2 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_2_BASEADDR 0xfd380000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_2_HIGHADDR 0xfd38ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_AFI_2 */
#define XPAR_PSV_FPD_AFI_1_BASEADDR 0xfd380000
#define XPAR_PSV_FPD_AFI_1_HIGHADDR 0xfd38ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_APU_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_APU_0_BASEADDR 0xfd5c0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_APU_0_HIGHADDR 0xfd5cffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_APU_0 */
#define XPAR_PSV_APU_0_BASEADDR 0xfd5c0000
#define XPAR_PSV_APU_0_HIGHADDR 0xfd5cffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_CCI_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_CCI_0_BASEADDR 0xfd5e0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_CCI_0_HIGHADDR 0xfd5effff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_CCI_0 */
#define XPAR_PSV_FPD_CCI_0_BASEADDR 0xfd5e0000
#define XPAR_PSV_FPD_CCI_0_HIGHADDR 0xfd5effff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_GPV_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_GPV_0_BASEADDR 0xfd700000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_GPV_0_HIGHADDR 0xfd7fffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_GPV_0 */
#define XPAR_PSV_FPD_GPV_0_BASEADDR 0xfd700000
#define XPAR_PSV_FPD_GPV_0_HIGHADDR 0xfd7fffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_0_BASEADDR 0xfd610000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_0_HIGHADDR 0xfd61ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_0 */
#define XPAR_PSV_FPD_SLCR_0_BASEADDR 0xfd610000
#define XPAR_PSV_FPD_SLCR_0_HIGHADDR 0xfd61ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_SECURE_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_SECURE_0_BASEADDR 0xfd690000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_SECURE_0_HIGHADDR 0xfd69ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_SLCR_SECURE_0 */
#define XPAR_PSV_FPD_SLCR_SECURE_0_BASEADDR 0xfd690000
#define XPAR_PSV_FPD_SLCR_SECURE_0_HIGHADDR 0xfd69ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_SMMU_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_SMMU_0_BASEADDR 0xfd5f0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_FPD_SMMU_0_HIGHADDR 0xfd5fffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_FPD_SMMU_0 */
#define XPAR_PSV_FPD_SMMU_0_BASEADDR 0xfd5f0000
#define XPAR_PSV_FPD_SMMU_0_HIGHADDR 0xfd5fffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_SCNTR_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_SCNTR_0_BASEADDR 0xff130000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_SCNTR_0_HIGHADDR 0xff13ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_SCNTR_0 */
#define XPAR_PSV_SCNTR_0_BASEADDR 0xff130000
#define XPAR_PSV_SCNTR_0_HIGHADDR 0xff13ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_SCNTRS_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_SCNTRS_0_BASEADDR 0xff140000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_SCNTRS_0_HIGHADDR 0xff14ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_SCNTRS_0 */
#define XPAR_PSV_SCNTRS_0_BASEADDR 0xff140000
#define XPAR_PSV_SCNTRS_0_HIGHADDR 0xff14ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_AFI_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_AFI_0_BASEADDR 0xff9b0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_AFI_0_HIGHADDR 0xff9bffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_AFI_0 */
#define XPAR_PSV_LPD_AFI_0_BASEADDR 0xff9b0000
#define XPAR_PSV_LPD_AFI_0_HIGHADDR 0xff9bffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SECURE_SLCR_0_BASEADDR 0xff0a0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SECURE_SLCR_0_HIGHADDR 0xff0affff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SECURE_SLCR_0 */
#define XPAR_PSV_LPD_IOU_SECURE_SLCR_0_BASEADDR 0xff0a0000
#define XPAR_PSV_LPD_IOU_SECURE_SLCR_0_HIGHADDR 0xff0affff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SLCR_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SLCR_0_BASEADDR 0xff080000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SLCR_0_HIGHADDR 0xff09ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_IOU_SLCR_0 */
#define XPAR_PSV_LPD_IOU_SLCR_0_BASEADDR 0xff080000
#define XPAR_PSV_LPD_IOU_SLCR_0_HIGHADDR 0xff09ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_0_BASEADDR 0xff410000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_0_HIGHADDR 0xff50ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_0 */
#define XPAR_PSV_LPD_SLCR_0_BASEADDR 0xff410000
#define XPAR_PSV_LPD_SLCR_0_HIGHADDR 0xff50ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_SECURE_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_SECURE_0_BASEADDR 0xff510000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_SECURE_0_HIGHADDR 0xff54ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_LPD_SLCR_SECURE_0 */
#define XPAR_PSV_LPD_SLCR_SECURE_0_BASEADDR 0xff510000
#define XPAR_PSV_LPD_SLCR_SECURE_0_HIGHADDR 0xff54ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_OCM_CTRL */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_OCM_CTRL_BASEADDR 0xff960000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_OCM_CTRL_HIGHADDR 0xff96ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_OCM_CTRL */
#define XPAR_PSV_OCM_0_BASEADDR 0xff960000
#define XPAR_PSV_OCM_0_HIGHADDR 0xff96ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_GLOBAL_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_GLOBAL_0_BASEADDR 0xf1110000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_GLOBAL_0_HIGHADDR 0xf115ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_GLOBAL_0 */
#define XPAR_PSV_PMC_GLOBAL_0_BASEADDR 0xf1110000
#define XPAR_PSV_PMC_GLOBAL_0_HIGHADDR 0xf115ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_RAM_NPI */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_RAM_NPI_BASEADDR 0xf6000000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_RAM_NPI_HIGHADDR 0xf7ffffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_RAM_NPI */
#define XPAR_PSV_PMC_RAM_NPI_0_BASEADDR 0xf6000000
#define XPAR_PSV_PMC_RAM_NPI_0_HIGHADDR 0xf7ffffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT_BASEADDR 0xf1220000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT_HIGHADDR 0xf122ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT */
#define XPAR_PSV_PMC_SLAVE_BOOT_0_BASEADDR 0xf1220000
#define XPAR_PSV_PMC_SLAVE_BOOT_0_HIGHADDR 0xf122ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT_STREAM */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT_STREAM_BASEADDR 0xf2100000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT_STREAM_HIGHADDR 0xf210ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_SLAVE_BOOT_STREAM */
#define XPAR_PSV_PMC_SLAVE_BOOT_STREAM_0_BASEADDR 0xf2100000
#define XPAR_PSV_PMC_SLAVE_BOOT_STREAM_0_HIGHADDR 0xf210ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_PPU1_MDM_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_PPU1_MDM_0_BASEADDR 0xf0310000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_PPU1_MDM_0_HIGHADDR 0xf0317fff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_PPU1_MDM_0 */
#define XPAR_PSV_PMC_PPU1_MDM_0_BASEADDR 0xf0310000
#define XPAR_PSV_PMC_PPU1_MDM_0_HIGHADDR 0xf0317fff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PSM_GLOBAL_REG */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PSM_GLOBAL_REG_BASEADDR 0xffc90000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PSM_GLOBAL_REG_HIGHADDR 0xffc9efff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PSM_GLOBAL_REG */
#define XPAR_PSV_PSM_GLOBAL_REG_0_BASEADDR 0xffc90000
#define XPAR_PSV_PSM_GLOBAL_REG_0_HIGHADDR 0xffc9efff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_TRNG */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_TRNG_BASEADDR 0xf1230000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_TRNG_HIGHADDR 0xf123ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_TRNG */
#define XPAR_PSV_PMC_TRNG_0_BASEADDR 0xf1230000
#define XPAR_PSV_PMC_TRNG_0_HIGHADDR 0xf123ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_0_DATA_CACHE */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_0_DATA_CACHE_BASEADDR 0xffe50000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_0_DATA_CACHE_HIGHADDR 0xffe5ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_0_DATA_CACHE */
#define XPAR_PSV_R5_0_DATA_CACHE_0_BASEADDR 0xffe50000
#define XPAR_PSV_R5_0_DATA_CACHE_0_HIGHADDR 0xffe5ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_0_INSTRUCTION_CACHE */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_0_INSTRUCTION_CACHE_BASEADDR 0xffe40000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_0_INSTRUCTION_CACHE_HIGHADDR 0xffe4ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_0_INSTRUCTION_CACHE */
#define XPAR_PSV_R5_0_INSTRUCTION_CACHE_0_BASEADDR 0xffe40000
#define XPAR_PSV_R5_0_INSTRUCTION_CACHE_0_HIGHADDR 0xffe4ffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_1_DATA_CACHE */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_1_DATA_CACHE_BASEADDR 0xffed0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_1_DATA_CACHE_HIGHADDR 0xffedffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_1_DATA_CACHE */
#define XPAR_PSV_R5_1_DATA_CACHE_0_BASEADDR 0xffed0000
#define XPAR_PSV_R5_1_DATA_CACHE_0_HIGHADDR 0xffedffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_1_INSTRUCTION_CACHE */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_1_INSTRUCTION_CACHE_BASEADDR 0xffec0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_R5_1_INSTRUCTION_CACHE_HIGHADDR 0xffecffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_R5_1_INSTRUCTION_CACHE */
#define XPAR_PSV_R5_1_INSTRUCTION_CACHE_0_BASEADDR 0xffec0000
#define XPAR_PSV_R5_1_INSTRUCTION_CACHE_0_HIGHADDR 0xffecffff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_RPU_0 */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_RPU_0_BASEADDR 0xff9a0000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_RPU_0_HIGHADDR 0xff9affff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_RPU_0 */
#define XPAR_PSV_RPU_0_BASEADDR 0xff9a0000
#define XPAR_PSV_RPU_0_HIGHADDR 0xff9affff

/* Definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_SHA */
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_SHA_BASEADDR 0xf1210000
#define XPAR_PS_WIZARD_0_PMCPS_0_PSV_PMC_SHA_HIGHADDR 0xf121ffff

/* Canonical definitions for peripheral PS_WIZARD_0_PMCPS_0_PSV_PMC_SHA */
#define XPAR_PSV_PMC_SHA_0_BASEADDR 0xf1210000
#define XPAR_PSV_PMC_SHA_0_HIGHADDR 0xf121ffff

/* Definitions for peripheral PSV_R5_0_ATCM_GLOBAL */
#define XPAR_PSV_R5_0_ATCM_GLOBAL_BASEADDR 0xffe00000
#define XPAR_PSV_R5_0_ATCM_GLOBAL_HIGHADDR 0xffe0ffff

/* Canonical definitions for peripheral PSV_R5_0_ATCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_0_BASEADDR 0xffe00000
#define XPAR_PSV_TCM_GLOBAL_0_HIGHADDR 0xffe0ffff

/* Definitions for peripheral PSV_R5_0_BTCM_GLOBAL */
#define XPAR_PSV_R5_0_BTCM_GLOBAL_BASEADDR 0xffe20000
#define XPAR_PSV_R5_0_BTCM_GLOBAL_HIGHADDR 0xffe2ffff

/* Canonical definitions for peripheral PSV_R5_0_BTCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_1_BASEADDR 0xffe20000
#define XPAR_PSV_TCM_GLOBAL_1_HIGHADDR 0xffe2ffff

/* Definitions for peripheral PSV_R5_1_ATCM_GLOBAL */
#define XPAR_PSV_R5_1_ATCM_GLOBAL_BASEADDR 0xffe90000
#define XPAR_PSV_R5_1_ATCM_GLOBAL_HIGHADDR 0xffe9ffff

/* Canonical definitions for peripheral PSV_R5_1_ATCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_2_BASEADDR 0xffe90000
#define XPAR_PSV_TCM_GLOBAL_2_HIGHADDR 0xffe9ffff

/* Definitions for peripheral PSV_R5_1_BTCM_GLOBAL */
#define XPAR_PSV_R5_1_BTCM_GLOBAL_BASEADDR 0xffeb0000
#define XPAR_PSV_R5_1_BTCM_GLOBAL_HIGHADDR 0xffebffff

/* Canonical definitions for peripheral PSV_R5_1_BTCM_GLOBAL */
#define XPAR_PSV_TCM_GLOBAL_3_BASEADDR 0xffeb0000
#define XPAR_PSV_TCM_GLOBAL_3_HIGHADDR 0xffebffff

/* Definitions for peripheral LPD_XPPU */
#define XPAR_LPD_XPPU_BASEADDR 0xff990000
#define XPAR_LPD_XPPU_HIGHADDR 0xff991fff

/* Canonical definitions for peripheral LPD_XPPU */
#define XPAR_PSV_LPD_XPPU_0_BASEADDR 0xff990000
#define XPAR_PSV_LPD_XPPU_0_HIGHADDR 0xff991fff

/* Definitions for peripheral PMC_XPPU */
#define XPAR_PMC_XPPU_BASEADDR 0xf1310000
#define XPAR_PMC_XPPU_HIGHADDR 0xf1311fff

/* Canonical definitions for peripheral PMC_XPPU */
#define XPAR_PSV_PMC_XPPU_0_BASEADDR 0xf1310000
#define XPAR_PSV_PMC_XPPU_0_HIGHADDR 0xf1311fff

/* Definitions for peripheral PMC_XPPU_NPI */
#define XPAR_PMC_XPPU_NPI_BASEADDR 0xf1300000
#define XPAR_PMC_XPPU_NPI_HIGHADDR 0xf1301fff

/* Canonical definitions for peripheral PMC_XPPU_NPI */
#define XPAR_PSV_PMC_XPPU_NPI_0_BASEADDR 0xf1300000
#define XPAR_PSV_PMC_XPPU_NPI_0_HIGHADDR 0xf1301fff

/* Definitions for peripheral FPD_XMPU */
#define XPAR_FPD_XMPU_BASEADDR 0xfd390000
#define XPAR_FPD_XMPU_HIGHADDR 0xfd390fff

/* Canonical definitions for peripheral FPD_XMPU */
#define XPAR_PSV_FPD_SLAVE_XMPU_0_BASEADDR 0xfd390000
#define XPAR_PSV_FPD_SLAVE_XMPU_0_HIGHADDR 0xfd390fff

/* Definitions for peripheral PMC_XMPU */
#define XPAR_PMC_XMPU_BASEADDR 0xf12f0000
#define XPAR_PMC_XMPU_HIGHADDR 0xf12f0fff

/* Canonical definitions for peripheral PMC_XMPU */
#define XPAR_PSV_PMC_XMPU_0_BASEADDR 0xf12f0000
#define XPAR_PSV_PMC_XMPU_0_HIGHADDR 0xf12f0fff

/* Definitions for peripheral OCM_XMPU */
#define XPAR_OCM_XMPU_BASEADDR 0xff980000
#define XPAR_OCM_XMPU_HIGHADDR 0xff980fff

/* Canonical definitions for peripheral OCM_XMPU */
#define XPAR_PSV_OCM_XMPU_0_BASEADDR 0xff980000
#define XPAR_PSV_OCM_XMPU_0_HIGHADDR 0xff980fff

/*  BOARD definition */
#define XPS_BOARD_VRK160

#define XPAR_AXI_NOC2_DDR_LOW_0_BASEADDR 0x40000
#define XPAR_AXI_NOC2_DDR_LOW_0_HIGHADDR 0x8003ffff
#define XPAR_PSV_OCM_0_BASEADDRESS 0xfffc0000
#define XPAR_PSV_OCM_0_HIGHADDRESS 0xffffffff
#define XPAR_AXI_BRAM_0_BASEADDRESS 0xa4000000
#define XPAR_AXI_BRAM_0_HIGHADDRESS 0xa4001fff
#define XPAR_CPU_CORE_CLOCK_FREQ_HZ 800000000

#define XPAR_CPU_TIMESTAMP_CLK_FREQ 0
#define XPAR_PSU_PSS_REF_CLK_FREQ_HZ 33333000

/* Number of SLRs */
#define NUMBER_OF_SLRS 0x1

/* Device ID */
#define XPAR_DEVICE_ID "xcvr1602"

#endif  /* end of protection macro */