/*******************************************************************************
* Copyright 2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/

/*****************************************************************************/
/**
 *
 * @file xmmidp_hw.h
 *
 * @note	None.
 *
 * <pre>
 * MODIFICATION HISTORY:
 *
 * Ver	Who   Date     Changes
 * ---- ----- -------- ----------------------------------------------------
 * 1.0  ck   03/14/25  Initial Release.
 * </pre>
 *
 *****************************************************************************/

#ifndef XMMIDP_HW_H_
/* Prevent circular inclusions by using protection macros. */
#define XMMIDP_HW_H_

#ifdef __cplusplus
extern "C" {
#endif
/***************************** Include Files **********************************/
#include "xil_io.h"
#include "xil_types.h"

/************************** Constant Definitions ******************************/
#define XXMMIDP_BASEADDR    0xEDE00000

#define XMMIDP_STREAM_ID1   1
#define XMMIDP_STREAM_ID2   2
#define XMMIDP_STREAM_ID3   3
#define XMMIDP_STREAM_ID4   4

#define XMMIDP_LANE_0_CR_DONE         0x0
#define XMMIDP_LANE_1_CR_DONE         0x1
#define XMMIDP_LANE_2_CR_DONE         0x2
#define XMMIDP_LANE_3_CR_DONE         0x3
#define XMMIDP_LANE_ALL_CR_DONE       0x4

#define XMMIDP_MAX_VS_LEVEL		0x3
#define XMMIDP_MAX_PE_LEVEL		0x3

/* Core Control */
#define XMMIDP_CCTL0				0x200

#define XMMIDP_CCTL0_ENHANCE_FRAME_WITH_FEC_EN_SHIFT	29
#define XMMIDP_CCTL0_ENHANCE_FRAME_WITH_FEC_EN_WIDTH	1
#define XMMIDP_CCTL0_ENHANCE_FRAME_WITH_FEC_EN_MASK	0x20000000

#define XMMIDP_CCTL0_INITIATE_MST_ACT_SEQ_SHIFT	28
#define XMMIDP_CCTL0_INITIATE_MST_ACT_SEQ_WIDTH	1
#define XMMIDP_CCTL0_INITIATE_MST_ACT_SEQ_MASK	0x10000000

#define XMMIDP_CCTL0_ENABLE_EDP_SHIFT		27
#define XMMIDP_CCTL0_ENABLE_EDP_WIDTH		1
#define XMMIDP_CCTL0_ENABLE_EDP_MASK		0x08000000

#define XMMIDP_CCTL0_ENABLE_FEC_SHIFT 	26
#define XMMIDP_CCTL0_ENABLE_FEC_WIDTH		1
#define XMMIDP_CCTL0_ENABLE_FEC_MASK		0x04000000

#define XMMIDP_CCTL0_ENABLE_MST_MODE_SHIFT	25
#define XMMIDP_CCTL0_ENABLE_MST_MODE_WIDTH	1
#define XMMIDP_CCTL0_ENABLE_MST_MODE_MASK	0x02000000

#define XMMIDP_CCTL0_BS_512_SCALE_DOWN_SHIFT	17
#define XMMIDP_CCTL0_BS_512_SCALE_DOWN_WIDTH	8
#define XMMIDP_CCTL0_BS_512_SCALE_DOWN_MASK	0x01FE0000

#define XMMIDP_CCTL0_SR_SCALE_DOWN_SHIFT	16
#define XMMIDP_CCTL0_SR_SCALE_DOWN_WIDTH	1
#define XMMIDP_CCTL0_SR_SCALE_DOWN_MASK	0x00010000

#define XMMIDP_CCTL0_DEBUG_CONTROL_SHIFT	8
#define XMMIDP_CCTL0_DEBUG_CONTROL_WIDTH	4
#define XMMIDP_CCTL0_DEBUG_CONTROL_MASK	0x00000F00

#define XMMIDP_CCTL0_SEL_AUX_TIMEOUT_32MS_SHIFT	6
#define XMMIDP_CCTL0_SEL_AUX_TIMEOUT_32MS_WIDTH	1
#define XMMIDP_CCTL0_SEL_AUX_TIMEOUT_32MS_MASK	0x00000040

#define XMMIDP_CCTL0_DISABLING_INTERLEAVING_SHIFT	5
#define XMMIDP_CCTL0_DISABLING_INTERLEAVING_WIDTH	1
#define XMMIDP_CCTL0_DISABLING_INTERLEAVING_MASK	0x00000020

#define XMMIDP_CCTL0_FORCE_HPD_SHIFT		4
#define XMMIDP_CCTL0_FORCE_HPD_WIDTH		1
#define XMMIDP_CCTL0_FORCE_HPD_MASK		0x00000010

#define XMMIDP_CCTL0_SCALE_DOWN_MODE_SHIFT		3
#define XMMIDP_CCTL0_SCALE_DOWN_MODE_WIDTH		1
#define XMMIDP_CCTL0_SCALE_DOWN_MODE_MASK		0x00000008

#define XMMIDP_CCTL0_DEFAULT_FAST_LINK_TRAIN_EN_SHIFT		2
#define XMMIDP_CCTL0_DEFAULT_FAST_LINK_TRAIN_EN_WIDTH		1
#define XMMIDP_CCTL0_DEFAULT_FAST_LINK_TRAIN_EN_MASK		0x00000004

#define XMMIDP_CCTL0_ENHANCE_FRAMING_EN_SHIFT		1
#define XMMIDP_CCTL0_ENHANCE_FRAMING_EN_WIDTH		1
#define XMMIDP_CCTL0_ENHANCE_FRAMING_EN_MASK		0x00000002

#define XMMIDP_CCTL0_SCRAMBLE_DIS_SHIFT	0
#define XMMIDP_CCTL0_SCRAMBLE_DIS_WIDTH	1
#define XMMIDP_CCTL0_SCRAMBLE_DIS_MASK	0x00000001

/* Soft Reset Ctrl */
#define XMMIDP_SFT_RST_CTRL0		0x204

#define XMMIDP_SFT_RST_CTRL0_AUX_CDR_CLK_CYCLE_SHIFT	24
#define XMMIDP_SFT_RST_CTRL0_AUX_CDR_CLK_CYCLE_WIDTH	4
#define XMMIDP_SFT_RST_CTRL0_AUX_CDR_CLK_CYCLE_MASK	0x0F000000

#define XMMIDP_SFT_RST_CTRL0_AUX_CDR_SHIFT	16
#define XMMIDP_SFT_RST_CTRL0_AUX_CDR_WIDTH	4
#define XMMIDP_SFT_RST_CTRL0_AUX_CDR_MASK	0x000F0000

#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM3_SHIFT	11
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM3_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM3_MASK	0x00000800

#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM2_SHIFT	10
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM2_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM2_MASK	0x00000400

#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM1_SHIFT	9
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM1_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_STREAM1_MASK	0x00000200

#define XMMIDP_SFT_RST_CTRL0_VID_RST_SHIFT	5
#define XMMIDP_SFT_RST_CTRL0_VID_RST_WIDTH	3
#define XMMIDP_SFT_RST_CTRL0_VID_RST_MASK	0x000001E0

#define XMMIDP_SFT_RST_CTRL0_AUX_RST_SHIFT	4
#define XMMIDP_SFT_RST_CTRL0_AUX_RST_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_AUX_RST_MASK	0x00000010

#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_SHIFT	3
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_AUD_SMPLR_RST_MASK	0x00000008

#define XMMIDP_SFT_RST_CTRL0_HDCP_MODULE_RST_SHIFT	2
#define XMMIDP_SFT_RST_CTRL0_HDCP_MODULE_RST_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_HDCP_MODULE_RST_MASK	0x00000040

#define XMMIDP_SFT_RST_CTRL0_PHY_SFT_RST_SHIFT	1
#define XMMIDP_SFT_RST_CTRL0_PHY_SFT_RST_WIDTH	1
#define XMMIDP_SFT_RST_CTRL0_PHY_SFT_RST_MASK		0x00000002

#define XMMIDP_SFT_RST_CTRL0_CNTRLR_RST_SHIFT		0
#define XMMIDP_SFT_RST_CTRL0_CNTRLR_RST_WIDTH		1
#define XMMIDP_SFT_RST_CTRL0_CNTRLR_RST_MASK		0x00000001

/** AUX Channel Configuration registers **/
#define XMMIDP_AUX_CMD0				0x00B00

#define XMMIDP_AUX_CMD_AUX_CMD_TYPE_SHIFT		0x001C
#define XMMIDP_AUX_CMD_AUX_CMD_TYPE_WIDTH		0x0004
#define XMMIDP_AUX_CMD_AUX_CMD_TYPE_MASK		0x0000F000

#define XMMIDP_AUX_CMD_NATIVE_WRITE			0x8
#define XMMIDP_AUX_CMD_NATIVE_READ			0x9
#define XMMIDP_AUX_CMD_I2C_MOT_WRITE			0x4
#define XMMIDP_AUX_CMD_I2C_MOT_READ			0x5
#define XMMIDP_AUX_CMD_I2C_WRITE			0x0
#define XMMIDP_AUX_CMD_I2C_READ			0x1
#define XMMIDP_AUX_CMD_I2C_WRITE_ST_UPD		0x2
#define XMMIDP_AUX_CMD_MOT_WRITE_ST_UPD		0x6

#define XMMIDP_AUX_CMD_AUX_ADDR_SHIFT			0x8
#define XMMIDP_AUX_CMD_AUX_ADDR_WIDTH			0x14
#define XMMIDP_AUX_CMD_AUX_ADDR_MASK			0x0FFFFF00

#define XMMIDP_AUX_CMD_AUX_PHY_WAKE_SHIFT		0x5
#define XMMIDP_AUX_CMD_AUX_PHY_WAKE_WIDTH		0x1
#define XMMIDP_AUX_CMD_AUX_PHY_WAKE_MASK		0x00000020

#define XMMIDP_AUX_CMD_I2C_ADDR_ONLY_SHIFT		0x0004
#define XMMIDP_AUX_CMD_I2C_ADDR_ONLY_WIDTH		0x0001
#define XMMIDP_AUX_CMD_I2C_ADDR_ONLY_MASK		0x00000010

#define XMMIDP_AUX_CMD_LEN_REQ_SHIFT			0x0000
#define XMMIDP_AUX_CMD_LEN_REQ_WIDTH			0x0004
#define XMMIDP_AUX_CMD_LEN_REQ_MASK			0x0000000F

/** AUX request reply */
#define XMMIDP_AUX_STATUS0			0x00B04
#define XMMIDP_AUX_STATUS_MASK		0x000000FF
#define	XMMIDP_AUX_STATUS_ACK			0x0
#define	XMMIDP_AUX_STATUS_AUX_NACK		0x1
#define	XMMIDP_AUX_STATUS_AUX_DEFER		0x2
#define	XMMIDP_AUX_STATUS_I2C_NACK		0x4
#define	XMMIDP_AUX_STATUS_I2C_DEFER		0x8

#define XMMIDP_AUX_M_MASK			0x0000FF00

#define XMMIDP_AUX_REPLY_RECEIVED_SHIFT	16
#define XMMIDP_AUX_REPLY_RECEIVED_MASK	0x00010000

#define XMMIDP_AUX_REPLY_ACTIVE_TRANSFER	0x1
#define XMMIDP_AUX_REPLY_RECEIVED		0x0

#define XMMIDP_AUX_TIMEOUT_MASK		0x00020000
#define XMMIDP_AUX_TIMEOUT			0x1

#define XMMIDP_AUX_REPLY_ERR_SHIFT		18
#define XMMIDP_AUX_REPLY_ERR_MASK		0x00040000
#define XMMIDP_AUX_REPLY_ERR			0x1

#define XMMIDP_AUX_BYTES_READ_SHIFT		19
#define XMMIDP_AUX_BYTES_READ_WIDTH		5
#define XMMIDP_AUX_BYTES_READ_MASK		0x00F80000

#define XMMIDP_SINK_DISCONNECT_WHILE_ACTIVE_MASK	0x01000000
#define XMMIDP_SINK_DISCONNECT_WHILE_ACTIVE		0x1

#define XMMIDP_AUX_DATA0_0			0x00B08
#define XMMIDP_AUX_DATA1_0			0x00B0C
#define XMMIDP_AUX_DATA2_0			0x00B10
#define XMMIDP_AUX_DATA3_0			0x00B14

#define XMMIDP_AUX_CONFIG1_0			0x00B20
#define XMMIDP_AUX_CONFIG2_0			0x00B24

#define XMMIDP_AUX_250US_CNT_LIMIT_0		0x00B40
#define XMMIDP_AUX_2000US_CNT_LIMIT_0		0x00B44
#define XMMIDP_AUX_100000US_CNT_LIMIT_0		0x00B48

#define XMMIDP_PM_CONFIG1			0x00350
#define XMMIDP_PM_CONFIG2			0x00354

/** General Interrupt */
#define XMMIDP_GEN_INT0		0x00D00

#define XMMIDP_GEN_INT0_PM_EVENT_SHIFT	31
#define XMMIDP_GEN_INT0_PM_EVENT_WIDTH	1
#define XMMIDP_GEN_INT0_PM_EVENT_MASK		0x80000000

#define XMMIDP_GEN_INT0_DSC_EVENT_SHIFT	30
#define XMMIDP_GEN_INT0_DSC_EVENT_WIDTH	1
#define XMMIDP_GEN_INT0_DSC_EVENT_MASK	0x40000000

#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM3_SHIFT	27
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM3_WIDTH	1
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM3_MASK		0x08000000

#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM3_SHIFT		26
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM3_WIDTH		1
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM3_MASK		0x04000000

#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM3_SHIFT		25
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM3_WIDTH		1
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM3_MASK		0x02000000

#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM3_SHIFT		24
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM3_WIDTH		1
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM3_MASK		0x01000000

#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM2_SHIFT	21
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM2_WIDTH	1
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM2_MASK		0x00200000

#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM2_SHIFT		20
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM2_WIDTH		1
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM2_MASK		0x00100000

#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM2_SHIFT		19
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM2_WIDTH		1
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM2_MASK		0x00080000

#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM2_SHIFT		18
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM2_WIDTH		1
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM2_MASK		0x00040000

#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM1_SHIFT	15
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM1_WIDTH	1
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM1_MASK		0x00008000

#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM1_SHIFT		14
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM1_WIDTH		1
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM1_MASK		0x00004000

#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM1_SHIFT		13
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM1_WIDTH		1
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM1_MASK		0x00002000

#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM1_SHIFT		12
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM1_WIDTH		1
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM1_MASK		0x00001000

#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM0_SHIFT	8
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM0_WIDTH	1
#define XMMIDP_GEN_INT0_VID_FIFO_UNDRFLW_STREAM0_MASK		0x00000100

#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM0_SHIFT		6
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM0_WIDTH		1
#define XMMIDP_GEN_INT0_VID_FIFO_OVRFLW_STREAM0_MASK		0x00000040

#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM0_SHIFT		5
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM0_WIDTH		1
#define XMMIDP_GEN_INT0_AUD_FIFO_OVRFLW_STREAM0_MASK		0x00000020

#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM0_SHIFT		4
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM0_WIDTH		1
#define XMMIDP_GEN_INT0_SDP_EVENT_STREAM0_MASK		0x00000010

#define XMMIDP_GEN_INT0_AUX_CMD_INVALID_SHIFT		3
#define XMMIDP_GEN_INT0_AUX_CMD_INVALID_WIDTH		1
#define XMMIDP_GEN_INT0_AUX_CMD_INVALID_MASK		0x00000008

#define XMMIDP_GEN_INT0_HDCP_EVENT_SHIFT		2
#define XMMIDP_GEN_INT0_HDCP_EVENT_WIDTH		1
#define XMMIDP_GEN_INT0_HDCP_EVENT_MASK		0x00000004

#define XMMIDP_GEN_INT0_AUX_REPLY_EVENT_SHIFT		1
#define XMMIDP_GEN_INT0_AUX_REPLY_EVENT_WIDTH		1
#define XMMIDP_GEN_INT0_AUX_REPLY_EVENT_MASK		0x00000002

#define XMMIDP_GEN_INT0_HPD_EVENT_SHIFT			0
#define XMMIDP_GEN_INT0_HPD_EVENT_WIDTH			1
#define XMMIDP_GEN_INT0_HPD_EVENT_MASK			0x00000001

/** General Interrupt Enable*/
#define XMMIDP_GEN_INT_ENABLE0	0x0D04

#define XMMIDP_GEN_INT_PM_EVENT_EN_SHIFT			31
#define XMMIDP_GEN_INT_PM_EVENT_EN_WIDTH			1
#define XMMIDP_GEN_INT_PM_EVENT_EN_MASK			0x80000000

#define XMMIDP_GEN_INT_DSC_EVENT_EN_SHIFT			30
#define XMMIDP_GEN_INT_DSC_EVENT_EN_WIDTH			1
#define XMMIDP_GEN_INT_DSC_EVENT_EN_MASK			0x40000000

#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM3_EN_SHIFT	27
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM3_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM3_EN_MASK	0x08000000

#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM3_EN_SHIFT	26
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM3_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM3_EN_MASK	0x04000000

#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM3_EN_SHIFT	25
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM3_EN_WIDTH	1
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM3_EN_MASK	0x02000000

#define XMMIDP_GEN_INT_SDP_EVENT_STREAM3_EN_SHIFT		24
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM3_EN_WIDTH		1
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM3_EN_MASK		0x01000000

#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM2_EN_SHIFT	21
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM2_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM2_EN_MASK	0x00200000

#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM2_EN_SHIFT	20
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM2_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM2_EN_MASK	0x00100000

#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM2_EN_SHIFT	19
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM2_EN_WIDTH	1
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM2_EN_MASK	0x00080000

#define XMMIDP_GEN_INT_SDP_EVENT_STREAM2_EN_SHIFT		18
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM2_EN_WIDTH		1
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM2_EN_MASK		0x00040000

#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM1_EN_SHIFT	15
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM1_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM1_EN_MASK	0x00008000

#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM1_EN_SHIFT	14
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM1_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM1_EN_MASK	0x00004000

#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM1_EN_SHIFT	13
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM1_EN_WIDTH	1
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM1_EN_MASK	0x00002000

#define XMMIDP_GEN_INT_SDP_EVENT_STREAM1_EN_SHIFT		12
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM1_EN_WIDTH		1
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM1_EN_MASK		0x00001000

#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM0_EN_SHIFT	8
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM0_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_UNDRFLW_STREAM0_EN_MASK	0x00000100

#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM0_EN_SHIFT	6
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM0_EN_WIDTH	1
#define XMMIDP_GEN_INT_VID_FIFO_OVRFLW_STREAM0_EN_MASK	0x00000040

#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM0_EN_SHIFT	5
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM0_EN_WIDTH	1
#define XMMIDP_GEN_INT_AUD_FIFO_OVRFLW_STREAM0_EN_MASK	0x00000020

#define XMMIDP_GEN_INT_SDP_EVENT_STREAM0_EN_SHIFT		4
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM0_EN_WIDTH		1
#define XMMIDP_GEN_INT_SDP_EVENT_STREAM0_EN_MASK		0x00000010

#define XMMIDP_GEN_INT_AUX_CMD_INVALID_EN_SHIFT		3
#define XMMIDP_GEN_INT_AUX_CMD_INVALID_EN_WIDTH		1
#define XMMIDP_GEN_INT_AUX_CMD_INVALID_EN_MASK		0x00000008

#define XMMIDP_GEN_INT_HDCP_EVENT_EN_SHIFT			2
#define XMMIDP_GEN_INT_HDCP_EVENT_EN_WIDTH			1
#define XMMIDP_GEN_INT_HDCP_EVENT_EN_MASK			0x00000004

#define XMMIDP_GEN_INT_AUX_REPLY_EVENT_EN_SHIFT		1
#define XMMIDP_GEN_INT_AUX_REPLY_EVENT_EN_WIDTH		1
#define XMMIDP_GEN_INT_AUX_REPLY_EVENT_EN_MASK		0x00000002

#define XMMIDP_GEN_INT_HPD_EVENT_EN_SHIFT			0
#define XMMIDP_GEN_INT_HPD_EVENT_EN_WIDTH			1
#define XMMIDP_GEN_INT_HPD_EVENT_EN_MASK			0x00000001

/* HPD_STATUS */
#define XMMIDP_HPD_STATUS0				0xD08

#define XMMIDP_HPD_STATUS0_TIMER_SHIFT		15
#define XMMIDP_HPD_STATUS0_TIMER_WIDTH		17
#define XMMIDP_HPD_STATUS0_TIMER_MASK			0xFFFF8000

#define XMMIDP_HPD_STATUS0_STATE_SHIFT		9
#define XMMIDP_HPD_STATUS0_STATE_WIDTH		3
#define XMMIDP_HPD_STATUS0_STATE_MASK			0x00000E00

#define XMMIDP_HPD_STATUS0_NOT_CON			0x0
#define XMMIDP_HPD_STATUS0_CONNECTED			0x1

#define XMMIDP_HPD_STATUS0_STATUS_SHIFT		8
#define XMMIDP_HPD_STATUS0_STATUS_WIDTH		1
#define XMMIDP_HPD_STATUS0_STATUS_MASK		0x00000100

#define XMMIDP_HPD_STATUS0_UNPLUG_ERR_SHIFT		3
#define XMMIDP_HPD_STATUS0_UNPLUG_ERR_WIDTH		1
#define XMMIDP_HPD_STATUS0_UNPLUG_ERR_MASK		0x00000008

#define XMMIDP_HPD_STATUS0_HOT_UNPLUG_SHIFT		2
#define XMMIDP_HPD_STATUS0_HOT_UNPLUG_WIDTH		1
#define XMMIDP_HPD_STATUS0_HOT_UNPLUG_MASK		0x00000004

#define XMMIDP_HPD_STATUS0_HOT_PLUG_SHIFT		1
#define XMMIDP_HPD_STATUS0_HOT_PLUG_WIDTH		1
#define XMMIDP_HPD_STATUS0_HOT_PLUG_MASK		0x00000002

#define XMMIDP_HPD_STATUS0_HPD_IRQ_SHIFT		0
#define XMMIDP_HPD_STATUS0_HPD_IRQ_WIDTH		1
#define XMMIDP_HPD_STATUS0_HPD_IRQ_MASK		0x00000001

/* HPD INTERRUPT ENABLE */
#define XMMIDP_HPD_INTERRUPT_ENABLE			0xD0C

#define XMMIDP_HPD_UNPLUG_ERR_EN_SHIFT		3
#define XMMIDP_HPD_UNPLUG_ERR_EN_WIDTH		1
#define XMMIDP_HPD_UNPLUG_ERR_EN_MASK			0x00000008

#define XMMIDP_HPD_UNPLUG_EN_SHIFT			2
#define XMMIDP_HPD_UNPLUG_EN_WIDTH			1
#define XMMIDP_HPD_UNPLUG_EN_MASK			0x00000004

#define XMMIDP_HPD_PLUG_EN_SHIFT			1
#define XMMIDP_HPD_PLUG_EN_WIDTH			1
#define XMMIDP_HPD_PLUG_EN_MASK			0x00000002

#define XMMIDP_HPD_IRQ_EN_SHIFT			0
#define XMMIDP_HPD_IRQ_EN_WIDTH			1
#define XMMIDP_HPD_IRQ_EN_MASK			0x000000001

/* PHYIF Control Register */
#define XMMIDP_PHYIF_CTRL_0				0xA00

#define XMMIDP_PHYIF_CTRL_0_EDP_PHY_RATE_SHIFT	26
#define XMMIDP_PHYIF_CTRL_0_EDP_PHY_RATE_WIDTH	2
#define XMMIDP_PHYIF_CTRL_0_EDP_PHY_RATE_MASK		0x1C000000

#define XMMIDP_PHYIF_CTRL_0_PHY_WIDTH_SHIFT		25
#define XMMIDP_PHYIF_CTRL_0_PHY_WIDTH_WIDTH		1
#define XMMIDP_PHYIF_CTRL_0_PHY_WIDTH_MASK		0x02000000

#define XMMIDP_PHYIF_CTRL_0_PHY_POWERDOWN_SHIFT	17
#define XMMIDP_PHYIF_CTRL_0_PHY_POWERDOWN_WIDTH	4
#define XMMIDP_PHYIF_CTRL_0_PHY_POWERDOWN_MASK	0x001E0000

#define XMMIDP_PHYIF_CTRL_0_SSC_DIS_SHIFT		16
#define XMMIDP_PHYIF_CTRL_0_SSC_DIS_WIDTH		1
#define XMMIDP_PHYIF_CTRL_0_SSC_DIS_MASK		0x00010000

#define XMMIDP_PHYIF_CTRL_0_PHY_BUSY_SHIFT		12
#define XMMIDP_PHYIF_CTRL_0_PHY_BUSY_WIDTH		4
#define XMMIDP_PHYIF_CTRL_0_PHY_BUSY_MASK		0x0000F000

#define XMMIDP_PHYIF_CTRL_0_XMIT_ENABLE_SHIFT		8
#define XMMIDP_PHYIF_CTRL_0_XMIT_ENABLE_WIDTH		4
#define XMMIDP_PHYIF_CTRL_0_XMIT_ENABLE_MASK		0x00000F00

#define XMMIDP_PHYIF_CTRL_0_PHY_LANES_SHIFT		6
#define XMMIDP_PHYIF_CTRL_0_PHY_LANES_WIDTH		2
#define XMMIDP_PHYIF_CTRL_0_PHY_LANES_MASK		0x000000C0

#define XMMIDP_PHYIF_CTRL_0_PHY_RATE_SHIFT		4
#define XMMIDP_PHYIF_CTRL_0_PHY_RATE_WIDTH		2
#define XMMIDP_PHYIF_CTRL_0_PHY_RATE_MASK		0x00000030

#define XMMIDP_PHYIF_CTRL_0_TPS_SEL_SHIFT		0
#define XMMIDP_PHYIF_CTRL_0_TPS_SEL_WIDTH		4
#define XMMIDP_PHYIF_CTRL_0_TPS_SEL_MASK		0x0000000F

#define XMMIDP_PHYIF_CTRL_NO_TRAIN			0x0
#define XMMIDP_PHYIF_CTRL_TPS1			0x1
#define XMMIDP_PHYIF_CTRL_TPS2			0x2
#define XMMIDP_PHYIF_CTRL_TPS3			0x3
#define XMMIDP_PHYIF_CTRL_TPS4			0x4
#define XMMIDP_PHYIF_CTRL_SYMBOL_ERR_RATE		0x5
#define XMMIDP_PHYIF_CTRL_PRBS7			0x6
#define XMMIDP_PHYIF_CTRL_CUSTOMPAT			0x7
#define XMMIDP_PHYIF_CTRL_CP1510_PAT_1		0x8
#define XMMIDP_PHYIF_CTRL_CP1510_PAT_2		0x9

/* PHYIF Control Register */
#define XMMIDP_PHY_TX_EQ				0x00A04

#define XMMIDP_PHY_TX_EQ_LANE3_TX_VSWING_SHIFT	20
#define XMMIDP_PHY_TX_EQ_LANE3_TX_VSWING_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE3_TX_VSWING_MASK		0x00300000

#define XMMIDP_PHY_TX_EQ_VSWING_LEVEL0		0x0
#define XMMIDP_PHY_TX_EQ_VSWING_LEVEL1		0x1
#define XMMIDP_PHY_TX_EQ_VSWING_LEVEL2		0x2
#define XMMIDP_PHY_TX_EQ_VSWING_LEVEL3		0x3

#define XMMIDP_PHY_TX_EQ_LANE3_TX_PREEMP_SHIFT	18
#define XMMIDP_PHY_TX_EQ_LANE3_TX_PREEMP_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE3_TX_PREEMP_MASK		0x000C0000

#define XMMIDP_PHY_TX_EQ_PREEMP_LEVEL0		0x0
#define XMMIDP_PHY_TX_EQ_PREEMP_LEVEL1		0x1
#define XMMIDP_PHY_TX_EQ_PREEMP_LEVEL2		0x2
#define XMMIDP_PHY_TX_EQ_PREEMP_LEVEL3		0x3

#define XMMIDP_PHY_TX_EQ_LANE2_TX_VSWING_SHIFT	14
#define XMMIDP_PHY_TX_EQ_LANE2_TX_VSWING_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE2_TX_VSWING_MASK		0x0000C000

#define XMMIDP_PHY_TX_EQ_LANE2_TX_PREEMP_SHIFT	12
#define XMMIDP_PHY_TX_EQ_LANE2_TX_PREEMP_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE2_TX_PREEMP_MASK		0x00003000

#define XMMIDP_PHY_TX_EQ_LANE1_TX_VSWING_SHIFT	8
#define XMMIDP_PHY_TX_EQ_LANE1_TX_VSWING_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE1_TX_VSWING_MASK		0x00000300

#define XMMIDP_PHY_TX_EQ_LANE1_TX_PREEMP_SHIFT	6
#define XMMIDP_PHY_TX_EQ_LANE1_TX_PREEMP_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE1_TX_PREEMP_MASK		0x000000C0

#define XMMIDP_PHY_TX_EQ_LANE0_TX_VSWING_SHIFT	2
#define XMMIDP_PHY_TX_EQ_LANE0_TX_VSWING_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE0_TX_VSWING_MASK		0x0000000C

#define XMMIDP_PHY_TX_EQ_LANE0_TX_PREEMP_SHIFT	0
#define XMMIDP_PHY_TX_EQ_LANE0_TX_PREEMP_WIDTH	2
#define XMMIDP_PHY_TX_EQ_LANE0_TX_PREEMP_MASK		0x00000003

/* CUSTOMPAT0 Register */
#define XMMIDP_CUSTOMPAT0				0x00A08

#define XMMIDP_CUSTOM80B_0_SHIFT			0
#define XMMIDP_CUSTOM80B_0_WIDTH			30
#define XMMIDP_CUSTOM80B_0_MASK			0x3FFFFFFF

#define XMMIDP_CUSTOMPAT1				0x00A0C

#define XMMIDP_CUSTOM80B_1_SHIFT			0
#define XMMIDP_CUSTOM80B_1_WIDTH			30
#define XMMIDP_CUSTOM80B_1_MASK			0x3FFFFFFF

#define XMMIDP_CUSTOMPAT2				0x00A0C

#define XMMIDP_CUSTOM80B_2_SHIFT			0
#define XMMIDP_CUSTOM80B_2_WIDTH			20
#define XMMIDP_CUSTOM80B_2_MASK			0x000FFFFF

/* HBR COMPLIANCE SCRAMBLER RESET */
#define HBR2_COMPLIANCE_SCRAMBLER_RESET0		0x00A14

#define XMMIDP_HBR2_COMPLIANCE_NUM_SR_ZEROS_SHIFT	0
#define XMMIDP_HBR2_COMPLIANCE_NUM_SR_ZEROS_WIDTH	16
#define XMMIDP_HBR2_COMPLIANCE_NUM_SR_ZEROS_MASK	0x0000FFFF

/* PHYIF_PWRDOWN_CTRL0 */
#define XMMIDP_PHYIF_PWRDOWN_CTRL0			0x00A18

#define XMMIDP_PHYIF_PWRDOWN_CTRL0_PER_LANE_CTL_EN_SHIFT	16
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_PER_LANE_CTL_EN_WIDTH	1
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_PER_LANE_CTL_EN_MASK	0x00010000

#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE3_SHIFT		12
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE3_WIDTH		4
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE3_MASK			0x0000F000

#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE2_SHIFT		8
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE2_WIDTH		4
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE2_MASK			0x00000F00

#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE1_SHIFT		4
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE1_WIDTH		4
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE1_MASK			0x000000F0

#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE0_SHIFT		0
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE0_WIDTH		4
#define XMMIDP_PHYIF_PWRDOWN_CTRL0_LANE0_MASK			0x0000000F

/** Video Configuration register **/
#define XMMIDP_VIDEO_CONFIG1				0x00310

#define XMMIDP_VIDEO_CONFIG1_HACTIVE_SHIFT		16
#define XMMIDP_VIDEO_CONFIG1_HACTIVE_WIDTH		16
#define XMMIDP_VIDEO_CONFIG1_HACTIVE_MASK		0xFFFF0000

#define XMMIDP_VIDEO_CONFIG1_HBLANK_SHIFT		2
#define XMMIDP_VIDEO_CONFIG1_HBLANK_WIDTH		14
#define XMMIDP_VIDEO_CONFIG1_HBLANK_MASK		0x0000FFFC

#define XMMIDP_VIDEO_CONFIG1_I_P_SHIFT		1
#define XMMIDP_VIDEO_CONFIG1_I_P_WIDTH		1
#define XMMIDP_VIDEO_CONFIG1_I_P_MASK			0x00000002

#define XMMIDP_VIDEO_CONFIG1_RV_BLANK_IN_OSC_SHIFT	1
#define XMMIDP_VIDEO_CONFIG1_RV_BLANK_IN_OSC_WIDTH	1
#define XMMIDP_VIDEO_CONFIG1_RV_BLANK_IN_OSC_MASK	0x00000002

#define XMMIDP_VIDEO_CONFIG2				0x00314

#define XMMIDP_VIDEO_CONFIG2_VBLANK_SHIFT		16
#define XMMIDP_VIDEO_CONFIG2_VBLANK_WIDTH		16
#define XMMIDP_VIDEO_CONFIG2_VBLANK_MASK		0xFFFF0000

#define XMMIDP_VIDEO_CONFIG2_HACTIVE_SHIFT		0
#define XMMIDP_VIDEO_CONFIG2_HACTIVE_WIDTH		16
#define XMMIDP_VIDEO_CONFIG2_HACTIVE_MASK		0x0000FFFF

#define XMMIDP_VIDEO_CONFIG3				0x00318

#define XMMIDP_VIDEO_CONFIG3_HSYNC_WIDTH_SHIFT	16
#define XMMIDP_VIDEO_CONFIG3_HSYNC_WIDTH_WIDTH	15
#define XMMIDP_VIDEO_CONFIG3_HSYNC_WIDTH_MASK		0x7FFF0000

#define XMMIDP_VIDEO_CONFIG4				0x0031C

#define XMMIDP_VIDEO_CONFIG4_VSYNC_WIDTH_SHIFT	16
#define XMMIDP_VIDEO_CONFIG4_VSYNC_WIDTH_WIDTH	15
#define XMMIDP_VIDEO_CONFIG4_VSYNC_WIDTH_MASK		0x7FFF0000

#define XMMIDP_VIDEO_CONFIG5				0x00320

#define XMMIDP_VIDEO_CONFIG5_INIT_THRESHOLD_HI_SHIFT	21
#define XMMIDP_VIDEO_CONFIG5_INIT_THRESHOLD_HI_WIDTH	2
#define XMMIDP_VIDEO_CONFIG5_INIT_THRESHOLD_HI_MASK	0x00600000

#define XMMIDP_VIDEO_CONFIG5_EN_3D_FRAME_FILED_SEQ_SHIFT	20
#define XMMIDP_VIDEO_CONFIG5_EN_3D_FRAME_FILED_SEQ_WIDTH	1
#define XMMIDP_VIDEO_CONFIG5_EN_3D_FRAME_FILED_SEQ_MASK	0x00100000

#define XMMIDP_VIDEO_CONFIG5_AVG_BYTES_PER_TU_FRAC_SHIFT	14
#define XMMIDP_VIDEO_CONFIG5_AVG_BYTES_PER_TU_FRAC_WIDTH	6
#define XMMIDP_VIDEO_CONFIG5_AVG_BYTES_PER_TU_FRAC_MASK	0x00007E000

#define XMMIDP_VIDEO_CONFIG5_INIT_THRESHOLD_SHIFT	7
#define XMMIDP_VIDEO_CONFIG5_INIT_THRESHOLD_WIDTH	7
#define XMMIDP_VIDEO_CONFIG5_INIT_THRESHOLD_MASK	0x00001FC0

#define XMMIDP_VIDEO_CONFIG5_AVG_BYTES_PER_TU_SHIFT	0
#define XMMIDP_VIDEO_CONFIG5_AVG_BYTES_PER_TU_WIDTH	6
#define XMMIDP_VIDEO_CONFIG5_AVG_BYTES_PER_TU_MASK	0x0000003F

#define XMMIDP_VIDEO_MSA1			0x00324

#define XMMIDP_VIDEO_MSA1_VSTART_SHIFT	16
#define XMMIDP_VIDEO_MSA1_VSTART_WIDTH	16
#define XMMIDP_VIDEO_MSA1_VSTART_MASK		0xFFFF0000

#define XMMIDP_VIDEO_MSA1_HSTART_SHIFT	0
#define XMMIDP_VIDEO_MSA1_HSTART_WIDTH	16
#define XMMIDP_VIDEO_MSA1_HSTART_MASK		0x0000FFFF

#define XMMIDP_VIDEO_MSA2			0x00328

#define XMMIDP_VIDEO_MSA2_MISC0_SHIFT		24
#define XMMIDP_VIDEO_MSA2_MISC0_WIDTH		16
#define XMMIDP_VIDEO_MSA2_MISC0_MASK		0xFF800000

#define XMMIDP_VIDEO_MSA2_MVID_SHIFT		0
#define XMMIDP_VIDEO_MSA2_MVID_WIDTH		23
#define XMMIDP_VIDEO_MSA2_MVID_MASK		0x007FFFFF

#define XMMIDP_VIDEO_MSA3			0x0032C

#define XMMIDP_VIDEO_MSA3_MISC1_SHIFT		24
#define XMMIDP_VIDEO_MSA3_MISC1_WIDTH		16
#define XMMIDP_VIDEO_MSA3_MISC1_MASK		0xFF800000

#define XMMIDP_VIDEO_MSA3_NVID_SHIFT		0
#define XMMIDP_VIDEO_MSA3_NVID_WIDTH		23
#define XMMIDP_VIDEO_MSA3_NVID_MASK		0x007FFFFF

#define XMMIDP_VSAMPLE_CTRL			0x00300

#define XMMIDP_VSAMPLE_CTRL_LINK_UPD_PPS_SHIFT	27
#define XMMIDP_VSAMPLE_CTRL_LINK_UPD_PPS_WIDTH	1
#define XMMIDP_VSAMPLE_CTRL_LINK_UPD_PPS_MASK		0x08000000

#define XMMIDP_VSAMPLE_CTRL_STREAM_TYPE_SHIFT		25
#define XMMIDP_VSAMPLE_CTRL_STREAM_TYPE_WIDTH		1
#define XMMIDP_VSAMPLE_CTRL_STREAM_TYPE_MASK		0x02000000

#define XMMIDP_VSAMPLE_CTRL_ENCRYPTION_EN_SHIFT	24
#define XMMIDP_VSAMPLE_CTRL_ENCRYPTION_EN_WIDTH	1
#define XMMIDP_VSAMPLE_CTRL_ENCRYPTION_EN_MASK	0x01000000

#define XMMIDP_VSAMPLE_CTRL_ENABLE_DSC_SHIFT		23
#define XMMIDP_VSAMPLE_CTRL_ENABLE_DSC_WIDTH		1
#define XMMIDP_VSAMPLE_CTRL_ENABLE_DSC_MASK		0x00800000

#define XMMIDP_VSAMPLE_CTRL_PIXEL_MODE_SELECT_SHIFT	21
#define XMMIDP_VSAMPLE_CTRL_PIXEL_MODE_SELECT_WIDTH	2
#define XMMIDP_VSAMPLE_CTRL_PIXEL_MODE_SELECT_MASK	0x00600000

#define XMMIDP_VSAMPLE_CTRL_VIDEO_MAPPING_SHIFT	16
#define XMMIDP_VSAMPLE_CTRL_VIDEO_MAPPING_WIDTH	5
#define XMMIDP_VSAMPLE_CTRL_VIDEO_MAPPING_MASK	0x001F0000

#define XMMIDP_VSAMPLE_CTRL_VIDEO_MAPPING_IPI_EN_SHIFT	15
#define XMMIDP_VSAMPLE_CTRL_VIDEO_MAPPING_IPI_EN_WIDTH	1
#define XMMIDP_VSAMPLE_CTRL_VIDEO_MAPPING_IPI_EN_MASK		0x00008000

#define XMMIDP_VSAMPLE_CTRL_VIDEO_STREAM_EN_SHIFT	5
#define XMMIDP_VSAMPLE_CTRL_VIDEO_STREAM_EN_WIDTH	1
#define XMMIDP_VSAMPLE_CTRL_VIDEO_STREAM_EN_MASK	0x00000010

/* VINPUT_POLARITY_CTRL */
#define XMMIDP_VINPUT_POLARITY_CTRL			0x0030C

#define XMMIDP_VINPUT_POLARITY_CTRL_DIE_IN_POLARITY_SHIFT	2
#define XMMIDP_VINPUT_POLARITY_CTRL_DIE_IN_POLARITY_WIDTH	1
#define XMMIDP_VINPUT_POLARITY_CTRL_DIE_IN_POLARITY_MASK	0x08000002

#define XMMIDP_DE_IN_POLARITY_ACTIVE_LOW	0x1
#define XMMIDP_DE_IN_POLARITY_ACTIVE_HIGH	0x0

#define XMMIDP_VINPUT_POLARITY_CTRL_HSYNC_IN_POLARITY_SHIFT	1
#define XMMIDP_VINPUT_POLARITY_CTRL_HSYNC_IN_POLARITY_WIDTH	1
#define XMMIDP_VINPUT_POLARITY_CTRL_HSYNC_IN_POLARITY_MASK	0x00000001

#define XMMIDP_HSYNC_IN_POLARITY_ACTIVE_LOW	0x0
#define XMMIDP_HSYNC_IN_POLARITY_ACTIVE_HIGH	0x1

#define XMMIDP_VINPUT_POLARITY_CTRL_VSYNC_IN_POLARITY_SHIFT	0
#define XMMIDP_VINPUT_POLARITY_CTRL_VSYNC_IN_POLARITY_WIDTH	1
#define XMMIDP_VINPUT_POLARITY_CTRL_VSYNC_IN_POLARITY_MASK	0x00000000

#define XMMIDP_VSYNC_IN_POLARITY_ACTIVE_LOW	0x0
#define XMMIDP_VSYNC_IN_POLARITY_ACTIVE_HIGH	0x1

#define XMMIDP_VIDEO_HBLANK_INTERVAL		0x330

#define XMMIDP_VIDEO_HBLANK_INTERVAL_SHIFT	0
#define XMMIDP_VIDEO_HBLANK_INTERVAL_WIDTH	15
#define XMMIDP_VIDEO_HBLANK_INTERVAL_MASK	0x0000FFFF

/** DPCD Addres Mapping within DPCD Receiver Capability Field (00000h - 000FFh) */
/*
 *  * Register: XMMIDP_DPCD_REV
 *  */
#define XMMIDP_DPCD_REV			0x00000

#define XMMIDP_DPCD_REV_MAJOR_NUM_SHIFT	4
#define XMMIDP_DPCD_REV_MAJOR_NUM_WIDTH	4
#define XMMIDP_DPCD_REV_MAJOR_NUM_MASK	0x000F0

#define XMMIDP_DPCD_REV_MINOR_NUM_SHIFT	0
#define XMMIDP_DPCD_REV_MINOR_NUM_WIDTH	4
#define XMMIDP_DPCD_REV_MINOR_NUM_MASK	0x0000F

/*
 *  * Register: XMMIDP_DPCD_MAX_LINK_RATE
 *  */
#define XMMIDP_DPCD_MAX_LINK_RATE	0x00001

#define XMMIDP_DPCD_MAX_LINK_RATE_SHIFT	0
#define XMMIDP_DPCD_MAX_LINK_RATE_WIDTH	8
#define XMMIDP_DPCD_MAX_LINK_RATE_MASK	0x000FF

/*
 *  * Register: XMMIDP_DPCD_MAX_LANE_COUNT
 *  */
#define XMMIDP_DPCD_MAX_LANE_COUNT	0x00002

#define XMMIDP_DPCD_ENHANCED_FRAME_CAP_SHIFT	7
#define XMMIDP_DPCD_ENHANCED_FRAME_CAP_WIDTH	1
#define XMMIDP_DPCD_ENHANCED_FRAME_CAP_MASK	0x00080

#define XMMIDP_DPCD_TPS3_SUPPORTED_SHIFT		6
#define XMMIDP_DPCD_TPS3_SUPPORTED_WIDTH		1
#define XMMIDP_DPCD_TPS3_SUPPORTED_MASK		0x00040

#define XMMIDP_DPCD_POST_LT_ADJ_REQ_SUPPORTED_SHIFT	5
#define XMMIDP_DPCD_POST_LT_ADJ_REQ_SUPPORTED_WIDTH	1
#define XMMIDP_DPCD_POST_LT_ADJ_REQ_SUPPORTED_MASK	0x00020

#define XMMIDP_DPCD_MAX_LANE_COUNT_SHIFT		0
#define XMMIDP_DPCD_MAX_LANE_COUNT_WIDTH		5
#define XMMIDP_DPCD_MAX_LANE_COUNT_MASK 		0x0001F

/*
 *  * Register: XMMIDP_DPCD_MAX_DOWNSPREAD
 *  */
#define XMMIDP_DPCD_MAX_DOWNSPREAD	0x00003

#define XMMIDP_DPCD_TPS4_SUPPORTED_SHIFT	7
#define XMMIDP_DPCD_TPS4_SUPPORTED_WIDTH	1
#define XMMIDP_DPCD_TPS4_SUPPORTED_MASK	0x00080

#define XMMIDP_DPCD_NO_AUX_TRANSACTION_LINK_TRAINING_SHIFT		6
#define XMMIDP_DPCD_NO_AUX_TRANSACTION_LINK_TRAINING_WIDTH		1
#define XMMIDP_DPCD_NO_AUX_TRANSACTION_LINK_TRAINING_MASK		0x00040

#define XMMIDP_DPCD_MAX_DOWNSPREAD_SHIFT		0
#define XMMIDP_DPCD_MAX_DOWNSPREAD_WIDTH		1
#define XMMIDP_DPCD_MAX_DOWNSPREAD_MASK 		0x00001

/*
 *  * Register: XMMIDP_DPCD_NORP_POWER_VOLTAGE
 *  */
#define XMMIDP_DPCD_NORP_POWER_VOLTAGE	0x00004

#define XMMIDP_DPCD_18V_DP_PWR_CAP_SHIFT		7
#define XMMIDP_DPCD_18V_DP_PWR_CAP_WIDTH		1
#define XMMIDP_DPCD_18V_DP_PWR_CAP_MASK		0x00080

#define XMMIDP_DPCD_12V_DP_PWR_CAP_SHIFT		6
#define XMMIDP_DPCD_12V_DP_PWR_CAP_WIDTH		1
#define XMMIDP_DPCD_12V_DP_PWR_CAP_MASK		0x00040

#define XMMIDP_DPCD_5V_DP_PWR_CAP_SHIFT		5
#define XMMIDP_DPCD_5V_DP_PWR_CAP_WIDTH		1
#define XMMIDP_DPCD_5V_DP_PWR_CAP_MASK		0x00020

#define XMMIDP_DPCD_CRC_3D_SUPPORTED_SHIFT	1
#define XMMIDP_DPCD_CRC_3D_SUPPORTED_WIDTH	1
#define XMMIDP_DPCD_CRC_3D_SUPPORTED_MASK	0x00002

#define XMMIDP_DPCD_NORP_SHIFT		0
#define XMMIDP_DPCD_NORP_WIDTH		1
#define XMMIDP_DPCD_NORP_MASK 		0x00001

/*
 *  * Register: XMMIDP_DPCD_DOWN_STREAM_PORT_PRESENT
 *  */
#define XMMIDP_DPCD_DOWN_STREAM_PORT_PRESENT	0x00005

#define XMMIDP_DPCD_DETAILED_CAP_INFO_AVAILABLE_SHIFT		4
#define XMMIDP_DPCD_DETAILED_CAP_INFO_AVAILABLE_WIDTH		1
#define XMMIDP_DPCD_DETAILED_CAP_INFO_AVAILABLE_MASK		0x00010

#define XMMIDP_DPCD_FORMAT_CONVERSION_SHIFT	3
#define XMMIDP_DPCD_FORMAT_CONVERSION_WIDTH	1
#define XMMIDP_DPCD_FORMAT_CONVERSION_MASK	0x00008

#define XMMIDP_DPCD_DFP_TYPE_SHIFT	1
#define XMMIDP_DPCD_DFP_TYPE_WIDTH	2
#define XMMIDP_DPCD_DFP_TYPE_MASK	0x00006

#define XMMIDP_DPCD_DFP_PRESENT_SHIFT		0
#define XMMIDP_DPCD_DFP_PRESENT_WIDTH		1
#define XMMIDP_DPCD_DFP_PRESENT_MASK 		0x00001

/*
 *  * Register: XMMIDP_DPCD_MAIN_LINK_CHANNEL_CODING
 *  */
#define XMMIDP_DPCD_DOWN_MAIN_LINK_CHANNEL_CODING	0x00006

#define XMMIDP_DPCD_8B_10B_SHIFT		0
#define XMMIDP_DPCD_8B_10B_WIDTH		1
#define XMMIDP_DPCD_8B_10B_MASK		0x00001

/*
 *  * Register: XMMIDP_DPCD_DOWN_STREAM_PORT_COUNT
 *  */
#define XMMIDP_DPCD_DOWN_STREAM_PORT_COUNT	0x00007

#define XMMIDP_DPCD_OUI_SUPPORT_SHIFT	3
#define XMMIDP_DPCD_OUI_SUPPORT_WIDTH	1
#define XMMIDP_DPCD_OUI_SUPPORT_MASK	0x00008

#define XMMIDP_DPCD_MSA_PAR_IGNORED_SHIFT	6
#define XMMIDP_DPCD_MSA_PAR_IGNORED_WIDTH	1
#define XMMIDP_DPCD_MSA_PAR_IGNORED_MASK		0x00040

#define XMMIDP_DPCD_DFP_COUNT_SHIFT		0
#define XMMIDP_DPCD_DFP_COUNT_WIDTH		4
#define XMMIDP_DPCD_DFP_COUNT_MASK 		0x0000F

/*
 *  * Register: XMMIDP_DPCD_RECIEVE_PORT0_CAP_0
 *  */
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0	0x00008

#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_BUFFER_SIZE_PER_PORT_SHIFT	5
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_BUFFER_SIZE_PER_PORT_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_BUFFER_SIZE_PER_PORT_MASK	0x00020

#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_BUFFER_SIZE_UNIT_SHIFT	4
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_BUFFER_SIZE_UNIT_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_BUFFER_SIZE_UNIT_MASK	0x00010

#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_HBLANK_EXPANSION_CAPABLE_SHIFT	3
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_HBLANK_EXPANSION_CAPABLE_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_HBLANK_EXPANSION_CAPABLE_MASK	0x00008

#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_ASSOCIATED_TO_PRECEDING_PORT_SHIFT	2
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_ASSOCIATED_TO_PRECEDING_PORT_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_ASSOCIATED_TO_PRECEDING_PORT_MASK	0x00003

#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_LOCAL_EDID_PRESENT_SHIFT		1
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_LOCAL_EDID_PRESENT_WIDTH		1
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_0_LOCAL_EDID_PRESENT_MASK 		0x00002

/*
 *  * Register: XMMIDP_DPCD_RECIEVE_PORT0_CAP_1
 *  */
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_1	0x00009

#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_1_BUF_SIZE_SHIFT	0
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_1_BUF_SIZE_WIDTH	8
#define XMMIDP_DPCD_RECEIVE_PORT0_CAP_1_BUF_SIZE_MASK	0x000FF

/*
 *  * Register: XMMIDP_DPCD_RECIEVE_PORT1_CAP_0
 *  */
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0	0x0000A

#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_BUFFER_SIZE_PER_PORT_SHIFT	5
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_BUFFER_SIZE_PER_PORT_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_BUFFER_SIZE_PER_PORT_MASK	0x00020

#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_BUFFER_SIZE_UNIT_SHIFT	4
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_BUFFER_SIZE_UNIT_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_BUFFER_SIZE_UNIT_MASK	0x00010

#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_HBLANK_EXPANSION_CAPABLE_SHIFT	3
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_HBLANK_EXPANSION_CAPABLE_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_HBLANK_EXPANSION_CAPABLE_MASK	0x00008

#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_ASSOCIATED_TO_PRECEDING_PORT_SHIFT	2
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_ASSOCIATED_TO_PRECEDING_PORT_WIDTH	1
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_ASSOCIATED_TO_PRECEDING_PORT_MASK	0x00003

#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_LOCAL_EDID_PRESENT_SHIFT		1
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_LOCAL_EDID_PRESENT_WIDTH		1
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_0_LOCAL_EDID_PRESENT_MASK 		0x00002

/*
 *  * Register: XMMIDP_DPCD_RECIEVE_PORT1_CAP_1
 *  */
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_1	0x0000B

#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_1_BUF_SIZE_SHIFT	0
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_1_BUF_SIZE_WIDTH	8
#define XMMIDP_DPCD_RECEIVE_PORT1_CAP_1_BUF_SIZE_MASK	0x000FF

/*
 *  * Register: XMMIDP_DPCD_RECIEVE_PORT1_CAP_1
 *  */
#define XMMIDP_DPCD_I2C_CONTROL_CAP_BIT_MAP_1	0x0000C

#define XMMIDP_DPCD_I2C_CONTROL_CAP_BIT_MAP_1_SHIFT	0
#define XMMIDP_DPCD_I2C_CONTROL_CAP_BIT_MAP_1_WIDTH	8
#define XMMIDP_DPCD_I2C_CONTROL_CAP_BIT_MAP_1_MASK	0x000FF

/*
 *  * Register: XMMIDP_DPCD_EDP_CONFIG_CAP
 *  */
#define XMMIDP_DPCD_EDP_CONFIG_CAP	0x0000D

/*
 *  * Register: XMMIDP_DPCD_TRAINING_AUX_RD_INTERVAL
 *  */
#define XMMIDP_DPCD_TRAINING_AUX_RD_INTERVAL	0x0000E

#define XMMIDP_DPCD_EXTENDED_REEIVER_CAPABILITY_FIELD_PRESENT_SHIFT	7
#define XMMIDP_DPCD_EXTENDED_REEIVER_CAPABILITY_FIELD_PRESENT_WIDTH	1
#define XMMIDP_DPCD_EXTENDED_REEIVER_CAPABILITY_FIELD_PRESENT_MASK	0x00080

#define XMMIDP_DPCD_TRAINING_AUX_RD_INTERVAL_SHIFT	0
#define XMMIDP_DPCD_TRAINING_AUX_RD_INTERVAL_WIDTH	7
#define XMMIDP_DPCD_TRAINING_AUX_RD_INTERVAL_MASK	0x0007F

/*
 *  * Register: XMMIDP_DPCD_ADAPTER_CAP
 *  */
#define XMMIDP_DPCD_ADAPTER_CAP	0x0000F

#define XMMIDP_DPCD_ALTERNATE_I2C_PATTERN_CAP_SHIFT	1
#define XMMIDP_DPCD_ALTERNATE_I2C_PATTERN_CAP_WIDTH	1
#define XMMIDP_DPCD_ALTERNATE_I2C_PATTERN_CAP_MASK	0x00002

#define XMMIDP_DPCD_ADAPTER_CAP_FORCE_LOAD_SENSE_CAP_SHIFT	0
#define XMMIDP_DPCD_ADAPTER_CAP_FORCE_LOAD_SENSE_CAP_WIDTH	1
#define XMMIDP_DPCD_ADAPTER_CAP_FORCE_LOAD_SENSE_CAP_MASK	0x00001

/** XMMIDP_DPCD 00010h - 0001Fh DPCD r1.3 ONLY **/
/** XMMIDP_DPCD 00020h RESERVED */

/*
 *  * Register: XMMIDP_DPCD_MSTM_CAP
 *  */
#define XMMIDP_DPCD_MSTM_CAP	0x00021

#define XMMIDP_DPCD_MSTM_CAP_MST_CAP_SHIFT	0
#define XMMIDP_DPCD_MSTM_CAP_MST_CAP_WIDTH	1
#define XMMIDP_DPCD_MSTM_CAP_MST_CAP_MASK	0x00001

/*
 *  * Register: XMMIDP_DPCD_NUM_AUDIO_ENDPOINTS
 *  */
#define XMMIDP_DPCD_NUM_AUDIO_ENDPOINTS	0x00022

/*
 *  * Register: XMMIDP_DPCD_AV_SYNC_DATA_BLOCK_AV_GRANULARITY
 *  */
#define XMMIDP_DPCD_AV_SYNC_DATA_BLOCK_AV_GRANULARITY	0x00023

#define XMMIDP_DPCD_VG_FACTOR_SHIFT	4
#define XMMIDP_DPCD_VG_FACTOR_WIDTH	4
#define XMMIDP_DPCD_VG_FACTOR_MASK	0x000F0

#define XMMIDP_DPCD_AG_FACTOR_SHIFT	0
#define XMMIDP_DPCD_AG_FACTOR_WIDTH	4
#define XMMIDP_DPCD_AG_FACTOR_MASK	0x0000F

/*
 *  * Register: XMMIDP_DPCD_AUD_DEC_LAT7_0
 *  */
#define XMMIDP_DPCD_AUD_DEC_LAT7_0	0x00024

/*
 *  * Register: XMMIDP_DPCD_AUD_DEC_LAT15_8
 *  */
#define XMMIDP_DPCD_AUD_DEC_LAT15_8	0x00025

/*
 *  * Register: XMMIDP_DPCD_AUD_PP_LAT7_0
 *  */
#define XMMIDP_DPCD_AUD_PP_LAT7_0	0x00026

/*
 *  * Register: XMMIDP_DPCD_AUD_PP_LAT15_8
 *  */
#define XMMIDP_DPCD_AUD_PP_LAT15_8	0x00027

/*
 *  * Register: XMMIDP_DPCD_VID_INTER_LAT7_0
 *  */
#define XMMIDP_DPCD_VID_INTER_LAT7_0	0x00028

/*
 *  * Register: XMMIDP_DPCD_VID_PROG_LAT7_0
 *  */
#define XMMIDP_DPCD_VID_PROG_LAT7_0	0x00029

/*
 *  * Register: XMMIDP_DPCD_REP_LAT7_0
 *  */
#define XMMIDP_DPCD_REP_LAT7_0	0x0002A

/*
 *  * Register: XMMIDP_DPCD_AUD_DEL_INS7_0
 *  */
#define XMMIDP_DPCD_AUD_DEL_INS7_0	0x0002B

/*
 *  * Register: XMMIDP_DPCD_AUD_DEL_INS15_8
 *  */
#define XMMIDP_DPCD_AUD_DEL_INS15_8	0x0002C

/*
 *  * Register: XMMIDP_DPCD_AUD_DEL_INS23_16
 *  */
#define XMMIDP_DPCD_AUD_DEL_INS23_16	0x0002D

/** DPCD Addres Mapping within DPCD Link Configuration Field (00100h - 001FFh) */

/*
 *  * Register: XMMIDP_DPCD_LINK_BW_SET
 *  */
#define XMMIDP_DPCD_LINK_BW_SET		 0x00100
#define XMMIDP_DPCD_LINK_BW_SET_162GBPS	 0x06
#define XMMIDP_DPCD_LINK_BW_SET_540GBPS	 0x14
#define XMMIDP_DPCD_LINK_BW_SET_270GBPS	 0x0A
#define XMMIDP_DPCD_LINK_BW_SET_810GBPS	 0x1E

/*
 *  * Register: XMMIDP_DPCD_LANE_COUNT_SET
 *  */
#define XMMIDP_DPCD_LANE_COUNT_SET		 0x00101

#define XMMIDP_DPCD_ENHANCED_FRAME_EN_SHIFT	 7
#define XMMIDP_DPCD_ENHANCED_FRAME_EN_WIDTH	 1
#define XMMIDP_DPCD_ENHANCED_FRAME_EN_MASK	 0x80

#define XMMIDP_DPCD_POST_LT_ADJ_REQ_GRANTED_SHIFT	 5
#define XMMIDP_DPCD_POST_LT_ADJ_REQ_GRANTED_WIDTH	 1
#define XMMIDP_DPCD_POST_LT_ADJ_REQ_GRANTED_MASK	 0x20

#define XMMIDP_DPCD_LANE_COUNT_SET_SHIFT	 0
#define XMMIDP_DPCD_LANE_COUNT_SET_WIDTH	 5
#define XMMIDP_DPCD_LANE_COUNT_SET_MASK	 0x1F

/*
 *  * Register: XMMIDP_DPCD_TRAINING_PATTERN_SET
 *  */
#define XMMIDP_DPCD_TRAINING_PATTERN_SET		 0x00102

#define XMMIDP_DPCD_SYMBOL_ERROR_COUNT_SEL_SHIFT	 6
#define XMMIDP_DPCD_SYMBOL_ERROR_COUNT_SEL_WIDTH	 2
#define XMMIDP_DPCD_SYMBOL_ERROR_COUNT_SEL_MASK	 0xC0

#define XMMIDP_DPCD_SCRAMBLING_DISABLE_SHIFT		 5
#define XMMIDP_DPCD_SCRAMBLING_DISABLE_WIDTH		 1
#define XMMIDP_DPCD_SCRAMBLING_DISABLE_MASK		 0x20

#define XMMIDP_DPCD_RECOVERED_CLOCK_OUT_EN_SHIFT	 4
#define XMMIDP_DPCD_RECOVERED_CLOCK_OUT_EN_WIDTH	 1
#define XMMIDP_DPCD_RECOVERED_CLOCK_OUT_EN_MASK	 0x10

#define XMMIDP_DPCD_TRAINING_PATTERN_SELECT_SHIFT	 0
#define XMMIDP_DPCD_TRAINING_PATTERN_SELECT_WIDTH	 4
#define XMMIDP_DPCD_TRAINING_PATTERN_SELECT_MASK	 0x0F

/*
 *  * Register: XMMIDP_DPCD_TRAINING_LANE0_SET
 *  */
#define XMMIDP_DPCD_TRAINING_LANE0_SET		 0x00103

#define XMMIDP_DPCD_MAX_PREEMPHASIS_REACHED_SHIFT	 5
#define XMMIDP_DPCD_MAX_PREEMPHASIS_REACHED_WIDTH	 1
#define XMMIDP_DPCD_MAX_PREEMPHASIS_REACHED_MASK	 0x20

#define XMMIDP_DPCD_PREEMPHASIS_SET_SHIFT		 3
#define XMMIDP_DPCD_PREEMPHASIS_SET_WIDTH		 2
#define XMMIDP_DPCD_PREEMPHASIS_SET_MASK		 0x18

#define XMMIDP_DPCD_MAX_SWING_REACHED_SHIFT		 2
#define XMMIDP_DPCD_MAX_SWING_REACHED_WIDTH		 1
#define XMMIDP_DPCD_MAX_SWING_REACHED_MASK		 0x04

#define XMMIDP_DPCD_VOLTAGE_SWING_SET_SHIFT		 0
#define XMMIDP_DPCD_VOLTAGE_SWING_SET_WIDTH		 2
#define XMMIDP_DPCD_VOLTAGE_SWING_SET_MASK		 0x03

#define XMMIDP_DPCD_TRAINING_LANE1_SET		 0x00104
#define XMMIDP_DPCD_TRAINING_LANE2_SET		 0x00105
#define XMMIDP_DPCD_TRAINING_LANE3_SET		 0x00106

/*
 *  * Register: XMMIDP_DPCD_DOWNSPREAD_CTRL
 *  */
#define XMMIDP_DPCD_DOWNSPREAD_CTRL			 0x00107

#define XMMIDP_DPCD_MSA_TIMING_PAR_IGNORE_EN_SHIFT	 7
#define XMMIDP_DPCD_MSA_TIMING_PAR_IGNORE_EN_WIDTH	 1
#define XMMIDP_DPCD_MSA_TIMING_PAR_IGNORE_EN_MASK	 0x80

#define XMMIDP_DPCD_SPREAD_AMP_SHIFT			 4
#define XMMIDP_DPCD_SPREAD_AMP_WIDTH			 1
#define XMMIDP_DPCD_SPREAD_AMP_MASK			 0x10

/*
 *  * Register: XMMIDP_DPCD_MAIN_LINK_CHANNEL_CODING_SET
 *  */
#define XMMIDP_DPCD_MAIN_LINK_CHANNEL_CODING_SET	 0x00108

#define XMMIDP_DPCD_SET8b10b_SHIFT			 0
#define XMMIDP_DPCD_SET8b10b_WIDTH			 1
#define XMMIDP_DPCD_SET8b10b_MASK			 0x00

/*
 *  * Register: XMMIDP_DPCD_I2C_SPEED_CTRL
 *  */
#define XMMIDP_DPCD_I2C_SPEED_CTRL		 0x00109

#define XMMIDP_DPCD_I2C_SPEED_CTRL_1KBPS	 0
#define XMMIDP_DPCD_I2C_SPEED_CTRL_5KBPS	 2
#define XMMIDP_DPCD_I2C_SPEED_CTRL_10KPBS	 4
#define XMMIDP_DPCD_I2C_SPEED_CTRL_100KPBS	 8
#define XMMIDP_DPCD_I2C_SPEED_CTRL_400KPBS	 10
#define XMMIDP_DPCD_I2C_SPEED_CTRL_1MBPS	 20

/*
 *  * Register: XMMIDP_DPCD_EDP_CONFIG_SET
 *  */
#define XMMIDP_DPCD_EDP_CONFIG_SET		 0x0010A

#define XMMIDP_DPCD_PANEL_SELF_TEST_EN_SHIFT	 7
#define XMMIDP_DPCD_PANEL_SELF_TEST_EN_WIDTH	 1
#define XMMIDP_DPCD_PANEL_SELF_TEST_EN_MASK	 0x80

#define XMMIDP_DPCD_ALT_SCRAMBLER_RESET_EN_SHIFT	 0
#define XMMIDP_DPCD_ALT_SCRAMBLER_RESET_EN_WIDTH	 1
#define XMMIDP_DPCD_ALT_SCRAMBLER_RESET_EN_MASK	 0x00

/*
 *  * Register: XMMIDP_DPCD_LINK_QUAL_LANE0_SET
 *  */
#define XMMIDP_DPCD_LINK_QUAL_LANE0_SET		 0x0010B

#define XMMIDP_DPCD_LINK_QUAL_PATTERN_SET_SHIFT	 0
#define XMMIDP_DPCD_LINK_QUAL_PATTERN_SET_WIDTH	 3
#define XMMIDP_DPCD_LINK_QUAL_PATTERN_SET_MASK	 0x07

#define XMMIDP_DPCD_LINK_QUAL_LANE1_SET		 0x0010C
#define XMMIDP_DPCD_LINK_QUAL_LANE2_SET		 0x0010D
#define XMMIDP_DPCD_LINK_QUAL_LANE3_SET		 0x0010E

/*
 *  * Register: XMMIDP_DPCD_MSTM_CTRL
 *  */
#define XMMIDP_DPCD_MSTM_CTRL				 0x00111

#define XMMIDP_DPCD_UPSTREAM_IS_SRC_SHIFT	 	2
#define XMMIDP_DPCD_UPSTREAM_IS_SRC_WIDTH	 	1
#define XMMIDP_DPCD_UPSTREAM_IS_SRC_MASK	 	0x04

#define XMMIDP_DPCD_UP_REQ_EN_SHIFT	 		1
#define XMMIDP_DPCD_UP_REQ_EN_WIDTH	 		1
#define XMMIDP_DPCD_UP_REQ_EN_MASK	 		0x02

#define XMMIDP_DPCD_MST_EN_SHIFT	 		0
#define XMMIDP_DPCD_MST_EN_WIDTH	 		1
#define XMMIDP_DPCD_MST_EN_MASK	 		0x00

/*
 *  * Register: XMMIDP_DPCD_AUDIO_DELAY
 *  */
#define XMMIDP_DPCD_AUDIO0_DELAY			0x00112
#define XMMIDP_DPCD_AUDIO1_DELAY			0x00113
#define XMMIDP_DPCD_AUDIO2_DELAY			0x00114

/*
 *  * Register: XMMIDP_DPCD_LINK_RATE_SET
 *  */
#define XMMIDP_DPCD_LINK_RATE_SET			0x00115

#define XMMIDP_DPCD_TX_GTC_SLAVE_CAP_SHIFT	 	4
#define XMMIDP_DPCD_TX_GTC_SLAVE_CAP_WIDTH	 	1
#define XMMIDP_DPCD_TX_GTC_SLAVE_CAP_MASK		0x10

#define XMMIDP_DPCD_TX_GTC_CAP_SHIFT	 		3
#define XMMIDP_DPCD_TX_GTC_CAP_WIDTH	 		1
#define XMMIDP_DPCD_TX_GTC_CAP_MASK	 		0x08

#define XMMIDP_DPCD_LINK_RATE_SET_SHIFT	 	0
#define XMMIDP_DPCD_LINK_RATE_SET_WIDTH	 	3
#define XMMIDP_DPCD_LINK_RATE_SET_MASK	 	0x00

/*
 *  * Register: XMMIDP_DPCD_UPSTREAM_DEVICE_DP_PWR_NEED
 *  */
#define XMMIDP_DPCD_UPSTREAM_DEVICE_DP_PWR_NEED	0x00118

#define XMMIDP_DPCD_DP_PWR_NOT_NEEDED_SHIFT	 	0
#define XMMIDP_DPCD_DP_PWR_NOT_NEEDED_WIDTH	 	1
#define XMMIDP_DPCD_DP_PWR_NOT_NEEDED_MASK		0x00

/*
 *  * Register: XMMIDP_DPCD_EXTENDED_DPRX_SLEEP_WAKE_TIMEOUT_GRANT
 *  */
#define XMMIDP_DPCD_EXTENDED_DPRX_SLEEP_WAKE_TIMEOUT_GRANT	0x00119

#define XMMIDP_DPCD_DPRX_SLEEP_WAKE_TIMEOUT_PERIOD_GRANT_SHIFT	 	0
#define XMMIDP_DPCD_DPRX_SLEEP_WAKE_TIMEOUT_PERIOD_GRANT_WIDTH	 	1
#define XMMIDP_DPCD_DPRX_SLEEP_WAKE_TIMEOUT_PERIOD_GRANT_MASK		0x00

/*
 *  * Register: XMMIDP_DPCD_FEC_CONFIGURATION
 *  */
#define XMMIDP_DPCD_FEC_CONFIGURATION			0x00120

#define XMMIDP_DPCD_LANE_DEC_SELECT_SHIFT	 	4
#define XMMIDP_DPCD_LANE_DEC_SELECT_WIDTH	 	2
#define XMMIDP_DPCD_LANE_DEC_SELECT_MASK		0x30

#define XMMIDP_DPCD_FEC_ERROR_COUNT_SELF_SHIFT 	1
#define XMMIDP_DPCD_FEC_ERROR_COUNT_SELF_WIDTH 	4
#define XMMIDP_DPCD_FEC_ERROR_COUNT_SELF_MASK		0x1E

#define XMMIDP_DPCD_FEC_READY_SHIFT	 		0
#define XMMIDP_DPCD_FEC_READY_WIDTH	 		1
#define XMMIDP_DPCD_FEC_READY_MASK	 		0x00

/*
 *  * Register: XMMIDP_DPCD_TX_GTC_VALUE
 *  */
#define XMMIDP_DPCD_TX_GTC0_VALUE			0x00154
#define XMMIDP_DPCD_TX_GTC1_VALUE			0x00155
#define XMMIDP_DPCD_TX_GTC2_VALUE			0x00156
#define XMMIDP_DPCD_TX_GTC3_VALUE			0x00157

/*
 *  * Register: XMMIDP_DPCD_RX_GTC_VALUE_PHASE_SKEW_EN
 *  */
#define XMMIDP_DPCD_RX_GTC_VALUE_PHASE_SKEW_EN			0x00158

/*
 *  * Register: XMMIDP_DPCD_TX_GTC_FREQ_LOCK_DONE
 *  */
#define XMMIDP_DPCD_TX_GTC_FREQ_LOCK_DONE		0x00159

/*
 *  * Register: XMMIDP_DPCD_TX_GTC_PHASE_SKEW_OFFSET
 *  */
#define XMMIDP_DPCD_TX_GTC_PHASE_SKEW_OFFSET0		0x0015A
#define XMMIDP_DPCD_TX_GTC_PHASE_SKEW_OFFSET1		0x0015B

/*
 *  * Register: XMMIDP_DPCD_DSC_ENABLE
 *  */
#define XMMIDP_DPCD_DSC_ENABLE			0x00160

/*
 *  * Register: XMMIDP_DPCD_PANEL_REFRESH_EN
 *  */
#define XMMIDP_DPCD_PANEL_REFRESH_EN			0x00170

/*
 *  * Register: XMMIDP_DPCD_ADAPTER_CTRL
 *  */
#define XMMIDP_DPCD_ADAPTER_CTRL			0x001A0

#define XMMIDP_DPCD_FORCE_LOAD_SENSE_SHIFT		0
#define XMMIDP_DPCD_FORCE_LOAD_SENSE_WIDTH		1
#define XMMIDP_DPCD_FORCE_LOAD_SENSE_MASK		0x00

/*
 *  * Register: XMMIDP_DPCD_BRANCH_DEVICE_CTRL
 *  */
#define XMMIDP_DPCD_BRANCH_DEVICE_CTRL		0x001A1

#define XMMIDP_DPCD_HOTPLUG_UNPLUG_NOTIF_SHIFT	0
#define XMMIDP_DPCD_HOTPLUG_UNPLUG_NOTIF_WIDTH	1
#define XMMIDP_DPCD_HOTPLUG_UNPLUG_NOTIF_MASK		0x00

/*
 *  * Register: XMMIDP_DPCD_PAYLOAD_ALLOCATE_SET
 *  */
#define XMMIDP_DPCD_PAYLOAD_ALLOCATE_SET		0x001C0

#define XMMIDP_DPCD_VC_PAYLOAD_ID_SHIFT		0
#define XMMIDP_DPCD_VC_PAYLOAD_ID_WIDTH		7
#define XMMIDP_DPCD_VC_PAYLOAD_ID_MASK		0x7F

/*
 *  * Register: XMMIDP_DPCD_PAYLOAD_ALLOCATE_START_TIME_SLOT
 *  */
#define XMMIDP_DPCD_PAYLOAD_ALLOCATE_START_TIME_SLOT	0x001C1

#define XMMIDP_DPCD_START_TIME_VC_PAYLOAD_ID_SHIFT	0
#define XMMIDP_DPCD_START_TIME_VC_PAYLOAD_ID_WIDTH	6
#define XMMIDP_DPCD_START_TIME_VC_PAYLOAD_ID_MASK	0x3F

/*
 *  * Register: XMMIDP_DPCD_LANE0_1_STATUS
 *  */
#define XMMIDP_DPCD_LANE0_1_STATUS			0x00202

#define XMMIDP_DPCD_LANE1_SYMBOL_LOCKED_SHIFT		6
#define XMMIDP_DPCD_LANE1_SYMBOL_LOCKED_WIDTH		1
#define XMMIDP_DPCD_LANE1_SYMBOL_LOCKED_MASK		0x40

#define XMMIDP_DPCD_LANE1_CHANNEL_EQ_DONE_SHIFT	5
#define XMMIDP_DPCD_LANE1_CHANNEL_EQ_DONE_WIDTH	1
#define XMMIDP_DPCD_LANE1_CHANNEL_EQ_DONE_MASK	0x20

#define XMMIDP_DPCD_LANE1_CR_DONE_SHIFT		4
#define XMMIDP_DPCD_LANE1_CR_DONE_WIDTH		1
#define XMMIDP_DPCD_LANE1_CR_DONE_MASK		0x10

#define XMMIDP_DPCD_LANE0_SYMBOL_LOCKED_SHIFT		2
#define XMMIDP_DPCD_LANE0_SYMBOL_LOCKED_WIDTH		1
#define XMMIDP_DPCD_LANE0_SYMBOL_LOCKED_MASK		0x04

#define XMMIDP_DPCD_LANE0_CHANNEL_EQ_DONE_SHIFT	1
#define XMMIDP_DPCD_LANE0_CHANNEL_EQ_DONE_WIDTH	1
#define XMMIDP_DPCD_LANE0_CHANNEL_EQ_DONE_MASK	0x02

#define XMMIDP_DPCD_LANE0_CR_DONE_SHIFT		0
#define XMMIDP_DPCD_LANE0_CR_DONE_WIDTH		1
#define XMMIDP_DPCD_LANE0_CR_DONE_MASK		0x01

/*
 *  * Register: XMMIDP_DPCD_LANE2_3_STATUS
 *  */
#define XMMIDP_DPCD_LANE2_3_STATUS			0x00203

#define XMMIDP_DPCD_LANE3_SYMBOL_LOCKED_SHIFT		6
#define XMMIDP_DPCD_LANE3_SYMBOL_LOCKED_WIDTH		1
#define XMMIDP_DPCD_LANE3_SYMBOL_LOCKED_MASK		0x40

#define XMMIDP_DPCD_LANE3_CHANNEL_EQ_DONE_SHIFT	5
#define XMMIDP_DPCD_LANE3_CHANNEL_EQ_DONE_WIDTH	1
#define XMMIDP_DPCD_LANE3_CHANNEL_EQ_DONE_MASK	0x20

#define XMMIDP_DPCD_LANE3_CR_DONE_SHIFT		4
#define XMMIDP_DPCD_LANE3_CR_DONE_WIDTH		1
#define XMMIDP_DPCD_LANE3_CR_DONE_MASK		0x10

#define XMMIDP_DPCD_LANE2_SYMBOL_LOCKED_SHIFT		2
#define XMMIDP_DPCD_LANE2_SYMBOL_LOCKED_WIDTH		1
#define XMMIDP_DPCD_LANE2_SYMBOL_LOCKED_MASK		0x04

#define XMMIDP_DPCD_LANE2_CHANNEL_EQ_DONE_SHIFT	1
#define XMMIDP_DPCD_LANE2_CHANNEL_EQ_DONE_WIDTH	1
#define XMMIDP_DPCD_LANE2_CHANNEL_EQ_DONE_MASK	0x02

#define XMMIDP_DPCD_LANE2_CR_DONE_SHIFT		0
#define XMMIDP_DPCD_LANE2_CR_DONE_WIDTH		1
#define XMMIDP_DPCD_LANE2_CR_DONE_MASK		0x01

/*
 *  * Register: XMMIDP_DPCD_LANE_ALIGN_STATUS_UPDATED
 *  */
#define XMMIDP_DPCD_LANE_ALIGN_STATUS_UPDATED		0x00204

#define XMMIDP_DPCD_LINK_STATUS_UPDATED_SHIFT		7
#define XMMIDP_DPCD_LINK_STATUS_UPDATED_WIDTH		1
#define XMMIDP_DPCD_LINK_STATUS_UPDATED_MASK		0x80

#define XMMIDP_DPCD_DOWNSTREAM_PORT_STATUS_CHANGED_SHIFT	6
#define XMMIDP_DPCD_DOWNSTREAM_PORT_STATUS_CHANGED_WIDTH	1
#define XMMIDP_DPCD_DOWNSTREAM_PORT_STATUS_CHANGED_MASK	0x40

#define XMMIDP_DPCD_POST_LT_ADJ_REQ_IN_PROGRESS_SHIFT		1
#define XMMIDP_DPCD_POST_LT_ADJ_REQ_IN_PROGRESS_WIDTH		1
#define XMMIDP_DPCD_POST_LT_ADJ_REQ_IN_PROGRESS_MASK		0x02

#define XMMIDP_DPCD_INTERLANE_ALIGN_DONE_SHIFT	0
#define XMMIDP_DPCD_INTERLANE_ALIGN_DONE_WIDTH	1
#define XMMIDP_DPCD_INTERLANE_ALIGN_DONE_MASK		0x01

/*
 *  * Register: XMMIDP_DPCD_ADJUSTED_REQ_LANE0_1
 *  */
#define XMMIDP_DPCD_ADJUSTED_REQ_LANE0_1	0x00206

#define XMMIDP_DPCD_PREEMP_LANE1_SHIFT	6
#define XMMIDP_DPCD_PREEMP_LANE1_WIDTH	2
#define XMMIDP_DPCD_PREEMP_LANE1_MASK		0xC0

#define XMMIDP_DPCD_VSWING_LANE1_SHIFT	4
#define XMMIDP_DPCD_VSWING_LANE1_WIDTH	2
#define XMMIDP_DPCD_VSWING_LANE1_MASK		0x30

#define XMMIDP_DPCD_PREEMP_LANE0_SHIFT	2
#define XMMIDP_DPCD_PREEMP_LANE0_WIDTH	2
#define XMMIDP_DPCD_PREEMP_LANE0_MASK		0x0C

#define XMMIDP_DPCD_VSWING_LANE0_SHIFT	0
#define XMMIDP_DPCD_VSWING_LANE0_WIDTH	2
#define XMMIDP_DPCD_VSWING_LANE0_MASK		0x03

/*
 *  * Register: XMMIDP_DPCD_ADJUSTED_REQ_LANE2_3
 *  */
#define XMMIDP_DPCD_ADJUSTED_REQ_LANE2_3	0x00207

#define XMMIDP_DPCD_PREEMP_LANE3_SHIFT	6
#define XMMIDP_DPCD_PREEMP_LANE3_WIDTH	2
#define XMMIDP_DPCD_PREEMP_LANE3_MASK		0xC0

#define XMMIDP_DPCD_VSWING_LANE3_SHIFT	4
#define XMMIDP_DPCD_VSWING_LANE3_WIDTH	2
#define XMMIDP_DPCD_VSWING_LANE3_MASK		0x30

#define XMMIDP_DPCD_PREEMP_LANE2_SHIFT	2
#define XMMIDP_DPCD_PREEMP_LANE2_WIDTH	2
#define XMMIDP_DPCD_PREEMP_LANE2_MASK		0x0C

#define XMMIDP_DPCD_VSWING_LANE2_SHIFT	0
#define XMMIDP_DPCD_VSWING_LANE2_WIDTH	2
#define XMMIDP_DPCD_VSWING_LANE2_MASK		0x03

//FIXME - add others
#define XMMIDP_DPCD_SET_POWER_DP_PWR_VOLTAGE		0x00600
#define XMMIDP_DPCD_RX_CAP_ENABLED_MASK		0x80
#define XMMIDP_DPCD_MAX_LINK_RATE_EXTENDED		0x2201

/******************************************************************************/

/******************* Macros (Inline Functions) Definitions ********************/

/** @name Register access macro definitions.
  * @{
  */
#define XMmiDp_In32 Xil_In32
#define XMmiDp_Out32 Xil_Out32
/* @} */

/******************************************************************************/
/**
 * This is a low-level function that reads from the specified register.
 *
 * @param	BaseAddress is the base address of the device.
 * @param	RegOffset is the register offset to be read from.
 *
 * @return	The 32-bit value of the specified register.
 *
 * @note	C-style signature:
 *		u32 XMmiDp_ReadReg(UINTPTR BaseAddress, u32 RegOffset)
 *
*******************************************************************************/
#define XMmiDp_ReadReg(BaseAddress, RegOffset) \
	XMmiDp_In32((BaseAddress) + (RegOffset))

/******************************************************************************/
/**
 * This is a low-level function that writes to the specified register.
 *
 * @param	BaseAddress is the base address of the device.
 * @param	RegOffset is the register offset to write to.
 * @param	Data is the 32-bit data to write to the specified register.
 *
 * @return	None.
 *
 * @note	C-style signature:
 *		void XMmiDp_WriteReg(UINTPTR BaseAddress, u32 RegOffset, u32 Data)
 *
*******************************************************************************/
#define XMmiDp_WriteReg(BaseAddress, RegOffset, Data) \
	XMmiDp_Out32((BaseAddress) + (RegOffset), (Data))

#ifdef __cplusplus
}
#endif

#endif /* XDP_HW_H_ */
/** @} */
