/*
 * QEMU model of the CRF_APB APB control registers for clock controller. The RST_ctrl_fpd will be added to this as well
 *
 * Copyright (c) 2017 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2017-02-27.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "hw/arm/linux-boot-if.h"

#include "hw/fdt_generic_util.h"

#ifndef XILINX_CRF_APB_ERR_DEBUG
#define XILINX_CRF_APB_ERR_DEBUG 0
#endif

#define TYPE_XILINX_CRF_APB "xlnx.zynqmp_crf"

#define XILINX_CRF_APB(obj) \
     OBJECT_CHECK(CRF_APB, (obj), TYPE_XILINX_CRF_APB)

REG32(ERR_CTRL, 0x0)
    FIELD(ERR_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0x4)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x8)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0xc)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x10)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(CRF_WPROT, 0x1c)
    FIELD(CRF_WPROT, ACTIVE, 0, 1)
REG32(APLL_CTRL, 0x20)
    FIELD(APLL_CTRL, POST_SRC, 24, 3)
    FIELD(APLL_CTRL, PRE_SRC, 20, 3)
    FIELD(APLL_CTRL, CLKOUTDIV, 17, 1)
    FIELD(APLL_CTRL, DIV2, 16, 1)
    FIELD(APLL_CTRL, FBDIV, 8, 7)
    FIELD(APLL_CTRL, BYPASS, 3, 1)
    FIELD(APLL_CTRL, RESET, 0, 1)
REG32(APLL_CFG, 0x24)
    FIELD(APLL_CFG, LOCK_DLY, 25, 7)
    FIELD(APLL_CFG, LOCK_CNT, 13, 10)
    FIELD(APLL_CFG, LFHF, 10, 2)
    FIELD(APLL_CFG, CP, 5, 4)
    FIELD(APLL_CFG, RES, 0, 4)
REG32(APLL_FRAC_CFG, 0x28)
    FIELD(APLL_FRAC_CFG, ENABLED, 31, 1)
    FIELD(APLL_FRAC_CFG, SEED, 22, 3)
    FIELD(APLL_FRAC_CFG, ALGRTHM, 19, 1)
    FIELD(APLL_FRAC_CFG, ORDER, 18, 1)
    FIELD(APLL_FRAC_CFG, DATA, 0, 16)
REG32(DPLL_CTRL, 0x2c)
    FIELD(DPLL_CTRL, POST_SRC, 24, 3)
    FIELD(DPLL_CTRL, PRE_SRC, 20, 3)
    FIELD(DPLL_CTRL, CLKOUTDIV, 17, 1)
    FIELD(DPLL_CTRL, DIV2, 16, 1)
    FIELD(DPLL_CTRL, FBDIV, 8, 7)
    FIELD(DPLL_CTRL, BYPASS, 3, 1)
    FIELD(DPLL_CTRL, RESET, 0, 1)
REG32(DPLL_CFG, 0x30)
    FIELD(DPLL_CFG, LOCK_DLY, 25, 7)
    FIELD(DPLL_CFG, LOCK_CNT, 13, 10)
    FIELD(DPLL_CFG, LFHF, 10, 2)
    FIELD(DPLL_CFG, CP, 5, 4)
    FIELD(DPLL_CFG, RES, 0, 4)
REG32(DPLL_FRAC_CFG, 0x34)
    FIELD(DPLL_FRAC_CFG, ENABLED, 31, 1)
    FIELD(DPLL_FRAC_CFG, SEED, 22, 3)
    FIELD(DPLL_FRAC_CFG, ALGRTHM, 19, 1)
    FIELD(DPLL_FRAC_CFG, ORDER, 18, 1)
    FIELD(DPLL_FRAC_CFG, DATA, 0, 16)
REG32(VPLL_CTRL, 0x38)
    FIELD(VPLL_CTRL, POST_SRC, 24, 3)
    FIELD(VPLL_CTRL, PRE_SRC, 20, 3)
    FIELD(VPLL_CTRL, CLKOUTDIV, 17, 1)
    FIELD(VPLL_CTRL, DIV2, 16, 1)
    FIELD(VPLL_CTRL, FBDIV, 8, 7)
    FIELD(VPLL_CTRL, BYPASS, 3, 1)
    FIELD(VPLL_CTRL, RESET, 0, 1)
REG32(VPLL_CFG, 0x3c)
    FIELD(VPLL_CFG, LOCK_DLY, 25, 7)
    FIELD(VPLL_CFG, LOCK_CNT, 13, 10)
    FIELD(VPLL_CFG, LFHF, 10, 2)
    FIELD(VPLL_CFG, CP, 5, 4)
    FIELD(VPLL_CFG, RES, 0, 4)
REG32(VPLL_FRAC_CFG, 0x40)
    FIELD(VPLL_FRAC_CFG, ENABLED, 31, 1)
    FIELD(VPLL_FRAC_CFG, SEED, 22, 3)
    FIELD(VPLL_FRAC_CFG, ALGRTHM, 19, 1)
    FIELD(VPLL_FRAC_CFG, ORDER, 18, 1)
    FIELD(VPLL_FRAC_CFG, DATA, 0, 16)
REG32(PLL_STATUS, 0x44)
    FIELD(PLL_STATUS, VPLL_STABLE, 5, 1)
    FIELD(PLL_STATUS, DPLL_STABLE, 4, 1)
    FIELD(PLL_STATUS, APLL_STABLE, 3, 1)
    FIELD(PLL_STATUS, VPLL_LOCK, 2, 1)
    FIELD(PLL_STATUS, DPLL_LOCK, 1, 1)
    FIELD(PLL_STATUS, APLL_LOCK, 0, 1)
REG32(APLL_TO_LPD_CTRL, 0x48)
    FIELD(APLL_TO_LPD_CTRL, DIVISOR0, 8, 6)
REG32(DPLL_TO_LPD_CTRL, 0x4c)
    FIELD(DPLL_TO_LPD_CTRL, DIVISOR0, 8, 6)
REG32(VPLL_TO_LPD_CTRL, 0x50)
    FIELD(VPLL_TO_LPD_CTRL, DIVISOR0, 8, 6)
REG32(ACPU_CTRL, 0x60)
    FIELD(ACPU_CTRL, CLKACT_HALF, 25, 1)
    FIELD(ACPU_CTRL, CLKACT_FULL, 24, 1)
    FIELD(ACPU_CTRL, DIVISOR0, 8, 6)
    FIELD(ACPU_CTRL, SRCSEL, 0, 3)
REG32(DBG_TRACE_CTRL, 0x64)
    FIELD(DBG_TRACE_CTRL, CLKACT, 24, 1)
    FIELD(DBG_TRACE_CTRL, DIVISOR0, 8, 6)
    FIELD(DBG_TRACE_CTRL, SRCSEL, 0, 3)
REG32(DBG_FPD_CTRL, 0x68)
    FIELD(DBG_FPD_CTRL, CLKACT, 24, 1)
    FIELD(DBG_FPD_CTRL, DIVISOR0, 8, 6)
    FIELD(DBG_FPD_CTRL, SRCSEL, 0, 3)
REG32(DP_VIDEO_REF_CTRL, 0x70)
    FIELD(DP_VIDEO_REF_CTRL, CLKACT, 24, 1)
    FIELD(DP_VIDEO_REF_CTRL, DIVISOR1, 16, 6)
    FIELD(DP_VIDEO_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(DP_VIDEO_REF_CTRL, SRCSEL, 0, 3)
REG32(DP_AUDIO_REF_CTRL, 0x74)
    FIELD(DP_AUDIO_REF_CTRL, CLKACT, 24, 1)
    FIELD(DP_AUDIO_REF_CTRL, DIVISOR1, 16, 6)
    FIELD(DP_AUDIO_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(DP_AUDIO_REF_CTRL, SRCSEL, 0, 3)
REG32(DP_STC_REF_CTRL, 0x7c)
    FIELD(DP_STC_REF_CTRL, CLKACT, 24, 1)
    FIELD(DP_STC_REF_CTRL, DIVISOR1, 16, 6)
    FIELD(DP_STC_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(DP_STC_REF_CTRL, SRCSEL, 0, 3)
REG32(DDR_CTRL, 0x80)
    FIELD(DDR_CTRL, CLKACT, 24, 1)
    FIELD(DDR_CTRL, DIVISOR0, 8, 6)
    FIELD(DDR_CTRL, SRCSEL, 0, 3)
REG32(GPU_REF_CTRL, 0x84)
    FIELD(GPU_REF_CTRL, PP1_CLKACT, 26, 1)
    FIELD(GPU_REF_CTRL, PP0_CLKACT, 25, 1)
    FIELD(GPU_REF_CTRL, CLKACT, 24, 1)
    FIELD(GPU_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(GPU_REF_CTRL, SRCSEL, 0, 3)
REG32(SATA_REF_CTRL, 0xa0)
    FIELD(SATA_REF_CTRL, CLKACT, 24, 1)
    FIELD(SATA_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(SATA_REF_CTRL, SRCSEL, 0, 3)
REG32(PCIE_REF_CTRL, 0xb4)
    FIELD(PCIE_REF_CTRL, CLKACT, 24, 1)
    FIELD(PCIE_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(PCIE_REF_CTRL, SRCSEL, 0, 3)
REG32(GDMA_REF_CTRL, 0xb8)
    FIELD(GDMA_REF_CTRL, CLKACT, 24, 1)
    FIELD(GDMA_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(GDMA_REF_CTRL, SRCSEL, 0, 3)
REG32(DPDMA_REF_CTRL, 0xbc)
    FIELD(DPDMA_REF_CTRL, CLKACT, 24, 1)
    FIELD(DPDMA_REF_CTRL, DIVISOR0, 8, 6)
    FIELD(DPDMA_REF_CTRL, SRCSEL, 0, 3)
REG32(TOPSW_MAIN_CTRL, 0xc0)
    FIELD(TOPSW_MAIN_CTRL, CLKACT, 24, 1)
    FIELD(TOPSW_MAIN_CTRL, DIVISOR0, 8, 6)
    FIELD(TOPSW_MAIN_CTRL, SRCSEL, 0, 3)
REG32(TOPSW_LSBUS_CTRL, 0xc4)
    FIELD(TOPSW_LSBUS_CTRL, CLKACT, 24, 1)
    FIELD(TOPSW_LSBUS_CTRL, DIVISOR0, 8, 6)
    FIELD(TOPSW_LSBUS_CTRL, SRCSEL, 0, 3)
REG32(DBG_TSTMP_CTRL, 0xf8)
    FIELD(DBG_TSTMP_CTRL, DIVISOR0, 8, 6)
    FIELD(DBG_TSTMP_CTRL, SRCSEL, 0, 3)
REG32(RST_FPD_TOP, 0x100)
    FIELD(RST_FPD_TOP, PCIE_CFG_RESET, 19, 1)
    FIELD(RST_FPD_TOP, PCIE_BRIDGE_RESET, 18, 1)
    FIELD(RST_FPD_TOP, PCIE_CTRL_RESET, 17, 1)
    FIELD(RST_FPD_TOP, DP_RESET, 16, 1)
    FIELD(RST_FPD_TOP, SWDT_RESET, 15, 1)
    FIELD(RST_FPD_TOP, AFI_FM5_RESET, 12, 1)
    FIELD(RST_FPD_TOP, AFI_FM4_RESET, 11, 1)
    FIELD(RST_FPD_TOP, AFI_FM3_RESET, 10, 1)
    FIELD(RST_FPD_TOP, AFI_FM2_RESET, 9, 1)
    FIELD(RST_FPD_TOP, AFI_FM1_RESET, 8, 1)
    FIELD(RST_FPD_TOP, AFI_FM0_RESET, 7, 1)
    FIELD(RST_FPD_TOP, GDMA_RESET, 6, 1)
    FIELD(RST_FPD_TOP, GPU_PP1_RESET, 5, 1)
    FIELD(RST_FPD_TOP, GPU_PP0_RESET, 4, 1)
    FIELD(RST_FPD_TOP, GPU_RESET, 3, 1)
    FIELD(RST_FPD_TOP, GT_RESET, 2, 1)
    FIELD(RST_FPD_TOP, SATA_RESET, 1, 1)
REG32(RST_FPD_APU, 0x104)
    FIELD(RST_FPD_APU, ACPU3_PWRON_RESET, 13, 1)
    FIELD(RST_FPD_APU, ACPU2_PWRON_RESET, 12, 1)
    FIELD(RST_FPD_APU, ACPU1_PWRON_RESET, 11, 1)
    FIELD(RST_FPD_APU, ACPU0_PWRON_RESET, 10, 1)
    FIELD(RST_FPD_APU, APU_L2_RESET, 8, 1)
    FIELD(RST_FPD_APU, ACPU3_RESET, 3, 1)
    FIELD(RST_FPD_APU, ACPU2_RESET, 2, 1)
    FIELD(RST_FPD_APU, ACPU1_RESET, 1, 1)
    FIELD(RST_FPD_APU, ACPU0_RESET, 0, 1)
REG32(RST_DDR_SS, 0x108)
    FIELD(RST_DDR_SS, DDR_RESET, 3, 1)
    FIELD(RST_DDR_SS, APM_RESET, 2, 1)

#define R_MAX (R_RST_DDR_SS + 1)

#define APU_MAX_CPU    4

typedef struct CRF_APB {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir;
    bool linux_direct_boot;

    qemu_irq acpu_rst[APU_MAX_CPU];
    uint32_t regs[R_MAX];
    RegisterInfo regs_info[R_MAX];
} CRF_APB;

static void ir_update_irq(CRF_APB *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    CRF_APB *s = XILINX_CRF_APB(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    CRF_APB *s = XILINX_CRF_APB(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    CRF_APB *s = XILINX_CRF_APB(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static uint64_t rst_fpd_apu_prew(RegisterInfo *reg, uint64_t val64)
{
    CRF_APB *s = XILINX_CRF_APB(reg->opaque);
    uint32_t val = val64;
    uint32_t val_old = s->regs[R_RST_FPD_APU];
    unsigned int i;

    for (i = 0; i < APU_MAX_CPU; i++) {
        /* Update irq's only when changed */
        uint32_t mask = (1 << (R_RST_FPD_APU_ACPU0_RESET_SHIFT + i));
        if ((val ^ val_old) & mask) {
            qemu_set_irq(s->acpu_rst[i], !!(val & mask));
        }
    }
    return val64;
}

static const RegisterAccessInfo crf_apb_regs_info[] = {
    {   .name = "ERR_CTRL",  .addr = A_ERR_CTRL,
    },{ .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .w1c = 0x1,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .pre_write = ir_disable_prew,
    },{ .name = "CRF_WPROT",  .addr = A_CRF_WPROT,
    },{ .name = "APLL_CTRL",  .addr = A_APLL_CTRL,
        .reset = 0x12c09,
        .rsvd = 0xf88c80f6,
    },{ .name = "APLL_CFG",  .addr = A_APLL_CFG,
        .rsvd = 0x1801210,
    },{ .name = "APLL_FRAC_CFG",  .addr = A_APLL_FRAC_CFG,
        .rsvd = 0x7e330000,
    },{ .name = "DPLL_CTRL",  .addr = A_DPLL_CTRL,
        .reset = 0x2c09,
        .rsvd = 0xf88c80f6,
    },{ .name = "DPLL_CFG",  .addr = A_DPLL_CFG,
        .rsvd = 0x1801210,
    },{ .name = "DPLL_FRAC_CFG",  .addr = A_DPLL_FRAC_CFG,
        .rsvd = 0x7e330000,
    },{ .name = "VPLL_CTRL",  .addr = A_VPLL_CTRL,
        .reset = 0x12809,
        .rsvd = 0xf88c80f6,
    },{ .name = "VPLL_CFG",  .addr = A_VPLL_CFG,
        .rsvd = 0x1801210,
    },{ .name = "VPLL_FRAC_CFG",  .addr = A_VPLL_FRAC_CFG,
        .rsvd = 0x7e330000,
    },{ .name = "PLL_STATUS",  .addr = A_PLL_STATUS,
        .reset = 0x3f,
        .rsvd = 0xc0,
        .ro = 0x3f,
    },{ .name = "APLL_TO_LPD_CTRL",  .addr = A_APLL_TO_LPD_CTRL,
        .reset = 0x400,
        .rsvd = 0xc0ff,
    },{ .name = "DPLL_TO_LPD_CTRL",  .addr = A_DPLL_TO_LPD_CTRL,
        .reset = 0x400,
        .rsvd = 0xc0ff,
    },{ .name = "VPLL_TO_LPD_CTRL",  .addr = A_VPLL_TO_LPD_CTRL,
        .reset = 0x400,
        .rsvd = 0xc0ff,
    },{ .name = "ACPU_CTRL",  .addr = A_ACPU_CTRL,
        .reset = 0x3000400,
        .rsvd = 0xfcffc0f8,
    },{ .name = "DBG_TRACE_CTRL",  .addr = A_DBG_TRACE_CTRL,
        .reset = 0x2500,
        .rsvd = 0xfeffc0f8,
    },{ .name = "DBG_FPD_CTRL",  .addr = A_DBG_FPD_CTRL,
        .reset = 0x1002500,
        .rsvd = 0xfeffc0f8,
    },{ .name = "DP_VIDEO_REF_CTRL",  .addr = A_DP_VIDEO_REF_CTRL,
        .reset = 0x1002300,
        .rsvd = 0xfec0c0f8,
    },{ .name = "DP_AUDIO_REF_CTRL",  .addr = A_DP_AUDIO_REF_CTRL,
        .reset = 0x1032300,
        .rsvd = 0xfec0c0f8,
    },{ .name = "DP_STC_REF_CTRL",  .addr = A_DP_STC_REF_CTRL,
        .reset = 0x1203200,
        .rsvd = 0xfec0c0f8,
    },{ .name = "DDR_CTRL",  .addr = A_DDR_CTRL,
        .reset = 0x1000500,
        .rsvd = 0xfeffc0f8,
    },{ .name = "GPU_REF_CTRL",  .addr = A_GPU_REF_CTRL,
        .reset = 0x1500,
        .rsvd = 0xf8ffc0f8,
    },{ .name = "SATA_REF_CTRL",  .addr = A_SATA_REF_CTRL,
        .reset = 0x1001600,
        .rsvd = 0xfeffc0f8,
    },{ .name = "PCIE_REF_CTRL",  .addr = A_PCIE_REF_CTRL,
        .reset = 0x1500,
        .rsvd = 0xfeffc0f8,
    },{ .name = "GDMA_REF_CTRL",  .addr = A_GDMA_REF_CTRL,
        .reset = 0x1000500,
        .rsvd = 0xfeffc0f8,
    },{ .name = "DPDMA_REF_CTRL",  .addr = A_DPDMA_REF_CTRL,
        .reset = 0x1000500,
        .rsvd = 0xfeffc0f8,
    },{ .name = "TOPSW_MAIN_CTRL",  .addr = A_TOPSW_MAIN_CTRL,
        .reset = 0x1000400,
        .rsvd = 0xfeffc0f8,
    },{ .name = "TOPSW_LSBUS_CTRL",  .addr = A_TOPSW_LSBUS_CTRL,
        .reset = 0x1000800,
        .rsvd = 0xfeffc0f8,
    },{ .name = "DBG_TSTMP_CTRL",  .addr = A_DBG_TSTMP_CTRL,
        .reset = 0xa00,
        .rsvd = 0xffffc0f8,
    },
    {   .name = "RST_FPD_TOP",  .addr = A_RST_FPD_TOP,
        .reset = 0xf9ffe,
        .rsvd = 0xf06001,
    },{ .name = "RST_FPD_APU",  .addr = A_RST_FPD_APU,
        .reset = 0x3d0f,
        .rsvd = 0xc2f0,
        .pre_write = rst_fpd_apu_prew,
    },{ .name = "RST_DDR_SS",  .addr = A_RST_DDR_SS,
        .reset = 0xf,
        .rsvd = 0xf3,
    }
};

static void crf_apb_reset(DeviceState *dev)
{
    CRF_APB *s = XILINX_CRF_APB(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    if (!s->linux_direct_boot) {
        /*
         * Set A53's in reset
         */
        for (i = 0; i < APU_MAX_CPU; i++) {
            qemu_set_irq(s->acpu_rst[i], 1);
        }
    }

    ir_update_irq(s);
}

static void crf_linux_boot_if_init(ARMLinuxBootIf *obj, bool secure_boot)
{
    CRF_APB *s = XILINX_CRF_APB(obj);

    s->linux_direct_boot = true;
}


static const MemoryRegionOps crf_apb_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void crf_apb_realize(DeviceState *dev, Error **errp)
{
    CRF_APB *s = XILINX_CRF_APB(dev);

    qdev_init_gpio_out_named(dev, s->acpu_rst, "RST_A9", APU_MAX_CPU);
}

static void crf_apb_init(Object *obj)
{
    CRF_APB *s = XILINX_CRF_APB(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_CRF_APB, R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), crf_apb_regs_info,
                              ARRAY_SIZE(crf_apb_regs_info),
                              s->regs_info, s->regs,
                              &crf_apb_ops,
                              XILINX_CRF_APB_ERR_DEBUG,
                              R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir);
}

static const VMStateDescription vmstate_crf_apb = {
    .name = TYPE_XILINX_CRF_APB,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, CRF_APB, R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet crf_gpios[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
            { .name = "RST_A9",   .fdt_index = 0,   .range = 4 },
            { },
        }
    },
    { },
};

static void crf_apb_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);
    ARMLinuxBootIfClass *albifc = ARM_LINUX_BOOT_IF_CLASS(klass);

    dc->reset = crf_apb_reset;
    dc->realize = crf_apb_realize;
    dc->vmsd = &vmstate_crf_apb;
    fggc->controller_gpios = crf_gpios;
    albifc->arm_linux_init = crf_linux_boot_if_init;
}

static const TypeInfo crf_apb_info = {
    .name          = TYPE_XILINX_CRF_APB,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(CRF_APB),
    .class_init    = crf_apb_class_init,
    .instance_init = crf_apb_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { TYPE_ARM_LINUX_BOOT_IF },
        { }
    },
};

static void crf_apb_register_types(void)
{
    type_register_static(&crf_apb_info);
}

type_init(crf_apb_register_types)
