/*
 * QEMU model of the PSXC_AFI_FS AFI FS Control and status registers
 *
 * Copyright (c) 2024 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2024-11-27.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_PSXC_AFI_FS_ERR_DEBUG
#define XILINX_PSXC_AFI_FS_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSXC_AFI_FS "xlnx.psxc_afi_fs"

#define XILINX_PSXC_AFI_FS(obj) \
     OBJECT_CHECK(PSXC_AFI_FS, (obj), TYPE_XILINX_PSXC_AFI_FS)

REG32(CORRECTABLE_TOP_ERROR_SOURCE_STATUS, 0x0)
    FIELD(CORRECTABLE_TOP_ERROR_SOURCE_STATUS,
          CORRECTABLE_ERROR_SOURCE_STATUS, 0, 1)
REG32(CORRECTABLE_ERROR_SOURCE_STATUS, 0x4)
    FIELD(CORRECTABLE_ERROR_SOURCE_STATUS, FIREWALL_INT_ERR, 3, 1)
    FIELD(CORRECTABLE_ERROR_SOURCE_STATUS, PL_INT_ERR, 2, 1)
    FIELD(CORRECTABLE_ERROR_SOURCE_STATUS, PS_INT_ERR, 1, 1)
    FIELD(CORRECTABLE_ERROR_SOURCE_STATUS, APB_INT_ERR, 0, 1)
REG32(UNCORRECTABLE_TOP_ERROR_SOURCE_STATUS, 0x1000)
    FIELD(UNCORRECTABLE_TOP_ERROR_SOURCE_STATUS,
          UNCORRECTABLE_ERROR_SOURCE_STATUS, 0, 1)
REG32(UNCORRECTABLE_ERROR_SOURCE_STATUS, 0x1004)
    FIELD(UNCORRECTABLE_ERROR_SOURCE_STATUS, FIREWALL_INT_ERR, 3, 1)
    FIELD(UNCORRECTABLE_ERROR_SOURCE_STATUS, PL_INT_ERR, 2, 1)
    FIELD(UNCORRECTABLE_ERROR_SOURCE_STATUS, PS_INT_ERR, 1, 1)
    FIELD(UNCORRECTABLE_ERROR_SOURCE_STATUS, APB_INT_ERR, 0, 1)
REG32(TOP_INTERRUPT_SOURCE_STATUS, 0x2000)
    FIELD(TOP_INTERRUPT_SOURCE_STATUS, INTERRUPT_SOURCE_STATUS, 0, 1)
REG32(INTERRUPT_SOURCE_STATUS, 0x2004)
    FIELD(INTERRUPT_SOURCE_STATUS, PL_INT_IRQ, 2, 1)
    FIELD(INTERRUPT_SOURCE_STATUS, PS_INT_IRQ, 1, 1)
    FIELD(INTERRUPT_SOURCE_STATUS, APB_INT_IRQ, 0, 1)
REG32(SAFETY_CHK, 0x3000)
REG32(SLVERR, 0x3004)
REG32(AFI_FS_MAIN_CONFIG, 0x3008)
    FIELD(AFI_FS_MAIN_CONFIG, XMPU_ALIGN_CFG, 4, 1)
    FIELD(AFI_FS_MAIN_CONFIG, FABRIC_PARITY_EN, 3, 1)
    FIELD(AFI_FS_MAIN_CONFIG, FABRIC_WIDTH, 1, 2)
    FIELD(AFI_FS_MAIN_CONFIG, FABRIC_PORT_ENABLE, 0, 1)
REG32(AFI_FS_CNTL_PARITY_INJ, 0x300c)
    FIELD(AFI_FS_CNTL_PARITY_INJ, PARITY_INJ_BYTE, 4, 5)
    FIELD(AFI_FS_CNTL_PARITY_INJ, PARITY_INJ_BIT, 0, 4)
REG32(FIREWALL_CNTL_ERR_TYPE, 0x3010)
    FIELD(FIREWALL_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(TEST_MODE_CFG, 0x3014)
    FIELD(TEST_MODE_CFG, TEST_CTRL_EN, 0, 1)
REG32(APB_INT_MERB_CNTL_MAIN, 0x4000)
    FIELD(APB_INT_MERB_CNTL_MAIN, TIMEOUT_EN, 0, 1)
REG32(APB_INT_MERB_CNTL_QOS, 0x4004)
REG32(APB_INT_MERB_CNTL_ROUTING, 0x4008)
REG32(APB_INT_MERB_CNTL_ISOLATION, 0x400c)
    FIELD(APB_INT_MERB_CNTL_ISOLATION, IDLEREQ, 1, 1)
    FIELD(APB_INT_MERB_CNTL_ISOLATION, SOFT_RST_N, 0, 1)
REG32(APB_INT_MERB_CNTL_ERR_TYPE, 0x4010)
    FIELD(APB_INT_MERB_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(APB_INT_MERB_INTF_CNTL_ERR_TYPE0, 0x4014)
    FIELD(APB_INT_MERB_INTF_CNTL_ERR_TYPE0, ERR_CORR, 0, 1)
REG32(APB_INT_MERB_INTF_CNTL_ERR_TYPE1, 0x4018)
    FIELD(APB_INT_MERB_INTF_CNTL_ERR_TYPE1, ERR_CORR, 0, 1)
REG32(APB_INT_MERB_INTF_CNTL_ERR_TYPE2, 0x401c)
    FIELD(APB_INT_MERB_INTF_CNTL_ERR_TYPE2, ERR_CORR, 0, 1)
REG32(APB_INT_MERB_INTF_CNTL_INTF_TEST_EN0, 0x4054)
    FIELD(APB_INT_MERB_INTF_CNTL_INTF_TEST_EN0, PARITY_ERR_INJ_EN, 0, 1)
REG32(APB_INT_MERB_INTF_CNTL_INTF_TEST_EN1, 0x4058)
    FIELD(APB_INT_MERB_INTF_CNTL_INTF_TEST_EN1, PARITY_ERR_INJ_EN, 0, 1)
REG32(APB_INT_MERB_INTF_CNTL_INTF_TEST_EN2, 0x405c)
    FIELD(APB_INT_MERB_INTF_CNTL_INTF_TEST_EN2, PARITY_ERR_INJ_EN, 0, 1)
REG32(APB_INT_MERB_STATUS_ISOLATION, 0x4074)
    FIELD(APB_INT_MERB_STATUS_ISOLATION, NO_PENDING_TRANS, 2, 1)
    FIELD(APB_INT_MERB_STATUS_ISOLATION, IDLE, 1, 1)
    FIELD(APB_INT_MERB_STATUS_ISOLATION, IDLEACK, 0, 1)
REG32(APB_INT_MERB_ERROR_SOURCE_STATUS, 0x4078)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, IP2_INTERFACE_ERR_TYPE, 26, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, IP1_INTERFACE_ERR_TYPE, 25, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, IP0_INTERFACE_ERR_TYPE, 24, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, IP2_INTERFACE_ERR, 18, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, IP1_INTERFACE_ERR, 17, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, IP0_INTERFACE_ERR, 16, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, ERB_ERROR_TYPE, 1, 1)
    FIELD(APB_INT_MERB_ERROR_SOURCE_STATUS, ERB_ERROR, 0, 1)
REG32(APB_INT_MERB_ERROR_ISR, 0x407c)
    FIELD(APB_INT_MERB_ERROR_ISR, TIMEOUT, 16, 1)
    FIELD(APB_INT_MERB_ERROR_ISR, MISSION, 0, 1)
REG32(APB_INT_MERB_ERROR_IMR, 0x4080)
    FIELD(APB_INT_MERB_ERROR_IMR, TIMEOUT, 16, 1)
    FIELD(APB_INT_MERB_ERROR_IMR, MISSION, 0, 1)
REG32(APB_INT_MERB_ERROR_IER, 0x4084)
    FIELD(APB_INT_MERB_ERROR_IER, TIMEOUT, 16, 1)
    FIELD(APB_INT_MERB_ERROR_IER, MISSION, 0, 1)
REG32(APB_INT_MERB_ERROR_IDR, 0x4088)
    FIELD(APB_INT_MERB_ERROR_IDR, TIMEOUT, 16, 1)
    FIELD(APB_INT_MERB_ERROR_IDR, MISSION, 0, 1)
REG32(APB_INT_MERB_INTERRUPT_ISR, 0x4090)
    FIELD(APB_INT_MERB_INTERRUPT_ISR, LATENT, 0, 1)
REG32(APB_INT_MERB_INTERRUPT_IMR, 0x4094)
    FIELD(APB_INT_MERB_INTERRUPT_IMR, LATENT, 0, 1)
REG32(APB_INT_MERB_INTERRUPT_IER, 0x4098)
    FIELD(APB_INT_MERB_INTERRUPT_IER, LATENT, 0, 1)
REG32(APB_INT_MERB_INTERRUPT_IDR, 0x409c)
    FIELD(APB_INT_MERB_INTERRUPT_IDR, LATENT, 0, 1)
REG32(APB_INT_MERB_INTF_ERROR_ISR0, 0x40a4)
    FIELD(APB_INT_MERB_INTF_ERROR_ISR0, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IMR0, 0x40a8)
    FIELD(APB_INT_MERB_INTF_ERROR_IMR0, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IER0, 0x40ac)
    FIELD(APB_INT_MERB_INTF_ERROR_IER0, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IDR0, 0x40b0)
    FIELD(APB_INT_MERB_INTF_ERROR_IDR0, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_ISR1, 0x40b8)
    FIELD(APB_INT_MERB_INTF_ERROR_ISR1, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IMR1, 0x40bc)
    FIELD(APB_INT_MERB_INTF_ERROR_IMR1, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IER1, 0x40c0)
    FIELD(APB_INT_MERB_INTF_ERROR_IER1, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IDR1, 0x40c4)
    FIELD(APB_INT_MERB_INTF_ERROR_IDR1, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_ISR2, 0x40cc)
    FIELD(APB_INT_MERB_INTF_ERROR_ISR2, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IMR2, 0x40d0)
    FIELD(APB_INT_MERB_INTF_ERROR_IMR2, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IER2, 0x40d4)
    FIELD(APB_INT_MERB_INTF_ERROR_IER2, PARITY_ERR, 8, 1)
REG32(APB_INT_MERB_INTF_ERROR_IDR2, 0x40d8)
    FIELD(APB_INT_MERB_INTF_ERROR_IDR2, PARITY_ERR, 8, 1)
REG32(DTP_MERB_CNTL_MAIN, 0x5000)
    FIELD(DTP_MERB_CNTL_MAIN, TIMEOUT_EN, 0, 1)
REG32(DTP_MERB_CNTL_ISOLATION, 0x500c)
    FIELD(DTP_MERB_CNTL_ISOLATION, IDLEREQ, 1, 1)
    FIELD(DTP_MERB_CNTL_ISOLATION, SOFT_RST_N, 0, 1)
REG32(DTP_MERB_CNTL_ERR_TYPE, 0x5010)
    FIELD(DTP_MERB_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(DTP_MERB_STATUS_ISOLATION, 0x5074)
    FIELD(DTP_MERB_STATUS_ISOLATION, NO_PENDING_TRANS, 2, 1)
    FIELD(DTP_MERB_STATUS_ISOLATION, IDLE, 1, 1)
    FIELD(DTP_MERB_STATUS_ISOLATION, IDLEACK, 0, 1)
REG32(DTP_MERB_ERROR_SOURCE_STATUS, 0x5078)
    FIELD(DTP_MERB_ERROR_SOURCE_STATUS, IP0_INTERFACE_ERR_TYPE, 24, 1)
    FIELD(DTP_MERB_ERROR_SOURCE_STATUS, IP0_INTERFACE_ERR, 16, 1)
    FIELD(DTP_MERB_ERROR_SOURCE_STATUS, ERB_ERROR_TYPE, 1, 1)
    FIELD(DTP_MERB_ERROR_SOURCE_STATUS, ERB_ERROR, 0, 1)
REG32(DTP_MERB_ERROR_ISR, 0x507c)
    FIELD(DTP_MERB_ERROR_ISR, TIMEOUT_RD, 17, 1)
    FIELD(DTP_MERB_ERROR_ISR, TIMEOUT_WR, 16, 1)
    FIELD(DTP_MERB_ERROR_ISR, MISSION, 0, 1)
REG32(DTP_MERB_ERROR_IMR, 0x5080)
    FIELD(DTP_MERB_ERROR_IMR, TIMEOUT_RD, 17, 1)
    FIELD(DTP_MERB_ERROR_IMR, TIMEOUT_WR, 16, 1)
    FIELD(DTP_MERB_ERROR_IMR, MISSION, 0, 1)
REG32(DTP_MERB_ERROR_IER, 0x5084)
    FIELD(DTP_MERB_ERROR_IER, TIMEOUT_RD, 17, 1)
    FIELD(DTP_MERB_ERROR_IER, TIMEOUT_WR, 16, 1)
    FIELD(DTP_MERB_ERROR_IER, MISSION, 0, 1)
REG32(DTP_MERB_ERROR_IDR, 0x5088)
    FIELD(DTP_MERB_ERROR_IDR, TIMEOUT_RD, 17, 1)
    FIELD(DTP_MERB_ERROR_IDR, TIMEOUT_WR, 16, 1)
    FIELD(DTP_MERB_ERROR_IDR, MISSION, 0, 1)
REG32(DTP_MERB_INTERRUPT_ISR, 0x5090)
    FIELD(DTP_MERB_INTERRUPT_ISR, LATENT, 0, 1)
REG32(DTP_MERB_INTERRUPT_IMR, 0x5094)
    FIELD(DTP_MERB_INTERRUPT_IMR, LATENT, 0, 1)
REG32(DTP_MERB_INTERRUPT_IER, 0x5098)
    FIELD(DTP_MERB_INTERRUPT_IER, LATENT, 0, 1)
REG32(DTP_MERB_INTERRUPT_IDR, 0x509c)
    FIELD(DTP_MERB_INTERRUPT_IDR, LATENT, 0, 1)
REG32(DTP_SERB_CNTL_MAIN, 0x6000)
    FIELD(DTP_SERB_CNTL_MAIN, TIMEOUT_EN, 0, 1)
REG32(DTP_SERB_CNTL_ISOLATION, 0x600c)
    FIELD(DTP_SERB_CNTL_ISOLATION, IDLEREQ, 1, 1)
    FIELD(DTP_SERB_CNTL_ISOLATION, SOFT_RST_N, 0, 1)
REG32(DTP_SERB_CNTL_ERR_TYPE, 0x6010)
    FIELD(DTP_SERB_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(DTP_SERB_INTF_CNTL_ERR_TYPE0, 0x6014)
    FIELD(DTP_SERB_INTF_CNTL_ERR_TYPE0, ERR_CORR, 0, 1)
REG32(DTP_SERB_INTF_CNTL_INTF_TEST_EN0, 0x6054)
    FIELD(DTP_SERB_INTF_CNTL_INTF_TEST_EN0, PARITY_ERR_INJ_EN, 0, 1)
REG32(DTP_SERB_STATUS_ISOLATION, 0x6074)
    FIELD(DTP_SERB_STATUS_ISOLATION, NO_PENDING_TRANS, 2, 1)
    FIELD(DTP_SERB_STATUS_ISOLATION, IDLE, 1, 1)
    FIELD(DTP_SERB_STATUS_ISOLATION, IDLEACK, 0, 1)
REG32(DTP_SERB_ERROR_SOURCE_STATUS, 0x6078)
    FIELD(DTP_SERB_ERROR_SOURCE_STATUS, IP0_INTERFACE_ERR_TYPE, 24, 1)
    FIELD(DTP_SERB_ERROR_SOURCE_STATUS, IP0_INTERFACE_ERR, 16, 1)
    FIELD(DTP_SERB_ERROR_SOURCE_STATUS, ERB_ERROR_TYPE, 1, 1)
    FIELD(DTP_SERB_ERROR_SOURCE_STATUS, ERB_ERROR, 0, 1)
REG32(DTP_SERB_ERROR_ISR, 0x607c)
    FIELD(DTP_SERB_ERROR_ISR, TIMEOUT_RD, 17, 1)
    FIELD(DTP_SERB_ERROR_ISR, TIMEOUT_WR, 16, 1)
    FIELD(DTP_SERB_ERROR_ISR, MISSION, 0, 1)
REG32(DTP_SERB_ERROR_IMR, 0x6080)
    FIELD(DTP_SERB_ERROR_IMR, TIMEOUT_RD, 17, 1)
    FIELD(DTP_SERB_ERROR_IMR, TIMEOUT_WR, 16, 1)
    FIELD(DTP_SERB_ERROR_IMR, MISSION, 0, 1)
REG32(DTP_SERB_ERROR_IER, 0x6084)
    FIELD(DTP_SERB_ERROR_IER, TIMEOUT_RD, 17, 1)
    FIELD(DTP_SERB_ERROR_IER, TIMEOUT_WR, 16, 1)
    FIELD(DTP_SERB_ERROR_IER, MISSION, 0, 1)
REG32(DTP_SERB_ERROR_IDR, 0x6088)
    FIELD(DTP_SERB_ERROR_IDR, TIMEOUT_RD, 17, 1)
    FIELD(DTP_SERB_ERROR_IDR, TIMEOUT_WR, 16, 1)
    FIELD(DTP_SERB_ERROR_IDR, MISSION, 0, 1)
REG32(DTP_SERB_INTERRUPT_ISR, 0x6090)
    FIELD(DTP_SERB_INTERRUPT_ISR, LATENT, 0, 1)
REG32(DTP_SERB_INTERRUPT_IMR, 0x6094)
    FIELD(DTP_SERB_INTERRUPT_IMR, LATENT, 0, 1)
REG32(DTP_SERB_INTERRUPT_IER, 0x6098)
    FIELD(DTP_SERB_INTERRUPT_IER, LATENT, 0, 1)
REG32(DTP_SERB_INTERRUPT_IDR, 0x609c)
    FIELD(DTP_SERB_INTERRUPT_IDR, LATENT, 0, 1)
REG32(DTP_SERB_INTF_ERROR_ISR0, 0x60a4)
    FIELD(DTP_SERB_INTF_ERROR_ISR0, PARITY_ERR_REGSLICE, 24, 1)
    FIELD(DTP_SERB_INTF_ERROR_ISR0, PARITY_ERR_B, 12, 1)
    FIELD(DTP_SERB_INTF_ERROR_ISR0, PARITY_ERR_R, 11, 1)
    FIELD(DTP_SERB_INTF_ERROR_ISR0, PARITY_ERR_W, 10, 1)
    FIELD(DTP_SERB_INTF_ERROR_ISR0, PARITY_ERR_AR, 9, 1)
    FIELD(DTP_SERB_INTF_ERROR_ISR0, PARITY_ERR_AW, 8, 1)
REG32(DTP_SERB_INTF_ERROR_IMR0, 0x60a8)
    FIELD(DTP_SERB_INTF_ERROR_IMR0, PARITY_ERR_REGSLICE, 24, 1)
    FIELD(DTP_SERB_INTF_ERROR_IMR0, PARITY_ERR_B, 12, 1)
    FIELD(DTP_SERB_INTF_ERROR_IMR0, PARITY_ERR_R, 11, 1)
    FIELD(DTP_SERB_INTF_ERROR_IMR0, PARITY_ERR_W, 10, 1)
    FIELD(DTP_SERB_INTF_ERROR_IMR0, PARITY_ERR_AR, 9, 1)
    FIELD(DTP_SERB_INTF_ERROR_IMR0, PARITY_ERR_AW, 8, 1)
REG32(DTP_SERB_INTF_ERROR_IER0, 0x60ac)
    FIELD(DTP_SERB_INTF_ERROR_IER0, PARITY_ERR_REGSLICE, 24, 1)
    FIELD(DTP_SERB_INTF_ERROR_IER0, PARITY_ERR_B, 12, 1)
    FIELD(DTP_SERB_INTF_ERROR_IER0, PARITY_ERR_R, 11, 1)
    FIELD(DTP_SERB_INTF_ERROR_IER0, PARITY_ERR_W, 10, 1)
    FIELD(DTP_SERB_INTF_ERROR_IER0, PARITY_ERR_AR, 9, 1)
    FIELD(DTP_SERB_INTF_ERROR_IER0, PARITY_ERR_AW, 8, 1)
REG32(DTP_SERB_INTF_ERROR_IDR0, 0x60b0)
    FIELD(DTP_SERB_INTF_ERROR_IDR0, PARITY_ERR_REGSLICE, 24, 1)
    FIELD(DTP_SERB_INTF_ERROR_IDR0, PARITY_ERR_B, 12, 1)
    FIELD(DTP_SERB_INTF_ERROR_IDR0, PARITY_ERR_R, 11, 1)
    FIELD(DTP_SERB_INTF_ERROR_IDR0, PARITY_ERR_W, 10, 1)
    FIELD(DTP_SERB_INTF_ERROR_IDR0, PARITY_ERR_AR, 9, 1)
    FIELD(DTP_SERB_INTF_ERROR_IDR0, PARITY_ERR_AW, 8, 1)

#define PSXC_AFI_FS_R_MAX (R_DTP_SERB_INTF_ERROR_IDR0 + 1)

typedef struct PSXC_AFI_FS {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_apb_int_merb_intf_error_imr0;
    qemu_irq irq_apb_int_merb_interrupt_imr;
    qemu_irq irq_apb_int_merb_intf_error_imr2;
    qemu_irq irq_apb_int_merb_intf_error_imr1;
    qemu_irq irq_dtp_merb_interrupt_imr;
    qemu_irq irq_apb_int_merb_error_imr;
    qemu_irq irq_dtp_serb_intf_error_imr0;
    qemu_irq irq_dtp_serb_interrupt_imr;
    qemu_irq irq_dtp_merb_error_imr;
    qemu_irq irq_dtp_serb_error_imr;

    uint32_t regs[PSXC_AFI_FS_R_MAX];
    RegisterInfo regs_info[PSXC_AFI_FS_R_MAX];
} PSXC_AFI_FS;

static void apb_int_merb_intf_error_imr0_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_APB_INT_MERB_INTF_ERROR_ISR0] &
                   ~s->regs[R_APB_INT_MERB_INTF_ERROR_IMR0];
    qemu_set_irq(s->irq_apb_int_merb_intf_error_imr0, pending);
}

static void apb_int_merb_intf_error_isr0_postw(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    apb_int_merb_intf_error_imr0_update_irq(s);
}

static uint64_t apb_int_merb_intf_error_ier0_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTF_ERROR_IMR0] &= ~val;
    apb_int_merb_intf_error_imr0_update_irq(s);
    return 0;
}

static uint64_t apb_int_merb_intf_error_idr0_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTF_ERROR_IMR0] |= val;
    apb_int_merb_intf_error_imr0_update_irq(s);
    return 0;
}

static void apb_int_merb_interrupt_imr_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_APB_INT_MERB_INTERRUPT_ISR] &
                   ~s->regs[R_APB_INT_MERB_INTERRUPT_IMR];
    qemu_set_irq(s->irq_apb_int_merb_interrupt_imr, pending);
}

static void apb_int_merb_interrupt_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    apb_int_merb_interrupt_imr_update_irq(s);
}

static uint64_t apb_int_merb_interrupt_ier_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTERRUPT_IMR] &= ~val;
    apb_int_merb_interrupt_imr_update_irq(s);
    return 0;
}

static uint64_t apb_int_merb_interrupt_idr_prew(RegisterInfo *reg,
                                                uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTERRUPT_IMR] |= val;
    apb_int_merb_interrupt_imr_update_irq(s);
    return 0;
}

static void apb_int_merb_intf_error_imr2_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_APB_INT_MERB_INTF_ERROR_ISR2] &
                   ~s->regs[R_APB_INT_MERB_INTF_ERROR_IMR2];
    qemu_set_irq(s->irq_apb_int_merb_intf_error_imr2, pending);
}

static void apb_int_merb_intf_error_isr2_postw(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    apb_int_merb_intf_error_imr2_update_irq(s);
}

static uint64_t apb_int_merb_intf_error_ier2_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTF_ERROR_IMR2] &= ~val;
    apb_int_merb_intf_error_imr2_update_irq(s);
    return 0;
}

static uint64_t apb_int_merb_intf_error_idr2_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTF_ERROR_IMR2] |= val;
    apb_int_merb_intf_error_imr2_update_irq(s);
    return 0;
}

static void apb_int_merb_intf_error_imr1_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_APB_INT_MERB_INTF_ERROR_ISR1] &
                   ~s->regs[R_APB_INT_MERB_INTF_ERROR_IMR1];
    qemu_set_irq(s->irq_apb_int_merb_intf_error_imr1, pending);
}

static void apb_int_merb_intf_error_isr1_postw(RegisterInfo *reg,
                                               uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    apb_int_merb_intf_error_imr1_update_irq(s);
}

static uint64_t apb_int_merb_intf_error_ier1_prew(RegisterInfo *reg,
                                                  uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTF_ERROR_IMR1] &= ~val;
    apb_int_merb_intf_error_imr1_update_irq(s);
    return 0;
}

static uint64_t apb_int_merb_intf_error_idr1_prew(RegisterInfo *reg,
                                                   uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_INTF_ERROR_IMR1] |= val;
    apb_int_merb_intf_error_imr1_update_irq(s);
    return 0;
}

static void dtp_merb_interrupt_imr_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_DTP_MERB_INTERRUPT_ISR] &
                   ~s->regs[R_DTP_MERB_INTERRUPT_IMR];
    qemu_set_irq(s->irq_dtp_merb_interrupt_imr, pending);
}

static void dtp_merb_interrupt_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    dtp_merb_interrupt_imr_update_irq(s);
}

static uint64_t dtp_merb_interrupt_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_MERB_INTERRUPT_IMR] &= ~val;
    dtp_merb_interrupt_imr_update_irq(s);
    return 0;
}

static uint64_t dtp_merb_interrupt_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_MERB_INTERRUPT_IMR] |= val;
    dtp_merb_interrupt_imr_update_irq(s);
    return 0;
}

static void apb_int_merb_error_imr_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_APB_INT_MERB_ERROR_ISR] &
                   ~s->regs[R_APB_INT_MERB_ERROR_IMR];
    qemu_set_irq(s->irq_apb_int_merb_error_imr, pending);
}

static void apb_int_merb_error_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    apb_int_merb_error_imr_update_irq(s);
}

static uint64_t apb_int_merb_error_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_ERROR_IMR] &= ~val;
    apb_int_merb_error_imr_update_irq(s);
    return 0;
}

static uint64_t apb_int_merb_error_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_APB_INT_MERB_ERROR_IMR] |= val;
    apb_int_merb_error_imr_update_irq(s);
    return 0;
}

static void dtp_serb_intf_error_imr0_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_DTP_SERB_INTF_ERROR_ISR0] &
                   ~s->regs[R_DTP_SERB_INTF_ERROR_IMR0];
    qemu_set_irq(s->irq_dtp_serb_intf_error_imr0, pending);
}

static void dtp_serb_intf_error_isr0_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    dtp_serb_intf_error_imr0_update_irq(s);
}

static uint64_t dtp_serb_intf_error_ier0_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_SERB_INTF_ERROR_IMR0] &= ~val;
    dtp_serb_intf_error_imr0_update_irq(s);
    return 0;
}

static uint64_t dtp_serb_intf_error_idr0_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_SERB_INTF_ERROR_IMR0] |= val;
    dtp_serb_intf_error_imr0_update_irq(s);
    return 0;
}

static void dtp_serb_interrupt_imr_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_DTP_SERB_INTERRUPT_ISR] &
                   ~s->regs[R_DTP_SERB_INTERRUPT_IMR];
    qemu_set_irq(s->irq_dtp_serb_interrupt_imr, pending);
}

static void dtp_serb_interrupt_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    dtp_serb_interrupt_imr_update_irq(s);
}

static uint64_t dtp_serb_interrupt_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_SERB_INTERRUPT_IMR] &= ~val;
    dtp_serb_interrupt_imr_update_irq(s);
    return 0;
}

static uint64_t dtp_serb_interrupt_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_SERB_INTERRUPT_IMR] |= val;
    dtp_serb_interrupt_imr_update_irq(s);
    return 0;
}

static void dtp_merb_error_imr_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_DTP_MERB_ERROR_ISR] &
                   ~s->regs[R_DTP_MERB_ERROR_IMR];
    qemu_set_irq(s->irq_dtp_merb_error_imr, pending);
}

static void dtp_merb_error_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    dtp_merb_error_imr_update_irq(s);
}

static uint64_t dtp_merb_error_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_MERB_ERROR_IMR] &= ~val;
    dtp_merb_error_imr_update_irq(s);
    return 0;
}

static uint64_t dtp_merb_error_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_MERB_ERROR_IMR] |= val;
    dtp_merb_error_imr_update_irq(s);
    return 0;
}

static void dtp_serb_error_imr_update_irq(PSXC_AFI_FS *s)
{
    bool pending = s->regs[R_DTP_SERB_ERROR_ISR] &
                   ~s->regs[R_DTP_SERB_ERROR_IMR];
    qemu_set_irq(s->irq_dtp_serb_error_imr, pending);
}

static void dtp_serb_error_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    dtp_serb_error_imr_update_irq(s);
}

static uint64_t dtp_serb_error_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_SERB_ERROR_IMR] &= ~val;
    dtp_serb_error_imr_update_irq(s);
    return 0;
}

static uint64_t dtp_serb_error_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_DTP_SERB_ERROR_IMR] |= val;
    dtp_serb_error_imr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo psxc_afi_fs_regs_info[] = {
    {   .name = "CORRECTABLE_TOP_ERROR_SOURCE_STATUS",
        .addr = A_CORRECTABLE_TOP_ERROR_SOURCE_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "CORRECTABLE_ERROR_SOURCE_STATUS",
        .addr = A_CORRECTABLE_ERROR_SOURCE_STATUS,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "UNCORRECTABLE_TOP_ERROR_SOURCE_STATUS",
        .addr = A_UNCORRECTABLE_TOP_ERROR_SOURCE_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "UNCORRECTABLE_ERROR_SOURCE_STATUS",
        .addr = A_UNCORRECTABLE_ERROR_SOURCE_STATUS,
        .rsvd = 0xfffffff0,
        .ro = 0xffffffff,
    },{ .name = "TOP_INTERRUPT_SOURCE_STATUS",
        .addr = A_TOP_INTERRUPT_SOURCE_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "INTERRUPT_SOURCE_STATUS",  .addr = A_INTERRUPT_SOURCE_STATUS,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    },{ .name = "SLVERR",  .addr = A_SLVERR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "AFI_FS_MAIN_CONFIG",  .addr = A_AFI_FS_MAIN_CONFIG,
        .rsvd = 0xffffffc0,
    },{ .name = "AFI_FS_CNTL_PARITY_INJ",  .addr = A_AFI_FS_CNTL_PARITY_INJ,
        .rsvd = 0xfffffe00,
    },{ .name = "FIREWALL_CNTL_ERR_TYPE",  .addr = A_FIREWALL_CNTL_ERR_TYPE,
        .rsvd = 0xfffffffe,
    },{ .name = "TEST_MODE_CFG",  .addr = A_TEST_MODE_CFG,
        .rsvd = 0xfffffffe,
    },{ .name = "APB_INT_MERB_CNTL_MAIN",  .addr = A_APB_INT_MERB_CNTL_MAIN,
        .rsvd = 0xfffffffe,
    },{ .name = "APB_INT_MERB_CNTL_QOS",  .addr = A_APB_INT_MERB_CNTL_QOS,
        .rsvd = 0xffffffff,
    },{ .name = "APB_INT_MERB_CNTL_ROUTING",
        .addr = A_APB_INT_MERB_CNTL_ROUTING,
        .rsvd = 0xffffffff,
    },{ .name = "APB_INT_MERB_CNTL_ISOLATION",
        .addr = A_APB_INT_MERB_CNTL_ISOLATION,
        .reset = 0x1,
        .rsvd = 0xfffffffc,
    },{ .name = "APB_INT_MERB_CNTL_ERR_TYPE",
        .addr = A_APB_INT_MERB_CNTL_ERR_TYPE,
        .rsvd = 0xfffffffe,
    },{ .name = "APB_INT_MERB_INTF_CNTL_ERR_TYPE0",
        .addr = A_APB_INT_MERB_INTF_CNTL_ERR_TYPE0,
        .rsvd = 0xfffffffe,
    },{ .name = "APB_INT_MERB_INTF_CNTL_ERR_TYPE1",
        .addr = A_APB_INT_MERB_INTF_CNTL_ERR_TYPE1,
        .rsvd = 0xfffffffe,
    },{ .name = "APB_INT_MERB_INTF_CNTL_ERR_TYPE2",
        .addr = A_APB_INT_MERB_INTF_CNTL_ERR_TYPE2,
        .rsvd = 0xfffffffe,
    },{ .name = "APB_INT_MERB_INTF_CNTL_INTF_TEST_EN0",
        .addr = A_APB_INT_MERB_INTF_CNTL_INTF_TEST_EN0,
        .rsvd = 0xfffffff8,
    },{ .name = "APB_INT_MERB_INTF_CNTL_INTF_TEST_EN1",
        .addr = A_APB_INT_MERB_INTF_CNTL_INTF_TEST_EN1,
        .rsvd = 0xfffffff8,
    },{ .name = "APB_INT_MERB_INTF_CNTL_INTF_TEST_EN2",
        .addr = A_APB_INT_MERB_INTF_CNTL_INTF_TEST_EN2,
        .rsvd = 0xfffffff8,
    },{ .name = "APB_INT_MERB_STATUS_ISOLATION",
        .addr = A_APB_INT_MERB_STATUS_ISOLATION,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_ERROR_SOURCE_STATUS",
        .addr = A_APB_INT_MERB_ERROR_SOURCE_STATUS,
        .rsvd = 0xf8f8fffc,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_ERROR_ISR",  .addr = A_APB_INT_MERB_ERROR_ISR,
        .rsvd = 0xfffefffe,
        .w1c = 0xffffffff,
        .post_write = apb_int_merb_error_isr_postw,
    },{ .name = "APB_INT_MERB_ERROR_IMR",  .addr = A_APB_INT_MERB_ERROR_IMR,
        .reset = 0x10001,
        .rsvd = 0xfffefffe,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_ERROR_IER",  .addr = A_APB_INT_MERB_ERROR_IER,
        .rsvd = 0xfffefffe,
        .pre_write = apb_int_merb_error_ier_prew,
    },{ .name = "APB_INT_MERB_ERROR_IDR",  .addr = A_APB_INT_MERB_ERROR_IDR,
        .rsvd = 0xfffefffe,
        .pre_write = apb_int_merb_error_idr_prew,
    },{ .name = "APB_INT_MERB_INTERRUPT_ISR",
        .addr = A_APB_INT_MERB_INTERRUPT_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0xffffffff,
        .post_write = apb_int_merb_interrupt_isr_postw,
    },{ .name = "APB_INT_MERB_INTERRUPT_IMR",
        .addr = A_APB_INT_MERB_INTERRUPT_IMR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_INTERRUPT_IER",
        .addr = A_APB_INT_MERB_INTERRUPT_IER,
        .rsvd = 0xfffffffe,
        .pre_write = apb_int_merb_interrupt_ier_prew,
    },{ .name = "APB_INT_MERB_INTERRUPT_IDR",
        .addr = A_APB_INT_MERB_INTERRUPT_IDR,
        .rsvd = 0xfffffffe,
        .pre_write = apb_int_merb_interrupt_idr_prew,
    },{ .name = "APB_INT_MERB_INTF_ERROR_ISR0",
        .addr = A_APB_INT_MERB_INTF_ERROR_ISR0,
        .rsvd = 0xfffefefe,
        .w1c = 0xffffffff,
        .post_write = apb_int_merb_intf_error_isr0_postw,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IMR0",
        .addr = A_APB_INT_MERB_INTF_ERROR_IMR0,
        .reset = 0x10101,
        .rsvd = 0xfffefefe,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IER0",
        .addr = A_APB_INT_MERB_INTF_ERROR_IER0,
        .rsvd = 0xfffefefe,
        .pre_write = apb_int_merb_intf_error_ier0_prew,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IDR0",
        .addr = A_APB_INT_MERB_INTF_ERROR_IDR0,
        .rsvd = 0xfffefefe,
        .pre_write = apb_int_merb_intf_error_idr0_prew,
    },{ .name = "APB_INT_MERB_INTF_ERROR_ISR1",
        .addr = A_APB_INT_MERB_INTF_ERROR_ISR1,
        .rsvd = 0xfffefefe,
        .w1c = 0xffffffff,
        .post_write = apb_int_merb_intf_error_isr1_postw,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IMR1",
        .addr = A_APB_INT_MERB_INTF_ERROR_IMR1,
        .reset = 0x10101,
        .rsvd = 0xfffefefe,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IER1",
        .addr = A_APB_INT_MERB_INTF_ERROR_IER1,
        .rsvd = 0xfffefefe,
        .pre_write = apb_int_merb_intf_error_ier1_prew,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IDR1",
        .addr = A_APB_INT_MERB_INTF_ERROR_IDR1,
        .rsvd = 0xfffefefe,
        .pre_write = apb_int_merb_intf_error_idr1_prew,
    },{ .name = "APB_INT_MERB_INTF_ERROR_ISR2",
        .addr = A_APB_INT_MERB_INTF_ERROR_ISR2,
        .rsvd = 0xfffefefe,
        .w1c = 0xffffffff,
        .post_write = apb_int_merb_intf_error_isr2_postw,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IMR2",
        .addr = A_APB_INT_MERB_INTF_ERROR_IMR2,
        .reset = 0x10101,
        .rsvd = 0xfffefefe,
        .ro = 0xffffffff,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IER2",
        .addr = A_APB_INT_MERB_INTF_ERROR_IER2,
        .rsvd = 0xfffefefe,
        .pre_write = apb_int_merb_intf_error_ier2_prew,
    },{ .name = "APB_INT_MERB_INTF_ERROR_IDR2",
        .addr = A_APB_INT_MERB_INTF_ERROR_IDR2,
        .rsvd = 0xfffefefe,
        .pre_write = apb_int_merb_intf_error_idr2_prew,
    },{ .name = "DTP_MERB_CNTL_MAIN",  .addr = A_DTP_MERB_CNTL_MAIN,
        .rsvd = 0xfffffffe,
    },{ .name = "DTP_MERB_CNTL_ISOLATION",  .addr = A_DTP_MERB_CNTL_ISOLATION,
        .reset = 0x1,
        .rsvd = 0xfffffffc,
    },{ .name = "DTP_MERB_CNTL_ERR_TYPE",  .addr = A_DTP_MERB_CNTL_ERR_TYPE,
        .rsvd = 0xfffffffe,
    },{ .name = "DTP_MERB_STATUS_ISOLATION",
        .addr = A_DTP_MERB_STATUS_ISOLATION,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "DTP_MERB_ERROR_SOURCE_STATUS",
        .addr = A_DTP_MERB_ERROR_SOURCE_STATUS,
        .rsvd = 0xfefefffc,
        .ro = 0xffffffff,
    },{ .name = "DTP_MERB_ERROR_ISR",  .addr = A_DTP_MERB_ERROR_ISR,
        .rsvd = 0xfffcfffe,
        .w1c = 0xffffffff,
        .post_write = dtp_merb_error_isr_postw,
    },{ .name = "DTP_MERB_ERROR_IMR",  .addr = A_DTP_MERB_ERROR_IMR,
        .reset = 0x30001,
        .rsvd = 0xfffcfffe,
        .ro = 0xffffffff,
    },{ .name = "DTP_MERB_ERROR_IER",  .addr = A_DTP_MERB_ERROR_IER,
        .rsvd = 0xfffcfffe,
        .pre_write = dtp_merb_error_ier_prew,
    },{ .name = "DTP_MERB_ERROR_IDR",  .addr = A_DTP_MERB_ERROR_IDR,
        .rsvd = 0xfffcfffe,
        .pre_write = dtp_merb_error_idr_prew,
    },{ .name = "DTP_MERB_INTERRUPT_ISR",  .addr = A_DTP_MERB_INTERRUPT_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0xffffffff,
        .post_write = dtp_merb_interrupt_isr_postw,
    },{ .name = "DTP_MERB_INTERRUPT_IMR",  .addr = A_DTP_MERB_INTERRUPT_IMR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "DTP_MERB_INTERRUPT_IER",  .addr = A_DTP_MERB_INTERRUPT_IER,
        .rsvd = 0xfffffffe,
        .pre_write = dtp_merb_interrupt_ier_prew,
    },{ .name = "DTP_MERB_INTERRUPT_IDR",  .addr = A_DTP_MERB_INTERRUPT_IDR,
        .rsvd = 0xfffffffe,
        .pre_write = dtp_merb_interrupt_idr_prew,
    },{ .name = "DTP_SERB_CNTL_MAIN",  .addr = A_DTP_SERB_CNTL_MAIN,
        .rsvd = 0xfffffffe,
    },{ .name = "DTP_SERB_CNTL_ISOLATION",  .addr = A_DTP_SERB_CNTL_ISOLATION,
        .reset = 0x1,
        .rsvd = 0xfffffffc,
    },{ .name = "DTP_SERB_CNTL_ERR_TYPE",  .addr = A_DTP_SERB_CNTL_ERR_TYPE,
        .rsvd = 0xfffffffe,
    },{ .name = "DTP_SERB_INTF_CNTL_ERR_TYPE0",
        .addr = A_DTP_SERB_INTF_CNTL_ERR_TYPE0,
        .rsvd = 0xfffffffe,
    },{ .name = "DTP_SERB_INTF_CNTL_INTF_TEST_EN0",
        .addr = A_DTP_SERB_INTF_CNTL_INTF_TEST_EN0,
        .rsvd = 0xfffffc00,
    },{ .name = "DTP_SERB_STATUS_ISOLATION",
        .addr = A_DTP_SERB_STATUS_ISOLATION,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "DTP_SERB_ERROR_SOURCE_STATUS",
        .addr = A_DTP_SERB_ERROR_SOURCE_STATUS,
        .rsvd = 0xfefefffc,
        .ro = 0xffffffff,
    },{ .name = "DTP_SERB_ERROR_ISR",  .addr = A_DTP_SERB_ERROR_ISR,
        .rsvd = 0xfffcfffe,
        .w1c = 0xffffffff,
        .post_write = dtp_serb_error_isr_postw,
    },{ .name = "DTP_SERB_ERROR_IMR",  .addr = A_DTP_SERB_ERROR_IMR,
        .reset = 0x30001,
        .rsvd = 0xfffcfffe,
        .ro = 0xffffffff,
    },{ .name = "DTP_SERB_ERROR_IER",  .addr = A_DTP_SERB_ERROR_IER,
        .rsvd = 0xfffcfffe,
        .pre_write = dtp_serb_error_ier_prew,
    },{ .name = "DTP_SERB_ERROR_IDR",  .addr = A_DTP_SERB_ERROR_IDR,
        .rsvd = 0xfffcfffe,
        .pre_write = dtp_serb_error_idr_prew,
    },{ .name = "DTP_SERB_INTERRUPT_ISR",  .addr = A_DTP_SERB_INTERRUPT_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0xffffffff,
        .post_write = dtp_serb_interrupt_isr_postw,
    },{ .name = "DTP_SERB_INTERRUPT_IMR",  .addr = A_DTP_SERB_INTERRUPT_IMR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "DTP_SERB_INTERRUPT_IER",  .addr = A_DTP_SERB_INTERRUPT_IER,
        .rsvd = 0xfffffffe,
        .pre_write = dtp_serb_interrupt_ier_prew,
    },{ .name = "DTP_SERB_INTERRUPT_IDR",  .addr = A_DTP_SERB_INTERRUPT_IDR,
        .rsvd = 0xfffffffe,
        .pre_write = dtp_serb_interrupt_idr_prew,
    },{ .name = "DTP_SERB_INTF_ERROR_ISR0",  .addr = A_DTP_SERB_INTF_ERROR_ISR0,
        .rsvd = 0xfefce0f0,
        .w1c = 0xffffffff,
        .post_write = dtp_serb_intf_error_isr0_postw,
    },{ .name = "DTP_SERB_INTF_ERROR_IMR0",  .addr = A_DTP_SERB_INTF_ERROR_IMR0,
        .reset = 0x1031f0f,
        .rsvd = 0xfefce0f0,
        .ro = 0xffffffff,
    },{ .name = "DTP_SERB_INTF_ERROR_IER0",  .addr = A_DTP_SERB_INTF_ERROR_IER0,
        .rsvd = 0xfefce0f0,
        .pre_write = dtp_serb_intf_error_ier0_prew,
    },{ .name = "DTP_SERB_INTF_ERROR_IDR0",  .addr = A_DTP_SERB_INTF_ERROR_IDR0,
        .rsvd = 0xfefce0f0,
        .pre_write = dtp_serb_intf_error_idr0_prew,
    }
};

static void psxc_afi_fs_reset_enter(Object *obj, ResetType type)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void psxc_afi_fs_reset_hold(Object *obj)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(obj);

    apb_int_merb_intf_error_imr0_update_irq(s);
    apb_int_merb_interrupt_imr_update_irq(s);
    apb_int_merb_intf_error_imr2_update_irq(s);
    apb_int_merb_intf_error_imr1_update_irq(s);
    dtp_merb_interrupt_imr_update_irq(s);
    apb_int_merb_error_imr_update_irq(s);
    dtp_serb_intf_error_imr0_update_irq(s);
    dtp_serb_interrupt_imr_update_irq(s);
    dtp_merb_error_imr_update_irq(s);
    dtp_serb_error_imr_update_irq(s);
}

static const MemoryRegionOps psxc_afi_fs_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void psxc_afi_fs_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void psxc_afi_fs_init(Object *obj)
{
    PSXC_AFI_FS *s = XILINX_PSXC_AFI_FS(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSXC_AFI_FS,
                       PSXC_AFI_FS_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psxc_afi_fs_regs_info,
                              ARRAY_SIZE(psxc_afi_fs_regs_info),
                              s->regs_info, s->regs,
                              &psxc_afi_fs_ops,
                              XILINX_PSXC_AFI_FS_ERR_DEBUG,
                              PSXC_AFI_FS_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_apb_int_merb_intf_error_imr0);
    sysbus_init_irq(sbd, &s->irq_apb_int_merb_interrupt_imr);
    sysbus_init_irq(sbd, &s->irq_apb_int_merb_intf_error_imr2);
    sysbus_init_irq(sbd, &s->irq_apb_int_merb_intf_error_imr1);
    sysbus_init_irq(sbd, &s->irq_dtp_merb_interrupt_imr);
    sysbus_init_irq(sbd, &s->irq_apb_int_merb_error_imr);
    sysbus_init_irq(sbd, &s->irq_dtp_serb_intf_error_imr0);
    sysbus_init_irq(sbd, &s->irq_dtp_serb_interrupt_imr);
    sysbus_init_irq(sbd, &s->irq_dtp_merb_error_imr);
    sysbus_init_irq(sbd, &s->irq_dtp_serb_error_imr);
}

static const VMStateDescription vmstate_psxc_afi_fs = {
    .name = TYPE_XILINX_PSXC_AFI_FS,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSXC_AFI_FS, PSXC_AFI_FS_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void psxc_afi_fs_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = psxc_afi_fs_realize;
    dc->vmsd = &vmstate_psxc_afi_fs;
    rc->phases.enter = psxc_afi_fs_reset_enter;
    rc->phases.hold = psxc_afi_fs_reset_hold;
}

static const TypeInfo psxc_afi_fs_info = {
    .name          = TYPE_XILINX_PSXC_AFI_FS,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSXC_AFI_FS),
    .class_init    = psxc_afi_fs_class_init,
    .instance_init = psxc_afi_fs_init,
};

static void psxc_afi_fs_register_types(void)
{
    type_register_static(&psxc_afi_fs_info);
}

type_init(psxc_afi_fs_register_types)
