/*
 * QEMU model of the XlnxPsxcLpxSlcr Global system level control registers for
 * the low power domain
 *
 * Copyright (c) 2024, Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "qapi/error.h"
#include "hw/register.h"
#include "hw/resettable.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "hw/arm/linux-boot-if.h"
#include "hw/fdt_generic_util.h"
#include "hw/misc/xlnx-psxc-lpx-slcr.h"
#include "trace.h"

REG32(WPROT0, 0x00000000)
    FIELD(WPROT0, ACTIVE, 0, 1)
#define WPROT0_WRITE_MASK 0x00000001
#define WPROT0_RESET_VAL 0x0

REG32(SAFETY_CHK0, 0x00000060)
    FIELD(SAFETY_CHK0, CHK_VAL, 0, 32)
#define SAFETY_CHK0_WRITE_MASK 0xffffffff
#define SAFETY_CHK0_RESET_VAL 0x0

REG32(SAFETY_CHK1, 0x00000064)
    FIELD(SAFETY_CHK1, CHK_VAL, 0, 32)
#define SAFETY_CHK1_WRITE_MASK 0xffffffff
#define SAFETY_CHK1_RESET_VAL 0x0

REG32(SAFETY_CHK2, 0x00000068)
    FIELD(SAFETY_CHK2, CHK_VAL, 0, 32)
#define SAFETY_CHK2_WRITE_MASK 0xffffffff
#define SAFETY_CHK2_RESET_VAL 0x0

REG32(SAFETY_CHK3, 0x0000006c)
    FIELD(SAFETY_CHK3, CHK_VAL, 0, 32)
#define SAFETY_CHK3_WRITE_MASK 0xffffffff
#define SAFETY_CHK3_RESET_VAL 0x0

REG32(HSDP_CONFIG, 0x00000088)
    FIELD(HSDP_CONFIG, SEL_AUR_PCIE, 1, 1)
    FIELD(HSDP_CONFIG, SEL_AUR_PL, 0, 1)
#define HSDP_CONFIG_WRITE_MASK 0x00000003
#define HSDP_CONFIG_RESET_VAL 0x0

REG32(OCM2_CONFIG, 0x0000008c)
    FIELD(OCM2_CONFIG, PRESENT, 0, 1)
#define OCM2_CONFIG_RESET_VAL 0x0

REG32(BISR_CACHE_CTRL_0, 0x00000100)
    FIELD(BISR_CACHE_CTRL_0, CLR, 4, 1)
    FIELD(BISR_CACHE_CTRL_0, TRIGGER, 0, 1)
#define BISR_CACHE_CTRL_0_WRITE_MASK 0x00000011
#define BISR_CACHE_CTRL_0_RESET_VAL 0x0

REG32(BISR_CACHE_CTRL_1, 0x00000104)
    FIELD(BISR_CACHE_CTRL_1, PGEN_10, 10, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_9, 9, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_8, 8, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_7, 7, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_6, 6, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_5, 5, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_4, 4, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_3, 3, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_2, 2, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_1, 1, 1)
    FIELD(BISR_CACHE_CTRL_1, PGEN_0, 0, 1)
#define BISR_CACHE_CTRL_1_WRITE_MASK 0x000007ff
#define BISR_CACHE_CTRL_1_RESET_VAL 0x0

REG32(BISR_CACHE_STATUS, 0x00000108)
    FIELD(BISR_CACHE_STATUS, PASS_GLOBAL, 31, 1)
    FIELD(BISR_CACHE_STATUS, DONE_GLOBAL, 30, 1)
    FIELD(BISR_CACHE_STATUS, PASS_10, 21, 1)
    FIELD(BISR_CACHE_STATUS, DONE_10, 20, 1)
    FIELD(BISR_CACHE_STATUS, PASS_9, 19, 1)
    FIELD(BISR_CACHE_STATUS, DONE_9, 18, 1)
    FIELD(BISR_CACHE_STATUS, PASS_8, 17, 1)
    FIELD(BISR_CACHE_STATUS, DONE_8, 16, 1)
    FIELD(BISR_CACHE_STATUS, PASS_7, 15, 1)
    FIELD(BISR_CACHE_STATUS, DONE_7, 14, 1)
    FIELD(BISR_CACHE_STATUS, PASS_6, 13, 1)
    FIELD(BISR_CACHE_STATUS, DONE_6, 12, 1)
    FIELD(BISR_CACHE_STATUS, PASS_5, 11, 1)
    FIELD(BISR_CACHE_STATUS, DONE_5, 10, 1)
    FIELD(BISR_CACHE_STATUS, PASS_4, 9, 1)
    FIELD(BISR_CACHE_STATUS, DONE_4, 8, 1)
    FIELD(BISR_CACHE_STATUS, PASS_3, 7, 1)
    FIELD(BISR_CACHE_STATUS, DONE_3, 6, 1)
    FIELD(BISR_CACHE_STATUS, PASS_2, 5, 1)
    FIELD(BISR_CACHE_STATUS, DONE_2, 4, 1)
    FIELD(BISR_CACHE_STATUS, PASS_1, 3, 1)
    FIELD(BISR_CACHE_STATUS, DONE_1, 2, 1)
    FIELD(BISR_CACHE_STATUS, PASS_0, 1, 1)
    FIELD(BISR_CACHE_STATUS, DONE_0, 0, 1)
#define BISR_CACHE_STATUS_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_0, 0x00000110)
    FIELD(BISR_CACHE_DATA_0, DATA, 0, 32)
#define BISR_CACHE_DATA_0_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_0_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_1, 0x00000114)
    FIELD(BISR_CACHE_DATA_1, DATA, 0, 32)
#define BISR_CACHE_DATA_1_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_1_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_2, 0x00000118)
    FIELD(BISR_CACHE_DATA_2, DATA, 0, 32)
#define BISR_CACHE_DATA_2_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_2_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_3, 0x0000011c)
    FIELD(BISR_CACHE_DATA_3, DATA, 0, 32)
#define BISR_CACHE_DATA_3_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_3_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_4, 0x00000120)
    FIELD(BISR_CACHE_DATA_4, DATA, 0, 32)
#define BISR_CACHE_DATA_4_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_4_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_5, 0x00000124)
    FIELD(BISR_CACHE_DATA_5, DATA, 0, 32)
#define BISR_CACHE_DATA_5_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_5_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_6, 0x00000128)
    FIELD(BISR_CACHE_DATA_6, DATA, 0, 32)
#define BISR_CACHE_DATA_6_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_6_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_7, 0x0000012c)
    FIELD(BISR_CACHE_DATA_7, DATA, 0, 32)
#define BISR_CACHE_DATA_7_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_7_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_8, 0x00000130)
    FIELD(BISR_CACHE_DATA_8, DATA, 0, 32)
#define BISR_CACHE_DATA_8_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_8_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_9, 0x00000134)
    FIELD(BISR_CACHE_DATA_9, DATA, 0, 32)
#define BISR_CACHE_DATA_9_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_9_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_10, 0x00000138)
    FIELD(BISR_CACHE_DATA_10, DATA, 0, 32)
#define BISR_CACHE_DATA_10_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_10_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_11, 0x0000013c)
    FIELD(BISR_CACHE_DATA_11, DATA, 0, 32)
#define BISR_CACHE_DATA_11_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_11_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_12, 0x00000140)
    FIELD(BISR_CACHE_DATA_12, DATA, 0, 32)
#define BISR_CACHE_DATA_12_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_12_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_13, 0x00000144)
    FIELD(BISR_CACHE_DATA_13, DATA, 0, 32)
#define BISR_CACHE_DATA_13_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_13_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_14, 0x00000148)
    FIELD(BISR_CACHE_DATA_14, DATA, 0, 32)
#define BISR_CACHE_DATA_14_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_14_RESET_VAL 0x0

REG32(BISR_CACHE_DATA_15, 0x0000014c)
    FIELD(BISR_CACHE_DATA_15, DATA, 0, 32)
#define BISR_CACHE_DATA_15_WRITE_MASK 0xffffffff
#define BISR_CACHE_DATA_15_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU0A, 0x00000200)
    FIELD(NOC_TRANS_REMAP_RPU0A, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU0A_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU0A_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU1A, 0x00000204)
    FIELD(NOC_TRANS_REMAP_RPU1A, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU1A_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU1A_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU0B, 0x00000208)
    FIELD(NOC_TRANS_REMAP_RPU0B, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU0B_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU0B_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU1B, 0x0000020c)
    FIELD(NOC_TRANS_REMAP_RPU1B, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU1B_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU1B_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU0C, 0x00000210)
    FIELD(NOC_TRANS_REMAP_RPU0C, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU0C_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU0C_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU1C, 0x00000214)
    FIELD(NOC_TRANS_REMAP_RPU1C, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU1C_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU1C_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU0D, 0x00000218)
    FIELD(NOC_TRANS_REMAP_RPU0D, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU0D_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU0D_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU1D, 0x0000021c)
    FIELD(NOC_TRANS_REMAP_RPU1D, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU1D_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU1D_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU0E, 0x00000220)
    FIELD(NOC_TRANS_REMAP_RPU0E, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU0E_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU0E_RESET_VAL 0x0

REG32(NOC_TRANS_REMAP_RPU1E, 0x00000224)
    FIELD(NOC_TRANS_REMAP_RPU1E, NOC_TRANSACTION_REMAP, 0, 1)
#define NOC_TRANS_REMAP_RPU1E_WRITE_MASK 0x00000001
#define NOC_TRANS_REMAP_RPU1E_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_0, 0x00000280)
    FIELD(ADMA0_ROUTE_CR_0, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_0_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_0_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_1, 0x00000284)
    FIELD(ADMA0_ROUTE_CR_1, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_1_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_1_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_2, 0x00000288)
    FIELD(ADMA0_ROUTE_CR_2, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_2_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_2_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_3, 0x0000028c)
    FIELD(ADMA0_ROUTE_CR_3, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_3_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_3_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_4, 0x00000290)
    FIELD(ADMA0_ROUTE_CR_4, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_4_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_4_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_5, 0x00000294)
    FIELD(ADMA0_ROUTE_CR_5, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_5_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_5_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_6, 0x00000298)
    FIELD(ADMA0_ROUTE_CR_6, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_6_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_6_RESET_VAL 0x0

REG32(ADMA0_ROUTE_CR_7, 0x0000029c)
    FIELD(ADMA0_ROUTE_CR_7, ROUTING_BIT, 0, 1)
#define ADMA0_ROUTE_CR_7_WRITE_MASK 0x00000001
#define ADMA0_ROUTE_CR_7_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_0, 0x000002a0)
    FIELD(SDMA_ROUTE_CR_0, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_0_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_0_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_1, 0x000002a4)
    FIELD(SDMA_ROUTE_CR_1, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_1_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_1_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_2, 0x000002a8)
    FIELD(SDMA_ROUTE_CR_2, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_2_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_2_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_3, 0x000002ac)
    FIELD(SDMA_ROUTE_CR_3, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_3_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_3_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_4, 0x000002b0)
    FIELD(SDMA_ROUTE_CR_4, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_4_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_4_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_5, 0x000002b4)
    FIELD(SDMA_ROUTE_CR_5, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_5_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_5_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_6, 0x000002b8)
    FIELD(SDMA_ROUTE_CR_6, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_6_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_6_RESET_VAL 0x0

REG32(SDMA_ROUTE_CR_7, 0x000002bc)
    FIELD(SDMA_ROUTE_CR_7, ROUTING_BIT, 0, 1)
#define SDMA_ROUTE_CR_7_WRITE_MASK 0x00000001
#define SDMA_ROUTE_CR_7_RESET_VAL 0x0

REG32(SDMA_CFG, 0x000002c0)
    FIELD(SDMA_CFG, BUS_WIDTH, 5, 0x2)
    FIELD(SDMA_CFG, NUM_CH, 0, 5)
#define SDMA_CFG_RESET_VAL 0x48

REG32(WWDT0_CLK_SEL, 0x000002d0)
    FIELD(WWDT0_CLK_SEL, SELECT_1, 1, 1)
    FIELD(WWDT0_CLK_SEL, SELECT_0, 0, 1)
#define WWDT0_CLK_SEL_WRITE_MASK 0x00000003
#define WWDT0_CLK_SEL_RESET_VAL 0x0

REG32(WWDT1_CLK_SEL, 0x000002d4)
    FIELD(WWDT1_CLK_SEL, SELECT_1, 1, 1)
    FIELD(WWDT1_CLK_SEL, SELECT_0, 0, 1)
#define WWDT1_CLK_SEL_WRITE_MASK 0x00000003
#define WWDT1_CLK_SEL_RESET_VAL 0x0

REG32(WWDT2_CLK_SEL, 0x000002d8)
    FIELD(WWDT2_CLK_SEL, SELECT_1, 1, 1)
    FIELD(WWDT2_CLK_SEL, SELECT_0, 0, 1)
#define WWDT2_CLK_SEL_WRITE_MASK 0x00000003
#define WWDT2_CLK_SEL_RESET_VAL 0x0

REG32(WWDT3_CLK_SEL, 0x000002dc)
    FIELD(WWDT3_CLK_SEL, SELECT_1, 1, 1)
    FIELD(WWDT3_CLK_SEL, SELECT_0, 0, 1)
#define WWDT3_CLK_SEL_WRITE_MASK 0x00000003
#define WWDT3_CLK_SEL_RESET_VAL 0x0

REG32(WWDT4_CLK_SEL, 0x000002e0)
    FIELD(WWDT4_CLK_SEL, SELECT_1, 1, 1)
    FIELD(WWDT4_CLK_SEL, SELECT_0, 0, 1)
#define WWDT4_CLK_SEL_WRITE_MASK 0x00000003
#define WWDT4_CLK_SEL_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU0A, 0x00000300)
    FIELD(SMID_CONFIG_RPU0A, CH3, 3, 1)
    FIELD(SMID_CONFIG_RPU0A, CH2, 2, 1)
    FIELD(SMID_CONFIG_RPU0A, CH1, 1, 1)
    FIELD(SMID_CONFIG_RPU0A, CH0, 0, 1)
#define SMID_CONFIG_RPU0A_WRITE_MASK 0x0000000f
#define SMID_CONFIG_RPU0A_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU1A, 0x00000304)
    FIELD(SMID_CONFIG_RPU1A, CH3, 3, 1)
    FIELD(SMID_CONFIG_RPU1A, CH2, 2, 1)
    FIELD(SMID_CONFIG_RPU1A, CH1, 1, 1)
    FIELD(SMID_CONFIG_RPU1A, CH0, 0, 1)
#define SMID_CONFIG_RPU1A_WRITE_MASK 0x0000000f
#define SMID_CONFIG_RPU1A_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU0B, 0x00000308)
    FIELD(SMID_CONFIG_RPU0B, CH3, 3, 1)
    FIELD(SMID_CONFIG_RPU0B, CH2, 2, 1)
    FIELD(SMID_CONFIG_RPU0B, CH1, 1, 1)
    FIELD(SMID_CONFIG_RPU0B, CH0, 0, 1)
#define SMID_CONFIG_RPU0B_WRITE_MASK 0x0000000f
#define SMID_CONFIG_RPU0B_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU1B, 0x0000030c)
    FIELD(SMID_CONFIG_RPU1B, CH3, 3, 1)
    FIELD(SMID_CONFIG_RPU1B, CH2, 2, 1)
    FIELD(SMID_CONFIG_RPU1B, CH1, 1, 1)
    FIELD(SMID_CONFIG_RPU1B, CH0, 0, 1)
#define SMID_CONFIG_RPU1B_WRITE_MASK 0x0000000f
#define SMID_CONFIG_RPU1B_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU0C, 0x00000310)
    FIELD(SMID_CONFIG_RPU0C, CH0, 0, 1)
#define SMID_CONFIG_RPU0C_WRITE_MASK 0x00000001
#define SMID_CONFIG_RPU0C_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU1C, 0x00000314)
    FIELD(SMID_CONFIG_RPU1C, CH0, 0, 1)
#define SMID_CONFIG_RPU1C_WRITE_MASK 0x00000001
#define SMID_CONFIG_RPU1C_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU0D, 0x00000318)
    FIELD(SMID_CONFIG_RPU0D, CH0, 0, 1)
#define SMID_CONFIG_RPU0D_WRITE_MASK 0x00000001
#define SMID_CONFIG_RPU0D_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU1D, 0x0000031c)
    FIELD(SMID_CONFIG_RPU1D, CH0, 0, 1)
#define SMID_CONFIG_RPU1D_WRITE_MASK 0x00000001
#define SMID_CONFIG_RPU1D_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU0E, 0x00000320)
    FIELD(SMID_CONFIG_RPU0E, CH0, 0, 1)
#define SMID_CONFIG_RPU0E_WRITE_MASK 0x00000001
#define SMID_CONFIG_RPU0E_RESET_VAL 0x0

REG32(SMID_CONFIG_RPU1E, 0x00000324)
    FIELD(SMID_CONFIG_RPU1E, CH0, 0, 1)
#define SMID_CONFIG_RPU1E_WRITE_MASK 0x00000001
#define SMID_CONFIG_RPU1E_RESET_VAL 0x0

REG32(SMID_CONFIG_ADMA, 0x00000330)
    FIELD(SMID_CONFIG_ADMA, CH7, 7, 1)
    FIELD(SMID_CONFIG_ADMA, CH6, 6, 1)
    FIELD(SMID_CONFIG_ADMA, CH5, 5, 1)
    FIELD(SMID_CONFIG_ADMA, CH4, 4, 1)
    FIELD(SMID_CONFIG_ADMA, CH3, 3, 1)
    FIELD(SMID_CONFIG_ADMA, CH2, 2, 1)
    FIELD(SMID_CONFIG_ADMA, CH1, 1, 1)
    FIELD(SMID_CONFIG_ADMA, CH0, 0, 1)
#define SMID_CONFIG_ADMA_WRITE_MASK 0x000000ff
#define SMID_CONFIG_ADMA_RESET_VAL 0x0

REG32(NMU_RD_FIREWALL_ISR, 0x00000400)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_RD_FIREWALL_ISR, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_RD_FIREWALL_ISR_RESET_VAL 0x0

REG32(NMU_RD_FIREWALL_IMR, 0x00000404)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_RD_FIREWALL_IMR, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_RD_FIREWALL_IMR_RESET_VAL 0xfff

REG32(NMU_RD_FIREWALL_IEN, 0x00000408)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_RD_FIREWALL_IEN, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_RD_FIREWALL_IEN_RESET_VAL 0x0

REG32(NMU_RD_FIREWALL_IDS, 0x0000040c)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_RD_FIREWALL_IDS, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_RD_FIREWALL_IDS_RESET_VAL 0x0

REG32(NMU_RD_FIREWALL_TRIGG, 0x00000410)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_RD_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_RD_FIREWALL_TRIGG_RESET_VAL 0x0

REG32(NMU_WR_FIREWALL_ISR, 0x00000414)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_WR_FIREWALL_ISR, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_WR_FIREWALL_ISR_RESET_VAL 0x0

REG32(NMU_WR_FIREWALL_IMR, 0x00000418)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_WR_FIREWALL_IMR, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_WR_FIREWALL_IMR_RESET_VAL 0xfff

REG32(NMU_WR_FIREWALL_IEN, 0x0000041c)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_WR_FIREWALL_IEN, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_WR_FIREWALL_IEN_RESET_VAL 0x0

REG32(NMU_WR_FIREWALL_IDS, 0x00000420)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_WR_FIREWALL_IDS, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_WR_FIREWALL_IDS_RESET_VAL 0x0

REG32(NMU_WR_FIREWALL_TRIGG, 0x00000424)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_ISOC_AXI_ERR, 11, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_MMI_AXI_ERR, 10, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PMX_NOC_AXI_ERR, 9, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_RPU_AXI_ERR, 8, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI7_ERR, 7, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI6_ERR, 6, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI5_ERR, 5, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI4_ERR, 4, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI3_ERR, 3, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI2_ERR, 2, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI1_ERR, 1, 1)
    FIELD(NMU_WR_FIREWALL_TRIGG, PSXL_NOC_CCI_AXI0_ERR, 0, 1)
#define NMU_WR_FIREWALL_TRIGG_RESET_VAL 0x0

REG32(NSU_FIREWALL_ISR, 0x00000428)
    FIELD(NSU_FIREWALL_ISR, NOC_PMX_AXI_ERR, 4, 1)
    FIELD(NSU_FIREWALL_ISR, NOC_PSXL_CCI_AXI3_ERR, 3, 1)
    FIELD(NSU_FIREWALL_ISR, NOC_PSXL_CCI_AXI2_ERR, 2, 1)
    FIELD(NSU_FIREWALL_ISR, NOC_PSXL_CCI_AXI1_ERR, 1, 1)
    FIELD(NSU_FIREWALL_ISR, NOC_PSXL_CCI_AXI0_ERR, 0, 1)
#define NSU_FIREWALL_ISR_RESET_VAL 0x0

REG32(NSU_FIREWALL_IMR, 0x0000042c)
    FIELD(NSU_FIREWALL_IMR, NOC_PMX_AXI_ERR, 4, 1)
    FIELD(NSU_FIREWALL_IMR, NOC_PSXL_CCI_AXI3_ERR, 3, 1)
    FIELD(NSU_FIREWALL_IMR, NOC_PSXL_CCI_AXI2_ERR, 2, 1)
    FIELD(NSU_FIREWALL_IMR, NOC_PSXL_CCI_AXI1_ERR, 1, 1)
    FIELD(NSU_FIREWALL_IMR, NOC_PSXL_CCI_AXI0_ERR, 0, 1)
#define NSU_FIREWALL_IMR_RESET_VAL 0x1f

REG32(NSU_FIREWALL_IEN, 0x00000430)
    FIELD(NSU_FIREWALL_IEN, NOC_PMX_AXI_ERR, 4, 1)
    FIELD(NSU_FIREWALL_IEN, NOC_PSXL_CCI_AXI3_ERR, 3, 1)
    FIELD(NSU_FIREWALL_IEN, NOC_PSXL_CCI_AXI2_ERR, 2, 1)
    FIELD(NSU_FIREWALL_IEN, NOC_PSXL_CCI_AXI1_ERR, 1, 1)
    FIELD(NSU_FIREWALL_IEN, NOC_PSXL_CCI_AXI0_ERR, 0, 1)
#define NSU_FIREWALL_IEN_RESET_VAL 0x0

REG32(NSU_FIREWALL_IDS, 0x00000434)
    FIELD(NSU_FIREWALL_IDS, NOC_PMX_AXI_ERR, 4, 1)
    FIELD(NSU_FIREWALL_IDS, NOC_PSXL_CCI_AXI3_ERR, 3, 1)
    FIELD(NSU_FIREWALL_IDS, NOC_PSXL_CCI_AXI2_ERR, 2, 1)
    FIELD(NSU_FIREWALL_IDS, NOC_PSXL_CCI_AXI1_ERR, 1, 1)
    FIELD(NSU_FIREWALL_IDS, NOC_PSXL_CCI_AXI0_ERR, 0, 1)
#define NSU_FIREWALL_IDS_RESET_VAL 0x0

REG32(NSU_FIREWALL_TRIGG, 0x00000438)
    FIELD(NSU_FIREWALL_TRIGG, NOC_PMX_AXI_ERR, 4, 1)
    FIELD(NSU_FIREWALL_TRIGG, NOC_PSXL_CCI_AXI3_ERR, 3, 1)
    FIELD(NSU_FIREWALL_TRIGG, NOC_PSXL_CCI_AXI2_ERR, 2, 1)
    FIELD(NSU_FIREWALL_TRIGG, NOC_PSXL_CCI_AXI1_ERR, 1, 1)
    FIELD(NSU_FIREWALL_TRIGG, NOC_PSXL_CCI_AXI0_ERR, 0, 1)
#define NSU_FIREWALL_TRIGG_RESET_VAL 0x0

REG32(RPU_PCIL_ISR, 0x00000440)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_1E, 9, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_0E, 8, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_1D, 7, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_1C, 6, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_0D, 5, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_0C, 4, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_1B, 3, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_1A, 2, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_0B, 1, 1)
    FIELD(RPU_PCIL_ISR, RPU_PCIL_ERR_CORE_0A, 0, 1)
#define RPU_PCIL_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_IMR, 0x00000444)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_1E, 9, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_0E, 8, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_1D, 7, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_1C, 6, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_0D, 5, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_0C, 4, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_1B, 3, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_1A, 2, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_0B, 1, 1)
    FIELD(RPU_PCIL_IMR, RPU_PCIL_ERR_CORE_0A, 0, 1)
#define RPU_PCIL_IMR_RESET_VAL 0x3ff

REG32(RPU_PCIL_IEN, 0x00000448)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_1E, 9, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_0E, 8, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_1D, 7, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_1C, 6, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_0D, 5, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_0C, 4, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_1B, 3, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_1A, 2, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_0B, 1, 1)
    FIELD(RPU_PCIL_IEN, RPU_PCIL_ERR_CORE_0A, 0, 1)
#define RPU_PCIL_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_IDS, 0x0000044c)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_1E, 9, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_0E, 8, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_1D, 7, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_1C, 6, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_0D, 5, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_0C, 4, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_1B, 3, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_1A, 2, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_0B, 1, 1)
    FIELD(RPU_PCIL_IDS, RPU_PCIL_ERR_CORE_0A, 0, 1)
#define RPU_PCIL_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_TRIGG, 0x00000450)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_1E, 9, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_0E, 8, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_1D, 7, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_1C, 6, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_0D, 5, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_0C, 4, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_1B, 3, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_1A, 2, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_0B, 1, 1)
    FIELD(RPU_PCIL_TRIGG, RPU_PCIL_ERR_CORE_0A, 0, 1)
#define RPU_PCIL_TRIGG_RESET_VAL 0x0

REG32(ZDMA_LS_CMP_OUT_ISR, 0x00000500)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_REG, 21, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_REG, 20, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_AFIFO_ZDMA, 19, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_AFIFO_ZDMA, 18, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI7, 15, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI7, 14, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI6, 13, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI6, 12, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI5, 11, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI5, 10, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI4, 9, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI4, 8, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI3, 7, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI3, 6, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI2, 5, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI2, 4, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI1, 3, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI1, 2, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, OUT_FCI0, 1, 1)
    FIELD(ZDMA_LS_CMP_OUT_ISR, ERR_FCI0, 0, 1)
#define ZDMA_LS_CMP_OUT_ISR_RESET_VAL 0x0

REG32(ZDMA_LS_CMP_OUT_IMR, 0x00000504)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_REG, 21, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_REG, 20, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_AFIFO_ZDMA, 19, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_AFIFO_ZDMA, 18, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI7, 15, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI7, 14, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI6, 13, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI6, 12, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI5, 11, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI5, 10, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI4, 9, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI4, 8, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI3, 7, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI3, 6, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI2, 5, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI2, 4, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI1, 3, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI1, 2, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, OUT_FCI0, 1, 1)
    FIELD(ZDMA_LS_CMP_OUT_IMR, ERR_FCI0, 0, 1)
#define ZDMA_LS_CMP_OUT_IMR_RESET_VAL 0x3fffff

REG32(ZDMA_LS_CMP_OUT_IEN, 0x00000508)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_REG, 21, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_REG, 20, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_AFIFO_ZDMA, 19, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_AFIFO_ZDMA, 18, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI7, 15, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI7, 14, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI6, 13, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI6, 12, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI5, 11, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI5, 10, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI4, 9, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI4, 8, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI3, 7, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI3, 6, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI2, 5, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI2, 4, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI1, 3, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI1, 2, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, OUT_FCI0, 1, 1)
    FIELD(ZDMA_LS_CMP_OUT_IEN, ERR_FCI0, 0, 1)
#define ZDMA_LS_CMP_OUT_IEN_RESET_VAL 0x0

REG32(ZDMA_LS_CMP_OUT_IDS, 0x0000050c)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_REG, 21, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_REG, 20, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_AFIFO_ZDMA, 19, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_AFIFO_ZDMA, 18, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI7, 15, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI7, 14, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI6, 13, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI6, 12, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI5, 11, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI5, 10, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI4, 9, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI4, 8, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI3, 7, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI3, 6, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI2, 5, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI2, 4, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI1, 3, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI1, 2, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, OUT_FCI0, 1, 1)
    FIELD(ZDMA_LS_CMP_OUT_IDS, ERR_FCI0, 0, 1)
#define ZDMA_LS_CMP_OUT_IDS_RESET_VAL 0x0

REG32(ZDMA_LS_CMP_OUT_TRIGG, 0x00000510)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_REG, 21, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_REG, 20, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_AFIFO_ZDMA, 19, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_AFIFO_ZDMA, 18, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI7, 15, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI7, 14, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI6, 13, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI6, 12, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI5, 11, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI5, 10, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI4, 9, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI4, 8, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI3, 7, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI3, 6, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI2, 5, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI2, 4, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI1, 3, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI1, 2, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, OUT_FCI0, 1, 1)
    FIELD(ZDMA_LS_CMP_OUT_TRIGG, ERR_FCI0, 0, 1)
#define ZDMA_LS_CMP_OUT_TRIGG_RESET_VAL 0x0

REG32(ZDMA_SYNC_LS_CMP_OUT_ISR, 0x00000520)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI7, 15, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI6, 14, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI5, 13, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI4, 12, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI3, 11, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI2, 10, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI1, 9, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, OUT_FCI0, 8, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI7, 7, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI6, 6, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI5, 5, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI4, 4, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI3, 3, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI2, 2, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI1, 1, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_ISR, ERR_FCI0, 0, 1)
#define ZDMA_SYNC_LS_CMP_OUT_ISR_RESET_VAL 0x0

REG32(ZDMA_SYNC_LS_CMP_OUT_IMR, 0x00000524)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI7, 15, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI6, 14, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI5, 13, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI4, 12, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI3, 11, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI2, 10, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI1, 9, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, OUT_FCI0, 8, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI7, 7, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI6, 6, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI5, 5, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI4, 4, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI3, 3, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI2, 2, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI1, 1, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IMR, ERR_FCI0, 0, 1)
#define ZDMA_SYNC_LS_CMP_OUT_IMR_RESET_VAL 0x3ffff

REG32(ZDMA_SYNC_LS_CMP_OUT_IEN, 0x00000528)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI7, 15, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI6, 14, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI5, 13, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI4, 12, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI3, 11, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI2, 10, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI1, 9, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, OUT_FCI0, 8, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI7, 7, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI6, 6, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI5, 5, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI4, 4, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI3, 3, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI2, 2, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI1, 1, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IEN, ERR_FCI0, 0, 1)
#define ZDMA_SYNC_LS_CMP_OUT_IEN_RESET_VAL 0x0

REG32(ZDMA_SYNC_LS_CMP_OUT_IDS, 0x0000052c)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI7, 15, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI6, 14, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI5, 13, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI4, 12, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI3, 11, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI2, 10, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI1, 9, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, OUT_FCI0, 8, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI7, 7, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI6, 6, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI5, 5, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI4, 4, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI3, 3, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI2, 2, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI1, 1, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_IDS, ERR_FCI0, 0, 1)
#define ZDMA_SYNC_LS_CMP_OUT_IDS_RESET_VAL 0x0

REG32(ZDMA_SYNC_LS_CMP_OUT_TRIGG, 0x00000530)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_ZDMA, 17, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_ZDMA, 16, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI7, 15, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI6, 14, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI5, 13, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI4, 12, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI3, 11, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI2, 10, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI1, 9, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, OUT_FCI0, 8, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI7, 7, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI6, 6, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI5, 5, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI4, 4, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI3, 3, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI2, 2, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI1, 1, 1)
    FIELD(ZDMA_SYNC_LS_CMP_OUT_TRIGG, ERR_FCI0, 0, 1)
#define ZDMA_SYNC_LS_CMP_OUT_TRIGG_RESET_VAL 0x0

REG32(LPX_DFX_ERR_ISR, 0x00000554)
    FIELD(LPX_DFX_ERR_ISR, ASU_DFX, 8, 1)
    FIELD(LPX_DFX_ERR_ISR, LPX_DFX, 7, 1)
    FIELD(LPX_DFX_ERR_ISR, RPUE_DFX, 6, 1)
    FIELD(LPX_DFX_ERR_ISR, RPUD_DFX, 5, 1)
    FIELD(LPX_DFX_ERR_ISR, RPUC_DFX, 4, 1)
    FIELD(LPX_DFX_ERR_ISR, RPUB_DFX, 3, 1)
    FIELD(LPX_DFX_ERR_ISR, RPUA_DFX, 2, 1)
    FIELD(LPX_DFX_ERR_ISR, LPXIOU_DFX, 1, 1)
    FIELD(LPX_DFX_ERR_ISR, OCM_DFX, 0, 1)
#define LPX_DFX_ERR_ISR_RESET_VAL 0x0

REG32(LPX_DFX_ERR_IMR, 0x00000558)
    FIELD(LPX_DFX_ERR_IMR, ASU_DFX, 8, 1)
    FIELD(LPX_DFX_ERR_IMR, LPX_DFX, 7, 1)
    FIELD(LPX_DFX_ERR_IMR, RPUE_DFX, 6, 1)
    FIELD(LPX_DFX_ERR_IMR, RPUD_DFX, 5, 1)
    FIELD(LPX_DFX_ERR_IMR, RPUC_DFX, 4, 1)
    FIELD(LPX_DFX_ERR_IMR, RPUB_DFX, 3, 1)
    FIELD(LPX_DFX_ERR_IMR, RPUA_DFX, 2, 1)
    FIELD(LPX_DFX_ERR_IMR, LPXIOU_DFX, 1, 1)
    FIELD(LPX_DFX_ERR_IMR, OCM_DFX, 0, 1)
#define LPX_DFX_ERR_IMR_RESET_VAL 0x1ff

REG32(LPX_DFX_ERR_IEN, 0x0000055c)
    FIELD(LPX_DFX_ERR_IEN, ASU_DFX, 8, 1)
    FIELD(LPX_DFX_ERR_IEN, LPX_DFX, 7, 1)
    FIELD(LPX_DFX_ERR_IEN, RPUE_DFX, 6, 1)
    FIELD(LPX_DFX_ERR_IEN, RPUD_DFX, 5, 1)
    FIELD(LPX_DFX_ERR_IEN, RPUC_DFX, 4, 1)
    FIELD(LPX_DFX_ERR_IEN, RPUB_DFX, 3, 1)
    FIELD(LPX_DFX_ERR_IEN, RPUA_DFX, 2, 1)
    FIELD(LPX_DFX_ERR_IEN, LPXIOU_DFX, 1, 1)
    FIELD(LPX_DFX_ERR_IEN, OCM_DFX, 0, 1)
#define LPX_DFX_ERR_IEN_RESET_VAL 0x0

REG32(LPX_DFX_ERR_IDS, 0x00000560)
    FIELD(LPX_DFX_ERR_IDS, ASU_DFX, 8, 1)
    FIELD(LPX_DFX_ERR_IDS, LPX_DFX, 7, 1)
    FIELD(LPX_DFX_ERR_IDS, RPUE_DFX, 6, 1)
    FIELD(LPX_DFX_ERR_IDS, RPUD_DFX, 5, 1)
    FIELD(LPX_DFX_ERR_IDS, RPUC_DFX, 4, 1)
    FIELD(LPX_DFX_ERR_IDS, RPUB_DFX, 3, 1)
    FIELD(LPX_DFX_ERR_IDS, RPUA_DFX, 2, 1)
    FIELD(LPX_DFX_ERR_IDS, LPXIOU_DFX, 1, 1)
    FIELD(LPX_DFX_ERR_IDS, OCM_DFX, 0, 1)
#define LPX_DFX_ERR_IDS_RESET_VAL 0x0

REG32(LPX_DFX_ERR_TRIGG, 0x00000564)
    FIELD(LPX_DFX_ERR_TRIGG, ASU_DFX, 8, 1)
    FIELD(LPX_DFX_ERR_TRIGG, LPX_DFX, 7, 1)
    FIELD(LPX_DFX_ERR_TRIGG, RPUE_DFX, 6, 1)
    FIELD(LPX_DFX_ERR_TRIGG, RPUD_DFX, 5, 1)
    FIELD(LPX_DFX_ERR_TRIGG, RPUC_DFX, 4, 1)
    FIELD(LPX_DFX_ERR_TRIGG, RPUB_DFX, 3, 1)
    FIELD(LPX_DFX_ERR_TRIGG, RPUA_DFX, 2, 1)
    FIELD(LPX_DFX_ERR_TRIGG, LPXIOU_DFX, 1, 1)
    FIELD(LPX_DFX_ERR_TRIGG, OCM_DFX, 0, 1)
#define LPX_DFX_ERR_TRIGG_RESET_VAL 0x0

REG32(ZDMA_LS_CMP_ERR_REG, 0x00000568)
    FIELD(ZDMA_LS_CMP_ERR_REG, ZDMA_SYNC_LS_CMP_OUT_ISR_IRQ_ST, 1, 1)
    FIELD(ZDMA_LS_CMP_ERR_REG, ZDMA_LS_CMP_OUT_ISR_IRQ_ST, 0, 1)
#define ZDMA_LS_CMP_ERR_REG_RESET_VAL 0x0

REG32(PSXC_SPLITTER_FATAL_ERR, 0x0000056c)
    FIELD(PSXC_SPLITTER_FATAL_ERR, PSXC_SPLITTER3_FATAL_ERR, 3, 1)
    FIELD(PSXC_SPLITTER_FATAL_ERR, PSXC_SPLITTER2_FATAL_ERR, 2, 1)
    FIELD(PSXC_SPLITTER_FATAL_ERR, PSXC_SPLITTER1_FATAL_ERR, 1, 1)
    FIELD(PSXC_SPLITTER_FATAL_ERR, PSXC_SPLITTER0_FATAL_ERR, 0, 1)
#define PSXC_SPLITTER_FATAL_ERR_RESET_VAL 0x0

REG32(PSXC_RPUA_CORE_CLUSTER_FATAL, 0x00000570)
    FIELD(PSXC_RPUA_CORE_CLUSTER_FATAL, PSXC_RPUA_CORE1_FATAL, 2, 1)
    FIELD(PSXC_RPUA_CORE_CLUSTER_FATAL, PSXC_RPUA_CORE0_FATAL, 1, 1)
    FIELD(PSXC_RPUA_CORE_CLUSTER_FATAL, PSXC_RPUA_CLUSTER_FATAL, 0, 1)
#define PSXC_RPUA_CORE_CLUSTER_FATAL_RESET_VAL 0x0

REG32(PSXC_RPUB_CORE_CLUSTER_FATAL, 0x00000574)
    FIELD(PSXC_RPUB_CORE_CLUSTER_FATAL, PSXC_RPUB_CORE1_FATAL, 2, 1)
    FIELD(PSXC_RPUB_CORE_CLUSTER_FATAL, PSXC_RPUB_CORE0_FATAL, 1, 1)
    FIELD(PSXC_RPUB_CORE_CLUSTER_FATAL, PSXC_RPUB_CLUSTER_FATAL, 0, 1)
#define PSXC_RPUB_CORE_CLUSTER_FATAL_RESET_VAL 0x0

REG32(PSXC_RPUC_CORE_CLUSTER_FATAL, 0x00000578)
    FIELD(PSXC_RPUC_CORE_CLUSTER_FATAL, PSXC_RPUC_CORE1_FATAL, 2, 1)
    FIELD(PSXC_RPUC_CORE_CLUSTER_FATAL, PSXC_RPUC_CORE0_FATAL, 1, 1)
    FIELD(PSXC_RPUC_CORE_CLUSTER_FATAL, PSXC_RPUC_CLUSTER_FATAL, 0, 1)
#define PSXC_RPUC_CORE_CLUSTER_FATAL_RESET_VAL 0x0

REG32(PSXC_RPUD_CORE_CLUSTER_FATAL, 0x0000057c)
    FIELD(PSXC_RPUD_CORE_CLUSTER_FATAL, PSXC_RPUD_CORE1_FATAL, 2, 1)
    FIELD(PSXC_RPUD_CORE_CLUSTER_FATAL, PSXC_RPUD_CORE0_FATAL, 1, 1)
    FIELD(PSXC_RPUD_CORE_CLUSTER_FATAL, PSXC_RPUD_CLUSTER_FATAL, 0, 1)
#define PSXC_RPUD_CORE_CLUSTER_FATAL_RESET_VAL 0x0

REG32(PSXC_RPUE_CORE_CLUSTER_FATAL, 0x00000580)
    FIELD(PSXC_RPUE_CORE_CLUSTER_FATAL, PSXC_RPUE_CORE1_FATAL, 2, 1)
    FIELD(PSXC_RPUE_CORE_CLUSTER_FATAL, PSXC_RPUE_CORE0_FATAL, 1, 1)
    FIELD(PSXC_RPUE_CORE_CLUSTER_FATAL, PSXC_RPUE_CLUSTER_FATAL, 0, 1)
#define PSXC_RPUE_CORE_CLUSTER_FATAL_RESET_VAL 0x0

REG32(INT_LPXASILB_CORR_ERR_ISR, 0x00000584)
    FIELD(INT_LPXASILB_CORR_ERR_ISR, INT_IOU_CORR_ERR, 2, 1)
    FIELD(INT_LPXASILB_CORR_ERR_ISR, INT_OCM_ASILB_CORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_CORR_ERR_ISR, INT_LPX_ASILB_CORR_ERR, 0, 1)
#define INT_LPXASILB_CORR_ERR_ISR_RESET_VAL 0x0

REG32(INT_LPXASILB_CORR_ERR_IMR, 0x00000588)
    FIELD(INT_LPXASILB_CORR_ERR_IMR, INT_IOU_CORR_ERR, 2, 1)
    FIELD(INT_LPXASILB_CORR_ERR_IMR, INT_OCM_ASILB_CORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_CORR_ERR_IMR, INT_LPX_ASILB_CORR_ERR, 0, 1)
#define INT_LPXASILB_CORR_ERR_IMR_RESET_VAL 0x7

REG32(INT_LPXASILB_CORR_ERR_IEN, 0x0000058c)
    FIELD(INT_LPXASILB_CORR_ERR_IEN, INT_IOU_CORR_ERR, 2, 1)
    FIELD(INT_LPXASILB_CORR_ERR_IEN, INT_OCM_ASILB_CORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_CORR_ERR_IEN, INT_LPX_ASILB_CORR_ERR, 0, 1)
#define INT_LPXASILB_CORR_ERR_IEN_RESET_VAL 0x0

REG32(INT_LPXASILB_CORR_ERR_IDS, 0x00000590)
    FIELD(INT_LPXASILB_CORR_ERR_IDS, INT_IOU_CORR_ERR, 2, 1)
    FIELD(INT_LPXASILB_CORR_ERR_IDS, INT_OCM_ASILB_CORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_CORR_ERR_IDS, INT_LPX_ASILB_CORR_ERR, 0, 1)
#define INT_LPXASILB_CORR_ERR_IDS_RESET_VAL 0x0

REG32(INT_LPXASILB_CORR_ERR_TRIGG, 0x00000594)
    FIELD(INT_LPXASILB_CORR_ERR_TRIGG, INT_IOU_CORR_ERR, 2, 1)
    FIELD(INT_LPXASILB_CORR_ERR_TRIGG, INT_OCM_ASILB_CORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_CORR_ERR_TRIGG, INT_LPX_ASILB_CORR_ERR, 0, 1)
#define INT_LPXASILB_CORR_ERR_TRIGG_RESET_VAL 0x0

REG32(INT_LPXASILB_UNCORR_ERR_ISR, 0x00000598)
    FIELD(INT_LPXASILB_UNCORR_ERR_ISR, INT_IOU_CORR_UNCORRERR, 2, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_ISR, INT_OCM_ASILB_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_ISR, INT_LPX_ASILB_UNCORR_ERR, 0, 1)
#define INT_LPXASILB_UNCORR_ERR_ISR_RESET_VAL 0x0

REG32(INT_LPXASILB_UNCORR_ERR_IMR, 0x0000059c)
    FIELD(INT_LPXASILB_UNCORR_ERR_IMR, INT_IOU_CORR_UNCORRERR, 2, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_IMR, INT_OCM_ASILB_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_IMR, INT_LPX_ASILB_UNCORR_ERR, 0, 1)
#define INT_LPXASILB_UNCORR_ERR_IMR_RESET_VAL 0x7

REG32(INT_LPXASILB_UNCORR_ERR_IEN, 0x000005a0)
    FIELD(INT_LPXASILB_UNCORR_ERR_IEN, INT_IOU_CORR_UNCORRERR, 2, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_IEN, INT_OCM_ASILB_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_IEN, INT_LPX_ASILB_UNCORR_ERR, 0, 1)
#define INT_LPXASILB_UNCORR_ERR_IEN_RESET_VAL 0x0

REG32(INT_LPXASILB_UNCORR_ERR_IDS, 0x000005a4)
    FIELD(INT_LPXASILB_UNCORR_ERR_IDS, INT_IOU_CORR_UNCORRERR, 2, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_IDS, INT_OCM_ASILB_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_IDS, INT_LPX_ASILB_UNCORR_ERR, 0, 1)
#define INT_LPXASILB_UNCORR_ERR_IDS_RESET_VAL 0x0

REG32(INT_LPXASILB_UNCORR_ERR_TRIGG, 0x000005a8)
    FIELD(INT_LPXASILB_UNCORR_ERR_TRIGG, INT_IOU_CORR_UNCORRERR, 2, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_TRIGG, INT_OCM_ASILB_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILB_UNCORR_ERR_TRIGG, INT_LPX_ASILB_UNCORR_ERR, 0, 1)
#define INT_LPXASILB_UNCORR_ERR_TRIGG_RESET_VAL 0x0

REG32(INT_LPXASILD_CORR_ERR_ISR, 0x000005ac)
    FIELD(INT_LPXASILD_CORR_ERR_ISR, INTOCM_ASILD_CR, 1, 1)
    FIELD(INT_LPXASILD_CORR_ERR_ISR, INTLPD_ASILD_CR, 0, 1)
#define INT_LPXASILD_CORR_ERR_ISR_RESET_VAL 0x0

REG32(INT_LPXASILD_CORR_ERR_IMR, 0x000005b0)
    FIELD(INT_LPXASILD_CORR_ERR_IMR, INTOCM_ASILD_CR, 1, 1)
    FIELD(INT_LPXASILD_CORR_ERR_IMR, INTLPD_ASILD_CR, 0, 1)
#define INT_LPXASILD_CORR_ERR_IMR_RESET_VAL 0x3

REG32(INT_LPXASILD_CORR_ERR_IEN, 0x000005b4)
    FIELD(INT_LPXASILD_CORR_ERR_IEN, INTOCM_ASILD_CR, 1, 1)
    FIELD(INT_LPXASILD_CORR_ERR_IEN, INTLPD_ASILD_CR, 0, 1)
#define INT_LPXASILD_CORR_ERR_IEN_RESET_VAL 0x0

REG32(INT_LPXASILD_CORR_ERR_IDS, 0x000005b8)
    FIELD(INT_LPXASILD_CORR_ERR_IDS, INTOCM_ASILD_CR, 1, 1)
    FIELD(INT_LPXASILD_CORR_ERR_IDS, INTLPD_ASILD_CR, 0, 1)
#define INT_LPXASILD_CORR_ERR_IDS_RESET_VAL 0x0

REG32(INT_LPXASILD_CORR_ERR_TRIGG, 0x000005bc)
    FIELD(INT_LPXASILD_CORR_ERR_TRIGG, INTOCM_ASILD_CR, 1, 1)
    FIELD(INT_LPXASILD_CORR_ERR_TRIGG, INTLPD_ASILD_CR, 0, 1)
#define INT_LPXASILD_CORR_ERR_TRIGG_RESET_VAL 0x0

REG32(INT_LPXASILD_UNCORR_ERR_ISR, 0x000005c0)
    FIELD(INT_LPXASILD_UNCORR_ERR_ISR, INTOCM_ASILD_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILD_UNCORR_ERR_ISR, INTLPD_ASILD_UNCORR_ERR, 0, 1)
#define INT_LPXASILD_UNCORR_ERR_ISR_RESET_VAL 0x0

REG32(INT_LPXASILD_UNCORR_ERR_IMR, 0x000005c4)
    FIELD(INT_LPXASILD_UNCORR_ERR_IMR, INTOCM_ASILD_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILD_UNCORR_ERR_IMR, INTLPD_ASILD_UNCORR_ERR, 0, 1)
#define INT_LPXASILD_UNCORR_ERR_IMR_RESET_VAL 0x3

REG32(INT_LPXASILD_UNCORR_ERR_IEN, 0x000005c8)
    FIELD(INT_LPXASILD_UNCORR_ERR_IEN, INTOCM_ASILD_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILD_UNCORR_ERR_IEN, INTLPD_ASILD_UNCORR_ERR, 0, 1)
#define INT_LPXASILD_UNCORR_ERR_IEN_RESET_VAL 0x0

REG32(INT_LPXASILD_UNCORR_ERR_IDS, 0x000005cc)
    FIELD(INT_LPXASILD_UNCORR_ERR_IDS, INTOCM_ASILD_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILD_UNCORR_ERR_IDS, INTLPD_ASILD_UNCORR_ERR, 0, 1)
#define INT_LPXASILD_UNCORR_ERR_IDS_RESET_VAL 0x0

REG32(INT_LPXASILD_UNCORR_ERR_TRIGG, 0x000005d0)
    FIELD(INT_LPXASILD_UNCORR_ERR_TRIGG, INTOCM_ASILD_UNCORR_ERR, 1, 1)
    FIELD(INT_LPXASILD_UNCORR_ERR_TRIGG, INTLPD_ASILD_UNCORR_ERR, 0, 1)
#define INT_LPXASILD_UNCORR_ERR_TRIGG_RESET_VAL 0x0

REG32(INT_LPXASILB_IRQ_ISR, 0x000005d4)
    FIELD(INT_LPXASILB_IRQ_ISR, INT_OCM_ASILB_IRQ, 1, 1)
    FIELD(INT_LPXASILB_IRQ_ISR, INT_LPX_ASILB_IRQ, 0, 1)
#define INT_LPXASILB_IRQ_ISR_RESET_VAL 0x0

REG32(INT_LPXASILB_IRQ_IMR, 0x000005d8)
    FIELD(INT_LPXASILB_IRQ_IMR, INT_OCM_ASILB_IRQ, 1, 1)
    FIELD(INT_LPXASILB_IRQ_IMR, INT_LPX_ASILB_IRQ, 0, 1)
#define INT_LPXASILB_IRQ_IMR_RESET_VAL 0x3

REG32(INT_LPXASILB_IRQ_IEN, 0x000005dc)
    FIELD(INT_LPXASILB_IRQ_IEN, INT_OCM_ASILB_IRQ, 1, 1)
    FIELD(INT_LPXASILB_IRQ_IEN, INT_LPX_ASILB_IRQ, 0, 1)
#define INT_LPXASILB_IRQ_IEN_RESET_VAL 0x0

REG32(INT_LPXASILB_IRQ_IDS, 0x000005e0)
    FIELD(INT_LPXASILB_IRQ_IDS, INT_OCM_ASILB_IRQ, 1, 1)
    FIELD(INT_LPXASILB_IRQ_IDS, INT_LPX_ASILB_IRQ, 0, 1)
#define INT_LPXASILB_IRQ_IDS_RESET_VAL 0x0

REG32(INT_LPXASILB_IRQ_TRIGG, 0x000005e4)
    FIELD(INT_LPXASILB_IRQ_TRIGG, INT_OCM_ASILB_IRQ, 1, 1)
    FIELD(INT_LPXASILB_IRQ_TRIGG, INT_LPX_ASILB_IRQ, 0, 1)
#define INT_LPXASILB_IRQ_TRIGG_RESET_VAL 0x0

REG32(INT_LPXASILD_IRQ_ISR, 0x000005e8)
    FIELD(INT_LPXASILD_IRQ_ISR, INT_OCM_ASILD_IRQ, 1, 1)
    FIELD(INT_LPXASILD_IRQ_ISR, INT_LPX_ASILD_IRQ, 0, 1)
#define INT_LPXASILD_IRQ_ISR_RESET_VAL 0x0

REG32(INT_LPXASILD_IRQ_IMR, 0x000005ec)
    FIELD(INT_LPXASILD_IRQ_IMR, INT_OCM_ASILD_IRQ, 1, 1)
    FIELD(INT_LPXASILD_IRQ_IMR, INT_LPX_ASILD_IRQ, 0, 1)
#define INT_LPXASILD_IRQ_IMR_RESET_VAL 0x3

REG32(INT_LPXASILD_IRQ_IEN, 0x000005f0)
    FIELD(INT_LPXASILD_IRQ_IEN, INT_OCM_ASILD_IRQ, 1, 1)
    FIELD(INT_LPXASILD_IRQ_IEN, INT_LPX_ASILD_IRQ, 0, 1)
#define INT_LPXASILD_IRQ_IEN_RESET_VAL 0x0

REG32(INT_LPXASILD_IRQ_IDS, 0x000005f4)
    FIELD(INT_LPXASILD_IRQ_IDS, INT_OCM_ASILD_IRQ, 1, 1)
    FIELD(INT_LPXASILD_IRQ_IDS, INT_LPX_ASILD_IRQ, 0, 1)
#define INT_LPXASILD_IRQ_IDS_RESET_VAL 0x0

REG32(INT_LPXASILD_IRQ_TRIGG, 0x000005f8)
    FIELD(INT_LPXASILD_IRQ_TRIGG, INT_OCM_ASILD_IRQ, 1, 1)
    FIELD(INT_LPXASILD_IRQ_TRIGG, INT_LPX_ASILD_IRQ, 0, 1)
#define INT_LPXASILD_IRQ_TRIGG_RESET_VAL 0x0

REG32(LPX_PSM_DONE_ISR, 0x000005fc)
    FIELD(LPX_PSM_DONE_ISR, APU3_CORE1_PSM_DONE, 17, 1)
    FIELD(LPX_PSM_DONE_ISR, APU3_CORE0_PSM_DONE, 16, 1)
    FIELD(LPX_PSM_DONE_ISR, APU2_CORE1_PSM_DONE, 15, 1)
    FIELD(LPX_PSM_DONE_ISR, APU2_CORE0_PSM_DONE, 14, 1)
    FIELD(LPX_PSM_DONE_ISR, APU1_CORE1_PSM_DONE, 13, 1)
    FIELD(LPX_PSM_DONE_ISR, APU1_CORE0_PSM_DONE, 12, 1)
    FIELD(LPX_PSM_DONE_ISR, APU0_CORE1_PSM_DONE, 11, 1)
    FIELD(LPX_PSM_DONE_ISR, APU0_CORE0_PSM_DONE, 10, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU1E_PSM_DONE, 9, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU0E_PSM_DONE, 8, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU1D_PSM_DONE, 7, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU0D_PSM_DONE, 6, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU1C_PSM_DONE, 5, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU0C_PSM_DONE, 4, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU1B_PSM_DONE, 3, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU0B_PSM_DONE, 2, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU1A_PSM_DONE, 1, 1)
    FIELD(LPX_PSM_DONE_ISR, RPU0A_PSM_DONE, 0, 1)
#define LPX_PSM_DONE_ISR_RESET_VAL 0x3ffff

REG32(LPX_PSM_DONE_IMR, 0x00000600)
    FIELD(LPX_PSM_DONE_IMR, APU3_CORE1_PSM_DONE, 17, 1)
    FIELD(LPX_PSM_DONE_IMR, APU3_CORE0_PSM_DONE, 16, 1)
    FIELD(LPX_PSM_DONE_IMR, APU2_CORE1_PSM_DONE, 15, 1)
    FIELD(LPX_PSM_DONE_IMR, APU2_CORE0_PSM_DONE, 14, 1)
    FIELD(LPX_PSM_DONE_IMR, APU1_CORE1_PSM_DONE, 13, 1)
    FIELD(LPX_PSM_DONE_IMR, APU1_CORE0_PSM_DONE, 12, 1)
    FIELD(LPX_PSM_DONE_IMR, APU0_CORE1_PSM_DONE, 11, 1)
    FIELD(LPX_PSM_DONE_IMR, APU0_CORE0_PSM_DONE, 10, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU1E_PSM_DONE, 9, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU0E_PSM_DONE, 8, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU1D_PSM_DONE, 7, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU0D_PSM_DONE, 6, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU1C_PSM_DONE, 5, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU0C_PSM_DONE, 4, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU1B_PSM_DONE, 3, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU0B_PSM_DONE, 2, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU1A_PSM_DONE, 1, 1)
    FIELD(LPX_PSM_DONE_IMR, RPU0A_PSM_DONE, 0, 1)
#define LPX_PSM_DONE_IMR_RESET_VAL 0x3ffff

REG32(LPX_PSM_DONE_IEN, 0x00000604)
    FIELD(LPX_PSM_DONE_IEN, APU3_CORE1_PSM_DONE, 17, 1)
    FIELD(LPX_PSM_DONE_IEN, APU3_CORE0_PSM_DONE, 16, 1)
    FIELD(LPX_PSM_DONE_IEN, APU2_CORE1_PSM_DONE, 15, 1)
    FIELD(LPX_PSM_DONE_IEN, APU2_CORE0_PSM_DONE, 14, 1)
    FIELD(LPX_PSM_DONE_IEN, APU1_CORE1_PSM_DONE, 13, 1)
    FIELD(LPX_PSM_DONE_IEN, APU1_CORE0_PSM_DONE, 12, 1)
    FIELD(LPX_PSM_DONE_IEN, APU0_CORE1_PSM_DONE, 11, 1)
    FIELD(LPX_PSM_DONE_IEN, APU0_CORE0_PSM_DONE, 10, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU1E_PSM_DONE, 9, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU0E_PSM_DONE, 8, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU1D_PSM_DONE, 7, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU0D_PSM_DONE, 6, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU1C_PSM_DONE, 5, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU0C_PSM_DONE, 4, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU1B_PSM_DONE, 3, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU0B_PSM_DONE, 2, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU1A_PSM_DONE, 1, 1)
    FIELD(LPX_PSM_DONE_IEN, RPU0A_PSM_DONE, 0, 1)
#define LPX_PSM_DONE_IEN_RESET_VAL 0x0

REG32(LPX_PSM_DONE_IDS, 0x00000608)
    FIELD(LPX_PSM_DONE_IDS, APU3_CORE1_PSM_DONE, 17, 1)
    FIELD(LPX_PSM_DONE_IDS, APU3_CORE0_PSM_DONE, 16, 1)
    FIELD(LPX_PSM_DONE_IDS, APU2_CORE1_PSM_DONE, 15, 1)
    FIELD(LPX_PSM_DONE_IDS, APU2_CORE0_PSM_DONE, 14, 1)
    FIELD(LPX_PSM_DONE_IDS, APU1_CORE1_PSM_DONE, 13, 1)
    FIELD(LPX_PSM_DONE_IDS, APU1_CORE0_PSM_DONE, 12, 1)
    FIELD(LPX_PSM_DONE_IDS, APU0_CORE1_PSM_DONE, 11, 1)
    FIELD(LPX_PSM_DONE_IDS, APU0_CORE0_PSM_DONE, 10, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU1E_PSM_DONE, 9, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU0E_PSM_DONE, 8, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU1D_PSM_DONE, 7, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU0D_PSM_DONE, 6, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU1C_PSM_DONE, 5, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU0C_PSM_DONE, 4, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU1B_PSM_DONE, 3, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU0B_PSM_DONE, 2, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU1A_PSM_DONE, 1, 1)
    FIELD(LPX_PSM_DONE_IDS, RPU0A_PSM_DONE, 0, 1)
#define LPX_PSM_DONE_IDS_RESET_VAL 0x0

REG32(LPX_PSM_DONE_TRIGG, 0x0000060c)
    FIELD(LPX_PSM_DONE_TRIGG, APU3_CORE1_PSM_DONE, 17, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU3_CORE0_PSM_DONE, 16, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU2_CORE1_PSM_DONE, 15, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU2_CORE0_PSM_DONE, 14, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU1_CORE1_PSM_DONE, 13, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU1_CORE0_PSM_DONE, 12, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU0_CORE1_PSM_DONE, 11, 1)
    FIELD(LPX_PSM_DONE_TRIGG, APU0_CORE0_PSM_DONE, 10, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU1E_PSM_DONE, 9, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU0E_PSM_DONE, 8, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU1D_PSM_DONE, 7, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU0D_PSM_DONE, 6, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU1C_PSM_DONE, 5, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU0C_PSM_DONE, 4, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU1B_PSM_DONE, 3, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU0B_PSM_DONE, 2, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU1A_PSM_DONE, 1, 1)
    FIELD(LPX_PSM_DONE_TRIGG, RPU0A_PSM_DONE, 0, 1)
#define LPX_PSM_DONE_TRIGG_RESET_VAL 0x0

REG32(PSXC_SW_ERR, 0x00000700)
    FIELD(PSXC_SW_ERR, NCR_FLAG, 31, 1)
    FIELD(PSXC_SW_ERR, CR_FLAG, 30, 1)
    FIELD(PSXC_SW_ERR, DATA, 0, 30)
#define PSXC_SW_ERR_WRITE_MASK 0xffffffff
#define PSXC_SW_ERR_RESET_VAL 0x0

REG32(TTC0_IRQ_STATUS, 0x00000704)
    FIELD(TTC0_IRQ_STATUS, TTC0, 0, 3)
#define TTC0_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC1_IRQ_STATUS, 0x00000708)
    FIELD(TTC1_IRQ_STATUS, TTC1, 0, 3)
#define TTC1_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC2_IRQ_STATUS, 0x0000070c)
    FIELD(TTC2_IRQ_STATUS, TTC2, 0, 3)
#define TTC2_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC3_IRQ_STATUS, 0x00000710)
    FIELD(TTC3_IRQ_STATUS, TTC3, 0, 3)
#define TTC3_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC4_IRQ_STATUS, 0x00000714)
    FIELD(TTC4_IRQ_STATUS, TTC4, 0, 3)
#define TTC4_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC5_IRQ_STATUS, 0x00000718)
    FIELD(TTC5_IRQ_STATUS, TTC5, 0, 3)
#define TTC5_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC6_IRQ_STATUS, 0x0000071c)
    FIELD(TTC6_IRQ_STATUS, TTC6, 0, 3)
#define TTC6_IRQ_STATUS_RESET_VAL 0x0

REG32(TTC7_IRQ_STATUS, 0x00000720)
    FIELD(TTC7_IRQ_STATUS, TTC7, 0, 3)
#define TTC7_IRQ_STATUS_RESET_VAL 0x0

REG32(MMI_PRESENT_STATUS, 0x00000724)
    FIELD(MMI_PRESENT_STATUS, MMI_PRESENT_STATUS, 0, 1)
#define MMI_PRESENT_STATUS_RESET_VAL 0x1

REG32(ZDMA_LS_CONFIG, 0x00002024)
    FIELD(ZDMA_LS_CONFIG, ERR_INJ_ZDMA, 17, 1)
    FIELD(ZDMA_LS_CONFIG, LS_ENABLE_ZDMA, 16, 1)
    FIELD(ZDMA_LS_CONFIG, ERR_INJ_FCI, 8, 8)
    FIELD(ZDMA_LS_CONFIG, LS_ENABLE_FCI, 0, 8)
#define ZDMA_LS_CONFIG_WRITE_MASK 0x0003ffff
#define ZDMA_LS_CONFIG_RESET_VAL 0x0

REG32(ZDMA_SYNC_LS_CONFIG, 0x00002028)
    FIELD(ZDMA_SYNC_LS_CONFIG, LS_CMP_OUT_ERR_ENABLE_ZDMA, 8, 1)
    FIELD(ZDMA_SYNC_LS_CONFIG, LS_CMP_OUT_ERR_ENABLE_FCI, 0, 8)
#define ZDMA_SYNC_LS_CONFIG_WRITE_MASK 0x000001ff
#define ZDMA_SYNC_LS_CONFIG_RESET_VAL 0x0

REG32(AFI_FS, 0x00009000)
REG32(LPX_CMN_CFG_0, 0x0000a014)
    FIELD(LPX_CMN_CFG_0, CFGM_PERIPHBASE, 0, 22)
#define LPX_CMN_CFG_0_WRITE_MASK 0x003fffff
#define LPX_CMN_CFG_0_RESET_VAL 0x3e

REG32(LPX_APU_CLUSTER0_BRDC_CTRL, 0x0000a044)
    FIELD(LPX_APU_CLUSTER0_BRDC_CTRL, BRDC_ATOMIC, 4, 1)
    FIELD(LPX_APU_CLUSTER0_BRDC_CTRL, BRDC_OUTER, 3, 1)
    FIELD(LPX_APU_CLUSTER0_BRDC_CTRL, BRDC_PERSIST, 2, 1)
    FIELD(LPX_APU_CLUSTER0_BRDC_CTRL, BRDC_CMNT_POU, 1, 1)
    FIELD(LPX_APU_CLUSTER0_BRDC_CTRL, BRDC_CMNT, 0, 1)
#define LPX_APU_CLUSTER0_BRDC_CTRL_WRITE_MASK 0x0000001f
#define LPX_APU_CLUSTER0_BRDC_CTRL_RESET_VAL 0x9

REG32(LPX_APU_CLUSTER1_BRDC_CTRL, 0x0000a048)
    FIELD(LPX_APU_CLUSTER1_BRDC_CTRL, BRDC_ATOMIC, 4, 1)
    FIELD(LPX_APU_CLUSTER1_BRDC_CTRL, BRDC_OUTER, 3, 1)
    FIELD(LPX_APU_CLUSTER1_BRDC_CTRL, BRDC_PERSIST, 2, 1)
    FIELD(LPX_APU_CLUSTER1_BRDC_CTRL, BRDC_CMNT_POU, 1, 1)
    FIELD(LPX_APU_CLUSTER1_BRDC_CTRL, BRDC_CMNT, 0, 1)
#define LPX_APU_CLUSTER1_BRDC_CTRL_WRITE_MASK 0x0000001f
#define LPX_APU_CLUSTER1_BRDC_CTRL_RESET_VAL 0x9

REG32(LPX_APU_CLUSTER2_BRDC_CTRL, 0x0000a04c)
    FIELD(LPX_APU_CLUSTER2_BRDC_CTRL, BRDC_ATOMIC, 4, 1)
    FIELD(LPX_APU_CLUSTER2_BRDC_CTRL, BRDC_OUTER, 3, 1)
    FIELD(LPX_APU_CLUSTER2_BRDC_CTRL, BRDC_PERSIST, 2, 1)
    FIELD(LPX_APU_CLUSTER2_BRDC_CTRL, BRDC_CMNT_POU, 1, 1)
    FIELD(LPX_APU_CLUSTER2_BRDC_CTRL, BRDC_CMNT, 0, 1)
#define LPX_APU_CLUSTER2_BRDC_CTRL_WRITE_MASK 0x0000001f
#define LPX_APU_CLUSTER2_BRDC_CTRL_RESET_VAL 0x9

REG32(LPX_APU_CLUSTER3_BRDC_CTRL, 0x0000a050)
    FIELD(LPX_APU_CLUSTER3_BRDC_CTRL, BRDC_ATOMIC, 4, 1)
    FIELD(LPX_APU_CLUSTER3_BRDC_CTRL, BRDC_OUTER, 3, 1)
    FIELD(LPX_APU_CLUSTER3_BRDC_CTRL, BRDC_PERSIST, 2, 1)
    FIELD(LPX_APU_CLUSTER3_BRDC_CTRL, BRDC_CMNT_POU, 1, 1)
    FIELD(LPX_APU_CLUSTER3_BRDC_CTRL, BRDC_CMNT, 0, 1)
#define LPX_APU_CLUSTER3_BRDC_CTRL_WRITE_MASK 0x0000001f
#define LPX_APU_CLUSTER3_BRDC_CTRL_RESET_VAL 0x9

REG32(LPX_FPX_MMU_TCU, 0x0000a400)
    FIELD(LPX_FPX_MMU_TCU, ECOREVNUM, 6, 4)
    FIELD(LPX_FPX_MMU_TCU, SUP_OAS, 3, 3)
    FIELD(LPX_FPX_MMU_TCU, SUP_SEV, 2, 1)
    FIELD(LPX_FPX_MMU_TCU, SUP_BTM, 1, 1)
    FIELD(LPX_FPX_MMU_TCU, SUP_COHACC, 0, 1)
#define LPX_FPX_MMU_TCU_WRITE_MASK 0x000003ff
#define LPX_FPX_MMU_TCU_RESET_VAL 0x2b

REG32(LPX_FPX_MMU_TBU_0, 0x0000a404)
    FIELD(LPX_FPX_MMU_TBU_0, ECOREVNUM, 20, 4)
    FIELD(LPX_FPX_MMU_TBU_0, UTLB_ROUNDROBIN, 19, 1)
    FIELD(LPX_FPX_MMU_TBU_0, MAX_TOK_TRANS, 18, 1)
    FIELD(LPX_FPX_MMU_TBU_0, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_0, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_0, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_0, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_0_WRITE_MASK 0x00ffffff
#define LPX_FPX_MMU_TBU_0_RESET_VAL 0x60000

REG32(LPX_FPX_MMU_TBU_1, 0x0000a408)
    FIELD(LPX_FPX_MMU_TBU_1, ECOREVNUM, 14, 4)
    FIELD(LPX_FPX_MMU_TBU_1, UTLB_ROUNDROBIN, 13, 1)
    FIELD(LPX_FPX_MMU_TBU_1, MAX_TOK_TRANS, 10, 3)
    FIELD(LPX_FPX_MMU_TBU_1, CMO_DISABLE, 9, 1)
    FIELD(LPX_FPX_MMU_TBU_1, S_SID_HIGH, 5, 4)
    FIELD(LPX_FPX_MMU_TBU_1, NS_SID_HIGH, 1, 4)
    FIELD(LPX_FPX_MMU_TBU_1, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_1_WRITE_MASK 0x0003ffff
#define LPX_FPX_MMU_TBU_1_RESET_VAL 0x1e01

REG32(LPX_FPX_MMU_TBU_2, 0x0000a40c)
    FIELD(LPX_FPX_MMU_TBU_2, ECOREVNUM, 22, 4)
    FIELD(LPX_FPX_MMU_TBU_2, UTLB_ROUNDROBIN, 21, 1)
    FIELD(LPX_FPX_MMU_TBU_2, MAX_TOK_TRANS, 18, 3)
    FIELD(LPX_FPX_MMU_TBU_2, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_2, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_2, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_2, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_2_WRITE_MASK 0x03ffffff
#define LPX_FPX_MMU_TBU_2_RESET_VAL 0xe0000

REG32(LPX_FPX_MMU_TBU_3, 0x0000a410)
    FIELD(LPX_FPX_MMU_TBU_3, ECOREVNUM, 22, 4)
    FIELD(LPX_FPX_MMU_TBU_3, UTLB_ROUNDROBIN, 21, 1)
    FIELD(LPX_FPX_MMU_TBU_3, MAX_TOK_TRANS, 18, 3)
    FIELD(LPX_FPX_MMU_TBU_3, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_3, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_3, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_3, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_3_WRITE_MASK 0x03ffffff
#define LPX_FPX_MMU_TBU_3_RESET_VAL 0xe0000

REG32(LPX_FPX_MMU_TBU_4, 0x0000a414)
    FIELD(LPX_FPX_MMU_TBU_4, ECOREVNUM, 22, 4)
    FIELD(LPX_FPX_MMU_TBU_4, UTLB_ROUNDROBIN, 21, 1)
    FIELD(LPX_FPX_MMU_TBU_4, MAX_TOK_TRANS, 18, 3)
    FIELD(LPX_FPX_MMU_TBU_4, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_4, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_4, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_4, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_4_WRITE_MASK 0x03ffffff
#define LPX_FPX_MMU_TBU_4_RESET_VAL 0xe0000

REG32(LPX_FPX_MMU_TBU_5, 0x0000a418)
    FIELD(LPX_FPX_MMU_TBU_5, ECOREVNUM, 22, 4)
    FIELD(LPX_FPX_MMU_TBU_5, UTLB_ROUNDROBIN, 21, 1)
    FIELD(LPX_FPX_MMU_TBU_5, MAX_TOK_TRANS, 18, 3)
    FIELD(LPX_FPX_MMU_TBU_5, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_5, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_5, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_5, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_5_WRITE_MASK 0x03ffffff
#define LPX_FPX_MMU_TBU_5_RESET_VAL 0x1c0000

REG32(LPX_FPX_MMU_TBU_6, 0x0000a41c)
    FIELD(LPX_FPX_MMU_TBU_6, ECOREVNUM, 22, 4)
    FIELD(LPX_FPX_MMU_TBU_6, UTLB_ROUNDROBIN, 21, 1)
    FIELD(LPX_FPX_MMU_TBU_6, MAX_TOK_TRANS, 18, 3)
    FIELD(LPX_FPX_MMU_TBU_6, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_6, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_6, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_6, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_6_WRITE_MASK 0x03ffffff
#define LPX_FPX_MMU_TBU_6_RESET_VAL 0x1c0000

REG32(LPX_FPX_MMU_TBU_7, 0x0000a420)
    FIELD(LPX_FPX_MMU_TBU_7, ECOREVNUM, 23, 4)
    FIELD(LPX_FPX_MMU_TBU_7, UTLB_ROUNDROBIN, 22, 1)
    FIELD(LPX_FPX_MMU_TBU_7, MAX_TOK_TRANS, 18, 4)
    FIELD(LPX_FPX_MMU_TBU_7, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_7, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_7, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_7, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_7_WRITE_MASK 0x07ffffff
#define LPX_FPX_MMU_TBU_7_RESET_VAL 0x3c0000

REG32(LPX_FPX_MMU_TBU_8, 0x0000a424)
    FIELD(LPX_FPX_MMU_TBU_8, ECOREVNUM, 23, 4)
    FIELD(LPX_FPX_MMU_TBU_8, UTLB_ROUNDROBIN, 22, 1)
    FIELD(LPX_FPX_MMU_TBU_8, MAX_TOK_TRANS, 18, 4)
    FIELD(LPX_FPX_MMU_TBU_8, CMO_DISABLE, 17, 1)
    FIELD(LPX_FPX_MMU_TBU_8, S_SID_HIGH, 9, 8)
    FIELD(LPX_FPX_MMU_TBU_8, NS_SID_HIGH, 1, 8)
    FIELD(LPX_FPX_MMU_TBU_8, PCIE_MODE, 0, 1)
#define LPX_FPX_MMU_TBU_8_WRITE_MASK 0x07ffffff
#define LPX_FPX_MMU_TBU_8_RESET_VAL 0x7e0000

REG32(HNF_POWER_MODE, 0x0000a428)
    FIELD(HNF_POWER_MODE, OP_MODE_3, 28, 4)
    FIELD(HNF_POWER_MODE, POLICY_3, 24, 4)
    FIELD(HNF_POWER_MODE, OP_MODE_2, 20, 4)
    FIELD(HNF_POWER_MODE, POLICY_2, 16, 4)
    FIELD(HNF_POWER_MODE, OP_MODE_1, 12, 4)
    FIELD(HNF_POWER_MODE, POLICY_1, 8, 4)
    FIELD(HNF_POWER_MODE, OP_MODE_0, 4, 4)
    FIELD(HNF_POWER_MODE, POLICY_0, 0, 4)
#define HNF_POWER_MODE_WRITE_MASK 0xffffffff
#define HNF_POWER_MODE_RESET_VAL 0x38383838

REG32(RPU_PCIL_A0_ISR, 0x00010000)
    FIELD(RPU_PCIL_A0_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_A0_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_A0_IMR, 0x00010004)
    FIELD(RPU_PCIL_A0_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_A0_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_A0_IEN, 0x00010008)
    FIELD(RPU_PCIL_A0_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_A0_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_A0_IDS, 0x0001000c)
    FIELD(RPU_PCIL_A0_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_A0_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_A0_PR, 0x00010080)
    FIELD(RPU_PCIL_A0_PR, PREQ, 0, 1)
#define RPU_PCIL_A0_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_A0_PR_RESET_VAL 0x0

REG32(RPU_PCIL_A0_PS, 0x00010084)
    FIELD(RPU_PCIL_A0_PS, PSTATE, 0, 1)
#define RPU_PCIL_A0_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_A0_PS_RESET_VAL 0x0

REG32(RPU_PCIL_A0_PA, 0x00010088)
    FIELD(RPU_PCIL_A0_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_A0_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_A0_PA, PACTIVE, 0, 2)
#define RPU_PCIL_A0_PA_RESET_VAL 0x0

REG32(RPU_PCIL_A1_ISR, 0x00010100)
    FIELD(RPU_PCIL_A1_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_A1_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_A1_IMR, 0x00010104)
    FIELD(RPU_PCIL_A1_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_A1_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_A1_IEN, 0x00010108)
    FIELD(RPU_PCIL_A1_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_A1_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_A1_IDS, 0x0001010c)
    FIELD(RPU_PCIL_A1_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_A1_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_A1_PR, 0x00010180)
    FIELD(RPU_PCIL_A1_PR, PREQ, 0, 1)
#define RPU_PCIL_A1_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_A1_PR_RESET_VAL 0x0

REG32(RPU_PCIL_A1_PS, 0x00010184)
    FIELD(RPU_PCIL_A1_PS, PSTATE, 0, 1)
#define RPU_PCIL_A1_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_A1_PS_RESET_VAL 0x0

REG32(RPU_PCIL_A1_PA, 0x00010188)
    FIELD(RPU_PCIL_A1_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_A1_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_A1_PA, PACTIVE, 0, 2)
#define RPU_PCIL_A1_PA_RESET_VAL 0x0

REG32(RPU_PCIL_B0_ISR, 0x00011000)
    FIELD(RPU_PCIL_B0_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_B0_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_B0_IMR, 0x00011004)
    FIELD(RPU_PCIL_B0_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_B0_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_B0_IEN, 0x00011008)
    FIELD(RPU_PCIL_B0_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_B0_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_B0_IDS, 0x0001100c)
    FIELD(RPU_PCIL_B0_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_B0_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_B0_PR, 0x00011080)
    FIELD(RPU_PCIL_B0_PR, PREQ, 0, 1)
#define RPU_PCIL_B0_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_B0_PR_RESET_VAL 0x0

REG32(RPU_PCIL_B0_PS, 0x00011084)
    FIELD(RPU_PCIL_B0_PS, PSTATE, 0, 1)
#define RPU_PCIL_B0_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_B0_PS_RESET_VAL 0x0

REG32(RPU_PCIL_B0_PA, 0x00011088)
    FIELD(RPU_PCIL_B0_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_B0_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_B0_PA, PACTIVE, 0, 2)
#define RPU_PCIL_B0_PA_RESET_VAL 0x0

REG32(RPU_PCIL_B1_ISR, 0x00011100)
    FIELD(RPU_PCIL_B1_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_B1_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_B1_IMR, 0x00011104)
    FIELD(RPU_PCIL_B1_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_B1_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_B1_IEN, 0x00011108)
    FIELD(RPU_PCIL_B1_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_B1_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_B1_IDS, 0x0001110c)
    FIELD(RPU_PCIL_B1_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_B1_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_B1_PR, 0x00011180)
    FIELD(RPU_PCIL_B1_PR, PREQ, 0, 1)
#define RPU_PCIL_B1_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_B1_PR_RESET_VAL 0x0

REG32(RPU_PCIL_B1_PS, 0x00011184)
    FIELD(RPU_PCIL_B1_PS, PSTATE, 0, 1)
#define RPU_PCIL_B1_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_B1_PS_RESET_VAL 0x0

REG32(RPU_PCIL_B1_PA, 0x00011188)
    FIELD(RPU_PCIL_B1_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_B1_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_B1_PA, PACTIVE, 0, 2)
#define RPU_PCIL_B1_PA_RESET_VAL 0x0

REG32(RPU_PCIL_C0_ISR, 0x000111c4)
    FIELD(RPU_PCIL_C0_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_C0_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_C0_IMR, 0x000111c8)
    FIELD(RPU_PCIL_C0_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_C0_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_C0_IEN, 0x000111cc)
    FIELD(RPU_PCIL_C0_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_C0_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_C0_IDS, 0x000111d0)
    FIELD(RPU_PCIL_C0_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_C0_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_C0_PR, 0x000111d4)
    FIELD(RPU_PCIL_C0_PR, PREQ, 0, 1)
#define RPU_PCIL_C0_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_C0_PR_RESET_VAL 0x0

REG32(RPU_PCIL_C0_PS, 0x000111d8)
    FIELD(RPU_PCIL_C0_PS, PSTATE, 0, 1)
#define RPU_PCIL_C0_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_C0_PS_RESET_VAL 0x0

REG32(RPU_PCIL_C0_PA, 0x000111dc)
    FIELD(RPU_PCIL_C0_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_C0_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_C0_PA, PACTIVE, 0, 2)
#define RPU_PCIL_C0_PA_RESET_VAL 0x0

REG32(RPU_PCIL_C1_ISR, 0x000111e4)
    FIELD(RPU_PCIL_C1_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_C1_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_C1_IMR, 0x000111e8)
    FIELD(RPU_PCIL_C1_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_C1_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_C1_IEN, 0x000111ec)
    FIELD(RPU_PCIL_C1_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_C1_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_C1_IDS, 0x000111f0)
    FIELD(RPU_PCIL_C1_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_C1_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_C1_PR, 0x000111f4)
    FIELD(RPU_PCIL_C1_PR, PREQ, 0, 1)
#define RPU_PCIL_C1_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_C1_PR_RESET_VAL 0x0

REG32(RPU_PCIL_C1_PS, 0x000111f8)
    FIELD(RPU_PCIL_C1_PS, PSTATE, 0, 1)
#define RPU_PCIL_C1_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_C1_PS_RESET_VAL 0x0

REG32(RPU_PCIL_C1_PA, 0x000111fc)
    FIELD(RPU_PCIL_C1_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_C1_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_C1_PA, PACTIVE, 0, 2)
#define RPU_PCIL_C1_PA_RESET_VAL 0x0

REG32(RPU_PCIL_D0_ISR, 0x00011204)
    FIELD(RPU_PCIL_D0_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_D0_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_D0_IMR, 0x00011208)
    FIELD(RPU_PCIL_D0_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_D0_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_D0_IEN, 0x0001120c)
    FIELD(RPU_PCIL_D0_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_D0_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_D0_IDS, 0x00011210)
    FIELD(RPU_PCIL_D0_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_D0_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_D0_PR, 0x00011214)
    FIELD(RPU_PCIL_D0_PR, PREQ, 0, 1)
#define RPU_PCIL_D0_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_D0_PR_RESET_VAL 0x0

REG32(RPU_PCIL_D0_PS, 0x00011218)
    FIELD(RPU_PCIL_D0_PS, PSTATE, 0, 1)
#define RPU_PCIL_D0_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_D0_PS_RESET_VAL 0x0

REG32(RPU_PCIL_D0_PA, 0x0001121c)
    FIELD(RPU_PCIL_D0_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_D0_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_D0_PA, PACTIVE, 0, 2)
#define RPU_PCIL_D0_PA_RESET_VAL 0x0

REG32(RPU_PCIL_D1_ISR, 0x00011224)
    FIELD(RPU_PCIL_D1_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_D1_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_D1_IMR, 0x00011228)
    FIELD(RPU_PCIL_D1_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_D1_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_D1_IEN, 0x0001122c)
    FIELD(RPU_PCIL_D1_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_D1_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_D1_IDS, 0x00011230)
    FIELD(RPU_PCIL_D1_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_D1_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_D1_PR, 0x00011234)
    FIELD(RPU_PCIL_D1_PR, PREQ, 0, 1)
#define RPU_PCIL_D1_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_D1_PR_RESET_VAL 0x0

REG32(RPU_PCIL_D1_PS, 0x00011238)
    FIELD(RPU_PCIL_D1_PS, PSTATE, 0, 1)
#define RPU_PCIL_D1_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_D1_PS_RESET_VAL 0x0

REG32(RPU_PCIL_D1_PA, 0x0001123c)
    FIELD(RPU_PCIL_D1_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_D1_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_D1_PA, PACTIVE, 0, 2)
#define RPU_PCIL_D1_PA_RESET_VAL 0x0

REG32(RPU_PCIL_E0_ISR, 0x00011244)
    FIELD(RPU_PCIL_E0_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_E0_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_E0_IMR, 0x00011248)
    FIELD(RPU_PCIL_E0_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_E0_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_E0_IEN, 0x0001124c)
    FIELD(RPU_PCIL_E0_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_E0_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_E0_IDS, 0x00011250)
    FIELD(RPU_PCIL_E0_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_E0_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_E0_PR, 0x00011254)
    FIELD(RPU_PCIL_E0_PR, PREQ, 0, 1)
#define RPU_PCIL_E0_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_E0_PR_RESET_VAL 0x0

REG32(RPU_PCIL_E0_PS, 0x00011258)
    FIELD(RPU_PCIL_E0_PS, PSTATE, 0, 1)
#define RPU_PCIL_E0_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_E0_PS_RESET_VAL 0x0

REG32(RPU_PCIL_E0_PA, 0x0001125c)
    FIELD(RPU_PCIL_E0_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_E0_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_E0_PA, PACTIVE, 0, 2)
#define RPU_PCIL_E0_PA_RESET_VAL 0x0

REG32(RPU_PCIL_E1_ISR, 0x00011264)
    FIELD(RPU_PCIL_E1_ISR, PACTIVE1, 0, 1)
#define RPU_PCIL_E1_ISR_RESET_VAL 0x0

REG32(RPU_PCIL_E1_IMR, 0x00011268)
    FIELD(RPU_PCIL_E1_IMR, PACTIVE1, 0, 1)
#define RPU_PCIL_E1_IMR_RESET_VAL 0x1

REG32(RPU_PCIL_E1_IEN, 0x0001126c)
    FIELD(RPU_PCIL_E1_IEN, PACTIVE1, 0, 1)
#define RPU_PCIL_E1_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_E1_IDS, 0x00011270)
    FIELD(RPU_PCIL_E1_IDS, PACTIVE1, 0, 1)
#define RPU_PCIL_E1_IDS_RESET_VAL 0x0

REG32(RPU_PCIL_E1_PR, 0x00011274)
    FIELD(RPU_PCIL_E1_PR, PREQ, 0, 1)
#define RPU_PCIL_E1_PR_WRITE_MASK 0x00000001
#define RPU_PCIL_E1_PR_RESET_VAL 0x0

REG32(RPU_PCIL_E1_PS, 0x00011278)
    FIELD(RPU_PCIL_E1_PS, PSTATE, 0, 1)
#define RPU_PCIL_E1_PS_WRITE_MASK 0x00000001
#define RPU_PCIL_E1_PS_RESET_VAL 0x0

REG32(RPU_PCIL_E1_PA, 0x0001127c)
    FIELD(RPU_PCIL_E1_PA, PDENY, 9, 1)
    FIELD(RPU_PCIL_E1_PA, PACCEPT, 8, 1)
    FIELD(RPU_PCIL_E1_PA, PACTIVE, 0, 2)
#define RPU_PCIL_E1_PA_RESET_VAL 0x0

REG32(RPU_PCIL_PSM_STANDBY, 0x00018000)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE1_E, 19, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI1_E, 18, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE0_E, 17, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI0_E, 16, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE1_D, 15, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI1_D, 14, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE0_D, 13, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI0_D, 12, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE1_C, 11, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI1_C, 10, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE0_C, 9, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI0_C, 8, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE1_B, 7, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI1_B, 6, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE0_B, 5, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI0_B, 4, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE1_A, 3, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI1_A, 2, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFE0_A, 1, 1)
    FIELD(RPU_PCIL_PSM_STANDBY, WFI0_A, 0, 1)
#define RPU_PCIL_PSM_STANDBY_RESET_VAL 0x55555

REG32(RPU_PCIL_PSM_IMR, 0x00018004)
    FIELD(RPU_PCIL_PSM_IMR, WFE1_E, 19, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI1_E, 18, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE0_E, 17, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI0_E, 16, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE1_D, 15, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI1_D, 14, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE0_D, 13, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI0_D, 12, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE1_C, 11, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI1_C, 10, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE0_C, 9, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI0_C, 8, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE1_B, 7, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI1_B, 6, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE0_B, 5, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI0_B, 4, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE1_A, 3, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI1_A, 2, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFE0_A, 1, 1)
    FIELD(RPU_PCIL_PSM_IMR, WFI0_A, 0, 1)
#define RPU_PCIL_PSM_IMR_RESET_VAL 0xfffff

REG32(RPU_PCIL_PSM_IEN, 0x00018008)
    FIELD(RPU_PCIL_PSM_IEN, WFE1_E, 19, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI1_E, 18, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE0_E, 17, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI0_E, 16, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE1_D, 15, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI1_D, 14, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE0_D, 13, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI0_D, 12, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE1_C, 11, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI1_C, 10, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE0_C, 9, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI0_C, 8, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE1_B, 7, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI1_B, 6, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE0_B, 5, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI0_B, 4, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE1_A, 3, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI1_A, 2, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFE0_A, 1, 1)
    FIELD(RPU_PCIL_PSM_IEN, WFI0_A, 0, 1)
#define RPU_PCIL_PSM_IEN_RESET_VAL 0x0

REG32(RPU_PCIL_PSM_IDS, 0x0001800c)
    FIELD(RPU_PCIL_PSM_IDS, WFE1_E, 19, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI1_E, 18, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE0_E, 17, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI0_E, 16, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE1_D, 15, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI1_D, 14, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE0_D, 13, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI0_D, 12, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE1_C, 11, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI1_C, 10, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE0_C, 9, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI0_C, 8, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE1_B, 7, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI1_B, 6, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE0_B, 5, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI0_B, 4, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE1_A, 3, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI1_A, 2, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFE0_A, 1, 1)
    FIELD(RPU_PCIL_PSM_IDS, WFI0_A, 0, 1)
#define RPU_PCIL_PSM_IDS_RESET_VAL 0x0

REG32(LPX_GD0_VCCINT_PMC_VAL_SEL, 0x00020000)
    FIELD(LPX_GD0_VCCINT_PMC_VAL_SEL, VAL, 0, 3)
#define LPX_GD0_VCCINT_PMC_VAL_SEL_WRITE_MASK 0x00000007
#define LPX_GD0_VCCINT_PMC_VAL_SEL_RESET_VAL 0x0

REG32(LPX_GD0_EN_GLITCH_DET_B, 0x00020004)
    FIELD(LPX_GD0_EN_GLITCH_DET_B, VAL, 0, 1)
#define LPX_GD0_EN_GLITCH_DET_B_WRITE_MASK 0x00000001
#define LPX_GD0_EN_GLITCH_DET_B_RESET_VAL 0x0

REG32(LPX_GD0_COMP_SEL, 0x00020008)
    FIELD(LPX_GD0_COMP_SEL, VAL, 0, 2)
#define LPX_GD0_COMP_SEL_WRITE_MASK 0x00000003
#define LPX_GD0_COMP_SEL_RESET_VAL 0x0

REG32(LPX_GD0_DEL_SEL, 0x0002000c)
    FIELD(LPX_GD0_DEL_SEL, VAL, 0, 4)
#define LPX_GD0_DEL_SEL_WRITE_MASK 0x0000000f
#define LPX_GD0_DEL_SEL_RESET_VAL 0x0

REG32(LPX_GD0_GLITCH_DET_SPARE_SEL_PMC, 0x00020010)
    FIELD(LPX_GD0_GLITCH_DET_SPARE_SEL_PMC, VAL, 0, 4)
#define LPX_GD0_GLITCH_DET_SPARE_SEL_PMC_WRITE_MASK 0x0000000f
#define LPX_GD0_GLITCH_DET_SPARE_SEL_PMC_RESET_VAL 0x0

REG32(LPX_GD0_GL_DET_TEST_MODE, 0x00020014)
    FIELD(LPX_GD0_GL_DET_TEST_MODE, VAL, 0, 1)
#define LPX_GD0_GL_DET_TEST_MODE_WRITE_MASK 0x00000001
#define LPX_GD0_GL_DET_TEST_MODE_RESET_VAL 0x0

REG32(LPX_GD0_TEST_GLITCH_GEN, 0x00020018)
    FIELD(LPX_GD0_TEST_GLITCH_GEN, VAL, 0, 1)
#define LPX_GD0_TEST_GLITCH_GEN_WRITE_MASK 0x00000001
#define LPX_GD0_TEST_GLITCH_GEN_RESET_VAL 0x0

REG32(LPX_GD0_TEST_GLITCH_SEL, 0x0002001c)
    FIELD(LPX_GD0_TEST_GLITCH_SEL, VAL, 0, 5)
#define LPX_GD0_TEST_GLITCH_SEL_WRITE_MASK 0x0000001f
#define LPX_GD0_TEST_GLITCH_SEL_RESET_VAL 0x0

REG32(LPX_GD0_FABRIC_GL_EN, 0x00020020)
    FIELD(LPX_GD0_FABRIC_GL_EN, VAL, 0, 1)
#define LPX_GD0_FABRIC_GL_EN_WRITE_MASK 0x00000001
#define LPX_GD0_FABRIC_GL_EN_RESET_VAL 0x0

REG32(LPX_GD0_VCCINT_PMC_GLITCH_DETECT, 0x00020024)
    FIELD(LPX_GD0_VCCINT_PMC_GLITCH_DETECT, VAL, 0, 1)
#define LPX_GD0_VCCINT_PMC_GLITCH_DETECT_RESET_VAL 0x0

REG32(LPX_GD1_VCCINT_PMC_VAL_SEL, 0x00020028)
    FIELD(LPX_GD1_VCCINT_PMC_VAL_SEL, VAL, 0, 3)
#define LPX_GD1_VCCINT_PMC_VAL_SEL_WRITE_MASK 0x00000007
#define LPX_GD1_VCCINT_PMC_VAL_SEL_RESET_VAL 0x0

REG32(LPX_GD1_EN_GLITCH_DET_B, 0x0002002c)
    FIELD(LPX_GD1_EN_GLITCH_DET_B, VAL, 0, 1)
#define LPX_GD1_EN_GLITCH_DET_B_WRITE_MASK 0x00000001
#define LPX_GD1_EN_GLITCH_DET_B_RESET_VAL 0x0

REG32(LPX_GD1_COMP_SEL, 0x00020030)
    FIELD(LPX_GD1_COMP_SEL, VAL, 0, 2)
#define LPX_GD1_COMP_SEL_WRITE_MASK 0x00000003
#define LPX_GD1_COMP_SEL_RESET_VAL 0x0

REG32(LPX_GD1_DEL_SEL, 0x00020034)
    FIELD(LPX_GD1_DEL_SEL, VAL, 0, 4)
#define LPX_GD1_DEL_SEL_WRITE_MASK 0x0000000f
#define LPX_GD1_DEL_SEL_RESET_VAL 0x0

REG32(LPX_GD1_GLITCH_DET_SPARE_SEL_PMC, 0x00020038)
    FIELD(LPX_GD1_GLITCH_DET_SPARE_SEL_PMC, VAL, 0, 4)
#define LPX_GD1_GLITCH_DET_SPARE_SEL_PMC_WRITE_MASK 0x0000000f
#define LPX_GD1_GLITCH_DET_SPARE_SEL_PMC_RESET_VAL 0x0

REG32(LPX_GD1_GL_DET_TEST_MODE, 0x0002003c)
    FIELD(LPX_GD1_GL_DET_TEST_MODE, VAL, 0, 1)
#define LPX_GD1_GL_DET_TEST_MODE_WRITE_MASK 0x00000001
#define LPX_GD1_GL_DET_TEST_MODE_RESET_VAL 0x0

REG32(LPX_GD1_TEST_GLITCH_GEN, 0x00020040)
    FIELD(LPX_GD1_TEST_GLITCH_GEN, VAL, 0, 1)
#define LPX_GD1_TEST_GLITCH_GEN_WRITE_MASK 0x00000001
#define LPX_GD1_TEST_GLITCH_GEN_RESET_VAL 0x0

REG32(LPX_GD1_TEST_GLITCH_SEL, 0x00020044)
    FIELD(LPX_GD1_TEST_GLITCH_SEL, VAL, 0, 5)
#define LPX_GD1_TEST_GLITCH_SEL_WRITE_MASK 0x0000001f
#define LPX_GD1_TEST_GLITCH_SEL_RESET_VAL 0x0

REG32(LPX_GD1_FABRIC_GL_EN, 0x00020048)
    FIELD(LPX_GD1_FABRIC_GL_EN, VAL, 0, 1)
#define LPX_GD1_FABRIC_GL_EN_WRITE_MASK 0x00000001
#define LPX_GD1_FABRIC_GL_EN_RESET_VAL 0x0

REG32(LPX_GD1_VCCINT_PMC_GLITCH_DETECT, 0x0002004c)
    FIELD(LPX_GD1_VCCINT_PMC_GLITCH_DETECT, VAL, 0, 1)
#define LPX_GD1_VCCINT_PMC_GLITCH_DETECT_RESET_VAL 0x0

REG32(EAM_ERR0_STATUS, 0x00040000)
    FIELD(EAM_ERR0_STATUS, SRC31, 31, 1)
    FIELD(EAM_ERR0_STATUS, SRC30, 30, 1)
    FIELD(EAM_ERR0_STATUS, SRC29, 29, 1)
    FIELD(EAM_ERR0_STATUS, SRC28, 28, 1)
    FIELD(EAM_ERR0_STATUS, SRC27, 27, 1)
    FIELD(EAM_ERR0_STATUS, SRC26, 26, 1)
    FIELD(EAM_ERR0_STATUS, SRC25, 25, 1)
    FIELD(EAM_ERR0_STATUS, SRC24, 24, 1)
    FIELD(EAM_ERR0_STATUS, SRC23, 23, 1)
    FIELD(EAM_ERR0_STATUS, SRC22, 22, 1)
    FIELD(EAM_ERR0_STATUS, SRC21, 21, 1)
    FIELD(EAM_ERR0_STATUS, SRC20, 20, 1)
    FIELD(EAM_ERR0_STATUS, SRC19, 19, 1)
    FIELD(EAM_ERR0_STATUS, SRC18, 18, 1)
    FIELD(EAM_ERR0_STATUS, SRC17, 17, 1)
    FIELD(EAM_ERR0_STATUS, SRC16, 16, 1)
    FIELD(EAM_ERR0_STATUS, SRC15, 15, 1)
    FIELD(EAM_ERR0_STATUS, SRC14, 14, 1)
    FIELD(EAM_ERR0_STATUS, SRC13, 13, 1)
    FIELD(EAM_ERR0_STATUS, SRC12, 12, 1)
    FIELD(EAM_ERR0_STATUS, SRC11, 11, 1)
    FIELD(EAM_ERR0_STATUS, SRC10, 10, 1)
    FIELD(EAM_ERR0_STATUS, SRC9, 9, 1)
    FIELD(EAM_ERR0_STATUS, SRC8, 8, 1)
    FIELD(EAM_ERR0_STATUS, SRC7, 7, 1)
    FIELD(EAM_ERR0_STATUS, SRC6, 6, 1)
    FIELD(EAM_ERR0_STATUS, SRC5, 5, 1)
    FIELD(EAM_ERR0_STATUS, SRC4, 4, 1)
    FIELD(EAM_ERR0_STATUS, SRC3, 3, 1)
    FIELD(EAM_ERR0_STATUS, SRC2, 2, 1)
    FIELD(EAM_ERR0_STATUS, SRC1, 1, 1)
    FIELD(EAM_ERR0_STATUS, SRC0, 0, 1)
#define EAM_ERR0_STATUS_RESET_VAL 0x0

REG32(EAM_ERR1_STATUS, 0x00040004)
    FIELD(EAM_ERR1_STATUS, SRC31, 31, 1)
    FIELD(EAM_ERR1_STATUS, SRC30, 30, 1)
    FIELD(EAM_ERR1_STATUS, SRC29, 29, 1)
    FIELD(EAM_ERR1_STATUS, SRC28, 28, 1)
    FIELD(EAM_ERR1_STATUS, SRC27, 27, 1)
    FIELD(EAM_ERR1_STATUS, SRC26, 26, 1)
    FIELD(EAM_ERR1_STATUS, SRC25, 25, 1)
    FIELD(EAM_ERR1_STATUS, SRC24, 24, 1)
    FIELD(EAM_ERR1_STATUS, SRC23, 23, 1)
    FIELD(EAM_ERR1_STATUS, SRC22, 22, 1)
    FIELD(EAM_ERR1_STATUS, SRC21, 21, 1)
    FIELD(EAM_ERR1_STATUS, SRC20, 20, 1)
    FIELD(EAM_ERR1_STATUS, SRC19, 19, 1)
    FIELD(EAM_ERR1_STATUS, SRC18, 18, 1)
    FIELD(EAM_ERR1_STATUS, SRC17, 17, 1)
    FIELD(EAM_ERR1_STATUS, SRC16, 16, 1)
    FIELD(EAM_ERR1_STATUS, SRC15, 15, 1)
    FIELD(EAM_ERR1_STATUS, SRC14, 14, 1)
    FIELD(EAM_ERR1_STATUS, SRC13, 13, 1)
    FIELD(EAM_ERR1_STATUS, SRC12, 12, 1)
    FIELD(EAM_ERR1_STATUS, SRC11, 11, 1)
    FIELD(EAM_ERR1_STATUS, SRC10, 10, 1)
    FIELD(EAM_ERR1_STATUS, SRC9, 9, 1)
    FIELD(EAM_ERR1_STATUS, SRC8, 8, 1)
    FIELD(EAM_ERR1_STATUS, SRC7, 7, 1)
    FIELD(EAM_ERR1_STATUS, SRC6, 6, 1)
    FIELD(EAM_ERR1_STATUS, SRC5, 5, 1)
    FIELD(EAM_ERR1_STATUS, SRC4, 4, 1)
    FIELD(EAM_ERR1_STATUS, SRC3, 3, 1)
    FIELD(EAM_ERR1_STATUS, SRC2, 2, 1)
    FIELD(EAM_ERR1_STATUS, SRC1, 1, 1)
    FIELD(EAM_ERR1_STATUS, SRC0, 0, 1)
#define EAM_ERR1_STATUS_RESET_VAL 0x0

REG32(EAM_ERR2_STATUS, 0x00040008)
    FIELD(EAM_ERR2_STATUS, SRC31, 31, 1)
    FIELD(EAM_ERR2_STATUS, SRC30, 30, 1)
    FIELD(EAM_ERR2_STATUS, SRC29, 29, 1)
    FIELD(EAM_ERR2_STATUS, SRC28, 28, 1)
    FIELD(EAM_ERR2_STATUS, SRC27, 27, 1)
    FIELD(EAM_ERR2_STATUS, SRC26, 26, 1)
    FIELD(EAM_ERR2_STATUS, SRC25, 25, 1)
    FIELD(EAM_ERR2_STATUS, SRC24, 24, 1)
    FIELD(EAM_ERR2_STATUS, SRC23, 23, 1)
    FIELD(EAM_ERR2_STATUS, SRC22, 22, 1)
    FIELD(EAM_ERR2_STATUS, SRC21, 21, 1)
    FIELD(EAM_ERR2_STATUS, SRC20, 20, 1)
    FIELD(EAM_ERR2_STATUS, SRC19, 19, 1)
    FIELD(EAM_ERR2_STATUS, SRC18, 18, 1)
    FIELD(EAM_ERR2_STATUS, SRC17, 17, 1)
    FIELD(EAM_ERR2_STATUS, SRC16, 16, 1)
    FIELD(EAM_ERR2_STATUS, SRC15, 15, 1)
    FIELD(EAM_ERR2_STATUS, SRC14, 14, 1)
    FIELD(EAM_ERR2_STATUS, SRC13, 13, 1)
    FIELD(EAM_ERR2_STATUS, SRC12, 12, 1)
    FIELD(EAM_ERR2_STATUS, SRC11, 11, 1)
    FIELD(EAM_ERR2_STATUS, SRC10, 10, 1)
    FIELD(EAM_ERR2_STATUS, SRC9, 9, 1)
    FIELD(EAM_ERR2_STATUS, SRC8, 8, 1)
    FIELD(EAM_ERR2_STATUS, SRC7, 7, 1)
    FIELD(EAM_ERR2_STATUS, SRC6, 6, 1)
    FIELD(EAM_ERR2_STATUS, SRC5, 5, 1)
    FIELD(EAM_ERR2_STATUS, SRC4, 4, 1)
    FIELD(EAM_ERR2_STATUS, SRC3, 3, 1)
    FIELD(EAM_ERR2_STATUS, SRC2, 2, 1)
    FIELD(EAM_ERR2_STATUS, SRC1, 1, 1)
    FIELD(EAM_ERR2_STATUS, SRC0, 0, 1)
#define EAM_ERR2_STATUS_RESET_VAL 0x0

REG32(EAM_ERR3_STATUS, 0x0004000c)
    FIELD(EAM_ERR3_STATUS, SRC31, 31, 1)
    FIELD(EAM_ERR3_STATUS, SRC30, 30, 1)
    FIELD(EAM_ERR3_STATUS, SRC29, 29, 1)
    FIELD(EAM_ERR3_STATUS, SRC28, 28, 1)
    FIELD(EAM_ERR3_STATUS, SRC27, 27, 1)
    FIELD(EAM_ERR3_STATUS, SRC26, 26, 1)
    FIELD(EAM_ERR3_STATUS, SRC25, 25, 1)
    FIELD(EAM_ERR3_STATUS, SRC24, 24, 1)
    FIELD(EAM_ERR3_STATUS, SRC23, 23, 1)
    FIELD(EAM_ERR3_STATUS, SRC22, 22, 1)
    FIELD(EAM_ERR3_STATUS, SRC21, 21, 1)
    FIELD(EAM_ERR3_STATUS, SRC20, 20, 1)
    FIELD(EAM_ERR3_STATUS, SRC19, 19, 1)
    FIELD(EAM_ERR3_STATUS, SRC18, 18, 1)
    FIELD(EAM_ERR3_STATUS, SRC17, 17, 1)
    FIELD(EAM_ERR3_STATUS, SRC16, 16, 1)
    FIELD(EAM_ERR3_STATUS, SRC15, 15, 1)
    FIELD(EAM_ERR3_STATUS, SRC14, 14, 1)
    FIELD(EAM_ERR3_STATUS, SRC13, 13, 1)
    FIELD(EAM_ERR3_STATUS, SRC12, 12, 1)
    FIELD(EAM_ERR3_STATUS, SRC11, 11, 1)
    FIELD(EAM_ERR3_STATUS, SRC10, 10, 1)
    FIELD(EAM_ERR3_STATUS, SRC9, 9, 1)
    FIELD(EAM_ERR3_STATUS, SRC8, 8, 1)
    FIELD(EAM_ERR3_STATUS, SRC7, 7, 1)
    FIELD(EAM_ERR3_STATUS, SRC6, 6, 1)
    FIELD(EAM_ERR3_STATUS, SRC5, 5, 1)
    FIELD(EAM_ERR3_STATUS, SRC4, 4, 1)
    FIELD(EAM_ERR3_STATUS, SRC3, 3, 1)
    FIELD(EAM_ERR3_STATUS, SRC2, 2, 1)
    FIELD(EAM_ERR3_STATUS, SRC1, 1, 1)
    FIELD(EAM_ERR3_STATUS, SRC0, 0, 1)
#define EAM_ERR3_STATUS_RESET_VAL 0x0

REG32(EAM_ERR0_TRIG, 0x40020)
REG32(EAM_ERR1_TRIG, 0x40024)
REG32(EAM_ERR2_TRIG, 0x40028)
REG32(EAM_ERR3_TRIG, 0x4002C)

REG32(EAM_PMC0_ERR0_MASK, 0x00040040)
    FIELD(EAM_PMC0_ERR0_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR0_MASK, SRC0, 0, 1)
#define EAM_PMC0_ERR0_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC0_ERR1_MASK, 0x00040044)
    FIELD(EAM_PMC0_ERR1_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR1_MASK, SRC0, 0, 1)
#define EAM_PMC0_ERR1_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC0_ERR2_MASK, 0x00040048)
    FIELD(EAM_PMC0_ERR2_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR2_MASK, SRC0, 0, 1)
#define EAM_PMC0_ERR2_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC0_ERR3_MASK, 0x0004004c)
    FIELD(EAM_PMC0_ERR3_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR3_MASK, SRC0, 0, 1)
#define EAM_PMC0_ERR3_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC0_ERR0_EN, 0x00040060)
    FIELD(EAM_PMC0_ERR0_EN, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR0_EN, SRC0, 0, 1)
#define EAM_PMC0_ERR0_EN_RESET_VAL 0x0

REG32(EAM_PMC0_ERR1_EN, 0x00040064)
    FIELD(EAM_PMC0_ERR1_EN, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR1_EN, SRC0, 0, 1)
#define EAM_PMC0_ERR1_EN_RESET_VAL 0x0

REG32(EAM_PMC0_ERR2_EN, 0x00040068)
    FIELD(EAM_PMC0_ERR2_EN, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR2_EN, SRC0, 0, 1)
#define EAM_PMC0_ERR2_EN_RESET_VAL 0x0

REG32(EAM_PMC0_ERR3_EN, 0x0004006c)
    FIELD(EAM_PMC0_ERR3_EN, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR3_EN, SRC0, 0, 1)
#define EAM_PMC0_ERR3_EN_RESET_VAL 0x0

REG32(EAM_PMC0_ERR0_DIS, 0x00040080)
    FIELD(EAM_PMC0_ERR0_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR0_DIS, SRC0, 0, 1)
#define EAM_PMC0_ERR0_DIS_RESET_VAL 0x0

REG32(EAM_PMC0_ERR1_DIS, 0x00040084)
    FIELD(EAM_PMC0_ERR1_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR1_DIS, SRC0, 0, 1)
#define EAM_PMC0_ERR1_DIS_RESET_VAL 0x0

REG32(EAM_PMC0_ERR2_DIS, 0x00040088)
    FIELD(EAM_PMC0_ERR2_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR2_DIS, SRC0, 0, 1)
#define EAM_PMC0_ERR2_DIS_RESET_VAL 0x0

REG32(EAM_PMC0_ERR3_DIS, 0x0004008c)
    FIELD(EAM_PMC0_ERR3_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC0_ERR3_DIS, SRC0, 0, 1)
#define EAM_PMC0_ERR3_DIS_RESET_VAL 0x0

REG32(EAM_PMC1_ERR0_MASK, 0x000400a0)
    FIELD(EAM_PMC1_ERR0_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR0_MASK, SRC0, 0, 1)
#define EAM_PMC1_ERR0_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC1_ERR1_MASK, 0x000400a4)
    FIELD(EAM_PMC1_ERR1_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR1_MASK, SRC0, 0, 1)
#define EAM_PMC1_ERR1_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC1_ERR2_MASK, 0x000400a8)
    FIELD(EAM_PMC1_ERR2_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR2_MASK, SRC0, 0, 1)
#define EAM_PMC1_ERR2_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC1_ERR3_MASK, 0x000400ac)
    FIELD(EAM_PMC1_ERR3_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR3_MASK, SRC0, 0, 1)
#define EAM_PMC1_ERR3_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC1_ERR0_EN, 0x000400c0)
    FIELD(EAM_PMC1_ERR0_EN, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR0_EN, SRC0, 0, 1)
#define EAM_PMC1_ERR0_EN_RESET_VAL 0x0

REG32(EAM_PMC1_ERR1_EN, 0x000400c4)
    FIELD(EAM_PMC1_ERR1_EN, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR1_EN, SRC0, 0, 1)
#define EAM_PMC1_ERR1_EN_RESET_VAL 0x0

REG32(EAM_PMC1_ERR2_EN, 0x000400c8)
    FIELD(EAM_PMC1_ERR2_EN, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR2_EN, SRC0, 0, 1)
#define EAM_PMC1_ERR2_EN_RESET_VAL 0x0

REG32(EAM_PMC1_ERR3_EN, 0x000400cc)
    FIELD(EAM_PMC1_ERR3_EN, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR3_EN, SRC0, 0, 1)
#define EAM_PMC1_ERR3_EN_RESET_VAL 0x0

REG32(EAM_PMC1_ERR0_DIS, 0x000400e0)
    FIELD(EAM_PMC1_ERR0_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR0_DIS, SRC0, 0, 1)
#define EAM_PMC1_ERR0_DIS_RESET_VAL 0x0

REG32(EAM_PMC1_ERR1_DIS, 0x000400e4)
    FIELD(EAM_PMC1_ERR1_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR1_DIS, SRC0, 0, 1)
#define EAM_PMC1_ERR1_DIS_RESET_VAL 0x0

REG32(EAM_PMC1_ERR2_DIS, 0x000400e8)
    FIELD(EAM_PMC1_ERR2_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR2_DIS, SRC0, 0, 1)
#define EAM_PMC1_ERR2_DIS_RESET_VAL 0x0

REG32(EAM_PMC1_ERR3_DIS, 0x000400ec)
    FIELD(EAM_PMC1_ERR3_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC1_ERR3_DIS, SRC0, 0, 1)
#define EAM_PMC1_ERR3_DIS_RESET_VAL 0x0

REG32(EAM_PMC2_ERR0_MASK, 0x00040100)
    FIELD(EAM_PMC2_ERR0_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR0_MASK, SRC0, 0, 1)
#define EAM_PMC2_ERR0_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC2_ERR1_MASK, 0x00040104)
    FIELD(EAM_PMC2_ERR1_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR1_MASK, SRC0, 0, 1)
#define EAM_PMC2_ERR1_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC2_ERR2_MASK, 0x00040108)
    FIELD(EAM_PMC2_ERR2_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR2_MASK, SRC0, 0, 1)
#define EAM_PMC2_ERR2_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC2_ERR3_MASK, 0x0004010c)
    FIELD(EAM_PMC2_ERR3_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR3_MASK, SRC0, 0, 1)
#define EAM_PMC2_ERR3_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC2_ERR0_EN, 0x00040120)
    FIELD(EAM_PMC2_ERR0_EN, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR0_EN, SRC0, 0, 1)
#define EAM_PMC2_ERR0_EN_RESET_VAL 0x0

REG32(EAM_PMC2_ERR1_EN, 0x00040124)
    FIELD(EAM_PMC2_ERR1_EN, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR1_EN, SRC0, 0, 1)
#define EAM_PMC2_ERR1_EN_RESET_VAL 0x0

REG32(EAM_PMC2_ERR2_EN, 0x00040128)
    FIELD(EAM_PMC2_ERR2_EN, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR2_EN, SRC0, 0, 1)
#define EAM_PMC2_ERR2_EN_RESET_VAL 0x0

REG32(EAM_PMC2_ERR3_EN, 0x0004012c)
    FIELD(EAM_PMC2_ERR3_EN, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR3_EN, SRC0, 0, 1)
#define EAM_PMC2_ERR3_EN_RESET_VAL 0x0

REG32(EAM_PMC2_ERR0_DIS, 0x00040140)
    FIELD(EAM_PMC2_ERR0_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR0_DIS, SRC0, 0, 1)
#define EAM_PMC2_ERR0_DIS_RESET_VAL 0x0

REG32(EAM_PMC2_ERR1_DIS, 0x00040144)
    FIELD(EAM_PMC2_ERR1_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR1_DIS, SRC0, 0, 1)
#define EAM_PMC2_ERR1_DIS_RESET_VAL 0x0

REG32(EAM_PMC2_ERR2_DIS, 0x00040148)
    FIELD(EAM_PMC2_ERR2_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR2_DIS, SRC0, 0, 1)
#define EAM_PMC2_ERR2_DIS_RESET_VAL 0x0

REG32(EAM_PMC2_ERR3_DIS, 0x0004014c)
    FIELD(EAM_PMC2_ERR3_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC2_ERR3_DIS, SRC0, 0, 1)
#define EAM_PMC2_ERR3_DIS_RESET_VAL 0x0

REG32(EAM_PMC3_ERR0_MASK, 0x00040160)
    FIELD(EAM_PMC3_ERR0_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR0_MASK, SRC0, 0, 1)
#define EAM_PMC3_ERR0_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC3_ERR1_MASK, 0x00040164)
    FIELD(EAM_PMC3_ERR1_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR1_MASK, SRC0, 0, 1)
#define EAM_PMC3_ERR1_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC3_ERR2_MASK, 0x00040168)
    FIELD(EAM_PMC3_ERR2_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR2_MASK, SRC0, 0, 1)
#define EAM_PMC3_ERR2_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC3_ERR3_MASK, 0x0004016c)
    FIELD(EAM_PMC3_ERR3_MASK, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR3_MASK, SRC0, 0, 1)
#define EAM_PMC3_ERR3_MASK_RESET_VAL 0xffffffff

REG32(EAM_PMC3_ERR0_EN, 0x00040180)
    FIELD(EAM_PMC3_ERR0_EN, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR0_EN, SRC0, 0, 1)
#define EAM_PMC3_ERR0_EN_RESET_VAL 0x0

REG32(EAM_PMC3_ERR1_EN, 0x00040184)
    FIELD(EAM_PMC3_ERR1_EN, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR1_EN, SRC0, 0, 1)
#define EAM_PMC3_ERR1_EN_RESET_VAL 0x0

REG32(EAM_PMC3_ERR2_EN, 0x00040188)
    FIELD(EAM_PMC3_ERR2_EN, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR2_EN, SRC0, 0, 1)
#define EAM_PMC3_ERR2_EN_RESET_VAL 0x0

REG32(EAM_PMC3_ERR3_EN, 0x0004018c)
    FIELD(EAM_PMC3_ERR3_EN, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR3_EN, SRC0, 0, 1)
#define EAM_PMC3_ERR3_EN_RESET_VAL 0x0

REG32(EAM_PMC3_ERR0_DIS, 0x000401a0)
    FIELD(EAM_PMC3_ERR0_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR0_DIS, SRC0, 0, 1)
#define EAM_PMC3_ERR0_DIS_RESET_VAL 0x0

REG32(EAM_PMC3_ERR1_DIS, 0x000401a4)
    FIELD(EAM_PMC3_ERR1_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR1_DIS, SRC0, 0, 1)
#define EAM_PMC3_ERR1_DIS_RESET_VAL 0x0

REG32(EAM_PMC3_ERR2_DIS, 0x000401a8)
    FIELD(EAM_PMC3_ERR2_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR2_DIS, SRC0, 0, 1)
#define EAM_PMC3_ERR2_DIS_RESET_VAL 0x0

REG32(EAM_PMC3_ERR3_DIS, 0x000401ac)
    FIELD(EAM_PMC3_ERR3_DIS, SRC31, 31, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC30, 30, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC29, 29, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC28, 28, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC27, 27, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC26, 26, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC25, 25, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC24, 24, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC23, 23, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC22, 22, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC21, 21, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC20, 20, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC19, 19, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC18, 18, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC17, 17, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC16, 16, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC15, 15, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC14, 14, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC13, 13, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC12, 12, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC11, 11, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC10, 10, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC9, 9, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC8, 8, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC7, 7, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC6, 6, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC5, 5, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC4, 4, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC3, 3, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC2, 2, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC1, 1, 1)
    FIELD(EAM_PMC3_ERR3_DIS, SRC0, 0, 1)
#define EAM_PMC3_ERR3_DIS_RESET_VAL 0x0

REG32(EAM_ASU_ERR0_MASK, 0x000401c0)
    FIELD(EAM_ASU_ERR0_MASK, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR0_MASK, SRC0, 0, 1)
#define EAM_ASU_ERR0_MASK_RESET_VAL 0xffffffff

REG32(EAM_ASU_ERR1_MASK, 0x000401c4)
    FIELD(EAM_ASU_ERR1_MASK, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR1_MASK, SRC0, 0, 1)
#define EAM_ASU_ERR1_MASK_RESET_VAL 0xffffffff

REG32(EAM_ASU_ERR2_MASK, 0x000401c8)
    FIELD(EAM_ASU_ERR2_MASK, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR2_MASK, SRC0, 0, 1)
#define EAM_ASU_ERR2_MASK_RESET_VAL 0xffffffff

REG32(EAM_ASU_ERR3_MASK, 0x000401cc)
    FIELD(EAM_ASU_ERR3_MASK, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR3_MASK, SRC0, 0, 1)
#define EAM_ASU_ERR3_MASK_RESET_VAL 0xffffffff

REG32(EAM_ASU_ERR0_EN, 0x000401e0)
    FIELD(EAM_ASU_ERR0_EN, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR0_EN, SRC0, 0, 1)
#define EAM_ASU_ERR0_EN_RESET_VAL 0x0

REG32(EAM_ASU_ERR1_EN, 0x000401e4)
    FIELD(EAM_ASU_ERR1_EN, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR1_EN, SRC0, 0, 1)
#define EAM_ASU_ERR1_EN_RESET_VAL 0x0

REG32(EAM_ASU_ERR2_EN, 0x000401e8)
    FIELD(EAM_ASU_ERR2_EN, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR2_EN, SRC0, 0, 1)
#define EAM_ASU_ERR2_EN_RESET_VAL 0x0

REG32(EAM_ASU_ERR3_EN, 0x000401ec)
    FIELD(EAM_ASU_ERR3_EN, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR3_EN, SRC0, 0, 1)
#define EAM_ASU_ERR3_EN_RESET_VAL 0x0

REG32(EAM_ASU_ERR0_DIS, 0x00040200)
    FIELD(EAM_ASU_ERR0_DIS, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR0_DIS, SRC0, 0, 1)
#define EAM_ASU_ERR0_DIS_RESET_VAL 0x0

REG32(EAM_ASU_ERR1_DIS, 0x00040204)
    FIELD(EAM_ASU_ERR1_DIS, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR1_DIS, SRC0, 0, 1)
#define EAM_ASU_ERR1_DIS_RESET_VAL 0x0

REG32(EAM_ASU_ERR2_DIS, 0x00040208)
    FIELD(EAM_ASU_ERR2_DIS, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR2_DIS, SRC0, 0, 1)
#define EAM_ASU_ERR2_DIS_RESET_VAL 0x0

REG32(EAM_ASU_ERR3_DIS, 0x0004020c)
    FIELD(EAM_ASU_ERR3_DIS, SRC31, 31, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC30, 30, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC29, 29, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC28, 28, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC27, 27, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC26, 26, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC25, 25, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC24, 24, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC23, 23, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC22, 22, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC21, 21, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC20, 20, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC19, 19, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC18, 18, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC17, 17, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC16, 16, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC15, 15, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC14, 14, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC13, 13, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC12, 12, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC11, 11, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC10, 10, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC9, 9, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC8, 8, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC7, 7, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC6, 6, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC5, 5, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC4, 4, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC3, 3, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC2, 2, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC1, 1, 1)
    FIELD(EAM_ASU_ERR3_DIS, SRC0, 0, 1)
#define EAM_ASU_ERR3_DIS_RESET_VAL 0x0

REG32(APU0_CORE0_PWR_CNTRL_REG0, 0x00050000)
    FIELD(APU0_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU0_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU0_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU0_CORE0_PWR_CNTRL_REG1, 0x00050004)
    FIELD(APU0_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU0_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU0_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU0_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU0_CORE0_PWR_CNTRL_REG2, 0x00050008)
    FIELD(APU0_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU0_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU0_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU0_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU0_CORE0_PWR_CNTRL_STS, 0x0005000c)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU0_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU0_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU0_CORE0_PWR_CNTRL_WPROT, 0x00050010)
    FIELD(APU0_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU0_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU0_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU0_CORE1_PWR_CNTRL_REG0, 0x00050020)
    FIELD(APU0_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU0_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU0_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU0_CORE1_PWR_CNTRL_REG1, 0x00050024)
    FIELD(APU0_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU0_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU0_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU0_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU0_CORE1_PWR_CNTRL_REG2, 0x00050028)
    FIELD(APU0_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU0_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU0_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU0_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU0_CORE1_PWR_CNTRL_STS, 0x0005002c)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU0_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU0_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU0_CORE1_PWR_CNTRL_WPROT, 0x00050030)
    FIELD(APU0_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU0_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU0_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU1_CORE0_PWR_CNTRL_REG0, 0x00050040)
    FIELD(APU1_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU1_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU1_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU1_CORE0_PWR_CNTRL_REG1, 0x00050044)
    FIELD(APU1_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU1_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU1_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU1_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU1_CORE0_PWR_CNTRL_REG2, 0x00050048)
    FIELD(APU1_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU1_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU1_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU1_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU1_CORE0_PWR_CNTRL_STS, 0x0005004c)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU1_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU1_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU1_CORE0_PWR_CNTRL_WPROT, 0x00050050)
    FIELD(APU1_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU1_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU1_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU1_CORE1_PWR_CNTRL_REG0, 0x00050060)
    FIELD(APU1_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU1_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU1_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU1_CORE1_PWR_CNTRL_REG1, 0x00050064)
    FIELD(APU1_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU1_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU1_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU1_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU1_CORE1_PWR_CNTRL_REG2, 0x00050068)
    FIELD(APU1_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU1_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU1_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU1_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU1_CORE1_PWR_CNTRL_STS, 0x0005006c)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU1_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU1_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU1_CORE1_PWR_CNTRL_WPROT, 0x00050070)
    FIELD(APU1_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU1_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU1_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU2_CORE0_PWR_CNTRL_REG0, 0x00050080)
    FIELD(APU2_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU2_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU2_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU2_CORE0_PWR_CNTRL_REG1, 0x00050084)
    FIELD(APU2_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU2_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU2_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU2_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU2_CORE0_PWR_CNTRL_REG2, 0x00050088)
    FIELD(APU2_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU2_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU2_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU2_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU2_CORE0_PWR_CNTRL_STS, 0x0005008c)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU2_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU2_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU2_CORE0_PWR_CNTRL_WPROT, 0x00050090)
    FIELD(APU2_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU2_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU2_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU2_CORE1_PWR_CNTRL_REG0, 0x000500a0)
    FIELD(APU2_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU2_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU2_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU2_CORE1_PWR_CNTRL_REG1, 0x000500a4)
    FIELD(APU2_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU2_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU2_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU2_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU2_CORE1_PWR_CNTRL_REG2, 0x000500a8)
    FIELD(APU2_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU2_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU2_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU2_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU2_CORE1_PWR_CNTRL_STS, 0x000500ac)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU2_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU2_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU2_CORE1_PWR_CNTRL_WPROT, 0x000500b0)
    FIELD(APU2_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU2_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU2_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU3_CORE0_PWR_CNTRL_REG0, 0x000500c0)
    FIELD(APU3_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU3_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU3_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU3_CORE0_PWR_CNTRL_REG1, 0x000500c4)
    FIELD(APU3_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU3_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU3_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU3_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU3_CORE0_PWR_CNTRL_REG2, 0x000500c8)
    FIELD(APU3_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU3_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU3_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU3_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU3_CORE0_PWR_CNTRL_STS, 0x000500cc)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU3_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU3_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU3_CORE0_PWR_CNTRL_WPROT, 0x000500d0)
    FIELD(APU3_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU3_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU3_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(APU3_CORE1_PWR_CNTRL_REG0, 0x000500e0)
    FIELD(APU3_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define APU3_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define APU3_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(APU3_CORE1_PWR_CNTRL_REG1, 0x000500e4)
    FIELD(APU3_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(APU3_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define APU3_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define APU3_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(APU3_CORE1_PWR_CNTRL_REG2, 0x000500e8)
    FIELD(APU3_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(APU3_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define APU3_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define APU3_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(APU3_CORE1_PWR_CNTRL_STS, 0x000500ec)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(APU3_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define APU3_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(APU3_CORE1_PWR_CNTRL_WPROT, 0x000500f0)
    FIELD(APU3_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define APU3_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define APU3_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU0_CORE0_PWR_CNTRL_REG0, 0x00050100)
    FIELD(RPU0_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU0_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU0_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU0_CORE0_PWR_CNTRL_REG1, 0x00050104)
    FIELD(RPU0_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU0_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU0_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU0_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU0_CORE0_PWR_CNTRL_REG2, 0x00050108)
    FIELD(RPU0_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU0_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU0_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU0_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU0_CORE0_PWR_CNTRL_STS, 0x0005010c)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU0_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU0_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU0_CORE0_PWR_CNTRL_WPROT, 0x00050110)
    FIELD(RPU0_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU0_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU0_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU0_CORE1_PWR_CNTRL_REG0, 0x00050120)
    FIELD(RPU0_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU0_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU0_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU0_CORE1_PWR_CNTRL_REG1, 0x00050124)
    FIELD(RPU0_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU0_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU0_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU0_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU0_CORE1_PWR_CNTRL_REG2, 0x00050128)
    FIELD(RPU0_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU0_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU0_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU0_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU0_CORE1_PWR_CNTRL_STS, 0x0005012c)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU0_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU0_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU0_CORE1_PWR_CNTRL_WPROT, 0x00050130)
    FIELD(RPU0_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU0_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU0_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU1_CORE0_PWR_CNTRL_REG0, 0x00050140)
    FIELD(RPU1_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU1_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU1_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU1_CORE0_PWR_CNTRL_REG1, 0x00050144)
    FIELD(RPU1_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU1_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU1_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU1_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU1_CORE0_PWR_CNTRL_REG2, 0x00050148)
    FIELD(RPU1_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU1_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU1_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU1_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU1_CORE0_PWR_CNTRL_STS, 0x0005014c)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU1_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU1_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU1_CORE0_PWR_CNTRL_WPROT, 0x00050150)
    FIELD(RPU1_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU1_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU1_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU1_CORE1_PWR_CNTRL_REG0, 0x00050160)
    FIELD(RPU1_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU1_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU1_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU1_CORE1_PWR_CNTRL_REG1, 0x00050164)
    FIELD(RPU1_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU1_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU1_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU1_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU1_CORE1_PWR_CNTRL_REG2, 0x00050168)
    FIELD(RPU1_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU1_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU1_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU1_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU1_CORE1_PWR_CNTRL_STS, 0x0005016c)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU1_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU1_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU1_CORE1_PWR_CNTRL_WPROT, 0x00050170)
    FIELD(RPU1_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU1_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU1_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU2_CORE0_PWR_CNTRL_REG0, 0x00050180)
    FIELD(RPU2_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU2_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU2_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU2_CORE0_PWR_CNTRL_REG1, 0x00050184)
    FIELD(RPU2_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU2_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU2_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU2_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU2_CORE0_PWR_CNTRL_REG2, 0x00050188)
    FIELD(RPU2_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU2_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU2_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU2_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU2_CORE0_PWR_CNTRL_STS, 0x0005018c)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU2_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU2_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU2_CORE0_PWR_CNTRL_WPROT, 0x00050190)
    FIELD(RPU2_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU2_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU2_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU2_CORE1_PWR_CNTRL_REG0, 0x000501a0)
    FIELD(RPU2_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU2_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU2_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU2_CORE1_PWR_CNTRL_REG1, 0x000501a4)
    FIELD(RPU2_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU2_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU2_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU2_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU2_CORE1_PWR_CNTRL_REG2, 0x000501a8)
    FIELD(RPU2_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU2_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU2_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU2_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU2_CORE1_PWR_CNTRL_STS, 0x000501ac)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU2_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU2_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU2_CORE1_PWR_CNTRL_WPROT, 0x000501b0)
    FIELD(RPU2_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU2_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU2_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU3_CORE0_PWR_CNTRL_REG0, 0x000501c0)
    FIELD(RPU3_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU3_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU3_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU3_CORE0_PWR_CNTRL_REG1, 0x000501c4)
    FIELD(RPU3_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU3_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU3_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU3_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU3_CORE0_PWR_CNTRL_REG2, 0x000501c8)
    FIELD(RPU3_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU3_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU3_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU3_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU3_CORE0_PWR_CNTRL_STS, 0x000501cc)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU3_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU3_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU3_CORE0_PWR_CNTRL_WPROT, 0x000501d0)
    FIELD(RPU3_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU3_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU3_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU3_CORE1_PWR_CNTRL_REG0, 0x000501e0)
    FIELD(RPU3_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU3_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU3_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU3_CORE1_PWR_CNTRL_REG1, 0x000501e4)
    FIELD(RPU3_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU3_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU3_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU3_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU3_CORE1_PWR_CNTRL_REG2, 0x000501e8)
    FIELD(RPU3_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU3_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU3_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU3_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU3_CORE1_PWR_CNTRL_STS, 0x000501ec)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU3_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU3_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU3_CORE1_PWR_CNTRL_WPROT, 0x000501f0)
    FIELD(RPU3_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU3_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU3_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU4_CORE0_PWR_CNTRL_REG0, 0x00050200)
    FIELD(RPU4_CORE0_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU4_CORE0_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU4_CORE0_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU4_CORE0_PWR_CNTRL_REG1, 0x00050204)
    FIELD(RPU4_CORE0_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU4_CORE0_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU4_CORE0_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU4_CORE0_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU4_CORE0_PWR_CNTRL_REG2, 0x00050208)
    FIELD(RPU4_CORE0_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU4_CORE0_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU4_CORE0_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU4_CORE0_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU4_CORE0_PWR_CNTRL_STS, 0x0005020c)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU4_CORE0_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU4_CORE0_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU4_CORE0_PWR_CNTRL_WPROT, 0x00050210)
    FIELD(RPU4_CORE0_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU4_CORE0_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU4_CORE0_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(RPU4_CORE1_PWR_CNTRL_REG0, 0x00050220)
    FIELD(RPU4_CORE1_PWR_CNTRL_REG0, POWERUP_REQ, 0, 1)
#define RPU4_CORE1_PWR_CNTRL_REG0_WRITE_MASK 0x00000001
#define RPU4_CORE1_PWR_CNTRL_REG0_RESET_VAL 0x1

REG32(RPU4_CORE1_PWR_CNTRL_REG1, 0x00050224)
    FIELD(RPU4_CORE1_PWR_CNTRL_REG1, PGE1_DELAY, 16, 16)
    FIELD(RPU4_CORE1_PWR_CNTRL_REG1, PGE2_DELAY, 0, 16)
#define RPU4_CORE1_PWR_CNTRL_REG1_WRITE_MASK 0xffffffff
#define RPU4_CORE1_PWR_CNTRL_REG1_RESET_VAL 0x0

REG32(RPU4_CORE1_PWR_CNTRL_REG2, 0x00050228)
    FIELD(RPU4_CORE1_PWR_CNTRL_REG2, PGE3_DELAY, 16, 16)
    FIELD(RPU4_CORE1_PWR_CNTRL_REG2, ISO_DELAY, 0, 16)
#define RPU4_CORE1_PWR_CNTRL_REG2_WRITE_MASK 0xffffffff
#define RPU4_CORE1_PWR_CNTRL_REG2_RESET_VAL 0x0

REG32(RPU4_CORE1_PWR_CNTRL_STS, 0x0005022c)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 12, 1)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, PWRUP_ACK_REG, 11, 1)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, RESET_GATE, 10, 1)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, CLOCK_EN, 9, 1)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, ISOLATION, 8, 1)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, PGE, 4, 4)
    FIELD(RPU4_CORE1_PWR_CNTRL_STS, PRDY, 0, 4)
#define RPU4_CORE1_PWR_CNTRL_STS_RESET_VAL 0x9ff

REG32(RPU4_CORE1_PWR_CNTRL_WPROT, 0x00050230)
    FIELD(RPU4_CORE1_PWR_CNTRL_WPROT, WPROT, 0, 1)
#define RPU4_CORE1_PWR_CNTRL_WPROT_WRITE_MASK 0x00000001
#define RPU4_CORE1_PWR_CNTRL_WPROT_RESET_VAL 0x1

REG32(OCM_PWR_CNTRL, 0x00050300)
    FIELD(OCM_PWR_CNTRL, B3_I3, 27, 1)
    FIELD(OCM_PWR_CNTRL, B3_I2, 26, 1)
    FIELD(OCM_PWR_CNTRL, B3_I1, 25, 1)
    FIELD(OCM_PWR_CNTRL, B3_I0, 24, 1)
    FIELD(OCM_PWR_CNTRL, B2_I3, 19, 1)
    FIELD(OCM_PWR_CNTRL, B2_I2, 18, 1)
    FIELD(OCM_PWR_CNTRL, B2_I1, 17, 1)
    FIELD(OCM_PWR_CNTRL, B2_I0, 16, 1)
    FIELD(OCM_PWR_CNTRL, B1_I3, 11, 1)
    FIELD(OCM_PWR_CNTRL, B1_I2, 10, 1)
    FIELD(OCM_PWR_CNTRL, B1_I1, 9, 1)
    FIELD(OCM_PWR_CNTRL, B1_I0, 8, 1)
    FIELD(OCM_PWR_CNTRL, B0_I3, 3, 1)
    FIELD(OCM_PWR_CNTRL, B0_I2, 2, 1)
    FIELD(OCM_PWR_CNTRL, B0_I1, 1, 1)
    FIELD(OCM_PWR_CNTRL, B0_I0, 0, 1)
#define OCM_PWR_CNTRL_WRITE_MASK 0x0f0f0f0f
#define OCM_PWR_CNTRL_RESET_VAL 0xf0f0f0f

REG32(OCM_CE_CNTRL, 0x00050304)
    FIELD(OCM_CE_CNTRL, B3_I3, 27, 1)
    FIELD(OCM_CE_CNTRL, B3_I2, 26, 1)
    FIELD(OCM_CE_CNTRL, B3_I1, 25, 1)
    FIELD(OCM_CE_CNTRL, B3_I0, 24, 1)
    FIELD(OCM_CE_CNTRL, B2_I3, 19, 1)
    FIELD(OCM_CE_CNTRL, B2_I2, 18, 1)
    FIELD(OCM_CE_CNTRL, B2_I1, 17, 1)
    FIELD(OCM_CE_CNTRL, B2_I0, 16, 1)
    FIELD(OCM_CE_CNTRL, B1_I3, 11, 1)
    FIELD(OCM_CE_CNTRL, B1_I2, 10, 1)
    FIELD(OCM_CE_CNTRL, B1_I1, 9, 1)
    FIELD(OCM_CE_CNTRL, B1_I0, 8, 1)
    FIELD(OCM_CE_CNTRL, B0_I3, 3, 1)
    FIELD(OCM_CE_CNTRL, B0_I2, 2, 1)
    FIELD(OCM_CE_CNTRL, B0_I1, 1, 1)
    FIELD(OCM_CE_CNTRL, B0_I0, 0, 1)
#define OCM_CE_CNTRL_WRITE_MASK 0x0f0f0f0f
#define OCM_CE_CNTRL_RESET_VAL 0xf0f0f0f

REG32(OCM_RET_CNTRL, 0x00050308)
    FIELD(OCM_RET_CNTRL, B3_I3, 27, 1)
    FIELD(OCM_RET_CNTRL, B3_I2, 26, 1)
    FIELD(OCM_RET_CNTRL, B3_I1, 25, 1)
    FIELD(OCM_RET_CNTRL, B3_I0, 24, 1)
    FIELD(OCM_RET_CNTRL, B2_I3, 19, 1)
    FIELD(OCM_RET_CNTRL, B2_I2, 18, 1)
    FIELD(OCM_RET_CNTRL, B2_I1, 17, 1)
    FIELD(OCM_RET_CNTRL, B2_I0, 16, 1)
    FIELD(OCM_RET_CNTRL, B1_I3, 11, 1)
    FIELD(OCM_RET_CNTRL, B1_I2, 10, 1)
    FIELD(OCM_RET_CNTRL, B1_I1, 9, 1)
    FIELD(OCM_RET_CNTRL, B1_I0, 8, 1)
    FIELD(OCM_RET_CNTRL, B0_I3, 3, 1)
    FIELD(OCM_RET_CNTRL, B0_I2, 2, 1)
    FIELD(OCM_RET_CNTRL, B0_I1, 1, 1)
    FIELD(OCM_RET_CNTRL, B0_I0, 0, 1)
#define OCM_RET_CNTRL_WRITE_MASK 0x0f0f0f0f
#define OCM_RET_CNTRL_RESET_VAL 0x0

REG32(OCM_PWR_STATUS, 0x0005030c)
    FIELD(OCM_PWR_STATUS, B3_I3, 27, 1)
    FIELD(OCM_PWR_STATUS, B3_I2, 26, 1)
    FIELD(OCM_PWR_STATUS, B3_I1, 25, 1)
    FIELD(OCM_PWR_STATUS, B3_I0, 24, 1)
    FIELD(OCM_PWR_STATUS, B2_I3, 19, 1)
    FIELD(OCM_PWR_STATUS, B2_I2, 18, 1)
    FIELD(OCM_PWR_STATUS, B2_I1, 17, 1)
    FIELD(OCM_PWR_STATUS, B2_I0, 16, 1)
    FIELD(OCM_PWR_STATUS, B1_I3, 11, 1)
    FIELD(OCM_PWR_STATUS, B1_I2, 10, 1)
    FIELD(OCM_PWR_STATUS, B1_I1, 9, 1)
    FIELD(OCM_PWR_STATUS, B1_I0, 8, 1)
    FIELD(OCM_PWR_STATUS, B0_I3, 3, 1)
    FIELD(OCM_PWR_STATUS, B0_I2, 2, 1)
    FIELD(OCM_PWR_STATUS, B0_I1, 1, 1)
    FIELD(OCM_PWR_STATUS, B0_I0, 0, 1)
#define OCM_PWR_STATUS_RESET_VAL 0xf0f0f0f

REG32(RPU_CACHE_PWR_CNTRL, 0x00050400)
    FIELD(RPU_CACHE_PWR_CNTRL, E1, 9, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, E0, 8, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, D1, 7, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, D0, 6, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, C1, 5, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, C0, 4, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, B1, 3, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, B0, 2, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, A1, 1, 1)
    FIELD(RPU_CACHE_PWR_CNTRL, A0, 0, 1)
#define RPU_CACHE_PWR_CNTRL_WRITE_MASK 0x000003ff
#define RPU_CACHE_PWR_CNTRL_RESET_VAL 0x3ff

REG32(RPU_CACHE_CE_CNTRL, 0x00050404)
    FIELD(RPU_CACHE_CE_CNTRL, E1, 9, 1)
    FIELD(RPU_CACHE_CE_CNTRL, E0, 8, 1)
    FIELD(RPU_CACHE_CE_CNTRL, D1, 7, 1)
    FIELD(RPU_CACHE_CE_CNTRL, D0, 6, 1)
    FIELD(RPU_CACHE_CE_CNTRL, C1, 5, 1)
    FIELD(RPU_CACHE_CE_CNTRL, C0, 4, 1)
    FIELD(RPU_CACHE_CE_CNTRL, B1, 3, 1)
    FIELD(RPU_CACHE_CE_CNTRL, B0, 2, 1)
    FIELD(RPU_CACHE_CE_CNTRL, A1, 1, 1)
    FIELD(RPU_CACHE_CE_CNTRL, A0, 0, 1)
#define RPU_CACHE_CE_CNTRL_WRITE_MASK 0x000003ff
#define RPU_CACHE_CE_CNTRL_RESET_VAL 0x3ff

REG32(RPU_CACHE_PWR_STATUS, 0x00050408)
    FIELD(RPU_CACHE_PWR_STATUS, E1, 9, 1)
    FIELD(RPU_CACHE_PWR_STATUS, E0, 8, 1)
    FIELD(RPU_CACHE_PWR_STATUS, D1, 7, 1)
    FIELD(RPU_CACHE_PWR_STATUS, D0, 6, 1)
    FIELD(RPU_CACHE_PWR_STATUS, C1, 5, 1)
    FIELD(RPU_CACHE_PWR_STATUS, C0, 4, 1)
    FIELD(RPU_CACHE_PWR_STATUS, B1, 3, 1)
    FIELD(RPU_CACHE_PWR_STATUS, B0, 2, 1)
    FIELD(RPU_CACHE_PWR_STATUS, A1, 1, 1)
    FIELD(RPU_CACHE_PWR_STATUS, A0, 0, 1)
#define RPU_CACHE_PWR_STATUS_RESET_VAL 0x3ff

REG32(RPU_TCM_PWR_CNTRL, 0x00050410)
    FIELD(RPU_TCM_PWR_CNTRL, TCME1, 9, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCME0, 8, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMD1, 7, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMD0, 6, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMC1, 5, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMC0, 4, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMB1, 3, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMB0, 2, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMA1, 1, 1)
    FIELD(RPU_TCM_PWR_CNTRL, TCMA0, 0, 1)
#define RPU_TCM_PWR_CNTRL_WRITE_MASK 0x000003ff
#define RPU_TCM_PWR_CNTRL_RESET_VAL 0x3ff

REG32(RPU_TCM_CE_CNTRL, 0x00050414)
    FIELD(RPU_TCM_CE_CNTRL, TCME1, 9, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCME0, 8, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMD1, 7, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMD0, 6, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMC1, 5, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMC0, 4, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMB1, 3, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMB0, 2, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMA1, 1, 1)
    FIELD(RPU_TCM_CE_CNTRL, TCMA0, 0, 1)
#define RPU_TCM_CE_CNTRL_WRITE_MASK 0x000003ff
#define RPU_TCM_CE_CNTRL_RESET_VAL 0x3ff

REG32(RPU_TCM_RET_CNTRL, 0x00050418)
    FIELD(RPU_TCM_RET_CNTRL, TCME1, 9, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCME0, 8, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMD1, 7, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMD0, 6, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMC1, 5, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMC0, 4, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMB1, 3, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMB0, 2, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMA1, 1, 1)
    FIELD(RPU_TCM_RET_CNTRL, TCMA0, 0, 1)
#define RPU_TCM_RET_CNTRL_WRITE_MASK 0x000003ff
#define RPU_TCM_RET_CNTRL_RESET_VAL 0x0

REG32(RPU_TCM_PWR_STATUS, 0x0005041c)
    FIELD(RPU_TCM_PWR_STATUS, TCME1, 9, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCME0, 8, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMD1, 7, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMD0, 6, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMC1, 5, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMC0, 4, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMB1, 3, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMB0, 2, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMA1, 1, 1)
    FIELD(RPU_TCM_PWR_STATUS, TCMA0, 0, 1)
#define RPU_TCM_PWR_STATUS_RESET_VAL 0x3ff

REG32(GEM_PWR_CNTRL, 0x00050420)
    FIELD(GEM_PWR_CNTRL, GEM1, 8, 1)
    FIELD(GEM_PWR_CNTRL, GEM0, 0, 1)
#define GEM_PWR_CNTRL_WRITE_MASK 0x00000101
#define GEM_PWR_CNTRL_RESET_VAL 0x101

REG32(GEM_CE_CNTRL, 0x00050424)
    FIELD(GEM_CE_CNTRL, GEM1, 1, 1)
    FIELD(GEM_CE_CNTRL, GEM0, 0, 1)
#define GEM_CE_CNTRL_WRITE_MASK 0x00000003
#define GEM_CE_CNTRL_RESET_VAL 0x3

REG32(GEM_PWR_STATUS, 0x00050428)
    FIELD(GEM_PWR_STATUS, GEM1, 8, 1)
    FIELD(GEM_PWR_STATUS, GEM0, 0, 1)
#define GEM_PWR_STATUS_RESET_VAL 0x101

REG32(LLC_RAM_PWR_STATUS, 0x00050460)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD3_1, 31, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD3_0, 30, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD2_1, 29, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD2_0, 28, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD1_1, 27, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD1_0, 26, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD0_1, 25, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF200_QUADWORD0_0, 24, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD3_1, 23, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD3_0, 22, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD2_1, 21, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD2_0, 20, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD1_1, 19, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD1_0, 18, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD0_1, 17, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF136_QUADWORD0_0, 16, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD3_1, 15, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD3_0, 14, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD2_1, 13, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD2_0, 12, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD1_1, 11, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD1_0, 10, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD0_1, 9, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF72_QUADWORD0_0, 8, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD3_1, 7, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD3_0, 6, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD2_1, 5, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD2_0, 4, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD1_1, 3, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD1_0, 2, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD0_1, 1, 1)
    FIELD(LLC_RAM_PWR_STATUS, HNF8_QUADWORD0_0, 0, 1)
#define LLC_RAM_PWR_STATUS_RESET_VAL 0x0

REG32(APU0_DSU_L3_PWR_CNTRL, 0x00050470)
    FIELD(APU0_DSU_L3_PWR_CNTRL, LTDB, 8, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, SF, 7, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, VICTIM, 6, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, DATA1, 5, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, DATA0, 4, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, TAG3, 3, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, TAG2, 2, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, TAG1, 1, 1)
    FIELD(APU0_DSU_L3_PWR_CNTRL, TAG0, 0, 1)
#define APU0_DSU_L3_PWR_CNTRL_WRITE_MASK 0x000001ff
#define APU0_DSU_L3_PWR_CNTRL_RESET_VAL 0x1ff

REG32(APU0_DSU_L3_CE_CNTRL, 0x00050474)
    FIELD(APU0_DSU_L3_CE_CNTRL, LTDB, 8, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, SF, 7, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, VICTIM, 6, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, DATA1, 5, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, DATA0, 4, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, TAG3, 3, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, TAG2, 2, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, TAG1, 1, 1)
    FIELD(APU0_DSU_L3_CE_CNTRL, TAG0, 0, 1)
#define APU0_DSU_L3_CE_CNTRL_WRITE_MASK 0x000001ff
#define APU0_DSU_L3_CE_CNTRL_RESET_VAL 0x1ff

REG32(APU0_DSU_L3_PWR_STATUS, 0x00050478)
    FIELD(APU0_DSU_L3_PWR_STATUS, LTDB, 8, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, SF, 7, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, VICTIM, 6, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, DATA1, 5, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, DATA0, 4, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, TAG3, 3, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, TAG2, 2, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, TAG1, 1, 1)
    FIELD(APU0_DSU_L3_PWR_STATUS, TAG0, 0, 1)
#define APU0_DSU_L3_PWR_STATUS_RESET_VAL 0x1ff

REG32(APU1_DSU_L3_PWR_CNTRL, 0x0005047c)
    FIELD(APU1_DSU_L3_PWR_CNTRL, LTDB, 8, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, SF, 7, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, VICTIM, 6, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, DATA1, 5, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, DATA0, 4, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, TAG3, 3, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, TAG2, 2, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, TAG1, 1, 1)
    FIELD(APU1_DSU_L3_PWR_CNTRL, TAG0, 0, 1)
#define APU1_DSU_L3_PWR_CNTRL_WRITE_MASK 0x000001ff
#define APU1_DSU_L3_PWR_CNTRL_RESET_VAL 0x1ff

REG32(APU1_DSU_L3_CE_CNTRL, 0x00050480)
    FIELD(APU1_DSU_L3_CE_CNTRL, LTDB, 8, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, SF, 7, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, VICTIM, 6, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, DATA1, 5, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, DATA0, 4, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, TAG3, 3, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, TAG2, 2, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, TAG1, 1, 1)
    FIELD(APU1_DSU_L3_CE_CNTRL, TAG0, 0, 1)
#define APU1_DSU_L3_CE_CNTRL_WRITE_MASK 0x000001ff
#define APU1_DSU_L3_CE_CNTRL_RESET_VAL 0x1ff

REG32(APU1_DSU_L3_PWR_STATUS, 0x00050484)
    FIELD(APU1_DSU_L3_PWR_STATUS, LTDB, 8, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, SF, 7, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, VICTIM, 6, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, DATA1, 5, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, DATA0, 4, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, TAG3, 3, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, TAG2, 2, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, TAG1, 1, 1)
    FIELD(APU1_DSU_L3_PWR_STATUS, TAG0, 0, 1)
#define APU1_DSU_L3_PWR_STATUS_RESET_VAL 0x1ff

REG32(APU2_DSU_L3_PWR_CNTRL, 0x00050488)
    FIELD(APU2_DSU_L3_PWR_CNTRL, LTDB, 8, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, SF, 7, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, VICTIM, 6, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, DATA1, 5, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, DATA0, 4, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, TAG3, 3, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, TAG2, 2, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, TAG1, 1, 1)
    FIELD(APU2_DSU_L3_PWR_CNTRL, TAG0, 0, 1)
#define APU2_DSU_L3_PWR_CNTRL_WRITE_MASK 0x000001ff
#define APU2_DSU_L3_PWR_CNTRL_RESET_VAL 0x1ff

REG32(APU2_DSU_L3_CE_CNTRL, 0x0005048c)
    FIELD(APU2_DSU_L3_CE_CNTRL, LTDB, 8, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, SF, 7, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, VICTIM, 6, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, DATA1, 5, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, DATA0, 4, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, TAG3, 3, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, TAG2, 2, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, TAG1, 1, 1)
    FIELD(APU2_DSU_L3_CE_CNTRL, TAG0, 0, 1)
#define APU2_DSU_L3_CE_CNTRL_WRITE_MASK 0x000001ff
#define APU2_DSU_L3_CE_CNTRL_RESET_VAL 0x1ff

REG32(APU2_DSU_L3_PWR_STATUS, 0x00050490)
    FIELD(APU2_DSU_L3_PWR_STATUS, LTDB, 8, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, SF, 7, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, VICTIM, 6, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, DATA1, 5, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, DATA0, 4, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, TAG3, 3, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, TAG2, 2, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, TAG1, 1, 1)
    FIELD(APU2_DSU_L3_PWR_STATUS, TAG0, 0, 1)
#define APU2_DSU_L3_PWR_STATUS_RESET_VAL 0x1ff

REG32(APU3_DSU_L3_PWR_CNTRL, 0x00050494)
    FIELD(APU3_DSU_L3_PWR_CNTRL, LTDB, 8, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, SF, 7, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, VICTIM, 6, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, DATA1, 5, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, DATA0, 4, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, TAG3, 3, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, TAG2, 2, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, TAG1, 1, 1)
    FIELD(APU3_DSU_L3_PWR_CNTRL, TAG0, 0, 1)
#define APU3_DSU_L3_PWR_CNTRL_WRITE_MASK 0x000001ff
#define APU3_DSU_L3_PWR_CNTRL_RESET_VAL 0x1ff

REG32(APU3_DSU_L3_CE_CNTRL, 0x00050498)
    FIELD(APU3_DSU_L3_CE_CNTRL, LTDB, 8, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, SF, 7, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, VICTIM, 6, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, DATA1, 5, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, DATA0, 4, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, TAG3, 3, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, TAG2, 2, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, TAG1, 1, 1)
    FIELD(APU3_DSU_L3_CE_CNTRL, TAG0, 0, 1)
#define APU3_DSU_L3_CE_CNTRL_WRITE_MASK 0x000001ff
#define APU3_DSU_L3_CE_CNTRL_RESET_VAL 0x1ff

REG32(APU3_DSU_L3_PWR_STATUS, 0x0005049c)
    FIELD(APU3_DSU_L3_PWR_STATUS, LTDB, 8, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, SF, 7, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, VICTIM, 6, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, DATA1, 5, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, DATA0, 4, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, TAG3, 3, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, TAG2, 2, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, TAG1, 1, 1)
    FIELD(APU3_DSU_L3_PWR_STATUS, TAG0, 0, 1)
#define APU3_DSU_L3_PWR_STATUS_RESET_VAL 0x1ff

REG32(DOMAIN_ISO_CNTRL, 0x00050500)
    FIELD(DOMAIN_ISO_CNTRL, FPD_MMI_DFX, 3, 1)
    FIELD(DOMAIN_ISO_CNTRL, FPD_MMI, 2, 1)
    FIELD(DOMAIN_ISO_CNTRL, LPD_FPD_DFX, 1, 1)
    FIELD(DOMAIN_ISO_CNTRL, LPD_FPD, 0, 1)
#define DOMAIN_ISO_CNTRL_WRITE_MASK 0x0000000f
#define DOMAIN_ISO_CNTRL_RESET_VAL 0x1f

REG32(APU_GICD_P_CHAN_IN, 0x00050504)
    FIELD(APU_GICD_P_CHAN_IN, PSTATE, 1, 5)
    FIELD(APU_GICD_P_CHAN_IN, PREQ, 0, 1)
#define APU_GICD_P_CHAN_IN_WRITE_MASK 0x0000003f
#define APU_GICD_P_CHAN_IN_RESET_VAL 0x0

REG32(APU_GICD_P_CHAN_OUT, 0x00050508)
    FIELD(APU_GICD_P_CHAN_OUT, PDENY, 2, 1)
    FIELD(APU_GICD_P_CHAN_OUT, PACCEPT, 1, 1)
    FIELD(APU_GICD_P_CHAN_OUT, PACTIVE, 0, 1)
#define APU_GICD_P_CHAN_OUT_RESET_VAL 0x0

REG32(WAKEUP0_IRQ_STATUS, 0x00050600)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD1, 28, 1)
    FIELD(WAKEUP0_IRQ_STATUS, RSVD0, 27, 1)
    FIELD(WAKEUP0_IRQ_STATUS, FPD_DBG, 26, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU_CLUSTER_DBG, 25, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU_CORE_DBG, 24, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_DSU_CORESIGHT, 21, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_DSU_CORESIGHT, 20, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE1_CORESIGHT, 13, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE0_CORESIGHT, 12, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CLUSTER, 11, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CLUSTER, 10, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CLUSTER, 9, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CLUSTER, 8, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE1, 7, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU3_CORE0, 6, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU2_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE1, 3, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU1_CORE0, 2, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_STATUS, APU0_CORE0, 0, 1)
#define WAKEUP0_IRQ_STATUS_RESET_VAL 0x0

REG32(WAKEUP0_IRQ_MASK, 0x00050604)
    FIELD(WAKEUP0_IRQ_MASK, RSVD1, 28, 1)
    FIELD(WAKEUP0_IRQ_MASK, RSVD0, 27, 1)
    FIELD(WAKEUP0_IRQ_MASK, FPD_DBG, 26, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU_CLUSTER_DBG, 25, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU_CORE_DBG, 24, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_DSU_CORESIGHT, 21, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_DSU_CORESIGHT, 20, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE1_CORESIGHT, 13, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE0_CORESIGHT, 12, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CLUSTER, 11, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CLUSTER, 10, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CLUSTER, 9, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CLUSTER, 8, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE1, 7, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU3_CORE0, 6, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU2_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE1, 3, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU1_CORE0, 2, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_MASK, APU0_CORE0, 0, 1)
#define WAKEUP0_IRQ_MASK_RESET_VAL 0x1fffffff

REG32(WAKEUP0_IRQ_EN, 0x00050608)
    FIELD(WAKEUP0_IRQ_EN, RSVD1, 28, 1)
    FIELD(WAKEUP0_IRQ_EN, RSVD0, 27, 1)
    FIELD(WAKEUP0_IRQ_EN, FPD_DBG, 26, 1)
    FIELD(WAKEUP0_IRQ_EN, APU_CLUSTER_DBG, 25, 1)
    FIELD(WAKEUP0_IRQ_EN, APU_CORE_DBG, 24, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_DSU_CORESIGHT, 21, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_DSU_CORESIGHT, 20, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE1_CORESIGHT, 13, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE0_CORESIGHT, 12, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CLUSTER, 11, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CLUSTER, 10, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CLUSTER, 9, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CLUSTER, 8, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE1, 7, 1)
    FIELD(WAKEUP0_IRQ_EN, APU3_CORE0, 6, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_EN, APU2_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE1, 3, 1)
    FIELD(WAKEUP0_IRQ_EN, APU1_CORE0, 2, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_EN, APU0_CORE0, 0, 1)
#define WAKEUP0_IRQ_EN_RESET_VAL 0x0

REG32(WAKEUP0_IRQ_DIS, 0x0005060c)
    FIELD(WAKEUP0_IRQ_DIS, RSVD1, 28, 1)
    FIELD(WAKEUP0_IRQ_DIS, RSVD0, 27, 1)
    FIELD(WAKEUP0_IRQ_DIS, FPD_DBG, 26, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU_CLUSTER_DBG, 25, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU_CORE_DBG, 24, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_DSU_CORESIGHT, 21, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_DSU_CORESIGHT, 20, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE1_CORESIGHT, 13, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE0_CORESIGHT, 12, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CLUSTER, 11, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CLUSTER, 10, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CLUSTER, 9, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CLUSTER, 8, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE1, 7, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU3_CORE0, 6, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU2_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE1, 3, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU1_CORE0, 2, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_DIS, APU0_CORE0, 0, 1)
#define WAKEUP0_IRQ_DIS_RESET_VAL 0x0

REG32(WAKEUP0_IRQ_TRIG, 0x00050610)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD1, 28, 1)
    FIELD(WAKEUP0_IRQ_TRIG, RSVD0, 27, 1)
    FIELD(WAKEUP0_IRQ_TRIG, FPD_DBG, 26, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU_CLUSTER_DBG, 25, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU_CORE_DBG, 24, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_DSU_CORESIGHT, 23, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_DSU_CORESIGHT, 22, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_DSU_CORESIGHT, 21, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_DSU_CORESIGHT, 20, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE1_CORESIGHT, 15, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE0_CORESIGHT, 14, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE1_CORESIGHT, 13, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE0_CORESIGHT, 12, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CLUSTER, 11, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CLUSTER, 10, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CLUSTER, 9, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CLUSTER, 8, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE1, 7, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU3_CORE0, 6, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE1, 5, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU2_CORE0, 4, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE1, 3, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU1_CORE0, 2, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE1, 1, 1)
    FIELD(WAKEUP0_IRQ_TRIG, APU0_CORE0, 0, 1)
#define WAKEUP0_IRQ_TRIG_RESET_VAL 0x0

REG32(WAKEUP1_IRQ_STATUS, 0x00050614)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_E_CORE1_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_E_CORE0_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_D_CORE1_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_D_CORE0_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_C_CORE1_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_C_CORE0_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_E_CORE1, 9, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_E_CORE0, 8, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_D_CORE1, 7, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_D_CORE0, 6, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_C_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_C_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_B_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE1, 1, 1)
    FIELD(WAKEUP1_IRQ_STATUS, RPU_A_CORE0, 0, 1)
#define WAKEUP1_IRQ_STATUS_RESET_VAL 0x0

REG32(WAKEUP1_IRQ_MASK, 0x00050618)
    FIELD(WAKEUP1_IRQ_MASK, RPU_E_CORE1_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_E_CORE0_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_D_CORE1_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_D_CORE0_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_C_CORE1_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_C_CORE0_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_E_CORE1, 9, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_E_CORE0, 8, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_D_CORE1, 7, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_D_CORE0, 6, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_C_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_C_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_B_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE1, 1, 1)
    FIELD(WAKEUP1_IRQ_MASK, RPU_A_CORE0, 0, 1)
#define WAKEUP1_IRQ_MASK_RESET_VAL 0x3ff03ff

REG32(WAKEUP1_IRQ_EN, 0x0005061c)
    FIELD(WAKEUP1_IRQ_EN, RPU_E_CORE1_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_E_CORE0_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_D_CORE1_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_D_CORE0_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_C_CORE1_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_C_CORE0_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_E_CORE1, 9, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_E_CORE0, 8, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_D_CORE1, 7, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_D_CORE0, 6, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_C_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_C_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_B_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE1, 1, 1)
    FIELD(WAKEUP1_IRQ_EN, RPU_A_CORE0, 0, 1)
#define WAKEUP1_IRQ_EN_RESET_VAL 0x0

REG32(WAKEUP1_IRQ_DIS, 0x00050620)
    FIELD(WAKEUP1_IRQ_DIS, RPU_E_CORE1_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_E_CORE0_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_D_CORE1_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_D_CORE0_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_C_CORE1_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_C_CORE0_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_E_CORE1, 9, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_E_CORE0, 8, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_D_CORE1, 7, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_D_CORE0, 6, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_C_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_C_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_B_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE1, 1, 1)
    FIELD(WAKEUP1_IRQ_DIS, RPU_A_CORE0, 0, 1)
#define WAKEUP1_IRQ_DIS_RESET_VAL 0x0

REG32(WAKEUP1_IRQ_TRIG, 0x00050624)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_E_CORE1_CORESIGHT, 25, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_E_CORE0_CORESIGHT, 24, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_D_CORE1_CORESIGHT, 23, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_D_CORE0_CORESIGHT, 22, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_C_CORE1_CORESIGHT, 21, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_C_CORE0_CORESIGHT, 20, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE1_CORESIGHT, 19, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE0_CORESIGHT, 18, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE1_CORESIGHT, 17, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE0_CORESIGHT, 16, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_E_CORE1, 9, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_E_CORE0, 8, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_D_CORE1, 7, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_D_CORE0, 6, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_C_CORE1, 5, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_C_CORE0, 4, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE1, 3, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_B_CORE0, 2, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE1, 1, 1)
    FIELD(WAKEUP1_IRQ_TRIG, RPU_A_CORE0, 0, 1)
#define WAKEUP1_IRQ_TRIG_RESET_VAL 0x0

REG32(POWER_DWN_IRQ_STATUS, 0x00050630)
    FIELD(POWER_DWN_IRQ_STATUS, RSVD1, 26, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUE_CORE1_PWRDWN, 25, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUE_CORE0_PWRDWN, 24, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUD_CORE1_PWRDWN, 23, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUD_CORE0_PWRDWN, 22, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUC_CORE1_PWRDWN, 21, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUC_CORE0_PWRDWN, 20, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUB_CORE1_PWRDWN, 19, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUB_CORE0_PWRDWN, 18, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUA_CORE1_PWRDWN, 17, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RPUA_CORE0_PWRDWN, 16, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU3_CLUSTER, 15, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU2_CLUSTER, 14, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU1_CLUSTER, 13, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU0_CLUSTER, 12, 1)
    FIELD(POWER_DWN_IRQ_STATUS, RSVD0, 8, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU3_CORE1_PWRDWN, 7, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU3_CORE0_PWRDWN, 6, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU2_CORE1_PWRDWN, 5, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU2_CORE0_PWRDWN, 4, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU1_CORE1_PWRDWN, 3, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU1_CORE0_PWRDWN, 2, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(POWER_DWN_IRQ_STATUS, APU0_CORE0_PWRDWN, 0, 1)
#define POWER_DWN_IRQ_STATUS_RESET_VAL 0x0

REG32(POWER_DWN_IRQ_MASK, 0x00050634)
    FIELD(POWER_DWN_IRQ_MASK, RSVD1, 26, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUE_CORE1_PWRDWN, 25, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUE_CORE0_PWRDWN, 24, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUD_CORE1_PWRDWN, 23, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUD_CORE0_PWRDWN, 22, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUC_CORE1_PWRDWN, 21, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUC_CORE0_PWRDWN, 20, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUB_CORE1_PWRDWN, 19, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUB_CORE0_PWRDWN, 18, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUA_CORE1_PWRDWN, 17, 1)
    FIELD(POWER_DWN_IRQ_MASK, RPUA_CORE0_PWRDWN, 16, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU3_CLUSTER, 15, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU2_CLUSTER, 14, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU1_CLUSTER, 13, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU0_CLUSTER, 12, 1)
    FIELD(POWER_DWN_IRQ_MASK, RSVD0, 8, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU3_CORE1_PWRDWN, 7, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU3_CORE0_PWRDWN, 6, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU2_CORE1_PWRDWN, 5, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU2_CORE0_PWRDWN, 4, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU1_CORE1_PWRDWN, 3, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU1_CORE0_PWRDWN, 2, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(POWER_DWN_IRQ_MASK, APU0_CORE0_PWRDWN, 0, 1)
#define POWER_DWN_IRQ_MASK_RESET_VAL 0x7fff1ff

REG32(POWER_DWN_IRQ_EN, 0x00050638)
    FIELD(POWER_DWN_IRQ_EN, RSVD1, 26, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUE_CORE1_PWRDWN, 25, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUE_CORE0_PWRDWN, 24, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUD_CORE1_PWRDWN, 23, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUD_CORE0_PWRDWN, 22, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUC_CORE1_PWRDWN, 21, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUC_CORE0_PWRDWN, 20, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUB_CORE1_PWRDWN, 19, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUB_CORE0_PWRDWN, 18, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUA_CORE1_PWRDWN, 17, 1)
    FIELD(POWER_DWN_IRQ_EN, RPUA_CORE0_PWRDWN, 16, 1)
    FIELD(POWER_DWN_IRQ_EN, APU3_CLUSTER, 15, 1)
    FIELD(POWER_DWN_IRQ_EN, APU2_CLUSTER, 14, 1)
    FIELD(POWER_DWN_IRQ_EN, APU1_CLUSTER, 13, 1)
    FIELD(POWER_DWN_IRQ_EN, APU0_CLUSTER, 12, 1)
    FIELD(POWER_DWN_IRQ_EN, RSVD0, 8, 1)
    FIELD(POWER_DWN_IRQ_EN, APU3_CORE1_PWRDWN, 7, 1)
    FIELD(POWER_DWN_IRQ_EN, APU3_CORE0_PWRDWN, 6, 1)
    FIELD(POWER_DWN_IRQ_EN, APU2_CORE1_PWRDWN, 5, 1)
    FIELD(POWER_DWN_IRQ_EN, APU2_CORE0_PWRDWN, 4, 1)
    FIELD(POWER_DWN_IRQ_EN, APU1_CORE1_PWRDWN, 3, 1)
    FIELD(POWER_DWN_IRQ_EN, APU1_CORE0_PWRDWN, 2, 1)
    FIELD(POWER_DWN_IRQ_EN, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(POWER_DWN_IRQ_EN, APU0_CORE0_PWRDWN, 0, 1)
#define POWER_DWN_IRQ_EN_RESET_VAL 0x0

REG32(POWER_DWN_IRQ_DIS, 0x0005063c)
    FIELD(POWER_DWN_IRQ_DIS, RSVD1, 26, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUE_CORE1_PWRDWN, 25, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUE_CORE0_PWRDWN, 24, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUD_CORE1_PWRDWN, 23, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUD_CORE0_PWRDWN, 22, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUC_CORE1_PWRDWN, 21, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUC_CORE0_PWRDWN, 20, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUB_CORE1_PWRDWN, 19, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUB_CORE0_PWRDWN, 18, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUA_CORE1_PWRDWN, 17, 1)
    FIELD(POWER_DWN_IRQ_DIS, RPUA_CORE0_PWRDWN, 16, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU3_CLUSTER, 15, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU2_CLUSTER, 14, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU1_CLUSTER, 13, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU0_CLUSTER, 12, 1)
    FIELD(POWER_DWN_IRQ_DIS, RSVD0, 8, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU3_CORE1_PWRDWN, 7, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU3_CORE0_PWRDWN, 6, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU2_CORE1_PWRDWN, 5, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU2_CORE0_PWRDWN, 4, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU1_CORE1_PWRDWN, 3, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU1_CORE0_PWRDWN, 2, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(POWER_DWN_IRQ_DIS, APU0_CORE0_PWRDWN, 0, 1)
#define POWER_DWN_IRQ_DIS_RESET_VAL 0x0

REG32(POWER_DWN_IRQ_TRIG, 0x00050640)
    FIELD(POWER_DWN_IRQ_TRIG, RSVD1, 26, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUE_CORE1_PWRDWN, 25, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUE_CORE0_PWRDWN, 24, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUD_CORE1_PWRDWN, 23, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUD_CORE0_PWRDWN, 22, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUC_CORE1_PWRDWN, 21, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUC_CORE0_PWRDWN, 20, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUB_CORE1_PWRDWN, 19, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUB_CORE0_PWRDWN, 18, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUA_CORE1_PWRDWN, 17, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RPUA_CORE0_PWRDWN, 16, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU3_CLUSTER, 15, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU2_CLUSTER, 14, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU1_CLUSTER, 13, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU0_CLUSTER, 12, 1)
    FIELD(POWER_DWN_IRQ_TRIG, RSVD0, 8, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU3_CORE1_PWRDWN, 7, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU3_CORE0_PWRDWN, 6, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU2_CORE1_PWRDWN, 5, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU2_CORE0_PWRDWN, 4, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU1_CORE1_PWRDWN, 3, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU1_CORE0_PWRDWN, 2, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU0_CORE1_PWRDWN, 1, 1)
    FIELD(POWER_DWN_IRQ_TRIG, APU0_CORE0_PWRDWN, 0, 1)
#define POWER_DWN_IRQ_TRIG_RESET_VAL 0x0

REG32(PWR_RST_IRQ_STATUS, 0x00050650)
    FIELD(PWR_RST_IRQ_STATUS, FPD_SUPPLY, 31, 1)
    FIELD(PWR_RST_IRQ_STATUS, RSVD1, 30, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPU_STANDBY, 29, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU_STANDBY, 28, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUE_CORE1_WARM_RST, 27, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUE_CORE0_WARM_RST, 26, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUD_CORE1_WARM_RST, 25, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUD_CORE0_WARM_RST, 24, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUC_CORE1_WARM_RST, 23, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUC_CORE0_WARM_RST, 22, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUB_CORE1_WARM_RST, 21, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUB_CORE0_WARM_RST, 20, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUA_CORE1_WARM_RST, 19, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUA_CORE0_WARM_RST, 18, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUE_CORE1_DBG_RST, 17, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUE_CORE0_DBG_RST, 16, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUD_CORE1_DBG_RST, 15, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUD_CORE0_DBG_RST, 14, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUC_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUC_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUB_CORE1_DBG_RST, 11, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUB_CORE0_DBG_RST, 10, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUA_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_RST_IRQ_STATUS, RPUA_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU3_CORE1_DBG_RST, 7, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU3_CORE0_DBG_RST, 6, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU2_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU2_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU1_CORE1_DBG_RST, 3, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU1_CORE0_DBG_RST, 2, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_RST_IRQ_STATUS, APU0_CORE0_DBG_RST, 0, 1)
#define PWR_RST_IRQ_STATUS_RESET_VAL 0x0

REG32(PWR_RST_IRQ_MASK, 0x00050654)
    FIELD(PWR_RST_IRQ_MASK, FPD_SUPPLY, 31, 1)
    FIELD(PWR_RST_IRQ_MASK, RSVD1, 30, 1)
    FIELD(PWR_RST_IRQ_MASK, RPU_STANDBY, 29, 1)
    FIELD(PWR_RST_IRQ_MASK, APU_STANDBY, 28, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUE_CORE1_WARM_RST, 27, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUE_CORE0_WARM_RST, 26, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUD_CORE1_WARM_RST, 25, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUD_CORE0_WARM_RST, 24, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUC_CORE1_WARM_RST, 23, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUC_CORE0_WARM_RST, 22, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUB_CORE1_WARM_RST, 21, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUB_CORE0_WARM_RST, 20, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUA_CORE1_WARM_RST, 19, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUA_CORE0_WARM_RST, 18, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUE_CORE1_DBG_RST, 17, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUE_CORE0_DBG_RST, 16, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUD_CORE1_DBG_RST, 15, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUD_CORE0_DBG_RST, 14, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUC_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUC_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUB_CORE1_DBG_RST, 11, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUB_CORE0_DBG_RST, 10, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUA_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_RST_IRQ_MASK, RPUA_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_RST_IRQ_MASK, APU3_CORE1_DBG_RST, 7, 1)
    FIELD(PWR_RST_IRQ_MASK, APU3_CORE0_DBG_RST, 6, 1)
    FIELD(PWR_RST_IRQ_MASK, APU2_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_RST_IRQ_MASK, APU2_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_RST_IRQ_MASK, APU1_CORE1_DBG_RST, 3, 1)
    FIELD(PWR_RST_IRQ_MASK, APU1_CORE0_DBG_RST, 2, 1)
    FIELD(PWR_RST_IRQ_MASK, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_RST_IRQ_MASK, APU0_CORE0_DBG_RST, 0, 1)
#define PWR_RST_IRQ_MASK_RESET_VAL 0xffffffff

REG32(PWR_RST_IRQ_EN, 0x00050658)
    FIELD(PWR_RST_IRQ_EN, FPD_SUPPLY, 31, 1)
    FIELD(PWR_RST_IRQ_EN, RSVD1, 30, 1)
    FIELD(PWR_RST_IRQ_EN, RPU_STANDBY, 29, 1)
    FIELD(PWR_RST_IRQ_EN, APU_STANDBY, 28, 1)
    FIELD(PWR_RST_IRQ_EN, RPUE_CORE1_WARM_RST, 27, 1)
    FIELD(PWR_RST_IRQ_EN, RPUE_CORE0_WARM_RST, 26, 1)
    FIELD(PWR_RST_IRQ_EN, RPUD_CORE1_WARM_RST, 25, 1)
    FIELD(PWR_RST_IRQ_EN, RPUD_CORE0_WARM_RST, 24, 1)
    FIELD(PWR_RST_IRQ_EN, RPUC_CORE1_WARM_RST, 23, 1)
    FIELD(PWR_RST_IRQ_EN, RPUC_CORE0_WARM_RST, 22, 1)
    FIELD(PWR_RST_IRQ_EN, RPUB_CORE1_WARM_RST, 21, 1)
    FIELD(PWR_RST_IRQ_EN, RPUB_CORE0_WARM_RST, 20, 1)
    FIELD(PWR_RST_IRQ_EN, RPUA_CORE1_WARM_RST, 19, 1)
    FIELD(PWR_RST_IRQ_EN, RPUA_CORE0_WARM_RST, 18, 1)
    FIELD(PWR_RST_IRQ_EN, RPUE_CORE1_DBG_RST, 17, 1)
    FIELD(PWR_RST_IRQ_EN, RPUE_CORE0_DBG_RST, 16, 1)
    FIELD(PWR_RST_IRQ_EN, RPUD_CORE1_DBG_RST, 15, 1)
    FIELD(PWR_RST_IRQ_EN, RPUD_CORE0_DBG_RST, 14, 1)
    FIELD(PWR_RST_IRQ_EN, RPUC_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_RST_IRQ_EN, RPUC_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_RST_IRQ_EN, RPUB_CORE1_DBG_RST, 11, 1)
    FIELD(PWR_RST_IRQ_EN, RPUB_CORE0_DBG_RST, 10, 1)
    FIELD(PWR_RST_IRQ_EN, RPUA_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_RST_IRQ_EN, RPUA_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_RST_IRQ_EN, APU3_CORE1_DBG_RST, 7, 1)
    FIELD(PWR_RST_IRQ_EN, APU3_CORE0_DBG_RST, 6, 1)
    FIELD(PWR_RST_IRQ_EN, APU2_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_RST_IRQ_EN, APU2_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_RST_IRQ_EN, APU1_CORE1_DBG_RST, 3, 1)
    FIELD(PWR_RST_IRQ_EN, APU1_CORE0_DBG_RST, 2, 1)
    FIELD(PWR_RST_IRQ_EN, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_RST_IRQ_EN, APU0_CORE0_DBG_RST, 0, 1)
#define PWR_RST_IRQ_EN_RESET_VAL 0x0

REG32(PWR_RST_IRQ_DIS, 0x0005065c)
    FIELD(PWR_RST_IRQ_DIS, FPD_SUPPLY, 31, 1)
    FIELD(PWR_RST_IRQ_DIS, RSVD1, 30, 1)
    FIELD(PWR_RST_IRQ_DIS, RPU_STANDBY, 29, 1)
    FIELD(PWR_RST_IRQ_DIS, APU_STANDBY, 28, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUE_CORE1_WARM_RST, 27, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUE_CORE0_WARM_RST, 26, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUD_CORE1_WARM_RST, 25, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUD_CORE0_WARM_RST, 24, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUC_CORE1_WARM_RST, 23, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUC_CORE0_WARM_RST, 22, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUB_CORE1_WARM_RST, 21, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUB_CORE0_WARM_RST, 20, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUA_CORE1_WARM_RST, 19, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUA_CORE0_WARM_RST, 18, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUE_CORE1_DBG_RST, 17, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUE_CORE0_DBG_RST, 16, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUD_CORE1_DBG_RST, 15, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUD_CORE0_DBG_RST, 14, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUC_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUC_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUB_CORE1_DBG_RST, 11, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUB_CORE0_DBG_RST, 10, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUA_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_RST_IRQ_DIS, RPUA_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_RST_IRQ_DIS, APU3_CORE1_DBG_RST, 7, 1)
    FIELD(PWR_RST_IRQ_DIS, APU3_CORE0_DBG_RST, 6, 1)
    FIELD(PWR_RST_IRQ_DIS, APU2_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_RST_IRQ_DIS, APU2_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_RST_IRQ_DIS, APU1_CORE1_DBG_RST, 3, 1)
    FIELD(PWR_RST_IRQ_DIS, APU1_CORE0_DBG_RST, 2, 1)
    FIELD(PWR_RST_IRQ_DIS, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_RST_IRQ_DIS, APU0_CORE0_DBG_RST, 0, 1)
#define PWR_RST_IRQ_DIS_RESET_VAL 0x0

REG32(PWR_RST_IRQ_TRIG, 0x00050660)
    FIELD(PWR_RST_IRQ_TRIG, FPD_SUPPLY, 31, 1)
    FIELD(PWR_RST_IRQ_TRIG, RSVD1, 30, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPU_STANDBY, 29, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU_STANDBY, 28, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUE_CORE1_WARM_RST, 27, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUE_CORE0_WARM_RST, 26, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUD_CORE1_WARM_RST, 25, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUD_CORE0_WARM_RST, 24, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUC_CORE1_WARM_RST, 23, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUC_CORE0_WARM_RST, 22, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUB_CORE1_WARM_RST, 21, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUB_CORE0_WARM_RST, 20, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUA_CORE1_WARM_RST, 19, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUA_CORE0_WARM_RST, 18, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUE_CORE1_DBG_RST, 17, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUE_CORE0_DBG_RST, 16, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUD_CORE1_DBG_RST, 15, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUD_CORE0_DBG_RST, 14, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUC_CORE1_DBG_RST, 13, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUC_CORE0_DBG_RST, 12, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUB_CORE1_DBG_RST, 11, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUB_CORE0_DBG_RST, 10, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUA_CORE1_DBG_RST, 9, 1)
    FIELD(PWR_RST_IRQ_TRIG, RPUA_CORE0_DBG_RST, 8, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU3_CORE1_DBG_RST, 7, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU3_CORE0_DBG_RST, 6, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU2_CORE1_DBG_RST, 5, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU2_CORE0_DBG_RST, 4, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU1_CORE1_DBG_RST, 3, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU1_CORE0_DBG_RST, 2, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU0_CORE1_DBG_RST, 1, 1)
    FIELD(PWR_RST_IRQ_TRIG, APU0_CORE0_DBG_RST, 0, 1)
#define PWR_RST_IRQ_TRIG_RESET_VAL 0x0

REG32(PMC_IRQ_PWR_MB_IRQ, 0x000506e0)
    FIELD(PMC_IRQ_PWR_MB_IRQ, PWR_CTRL_REQ, 15, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, WAKEUP_REQ, 14, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, RSVD0, 13, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, PWR_DWN_REQ, 12, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, PWR_UP_REQ, 11, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, SW_RST_REQ, 10, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, RSVD1, 9, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, ISO_REQ, 8, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, RSVD2, 7, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ, RSVD3, 6, 1)
#define PMC_IRQ_PWR_MB_IRQ_RESET_VAL 0x0

REG32(PMC_IRQ_PWR_MB_IRQ_MASK, 0x000506e4)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, PWR_CTRL_REQ, 15, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, WAKEUP_REQ, 14, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, RSVD0, 13, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, PWR_DWN_REQ, 12, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, PWR_UP_REQ, 11, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, SW_RST_REQ, 10, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, RSVD1, 9, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, ISO_REQ, 8, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, RSVD2, 7, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_MASK, RSVD3, 6, 1)
#define PMC_IRQ_PWR_MB_IRQ_MASK_RESET_VAL 0xffc0

REG32(PMC_IRQ_PWR_MB_IRQ_EN, 0x000506e8)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, PWR_CTRL_REQ, 15, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, WAKEUP_REQ, 14, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, RSVD0, 13, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, PWR_DWN_REQ, 12, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, PWR_UP_REQ, 11, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, SW_RST_REQ, 10, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, RSVD1, 9, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, ISO_REQ, 8, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, RSVD2, 7, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_EN, RSVD3, 6, 1)
#define PMC_IRQ_PWR_MB_IRQ_EN_RESET_VAL 0x0

REG32(PMC_IRQ_PWR_MB_IRQ_DIS, 0x000506ec)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, PWR_CTRL_REQ, 15, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, WAKEUP_REQ, 14, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, RSVD0, 13, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, PWR_DWN_REQ, 12, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, PWR_UP_REQ, 11, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, SW_RST_REQ, 10, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, RSVD1, 9, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, ISO_REQ, 8, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, RSVD2, 7, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_DIS, RSVD3, 6, 1)
#define PMC_IRQ_PWR_MB_IRQ_DIS_RESET_VAL 0x0

REG32(PMC_IRQ_PWR_MB_IRQ_TRIG, 0x000506f0)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, PWR_CTRL_REQ, 15, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, WAKEUP_REQ, 14, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, RSVD0, 13, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, PWR_DWN_REQ, 12, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, PWR_UP_REQ, 11, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, SW_RST_REQ, 10, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, RSVD1, 9, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, ISO_REQ, 8, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, RSVD2, 7, 1)
    FIELD(PMC_IRQ_PWR_MB_IRQ_TRIG, RSVD3, 6, 1)
#define PMC_IRQ_PWR_MB_IRQ_TRIG_RESET_VAL 0x0

REG32(DBG_PWR_ACK, 0x000506f4)
    FIELD(DBG_PWR_ACK, FPD, 30, 1)
    FIELD(DBG_PWR_ACK, RPU_E_CORE1, 29, 1)
    FIELD(DBG_PWR_ACK, RPU_E_CORE0, 28, 1)
    FIELD(DBG_PWR_ACK, RPU_D_CORE1, 27, 1)
    FIELD(DBG_PWR_ACK, RPU_D_CORE0, 26, 1)
    FIELD(DBG_PWR_ACK, RPU_C_CORE1, 25, 1)
    FIELD(DBG_PWR_ACK, RPU_C_CORE0, 24, 1)
    FIELD(DBG_PWR_ACK, RPU_B_CORE1, 23, 1)
    FIELD(DBG_PWR_ACK, RPU_B_CORE0, 22, 1)
    FIELD(DBG_PWR_ACK, RPU_A_CORE1, 21, 1)
    FIELD(DBG_PWR_ACK, RPU_A_CORE0, 20, 1)
    FIELD(DBG_PWR_ACK, APU3_DSU, 19, 1)
    FIELD(DBG_PWR_ACK, APU2_DSU, 18, 1)
    FIELD(DBG_PWR_ACK, APU1_DSU, 17, 1)
    FIELD(DBG_PWR_ACK, APU0_DSU, 16, 1)
    FIELD(DBG_PWR_ACK, APU3_CORE1, 13, 1)
    FIELD(DBG_PWR_ACK, APU3_CORE0, 12, 1)
    FIELD(DBG_PWR_ACK, APU2_CORE1, 9, 1)
    FIELD(DBG_PWR_ACK, APU2_CORE0, 8, 1)
    FIELD(DBG_PWR_ACK, APU1_CORE1, 5, 1)
    FIELD(DBG_PWR_ACK, APU1_CORE0, 4, 1)
    FIELD(DBG_PWR_ACK, APU0_CORE1, 1, 1)
    FIELD(DBG_PWR_ACK, APU0_CORE0, 0, 1)
#define DBG_PWR_ACK_WRITE_MASK 0x7fff3333
#define DBG_PWR_ACK_RESET_VAL 0x0

REG32(MEM_CLEAR_TRIGGER, 0x00050900)
    FIELD(MEM_CLEAR_TRIGGER, FPX1_PREWRAP, 27, 1)
    FIELD(MEM_CLEAR_TRIGGER, FPX1_MMU, 26, 1)
    FIELD(MEM_CLEAR_TRIGGER, FPX2, 25, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN4, 24, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN3_1, 23, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN3_0, 22, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN2, 21, 1)
    FIELD(MEM_CLEAR_TRIGGER, CMN1, 20, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CLUSTER, 19, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CLUSTER, 18, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CLUSTER, 17, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CLUSTER, 16, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CORE1, 13, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU3_CORE0, 12, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CORE1, 9, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU2_CORE0, 8, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CORE1, 5, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU1_CORE0, 4, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CORE1, 1, 1)
    FIELD(MEM_CLEAR_TRIGGER, APU0_CORE0, 0, 1)
#define MEM_CLEAR_TRIGGER_WRITE_MASK 0xf3f3333
#define MEM_CLEAR_TRIGGER_RESET_VAL 0x0

REG32(MEM_CLEAR_DONE, 0x00050904)
    FIELD(MEM_CLEAR_DONE, FPX1_PREWRAP, 27, 1)
    FIELD(MEM_CLEAR_DONE, FPX1_MMU, 26, 1)
    FIELD(MEM_CLEAR_DONE, FPX2, 25, 1)
    FIELD(MEM_CLEAR_DONE, CMN4, 24, 1)
    FIELD(MEM_CLEAR_DONE, CMN3_1, 23, 1)
    FIELD(MEM_CLEAR_DONE, CMN3_0, 22, 1)
    FIELD(MEM_CLEAR_DONE, CMN2, 21, 1)
    FIELD(MEM_CLEAR_DONE, CMN1, 20, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CLUSTER, 19, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CLUSTER, 18, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CLUSTER, 17, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CLUSTER, 16, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CORE1, 13, 1)
    FIELD(MEM_CLEAR_DONE, APU3_CORE0, 12, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CORE1, 9, 1)
    FIELD(MEM_CLEAR_DONE, APU2_CORE0, 8, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CORE1, 5, 1)
    FIELD(MEM_CLEAR_DONE, APU1_CORE0, 4, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CORE1, 1, 1)
    FIELD(MEM_CLEAR_DONE, APU0_CORE0, 0, 1)
#define MEM_CLEAR_DONE_RESET_VAL 0x0

REG32(MEM_CLEAR_PASS, 0x00050908)
    FIELD(MEM_CLEAR_PASS, FPX1_PREWRAP, 27, 1)
    FIELD(MEM_CLEAR_PASS, FPX1_MMU, 26, 1)
    FIELD(MEM_CLEAR_PASS, FPX2, 25, 1)
    FIELD(MEM_CLEAR_PASS, CMN4, 24, 1)
    FIELD(MEM_CLEAR_PASS, CMN3_1, 23, 1)
    FIELD(MEM_CLEAR_PASS, CMN3_0, 22, 1)
    FIELD(MEM_CLEAR_PASS, CMN2, 21, 1)
    FIELD(MEM_CLEAR_PASS, CMN1, 20, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CLUSTER, 19, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CLUSTER, 18, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CLUSTER, 17, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CLUSTER, 16, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CORE1, 13, 1)
    FIELD(MEM_CLEAR_PASS, APU3_CORE0, 12, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CORE1, 9, 1)
    FIELD(MEM_CLEAR_PASS, APU2_CORE0, 8, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CORE1, 5, 1)
    FIELD(MEM_CLEAR_PASS, APU1_CORE0, 4, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CORE1, 1, 1)
    FIELD(MEM_CLEAR_PASS, APU0_CORE0, 0, 1)
#define MEM_CLEAR_PASS_RESET_VAL 0x0

REG32(SCAN_CLEAR_TRIGGER, 0x00050910)
    FIELD(SCAN_CLEAR_TRIGGER, FPX1_PREWRAP, 27, 1)
    FIELD(SCAN_CLEAR_TRIGGER, FPX1_MMU, 26, 1)
    FIELD(SCAN_CLEAR_TRIGGER, FPX2, 25, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN4, 24, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN3_1, 23, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN3_0, 22, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN2, 21, 1)
    FIELD(SCAN_CLEAR_TRIGGER, CMN1, 20, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CLUSTER, 19, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CLUSTER, 18, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CLUSTER, 17, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CLUSTER, 16, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CORE1, 13, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU3_CORE0, 12, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CORE1, 9, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU2_CORE0, 8, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CORE1, 5, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU1_CORE0, 4, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CORE1, 1, 1)
    FIELD(SCAN_CLEAR_TRIGGER, APU0_CORE0, 0, 1)
#define SCAN_CLEAR_TRIGGER_RESET_VAL 0x0
#define SCAN_CLEAR_TRIGGER_WRITE_MASK 0xfff3333

REG32(SCAN_CLEAR_DONE, 0x00050914)
    FIELD(SCAN_CLEAR_DONE, FPX1_PREWRAP, 27, 1)
    FIELD(SCAN_CLEAR_DONE, FPX1_MMU, 26, 1)
    FIELD(SCAN_CLEAR_DONE, FPX2, 25, 1)
    FIELD(SCAN_CLEAR_DONE, CMN4, 24, 1)
    FIELD(SCAN_CLEAR_DONE, CMN3_1, 23, 1)
    FIELD(SCAN_CLEAR_DONE, CMN3_0, 22, 1)
    FIELD(SCAN_CLEAR_DONE, CMN2, 21, 1)
    FIELD(SCAN_CLEAR_DONE, CMN1, 20, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CLUSTER, 19, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CLUSTER, 18, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CLUSTER, 17, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CLUSTER, 16, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CORE1, 13, 1)
    FIELD(SCAN_CLEAR_DONE, APU3_CORE0, 12, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CORE1, 9, 1)
    FIELD(SCAN_CLEAR_DONE, APU2_CORE0, 8, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CORE1, 5, 1)
    FIELD(SCAN_CLEAR_DONE, APU1_CORE0, 4, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CORE1, 1, 1)
    FIELD(SCAN_CLEAR_DONE, APU0_CORE0, 0, 1)
#define SCAN_CLEAR_DONE_RESET_VAL 0x0

REG32(SCAN_CLEAR_PASS, 0x00050918)
    FIELD(SCAN_CLEAR_PASS, FPX1_PREWRAP, 27, 1)
    FIELD(SCAN_CLEAR_PASS, FPX1_MMU, 26, 1)
    FIELD(SCAN_CLEAR_PASS, FPX2, 25, 1)
    FIELD(SCAN_CLEAR_PASS, CMN4, 24, 1)
    FIELD(SCAN_CLEAR_PASS, CMN3_1, 23, 1)
    FIELD(SCAN_CLEAR_PASS, CMN3_0, 22, 1)
    FIELD(SCAN_CLEAR_PASS, CMN2, 21, 1)
    FIELD(SCAN_CLEAR_PASS, CMN1, 20, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CLUSTER, 19, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CLUSTER, 18, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CLUSTER, 17, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CLUSTER, 16, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CORE1, 13, 1)
    FIELD(SCAN_CLEAR_PASS, APU3_CORE0, 12, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CORE1, 9, 1)
    FIELD(SCAN_CLEAR_PASS, APU2_CORE0, 8, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CORE1, 5, 1)
    FIELD(SCAN_CLEAR_PASS, APU1_CORE0, 4, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CORE1, 1, 1)
    FIELD(SCAN_CLEAR_PASS, APU0_CORE0, 0, 1)
#define SCAN_CLEAR_PASS_RESET_VAL 0x0

REG32(SCAN_CLEAR_LOCK, 0x00050920)
    FIELD(SCAN_CLEAR_LOCK, LOCK, 0, 1)
#define SCAN_CLEAR_LOCK_WRITE_MASK 0x00000001
#define SCAN_CLEAR_LOCK_RESET_VAL 0x0

REG32(REQ_SWRST_STATUS, 0x00060000)
    FIELD(REQ_SWRST_STATUS, RSVD1, 31, 1)
    FIELD(REQ_SWRST_STATUS, FP, 30, 1)
    FIELD(REQ_SWRST_STATUS, LP, 29, 1)
    FIELD(REQ_SWRST_STATUS, RPU, 28, 1)
    FIELD(REQ_SWRST_STATUS, RPU_E_CLUSTER, 27, 1)
    FIELD(REQ_SWRST_STATUS, RPU_D_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_STATUS, RPU_C_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_STATUS, RPU_B_CLUSTER, 24, 1)
    FIELD(REQ_SWRST_STATUS, RPU_A_CLUSTER, 23, 1)
    FIELD(REQ_SWRST_STATUS, RPU_E_CORE1, 22, 1)
    FIELD(REQ_SWRST_STATUS, RPU_E_CORE0, 21, 1)
    FIELD(REQ_SWRST_STATUS, RPU_D_CORE1, 20, 1)
    FIELD(REQ_SWRST_STATUS, RPU_D_CORE0, 19, 1)
    FIELD(REQ_SWRST_STATUS, RPU_C_CORE1, 18, 1)
    FIELD(REQ_SWRST_STATUS, RPU_C_CORE0, 17, 1)
    FIELD(REQ_SWRST_STATUS, RPU_B_CORE1, 16, 1)
    FIELD(REQ_SWRST_STATUS, RPU_B_CORE0, 15, 1)
    FIELD(REQ_SWRST_STATUS, RPU_A_CORE1, 14, 1)
    FIELD(REQ_SWRST_STATUS, RPU_A_CORE0, 13, 1)
    FIELD(REQ_SWRST_STATUS, APU, 12, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CLUSTER, 11, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CLUSTER, 10, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CLUSTER, 9, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CLUSTER, 8, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CORE1, 7, 1)
    FIELD(REQ_SWRST_STATUS, APU3_CORE0, 6, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CORE1, 5, 1)
    FIELD(REQ_SWRST_STATUS, APU2_CORE0, 4, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CORE1, 3, 1)
    FIELD(REQ_SWRST_STATUS, APU1_CORE0, 2, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_STATUS, APU0_CORE0, 0, 1)
#define REQ_SWRST_STATUS_RESET_VAL 0x0

REG32(REQ_SWRST_INT_MASK, 0x00060004)
    FIELD(REQ_SWRST_INT_MASK, RSVD1, 31, 1)
    FIELD(REQ_SWRST_INT_MASK, FP, 30, 1)
    FIELD(REQ_SWRST_INT_MASK, LP, 29, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU, 28, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_E_CLUSTER, 27, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_D_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_C_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_B_CLUSTER, 24, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_A_CLUSTER, 23, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_E_CORE1, 22, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_E_CORE0, 21, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_D_CORE1, 20, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_D_CORE0, 19, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_C_CORE1, 18, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_C_CORE0, 17, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_B_CORE1, 16, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_B_CORE0, 15, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_A_CORE1, 14, 1)
    FIELD(REQ_SWRST_INT_MASK, RPU_A_CORE0, 13, 1)
    FIELD(REQ_SWRST_INT_MASK, APU, 12, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CLUSTER, 11, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CLUSTER, 10, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CLUSTER, 9, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CLUSTER, 8, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CORE1, 7, 1)
    FIELD(REQ_SWRST_INT_MASK, APU3_CORE0, 6, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CORE1, 5, 1)
    FIELD(REQ_SWRST_INT_MASK, APU2_CORE0, 4, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CORE1, 3, 1)
    FIELD(REQ_SWRST_INT_MASK, APU1_CORE0, 2, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_INT_MASK, APU0_CORE0, 0, 1)
#define REQ_SWRST_INT_MASK_RESET_VAL 0xffffffff

REG32(REQ_SWRST_INT_EN, 0x00060008)
    FIELD(REQ_SWRST_INT_EN, RSVD1, 31, 1)
    FIELD(REQ_SWRST_INT_EN, FP, 30, 1)
    FIELD(REQ_SWRST_INT_EN, LP, 29, 1)
    FIELD(REQ_SWRST_INT_EN, RPU, 28, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_E_CLUSTER, 27, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_D_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_C_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_B_CLUSTER, 24, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_A_CLUSTER, 23, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_E_CORE1, 22, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_E_CORE0, 21, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_D_CORE1, 20, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_D_CORE0, 19, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_C_CORE1, 18, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_C_CORE0, 17, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_B_CORE1, 16, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_B_CORE0, 15, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_A_CORE1, 14, 1)
    FIELD(REQ_SWRST_INT_EN, RPU_A_CORE0, 13, 1)
    FIELD(REQ_SWRST_INT_EN, APU, 12, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CLUSTER, 11, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CLUSTER, 10, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CLUSTER, 9, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CLUSTER, 8, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CORE1, 7, 1)
    FIELD(REQ_SWRST_INT_EN, APU3_CORE0, 6, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CORE1, 5, 1)
    FIELD(REQ_SWRST_INT_EN, APU2_CORE0, 4, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CORE1, 3, 1)
    FIELD(REQ_SWRST_INT_EN, APU1_CORE0, 2, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_INT_EN, APU0_CORE0, 0, 1)
#define REQ_SWRST_INT_EN_RESET_VAL 0x0

REG32(REQ_SWRST_INT_DIS, 0x0006000c)
    FIELD(REQ_SWRST_INT_DIS, RSVD1, 31, 1)
    FIELD(REQ_SWRST_INT_DIS, FP, 30, 1)
    FIELD(REQ_SWRST_INT_DIS, LP, 29, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU, 28, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_E_CLUSTER, 27, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_D_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_C_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_B_CLUSTER, 24, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_A_CLUSTER, 23, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_E_CORE1, 22, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_E_CORE0, 21, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_D_CORE1, 20, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_D_CORE0, 19, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_C_CORE1, 18, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_C_CORE0, 17, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_B_CORE1, 16, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_B_CORE0, 15, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_A_CORE1, 14, 1)
    FIELD(REQ_SWRST_INT_DIS, RPU_A_CORE0, 13, 1)
    FIELD(REQ_SWRST_INT_DIS, APU, 12, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CLUSTER, 11, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CLUSTER, 10, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CLUSTER, 9, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CLUSTER, 8, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CORE1, 7, 1)
    FIELD(REQ_SWRST_INT_DIS, APU3_CORE0, 6, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CORE1, 5, 1)
    FIELD(REQ_SWRST_INT_DIS, APU2_CORE0, 4, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CORE1, 3, 1)
    FIELD(REQ_SWRST_INT_DIS, APU1_CORE0, 2, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_INT_DIS, APU0_CORE0, 0, 1)
#define REQ_SWRST_INT_DIS_RESET_VAL 0x0

REG32(REQ_SWRST_TRIG, 0x00060010)
    FIELD(REQ_SWRST_TRIG, RSVD1, 31, 1)
    FIELD(REQ_SWRST_TRIG, FP, 30, 1)
    FIELD(REQ_SWRST_TRIG, LP, 29, 1)
    FIELD(REQ_SWRST_TRIG, RPU, 28, 1)
    FIELD(REQ_SWRST_TRIG, RPU_E_CLUSTER, 27, 1)
    FIELD(REQ_SWRST_TRIG, RPU_D_CLUSTER, 26, 1)
    FIELD(REQ_SWRST_TRIG, RPU_C_CLUSTER, 25, 1)
    FIELD(REQ_SWRST_TRIG, RPU_B_CLUSTER, 24, 1)
    FIELD(REQ_SWRST_TRIG, RPU_A_CLUSTER, 23, 1)
    FIELD(REQ_SWRST_TRIG, RPU_E_CORE1, 22, 1)
    FIELD(REQ_SWRST_TRIG, RPU_E_CORE0, 21, 1)
    FIELD(REQ_SWRST_TRIG, RPU_D_CORE1, 20, 1)
    FIELD(REQ_SWRST_TRIG, RPU_D_CORE0, 19, 1)
    FIELD(REQ_SWRST_TRIG, RPU_C_CORE1, 18, 1)
    FIELD(REQ_SWRST_TRIG, RPU_C_CORE0, 17, 1)
    FIELD(REQ_SWRST_TRIG, RPU_B_CORE1, 16, 1)
    FIELD(REQ_SWRST_TRIG, RPU_B_CORE0, 15, 1)
    FIELD(REQ_SWRST_TRIG, RPU_A_CORE1, 14, 1)
    FIELD(REQ_SWRST_TRIG, RPU_A_CORE0, 13, 1)
    FIELD(REQ_SWRST_TRIG, APU, 12, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CLUSTER, 11, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CLUSTER, 10, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CLUSTER, 9, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CLUSTER, 8, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CORE1, 7, 1)
    FIELD(REQ_SWRST_TRIG, APU3_CORE0, 6, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CORE1, 5, 1)
    FIELD(REQ_SWRST_TRIG, APU2_CORE0, 4, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CORE1, 3, 1)
    FIELD(REQ_SWRST_TRIG, APU1_CORE0, 2, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CORE1, 1, 1)
    FIELD(REQ_SWRST_TRIG, APU0_CORE0, 0, 1)
#define REQ_SWRST_TRIG_RESET_VAL 0x0

REG32(REQ_PWRDWN0_STATUS, 0x00060020)
    FIELD(REQ_PWRDWN0_STATUS, RSVD8, 24, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD7, 23, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE3, 22, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE2, 21, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE1, 20, 1)
    FIELD(REQ_PWRDWN0_STATUS, LLC_MODE0, 19, 1)
    FIELD(REQ_PWRDWN0_STATUS, FP, 18, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_3Q, 17, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_1H, 16, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_1Q, 15, 1)
    FIELD(REQ_PWRDWN0_STATUS, L3_ON, 14, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD5, 11, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD4, 10, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD3, 7, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD2, 6, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD1, 3, 1)
    FIELD(REQ_PWRDWN0_STATUS, RSVD0, 2, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_STATUS, APU0_CORE0, 0, 1)
#define REQ_PWRDWN0_STATUS_RESET_VAL 0x0

REG32(REQ_PWRDWN0_INT_MASK, 0x00060024)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD8, 24, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD7, 23, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE3, 22, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE2, 21, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE1, 20, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, LLC_MODE0, 19, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, FP, 18, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_3Q, 17, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_1H, 16, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_1Q, 15, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, L3_ON, 14, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD5, 11, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD4, 10, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD3, 7, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD2, 6, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD1, 3, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, RSVD0, 2, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_INT_MASK, APU0_CORE0, 0, 1)
#define REQ_PWRDWN0_INT_MASK_RESET_VAL 0x1ffffff

REG32(REQ_PWRDWN0_INT_EN, 0x00060028)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD8, 24, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD7, 23, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE3, 22, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE2, 21, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE1, 20, 1)
    FIELD(REQ_PWRDWN0_INT_EN, LLC_MODE0, 19, 1)
    FIELD(REQ_PWRDWN0_INT_EN, FP, 18, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_3Q, 17, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_1H, 16, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_1Q, 15, 1)
    FIELD(REQ_PWRDWN0_INT_EN, L3_ON, 14, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD5, 11, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD4, 10, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD3, 7, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD2, 6, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD1, 3, 1)
    FIELD(REQ_PWRDWN0_INT_EN, RSVD0, 2, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_INT_EN, APU0_CORE0, 0, 1)
#define REQ_PWRDWN0_INT_EN_RESET_VAL 0x0

REG32(REQ_PWRDWN0_INT_DIS, 0x0006002c)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD8, 24, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD7, 23, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE3, 22, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE2, 21, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE1, 20, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, LLC_MODE0, 19, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, FP, 18, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_3Q, 17, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_1H, 16, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_1Q, 15, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, L3_ON, 14, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD5, 11, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD4, 10, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD3, 7, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD2, 6, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD1, 3, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, RSVD0, 2, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_INT_DIS, APU0_CORE0, 0, 1)
#define REQ_PWRDWN0_INT_DIS_RESET_VAL 0x0

REG32(REQ_PWRDWN0_TRIG, 0x00060030)
    FIELD(REQ_PWRDWN0_TRIG, RSVD8, 24, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD7, 23, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE3, 22, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE2, 21, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE1, 20, 1)
    FIELD(REQ_PWRDWN0_TRIG, LLC_MODE0, 19, 1)
    FIELD(REQ_PWRDWN0_TRIG, FP, 18, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_3Q, 17, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_1H, 16, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_1Q, 15, 1)
    FIELD(REQ_PWRDWN0_TRIG, L3_ON, 14, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD5, 11, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD4, 10, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD3, 7, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD2, 6, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD1, 3, 1)
    FIELD(REQ_PWRDWN0_TRIG, RSVD0, 2, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRDWN0_TRIG, APU0_CORE0, 0, 1)
#define REQ_PWRDWN0_TRIG_RESET_VAL 0x0

REG32(REQ_PWRDWN1_STATUS, 0x00060040)
    FIELD(REQ_PWRDWN1_STATUS, GEM1, 31, 1)
    FIELD(REQ_PWRDWN1_STATUS, GEM0, 30, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1E_RET, 29, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0E_RET, 28, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1D_RET, 27, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0D_RET, 26, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1C_RET, 25, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0C_RET, 24, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1B_RET, 23, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0B_RET, 22, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1A_RET, 21, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0A_RET, 20, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1E, 19, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0E, 18, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1D, 17, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0D, 16, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1C, 15, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0C, 14, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1B, 13, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0B, 12, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM1A, 11, 1)
    FIELD(REQ_PWRDWN1_STATUS, TCM0A, 10, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_STATUS, RPU_A_CORE0, 0, 1)
#define REQ_PWRDWN1_STATUS_RESET_VAL 0x0

REG32(REQ_PWRDWN1_INT_MASK, 0x00060044)
    FIELD(REQ_PWRDWN1_INT_MASK, GEM1, 31, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, GEM0, 30, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1E_RET, 29, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0E_RET, 28, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1D_RET, 27, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0D_RET, 26, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1C_RET, 25, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0C_RET, 24, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1B_RET, 23, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0B_RET, 22, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1A_RET, 21, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0A_RET, 20, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1E, 19, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0E, 18, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1D, 17, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0D, 16, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1C, 15, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0C, 14, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1B, 13, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0B, 12, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM1A, 11, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, TCM0A, 10, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_INT_MASK, RPU_A_CORE0, 0, 1)
#define REQ_PWRDWN1_INT_MASK_RESET_VAL 0xffffffff

REG32(REQ_PWRDWN1_INT_EN, 0x00060048)
    FIELD(REQ_PWRDWN1_INT_EN, GEM1, 31, 1)
    FIELD(REQ_PWRDWN1_INT_EN, GEM0, 30, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1E_RET, 29, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0E_RET, 28, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1D_RET, 27, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0D_RET, 26, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1C_RET, 25, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0C_RET, 24, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1B_RET, 23, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0B_RET, 22, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1A_RET, 21, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0A_RET, 20, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1E, 19, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0E, 18, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1D, 17, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0D, 16, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1C, 15, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0C, 14, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1B, 13, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0B, 12, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM1A, 11, 1)
    FIELD(REQ_PWRDWN1_INT_EN, TCM0A, 10, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_INT_EN, RPU_A_CORE0, 0, 1)
#define REQ_PWRDWN1_INT_EN_RESET_VAL 0x0

REG32(REQ_PWRDWN1_INT_DIS, 0x0006004c)
    FIELD(REQ_PWRDWN1_INT_DIS, GEM1, 31, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, GEM0, 30, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1E_RET, 29, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0E_RET, 28, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1D_RET, 27, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0D_RET, 26, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1C_RET, 25, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0C_RET, 24, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1B_RET, 23, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0B_RET, 22, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1A_RET, 21, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0A_RET, 20, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1E, 19, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0E, 18, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1D, 17, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0D, 16, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1C, 15, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0C, 14, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1B, 13, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0B, 12, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM1A, 11, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, TCM0A, 10, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_INT_DIS, RPU_A_CORE0, 0, 1)
#define REQ_PWRDWN1_INT_DIS_RESET_VAL 0x0

REG32(REQ_PWRDWN1_TRIG, 0x00060050)
    FIELD(REQ_PWRDWN1_TRIG, GEM1, 31, 1)
    FIELD(REQ_PWRDWN1_TRIG, GEM0, 30, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1E_RET, 29, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0E_RET, 28, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1D_RET, 27, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0D_RET, 26, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1C_RET, 25, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0C_RET, 24, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1B_RET, 23, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0B_RET, 22, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1A_RET, 21, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0A_RET, 20, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1E, 19, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0E, 18, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1D, 17, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0D, 16, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1C, 15, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0C, 14, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1B, 13, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0B, 12, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM1A, 11, 1)
    FIELD(REQ_PWRDWN1_TRIG, TCM0A, 10, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRDWN1_TRIG, RPU_A_CORE0, 0, 1)
#define REQ_PWRDWN1_TRIG_RESET_VAL 0x0

REG32(REQ_PWRDWN2_STATUS, 0x00060060)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND15_RET, 31, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND14_RET, 30, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND13_RET, 29, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND12_RET, 28, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND11_RET, 27, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND10_RET, 26, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND9_RET, 25, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND8_RET, 24, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND7_RET, 23, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND6_RET, 22, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND5_RET, 21, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND4_RET, 20, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND3_RET, 19, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND2_RET, 18, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND1_RET, 17, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND0_RET, 16, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRDWN2_STATUS, OCM_ISLAND0, 0, 1)
#define REQ_PWRDWN2_STATUS_RESET_VAL 0x0

REG32(REQ_PWRDWN2_INT_MASK, 0x00060064)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND15_RET, 31, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND14_RET, 30, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND13_RET, 29, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND12_RET, 28, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND11_RET, 27, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND10_RET, 26, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND9_RET, 25, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND8_RET, 24, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND7_RET, 23, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND6_RET, 22, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND5_RET, 21, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND4_RET, 20, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND3_RET, 19, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND2_RET, 18, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND1_RET, 17, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND0_RET, 16, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRDWN2_INT_MASK, OCM_ISLAND0, 0, 1)
#define REQ_PWRDWN2_INT_MASK_RESET_VAL 0xffffffff

REG32(REQ_PWRDWN2_INT_EN, 0x00060068)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND15_RET, 31, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND14_RET, 30, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND13_RET, 29, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND12_RET, 28, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND11_RET, 27, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND10_RET, 26, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND9_RET, 25, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND8_RET, 24, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND7_RET, 23, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND6_RET, 22, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND5_RET, 21, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND4_RET, 20, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND3_RET, 19, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND2_RET, 18, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND1_RET, 17, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND0_RET, 16, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRDWN2_INT_EN, OCM_ISLAND0, 0, 1)
#define REQ_PWRDWN2_INT_EN_RESET_VAL 0x0

REG32(REQ_PWRDWN2_INT_DIS, 0x0006006c)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND15_RET, 31, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND14_RET, 30, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND13_RET, 29, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND12_RET, 28, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND11_RET, 27, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND10_RET, 26, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND9_RET, 25, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND8_RET, 24, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND7_RET, 23, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND6_RET, 22, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND5_RET, 21, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND4_RET, 20, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND3_RET, 19, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND2_RET, 18, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND1_RET, 17, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND0_RET, 16, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRDWN2_INT_DIS, OCM_ISLAND0, 0, 1)
#define REQ_PWRDWN2_INT_DIS_RESET_VAL 0x0

REG32(REQ_PWRDWN2_TRIG, 0x00060070)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND15_RET, 31, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND14_RET, 30, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND13_RET, 29, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND12_RET, 28, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND11_RET, 27, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND10_RET, 26, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND9_RET, 25, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND8_RET, 24, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND7_RET, 23, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND6_RET, 22, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND5_RET, 21, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND4_RET, 20, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND3_RET, 19, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND2_RET, 18, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND1_RET, 17, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND0_RET, 16, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRDWN2_TRIG, OCM_ISLAND0, 0, 1)
#define REQ_PWRDWN2_TRIG_RESET_VAL 0x0

REG32(REQ_PWRUP0_STATUS, 0x00060080)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_STATUS, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_STATUS, FP, 20, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_STATUS, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD8, 15, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD7, 14, 1)
    FIELD(REQ_PWRUP0_STATUS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_STATUS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD6, 11, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD5, 10, 1)
    FIELD(REQ_PWRUP0_STATUS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_STATUS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_STATUS, RSDV4, 7, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD3, 6, 1)
    FIELD(REQ_PWRUP0_STATUS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_STATUS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD2, 3, 1)
    FIELD(REQ_PWRUP0_STATUS, RSVD1, 2, 1)
    FIELD(REQ_PWRUP0_STATUS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_STATUS, APU0_CORE0, 0, 1)
#define REQ_PWRUP0_STATUS_RESET_VAL 0x0

REG32(REQ_PWRUP0_INT_MASK, 0x00060084)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_INT_MASK, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_INT_MASK, FP, 20, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_INT_MASK, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD8, 15, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD7, 14, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD6, 11, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD5, 10, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSDV4, 7, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD3, 6, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD2, 3, 1)
    FIELD(REQ_PWRUP0_INT_MASK, RSVD1, 2, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_INT_MASK, APU0_CORE0, 0, 1)
#define REQ_PWRUP0_INT_MASK_RESET_VAL 0x1ffffff

REG32(REQ_PWRUP0_INT_EN, 0x00060088)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_INT_EN, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_INT_EN, FP, 20, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_INT_EN, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD8, 15, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD7, 14, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD6, 11, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD5, 10, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSDV4, 7, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD3, 6, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD2, 3, 1)
    FIELD(REQ_PWRUP0_INT_EN, RSVD1, 2, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_INT_EN, APU0_CORE0, 0, 1)
#define REQ_PWRUP0_INT_EN_RESET_VAL 0x0

REG32(REQ_PWRUP0_INT_DIS, 0x0006008c)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_INT_DIS, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_INT_DIS, FP, 20, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_INT_DIS, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD8, 15, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD7, 14, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD6, 11, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD5, 10, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSDV4, 7, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD3, 6, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD2, 3, 1)
    FIELD(REQ_PWRUP0_INT_DIS, RSVD1, 2, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_INT_DIS, APU0_CORE0, 0, 1)
#define REQ_PWRUP0_INT_DIS_RESET_VAL 0x0

REG32(REQ_PWRUP0_TRIG, 0x00060090)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE3, 24, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE2, 23, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE1, 22, 1)
    FIELD(REQ_PWRUP0_TRIG, LLC_MODE0, 21, 1)
    FIELD(REQ_PWRUP0_TRIG, FP, 20, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_3Q, 19, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_1H, 18, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_1Q, 17, 1)
    FIELD(REQ_PWRUP0_TRIG, L3_ON, 16, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD8, 15, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD7, 14, 1)
    FIELD(REQ_PWRUP0_TRIG, APU3_CORE1, 13, 1)
    FIELD(REQ_PWRUP0_TRIG, APU3_CORE0, 12, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD6, 11, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD5, 10, 1)
    FIELD(REQ_PWRUP0_TRIG, APU2_CORE1, 9, 1)
    FIELD(REQ_PWRUP0_TRIG, APU2_CORE0, 8, 1)
    FIELD(REQ_PWRUP0_TRIG, RSDV4, 7, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD3, 6, 1)
    FIELD(REQ_PWRUP0_TRIG, APU1_CORE1, 5, 1)
    FIELD(REQ_PWRUP0_TRIG, APU1_CORE0, 4, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD2, 3, 1)
    FIELD(REQ_PWRUP0_TRIG, RSVD1, 2, 1)
    FIELD(REQ_PWRUP0_TRIG, APU0_CORE1, 1, 1)
    FIELD(REQ_PWRUP0_TRIG, APU0_CORE0, 0, 1)
#define REQ_PWRUP0_TRIG_RESET_VAL 0x0

REG32(REQ_PWRUP1_STATUS, 0x000600a0)
    FIELD(REQ_PWRUP1_STATUS, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_STATUS, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_STATUS, RSVD5, 27, 1)
    FIELD(REQ_PWRUP1_STATUS, RSVD4, 26, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1E, 25, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0E, 24, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1D, 23, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0D, 22, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1C, 21, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0C, 20, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1B, 19, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0B, 18, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM1A, 17, 1)
    FIELD(REQ_PWRUP1_STATUS, TCM0A, 16, 1)
    FIELD(REQ_PWRUP1_STATUS, RSVD3, 13, 1)
    FIELD(REQ_PWRUP1_STATUS, RSVD2, 12, 1)
    FIELD(REQ_PWRUP1_STATUS, RSVD1, 11, 1)
    FIELD(REQ_PWRUP1_STATUS, RSVD0, 10, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_STATUS, RPU_A_CORE0, 0, 1)
#define REQ_PWRUP1_STATUS_RESET_VAL 0x0

REG32(REQ_PWRUP1_INT_MASK, 0x000600a4)
    FIELD(REQ_PWRUP1_INT_MASK, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_INT_MASK, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RSVD5, 27, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RSVD4, 26, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1E, 25, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0E, 24, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1D, 23, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0D, 22, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1C, 21, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0C, 20, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1B, 19, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0B, 18, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM1A, 17, 1)
    FIELD(REQ_PWRUP1_INT_MASK, TCM0A, 16, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RSVD3, 13, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RSVD2, 12, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RSVD1, 11, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RSVD0, 10, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_INT_MASK, RPU_A_CORE0, 0, 1)
#define REQ_PWRUP1_INT_MASK_RESET_VAL 0x3fff3fff

REG32(REQ_PWRUP1_INT_EN, 0x000600a8)
    FIELD(REQ_PWRUP1_INT_EN, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_INT_EN, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_INT_EN, RSVD5, 27, 1)
    FIELD(REQ_PWRUP1_INT_EN, RSVD4, 26, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1E, 25, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0E, 24, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1D, 23, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0D, 22, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1C, 21, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0C, 20, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1B, 19, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0B, 18, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM1A, 17, 1)
    FIELD(REQ_PWRUP1_INT_EN, TCM0A, 16, 1)
    FIELD(REQ_PWRUP1_INT_EN, RSVD3, 13, 1)
    FIELD(REQ_PWRUP1_INT_EN, RSVD2, 12, 1)
    FIELD(REQ_PWRUP1_INT_EN, RSVD1, 11, 1)
    FIELD(REQ_PWRUP1_INT_EN, RSVD0, 10, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_INT_EN, RPU_A_CORE0, 0, 1)
#define REQ_PWRUP1_INT_EN_RESET_VAL 0x0

REG32(REQ_PWRUP1_INT_DIS, 0x000600ac)
    FIELD(REQ_PWRUP1_INT_DIS, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_INT_DIS, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RSVD5, 27, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RSVD4, 26, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1E, 25, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0E, 24, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1D, 23, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0D, 22, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1C, 21, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0C, 20, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1B, 19, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0B, 18, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM1A, 17, 1)
    FIELD(REQ_PWRUP1_INT_DIS, TCM0A, 16, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RSVD3, 13, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RSVD2, 12, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RSVD1, 11, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RSVD0, 10, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_INT_DIS, RPU_A_CORE0, 0, 1)
#define REQ_PWRUP1_INT_DIS_RESET_VAL 0x0

REG32(REQ_PWRUP1_TRIG, 0x000600b0)
    FIELD(REQ_PWRUP1_TRIG, GEM1, 29, 1)
    FIELD(REQ_PWRUP1_TRIG, GEM0, 28, 1)
    FIELD(REQ_PWRUP1_TRIG, RSVD5, 27, 1)
    FIELD(REQ_PWRUP1_TRIG, RSVD4, 26, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1E, 25, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0E, 24, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1D, 23, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0D, 22, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1C, 21, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0C, 20, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1B, 19, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0B, 18, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM1A, 17, 1)
    FIELD(REQ_PWRUP1_TRIG, TCM0A, 16, 1)
    FIELD(REQ_PWRUP1_TRIG, RSVD3, 13, 1)
    FIELD(REQ_PWRUP1_TRIG, RSVD2, 12, 1)
    FIELD(REQ_PWRUP1_TRIG, RSVD1, 11, 1)
    FIELD(REQ_PWRUP1_TRIG, RSVD0, 10, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_E_CORE1, 9, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_E_CORE0, 8, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_D_CORE1, 7, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_D_CORE0, 6, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_C_CORE1, 5, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_C_CORE0, 4, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_B_CORE1, 3, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_B_CORE0, 2, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_A_CORE1, 1, 1)
    FIELD(REQ_PWRUP1_TRIG, RPU_A_CORE0, 0, 1)
#define REQ_PWRUP1_TRIG_RESET_VAL 0x0

REG32(REQ_PWRUP2_STATUS, 0x000600c0)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRUP2_STATUS, OCM_ISLAND0, 0, 1)
#define REQ_PWRUP2_STATUS_RESET_VAL 0x0

REG32(REQ_PWRUP2_INT_MASK, 0x000600c4)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRUP2_INT_MASK, OCM_ISLAND0, 0, 1)
#define REQ_PWRUP2_INT_MASK_RESET_VAL 0xffff

REG32(REQ_PWRUP2_INT_EN, 0x000600c8)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRUP2_INT_EN, OCM_ISLAND0, 0, 1)
#define REQ_PWRUP2_INT_EN_RESET_VAL 0x0

REG32(REQ_PWRUP2_INT_DIS, 0x000600cc)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRUP2_INT_DIS, OCM_ISLAND0, 0, 1)
#define REQ_PWRUP2_INT_DIS_RESET_VAL 0x0

REG32(REQ_PWRUP2_TRIG, 0x000600d0)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND15, 15, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND14, 14, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND13, 13, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND12, 12, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND11, 11, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND10, 10, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND9, 9, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND8, 8, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND7, 7, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND6, 6, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND5, 5, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND4, 4, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND3, 3, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND2, 2, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND1, 1, 1)
    FIELD(REQ_PWRUP2_TRIG, OCM_ISLAND0, 0, 1)
#define REQ_PWRUP2_TRIG_RESET_VAL 0x0

REG32(REQ_ISO_STATUS, 0x000600e0)
    FIELD(REQ_ISO_STATUS, FP, 0, 1)
#define REQ_ISO_STATUS_RESET_VAL 0x0

REG32(REQ_ISO_INT_MASK, 0x000600e4)
    FIELD(REQ_ISO_INT_MASK, FP, 0, 1)
#define REQ_ISO_INT_MASK_RESET_VAL 0x1

REG32(REQ_ISO_INT_EN, 0x000600e8)
    FIELD(REQ_ISO_INT_EN, FP, 0, 1)
#define REQ_ISO_INT_EN_RESET_VAL 0x0

REG32(REQ_ISO_INT_DIS, 0x000600ec)
    FIELD(REQ_ISO_INT_DIS, FP, 0, 1)
#define REQ_ISO_INT_DIS_RESET_VAL 0x0

REG32(REQ_ISO_TRIG, 0x000600f0)
#define EAM_REG_ADDR(x) (x - A_EAM_ERR0_STATUS)
#define R_EAM(x) (EAM_REG_ADDR(A_ ## x) / 4)

static void update_ocm_pwr(XlnxPsxcLpxSlcr *s)
{
    size_t i;

    for (i = 0; i < ARRAY_SIZE(s->ocm_pwr); i++) {
        size_t bank = i / 4;
        size_t island = i % 4;
        bool sta = extract32(s->ocm_pwr_ctrl, bank * 8 + island, 1);

        qemu_set_irq(s->ocm_pwr[i], sta);
    }
}

static void update_rpu_tcm_pwr(XlnxPsxcLpxSlcr *s)
{
    size_t i;

    for (i = 0; i < ARRAY_SIZE(s->rpu_tcm_pwr); i++) {
        bool sta = extract32(s->rpu_tcm_pwr_ctrl, i, 1);

        qemu_set_irq(s->rpu_tcm_pwr[i], sta);
    }
}

static void update_gem_pwr(XlnxPsxcLpxSlcr *s)
{
    qemu_set_irq(s->gem_pwr[0], extract32(s->gem_pwr_ctrl, 0, 1));
    qemu_set_irq(s->gem_pwr[1], extract32(s->gem_pwr_ctrl, 8, 1));
}

static inline bool irq_is_pending(XlnxPsxcLpxSlcrIrq *irq)
{
    return !!(irq->status & ~irq->mask);
}

static void update_pwr_reset_irq(XlnxPsxcLpxSlcr *s)
{
    bool sta;

    sta = irq_is_pending(&s->wakeup0_irq)
        || irq_is_pending(&s->wakeup1_irq)
        || irq_is_pending(&s->power_dwn_irq)
        || irq_is_pending(&s->pwr_rst_irq)
        || irq_is_pending(&s->req_pwrup0_irq)
        || irq_is_pending(&s->req_pwrup1_irq)
        || irq_is_pending(&s->req_pwrdwn0_irq)
        || irq_is_pending(&s->req_pwrdwn1_irq);

    qemu_set_irq(s->pwr_reset_irq, sta);
}

static void update_rpu_pcil_wfi_irq(XlnxPsxcLpxSlcr *s)
{
    /*
     * This IRQ does not go out of the SLCR. It directly maps to the
     * RPU_STANDBY bit in the PWR_RST_IRQ_STATUS register.
     */
    if (irq_is_pending(&s->rpu_pcil_wfi_irq)) {
        s->pwr_rst_irq.status |= R_PWR_RST_IRQ_STATUS_RPU_STANDBY_MASK;
        update_pwr_reset_irq(s);
    }
}

static void update_rpu_pcil_pchan_irq(XlnxPsxcLpxSlcr *s, size_t idx)
{
    XlnxPsxcLpxSlcrRpuPChannel *chan = &s->rpu_pcil_pchan[idx];

    /*
     * This IRQ does not go out of the SLCR. It directly maps to the WAKEUP1
     * register LSBs.
     */
    if (irq_is_pending(&chan->irq)) {
        s->wakeup1_irq.status |=
            1 << (R_WAKEUP1_IRQ_STATUS_RPU_A_CORE0_SHIFT + idx);
        update_pwr_reset_irq(s);
    }
}

static void update_core_pwr(const XlnxPsxcLpxSlcr *s, size_t idx)
{
    const XlnxPsxcLpxSlcrCorePowerCtrl *pwr_ctrl = &s->core_pwr[idx];
    bool pwr = FIELD_EX32(pwr_ctrl->reg0,
                          APU0_CORE0_PWR_CNTRL_REG0, POWERUP_REQ);

    trace_xlnx_psxc_lpx_slcr_update_core_power(idx, pwr);
    qemu_set_irq(pwr_ctrl->pwr, pwr);
}

static void apu_standby_handler(void *opaque, int n, int level)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    if (!level) {
        return;
    }

    s->pwr_rst_irq.status |= R_PWR_RST_IRQ_STATUS_APU_STANDBY_MASK;
    update_pwr_reset_irq(s);
}

static void rpu_standby_handler(void *opaque, int n, int level)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    if (!level) {
        return;
    }

    /*
     * bit (n * 2) is wfi event of core n, while bit (n * 2) + 1 is for wfe
     * event.
     */
    s->rpu_pcil_wfi_irq.status |= (1 << (n * 2));
    update_rpu_pcil_wfi_irq(s);
}

static void apu_cluster_pchan_wakeup_handler(void *opaque, int n, int level)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    if (!level) {
        return;
    }

    s->wakeup0_irq.status |= R_WAKEUP0_IRQ_STATUS_APU0_CLUSTER_MASK << n;
    update_pwr_reset_irq(s);
}

static void apu_cluster_pchan_poweroff_handler(void *opaque, int n, int level)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    if (!level) {
        return;
    }

    s->power_dwn_irq.status |= R_POWER_DWN_IRQ_STATUS_APU0_CLUSTER_MASK << n;
    update_pwr_reset_irq(s);
}

static void apu_core_pchan_wakeup_handler(void *opaque, int n, int level)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    if (!level) {
        return;
    }

    s->wakeup0_irq.status |= R_WAKEUP0_IRQ_STATUS_APU0_CORE0_MASK << n;
    update_pwr_reset_irq(s);
}

static void apu_core_pchan_poweroff_handler(void *opaque, int n, int level)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    if (!level) {
        return;
    }

    s->power_dwn_irq.status |=
        R_POWER_DWN_IRQ_STATUS_APU0_CORE0_PWRDWN_MASK << n;
    update_pwr_reset_irq(s);
}

static uint32_t core_pwr_ctrl_read(const XlnxPsxcLpxSlcr *s, hwaddr offset)
{
    const size_t stride = A_APU0_CORE1_PWR_CNTRL_REG0
        - A_APU0_CORE0_PWR_CNTRL_REG0;
    size_t core_idx;
    size_t reg;
    const XlnxPsxcLpxSlcrCorePowerCtrl *pwr_ctrl;
    uint32_t ret;
    bool powered_up;

    core_idx = offset / stride;
    reg = offset % stride;
    reg += A_APU0_CORE0_PWR_CNTRL_REG0;

    g_assert(core_idx < ARRAY_SIZE(s->core_pwr));
    pwr_ctrl = &s->core_pwr[core_idx];

    powered_up = FIELD_EX32(pwr_ctrl->reg0,
                            APU0_CORE0_PWR_CNTRL_REG0, POWERUP_REQ);

    switch (reg) {
    case A_APU0_CORE0_PWR_CNTRL_REG0:
        ret = pwr_ctrl->reg0;
        break;

    case A_APU0_CORE0_PWR_CNTRL_REG1:
        ret = pwr_ctrl->reg1;
        break;

    case A_APU0_CORE0_PWR_CNTRL_REG2:
        ret = pwr_ctrl->reg2;
        break;

    case A_APU0_CORE0_PWR_CNTRL_STS:
        /* always advertize power good */
        ret = FIELD_DP32(0, APU0_CORE0_PWR_CNTRL_STS, PRDY, 0xf);
        ret = FIELD_DP32(ret, APU0_CORE0_PWR_CNTRL_STS, PGE, 0xf);

        /* 0: isolation enabled */
        ret = FIELD_DP32(ret, APU0_CORE0_PWR_CNTRL_STS, ISOLATION, powered_up);

        /* 0: clock enabled, 1: clock gated */
        ret = FIELD_DP32(ret, APU0_CORE0_PWR_CNTRL_STS, CLOCK_EN, 0);

        /* 0: reset released */
        ret = FIELD_DP32(ret, APU0_CORE0_PWR_CNTRL_STS, RESET_GATE, 0);

        ret = FIELD_DP32(ret, APU0_CORE0_PWR_CNTRL_STS, PWRUP_ACK_REG,
                         powered_up);

        ret = FIELD_DP32(ret, APU0_CORE0_PWR_CNTRL_STS, ISLAND_PWRUP_ERR, 0);
        break;

    case A_APU0_CORE0_PWR_CNTRL_WPROT:
        ret = pwr_ctrl->wprot;
        break;

    default:
        ret = 0;
    }

    return ret;
}

static void core_pwr_ctrl_write(XlnxPsxcLpxSlcr *s, hwaddr offset, uint32_t val)
{
    const size_t stride = A_APU0_CORE1_PWR_CNTRL_REG0
        - A_APU0_CORE0_PWR_CNTRL_REG0;
    size_t core_idx;
    size_t reg;
    XlnxPsxcLpxSlcrCorePowerCtrl *pwr_ctrl;

    core_idx = offset / stride;
    reg = offset % stride;
    reg += A_APU0_CORE0_PWR_CNTRL_REG0;

    g_assert(core_idx < ARRAY_SIZE(s->core_pwr));
    pwr_ctrl = &s->core_pwr[core_idx];

    if ((reg != A_APU0_CORE0_PWR_CNTRL_WPROT) && pwr_ctrl->wprot) {
        return;
    }

    switch (reg) {
    case A_APU0_CORE0_PWR_CNTRL_REG0:
        pwr_ctrl->reg0 = val & APU0_CORE0_PWR_CNTRL_REG0_WRITE_MASK;
        update_core_pwr(s, core_idx);
        break;

    case A_APU0_CORE0_PWR_CNTRL_REG1:
        pwr_ctrl->reg1 = val & APU0_CORE0_PWR_CNTRL_REG1_WRITE_MASK;
        break;

    case A_APU0_CORE0_PWR_CNTRL_REG2:
        pwr_ctrl->reg2 = val & APU0_CORE0_PWR_CNTRL_REG2_WRITE_MASK;
        break;

    case A_APU0_CORE0_PWR_CNTRL_STS:
        /* ro */
        break;

    case A_APU0_CORE0_PWR_CNTRL_WPROT:
        pwr_ctrl->wprot = val & APU0_CORE0_PWR_CNTRL_WPROT_WRITE_MASK;
        break;
    }
}

static uint32_t irq_reg_read(XlnxPsxcLpxSlcrIrq *irq,
                             size_t offset)
{
    uint32_t ret;

    switch (offset + A_WAKEUP0_IRQ_STATUS) {
    case A_WAKEUP0_IRQ_STATUS:
        ret = irq->status;
        break;

    case A_WAKEUP0_IRQ_MASK:
        ret = irq->mask;
        break;

    default:
        /* wo */
        ret = 0;
    }

    return ret;
}


static bool irq_reg_write(XlnxPsxcLpxSlcrIrq *irq,
                          size_t offset, uint32_t value)
{
    switch (offset + A_WAKEUP0_IRQ_STATUS) {
    case A_WAKEUP0_IRQ_STATUS:
        irq->status &= ~value;
        break;

    case A_WAKEUP0_IRQ_EN:
        irq->mask &= ~value;
        break;

    case A_WAKEUP0_IRQ_DIS:
        irq->mask |= value;
        break;

    case A_WAKEUP0_IRQ_TRIG:
        irq->status |= value;
        break;

    default:
        /* ro */
        return false;
    }

    return true;
}

static uint32_t pwr_reset_irq_read(XlnxPsxcLpxSlcr *s, XlnxPsxcLpxSlcrIrq *irq,
                                   size_t offset)
{
    return irq_reg_read(irq, offset);
}

static void pwr_reset_irq_write(XlnxPsxcLpxSlcr *s, XlnxPsxcLpxSlcrIrq *irq,
                                size_t offset, uint32_t value)
{
    if (irq_reg_write(irq, offset, value)) {
        update_pwr_reset_irq(s);
    }
}

static inline size_t rpu_pcil_pchannel_decode_offset(size_t *offset)
{
    const size_t cluster_stride = A_RPU_PCIL_B0_ISR - A_RPU_PCIL_A0_ISR;
    const size_t core_stride = A_RPU_PCIL_A1_ISR - A_RPU_PCIL_A0_ISR;
    size_t cl_idx, core_idx, idx;

    cl_idx = *offset / cluster_stride;
    *offset = *offset % cluster_stride;

    core_idx = *offset / core_stride;
    *offset = *offset % core_stride;

    idx = cl_idx * 2 + core_idx;

    return idx;
}

static uint32_t rpu_pcil_pchannel_read(XlnxPsxcLpxSlcr *s, size_t offset)
{
    size_t idx, reg;
    XlnxPsxcLpxSlcrRpuPChannel *pchan;
    uint32_t ret;

    reg = offset;
    idx = rpu_pcil_pchannel_decode_offset(&reg);

    if (idx >= s->num_rpu) {
        qemu_log_mask(LOG_GUEST_ERROR,
                      TYPE_XILINX_PSXC_LPX_SLCR ": access to RPU_PCIL register"
                      "for non-existant RPU %zu\n", idx);
        return 0;
    }

    pchan = &s->rpu_pcil_pchan[idx];

    switch (reg + A_RPU_PCIL_A0_ISR) {
    case A_RPU_PCIL_A0_ISR ... A_RPU_PCIL_A0_IDS:
        ret = irq_reg_read(&pchan->irq, reg);
        break;

    case A_RPU_PCIL_A0_PR:
        ret = pchan->preq;
        break;

    case A_RPU_PCIL_A0_PS:
        ret = pchan->pstate;
        break;

    case A_RPU_PCIL_A0_PA:
        ret = FIELD_DP32(0, RPU_PCIL_A0_PA, PACTIVE,
                         pchannel_get_current_state(pchan->iface));
        trace_xlnx_psxc_lpx_slcr_rpu_read_current_pstate(idx, ret);
        ret |= pchan->pactive; /* paccept and pdeny bits */
        break;

    default:
        ret = 0;
        break;
    }

    return ret;
}

static void update_rpu_pcil_pchannel(XlnxPsxcLpxSlcr *s, size_t idx)
{
    XlnxPsxcLpxSlcrRpuPChannel *pchan = &s->rpu_pcil_pchan[idx];
    const uint32_t R52_PSTATE_RUNNING = 0x2;

    if (pchan->preq) {
        uint32_t pstate;
        bool success;

        success = pchannel_request_state_change(pchan->iface, pchan->pstate);
        trace_xlnx_psxc_lpx_slcr_rpu_request_pstate_change(idx, pchan->pstate,
                                                           success);

        pchan->pactive = FIELD_DP32(pchan->pactive, RPU_PCIL_A0_PA,
                                    PACCEPT, success);
        pchan->pactive = FIELD_DP32(pchan->pactive, RPU_PCIL_A0_PA,
                                    PDENY, !success);

        pstate = pchannel_get_current_state(pchan->iface);

        if (pstate != R52_PSTATE_RUNNING) {
            return;
        }

        pchan->irq.status = FIELD_DP32(pchan->irq.status, RPU_PCIL_A0_ISR,
                                       PACTIVE1, 1);

        update_rpu_pcil_pchan_irq(s, idx);
    } else {
        pchan->pactive = FIELD_DP32(pchan->pactive, RPU_PCIL_A0_PA,
                                    PACCEPT, 0);
        pchan->pactive = FIELD_DP32(pchan->pactive, RPU_PCIL_A0_PA,
                                    PDENY, 0);
    }
}

static void rpu_pcil_pchannel_write(XlnxPsxcLpxSlcr *s,
                                    size_t offset, uint32_t value)
{
    size_t idx, reg;
    XlnxPsxcLpxSlcrRpuPChannel *pchan;

    reg = offset;
    idx = rpu_pcil_pchannel_decode_offset(&reg);

    if (idx >= s->num_rpu) {
        qemu_log_mask(LOG_GUEST_ERROR,
                      TYPE_XILINX_PSXC_LPX_SLCR ": access to RPU_PCIL register"
                      "for non-existant RPU %zu\n", idx);
        return;
    }

    pchan = &s->rpu_pcil_pchan[idx];

    switch (reg + A_RPU_PCIL_A0_ISR) {
    case A_RPU_PCIL_A0_ISR ... A_RPU_PCIL_A0_IDS:
        if (irq_reg_write(&pchan->irq, reg, value)) {
            update_rpu_pcil_pchan_irq(s, idx);
        }
        break;

    case A_RPU_PCIL_A0_PR:
        pchan->preq = value & RPU_PCIL_A0_PR_WRITE_MASK;
        update_rpu_pcil_pchannel(s, idx);
        break;

    case A_RPU_PCIL_A0_PS:
        pchan->pstate = value & RPU_PCIL_A0_PS_WRITE_MASK;
        update_rpu_pcil_pchannel(s, idx);
        break;

    case A_RPU_PCIL_A0_PA:
        /* ro */
        break;

    default:
        break;
    }
}

static void pmxc_lpd_eam_err_update(XlnxPsxcLpxSlcr *s)
{
    bool err_group;

    err_group =
        !!((s->eam_regs[0] & (~s->eam_regs[R_EAM(EAM_PMC0_ERR0_MASK)])) |
           (s->eam_regs[1] & (~s->eam_regs[R_EAM(EAM_PMC0_ERR1_MASK)])) |
           (s->eam_regs[2] & (~s->eam_regs[R_EAM(EAM_PMC0_ERR2_MASK)])) |
           (s->eam_regs[3] & (~s->eam_regs[R_EAM(EAM_PMC0_ERR3_MASK)])));
    qemu_set_irq(s->eam_err[0], err_group);

    err_group =
        !!((s->eam_regs[0] & (~s->eam_regs[R_EAM(EAM_PMC1_ERR0_MASK)])) |
           (s->eam_regs[1] & (~s->eam_regs[R_EAM(EAM_PMC1_ERR1_MASK)])) |
           (s->eam_regs[2] & (~s->eam_regs[R_EAM(EAM_PMC1_ERR2_MASK)])) |
           (s->eam_regs[3] & (~s->eam_regs[R_EAM(EAM_PMC1_ERR3_MASK)])));
    qemu_set_irq(s->eam_err[1], err_group);

    err_group =
        !!((s->eam_regs[0] & (~s->eam_regs[R_EAM(EAM_PMC2_ERR0_MASK)])) |
           (s->eam_regs[1] & (~s->eam_regs[R_EAM(EAM_PMC2_ERR1_MASK)])) |
           (s->eam_regs[2] & (~s->eam_regs[R_EAM(EAM_PMC2_ERR2_MASK)])) |
           (s->eam_regs[3] & (~s->eam_regs[R_EAM(EAM_PMC2_ERR3_MASK)])));
    qemu_set_irq(s->eam_err[2], err_group);

    err_group =
        !!((s->eam_regs[0] & (~s->eam_regs[R_EAM(EAM_PMC3_ERR0_MASK)])) |
           (s->eam_regs[1] & (~s->eam_regs[R_EAM(EAM_PMC3_ERR1_MASK)])) |
           (s->eam_regs[2] & (~s->eam_regs[R_EAM(EAM_PMC3_ERR2_MASK)])) |
           (s->eam_regs[3] & (~s->eam_regs[R_EAM(EAM_PMC3_ERR3_MASK)])));
    qemu_set_irq(s->eam_err[3], err_group);
}

static void eam_handler(void *opaque, int n, int lvl)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);
    size_t reg_idx = n / 32;
    size_t err_idx = n % 32;

    if (lvl) {
        s->eam_regs[reg_idx] |= 1 << err_idx;
        pmxc_lpd_eam_err_update(s);
    }
}

static uint64_t psxc_lpx_slcr_read(void *opaque, hwaddr offset,
                                   unsigned int size)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);
    uint32_t ret;

    switch (offset) {
    case A_MEM_CLEAR_PASS:
    case A_MEM_CLEAR_DONE:
        ret = s->mem_clear_done_pass;
        break;

    case A_SCAN_CLEAR_PASS:
    case A_SCAN_CLEAR_DONE:
        ret = s->scan_clear_done_pass;
        break;

    case A_OCM_PWR_CNTRL:
    case A_OCM_PWR_STATUS:
        ret = s->ocm_pwr_ctrl;
        break;

    case A_RPU_TCM_PWR_CNTRL:
    case A_RPU_TCM_PWR_STATUS:
        ret = s->rpu_tcm_pwr_ctrl;
        break;

    case A_GEM_PWR_CNTRL:
    case A_GEM_PWR_STATUS:
        ret = s->gem_pwr_ctrl;
        break;

    case A_WAKEUP0_IRQ_STATUS ... A_WAKEUP0_IRQ_TRIG:
        ret = pwr_reset_irq_read(s, &s->wakeup0_irq,
                                 offset - A_WAKEUP0_IRQ_STATUS);
        break;

    case A_WAKEUP1_IRQ_STATUS ... A_WAKEUP1_IRQ_TRIG:
        ret = pwr_reset_irq_read(s, &s->wakeup1_irq,
                                 offset - A_WAKEUP1_IRQ_STATUS);
        break;

    case A_POWER_DWN_IRQ_STATUS ... A_POWER_DWN_IRQ_TRIG:
        ret = pwr_reset_irq_read(s, &s->power_dwn_irq,
                                 offset - A_POWER_DWN_IRQ_STATUS);
        break;

    case A_PWR_RST_IRQ_STATUS ... A_PWR_RST_IRQ_TRIG:
        ret = pwr_reset_irq_read(s, &s->pwr_rst_irq,
                                 offset - A_PWR_RST_IRQ_STATUS);
        break;

    case A_REQ_PWRUP0_STATUS ... A_REQ_PWRUP0_TRIG:
        ret = pwr_reset_irq_read(s, &s->req_pwrup0_irq,
                                 offset - A_REQ_PWRUP0_STATUS);
        break;

    case A_REQ_PWRUP1_STATUS ... A_REQ_PWRUP1_TRIG:
        ret = pwr_reset_irq_read(s, &s->req_pwrup1_irq,
                                 offset - A_REQ_PWRUP1_STATUS);
        break;

    case A_REQ_PWRDWN0_STATUS ... A_REQ_PWRDWN0_TRIG:
        ret = pwr_reset_irq_read(s, &s->req_pwrdwn0_irq,
                                 offset - A_REQ_PWRDWN0_STATUS);
        break;

    case A_REQ_PWRDWN1_STATUS ... A_REQ_PWRDWN1_TRIG:
        ret = pwr_reset_irq_read(s, &s->req_pwrdwn1_irq,
                                 offset - A_REQ_PWRDWN1_STATUS);
        break;


    case A_APU0_CORE0_PWR_CNTRL_REG0 ... A_RPU4_CORE1_PWR_CNTRL_WPROT:
        ret = core_pwr_ctrl_read(s, offset - A_APU0_CORE0_PWR_CNTRL_REG0);
        break;

    case A_RPU_PCIL_A0_ISR ... A_RPU_PCIL_E1_PA:
        ret = rpu_pcil_pchannel_read(s, offset - A_RPU_PCIL_A0_ISR);
        break;

    case A_RPU_PCIL_PSM_STANDBY ... A_RPU_PCIL_PSM_IDS:
        ret = irq_reg_read(&s->rpu_pcil_wfi_irq,
                           offset - A_RPU_PCIL_PSM_STANDBY);
        break;

    case A_EAM_ERR0_STATUS ... A_EAM_ERR3_STATUS:
        ret = s->eam_regs[EAM_REG_ADDR(offset) / 4];
        break;

    case A_EAM_PMC0_ERR0_MASK ... A_EAM_PMC0_ERR3_MASK:
    case A_EAM_PMC1_ERR0_MASK ... A_EAM_PMC1_ERR3_MASK:
    case A_EAM_PMC2_ERR0_MASK ... A_EAM_PMC2_ERR3_MASK:
    case A_EAM_PMC3_ERR0_MASK ... A_EAM_PMC3_ERR3_MASK:
    case A_EAM_ASU_ERR0_MASK ... A_EAM_ASU_ERR3_MASK:
        ret = s->eam_regs[EAM_REG_ADDR(offset) / 4];
        break;

    default:
        ret = 0;
    }

    trace_xlnx_psxc_lpx_slcr_read(offset, ret);
    return ret;
}

static void psxc_lpx_slcr_write(void *opaque, hwaddr offset,
                                uint64_t value, unsigned int size)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(opaque);

    trace_xlnx_psxc_lpx_slcr_write(offset, value);

    switch (offset) {
    case A_MEM_CLEAR_TRIGGER:
        s->mem_clear_done_pass |= value & MEM_CLEAR_TRIGGER_WRITE_MASK;
        break;

    case A_SCAN_CLEAR_TRIGGER:
        s->scan_clear_done_pass |= value & SCAN_CLEAR_TRIGGER_WRITE_MASK;
        break;

    case A_OCM_PWR_CNTRL:
        s->ocm_pwr_ctrl = value & OCM_PWR_CNTRL_WRITE_MASK;
        update_ocm_pwr(s);
        break;

    case A_RPU_TCM_PWR_CNTRL:
        s->rpu_tcm_pwr_ctrl = value & RPU_TCM_PWR_CNTRL_WRITE_MASK;
        update_rpu_tcm_pwr(s);
        break;

    case A_GEM_PWR_CNTRL:
        s->gem_pwr_ctrl = value & GEM_PWR_CNTRL_WRITE_MASK;
        update_gem_pwr(s);
        break;

    case A_WAKEUP0_IRQ_STATUS ... A_WAKEUP0_IRQ_TRIG:
        pwr_reset_irq_write(s, &s->wakeup0_irq,
                            offset - A_WAKEUP0_IRQ_STATUS, value);
        break;

    case A_WAKEUP1_IRQ_STATUS ... A_WAKEUP1_IRQ_TRIG:
        pwr_reset_irq_write(s, &s->wakeup1_irq,
                            offset - A_WAKEUP1_IRQ_STATUS, value);
        break;

    case A_POWER_DWN_IRQ_STATUS ... A_POWER_DWN_IRQ_TRIG:
        pwr_reset_irq_write(s, &s->power_dwn_irq,
                            offset - A_POWER_DWN_IRQ_STATUS, value);
        break;

    case A_PWR_RST_IRQ_STATUS ... A_PWR_RST_IRQ_TRIG:
        pwr_reset_irq_write(s, &s->pwr_rst_irq,
                            offset - A_PWR_RST_IRQ_STATUS, value);
        break;

    case A_REQ_PWRUP0_STATUS ... A_REQ_PWRUP0_TRIG:
        pwr_reset_irq_write(s, &s->req_pwrup0_irq,
                            offset - A_REQ_PWRUP0_STATUS, value);
        break;

    case A_REQ_PWRUP1_STATUS ... A_REQ_PWRUP1_TRIG:
        pwr_reset_irq_write(s, &s->req_pwrup1_irq,
                            offset - A_REQ_PWRUP1_STATUS, value);
        break;

    case A_REQ_PWRDWN0_STATUS ... A_REQ_PWRDWN0_TRIG:
        pwr_reset_irq_write(s, &s->req_pwrdwn0_irq,
                            offset - A_REQ_PWRDWN0_STATUS, value);
        break;

    case A_REQ_PWRDWN1_STATUS ... A_REQ_PWRDWN1_TRIG:
        pwr_reset_irq_write(s, &s->req_pwrdwn1_irq,
                            offset - A_REQ_PWRDWN1_STATUS, value);
        break;

    case A_APU0_CORE0_PWR_CNTRL_REG0 ... A_RPU4_CORE1_PWR_CNTRL_WPROT:
        core_pwr_ctrl_write(s, offset - A_APU0_CORE0_PWR_CNTRL_REG0, value);
        break;

    case A_RPU_PCIL_A0_ISR ... A_RPU_PCIL_E1_PA:
        rpu_pcil_pchannel_write(s, offset - A_RPU_PCIL_A0_ISR, value);
        break;

    case A_RPU_PCIL_PSM_STANDBY ... A_RPU_PCIL_PSM_IDS:
        if (irq_reg_write(&s->rpu_pcil_wfi_irq,
                          offset - A_RPU_PCIL_PSM_STANDBY, value)) {
            update_rpu_pcil_wfi_irq(s);
        }
        break;
    case A_EAM_ERR0_STATUS ... A_EAM_ERR3_STATUS:
        s->eam_regs[EAM_REG_ADDR(offset) / 4] &= ~value;
        pmxc_lpd_eam_err_update(s);
        break;
    case A_EAM_ERR0_TRIG ...  A_EAM_ERR3_TRIG:
        s->eam_regs[(EAM_REG_ADDR(offset) - 0x20) / 4] = value;
        pmxc_lpd_eam_err_update(s);
        break;
    case A_EAM_PMC0_ERR0_EN ... A_EAM_PMC0_ERR3_EN:
    case A_EAM_PMC1_ERR0_EN ... A_EAM_PMC1_ERR3_EN:
    case A_EAM_PMC2_ERR0_EN ... A_EAM_PMC2_ERR3_EN:
    case A_EAM_PMC3_ERR0_EN ... A_EAM_PMC3_ERR3_EN:
    case A_EAM_ASU_ERR0_EN ... A_EAM_ASU_ERR3_EN:
        s->eam_regs[(EAM_REG_ADDR(offset) - 0x20) / 4] &= ~value;
        pmxc_lpd_eam_err_update(s);
        break;
    case A_EAM_PMC0_ERR0_DIS ... A_EAM_PMC0_ERR3_DIS:
    case A_EAM_PMC1_ERR0_DIS ... A_EAM_PMC1_ERR3_DIS:
    case A_EAM_PMC2_ERR0_DIS ... A_EAM_PMC2_ERR3_DIS:
    case A_EAM_PMC3_ERR0_DIS ... A_EAM_PMC3_ERR3_DIS:
    case A_EAM_ASU_ERR0_DIS ... A_EAM_ASU_ERR3_DIS:
        s->eam_regs[(EAM_REG_ADDR(offset) - 0x40) / 4] |= value;
        pmxc_lpd_eam_err_update(s);
        break;
    default:
        break;
    }
}

static const MemoryRegionOps psxc_lpx_slcr_ops = {
    .read = psxc_lpx_slcr_read,
    .write = psxc_lpx_slcr_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void core_pwr_ctrl_reset(XlnxPsxcLpxSlcrCorePowerCtrl *pwr_ctrl,
                                bool linux_boot)
{
    if (linux_boot) {
        pwr_ctrl->reg0 = 0; /* reset with the core powered off */
    } else {
        pwr_ctrl->reg0 = APU0_CORE0_PWR_CNTRL_REG0_RESET_VAL;
    }

    pwr_ctrl->reg1 = APU0_CORE0_PWR_CNTRL_REG1_RESET_VAL;
    pwr_ctrl->reg2 = APU0_CORE0_PWR_CNTRL_REG2_RESET_VAL;
    pwr_ctrl->wprot = APU0_CORE0_PWR_CNTRL_WPROT_RESET_VAL;
}

static void rpu_pcil_pchan_reset(XlnxPsxcLpxSlcrRpuPChannel *pchan)
{
    pchan->irq.status = RPU_PCIL_A0_ISR_RESET_VAL;
    pchan->irq.mask = RPU_PCIL_A0_IMR_RESET_VAL;
    pchan->preq = RPU_PCIL_A0_PR_RESET_VAL;
    pchan->pstate = RPU_PCIL_A0_PS_RESET_VAL;
    pchan->pactive = RPU_PCIL_A0_PA_RESET_VAL;
}

static void psxc_lpx_slcr_reset_enter(Object *obj, ResetType type)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(obj);
    size_t i;

    s->ocm_pwr_ctrl = OCM_PWR_CNTRL_RESET_VAL;
    s->rpu_tcm_pwr_ctrl = RPU_TCM_PWR_CNTRL_RESET_VAL;
    s->gem_pwr_ctrl = GEM_PWR_CNTRL_RESET_VAL;

    s->wakeup0_irq.status = WAKEUP0_IRQ_STATUS_RESET_VAL;
    s->wakeup0_irq.mask = WAKEUP0_IRQ_MASK_RESET_VAL;
    s->wakeup1_irq.status = WAKEUP1_IRQ_STATUS_RESET_VAL;
    s->wakeup1_irq.mask = WAKEUP1_IRQ_MASK_RESET_VAL;
    s->power_dwn_irq.status = POWER_DWN_IRQ_STATUS_RESET_VAL;
    s->power_dwn_irq.mask = POWER_DWN_IRQ_MASK_RESET_VAL;
    s->pwr_rst_irq.status = PWR_RST_IRQ_STATUS_RESET_VAL;
    s->pwr_rst_irq.mask = PWR_RST_IRQ_MASK_RESET_VAL;
    s->req_pwrup0_irq.status = REQ_PWRUP0_STATUS_RESET_VAL;
    s->req_pwrup0_irq.mask = REQ_PWRUP0_INT_MASK_RESET_VAL;
    s->req_pwrup1_irq.status = REQ_PWRUP1_STATUS_RESET_VAL;
    s->req_pwrup1_irq.mask = REQ_PWRUP0_INT_MASK_RESET_VAL;
    s->req_pwrdwn0_irq.status = REQ_PWRDWN0_STATUS_RESET_VAL;
    s->req_pwrdwn0_irq.mask = REQ_PWRDWN0_INT_MASK_RESET_VAL;
    s->req_pwrdwn1_irq.status = REQ_PWRDWN1_STATUS_RESET_VAL;
    s->req_pwrdwn1_irq.mask = REQ_PWRDWN0_INT_MASK_RESET_VAL;
    s->rpu_pcil_wfi_irq.status = RPU_PCIL_PSM_STANDBY_RESET_VAL;
    s->rpu_pcil_wfi_irq.mask = RPU_PCIL_PSM_IMR_RESET_VAL;
    s->mem_clear_done_pass = MEM_CLEAR_DONE_RESET_VAL;
    s->scan_clear_done_pass = SCAN_CLEAR_DONE_RESET_VAL;

    for (i = 0; i < s->num_rpu; i++) {
        rpu_pcil_pchan_reset(&s->rpu_pcil_pchan[i]);
    }

    for (i = 0; i < ARRAY_SIZE(s->core_pwr); i++) {
        core_pwr_ctrl_reset(&s->core_pwr[i], s->linux_boot);
    }
}

static void psxc_lpx_slcr_reset_hold(Object *obj)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(obj);
    size_t i;

    update_ocm_pwr(s);
    update_rpu_tcm_pwr(s);
    update_gem_pwr(s);
    update_pwr_reset_irq(s);
    update_rpu_pcil_wfi_irq(s);

    for (i = 0; i < ARRAY_SIZE(s->core_pwr); i++) {
        update_core_pwr(s, i);
    }
}

static void psxc_lpx_slcr_reset_exit(Object *obj)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(obj);
    size_t i;

    for (i = 0; i < s->num_rpu; i++) {
        if (object_dynamic_cast(OBJECT(s->rpu_pcil_pchan[i].iface),
                                TYPE_ARM_PCHANNEL_DUMMY)) {
            device_cold_reset(DEVICE(s->rpu_pcil_pchan[i].iface));
        }
    }
}

static inline void stub_pchannel_iface(ARMPChannelIf **iface, Error **errp)
{
    DeviceState *stub;

    stub = qdev_new(TYPE_ARM_PCHANNEL_DUMMY);
    qdev_prop_set_uint32(stub, "pstate-on", 0x0);
    qdev_prop_set_uint32(stub, "pstate-reset-val", 0x0); /* ON */
    qdev_prop_set_uint32(stub, "pactive-on", 0x2);
    qdev_prop_set_uint32(stub, "pactive-off", 0x0);
    qdev_realize(stub, NULL, errp);

    if (*errp) {
        return;
    }

    *iface = ARM_PCHANNEL_IF(stub);
}

static void psxc_lpx_slcr_realize(DeviceState *dev, Error **errp)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(dev);
    SysBusDevice *sbd = SYS_BUS_DEVICE(dev);
    size_t i;

    if (s->num_rpu > ARRAY_SIZE(s->rpu_pcil_pchan)) {
        error_setg(errp, TYPE_XILINX_PSXC_LPX_SLCR
                   ": Invalid number of RPUs %" PRIu32, s->num_rpu);
        return;
    }

    qdev_init_gpio_out_named(dev, s->ocm_pwr, "pwr-ocm",
                             ARRAY_SIZE(s->ocm_pwr));
    qdev_init_gpio_out_named(dev, s->rpu_tcm_pwr, "pwr-rpu-tcm",
                             ARRAY_SIZE(s->rpu_tcm_pwr));
    qdev_init_gpio_out_named(dev, s->gem_pwr, "pwr-gem",
                             ARRAY_SIZE(s->gem_pwr));

    for (i = 0; i < ARRAY_SIZE(s->core_pwr); i++) {
        qdev_init_gpio_out_named(dev, &s->core_pwr[i].pwr, "pwr-cpu", 1);
    }

    qdev_init_gpio_out_named(dev, s->eam_err, "eam-err", 4);

    sysbus_init_irq(sbd, &s->pwr_reset_irq);

    qdev_init_gpio_in_named(dev, apu_standby_handler, "apu-wfi", 8);
    qdev_init_gpio_in_named(dev, rpu_standby_handler, "rpu-wfi", 10);
    qdev_init_gpio_in_named(dev, apu_cluster_pchan_poweroff_handler,
                            "apu-cluster-pchan-poweroff", 4);
    qdev_init_gpio_in_named(dev, apu_cluster_pchan_wakeup_handler,
                            "apu-cluster-pchan-wakeup", 4);
    qdev_init_gpio_in_named(dev, apu_core_pchan_poweroff_handler,
                            "apu-core-pchan-poweroff", 8);
    qdev_init_gpio_in_named(dev, apu_core_pchan_wakeup_handler,
                            "apu-core-pchan-wakeup", 8);
    qdev_init_gpio_in_named(dev, eam_handler, "eam-err-in", 128);

    for (i = 0; i < s->num_rpu; i++) {
        if (s->rpu_pcil_pchan[i].iface == NULL) {
            stub_pchannel_iface(&s->rpu_pcil_pchan[i].iface, errp);

            if (*errp) {
                return;
            }
        }
    }
}

static void psxc_lpx_slcr_linux_boot_if_init(ARMLinuxBootIf *obj,
                                             bool secure_boot)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(obj);

    s->linux_boot = true;
}

static void psxc_lpx_slcr_init(Object *obj)
{
    XlnxPsxcLpxSlcr *s = XILINX_PSXC_LPX_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    memory_region_init_io(&s->iomem, obj, &psxc_lpx_slcr_ops, s,
                          TYPE_XILINX_PSXC_LPX_SLCR, PSXC_LPX_SLCR_MMIO_SIZE);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_core_pwr = {
    .name = TYPE_XILINX_PSXC_LPX_SLCR "-core-pwr",
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32(reg0, XlnxPsxcLpxSlcrCorePowerCtrl),
        VMSTATE_UINT32(reg1, XlnxPsxcLpxSlcrCorePowerCtrl),
        VMSTATE_UINT32(reg2, XlnxPsxcLpxSlcrCorePowerCtrl),
        VMSTATE_UINT32(wprot, XlnxPsxcLpxSlcrCorePowerCtrl),
        VMSTATE_END_OF_LIST()
    }
};

static const VMStateDescription vmstate_irq = {
    .name = TYPE_XILINX_PSXC_LPX_SLCR "-irq",
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32(status, XlnxPsxcLpxSlcrIrq),
        VMSTATE_UINT32(mask, XlnxPsxcLpxSlcrIrq),
        VMSTATE_END_OF_LIST()
    }
};

static const VMStateDescription vmstate_rpu_pchannel = {
    .name = TYPE_XILINX_PSXC_LPX_SLCR "-rpu-pchannel",
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_STRUCT(irq, XlnxPsxcLpxSlcrRpuPChannel, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_BOOL(preq, XlnxPsxcLpxSlcrRpuPChannel),
        VMSTATE_UINT32(pstate, XlnxPsxcLpxSlcrRpuPChannel),
        VMSTATE_UINT32(pactive, XlnxPsxcLpxSlcrRpuPChannel),
        VMSTATE_END_OF_LIST()
    }
};

static const VMStateDescription vmstate_psxc_lpx_slcr = {
    .name = TYPE_XILINX_PSXC_LPX_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32(ocm_pwr_ctrl, XlnxPsxcLpxSlcr),
        VMSTATE_UINT32(rpu_tcm_pwr_ctrl, XlnxPsxcLpxSlcr),
        VMSTATE_UINT32(gem_pwr_ctrl, XlnxPsxcLpxSlcr),
        VMSTATE_STRUCT_ARRAY(core_pwr, XlnxPsxcLpxSlcr, 18, 1,
                             vmstate_core_pwr, XlnxPsxcLpxSlcrCorePowerCtrl),
        VMSTATE_STRUCT(wakeup0_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(wakeup1_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(power_dwn_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(pwr_rst_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(req_pwrup0_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(req_pwrup1_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(req_pwrdwn0_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(req_pwrdwn1_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT(rpu_pcil_wfi_irq, XlnxPsxcLpxSlcr, 1,
                       vmstate_irq, XlnxPsxcLpxSlcrIrq),
        VMSTATE_STRUCT_ARRAY(rpu_pcil_pchan, XlnxPsxcLpxSlcr, 10, 1,
                             vmstate_rpu_pchannel, XlnxPsxcLpxSlcrRpuPChannel),
        VMSTATE_END_OF_LIST(),
    }
};

static Property psxc_lpx_slcr_properties[] = {
    DEFINE_PROP_UINT32("num-rpu", XlnxPsxcLpxSlcr, num_rpu, 10),
    DEFINE_PROP_LINK("core-0", XlnxPsxcLpxSlcr, rpu_pcil_pchan[0].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-1", XlnxPsxcLpxSlcr, rpu_pcil_pchan[1].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-2", XlnxPsxcLpxSlcr, rpu_pcil_pchan[2].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-3", XlnxPsxcLpxSlcr, rpu_pcil_pchan[3].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-4", XlnxPsxcLpxSlcr, rpu_pcil_pchan[4].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-5", XlnxPsxcLpxSlcr, rpu_pcil_pchan[5].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-6", XlnxPsxcLpxSlcr, rpu_pcil_pchan[6].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-7", XlnxPsxcLpxSlcr, rpu_pcil_pchan[7].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-8", XlnxPsxcLpxSlcr, rpu_pcil_pchan[8].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_LINK("core-9", XlnxPsxcLpxSlcr, rpu_pcil_pchan[9].iface,
                     TYPE_ARM_PCHANNEL_IF, ARMPChannelIf *),
    DEFINE_PROP_END_OF_LIST(),
};

static const FDTGenericGPIOSet psxc_lpx_slcr_gpios[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
            { .name = "pwr-cpu", .fdt_index = 0, .range = 18 },
            { .name = "pwr-ocm", .fdt_index = 18, .range = 16 },
            { .name = "pwr-rpu-tcm", .fdt_index = 34, .range = 10 },
            { .name = "pwr-gem", .fdt_index = 44, .range = 2 },
            { .name = "eam-err", .fdt_index = 46, .range = 4},

            /* inputs */
            { .name = "apu-wfi", .fdt_index = 64, .range = 8 },
            { .name = "rpu-wfi", .fdt_index = 72, .range = 10 },
            { .name = "apu-cluster-pchan-poweroff", .fdt_index = 82,
              .range = 4 },
            { .name = "apu-cluster-pchan-wakeup", .fdt_index = 86, .range = 4 },
            { .name = "apu-core-pchan-poweroff", .fdt_index = 90, .range = 8 },
            { .name = "apu-core-pchan-wakeup", .fdt_index = 98, .range = 8 },
            { .name = "eam-err-in", .fdt_index = 106, .range = 128 },
            { },
        }
    },
    { },
};

static void psxc_lpx_slcr_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);
    ARMLinuxBootIfClass *albifc = ARM_LINUX_BOOT_IF_CLASS(klass);

    dc->realize = psxc_lpx_slcr_realize;
    dc->vmsd = &vmstate_psxc_lpx_slcr;
    rc->phases.enter = psxc_lpx_slcr_reset_enter;
    rc->phases.hold = psxc_lpx_slcr_reset_hold;
    rc->phases.exit = psxc_lpx_slcr_reset_exit;
    device_class_set_props(dc, psxc_lpx_slcr_properties);
    albifc->arm_linux_init = psxc_lpx_slcr_linux_boot_if_init;
    fggc->controller_gpios = psxc_lpx_slcr_gpios;
}

static const TypeInfo psxc_lpx_slcr_info = {
    .name          = TYPE_XILINX_PSXC_LPX_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(XlnxPsxcLpxSlcr),
    .class_init    = psxc_lpx_slcr_class_init,
    .instance_init = psxc_lpx_slcr_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_ARM_LINUX_BOOT_IF },
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void psxc_lpx_slcr_register_types(void)
{
    type_register_static(&psxc_lpx_slcr_info);
}

type_init(psxc_lpx_slcr_register_types)
