/*
 * QEMU model of the APU_CTRL APU Dual Core Settings
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-08-22.
 * Written by Edgar E. Iglesias <edgar.iglesias@xilinx.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "hw/irq.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "qapi/error.h"
#include "sysemu/sysemu.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "cpu.h"
#include "hw/fdt_generic_util.h"

#ifndef XILINX_APU_CTRL_ERR_DEBUG
#define XILINX_APU_CTRL_ERR_DEBUG 0
#endif

#define TYPE_XILINX_APU_CTRL "xlnx.versal-apu-ctrl"

#define XILINX_APU_CTRL(obj) \
     OBJECT_CHECK(XlnxZynq3APUCtrl, (obj), TYPE_XILINX_APU_CTRL)

REG32(ERR_CTRL, 0x0)
    FIELD(ERR_CTRL, PSLVERR, 0, 1)
REG32(ISR, 0x10)
    FIELD(ISR, INV_APB, 0, 1)
REG32(IMR, 0x14)
    FIELD(IMR, INV_APB, 0, 1)
REG32(IEN, 0x18)
    FIELD(IEN, INV_APB, 0, 1)
REG32(IDS, 0x1c)
    FIELD(IDS, INV_APB, 0, 1)
REG32(CONFIG_0, 0x20)
    FIELD(CONFIG_0, CFGTE, 24, 2)
    FIELD(CONFIG_0, CFGEND, 16, 2)
    FIELD(CONFIG_0, VINITHI, 8, 2)
    FIELD(CONFIG_0, AA64NAA32, 0, 2)
REG32(CONFIG_1, 0x24)
    FIELD(CONFIG_1, L1RSTDISABLE, 28, 1)
    FIELD(CONFIG_1, CP15SDISABLE, 0, 2)
REG32(RVBARADDR0L, 0x40)
    FIELD(RVBARADDR0L, ADDR, 2, 30)
REG32(RVBARADDR0H, 0x44)
    FIELD(RVBARADDR0H, ADDR, 0, 12)
REG32(RVBARADDR1L, 0x48)
    FIELD(RVBARADDR1L, ADDR, 2, 30)
REG32(RVBARADDR1H, 0x4c)
    FIELD(RVBARADDR1H, ADDR, 0, 12)
REG32(RVBARADDR2L, 0x50)
    FIELD(RVBARADDR2L, ADDR, 2, 30)
REG32(RVBARADDR2H, 0x54)
    FIELD(RVBARADDR2H, ADDR, 0, 12)
REG32(RVBARADDR3L, 0x58)
    FIELD(RVBARADDR3L, ADDR, 2, 30)
REG32(RVBARADDR3H, 0x5c)
    FIELD(RVBARADDR3H, ADDR, 0, 12)
REG32(ACE_CTRL, 0x60)
    FIELD(ACE_CTRL, AWQOS, 16, 4)
    FIELD(ACE_CTRL, ARQOS, 0, 4)
REG32(SNOOP_CTRL, 0x80)
    FIELD(SNOOP_CTRL, ACE_INACT, 4, 1)
    FIELD(SNOOP_CTRL, ACP_INACT, 0, 1)
REG32(PWRCTL, 0x90)
    FIELD(PWRCTL, CLREXMONREQ, 17, 1)
    FIELD(PWRCTL, L2FLUSHREQ, 16, 1)
    FIELD(PWRCTL, CPUPWRDWNREQ, 0, 2)
REG32(PWRSTAT, 0x94)
    FIELD(PWRSTAT, CLREXMONACK, 17, 1)
    FIELD(PWRSTAT, L2FLUSHDONE, 16, 1)
    FIELD(PWRSTAT, DBGNOPWRDWN, 0, 2)

#define APU_CTRL_R_MAX (R_PWRSTAT + 1)

#define MAX_CPUS 4

typedef struct XlnxZynq3APUCtrl {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr;

    ARMCPU *cpus[MAX_CPUS];
    qemu_irq acpu_pwrdw[MAX_CPUS];

    uint8_t cpu_pwrdwn_req;

    uint32_t regs[APU_CTRL_R_MAX];
    RegisterInfo regs_info[APU_CTRL_R_MAX];
} XlnxZynq3APUCtrl;

static void imr_update_irq(XlnxZynq3APUCtrl *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ien_prew(RegisterInfo *reg, uint64_t val64)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t ids_prew(RegisterInfo *reg, uint64_t val64)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static void rvbar_postw(RegisterInfo *reg, uint64_t val64)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(reg->opaque);
    int i;

    for (i = 0; i < MAX_CPUS; i++) {
        uint64_t rvbar;

        if (!s->cpus[i]) {
            break;
        }

        rvbar = s->regs[R_RVBARADDR0H + i * 2];
        rvbar <<= 32;
        rvbar |= s->regs[R_RVBARADDR0L + i * 2];

        object_property_set_int(OBJECT(s->cpus[i]), "rvbar", rvbar, &error_abort);
    }
}

static void pwrctl_postw(RegisterInfo *reg, uint64_t val64)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(reg->opaque);
    int i;
    uint32_t new;

    if (ARRAY_FIELD_EX32(s->regs, PWRCTL, L2FLUSHREQ)) {
        bool flush_req_ok = true;

        if (!ARRAY_FIELD_EX32(s->regs, SNOOP_CTRL, ACE_INACT)
            || !ARRAY_FIELD_EX32(s->regs, SNOOP_CTRL, ACP_INACT)) {
            qemu_log_mask(LOG_GUEST_ERROR,
                 "%s: SNOOP_CTRL not inactive while requesting L2FLUSHREQ\n",
                 DEVICE(s)->id);
            flush_req_ok = false;
        }

        /* HAX:
         * We shouldn't be peeking into this internal ARMCPU state.
         * This is useful for debugging.
         */
        for (i = 0; i < MAX_CPUS; i++) {
            if (s->cpus[i] && !s->cpus[i]->is_in_wfi) {
                qemu_log_mask(LOG_GUEST_ERROR,
                       "%s: ACPU%d not in WFI while requesting L2FLUSHREQ\n",
                       DEVICE(s)->id, i);
                flush_req_ok = false;
            }
        }

        ARRAY_FIELD_DP32(s->regs, PWRSTAT, L2FLUSHDONE, flush_req_ok);
    }

    if (ARRAY_FIELD_EX32(s->regs, PWRCTL, CLREXMONREQ)) {
        qemu_log_mask(LOG_UNIMP, "%s: CLREXMONREQ unimplemented.\n",
                      DEVICE(s)->id);
    }

    for (i = 0; i < MAX_CPUS; i++) {
        new = val64 & (1 << i);
        /* Check if CPU's CPUPWRDNREQ has changed. If yes, update GPIOs. */
        if (new != (s->cpu_pwrdwn_req & (1 << i))) {
            qemu_set_irq(s->acpu_pwrdw[i], !!new);
        }
        s->cpu_pwrdwn_req &= ~(1 << i);
        s->cpu_pwrdwn_req |= new;
    }
}

static const RegisterAccessInfo apu_ctrl_regs_info[] = {
    {   .name = "ERR_CTRL",  .addr = A_ERR_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "IEN",  .addr = A_IEN,
        .pre_write = ien_prew,
    },{ .name = "IDS",  .addr = A_IDS,
        .pre_write = ids_prew,
    },{ .name = "CONFIG_0",  .addr = A_CONFIG_0,
        .reset = 0x303,
    },{ .name = "CONFIG_1",  .addr = A_CONFIG_1,
    },{ .name = "RVBARADDR0L",  .addr = A_RVBARADDR0L,
        .reset = 0xffff0000,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR0H",  .addr = A_RVBARADDR0H,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR1L",  .addr = A_RVBARADDR1L,
        .reset = 0xffff0000,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR1H",  .addr = A_RVBARADDR1H,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR2L",  .addr = A_RVBARADDR2L,
        .reset = 0xffff0000,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR2H",  .addr = A_RVBARADDR2H,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR3L",  .addr = A_RVBARADDR3L,
        .reset = 0xffff0000,
        .post_write = rvbar_postw,
    },{ .name = "RVBARADDR3H",  .addr = A_RVBARADDR3H,
        .post_write = rvbar_postw,
    },{ .name = "ACE_CTRL",  .addr = A_ACE_CTRL,
        .reset = 0xf000f,
    },{ .name = "SNOOP_CTRL",  .addr = A_SNOOP_CTRL,
    },{ .name = "PWRCTL",  .addr = A_PWRCTL,
        .post_write = pwrctl_postw,
    },{ .name = "PWRSTAT",  .addr = A_PWRSTAT,
        .ro = 0x30003,
    }
};

static void apu_ctrl_reset(DeviceState *dev)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    imr_update_irq(s);
}

static const MemoryRegionOps apu_ctrl_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void apu_ctrl_realize(DeviceState *dev, Error **errp)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(dev);

    qdev_init_gpio_out_named(dev, s->acpu_pwrdw, "acpu-pwrdw", MAX_CPUS);
}

static void apu_ctrl_init(Object *obj)
{
    XlnxZynq3APUCtrl *s = XILINX_APU_CTRL(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;
    int i;

    for (i = 0; i < MAX_CPUS; ++i) {
        char *prop_name = g_strdup_printf("cpu%d", i);
        object_property_add_link(obj, prop_name, TYPE_ARM_CPU,
                             (Object **)&s->cpus[i],
                             qdev_prop_allow_set_link_before_realize,
                             OBJ_PROP_LINK_STRONG);
        g_free(prop_name);
    }

    memory_region_init(&s->iomem, obj, TYPE_XILINX_APU_CTRL,
                       APU_CTRL_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), apu_ctrl_regs_info,
                              ARRAY_SIZE(apu_ctrl_regs_info),
                              s->regs_info, s->regs,
                              &apu_ctrl_ops,
                              XILINX_APU_CTRL_ERR_DEBUG,
                              APU_CTRL_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr);
}

static const FDTGenericGPIOSet apu_ctrl_controller_gpios[] = {
    {
        .names = &fdt_generic_gpio_name_set_gpio,
        .gpios = (FDTGenericGPIOConnection[]) {
            {.name = "acpu-pwrdw", .fdt_index = 0, .range = MAX_CPUS},
            { },
        },
    },
    { },
};


static const VMStateDescription vmstate_apu_ctrl = {
    .name = TYPE_XILINX_APU_CTRL,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, XlnxZynq3APUCtrl, APU_CTRL_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void apu_ctrl_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->reset = apu_ctrl_reset;
    dc->vmsd = &vmstate_apu_ctrl;
    dc->realize = apu_ctrl_realize;
    fggc->controller_gpios = apu_ctrl_controller_gpios;
}

static const TypeInfo apu_ctrl_info = {
    .name          = TYPE_XILINX_APU_CTRL,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(XlnxZynq3APUCtrl),
    .class_init    = apu_ctrl_class_init,
    .instance_init = apu_ctrl_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { },
    },
};

static void apu_ctrl_register_types(void)
{
    type_register_static(&apu_ctrl_info);
}

type_init(apu_ctrl_register_types)
