/*
 * QEMU model of the CMT_MMCM 
 *
 * Copyright (c) 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-02-06.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_CMT_MMCM_ERR_DEBUG
#define XILINX_CMT_MMCM_ERR_DEBUG 0
#endif

#define TYPE_XILINX_CMT_MMCM "xlnx.versal-cmt-mmcm"

#define XILINX_CMT_MMCM(obj) \
     OBJECT_CHECK(CMT_MMCM, (obj), TYPE_XILINX_CMT_MMCM)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, PWRDN, 14, 1)
    FIELD(REG_PCSR_MASK, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_MASK, APBEN, 12, 1)
    FIELD(REG_PCSR_MASK, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(REG_PCSR_MASK, STARTCAL, 10, 1)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, TRISTATE, 8, 1)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE, 2, 4)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, PWRDN, 14, 1)
    FIELD(REG_PCSR_CONTROL, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_CONTROL, APBEN, 12, 1)
    FIELD(REG_PCSR_CONTROL, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(REG_PCSR_CONTROL, STARTCAL, 10, 1)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, TRISTATE, 8, 1)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE, 2, 4)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_ITR, 0x10)
    FIELD(REG_ITR, LOCK_B, 0, 1)
REG32(REG_ISR, 0x14)
    FIELD(REG_ISR, LOCK_B, 0, 1)
REG32(REG_IMR0, 0x18)
    FIELD(REG_IMR0, LOCK_B, 0, 1)
REG32(REG_IER0, 0x1c)
    FIELD(REG_IER0, LOCK_B, 0, 1)
REG32(REG_IDR0, 0x20)
    FIELD(REG_IDR0, LOCK_B, 0, 1)
REG32(REG_IOR, 0x24)
    FIELD(REG_IOR, OFFSET, 0, 5)
REG32(REG_0, 0x28)
    FIELD(REG_0, AVDD_VBG_SEL, 11, 5)
    FIELD(REG_0, AVDD_COMP_SET, 8, 3)
    FIELD(REG_0, ANALOG_MISC, 3, 4)
    FIELD(REG_0, AVDD_VBG_PD, 0, 3)
REG32(REG_1, 0x2c)
    FIELD(REG_1, CLKBURST_REPEAT, 10, 1)
    FIELD(REG_1, CLKBURST_ENABLE, 9, 1)
    FIELD(REG_1, CLKBURST_CNT, 0, 8)
REG32(REG_2, 0x30)
    FIELD(REG_2, CLKFBOUT_PREDIV2, 12, 1)
    FIELD(REG_2, CLKFBOUT_MX, 10, 2)
    FIELD(REG_2, CLKFBOUT_EN, 9, 1)
    FIELD(REG_2, CLKFBOUT_EDGE, 8, 1)
    FIELD(REG_2, CLKFBOUT_DT, 0, 8)
REG32(REG_3, 0x34)
    FIELD(REG_3, CLKFBOUT_HT, 8, 8)
    FIELD(REG_3, CLKFBOUT_LT, 0, 8)
REG32(REG_4, 0x38)
    FIELD(REG_4, CLKOUT0_P5_FEDGE, 15, 1)
    FIELD(REG_4, CLKOUT0_START_H, 14, 1)
    FIELD(REG_4, CLKOUT0_P5EN, 13, 1)
    FIELD(REG_4, CLKOUT0_USED, 12, 1)
    FIELD(REG_4, CLKOUT0_PREDIV2, 11, 1)
    FIELD(REG_4, CLKOUT0_MX, 9, 2)
    FIELD(REG_4, CLKOUT0_EDGE, 8, 1)
    FIELD(REG_4, CLKOUT0_DT, 0, 8)
REG32(REG_5, 0x3c)
    FIELD(REG_5, CLKOUT0_HT, 8, 8)
    FIELD(REG_5, CLKOUT0_LT, 0, 8)
REG32(REG_6, 0x40)
    FIELD(REG_6, CLKOUT1_P5_FEDGE, 15, 1)
    FIELD(REG_6, CLKOUT1_START_H, 14, 1)
    FIELD(REG_6, CLKOUT1_P5EN, 13, 1)
    FIELD(REG_6, CLKOUT1_USED, 12, 1)
    FIELD(REG_6, CLKOUT1_PREDIV2, 11, 1)
    FIELD(REG_6, CLKOUT1_MX, 9, 2)
    FIELD(REG_6, CLKOUT1_EDGE, 8, 1)
    FIELD(REG_6, CLKOUT1_DT, 0, 8)
REG32(REG_7, 0x44)
    FIELD(REG_7, CLKOUT1_HT, 8, 8)
    FIELD(REG_7, CLKOUT1_LT, 0, 8)
REG32(REG_8, 0x48)
    FIELD(REG_8, CLKOUT2_P5_FEDGE, 15, 1)
    FIELD(REG_8, CLKOUT2_START_H, 14, 1)
    FIELD(REG_8, CLKOUT2_P5EN, 13, 1)
    FIELD(REG_8, CLKOUT2_USED, 12, 1)
    FIELD(REG_8, CLKOUT2_PREDIV2, 11, 1)
    FIELD(REG_8, CLKOUT2_MX, 9, 2)
    FIELD(REG_8, CLKOUT2_EDGE, 8, 1)
    FIELD(REG_8, CLKOUT2_DT, 0, 8)
REG32(REG_9, 0x4c)
    FIELD(REG_9, CLKOUT2_HT, 8, 8)
    FIELD(REG_9, CLKOUT2_LT, 0, 8)
REG32(REG_10, 0x50)
    FIELD(REG_10, CLKOUT3_P5_FEDGE, 15, 1)
    FIELD(REG_10, CLKOUT3_START_H, 14, 1)
    FIELD(REG_10, CLKOUT3_P5EN, 13, 1)
    FIELD(REG_10, CLKOUT3_USED, 12, 1)
    FIELD(REG_10, CLKOUT3_PREDIV2, 11, 1)
    FIELD(REG_10, CLKOUT3_MX, 9, 2)
    FIELD(REG_10, CLKOUT3_EDGE, 8, 1)
    FIELD(REG_10, CLKOUT3_DT, 0, 8)
REG32(REG_11, 0x54)
    FIELD(REG_11, CLKOUT3_HT, 8, 8)
    FIELD(REG_11, CLKOUT3_LT, 0, 8)
REG32(REG_12, 0x58)
    FIELD(REG_12, CONTROL_0, 0, 16)
REG32(REG_13, 0x5c)
    FIELD(REG_13, CONTROL_1, 0, 16)
REG32(REG_14, 0x60)
    FIELD(REG_14, CONTROL_2, 0, 16)
REG32(REG_15, 0x64)
    FIELD(REG_15, CONTROL_3, 0, 16)
REG32(REG_16, 0x68)
    FIELD(REG_16, CONTROL_4, 0, 16)
REG32(REG_17, 0x6c)
    FIELD(REG_17, CONTROL_5, 0, 16)
REG32(REG_18, 0x70)
    FIELD(REG_18, CONTROL_6, 0, 16)
REG32(REG_19, 0x74)
    FIELD(REG_19, CONTROL_7, 0, 16)
REG32(REG_20, 0x78)
    FIELD(REG_20, CP_RES_L, 8, 2)
    FIELD(REG_20, CP_RES_H, 6, 2)
    FIELD(REG_20, CP_OPAMP_BN, 5, 1)
    FIELD(REG_20, CP_BIAS_TRIP_SET, 4, 1)
    FIELD(REG_20, CP, 0, 4)
REG32(REG_21, 0x7c)
    FIELD(REG_21, DESKEW_EN, 8, 1)
    FIELD(REG_21, DESKEW_DLY_PATH, 7, 1)
    FIELD(REG_21, DESKEW_DLY_EN, 6, 1)
    FIELD(REG_21, DESKEW_DLY, 0, 6)
REG32(REG_22, 0x80)
    FIELD(REG_22, DIVCLK_EDGE, 10, 1)
    FIELD(REG_22, DIRECT_PATH_CNTRL, 9, 1)
    FIELD(REG_22, DESKEW_EN_2ND, 8, 1)
    FIELD(REG_22, DESKEW_DLY_PATH_2ND, 7, 1)
    FIELD(REG_22, DESKEW_DLY_EN_2ND, 6, 1)
    FIELD(REG_22, DESKEW_DLY_2ND, 0, 6)
REG32(REG_23, 0x84)
    FIELD(REG_23, DIVCLK_HT, 8, 8)
    FIELD(REG_23, DIVCLK_LT, 0, 8)
REG32(REG_24, 0x88)
    FIELD(REG_24, FRACT_TEST_SEL, 10, 3)
    FIELD(REG_24, FRACT_TEST_EN, 9, 1)
    FIELD(REG_24, FRACT_TEST_CK_SEL, 8, 1)
    FIELD(REG_24, EN_VCO_DIV6, 7, 1)
    FIELD(REG_24, EN_VCO_DIV1, 6, 1)
    FIELD(REG_24, EN_TESTIN, 5, 1)
    FIELD(REG_24, EN_SYNC_CK_TEST, 4, 1)
    FIELD(REG_24, EN_LOCKED_DESKEW_2ND, 3, 1)
    FIELD(REG_24, EN_LOCKED_DESKEW, 2, 1)
    FIELD(REG_24, EN_DESKEW_TRACK_2ND, 1, 1)
    FIELD(REG_24, EN_DESKEW_TRACK, 0, 1)
REG32(REG_25, 0x8c)
    FIELD(REG_25, HVLF_CNT_TEST_EN, 10, 1)
    FIELD(REG_25, HVLF_CNT_TEST, 4, 6)
    FIELD(REG_25, FREQ_COMP, 1, 3)
    FIELD(REG_25, FORCE_SENSE_SHORT, 0, 1)
REG32(REG_27, 0x90)
    FIELD(REG_27, INTERP1_SKEW, 10, 5)
    FIELD(REG_27, INTERP1_SEL, 8, 2)
    FIELD(REG_27, INTERP0_SKEW, 2, 5)
    FIELD(REG_27, INTERP0_SEL, 0, 2)
REG32(REG_28, 0x94)
    FIELD(REG_28, INTERP3_SKEW, 10, 5)
    FIELD(REG_28, INTERP3_SEL, 8, 2)
    FIELD(REG_28, INTERP2_SKEW, 2, 5)
    FIELD(REG_28, INTERP2_SEL, 0, 2)
REG32(REG_29, 0x98)
    FIELD(REG_29, LFHF, 10, 2)
    FIELD(REG_29, LF_PEN, 8, 2)
    FIELD(REG_29, LF_NEN, 6, 2)
    FIELD(REG_29, LF_LOW_SEL, 5, 1)
REG32(REG_30, 0x9c)
    FIELD(REG_30, LOCK_FB_DLY, 10, 5)
    FIELD(REG_30, LOCK_CNT, 0, 10)
REG32(REG_31, 0xa0)
    FIELD(REG_31, LOCK_REF_DLY, 10, 5)
    FIELD(REG_31, LOCK_SAT_HIGH, 0, 10)
REG32(REG_32, 0xa4)
    FIELD(REG_32, MMCM_EN, 12, 1)
    FIELD(REG_32, PI_PROGRAM, 11, 1)
    FIELD(REG_32, PFD_STARTUP, 10, 1)
    FIELD(REG_32, PFD, 3, 7)
    FIELD(REG_32, MAN_LF, 0, 3)
REG32(REG_33, 0xa8)
    FIELD(REG_33, SENSE_TEST_EN, 7, 1)
    FIELD(REG_33, SEL_SLIPD, 6, 1)
    FIELD(REG_33, RES, 1, 4)
    FIELD(REG_33, REGLPF_RES_SHORT, 0, 1)
REG32(REG_34, 0xac)
    FIELD(REG_34, SPARE_ANALOG, 0, 16)
REG32(REG_35, 0xb0)
    FIELD(REG_35, SPARE_DIGITAL, 0, 16)
REG32(REG_36, 0xb4)
    FIELD(REG_36, TC_GEN_MODE, 8, 1)
    FIELD(REG_36, SYNTH_CLK_DIV, 6, 2)
    FIELD(REG_36, SUP_SEL_VCCINT, 5, 1)
    FIELD(REG_36, SUP_SEL_VCCAUX, 4, 1)
    FIELD(REG_36, SUP_SEL_VBGHALF, 3, 1)
    FIELD(REG_36, SUP_SEL_VBG, 2, 1)
    FIELD(REG_36, SUP_SEL_AVDD, 0, 1)
REG32(REG_37, 0xb8)
    FIELD(REG_37, TESTOUT1_MUX_SEL, 6, 6)
    FIELD(REG_37, TESTOUT0_MUX_SEL, 0, 6)
REG32(REG_38, 0xbc)
    FIELD(REG_38, TMUX_MUX_SEL, 12, 2)
    FIELD(REG_38, TESTOUT3_MUX_SEL, 6, 6)
    FIELD(REG_38, TESTOUT2_MUX_SEL, 0, 6)
REG32(REG_39, 0xc0)
    FIELD(REG_39, UNLOCK_CNT, 0, 10)
REG32(REG_40, 0xc4)
    FIELD(REG_40, VCO_STARTUP_HYST_DISABLE, 7, 1)
    FIELD(REG_40, VCO_STARTUP_ALT_EN, 6, 1)
    FIELD(REG_40, VCO_STARTUP_ADJ, 5, 1)
    FIELD(REG_40, VCO_SINGLE_BAND_DEFAULT, 4, 1)
    FIELD(REG_40, VCO_KICK_DISABLE, 3, 1)
    FIELD(REG_40, VCO_HIGH_RANGE_EN, 2, 1)
    FIELD(REG_40, VCO_GATE_CCI_B, 1, 1)
    FIELD(REG_40, VCO_BAND_MODE, 0, 1)
REG32(REG_41, 0xc8)
    FIELD(REG_41, VLF_VALID_SEL, 9, 3)
    FIELD(REG_41, VLF_VALID_PWDN, 8, 1)
    FIELD(REG_41, VLF_SWITCH_SEL, 5, 3)
    FIELD(REG_41, VLF_SWITCH_PWDN, 4, 1)
    FIELD(REG_41, VLF_HIGH_SEL, 2, 2)
    FIELD(REG_41, VLF_HIGH_PWDN_B, 1, 1)
    FIELD(REG_41, VLF_HIGH_EN, 0, 1)
REG32(REG_42, 0xcc)
    FIELD(REG_42, CLKOUT4_P5_FEDGE, 15, 1)
    FIELD(REG_42, CLKOUT4_START_H, 14, 1)
    FIELD(REG_42, CLKOUT4_P5EN, 13, 1)
    FIELD(REG_42, CLKOUT4_USED, 12, 1)
    FIELD(REG_42, CLKOUT4_PREDIV2, 11, 1)
    FIELD(REG_42, CLKOUT4_MX, 9, 2)
    FIELD(REG_42, CLKOUT4_EDGE, 8, 1)
    FIELD(REG_42, CLKOUT4_DT, 0, 8)
REG32(REG_43, 0xd0)
    FIELD(REG_43, CLKOUT4_HT, 8, 8)
    FIELD(REG_43, CLKOUT4_LT, 0, 8)
REG32(REG_44, 0xd4)
    FIELD(REG_44, CLKOUT5_P5_FEDGE, 15, 1)
    FIELD(REG_44, CLKOUT5_START_H, 14, 1)
    FIELD(REG_44, CLKOUT5_P5EN, 13, 1)
    FIELD(REG_44, CLKOUT5_USED, 12, 1)
    FIELD(REG_44, CLKOUT5_PREDIV2, 11, 1)
    FIELD(REG_44, CLKOUT5_MX, 9, 2)
    FIELD(REG_44, CLKOUT5_EDGE, 8, 1)
    FIELD(REG_44, CLKOUT5_DT, 0, 8)
REG32(REG_45, 0xd8)
    FIELD(REG_45, CLKOUT5_HT, 8, 8)
    FIELD(REG_45, CLKOUT5_LT, 0, 8)
REG32(REG_46, 0xdc)
    FIELD(REG_46, CLKOUT6_P5_FEDGE, 15, 1)
    FIELD(REG_46, CLKOUT6_START_H, 14, 1)
    FIELD(REG_46, CLKOUT6_P5EN, 13, 1)
    FIELD(REG_46, CLKOUT6_USED, 12, 1)
    FIELD(REG_46, CLKOUT6_PREDIV2, 11, 1)
    FIELD(REG_46, CLKOUT6_MX, 9, 2)
    FIELD(REG_46, CLKOUT6_EDGE, 8, 1)
    FIELD(REG_46, CLKOUT6_DT, 0, 8)
REG32(REG_47, 0xe0)
    FIELD(REG_47, CLKOUT6_HT, 8, 8)
    FIELD(REG_47, CLKOUT6_LT, 0, 8)
REG32(REG_48, 0xe4)
    FIELD(REG_48, INTERP5_SKEW, 10, 5)
    FIELD(REG_48, INTERP5_SEL, 8, 2)
    FIELD(REG_48, INTERP4_SKEW, 2, 5)
    FIELD(REG_48, INTERP4_SEL, 0, 2)
REG32(REG_49, 0xe8)
    FIELD(REG_49, INTERPFB_SKEW, 10, 5)
    FIELD(REG_49, INTERPFB_SEL, 8, 2)
    FIELD(REG_49, INTERP6_SKEW, 2, 5)
    FIELD(REG_49, INTERP6_SEL, 0, 2)
REG32(REG_50, 0xec)
    FIELD(REG_50, IS_RST_INVERTED, 7, 1)
    FIELD(REG_50, IS_PWRDWN_INVERTED, 6, 1)
    FIELD(REG_50, IS_PSINCDEC_INVERTED, 5, 1)
    FIELD(REG_50, IS_PSEN_INVERTED, 4, 1)
    FIELD(REG_50, IS_CLKINSEL_INVERTED, 3, 1)
    FIELD(REG_50, IS_CLKIN2_INVERTED, 2, 1)
    FIELD(REG_50, IS_CLKIN1_INVERTED, 1, 1)
    FIELD(REG_50, IS_CLKFBIN_INVERTED, 0, 1)
REG32(REG_51, 0xf0)
    FIELD(REG_51, CLKFBOUT_FRACT_SPARE, 6, 10)
    FIELD(REG_51, CLKFBOUT_FRACT, 0, 6)
REG32(REG_52, 0xf4)
    FIELD(REG_52, CLKFBIN_HT, 8, 8)
    FIELD(REG_52, CLKFBIN_LT, 0, 8)
REG32(REG_53, 0xf8)
    FIELD(REG_53, SS_STEPS_INIT, 10, 3)
    FIELD(REG_53, SS_STEPS, 7, 3)
    FIELD(REG_53, SS_EN, 6, 1)
    FIELD(REG_53, CLKFBIN_EDGE, 0, 1)
REG32(REG_54, 0xfc)
    FIELD(REG_54, SKEW_SEL, 5, 6)
    FIELD(REG_54, CLKFBOUT_FRACT_SEED, 3, 2)
    FIELD(REG_54, CLKFBOUT_FRACT_ORDER, 2, 1)
    FIELD(REG_54, CLKFBOUT_FRACT_EN, 1, 1)
    FIELD(REG_54, CLKFBOUT_FRACT_ALG, 0, 1)

#define CMT_MMCM_R_MAX (R_REG_54 + 1)

typedef struct CMT_MMCM {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[CMT_MMCM_R_MAX];
    RegisterInfo regs_info[CMT_MMCM_R_MAX];
} CMT_MMCM;

#define LOCK_VAL 0xF9E8D7C6

static void cmt_mmcm_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    CMT_MMCM *s = XILINX_CMT_MMCM(reg->opaque);
    bool locked = val64 != LOCK_VAL;

    ARRAY_FIELD_DP32(s->regs, REG_PCSR_STATUS, PCSRLOCK, locked);
    ARRAY_FIELD_DP32(s->regs, REG_PCSR_LOCK, STATE, locked);
}

static const RegisterAccessInfo cmt_mmcm_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xffe00000,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1fe,
        .rsvd = 0xffe00000,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_PCSRLOCK_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_CALDONE_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = cmt_mmcm_lock_postw
    },{ .name = "REG_ITR",  .addr = A_REG_ITR,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ISR",  .addr = A_REG_ISR,
        .rsvd = 0xfffffffe,
        .w1c = 0x1,
    },{ .name = "REG_IMR0",  .addr = A_REG_IMR0,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "REG_IER0",  .addr = A_REG_IER0,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_IDR0",  .addr = A_REG_IDR0,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_IOR",  .addr = A_REG_IOR,
        .reset = 0xb,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_0",  .addr = A_REG_0,
        .reset = 0x4b06,
        .rsvd = 0xffff0080,
        .ro = 0x80,
    },{ .name = "REG_1",  .addr = A_REG_1,
        .reset = 0x1,
        .rsvd = 0xfffff900,
        .ro = 0x100,
    },{ .name = "REG_2",  .addr = A_REG_2,
        .reset = 0x1600,
        .rsvd = 0xffffe000,
    },{ .name = "REG_3",  .addr = A_REG_3,
        .reset = 0x1515,
        .rsvd = 0xffff0000,
    },{ .name = "REG_4",  .addr = A_REG_4,
        .reset = 0xa00,
        .rsvd = 0xffff0000,
    },{ .name = "REG_5",  .addr = A_REG_5,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_6",  .addr = A_REG_6,
        .reset = 0xa00,
        .rsvd = 0xffff0000,
    },{ .name = "REG_7",  .addr = A_REG_7,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_8",  .addr = A_REG_8,
        .reset = 0xa00,
        .rsvd = 0xffff0000,
    },{ .name = "REG_9",  .addr = A_REG_9,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_10",  .addr = A_REG_10,
        .reset = 0xa00,
        .rsvd = 0xffff0000,
    },{ .name = "REG_11",  .addr = A_REG_11,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_12",  .addr = A_REG_12,
        .reset = 0xf37c,
        .rsvd = 0xffff0000,
    },{ .name = "REG_13",  .addr = A_REG_13,
        .reset = 0x7c4d,
        .rsvd = 0xffff0000,
    },{ .name = "REG_14",  .addr = A_REG_14,
        .reset = 0xd042,
        .rsvd = 0xffff0000,
    },{ .name = "REG_15",  .addr = A_REG_15,
        .reset = 0xebd8,
        .rsvd = 0xffff0000,
    },{ .name = "REG_16",  .addr = A_REG_16,
        .reset = 0xec5f,
        .rsvd = 0xffff0000,
    },{ .name = "REG_17",  .addr = A_REG_17,
        .reset = 0xedfb,
        .rsvd = 0xffff0000,
    },{ .name = "REG_18",  .addr = A_REG_18,
        .reset = 0xaacd,
        .rsvd = 0xffff0000,
    },{ .name = "REG_19",  .addr = A_REG_19,
        .reset = 0x4428,
        .rsvd = 0xffff0000,
    },{ .name = "REG_20",  .addr = A_REG_20,
        .reset = 0x2f,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_21",  .addr = A_REG_21,
        .rsvd = 0xfffffe00,
    },{ .name = "REG_22",  .addr = A_REG_22,
        .reset = 0x400,
        .rsvd = 0xfffff800,
    },{ .name = "REG_23",  .addr = A_REG_23,
        .rsvd = 0xffff0000,
    },{ .name = "REG_24",  .addr = A_REG_24,
        .reset = 0x20,
        .rsvd = 0xffffe000,
    },{ .name = "REG_25",  .addr = A_REG_25,
        .reset = 0x6,
        .rsvd = 0xfffff800,
    },{ .name = "REG_27",  .addr = A_REG_27,
        .rsvd = 0xffff8080,
        .ro = 0x80,
    },{ .name = "REG_28",  .addr = A_REG_28,
        .rsvd = 0xffff8080,
        .ro = 0x80,
    },{ .name = "REG_29",  .addr = A_REG_29,
        .reset = 0xe80,
        .rsvd = 0xfffff01f,
        .ro = 0x1f,
    },{ .name = "REG_30",  .addr = A_REG_30,
        .reset = 0x7d45,
        .rsvd = 0xffff8000,
    },{ .name = "REG_31",  .addr = A_REG_31,
        .reset = 0x7fe9,
        .rsvd = 0xffff8000,
    },{ .name = "REG_32",  .addr = A_REG_32,
        .reset = 0x1188,
        .rsvd = 0xffffe000,
    },{ .name = "REG_33",  .addr = A_REG_33,
        .reset = 0xc,
        .rsvd = 0xffffff20,
        .ro = 0x20,
    },{ .name = "REG_34",  .addr = A_REG_34,
        .reset = 0x1,
        .rsvd = 0xffff0000,
    },{ .name = "REG_35",  .addr = A_REG_35,
        .rsvd = 0xffff0000,
    },{ .name = "REG_36",  .addr = A_REG_36,
        .reset = 0xc0,
        .rsvd = 0xfffffe02,
        .ro = 0x2,
    },{ .name = "REG_37",  .addr = A_REG_37,
        .rsvd = 0xfffff000,
    },{ .name = "REG_38",  .addr = A_REG_38,
        .rsvd = 0xffffc000,
    },{ .name = "REG_39",  .addr = A_REG_39,
        .reset = 0x1,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_40",  .addr = A_REG_40,
        .rsvd = 0xffffff00,
    },{ .name = "REG_41",  .addr = A_REG_41,
        .reset = 0x68b,
        .rsvd = 0xfffff000,
    },{ .name = "REG_42",  .addr = A_REG_42,
        .reset = 0xa06,
        .rsvd = 0xffff0000,
    },{ .name = "REG_43",  .addr = A_REG_43,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_44",  .addr = A_REG_44,
        .reset = 0xa00,
        .rsvd = 0xffff0000,
    },{ .name = "REG_45",  .addr = A_REG_45,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_46",  .addr = A_REG_46,
        .reset = 0xa00,
        .rsvd = 0xffff0000,
    },{ .name = "REG_47",  .addr = A_REG_47,
        .reset = 0x101,
        .rsvd = 0xffff0000,
    },{ .name = "REG_48",  .addr = A_REG_48,
        .rsvd = 0xffff8080,
        .ro = 0x80,
    },{ .name = "REG_49",  .addr = A_REG_49,
        .rsvd = 0xffff8080,
        .ro = 0x80,
    },{ .name = "REG_50",  .addr = A_REG_50,
        .rsvd = 0xffffff00,
    },{ .name = "REG_51",  .addr = A_REG_51,
        .rsvd = 0xffff0000,
    },{ .name = "REG_52",  .addr = A_REG_52,
        .rsvd = 0xffff0000,
    },{ .name = "REG_53",  .addr = A_REG_53,
        .reset = 0x1381,
        .rsvd = 0xffffe03e,
        .ro = 0x3e,
    },{ .name = "REG_54",  .addr = A_REG_54,
        .rsvd = 0xfffff800,
    }
};

static void cmt_mmcm_reset(DeviceState *dev)
{
    CMT_MMCM *s = XILINX_CMT_MMCM(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static MemTxResult reg_write(void *opaque, hwaddr addr,
                             uint64_t data, unsigned size, MemTxAttrs attrs)
{
    RegisterInfoArray *reg_array = opaque;
    CMT_MMCM *s = XILINX_CMT_MMCM(reg_array->r[0]->opaque);

    /* Is the register set Locked?  */
    if (ARRAY_FIELD_EX32(s->regs, REG_PCSR_LOCK, STATE)
        && addr != A_REG_PCSR_LOCK) {
        return MEMTX_ERROR;
    }

    register_write_memory(opaque, addr, data, size);
    return MEMTX_OK;
}

static const MemoryRegionOps cmt_mmcm_ops = {
    .read = register_read_memory,
    .write_with_attrs = reg_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void cmt_mmcm_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void cmt_mmcm_init(Object *obj)
{
    CMT_MMCM *s = XILINX_CMT_MMCM(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_CMT_MMCM,
                       CMT_MMCM_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), cmt_mmcm_regs_info,
                              ARRAY_SIZE(cmt_mmcm_regs_info),
                              s->regs_info, s->regs,
                              &cmt_mmcm_ops,
                              XILINX_CMT_MMCM_ERR_DEBUG,
                              CMT_MMCM_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_cmt_mmcm = {
    .name = TYPE_XILINX_CMT_MMCM,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, CMT_MMCM, CMT_MMCM_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void cmt_mmcm_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = cmt_mmcm_reset;
    dc->realize = cmt_mmcm_realize;
    dc->vmsd = &vmstate_cmt_mmcm;
}

static const TypeInfo cmt_mmcm_info = {
    .name          = TYPE_XILINX_CMT_MMCM,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(CMT_MMCM),
    .class_init    = cmt_mmcm_class_init,
    .instance_init = cmt_mmcm_init,
};

static void cmt_mmcm_register_types(void)
{
    type_register_static(&cmt_mmcm_info);
}

type_init(cmt_mmcm_register_types)
