/*
 * QEMU model of the CPM_SLCR_SECURE This block holds the TrustZone
 * configuration of varlious master and slave devices in CPM
 *
 * Copyright (c) 2021 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2021-08-30.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_CPM_SLCR_SECURE_ERR_DEBUG
#define XILINX_CPM_SLCR_SECURE_ERR_DEBUG 0
#endif

#define TYPE_XILINX_CPM_SLCR_SECURE "xlnx.cpm_slcr_secure"

#define XILINX_CPM_SLCR_SECURE(obj) \
     OBJECT_CHECK(CPM_SLCR_SECURE, (obj), TYPE_XILINX_CPM_SLCR_SECURE)

REG32(WPROT0, 0x0)
    FIELD(WPROT0, ACTIVE, 0, 1)
REG32(REG_CTRL, 0x4)
    FIELD(REG_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0x10)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x14)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0x18)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x1c)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_TRIGGER, 0x20)
    FIELD(IR_TRIGGER, ADDR_DECODE_ERR, 0, 1)
REG32(TZ_PCIE, 0x100)
    FIELD(TZ_PCIE, ATTR_DMA_CH3_SEC, 31, 1)
    FIELD(TZ_PCIE, ATTR_DMA_CH2_SEC, 30, 1)
    FIELD(TZ_PCIE, ATTR_DMA_CH1_SEC, 29, 1)
    FIELD(TZ_PCIE, ATTR_DMA_CH0_SEC, 28, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF3_VF_SEC, 27, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF2_VF_SEC, 26, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF1_VF_SEC, 25, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF0_VF_SEC, 24, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF3_SEC, 23, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF2_SEC, 22, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF1_SEC, 21, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PF0_SEC, 20, 1)
    FIELD(TZ_PCIE, ATTR_DMA_ENABLE_SECURE, 19, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF3_VF, 18, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF2_VF, 17, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF1_VF, 16, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF0_VF, 15, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF3, 14, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF2, 13, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF1, 12, 1)
    FIELD(TZ_PCIE, ATTR_DMA_PCIEBAR2AXIBAR_SEC_PF0, 11, 1)
    FIELD(TZ_PCIE, ATTR_DMA_AXIBAR2PCIEBAR_SEC_5, 10, 1)
    FIELD(TZ_PCIE, ATTR_DMA_AXIBAR2PCIEBAR_SEC_4, 9, 1)
    FIELD(TZ_PCIE, ATTR_DMA_AXIBAR2PCIEBAR_SEC_3, 8, 1)
    FIELD(TZ_PCIE, ATTR_DMA_AXIBAR2PCIEBAR_SEC_2, 7, 1)
    FIELD(TZ_PCIE, ATTR_DMA_AXIBAR2PCIEBAR_SEC_1, 6, 1)
    FIELD(TZ_PCIE, ATTR_DMA_AXIBAR2PCIEBAR_SEC_0, 5, 1)
    FIELD(TZ_PCIE, ATTRIB_DMA, 4, 1)
    FIELD(TZ_PCIE, ATTRIB_PCIE_1, 3, 1)
    FIELD(TZ_PCIE, ATTRIB_PCIE_0, 2, 1)
    FIELD(TZ_PCIE, CFG_MGMT_PCIE1, 1, 1)
    FIELD(TZ_PCIE, CFG_MGMT_PCIE0, 0, 1)
REG32(TZ_CPI, 0x104)
    FIELD(TZ_CPI, PORT1_CFG, 3, 1)
    FIELD(TZ_CPI, PORT1_EN, 2, 1)
    FIELD(TZ_CPI, PORT0_CFG, 1, 1)
    FIELD(TZ_CPI, PORT0_EN, 0, 1)
REG32(TZ_CRCPM, 0x108)
    FIELD(TZ_CRCPM, CFG, 0, 1)
REG32(TZ_SLCR, 0x10c)
    FIELD(TZ_SLCR, CFG, 0, 1)
REG32(TZ_ADDRREMAP, 0x110)
    FIELD(TZ_ADDRREMAP, CFG, 0, 1)
REG32(TZ_MCAP, 0x114)
    FIELD(TZ_MCAP, MCAP1_OVERRIDE_VAL, 3, 1)
    FIELD(TZ_MCAP, MCAP1_OVERRIDE_EN, 2, 1)
    FIELD(TZ_MCAP, MCAP0_OVERRIDE_VAL, 1, 1)
    FIELD(TZ_MCAP, MCAP0_OVERRIDE_EN, 0, 1)
REG32(PCIE0_SMID_EN, 0x200)
    FIELD(PCIE0_SMID_EN, SELECT_ENABLE, 10, 10)
    FIELD(PCIE0_SMID_EN, BASE, 0, 10)
REG32(PCIE0_SMID_CFG0, 0x204)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_7, 28, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_6, 24, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_5, 20, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_4, 16, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_3, 12, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_2, 8, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_1, 4, 4)
    FIELD(PCIE0_SMID_CFG0, BDF_BIT_SEL_0, 0, 4)
REG32(PCIE0_SMID_CFG1, 0x208)
    FIELD(PCIE0_SMID_CFG1, BDF_BIT_SEL_9, 4, 4)
    FIELD(PCIE0_SMID_CFG1, BDF_BIT_SEL_8, 0, 4)
REG32(PCIE1_SMID_EN, 0x20c)
    FIELD(PCIE1_SMID_EN, SELECT_ENABLE, 10, 10)
    FIELD(PCIE1_SMID_EN, BASE, 0, 10)
REG32(PCIE1_SMID_CFG0, 0x210)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_7, 28, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_6, 24, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_5, 20, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_4, 16, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_3, 12, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_2, 8, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_1, 4, 4)
    FIELD(PCIE1_SMID_CFG0, BDF_BIT_SEL_0, 0, 4)
REG32(PCIE1_SMID_CFG1, 0x214)
    FIELD(PCIE1_SMID_CFG1, BDF_BIT_SEL_9, 4, 4)
    FIELD(PCIE1_SMID_CFG1, BDF_BIT_SEL_8, 0, 4)
REG32(PCIE0_FUNC_NUM, 0x218)
    FIELD(PCIE0_FUNC_NUM, DBG, 8, 8)
    FIELD(PCIE0_FUNC_NUM, PS, 0, 8)
REG32(CMN_SMID, 0x220)
    FIELD(CMN_SMID, BASE, 0, 10)
REG32(TZPROT, 0x300)
    FIELD(TZPROT, ACTIVE, 0, 1)
REG32(OD_MBIST_RESET_N, 0x420)
    FIELD(OD_MBIST_RESET_N, CPM_POR_HNF_1, 7, 1)
    FIELD(OD_MBIST_RESET_N, CPM_POR_HNF_0, 6, 1)
    FIELD(OD_MBIST_RESET_N, CPM_INT_WRAP, 5, 1)
    FIELD(OD_MBIST_RESET_N, CPM_POR_CXRH_1, 4, 1)
    FIELD(OD_MBIST_RESET_N, CPM_POR_CXRH_0, 3, 1)
    FIELD(OD_MBIST_RESET_N, CPM_PCIEA, 2, 1)
    FIELD(OD_MBIST_RESET_N, PCIEA_DMA, 1, 1)
    FIELD(OD_MBIST_RESET_N, CPM_L2, 0, 1)
REG32(OD_MBIST_PG_EN, 0x424)
    FIELD(OD_MBIST_PG_EN, CPM_POR_HNF_1, 7, 1)
    FIELD(OD_MBIST_PG_EN, CPM_POR_HNF_0, 6, 1)
    FIELD(OD_MBIST_PG_EN, CPM_INT_WRAP, 5, 1)
    FIELD(OD_MBIST_PG_EN, CPM_POR_CXRH_1, 4, 1)
    FIELD(OD_MBIST_PG_EN, CPM_POR_CXRH_0, 3, 1)
    FIELD(OD_MBIST_PG_EN, CPM_PCIEA, 2, 1)
    FIELD(OD_MBIST_PG_EN, PCIEA_DMA, 1, 1)
    FIELD(OD_MBIST_PG_EN, CPM_L2, 0, 1)
REG32(OD_MBIST_SETUP, 0x428)
    FIELD(OD_MBIST_SETUP, CPM_POR_HNF_1, 7, 1)
    FIELD(OD_MBIST_SETUP, CPM_POR_HNF_0, 6, 1)
    FIELD(OD_MBIST_SETUP, CPM_INT_WRAP, 5, 1)
    FIELD(OD_MBIST_SETUP, CPM_POR_CXRH_1, 4, 1)
    FIELD(OD_MBIST_SETUP, CPM_POR_CXRH_0, 3, 1)
    FIELD(OD_MBIST_SETUP, CPM_PCIEA, 2, 1)
    FIELD(OD_MBIST_SETUP, PCIEA_DMA, 1, 1)
    FIELD(OD_MBIST_SETUP, CPM_L2, 0, 1)
REG32(OD_MBIST_DONE, 0x42c)
    FIELD(OD_MBIST_DONE, CPM_POR_HNF_1, 7, 1)
    FIELD(OD_MBIST_DONE, CPM_POR_HNF_0, 6, 1)
    FIELD(OD_MBIST_DONE, CPM_INT_WRAP, 5, 1)
    FIELD(OD_MBIST_DONE, CPM_POR_CXRH_1, 4, 1)
    FIELD(OD_MBIST_DONE, CPM_POR_CXRH_0, 3, 1)
    FIELD(OD_MBIST_DONE, CPM_PCIEA, 2, 1)
    FIELD(OD_MBIST_DONE, PCIEA_DMA, 1, 1)
    FIELD(OD_MBIST_DONE, CPM_L2, 0, 1)
REG32(OD_MBIST_GO, 0x430)
    FIELD(OD_MBIST_GO, CPM_POR_HNF_1, 7, 1)
    FIELD(OD_MBIST_GO, CPM_POR_HNF_0, 6, 1)
    FIELD(OD_MBIST_GO, CPM_INT_WRAP, 5, 1)
    FIELD(OD_MBIST_GO, CPM_POR_CXRH_1, 4, 1)
    FIELD(OD_MBIST_GO, CPM_POR_CXRH_0, 3, 1)
    FIELD(OD_MBIST_GO, CPM_PCIEA, 2, 1)
    FIELD(OD_MBIST_GO, PCIEA_DMA, 1, 1)
    FIELD(OD_MBIST_GO, CPM_L2, 0, 1)

#define CPM_SLCR_SECURE_R_MAX (R_OD_MBIST_GO + 1)

typedef struct CPM_SLCR_SECURE {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir;

    uint32_t regs[CPM_SLCR_SECURE_R_MAX];
    RegisterInfo regs_info[CPM_SLCR_SECURE_R_MAX];
} CPM_SLCR_SECURE;

static void ir_update_irq(CPM_SLCR_SECURE *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static void od_mbist_pg_en_postw(RegisterInfo *reg, uint64_t val64)
{
   CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(reg->opaque);
   uint32_t val = val64;

   s->regs[R_OD_MBIST_DONE] = s->regs[R_OD_MBIST_SETUP] & val;
   s->regs[R_OD_MBIST_GO] = s->regs[R_OD_MBIST_DONE];
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_trigger_prew(RegisterInfo *reg, uint64_t val64)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_STATUS] |= val;
    ir_update_irq(s);
    return 0;
}

static const RegisterAccessInfo cpm_slcr_secure_regs_info[] = {
    {   .name = "WPROT0",  .addr = A_WPROT0,
        .reset = 0x1,
    },{ .name = "REG_CTRL",  .addr = A_REG_CTRL,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_disable_prew,
    },{ .name = "IR_TRIGGER",  .addr = A_IR_TRIGGER,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_trigger_prew,
    },{ .name = "TZ_PCIE",  .addr = A_TZ_PCIE,
        .reset = 0xffffffff,
    },{ .name = "TZ_CPI",  .addr = A_TZ_CPI,
        .reset = 0xf,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "TZ_CRCPM",  .addr = A_TZ_CRCPM,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TZ_SLCR",  .addr = A_TZ_SLCR,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TZ_ADDRREMAP",  .addr = A_TZ_ADDRREMAP,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TZ_MCAP",  .addr = A_TZ_MCAP,
        .reset = 0xf,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "PCIE0_SMID_EN",  .addr = A_PCIE0_SMID_EN,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "PCIE0_SMID_CFG0",  .addr = A_PCIE0_SMID_CFG0,
    },{ .name = "PCIE0_SMID_CFG1",  .addr = A_PCIE0_SMID_CFG1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "PCIE1_SMID_EN",  .addr = A_PCIE1_SMID_EN,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    },{ .name = "PCIE1_SMID_CFG0",  .addr = A_PCIE1_SMID_CFG0,
    },{ .name = "PCIE1_SMID_CFG1",  .addr = A_PCIE1_SMID_CFG1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "PCIE0_FUNC_NUM",  .addr = A_PCIE0_FUNC_NUM,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "CMN_SMID",  .addr = A_CMN_SMID,
    },{ .name = "TZPROT",  .addr = A_TZPROT,
    },{ .name = "OD_MBIST_RESET_N",  .addr = A_OD_MBIST_RESET_N,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "OD_MBIST_PG_EN",  .addr = A_OD_MBIST_PG_EN,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
        .post_write = od_mbist_pg_en_postw,
    },{ .name = "OD_MBIST_SETUP",  .addr = A_OD_MBIST_SETUP,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "OD_MBIST_DONE",  .addr = A_OD_MBIST_DONE,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "OD_MBIST_GO",  .addr = A_OD_MBIST_GO,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    }
};

static void cpm_slcr_secure_reset_enter(Object *obj, ResetType type)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void cpm_slcr_secure_reset_hold(Object *obj)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(obj);

    ir_update_irq(s);
}

static const MemoryRegionOps cpm_slcr_secure_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void cpm_slcr_secure_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void cpm_slcr_secure_init(Object *obj)
{
    CPM_SLCR_SECURE *s = XILINX_CPM_SLCR_SECURE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_CPM_SLCR_SECURE,
                       CPM_SLCR_SECURE_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), cpm_slcr_secure_regs_info,
                              ARRAY_SIZE(cpm_slcr_secure_regs_info),
                              s->regs_info, s->regs,
                              &cpm_slcr_secure_ops,
                              XILINX_CPM_SLCR_SECURE_ERR_DEBUG,
                              CPM_SLCR_SECURE_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir);
}

static const VMStateDescription vmstate_cpm_slcr_secure = {
    .name = TYPE_XILINX_CPM_SLCR_SECURE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, CPM_SLCR_SECURE, CPM_SLCR_SECURE_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void cpm_slcr_secure_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = cpm_slcr_secure_realize;
    dc->vmsd = &vmstate_cpm_slcr_secure;
    rc->phases.enter = cpm_slcr_secure_reset_enter;
    rc->phases.hold = cpm_slcr_secure_reset_hold;
}

static const TypeInfo cpm_slcr_secure_info = {
    .name          = TYPE_XILINX_CPM_SLCR_SECURE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(CPM_SLCR_SECURE),
    .class_init    = cpm_slcr_secure_class_init,
    .instance_init = cpm_slcr_secure_init,
};

static void cpm_slcr_secure_register_types(void)
{
    type_register_static(&cpm_slcr_secure_info);
}

type_init(cpm_slcr_secure_register_types)
