/*
 * QEMU model of the DDRMC_NOC MC that supports DDR4 and LPDDR4
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-09-03.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_DDRMC_NOC_ERR_DEBUG
#define XILINX_DDRMC_NOC_ERR_DEBUG 0
#endif

#define TYPE_XILINX_DDRMC_NOC "xlnx.versal-ddrmc-noc"

#define XILINX_DDRMC_NOC(obj) \
     OBJECT_CHECK(DDRMC_NOC, (obj), TYPE_XILINX_DDRMC_NOC)

REG32(PCSR_LOCK, 0xc)
    FIELD(PCSR_LOCK, STATE, 0, 1)
REG32(REG_NSU_0_ING, 0x10)
    FIELD(REG_NSU_0_ING, BER_VC_VLD, 26, 1)
    FIELD(REG_NSU_0_ING, ISOCR_VC_VLD, 25, 1)
    FIELD(REG_NSU_0_ING, LLR_VC_VLD, 24, 1)
    FIELD(REG_NSU_0_ING, BEW_VC_MAP, 20, 3)
    FIELD(REG_NSU_0_ING, ISOW_VC_MAP, 16, 3)
    FIELD(REG_NSU_0_ING, BER_VC_MAP, 12, 3)
    FIELD(REG_NSU_0_ING, ISOR_VC_MAP, 8, 3)
    FIELD(REG_NSU_0_ING, LLR_VC_MAP, 4, 3)
    FIELD(REG_NSU_0_ING, DBI_EN, 1, 1)
    FIELD(REG_NSU_0_ING, ECC_CHK_EN, 0, 1)
REG32(REG_NSU_0_EGR, 0x14)
    FIELD(REG_NSU_0_EGR, BER_VC_VLD, 22, 1)
    FIELD(REG_NSU_0_EGR, ISOCR_VC_VLD, 21, 1)
    FIELD(REG_NSU_0_EGR, LLR_VC_VLD, 20, 1)
    FIELD(REG_NSU_0_EGR, BEW_VC_MAP, 16, 3)
    FIELD(REG_NSU_0_EGR, ISOW_VC_MAP, 12, 3)
    FIELD(REG_NSU_0_EGR, BER_VC_MAP, 8, 3)
    FIELD(REG_NSU_0_EGR, ISOR_VC_MAP, 4, 3)
    FIELD(REG_NSU_0_EGR, LLR_VC_MAP, 0, 3)
REG32(REG_NSU_1_ING, 0x18)
    FIELD(REG_NSU_1_ING, BER_VC_VLD, 26, 1)
    FIELD(REG_NSU_1_ING, ISOCR_VC_VLD, 25, 1)
    FIELD(REG_NSU_1_ING, LLR_VC_VLD, 24, 1)
    FIELD(REG_NSU_1_ING, BEW_VC_MAP, 20, 3)
    FIELD(REG_NSU_1_ING, ISOW_VC_MAP, 16, 3)
    FIELD(REG_NSU_1_ING, BER_VC_MAP, 12, 3)
    FIELD(REG_NSU_1_ING, ISOR_VC_MAP, 8, 3)
    FIELD(REG_NSU_1_ING, LLR_VC_MAP, 4, 3)
    FIELD(REG_NSU_1_ING, DBI_EN, 1, 1)
    FIELD(REG_NSU_1_ING, ECC_CHK_EN, 0, 1)
REG32(REG_NSU_1_EGR, 0x1c)
    FIELD(REG_NSU_1_EGR, BER_VC_VLD, 22, 1)
    FIELD(REG_NSU_1_EGR, ISOCR_VC_VLD, 21, 1)
    FIELD(REG_NSU_1_EGR, LLR_VC_VLD, 20, 1)
    FIELD(REG_NSU_1_EGR, BEW_VC_MAP, 16, 3)
    FIELD(REG_NSU_1_EGR, ISOW_VC_MAP, 12, 3)
    FIELD(REG_NSU_1_EGR, BER_VC_MAP, 8, 3)
    FIELD(REG_NSU_1_EGR, ISOR_VC_MAP, 4, 3)
    FIELD(REG_NSU_1_EGR, LLR_VC_MAP, 0, 3)
REG32(REG_NSU_2_ING, 0x20)
    FIELD(REG_NSU_2_ING, BER_VC_VLD, 26, 1)
    FIELD(REG_NSU_2_ING, ISOCR_VC_VLD, 25, 1)
    FIELD(REG_NSU_2_ING, LLR_VC_VLD, 24, 1)
    FIELD(REG_NSU_2_ING, BEW_VC_MAP, 20, 3)
    FIELD(REG_NSU_2_ING, ISOW_VC_MAP, 16, 3)
    FIELD(REG_NSU_2_ING, BER_VC_MAP, 12, 3)
    FIELD(REG_NSU_2_ING, ISOR_VC_MAP, 8, 3)
    FIELD(REG_NSU_2_ING, LLR_VC_MAP, 4, 3)
    FIELD(REG_NSU_2_ING, DBI_EN, 1, 1)
    FIELD(REG_NSU_2_ING, ECC_CHK_EN, 0, 1)
REG32(REG_NSU_2_EGR, 0x24)
    FIELD(REG_NSU_2_EGR, BER_VC_VLD, 22, 1)
    FIELD(REG_NSU_2_EGR, ISOCR_VC_VLD, 21, 1)
    FIELD(REG_NSU_2_EGR, LLR_VC_VLD, 20, 1)
    FIELD(REG_NSU_2_EGR, BEW_VC_MAP, 16, 3)
    FIELD(REG_NSU_2_EGR, ISOW_VC_MAP, 12, 3)
    FIELD(REG_NSU_2_EGR, BER_VC_MAP, 8, 3)
    FIELD(REG_NSU_2_EGR, ISOR_VC_MAP, 4, 3)
    FIELD(REG_NSU_2_EGR, LLR_VC_MAP, 0, 3)
REG32(REG_NSU_3_ING, 0x28)
    FIELD(REG_NSU_3_ING, BER_VC_VLD, 26, 1)
    FIELD(REG_NSU_3_ING, ISOCR_VC_VLD, 25, 1)
    FIELD(REG_NSU_3_ING, LLR_VC_VLD, 24, 1)
    FIELD(REG_NSU_3_ING, BEW_VC_MAP, 20, 3)
    FIELD(REG_NSU_3_ING, ISOW_VC_MAP, 16, 3)
    FIELD(REG_NSU_3_ING, BER_VC_MAP, 12, 3)
    FIELD(REG_NSU_3_ING, ISOR_VC_MAP, 8, 3)
    FIELD(REG_NSU_3_ING, LLR_VC_MAP, 4, 3)
    FIELD(REG_NSU_3_ING, DBI_EN, 1, 1)
    FIELD(REG_NSU_3_ING, ECC_CHK_EN, 0, 1)
REG32(REG_NSU_3_EGR, 0x2c)
    FIELD(REG_NSU_3_EGR, BER_VC_VLD, 22, 1)
    FIELD(REG_NSU_3_EGR, ISOCR_VC_VLD, 21, 1)
    FIELD(REG_NSU_3_EGR, LLR_VC_VLD, 20, 1)
    FIELD(REG_NSU_3_EGR, BEW_VC_MAP, 16, 3)
    FIELD(REG_NSU_3_EGR, ISOW_VC_MAP, 12, 3)
    FIELD(REG_NSU_3_EGR, BER_VC_MAP, 8, 3)
    FIELD(REG_NSU_3_EGR, ISOR_VC_MAP, 4, 3)
    FIELD(REG_NSU_3_EGR, LLR_VC_MAP, 0, 3)
REG32(DC_CMD_CREDITS, 0x30)
    FIELD(DC_CMD_CREDITS, MIN_CREDITS, 6, 6)
    FIELD(DC_CMD_CREDITS, INIT_CREDITS, 0, 6)
REG32(REG_ADEC0, 0x34)
    FIELD(REG_ADEC0, LOW_MEM_BASE, 0, 20)
REG32(REG_ADEC1, 0x38)
    FIELD(REG_ADEC1, LOW_MEM_OFFSET, 0, 20)
REG32(REG_ADEC2, 0x3c)
    FIELD(REG_ADEC2, HIGH_MEM_EN, 20, 1)
    FIELD(REG_ADEC2, HIGH_MEM_BASE, 0, 20)
REG32(REG_ADEC3, 0x40)
    FIELD(REG_ADEC3, HIGH_MEM_OFFSET, 0, 20)
REG32(REG_ADEC4, 0x44)
    FIELD(REG_ADEC4, LRANK_2, 24, 6)
    FIELD(REG_ADEC4, LRANK_1, 18, 6)
    FIELD(REG_ADEC4, LRANK_0, 12, 6)
    FIELD(REG_ADEC4, RANK_1, 6, 6)
    FIELD(REG_ADEC4, RANK_0, 0, 6)
REG32(REG_ADEC5, 0x48)
    FIELD(REG_ADEC5, ROW_4, 24, 6)
    FIELD(REG_ADEC5, ROW_3, 18, 6)
    FIELD(REG_ADEC5, ROW_2, 12, 6)
    FIELD(REG_ADEC5, ROW_1, 6, 6)
    FIELD(REG_ADEC5, ROW_0, 0, 6)
REG32(REG_ADEC6, 0x4c)
    FIELD(REG_ADEC6, ROW_9, 24, 6)
    FIELD(REG_ADEC6, ROW_8, 18, 6)
    FIELD(REG_ADEC6, ROW_7, 12, 6)
    FIELD(REG_ADEC6, ROW_6, 6, 6)
    FIELD(REG_ADEC6, ROW_5, 0, 6)
REG32(REG_ADEC7, 0x50)
    FIELD(REG_ADEC7, ROW_14, 24, 6)
    FIELD(REG_ADEC7, ROW_13, 18, 6)
    FIELD(REG_ADEC7, ROW_12, 12, 6)
    FIELD(REG_ADEC7, ROW_11, 6, 6)
    FIELD(REG_ADEC7, ROW_10, 0, 6)
REG32(REG_ADEC8, 0x54)
    FIELD(REG_ADEC8, COL_0, 24, 6)
    FIELD(REG_ADEC8, ROW_18, 18, 6)
    FIELD(REG_ADEC8, ROW_17, 12, 6)
    FIELD(REG_ADEC8, ROW_16, 6, 6)
    FIELD(REG_ADEC8, ROW_15, 0, 6)
REG32(REG_ADEC9, 0x58)
    FIELD(REG_ADEC9, COL_5, 24, 6)
    FIELD(REG_ADEC9, COL_4, 18, 6)
    FIELD(REG_ADEC9, COL_3, 12, 6)
    FIELD(REG_ADEC9, COL_2, 6, 6)
    FIELD(REG_ADEC9, COL_1, 0, 6)
REG32(REG_ADEC10, 0x5c)
    FIELD(REG_ADEC10, BANK_0, 24, 6)
    FIELD(REG_ADEC10, COL_9, 18, 6)
    FIELD(REG_ADEC10, COL_8, 12, 6)
    FIELD(REG_ADEC10, COL_7, 6, 6)
    FIELD(REG_ADEC10, COL_6, 0, 6)
REG32(REG_ADEC11, 0x60)
    FIELD(REG_ADEC11, CH_SEL, 18, 6)
    FIELD(REG_ADEC11, GROUP_1, 12, 6)
    FIELD(REG_ADEC11, GROUP_0, 6, 6)
    FIELD(REG_ADEC11, BANK_1, 0, 6)
REG32(REG_NSU0_PORT, 0x64)
    FIELD(REG_NSU0_PORT, SRC_ID, 0, 12)
REG32(REG_NSU1_PORT, 0x68)
    FIELD(REG_NSU1_PORT, SRC_ID, 0, 12)
REG32(REG_NSU2_PORT, 0x6c)
    FIELD(REG_NSU2_PORT, SRC_ID, 0, 12)
REG32(REG_NSU3_PORT, 0x70)
    FIELD(REG_NSU3_PORT, SRC_ID, 0, 12)
REG32(REG_NSU_0_R_EGR, 0x400)
    FIELD(REG_NSU_0_R_EGR, BER_VC_TOKEN, 20, 8)
    FIELD(REG_NSU_0_R_EGR, ISOCR_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_0_R_EGR, LLR_VC_TOKEN, 4, 8)
REG32(REG_NSU_0_W_EGR, 0x404)
    FIELD(REG_NSU_0_W_EGR, BEW_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_0_W_EGR, ISOCW_VC_TOKEN, 4, 8)
REG32(REG_NSU_1_R_EGR, 0x408)
    FIELD(REG_NSU_1_R_EGR, BER_VC_TOKEN, 20, 8)
    FIELD(REG_NSU_1_R_EGR, ISOCR_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_1_R_EGR, LLR_VC_TOKEN, 4, 8)
REG32(REG_NSU_1_W_EGR, 0x40c)
    FIELD(REG_NSU_1_W_EGR, BEW_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_1_W_EGR, ISOCW_VC_TOKEN, 4, 8)
REG32(REG_NSU_2_R_EGR, 0x410)
    FIELD(REG_NSU_2_R_EGR, BER_VC_TOKEN, 20, 8)
    FIELD(REG_NSU_2_R_EGR, ISOCR_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_2_R_EGR, LLR_VC_TOKEN, 4, 8)
REG32(REG_NSU_2_W_EGR, 0x414)
    FIELD(REG_NSU_2_W_EGR, BEW_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_2_W_EGR, ISOCW_VC_TOKEN, 4, 8)
REG32(REG_NSU_3_R_EGR, 0x418)
    FIELD(REG_NSU_3_R_EGR, BER_VC_TOKEN, 20, 8)
    FIELD(REG_NSU_3_R_EGR, ISOCR_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_3_R_EGR, LLR_VC_TOKEN, 4, 8)
REG32(REG_NSU_3_W_EGR, 0x41c)
    FIELD(REG_NSU_3_W_EGR, BEW_VC_TOKEN, 12, 8)
    FIELD(REG_NSU_3_W_EGR, ISOCW_VC_TOKEN, 4, 8)
REG32(REG_RD_DRR_TKN_P0, 0x420)
    FIELD(REG_RD_DRR_TKN_P0, BER, 16, 8)
    FIELD(REG_RD_DRR_TKN_P0, ISOCR, 8, 8)
    FIELD(REG_RD_DRR_TKN_P0, LLR, 0, 8)
REG32(REG_WR_DRR_TKN_P0, 0x424)
    FIELD(REG_WR_DRR_TKN_P0, BEW, 8, 8)
    FIELD(REG_WR_DRR_TKN_P0, ISOCW, 0, 8)
REG32(REG_RD_DRR_TKN_P1, 0x428)
    FIELD(REG_RD_DRR_TKN_P1, BER, 16, 8)
    FIELD(REG_RD_DRR_TKN_P1, ISOCR, 8, 8)
    FIELD(REG_RD_DRR_TKN_P1, LLR, 0, 8)
REG32(REG_WR_DRR_TKN_P1, 0x42c)
    FIELD(REG_WR_DRR_TKN_P1, BEW, 8, 8)
    FIELD(REG_WR_DRR_TKN_P1, ISOCW, 0, 8)
REG32(REG_RD_DRR_TKN_P2, 0x430)
    FIELD(REG_RD_DRR_TKN_P2, BER, 16, 8)
    FIELD(REG_RD_DRR_TKN_P2, ISOCR, 8, 8)
    FIELD(REG_RD_DRR_TKN_P2, LLR, 0, 8)
REG32(REG_WR_DRR_TKN_P2, 0x434)
    FIELD(REG_WR_DRR_TKN_P2, BEW, 8, 8)
    FIELD(REG_WR_DRR_TKN_P2, ISOCW, 0, 8)
REG32(REG_RD_DRR_TKN_P3, 0x438)
    FIELD(REG_RD_DRR_TKN_P3, BER, 16, 8)
    FIELD(REG_RD_DRR_TKN_P3, ISOCR, 8, 8)
    FIELD(REG_RD_DRR_TKN_P3, LLR, 0, 8)
REG32(REG_WR_DRR_TKN_P3, 0x43c)
    FIELD(REG_WR_DRR_TKN_P3, BEW, 8, 8)
    FIELD(REG_WR_DRR_TKN_P3, ISOCW, 0, 8)
REG32(REG_QOS0, 0x440)
    FIELD(REG_QOS0, WR_THRSHOLD, 16, 12)
    FIELD(REG_QOS0, RD_THRSHOLD, 4, 12)
    FIELD(REG_QOS0, ARB_MODE, 0, 1)
REG32(REG_QOS1, 0x444)
    FIELD(REG_QOS1, BER_TOKEN, 20, 10)
    FIELD(REG_QOS1, ISOR_TOKEN, 10, 10)
    FIELD(REG_QOS1, LLR_TOKEN, 0, 10)
REG32(REG_QOS2, 0x448)
    FIELD(REG_QOS2, BEW_TOKEN, 10, 10)
    FIELD(REG_QOS2, ISOW_TOKEN, 0, 10)
REG32(REG_QOS_TIMEOUT0, 0x44c)
    FIELD(REG_QOS_TIMEOUT0, BEW_SCALE, 20, 5)
    FIELD(REG_QOS_TIMEOUT0, ISW_SCALE, 15, 5)
    FIELD(REG_QOS_TIMEOUT0, BER_SCALE, 10, 5)
    FIELD(REG_QOS_TIMEOUT0, ISR_SCALE, 5, 5)
    FIELD(REG_QOS_TIMEOUT0, LLR_SCALE, 0, 5)
REG32(REG_QOS_TIMEOUT1, 0x450)
    FIELD(REG_QOS_TIMEOUT1, ISOW_TIMEOUT, 24, 8)
    FIELD(REG_QOS_TIMEOUT1, BER_TIMEOUT, 16, 8)
    FIELD(REG_QOS_TIMEOUT1, ISOR_TIMEOUT, 8, 8)
    FIELD(REG_QOS_TIMEOUT1, LLR_TIMEOUT, 0, 8)
REG32(REG_QOS_TIMEOUT2, 0x454)
    FIELD(REG_QOS_TIMEOUT2, BEW_TIMEOUT, 0, 8)
REG32(REG_RATE_CTRL_SCALE, 0x458)
    FIELD(REG_RATE_CTRL_SCALE, BEW_UPDATE_PERIOD, 20, 5)
    FIELD(REG_RATE_CTRL_SCALE, ISW_UPDATE_PERIOD, 15, 5)
    FIELD(REG_RATE_CTRL_SCALE, BER_UPDATE_PERIOD, 10, 5)
    FIELD(REG_RATE_CTRL_SCALE, ISR_UPDATE_PERIOD, 5, 5)
    FIELD(REG_RATE_CTRL_SCALE, LLR_UPDATE_PERIOD, 0, 5)
REG32(REG_P0_LLR_RATE_CTRL, 0x45c)
    FIELD(REG_P0_LLR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P0_LLR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P0_ISR_RATE_CTRL, 0x460)
    FIELD(REG_P0_ISR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P0_ISR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P0_BER_RATE_CTRL, 0x464)
    FIELD(REG_P0_BER_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P0_BER_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P0_ISW_RATE_CTRL, 0x468)
    FIELD(REG_P0_ISW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P0_ISW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P0_BEW_RATE_CTRL, 0x46c)
    FIELD(REG_P0_BEW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P0_BEW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P1_LLR_RATE_CTRL, 0x470)
    FIELD(REG_P1_LLR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P1_LLR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P1_ISR_RATE_CTRL, 0x474)
    FIELD(REG_P1_ISR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P1_ISR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P1_BER_RATE_CTRL, 0x478)
    FIELD(REG_P1_BER_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P1_BER_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P1_ISW_RATE_CTRL, 0x47c)
    FIELD(REG_P1_ISW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P1_ISW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P1_BEW_RATE_CTRL, 0x480)
    FIELD(REG_P1_BEW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P1_BEW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P2_LLR_RATE_CTRL, 0x484)
    FIELD(REG_P2_LLR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P2_LLR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P2_ISR_RATE_CTRL, 0x488)
    FIELD(REG_P2_ISR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P2_ISR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P2_BER_RATE_CTRL, 0x48c)
    FIELD(REG_P2_BER_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P2_BER_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P2_ISW_RATE_CTRL, 0x490)
    FIELD(REG_P2_ISW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P2_ISW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P2_BEW_RATE_CTRL, 0x494)
    FIELD(REG_P2_BEW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P2_BEW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P3_LLR_RATE_CTRL, 0x498)
    FIELD(REG_P3_LLR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P3_LLR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P3_ISR_RATE_CTRL, 0x49c)
    FIELD(REG_P3_ISR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P3_ISR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P3_BER_RATE_CTRL, 0x4a0)
    FIELD(REG_P3_BER_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P3_BER_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P3_ISW_RATE_CTRL, 0x4a4)
    FIELD(REG_P3_ISW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P3_ISW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_P3_BEW_RATE_CTRL, 0x4a8)
    FIELD(REG_P3_BEW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_P3_BEW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_CMDQ_CTRL0, 0x4ac)
    FIELD(REG_CMDQ_CTRL0, BEW_THRESHOLD_CH0, 20, 5)
    FIELD(REG_CMDQ_CTRL0, ISW_THRESHOLD_CH0, 15, 5)
    FIELD(REG_CMDQ_CTRL0, BER_THRESHOLD_CH0, 10, 5)
    FIELD(REG_CMDQ_CTRL0, ISR_THRESHOLD_CH0, 5, 5)
    FIELD(REG_CMDQ_CTRL0, LLR_THRESHOLD_CH0, 0, 5)
REG32(REG_CMDQ_CTRL1, 0x4b0)
    FIELD(REG_CMDQ_CTRL1, BEW_THRESHOLD_CH1, 20, 5)
    FIELD(REG_CMDQ_CTRL1, ISW_THRESHOLD_CH1, 15, 5)
    FIELD(REG_CMDQ_CTRL1, BER_THRESHOLD_CH1, 10, 5)
    FIELD(REG_CMDQ_CTRL1, ISR_THRESHOLD_CH1, 5, 5)
    FIELD(REG_CMDQ_CTRL1, LLR_THRESHOLD_CH1, 0, 5)
REG32(REG_CMDQ_LLR_RATE_CTRL, 0x4b4)
    FIELD(REG_CMDQ_LLR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_CMDQ_LLR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_CMDQ_ISR_RATE_CTRL, 0x4b8)
    FIELD(REG_CMDQ_ISR_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_CMDQ_ISR_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_CMDQ_BER_RATE_CTRL, 0x4bc)
    FIELD(REG_CMDQ_BER_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_CMDQ_BER_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_CMDQ_ISW_RATE_CTRL, 0x4c0)
    FIELD(REG_CMDQ_ISW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_CMDQ_ISW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_CMDQ_BEW_RATE_CTRL, 0x4c4)
    FIELD(REG_CMDQ_BEW_RATE_CTRL, CREDIT_LIMIT, 10, 12)
    FIELD(REG_CMDQ_BEW_RATE_CTRL, CREDIT_UPDATE, 0, 10)
REG32(REG_QOS_RATE_CTRL_SCALE, 0x4c8)
    FIELD(REG_QOS_RATE_CTRL_SCALE, BEW_UPDATE_PERIOD, 20, 5)
    FIELD(REG_QOS_RATE_CTRL_SCALE, ISW_UPDATE_PERIOD, 15, 5)
    FIELD(REG_QOS_RATE_CTRL_SCALE, BER_UPDATE_PERIOD, 10, 5)
    FIELD(REG_QOS_RATE_CTRL_SCALE, ISR_UPDATE_PERIOD, 5, 5)
    FIELD(REG_QOS_RATE_CTRL_SCALE, LLR_UPDATE_PERIOD, 0, 5)
REG32(EXMON_CLR_EXE, 0x4cc)
    FIELD(EXMON_CLR_EXE, AXSIZE_BASED_CHECK, 8, 1)
    FIELD(EXMON_CLR_EXE, MON_7, 7, 1)
    FIELD(EXMON_CLR_EXE, MON_6, 6, 1)
    FIELD(EXMON_CLR_EXE, MON_5, 5, 1)
    FIELD(EXMON_CLR_EXE, MON_4, 4, 1)
    FIELD(EXMON_CLR_EXE, MON_3, 3, 1)
    FIELD(EXMON_CLR_EXE, MON_2, 2, 1)
    FIELD(EXMON_CLR_EXE, MON_1, 1, 1)
    FIELD(EXMON_CLR_EXE, MON_0, 0, 1)
REG32(UB_CLK_MUX, 0x4d0)
    FIELD(UB_CLK_MUX, SEL, 0, 2)
REG32(PERF_MON_TIMEBASE_SCALE, 0x4d4)
    FIELD(PERF_MON_TIMEBASE_SCALE, TB3_SCALE, 15, 5)
    FIELD(PERF_MON_TIMEBASE_SCALE, TB2_SCALE, 10, 5)
    FIELD(PERF_MON_TIMEBASE_SCALE, TB1_SCALE, 5, 5)
    FIELD(PERF_MON_TIMEBASE_SCALE, TB0_SCALE, 0, 5)
REG32(NSU0_PERF_MON_CTL_0_0, 0x4d8)
    FIELD(NSU0_PERF_MON_CTL_0_0, SNGL, 1, 1)
    FIELD(NSU0_PERF_MON_CTL_0_0, MON_EN, 0, 1)
REG32(NSU0_PERF_MON_CTL_0_1, 0x4dc)
    FIELD(NSU0_PERF_MON_CTL_0_1, BEW, 7, 1)
    FIELD(NSU0_PERF_MON_CTL_0_1, ISOW, 6, 1)
    FIELD(NSU0_PERF_MON_CTL_0_1, BER, 5, 1)
    FIELD(NSU0_PERF_MON_CTL_0_1, ISOR, 4, 1)
    FIELD(NSU0_PERF_MON_CTL_0_1, LLR, 3, 1)
    FIELD(NSU0_PERF_MON_CTL_0_1, LAT_SEL, 2, 1)
    FIELD(NSU0_PERF_MON_CTL_0_1, TB_SEL, 0, 2)
REG32(NSU0_PERF_FILTER_0_0, 0x4e0)
    FIELD(NSU0_PERF_FILTER_0_0, AXLOCK, 29, 1)
    FIELD(NSU0_PERF_FILTER_0_0, AXPROT, 26, 3)
    FIELD(NSU0_PERF_FILTER_0_0, AXBURST, 24, 2)
    FIELD(NSU0_PERF_FILTER_0_0, AXLEN_MAX, 20, 4)
    FIELD(NSU0_PERF_FILTER_0_0, AXLEN_MIN, 16, 4)
    FIELD(NSU0_PERF_FILTER_0_0, AXID, 0, 16)
REG32(NSU0_PERF_FILTER_0_1, 0x4e4)
    FIELD(NSU0_PERF_FILTER_0_1, SRC_ID, 0, 12)
REG32(NSU0_PERF_FILTER_EN_0, 0x4e8)
    FIELD(NSU0_PERF_FILTER_EN_0, SRC_ID, 5, 1)
    FIELD(NSU0_PERF_FILTER_EN_0, AXLOCK, 4, 1)
    FIELD(NSU0_PERF_FILTER_EN_0, AXPROT, 3, 1)
    FIELD(NSU0_PERF_FILTER_EN_0, AXBURST, 2, 1)
    FIELD(NSU0_PERF_FILTER_EN_0, AXLEN, 1, 1)
    FIELD(NSU0_PERF_FILTER_EN_0, AXID, 0, 1)
REG32(NSU0_PERF_MON_0_0, 0x4ec)
    FIELD(NSU0_PERF_MON_0_0, LAT_OVF, 31, 1)
    FIELD(NSU0_PERF_MON_0_0, LAT, 0, 31)
REG32(NSU0_PERF_MON_0_1, 0x4f0)
    FIELD(NSU0_PERF_MON_0_1, BURST_OVF, 31, 1)
    FIELD(NSU0_PERF_MON_0_1, BURST, 0, 31)
REG32(NSU0_PERF_MON_0_2, 0x4f4)
    FIELD(NSU0_PERF_MON_0_2, HEADER_OVF, 31, 1)
    FIELD(NSU0_PERF_MON_0_2, HEADER, 0, 31)
REG32(NSU0_PERF_MON_CTL_1_0, 0x4f8)
    FIELD(NSU0_PERF_MON_CTL_1_0, SNGL, 1, 1)
    FIELD(NSU0_PERF_MON_CTL_1_0, MON_EN, 0, 1)
REG32(NSU0_PERF_MON_CTL_1_1, 0x4fc)
    FIELD(NSU0_PERF_MON_CTL_1_1, BEW, 7, 1)
    FIELD(NSU0_PERF_MON_CTL_1_1, ISOW, 6, 1)
    FIELD(NSU0_PERF_MON_CTL_1_1, BER, 5, 1)
    FIELD(NSU0_PERF_MON_CTL_1_1, ISOR, 4, 1)
    FIELD(NSU0_PERF_MON_CTL_1_1, LLR, 3, 1)
    FIELD(NSU0_PERF_MON_CTL_1_1, LAT_SEL, 2, 1)
    FIELD(NSU0_PERF_MON_CTL_1_1, TB_SEL, 0, 2)
REG32(NSU0_PERF_FILTER_1_0, 0x500)
    FIELD(NSU0_PERF_FILTER_1_0, AXLOCK, 29, 1)
    FIELD(NSU0_PERF_FILTER_1_0, AXPROT, 26, 3)
    FIELD(NSU0_PERF_FILTER_1_0, AXBURST, 24, 2)
    FIELD(NSU0_PERF_FILTER_1_0, AXLEN_MAX, 20, 4)
    FIELD(NSU0_PERF_FILTER_1_0, AXLEN_MIN, 16, 4)
    FIELD(NSU0_PERF_FILTER_1_0, AXID, 0, 16)
REG32(NSU0_PERF_FILTER_1_1, 0x504)
    FIELD(NSU0_PERF_FILTER_1_1, SRC_ID, 0, 12)
REG32(NSU0_PERF_FILTER_EN_1, 0x508)
    FIELD(NSU0_PERF_FILTER_EN_1, SRC_ID, 5, 1)
    FIELD(NSU0_PERF_FILTER_EN_1, AXLOCK, 4, 1)
    FIELD(NSU0_PERF_FILTER_EN_1, AXPROT, 3, 1)
    FIELD(NSU0_PERF_FILTER_EN_1, AXBURST, 2, 1)
    FIELD(NSU0_PERF_FILTER_EN_1, AXLEN, 1, 1)
    FIELD(NSU0_PERF_FILTER_EN_1, AXID, 0, 1)
REG32(NSU0_PERF_MON_1_0, 0x50c)
    FIELD(NSU0_PERF_MON_1_0, LAT_OVF, 31, 1)
    FIELD(NSU0_PERF_MON_1_0, LAT, 0, 31)
REG32(NSU0_PERF_MON_1_1, 0x510)
    FIELD(NSU0_PERF_MON_1_1, BURST_OVF, 31, 1)
    FIELD(NSU0_PERF_MON_1_1, BURST, 0, 31)
REG32(NSU0_PERF_MON_1_2, 0x514)
    FIELD(NSU0_PERF_MON_1_2, HEADER_OVF, 31, 1)
    FIELD(NSU0_PERF_MON_1_2, HEADER, 0, 31)
REG32(NSU1_PERF_MON_CTL_0_0, 0x518)
    FIELD(NSU1_PERF_MON_CTL_0_0, SNGL, 1, 1)
    FIELD(NSU1_PERF_MON_CTL_0_0, MON_EN, 0, 1)
REG32(NSU1_PERF_MON_CTL_0_1, 0x51c)
    FIELD(NSU1_PERF_MON_CTL_0_1, BEW, 7, 1)
    FIELD(NSU1_PERF_MON_CTL_0_1, ISOW, 6, 1)
    FIELD(NSU1_PERF_MON_CTL_0_1, BER, 5, 1)
    FIELD(NSU1_PERF_MON_CTL_0_1, ISOR, 4, 1)
    FIELD(NSU1_PERF_MON_CTL_0_1, LLR, 3, 1)
    FIELD(NSU1_PERF_MON_CTL_0_1, LAT_SEL, 2, 1)
    FIELD(NSU1_PERF_MON_CTL_0_1, TB_SEL, 0, 2)
REG32(NSU1_PERF_FILTER_0_0, 0x520)
    FIELD(NSU1_PERF_FILTER_0_0, AXLOCK, 29, 1)
    FIELD(NSU1_PERF_FILTER_0_0, AXPROT, 26, 3)
    FIELD(NSU1_PERF_FILTER_0_0, AXBURST, 24, 2)
    FIELD(NSU1_PERF_FILTER_0_0, AXLEN_MAX, 20, 4)
    FIELD(NSU1_PERF_FILTER_0_0, AXLEN_MIN, 16, 4)
    FIELD(NSU1_PERF_FILTER_0_0, AXID, 0, 16)
REG32(NSU1_PERF_FILTER_0_1, 0x524)
    FIELD(NSU1_PERF_FILTER_0_1, SRC_ID, 0, 12)
REG32(NSU1_PERF_FILTER_EN_0, 0x528)
    FIELD(NSU1_PERF_FILTER_EN_0, SRC_ID, 5, 1)
    FIELD(NSU1_PERF_FILTER_EN_0, AXLOCK, 4, 1)
    FIELD(NSU1_PERF_FILTER_EN_0, AXPROT, 3, 1)
    FIELD(NSU1_PERF_FILTER_EN_0, AXBURST, 2, 1)
    FIELD(NSU1_PERF_FILTER_EN_0, AXLEN, 1, 1)
    FIELD(NSU1_PERF_FILTER_EN_0, AXID, 0, 1)
REG32(NSU1_PERF_MON_0_0, 0x52c)
    FIELD(NSU1_PERF_MON_0_0, LAT_OVF, 31, 1)
    FIELD(NSU1_PERF_MON_0_0, LAT, 0, 31)
REG32(NSU1_PERF_MON_0_1, 0x530)
    FIELD(NSU1_PERF_MON_0_1, BURST_OVF, 31, 1)
    FIELD(NSU1_PERF_MON_0_1, BURST, 0, 31)
REG32(NSU1_PERF_MON_0_2, 0x534)
    FIELD(NSU1_PERF_MON_0_2, HEADER_OVF, 31, 1)
    FIELD(NSU1_PERF_MON_0_2, HEADER, 0, 31)
REG32(NSU1_PERF_MON_CTL_1_0, 0x538)
    FIELD(NSU1_PERF_MON_CTL_1_0, SNGL, 1, 1)
    FIELD(NSU1_PERF_MON_CTL_1_0, MON_EN, 0, 1)
REG32(NSU1_PERF_MON_CTL_1_1, 0x53c)
    FIELD(NSU1_PERF_MON_CTL_1_1, BEW, 7, 1)
    FIELD(NSU1_PERF_MON_CTL_1_1, ISOW, 6, 1)
    FIELD(NSU1_PERF_MON_CTL_1_1, BER, 5, 1)
    FIELD(NSU1_PERF_MON_CTL_1_1, ISOR, 4, 1)
    FIELD(NSU1_PERF_MON_CTL_1_1, LLR, 3, 1)
    FIELD(NSU1_PERF_MON_CTL_1_1, LAT_SEL, 2, 1)
    FIELD(NSU1_PERF_MON_CTL_1_1, TB_SEL, 0, 2)
REG32(NSU1_PERF_FILTER_1_0, 0x540)
    FIELD(NSU1_PERF_FILTER_1_0, AXLOCK, 29, 1)
    FIELD(NSU1_PERF_FILTER_1_0, AXPROT, 26, 3)
    FIELD(NSU1_PERF_FILTER_1_0, AXBURST, 24, 2)
    FIELD(NSU1_PERF_FILTER_1_0, AXLEN_MAX, 20, 4)
    FIELD(NSU1_PERF_FILTER_1_0, AXLEN_MIN, 16, 4)
    FIELD(NSU1_PERF_FILTER_1_0, AXID, 0, 16)
REG32(NSU1_PERF_FILTER_1_1, 0x544)
    FIELD(NSU1_PERF_FILTER_1_1, SRC_ID, 0, 12)
REG32(NSU1_PERF_FILTER_EN_1, 0x548)
    FIELD(NSU1_PERF_FILTER_EN_1, SRC_ID, 5, 1)
    FIELD(NSU1_PERF_FILTER_EN_1, AXLOCK, 4, 1)
    FIELD(NSU1_PERF_FILTER_EN_1, AXPROT, 3, 1)
    FIELD(NSU1_PERF_FILTER_EN_1, AXBURST, 2, 1)
    FIELD(NSU1_PERF_FILTER_EN_1, AXLEN, 1, 1)
    FIELD(NSU1_PERF_FILTER_EN_1, AXID, 0, 1)
REG32(NSU1_PERF_MON_1_0, 0x54c)
    FIELD(NSU1_PERF_MON_1_0, LAT_OVF, 31, 1)
    FIELD(NSU1_PERF_MON_1_0, LAT, 0, 31)
REG32(NSU1_PERF_MON_1_1, 0x550)
    FIELD(NSU1_PERF_MON_1_1, BURST_OVF, 31, 1)
    FIELD(NSU1_PERF_MON_1_1, BURST, 0, 31)
REG32(NSU1_PERF_MON_1_2, 0x554)
    FIELD(NSU1_PERF_MON_1_2, HEADER_OVF, 31, 1)
    FIELD(NSU1_PERF_MON_1_2, HEADER, 0, 31)
REG32(NSU2_PERF_MON_CTL_0_0, 0x558)
    FIELD(NSU2_PERF_MON_CTL_0_0, SNGL, 1, 1)
    FIELD(NSU2_PERF_MON_CTL_0_0, MON_EN, 0, 1)
REG32(NSU2_PERF_MON_CTL_0_1, 0x55c)
    FIELD(NSU2_PERF_MON_CTL_0_1, BEW, 7, 1)
    FIELD(NSU2_PERF_MON_CTL_0_1, ISOW, 6, 1)
    FIELD(NSU2_PERF_MON_CTL_0_1, BER, 5, 1)
    FIELD(NSU2_PERF_MON_CTL_0_1, ISOR, 4, 1)
    FIELD(NSU2_PERF_MON_CTL_0_1, LLR, 3, 1)
    FIELD(NSU2_PERF_MON_CTL_0_1, LAT_SEL, 2, 1)
    FIELD(NSU2_PERF_MON_CTL_0_1, TB_SEL, 0, 2)
REG32(NSU2_PERF_FILTER_0_0, 0x560)
    FIELD(NSU2_PERF_FILTER_0_0, AXLOCK, 29, 1)
    FIELD(NSU2_PERF_FILTER_0_0, AXPROT, 26, 3)
    FIELD(NSU2_PERF_FILTER_0_0, AXBURST, 24, 2)
    FIELD(NSU2_PERF_FILTER_0_0, AXLEN_MAX, 20, 4)
    FIELD(NSU2_PERF_FILTER_0_0, AXLEN_MIN, 16, 4)
    FIELD(NSU2_PERF_FILTER_0_0, AXID, 0, 16)
REG32(NSU2_PERF_FILTER_0_1, 0x564)
    FIELD(NSU2_PERF_FILTER_0_1, SRC_ID, 0, 12)
REG32(NSU2_PERF_FILTER_EN_0, 0x568)
    FIELD(NSU2_PERF_FILTER_EN_0, SRC_ID, 5, 1)
    FIELD(NSU2_PERF_FILTER_EN_0, AXLOCK, 4, 1)
    FIELD(NSU2_PERF_FILTER_EN_0, AXPROT, 3, 1)
    FIELD(NSU2_PERF_FILTER_EN_0, AXBURST, 2, 1)
    FIELD(NSU2_PERF_FILTER_EN_0, AXLEN, 1, 1)
    FIELD(NSU2_PERF_FILTER_EN_0, AXID, 0, 1)
REG32(NSU2_PERF_MON_0_0, 0x56c)
    FIELD(NSU2_PERF_MON_0_0, LAT_OVF, 31, 1)
    FIELD(NSU2_PERF_MON_0_0, LAT, 0, 31)
REG32(NSU2_PERF_MON_0_1, 0x570)
    FIELD(NSU2_PERF_MON_0_1, BURST_OVF, 31, 1)
    FIELD(NSU2_PERF_MON_0_1, BURST, 0, 31)
REG32(NSU2_PERF_MON_0_2, 0x574)
    FIELD(NSU2_PERF_MON_0_2, HEADER_OVF, 31, 1)
    FIELD(NSU2_PERF_MON_0_2, HEADER, 0, 31)
REG32(NSU2_PERF_MON_CTL_1_0, 0x578)
    FIELD(NSU2_PERF_MON_CTL_1_0, SNGL, 1, 1)
    FIELD(NSU2_PERF_MON_CTL_1_0, MON_EN, 0, 1)
REG32(NSU2_PERF_MON_CTL_1_1, 0x57c)
    FIELD(NSU2_PERF_MON_CTL_1_1, BEW, 7, 1)
    FIELD(NSU2_PERF_MON_CTL_1_1, ISOW, 6, 1)
    FIELD(NSU2_PERF_MON_CTL_1_1, BER, 5, 1)
    FIELD(NSU2_PERF_MON_CTL_1_1, ISOR, 4, 1)
    FIELD(NSU2_PERF_MON_CTL_1_1, LLR, 3, 1)
    FIELD(NSU2_PERF_MON_CTL_1_1, LAT_SEL, 2, 1)
    FIELD(NSU2_PERF_MON_CTL_1_1, TB_SEL, 0, 2)
REG32(NSU2_PERF_FILTER_1_0, 0x580)
    FIELD(NSU2_PERF_FILTER_1_0, AXLOCK, 29, 1)
    FIELD(NSU2_PERF_FILTER_1_0, AXPROT, 26, 3)
    FIELD(NSU2_PERF_FILTER_1_0, AXBURST, 24, 2)
    FIELD(NSU2_PERF_FILTER_1_0, AXLEN_MAX, 20, 4)
    FIELD(NSU2_PERF_FILTER_1_0, AXLEN_MIN, 16, 4)
    FIELD(NSU2_PERF_FILTER_1_0, AXID, 0, 16)
REG32(NSU2_PERF_FILTER_1_1, 0x584)
    FIELD(NSU2_PERF_FILTER_1_1, SRC_ID, 0, 12)
REG32(NSU2_PERF_FILTER_EN_1, 0x588)
    FIELD(NSU2_PERF_FILTER_EN_1, SRC_ID, 5, 1)
    FIELD(NSU2_PERF_FILTER_EN_1, AXLOCK, 4, 1)
    FIELD(NSU2_PERF_FILTER_EN_1, AXPROT, 3, 1)
    FIELD(NSU2_PERF_FILTER_EN_1, AXBURST, 2, 1)
    FIELD(NSU2_PERF_FILTER_EN_1, AXLEN, 1, 1)
    FIELD(NSU2_PERF_FILTER_EN_1, AXID, 0, 1)
REG32(NSU2_PERF_MON_1_0, 0x58c)
    FIELD(NSU2_PERF_MON_1_0, LAT_OVF, 31, 1)
    FIELD(NSU2_PERF_MON_1_0, LAT, 0, 31)
REG32(NSU2_PERF_MON_1_1, 0x590)
    FIELD(NSU2_PERF_MON_1_1, BURST_OVF, 31, 1)
    FIELD(NSU2_PERF_MON_1_1, BURST, 0, 31)
REG32(NSU2_PERF_MON_1_2, 0x594)
    FIELD(NSU2_PERF_MON_1_2, HEADER_OVF, 31, 1)
    FIELD(NSU2_PERF_MON_1_2, HEADER, 0, 31)
REG32(NSU3_PERF_MON_CTL_0_0, 0x598)
    FIELD(NSU3_PERF_MON_CTL_0_0, SNGL, 1, 1)
    FIELD(NSU3_PERF_MON_CTL_0_0, MON_EN, 0, 1)
REG32(NSU3_PERF_MON_CTL_0_1, 0x59c)
    FIELD(NSU3_PERF_MON_CTL_0_1, BEW, 7, 1)
    FIELD(NSU3_PERF_MON_CTL_0_1, ISOW, 6, 1)
    FIELD(NSU3_PERF_MON_CTL_0_1, BER, 5, 1)
    FIELD(NSU3_PERF_MON_CTL_0_1, ISOR, 4, 1)
    FIELD(NSU3_PERF_MON_CTL_0_1, LLR, 3, 1)
    FIELD(NSU3_PERF_MON_CTL_0_1, LAT_SEL, 2, 1)
    FIELD(NSU3_PERF_MON_CTL_0_1, TB_SEL, 0, 2)
REG32(NSU3_PERF_FILTER_0_0, 0x5a0)
    FIELD(NSU3_PERF_FILTER_0_0, AXLOCK, 29, 1)
    FIELD(NSU3_PERF_FILTER_0_0, AXPROT, 26, 3)
    FIELD(NSU3_PERF_FILTER_0_0, AXBURST, 24, 2)
    FIELD(NSU3_PERF_FILTER_0_0, AXLEN_MAX, 20, 4)
    FIELD(NSU3_PERF_FILTER_0_0, AXLEN_MIN, 16, 4)
    FIELD(NSU3_PERF_FILTER_0_0, AXID, 0, 16)
REG32(NSU3_PERF_FILTER_0_1, 0x5a4)
    FIELD(NSU3_PERF_FILTER_0_1, SRC_ID, 0, 12)
REG32(NSU3_PERF_FILTER_EN_0, 0x5a8)
    FIELD(NSU3_PERF_FILTER_EN_0, SRC_ID, 5, 1)
    FIELD(NSU3_PERF_FILTER_EN_0, AXLOCK, 4, 1)
    FIELD(NSU3_PERF_FILTER_EN_0, AXPROT, 3, 1)
    FIELD(NSU3_PERF_FILTER_EN_0, AXBURST, 2, 1)
    FIELD(NSU3_PERF_FILTER_EN_0, AXLEN, 1, 1)
    FIELD(NSU3_PERF_FILTER_EN_0, AXID, 0, 1)
REG32(NSU3_PERF_MON_0_0, 0x5ac)
    FIELD(NSU3_PERF_MON_0_0, LAT_OVF, 31, 1)
    FIELD(NSU3_PERF_MON_0_0, LAT, 0, 31)
REG32(NSU3_PERF_MON_0_1, 0x5b0)
    FIELD(NSU3_PERF_MON_0_1, BURST_OVF, 31, 1)
    FIELD(NSU3_PERF_MON_0_1, BURST, 0, 31)
REG32(NSU3_PERF_MON_0_2, 0x5b4)
    FIELD(NSU3_PERF_MON_0_2, HEADER_OVF, 31, 1)
    FIELD(NSU3_PERF_MON_0_2, HEADER, 0, 31)
REG32(NSU3_PERF_MON_CTL_1_0, 0x5b8)
    FIELD(NSU3_PERF_MON_CTL_1_0, SNGL, 1, 1)
    FIELD(NSU3_PERF_MON_CTL_1_0, MON_EN, 0, 1)
REG32(NSU3_PERF_MON_CTL_1_1, 0x5bc)
    FIELD(NSU3_PERF_MON_CTL_1_1, BEW, 7, 1)
    FIELD(NSU3_PERF_MON_CTL_1_1, ISOW, 6, 1)
    FIELD(NSU3_PERF_MON_CTL_1_1, BER, 5, 1)
    FIELD(NSU3_PERF_MON_CTL_1_1, ISOR, 4, 1)
    FIELD(NSU3_PERF_MON_CTL_1_1, LLR, 3, 1)
    FIELD(NSU3_PERF_MON_CTL_1_1, LAT_SEL, 2, 1)
    FIELD(NSU3_PERF_MON_CTL_1_1, TB_SEL, 0, 2)
REG32(NSU3_PERF_FILTER_1_0, 0x5c0)
    FIELD(NSU3_PERF_FILTER_1_0, AXLOCK, 29, 1)
    FIELD(NSU3_PERF_FILTER_1_0, AXPROT, 26, 3)
    FIELD(NSU3_PERF_FILTER_1_0, AXBURST, 24, 2)
    FIELD(NSU3_PERF_FILTER_1_0, AXLEN_MAX, 20, 4)
    FIELD(NSU3_PERF_FILTER_1_0, AXLEN_MIN, 16, 4)
    FIELD(NSU3_PERF_FILTER_1_0, AXID, 0, 16)
REG32(NSU3_PERF_FILTER_1_1, 0x5c4)
    FIELD(NSU3_PERF_FILTER_1_1, SRC_ID, 0, 12)
REG32(NSU3_PERF_FILTER_EN_1, 0x5c8)
    FIELD(NSU3_PERF_FILTER_EN_1, SRC_ID, 5, 1)
    FIELD(NSU3_PERF_FILTER_EN_1, AXLOCK, 4, 1)
    FIELD(NSU3_PERF_FILTER_EN_1, AXPROT, 3, 1)
    FIELD(NSU3_PERF_FILTER_EN_1, AXBURST, 2, 1)
    FIELD(NSU3_PERF_FILTER_EN_1, AXLEN, 1, 1)
    FIELD(NSU3_PERF_FILTER_EN_1, AXID, 0, 1)
REG32(NSU3_PERF_MON_1_0, 0x5cc)
    FIELD(NSU3_PERF_MON_1_0, LAT_OVF, 31, 1)
    FIELD(NSU3_PERF_MON_1_0, LAT, 0, 31)
REG32(NSU3_PERF_MON_1_1, 0x5d0)
    FIELD(NSU3_PERF_MON_1_1, BURST_OVF, 31, 1)
    FIELD(NSU3_PERF_MON_1_1, BURST, 0, 31)
REG32(NSU3_PERF_MON_1_2, 0x5d4)
    FIELD(NSU3_PERF_MON_1_2, HEADER_OVF, 31, 1)
    FIELD(NSU3_PERF_MON_1_2, HEADER, 0, 31)
REG32(NSU0_ERR_LOG0_EN, 0x5d8)
    FIELD(NSU0_ERR_LOG0_EN, NOT_READY, 24, 1)
    FIELD(NSU0_ERR_LOG0_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU0_ERR_LOG0_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU0_ERR_LOG0_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU0_ERR_LOG0_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU0_ERR_LOG0_EN, EX_LEN, 13, 1)
    FIELD(NSU0_ERR_LOG0_EN, ING_OF, 12, 1)
    FIELD(NSU0_ERR_LOG0_EN, EGR_OF, 11, 1)
    FIELD(NSU0_ERR_LOG0_EN, NUM_LEN, 10, 1)
    FIELD(NSU0_ERR_LOG0_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU0_ERR_LOG0_EN, UNMAP_VC, 8, 1)
    FIELD(NSU0_ERR_LOG0_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU0_ERR_LOG0_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU0_ERR_LOG0_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU0_ERR_LOG0_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU0_ERR_LOG0_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU0_ERR_LOG0_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU0_ERR_LOG0_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU0_ERR_LOG1_EN, 0x5dc)
    FIELD(NSU0_ERR_LOG1_EN, NOT_READY, 24, 1)
    FIELD(NSU0_ERR_LOG1_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU0_ERR_LOG1_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU0_ERR_LOG1_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU0_ERR_LOG1_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU0_ERR_LOG1_EN, EX_LEN, 13, 1)
    FIELD(NSU0_ERR_LOG1_EN, ING_OF, 12, 1)
    FIELD(NSU0_ERR_LOG1_EN, EGR_OF, 11, 1)
    FIELD(NSU0_ERR_LOG1_EN, NUM_LEN, 10, 1)
    FIELD(NSU0_ERR_LOG1_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU0_ERR_LOG1_EN, UNMAP_VC, 8, 1)
    FIELD(NSU0_ERR_LOG1_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU0_ERR_LOG1_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU0_ERR_LOG1_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU0_ERR_LOG1_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU0_ERR_LOG1_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU0_ERR_LOG1_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU0_ERR_LOG1_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU0_ERR_STATUS, 0x5e0)
    FIELD(NSU0_ERR_STATUS, NOT_READY, 24, 1)
    FIELD(NSU0_ERR_STATUS, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU0_ERR_STATUS, WR_DATA_POISON, 22, 1)
    FIELD(NSU0_ERR_STATUS, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU0_ERR_STATUS, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU0_ERR_STATUS, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU0_ERR_STATUS, RD_HEADER_CE, 18, 1)
    FIELD(NSU0_ERR_STATUS, WR_DATA_CE, 17, 1)
    FIELD(NSU0_ERR_STATUS, WR_HEADER_CE, 16, 1)
    FIELD(NSU0_ERR_STATUS, WR_DATA_UC, 15, 1)
    FIELD(NSU0_ERR_STATUS, RD_RESP_PAR, 14, 1)
    FIELD(NSU0_ERR_STATUS, EX_LEN, 13, 1)
    FIELD(NSU0_ERR_STATUS, ING_OF, 12, 1)
    FIELD(NSU0_ERR_STATUS, EGR_OF, 11, 1)
    FIELD(NSU0_ERR_STATUS, NUM_LEN, 10, 1)
    FIELD(NSU0_ERR_STATUS, DST_ID_MATCH, 9, 1)
    FIELD(NSU0_ERR_STATUS, UNMAP_VC, 8, 1)
    FIELD(NSU0_ERR_STATUS, RD_HEADER_UC, 7, 1)
    FIELD(NSU0_ERR_STATUS, WR_HEADER_UC, 6, 1)
    FIELD(NSU0_ERR_STATUS, DBI_ID_PAR, 5, 1)
    FIELD(NSU0_ERR_STATUS, WR_WRAP_LEN, 4, 1)
    FIELD(NSU0_ERR_STATUS, RD_WRAP_LEN, 3, 1)
    FIELD(NSU0_ERR_STATUS, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU0_ERR_STATUS, SIZE_INVALID, 1, 1)
    FIELD(NSU0_ERR_STATUS, UNALIGN_WRAP, 0, 1)
REG32(NSU0_ERR_LOG0_0, 0x5e4)
    FIELD(NSU0_ERR_LOG0_0, DST, 20, 12)
    FIELD(NSU0_ERR_LOG0_0, SRC, 8, 12)
    FIELD(NSU0_ERR_LOG0_0, TAG, 0, 8)
REG32(NSU0_ERR_LOG0_1, 0x5e8)
    FIELD(NSU0_ERR_LOG0_1, POISON, 31, 1)
    FIELD(NSU0_ERR_LOG0_1, VC, 22, 8)
    FIELD(NSU0_ERR_LOG0_1, LAST, 21, 1)
    FIELD(NSU0_ERR_LOG0_1, WSTRB, 5, 16)
    FIELD(NSU0_ERR_LOG0_1, DST_PAR, 4, 1)
    FIELD(NSU0_ERR_LOG0_1, PKT_TYPE, 0, 4)
REG32(NSU0_ERR_LOG0_2, 0x5ec)
    FIELD(NSU0_ERR_LOG0_2, AXBURST, 30, 2)
    FIELD(NSU0_ERR_LOG0_2, SMID, 20, 10)
    FIELD(NSU0_ERR_LOG0_2, AXLOCK, 19, 1)
    FIELD(NSU0_ERR_LOG0_2, AXSIZE, 16, 3)
    FIELD(NSU0_ERR_LOG0_2, AXLEN, 8, 8)
    FIELD(NSU0_ERR_LOG0_2, NPP_EBIT, 0, 8)
REG32(NSU0_ERR_LOG0_3, 0x5f0)
REG32(NSU0_ERR_LOG0_4, 0x5f4)
    FIELD(NSU0_ERR_LOG0_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU0_ERR_LOG0_4, ADDR_U, 0, 16)
REG32(NSU0_ERR_LOG1_0, 0x5f8)
    FIELD(NSU0_ERR_LOG1_0, DST, 20, 12)
    FIELD(NSU0_ERR_LOG1_0, SRC, 8, 12)
    FIELD(NSU0_ERR_LOG1_0, TAG, 0, 8)
REG32(NSU0_ERR_LOG1_1, 0x5fc)
    FIELD(NSU0_ERR_LOG1_1, POISON, 31, 1)
    FIELD(NSU0_ERR_LOG1_1, VC, 22, 8)
    FIELD(NSU0_ERR_LOG1_1, LAST, 21, 1)
    FIELD(NSU0_ERR_LOG1_1, WSTRB, 5, 16)
    FIELD(NSU0_ERR_LOG1_1, DST_PAR, 4, 1)
    FIELD(NSU0_ERR_LOG1_1, PKT_TYPE, 0, 4)
REG32(NSU0_ERR_LOG1_2, 0x600)
    FIELD(NSU0_ERR_LOG1_2, AXBURST, 30, 2)
    FIELD(NSU0_ERR_LOG1_2, SMID, 20, 10)
    FIELD(NSU0_ERR_LOG1_2, AXLOCK, 19, 1)
    FIELD(NSU0_ERR_LOG1_2, AXSIZE, 16, 3)
    FIELD(NSU0_ERR_LOG1_2, AXLEN, 8, 8)
    FIELD(NSU0_ERR_LOG1_2, NPP_EBIT, 0, 8)
REG32(NSU0_ERR_LOG1_3, 0x604)
REG32(NSU0_ERR_LOG1_4, 0x608)
    FIELD(NSU0_ERR_LOG1_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU0_ERR_LOG1_4, ADDR_U, 0, 16)
REG32(NSU1_ERR_LOG0_EN, 0x60c)
    FIELD(NSU1_ERR_LOG0_EN, NOT_READY, 24, 1)
    FIELD(NSU1_ERR_LOG0_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU1_ERR_LOG0_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU1_ERR_LOG0_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU1_ERR_LOG0_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU1_ERR_LOG0_EN, EX_LEN, 13, 1)
    FIELD(NSU1_ERR_LOG0_EN, ING_OF, 12, 1)
    FIELD(NSU1_ERR_LOG0_EN, EGR_OF, 11, 1)
    FIELD(NSU1_ERR_LOG0_EN, NUM_LEN, 10, 1)
    FIELD(NSU1_ERR_LOG0_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU1_ERR_LOG0_EN, UNMAP_VC, 8, 1)
    FIELD(NSU1_ERR_LOG0_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU1_ERR_LOG0_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU1_ERR_LOG0_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU1_ERR_LOG0_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU1_ERR_LOG0_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU1_ERR_LOG0_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU1_ERR_LOG0_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU1_ERR_LOG1_EN, 0x610)
    FIELD(NSU1_ERR_LOG1_EN, NOT_READY, 24, 1)
    FIELD(NSU1_ERR_LOG1_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU1_ERR_LOG1_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU1_ERR_LOG1_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU1_ERR_LOG1_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU1_ERR_LOG1_EN, EX_LEN, 13, 1)
    FIELD(NSU1_ERR_LOG1_EN, ING_OF, 12, 1)
    FIELD(NSU1_ERR_LOG1_EN, EGR_OF, 11, 1)
    FIELD(NSU1_ERR_LOG1_EN, NUM_LEN, 10, 1)
    FIELD(NSU1_ERR_LOG1_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU1_ERR_LOG1_EN, UNMAP_VC, 8, 1)
    FIELD(NSU1_ERR_LOG1_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU1_ERR_LOG1_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU1_ERR_LOG1_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU1_ERR_LOG1_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU1_ERR_LOG1_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU1_ERR_LOG1_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU1_ERR_LOG1_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU1_ERR_STATUS, 0x614)
    FIELD(NSU1_ERR_STATUS, NOT_READY, 24, 1)
    FIELD(NSU1_ERR_STATUS, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU1_ERR_STATUS, WR_DATA_POISON, 22, 1)
    FIELD(NSU1_ERR_STATUS, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU1_ERR_STATUS, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU1_ERR_STATUS, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU1_ERR_STATUS, RD_HEADER_CE, 18, 1)
    FIELD(NSU1_ERR_STATUS, WR_DATA_CE, 17, 1)
    FIELD(NSU1_ERR_STATUS, WR_HEADER_CE, 16, 1)
    FIELD(NSU1_ERR_STATUS, WR_DATA_UC, 15, 1)
    FIELD(NSU1_ERR_STATUS, RD_RESP_PAR, 14, 1)
    FIELD(NSU1_ERR_STATUS, EX_LEN, 13, 1)
    FIELD(NSU1_ERR_STATUS, ING_OF, 12, 1)
    FIELD(NSU1_ERR_STATUS, EGR_OF, 11, 1)
    FIELD(NSU1_ERR_STATUS, NUM_LEN, 10, 1)
    FIELD(NSU1_ERR_STATUS, DST_ID_MATCH, 9, 1)
    FIELD(NSU1_ERR_STATUS, UNMAP_VC, 8, 1)
    FIELD(NSU1_ERR_STATUS, RD_HEADER_UC, 7, 1)
    FIELD(NSU1_ERR_STATUS, WR_HEADER_UC, 6, 1)
    FIELD(NSU1_ERR_STATUS, DBI_ID_PAR, 5, 1)
    FIELD(NSU1_ERR_STATUS, WR_WRAP_LEN, 4, 1)
    FIELD(NSU1_ERR_STATUS, RD_WRAP_LEN, 3, 1)
    FIELD(NSU1_ERR_STATUS, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU1_ERR_STATUS, SIZE_INVALID, 1, 1)
    FIELD(NSU1_ERR_STATUS, UNALIGN_WRAP, 0, 1)
REG32(NSU1_ERR_LOG0_0, 0x618)
    FIELD(NSU1_ERR_LOG0_0, DST, 20, 12)
    FIELD(NSU1_ERR_LOG0_0, SRC, 8, 12)
    FIELD(NSU1_ERR_LOG0_0, TAG, 0, 8)
REG32(NSU1_ERR_LOG0_1, 0x61c)
    FIELD(NSU1_ERR_LOG0_1, POISON, 31, 1)
    FIELD(NSU1_ERR_LOG0_1, VC, 22, 8)
    FIELD(NSU1_ERR_LOG0_1, LAST, 21, 1)
    FIELD(NSU1_ERR_LOG0_1, WSTRB, 5, 16)
    FIELD(NSU1_ERR_LOG0_1, DST_PAR, 4, 1)
    FIELD(NSU1_ERR_LOG0_1, PKT_TYPE, 0, 4)
REG32(NSU1_ERR_LOG0_2, 0x620)
    FIELD(NSU1_ERR_LOG0_2, AXBURST, 30, 2)
    FIELD(NSU1_ERR_LOG0_2, SMID, 20, 10)
    FIELD(NSU1_ERR_LOG0_2, AXLOCK, 19, 1)
    FIELD(NSU1_ERR_LOG0_2, AXSIZE, 16, 3)
    FIELD(NSU1_ERR_LOG0_2, AXLEN, 8, 8)
    FIELD(NSU1_ERR_LOG0_2, NPP_EBIT, 0, 8)
REG32(NSU1_ERR_LOG0_3, 0x624)
REG32(NSU1_ERR_LOG0_4, 0x628)
    FIELD(NSU1_ERR_LOG0_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU1_ERR_LOG0_4, ADDR_U, 0, 16)
REG32(NSU1_ERR_LOG1_0, 0x62c)
    FIELD(NSU1_ERR_LOG1_0, DST, 20, 12)
    FIELD(NSU1_ERR_LOG1_0, SRC, 8, 12)
    FIELD(NSU1_ERR_LOG1_0, TAG, 0, 8)
REG32(NSU1_ERR_LOG1_1, 0x630)
    FIELD(NSU1_ERR_LOG1_1, POISON, 31, 1)
    FIELD(NSU1_ERR_LOG1_1, VC, 22, 8)
    FIELD(NSU1_ERR_LOG1_1, LAST, 21, 1)
    FIELD(NSU1_ERR_LOG1_1, WSTRB, 5, 16)
    FIELD(NSU1_ERR_LOG1_1, DST_PAR, 4, 1)
    FIELD(NSU1_ERR_LOG1_1, PKT_TYPE, 0, 4)
REG32(NSU1_ERR_LOG1_2, 0x634)
    FIELD(NSU1_ERR_LOG1_2, AXBURST, 30, 2)
    FIELD(NSU1_ERR_LOG1_2, SMID, 20, 10)
    FIELD(NSU1_ERR_LOG1_2, AXLOCK, 19, 1)
    FIELD(NSU1_ERR_LOG1_2, AXSIZE, 16, 3)
    FIELD(NSU1_ERR_LOG1_2, AXLEN, 8, 8)
    FIELD(NSU1_ERR_LOG1_2, NPP_EBIT, 0, 8)
REG32(NSU1_ERR_LOG1_3, 0x638)
REG32(NSU1_ERR_LOG1_4, 0x63c)
    FIELD(NSU1_ERR_LOG1_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU1_ERR_LOG1_4, ADDR_U, 0, 16)
REG32(NSU2_ERR_LOG0_EN, 0x640)
    FIELD(NSU2_ERR_LOG0_EN, NOT_READY, 24, 1)
    FIELD(NSU2_ERR_LOG0_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU2_ERR_LOG0_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU2_ERR_LOG0_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU2_ERR_LOG0_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU2_ERR_LOG0_EN, EX_LEN, 13, 1)
    FIELD(NSU2_ERR_LOG0_EN, ING_OF, 12, 1)
    FIELD(NSU2_ERR_LOG0_EN, EGR_OF, 11, 1)
    FIELD(NSU2_ERR_LOG0_EN, NUM_LEN, 10, 1)
    FIELD(NSU2_ERR_LOG0_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU2_ERR_LOG0_EN, UNMAP_VC, 8, 1)
    FIELD(NSU2_ERR_LOG0_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU2_ERR_LOG0_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU2_ERR_LOG0_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU2_ERR_LOG0_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU2_ERR_LOG0_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU2_ERR_LOG0_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU2_ERR_LOG0_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU2_ERR_LOG1_EN, 0x644)
    FIELD(NSU2_ERR_LOG1_EN, NOT_READY, 24, 1)
    FIELD(NSU2_ERR_LOG1_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU2_ERR_LOG1_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU2_ERR_LOG1_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU2_ERR_LOG1_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU2_ERR_LOG1_EN, EX_LEN, 13, 1)
    FIELD(NSU2_ERR_LOG1_EN, ING_OF, 12, 1)
    FIELD(NSU2_ERR_LOG1_EN, EGR_OF, 11, 1)
    FIELD(NSU2_ERR_LOG1_EN, NUM_LEN, 10, 1)
    FIELD(NSU2_ERR_LOG1_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU2_ERR_LOG1_EN, UNMAP_VC, 8, 1)
    FIELD(NSU2_ERR_LOG1_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU2_ERR_LOG1_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU2_ERR_LOG1_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU2_ERR_LOG1_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU2_ERR_LOG1_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU2_ERR_LOG1_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU2_ERR_LOG1_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU2_ERR_STATUS, 0x648)
    FIELD(NSU2_ERR_STATUS, NOT_READY, 24, 1)
    FIELD(NSU2_ERR_STATUS, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU2_ERR_STATUS, WR_DATA_POISON, 22, 1)
    FIELD(NSU2_ERR_STATUS, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU2_ERR_STATUS, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU2_ERR_STATUS, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU2_ERR_STATUS, RD_HEADER_CE, 18, 1)
    FIELD(NSU2_ERR_STATUS, WR_DATA_CE, 17, 1)
    FIELD(NSU2_ERR_STATUS, WR_HEADER_CE, 16, 1)
    FIELD(NSU2_ERR_STATUS, WR_DATA_UC, 15, 1)
    FIELD(NSU2_ERR_STATUS, RD_RESP_PAR, 14, 1)
    FIELD(NSU2_ERR_STATUS, EX_LEN, 13, 1)
    FIELD(NSU2_ERR_STATUS, ING_OF, 12, 1)
    FIELD(NSU2_ERR_STATUS, EGR_OF, 11, 1)
    FIELD(NSU2_ERR_STATUS, NUM_LEN, 10, 1)
    FIELD(NSU2_ERR_STATUS, DST_ID_MATCH, 9, 1)
    FIELD(NSU2_ERR_STATUS, UNMAP_VC, 8, 1)
    FIELD(NSU2_ERR_STATUS, RD_HEADER_UC, 7, 1)
    FIELD(NSU2_ERR_STATUS, WR_HEADER_UC, 6, 1)
    FIELD(NSU2_ERR_STATUS, DBI_ID_PAR, 5, 1)
    FIELD(NSU2_ERR_STATUS, WR_WRAP_LEN, 4, 1)
    FIELD(NSU2_ERR_STATUS, RD_WRAP_LEN, 3, 1)
    FIELD(NSU2_ERR_STATUS, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU2_ERR_STATUS, SIZE_INVALID, 1, 1)
    FIELD(NSU2_ERR_STATUS, UNALIGN_WRAP, 0, 1)
REG32(NSU2_ERR_LOG0_0, 0x64c)
    FIELD(NSU2_ERR_LOG0_0, DST, 20, 12)
    FIELD(NSU2_ERR_LOG0_0, SRC, 8, 12)
    FIELD(NSU2_ERR_LOG0_0, TAG, 0, 8)
REG32(NSU2_ERR_LOG0_1, 0x650)
    FIELD(NSU2_ERR_LOG0_1, POISON, 31, 1)
    FIELD(NSU2_ERR_LOG0_1, VC, 22, 8)
    FIELD(NSU2_ERR_LOG0_1, LAST, 21, 1)
    FIELD(NSU2_ERR_LOG0_1, WSTRB, 5, 16)
    FIELD(NSU2_ERR_LOG0_1, DST_PAR, 4, 1)
    FIELD(NSU2_ERR_LOG0_1, PKT_TYPE, 0, 4)
REG32(NSU2_ERR_LOG0_2, 0x654)
    FIELD(NSU2_ERR_LOG0_2, AXBURST, 30, 2)
    FIELD(NSU2_ERR_LOG0_2, SMID, 20, 10)
    FIELD(NSU2_ERR_LOG0_2, AXLOCK, 19, 1)
    FIELD(NSU2_ERR_LOG0_2, AXSIZE, 16, 3)
    FIELD(NSU2_ERR_LOG0_2, AXLEN, 8, 8)
    FIELD(NSU2_ERR_LOG0_2, NPP_EBIT, 0, 8)
REG32(NSU2_ERR_LOG0_3, 0x658)
REG32(NSU2_ERR_LOG0_4, 0x65c)
    FIELD(NSU2_ERR_LOG0_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU2_ERR_LOG0_4, ADDR_U, 0, 16)
REG32(NSU2_ERR_LOG1_0, 0x660)
    FIELD(NSU2_ERR_LOG1_0, DST, 20, 12)
    FIELD(NSU2_ERR_LOG1_0, SRC, 8, 12)
    FIELD(NSU2_ERR_LOG1_0, TAG, 0, 8)
REG32(NSU2_ERR_LOG1_1, 0x664)
    FIELD(NSU2_ERR_LOG1_1, POISON, 31, 1)
    FIELD(NSU2_ERR_LOG1_1, VC, 22, 8)
    FIELD(NSU2_ERR_LOG1_1, LAST, 21, 1)
    FIELD(NSU2_ERR_LOG1_1, WSTRB, 5, 16)
    FIELD(NSU2_ERR_LOG1_1, DST_PAR, 4, 1)
    FIELD(NSU2_ERR_LOG1_1, PKT_TYPE, 0, 4)
REG32(NSU2_ERR_LOG1_2, 0x668)
    FIELD(NSU2_ERR_LOG1_2, AXBURST, 30, 2)
    FIELD(NSU2_ERR_LOG1_2, SMID, 20, 10)
    FIELD(NSU2_ERR_LOG1_2, AXLOCK, 19, 1)
    FIELD(NSU2_ERR_LOG1_2, AXSIZE, 16, 3)
    FIELD(NSU2_ERR_LOG1_2, AXLEN, 8, 8)
    FIELD(NSU2_ERR_LOG1_2, NPP_EBIT, 0, 8)
REG32(NSU2_ERR_LOG1_3, 0x66c)
REG32(NSU2_ERR_LOG1_4, 0x670)
    FIELD(NSU2_ERR_LOG1_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU2_ERR_LOG1_4, ADDR_U, 0, 16)
REG32(NSU3_ERR_LOG0_EN, 0x674)
    FIELD(NSU3_ERR_LOG0_EN, NOT_READY, 24, 1)
    FIELD(NSU3_ERR_LOG0_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU3_ERR_LOG0_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU3_ERR_LOG0_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU3_ERR_LOG0_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU3_ERR_LOG0_EN, EX_LEN, 13, 1)
    FIELD(NSU3_ERR_LOG0_EN, ING_OF, 12, 1)
    FIELD(NSU3_ERR_LOG0_EN, EGR_OF, 11, 1)
    FIELD(NSU3_ERR_LOG0_EN, NUM_LEN, 10, 1)
    FIELD(NSU3_ERR_LOG0_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU3_ERR_LOG0_EN, UNMAP_VC, 8, 1)
    FIELD(NSU3_ERR_LOG0_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU3_ERR_LOG0_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU3_ERR_LOG0_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU3_ERR_LOG0_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU3_ERR_LOG0_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU3_ERR_LOG0_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU3_ERR_LOG0_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU3_ERR_LOG1_EN, 0x678)
    FIELD(NSU3_ERR_LOG1_EN, NOT_READY, 24, 1)
    FIELD(NSU3_ERR_LOG1_EN, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_DATA_POISON, 22, 1)
    FIELD(NSU3_ERR_LOG1_EN, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU3_ERR_LOG1_EN, RD_HEADER_CE, 18, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_DATA_CE, 17, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_HEADER_CE, 16, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_DATA_UC, 15, 1)
    FIELD(NSU3_ERR_LOG1_EN, RD_RESP_PAR, 14, 1)
    FIELD(NSU3_ERR_LOG1_EN, EX_LEN, 13, 1)
    FIELD(NSU3_ERR_LOG1_EN, ING_OF, 12, 1)
    FIELD(NSU3_ERR_LOG1_EN, EGR_OF, 11, 1)
    FIELD(NSU3_ERR_LOG1_EN, NUM_LEN, 10, 1)
    FIELD(NSU3_ERR_LOG1_EN, DST_ID_MATCH, 9, 1)
    FIELD(NSU3_ERR_LOG1_EN, UNMAP_VC, 8, 1)
    FIELD(NSU3_ERR_LOG1_EN, RD_HEADER_UC, 7, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_HEADER_UC, 6, 1)
    FIELD(NSU3_ERR_LOG1_EN, DBI_ID_PAR, 5, 1)
    FIELD(NSU3_ERR_LOG1_EN, WR_WRAP_LEN, 4, 1)
    FIELD(NSU3_ERR_LOG1_EN, RD_WRAP_LEN, 3, 1)
    FIELD(NSU3_ERR_LOG1_EN, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU3_ERR_LOG1_EN, SIZE_INVALID, 1, 1)
    FIELD(NSU3_ERR_LOG1_EN, UNALIGN_WRAP, 0, 1)
REG32(NSU3_ERR_STATUS, 0x67c)
    FIELD(NSU3_ERR_STATUS, NOT_READY, 24, 1)
    FIELD(NSU3_ERR_STATUS, VC_TYP_MISSMATCH, 23, 1)
    FIELD(NSU3_ERR_STATUS, WR_DATA_POISON, 22, 1)
    FIELD(NSU3_ERR_STATUS, RD_HEADER_2ND_CE, 21, 1)
    FIELD(NSU3_ERR_STATUS, WR_DATA_2ND_CE, 20, 1)
    FIELD(NSU3_ERR_STATUS, WR_HEADER_2ND_CE, 19, 1)
    FIELD(NSU3_ERR_STATUS, RD_HEADER_CE, 18, 1)
    FIELD(NSU3_ERR_STATUS, WR_DATA_CE, 17, 1)
    FIELD(NSU3_ERR_STATUS, WR_HEADER_CE, 16, 1)
    FIELD(NSU3_ERR_STATUS, WR_DATA_UC, 15, 1)
    FIELD(NSU3_ERR_STATUS, RD_RESP_PAR, 14, 1)
    FIELD(NSU3_ERR_STATUS, EX_LEN, 13, 1)
    FIELD(NSU3_ERR_STATUS, ING_OF, 12, 1)
    FIELD(NSU3_ERR_STATUS, EGR_OF, 11, 1)
    FIELD(NSU3_ERR_STATUS, NUM_LEN, 10, 1)
    FIELD(NSU3_ERR_STATUS, DST_ID_MATCH, 9, 1)
    FIELD(NSU3_ERR_STATUS, UNMAP_VC, 8, 1)
    FIELD(NSU3_ERR_STATUS, RD_HEADER_UC, 7, 1)
    FIELD(NSU3_ERR_STATUS, WR_HEADER_UC, 6, 1)
    FIELD(NSU3_ERR_STATUS, DBI_ID_PAR, 5, 1)
    FIELD(NSU3_ERR_STATUS, WR_WRAP_LEN, 4, 1)
    FIELD(NSU3_ERR_STATUS, RD_WRAP_LEN, 3, 1)
    FIELD(NSU3_ERR_STATUS, EX_SIZE_INVALID, 2, 1)
    FIELD(NSU3_ERR_STATUS, SIZE_INVALID, 1, 1)
    FIELD(NSU3_ERR_STATUS, UNALIGN_WRAP, 0, 1)
REG32(NSU3_ERR_LOG0_0, 0x680)
    FIELD(NSU3_ERR_LOG0_0, DST, 20, 12)
    FIELD(NSU3_ERR_LOG0_0, SRC, 8, 12)
    FIELD(NSU3_ERR_LOG0_0, TAG, 0, 8)
REG32(NSU3_ERR_LOG0_1, 0x684)
    FIELD(NSU3_ERR_LOG0_1, POISON, 31, 1)
    FIELD(NSU3_ERR_LOG0_1, VC, 22, 8)
    FIELD(NSU3_ERR_LOG0_1, LAST, 21, 1)
    FIELD(NSU3_ERR_LOG0_1, WSTRB, 5, 16)
    FIELD(NSU3_ERR_LOG0_1, DST_PAR, 4, 1)
    FIELD(NSU3_ERR_LOG0_1, PKT_TYPE, 0, 4)
REG32(NSU3_ERR_LOG0_2, 0x688)
    FIELD(NSU3_ERR_LOG0_2, AXBURST, 30, 2)
    FIELD(NSU3_ERR_LOG0_2, SMID, 20, 10)
    FIELD(NSU3_ERR_LOG0_2, AXLOCK, 19, 1)
    FIELD(NSU3_ERR_LOG0_2, AXSIZE, 16, 3)
    FIELD(NSU3_ERR_LOG0_2, AXLEN, 8, 8)
    FIELD(NSU3_ERR_LOG0_2, NPP_EBIT, 0, 8)
REG32(NSU3_ERR_LOG0_3, 0x68c)
REG32(NSU3_ERR_LOG0_4, 0x690)
    FIELD(NSU3_ERR_LOG0_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU3_ERR_LOG0_4, ADDR_U, 0, 16)
REG32(NSU3_ERR_LOG1_0, 0x694)
    FIELD(NSU3_ERR_LOG1_0, DST, 20, 12)
    FIELD(NSU3_ERR_LOG1_0, SRC, 8, 12)
    FIELD(NSU3_ERR_LOG1_0, TAG, 0, 8)
REG32(NSU3_ERR_LOG1_1, 0x698)
    FIELD(NSU3_ERR_LOG1_1, POISON, 31, 1)
    FIELD(NSU3_ERR_LOG1_1, VC, 22, 8)
    FIELD(NSU3_ERR_LOG1_1, LAST, 21, 1)
    FIELD(NSU3_ERR_LOG1_1, WSTRB, 5, 16)
    FIELD(NSU3_ERR_LOG1_1, DST_PAR, 4, 1)
    FIELD(NSU3_ERR_LOG1_1, PKT_TYPE, 0, 4)
REG32(NSU3_ERR_LOG1_2, 0x69c)
    FIELD(NSU3_ERR_LOG1_2, AXBURST, 30, 2)
    FIELD(NSU3_ERR_LOG1_2, SMID, 20, 10)
    FIELD(NSU3_ERR_LOG1_2, AXLOCK, 19, 1)
    FIELD(NSU3_ERR_LOG1_2, AXSIZE, 16, 3)
    FIELD(NSU3_ERR_LOG1_2, AXLEN, 8, 8)
    FIELD(NSU3_ERR_LOG1_2, NPP_EBIT, 0, 8)
REG32(NSU3_ERR_LOG1_3, 0x6a0)
REG32(NSU3_ERR_LOG1_4, 0x6a4)
    FIELD(NSU3_ERR_LOG1_4, ERR_REF_NUM, 16, 16)
    FIELD(NSU3_ERR_LOG1_4, ADDR_U, 0, 16)
REG32(NSU0_ERR_CTRL, 0x6a8)
    FIELD(NSU0_ERR_CTRL, PERSISTENT, 22, 1)
    FIELD(NSU0_ERR_CTRL, R_DONE, 21, 1)
    FIELD(NSU0_ERR_CTRL, CW_DONE, 20, 1)
    FIELD(NSU0_ERR_CTRL, DW_DONE, 19, 1)
    FIELD(NSU0_ERR_CTRL, R_EN, 18, 1)
    FIELD(NSU0_ERR_CTRL, CW_EN, 17, 1)
    FIELD(NSU0_ERR_CTRL, DW_EN, 16, 1)
    FIELD(NSU0_ERR_CTRL, SEL, 14, 2)
    FIELD(NSU0_ERR_CTRL, FATAL_DROP_EN, 13, 1)
    FIELD(NSU0_ERR_CTRL, PAR_RESP_ERR_EN, 12, 1)
REG32(NSU1_ERR_CTRL, 0x6ac)
    FIELD(NSU1_ERR_CTRL, PERSISTENT, 22, 1)
    FIELD(NSU1_ERR_CTRL, R_DONE, 21, 1)
    FIELD(NSU1_ERR_CTRL, CW_DONE, 20, 1)
    FIELD(NSU1_ERR_CTRL, DW_DONE, 19, 1)
    FIELD(NSU1_ERR_CTRL, R_EN, 18, 1)
    FIELD(NSU1_ERR_CTRL, CW_EN, 17, 1)
    FIELD(NSU1_ERR_CTRL, DW_EN, 16, 1)
    FIELD(NSU1_ERR_CTRL, SEL, 14, 2)
    FIELD(NSU1_ERR_CTRL, FATAL_DROP_EN, 13, 1)
    FIELD(NSU1_ERR_CTRL, PAR_RESP_ERR_EN, 12, 1)
REG32(NSU2_ERR_CTRL, 0x6b0)
    FIELD(NSU2_ERR_CTRL, PERSISTENT, 22, 1)
    FIELD(NSU2_ERR_CTRL, R_DONE, 21, 1)
    FIELD(NSU2_ERR_CTRL, CW_DONE, 20, 1)
    FIELD(NSU2_ERR_CTRL, DW_DONE, 19, 1)
    FIELD(NSU2_ERR_CTRL, R_EN, 18, 1)
    FIELD(NSU2_ERR_CTRL, CW_EN, 17, 1)
    FIELD(NSU2_ERR_CTRL, DW_EN, 16, 1)
    FIELD(NSU2_ERR_CTRL, SEL, 14, 2)
    FIELD(NSU2_ERR_CTRL, FATAL_DROP_EN, 13, 1)
    FIELD(NSU2_ERR_CTRL, PAR_RESP_ERR_EN, 12, 1)
REG32(NSU3_ERR_CTRL, 0x6b4)
    FIELD(NSU3_ERR_CTRL, PERSISTENT, 22, 1)
    FIELD(NSU3_ERR_CTRL, R_DONE, 21, 1)
    FIELD(NSU3_ERR_CTRL, CW_DONE, 20, 1)
    FIELD(NSU3_ERR_CTRL, DW_DONE, 19, 1)
    FIELD(NSU3_ERR_CTRL, R_EN, 18, 1)
    FIELD(NSU3_ERR_CTRL, CW_EN, 17, 1)
    FIELD(NSU3_ERR_CTRL, DW_EN, 16, 1)
    FIELD(NSU3_ERR_CTRL, SEL, 14, 2)
    FIELD(NSU3_ERR_CTRL, FATAL_DROP_EN, 13, 1)
    FIELD(NSU3_ERR_CTRL, PAR_RESP_ERR_EN, 12, 1)
REG32(ECC_ERR_INJ_NSU0, 0x6b8)
    FIELD(ECC_ERR_INJ_NSU0, PERSISTENT, 24, 1)
    FIELD(ECC_ERR_INJ_NSU0, DST_PAR_DONE_WR, 23, 1)
    FIELD(ECC_ERR_INJ_NSU0, DST_PAR_EN_WR, 22, 1)
    FIELD(ECC_ERR_INJ_NSU0, DST_PAR_DONE_RD, 21, 1)
    FIELD(ECC_ERR_INJ_NSU0, DST_PAR_EN_RD, 20, 1)
    FIELD(ECC_ERR_INJ_NSU0, ECC_DONE_WR, 19, 1)
    FIELD(ECC_ERR_INJ_NSU0, ECC_EN_WR, 18, 1)
    FIELD(ECC_ERR_INJ_NSU0, ECC_DONE_RD, 17, 1)
    FIELD(ECC_ERR_INJ_NSU0, ECC_EN_RD, 16, 1)
    FIELD(ECC_ERR_INJ_NSU0, ECC_BIT_1, 8, 8)
    FIELD(ECC_ERR_INJ_NSU0, ECC_BIT_0, 0, 8)
REG32(ECC_ERR_INJ_NSU1, 0x6bc)
    FIELD(ECC_ERR_INJ_NSU1, PERSISTENT, 24, 1)
    FIELD(ECC_ERR_INJ_NSU1, DST_PAR_DONE_WR, 23, 1)
    FIELD(ECC_ERR_INJ_NSU1, DST_PAR_EN_WR, 22, 1)
    FIELD(ECC_ERR_INJ_NSU1, DST_PAR_DONE_RD, 21, 1)
    FIELD(ECC_ERR_INJ_NSU1, DST_PAR_EN_RD, 20, 1)
    FIELD(ECC_ERR_INJ_NSU1, ECC_DONE_WR, 19, 1)
    FIELD(ECC_ERR_INJ_NSU1, ECC_EN_WR, 18, 1)
    FIELD(ECC_ERR_INJ_NSU1, ECC_DONE_RD, 17, 1)
    FIELD(ECC_ERR_INJ_NSU1, ECC_EN_RD, 16, 1)
    FIELD(ECC_ERR_INJ_NSU1, ECC_BIT_1, 8, 8)
    FIELD(ECC_ERR_INJ_NSU1, ECC_BIT_0, 0, 8)
REG32(ECC_ERR_INJ_NSU2, 0x6c0)
    FIELD(ECC_ERR_INJ_NSU2, PERSISTENT, 24, 1)
    FIELD(ECC_ERR_INJ_NSU2, DST_PAR_DONE_WR, 23, 1)
    FIELD(ECC_ERR_INJ_NSU2, DST_PAR_EN_WR, 22, 1)
    FIELD(ECC_ERR_INJ_NSU2, DST_PAR_DONE_RD, 21, 1)
    FIELD(ECC_ERR_INJ_NSU2, DST_PAR_EN_RD, 20, 1)
    FIELD(ECC_ERR_INJ_NSU2, ECC_DONE_WR, 19, 1)
    FIELD(ECC_ERR_INJ_NSU2, ECC_EN_WR, 18, 1)
    FIELD(ECC_ERR_INJ_NSU2, ECC_DONE_RD, 17, 1)
    FIELD(ECC_ERR_INJ_NSU2, ECC_EN_RD, 16, 1)
    FIELD(ECC_ERR_INJ_NSU2, ECC_BIT_1, 8, 8)
    FIELD(ECC_ERR_INJ_NSU2, ECC_BIT_0, 0, 8)
REG32(ECC_ERR_INJ_NSU3, 0x6c4)
    FIELD(ECC_ERR_INJ_NSU3, PERSISTENT, 24, 1)
    FIELD(ECC_ERR_INJ_NSU3, DST_PAR_DONE_WR, 23, 1)
    FIELD(ECC_ERR_INJ_NSU3, DST_PAR_EN_WR, 22, 1)
    FIELD(ECC_ERR_INJ_NSU3, DST_PAR_DONE_RD, 21, 1)
    FIELD(ECC_ERR_INJ_NSU3, DST_PAR_EN_RD, 20, 1)
    FIELD(ECC_ERR_INJ_NSU3, ECC_DONE_WR, 19, 1)
    FIELD(ECC_ERR_INJ_NSU3, ECC_EN_WR, 18, 1)
    FIELD(ECC_ERR_INJ_NSU3, ECC_DONE_RD, 17, 1)
    FIELD(ECC_ERR_INJ_NSU3, ECC_EN_RD, 16, 1)
    FIELD(ECC_ERR_INJ_NSU3, ECC_BIT_1, 8, 8)
    FIELD(ECC_ERR_INJ_NSU3, ECC_BIT_0, 0, 8)
REG32(ILA_MUX_N0, 0x6c8)
REG32(ILA_MUX_N1, 0x6cc)
REG32(ILA_MUX_N2, 0x6d0)
REG32(ILA_MUX_N3, 0x6d4)
REG32(ILA_MUX_N4, 0x6d8)
REG32(ILA_MUX_N5, 0x6dc)
REG32(ILA_MUX_N6, 0x6e0)
REG32(ILA_MUX_N7, 0x6e4)
REG32(ILA_MUX_N8, 0x6e8)
REG32(ILA_MUX_N9, 0x6ec)
REG32(ILA_MUX_N10, 0x6f0)
REG32(ILA_MUX_N11, 0x6f4)
REG32(ILA_MUX_N12, 0x6f8)
REG32(ILA_MUX_N13, 0x6fc)
REG32(ILA_MUX_N14, 0x700)
REG32(ILA_MUX_N15, 0x704)
REG32(ILA_MUX_N16, 0x708)
REG32(ILA_MUX_N17, 0x70c)
REG32(NA_ERR_CTRL_0, 0x710)
    FIELD(NA_ERR_CTRL_0, DROP_PAR_ERR_EN, 28, 1)
    FIELD(NA_ERR_CTRL_0, PERSISTENT, 27, 1)
    FIELD(NA_ERR_CTRL_0, SEL, 24, 3)
    FIELD(NA_ERR_CTRL_0, P3_BER_PAR_DONE, 23, 1)
    FIELD(NA_ERR_CTRL_0, P2_BER_PAR_DONE, 22, 1)
    FIELD(NA_ERR_CTRL_0, P1_BER_PAR_DONE, 21, 1)
    FIELD(NA_ERR_CTRL_0, P0_BER_PAR_DONE, 20, 1)
    FIELD(NA_ERR_CTRL_0, P3_ISR_PAR_DONE, 19, 1)
    FIELD(NA_ERR_CTRL_0, P2_ISR_PAR_DONE, 18, 1)
    FIELD(NA_ERR_CTRL_0, P1_ISR_PAR_DONE, 17, 1)
    FIELD(NA_ERR_CTRL_0, P0_ISR_PAR_DONE, 16, 1)
    FIELD(NA_ERR_CTRL_0, P3_LLR_PAR_DONE, 15, 1)
    FIELD(NA_ERR_CTRL_0, P2_LLR_PAR_DONE, 14, 1)
    FIELD(NA_ERR_CTRL_0, P1_LLR_PAR_DONE, 13, 1)
    FIELD(NA_ERR_CTRL_0, P0_LLR_PAR_DONE, 12, 1)
    FIELD(NA_ERR_CTRL_0, INJECT_BER_PAR, 8, 4)
    FIELD(NA_ERR_CTRL_0, INJECT_ISR_PAR, 4, 4)
    FIELD(NA_ERR_CTRL_0, INJECT_LLR_PAR, 0, 4)
REG32(NA_ERR_CTRL_1, 0x714)
    FIELD(NA_ERR_CTRL_1, P3_BEW_D_PAR_DONE, 31, 1)
    FIELD(NA_ERR_CTRL_1, P2_BEW_D_PAR_DONE, 30, 1)
    FIELD(NA_ERR_CTRL_1, P1_BEW_D_PAR_DONE, 29, 1)
    FIELD(NA_ERR_CTRL_1, P0_BEW_D_PAR_DONE, 28, 1)
    FIELD(NA_ERR_CTRL_1, P3_BEW_H_PAR_DONE, 27, 1)
    FIELD(NA_ERR_CTRL_1, P2_BEW_H_PAR_DONE, 26, 1)
    FIELD(NA_ERR_CTRL_1, P1_BEW_H_PAR_DONE, 25, 1)
    FIELD(NA_ERR_CTRL_1, P0_BEW_H_PAR_DONE, 24, 1)
    FIELD(NA_ERR_CTRL_1, P3_ISW_D_PAR_DONE, 23, 1)
    FIELD(NA_ERR_CTRL_1, P2_ISW_D_PAR_DONE, 22, 1)
    FIELD(NA_ERR_CTRL_1, P1_ISW_D_PAR_DONE, 21, 1)
    FIELD(NA_ERR_CTRL_1, P0_ISW_D_PAR_DONE, 20, 1)
    FIELD(NA_ERR_CTRL_1, P3_ISW_H_PAR_DONE, 19, 1)
    FIELD(NA_ERR_CTRL_1, P2_ISW_H_PAR_DONE, 18, 1)
    FIELD(NA_ERR_CTRL_1, P1_ISW_H_PAR_DONE, 17, 1)
    FIELD(NA_ERR_CTRL_1, P0_ISW_H_PAR_DONE, 16, 1)
    FIELD(NA_ERR_CTRL_1, INJECT_BEW_D_PAR, 12, 4)
    FIELD(NA_ERR_CTRL_1, INJECT_BEW_H_PAR, 8, 4)
    FIELD(NA_ERR_CTRL_1, INJECT_ISW_D_PAR, 4, 4)
    FIELD(NA_ERR_CTRL_1, INJECT_ISW_H_PAR, 0, 4)
REG32(NA_ERR_CTRL_3, 0x718)
    FIELD(NA_ERR_CTRL_3, DC_W_PAR_DONE, 3, 1)
    FIELD(NA_ERR_CTRL_3, DC_R_PAR_DONE, 2, 1)
    FIELD(NA_ERR_CTRL_3, INJECT_DC_W_PAR, 1, 1)
    FIELD(NA_ERR_CTRL_3, INJECT_DC_R_PAR, 0, 1)
REG32(REG_ADEC12, 0x71c)
    FIELD(REG_ADEC12, GROUP_MASK, 30, 2)
    FIELD(REG_ADEC12, BANK_MASK, 28, 2)
    FIELD(REG_ADEC12, COL_MASK, 18, 10)
    FIELD(REG_ADEC12, ROW_MASK, 0, 18)
REG32(REG_ADEC13, 0x720)
    FIELD(REG_ADEC13, CH_MASK, 5, 1)
    FIELD(REG_ADEC13, LRANK_MASK, 2, 3)
    FIELD(REG_ADEC13, RANK_MASK, 0, 2)
REG32(REG_ADEC14, 0x724)
    FIELD(REG_ADEC14, GROUP_MATCH, 30, 2)
    FIELD(REG_ADEC14, BANK_MATCH, 28, 2)
    FIELD(REG_ADEC14, COL_MATCH, 18, 10)
    FIELD(REG_ADEC14, ROW_MATCH, 0, 18)
REG32(REG_ADEC15, 0x728)
    FIELD(REG_ADEC15, MATCH_EN, 8, 1)
    FIELD(REG_ADEC15, DONE, 7, 1)
    FIELD(REG_ADEC15, PERSISTENT, 6, 1)
    FIELD(REG_ADEC15, CH_MATCH, 5, 1)
    FIELD(REG_ADEC15, LRANK_MATCH, 2, 3)
    FIELD(REG_ADEC15, RANK_MATCH, 0, 2)
REG32(ADD_PAR_ERR_INJ_ADEC, 0x72c)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ADEC_ADDR_PAR_LOG_EN1, 17, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ADEC_ADDR_PAR_CHK_EN1, 16, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ADEC_ADDR_PAR_LOG_EN0, 15, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ADEC_ADDR_PAR_CHK_EN0, 14, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, DRAM_RANK1, 12, 2)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ERR_INJ_DONE1, 11, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ADDRESS_TYPE1, 9, 2)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ERR_INJ_PERSISTENT1, 8, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ERR_INJ_EN1, 7, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, DRAM_RANK0, 5, 2)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ERR_INJ_DONE0, 4, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ADDRESS_TYPE0, 2, 2)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ERR_INJ_PERSISTENT0, 1, 1)
    FIELD(ADD_PAR_ERR_INJ_ADEC, ERR_INJ_EN0, 0, 1)
REG32(ADEC_ADD_PAR_ERR_LOG0_0, 0x730)
REG32(ADEC_ADD_PAR_ERR_LOG1_0, 0x734)
REG32(ADEC_ADD_PAR_ERR_LOG0_1, 0x738)
REG32(ADEC_ADD_PAR_ERR_LOG1_1, 0x73c)
REG32(REG_DBG_MUX_SEL, 0x740)
    FIELD(REG_DBG_MUX_SEL, TRIG_DONE, 9, 1)
    FIELD(REG_DBG_MUX_SEL, DAT_DISC, 8, 1)
    FIELD(REG_DBG_MUX_SEL, POST_TRIG_CNT, 5, 3)
    FIELD(REG_DBG_MUX_SEL, CLK_DIV, 4, 1)
    FIELD(REG_DBG_MUX_SEL, TRIG_EN, 3, 1)
    FIELD(REG_DBG_MUX_SEL, DBG_EN, 2, 1)
    FIELD(REG_DBG_MUX_SEL, IN_SEL, 1, 1)
    FIELD(REG_DBG_MUX_SEL, OUT_SEL, 0, 1)
REG32(REG_DBG_DATA_SEL, 0x744)
    FIELD(REG_DBG_DATA_SEL, DDRMC, 0, 8)
REG32(REG_DBG_TRIG_MVAL_L, 0x748)
REG32(REG_DBG_TRIG_MVAL_U, 0x74c)
REG32(REG_DBG_TRIG_MASK_L, 0x750)
REG32(REG_DBG_TRIG_MASK_U, 0x754)
REG32(DDRMC_CLK_MUX, 0x758)
    FIELD(DDRMC_CLK_MUX, SEL, 0, 1)
REG32(XMPU_CTRL, 0x10000)
    FIELD(XMPU_CTRL, ALIGNCFG, 3, 1)
    FIELD(XMPU_CTRL, HIDEALLOWED, 2, 1)
    FIELD(XMPU_CTRL, DEFWRALLOWED, 1, 1)
    FIELD(XMPU_CTRL, DEFRDALLOWED, 0, 1)
REG32(XMPU_ERR_STATUS, 0x10004)
    FIELD(XMPU_ERR_STATUS, REGIONVIO, 4, 5)
    FIELD(XMPU_ERR_STATUS, SECURITYVIO, 3, 1)
    FIELD(XMPU_ERR_STATUS, WRPERMVIO, 2, 1)
    FIELD(XMPU_ERR_STATUS, RDPERMVIO, 1, 1)
REG32(XMPU_ERR_ADD_LO0, 0x10008)
REG32(XMPU_ERR_ADD_HI0, 0x1000c)
    FIELD(XMPU_ERR_ADD_HI0, XMPU_ERR_ADD_HI, 0, 16)
REG32(XMPU_ERR_AXI_ID, 0x10010)
    FIELD(XMPU_ERR_AXI_ID, XMPU_ERR_SMID, 0, 10)
REG32(XMPU_LOCK, 0x10020)
    FIELD(XMPU_LOCK, PROT, 0, 1)
REG32(XMPU_START_LO0, 0x10100)
    FIELD(XMPU_START_LO0, ADDR_LO, 12, 20)
REG32(XMPU_START_HI0, 0x10104)
    FIELD(XMPU_START_HI0, ADDR_HI, 0, 16)
REG32(XMPU_END_LO0, 0x10108)
    FIELD(XMPU_END_LO0, ADDR_LO, 12, 20)
REG32(XMPU_END_HI0, 0x1010c)
    FIELD(XMPU_END_HI0, ADDR_HI, 0, 16)
REG32(XMPU_MASTER0, 0x10110)
    FIELD(XMPU_MASTER0, MASK, 16, 10)
    FIELD(XMPU_MASTER0, ID, 0, 10)
REG32(XMPU_CONFIG0, 0x10114)
    FIELD(XMPU_CONFIG0, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG0, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG0, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG0, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG0, ENABLE, 0, 1)
REG32(XMPU_START_LO1, 0x10118)
    FIELD(XMPU_START_LO1, ADDR_LO, 12, 20)
REG32(XMPU_START_HI1, 0x1011c)
    FIELD(XMPU_START_HI1, ADDR_HI, 0, 16)
REG32(XMPU_END_LO1, 0x10120)
    FIELD(XMPU_END_LO1, ADDR_LO, 12, 20)
REG32(XMPU_END_HI1, 0x10124)
    FIELD(XMPU_END_HI1, ADDR_HI, 0, 16)
REG32(XMPU_MASTER1, 0x10128)
    FIELD(XMPU_MASTER1, MASK, 16, 10)
    FIELD(XMPU_MASTER1, ID, 0, 10)
REG32(XMPU_CONFIG1, 0x1012c)
    FIELD(XMPU_CONFIG1, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG1, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG1, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG1, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG1, ENABLE, 0, 1)
REG32(XMPU_START_LO2, 0x10130)
    FIELD(XMPU_START_LO2, ADDR_LO, 12, 20)
REG32(XMPU_START_HI2, 0x10134)
    FIELD(XMPU_START_HI2, ADDR_HI, 0, 16)
REG32(XMPU_END_LO2, 0x10138)
    FIELD(XMPU_END_LO2, ADDR_LO, 12, 20)
REG32(XMPU_END_HI2, 0x1013c)
    FIELD(XMPU_END_HI2, ADDR_HI, 0, 16)
REG32(XMPU_MASTER2, 0x10140)
    FIELD(XMPU_MASTER2, MASK, 16, 10)
    FIELD(XMPU_MASTER2, ID, 0, 10)
REG32(XMPU_CONFIG2, 0x10144)
    FIELD(XMPU_CONFIG2, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG2, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG2, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG2, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG2, ENABLE, 0, 1)
REG32(XMPU_START_LO3, 0x10148)
    FIELD(XMPU_START_LO3, ADDR_LO, 12, 20)
REG32(XMPU_START_HI3, 0x1014c)
    FIELD(XMPU_START_HI3, ADDR_HI, 0, 16)
REG32(XMPU_END_LO3, 0x10150)
    FIELD(XMPU_END_LO3, ADDR_LO, 12, 20)
REG32(XMPU_END_HI3, 0x10154)
    FIELD(XMPU_END_HI3, ADDR_HI, 0, 16)
REG32(XMPU_MASTER3, 0x10158)
    FIELD(XMPU_MASTER3, MASK, 16, 10)
    FIELD(XMPU_MASTER3, ID, 0, 10)
REG32(XMPU_CONFIG3, 0x1015c)
    FIELD(XMPU_CONFIG3, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG3, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG3, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG3, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG3, ENABLE, 0, 1)
REG32(XMPU_START_LO4, 0x10160)
    FIELD(XMPU_START_LO4, ADDR_LO, 12, 20)
REG32(XMPU_START_HI4, 0x10164)
    FIELD(XMPU_START_HI4, ADDR_HI, 0, 16)
REG32(XMPU_END_LO4, 0x10168)
    FIELD(XMPU_END_LO4, ADDR_LO, 12, 20)
REG32(XMPU_END_HI4, 0x1016c)
    FIELD(XMPU_END_HI4, ADDR_HI, 0, 16)
REG32(XMPU_MASTER4, 0x10170)
    FIELD(XMPU_MASTER4, MASK, 16, 10)
    FIELD(XMPU_MASTER4, ID, 0, 10)
REG32(XMPU_CONFIG4, 0x10174)
    FIELD(XMPU_CONFIG4, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG4, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG4, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG4, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG4, ENABLE, 0, 1)
REG32(XMPU_START_LO5, 0x10178)
    FIELD(XMPU_START_LO5, ADDR_LO, 12, 20)
REG32(XMPU_START_HI5, 0x1017c)
    FIELD(XMPU_START_HI5, ADDR_HI, 0, 16)
REG32(XMPU_END_LO5, 0x10180)
    FIELD(XMPU_END_LO5, ADDR_LO, 12, 20)
REG32(XMPU_END_HI5, 0x10184)
    FIELD(XMPU_END_HI5, ADDR_HI, 0, 16)
REG32(XMPU_MASTER5, 0x10188)
    FIELD(XMPU_MASTER5, MASK, 16, 10)
    FIELD(XMPU_MASTER5, ID, 0, 10)
REG32(XMPU_CONFIG5, 0x1018c)
    FIELD(XMPU_CONFIG5, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG5, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG5, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG5, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG5, ENABLE, 0, 1)
REG32(XMPU_START_LO6, 0x10190)
    FIELD(XMPU_START_LO6, ADDR_LO, 12, 20)
REG32(XMPU_START_HI6, 0x10194)
    FIELD(XMPU_START_HI6, ADDR_HI, 0, 16)
REG32(XMPU_END_LO6, 0x10198)
    FIELD(XMPU_END_LO6, ADDR_LO, 12, 20)
REG32(XMPU_END_HI6, 0x1019c)
    FIELD(XMPU_END_HI6, ADDR_HI, 0, 16)
REG32(XMPU_MASTER6, 0x101a0)
    FIELD(XMPU_MASTER6, MASK, 16, 10)
    FIELD(XMPU_MASTER6, ID, 0, 10)
REG32(XMPU_CONFIG6, 0x101a4)
    FIELD(XMPU_CONFIG6, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG6, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG6, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG6, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG6, ENABLE, 0, 1)
REG32(XMPU_START_LO7, 0x101a8)
    FIELD(XMPU_START_LO7, ADDR_LO, 12, 20)
REG32(XMPU_START_HI7, 0x101ac)
    FIELD(XMPU_START_HI7, ADDR_HI, 0, 16)
REG32(XMPU_END_LO7, 0x101b0)
    FIELD(XMPU_END_LO7, ADDR_LO, 12, 20)
REG32(XMPU_END_HI7, 0x101b4)
    FIELD(XMPU_END_HI7, ADDR_HI, 0, 16)
REG32(XMPU_MASTER7, 0x101b8)
    FIELD(XMPU_MASTER7, MASK, 16, 10)
    FIELD(XMPU_MASTER7, ID, 0, 10)
REG32(XMPU_CONFIG7, 0x101bc)
    FIELD(XMPU_CONFIG7, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG7, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG7, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG7, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG7, ENABLE, 0, 1)
REG32(XMPU_START_LO8, 0x101c0)
    FIELD(XMPU_START_LO8, ADDR_LO, 12, 20)
REG32(XMPU_START_HI8, 0x101c4)
    FIELD(XMPU_START_HI8, ADDR_HI, 0, 16)
REG32(XMPU_END_LO8, 0x101c8)
    FIELD(XMPU_END_LO8, ADDR_LO, 12, 20)
REG32(XMPU_END_HI8, 0x101cc)
    FIELD(XMPU_END_HI8, ADDR_HI, 0, 16)
REG32(XMPU_MASTER8, 0x101d0)
    FIELD(XMPU_MASTER8, MASK, 16, 10)
    FIELD(XMPU_MASTER8, ID, 0, 10)
REG32(XMPU_CONFIG8, 0x101d4)
    FIELD(XMPU_CONFIG8, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG8, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG8, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG8, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG8, ENABLE, 0, 1)
REG32(XMPU_START_LO9, 0x101d8)
    FIELD(XMPU_START_LO9, ADDR_LO, 12, 20)
REG32(XMPU_START_HI9, 0x101dc)
    FIELD(XMPU_START_HI9, ADDR_HI, 0, 16)
REG32(XMPU_END_LO9, 0x101e0)
    FIELD(XMPU_END_LO9, ADDR_LO, 12, 20)
REG32(XMPU_END_HI9, 0x101e4)
    FIELD(XMPU_END_HI9, ADDR_HI, 0, 16)
REG32(XMPU_MASTER9, 0x101e8)
    FIELD(XMPU_MASTER9, MASK, 16, 10)
    FIELD(XMPU_MASTER9, ID, 0, 10)
REG32(XMPU_CONFIG9, 0x101ec)
    FIELD(XMPU_CONFIG9, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG9, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG9, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG9, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG9, ENABLE, 0, 1)
REG32(XMPU_START_LO10, 0x101f0)
    FIELD(XMPU_START_LO10, ADDR_LO, 12, 20)
REG32(XMPU_START_HI10, 0x101f4)
    FIELD(XMPU_START_HI10, ADDR_HI, 0, 16)
REG32(XMPU_END_LO10, 0x101f8)
    FIELD(XMPU_END_LO10, ADDR_LO, 12, 20)
REG32(XMPU_END_HI10, 0x101fc)
    FIELD(XMPU_END_HI10, ADDR_HI, 0, 16)
REG32(XMPU_MASTER10, 0x10200)
    FIELD(XMPU_MASTER10, MASK, 16, 10)
    FIELD(XMPU_MASTER10, ID, 0, 10)
REG32(XMPU_CONFIG10, 0x10204)
    FIELD(XMPU_CONFIG10, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG10, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG10, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG10, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG10, ENABLE, 0, 1)
REG32(XMPU_START_LO11, 0x10208)
    FIELD(XMPU_START_LO11, ADDR_LO, 12, 20)
REG32(XMPU_START_HI11, 0x1020c)
    FIELD(XMPU_START_HI11, ADDR_HI, 0, 16)
REG32(XMPU_END_LO11, 0x10210)
    FIELD(XMPU_END_LO11, ADDR_LO, 12, 20)
REG32(XMPU_END_HI11, 0x10214)
    FIELD(XMPU_END_HI11, ADDR_HI, 0, 16)
REG32(XMPU_MASTER11, 0x10218)
    FIELD(XMPU_MASTER11, MASK, 16, 10)
    FIELD(XMPU_MASTER11, ID, 0, 10)
REG32(XMPU_CONFIG11, 0x1021c)
    FIELD(XMPU_CONFIG11, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG11, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG11, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG11, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG11, ENABLE, 0, 1)
REG32(XMPU_START_LO12, 0x10220)
    FIELD(XMPU_START_LO12, ADDR_LO, 12, 20)
REG32(XMPU_START_HI12, 0x10224)
    FIELD(XMPU_START_HI12, ADDR_HI, 0, 16)
REG32(XMPU_END_LO12, 0x10228)
    FIELD(XMPU_END_LO12, ADDR_LO, 12, 20)
REG32(XMPU_END_HI12, 0x1022c)
    FIELD(XMPU_END_HI12, ADDR_HI, 0, 16)
REG32(XMPU_MASTER12, 0x10230)
    FIELD(XMPU_MASTER12, MASK, 16, 10)
    FIELD(XMPU_MASTER12, ID, 0, 10)
REG32(XMPU_CONFIG12, 0x10234)
    FIELD(XMPU_CONFIG12, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG12, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG12, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG12, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG12, ENABLE, 0, 1)
REG32(XMPU_START_LO13, 0x10238)
    FIELD(XMPU_START_LO13, ADDR_LO, 12, 20)
REG32(XMPU_START_HI13, 0x1023c)
    FIELD(XMPU_START_HI13, ADDR_HI, 0, 16)
REG32(XMPU_END_LO13, 0x10240)
    FIELD(XMPU_END_LO13, ADDR_LO, 12, 20)
REG32(XMPU_END_HI13, 0x10244)
    FIELD(XMPU_END_HI13, ADDR_HI, 0, 16)
REG32(XMPU_MASTER13, 0x10248)
    FIELD(XMPU_MASTER13, MASK, 16, 10)
    FIELD(XMPU_MASTER13, ID, 0, 10)
REG32(XMPU_CONFIG13, 0x1024c)
    FIELD(XMPU_CONFIG13, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG13, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG13, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG13, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG13, ENABLE, 0, 1)
REG32(XMPU_START_LO14, 0x10250)
    FIELD(XMPU_START_LO14, ADDR_LO, 12, 20)
REG32(XMPU_START_HI14, 0x10254)
    FIELD(XMPU_START_HI14, ADDR_HI, 0, 16)
REG32(XMPU_END_LO14, 0x10258)
    FIELD(XMPU_END_LO14, ADDR_LO, 12, 20)
REG32(XMPU_END_HI14, 0x1025c)
    FIELD(XMPU_END_HI14, ADDR_HI, 0, 16)
REG32(XMPU_MASTER14, 0x10260)
    FIELD(XMPU_MASTER14, MASK, 16, 10)
    FIELD(XMPU_MASTER14, ID, 0, 10)
REG32(XMPU_CONFIG14, 0x10264)
    FIELD(XMPU_CONFIG14, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG14, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG14, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG14, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG14, ENABLE, 0, 1)
REG32(XMPU_START_LO15, 0x10268)
    FIELD(XMPU_START_LO15, ADDR_LO, 12, 20)
REG32(XMPU_START_HI15, 0x1026c)
    FIELD(XMPU_START_HI15, ADDR_HI, 0, 16)
REG32(XMPU_END_LO15, 0x10270)
    FIELD(XMPU_END_LO15, ADDR_LO, 12, 20)
REG32(XMPU_END_HI15, 0x10274)
    FIELD(XMPU_END_HI15, ADDR_HI, 0, 16)
REG32(XMPU_MASTER15, 0x10278)
    FIELD(XMPU_MASTER15, MASK, 16, 10)
    FIELD(XMPU_MASTER15, ID, 0, 10)
REG32(XMPU_CONFIG15, 0x1027c)
    FIELD(XMPU_CONFIG15, NSCHECKTYPE, 4, 1)
    FIELD(XMPU_CONFIG15, REGIONNS, 3, 1)
    FIELD(XMPU_CONFIG15, WRALLOWED, 2, 1)
    FIELD(XMPU_CONFIG15, RDALLOWED, 1, 1)
    FIELD(XMPU_CONFIG15, ENABLE, 0, 1)

#define DDRMC_NOC_R_MAX (R_XMPU_CONFIG15 + 1)
#define LOCK_VAL 0xF9E8D7C6

typedef struct DDRMC_NOC {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[DDRMC_NOC_R_MAX];
    RegisterInfo regs_info[DDRMC_NOC_R_MAX];
} DDRMC_NOC;

static void ddrmc_noc_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    DDRMC_NOC *s = XILINX_DDRMC_NOC(reg->opaque);
    uint32_t val = val64;
    bool locked;

    locked = ARRAY_FIELD_EX32(s->regs, PCSR_LOCK, STATE);
    if (locked && val == LOCK_VAL) {
        locked = false;
    } else {
        locked |= FIELD_EX32(val, PCSR_LOCK, STATE);
    }
    ARRAY_FIELD_DP32(s->regs, PCSR_LOCK, STATE, locked);
}

static const RegisterAccessInfo ddrmc_noc_regs_info[] = {
    {   .name = "PCSR_LOCK",  .addr = A_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .post_write = ddrmc_noc_lock_postw,
    },{ .name = "REG_NSU_0_ING",  .addr = A_REG_NSU_0_ING,
        .reset = 0x6432101,
        .rsvd = 0xf888888c,
        .ro = 0x88888c,
    },{ .name = "REG_NSU_0_EGR",  .addr = A_REG_NSU_0_EGR,
        .reset = 0x643210,
        .rsvd = 0xff888888,
        .ro = 0x88888,
    },{ .name = "REG_NSU_1_ING",  .addr = A_REG_NSU_1_ING,
        .reset = 0x6432101,
        .rsvd = 0xf888888c,
        .ro = 0x88888c,
    },{ .name = "REG_NSU_1_EGR",  .addr = A_REG_NSU_1_EGR,
        .reset = 0x643210,
        .rsvd = 0xff888888,
        .ro = 0x88888,
    },{ .name = "REG_NSU_2_ING",  .addr = A_REG_NSU_2_ING,
        .reset = 0x6432101,
        .rsvd = 0xf888888c,
        .ro = 0x88888c,
    },{ .name = "REG_NSU_2_EGR",  .addr = A_REG_NSU_2_EGR,
        .reset = 0x643210,
        .rsvd = 0xff888888,
        .ro = 0x88888,
    },{ .name = "REG_NSU_3_ING",  .addr = A_REG_NSU_3_ING,
        .reset = 0x6432101,
        .rsvd = 0xf888888c,
        .ro = 0x88888c,
    },{ .name = "REG_NSU_3_EGR",  .addr = A_REG_NSU_3_EGR,
        .reset = 0x643210,
        .rsvd = 0xff888888,
        .ro = 0x88888,
    },{ .name = "DC_CMD_CREDITS",  .addr = A_DC_CMD_CREDITS,
        .reset = 0x2a8,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADEC0",  .addr = A_REG_ADEC0,
        .rsvd = 0xfff00000,
    },{ .name = "REG_ADEC1",  .addr = A_REG_ADEC1,
        .rsvd = 0xfff00000,
    },{ .name = "REG_ADEC2",  .addr = A_REG_ADEC2,
        .reset = 0x100000,
        .rsvd = 0xffe00000,
    },{ .name = "REG_ADEC3",  .addr = A_REG_ADEC3,
        .rsvd = 0xfff00000,
    },{ .name = "REG_ADEC4",  .addr = A_REG_ADEC4,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC5",  .addr = A_REG_ADEC5,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC6",  .addr = A_REG_ADEC6,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC7",  .addr = A_REG_ADEC7,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC8",  .addr = A_REG_ADEC8,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC9",  .addr = A_REG_ADEC9,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC10",  .addr = A_REG_ADEC10,
        .rsvd = 0xc0000000,
    },{ .name = "REG_ADEC11",  .addr = A_REG_ADEC11,
        .rsvd = 0xff000000,
    },{ .name = "REG_NSU0_PORT",  .addr = A_REG_NSU0_PORT,
        .rsvd = 0xfffff000,
    },{ .name = "REG_NSU1_PORT",  .addr = A_REG_NSU1_PORT,
        .rsvd = 0xfffff000,
    },{ .name = "REG_NSU2_PORT",  .addr = A_REG_NSU2_PORT,
        .rsvd = 0xfffff000,
    },{ .name = "REG_NSU3_PORT",  .addr = A_REG_NSU3_PORT,
        .rsvd = 0xfffff000,
    },{ .name = "REG_NSU_0_R_EGR",  .addr = A_REG_NSU_0_R_EGR,
        .reset = 0x1010100,
        .rsvd = 0xf000000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_0_W_EGR",  .addr = A_REG_NSU_0_W_EGR,
        .reset = 0x10100,
        .rsvd = 0xfff0000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_1_R_EGR",  .addr = A_REG_NSU_1_R_EGR,
        .reset = 0x1010100,
        .rsvd = 0xf000000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_1_W_EGR",  .addr = A_REG_NSU_1_W_EGR,
        .reset = 0x10100,
        .rsvd = 0xfff0000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_2_R_EGR",  .addr = A_REG_NSU_2_R_EGR,
        .reset = 0x1010100,
        .rsvd = 0xf000000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_2_W_EGR",  .addr = A_REG_NSU_2_W_EGR,
        .reset = 0x10100,
        .rsvd = 0xfff0000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_3_R_EGR",  .addr = A_REG_NSU_3_R_EGR,
        .reset = 0x1010100,
        .rsvd = 0xf000000f,
        .ro = 0xf,
    },{ .name = "REG_NSU_3_W_EGR",  .addr = A_REG_NSU_3_W_EGR,
        .reset = 0x10100,
        .rsvd = 0xfff0000f,
        .ro = 0xf,
    },{ .name = "REG_RD_DRR_TKN_P0",  .addr = A_REG_RD_DRR_TKN_P0,
        .reset = 0x40404,
        .rsvd = 0xff000000,
    },{ .name = "REG_WR_DRR_TKN_P0",  .addr = A_REG_WR_DRR_TKN_P0,
        .reset = 0x404,
        .rsvd = 0xffff0000,
    },{ .name = "REG_RD_DRR_TKN_P1",  .addr = A_REG_RD_DRR_TKN_P1,
        .reset = 0x40404,
        .rsvd = 0xff000000,
    },{ .name = "REG_WR_DRR_TKN_P1",  .addr = A_REG_WR_DRR_TKN_P1,
        .reset = 0x404,
        .rsvd = 0xffff0000,
    },{ .name = "REG_RD_DRR_TKN_P2",  .addr = A_REG_RD_DRR_TKN_P2,
        .reset = 0x40404,
        .rsvd = 0xff000000,
    },{ .name = "REG_WR_DRR_TKN_P2",  .addr = A_REG_WR_DRR_TKN_P2,
        .reset = 0x404,
        .rsvd = 0xffff0000,
    },{ .name = "REG_RD_DRR_TKN_P3",  .addr = A_REG_RD_DRR_TKN_P3,
        .reset = 0x40404,
        .rsvd = 0xff000000,
    },{ .name = "REG_WR_DRR_TKN_P3",  .addr = A_REG_WR_DRR_TKN_P3,
        .reset = 0x404,
        .rsvd = 0xffff0000,
    },{ .name = "REG_QOS0",  .addr = A_REG_QOS0,
        .reset = 0xf00f0,
        .rsvd = 0xf000000e,
        .ro = 0xe,
    },{ .name = "REG_QOS1",  .addr = A_REG_QOS1,
        .reset = 0x200804,
        .rsvd = 0xc0000000,
    },{ .name = "REG_QOS2",  .addr = A_REG_QOS2,
        .reset = 0x802,
        .rsvd = 0xfff00000,
    },{ .name = "REG_QOS_TIMEOUT0",  .addr = A_REG_QOS_TIMEOUT0,
        .reset = 0x1084210,
        .rsvd = 0xfe000000,
    },{ .name = "REG_QOS_TIMEOUT1",  .addr = A_REG_QOS_TIMEOUT1,
        .reset = 0xffffffff,
    },{ .name = "REG_QOS_TIMEOUT2",  .addr = A_REG_QOS_TIMEOUT2,
        .reset = 0xff,
        .rsvd = 0xffffff00,
    },{ .name = "REG_RATE_CTRL_SCALE",  .addr = A_REG_RATE_CTRL_SCALE,
        .rsvd = 0xfe000000,
    },{ .name = "REG_P0_LLR_RATE_CTRL",  .addr = A_REG_P0_LLR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P0_ISR_RATE_CTRL",  .addr = A_REG_P0_ISR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P0_BER_RATE_CTRL",  .addr = A_REG_P0_BER_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P0_ISW_RATE_CTRL",  .addr = A_REG_P0_ISW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P0_BEW_RATE_CTRL",  .addr = A_REG_P0_BEW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P1_LLR_RATE_CTRL",  .addr = A_REG_P1_LLR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P1_ISR_RATE_CTRL",  .addr = A_REG_P1_ISR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P1_BER_RATE_CTRL",  .addr = A_REG_P1_BER_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P1_ISW_RATE_CTRL",  .addr = A_REG_P1_ISW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P1_BEW_RATE_CTRL",  .addr = A_REG_P1_BEW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P2_LLR_RATE_CTRL",  .addr = A_REG_P2_LLR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P2_ISR_RATE_CTRL",  .addr = A_REG_P2_ISR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P2_BER_RATE_CTRL",  .addr = A_REG_P2_BER_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P2_ISW_RATE_CTRL",  .addr = A_REG_P2_ISW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P2_BEW_RATE_CTRL",  .addr = A_REG_P2_BEW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P3_LLR_RATE_CTRL",  .addr = A_REG_P3_LLR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P3_ISR_RATE_CTRL",  .addr = A_REG_P3_ISR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P3_BER_RATE_CTRL",  .addr = A_REG_P3_BER_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P3_ISW_RATE_CTRL",  .addr = A_REG_P3_ISW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_P3_BEW_RATE_CTRL",  .addr = A_REG_P3_BEW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_CMDQ_CTRL0",  .addr = A_REG_CMDQ_CTRL0,
        .reset = 0x1084210,
        .rsvd = 0xfe000000,
    },{ .name = "REG_CMDQ_CTRL1",  .addr = A_REG_CMDQ_CTRL1,
        .reset = 0x1084210,
        .rsvd = 0xfe000000,
    },{ .name = "REG_CMDQ_LLR_RATE_CTRL",  .addr = A_REG_CMDQ_LLR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_CMDQ_ISR_RATE_CTRL",  .addr = A_REG_CMDQ_ISR_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_CMDQ_BER_RATE_CTRL",  .addr = A_REG_CMDQ_BER_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_CMDQ_ISW_RATE_CTRL",  .addr = A_REG_CMDQ_ISW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_CMDQ_BEW_RATE_CTRL",  .addr = A_REG_CMDQ_BEW_RATE_CTRL,
        .reset = 0x3ffc0f,
        .rsvd = 0xffc00000,
    },{ .name = "REG_QOS_RATE_CTRL_SCALE",  .addr = A_REG_QOS_RATE_CTRL_SCALE,
        .rsvd = 0xfe000000,
    },{ .name = "EXMON_CLR_EXE",  .addr = A_EXMON_CLR_EXE,
        .reset = 0x100,
        .rsvd = 0xfffffe00,
    },{ .name = "UB_CLK_MUX",  .addr = A_UB_CLK_MUX,
        .rsvd = 0xfffffffc,
    },{ .name = "PERF_MON_TIMEBASE_SCALE",  .addr = A_PERF_MON_TIMEBASE_SCALE,
        .reset = 0xbdef7,
        .rsvd = 0xfff00000,
    },{ .name = "NSU0_PERF_MON_CTL_0_0",  .addr = A_NSU0_PERF_MON_CTL_0_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU0_PERF_MON_CTL_0_1",  .addr = A_NSU0_PERF_MON_CTL_0_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU0_PERF_FILTER_0_0",  .addr = A_NSU0_PERF_FILTER_0_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU0_PERF_FILTER_0_1",  .addr = A_NSU0_PERF_FILTER_0_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU0_PERF_FILTER_EN_0",  .addr = A_NSU0_PERF_FILTER_EN_0,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU0_PERF_MON_0_0",  .addr = A_NSU0_PERF_MON_0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU0_PERF_MON_0_1",  .addr = A_NSU0_PERF_MON_0_1,
        .ro = 0xffffffff,
    },{ .name = "NSU0_PERF_MON_0_2",  .addr = A_NSU0_PERF_MON_0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU0_PERF_MON_CTL_1_0",  .addr = A_NSU0_PERF_MON_CTL_1_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU0_PERF_MON_CTL_1_1",  .addr = A_NSU0_PERF_MON_CTL_1_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU0_PERF_FILTER_1_0",  .addr = A_NSU0_PERF_FILTER_1_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU0_PERF_FILTER_1_1",  .addr = A_NSU0_PERF_FILTER_1_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU0_PERF_FILTER_EN_1",  .addr = A_NSU0_PERF_FILTER_EN_1,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU0_PERF_MON_1_0",  .addr = A_NSU0_PERF_MON_1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU0_PERF_MON_1_1",  .addr = A_NSU0_PERF_MON_1_1,
        .ro = 0xffffffff,
    },{ .name = "NSU0_PERF_MON_1_2",  .addr = A_NSU0_PERF_MON_1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU1_PERF_MON_CTL_0_0",  .addr = A_NSU1_PERF_MON_CTL_0_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU1_PERF_MON_CTL_0_1",  .addr = A_NSU1_PERF_MON_CTL_0_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU1_PERF_FILTER_0_0",  .addr = A_NSU1_PERF_FILTER_0_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU1_PERF_FILTER_0_1",  .addr = A_NSU1_PERF_FILTER_0_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU1_PERF_FILTER_EN_0",  .addr = A_NSU1_PERF_FILTER_EN_0,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU1_PERF_MON_0_0",  .addr = A_NSU1_PERF_MON_0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU1_PERF_MON_0_1",  .addr = A_NSU1_PERF_MON_0_1,
        .ro = 0xffffffff,
    },{ .name = "NSU1_PERF_MON_0_2",  .addr = A_NSU1_PERF_MON_0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU1_PERF_MON_CTL_1_0",  .addr = A_NSU1_PERF_MON_CTL_1_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU1_PERF_MON_CTL_1_1",  .addr = A_NSU1_PERF_MON_CTL_1_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU1_PERF_FILTER_1_0",  .addr = A_NSU1_PERF_FILTER_1_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU1_PERF_FILTER_1_1",  .addr = A_NSU1_PERF_FILTER_1_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU1_PERF_FILTER_EN_1",  .addr = A_NSU1_PERF_FILTER_EN_1,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU1_PERF_MON_1_0",  .addr = A_NSU1_PERF_MON_1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU1_PERF_MON_1_1",  .addr = A_NSU1_PERF_MON_1_1,
        .ro = 0xffffffff,
    },{ .name = "NSU1_PERF_MON_1_2",  .addr = A_NSU1_PERF_MON_1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU2_PERF_MON_CTL_0_0",  .addr = A_NSU2_PERF_MON_CTL_0_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU2_PERF_MON_CTL_0_1",  .addr = A_NSU2_PERF_MON_CTL_0_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU2_PERF_FILTER_0_0",  .addr = A_NSU2_PERF_FILTER_0_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU2_PERF_FILTER_0_1",  .addr = A_NSU2_PERF_FILTER_0_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU2_PERF_FILTER_EN_0",  .addr = A_NSU2_PERF_FILTER_EN_0,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU2_PERF_MON_0_0",  .addr = A_NSU2_PERF_MON_0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU2_PERF_MON_0_1",  .addr = A_NSU2_PERF_MON_0_1,
        .ro = 0xffffffff,
    },{ .name = "NSU2_PERF_MON_0_2",  .addr = A_NSU2_PERF_MON_0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU2_PERF_MON_CTL_1_0",  .addr = A_NSU2_PERF_MON_CTL_1_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU2_PERF_MON_CTL_1_1",  .addr = A_NSU2_PERF_MON_CTL_1_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU2_PERF_FILTER_1_0",  .addr = A_NSU2_PERF_FILTER_1_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU2_PERF_FILTER_1_1",  .addr = A_NSU2_PERF_FILTER_1_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU2_PERF_FILTER_EN_1",  .addr = A_NSU2_PERF_FILTER_EN_1,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU2_PERF_MON_1_0",  .addr = A_NSU2_PERF_MON_1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU2_PERF_MON_1_1",  .addr = A_NSU2_PERF_MON_1_1,
        .ro = 0xffffffff,
    },{ .name = "NSU2_PERF_MON_1_2",  .addr = A_NSU2_PERF_MON_1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU3_PERF_MON_CTL_0_0",  .addr = A_NSU3_PERF_MON_CTL_0_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU3_PERF_MON_CTL_0_1",  .addr = A_NSU3_PERF_MON_CTL_0_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU3_PERF_FILTER_0_0",  .addr = A_NSU3_PERF_FILTER_0_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU3_PERF_FILTER_0_1",  .addr = A_NSU3_PERF_FILTER_0_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU3_PERF_FILTER_EN_0",  .addr = A_NSU3_PERF_FILTER_EN_0,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU3_PERF_MON_0_0",  .addr = A_NSU3_PERF_MON_0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU3_PERF_MON_0_1",  .addr = A_NSU3_PERF_MON_0_1,
        .ro = 0xffffffff,
    },{ .name = "NSU3_PERF_MON_0_2",  .addr = A_NSU3_PERF_MON_0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU3_PERF_MON_CTL_1_0",  .addr = A_NSU3_PERF_MON_CTL_1_0,
        .rsvd = 0xfffffffc,
    },{ .name = "NSU3_PERF_MON_CTL_1_1",  .addr = A_NSU3_PERF_MON_CTL_1_1,
        .rsvd = 0xffffff00,
    },{ .name = "NSU3_PERF_FILTER_1_0",  .addr = A_NSU3_PERF_FILTER_1_0,
        .rsvd = 0xc0000000,
    },{ .name = "NSU3_PERF_FILTER_1_1",  .addr = A_NSU3_PERF_FILTER_1_1,
        .rsvd = 0xfffff000,
    },{ .name = "NSU3_PERF_FILTER_EN_1",  .addr = A_NSU3_PERF_FILTER_EN_1,
        .rsvd = 0xffffffc0,
    },{ .name = "NSU3_PERF_MON_1_0",  .addr = A_NSU3_PERF_MON_1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU3_PERF_MON_1_1",  .addr = A_NSU3_PERF_MON_1_1,
        .ro = 0xffffffff,
    },{ .name = "NSU3_PERF_MON_1_2",  .addr = A_NSU3_PERF_MON_1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG0_EN",  .addr = A_NSU0_ERR_LOG0_EN,
        .reset = 0x1fff,
        .rsvd = 0xfe000000,
    },{ .name = "NSU0_ERR_LOG1_EN",  .addr = A_NSU0_ERR_LOG1_EN,
        .reset = 0x107e000,
        .rsvd = 0xfe000000,
    },{ .name = "NSU0_ERR_STATUS",  .addr = A_NSU0_ERR_STATUS,
        .rsvd = 0xfe000000,
        .w1c = 0x1ffffff,
    },{ .name = "NSU0_ERR_LOG0_0",  .addr = A_NSU0_ERR_LOG0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG0_1",  .addr = A_NSU0_ERR_LOG0_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG0_2",  .addr = A_NSU0_ERR_LOG0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG0_3",  .addr = A_NSU0_ERR_LOG0_3,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG0_4",  .addr = A_NSU0_ERR_LOG0_4,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG1_0",  .addr = A_NSU0_ERR_LOG1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG1_1",  .addr = A_NSU0_ERR_LOG1_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG1_2",  .addr = A_NSU0_ERR_LOG1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG1_3",  .addr = A_NSU0_ERR_LOG1_3,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_LOG1_4",  .addr = A_NSU0_ERR_LOG1_4,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG0_EN",  .addr = A_NSU1_ERR_LOG0_EN,
        .reset = 0x1fff,
        .rsvd = 0xfe000000,
    },{ .name = "NSU1_ERR_LOG1_EN",  .addr = A_NSU1_ERR_LOG1_EN,
        .reset = 0x107e000,
        .rsvd = 0xfe000000,
    },{ .name = "NSU1_ERR_STATUS",  .addr = A_NSU1_ERR_STATUS,
        .rsvd = 0xfe000000,
        .w1c = 0x1ffffff,
    },{ .name = "NSU1_ERR_LOG0_0",  .addr = A_NSU1_ERR_LOG0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG0_1",  .addr = A_NSU1_ERR_LOG0_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG0_2",  .addr = A_NSU1_ERR_LOG0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG0_3",  .addr = A_NSU1_ERR_LOG0_3,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG0_4",  .addr = A_NSU1_ERR_LOG0_4,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG1_0",  .addr = A_NSU1_ERR_LOG1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG1_1",  .addr = A_NSU1_ERR_LOG1_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG1_2",  .addr = A_NSU1_ERR_LOG1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG1_3",  .addr = A_NSU1_ERR_LOG1_3,
        .ro = 0xffffffff,
    },{ .name = "NSU1_ERR_LOG1_4",  .addr = A_NSU1_ERR_LOG1_4,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG0_EN",  .addr = A_NSU2_ERR_LOG0_EN,
        .reset = 0x1fff,
        .rsvd = 0xfe000000,
    },{ .name = "NSU2_ERR_LOG1_EN",  .addr = A_NSU2_ERR_LOG1_EN,
        .reset = 0x107e000,
        .rsvd = 0xfe000000,
    },{ .name = "NSU2_ERR_STATUS",  .addr = A_NSU2_ERR_STATUS,
        .rsvd = 0xfe000000,
        .w1c = 0x1ffffff,
    },{ .name = "NSU2_ERR_LOG0_0",  .addr = A_NSU2_ERR_LOG0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG0_1",  .addr = A_NSU2_ERR_LOG0_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG0_2",  .addr = A_NSU2_ERR_LOG0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG0_3",  .addr = A_NSU2_ERR_LOG0_3,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG0_4",  .addr = A_NSU2_ERR_LOG0_4,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG1_0",  .addr = A_NSU2_ERR_LOG1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG1_1",  .addr = A_NSU2_ERR_LOG1_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG1_2",  .addr = A_NSU2_ERR_LOG1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG1_3",  .addr = A_NSU2_ERR_LOG1_3,
        .ro = 0xffffffff,
    },{ .name = "NSU2_ERR_LOG1_4",  .addr = A_NSU2_ERR_LOG1_4,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG0_EN",  .addr = A_NSU3_ERR_LOG0_EN,
        .reset = 0x1fff,
        .rsvd = 0xfe000000,
    },{ .name = "NSU3_ERR_LOG1_EN",  .addr = A_NSU3_ERR_LOG1_EN,
        .reset = 0x107e000,
        .rsvd = 0xfe000000,
    },{ .name = "NSU3_ERR_STATUS",  .addr = A_NSU3_ERR_STATUS,
        .rsvd = 0xfe000000,
        .w1c = 0x1ffffff,
    },{ .name = "NSU3_ERR_LOG0_0",  .addr = A_NSU3_ERR_LOG0_0,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG0_1",  .addr = A_NSU3_ERR_LOG0_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG0_2",  .addr = A_NSU3_ERR_LOG0_2,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG0_3",  .addr = A_NSU3_ERR_LOG0_3,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG0_4",  .addr = A_NSU3_ERR_LOG0_4,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG1_0",  .addr = A_NSU3_ERR_LOG1_0,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG1_1",  .addr = A_NSU3_ERR_LOG1_1,
        .rsvd = 0x40000000,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG1_2",  .addr = A_NSU3_ERR_LOG1_2,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG1_3",  .addr = A_NSU3_ERR_LOG1_3,
        .ro = 0xffffffff,
    },{ .name = "NSU3_ERR_LOG1_4",  .addr = A_NSU3_ERR_LOG1_4,
        .ro = 0xffffffff,
    },{ .name = "NSU0_ERR_CTRL",  .addr = A_NSU0_ERR_CTRL,
        .reset = 0x3000,
        .rsvd = 0xff800fff,
        .ro = 0xfff,
    },{ .name = "NSU1_ERR_CTRL",  .addr = A_NSU1_ERR_CTRL,
        .reset = 0x3000,
        .rsvd = 0xff800fff,
        .ro = 0xfff,
    },{ .name = "NSU2_ERR_CTRL",  .addr = A_NSU2_ERR_CTRL,
        .reset = 0x3000,
        .rsvd = 0xff800fff,
        .ro = 0xfff,
    },{ .name = "NSU3_ERR_CTRL",  .addr = A_NSU3_ERR_CTRL,
        .reset = 0x3000,
        .rsvd = 0xff800fff,
        .ro = 0xfff,
    },{ .name = "ECC_ERR_INJ_NSU0",  .addr = A_ECC_ERR_INJ_NSU0,
        .rsvd = 0xfe000000,
    },{ .name = "ECC_ERR_INJ_NSU1",  .addr = A_ECC_ERR_INJ_NSU1,
        .rsvd = 0xfe000000,
    },{ .name = "ECC_ERR_INJ_NSU2",  .addr = A_ECC_ERR_INJ_NSU2,
        .rsvd = 0xfe000000,
    },{ .name = "ECC_ERR_INJ_NSU3",  .addr = A_ECC_ERR_INJ_NSU3,
        .rsvd = 0xfe000000,
    },{ .name = "ILA_MUX_N0",  .addr = A_ILA_MUX_N0,
    },{ .name = "ILA_MUX_N1",  .addr = A_ILA_MUX_N1,
    },{ .name = "ILA_MUX_N2",  .addr = A_ILA_MUX_N2,
    },{ .name = "ILA_MUX_N3",  .addr = A_ILA_MUX_N3,
    },{ .name = "ILA_MUX_N4",  .addr = A_ILA_MUX_N4,
    },{ .name = "ILA_MUX_N5",  .addr = A_ILA_MUX_N5,
    },{ .name = "ILA_MUX_N6",  .addr = A_ILA_MUX_N6,
    },{ .name = "ILA_MUX_N7",  .addr = A_ILA_MUX_N7,
    },{ .name = "ILA_MUX_N8",  .addr = A_ILA_MUX_N8,
    },{ .name = "ILA_MUX_N9",  .addr = A_ILA_MUX_N9,
    },{ .name = "ILA_MUX_N10",  .addr = A_ILA_MUX_N10,
    },{ .name = "ILA_MUX_N11",  .addr = A_ILA_MUX_N11,
    },{ .name = "ILA_MUX_N12",  .addr = A_ILA_MUX_N12,
    },{ .name = "ILA_MUX_N13",  .addr = A_ILA_MUX_N13,
    },{ .name = "ILA_MUX_N14",  .addr = A_ILA_MUX_N14,
    },{ .name = "ILA_MUX_N15",  .addr = A_ILA_MUX_N15,
    },{ .name = "ILA_MUX_N16",  .addr = A_ILA_MUX_N16,
    },{ .name = "ILA_MUX_N17",  .addr = A_ILA_MUX_N17,
    },{ .name = "NA_ERR_CTRL_0",  .addr = A_NA_ERR_CTRL_0,
        .reset = 0x10000000,
        .rsvd = 0xe0000000,
    },{ .name = "NA_ERR_CTRL_1",  .addr = A_NA_ERR_CTRL_1,
    },{ .name = "NA_ERR_CTRL_3",  .addr = A_NA_ERR_CTRL_3,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_ADEC12",  .addr = A_REG_ADEC12,
    },{ .name = "REG_ADEC13",  .addr = A_REG_ADEC13,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_ADEC14",  .addr = A_REG_ADEC14,
    },{ .name = "REG_ADEC15",  .addr = A_REG_ADEC15,
        .rsvd = 0xfffffe00,
    },{ .name = "ADD_PAR_ERR_INJ_ADEC",  .addr = A_ADD_PAR_ERR_INJ_ADEC,
        .reset = 0x3c000,
        .rsvd = 0xfffc0000,
    },{ .name = "ADEC_ADD_PAR_ERR_LOG0_0",  .addr = A_ADEC_ADD_PAR_ERR_LOG0_0,
    },{ .name = "ADEC_ADD_PAR_ERR_LOG1_0",  .addr = A_ADEC_ADD_PAR_ERR_LOG1_0,
    },{ .name = "ADEC_ADD_PAR_ERR_LOG0_1",  .addr = A_ADEC_ADD_PAR_ERR_LOG0_1,
    },{ .name = "ADEC_ADD_PAR_ERR_LOG1_1",  .addr = A_ADEC_ADD_PAR_ERR_LOG1_1,
    },{ .name = "REG_DBG_MUX_SEL",  .addr = A_REG_DBG_MUX_SEL,
        .rsvd = 0xfffffc00,
        .ro = 0x200,
    },{ .name = "REG_DBG_DATA_SEL",  .addr = A_REG_DBG_DATA_SEL,
        .rsvd = 0xffffff00,
    },{ .name = "REG_DBG_TRIG_MVAL_L",  .addr = A_REG_DBG_TRIG_MVAL_L,
    },{ .name = "REG_DBG_TRIG_MVAL_U",  .addr = A_REG_DBG_TRIG_MVAL_U,
    },{ .name = "REG_DBG_TRIG_MASK_L",  .addr = A_REG_DBG_TRIG_MASK_L,
    },{ .name = "REG_DBG_TRIG_MASK_U",  .addr = A_REG_DBG_TRIG_MASK_U,
    },{ .name = "DDRMC_CLK_MUX",  .addr = A_DDRMC_CLK_MUX,
        .rsvd = 0xfffffffe,
    },{ .name = "XMPU_CTRL",  .addr = A_XMPU_CTRL,
        .reset = 0xb,
        .rsvd = 0xfffffff0,
    },{ .name = "XMPU_ERR_STATUS",  .addr = A_XMPU_ERR_STATUS,
        .rsvd = 0xfffffe01,
        .ro = 0x1,
    },{ .name = "XMPU_ERR_ADD_LO0",  .addr = A_XMPU_ERR_ADD_LO0,
    },{ .name = "XMPU_ERR_ADD_HI0",  .addr = A_XMPU_ERR_ADD_HI0,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_ERR_AXI_ID",  .addr = A_XMPU_ERR_AXI_ID,
        .rsvd = 0xfffffc00,
    },{ .name = "XMPU_LOCK",  .addr = A_XMPU_LOCK,
    },{ .name = "XMPU_START_LO0",  .addr = A_XMPU_START_LO0,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI0",  .addr = A_XMPU_START_HI0,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO0",  .addr = A_XMPU_END_LO0,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI0",  .addr = A_XMPU_END_HI0,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER0",  .addr = A_XMPU_MASTER0,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG0",  .addr = A_XMPU_CONFIG0,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO1",  .addr = A_XMPU_START_LO1,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI1",  .addr = A_XMPU_START_HI1,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO1",  .addr = A_XMPU_END_LO1,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI1",  .addr = A_XMPU_END_HI1,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER1",  .addr = A_XMPU_MASTER1,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG1",  .addr = A_XMPU_CONFIG1,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO2",  .addr = A_XMPU_START_LO2,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI2",  .addr = A_XMPU_START_HI2,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO2",  .addr = A_XMPU_END_LO2,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI2",  .addr = A_XMPU_END_HI2,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER2",  .addr = A_XMPU_MASTER2,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG2",  .addr = A_XMPU_CONFIG2,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO3",  .addr = A_XMPU_START_LO3,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI3",  .addr = A_XMPU_START_HI3,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO3",  .addr = A_XMPU_END_LO3,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI3",  .addr = A_XMPU_END_HI3,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER3",  .addr = A_XMPU_MASTER3,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG3",  .addr = A_XMPU_CONFIG3,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO4",  .addr = A_XMPU_START_LO4,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI4",  .addr = A_XMPU_START_HI4,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO4",  .addr = A_XMPU_END_LO4,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI4",  .addr = A_XMPU_END_HI4,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER4",  .addr = A_XMPU_MASTER4,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG4",  .addr = A_XMPU_CONFIG4,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO5",  .addr = A_XMPU_START_LO5,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI5",  .addr = A_XMPU_START_HI5,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO5",  .addr = A_XMPU_END_LO5,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI5",  .addr = A_XMPU_END_HI5,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER5",  .addr = A_XMPU_MASTER5,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG5",  .addr = A_XMPU_CONFIG5,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO6",  .addr = A_XMPU_START_LO6,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI6",  .addr = A_XMPU_START_HI6,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO6",  .addr = A_XMPU_END_LO6,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI6",  .addr = A_XMPU_END_HI6,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER6",  .addr = A_XMPU_MASTER6,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG6",  .addr = A_XMPU_CONFIG6,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO7",  .addr = A_XMPU_START_LO7,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI7",  .addr = A_XMPU_START_HI7,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO7",  .addr = A_XMPU_END_LO7,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI7",  .addr = A_XMPU_END_HI7,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER7",  .addr = A_XMPU_MASTER7,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG7",  .addr = A_XMPU_CONFIG7,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO8",  .addr = A_XMPU_START_LO8,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI8",  .addr = A_XMPU_START_HI8,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO8",  .addr = A_XMPU_END_LO8,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI8",  .addr = A_XMPU_END_HI8,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER8",  .addr = A_XMPU_MASTER8,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG8",  .addr = A_XMPU_CONFIG8,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO9",  .addr = A_XMPU_START_LO9,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI9",  .addr = A_XMPU_START_HI9,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO9",  .addr = A_XMPU_END_LO9,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI9",  .addr = A_XMPU_END_HI9,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER9",  .addr = A_XMPU_MASTER9,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG9",  .addr = A_XMPU_CONFIG9,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO10",  .addr = A_XMPU_START_LO10,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI10",  .addr = A_XMPU_START_HI10,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO10",  .addr = A_XMPU_END_LO10,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI10",  .addr = A_XMPU_END_HI10,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER10",  .addr = A_XMPU_MASTER10,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG10",  .addr = A_XMPU_CONFIG10,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO11",  .addr = A_XMPU_START_LO11,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI11",  .addr = A_XMPU_START_HI11,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO11",  .addr = A_XMPU_END_LO11,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI11",  .addr = A_XMPU_END_HI11,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER11",  .addr = A_XMPU_MASTER11,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG11",  .addr = A_XMPU_CONFIG11,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO12",  .addr = A_XMPU_START_LO12,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI12",  .addr = A_XMPU_START_HI12,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO12",  .addr = A_XMPU_END_LO12,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI12",  .addr = A_XMPU_END_HI12,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER12",  .addr = A_XMPU_MASTER12,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG12",  .addr = A_XMPU_CONFIG12,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO13",  .addr = A_XMPU_START_LO13,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI13",  .addr = A_XMPU_START_HI13,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO13",  .addr = A_XMPU_END_LO13,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI13",  .addr = A_XMPU_END_HI13,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER13",  .addr = A_XMPU_MASTER13,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG13",  .addr = A_XMPU_CONFIG13,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO14",  .addr = A_XMPU_START_LO14,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI14",  .addr = A_XMPU_START_HI14,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO14",  .addr = A_XMPU_END_LO14,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI14",  .addr = A_XMPU_END_HI14,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER14",  .addr = A_XMPU_MASTER14,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG14",  .addr = A_XMPU_CONFIG14,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    },{ .name = "XMPU_START_LO15",  .addr = A_XMPU_START_LO15,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_START_HI15",  .addr = A_XMPU_START_HI15,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_END_LO15",  .addr = A_XMPU_END_LO15,
        .rsvd = 0xfff,
        .ro = 0xfff,
    },{ .name = "XMPU_END_HI15",  .addr = A_XMPU_END_HI15,
        .rsvd = 0xffff0000,
    },{ .name = "XMPU_MASTER15",  .addr = A_XMPU_MASTER15,
        .rsvd = 0xfc00fc00,
        .ro = 0xfc00,
    },{ .name = "XMPU_CONFIG15",  .addr = A_XMPU_CONFIG15,
        .reset = 0x8,
        .rsvd = 0xffffffe0,
    }
};

static void ddrmc_noc_reset(DeviceState *dev)
{
    DDRMC_NOC *s = XILINX_DDRMC_NOC(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static MemTxResult reg_write(void *opaque, hwaddr addr,
                             uint64_t data, unsigned size, MemTxAttrs attrs)
{
    RegisterInfoArray *reg_array = opaque;
    DDRMC_NOC *s = XILINX_DDRMC_NOC(reg_array->r[0]->opaque);

    /* Is the register set Locked?  */
    if (ARRAY_FIELD_EX32(s->regs, PCSR_LOCK, STATE) && addr != A_PCSR_LOCK) {
        return MEMTX_ERROR;
    }

    register_write_memory(opaque, addr, data, size);
    return MEMTX_OK;
}

static const MemoryRegionOps ddrmc_noc_ops = {
    .read = register_read_memory,
    .write_with_attrs = reg_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void ddrmc_noc_init(Object *obj)
{
    DDRMC_NOC *s = XILINX_DDRMC_NOC(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_DDRMC_NOC,
                       DDRMC_NOC_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), ddrmc_noc_regs_info,
                              ARRAY_SIZE(ddrmc_noc_regs_info),
                              s->regs_info, s->regs,
                              &ddrmc_noc_ops,
                              XILINX_DDRMC_NOC_ERR_DEBUG,
                              DDRMC_NOC_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_ddrmc_noc = {
    .name = TYPE_XILINX_DDRMC_NOC,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, DDRMC_NOC, DDRMC_NOC_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void ddrmc_noc_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = ddrmc_noc_reset;
    dc->vmsd = &vmstate_ddrmc_noc;
}

static const TypeInfo ddrmc_noc_info = {
    .name          = TYPE_XILINX_DDRMC_NOC,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(DDRMC_NOC),
    .class_init    = ddrmc_noc_class_init,
    .instance_init = ddrmc_noc_init,
};

static void ddrmc_noc_register_types(void)
{
    type_register_static(&ddrmc_noc_info);
}

type_init(ddrmc_noc_register_types)
