/*
 * QEMU model of the PMC_IOU_SLCR Global system level control registers for the iou
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Partially Autogenerated by xregqemu.py 2018-02-06.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "hw/irq.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_PMC_IOU_SLCR_ERR_DEBUG
#define XILINX_PMC_IOU_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMC_IOU_SLCR "xlnx,versal-pmc-iou-slcr"

#define XILINX_PMC_IOU_SLCR(obj) \
     OBJECT_CHECK(PMC_IOU_SLCR, (obj), TYPE_XILINX_PMC_IOU_SLCR)

REG32(MIO_PIN_0, 0x0)
    FIELD(MIO_PIN_0, L3_SEL, 7, 3)
    FIELD(MIO_PIN_0, L2_SEL, 5, 2)
    FIELD(MIO_PIN_0, L1_SEL, 3, 2)
    FIELD(MIO_PIN_0, L0_SEL, 1, 2)
REG32(MIO_PIN_1, 0x4)
    FIELD(MIO_PIN_1, L3_SEL, 7, 3)
    FIELD(MIO_PIN_1, L2_SEL, 5, 2)
    FIELD(MIO_PIN_1, L1_SEL, 3, 2)
    FIELD(MIO_PIN_1, L0_SEL, 1, 2)
REG32(MIO_PIN_2, 0x8)
    FIELD(MIO_PIN_2, L3_SEL, 7, 3)
    FIELD(MIO_PIN_2, L2_SEL, 5, 2)
    FIELD(MIO_PIN_2, L1_SEL, 3, 2)
    FIELD(MIO_PIN_2, L0_SEL, 1, 2)
REG32(MIO_PIN_3, 0xc)
    FIELD(MIO_PIN_3, L3_SEL, 7, 3)
    FIELD(MIO_PIN_3, L2_SEL, 5, 2)
    FIELD(MIO_PIN_3, L1_SEL, 3, 2)
    FIELD(MIO_PIN_3, L0_SEL, 1, 2)
REG32(MIO_PIN_4, 0x10)
    FIELD(MIO_PIN_4, L3_SEL, 7, 3)
    FIELD(MIO_PIN_4, L2_SEL, 5, 2)
    FIELD(MIO_PIN_4, L1_SEL, 3, 2)
    FIELD(MIO_PIN_4, L0_SEL, 1, 2)
REG32(MIO_PIN_5, 0x14)
    FIELD(MIO_PIN_5, L3_SEL, 7, 3)
    FIELD(MIO_PIN_5, L2_SEL, 5, 2)
    FIELD(MIO_PIN_5, L1_SEL, 3, 2)
    FIELD(MIO_PIN_5, L0_SEL, 1, 2)
REG32(MIO_PIN_6, 0x18)
    FIELD(MIO_PIN_6, L3_SEL, 7, 3)
    FIELD(MIO_PIN_6, L2_SEL, 5, 2)
    FIELD(MIO_PIN_6, L1_SEL, 3, 2)
    FIELD(MIO_PIN_6, L0_SEL, 1, 2)
REG32(MIO_PIN_7, 0x1c)
    FIELD(MIO_PIN_7, L3_SEL, 7, 3)
    FIELD(MIO_PIN_7, L2_SEL, 5, 2)
    FIELD(MIO_PIN_7, L1_SEL, 3, 2)
    FIELD(MIO_PIN_7, L0_SEL, 1, 2)
REG32(MIO_PIN_8, 0x20)
    FIELD(MIO_PIN_8, L3_SEL, 7, 3)
    FIELD(MIO_PIN_8, L2_SEL, 5, 2)
    FIELD(MIO_PIN_8, L1_SEL, 3, 2)
    FIELD(MIO_PIN_8, L0_SEL, 1, 2)
REG32(MIO_PIN_9, 0x24)
    FIELD(MIO_PIN_9, L3_SEL, 7, 3)
    FIELD(MIO_PIN_9, L2_SEL, 5, 2)
    FIELD(MIO_PIN_9, L1_SEL, 3, 2)
    FIELD(MIO_PIN_9, L0_SEL, 1, 2)
REG32(MIO_PIN_10, 0x28)
    FIELD(MIO_PIN_10, L3_SEL, 7, 3)
    FIELD(MIO_PIN_10, L2_SEL, 5, 2)
    FIELD(MIO_PIN_10, L1_SEL, 3, 2)
    FIELD(MIO_PIN_10, L0_SEL, 1, 2)
REG32(MIO_PIN_11, 0x2c)
    FIELD(MIO_PIN_11, L3_SEL, 7, 3)
    FIELD(MIO_PIN_11, L2_SEL, 5, 2)
    FIELD(MIO_PIN_11, L1_SEL, 3, 2)
    FIELD(MIO_PIN_11, L0_SEL, 1, 2)
REG32(MIO_PIN_12, 0x30)
    FIELD(MIO_PIN_12, L3_SEL, 7, 3)
    FIELD(MIO_PIN_12, L2_SEL, 5, 2)
    FIELD(MIO_PIN_12, L1_SEL, 3, 2)
    FIELD(MIO_PIN_12, L0_SEL, 1, 2)
REG32(MIO_PIN_13, 0x34)
    FIELD(MIO_PIN_13, L3_SEL, 7, 3)
    FIELD(MIO_PIN_13, L2_SEL, 5, 2)
    FIELD(MIO_PIN_13, L1_SEL, 3, 2)
    FIELD(MIO_PIN_13, L0_SEL, 1, 2)
REG32(MIO_PIN_14, 0x38)
    FIELD(MIO_PIN_14, L3_SEL, 7, 3)
    FIELD(MIO_PIN_14, L2_SEL, 5, 2)
    FIELD(MIO_PIN_14, L1_SEL, 3, 2)
    FIELD(MIO_PIN_14, L0_SEL, 1, 2)
REG32(MIO_PIN_15, 0x3c)
    FIELD(MIO_PIN_15, L3_SEL, 7, 3)
    FIELD(MIO_PIN_15, L2_SEL, 5, 2)
    FIELD(MIO_PIN_15, L1_SEL, 3, 2)
    FIELD(MIO_PIN_15, L0_SEL, 1, 2)
REG32(MIO_PIN_16, 0x40)
    FIELD(MIO_PIN_16, L3_SEL, 7, 3)
    FIELD(MIO_PIN_16, L2_SEL, 5, 2)
    FIELD(MIO_PIN_16, L1_SEL, 3, 2)
    FIELD(MIO_PIN_16, L0_SEL, 1, 2)
REG32(MIO_PIN_17, 0x44)
    FIELD(MIO_PIN_17, L3_SEL, 7, 3)
    FIELD(MIO_PIN_17, L2_SEL, 5, 2)
    FIELD(MIO_PIN_17, L1_SEL, 3, 2)
    FIELD(MIO_PIN_17, L0_SEL, 1, 2)
REG32(MIO_PIN_18, 0x48)
    FIELD(MIO_PIN_18, L3_SEL, 7, 3)
    FIELD(MIO_PIN_18, L2_SEL, 5, 2)
    FIELD(MIO_PIN_18, L1_SEL, 3, 2)
    FIELD(MIO_PIN_18, L0_SEL, 1, 2)
REG32(MIO_PIN_19, 0x4c)
    FIELD(MIO_PIN_19, L3_SEL, 7, 3)
    FIELD(MIO_PIN_19, L2_SEL, 5, 2)
    FIELD(MIO_PIN_19, L1_SEL, 3, 2)
    FIELD(MIO_PIN_19, L0_SEL, 1, 2)
REG32(MIO_PIN_20, 0x50)
    FIELD(MIO_PIN_20, L3_SEL, 7, 3)
    FIELD(MIO_PIN_20, L2_SEL, 5, 2)
    FIELD(MIO_PIN_20, L1_SEL, 3, 2)
    FIELD(MIO_PIN_20, L0_SEL, 1, 2)
REG32(MIO_PIN_21, 0x54)
    FIELD(MIO_PIN_21, L3_SEL, 7, 3)
    FIELD(MIO_PIN_21, L2_SEL, 5, 2)
    FIELD(MIO_PIN_21, L1_SEL, 3, 2)
    FIELD(MIO_PIN_21, L0_SEL, 1, 2)
REG32(MIO_PIN_22, 0x58)
    FIELD(MIO_PIN_22, L3_SEL, 7, 3)
    FIELD(MIO_PIN_22, L2_SEL, 5, 2)
    FIELD(MIO_PIN_22, L1_SEL, 3, 2)
    FIELD(MIO_PIN_22, L0_SEL, 1, 2)
REG32(MIO_PIN_23, 0x5c)
    FIELD(MIO_PIN_23, L3_SEL, 7, 3)
    FIELD(MIO_PIN_23, L2_SEL, 5, 2)
    FIELD(MIO_PIN_23, L1_SEL, 3, 2)
    FIELD(MIO_PIN_23, L0_SEL, 1, 2)
REG32(MIO_PIN_24, 0x60)
    FIELD(MIO_PIN_24, L3_SEL, 7, 3)
    FIELD(MIO_PIN_24, L2_SEL, 5, 2)
    FIELD(MIO_PIN_24, L1_SEL, 3, 2)
    FIELD(MIO_PIN_24, L0_SEL, 1, 2)
REG32(MIO_PIN_25, 0x64)
    FIELD(MIO_PIN_25, L3_SEL, 7, 3)
    FIELD(MIO_PIN_25, L2_SEL, 5, 2)
    FIELD(MIO_PIN_25, L1_SEL, 3, 2)
    FIELD(MIO_PIN_25, L0_SEL, 1, 2)
REG32(MIO_PIN_26, 0x68)
    FIELD(MIO_PIN_26, L3_SEL, 7, 3)
    FIELD(MIO_PIN_26, L2_SEL, 5, 2)
    FIELD(MIO_PIN_26, L1_SEL, 3, 2)
    FIELD(MIO_PIN_26, L0_SEL, 1, 2)
REG32(MIO_PIN_27, 0x6c)
    FIELD(MIO_PIN_27, L3_SEL, 7, 3)
    FIELD(MIO_PIN_27, L2_SEL, 5, 2)
    FIELD(MIO_PIN_27, L1_SEL, 3, 2)
    FIELD(MIO_PIN_27, L0_SEL, 1, 2)
REG32(MIO_PIN_28, 0x70)
    FIELD(MIO_PIN_28, L3_SEL, 7, 3)
    FIELD(MIO_PIN_28, L2_SEL, 5, 2)
    FIELD(MIO_PIN_28, L1_SEL, 3, 2)
    FIELD(MIO_PIN_28, L0_SEL, 1, 2)
REG32(MIO_PIN_29, 0x74)
    FIELD(MIO_PIN_29, L3_SEL, 7, 3)
    FIELD(MIO_PIN_29, L2_SEL, 5, 2)
    FIELD(MIO_PIN_29, L1_SEL, 3, 2)
    FIELD(MIO_PIN_29, L0_SEL, 1, 2)
REG32(MIO_PIN_30, 0x78)
    FIELD(MIO_PIN_30, L3_SEL, 7, 3)
    FIELD(MIO_PIN_30, L2_SEL, 5, 2)
    FIELD(MIO_PIN_30, L1_SEL, 3, 2)
    FIELD(MIO_PIN_30, L0_SEL, 1, 2)
REG32(MIO_PIN_31, 0x7c)
    FIELD(MIO_PIN_31, L3_SEL, 7, 3)
    FIELD(MIO_PIN_31, L2_SEL, 5, 2)
    FIELD(MIO_PIN_31, L1_SEL, 3, 2)
    FIELD(MIO_PIN_31, L0_SEL, 1, 2)
REG32(MIO_PIN_32, 0x80)
    FIELD(MIO_PIN_32, L3_SEL, 7, 3)
    FIELD(MIO_PIN_32, L2_SEL, 5, 2)
    FIELD(MIO_PIN_32, L1_SEL, 3, 2)
    FIELD(MIO_PIN_32, L0_SEL, 1, 2)
REG32(MIO_PIN_33, 0x84)
    FIELD(MIO_PIN_33, L3_SEL, 7, 3)
    FIELD(MIO_PIN_33, L2_SEL, 5, 2)
    FIELD(MIO_PIN_33, L1_SEL, 3, 2)
    FIELD(MIO_PIN_33, L0_SEL, 1, 2)
REG32(MIO_PIN_34, 0x88)
    FIELD(MIO_PIN_34, L3_SEL, 7, 3)
    FIELD(MIO_PIN_34, L2_SEL, 5, 2)
    FIELD(MIO_PIN_34, L1_SEL, 3, 2)
    FIELD(MIO_PIN_34, L0_SEL, 1, 2)
REG32(MIO_PIN_35, 0x8c)
    FIELD(MIO_PIN_35, L3_SEL, 7, 3)
    FIELD(MIO_PIN_35, L2_SEL, 5, 2)
    FIELD(MIO_PIN_35, L1_SEL, 3, 2)
    FIELD(MIO_PIN_35, L0_SEL, 1, 2)
REG32(MIO_PIN_36, 0x90)
    FIELD(MIO_PIN_36, L3_SEL, 7, 3)
    FIELD(MIO_PIN_36, L2_SEL, 5, 2)
    FIELD(MIO_PIN_36, L1_SEL, 3, 2)
    FIELD(MIO_PIN_36, L0_SEL, 1, 2)
REG32(MIO_PIN_37, 0x94)
    FIELD(MIO_PIN_37, L3_SEL, 7, 3)
    FIELD(MIO_PIN_37, L2_SEL, 5, 2)
    FIELD(MIO_PIN_37, L1_SEL, 3, 2)
    FIELD(MIO_PIN_37, L0_SEL, 1, 2)
REG32(MIO_PIN_38, 0x98)
    FIELD(MIO_PIN_38, L3_SEL, 7, 3)
    FIELD(MIO_PIN_38, L2_SEL, 5, 2)
    FIELD(MIO_PIN_38, L1_SEL, 3, 2)
    FIELD(MIO_PIN_38, L0_SEL, 1, 2)
REG32(MIO_PIN_39, 0x9c)
    FIELD(MIO_PIN_39, L3_SEL, 7, 3)
    FIELD(MIO_PIN_39, L2_SEL, 5, 2)
    FIELD(MIO_PIN_39, L1_SEL, 3, 2)
    FIELD(MIO_PIN_39, L0_SEL, 1, 2)
REG32(MIO_PIN_40, 0xa0)
    FIELD(MIO_PIN_40, L3_SEL, 7, 3)
    FIELD(MIO_PIN_40, L2_SEL, 5, 2)
    FIELD(MIO_PIN_40, L1_SEL, 3, 2)
    FIELD(MIO_PIN_40, L0_SEL, 1, 2)
REG32(MIO_PIN_41, 0xa4)
    FIELD(MIO_PIN_41, L3_SEL, 7, 3)
    FIELD(MIO_PIN_41, L2_SEL, 5, 2)
    FIELD(MIO_PIN_41, L1_SEL, 3, 2)
    FIELD(MIO_PIN_41, L0_SEL, 1, 2)
REG32(MIO_PIN_42, 0xa8)
    FIELD(MIO_PIN_42, L3_SEL, 7, 3)
    FIELD(MIO_PIN_42, L2_SEL, 5, 2)
    FIELD(MIO_PIN_42, L1_SEL, 3, 2)
    FIELD(MIO_PIN_42, L0_SEL, 1, 2)
REG32(MIO_PIN_43, 0xac)
    FIELD(MIO_PIN_43, L3_SEL, 7, 3)
    FIELD(MIO_PIN_43, L2_SEL, 5, 2)
    FIELD(MIO_PIN_43, L1_SEL, 3, 2)
    FIELD(MIO_PIN_43, L0_SEL, 1, 2)
REG32(MIO_PIN_44, 0xb0)
    FIELD(MIO_PIN_44, L3_SEL, 7, 3)
    FIELD(MIO_PIN_44, L2_SEL, 5, 2)
    FIELD(MIO_PIN_44, L1_SEL, 3, 2)
    FIELD(MIO_PIN_44, L0_SEL, 1, 2)
REG32(MIO_PIN_45, 0xb4)
    FIELD(MIO_PIN_45, L3_SEL, 7, 3)
    FIELD(MIO_PIN_45, L2_SEL, 5, 2)
    FIELD(MIO_PIN_45, L1_SEL, 3, 2)
    FIELD(MIO_PIN_45, L0_SEL, 1, 2)
REG32(MIO_PIN_46, 0xb8)
    FIELD(MIO_PIN_46, L3_SEL, 7, 3)
    FIELD(MIO_PIN_46, L2_SEL, 5, 2)
    FIELD(MIO_PIN_46, L1_SEL, 3, 2)
    FIELD(MIO_PIN_46, L0_SEL, 1, 2)
REG32(MIO_PIN_47, 0xbc)
    FIELD(MIO_PIN_47, L3_SEL, 7, 3)
    FIELD(MIO_PIN_47, L2_SEL, 5, 2)
    FIELD(MIO_PIN_47, L1_SEL, 3, 2)
    FIELD(MIO_PIN_47, L0_SEL, 1, 2)
REG32(MIO_PIN_48, 0xc0)
    FIELD(MIO_PIN_48, L3_SEL, 7, 3)
    FIELD(MIO_PIN_48, L2_SEL, 5, 2)
    FIELD(MIO_PIN_48, L1_SEL, 3, 2)
    FIELD(MIO_PIN_48, L0_SEL, 1, 2)
REG32(MIO_PIN_49, 0xc4)
    FIELD(MIO_PIN_49, L3_SEL, 7, 3)
    FIELD(MIO_PIN_49, L2_SEL, 5, 2)
    FIELD(MIO_PIN_49, L1_SEL, 3, 2)
    FIELD(MIO_PIN_49, L0_SEL, 1, 2)
REG32(MIO_PIN_50, 0xc8)
    FIELD(MIO_PIN_50, L3_SEL, 7, 3)
    FIELD(MIO_PIN_50, L2_SEL, 5, 2)
    FIELD(MIO_PIN_50, L1_SEL, 3, 2)
    FIELD(MIO_PIN_50, L0_SEL, 1, 2)
REG32(MIO_PIN_51, 0xcc)
    FIELD(MIO_PIN_51, L3_SEL, 7, 3)
    FIELD(MIO_PIN_51, L2_SEL, 5, 2)
    FIELD(MIO_PIN_51, L1_SEL, 3, 2)
    FIELD(MIO_PIN_51, L0_SEL, 1, 2)
REG32(BNK0_EN_RX, 0x100)
    FIELD(BNK0_EN_RX, BNK0_EN_RX, 0, 26)
REG32(BNK0_SEL_RX0, 0x104)
REG32(BNK0_SEL_RX1, 0x108)
    FIELD(BNK0_SEL_RX1, BNK0_SEL_RX, 0, 20)
REG32(BNK0_EN_RX_SCHMITT_HYST, 0x10c)
    FIELD(BNK0_EN_RX_SCHMITT_HYST, BNK0_EN_RX_SCHMITT_HYST, 0, 26)
REG32(BNK0_EN_WK_PD, 0x110)
    FIELD(BNK0_EN_WK_PD, BNK0_EN_WK_PD, 0, 26)
REG32(BNK0_EN_WK_PU, 0x114)
    FIELD(BNK0_EN_WK_PU, BNK0_EN_WK_PU, 0, 26)
REG32(BNK0_SEL_DRV0, 0x118)
REG32(BNK0_SEL_DRV1, 0x11c)
    FIELD(BNK0_SEL_DRV1, BNK0_SEL_DRV, 0, 20)
REG32(BNK0_SEL_SLEW, 0x120)
    FIELD(BNK0_SEL_SLEW, BNK0_SEL_SLEW, 0, 26)
REG32(BNK0_EN_DFT_OPT_INV, 0x124)
    FIELD(BNK0_EN_DFT_OPT_INV, BNK0_EN_DFT_OPT_INV, 0, 26)
REG32(BNK0_EN_PAD2PAD_LOOPBACK, 0x128)
    FIELD(BNK0_EN_PAD2PAD_LOOPBACK, BNK0_EN_PAD2PAD_LOOPBACK, 0, 13)
REG32(BNK0_RX_SPARE0, 0x12c)
REG32(BNK0_RX_SPARE1, 0x130)
    FIELD(BNK0_RX_SPARE1, BNK0_RX_SPARE, 0, 20)
REG32(BNK0_TX_SPARE0, 0x134)
REG32(BNK0_TX_SPARE1, 0x138)
    FIELD(BNK0_TX_SPARE1, BNK0_TX_SPARE, 0, 20)
REG32(BNK0_SEL_EN1P8, 0x13c)
    FIELD(BNK0_SEL_EN1P8, BNK0_SEL_EN1P8, 0, 1)
REG32(BNK0_EN_B_POR_DETECT, 0x140)
    FIELD(BNK0_EN_B_POR_DETECT, BNK0_EN_B_POR_DETECT, 0, 1)
REG32(BNK0_LPF_BYP_POR_DETECT, 0x144)
    FIELD(BNK0_LPF_BYP_POR_DETECT, BNK0_LPF_BYP_POR_DETECT, 0, 1)
REG32(BNK0_EN_LATCH, 0x148)
    FIELD(BNK0_EN_LATCH, BNK0_EN_LATCH, 0, 1)
REG32(BNK0_VBG_LPF_BYP_B, 0x14c)
    FIELD(BNK0_VBG_LPF_BYP_B, BNK0_VBG_LPF_BYP_B, 0, 1)
REG32(BNK0_EN_AMP_B, 0x150)
    FIELD(BNK0_EN_AMP_B, BNK0_EN_AMP_B, 0, 2)
REG32(BNK0_SPARE_BIAS, 0x154)
    FIELD(BNK0_SPARE_BIAS, BNK0_SPARE_BIAS, 0, 4)
REG32(BNK0_DRIVER_BIAS, 0x158)
    FIELD(BNK0_DRIVER_BIAS, BNK0_DRIVER_BIAS, 0, 15)
REG32(BNK0_VMODE, 0x15c)
    FIELD(BNK0_VMODE, BNK0_VMODE, 0, 1)
REG32(BNK0_SEL_AUX_IO_RX, 0x160)
    FIELD(BNK0_SEL_AUX_IO_RX, BNK0_SEL_AUX_IO_RX, 0, 26)
REG32(BNK0_EN_TX_HS_MODE, 0x164)
    FIELD(BNK0_EN_TX_HS_MODE, BNK0_EN_TX_HS_MODE, 0, 26)
REG32(MIO_MST_TRI0, 0x200)
    FIELD(MIO_MST_TRI0, PIN_25_TRI, 25, 1)
    FIELD(MIO_MST_TRI0, PIN_24_TRI, 24, 1)
    FIELD(MIO_MST_TRI0, PIN_23_TRI, 23, 1)
    FIELD(MIO_MST_TRI0, PIN_22_TRI, 22, 1)
    FIELD(MIO_MST_TRI0, PIN_21_TRI, 21, 1)
    FIELD(MIO_MST_TRI0, PIN_20_TRI, 20, 1)
    FIELD(MIO_MST_TRI0, PIN_19_TRI, 19, 1)
    FIELD(MIO_MST_TRI0, PIN_18_TRI, 18, 1)
    FIELD(MIO_MST_TRI0, PIN_17_TRI, 17, 1)
    FIELD(MIO_MST_TRI0, PIN_16_TRI, 16, 1)
    FIELD(MIO_MST_TRI0, PIN_15_TRI, 15, 1)
    FIELD(MIO_MST_TRI0, PIN_14_TRI, 14, 1)
    FIELD(MIO_MST_TRI0, PIN_13_TRI, 13, 1)
    FIELD(MIO_MST_TRI0, PIN_12_TRI, 12, 1)
    FIELD(MIO_MST_TRI0, PIN_11_TRI, 11, 1)
    FIELD(MIO_MST_TRI0, PIN_10_TRI, 10, 1)
    FIELD(MIO_MST_TRI0, PIN_09_TRI, 9, 1)
    FIELD(MIO_MST_TRI0, PIN_08_TRI, 8, 1)
    FIELD(MIO_MST_TRI0, PIN_07_TRI, 7, 1)
    FIELD(MIO_MST_TRI0, PIN_06_TRI, 6, 1)
    FIELD(MIO_MST_TRI0, PIN_05_TRI, 5, 1)
    FIELD(MIO_MST_TRI0, PIN_04_TRI, 4, 1)
    FIELD(MIO_MST_TRI0, PIN_03_TRI, 3, 1)
    FIELD(MIO_MST_TRI0, PIN_02_TRI, 2, 1)
    FIELD(MIO_MST_TRI0, PIN_01_TRI, 1, 1)
    FIELD(MIO_MST_TRI0, PIN_00_TRI, 0, 1)
REG32(MIO_MST_TRI1, 0x204)
    FIELD(MIO_MST_TRI1, PIN_51_TRI, 25, 1)
    FIELD(MIO_MST_TRI1, PIN_50_TRI, 24, 1)
    FIELD(MIO_MST_TRI1, PIN_49_TRI, 23, 1)
    FIELD(MIO_MST_TRI1, PIN_48_TRI, 22, 1)
    FIELD(MIO_MST_TRI1, PIN_47_TRI, 21, 1)
    FIELD(MIO_MST_TRI1, PIN_46_TRI, 20, 1)
    FIELD(MIO_MST_TRI1, PIN_45_TRI, 19, 1)
    FIELD(MIO_MST_TRI1, PIN_44_TRI, 18, 1)
    FIELD(MIO_MST_TRI1, PIN_43_TRI, 17, 1)
    FIELD(MIO_MST_TRI1, PIN_42_TRI, 16, 1)
    FIELD(MIO_MST_TRI1, PIN_41_TRI, 15, 1)
    FIELD(MIO_MST_TRI1, PIN_40_TRI, 14, 1)
    FIELD(MIO_MST_TRI1, PIN_39_TRI, 13, 1)
    FIELD(MIO_MST_TRI1, PIN_38_TRI, 12, 1)
    FIELD(MIO_MST_TRI1, PIN_37_TRI, 11, 1)
    FIELD(MIO_MST_TRI1, PIN_36_TRI, 10, 1)
    FIELD(MIO_MST_TRI1, PIN_35_TRI, 9, 1)
    FIELD(MIO_MST_TRI1, PIN_34_TRI, 8, 1)
    FIELD(MIO_MST_TRI1, PIN_33_TRI, 7, 1)
    FIELD(MIO_MST_TRI1, PIN_32_TRI, 6, 1)
    FIELD(MIO_MST_TRI1, PIN_31_TRI, 5, 1)
    FIELD(MIO_MST_TRI1, PIN_30_TRI, 4, 1)
    FIELD(MIO_MST_TRI1, PIN_29_TRI, 3, 1)
    FIELD(MIO_MST_TRI1, PIN_28_TRI, 2, 1)
    FIELD(MIO_MST_TRI1, PIN_27_TRI, 1, 1)
    FIELD(MIO_MST_TRI1, PIN_26_TRI, 0, 1)
REG32(BNK1_EN_RX, 0x300)
    FIELD(BNK1_EN_RX, BNK1_EN_RX, 0, 26)
REG32(BNK1_SEL_RX0, 0x304)
REG32(BNK1_SEL_RX1, 0x308)
    FIELD(BNK1_SEL_RX1, BNK1_SEL_RX, 0, 20)
REG32(BNK1_EN_RX_SCHMITT_HYST, 0x30c)
    FIELD(BNK1_EN_RX_SCHMITT_HYST, BNK1_EN_RX_SCHMITT_HYST, 0, 26)
REG32(BNK1_EN_WK_PD, 0x310)
    FIELD(BNK1_EN_WK_PD, BNK1_EN_WK_PD, 0, 26)
REG32(BNK1_EN_WK_PU, 0x314)
    FIELD(BNK1_EN_WK_PU, BNK1_EN_WK_PU, 0, 26)
REG32(BNK1_SEL_DRV0, 0x318)
REG32(BNK1_SEL_DRV1, 0x31c)
    FIELD(BNK1_SEL_DRV1, BNK1_SEL_DRV, 0, 20)
REG32(BNK1_SEL_SLEW, 0x320)
    FIELD(BNK1_SEL_SLEW, BNK1_SEL_SLEW, 0, 26)
REG32(BNK1_EN_DFT_OPT_INV, 0x324)
    FIELD(BNK1_EN_DFT_OPT_INV, BNK1_EN_DFT_OPT_INV, 0, 26)
REG32(BNK1_EN_PAD2PAD_LOOPBACK, 0x328)
    FIELD(BNK1_EN_PAD2PAD_LOOPBACK, BNK1_EN_PAD2PAD_LOOPBACK, 0, 13)
REG32(BNK1_RX_SPARE0, 0x32c)
REG32(BNK1_RX_SPARE1, 0x330)
    FIELD(BNK1_RX_SPARE1, BNK1_RX_SPARE, 0, 20)
REG32(BNK1_TX_SPARE0, 0x334)
REG32(BNK1_TX_SPARE1, 0x338)
    FIELD(BNK1_TX_SPARE1, BNK1_TX_SPARE, 0, 20)
REG32(BNK1_SEL_EN1P8, 0x33c)
    FIELD(BNK1_SEL_EN1P8, BNK1_SEL_EN1P8, 0, 1)
REG32(BNK1_EN_B_POR_DETECT, 0x340)
    FIELD(BNK1_EN_B_POR_DETECT, BNK1_EN_B_POR_DETECT, 0, 1)
REG32(BNK1_LPF_BYP_POR_DETECT, 0x344)
    FIELD(BNK1_LPF_BYP_POR_DETECT, BNK1_LPF_BYP_POR_DETECT, 0, 1)
REG32(BNK1_EN_LATCH, 0x348)
    FIELD(BNK1_EN_LATCH, BNK1_EN_LATCH, 0, 1)
REG32(BNK1_VBG_LPF_BYP_B, 0x34c)
    FIELD(BNK1_VBG_LPF_BYP_B, BNK1_VBG_LPF_BYP_B, 0, 1)
REG32(BNK1_EN_AMP_B, 0x350)
    FIELD(BNK1_EN_AMP_B, BNK1_EN_AMP_B, 0, 2)
REG32(BNK1_SPARE_BIAS, 0x354)
    FIELD(BNK1_SPARE_BIAS, BNK1_SPARE_BIAS, 0, 4)
REG32(BNK1_DRIVER_BIAS, 0x358)
    FIELD(BNK1_DRIVER_BIAS, BNK1_DRIVER_BIAS, 0, 15)
REG32(BNK1_VMODE, 0x35c)
    FIELD(BNK1_VMODE, BNK1_VMODE, 0, 1)
REG32(BNK1_SEL_AUX_IO_RX, 0x360)
    FIELD(BNK1_SEL_AUX_IO_RX, BNK1_SEL_AUX_IO_RX, 0, 26)
REG32(BNK1_EN_TX_HS_MODE, 0x364)
    FIELD(BNK1_EN_TX_HS_MODE, BNK1_EN_TX_HS_MODE, 0, 26)
REG32(SD0_CLK_CTRL, 0x400)
    FIELD(SD0_CLK_CTRL, SDIO0_FBCLK_SEL, 2, 1)
    FIELD(SD0_CLK_CTRL, SDIO0_RX_SRC_SEL, 0, 2)
REG32(SD0_CTRL_REG, 0x404)
    FIELD(SD0_CTRL_REG, SD0_EMMC_SEL, 0, 1)
REG32(SD0_CONFIG_REG1, 0x410)
    FIELD(SD0_CONFIG_REG1, SD0_BASECLK, 7, 8)
    FIELD(SD0_CONFIG_REG1, SD0_TUNIGCOUNT, 1, 6)
    FIELD(SD0_CONFIG_REG1, SD0_ASYNCWKPENA, 0, 1)
REG32(SD0_CONFIG_REG2, 0x414)
    FIELD(SD0_CONFIG_REG2, SD0_SLOTTYPE, 12, 2)
    FIELD(SD0_CONFIG_REG2, SD0_ASYCINTR, 11, 1)
    FIELD(SD0_CONFIG_REG2, SD0_64BIT, 10, 1)
    FIELD(SD0_CONFIG_REG2, SD0_1P8V, 9, 1)
    FIELD(SD0_CONFIG_REG2, SD0_3P0V, 8, 1)
    FIELD(SD0_CONFIG_REG2, SD0_3P3V, 7, 1)
    FIELD(SD0_CONFIG_REG2, SD0_SUSPRES, 6, 1)
    FIELD(SD0_CONFIG_REG2, SD0_SDMA, 5, 1)
    FIELD(SD0_CONFIG_REG2, SD0_HIGHSPEED, 4, 1)
    FIELD(SD0_CONFIG_REG2, SD0_ADMA2, 3, 1)
    FIELD(SD0_CONFIG_REG2, SD0_8BIT, 2, 1)
    FIELD(SD0_CONFIG_REG2, SD0_MAXBLK, 0, 2)
REG32(SD0_CONFIG_REG3, 0x418)
    FIELD(SD0_CONFIG_REG3, SD0_TUNINGSDR50, 10, 1)
    FIELD(SD0_CONFIG_REG3, SD0_RETUNETMR, 6, 4)
    FIELD(SD0_CONFIG_REG3, SD0_DDRIVER, 5, 1)
    FIELD(SD0_CONFIG_REG3, SD0_CDRIVER, 4, 1)
    FIELD(SD0_CONFIG_REG3, SD0_ADRIVER, 3, 1)
    FIELD(SD0_CONFIG_REG3, SD0_DDR50, 2, 1)
    FIELD(SD0_CONFIG_REG3, SD0_SDR104, 1, 1)
    FIELD(SD0_CONFIG_REG3, SD0_SDR50, 0, 1)
REG32(SD0_INITPRESET, 0x41c)
    FIELD(SD0_INITPRESET, SD0_INITPRESET, 0, 13)
REG32(SD0_DSPPRESET, 0x420)
    FIELD(SD0_DSPPRESET, SD0_DSPPRESET, 0, 13)
REG32(SD0_HSPDPRESET, 0x424)
    FIELD(SD0_HSPDPRESET, SD0_HSPDPRESET, 0, 13)
REG32(SD0_SDR12PRESET, 0x428)
    FIELD(SD0_SDR12PRESET, SD0_SDR12PRESET, 0, 13)
REG32(SD0_SDR25PRESET, 0x42c)
    FIELD(SD0_SDR25PRESET, SD0_SDR25PRESET, 0, 13)
REG32(SD0_SDR50PRSET, 0x430)
    FIELD(SD0_SDR50PRSET, SD0_SDR50PRESET, 0, 13)
REG32(SD0_SDR104PRST, 0x434)
    FIELD(SD0_SDR104PRST, SD0_SDR104PRESET, 0, 13)
REG32(SD0_DDR50PRESET, 0x438)
    FIELD(SD0_DDR50PRESET, SD0_DDR50PRESET, 0, 13)
REG32(SD0_MAXCUR1P8, 0x43c)
    FIELD(SD0_MAXCUR1P8, SD0_MAXCUR1P8, 0, 8)
REG32(SD0_MAXCUR3P0, 0x440)
    FIELD(SD0_MAXCUR3P0, SD0_MAXCUR3P0, 0, 8)
REG32(SD0_MAXCUR3P3, 0x444)
    FIELD(SD0_MAXCUR3P3, SD0_MAXCUR3P3, 0, 8)
REG32(SD0_DLL_CTRL, 0x448)
    FIELD(SD0_DLL_CTRL, SD0_CLKSTABLE_CFG, 9, 1)
    FIELD(SD0_DLL_CTRL, SD0_DLL_CFG, 5, 4)
    FIELD(SD0_DLL_CTRL, SD0_DLL_PSDONE, 4, 1)
    FIELD(SD0_DLL_CTRL, SD0_DLL_OVF, 3, 1)
    FIELD(SD0_DLL_CTRL, SD0_DLL_RST, 2, 1)
    FIELD(SD0_DLL_CTRL, SD0_DLL_TESTMODE, 1, 1)
    FIELD(SD0_DLL_CTRL, SD0_DLL_LOCK, 0, 1)
REG32(SD0_CDN_CTRL, 0x44c)
    FIELD(SD0_CDN_CTRL, SD0_CDN_CTRL, 0, 1)
REG32(SD0_DLL_TEST, 0x450)
    FIELD(SD0_DLL_TEST, DLL_DIV, 16, 8)
    FIELD(SD0_DLL_TEST, DLL_TX_SEL, 9, 7)
    FIELD(SD0_DLL_TEST, DLL_RX_SEL, 0, 9)
REG32(SD0_RX_TUNING_SEL, 0x454)
    FIELD(SD0_RX_TUNING_SEL, SD0_RX_SEL, 0, 9)
REG32(SD0_DLL_DIV_MAP0, 0x458)
    FIELD(SD0_DLL_DIV_MAP0, DIV_3, 24, 8)
    FIELD(SD0_DLL_DIV_MAP0, DIV_2, 16, 8)
    FIELD(SD0_DLL_DIV_MAP0, DIV_1, 8, 8)
    FIELD(SD0_DLL_DIV_MAP0, DIV_0, 0, 8)
REG32(SD0_DLL_DIV_MAP1, 0x45c)
    FIELD(SD0_DLL_DIV_MAP1, DIV_7, 24, 8)
    FIELD(SD0_DLL_DIV_MAP1, DIV_6, 16, 8)
    FIELD(SD0_DLL_DIV_MAP1, DIV_5, 8, 8)
    FIELD(SD0_DLL_DIV_MAP1, DIV_4, 0, 8)
REG32(SD0_IOU_COHERENT_CTRL, 0x460)
    FIELD(SD0_IOU_COHERENT_CTRL, SD0_AXI_COH, 0, 4)
REG32(SD0_IOU_INTERCONNECT_ROUTE, 0x464)
    FIELD(SD0_IOU_INTERCONNECT_ROUTE, SD0, 0, 1)
REG32(SD0_IOU_RAM, 0x468)
    FIELD(SD0_IOU_RAM, EMASA0, 6, 1)
    FIELD(SD0_IOU_RAM, EMAB0, 3, 3)
    FIELD(SD0_IOU_RAM, EMAA0, 0, 3)
REG32(SD0_IOU_INTERCONNECT_QOS, 0x46c)
    FIELD(SD0_IOU_INTERCONNECT_QOS, SD0_QOS, 0, 4)
REG32(SD1_CLK_CTRL, 0x480)
    FIELD(SD1_CLK_CTRL, SDIO1_FBCLK_SEL, 1, 1)
    FIELD(SD1_CLK_CTRL, SDIO1_RX_SRC_SEL, 0, 1)
REG32(SD1_CTRL_REG, 0x484)
    FIELD(SD1_CTRL_REG, SD1_EMMC_SEL, 0, 1)
REG32(SD1_CONFIG_REG1, 0x490)
    FIELD(SD1_CONFIG_REG1, SD1_BASECLK, 7, 8)
    FIELD(SD1_CONFIG_REG1, SD1_TUNIGCOUNT, 1, 6)
    FIELD(SD1_CONFIG_REG1, SD1_ASYNCWKPENA, 0, 1)
REG32(SD1_CONFIG_REG2, 0x494)
    FIELD(SD1_CONFIG_REG2, SD1_SLOTTYPE, 12, 2)
    FIELD(SD1_CONFIG_REG2, SD1_ASYCINTR, 11, 1)
    FIELD(SD1_CONFIG_REG2, SD1_64BIT, 10, 1)
    FIELD(SD1_CONFIG_REG2, SD1_1P8V, 9, 1)
    FIELD(SD1_CONFIG_REG2, SD1_3P0V, 8, 1)
    FIELD(SD1_CONFIG_REG2, SD1_3P3V, 7, 1)
    FIELD(SD1_CONFIG_REG2, SD1_SUSPRES, 6, 1)
    FIELD(SD1_CONFIG_REG2, SD1_SDMA, 5, 1)
    FIELD(SD1_CONFIG_REG2, SD1_HIGHSPEED, 4, 1)
    FIELD(SD1_CONFIG_REG2, SD1_ADMA2, 3, 1)
    FIELD(SD1_CONFIG_REG2, SD1_8BIT, 2, 1)
    FIELD(SD1_CONFIG_REG2, SD1_MAXBLK, 0, 2)
REG32(SD1_CONFIG_REG3, 0x498)
    FIELD(SD1_CONFIG_REG3, SD1_TUNINGSDR50, 10, 1)
    FIELD(SD1_CONFIG_REG3, SD1_RETUNETMR, 6, 4)
    FIELD(SD1_CONFIG_REG3, SD1_DDRIVER, 5, 1)
    FIELD(SD1_CONFIG_REG3, SD1_CDRIVER, 4, 1)
    FIELD(SD1_CONFIG_REG3, SD1_ADRIVER, 3, 1)
    FIELD(SD1_CONFIG_REG3, SD1_DDR50, 2, 1)
    FIELD(SD1_CONFIG_REG3, SD1_SDR104, 1, 1)
    FIELD(SD1_CONFIG_REG3, SD1_SDR50, 0, 1)
REG32(SD1_INITPRESET, 0x49c)
    FIELD(SD1_INITPRESET, SD1_INITPRESET, 0, 13)
REG32(SD1_DSPPRESET, 0x4a0)
    FIELD(SD1_DSPPRESET, SD1_DSPPRESET, 0, 13)
REG32(SD1_HSPDPRESET, 0x4a4)
    FIELD(SD1_HSPDPRESET, SD1_HSPDPRESET, 0, 13)
REG32(SD1_SDR12PRESET, 0x4a8)
    FIELD(SD1_SDR12PRESET, SD1_SDR12PRESET, 0, 13)
REG32(SD1_SDR25PRESET, 0x4ac)
    FIELD(SD1_SDR25PRESET, SD1_SDR25PRESET, 0, 13)
REG32(SD1_SDR50PRSET, 0x4b0)
    FIELD(SD1_SDR50PRSET, SD1_SDR50PRESET, 0, 13)
REG32(SD1_SDR104PRST, 0x4b4)
    FIELD(SD1_SDR104PRST, SD1_SDR104PRESET, 0, 13)
REG32(SD1_DDR50PRESET, 0x4b8)
    FIELD(SD1_DDR50PRESET, SD1_DDR50PRESET, 0, 13)
REG32(SD1_MAXCUR1P8, 0x4bc)
    FIELD(SD1_MAXCUR1P8, SD1_MAXCUR1P8, 0, 8)
REG32(SD1_MAXCUR3P0, 0x4c0)
    FIELD(SD1_MAXCUR3P0, SD1_MAXCUR3P0, 0, 8)
REG32(SD1_MAXCUR3P3, 0x4c4)
    FIELD(SD1_MAXCUR3P3, SD1_MAXCUR3P3, 0, 8)
REG32(SD1_DLL_CTRL, 0x4c8)
    FIELD(SD1_DLL_CTRL, SD1_CLKSTABLE_CFG, 9, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_CFG, 5, 4)
    FIELD(SD1_DLL_CTRL, SD1_DLL_PSDONE, 4, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_OVF, 3, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_RST, 2, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_TESTMODE, 1, 1)
    FIELD(SD1_DLL_CTRL, SD1_DLL_LOCK, 0, 1)
REG32(SD1_CDN_CTRL, 0x4cc)
    FIELD(SD1_CDN_CTRL, SD1_CDN_CTRL, 0, 1)
REG32(SD1_DLL_TEST, 0x4d0)
    FIELD(SD1_DLL_TEST, DLL_DIV, 16, 8)
    FIELD(SD1_DLL_TEST, DLL_TX_SEL, 9, 7)
    FIELD(SD1_DLL_TEST, DLL_RX_SEL, 0, 9)
REG32(SD1_RX_TUNING_SEL, 0x4d4)
    FIELD(SD1_RX_TUNING_SEL, SD1_RX_SEL, 0, 9)
REG32(SD1_DLL_DIV_MAP0, 0x4d8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_3, 24, 8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_2, 16, 8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_1, 8, 8)
    FIELD(SD1_DLL_DIV_MAP0, DIV_0, 0, 8)
REG32(SD1_DLL_DIV_MAP1, 0x4dc)
    FIELD(SD1_DLL_DIV_MAP1, DIV_7, 24, 8)
    FIELD(SD1_DLL_DIV_MAP1, DIV_6, 16, 8)
    FIELD(SD1_DLL_DIV_MAP1, DIV_5, 8, 8)
    FIELD(SD1_DLL_DIV_MAP1, DIV_4, 0, 8)
REG32(SD1_IOU_COHERENT_CTRL, 0x4e0)
    FIELD(SD1_IOU_COHERENT_CTRL, SD1_AXI_COH, 0, 4)
REG32(SD1_IOU_INTERCONNECT_ROUTE, 0x4e4)
    FIELD(SD1_IOU_INTERCONNECT_ROUTE, SD1, 0, 1)
REG32(SD1_IOU_RAM, 0x4e8)
    FIELD(SD1_IOU_RAM, EMASA0, 6, 1)
    FIELD(SD1_IOU_RAM, EMAB0, 3, 3)
    FIELD(SD1_IOU_RAM, EMAA0, 0, 3)
REG32(SD1_IOU_INTERCONNECT_QOS, 0x4ec)
    FIELD(SD1_IOU_INTERCONNECT_QOS, SD1_QOS, 0, 4)
REG32(OSPI_QSPI_IOU_AXI_MUX_SEL, 0x504)
    FIELD(OSPI_QSPI_IOU_AXI_MUX_SEL, OSPI_MUX_SEL, 1, 1)
    FIELD(OSPI_QSPI_IOU_AXI_MUX_SEL, QSPI_OSPI_MUX_SEL, 0, 1)
REG32(QSPI_IOU_COHERENT_CTRL, 0x508)
    FIELD(QSPI_IOU_COHERENT_CTRL, QSPI_AXI_COH, 0, 4)
REG32(QSPI_IOU_INTERCONNECT_ROUTE, 0x50c)
    FIELD(QSPI_IOU_INTERCONNECT_ROUTE, QSPI, 0, 1)
REG32(QSPI_IOU_RAM, 0x510)
    FIELD(QSPI_IOU_RAM, EMASA1, 13, 1)
    FIELD(QSPI_IOU_RAM, EMAB1, 10, 3)
    FIELD(QSPI_IOU_RAM, EMAA1, 7, 3)
    FIELD(QSPI_IOU_RAM, EMASA0, 6, 1)
    FIELD(QSPI_IOU_RAM, EMAB0, 3, 3)
    FIELD(QSPI_IOU_RAM, EMAA0, 0, 3)
REG32(QSPI_IOU_INTERCONNECT_QOS, 0x514)
    FIELD(QSPI_IOU_INTERCONNECT_QOS, QSPI_QOS, 0, 4)
REG32(OSPI_IOU_COHERENT_CTRL, 0x530)
    FIELD(OSPI_IOU_COHERENT_CTRL, OSPI_AXI_COH, 0, 4)
REG32(OSPI_IOU_INTERCONNECT_ROUTE, 0x534)
    FIELD(OSPI_IOU_INTERCONNECT_ROUTE, OSPI, 0, 1)
REG32(OSPI_IOU_RAM, 0x538)
    FIELD(OSPI_IOU_RAM, EMAS0, 5, 1)
    FIELD(OSPI_IOU_RAM, EMAW0, 3, 2)
    FIELD(OSPI_IOU_RAM, EMA0, 0, 3)
REG32(OSPI_IOU_INTERCONNECT_QOS, 0x53c)
    FIELD(OSPI_IOU_INTERCONNECT_QOS, OSPI_QOS, 0, 4)
REG32(OSPI_REFCLK_DLY_CTRL, 0x540)
    FIELD(OSPI_REFCLK_DLY_CTRL, DLY1, 3, 2)
    FIELD(OSPI_REFCLK_DLY_CTRL, DLY0, 0, 3)
REG32(CUR_PWR_ST, 0x600)
    FIELD(CUR_PWR_ST, U2PMU, 0, 2)
REG32(CONNECT_ST, 0x604)
    FIELD(CONNECT_ST, U2PMU, 0, 1)
REG32(PW_STATE_REQ, 0x608)
    FIELD(PW_STATE_REQ, BIT_1_0, 0, 2)
REG32(HOST_U2_PORT_DISABLE, 0x60c)
    FIELD(HOST_U2_PORT_DISABLE, BIT_0, 0, 1)
REG32(DBG_U2PMU, 0x610)
REG32(DBG_U2PMU_EXT1, 0x614)
REG32(DBG_U2PMU_EXT2, 0x618)
    FIELD(DBG_U2PMU_EXT2, BIT_67_64, 0, 4)
REG32(PME_GEN_U2PMU, 0x61c)
    FIELD(PME_GEN_U2PMU, BIT_0, 0, 1)
REG32(PWR_CONFIG_USB2, 0x620)
    FIELD(PWR_CONFIG_USB2, STRAP, 0, 30)
REG32(PHY_HUB, 0x624)
    FIELD(PHY_HUB, VBUS_CTRL, 1, 1)
    FIELD(PHY_HUB, OVER_CURRENT, 0, 1)
REG32(CTRL, 0x700)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x800)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0x804)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x808)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x80c)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x810)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)
REG32(PARITY_ISR, 0x814)
    FIELD(PARITY_ISR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_ISR, PERR_AXI_SD0_IOU, 11, 1)
    FIELD(PARITY_ISR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_ISR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_ISR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_ISR, PERR_IOU_SD0, 7, 1)
    FIELD(PARITY_ISR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_ISR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_ISR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_ISR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_ISR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_ISR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_ISR, PERR_GPIO_APB, 0, 1)
REG32(PARITY_IMR, 0x818)
    FIELD(PARITY_IMR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_IMR, PERR_AXI_SD0_IOU, 11, 1)
    FIELD(PARITY_IMR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_IMR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_IMR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_IMR, PERR_IOU_SD0, 7, 1)
    FIELD(PARITY_IMR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_IMR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_IMR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_IMR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_IMR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_IMR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_IMR, PERR_GPIO_APB, 0, 1)
REG32(PARITY_IER, 0x81c)
    FIELD(PARITY_IER, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_IER, PERR_AXI_SD0_IOU, 11, 1)
    FIELD(PARITY_IER, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_IER, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_IER, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_IER, PERR_IOU_SD0, 7, 1)
    FIELD(PARITY_IER, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_IER, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_IER, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_IER, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_IER, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_IER, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_IER, PERR_GPIO_APB, 0, 1)
REG32(PARITY_IDR, 0x820)
    FIELD(PARITY_IDR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_IDR, PERR_AXI_SD0_IOU, 11, 1)
    FIELD(PARITY_IDR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_IDR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_IDR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_IDR, PERR_IOU_SD0, 7, 1)
    FIELD(PARITY_IDR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_IDR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_IDR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_IDR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_IDR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_IDR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_IDR, PERR_GPIO_APB, 0, 1)
REG32(PARITY_ITR, 0x824)
    FIELD(PARITY_ITR, PERR_AXI_SD1_IOU, 12, 1)
    FIELD(PARITY_ITR, PERR_AXI_SD0_IOU, 11, 1)
    FIELD(PARITY_ITR, PERR_AXI_QSPI_IOU, 10, 1)
    FIELD(PARITY_ITR, PERR_AXI_OSPI_IOU, 9, 1)
    FIELD(PARITY_ITR, PERR_IOU_SD1, 8, 1)
    FIELD(PARITY_ITR, PERR_IOU_SD0, 7, 1)
    FIELD(PARITY_ITR, PERR_IOU_QSPI1, 6, 1)
    FIELD(PARITY_ITR, PERR_IOUSLCR_SECURE_APB, 5, 1)
    FIELD(PARITY_ITR, PERR_IOUSLCR_APB, 4, 1)
    FIELD(PARITY_ITR, PERR_QSPI0_APB, 3, 1)
    FIELD(PARITY_ITR, PERR_OSPI_APB, 2, 1)
    FIELD(PARITY_ITR, PERR_I2C_APB, 1, 1)
    FIELD(PARITY_ITR, PERR_GPIO_APB, 0, 1)
REG32(WPROT0, 0x828)
    FIELD(WPROT0, ACTIVE, 0, 1)

#define R_MAX (R_WPROT0 + 1)

typedef struct PMC_IOU_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_parity_imr;
    qemu_irq irq_imr;
    qemu_irq sd_emmc_sel[2];
    qemu_irq qspi_ospi_mux_sel;
    qemu_irq ospi_mux_sel;

    uint32_t regs[R_MAX];
    RegisterInfo regs_info[R_MAX];
} PMC_IOU_SLCR;

static void pw_state_req_postw(RegisterInfo *reg, uint64_t val)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);

    s->regs[R_CUR_PWR_ST] = val & 0x3;
}

static void parity_imr_update_irq(PMC_IOU_SLCR *s)
{
    bool pending = s->regs[R_PARITY_ISR] & ~s->regs[R_PARITY_IMR];
    qemu_set_irq(s->irq_parity_imr, pending);
}

static void parity_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    parity_imr_update_irq(s);
}

static uint64_t parity_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PARITY_IMR] &= ~val;
    parity_imr_update_irq(s);
    return 0;
}

static uint64_t parity_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PARITY_IMR] |= val;
    parity_imr_update_irq(s);
    return 0;
}

static uint64_t parity_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PARITY_ISR] |= val;
    parity_imr_update_irq(s);
    return 0;
}

static void imr_update_irq(PMC_IOU_SLCR *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t sd0_ctrl_reg_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t prev = ARRAY_FIELD_EX32(s->regs, SD0_CTRL_REG, SD0_EMMC_SEL);

    if (prev != (val64 & R_SD0_CTRL_REG_SD0_EMMC_SEL_MASK)) {
        qemu_set_irq(s->sd_emmc_sel[0], !!val64);
    }

    return val64;
}

static uint64_t sd1_ctrl_reg_prew(RegisterInfo *reg, uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t prev = ARRAY_FIELD_EX32(s->regs, SD1_CTRL_REG, SD1_EMMC_SEL);

    if (prev != (val64 & R_SD1_CTRL_REG_SD1_EMMC_SEL_MASK)) {
        qemu_set_irq(s->sd_emmc_sel[1], !!val64);
    }

    return val64;
}

static uint64_t ospi_qspi_iou_axi_mux_sel_prew(RegisterInfo *reg,
                                               uint64_t val64)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(reg->opaque);
    uint32_t val32 = (uint32_t) val64;
    uint8_t ospi_mux_sel = FIELD_EX32(val32, OSPI_QSPI_IOU_AXI_MUX_SEL,
                                      OSPI_MUX_SEL);
    uint8_t qspi_ospi_mux_sel = FIELD_EX32(val32, OSPI_QSPI_IOU_AXI_MUX_SEL,
                                      QSPI_OSPI_MUX_SEL);

    if (ospi_mux_sel !=
        ARRAY_FIELD_EX32(s->regs, OSPI_QSPI_IOU_AXI_MUX_SEL, OSPI_MUX_SEL)) {
        qemu_set_irq(s->ospi_mux_sel, !!ospi_mux_sel);
    }

    if (qspi_ospi_mux_sel !=
        ARRAY_FIELD_EX32(s->regs, OSPI_QSPI_IOU_AXI_MUX_SEL,
                         QSPI_OSPI_MUX_SEL)) {
        qemu_set_irq(s->qspi_ospi_mux_sel, !!qspi_ospi_mux_sel);
    }

    return val64;
}

static RegisterAccessInfo pmc_iou_slcr_regs_info[] = {
    {   .name = "MIO_PIN_0",  .addr = A_MIO_PIN_0,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_1",  .addr = A_MIO_PIN_1,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_2",  .addr = A_MIO_PIN_2,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_3",  .addr = A_MIO_PIN_3,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_4",  .addr = A_MIO_PIN_4,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_5",  .addr = A_MIO_PIN_5,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_6",  .addr = A_MIO_PIN_6,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_7",  .addr = A_MIO_PIN_7,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_8",  .addr = A_MIO_PIN_8,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_9",  .addr = A_MIO_PIN_9,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_10",  .addr = A_MIO_PIN_10,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_11",  .addr = A_MIO_PIN_11,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_12",  .addr = A_MIO_PIN_12,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_13",  .addr = A_MIO_PIN_13,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_14",  .addr = A_MIO_PIN_14,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_15",  .addr = A_MIO_PIN_15,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_16",  .addr = A_MIO_PIN_16,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_17",  .addr = A_MIO_PIN_17,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_18",  .addr = A_MIO_PIN_18,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_19",  .addr = A_MIO_PIN_19,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_20",  .addr = A_MIO_PIN_20,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_21",  .addr = A_MIO_PIN_21,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_22",  .addr = A_MIO_PIN_22,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_23",  .addr = A_MIO_PIN_23,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_24",  .addr = A_MIO_PIN_24,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_25",  .addr = A_MIO_PIN_25,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_26",  .addr = A_MIO_PIN_26,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_27",  .addr = A_MIO_PIN_27,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_28",  .addr = A_MIO_PIN_28,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_29",  .addr = A_MIO_PIN_29,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_30",  .addr = A_MIO_PIN_30,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_31",  .addr = A_MIO_PIN_31,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_32",  .addr = A_MIO_PIN_32,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_33",  .addr = A_MIO_PIN_33,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_34",  .addr = A_MIO_PIN_34,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_35",  .addr = A_MIO_PIN_35,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_36",  .addr = A_MIO_PIN_36,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_37",  .addr = A_MIO_PIN_37,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_38",  .addr = A_MIO_PIN_38,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_39",  .addr = A_MIO_PIN_39,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_40",  .addr = A_MIO_PIN_40,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_41",  .addr = A_MIO_PIN_41,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_42",  .addr = A_MIO_PIN_42,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_43",  .addr = A_MIO_PIN_43,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_44",  .addr = A_MIO_PIN_44,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_45",  .addr = A_MIO_PIN_45,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_46",  .addr = A_MIO_PIN_46,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_47",  .addr = A_MIO_PIN_47,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_48",  .addr = A_MIO_PIN_48,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_49",  .addr = A_MIO_PIN_49,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_50",  .addr = A_MIO_PIN_50,
        .rsvd = 0xfffffc01,
    },{ .name = "MIO_PIN_51",  .addr = A_MIO_PIN_51,
        .rsvd = 0xfffffc01,
    },{ .name = "BNK0_EN_RX",  .addr = A_BNK0_EN_RX,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_SEL_RX0",  .addr = A_BNK0_SEL_RX0,
        .reset = 0xffffffff,
    },{ .name = "BNK0_SEL_RX1",  .addr = A_BNK0_SEL_RX1,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
    },{ .name = "BNK0_EN_RX_SCHMITT_HYST",  .addr = A_BNK0_EN_RX_SCHMITT_HYST,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_WK_PD",  .addr = A_BNK0_EN_WK_PD,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_WK_PU",  .addr = A_BNK0_EN_WK_PU,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_SEL_DRV0",  .addr = A_BNK0_SEL_DRV0,
        .reset = 0xffffffff,
    },{ .name = "BNK0_SEL_DRV1",  .addr = A_BNK0_SEL_DRV1,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
    },{ .name = "BNK0_SEL_SLEW",  .addr = A_BNK0_SEL_SLEW,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_DFT_OPT_INV",  .addr = A_BNK0_EN_DFT_OPT_INV,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_PAD2PAD_LOOPBACK",
        .addr = A_BNK0_EN_PAD2PAD_LOOPBACK,
        .rsvd = 0xffffe000,
    },{ .name = "BNK0_RX_SPARE0",  .addr = A_BNK0_RX_SPARE0,
    },{ .name = "BNK0_RX_SPARE1",  .addr = A_BNK0_RX_SPARE1,
        .rsvd = 0xfff00000,
    },{ .name = "BNK0_TX_SPARE0",  .addr = A_BNK0_TX_SPARE0,
    },{ .name = "BNK0_TX_SPARE1",  .addr = A_BNK0_TX_SPARE1,
        .rsvd = 0xfff00000,
    },{ .name = "BNK0_SEL_EN1P8",  .addr = A_BNK0_SEL_EN1P8,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK0_EN_B_POR_DETECT",  .addr = A_BNK0_EN_B_POR_DETECT,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK0_LPF_BYP_POR_DETECT",  .addr = A_BNK0_LPF_BYP_POR_DETECT,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK0_EN_LATCH",  .addr = A_BNK0_EN_LATCH,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK0_VBG_LPF_BYP_B",  .addr = A_BNK0_VBG_LPF_BYP_B,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK0_EN_AMP_B",  .addr = A_BNK0_EN_AMP_B,
        .rsvd = 0xfffffffc,
    },{ .name = "BNK0_SPARE_BIAS",  .addr = A_BNK0_SPARE_BIAS,
        .rsvd = 0xfffffff0,
    },{ .name = "BNK0_DRIVER_BIAS",  .addr = A_BNK0_DRIVER_BIAS,
        .rsvd = 0xffff8000,
    },{ .name = "BNK0_VMODE",  .addr = A_BNK0_VMODE,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "BNK0_SEL_AUX_IO_RX",  .addr = A_BNK0_SEL_AUX_IO_RX,
        .rsvd = 0xfc000000,
    },{ .name = "BNK0_EN_TX_HS_MODE",  .addr = A_BNK0_EN_TX_HS_MODE,
        .rsvd = 0xfc000000,
    },{ .name = "MIO_MST_TRI0",  .addr = A_MIO_MST_TRI0,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "MIO_MST_TRI1",  .addr = A_MIO_MST_TRI1,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_RX",  .addr = A_BNK1_EN_RX,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_SEL_RX0",  .addr = A_BNK1_SEL_RX0,
        .reset = 0xffffffff,
    },{ .name = "BNK1_SEL_RX1",  .addr = A_BNK1_SEL_RX1,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
    },{ .name = "BNK1_EN_RX_SCHMITT_HYST",  .addr = A_BNK1_EN_RX_SCHMITT_HYST,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_WK_PD",  .addr = A_BNK1_EN_WK_PD,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_WK_PU",  .addr = A_BNK1_EN_WK_PU,
        .reset = 0x3ffffff,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_SEL_DRV0",  .addr = A_BNK1_SEL_DRV0,
        .reset = 0xffffffff,
    },{ .name = "BNK1_SEL_DRV1",  .addr = A_BNK1_SEL_DRV1,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
    },{ .name = "BNK1_SEL_SLEW",  .addr = A_BNK1_SEL_SLEW,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_DFT_OPT_INV",  .addr = A_BNK1_EN_DFT_OPT_INV,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_PAD2PAD_LOOPBACK",
        .addr = A_BNK1_EN_PAD2PAD_LOOPBACK,
        .rsvd = 0xffffe000,
    },{ .name = "BNK1_RX_SPARE0",  .addr = A_BNK1_RX_SPARE0,
    },{ .name = "BNK1_RX_SPARE1",  .addr = A_BNK1_RX_SPARE1,
        .rsvd = 0xfff00000,
    },{ .name = "BNK1_TX_SPARE0",  .addr = A_BNK1_TX_SPARE0,
    },{ .name = "BNK1_TX_SPARE1",  .addr = A_BNK1_TX_SPARE1,
        .rsvd = 0xfff00000,
    },{ .name = "BNK1_SEL_EN1P8",  .addr = A_BNK1_SEL_EN1P8,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK1_EN_B_POR_DETECT",  .addr = A_BNK1_EN_B_POR_DETECT,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK1_LPF_BYP_POR_DETECT",  .addr = A_BNK1_LPF_BYP_POR_DETECT,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK1_EN_LATCH",  .addr = A_BNK1_EN_LATCH,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK1_VBG_LPF_BYP_B",  .addr = A_BNK1_VBG_LPF_BYP_B,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "BNK1_EN_AMP_B",  .addr = A_BNK1_EN_AMP_B,
        .rsvd = 0xfffffffc,
    },{ .name = "BNK1_SPARE_BIAS",  .addr = A_BNK1_SPARE_BIAS,
        .rsvd = 0xfffffff0,
    },{ .name = "BNK1_DRIVER_BIAS",  .addr = A_BNK1_DRIVER_BIAS,
        .rsvd = 0xffff8000,
    },{ .name = "BNK1_VMODE",  .addr = A_BNK1_VMODE,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "BNK1_SEL_AUX_IO_RX",  .addr = A_BNK1_SEL_AUX_IO_RX,
        .rsvd = 0xfc000000,
    },{ .name = "BNK1_EN_TX_HS_MODE",  .addr = A_BNK1_EN_TX_HS_MODE,
        .rsvd = 0xfc000000,
    },{ .name = "SD0_CLK_CTRL",  .addr = A_SD0_CLK_CTRL,
        .rsvd = 0xfffffff8,
    },{ .name = "SD0_CTRL_REG",  .addr = A_SD0_CTRL_REG,
        .rsvd = 0xfffffffe,
        .pre_write = sd0_ctrl_reg_prew,
    },{ .name = "SD0_CONFIG_REG1",  .addr = A_SD0_CONFIG_REG1,
        .reset = 0x3250,
        .rsvd = 0xffff8000,
    },{ .name = "SD0_CONFIG_REG2",  .addr = A_SD0_CONFIG_REG2,
        .reset = 0xffc,
        .rsvd = 0xffffc000,
    },{ .name = "SD0_CONFIG_REG3",  .addr = A_SD0_CONFIG_REG3,
        .reset = 0x407,
        .rsvd = 0xfffff800,
    },{ .name = "SD0_INITPRESET",  .addr = A_SD0_INITPRESET,
        .reset = 0x100,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_DSPPRESET",  .addr = A_SD0_DSPPRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_HSPDPRESET",  .addr = A_SD0_HSPDPRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_SDR12PRESET",  .addr = A_SD0_SDR12PRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_SDR25PRESET",  .addr = A_SD0_SDR25PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_SDR50PRSET",  .addr = A_SD0_SDR50PRSET,
        .reset = 0x1,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_SDR104PRST",  .addr = A_SD0_SDR104PRST,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_DDR50PRESET",  .addr = A_SD0_DDR50PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD0_MAXCUR1P8",  .addr = A_SD0_MAXCUR1P8,
        .rsvd = 0xffffff00,
    },{ .name = "SD0_MAXCUR3P0",  .addr = A_SD0_MAXCUR3P0,
        .rsvd = 0xffffff00,
    },{ .name = "SD0_MAXCUR3P3",  .addr = A_SD0_MAXCUR3P3,
        .rsvd = 0xffffff00,
    },{ .name = "SD0_DLL_CTRL",  .addr = A_SD0_DLL_CTRL,
        .reset = 0x1,
        .rsvd = 0xfffffc00,
        .ro = 0x19,
    },{ .name = "SD0_CDN_CTRL",  .addr = A_SD0_CDN_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "SD0_DLL_TEST",  .addr = A_SD0_DLL_TEST,
        .rsvd = 0xff000000,
    },{ .name = "SD0_RX_TUNING_SEL",  .addr = A_SD0_RX_TUNING_SEL,
        .rsvd = 0xfffffe00,
        .ro = 0x1ff,
    },{ .name = "SD0_DLL_DIV_MAP0",  .addr = A_SD0_DLL_DIV_MAP0,
        .reset = 0x50505050,
    },{ .name = "SD0_DLL_DIV_MAP1",  .addr = A_SD0_DLL_DIV_MAP1,
        .reset = 0x50505050,
    },{ .name = "SD0_IOU_COHERENT_CTRL",  .addr = A_SD0_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "SD0_IOU_INTERCONNECT_ROUTE",
        .addr = A_SD0_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "SD0_IOU_RAM",  .addr = A_SD0_IOU_RAM,
        .reset = 0x24,
        .rsvd = 0xffffff80,
    },{ .name = "SD0_IOU_INTERCONNECT_QOS",
        .addr = A_SD0_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "SD1_CLK_CTRL",  .addr = A_SD1_CLK_CTRL,
        .rsvd = 0xfffffffc,
    },{ .name = "SD1_CTRL_REG",  .addr = A_SD1_CTRL_REG,
        .rsvd = 0xfffffffe,
        .pre_write = sd1_ctrl_reg_prew,
    },{ .name = "SD1_CONFIG_REG1",  .addr = A_SD1_CONFIG_REG1,
        .reset = 0x3250,
        .rsvd = 0xffff8000,
    },{ .name = "SD1_CONFIG_REG2",  .addr = A_SD1_CONFIG_REG2,
        .reset = 0xffc,
        .rsvd = 0xffffc000,
    },{ .name = "SD1_CONFIG_REG3",  .addr = A_SD1_CONFIG_REG3,
        .reset = 0x407,
        .rsvd = 0xfffff800,
    },{ .name = "SD1_INITPRESET",  .addr = A_SD1_INITPRESET,
        .reset = 0x100,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_DSPPRESET",  .addr = A_SD1_DSPPRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_HSPDPRESET",  .addr = A_SD1_HSPDPRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR12PRESET",  .addr = A_SD1_SDR12PRESET,
        .reset = 0x4,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR25PRESET",  .addr = A_SD1_SDR25PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR50PRSET",  .addr = A_SD1_SDR50PRSET,
        .reset = 0x1,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_SDR104PRST",  .addr = A_SD1_SDR104PRST,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_DDR50PRESET",  .addr = A_SD1_DDR50PRESET,
        .reset = 0x2,
        .rsvd = 0xffffe000,
    },{ .name = "SD1_MAXCUR1P8",  .addr = A_SD1_MAXCUR1P8,
        .rsvd = 0xffffff00,
    },{ .name = "SD1_MAXCUR3P0",  .addr = A_SD1_MAXCUR3P0,
        .rsvd = 0xffffff00,
    },{ .name = "SD1_MAXCUR3P3",  .addr = A_SD1_MAXCUR3P3,
        .rsvd = 0xffffff00,
    },{ .name = "SD1_DLL_CTRL",  .addr = A_SD1_DLL_CTRL,
        .reset = 0x1,
        .rsvd = 0xfffffc00,
        .ro = 0x19,
    },{ .name = "SD1_CDN_CTRL",  .addr = A_SD1_CDN_CTRL,
        .rsvd = 0xfffffffe,
    },{ .name = "SD1_DLL_TEST",  .addr = A_SD1_DLL_TEST,
        .rsvd = 0xff000000,
    },{ .name = "SD1_RX_TUNING_SEL",  .addr = A_SD1_RX_TUNING_SEL,
        .rsvd = 0xfffffe00,
        .ro = 0x1ff,
    },{ .name = "SD1_DLL_DIV_MAP0",  .addr = A_SD1_DLL_DIV_MAP0,
        .reset = 0x50505050,
    },{ .name = "SD1_DLL_DIV_MAP1",  .addr = A_SD1_DLL_DIV_MAP1,
        .reset = 0x50505050,
    },{ .name = "SD1_IOU_COHERENT_CTRL",  .addr = A_SD1_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "SD1_IOU_INTERCONNECT_ROUTE",
        .addr = A_SD1_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "SD1_IOU_RAM",  .addr = A_SD1_IOU_RAM,
        .reset = 0x24,
        .rsvd = 0xffffff80,
    },{ .name = "SD1_IOU_INTERCONNECT_QOS",
        .addr = A_SD1_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_QSPI_IOU_AXI_MUX_SEL",
        .addr = A_OSPI_QSPI_IOU_AXI_MUX_SEL,
        .reset = 0x1,
        .rsvd = 0xfffffffc,
        .pre_write = ospi_qspi_iou_axi_mux_sel_prew,
    },{ .name = "QSPI_IOU_COHERENT_CTRL",  .addr = A_QSPI_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "QSPI_IOU_INTERCONNECT_ROUTE",
        .addr = A_QSPI_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "QSPI_IOU_RAM",  .addr = A_QSPI_IOU_RAM,
        .reset = 0x1224,
        .rsvd = 0xffffc000,
    },{ .name = "QSPI_IOU_INTERCONNECT_QOS",
        .addr = A_QSPI_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_IOU_COHERENT_CTRL",  .addr = A_OSPI_IOU_COHERENT_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_IOU_INTERCONNECT_ROUTE",
        .addr = A_OSPI_IOU_INTERCONNECT_ROUTE,
        .rsvd = 0xfffffffe,
    },{ .name = "OSPI_IOU_RAM",  .addr = A_OSPI_IOU_RAM,
        .reset = 0xa,
        .rsvd = 0xffffffc0,
    },{ .name = "OSPI_IOU_INTERCONNECT_QOS",
        .addr = A_OSPI_IOU_INTERCONNECT_QOS,
        .rsvd = 0xfffffff0,
    },{ .name = "OSPI_REFCLK_DLY_CTRL",  .addr = A_OSPI_REFCLK_DLY_CTRL,
        .reset = 0x13,
        .rsvd = 0xffffffe0,
    },{ .name = "CUR_PWR_ST",  .addr = A_CUR_PWR_ST,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "CONNECT_ST",  .addr = A_CONNECT_ST,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "PW_STATE_REQ",  .addr = A_PW_STATE_REQ,
        .rsvd = 0xfffffffc,
        .post_write = pw_state_req_postw,
    },{ .name = "HOST_U2_PORT_DISABLE",  .addr = A_HOST_U2_PORT_DISABLE,
        .rsvd = 0xfffffffe,
    },{ .name = "DBG_U2PMU",  .addr = A_DBG_U2PMU,
        .ro = 0xffffffff,
    },{ .name = "DBG_U2PMU_EXT1",  .addr = A_DBG_U2PMU_EXT1,
        .ro = 0xffffffff,
    },{ .name = "DBG_U2PMU_EXT2",  .addr = A_DBG_U2PMU_EXT2,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "PME_GEN_U2PMU",  .addr = A_PME_GEN_U2PMU,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "PWR_CONFIG_USB2",  .addr = A_PWR_CONFIG_USB2,
        .rsvd = 0xc0000000,
    },{ .name = "PHY_HUB",  .addr = A_PHY_HUB,
        .rsvd = 0xfffffffc,
        .ro = 0x2,
    },{ .name = "CTRL",  .addr = A_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "IER",  .addr = A_IER,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .pre_write = itr_prew,
    },{ .name = "PARITY_ISR",  .addr = A_PARITY_ISR,
        .w1c = 0x1fff,
        .post_write = parity_isr_postw,
    },{ .name = "PARITY_IMR",  .addr = A_PARITY_IMR,
        .reset = 0x1fff,
        .ro = 0x1fff,
    },{ .name = "PARITY_IER",  .addr = A_PARITY_IER,
        .pre_write = parity_ier_prew,
    },{ .name = "PARITY_IDR",  .addr = A_PARITY_IDR,
        .pre_write = parity_idr_prew,
    },{ .name = "PARITY_ITR",  .addr = A_PARITY_ITR,
        .pre_write = parity_itr_prew,
    },{ .name = "WPROT0",  .addr = A_WPROT0,
        .reset = 0x1,
    }
};

static void pmc_iou_slcr_reset(DeviceState *dev)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    parity_imr_update_irq(s);
    imr_update_irq(s);
    /* Setup OSPI_QSPI mux
     * By default axi slave interface is enabled for ospi-dma
     */
    qemu_set_irq(s->ospi_mux_sel, 0);
    qemu_set_irq(s->qspi_ospi_mux_sel, 1);
}

static const MemoryRegionOps pmc_iou_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmc_iou_slcr_realize(DeviceState *dev, Error **errp)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(dev);

    qdev_init_gpio_out(dev, s->sd_emmc_sel, 2);
    qdev_init_gpio_out(dev, &s->qspi_ospi_mux_sel, 1);
    qdev_init_gpio_out(dev, &s->ospi_mux_sel, 1);
}

static void pmc_iou_slcr_init(Object *obj)
{
    PMC_IOU_SLCR *s = XILINX_PMC_IOU_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMC_IOU_SLCR, R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmc_iou_slcr_regs_info,
                              ARRAY_SIZE(pmc_iou_slcr_regs_info),
                              s->regs_info, s->regs,
                              &pmc_iou_slcr_ops,
                              XILINX_PMC_IOU_SLCR_ERR_DEBUG,
                              R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_parity_imr);
    sysbus_init_irq(sbd, &s->irq_imr);
}

static const VMStateDescription vmstate_pmc_iou_slcr = {
    .name = TYPE_XILINX_PMC_IOU_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMC_IOU_SLCR, R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmc_iou_slcr_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pmc_iou_slcr_reset;
    dc->realize = pmc_iou_slcr_realize;
    dc->vmsd = &vmstate_pmc_iou_slcr;
}

static const TypeInfo pmc_iou_slcr_info = {
    .name          = TYPE_XILINX_PMC_IOU_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMC_IOU_SLCR),
    .class_init    = pmc_iou_slcr_class_init,
    .instance_init = pmc_iou_slcr_init,
};

static void pmc_iou_slcr_register_types(void)
{
    type_register_static(&pmc_iou_slcr_info);
}

type_init(pmc_iou_slcr_register_types)
