/*
 * QEMU model of the ASU_LOCAL_REG This is the database for the ASU Local
 * Register Definitions.
 *
 * Copyright (c) 2023 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2023-04-26.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_ASU_LOCAL_REG_ERR_DEBUG
#define XILINX_ASU_LOCAL_REG_ERR_DEBUG 0
#endif

#define TYPE_XILINX_ASU_LOCAL_REG "xlnx.asu_local_reg"

#define XILINX_ASU_LOCAL_REG(obj) \
     OBJECT_CHECK(ASU_LOCAL_REG, (obj), TYPE_XILINX_ASU_LOCAL_REG)

REG32(SSS_CFG, 0x0)
    FIELD(SSS_CFG, PLI_CFG, 16, 4)
    FIELD(SSS_CFG, SHA3_CFG, 12, 4)
    FIELD(SSS_CFG, SHA2_CFG, 8, 4)
    FIELD(SSS_CFG, AES_CFG, 4, 4)
    FIELD(SSS_CFG, DMA_CFG, 0, 4)
REG32(SSS_STATUS, 0x4)
    FIELD(SSS_STATUS, ERROR, 0, 1)
REG32(PL_ACCESS_ENABLE, 0x8)
    FIELD(PL_ACCESS_ENABLE, ENABLE, 0, 1)
REG32(LOCAL_GEN_STORAGE0, 0x10)
REG32(LOCAL_GEN_STORAGE1, 0x14)
REG32(LOCAL_GEN_STORAGE2, 0x18)
REG32(LOCAL_GEN_STORAGE3, 0x1c)
REG32(PERS_LOC_GEN_STORAGE0, 0x20)
REG32(PERS_LOC_GEN_STORAGE1, 0x24)
REG32(PERS_LOC_GEN_STORAGE2, 0x28)
REG32(PERS_LOC_GEN_STORAGE3, 0x2c)
REG32(ADDR_ERROR_STATUS, 0x30)
    FIELD(ADDR_ERROR_STATUS, STATUS, 0, 1)
REG32(ADDR_ERROR_INT_MASK, 0x34)
    FIELD(ADDR_ERROR_INT_MASK, MASK, 0, 1)
REG32(ADDR_ERROR_INT_EN, 0x38)
    FIELD(ADDR_ERROR_INT_EN, EN, 0, 1)
REG32(ADDR_ERROR_INT_DIS, 0x3c)
    FIELD(ADDR_ERROR_INT_DIS, DIS, 0, 1)

#define ASU_LOCAL_REG_R_MAX (R_ADDR_ERROR_INT_DIS + 1)

typedef struct ASU_LOCAL_REG {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_addr_error_int;

    uint32_t regs[ASU_LOCAL_REG_R_MAX];
    RegisterInfo regs_info[ASU_LOCAL_REG_R_MAX];
} ASU_LOCAL_REG;

static void addr_error_int_update_irq(ASU_LOCAL_REG *s)
{
    bool pending = s->regs[R_ADDR_ERROR_STATUS] &
                    ~s->regs[R_ADDR_ERROR_INT_MASK];
    qemu_set_irq(s->irq_addr_error_int, pending);
}

static void addr_error_status_postw(RegisterInfo *reg, uint64_t val64)
{
    ASU_LOCAL_REG *s = XILINX_ASU_LOCAL_REG(reg->opaque);
    addr_error_int_update_irq(s);
}

static uint64_t addr_error_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    ASU_LOCAL_REG *s = XILINX_ASU_LOCAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] &= ~val;
    addr_error_int_update_irq(s);
    return 0;
}

static uint64_t addr_error_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    ASU_LOCAL_REG *s = XILINX_ASU_LOCAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] |= val;
    addr_error_int_update_irq(s);
    return 0;
}

static const RegisterAccessInfo asu_local_reg_regs_info[] = {
    {   .name = "SSS_CFG",  .addr = A_SSS_CFG,
        .rsvd = 0xfff00000,
    },{ .name = "SSS_STATUS",  .addr = A_SSS_STATUS,
        .ro = 0x1,
    },{ .name = "PL_ACCESS_ENABLE",  .addr = A_PL_ACCESS_ENABLE,
    },{ .name = "LOCAL_GEN_STORAGE0",  .addr = A_LOCAL_GEN_STORAGE0,
    },{ .name = "LOCAL_GEN_STORAGE1",  .addr = A_LOCAL_GEN_STORAGE1,
    },{ .name = "LOCAL_GEN_STORAGE2",  .addr = A_LOCAL_GEN_STORAGE2,
    },{ .name = "LOCAL_GEN_STORAGE3",  .addr = A_LOCAL_GEN_STORAGE3,
    },{ .name = "PERS_LOC_GEN_STORAGE0",  .addr = A_PERS_LOC_GEN_STORAGE0,
    },{ .name = "PERS_LOC_GEN_STORAGE1",  .addr = A_PERS_LOC_GEN_STORAGE1,
    },{ .name = "PERS_LOC_GEN_STORAGE2",  .addr = A_PERS_LOC_GEN_STORAGE2,
    },{ .name = "PERS_LOC_GEN_STORAGE3",  .addr = A_PERS_LOC_GEN_STORAGE3,
    },{ .name = "ADDR_ERROR_STATUS",  .addr = A_ADDR_ERROR_STATUS,
        .w1c = 0x1,
        .post_write = addr_error_status_postw,
    },{ .name = "ADDR_ERROR_INT_MASK",  .addr = A_ADDR_ERROR_INT_MASK,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "ADDR_ERROR_INT_EN",  .addr = A_ADDR_ERROR_INT_EN,
        .pre_write = addr_error_int_en_prew,
    },{ .name = "ADDR_ERROR_INT_DIS",  .addr = A_ADDR_ERROR_INT_DIS,
        .pre_write = addr_error_int_dis_prew,
    }
};

static void asu_local_reg_reset_enter(Object *obj, ResetType type)
{
    ASU_LOCAL_REG *s = XILINX_ASU_LOCAL_REG(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void asu_local_reg_reset_hold(Object *obj)
{
    ASU_LOCAL_REG *s = XILINX_ASU_LOCAL_REG(obj);

    addr_error_int_update_irq(s);
}

static const MemoryRegionOps asu_local_reg_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void asu_local_reg_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void asu_local_reg_init(Object *obj)
{
    ASU_LOCAL_REG *s = XILINX_ASU_LOCAL_REG(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_ASU_LOCAL_REG,
                        ASU_LOCAL_REG_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), asu_local_reg_regs_info,
                              ARRAY_SIZE(asu_local_reg_regs_info),
                              s->regs_info, s->regs,
                              &asu_local_reg_ops,
                              XILINX_ASU_LOCAL_REG_ERR_DEBUG,
                              ASU_LOCAL_REG_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_addr_error_int);
}

static const VMStateDescription vmstate_asu_local_reg = {
    .name = TYPE_XILINX_ASU_LOCAL_REG,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, ASU_LOCAL_REG, ASU_LOCAL_REG_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void asu_local_reg_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = asu_local_reg_realize;
    dc->vmsd = &vmstate_asu_local_reg;
    rc->phases.enter = asu_local_reg_reset_enter;
    rc->phases.hold = asu_local_reg_reset_hold;
}

static const TypeInfo asu_local_reg_info = {
    .name          = TYPE_XILINX_ASU_LOCAL_REG,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(ASU_LOCAL_REG),
    .class_init    = asu_local_reg_class_init,
    .instance_init = asu_local_reg_init,
};

static void asu_local_reg_register_types(void)
{
    type_register_static(&asu_local_reg_info);
}

type_init(asu_local_reg_register_types)
