/* This file is autogenerated by scripts/decodetree.py.  */

typedef struct {
    int rs;
    int rn;
    int rt;
    int a;
    int r;
    int sz;
} arg_atomic;

typedef struct {
    int rd;
    int rn;
    int sf;
    int immr;
    int imms;
} arg_bitfield;

typedef struct {
    int rn;
    int rm;
    int m;
} arg_bra;

typedef struct {
    int rn;
    int m;
} arg_braz;

typedef struct {
    int rt;
    int imm;
    int sf;
    int nz;
} arg_cbz;

typedef struct {
    int rs;
    int rn;
    int rd;
    int options;
} arg_cpy;

typedef struct {
    int c;
    int cond;
    int imm;
} arg_disas_a6411;

typedef struct {
} arg_disas_a6415;

typedef struct {
    int domain;
    int types;
} arg_disas_a6416;

typedef struct {
    int mask;
    int imm;
} arg_disas_a6417;

typedef struct {
    int l;
    int op1;
    int crn;
    int crm;
    int op2;
    int rt;
    int op0;
} arg_disas_a6418;

typedef struct {
    int rs;
    int rn;
    int rt;
    int sz;
} arg_disas_a6421;

typedef struct {
    int sz;
    int rn;
    int rt;
} arg_disas_a6427;

typedef struct {
    int m;
    int w;
    int rn;
    int rt;
    int imm;
} arg_disas_a6428;

typedef struct {
    int q;
    int p;
    int rm;
    int scale;
    int rn;
    int rt;
    int selem;
} arg_disas_a6432;

typedef struct {
    int rd;
    int rn;
    int rm;
    int imm;
    int sf;
} arg_extract;

typedef struct {
    int imm;
} arg_i;

typedef struct {
    int rn;
    int rt;
    int imm;
    int sz;
    int sign;
    int ext;
} arg_ldapr_stlr_i;

typedef struct {
    int rt;
    int imm;
    int sz;
    int sign;
} arg_ldlit;

typedef struct {
    int rm;
    int rn;
    int rt;
    int sign;
    int ext;
    int sz;
    int opt;
    int s;
} arg_ldst;

typedef struct {
    int rt;
    int rn;
    int imm;
    int sz;
    int sign;
    int w;
    int p;
    int unpriv;
    int ext;
} arg_ldst_imm;

typedef struct {
    int rm;
    int rn;
    int rt;
    int sz;
    int q;
    int p;
    int rpt;
    int selem;
} arg_ldst_mult;

typedef struct {
    int rm;
    int rn;
    int rt;
    int p;
    int selem;
    int index;
    int scale;
} arg_ldst_single;

typedef struct {
    int rn;
    int rt;
    int imm;
    int p;
    int w;
} arg_ldst_tag;

typedef struct {
    int rt2;
    int rt;
    int rn;
    int imm;
    int sz;
    int sign;
    int w;
    int p;
} arg_ldstpair;

typedef struct {
    int rd;
    int sf;
    int imm;
    int hw;
} arg_movw;

typedef struct {
    int rn;
} arg_r;

typedef struct {
    int m;
} arg_reta;

typedef struct {
    int rd;
    int imm;
} arg_ri;

typedef struct {
    int rd;
    int rn;
    int sf;
    int dbm;
} arg_rri_log;

typedef struct {
    int rd;
    int rn;
    int imm;
    int sf;
} arg_rri_sf;

typedef struct {
    int rd;
    int rn;
    int uimm6;
    int uimm4;
} arg_rri_tag;

typedef struct {
    int rs;
    int rn;
    int rd;
    int unpriv;
    int nontemp;
} arg_set;

typedef struct {
    int rn;
    int rt;
    int sz;
    int lasr;
} arg_stlr;

typedef struct {
    int rn;
    int rt;
    int rt2;
    int rs;
    int sz;
    int lasr;
} arg_stxr;

typedef struct {
    int rt;
    int imm;
    int nz;
    int bitpos;
} arg_tbz;

typedef arg_ri arg_ADR;
static bool trans_ADR(DisasContext *ctx, arg_ADR *a);
typedef arg_ri arg_ADRP;
static bool trans_ADRP(DisasContext *ctx, arg_ADRP *a);
typedef arg_rri_sf arg_ADD_i;
static bool trans_ADD_i(DisasContext *ctx, arg_ADD_i *a);
typedef arg_rri_sf arg_ADDS_i;
static bool trans_ADDS_i(DisasContext *ctx, arg_ADDS_i *a);
typedef arg_rri_sf arg_SUB_i;
static bool trans_SUB_i(DisasContext *ctx, arg_SUB_i *a);
typedef arg_rri_sf arg_SUBS_i;
static bool trans_SUBS_i(DisasContext *ctx, arg_SUBS_i *a);
typedef arg_rri_tag arg_ADDG_i;
static bool trans_ADDG_i(DisasContext *ctx, arg_ADDG_i *a);
typedef arg_rri_tag arg_SUBG_i;
static bool trans_SUBG_i(DisasContext *ctx, arg_SUBG_i *a);
typedef arg_rri_log arg_AND_i;
static bool trans_AND_i(DisasContext *ctx, arg_AND_i *a);
typedef arg_rri_log arg_ORR_i;
static bool trans_ORR_i(DisasContext *ctx, arg_ORR_i *a);
typedef arg_rri_log arg_EOR_i;
static bool trans_EOR_i(DisasContext *ctx, arg_EOR_i *a);
typedef arg_rri_log arg_ANDS_i;
static bool trans_ANDS_i(DisasContext *ctx, arg_ANDS_i *a);
typedef arg_movw arg_MOVN;
static bool trans_MOVN(DisasContext *ctx, arg_MOVN *a);
typedef arg_movw arg_MOVZ;
static bool trans_MOVZ(DisasContext *ctx, arg_MOVZ *a);
typedef arg_movw arg_MOVK;
static bool trans_MOVK(DisasContext *ctx, arg_MOVK *a);
typedef arg_bitfield arg_SBFM;
static bool trans_SBFM(DisasContext *ctx, arg_SBFM *a);
typedef arg_bitfield arg_BFM;
static bool trans_BFM(DisasContext *ctx, arg_BFM *a);
typedef arg_bitfield arg_UBFM;
static bool trans_UBFM(DisasContext *ctx, arg_UBFM *a);
typedef arg_extract arg_EXTR;
static bool trans_EXTR(DisasContext *ctx, arg_EXTR *a);
typedef arg_i arg_B;
static bool trans_B(DisasContext *ctx, arg_B *a);
typedef arg_i arg_BL;
static bool trans_BL(DisasContext *ctx, arg_BL *a);
typedef arg_cbz arg_CBZ;
static bool trans_CBZ(DisasContext *ctx, arg_CBZ *a);
typedef arg_tbz arg_TBZ;
static bool trans_TBZ(DisasContext *ctx, arg_TBZ *a);
typedef arg_disas_a6411 arg_B_cond;
static bool trans_B_cond(DisasContext *ctx, arg_B_cond *a);
typedef arg_r arg_BR;
static bool trans_BR(DisasContext *ctx, arg_BR *a);
typedef arg_r arg_BLR;
static bool trans_BLR(DisasContext *ctx, arg_BLR *a);
typedef arg_r arg_RET;
static bool trans_RET(DisasContext *ctx, arg_RET *a);
typedef arg_braz arg_BRAZ;
static bool trans_BRAZ(DisasContext *ctx, arg_BRAZ *a);
typedef arg_braz arg_BLRAZ;
static bool trans_BLRAZ(DisasContext *ctx, arg_BLRAZ *a);
typedef arg_reta arg_RETA;
static bool trans_RETA(DisasContext *ctx, arg_RETA *a);
typedef arg_bra arg_BRA;
static bool trans_BRA(DisasContext *ctx, arg_BRA *a);
typedef arg_bra arg_BLRA;
static bool trans_BLRA(DisasContext *ctx, arg_BLRA *a);
typedef arg_disas_a6415 arg_ERET;
static bool trans_ERET(DisasContext *ctx, arg_ERET *a);
typedef arg_reta arg_ERETA;
static bool trans_ERETA(DisasContext *ctx, arg_ERETA *a);
typedef arg_disas_a6415 arg_YIELD;
static bool trans_YIELD(DisasContext *ctx, arg_YIELD *a);
typedef arg_disas_a6415 arg_WFE;
static bool trans_WFE(DisasContext *ctx, arg_WFE *a);
typedef arg_disas_a6415 arg_WFI;
static bool trans_WFI(DisasContext *ctx, arg_WFI *a);
typedef arg_disas_a6415 arg_XPACLRI;
static bool trans_XPACLRI(DisasContext *ctx, arg_XPACLRI *a);
typedef arg_disas_a6415 arg_PACIA1716;
static bool trans_PACIA1716(DisasContext *ctx, arg_PACIA1716 *a);
typedef arg_disas_a6415 arg_PACIB1716;
static bool trans_PACIB1716(DisasContext *ctx, arg_PACIB1716 *a);
typedef arg_disas_a6415 arg_AUTIA1716;
static bool trans_AUTIA1716(DisasContext *ctx, arg_AUTIA1716 *a);
typedef arg_disas_a6415 arg_AUTIB1716;
static bool trans_AUTIB1716(DisasContext *ctx, arg_AUTIB1716 *a);
typedef arg_disas_a6415 arg_ESB;
static bool trans_ESB(DisasContext *ctx, arg_ESB *a);
typedef arg_disas_a6415 arg_PACIAZ;
static bool trans_PACIAZ(DisasContext *ctx, arg_PACIAZ *a);
typedef arg_disas_a6415 arg_PACIASP;
static bool trans_PACIASP(DisasContext *ctx, arg_PACIASP *a);
typedef arg_disas_a6415 arg_PACIBZ;
static bool trans_PACIBZ(DisasContext *ctx, arg_PACIBZ *a);
typedef arg_disas_a6415 arg_PACIBSP;
static bool trans_PACIBSP(DisasContext *ctx, arg_PACIBSP *a);
typedef arg_disas_a6415 arg_AUTIAZ;
static bool trans_AUTIAZ(DisasContext *ctx, arg_AUTIAZ *a);
typedef arg_disas_a6415 arg_AUTIASP;
static bool trans_AUTIASP(DisasContext *ctx, arg_AUTIASP *a);
typedef arg_disas_a6415 arg_AUTIBZ;
static bool trans_AUTIBZ(DisasContext *ctx, arg_AUTIBZ *a);
typedef arg_disas_a6415 arg_AUTIBSP;
static bool trans_AUTIBSP(DisasContext *ctx, arg_AUTIBSP *a);
typedef arg_disas_a6415 arg_NOP;
static bool trans_NOP(DisasContext *ctx, arg_NOP *a);
typedef arg_disas_a6415 arg_CLREX;
static bool trans_CLREX(DisasContext *ctx, arg_CLREX *a);
typedef arg_disas_a6416 arg_DSB_DMB;
static bool trans_DSB_DMB(DisasContext *ctx, arg_DSB_DMB *a);
typedef arg_disas_a6415 arg_ISB;
static bool trans_ISB(DisasContext *ctx, arg_ISB *a);
typedef arg_disas_a6415 arg_SB;
static bool trans_SB(DisasContext *ctx, arg_SB *a);
typedef arg_disas_a6415 arg_CFINV;
static bool trans_CFINV(DisasContext *ctx, arg_CFINV *a);
typedef arg_disas_a6415 arg_XAFLAG;
static bool trans_XAFLAG(DisasContext *ctx, arg_XAFLAG *a);
typedef arg_disas_a6415 arg_AXFLAG;
static bool trans_AXFLAG(DisasContext *ctx, arg_AXFLAG *a);
typedef arg_i arg_MSR_i_UAO;
static bool trans_MSR_i_UAO(DisasContext *ctx, arg_MSR_i_UAO *a);
typedef arg_i arg_MSR_i_PAN;
static bool trans_MSR_i_PAN(DisasContext *ctx, arg_MSR_i_PAN *a);
typedef arg_i arg_MSR_i_SPSEL;
static bool trans_MSR_i_SPSEL(DisasContext *ctx, arg_MSR_i_SPSEL *a);
typedef arg_i arg_MSR_i_SBSS;
static bool trans_MSR_i_SBSS(DisasContext *ctx, arg_MSR_i_SBSS *a);
typedef arg_i arg_MSR_i_DIT;
static bool trans_MSR_i_DIT(DisasContext *ctx, arg_MSR_i_DIT *a);
typedef arg_i arg_MSR_i_TCO;
static bool trans_MSR_i_TCO(DisasContext *ctx, arg_MSR_i_TCO *a);
typedef arg_i arg_MSR_i_DAIFSET;
static bool trans_MSR_i_DAIFSET(DisasContext *ctx, arg_MSR_i_DAIFSET *a);
typedef arg_i arg_MSR_i_DAIFCLEAR;
static bool trans_MSR_i_DAIFCLEAR(DisasContext *ctx, arg_MSR_i_DAIFCLEAR *a);
typedef arg_disas_a6417 arg_MSR_i_SVCR;
static bool trans_MSR_i_SVCR(DisasContext *ctx, arg_MSR_i_SVCR *a);
typedef arg_disas_a6418 arg_SYS;
static bool trans_SYS(DisasContext *ctx, arg_SYS *a);
typedef arg_i arg_SVC;
static bool trans_SVC(DisasContext *ctx, arg_SVC *a);
typedef arg_i arg_HVC;
static bool trans_HVC(DisasContext *ctx, arg_HVC *a);
typedef arg_i arg_SMC;
static bool trans_SMC(DisasContext *ctx, arg_SMC *a);
typedef arg_i arg_BRK;
static bool trans_BRK(DisasContext *ctx, arg_BRK *a);
typedef arg_i arg_HLT;
static bool trans_HLT(DisasContext *ctx, arg_HLT *a);
typedef arg_stxr arg_STXR;
static bool trans_STXR(DisasContext *ctx, arg_STXR *a);
typedef arg_stxr arg_LDXR;
static bool trans_LDXR(DisasContext *ctx, arg_LDXR *a);
typedef arg_stlr arg_STLR;
static bool trans_STLR(DisasContext *ctx, arg_STLR *a);
typedef arg_stlr arg_LDAR;
static bool trans_LDAR(DisasContext *ctx, arg_LDAR *a);
typedef arg_stxr arg_STXP;
static bool trans_STXP(DisasContext *ctx, arg_STXP *a);
typedef arg_stxr arg_LDXP;
static bool trans_LDXP(DisasContext *ctx, arg_LDXP *a);
typedef arg_disas_a6421 arg_CASP;
static bool trans_CASP(DisasContext *ctx, arg_CASP *a);
typedef arg_disas_a6421 arg_CAS;
static bool trans_CAS(DisasContext *ctx, arg_CAS *a);
typedef arg_ldlit arg_LD_lit;
static bool trans_LD_lit(DisasContext *ctx, arg_LD_lit *a);
typedef arg_ldlit arg_LD_lit_v;
static bool trans_LD_lit_v(DisasContext *ctx, arg_LD_lit_v *a);
typedef arg_ldstpair arg_STP;
static bool trans_STP(DisasContext *ctx, arg_STP *a);
typedef arg_ldstpair arg_LDP;
static bool trans_LDP(DisasContext *ctx, arg_LDP *a);
typedef arg_ldstpair arg_STP_v;
static bool trans_STP_v(DisasContext *ctx, arg_STP_v *a);
typedef arg_ldstpair arg_LDP_v;
static bool trans_LDP_v(DisasContext *ctx, arg_LDP_v *a);
typedef arg_ldstpair arg_STGP;
static bool trans_STGP(DisasContext *ctx, arg_STGP *a);
typedef arg_ldst_imm arg_STR_i;
static bool trans_STR_i(DisasContext *ctx, arg_STR_i *a);
typedef arg_ldst_imm arg_LDR_i;
static bool trans_LDR_i(DisasContext *ctx, arg_LDR_i *a);
typedef arg_ldst_imm arg_STR_v_i;
static bool trans_STR_v_i(DisasContext *ctx, arg_STR_v_i *a);
typedef arg_ldst_imm arg_LDR_v_i;
static bool trans_LDR_v_i(DisasContext *ctx, arg_LDR_v_i *a);
typedef arg_ldst arg_STR;
static bool trans_STR(DisasContext *ctx, arg_STR *a);
typedef arg_ldst arg_LDR;
static bool trans_LDR(DisasContext *ctx, arg_LDR *a);
typedef arg_ldst arg_STR_v;
static bool trans_STR_v(DisasContext *ctx, arg_STR_v *a);
typedef arg_ldst arg_LDR_v;
static bool trans_LDR_v(DisasContext *ctx, arg_LDR_v *a);
typedef arg_atomic arg_LDADD;
static bool trans_LDADD(DisasContext *ctx, arg_LDADD *a);
typedef arg_atomic arg_LDCLR;
static bool trans_LDCLR(DisasContext *ctx, arg_LDCLR *a);
typedef arg_atomic arg_LDEOR;
static bool trans_LDEOR(DisasContext *ctx, arg_LDEOR *a);
typedef arg_atomic arg_LDSET;
static bool trans_LDSET(DisasContext *ctx, arg_LDSET *a);
typedef arg_atomic arg_LDSMAX;
static bool trans_LDSMAX(DisasContext *ctx, arg_LDSMAX *a);
typedef arg_atomic arg_LDSMIN;
static bool trans_LDSMIN(DisasContext *ctx, arg_LDSMIN *a);
typedef arg_atomic arg_LDUMAX;
static bool trans_LDUMAX(DisasContext *ctx, arg_LDUMAX *a);
typedef arg_atomic arg_LDUMIN;
static bool trans_LDUMIN(DisasContext *ctx, arg_LDUMIN *a);
typedef arg_atomic arg_SWP;
static bool trans_SWP(DisasContext *ctx, arg_SWP *a);
typedef arg_disas_a6427 arg_LDAPR;
static bool trans_LDAPR(DisasContext *ctx, arg_LDAPR *a);
typedef arg_disas_a6428 arg_LDRA;
static bool trans_LDRA(DisasContext *ctx, arg_LDRA *a);
typedef arg_ldapr_stlr_i arg_STLR_i;
static bool trans_STLR_i(DisasContext *ctx, arg_STLR_i *a);
typedef arg_ldapr_stlr_i arg_LDAPR_i;
static bool trans_LDAPR_i(DisasContext *ctx, arg_LDAPR_i *a);
typedef arg_ldst_mult arg_ST_mult;
static bool trans_ST_mult(DisasContext *ctx, arg_ST_mult *a);
typedef arg_ldst_mult arg_LD_mult;
static bool trans_LD_mult(DisasContext *ctx, arg_LD_mult *a);
typedef arg_ldst_single arg_ST_single;
static bool trans_ST_single(DisasContext *ctx, arg_ST_single *a);
typedef arg_ldst_single arg_LD_single;
static bool trans_LD_single(DisasContext *ctx, arg_LD_single *a);
typedef arg_disas_a6432 arg_LD_single_repl;
static bool trans_LD_single_repl(DisasContext *ctx, arg_LD_single_repl *a);
typedef arg_ldst_tag arg_STZGM;
static bool trans_STZGM(DisasContext *ctx, arg_STZGM *a);
typedef arg_ldst_tag arg_STG;
static bool trans_STG(DisasContext *ctx, arg_STG *a);
typedef arg_ldst_tag arg_LDG;
static bool trans_LDG(DisasContext *ctx, arg_LDG *a);
typedef arg_ldst_tag arg_STZG;
static bool trans_STZG(DisasContext *ctx, arg_STZG *a);
typedef arg_ldst_tag arg_STGM;
static bool trans_STGM(DisasContext *ctx, arg_STGM *a);
typedef arg_ldst_tag arg_ST2G;
static bool trans_ST2G(DisasContext *ctx, arg_ST2G *a);
typedef arg_ldst_tag arg_LDGM;
static bool trans_LDGM(DisasContext *ctx, arg_LDGM *a);
typedef arg_ldst_tag arg_STZ2G;
static bool trans_STZ2G(DisasContext *ctx, arg_STZ2G *a);
typedef arg_set arg_SETP;
static bool trans_SETP(DisasContext *ctx, arg_SETP *a);
typedef arg_set arg_SETM;
static bool trans_SETM(DisasContext *ctx, arg_SETM *a);
typedef arg_set arg_SETE;
static bool trans_SETE(DisasContext *ctx, arg_SETE *a);
typedef arg_set arg_SETGP;
static bool trans_SETGP(DisasContext *ctx, arg_SETGP *a);
typedef arg_set arg_SETGM;
static bool trans_SETGM(DisasContext *ctx, arg_SETGM *a);
typedef arg_set arg_SETGE;
static bool trans_SETGE(DisasContext *ctx, arg_SETGE *a);
typedef arg_cpy arg_CPYFP;
static bool trans_CPYFP(DisasContext *ctx, arg_CPYFP *a);
typedef arg_cpy arg_CPYFM;
static bool trans_CPYFM(DisasContext *ctx, arg_CPYFM *a);
typedef arg_cpy arg_CPYFE;
static bool trans_CPYFE(DisasContext *ctx, arg_CPYFE *a);
typedef arg_cpy arg_CPYP;
static bool trans_CPYP(DisasContext *ctx, arg_CPYP *a);
typedef arg_cpy arg_CPYM;
static bool trans_CPYM(DisasContext *ctx, arg_CPYM *a);
typedef arg_cpy arg_CPYE;
static bool trans_CPYE(DisasContext *ctx, arg_CPYE *a);

static void disas_a64_extract_addsub_imm(DisasContext *ctx, arg_rri_sf *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->sf = extract32(insn, 31, 1);
    a->imm = extract32(insn, 10, 12);
}

static void disas_a64_extract_addsub_imm12(DisasContext *ctx, arg_rri_sf *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->sf = extract32(insn, 31, 1);
    a->imm = shl_12(ctx, extract32(insn, 10, 12));
}

static void disas_a64_extract_addsub_imm_tag(DisasContext *ctx, arg_rri_tag *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->uimm6 = extract32(insn, 16, 6);
    a->rn = extract32(insn, 5, 5);
    a->uimm4 = extract32(insn, 10, 4);
}

static void disas_a64_extract_atomic(DisasContext *ctx, arg_atomic *a, uint32_t insn)
{
    a->rs = extract32(insn, 16, 5);
    a->sz = extract32(insn, 30, 2);
    a->rt = extract32(insn, 0, 5);
    a->r = extract32(insn, 22, 1);
    a->a = extract32(insn, 23, 1);
    a->rn = extract32(insn, 5, 5);
}

static void disas_a64_extract_bitfield_32(DisasContext *ctx, arg_bitfield *a, uint32_t insn)
{
    a->imms = extract32(insn, 10, 5);
    a->rn = extract32(insn, 5, 5);
    a->sf = 0;
    a->immr = extract32(insn, 16, 5);
    a->rd = extract32(insn, 0, 5);
}

static void disas_a64_extract_bitfield_64(DisasContext *ctx, arg_bitfield *a, uint32_t insn)
{
    a->imms = extract32(insn, 10, 6);
    a->rn = extract32(insn, 5, 5);
    a->sf = 1;
    a->immr = extract32(insn, 16, 6);
    a->rd = extract32(insn, 0, 5);
}

static void disas_a64_extract_branch(DisasContext *ctx, arg_i *a, uint32_t insn)
{
    a->imm = times_4(ctx, sextract32(insn, 0, 26));
}

static void disas_a64_extract_cpy(DisasContext *ctx, arg_cpy *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->rs = extract32(insn, 16, 5);
    a->options = extract32(insn, 12, 4);
    a->rn = extract32(insn, 5, 5);
}

static void disas_a64_extract_disas_a64_Fmt_10(DisasContext *ctx, arg_extract *a, uint32_t insn)
{
    a->imm = extract32(insn, 10, 6);
    a->rn = extract32(insn, 5, 5);
    a->sf = 1;
    a->rm = extract32(insn, 16, 5);
    a->rd = extract32(insn, 0, 5);
}

static void disas_a64_extract_disas_a64_Fmt_11(DisasContext *ctx, arg_extract *a, uint32_t insn)
{
    a->imm = extract32(insn, 10, 5);
    a->rn = extract32(insn, 5, 5);
    a->sf = 0;
    a->rm = extract32(insn, 16, 5);
    a->rd = extract32(insn, 0, 5);
}

static void disas_a64_extract_disas_a64_Fmt_13(DisasContext *ctx, arg_cbz *a, uint32_t insn)
{
    a->nz = extract32(insn, 24, 1);
    a->sf = extract32(insn, 31, 1);
    a->rt = extract32(insn, 0, 5);
    a->imm = times_4(ctx, sextract32(insn, 5, 19));
}

static void disas_a64_extract_disas_a64_Fmt_14(DisasContext *ctx, arg_tbz *a, uint32_t insn)
{
    a->bitpos = deposit32(extract32(insn, 19, 5), 5, 27, extract32(insn, 31, 1));
    a->nz = extract32(insn, 24, 1);
    a->rt = extract32(insn, 0, 5);
    a->imm = times_4(ctx, sextract32(insn, 5, 14));
}

static void disas_a64_extract_disas_a64_Fmt_15(DisasContext *ctx, arg_disas_a6411 *a, uint32_t insn)
{
    a->c = extract32(insn, 4, 1);
    a->cond = extract32(insn, 0, 4);
    a->imm = times_4(ctx, sextract32(insn, 5, 19));
}

static void disas_a64_extract_disas_a64_Fmt_16(DisasContext *ctx, arg_r *a, uint32_t insn)
{
    a->rn = extract32(insn, 5, 5);
}

static void disas_a64_extract_disas_a64_Fmt_17(DisasContext *ctx, arg_braz *a, uint32_t insn)
{
    a->m = extract32(insn, 10, 1);
    a->rn = extract32(insn, 5, 5);
}

static void disas_a64_extract_disas_a64_Fmt_18(DisasContext *ctx, arg_reta *a, uint32_t insn)
{
    a->m = extract32(insn, 10, 1);
}

static void disas_a64_extract_disas_a64_Fmt_19(DisasContext *ctx, arg_bra *a, uint32_t insn)
{
    a->m = extract32(insn, 10, 1);
    a->rn = extract32(insn, 5, 5);
    a->rm = extract32(insn, 0, 5);
}

static void disas_a64_extract_disas_a64_Fmt_20(DisasContext *ctx, arg_disas_a6415 *a, uint32_t insn)
{
}

static void disas_a64_extract_disas_a64_Fmt_21(DisasContext *ctx, arg_disas_a6416 *a, uint32_t insn)
{
    a->domain = extract32(insn, 10, 2);
    a->types = extract32(insn, 8, 2);
}

static void disas_a64_extract_disas_a64_Fmt_23(DisasContext *ctx, arg_disas_a6417 *a, uint32_t insn)
{
    a->mask = extract32(insn, 9, 2);
    a->imm = extract32(insn, 8, 1);
}

static void disas_a64_extract_disas_a64_Fmt_24(DisasContext *ctx, arg_disas_a6418 *a, uint32_t insn)
{
    a->op2 = extract32(insn, 5, 3);
    a->rt = extract32(insn, 0, 5);
    a->op1 = extract32(insn, 16, 3);
    a->crm = extract32(insn, 8, 4);
    a->op0 = 1;
    a->l = extract32(insn, 21, 1);
    a->crn = extract32(insn, 12, 4);
}

static void disas_a64_extract_disas_a64_Fmt_25(DisasContext *ctx, arg_disas_a6418 *a, uint32_t insn)
{
    a->op2 = extract32(insn, 5, 3);
    a->rt = extract32(insn, 0, 5);
    a->op1 = extract32(insn, 16, 3);
    a->crm = extract32(insn, 8, 4);
    a->op0 = 2;
    a->l = extract32(insn, 21, 1);
    a->crn = extract32(insn, 12, 4);
}

static void disas_a64_extract_disas_a64_Fmt_26(DisasContext *ctx, arg_disas_a6418 *a, uint32_t insn)
{
    a->op2 = extract32(insn, 5, 3);
    a->rt = extract32(insn, 0, 5);
    a->op1 = extract32(insn, 16, 3);
    a->crm = extract32(insn, 8, 4);
    a->op0 = 3;
    a->l = extract32(insn, 21, 1);
    a->crn = extract32(insn, 12, 4);
}

static void disas_a64_extract_disas_a64_Fmt_31(DisasContext *ctx, arg_disas_a6421 *a, uint32_t insn)
{
    a->rs = extract32(insn, 16, 5);
    a->rn = extract32(insn, 5, 5);
    a->sz = plus_2(ctx, extract32(insn, 30, 1));
    a->rt = extract32(insn, 0, 5);
}

static void disas_a64_extract_disas_a64_Fmt_32(DisasContext *ctx, arg_disas_a6421 *a, uint32_t insn)
{
    a->rs = extract32(insn, 16, 5);
    a->rn = extract32(insn, 5, 5);
    a->sz = extract32(insn, 30, 2);
    a->rt = extract32(insn, 0, 5);
}

static void disas_a64_extract_disas_a64_Fmt_42(DisasContext *ctx, arg_disas_a6427 *a, uint32_t insn)
{
    a->rn = extract32(insn, 5, 5);
    a->sz = extract32(insn, 30, 2);
    a->rt = extract32(insn, 0, 5);
}

static void disas_a64_extract_disas_a64_Fmt_43(DisasContext *ctx, arg_disas_a6428 *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->imm = times_8(ctx, deposit32(extract32(insn, 12, 9), 9, 23, sextract32(insn, 22, 1)));
    a->m = extract32(insn, 23, 1);
    a->rn = extract32(insn, 5, 5);
    a->w = extract32(insn, 11, 1);
}

static void disas_a64_extract_disas_a64_Fmt_50(DisasContext *ctx, arg_disas_a6432 *a, uint32_t insn)
{
    a->q = extract32(insn, 30, 1);
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->selem = plus_1(ctx, deposit32(extract32(insn, 21, 1), 1, 31, extract32(insn, 13, 1)));
    a->rm = extract32(insn, 16, 5);
    a->p = extract32(insn, 23, 1);
    a->scale = extract32(insn, 10, 2);
}

static void disas_a64_extract_i16(DisasContext *ctx, arg_i *a, uint32_t insn)
{
    a->imm = extract32(insn, 5, 16);
}

static void disas_a64_extract_ldapr_stlr_i(DisasContext *ctx, arg_ldapr_stlr_i *a, uint32_t insn)
{
    a->rn = extract32(insn, 5, 5);
    a->rt = extract32(insn, 0, 5);
    a->imm = sextract32(insn, 12, 9);
}

static void disas_a64_extract_ldlit(DisasContext *ctx, arg_ldlit *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->imm = times_4(ctx, sextract32(insn, 5, 19));
}

static void disas_a64_extract_ldst(DisasContext *ctx, arg_ldst *a, uint32_t insn)
{
    a->s = extract32(insn, 12, 1);
    a->rt = extract32(insn, 0, 5);
    a->opt = extract32(insn, 13, 3);
    a->rn = extract32(insn, 5, 5);
    a->rm = extract32(insn, 16, 5);
}

static void disas_a64_extract_ldst_imm(DisasContext *ctx, arg_ldst_imm *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->imm = sextract32(insn, 12, 9);
    a->rn = extract32(insn, 5, 5);
    a->p = 0;
    a->w = 0;
    a->unpriv = 0;
}

static void disas_a64_extract_ldst_imm_post(DisasContext *ctx, arg_ldst_imm *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->imm = sextract32(insn, 12, 9);
    a->rn = extract32(insn, 5, 5);
    a->p = 1;
    a->w = 1;
    a->unpriv = 0;
}

static void disas_a64_extract_ldst_imm_pre(DisasContext *ctx, arg_ldst_imm *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->imm = sextract32(insn, 12, 9);
    a->rn = extract32(insn, 5, 5);
    a->p = 0;
    a->w = 1;
    a->unpriv = 0;
}

static void disas_a64_extract_ldst_imm_user(DisasContext *ctx, arg_ldst_imm *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->imm = sextract32(insn, 12, 9);
    a->rn = extract32(insn, 5, 5);
    a->p = 0;
    a->w = 0;
    a->unpriv = 1;
}

static void disas_a64_extract_ldst_mult(DisasContext *ctx, arg_ldst_mult *a, uint32_t insn)
{
    a->q = extract32(insn, 30, 1);
    a->sz = extract32(insn, 10, 2);
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->rm = extract32(insn, 16, 5);
    a->p = extract32(insn, 23, 1);
}

static void disas_a64_extract_ldst_single_b(DisasContext *ctx, arg_ldst_single *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->selem = plus_1(ctx, deposit32(extract32(insn, 21, 1), 1, 31, extract32(insn, 13, 1)));
    a->rm = extract32(insn, 16, 5);
    a->p = extract32(insn, 23, 1);
    a->index = deposit32(extract32(insn, 10, 3), 3, 29, extract32(insn, 30, 1));
    a->scale = 0;
}

static void disas_a64_extract_ldst_single_d(DisasContext *ctx, arg_ldst_single *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->selem = plus_1(ctx, deposit32(extract32(insn, 21, 1), 1, 31, extract32(insn, 13, 1)));
    a->rm = extract32(insn, 16, 5);
    a->p = extract32(insn, 23, 1);
    a->index = extract32(insn, 30, 1);
    a->scale = 3;
}

static void disas_a64_extract_ldst_single_h(DisasContext *ctx, arg_ldst_single *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->selem = plus_1(ctx, deposit32(extract32(insn, 21, 1), 1, 31, extract32(insn, 13, 1)));
    a->rm = extract32(insn, 16, 5);
    a->p = extract32(insn, 23, 1);
    a->index = deposit32(extract32(insn, 11, 2), 2, 30, extract32(insn, 30, 1));
    a->scale = 1;
}

static void disas_a64_extract_ldst_single_s(DisasContext *ctx, arg_ldst_single *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->selem = plus_1(ctx, deposit32(extract32(insn, 21, 1), 1, 31, extract32(insn, 13, 1)));
    a->rm = extract32(insn, 16, 5);
    a->p = extract32(insn, 23, 1);
    a->index = deposit32(extract32(insn, 12, 1), 1, 31, extract32(insn, 30, 1));
    a->scale = 2;
}

static void disas_a64_extract_ldst_tag(DisasContext *ctx, arg_ldst_tag *a, uint32_t insn)
{
    a->rn = extract32(insn, 5, 5);
    a->rt = extract32(insn, 0, 5);
    a->imm = scale_by_log2_tag_granule(ctx, sextract32(insn, 12, 9));
}

static void disas_a64_extract_ldst_tag_mult(DisasContext *ctx, arg_ldst_tag *a, uint32_t insn)
{
    a->rn = extract32(insn, 5, 5);
    a->rt = extract32(insn, 0, 5);
    a->imm = 0;
}

static void disas_a64_extract_ldst_uimm(DisasContext *ctx, arg_ldst_imm *a, uint32_t insn)
{
    a->rt = extract32(insn, 0, 5);
    a->rn = extract32(insn, 5, 5);
    a->p = 0;
    a->w = 0;
    a->unpriv = 0;
    a->imm = uimm_scaled(ctx, deposit32(extract32(a->sz, 0, 3), 3, 29, extract32(insn, 10, 12)));
}

static void disas_a64_extract_ldstpair(DisasContext *ctx, arg_ldstpair *a, uint32_t insn)
{
    a->rt2 = extract32(insn, 10, 5);
    a->rn = extract32(insn, 5, 5);
    a->rt = extract32(insn, 0, 5);
    a->imm = sextract32(insn, 15, 7);
}

static void disas_a64_extract_logic_imm_32(DisasContext *ctx, arg_rri_log *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->sf = 0;
    a->rn = extract32(insn, 5, 5);
    a->dbm = extract32(insn, 10, 12);
}

static void disas_a64_extract_logic_imm_64(DisasContext *ctx, arg_rri_log *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->sf = 1;
    a->rn = extract32(insn, 5, 5);
    a->dbm = extract32(insn, 10, 13);
}

static void disas_a64_extract_movw_32(DisasContext *ctx, arg_movw *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->hw = extract32(insn, 21, 1);
    a->sf = 0;
    a->imm = extract32(insn, 5, 16);
}

static void disas_a64_extract_movw_64(DisasContext *ctx, arg_movw *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->hw = extract32(insn, 21, 2);
    a->sf = 1;
    a->imm = extract32(insn, 5, 16);
}

static void disas_a64_extract_msr_i(DisasContext *ctx, arg_i *a, uint32_t insn)
{
    a->imm = extract32(insn, 8, 4);
}

static void disas_a64_extract_pcrel(DisasContext *ctx, arg_ri *a, uint32_t insn)
{
    a->rd = extract32(insn, 0, 5);
    a->imm = deposit32(extract32(insn, 29, 2), 2, 30, sextract32(insn, 5, 19));
}

static void disas_a64_extract_set(DisasContext *ctx, arg_set *a, uint32_t insn)
{
    a->rs = extract32(insn, 16, 5);
    a->nontemp = extract32(insn, 13, 1);
    a->rn = extract32(insn, 5, 5);
    a->rd = extract32(insn, 0, 5);
    a->unpriv = extract32(insn, 12, 1);
}

static void disas_a64_extract_stlr(DisasContext *ctx, arg_stlr *a, uint32_t insn)
{
    a->rn = extract32(insn, 5, 5);
    a->sz = extract32(insn, 30, 2);
    a->rt = extract32(insn, 0, 5);
    a->lasr = extract32(insn, 15, 1);
}

static void disas_a64_extract_stxp(DisasContext *ctx, arg_stxr *a, uint32_t insn)
{
    a->rs = extract32(insn, 16, 5);
    a->rt = extract32(insn, 0, 5);
    a->sz = plus_2(ctx, extract32(insn, 30, 1));
    a->lasr = extract32(insn, 15, 1);
    a->rt2 = extract32(insn, 10, 5);
    a->rn = extract32(insn, 5, 5);
}

static void disas_a64_extract_stxr(DisasContext *ctx, arg_stxr *a, uint32_t insn)
{
    a->rs = extract32(insn, 16, 5);
    a->sz = extract32(insn, 30, 2);
    a->rt = extract32(insn, 0, 5);
    a->lasr = extract32(insn, 15, 1);
    a->rt2 = extract32(insn, 10, 5);
    a->rn = extract32(insn, 5, 5);
}

static bool disas_a64(DisasContext *ctx, uint32_t insn)
{
    union {
        arg_atomic f_atomic;
        arg_bitfield f_bitfield;
        arg_bra f_bra;
        arg_braz f_braz;
        arg_cbz f_cbz;
        arg_cpy f_cpy;
        arg_disas_a6411 f_disas_a6411;
        arg_disas_a6415 f_disas_a6415;
        arg_disas_a6416 f_disas_a6416;
        arg_disas_a6417 f_disas_a6417;
        arg_disas_a6418 f_disas_a6418;
        arg_disas_a6421 f_disas_a6421;
        arg_disas_a6427 f_disas_a6427;
        arg_disas_a6428 f_disas_a6428;
        arg_disas_a6432 f_disas_a6432;
        arg_extract f_extract;
        arg_i f_i;
        arg_ldapr_stlr_i f_ldapr_stlr_i;
        arg_ldlit f_ldlit;
        arg_ldst f_ldst;
        arg_ldst_imm f_ldst_imm;
        arg_ldst_mult f_ldst_mult;
        arg_ldst_single f_ldst_single;
        arg_ldst_tag f_ldst_tag;
        arg_ldstpair f_ldstpair;
        arg_movw f_movw;
        arg_r f_r;
        arg_reta f_reta;
        arg_ri f_ri;
        arg_rri_log f_rri_log;
        arg_rri_sf f_rri_sf;
        arg_rri_tag f_rri_tag;
        arg_set f_set;
        arg_stlr f_stlr;
        arg_stxr f_stxr;
        arg_tbz f_tbz;
    } u;

    switch ((insn >> 26) & 0x7) {
    case 0x2:
        /* ...010.. ........ ........ ........ */
        switch (insn & 0x23800000) {
        case 0x00000000:
            /* ..001000 0....... ........ ........ */
            switch ((insn >> 21) & 0x1) {
            case 0x0:
                /* ..001000 0.0..... ........ ........ */
                disas_a64_extract_stxr(ctx, &u.f_stxr, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* ..001000 000..... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:243 */
                    if (trans_STXR(ctx, &u.f_stxr)) return true;
                    break;
                case 0x1:
                    /* ..001000 010..... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:244 */
                    if (trans_LDXR(ctx, &u.f_stxr)) return true;
                    break;
                }
                break;
            case 0x1:
                /* ..001000 0.1..... ........ ........ */
                switch ((insn >> 31) & 0x1) {
                case 0x0:
                    /* 0.001000 0.1..... ........ ........ */
                    disas_a64_extract_disas_a64_Fmt_31(ctx, &u.f_disas_a6421, insn);
                    switch ((insn >> 10) & 0x1f) {
                    case 0x1f:
                        /* 0.001000 0.1..... .11111.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:253 */
                        if (trans_CASP(ctx, &u.f_disas_a6421)) return true;
                        break;
                    }
                    break;
                case 0x1:
                    /* 1.001000 0.1..... ........ ........ */
                    disas_a64_extract_stxp(ctx, &u.f_stxr, insn);
                    switch ((insn >> 22) & 0x1) {
                    case 0x0:
                        /* 1.001000 001..... ........ ........ */
                        /* ../git/target/arm/tcg/a64.decode:248 */
                        if (trans_STXP(ctx, &u.f_stxr)) return true;
                        break;
                    case 0x1:
                        /* 1.001000 011..... ........ ........ */
                        /* ../git/target/arm/tcg/a64.decode:249 */
                        if (trans_LDXP(ctx, &u.f_stxr)) return true;
                        break;
                    }
                    break;
                }
                break;
            }
            break;
        case 0x00800000:
            /* ..001000 1....... ........ ........ */
            switch (insn & 0x00207c00) {
            case 0x00007c00:
                /* ..001000 1.0..... .11111.. ........ */
                disas_a64_extract_stlr(ctx, &u.f_stlr, insn);
                switch (insn & 0x005f0000) {
                case 0x001f0000:
                    /* ..001000 10011111 .11111.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:245 */
                    if (trans_STLR(ctx, &u.f_stlr)) return true;
                    break;
                case 0x005f0000:
                    /* ..001000 11011111 .11111.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:246 */
                    if (trans_LDAR(ctx, &u.f_stlr)) return true;
                    break;
                }
                break;
            case 0x00207c00:
                /* ..001000 1.1..... .11111.. ........ */
                /* ../git/target/arm/tcg/a64.decode:255 */
                disas_a64_extract_disas_a64_Fmt_32(ctx, &u.f_disas_a6421, insn);
                if (trans_CAS(ctx, &u.f_disas_a6421)) return true;
                break;
            }
            break;
        case 0x20000000:
            /* ..101000 0....... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0xc0400000u) {
            case 0x00000000:
                /* 00101000 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:276 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00400000:
                /* 00101000 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:277 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80000000u:
                /* 10101000 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:278 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80400000u:
                /* 10101000 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:279 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0x20800000:
            /* ..101000 1....... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0xc0400000u) {
            case 0x00000000:
                /* 00101000 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:288 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00400000:
                /* 00101000 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:289 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101000 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:327 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_STGP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40400000:
                /* 01101000 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:290 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 1;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80000000u:
                /* 10101000 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:291 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80400000u:
                /* 10101000 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:292 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0x21000000:
            /* ..101001 0....... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0xc0400000u) {
            case 0x00000000:
                /* 00101001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:301 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00400000:
                /* 00101001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:302 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:328 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_STGP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40400000:
                /* 01101001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:303 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 1;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80000000u:
                /* 10101001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:304 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80400000u:
                /* 10101001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:305 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0x21800000:
            /* ..101001 1....... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0xc0400000u) {
            case 0x00000000:
                /* 00101001 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:314 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00400000:
                /* 00101001 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:315 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101001 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:329 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_STGP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40400000:
                /* 01101001 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:316 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 1;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80000000u:
                /* 10101001 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:317 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_STP(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x80400000u:
                /* 10101001 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:318 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_LDP(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        }
        break;
    case 0x3:
        /* ...011.. ........ ........ ........ */
        switch (insn & 0xa3400000u) {
        case 0x00000000:
            /* 0.001100 .0...... ........ ........ */
            disas_a64_extract_ldst_mult(ctx, &u.f_ldst_mult, insn);
            switch (insn & 0x0020f000) {
            case 0x00000000:
                /* 0.001100 .00..... 0000.... ........ */
                /* ../git/target/arm/tcg/a64.decode:483 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 4;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00002000:
                /* 0.001100 .00..... 0010.... ........ */
                /* ../git/target/arm/tcg/a64.decode:484 */
                u.f_ldst_mult.rpt = 4;
                u.f_ldst_mult.selem = 1;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00004000:
                /* 0.001100 .00..... 0100.... ........ */
                /* ../git/target/arm/tcg/a64.decode:485 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 3;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00006000:
                /* 0.001100 .00..... 0110.... ........ */
                /* ../git/target/arm/tcg/a64.decode:486 */
                u.f_ldst_mult.rpt = 3;
                u.f_ldst_mult.selem = 1;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00007000:
                /* 0.001100 .00..... 0111.... ........ */
                /* ../git/target/arm/tcg/a64.decode:487 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 1;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00008000:
                /* 0.001100 .00..... 1000.... ........ */
                /* ../git/target/arm/tcg/a64.decode:488 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 2;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x0000a000:
                /* 0.001100 .00..... 1010.... ........ */
                /* ../git/target/arm/tcg/a64.decode:489 */
                u.f_ldst_mult.rpt = 2;
                u.f_ldst_mult.selem = 1;
                if (trans_ST_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            }
            break;
        case 0x00400000:
            /* 0.001100 .1...... ........ ........ */
            disas_a64_extract_ldst_mult(ctx, &u.f_ldst_mult, insn);
            switch (insn & 0x0020f000) {
            case 0x00000000:
                /* 0.001100 .10..... 0000.... ........ */
                /* ../git/target/arm/tcg/a64.decode:491 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 4;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00002000:
                /* 0.001100 .10..... 0010.... ........ */
                /* ../git/target/arm/tcg/a64.decode:492 */
                u.f_ldst_mult.rpt = 4;
                u.f_ldst_mult.selem = 1;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00004000:
                /* 0.001100 .10..... 0100.... ........ */
                /* ../git/target/arm/tcg/a64.decode:493 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 3;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00006000:
                /* 0.001100 .10..... 0110.... ........ */
                /* ../git/target/arm/tcg/a64.decode:494 */
                u.f_ldst_mult.rpt = 3;
                u.f_ldst_mult.selem = 1;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00007000:
                /* 0.001100 .10..... 0111.... ........ */
                /* ../git/target/arm/tcg/a64.decode:495 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 1;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x00008000:
                /* 0.001100 .10..... 1000.... ........ */
                /* ../git/target/arm/tcg/a64.decode:496 */
                u.f_ldst_mult.rpt = 1;
                u.f_ldst_mult.selem = 2;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            case 0x0000a000:
                /* 0.001100 .10..... 1010.... ........ */
                /* ../git/target/arm/tcg/a64.decode:497 */
                u.f_ldst_mult.rpt = 2;
                u.f_ldst_mult.selem = 1;
                if (trans_LD_mult(ctx, &u.f_ldst_mult)) return true;
                break;
            }
            break;
        case 0x01000000:
            /* 0.001101 .0...... ........ ........ */
            switch ((insn >> 14) & 0x3) {
            case 0x0:
                /* 0.001101 .0...... 00...... ........ */
                /* ../git/target/arm/tcg/a64.decode:520 */
                disas_a64_extract_ldst_single_b(ctx, &u.f_ldst_single, insn);
                if (trans_ST_single(ctx, &u.f_ldst_single)) return true;
                break;
            case 0x1:
                /* 0.001101 .0...... 01...... ........ */
                disas_a64_extract_ldst_single_h(ctx, &u.f_ldst_single, insn);
                switch ((insn >> 10) & 0x1) {
                case 0x0:
                    /* 0.001101 .0...... 01...0.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:521 */
                    if (trans_ST_single(ctx, &u.f_ldst_single)) return true;
                    break;
                }
                break;
            case 0x2:
                /* 0.001101 .0...... 10...... ........ */
                switch ((insn >> 10) & 0x3) {
                case 0x0:
                    /* 0.001101 .0...... 10..00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:522 */
                    disas_a64_extract_ldst_single_s(ctx, &u.f_ldst_single, insn);
                    if (trans_ST_single(ctx, &u.f_ldst_single)) return true;
                    break;
                case 0x1:
                    /* 0.001101 .0...... 10..01.. ........ */
                    disas_a64_extract_ldst_single_d(ctx, &u.f_ldst_single, insn);
                    switch ((insn >> 12) & 0x1) {
                    case 0x0:
                        /* 0.001101 .0...... 10.001.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:523 */
                        if (trans_ST_single(ctx, &u.f_ldst_single)) return true;
                        break;
                    }
                    break;
                }
                break;
            }
            break;
        case 0x01400000:
            /* 0.001101 .1...... ........ ........ */
            switch ((insn >> 14) & 0x3) {
            case 0x0:
                /* 0.001101 .1...... 00...... ........ */
                /* ../git/target/arm/tcg/a64.decode:525 */
                disas_a64_extract_ldst_single_b(ctx, &u.f_ldst_single, insn);
                if (trans_LD_single(ctx, &u.f_ldst_single)) return true;
                break;
            case 0x1:
                /* 0.001101 .1...... 01...... ........ */
                disas_a64_extract_ldst_single_h(ctx, &u.f_ldst_single, insn);
                switch ((insn >> 10) & 0x1) {
                case 0x0:
                    /* 0.001101 .1...... 01...0.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:526 */
                    if (trans_LD_single(ctx, &u.f_ldst_single)) return true;
                    break;
                }
                break;
            case 0x2:
                /* 0.001101 .1...... 10...... ........ */
                switch ((insn >> 10) & 0x3) {
                case 0x0:
                    /* 0.001101 .1...... 10..00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:527 */
                    disas_a64_extract_ldst_single_s(ctx, &u.f_ldst_single, insn);
                    if (trans_LD_single(ctx, &u.f_ldst_single)) return true;
                    break;
                case 0x1:
                    /* 0.001101 .1...... 10..01.. ........ */
                    disas_a64_extract_ldst_single_d(ctx, &u.f_ldst_single, insn);
                    switch ((insn >> 12) & 0x1) {
                    case 0x0:
                        /* 0.001101 .1...... 10.001.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:528 */
                        if (trans_LD_single(ctx, &u.f_ldst_single)) return true;
                        break;
                    }
                    break;
                }
                break;
            case 0x3:
                /* 0.001101 .1...... 11...... ........ */
                disas_a64_extract_disas_a64_Fmt_50(ctx, &u.f_disas_a6432, insn);
                switch ((insn >> 12) & 0x1) {
                case 0x0:
                    /* 0.001101 .1...... 11.0.... ........ */
                    /* ../git/target/arm/tcg/a64.decode:531 */
                    if (trans_LD_single_repl(ctx, &u.f_disas_a6432)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x20000000:
            /* 0.101100 .0...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 00101100 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:280 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 00101100 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:293 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101100 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:282 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40800000:
                /* 01101100 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:295 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0x20400000:
            /* 0.101100 .1...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 00101100 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:281 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 00101100 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:294 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101100 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:283 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40800000:
                /* 01101100 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:296 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0x21000000:
            /* 0.101101 .0...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 00101101 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:306 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 00101101 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:319 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101101 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:308 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40800000:
                /* 01101101 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:321 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0x21400000:
            /* 0.101101 .1...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 00101101 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:307 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 2;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 00101101 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:320 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 2;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40000000:
                /* 01101101 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:309 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 3;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x40800000:
                /* 01101101 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:322 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 3;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0xa0000000u:
            /* 1.101100 .0...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 10101100 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:284 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 4;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 10101100 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:297 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 4;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0xa0400000u:
            /* 1.101100 .1...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 10101100 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:285 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 4;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 10101100 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:298 */
                u.f_ldstpair.p = 1;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 4;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0xa1000000u:
            /* 1.101101 .0...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 10101101 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:310 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 4;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 10101101 10...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:323 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 4;
                if (trans_STP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        case 0xa1400000u:
            /* 1.101101 .1...... ........ ........ */
            disas_a64_extract_ldstpair(ctx, &u.f_ldstpair, insn);
            switch (insn & 0x40800000) {
            case 0x00000000:
                /* 10101101 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:311 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 0;
                u.f_ldstpair.sz = 4;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            case 0x00800000:
                /* 10101101 11...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:324 */
                u.f_ldstpair.p = 0;
                u.f_ldstpair.sign = 0;
                u.f_ldstpair.w = 1;
                u.f_ldstpair.sz = 4;
                if (trans_LDP_v(ctx, &u.f_ldstpair)) return true;
                break;
            }
            break;
        }
        break;
    case 0x4:
        /* ...100.. ........ ........ ........ */
        switch ((insn >> 24) & 0x3) {
        case 0x0:
            /* ...10000 ........ ........ ........ */
            disas_a64_extract_pcrel(ctx, &u.f_ri, insn);
            switch ((insn >> 31) & 0x1) {
            case 0x0:
                /* 0..10000 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:35 */
                if (trans_ADR(ctx, &u.f_ri)) return true;
                break;
            case 0x1:
                /* 1..10000 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:36 */
                if (trans_ADRP(ctx, &u.f_ri)) return true;
                break;
            }
            break;
        case 0x1:
            /* ...10001 ........ ........ ........ */
            switch (insn & 0x60c00000) {
            case 0x00000000:
                /* .0010001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:44 */
                disas_a64_extract_addsub_imm(ctx, &u.f_rri_sf, insn);
                if (trans_ADD_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x00400000:
                /* .0010001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:45 */
                disas_a64_extract_addsub_imm12(ctx, &u.f_rri_sf, insn);
                if (trans_ADD_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x00800000:
                /* .0010001 10...... ........ ........ */
                disas_a64_extract_addsub_imm_tag(ctx, &u.f_rri_tag, insn);
                switch (insn & 0x8000c000u) {
                case 0x80000000u:
                    /* 10010001 10...... 00...... ........ */
                    /* ../git/target/arm/tcg/a64.decode:59 */
                    if (trans_ADDG_i(ctx, &u.f_rri_tag)) return true;
                    break;
                }
                break;
            case 0x20000000:
                /* .0110001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:46 */
                disas_a64_extract_addsub_imm(ctx, &u.f_rri_sf, insn);
                if (trans_ADDS_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x20400000:
                /* .0110001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:47 */
                disas_a64_extract_addsub_imm12(ctx, &u.f_rri_sf, insn);
                if (trans_ADDS_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x40000000:
                /* .1010001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:49 */
                disas_a64_extract_addsub_imm(ctx, &u.f_rri_sf, insn);
                if (trans_SUB_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x40400000:
                /* .1010001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:50 */
                disas_a64_extract_addsub_imm12(ctx, &u.f_rri_sf, insn);
                if (trans_SUB_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x40800000:
                /* .1010001 10...... ........ ........ */
                disas_a64_extract_addsub_imm_tag(ctx, &u.f_rri_tag, insn);
                switch (insn & 0x8000c000u) {
                case 0x80000000u:
                    /* 11010001 10...... 00...... ........ */
                    /* ../git/target/arm/tcg/a64.decode:60 */
                    if (trans_SUBG_i(ctx, &u.f_rri_tag)) return true;
                    break;
                }
                break;
            case 0x60000000:
                /* .1110001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:51 */
                disas_a64_extract_addsub_imm(ctx, &u.f_rri_sf, insn);
                if (trans_SUBS_i(ctx, &u.f_rri_sf)) return true;
                break;
            case 0x60400000:
                /* .1110001 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:52 */
                disas_a64_extract_addsub_imm12(ctx, &u.f_rri_sf, insn);
                if (trans_SUBS_i(ctx, &u.f_rri_sf)) return true;
                break;
            }
            break;
        case 0x2:
            /* ...10010 ........ ........ ........ */
            switch (insn & 0xe0800000u) {
            case 0x00000000:
                /* 00010010 0....... ........ ........ */
                disas_a64_extract_logic_imm_32(ctx, &u.f_rri_log, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 00010010 00...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:69 */
                    if (trans_AND_i(ctx, &u.f_rri_log)) return true;
                    break;
                }
                break;
            case 0x00800000:
                /* 00010010 1....... ........ ........ */
                disas_a64_extract_movw_32(ctx, &u.f_movw, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 00010010 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:84 */
                    if (trans_MOVN(ctx, &u.f_movw)) return true;
                    break;
                }
                break;
            case 0x20000000:
                /* 00110010 0....... ........ ........ */
                disas_a64_extract_logic_imm_32(ctx, &u.f_rri_log, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 00110010 00...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:71 */
                    if (trans_ORR_i(ctx, &u.f_rri_log)) return true;
                    break;
                }
                break;
            case 0x40000000:
                /* 01010010 0....... ........ ........ */
                disas_a64_extract_logic_imm_32(ctx, &u.f_rri_log, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 01010010 00...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:73 */
                    if (trans_EOR_i(ctx, &u.f_rri_log)) return true;
                    break;
                }
                break;
            case 0x40800000:
                /* 01010010 1....... ........ ........ */
                disas_a64_extract_movw_32(ctx, &u.f_movw, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 01010010 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:86 */
                    if (trans_MOVZ(ctx, &u.f_movw)) return true;
                    break;
                }
                break;
            case 0x60000000:
                /* 01110010 0....... ........ ........ */
                disas_a64_extract_logic_imm_32(ctx, &u.f_rri_log, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 01110010 00...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:75 */
                    if (trans_ANDS_i(ctx, &u.f_rri_log)) return true;
                    break;
                }
                break;
            case 0x60800000:
                /* 01110010 1....... ........ ........ */
                disas_a64_extract_movw_32(ctx, &u.f_movw, insn);
                switch ((insn >> 22) & 0x1) {
                case 0x0:
                    /* 01110010 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:88 */
                    if (trans_MOVK(ctx, &u.f_movw)) return true;
                    break;
                }
                break;
            case 0x80000000u:
                /* 10010010 0....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:68 */
                disas_a64_extract_logic_imm_64(ctx, &u.f_rri_log, insn);
                if (trans_AND_i(ctx, &u.f_rri_log)) return true;
                break;
            case 0x80800000u:
                /* 10010010 1....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:83 */
                disas_a64_extract_movw_64(ctx, &u.f_movw, insn);
                if (trans_MOVN(ctx, &u.f_movw)) return true;
                break;
            case 0xa0000000u:
                /* 10110010 0....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:70 */
                disas_a64_extract_logic_imm_64(ctx, &u.f_rri_log, insn);
                if (trans_ORR_i(ctx, &u.f_rri_log)) return true;
                break;
            case 0xc0000000u:
                /* 11010010 0....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:72 */
                disas_a64_extract_logic_imm_64(ctx, &u.f_rri_log, insn);
                if (trans_EOR_i(ctx, &u.f_rri_log)) return true;
                break;
            case 0xc0800000u:
                /* 11010010 1....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:85 */
                disas_a64_extract_movw_64(ctx, &u.f_movw, insn);
                if (trans_MOVZ(ctx, &u.f_movw)) return true;
                break;
            case 0xe0000000u:
                /* 11110010 0....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:74 */
                disas_a64_extract_logic_imm_64(ctx, &u.f_rri_log, insn);
                if (trans_ANDS_i(ctx, &u.f_rri_log)) return true;
                break;
            case 0xe0800000u:
                /* 11110010 1....... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:87 */
                disas_a64_extract_movw_64(ctx, &u.f_movw, insn);
                if (trans_MOVK(ctx, &u.f_movw)) return true;
                break;
            }
            break;
        case 0x3:
            /* ...10011 ........ ........ ........ */
            switch (insn & 0xe0c00000u) {
            case 0x00000000:
                /* 00010011 00...... ........ ........ */
                disas_a64_extract_bitfield_32(ctx, &u.f_bitfield, insn);
                switch (insn & 0x00208000) {
                case 0x00000000:
                    /* 00010011 000..... 0....... ........ */
                    /* ../git/target/arm/tcg/a64.decode:97 */
                    if (trans_SBFM(ctx, &u.f_bitfield)) return true;
                    break;
                }
                break;
            case 0x00800000:
                /* 00010011 10...... ........ ........ */
                disas_a64_extract_disas_a64_Fmt_11(ctx, &u.f_extract, insn);
                switch (insn & 0x00208000) {
                case 0x00000000:
                    /* 00010011 100..... 0....... ........ */
                    /* ../git/target/arm/tcg/a64.decode:108 */
                    if (trans_EXTR(ctx, &u.f_extract)) return true;
                    break;
                }
                break;
            case 0x20000000:
                /* 00110011 00...... ........ ........ */
                disas_a64_extract_bitfield_32(ctx, &u.f_bitfield, insn);
                switch (insn & 0x00208000) {
                case 0x00000000:
                    /* 00110011 000..... 0....... ........ */
                    /* ../git/target/arm/tcg/a64.decode:99 */
                    if (trans_BFM(ctx, &u.f_bitfield)) return true;
                    break;
                }
                break;
            case 0x40000000:
                /* 01010011 00...... ........ ........ */
                disas_a64_extract_bitfield_32(ctx, &u.f_bitfield, insn);
                switch (insn & 0x00208000) {
                case 0x00000000:
                    /* 01010011 000..... 0....... ........ */
                    /* ../git/target/arm/tcg/a64.decode:101 */
                    if (trans_UBFM(ctx, &u.f_bitfield)) return true;
                    break;
                }
                break;
            case 0x80400000u:
                /* 10010011 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:96 */
                disas_a64_extract_bitfield_64(ctx, &u.f_bitfield, insn);
                if (trans_SBFM(ctx, &u.f_bitfield)) return true;
                break;
            case 0x80c00000u:
                /* 10010011 11...... ........ ........ */
                disas_a64_extract_disas_a64_Fmt_10(ctx, &u.f_extract, insn);
                switch ((insn >> 21) & 0x1) {
                case 0x0:
                    /* 10010011 110..... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:107 */
                    if (trans_EXTR(ctx, &u.f_extract)) return true;
                    break;
                }
                break;
            case 0xa0400000u:
                /* 10110011 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:98 */
                disas_a64_extract_bitfield_64(ctx, &u.f_bitfield, insn);
                if (trans_BFM(ctx, &u.f_bitfield)) return true;
                break;
            case 0xc0400000u:
                /* 11010011 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:100 */
                disas_a64_extract_bitfield_64(ctx, &u.f_bitfield, insn);
                if (trans_UBFM(ctx, &u.f_bitfield)) return true;
                break;
            }
            break;
        }
        break;
    case 0x5:
        /* ...101.. ........ ........ ........ */
        switch ((insn >> 29) & 0x3) {
        case 0x0:
            /* .00101.. ........ ........ ........ */
            disas_a64_extract_branch(ctx, &u.f_i, insn);
            switch ((insn >> 31) & 0x1) {
            case 0x0:
                /* 000101.. ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:115 */
                if (trans_B(ctx, &u.f_i)) return true;
                break;
            case 0x1:
                /* 100101.. ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:116 */
                if (trans_BL(ctx, &u.f_i)) return true;
                break;
            }
            break;
        case 0x1:
            /* .01101.. ........ ........ ........ */
            switch ((insn >> 25) & 0x1) {
            case 0x0:
                /* .011010. ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:121 */
                disas_a64_extract_disas_a64_Fmt_13(ctx, &u.f_cbz, insn);
                if (trans_CBZ(ctx, &u.f_cbz)) return true;
                break;
            case 0x1:
                /* .011011. ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:127 */
                disas_a64_extract_disas_a64_Fmt_14(ctx, &u.f_tbz, insn);
                if (trans_TBZ(ctx, &u.f_tbz)) return true;
                break;
            }
            break;
        case 0x2:
            /* .10101.. ........ ........ ........ */
            switch (insn & 0x83000000u) {
            case 0x00000000:
                /* 01010100 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:130 */
                disas_a64_extract_disas_a64_Fmt_15(ctx, &u.f_disas_a6411, insn);
                if (trans_B_cond(ctx, &u.f_disas_a6411)) return true;
                break;
            case 0x80000000u:
                /* 11010100 ........ ........ ........ */
                disas_a64_extract_i16(ctx, &u.f_i, insn);
                switch (insn & 0x00e0001f) {
                case 0x00000001:
                    /* 11010100 000..... ........ ...00001 */
                    /* ../git/target/arm/tcg/a64.decode:223 */
                    if (trans_SVC(ctx, &u.f_i)) return true;
                    break;
                case 0x00000002:
                    /* 11010100 000..... ........ ...00010 */
                    /* ../git/target/arm/tcg/a64.decode:224 */
                    if (trans_HVC(ctx, &u.f_i)) return true;
                    break;
                case 0x00000003:
                    /* 11010100 000..... ........ ...00011 */
                    /* ../git/target/arm/tcg/a64.decode:225 */
                    if (trans_SMC(ctx, &u.f_i)) return true;
                    break;
                case 0x00200000:
                    /* 11010100 001..... ........ ...00000 */
                    /* ../git/target/arm/tcg/a64.decode:226 */
                    if (trans_BRK(ctx, &u.f_i)) return true;
                    break;
                case 0x00400000:
                    /* 11010100 010..... ........ ...00000 */
                    /* ../git/target/arm/tcg/a64.decode:227 */
                    if (trans_HLT(ctx, &u.f_i)) return true;
                    break;
                }
                break;
            case 0x81000000u:
                /* 11010101 ........ ........ ........ */
                switch (insn & 0x00d80000) {
                case 0x00000000:
                    /* 11010101 00.00... ........ ........ */
                    switch (insn & 0x0027f01f) {
                    case 0x0000401f:
                        /* 11010101 00000000 0100.... ...11111 */
                        switch ((insn >> 5) & 0x7) {
                        case 0x0:
                            /* 11010101 00000000 0100.... 00011111 */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 8) & 0xf) {
                            case 0x0:
                                /* 11010101 00000000 01000000 00011111 */
                                /* ../git/target/arm/tcg/a64.decode:195 */
                                if (trans_CFINV(ctx, &u.f_disas_a6415)) return true;
                                break;
                            }
                            break;
                        case 0x1:
                            /* 11010101 00000000 0100.... 00111111 */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 8) & 0xf) {
                            case 0x0:
                                /* 11010101 00000000 01000000 00111111 */
                                /* ../git/target/arm/tcg/a64.decode:196 */
                                if (trans_XAFLAG(ctx, &u.f_disas_a6415)) return true;
                                break;
                            }
                            break;
                        case 0x2:
                            /* 11010101 00000000 0100.... 01011111 */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 8) & 0xf) {
                            case 0x0:
                                /* 11010101 00000000 01000000 01011111 */
                                /* ../git/target/arm/tcg/a64.decode:197 */
                                if (trans_AXFLAG(ctx, &u.f_disas_a6415)) return true;
                                break;
                            }
                            break;
                        case 0x3:
                            /* 11010101 00000000 0100.... 01111111 */
                            /* ../git/target/arm/tcg/a64.decode:202 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_UAO(ctx, &u.f_i)) return true;
                            break;
                        case 0x4:
                            /* 11010101 00000000 0100.... 10011111 */
                            /* ../git/target/arm/tcg/a64.decode:203 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_PAN(ctx, &u.f_i)) return true;
                            break;
                        case 0x5:
                            /* 11010101 00000000 0100.... 10111111 */
                            /* ../git/target/arm/tcg/a64.decode:204 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_SPSEL(ctx, &u.f_i)) return true;
                            break;
                        }
                        break;
                    case 0x0003201f:
                        /* 11010101 00000011 0010.... ...11111 */
                        if ((insn & 0x00000c00) == 0x00000000) {
                            /* 11010101 00000011 001000.. ...11111 */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 5) & 0x1f) {
                            case 0x1:
                                /* 11010101 00000011 00100000 00111111 */
                                /* ../git/target/arm/tcg/a64.decode:158 */
                                if (trans_YIELD(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x2:
                                /* 11010101 00000011 00100000 01011111 */
                                /* ../git/target/arm/tcg/a64.decode:159 */
                                if (trans_WFE(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x3:
                                /* 11010101 00000011 00100000 01111111 */
                                /* ../git/target/arm/tcg/a64.decode:160 */
                                if (trans_WFI(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x7:
                                /* 11010101 00000011 00100000 11111111 */
                                /* ../git/target/arm/tcg/a64.decode:166 */
                                if (trans_XPACLRI(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x8:
                                /* 11010101 00000011 00100001 00011111 */
                                /* ../git/target/arm/tcg/a64.decode:167 */
                                if (trans_PACIA1716(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0xa:
                                /* 11010101 00000011 00100001 01011111 */
                                /* ../git/target/arm/tcg/a64.decode:168 */
                                if (trans_PACIB1716(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0xc:
                                /* 11010101 00000011 00100001 10011111 */
                                /* ../git/target/arm/tcg/a64.decode:169 */
                                if (trans_AUTIA1716(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0xe:
                                /* 11010101 00000011 00100001 11011111 */
                                /* ../git/target/arm/tcg/a64.decode:170 */
                                if (trans_AUTIB1716(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x10:
                                /* 11010101 00000011 00100010 00011111 */
                                /* ../git/target/arm/tcg/a64.decode:171 */
                                if (trans_ESB(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x18:
                                /* 11010101 00000011 00100011 00011111 */
                                /* ../git/target/arm/tcg/a64.decode:172 */
                                if (trans_PACIAZ(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x19:
                                /* 11010101 00000011 00100011 00111111 */
                                /* ../git/target/arm/tcg/a64.decode:173 */
                                if (trans_PACIASP(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1a:
                                /* 11010101 00000011 00100011 01011111 */
                                /* ../git/target/arm/tcg/a64.decode:174 */
                                if (trans_PACIBZ(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1b:
                                /* 11010101 00000011 00100011 01111111 */
                                /* ../git/target/arm/tcg/a64.decode:175 */
                                if (trans_PACIBSP(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1c:
                                /* 11010101 00000011 00100011 10011111 */
                                /* ../git/target/arm/tcg/a64.decode:176 */
                                if (trans_AUTIAZ(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1d:
                                /* 11010101 00000011 00100011 10111111 */
                                /* ../git/target/arm/tcg/a64.decode:177 */
                                if (trans_AUTIASP(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1e:
                                /* 11010101 00000011 00100011 11011111 */
                                /* ../git/target/arm/tcg/a64.decode:178 */
                                if (trans_AUTIBZ(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1f:
                                /* 11010101 00000011 00100011 11111111 */
                                /* ../git/target/arm/tcg/a64.decode:179 */
                                if (trans_AUTIBSP(ctx, &u.f_disas_a6415)) return true;
                                break;
                            }
                        }
                        /* ../git/target/arm/tcg/a64.decode:183 */
                        disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                        if (trans_NOP(ctx, &u.f_disas_a6415)) return true;
                        break;
                    case 0x0003301f:
                        /* 11010101 00000011 0011.... ...11111 */
                        switch ((insn >> 6) & 0x3) {
                        case 0x1:
                            /* 11010101 00000011 0011.... 01.11111 */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 5) & 0x1) {
                            case 0x0:
                                /* 11010101 00000011 0011.... 01011111 */
                                /* ../git/target/arm/tcg/a64.decode:188 */
                                if (trans_CLREX(ctx, &u.f_disas_a6415)) return true;
                                break;
                            }
                            break;
                        case 0x2:
                            /* 11010101 00000011 0011.... 10.11111 */
                            /* ../git/target/arm/tcg/a64.decode:189 */
                            disas_a64_extract_disas_a64_Fmt_21(ctx, &u.f_disas_a6416, insn);
                            if (trans_DSB_DMB(ctx, &u.f_disas_a6416)) return true;
                            break;
                        case 0x3:
                            /* 11010101 00000011 0011.... 11.11111 */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 5) & 0x1) {
                            case 0x0:
                                /* 11010101 00000011 0011.... 11011111 */
                                /* ../git/target/arm/tcg/a64.decode:190 */
                                if (trans_ISB(ctx, &u.f_disas_a6415)) return true;
                                break;
                            case 0x1:
                                /* 11010101 00000011 0011.... 11111111 */
                                switch ((insn >> 8) & 0xf) {
                                case 0x0:
                                    /* 11010101 00000011 00110000 11111111 */
                                    /* ../git/target/arm/tcg/a64.decode:191 */
                                    if (trans_SB(ctx, &u.f_disas_a6415)) return true;
                                    break;
                                }
                                break;
                            }
                            break;
                        }
                        break;
                    case 0x0003401f:
                        /* 11010101 00000011 0100.... ...11111 */
                        switch ((insn >> 5) & 0x7) {
                        case 0x1:
                            /* 11010101 00000011 0100.... 00111111 */
                            /* ../git/target/arm/tcg/a64.decode:205 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_SBSS(ctx, &u.f_i)) return true;
                            break;
                        case 0x2:
                            /* 11010101 00000011 0100.... 01011111 */
                            /* ../git/target/arm/tcg/a64.decode:206 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_DIT(ctx, &u.f_i)) return true;
                            break;
                        case 0x3:
                            /* 11010101 00000011 0100.... 01111111 */
                            disas_a64_extract_disas_a64_Fmt_23(ctx, &u.f_disas_a6417, insn);
                            switch ((insn >> 11) & 0x1) {
                            case 0x0:
                                /* 11010101 00000011 01000... 01111111 */
                                /* ../git/target/arm/tcg/a64.decode:210 */
                                if (trans_MSR_i_SVCR(ctx, &u.f_disas_a6417)) return true;
                                break;
                            }
                            break;
                        case 0x4:
                            /* 11010101 00000011 0100.... 10011111 */
                            /* ../git/target/arm/tcg/a64.decode:207 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_TCO(ctx, &u.f_i)) return true;
                            break;
                        case 0x6:
                            /* 11010101 00000011 0100.... 11011111 */
                            /* ../git/target/arm/tcg/a64.decode:208 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_DAIFSET(ctx, &u.f_i)) return true;
                            break;
                        case 0x7:
                            /* 11010101 00000011 0100.... 11111111 */
                            /* ../git/target/arm/tcg/a64.decode:209 */
                            disas_a64_extract_msr_i(ctx, &u.f_i, insn);
                            if (trans_MSR_i_DAIFCLEAR(ctx, &u.f_i)) return true;
                            break;
                        }
                        break;
                    }
                    break;
                case 0x00080000:
                    /* 11010101 00.01... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:216 */
                    disas_a64_extract_disas_a64_Fmt_24(ctx, &u.f_disas_a6418, insn);
                    if (trans_SYS(ctx, &u.f_disas_a6418)) return true;
                    break;
                case 0x00100000:
                    /* 11010101 00.10... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:217 */
                    disas_a64_extract_disas_a64_Fmt_25(ctx, &u.f_disas_a6418, insn);
                    if (trans_SYS(ctx, &u.f_disas_a6418)) return true;
                    break;
                case 0x00180000:
                    /* 11010101 00.11... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:218 */
                    disas_a64_extract_disas_a64_Fmt_26(ctx, &u.f_disas_a6418, insn);
                    if (trans_SYS(ctx, &u.f_disas_a6418)) return true;
                    break;
                }
                break;
            case 0x82000000u:
                /* 11010110 ........ ........ ........ */
                switch (insn & 0x00fff81f) {
                case 0x001f0000:
                    /* 11010110 00011111 00000... ...00000 */
                    disas_a64_extract_disas_a64_Fmt_16(ctx, &u.f_r, insn);
                    switch ((insn >> 10) & 0x1) {
                    case 0x0:
                        /* 11010110 00011111 000000.. ...00000 */
                        /* ../git/target/arm/tcg/a64.decode:132 */
                        if (trans_BR(ctx, &u.f_r)) return true;
                        break;
                    }
                    break;
                case 0x001f081f:
                    /* 11010110 00011111 00001... ...11111 */
                    /* ../git/target/arm/tcg/a64.decode:137 */
                    disas_a64_extract_disas_a64_Fmt_17(ctx, &u.f_braz, insn);
                    if (trans_BRAZ(ctx, &u.f_braz)) return true;
                    break;
                case 0x003f0000:
                    /* 11010110 00111111 00000... ...00000 */
                    disas_a64_extract_disas_a64_Fmt_16(ctx, &u.f_r, insn);
                    switch ((insn >> 10) & 0x1) {
                    case 0x0:
                        /* 11010110 00111111 000000.. ...00000 */
                        /* ../git/target/arm/tcg/a64.decode:133 */
                        if (trans_BLR(ctx, &u.f_r)) return true;
                        break;
                    }
                    break;
                case 0x003f081f:
                    /* 11010110 00111111 00001... ...11111 */
                    /* ../git/target/arm/tcg/a64.decode:138 */
                    disas_a64_extract_disas_a64_Fmt_17(ctx, &u.f_braz, insn);
                    if (trans_BLRAZ(ctx, &u.f_braz)) return true;
                    break;
                case 0x005f0000:
                    /* 11010110 01011111 00000... ...00000 */
                    disas_a64_extract_disas_a64_Fmt_16(ctx, &u.f_r, insn);
                    switch ((insn >> 10) & 0x1) {
                    case 0x0:
                        /* 11010110 01011111 000000.. ...00000 */
                        /* ../git/target/arm/tcg/a64.decode:134 */
                        if (trans_RET(ctx, &u.f_r)) return true;
                        break;
                    }
                    break;
                case 0x005f081f:
                    /* 11010110 01011111 00001... ...11111 */
                    disas_a64_extract_disas_a64_Fmt_18(ctx, &u.f_reta, insn);
                    switch ((insn >> 5) & 0x1f) {
                    case 0x1f:
                        /* 11010110 01011111 00001.11 11111111 */
                        /* ../git/target/arm/tcg/a64.decode:141 */
                        if (trans_RETA(ctx, &u.f_reta)) return true;
                        break;
                    }
                    break;
                case 0x009f0000:
                    /* 11010110 10011111 00000... ...00000 */
                    disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                    switch ((insn >> 5) & 0x3f) {
                    case 0x1f:
                        /* 11010110 10011111 00000011 11100000 */
                        /* ../git/target/arm/tcg/a64.decode:147 */
                        if (trans_ERET(ctx, &u.f_disas_a6415)) return true;
                        break;
                    }
                    break;
                case 0x009f081f:
                    /* 11010110 10011111 00001... ...11111 */
                    disas_a64_extract_disas_a64_Fmt_18(ctx, &u.f_reta, insn);
                    switch ((insn >> 5) & 0x1f) {
                    case 0x1f:
                        /* 11010110 10011111 00001.11 11111111 */
                        /* ../git/target/arm/tcg/a64.decode:148 */
                        if (trans_ERETA(ctx, &u.f_reta)) return true;
                        break;
                    }
                    break;
                }
                break;
            case 0x83000000u:
                /* 11010111 ........ ........ ........ */
                disas_a64_extract_disas_a64_Fmt_19(ctx, &u.f_bra, insn);
                switch ((insn >> 11) & 0x1fff) {
                case 0x3e1:
                    /* 11010111 00011111 00001... ........ */
                    /* ../git/target/arm/tcg/a64.decode:144 */
                    if (trans_BRA(ctx, &u.f_bra)) return true;
                    break;
                case 0x7e1:
                    /* 11010111 00111111 00001... ........ */
                    /* ../git/target/arm/tcg/a64.decode:145 */
                    if (trans_BLRA(ctx, &u.f_bra)) return true;
                    break;
                }
                break;
            }
            break;
        }
        break;
    case 0x6:
        /* ...110.. ........ ........ ........ */
        switch (insn & 0x23000000) {
        case 0x00000000:
            /* ..011000 ........ ........ ........ */
            switch ((insn >> 30) & 0x3) {
            case 0x0:
                /* 00011000 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:260 */
                disas_a64_extract_ldlit(ctx, &u.f_ldlit, insn);
                u.f_ldlit.sign = 0;
                u.f_ldlit.sz = 2;
                if (trans_LD_lit(ctx, &u.f_ldlit)) return true;
                break;
            case 0x1:
                /* 01011000 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:261 */
                disas_a64_extract_ldlit(ctx, &u.f_ldlit, insn);
                u.f_ldlit.sign = 0;
                u.f_ldlit.sz = 3;
                if (trans_LD_lit(ctx, &u.f_ldlit)) return true;
                break;
            case 0x2:
                /* 10011000 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:262 */
                disas_a64_extract_ldlit(ctx, &u.f_ldlit, insn);
                u.f_ldlit.sign = 1;
                u.f_ldlit.sz = 2;
                if (trans_LD_lit(ctx, &u.f_ldlit)) return true;
                break;
            case 0x3:
                /* 11011000 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:268 */
                disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                if (trans_NOP(ctx, &u.f_disas_a6415)) return true;
                break;
            }
            break;
        case 0x01000000:
            /* ..011001 ........ ........ ........ */
            switch (insn & 0x00e00c00) {
            case 0x00000000:
                /* ..011001 000..... ....00.. ........ */
                /* ../git/target/arm/tcg/a64.decode:471 */
                disas_a64_extract_ldapr_stlr_i(ctx, &u.f_ldapr_stlr_i, insn);
                u.f_ldapr_stlr_i.ext = 0;
                u.f_ldapr_stlr_i.sign = 0;
                u.f_ldapr_stlr_i.sz = extract32(insn, 30, 2);
                if (trans_STLR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                break;
            case 0x00000400:
                /* ..011001 000..... ....01.. ........ */
                disas_a64_extract_cpy(ctx, &u.f_cpy, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00011001 000..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:586 */
                    if (trans_CPYFP(ctx, &u.f_cpy)) return true;
                    break;
                }
                break;
            case 0x00200000:
                /* ..011001 001..... ....00.. ........ */
                disas_a64_extract_ldst_tag_mult(ctx, &u.f_ldst_tag, insn);
                switch (insn & 0xc01ff000u) {
                case 0xc0000000u:
                    /* 11011001 00100000 000000.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:538 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_STZGM(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00200400:
                /* ..011001 001..... ....01.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 001..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:539 */
                    u.f_ldst_tag.p = 1;
                    u.f_ldst_tag.w = 1;
                    if (trans_STG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00200800:
                /* ..011001 001..... ....10.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 001..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:540 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_STG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00200c00:
                /* ..011001 001..... ....11.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 001..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:541 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 1;
                    if (trans_STG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00400000:
                /* ..011001 010..... ....00.. ........ */
                /* ../git/target/arm/tcg/a64.decode:472 */
                disas_a64_extract_ldapr_stlr_i(ctx, &u.f_ldapr_stlr_i, insn);
                u.f_ldapr_stlr_i.ext = 0;
                u.f_ldapr_stlr_i.sign = 0;
                u.f_ldapr_stlr_i.sz = extract32(insn, 30, 2);
                if (trans_LDAPR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                break;
            case 0x00400400:
                /* ..011001 010..... ....01.. ........ */
                disas_a64_extract_cpy(ctx, &u.f_cpy, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00011001 010..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:587 */
                    if (trans_CPYFM(ctx, &u.f_cpy)) return true;
                    break;
                }
                break;
            case 0x00600000:
                /* ..011001 011..... ....00.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 011..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:543 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_LDG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00600400:
                /* ..011001 011..... ....01.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 011..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:544 */
                    u.f_ldst_tag.p = 1;
                    u.f_ldst_tag.w = 1;
                    if (trans_STZG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00600800:
                /* ..011001 011..... ....10.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 011..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:545 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_STZG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00600c00:
                /* ..011001 011..... ....11.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 011..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:546 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 1;
                    if (trans_STZG(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00800000:
                /* ..011001 100..... ....00.. ........ */
                disas_a64_extract_ldapr_stlr_i(ctx, &u.f_ldapr_stlr_i, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00011001 100..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:473 */
                    u.f_ldapr_stlr_i.sign = 1;
                    u.f_ldapr_stlr_i.sz = 0;
                    u.f_ldapr_stlr_i.ext = 0;
                    if (trans_LDAPR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                    break;
                case 0x1:
                    /* 01011001 100..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:474 */
                    u.f_ldapr_stlr_i.sign = 1;
                    u.f_ldapr_stlr_i.sz = 1;
                    u.f_ldapr_stlr_i.ext = 0;
                    if (trans_LDAPR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                    break;
                case 0x2:
                    /* 10011001 100..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:475 */
                    u.f_ldapr_stlr_i.sign = 1;
                    u.f_ldapr_stlr_i.sz = 2;
                    u.f_ldapr_stlr_i.ext = 0;
                    if (trans_LDAPR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                    break;
                }
                break;
            case 0x00800400:
                /* ..011001 100..... ....01.. ........ */
                disas_a64_extract_cpy(ctx, &u.f_cpy, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00011001 100..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:588 */
                    if (trans_CPYFE(ctx, &u.f_cpy)) return true;
                    break;
                }
                break;
            case 0x00a00000:
                /* ..011001 101..... ....00.. ........ */
                disas_a64_extract_ldst_tag_mult(ctx, &u.f_ldst_tag, insn);
                switch (insn & 0xc01ff000u) {
                case 0xc0000000u:
                    /* 11011001 10100000 000000.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:548 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_STGM(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00a00400:
                /* ..011001 101..... ....01.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 101..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:549 */
                    u.f_ldst_tag.p = 1;
                    u.f_ldst_tag.w = 1;
                    if (trans_ST2G(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00a00800:
                /* ..011001 101..... ....10.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 101..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:550 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_ST2G(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00a00c00:
                /* ..011001 101..... ....11.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 101..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:551 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 1;
                    if (trans_ST2G(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00c00000:
                /* ..011001 110..... ....00.. ........ */
                disas_a64_extract_ldapr_stlr_i(ctx, &u.f_ldapr_stlr_i, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00011001 110..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:476 */
                    u.f_ldapr_stlr_i.sign = 1;
                    u.f_ldapr_stlr_i.sz = 0;
                    u.f_ldapr_stlr_i.ext = 1;
                    if (trans_LDAPR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                    break;
                case 0x1:
                    /* 01011001 110..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:477 */
                    u.f_ldapr_stlr_i.sign = 1;
                    u.f_ldapr_stlr_i.sz = 1;
                    u.f_ldapr_stlr_i.ext = 1;
                    if (trans_LDAPR_i(ctx, &u.f_ldapr_stlr_i)) return true;
                    break;
                }
                break;
            case 0x00c00400:
                /* ..011001 110..... ....01.. ........ */
                disas_a64_extract_set(ctx, &u.f_set, insn);
                switch (insn & 0xc000c000u) {
                case 0x00000000:
                    /* 00011001 110..... 00..01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:570 */
                    if (trans_SETP(ctx, &u.f_set)) return true;
                    break;
                case 0x00004000:
                    /* 00011001 110..... 01..01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:571 */
                    if (trans_SETM(ctx, &u.f_set)) return true;
                    break;
                case 0x00008000:
                    /* 00011001 110..... 10..01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:572 */
                    if (trans_SETE(ctx, &u.f_set)) return true;
                    break;
                }
                break;
            case 0x00e00000:
                /* ..011001 111..... ....00.. ........ */
                disas_a64_extract_ldst_tag_mult(ctx, &u.f_ldst_tag, insn);
                switch (insn & 0xc01ff000u) {
                case 0xc0000000u:
                    /* 11011001 11100000 000000.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:553 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_LDGM(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00e00400:
                /* ..011001 111..... ....01.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 111..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:554 */
                    u.f_ldst_tag.p = 1;
                    u.f_ldst_tag.w = 1;
                    if (trans_STZ2G(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00e00800:
                /* ..011001 111..... ....10.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 111..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:555 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 0;
                    if (trans_STZ2G(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            case 0x00e00c00:
                /* ..011001 111..... ....11.. ........ */
                disas_a64_extract_ldst_tag(ctx, &u.f_ldst_tag, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11011001 111..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:556 */
                    u.f_ldst_tag.p = 0;
                    u.f_ldst_tag.w = 1;
                    if (trans_STZ2G(ctx, &u.f_ldst_tag)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x20000000:
            /* ..111000 ........ ........ ........ */
            switch (insn & 0x00200400) {
            case 0x00000000:
                /* ..111000 ..0..... .....0.. ........ */
                switch (insn & 0x00c00800) {
                case 0x00000000:
                    /* ..111000 000..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:338 */
                    disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                    u.f_ldst_imm.ext = 0;
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = extract32(insn, 30, 2);
                    if (trans_STR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x00000800:
                    /* ..111000 000..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:360 */
                    disas_a64_extract_ldst_imm_user(ctx, &u.f_ldst_imm, insn);
                    u.f_ldst_imm.ext = 0;
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = extract32(insn, 30, 2);
                    if (trans_STR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x00400000:
                    /* ..111000 010..... ....00.. ........ */
                    disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 010..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:339 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 010..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:340 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 010..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:341 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x3:
                        /* 11111000 010..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:342 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 3;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00400800:
                    /* ..111000 010..... ....10.. ........ */
                    disas_a64_extract_ldst_imm_user(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 010..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:361 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 010..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:362 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 010..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:363 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x3:
                        /* 11111000 010..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:364 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 3;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00800000:
                    /* ..111000 100..... ....00.. ........ */
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 100..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:343 */
                        disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 100..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:344 */
                        disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 100..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:345 */
                        disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x3:
                        /* 11111000 100..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:383 */
                        disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                        if (trans_NOP(ctx, &u.f_disas_a6415)) return true;
                        break;
                    }
                    break;
                case 0x00800800:
                    /* ..111000 100..... ....10.. ........ */
                    disas_a64_extract_ldst_imm_user(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 100..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:365 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 100..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:366 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 100..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:367 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00c00000:
                    /* ..111000 110..... ....00.. ........ */
                    disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 110..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:346 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 110..... ....00.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:347 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00c00800:
                    /* ..111000 110..... ....10.. ........ */
                    disas_a64_extract_ldst_imm_user(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 110..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:368 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 110..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:369 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                }
                break;
            case 0x00000400:
                /* ..111000 ..0..... .....1.. ........ */
                switch (insn & 0x00c00800) {
                case 0x00000000:
                    /* ..111000 000..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:349 */
                    disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                    u.f_ldst_imm.ext = 0;
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = extract32(insn, 30, 2);
                    if (trans_STR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x00000800:
                    /* ..111000 000..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:371 */
                    disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                    u.f_ldst_imm.ext = 0;
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = extract32(insn, 30, 2);
                    if (trans_STR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x00400000:
                    /* ..111000 010..... ....01.. ........ */
                    disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 010..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:350 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 010..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:351 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 010..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:352 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x3:
                        /* 11111000 010..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:353 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 3;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00400800:
                    /* ..111000 010..... ....11.. ........ */
                    disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 010..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:372 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 010..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:373 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 010..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:374 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x3:
                        /* 11111000 010..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:375 */
                        u.f_ldst_imm.sign = 0;
                        u.f_ldst_imm.sz = 3;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00800000:
                    /* ..111000 100..... ....01.. ........ */
                    disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 100..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:354 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 100..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:355 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 100..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:356 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00800800:
                    /* ..111000 100..... ....11.. ........ */
                    disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 100..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:376 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 100..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:377 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x2:
                        /* 10111000 100..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:378 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 2;
                        u.f_ldst_imm.ext = 0;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00c00000:
                    /* ..111000 110..... ....01.. ........ */
                    disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 110..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:357 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 110..... ....01.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:358 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                case 0x00c00800:
                    /* ..111000 110..... ....11.. ........ */
                    disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                    switch ((insn >> 30) & 0x3) {
                    case 0x0:
                        /* 00111000 110..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:379 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 0;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    case 0x1:
                        /* 01111000 110..... ....11.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:380 */
                        u.f_ldst_imm.sign = 1;
                        u.f_ldst_imm.sz = 1;
                        u.f_ldst_imm.ext = 1;
                        if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                        break;
                    }
                    break;
                }
                break;
            case 0x00200000:
                /* ..111000 ..1..... .....0.. ........ */
                switch ((insn >> 11) & 0x1) {
                case 0x0:
                    /* ..111000 ..1..... ....00.. ........ */
                    switch ((insn >> 12) & 0xf) {
                    case 0x0:
                        /* ..111000 ..1..... 000000.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:450 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDADD(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x1:
                        /* ..111000 ..1..... 000100.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:451 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDCLR(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x2:
                        /* ..111000 ..1..... 001000.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:452 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDEOR(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x3:
                        /* ..111000 ..1..... 001100.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:453 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDSET(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x4:
                        /* ..111000 ..1..... 010000.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:454 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDSMAX(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x5:
                        /* ..111000 ..1..... 010100.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:455 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDSMIN(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x6:
                        /* ..111000 ..1..... 011000.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:456 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDUMAX(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x7:
                        /* ..111000 ..1..... 011100.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:457 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_LDUMIN(ctx, &u.f_atomic)) return true;
                        break;
                    case 0x8:
                        /* ..111000 ..1..... 100000.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:458 */
                        disas_a64_extract_atomic(ctx, &u.f_atomic, insn);
                        if (trans_SWP(ctx, &u.f_atomic)) return true;
                        break;
                    case 0xc:
                        /* ..111000 ..1..... 110000.. ........ */
                        disas_a64_extract_disas_a64_Fmt_42(ctx, &u.f_disas_a6427, insn);
                        switch (insn & 0x00df0000) {
                        case 0x009f0000:
                            /* ..111000 10111111 110000.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:460 */
                            if (trans_LDAPR(ctx, &u.f_disas_a6427)) return true;
                            break;
                        }
                        break;
                    }
                    break;
                case 0x1:
                    /* ..111000 ..1..... ....10.. ........ */
                    switch ((insn >> 22) & 0x3) {
                    case 0x0:
                        /* ..111000 001..... ....10.. ........ */
                        /* ../git/target/arm/tcg/a64.decode:428 */
                        disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                        u.f_ldst.ext = 0;
                        u.f_ldst.sign = 0;
                        u.f_ldst.sz = extract32(insn, 30, 2);
                        if (trans_STR(ctx, &u.f_ldst)) return true;
                        break;
                    case 0x1:
                        /* ..111000 011..... ....10.. ........ */
                        disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                        switch ((insn >> 30) & 0x3) {
                        case 0x0:
                            /* 00111000 011..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:429 */
                            u.f_ldst.sign = 0;
                            u.f_ldst.sz = 0;
                            u.f_ldst.ext = 1;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x1:
                            /* 01111000 011..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:430 */
                            u.f_ldst.sign = 0;
                            u.f_ldst.sz = 1;
                            u.f_ldst.ext = 1;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x2:
                            /* 10111000 011..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:431 */
                            u.f_ldst.sign = 0;
                            u.f_ldst.sz = 2;
                            u.f_ldst.ext = 1;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x3:
                            /* 11111000 011..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:432 */
                            u.f_ldst.sign = 0;
                            u.f_ldst.sz = 3;
                            u.f_ldst.ext = 0;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        }
                        break;
                    case 0x2:
                        /* ..111000 101..... ....10.. ........ */
                        switch ((insn >> 30) & 0x3) {
                        case 0x0:
                            /* 00111000 101..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:433 */
                            disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                            u.f_ldst.sign = 1;
                            u.f_ldst.sz = 0;
                            u.f_ldst.ext = 0;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x1:
                            /* 01111000 101..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:434 */
                            disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                            u.f_ldst.sign = 1;
                            u.f_ldst.sz = 1;
                            u.f_ldst.ext = 0;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x2:
                            /* 10111000 101..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:435 */
                            disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                            u.f_ldst.sign = 1;
                            u.f_ldst.sz = 2;
                            u.f_ldst.ext = 0;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x3:
                            /* 11111000 101..... ....10.. ........ */
                            disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                            switch ((insn >> 14) & 0x1) {
                            case 0x1:
                                /* 11111000 101..... .1..10.. ........ */
                                /* ../git/target/arm/tcg/a64.decode:440 */
                                if (trans_NOP(ctx, &u.f_disas_a6415)) return true;
                                break;
                            }
                            break;
                        }
                        break;
                    case 0x3:
                        /* ..111000 111..... ....10.. ........ */
                        disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                        switch ((insn >> 30) & 0x3) {
                        case 0x0:
                            /* 00111000 111..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:436 */
                            u.f_ldst.sign = 1;
                            u.f_ldst.sz = 0;
                            u.f_ldst.ext = 1;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        case 0x1:
                            /* 01111000 111..... ....10.. ........ */
                            /* ../git/target/arm/tcg/a64.decode:437 */
                            u.f_ldst.sign = 1;
                            u.f_ldst.sz = 1;
                            u.f_ldst.ext = 1;
                            if (trans_LDR(ctx, &u.f_ldst)) return true;
                            break;
                        }
                        break;
                    }
                    break;
                }
                break;
            case 0x00200400:
                /* ..111000 ..1..... .....1.. ........ */
                disas_a64_extract_disas_a64_Fmt_43(ctx, &u.f_disas_a6428, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x3:
                    /* 11111000 ..1..... .....1.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:467 */
                    if (trans_LDRA(ctx, &u.f_disas_a6428)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x21000000:
            /* ..111001 ........ ........ ........ */
            switch ((insn >> 22) & 0x3) {
            case 0x0:
                /* ..111001 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:406 */
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                if (trans_STR_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x1:
                /* ..111001 01...... ........ ........ */
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111001 01...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:407 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 0;
                    u.f_ldst_imm.ext = 1;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x1:
                    /* 01111001 01...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:408 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 1;
                    u.f_ldst_imm.ext = 1;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x2:
                    /* 10111001 01...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:409 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 2;
                    u.f_ldst_imm.ext = 1;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x3:
                    /* 11111001 01...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:410 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 3;
                    u.f_ldst_imm.ext = 0;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x2:
                /* ..111001 10...... ........ ........ */
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111001 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:411 */
                    u.f_ldst_imm.sign = 1;
                    u.f_ldst_imm.sz = 0;
                    u.f_ldst_imm.ext = 0;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x1:
                    /* 01111001 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:412 */
                    u.f_ldst_imm.sign = 1;
                    u.f_ldst_imm.sz = 1;
                    u.f_ldst_imm.ext = 0;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x2:
                    /* 10111001 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:413 */
                    u.f_ldst_imm.sign = 1;
                    u.f_ldst_imm.sz = 2;
                    u.f_ldst_imm.ext = 0;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x3:
                    /* 11111001 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:418 */
                    disas_a64_extract_disas_a64_Fmt_20(ctx, &u.f_disas_a6415, insn);
                    if (trans_NOP(ctx, &u.f_disas_a6415)) return true;
                    break;
                }
                break;
            case 0x3:
                /* ..111001 11...... ........ ........ */
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111001 11...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:414 */
                    u.f_ldst_imm.sign = 1;
                    u.f_ldst_imm.sz = 0;
                    u.f_ldst_imm.ext = 1;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                case 0x1:
                    /* 01111001 11...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:415 */
                    u.f_ldst_imm.sign = 1;
                    u.f_ldst_imm.sz = 1;
                    u.f_ldst_imm.ext = 1;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            }
            break;
        }
        break;
    case 0x7:
        /* ...111.. ........ ........ ........ */
        switch (insn & 0x23000000) {
        case 0x00000000:
            /* ..011100 ........ ........ ........ */
            disas_a64_extract_ldlit(ctx, &u.f_ldlit, insn);
            switch ((insn >> 30) & 0x3) {
            case 0x0:
                /* 00011100 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:263 */
                u.f_ldlit.sign = 0;
                u.f_ldlit.sz = 2;
                if (trans_LD_lit_v(ctx, &u.f_ldlit)) return true;
                break;
            case 0x1:
                /* 01011100 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:264 */
                u.f_ldlit.sign = 0;
                u.f_ldlit.sz = 3;
                if (trans_LD_lit_v(ctx, &u.f_ldlit)) return true;
                break;
            case 0x2:
                /* 10011100 ........ ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:265 */
                u.f_ldlit.sign = 0;
                u.f_ldlit.sz = 4;
                if (trans_LD_lit_v(ctx, &u.f_ldlit)) return true;
                break;
            }
            break;
        case 0x01000000:
            /* ..011101 ........ ........ ........ */
            switch (insn & 0xc0e00c00u) {
            case 0x00000400:
                /* 00011101 000..... ....01.. ........ */
                /* ../git/target/arm/tcg/a64.decode:589 */
                disas_a64_extract_cpy(ctx, &u.f_cpy, insn);
                if (trans_CPYP(ctx, &u.f_cpy)) return true;
                break;
            case 0x00400400:
                /* 00011101 010..... ....01.. ........ */
                /* ../git/target/arm/tcg/a64.decode:590 */
                disas_a64_extract_cpy(ctx, &u.f_cpy, insn);
                if (trans_CPYM(ctx, &u.f_cpy)) return true;
                break;
            case 0x00800400:
                /* 00011101 100..... ....01.. ........ */
                /* ../git/target/arm/tcg/a64.decode:591 */
                disas_a64_extract_cpy(ctx, &u.f_cpy, insn);
                if (trans_CPYE(ctx, &u.f_cpy)) return true;
                break;
            case 0x00c00400:
                /* 00011101 110..... ....01.. ........ */
                disas_a64_extract_set(ctx, &u.f_set, insn);
                switch ((insn >> 14) & 0x3) {
                case 0x0:
                    /* 00011101 110..... 00..01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:575 */
                    if (trans_SETGP(ctx, &u.f_set)) return true;
                    break;
                case 0x1:
                    /* 00011101 110..... 01..01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:576 */
                    if (trans_SETGM(ctx, &u.f_set)) return true;
                    break;
                case 0x2:
                    /* 00011101 110..... 10..01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:577 */
                    if (trans_SETGE(ctx, &u.f_set)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x20000000:
            /* ..111100 ........ ........ ........ */
            switch (insn & 0x00e00c00) {
            case 0x00000000:
                /* ..111100 000..... ....00.. ........ */
                /* ../git/target/arm/tcg/a64.decode:385 */
                disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x00000400:
                /* ..111100 000..... ....01.. ........ */
                /* ../git/target/arm/tcg/a64.decode:390 */
                disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x00000c00:
                /* ..111100 000..... ....11.. ........ */
                /* ../git/target/arm/tcg/a64.decode:395 */
                disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x00200800:
                /* ..111100 001..... ....10.. ........ */
                /* ../git/target/arm/tcg/a64.decode:442 */
                disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                u.f_ldst.ext = 0;
                u.f_ldst.sign = 0;
                u.f_ldst.sz = extract32(insn, 30, 2);
                if (trans_STR_v(ctx, &u.f_ldst)) return true;
                break;
            case 0x00400000:
                /* ..111100 010..... ....00.. ........ */
                /* ../git/target/arm/tcg/a64.decode:387 */
                disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x00400400:
                /* ..111100 010..... ....01.. ........ */
                /* ../git/target/arm/tcg/a64.decode:392 */
                disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x00400c00:
                /* ..111100 010..... ....11.. ........ */
                /* ../git/target/arm/tcg/a64.decode:397 */
                disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x00600800:
                /* ..111100 011..... ....10.. ........ */
                /* ../git/target/arm/tcg/a64.decode:444 */
                disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                u.f_ldst.ext = 0;
                u.f_ldst.sign = 0;
                u.f_ldst.sz = extract32(insn, 30, 2);
                if (trans_LDR_v(ctx, &u.f_ldst)) return true;
                break;
            case 0x00800000:
                /* ..111100 100..... ....00.. ........ */
                disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 100..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:386 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x00800400:
                /* ..111100 100..... ....01.. ........ */
                disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 100..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:391 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x00800c00:
                /* ..111100 100..... ....11.. ........ */
                disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 100..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:396 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x00a00800:
                /* ..111100 101..... ....10.. ........ */
                disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 101..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:443 */
                    u.f_ldst.sign = 0;
                    u.f_ldst.sz = 4;
                    u.f_ldst.ext = 0;
                    if (trans_STR_v(ctx, &u.f_ldst)) return true;
                    break;
                }
                break;
            case 0x00c00000:
                /* ..111100 110..... ....00.. ........ */
                disas_a64_extract_ldst_imm(ctx, &u.f_ldst_imm, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 110..... ....00.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:388 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x00c00400:
                /* ..111100 110..... ....01.. ........ */
                disas_a64_extract_ldst_imm_post(ctx, &u.f_ldst_imm, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 110..... ....01.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:393 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x00c00c00:
                /* ..111100 110..... ....11.. ........ */
                disas_a64_extract_ldst_imm_pre(ctx, &u.f_ldst_imm, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 110..... ....11.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:398 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x00e00800:
                /* ..111100 111..... ....10.. ........ */
                disas_a64_extract_ldst(ctx, &u.f_ldst, insn);
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111100 111..... ....10.. ........ */
                    /* ../git/target/arm/tcg/a64.decode:445 */
                    u.f_ldst.sign = 0;
                    u.f_ldst.sz = 4;
                    u.f_ldst.ext = 0;
                    if (trans_LDR_v(ctx, &u.f_ldst)) return true;
                    break;
                }
                break;
            }
            break;
        case 0x21000000:
            /* ..111101 ........ ........ ........ */
            switch ((insn >> 22) & 0x3) {
            case 0x0:
                /* ..111101 00...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:420 */
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x1:
                /* ..111101 01...... ........ ........ */
                /* ../git/target/arm/tcg/a64.decode:422 */
                u.f_ldst_imm.ext = 0;
                u.f_ldst_imm.sign = 0;
                u.f_ldst_imm.sz = extract32(insn, 30, 2);
                disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                break;
            case 0x2:
                /* ..111101 10...... ........ ........ */
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111101 10...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:421 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_STR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            case 0x3:
                /* ..111101 11...... ........ ........ */
                switch ((insn >> 30) & 0x3) {
                case 0x0:
                    /* 00111101 11...... ........ ........ */
                    /* ../git/target/arm/tcg/a64.decode:423 */
                    u.f_ldst_imm.sign = 0;
                    u.f_ldst_imm.sz = 4;
                    u.f_ldst_imm.ext = 0;
                    disas_a64_extract_ldst_uimm(ctx, &u.f_ldst_imm, insn);
                    if (trans_LDR_v_i(ctx, &u.f_ldst_imm)) return true;
                    break;
                }
                break;
            }
            break;
        }
        break;
    }
    return false;
}
