/*
 * QEMU model of the UFS_REG UFS EXTERNAL CSR REG
 *
 * Copyright (c) 2023 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2023-08-16.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_UFS_REG_ERR_DEBUG
#define XILINX_UFS_REG_ERR_DEBUG 0
#endif

#define TYPE_XILINX_UFS_REG "dwc.ufs_reg"

#define XILINX_UFS_REG(obj) \
     OBJECT_CHECK(UFS_REG, (obj), TYPE_XILINX_UFS_REG)

REG32(LA_GPO_0, 0x0)
REG32(LA_GPO_1, 0x4)
REG32(LA_GPO_2, 0x8)
REG32(LA_GPI_0, 0xc)
REG32(LA_GPI_1, 0x10)
REG32(LA_GPI_2, 0x14)
REG32(MONITOR_0, 0x18)
REG32(MONITOR_1, 0x1c)
REG32(MONITOR_2, 0x20)
    FIELD(MONITOR_2, MOINTOR, 0, 10)
REG32(MONITOR_UP_0, 0x24)
REG32(MONITOR_UP_1, 0x28)
REG32(MONITOR_UP_2, 0x2c)
    FIELD(MONITOR_UP_2, MOINTOR, 0, 16)
REG32(TX_MK2EXTENSIONEN, 0x30)
    FIELD(TX_MK2EXTENSIONEN, TX_MK2EXTENSIONEN, 0, 1)
REG32(TST_RTCONTROL, 0x40)
    FIELD(TST_RTCONTROL, RX_TST_RTCONTROL_1, 24, 8)
    FIELD(TST_RTCONTROL, RX_TST_RTCONTROL_0, 16, 8)
    FIELD(TST_RTCONTROL, TX_TST_RTCONTROL_1, 8, 8)
    FIELD(TST_RTCONTROL, TX_TST_RTCONTROL_0, 0, 8)
REG32(CLOCK_SEL, 0x44)
    FIELD(CLOCK_SEL, REF_CLOCK_SEL, 6, 2)
    FIELD(CLOCK_SEL, CFG_CLOCK_SEL, 0, 6)
REG32(TEST_ENABLE, 0x48)
    FIELD(TEST_ENABLE, TEST_TX_REF_CLK_EN, 2, 1)
    FIELD(TEST_ENABLE, TEST_STOP_CLK_EN, 1, 1)
    FIELD(TEST_ENABLE, TEST_POWERDOWN, 0, 1)
REG32(SRAM_CSR, 0x4c)
    FIELD(SRAM_CSR, FW_SRAM_EN, 3, 1)
    FIELD(SRAM_CSR, SRAM_BYPASS, 2, 1)
    FIELD(SRAM_CSR, SRAM_EXT_LD_DONE, 1, 1)
    FIELD(SRAM_CSR, SRAM_INIT_DONE, 0, 1)
REG32(PHY_RESET, 0x50)
    FIELD(PHY_RESET, PHY_RESET, 0, 1)
REG32(TX_RX_CONFIG_RDY_SIGNAL_MON, 0x54)
    FIELD(TX_RX_CONFIG_RDY_SIGNAL_MON, TX_CFGRDYN_0, 0, 1)
    FIELD(TX_RX_CONFIG_RDY_SIGNAL_MON, TX_CFGRDYN_1, 1, 1)
    FIELD(TX_RX_CONFIG_RDY_SIGNAL_MON, RX_CFGRDYN_0, 2, 1)
    FIELD(TX_RX_CONFIG_RDY_SIGNAL_MON, RX_CFGRDYN_1, 3, 1)


#define UFS_REG_R_MAX (R_TX_RX_CONFIG_RDY_SIGNAL_MON + 1)

typedef struct UFS_REG {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    bool dev_rst;
    uint32_t regs[UFS_REG_R_MAX];
    RegisterInfo regs_info[UFS_REG_R_MAX];
} UFS_REG;

static void ufs_phy_rst_postw(RegisterInfo *reg, uint64_t val)
{
    UFS_REG *s = XILINX_UFS_REG(reg->opaque);
    uint32_t csr = s->regs[R_SRAM_CSR];
    bool level = !!val;

    if (s->dev_rst == 1 && level == 0)  {
        if (csr & R_SRAM_CSR_SRAM_BYPASS_MASK) {
            if (!(csr & R_SRAM_CSR_SRAM_INIT_DONE_MASK)) {
                ARRAY_FIELD_DP32(s->regs, SRAM_CSR, SRAM_INIT_DONE, 1);
            } else {
                qemu_log_mask(LOG_UNIMP,
                              "UFS External ROM load not-supported");
            }
        } else {
            qemu_log_mask(LOG_UNIMP,
                         "Override of SRAM not supported");
        }
    }
    s->dev_rst = level;
}

static const RegisterAccessInfo ufs_reg_regs_info[] = {
    {   .name = "LA_GPO_0",  .addr = A_LA_GPO_0,
        .ro = 0xffffffff,
    },{ .name = "LA_GPO_1",  .addr = A_LA_GPO_1,
        .ro = 0xffffffff,
    },{ .name = "LA_GPO_2",  .addr = A_LA_GPO_2,
        .ro = 0xffffffff,
    },{ .name = "LA_GPI_0",  .addr = A_LA_GPI_0,
    },{ .name = "LA_GPI_1",  .addr = A_LA_GPI_1,
    },{ .name = "LA_GPI_2",  .addr = A_LA_GPI_2,
    },{ .name = "MONITOR_0",  .addr = A_MONITOR_0,
        .ro = 0xffffffff,
    },{ .name = "MONITOR_1",  .addr = A_MONITOR_1,
        .ro = 0xffffffff,
    },{ .name = "MONITOR_2",  .addr = A_MONITOR_2,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "MONITOR_UP_0",  .addr = A_MONITOR_UP_0,
        .ro = 0xffffffff,
    },{ .name = "MONITOR_UP_1",  .addr = A_MONITOR_UP_1,
        .ro = 0xffffffff,
    },{ .name = "MONITOR_UP_2",  .addr = A_MONITOR_UP_2,
        .rsvd = 0xffff0000,
        .ro = 0xffffffff,
    },{ .name = "TX_MK2EXTENSIONEN",  .addr = A_TX_MK2EXTENSIONEN,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TST_RTCONTROL",  .addr = A_TST_RTCONTROL,
    },{ .name = "CLOCK_SEL",  .addr = A_CLOCK_SEL,
        .reset = 0x5a,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "TEST_ENABLE",  .addr = A_TEST_ENABLE,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
    },{ .name = "SRAM_CSR",  .addr = A_SRAM_CSR,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff1,
    },{ .name = "PHY_RESET", .addr = A_PHY_RESET,
        .rsvd = 0xfffffffe,
        .reset = 0x1,
        .post_write = ufs_phy_rst_postw,
    },{ .name = "TX_RX_CONFIG_RDY_SIGNAL_MON",
        .addr = A_TX_RX_CONFIG_RDY_SIGNAL_MON,
        .rsvd = 0xfffffff0,
        .reset = 0x0,
   }
};

static void ufs_reg_reset_enter(Object *obj, ResetType type)
{
    UFS_REG *s = XILINX_UFS_REG(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
    s->dev_rst = 1;
}

static const MemoryRegionOps ufs_reg_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void ufs_reg_init(Object *obj)
{
    UFS_REG *s = XILINX_UFS_REG(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_UFS_REG, UFS_REG_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), ufs_reg_regs_info,
                              ARRAY_SIZE(ufs_reg_regs_info),
                              s->regs_info, s->regs,
                              &ufs_reg_ops,
                              XILINX_UFS_REG_ERR_DEBUG,
                              UFS_REG_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_ufs_reg = {
    .name = TYPE_XILINX_UFS_REG,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, UFS_REG, UFS_REG_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void ufs_reg_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_ufs_reg;
    rc->phases.enter = ufs_reg_reset_enter;
}

static const TypeInfo ufs_reg_info = {
    .name          = TYPE_XILINX_UFS_REG,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(UFS_REG),
    .class_init    = ufs_reg_class_init,
    .instance_init = ufs_reg_init,
};

static void ufs_reg_register_types(void)
{
    type_register_static(&ufs_reg_info);
}

type_init(ufs_reg_register_types)
