/*
 * QEMU model of the IPI Inter Processor Interrupt block
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-08-23.
 * Written by Edgar E. Iglesias <edgar.iglesias@xilinx.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/irq.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "qemu/log.h"
#include "qapi/error.h"

#ifndef XILINX_IPI_ERR_DEBUG
#define XILINX_IPI_ERR_DEBUG 0
#endif

#define TYPE_XILINX_IPI "xlnx.versal-ipi"

#define XILINX_IPI(obj) \
     OBJECT_CHECK(XlnxVersalIPI, (obj), TYPE_XILINX_IPI)

REG32(IPI_CTRL, 0x0)
    FIELD(IPI_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IPI_INT_TRIG, 0xc)
    FIELD(IPI_INT_TRIG, ECC_CE, 7, 1)
    FIELD(IPI_INT_TRIG, ECC_UE, 6, 1)
    FIELD(IPI_INT_TRIG, APER_TZ, 5, 1)
    FIELD(IPI_INT_TRIG, APER_PERM, 4, 1)
    FIELD(IPI_INT_TRIG, MID_PARITY, 3, 1)
    FIELD(IPI_INT_TRIG, MID_RO, 2, 1)
    FIELD(IPI_INT_TRIG, MID_MISS, 1, 1)
    FIELD(IPI_INT_TRIG, ADDR_DECODE_ERR, 0, 1)
REG32(IPI_ISR, 0x10)
    FIELD(IPI_ISR, ECC_CE, 7, 1)
    FIELD(IPI_ISR, ECC_UE, 6, 1)
    FIELD(IPI_ISR, APER_TZ, 5, 1)
    FIELD(IPI_ISR, APER_PERM, 4, 1)
    FIELD(IPI_ISR, MID_PARITY, 3, 1)
    FIELD(IPI_ISR, MID_RO, 2, 1)
    FIELD(IPI_ISR, MID_MISS, 1, 1)
    FIELD(IPI_ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IPI_IMR, 0x14)
    FIELD(IPI_IMR, ECC_CE, 7, 1)
    FIELD(IPI_IMR, ECC_UE, 6, 1)
    FIELD(IPI_IMR, APER_TZ, 5, 1)
    FIELD(IPI_IMR, APER_PERM, 4, 1)
    FIELD(IPI_IMR, MID_PARITY, 3, 1)
    FIELD(IPI_IMR, MID_RO, 2, 1)
    FIELD(IPI_IMR, MID_MISS, 1, 1)
    FIELD(IPI_IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IPI_IER, 0x18)
    FIELD(IPI_IER, ECC_CE, 7, 1)
    FIELD(IPI_IER, ECC_UE, 6, 1)
    FIELD(IPI_IER, APER_TZ, 5, 1)
    FIELD(IPI_IER, APER_PERM, 4, 1)
    FIELD(IPI_IER, MID_PARITY, 3, 1)
    FIELD(IPI_IER, MID_RO, 2, 1)
    FIELD(IPI_IER, MID_MISS, 1, 1)
    FIELD(IPI_IER, ADDR_DECODE_ERR, 0, 1)
REG32(IPI_IDR, 0x1c)
    FIELD(IPI_IDR, ECC_CE, 7, 1)
    FIELD(IPI_IDR, ECC_UE, 6, 1)
    FIELD(IPI_IDR, APER_TZ, 5, 1)
    FIELD(IPI_IDR, APER_PERM, 4, 1)
    FIELD(IPI_IDR, MID_PARITY, 3, 1)
    FIELD(IPI_IDR, MID_RO, 2, 1)
    FIELD(IPI_IDR, MID_MISS, 1, 1)
    FIELD(IPI_IDR, ADDR_DECODE_ERR, 0, 1)
REG32(IPI_ECO, 0x20)
REG32(IPI_PROT_ERR_STATUS1_LOW, 0x28)
    FIELD(IPI_PROT_ERR_STATUS1_LOW, ADDR, 0, 12)
REG32(SAFETY_CHK, 0x30)
REG32(IPI_PROT_CTRL, 0x34)
    FIELD(IPI_PROT_CTRL, HIDEALLOWED, 2, 1)
    FIELD(IPI_PROT_CTRL, MID_PARITY_EN, 1, 1)
    FIELD(IPI_PROT_CTRL, ENABLE, 0, 1)
REG32(IPI_PROT_ERR_STATUS1, 0x38)
REG32(IPI_PROT_ERR_STATUS2, 0x3c)
    FIELD(IPI_PROT_ERR_STATUS2, AXI_ID, 0, 10)
REG32(MASTER_ID00, 0x40)
    FIELD(MASTER_ID00, MIDP, 31, 1)
    FIELD(MASTER_ID00, MIDR, 30, 1)
    FIELD(MASTER_ID00, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID00, MIDM, 16, 10)
    FIELD(MASTER_ID00, MID, 0, 10)
REG32(MASTER_ID01, 0x44)
    FIELD(MASTER_ID01, MIDP, 31, 1)
    FIELD(MASTER_ID01, MIDR, 30, 1)
    FIELD(MASTER_ID01, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID01, MIDM, 16, 10)
    FIELD(MASTER_ID01, MID, 0, 10)
REG32(MASTER_ID02, 0x48)
    FIELD(MASTER_ID02, MIDP, 31, 1)
    FIELD(MASTER_ID02, MIDR, 30, 1)
    FIELD(MASTER_ID02, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID02, MIDM, 16, 10)
    FIELD(MASTER_ID02, MID, 0, 10)
REG32(MASTER_ID03, 0x4c)
    FIELD(MASTER_ID03, MIDP, 31, 1)
    FIELD(MASTER_ID03, MIDR, 30, 1)
    FIELD(MASTER_ID03, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID03, MIDM, 16, 10)
    FIELD(MASTER_ID03, MID, 0, 10)
REG32(MASTER_ID04, 0x50)
    FIELD(MASTER_ID04, MIDP, 31, 1)
    FIELD(MASTER_ID04, MIDR, 30, 1)
    FIELD(MASTER_ID04, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID04, MIDM, 16, 10)
    FIELD(MASTER_ID04, MID, 0, 10)
REG32(MASTER_ID05, 0x54)
    FIELD(MASTER_ID05, MIDP, 31, 1)
    FIELD(MASTER_ID05, MIDR, 30, 1)
    FIELD(MASTER_ID05, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID05, MIDM, 16, 10)
    FIELD(MASTER_ID05, MID, 0, 10)
REG32(MASTER_ID06, 0x58)
    FIELD(MASTER_ID06, MIDP, 31, 1)
    FIELD(MASTER_ID06, MIDR, 30, 1)
    FIELD(MASTER_ID06, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID06, MIDM, 16, 10)
    FIELD(MASTER_ID06, MID, 0, 10)
REG32(MASTER_ID07, 0x5c)
    FIELD(MASTER_ID07, MIDP, 31, 1)
    FIELD(MASTER_ID07, MIDR, 30, 1)
    FIELD(MASTER_ID07, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID07, MIDM, 16, 10)
    FIELD(MASTER_ID07, MID, 0, 10)
REG32(MASTER_ID08, 0x60)
    FIELD(MASTER_ID08, MIDP, 31, 1)
    FIELD(MASTER_ID08, MIDR, 30, 1)
    FIELD(MASTER_ID08, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID08, MIDM, 16, 10)
    FIELD(MASTER_ID08, MID, 0, 10)
REG32(MASTER_ID09, 0x64)
    FIELD(MASTER_ID09, MIDP, 31, 1)
    FIELD(MASTER_ID09, MIDR, 30, 1)
    FIELD(MASTER_ID09, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID09, MIDM, 16, 10)
    FIELD(MASTER_ID09, MID, 0, 10)
REG32(MASTER_ID10, 0x68)
    FIELD(MASTER_ID10, MIDP, 31, 1)
    FIELD(MASTER_ID10, MIDR, 30, 1)
    FIELD(MASTER_ID10, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID10, MIDM, 16, 10)
    FIELD(MASTER_ID10, MID, 0, 10)
REG32(MASTER_ID11, 0x6c)
    FIELD(MASTER_ID11, MIDP, 31, 1)
    FIELD(MASTER_ID11, MIDR, 30, 1)
    FIELD(MASTER_ID11, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID11, MIDM, 16, 10)
    FIELD(MASTER_ID11, MID, 0, 10)
REG32(MASTER_ID12, 0x70)
    FIELD(MASTER_ID12, MIDP, 31, 1)
    FIELD(MASTER_ID12, MIDR, 30, 1)
    FIELD(MASTER_ID12, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID12, MIDM, 16, 10)
    FIELD(MASTER_ID12, MID, 0, 10)
REG32(MASTER_ID13, 0x74)
    FIELD(MASTER_ID13, MIDP, 31, 1)
    FIELD(MASTER_ID13, MIDR, 30, 1)
    FIELD(MASTER_ID13, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID13, MIDM, 16, 10)
    FIELD(MASTER_ID13, MID, 0, 10)
REG32(MASTER_ID14, 0x78)
    FIELD(MASTER_ID14, MIDP, 31, 1)
    FIELD(MASTER_ID14, MIDR, 30, 1)
    FIELD(MASTER_ID14, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID14, MIDM, 16, 10)
    FIELD(MASTER_ID14, MID, 0, 10)
REG32(MASTER_ID15, 0x7c)
    FIELD(MASTER_ID15, MIDP, 31, 1)
    FIELD(MASTER_ID15, MIDR, 30, 1)
    FIELD(MASTER_ID15, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID15, MIDM, 16, 10)
    FIELD(MASTER_ID15, MID, 0, 10)
REG32(MASTER_ID16, 0x80)
    FIELD(MASTER_ID16, MIDP, 31, 1)
    FIELD(MASTER_ID16, MIDR, 30, 1)
    FIELD(MASTER_ID16, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID16, MIDM, 16, 10)
    FIELD(MASTER_ID16, MID, 0, 10)
REG32(MASTER_ID17, 0x84)
    FIELD(MASTER_ID17, MIDP, 31, 1)
    FIELD(MASTER_ID17, MIDR, 30, 1)
    FIELD(MASTER_ID17, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID17, MIDM, 16, 10)
    FIELD(MASTER_ID17, MID, 0, 10)
REG32(MASTER_ID18, 0x88)
    FIELD(MASTER_ID18, MIDP, 31, 1)
    FIELD(MASTER_ID18, MIDR, 30, 1)
    FIELD(MASTER_ID18, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID18, MIDM, 16, 10)
    FIELD(MASTER_ID18, MID, 0, 10)
REG32(MASTER_ID19, 0x8c)
    FIELD(MASTER_ID19, MIDP, 31, 1)
    FIELD(MASTER_ID19, MIDR, 30, 1)
    FIELD(MASTER_ID19, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID19, MIDM, 16, 10)
    FIELD(MASTER_ID19, MID, 0, 10)
REG32(LOCK, 0x90)
    FIELD(LOCK, REGWRDIS, 0, 1)
REG32(IPI_ECC_CTRL, 0x94)
    FIELD(IPI_ECC_CTRL, FI_MODE, 2, 1)
    FIELD(IPI_ECC_CTRL, DET_ONLY, 1, 1)
    FIELD(IPI_ECC_CTRL, ECC_ON_OFF, 0, 1)
REG32(IPI_ECC_CE_FFA, 0x98)
    FIELD(IPI_ECC_CE_FFA, ADDR, 0, 10)
REG32(IPI_ECC_CE_FFD, 0x9c)
REG32(IPI_CE_FFE, 0xa0)
    FIELD(IPI_CE_FFE, SYNDROME, 0, 7)
REG32(IPI_ECC_UE_FFA, 0xa4)
    FIELD(IPI_ECC_UE_FFA, ADDR, 0, 10)
REG32(IPI_ECC_UE_FFD, 0xa8)
REG32(IPI_UE_FFE, 0xac)
    FIELD(IPI_UE_FFE, SYNDROME, 0, 7)
REG32(IPI_FI_CNTR, 0xb0)
    FIELD(IPI_FI_CNTR, COUNT, 0, 24)
REG32(IPI_FI_D, 0xb4)
REG32(IPI_FI_S, 0xb8)
    FIELD(IPI_FI_S, DATA, 0, 7)
REG32(IPI_APER_TZ_000, 0xbc)
    FIELD(IPI_APER_TZ_000, DATA, 0, 16)
REG32(IPI_APER_TZ_001, 0xc0)
    FIELD(IPI_APER_TZ_001, DATA, 0, 16)
REG32(IPI_APER_TZ_002, 0xc4)
    FIELD(IPI_APER_TZ_002, DATA, 0, 16)
REG32(IPI_APER_TZ_003, 0xc8)
    FIELD(IPI_APER_TZ_003, DATA, 0, 16)
REG32(IPI_APER_TZ_004, 0xcc)
    FIELD(IPI_APER_TZ_004, DATA, 0, 16)
REG32(IPI_APER_TZ_005, 0xd0)
    FIELD(IPI_APER_TZ_005, DATA, 0, 16)
REG32(IPI_APER_TZ_006, 0xd4)
    FIELD(IPI_APER_TZ_006, DATA, 0, 16)
REG32(IPI_APER_TZ_007, 0xd8)
    FIELD(IPI_APER_TZ_007, DATA, 0, 16)
REG32(IPI_APER_TZ_008, 0xdc)
    FIELD(IPI_APER_TZ_008, DATA, 0, 16)
REG32(MASTER_ID20, 0x100)
    FIELD(MASTER_ID20, MIDP, 31, 1)
    FIELD(MASTER_ID20, MIDR, 30, 1)
    FIELD(MASTER_ID20, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID20, MIDM, 16, 10)
    FIELD(MASTER_ID20, MID, 0, 10)
REG32(MASTER_ID21, 0x104)
    FIELD(MASTER_ID21, MIDP, 31, 1)
    FIELD(MASTER_ID21, MIDR, 30, 1)
    FIELD(MASTER_ID21, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID21, MIDM, 16, 10)
    FIELD(MASTER_ID21, MID, 0, 10)
REG32(MASTER_ID22, 0x108)
    FIELD(MASTER_ID22, MIDP, 31, 1)
    FIELD(MASTER_ID22, MIDR, 30, 1)
    FIELD(MASTER_ID22, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID22, MIDM, 16, 10)
    FIELD(MASTER_ID22, MID, 0, 10)
REG32(MASTER_ID23, 0x10c)
    FIELD(MASTER_ID23, MIDP, 31, 1)
    FIELD(MASTER_ID23, MIDR, 30, 1)
    FIELD(MASTER_ID23, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID23, MIDM, 16, 10)
    FIELD(MASTER_ID23, MID, 0, 10)
REG32(MASTER_ID24, 0x110)
    FIELD(MASTER_ID24, MIDP, 31, 1)
    FIELD(MASTER_ID24, MIDR, 30, 1)
    FIELD(MASTER_ID24, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID24, MIDM, 16, 10)
    FIELD(MASTER_ID24, MID, 0, 10)
REG32(MASTER_ID25, 0x114)
    FIELD(MASTER_ID25, MIDP, 31, 1)
    FIELD(MASTER_ID25, MIDR, 30, 1)
    FIELD(MASTER_ID25, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID25, MIDM, 16, 10)
    FIELD(MASTER_ID25, MID, 0, 10)
REG32(MASTER_ID26, 0x118)
    FIELD(MASTER_ID26, MIDP, 31, 1)
    FIELD(MASTER_ID26, MIDR, 30, 1)
    FIELD(MASTER_ID26, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID26, MIDM, 16, 10)
    FIELD(MASTER_ID26, MID, 0, 10)
REG32(MASTER_ID27, 0x11c)
    FIELD(MASTER_ID27, MIDP, 31, 1)
    FIELD(MASTER_ID27, MIDR, 30, 1)
    FIELD(MASTER_ID27, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID27, MIDM, 16, 10)
    FIELD(MASTER_ID27, MID, 0, 10)
REG32(MASTER_ID28, 0x120)
    FIELD(MASTER_ID28, MIDP, 31, 1)
    FIELD(MASTER_ID28, MIDR, 30, 1)
    FIELD(MASTER_ID28, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID28, MIDM, 16, 10)
    FIELD(MASTER_ID28, MID, 0, 10)
REG32(MASTER_ID29, 0x124)
    FIELD(MASTER_ID29, MIDP, 31, 1)
    FIELD(MASTER_ID29, MIDR, 30, 1)
    FIELD(MASTER_ID29, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID29, MIDM, 16, 10)
    FIELD(MASTER_ID29, MID, 0, 10)
REG32(MASTER_ID30, 0x128)
    FIELD(MASTER_ID30, MIDP, 31, 1)
    FIELD(MASTER_ID30, MIDR, 30, 1)
    FIELD(MASTER_ID30, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID30, MIDM, 16, 10)
    FIELD(MASTER_ID30, MID, 0, 10)
REG32(MASTER_ID31, 0x12c)
    FIELD(MASTER_ID31, MIDP, 31, 1)
    FIELD(MASTER_ID31, MIDR, 30, 1)
    FIELD(MASTER_ID31, OVERRIDEEN, 29, 1)
    FIELD(MASTER_ID31, MIDM, 16, 10)
    FIELD(MASTER_ID31, MID, 0, 10)
REG32(PSM_TRIG, 0x10000)
    FIELD(PSM_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(PSM_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(PSM_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(PSM_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(PSM_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(PSM_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(PSM_TRIG, IPI6, 9, 1)
    FIELD(PSM_TRIG, PMC_NOBUF, 8, 1)
    FIELD(PSM_TRIG, IPI5, 7, 1)
    FIELD(PSM_TRIG, IPI4, 6, 1)
    FIELD(PSM_TRIG, IPI3, 5, 1)
    FIELD(PSM_TRIG, IPI2, 4, 1)
    FIELD(PSM_TRIG, IPI1, 3, 1)
    FIELD(PSM_TRIG, IPI0, 2, 1)
    FIELD(PSM_TRIG, PMC, 1, 1)
    FIELD(PSM_TRIG, PSM, 0, 1)
REG32(PSM_OBS, 0x10004)
    FIELD(PSM_OBS, IPI_NOBUF6, 15, 1)
    FIELD(PSM_OBS, IPI_NOBUF5, 14, 1)
    FIELD(PSM_OBS, IPI_NOBUF4, 13, 1)
    FIELD(PSM_OBS, IPI_NOBUF3, 12, 1)
    FIELD(PSM_OBS, IPI_NOBUF2, 11, 1)
    FIELD(PSM_OBS, IPI_NOBUF1, 10, 1)
    FIELD(PSM_OBS, IPI6, 9, 1)
    FIELD(PSM_OBS, PMC_NOBUF, 8, 1)
    FIELD(PSM_OBS, IPI5, 7, 1)
    FIELD(PSM_OBS, IPI4, 6, 1)
    FIELD(PSM_OBS, IPI3, 5, 1)
    FIELD(PSM_OBS, IPI2, 4, 1)
    FIELD(PSM_OBS, IPI1, 3, 1)
    FIELD(PSM_OBS, IPI0, 2, 1)
    FIELD(PSM_OBS, PMC, 1, 1)
    FIELD(PSM_OBS, PSM, 0, 1)
REG32(PSM_ISR, 0x10010)
    FIELD(PSM_ISR, IPI_NOBUF6, 15, 1)
    FIELD(PSM_ISR, IPI_NOBUF5, 14, 1)
    FIELD(PSM_ISR, IPI_NOBUF4, 13, 1)
    FIELD(PSM_ISR, IPI_NOBUF3, 12, 1)
    FIELD(PSM_ISR, IPI_NOBUF2, 11, 1)
    FIELD(PSM_ISR, IPI_NOBUF1, 10, 1)
    FIELD(PSM_ISR, IPI6, 9, 1)
    FIELD(PSM_ISR, PMC_NOBUF, 8, 1)
    FIELD(PSM_ISR, IPI5, 7, 1)
    FIELD(PSM_ISR, IPI4, 6, 1)
    FIELD(PSM_ISR, IPI3, 5, 1)
    FIELD(PSM_ISR, IPI2, 4, 1)
    FIELD(PSM_ISR, IPI1, 3, 1)
    FIELD(PSM_ISR, IPI0, 2, 1)
    FIELD(PSM_ISR, PMC, 1, 1)
    FIELD(PSM_ISR, PSM, 0, 1)
REG32(PSM_IMR, 0x10014)
    FIELD(PSM_IMR, IPI_NOBUF6, 15, 1)
    FIELD(PSM_IMR, IPI_NOBUF5, 14, 1)
    FIELD(PSM_IMR, IPI_NOBUF4, 13, 1)
    FIELD(PSM_IMR, IPI_NOBUF3, 12, 1)
    FIELD(PSM_IMR, IPI_NOBUF2, 11, 1)
    FIELD(PSM_IMR, IPI_NOBUF1, 10, 1)
    FIELD(PSM_IMR, IPI6, 9, 1)
    FIELD(PSM_IMR, PMC_NOBUF, 8, 1)
    FIELD(PSM_IMR, IPI5, 7, 1)
    FIELD(PSM_IMR, IPI4, 6, 1)
    FIELD(PSM_IMR, IPI3, 5, 1)
    FIELD(PSM_IMR, IPI2, 4, 1)
    FIELD(PSM_IMR, IPI1, 3, 1)
    FIELD(PSM_IMR, IPI0, 2, 1)
    FIELD(PSM_IMR, PMC, 1, 1)
    FIELD(PSM_IMR, PSM, 0, 1)
REG32(PSM_IER, 0x10018)
    FIELD(PSM_IER, IPI_NOBUF6, 15, 1)
    FIELD(PSM_IER, IPI_NOBUF5, 14, 1)
    FIELD(PSM_IER, IPI_NOBUF4, 13, 1)
    FIELD(PSM_IER, IPI_NOBUF3, 12, 1)
    FIELD(PSM_IER, IPI_NOBUF2, 11, 1)
    FIELD(PSM_IER, IPI_NOBUF1, 10, 1)
    FIELD(PSM_IER, IPI6, 9, 1)
    FIELD(PSM_IER, PMC_NOBUF, 8, 1)
    FIELD(PSM_IER, IPI5, 7, 1)
    FIELD(PSM_IER, IPI4, 6, 1)
    FIELD(PSM_IER, IPI3, 5, 1)
    FIELD(PSM_IER, IPI2, 4, 1)
    FIELD(PSM_IER, IPI1, 3, 1)
    FIELD(PSM_IER, IPI0, 2, 1)
    FIELD(PSM_IER, PMC, 1, 1)
    FIELD(PSM_IER, PSM, 0, 1)
REG32(PSM_IDR, 0x1001c)
    FIELD(PSM_IDR, IPI_NOBUF6, 15, 1)
    FIELD(PSM_IDR, IPI_NOBUF5, 14, 1)
    FIELD(PSM_IDR, IPI_NOBUF4, 13, 1)
    FIELD(PSM_IDR, IPI_NOBUF3, 12, 1)
    FIELD(PSM_IDR, IPI_NOBUF2, 11, 1)
    FIELD(PSM_IDR, IPI_NOBUF1, 10, 1)
    FIELD(PSM_IDR, IPI6, 9, 1)
    FIELD(PSM_IDR, PMC_NOBUF, 8, 1)
    FIELD(PSM_IDR, IPI5, 7, 1)
    FIELD(PSM_IDR, IPI4, 6, 1)
    FIELD(PSM_IDR, IPI3, 5, 1)
    FIELD(PSM_IDR, IPI2, 4, 1)
    FIELD(PSM_IDR, IPI1, 3, 1)
    FIELD(PSM_IDR, IPI0, 2, 1)
    FIELD(PSM_IDR, PMC, 1, 1)
    FIELD(PSM_IDR, PSM, 0, 1)
REG32(PMC_TRIG, 0x20000)
    FIELD(PMC_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(PMC_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(PMC_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(PMC_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(PMC_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(PMC_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(PMC_TRIG, IPI6, 9, 1)
    FIELD(PMC_TRIG, PMC_NOBUF, 8, 1)
    FIELD(PMC_TRIG, IPI5, 7, 1)
    FIELD(PMC_TRIG, IPI4, 6, 1)
    FIELD(PMC_TRIG, IPI3, 5, 1)
    FIELD(PMC_TRIG, IPI2, 4, 1)
    FIELD(PMC_TRIG, IPI1, 3, 1)
    FIELD(PMC_TRIG, IPI0, 2, 1)
    FIELD(PMC_TRIG, PMC, 1, 1)
    FIELD(PMC_TRIG, PSM, 0, 1)
REG32(PMC_OBS, 0x20004)
    FIELD(PMC_OBS, IPI_NOBUF6, 15, 1)
    FIELD(PMC_OBS, IPI_NOBUF5, 14, 1)
    FIELD(PMC_OBS, IPI_NOBUF4, 13, 1)
    FIELD(PMC_OBS, IPI_NOBUF3, 12, 1)
    FIELD(PMC_OBS, IPI_NOBUF2, 11, 1)
    FIELD(PMC_OBS, IPI_NOBUF1, 10, 1)
    FIELD(PMC_OBS, IPI6, 9, 1)
    FIELD(PMC_OBS, PMC_NOBUF, 8, 1)
    FIELD(PMC_OBS, IPI5, 7, 1)
    FIELD(PMC_OBS, IPI4, 6, 1)
    FIELD(PMC_OBS, IPI3, 5, 1)
    FIELD(PMC_OBS, IPI2, 4, 1)
    FIELD(PMC_OBS, IPI1, 3, 1)
    FIELD(PMC_OBS, IPI0, 2, 1)
    FIELD(PMC_OBS, PMC, 1, 1)
    FIELD(PMC_OBS, PSM, 0, 1)
REG32(PMC_ISR, 0x20010)
    FIELD(PMC_ISR, IPI_NOBUF6, 15, 1)
    FIELD(PMC_ISR, IPI_NOBUF5, 14, 1)
    FIELD(PMC_ISR, IPI_NOBUF4, 13, 1)
    FIELD(PMC_ISR, IPI_NOBUF3, 12, 1)
    FIELD(PMC_ISR, IPI_NOBUF2, 11, 1)
    FIELD(PMC_ISR, IPI_NOBUF1, 10, 1)
    FIELD(PMC_ISR, IPI6, 9, 1)
    FIELD(PMC_ISR, PMC_NOBUF, 8, 1)
    FIELD(PMC_ISR, IPI5, 7, 1)
    FIELD(PMC_ISR, IPI4, 6, 1)
    FIELD(PMC_ISR, IPI3, 5, 1)
    FIELD(PMC_ISR, IPI2, 4, 1)
    FIELD(PMC_ISR, IPI1, 3, 1)
    FIELD(PMC_ISR, IPI0, 2, 1)
    FIELD(PMC_ISR, PMC, 1, 1)
    FIELD(PMC_ISR, PSM, 0, 1)
REG32(PMC_IMR, 0x20014)
    FIELD(PMC_IMR, IPI_NOBUF6, 15, 1)
    FIELD(PMC_IMR, IPI_NOBUF5, 14, 1)
    FIELD(PMC_IMR, IPI_NOBUF4, 13, 1)
    FIELD(PMC_IMR, IPI_NOBUF3, 12, 1)
    FIELD(PMC_IMR, IPI_NOBUF2, 11, 1)
    FIELD(PMC_IMR, IPI_NOBUF1, 10, 1)
    FIELD(PMC_IMR, IPI6, 9, 1)
    FIELD(PMC_IMR, PMC_NOBUF, 8, 1)
    FIELD(PMC_IMR, IPI5, 7, 1)
    FIELD(PMC_IMR, IPI4, 6, 1)
    FIELD(PMC_IMR, IPI3, 5, 1)
    FIELD(PMC_IMR, IPI2, 4, 1)
    FIELD(PMC_IMR, IPI1, 3, 1)
    FIELD(PMC_IMR, IPI0, 2, 1)
    FIELD(PMC_IMR, PMC, 1, 1)
    FIELD(PMC_IMR, PSM, 0, 1)
REG32(PMC_IER, 0x20018)
    FIELD(PMC_IER, IPI_NOBUF6, 15, 1)
    FIELD(PMC_IER, IPI_NOBUF5, 14, 1)
    FIELD(PMC_IER, IPI_NOBUF4, 13, 1)
    FIELD(PMC_IER, IPI_NOBUF3, 12, 1)
    FIELD(PMC_IER, IPI_NOBUF2, 11, 1)
    FIELD(PMC_IER, IPI_NOBUF1, 10, 1)
    FIELD(PMC_IER, IPI6, 9, 1)
    FIELD(PMC_IER, PMC_NOBUF, 8, 1)
    FIELD(PMC_IER, IPI5, 7, 1)
    FIELD(PMC_IER, IPI4, 6, 1)
    FIELD(PMC_IER, IPI3, 5, 1)
    FIELD(PMC_IER, IPI2, 4, 1)
    FIELD(PMC_IER, IPI1, 3, 1)
    FIELD(PMC_IER, IPI0, 2, 1)
    FIELD(PMC_IER, PMC, 1, 1)
    FIELD(PMC_IER, PSM, 0, 1)
REG32(PMC_IDR, 0x2001c)
    FIELD(PMC_IDR, IPI_NOBUF6, 15, 1)
    FIELD(PMC_IDR, IPI_NOBUF5, 14, 1)
    FIELD(PMC_IDR, IPI_NOBUF4, 13, 1)
    FIELD(PMC_IDR, IPI_NOBUF3, 12, 1)
    FIELD(PMC_IDR, IPI_NOBUF2, 11, 1)
    FIELD(PMC_IDR, IPI_NOBUF1, 10, 1)
    FIELD(PMC_IDR, IPI6, 9, 1)
    FIELD(PMC_IDR, PMC_NOBUF, 8, 1)
    FIELD(PMC_IDR, IPI5, 7, 1)
    FIELD(PMC_IDR, IPI4, 6, 1)
    FIELD(PMC_IDR, IPI3, 5, 1)
    FIELD(PMC_IDR, IPI2, 4, 1)
    FIELD(PMC_IDR, IPI1, 3, 1)
    FIELD(PMC_IDR, IPI0, 2, 1)
    FIELD(PMC_IDR, PMC, 1, 1)
    FIELD(PMC_IDR, PSM, 0, 1)
REG32(IPI0_TRIG, 0x30000)
    FIELD(IPI0_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI0_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI0_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI0_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI0_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI0_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI0_TRIG, IPI6, 9, 1)
    FIELD(IPI0_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI0_TRIG, IPI5, 7, 1)
    FIELD(IPI0_TRIG, IPI4, 6, 1)
    FIELD(IPI0_TRIG, IPI3, 5, 1)
    FIELD(IPI0_TRIG, IPI2, 4, 1)
    FIELD(IPI0_TRIG, IPI1, 3, 1)
    FIELD(IPI0_TRIG, IPI0, 2, 1)
    FIELD(IPI0_TRIG, PMC, 1, 1)
    FIELD(IPI0_TRIG, PSM, 0, 1)
REG32(IPI0_OBS, 0x30004)
    FIELD(IPI0_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI0_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI0_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI0_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI0_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI0_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI0_OBS, IPI6, 9, 1)
    FIELD(IPI0_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI0_OBS, IPI5, 7, 1)
    FIELD(IPI0_OBS, IPI4, 6, 1)
    FIELD(IPI0_OBS, IPI3, 5, 1)
    FIELD(IPI0_OBS, IPI2, 4, 1)
    FIELD(IPI0_OBS, IPI1, 3, 1)
    FIELD(IPI0_OBS, IPI0, 2, 1)
    FIELD(IPI0_OBS, PMC, 1, 1)
    FIELD(IPI0_OBS, PSM, 0, 1)
REG32(IPI0_ISR, 0x30010)
    FIELD(IPI0_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI0_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI0_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI0_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI0_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI0_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI0_ISR, IPI6, 9, 1)
    FIELD(IPI0_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI0_ISR, IPI5, 7, 1)
    FIELD(IPI0_ISR, IPI4, 6, 1)
    FIELD(IPI0_ISR, IPI3, 5, 1)
    FIELD(IPI0_ISR, IPI2, 4, 1)
    FIELD(IPI0_ISR, IPI1, 3, 1)
    FIELD(IPI0_ISR, IPI0, 2, 1)
    FIELD(IPI0_ISR, PMC, 1, 1)
    FIELD(IPI0_ISR, PSM, 0, 1)
REG32(IPI0_IMR, 0x30014)
    FIELD(IPI0_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI0_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI0_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI0_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI0_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI0_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI0_IMR, IPI6, 9, 1)
    FIELD(IPI0_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI0_IMR, IPI5, 7, 1)
    FIELD(IPI0_IMR, IPI4, 6, 1)
    FIELD(IPI0_IMR, IPI3, 5, 1)
    FIELD(IPI0_IMR, IPI2, 4, 1)
    FIELD(IPI0_IMR, IPI1, 3, 1)
    FIELD(IPI0_IMR, IPI0, 2, 1)
    FIELD(IPI0_IMR, PMC, 1, 1)
    FIELD(IPI0_IMR, PSM, 0, 1)
REG32(IPI0_IER, 0x30018)
    FIELD(IPI0_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI0_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI0_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI0_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI0_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI0_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI0_IER, IPI6, 9, 1)
    FIELD(IPI0_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI0_IER, IPI5, 7, 1)
    FIELD(IPI0_IER, IPI4, 6, 1)
    FIELD(IPI0_IER, IPI3, 5, 1)
    FIELD(IPI0_IER, IPI2, 4, 1)
    FIELD(IPI0_IER, IPI1, 3, 1)
    FIELD(IPI0_IER, IPI0, 2, 1)
    FIELD(IPI0_IER, PMC, 1, 1)
    FIELD(IPI0_IER, PSM, 0, 1)
REG32(IPI0_IDR, 0x3001c)
    FIELD(IPI0_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI0_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI0_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI0_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI0_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI0_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI0_IDR, IPI6, 9, 1)
    FIELD(IPI0_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI0_IDR, IPI5, 7, 1)
    FIELD(IPI0_IDR, IPI4, 6, 1)
    FIELD(IPI0_IDR, IPI3, 5, 1)
    FIELD(IPI0_IDR, IPI2, 4, 1)
    FIELD(IPI0_IDR, IPI1, 3, 1)
    FIELD(IPI0_IDR, IPI0, 2, 1)
    FIELD(IPI0_IDR, PMC, 1, 1)
    FIELD(IPI0_IDR, PSM, 0, 1)
REG32(IPI1_TRIG, 0x40000)
    FIELD(IPI1_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI1_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI1_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI1_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI1_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI1_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI1_TRIG, IPI6, 9, 1)
    FIELD(IPI1_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI1_TRIG, IPI5, 7, 1)
    FIELD(IPI1_TRIG, IPI4, 6, 1)
    FIELD(IPI1_TRIG, IPI3, 5, 1)
    FIELD(IPI1_TRIG, IPI2, 4, 1)
    FIELD(IPI1_TRIG, IPI1, 3, 1)
    FIELD(IPI1_TRIG, IPI0, 2, 1)
    FIELD(IPI1_TRIG, PMC, 1, 1)
    FIELD(IPI1_TRIG, PSM, 0, 1)
REG32(IPI1_OBS, 0x40004)
    FIELD(IPI1_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI1_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI1_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI1_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI1_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI1_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI1_OBS, IPI6, 9, 1)
    FIELD(IPI1_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI1_OBS, IPI5, 7, 1)
    FIELD(IPI1_OBS, IPI4, 6, 1)
    FIELD(IPI1_OBS, IPI3, 5, 1)
    FIELD(IPI1_OBS, IPI2, 4, 1)
    FIELD(IPI1_OBS, IPI1, 3, 1)
    FIELD(IPI1_OBS, IPI0, 2, 1)
    FIELD(IPI1_OBS, PMC, 1, 1)
    FIELD(IPI1_OBS, PSM, 0, 1)
REG32(IPI1_ISR, 0x40010)
    FIELD(IPI1_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI1_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI1_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI1_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI1_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI1_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI1_ISR, IPI6, 9, 1)
    FIELD(IPI1_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI1_ISR, IPI5, 7, 1)
    FIELD(IPI1_ISR, IPI4, 6, 1)
    FIELD(IPI1_ISR, IPI3, 5, 1)
    FIELD(IPI1_ISR, IPI2, 4, 1)
    FIELD(IPI1_ISR, IPI1, 3, 1)
    FIELD(IPI1_ISR, IPI0, 2, 1)
    FIELD(IPI1_ISR, PMC, 1, 1)
    FIELD(IPI1_ISR, PSM, 0, 1)
REG32(IPI1_IMR, 0x40014)
    FIELD(IPI1_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI1_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI1_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI1_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI1_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI1_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI1_IMR, IPI6, 9, 1)
    FIELD(IPI1_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI1_IMR, IPI5, 7, 1)
    FIELD(IPI1_IMR, IPI4, 6, 1)
    FIELD(IPI1_IMR, IPI3, 5, 1)
    FIELD(IPI1_IMR, IPI2, 4, 1)
    FIELD(IPI1_IMR, IPI1, 3, 1)
    FIELD(IPI1_IMR, IPI0, 2, 1)
    FIELD(IPI1_IMR, PMC, 1, 1)
    FIELD(IPI1_IMR, PSM, 0, 1)
REG32(IPI1_IER, 0x40018)
    FIELD(IPI1_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI1_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI1_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI1_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI1_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI1_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI1_IER, IPI6, 9, 1)
    FIELD(IPI1_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI1_IER, IPI5, 7, 1)
    FIELD(IPI1_IER, IPI4, 6, 1)
    FIELD(IPI1_IER, IPI3, 5, 1)
    FIELD(IPI1_IER, IPI2, 4, 1)
    FIELD(IPI1_IER, IPI1, 3, 1)
    FIELD(IPI1_IER, IPI0, 2, 1)
    FIELD(IPI1_IER, PMC, 1, 1)
    FIELD(IPI1_IER, PSM, 0, 1)
REG32(IPI1_IDR, 0x4001c)
    FIELD(IPI1_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI1_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI1_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI1_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI1_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI1_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI1_IDR, IPI6, 9, 1)
    FIELD(IPI1_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI1_IDR, IPI5, 7, 1)
    FIELD(IPI1_IDR, IPI4, 6, 1)
    FIELD(IPI1_IDR, IPI3, 5, 1)
    FIELD(IPI1_IDR, IPI2, 4, 1)
    FIELD(IPI1_IDR, IPI1, 3, 1)
    FIELD(IPI1_IDR, IPI0, 2, 1)
    FIELD(IPI1_IDR, PMC, 1, 1)
    FIELD(IPI1_IDR, PSM, 0, 1)
REG32(IPI2_TRIG, 0x50000)
    FIELD(IPI2_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI2_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI2_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI2_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI2_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI2_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI2_TRIG, IPI6, 9, 1)
    FIELD(IPI2_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI2_TRIG, IPI5, 7, 1)
    FIELD(IPI2_TRIG, IPI4, 6, 1)
    FIELD(IPI2_TRIG, IPI3, 5, 1)
    FIELD(IPI2_TRIG, IPI2, 4, 1)
    FIELD(IPI2_TRIG, IPI1, 3, 1)
    FIELD(IPI2_TRIG, IPI0, 2, 1)
    FIELD(IPI2_TRIG, PMC, 1, 1)
    FIELD(IPI2_TRIG, PSM, 0, 1)
REG32(IPI2_OBS, 0x50004)
    FIELD(IPI2_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI2_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI2_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI2_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI2_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI2_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI2_OBS, IPI6, 9, 1)
    FIELD(IPI2_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI2_OBS, IPI5, 7, 1)
    FIELD(IPI2_OBS, IPI4, 6, 1)
    FIELD(IPI2_OBS, IPI3, 5, 1)
    FIELD(IPI2_OBS, IPI2, 4, 1)
    FIELD(IPI2_OBS, IPI1, 3, 1)
    FIELD(IPI2_OBS, IPI0, 2, 1)
    FIELD(IPI2_OBS, PMC, 1, 1)
    FIELD(IPI2_OBS, PSM, 0, 1)
REG32(IPI2_ISR, 0x50010)
    FIELD(IPI2_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI2_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI2_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI2_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI2_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI2_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI2_ISR, IPI6, 9, 1)
    FIELD(IPI2_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI2_ISR, IPI5, 7, 1)
    FIELD(IPI2_ISR, IPI4, 6, 1)
    FIELD(IPI2_ISR, IPI3, 5, 1)
    FIELD(IPI2_ISR, IPI2, 4, 1)
    FIELD(IPI2_ISR, IPI1, 3, 1)
    FIELD(IPI2_ISR, IPI0, 2, 1)
    FIELD(IPI2_ISR, PMC, 1, 1)
    FIELD(IPI2_ISR, PSM, 0, 1)
REG32(IPI2_IMR, 0x50014)
    FIELD(IPI2_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI2_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI2_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI2_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI2_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI2_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI2_IMR, IPI6, 9, 1)
    FIELD(IPI2_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI2_IMR, IPI5, 7, 1)
    FIELD(IPI2_IMR, IPI4, 6, 1)
    FIELD(IPI2_IMR, IPI3, 5, 1)
    FIELD(IPI2_IMR, IPI2, 4, 1)
    FIELD(IPI2_IMR, IPI1, 3, 1)
    FIELD(IPI2_IMR, IPI0, 2, 1)
    FIELD(IPI2_IMR, PMC, 1, 1)
    FIELD(IPI2_IMR, PSM, 0, 1)
REG32(IPI2_IER, 0x50018)
    FIELD(IPI2_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI2_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI2_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI2_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI2_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI2_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI2_IER, IPI6, 9, 1)
    FIELD(IPI2_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI2_IER, IPI5, 7, 1)
    FIELD(IPI2_IER, IPI4, 6, 1)
    FIELD(IPI2_IER, IPI3, 5, 1)
    FIELD(IPI2_IER, IPI2, 4, 1)
    FIELD(IPI2_IER, IPI1, 3, 1)
    FIELD(IPI2_IER, IPI0, 2, 1)
    FIELD(IPI2_IER, PMC, 1, 1)
    FIELD(IPI2_IER, PSM, 0, 1)
REG32(IPI2_IDR, 0x5001c)
    FIELD(IPI2_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI2_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI2_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI2_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI2_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI2_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI2_IDR, IPI6, 9, 1)
    FIELD(IPI2_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI2_IDR, IPI5, 7, 1)
    FIELD(IPI2_IDR, IPI4, 6, 1)
    FIELD(IPI2_IDR, IPI3, 5, 1)
    FIELD(IPI2_IDR, IPI2, 4, 1)
    FIELD(IPI2_IDR, IPI1, 3, 1)
    FIELD(IPI2_IDR, IPI0, 2, 1)
    FIELD(IPI2_IDR, PMC, 1, 1)
    FIELD(IPI2_IDR, PSM, 0, 1)
REG32(IPI3_TRIG, 0x60000)
    FIELD(IPI3_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI3_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI3_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI3_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI3_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI3_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI3_TRIG, IPI6, 9, 1)
    FIELD(IPI3_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI3_TRIG, IPI5, 7, 1)
    FIELD(IPI3_TRIG, IPI4, 6, 1)
    FIELD(IPI3_TRIG, IPI3, 5, 1)
    FIELD(IPI3_TRIG, IPI2, 4, 1)
    FIELD(IPI3_TRIG, IPI1, 3, 1)
    FIELD(IPI3_TRIG, IPI0, 2, 1)
    FIELD(IPI3_TRIG, PMC, 1, 1)
    FIELD(IPI3_TRIG, PSM, 0, 1)
REG32(IPI3_OBS, 0x60004)
    FIELD(IPI3_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI3_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI3_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI3_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI3_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI3_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI3_OBS, IPI6, 9, 1)
    FIELD(IPI3_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI3_OBS, IPI5, 7, 1)
    FIELD(IPI3_OBS, IPI4, 6, 1)
    FIELD(IPI3_OBS, IPI3, 5, 1)
    FIELD(IPI3_OBS, IPI2, 4, 1)
    FIELD(IPI3_OBS, IPI1, 3, 1)
    FIELD(IPI3_OBS, IPI0, 2, 1)
    FIELD(IPI3_OBS, PMC, 1, 1)
    FIELD(IPI3_OBS, PSM, 0, 1)
REG32(IPI3_ISR, 0x60010)
    FIELD(IPI3_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI3_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI3_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI3_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI3_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI3_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI3_ISR, IPI6, 9, 1)
    FIELD(IPI3_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI3_ISR, IPI5, 7, 1)
    FIELD(IPI3_ISR, IPI4, 6, 1)
    FIELD(IPI3_ISR, IPI3, 5, 1)
    FIELD(IPI3_ISR, IPI2, 4, 1)
    FIELD(IPI3_ISR, IPI1, 3, 1)
    FIELD(IPI3_ISR, IPI0, 2, 1)
    FIELD(IPI3_ISR, PMC, 1, 1)
    FIELD(IPI3_ISR, PSM, 0, 1)
REG32(IPI3_IMR, 0x60014)
    FIELD(IPI3_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI3_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI3_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI3_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI3_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI3_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI3_IMR, IPI6, 9, 1)
    FIELD(IPI3_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI3_IMR, IPI5, 7, 1)
    FIELD(IPI3_IMR, IPI4, 6, 1)
    FIELD(IPI3_IMR, IPI3, 5, 1)
    FIELD(IPI3_IMR, IPI2, 4, 1)
    FIELD(IPI3_IMR, IPI1, 3, 1)
    FIELD(IPI3_IMR, IPI0, 2, 1)
    FIELD(IPI3_IMR, PMC, 1, 1)
    FIELD(IPI3_IMR, PSM, 0, 1)
REG32(IPI3_IER, 0x60018)
    FIELD(IPI3_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI3_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI3_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI3_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI3_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI3_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI3_IER, IPI6, 9, 1)
    FIELD(IPI3_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI3_IER, IPI5, 7, 1)
    FIELD(IPI3_IER, IPI4, 6, 1)
    FIELD(IPI3_IER, IPI3, 5, 1)
    FIELD(IPI3_IER, IPI2, 4, 1)
    FIELD(IPI3_IER, IPI1, 3, 1)
    FIELD(IPI3_IER, IPI0, 2, 1)
    FIELD(IPI3_IER, PMC, 1, 1)
    FIELD(IPI3_IER, PSM, 0, 1)
REG32(IPI3_IDR, 0x6001c)
    FIELD(IPI3_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI3_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI3_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI3_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI3_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI3_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI3_IDR, IPI6, 9, 1)
    FIELD(IPI3_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI3_IDR, IPI5, 7, 1)
    FIELD(IPI3_IDR, IPI4, 6, 1)
    FIELD(IPI3_IDR, IPI3, 5, 1)
    FIELD(IPI3_IDR, IPI2, 4, 1)
    FIELD(IPI3_IDR, IPI1, 3, 1)
    FIELD(IPI3_IDR, IPI0, 2, 1)
    FIELD(IPI3_IDR, PMC, 1, 1)
    FIELD(IPI3_IDR, PSM, 0, 1)
REG32(IPI4_TRIG, 0x70000)
    FIELD(IPI4_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI4_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI4_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI4_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI4_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI4_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI4_TRIG, IPI6, 9, 1)
    FIELD(IPI4_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI4_TRIG, IPI5, 7, 1)
    FIELD(IPI4_TRIG, IPI4, 6, 1)
    FIELD(IPI4_TRIG, IPI3, 5, 1)
    FIELD(IPI4_TRIG, IPI2, 4, 1)
    FIELD(IPI4_TRIG, IPI1, 3, 1)
    FIELD(IPI4_TRIG, IPI0, 2, 1)
    FIELD(IPI4_TRIG, PMC, 1, 1)
    FIELD(IPI4_TRIG, PSM, 0, 1)
REG32(IPI4_OBS, 0x70004)
    FIELD(IPI4_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI4_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI4_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI4_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI4_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI4_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI4_OBS, IPI6, 9, 1)
    FIELD(IPI4_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI4_OBS, IPI5, 7, 1)
    FIELD(IPI4_OBS, IPI4, 6, 1)
    FIELD(IPI4_OBS, IPI3, 5, 1)
    FIELD(IPI4_OBS, IPI2, 4, 1)
    FIELD(IPI4_OBS, IPI1, 3, 1)
    FIELD(IPI4_OBS, IPI0, 2, 1)
    FIELD(IPI4_OBS, PMC, 1, 1)
    FIELD(IPI4_OBS, PSM, 0, 1)
REG32(IPI4_ISR, 0x70010)
    FIELD(IPI4_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI4_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI4_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI4_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI4_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI4_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI4_ISR, IPI6, 9, 1)
    FIELD(IPI4_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI4_ISR, IPI5, 7, 1)
    FIELD(IPI4_ISR, IPI4, 6, 1)
    FIELD(IPI4_ISR, IPI3, 5, 1)
    FIELD(IPI4_ISR, IPI2, 4, 1)
    FIELD(IPI4_ISR, IPI1, 3, 1)
    FIELD(IPI4_ISR, IPI0, 2, 1)
    FIELD(IPI4_ISR, PMC, 1, 1)
    FIELD(IPI4_ISR, PSM, 0, 1)
REG32(IPI4_IMR, 0x70014)
    FIELD(IPI4_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI4_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI4_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI4_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI4_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI4_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI4_IMR, IPI6, 9, 1)
    FIELD(IPI4_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI4_IMR, IPI5, 7, 1)
    FIELD(IPI4_IMR, IPI4, 6, 1)
    FIELD(IPI4_IMR, IPI3, 5, 1)
    FIELD(IPI4_IMR, IPI2, 4, 1)
    FIELD(IPI4_IMR, IPI1, 3, 1)
    FIELD(IPI4_IMR, IPI0, 2, 1)
    FIELD(IPI4_IMR, PMC, 1, 1)
    FIELD(IPI4_IMR, PSM, 0, 1)
REG32(IPI4_IER, 0x70018)
    FIELD(IPI4_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI4_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI4_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI4_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI4_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI4_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI4_IER, IPI6, 9, 1)
    FIELD(IPI4_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI4_IER, IPI5, 7, 1)
    FIELD(IPI4_IER, IPI4, 6, 1)
    FIELD(IPI4_IER, IPI3, 5, 1)
    FIELD(IPI4_IER, IPI2, 4, 1)
    FIELD(IPI4_IER, IPI1, 3, 1)
    FIELD(IPI4_IER, IPI0, 2, 1)
    FIELD(IPI4_IER, PMC, 1, 1)
    FIELD(IPI4_IER, PSM, 0, 1)
REG32(IPI4_IDR, 0x7001c)
    FIELD(IPI4_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI4_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI4_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI4_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI4_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI4_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI4_IDR, IPI6, 9, 1)
    FIELD(IPI4_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI4_IDR, IPI5, 7, 1)
    FIELD(IPI4_IDR, IPI4, 6, 1)
    FIELD(IPI4_IDR, IPI3, 5, 1)
    FIELD(IPI4_IDR, IPI2, 4, 1)
    FIELD(IPI4_IDR, IPI1, 3, 1)
    FIELD(IPI4_IDR, IPI0, 2, 1)
    FIELD(IPI4_IDR, PMC, 1, 1)
    FIELD(IPI4_IDR, PSM, 0, 1)
REG32(IPI5_TRIG, 0x80000)
    FIELD(IPI5_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI5_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI5_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI5_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI5_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI5_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI5_TRIG, IPI6, 9, 1)
    FIELD(IPI5_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI5_TRIG, IPI5, 7, 1)
    FIELD(IPI5_TRIG, IPI4, 6, 1)
    FIELD(IPI5_TRIG, IPI3, 5, 1)
    FIELD(IPI5_TRIG, IPI2, 4, 1)
    FIELD(IPI5_TRIG, IPI1, 3, 1)
    FIELD(IPI5_TRIG, IPI0, 2, 1)
    FIELD(IPI5_TRIG, PMC, 1, 1)
    FIELD(IPI5_TRIG, PSM, 0, 1)
REG32(IPI5_OBS, 0x80004)
    FIELD(IPI5_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI5_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI5_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI5_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI5_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI5_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI5_OBS, IPI6, 9, 1)
    FIELD(IPI5_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI5_OBS, IPI5, 7, 1)
    FIELD(IPI5_OBS, IPI4, 6, 1)
    FIELD(IPI5_OBS, IPI3, 5, 1)
    FIELD(IPI5_OBS, IPI2, 4, 1)
    FIELD(IPI5_OBS, IPI1, 3, 1)
    FIELD(IPI5_OBS, IPI0, 2, 1)
    FIELD(IPI5_OBS, PMC, 1, 1)
    FIELD(IPI5_OBS, PSM, 0, 1)
REG32(IPI5_ISR, 0x80010)
    FIELD(IPI5_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI5_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI5_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI5_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI5_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI5_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI5_ISR, IPI6, 9, 1)
    FIELD(IPI5_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI5_ISR, IPI5, 7, 1)
    FIELD(IPI5_ISR, IPI4, 6, 1)
    FIELD(IPI5_ISR, IPI3, 5, 1)
    FIELD(IPI5_ISR, IPI2, 4, 1)
    FIELD(IPI5_ISR, IPI1, 3, 1)
    FIELD(IPI5_ISR, IPI0, 2, 1)
    FIELD(IPI5_ISR, PMC, 1, 1)
    FIELD(IPI5_ISR, PSM, 0, 1)
REG32(IPI5_IMR, 0x80014)
    FIELD(IPI5_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI5_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI5_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI5_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI5_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI5_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI5_IMR, IPI6, 9, 1)
    FIELD(IPI5_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI5_IMR, IPI5, 7, 1)
    FIELD(IPI5_IMR, IPI4, 6, 1)
    FIELD(IPI5_IMR, IPI3, 5, 1)
    FIELD(IPI5_IMR, IPI2, 4, 1)
    FIELD(IPI5_IMR, IPI1, 3, 1)
    FIELD(IPI5_IMR, IPI0, 2, 1)
    FIELD(IPI5_IMR, PMC, 1, 1)
    FIELD(IPI5_IMR, PSM, 0, 1)
REG32(IPI5_IER, 0x80018)
    FIELD(IPI5_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI5_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI5_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI5_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI5_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI5_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI5_IER, IPI6, 9, 1)
    FIELD(IPI5_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI5_IER, IPI5, 7, 1)
    FIELD(IPI5_IER, IPI4, 6, 1)
    FIELD(IPI5_IER, IPI3, 5, 1)
    FIELD(IPI5_IER, IPI2, 4, 1)
    FIELD(IPI5_IER, IPI1, 3, 1)
    FIELD(IPI5_IER, IPI0, 2, 1)
    FIELD(IPI5_IER, PMC, 1, 1)
    FIELD(IPI5_IER, PSM, 0, 1)
REG32(IPI5_IDR, 0x8001c)
    FIELD(IPI5_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI5_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI5_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI5_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI5_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI5_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI5_IDR, IPI6, 9, 1)
    FIELD(IPI5_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI5_IDR, IPI5, 7, 1)
    FIELD(IPI5_IDR, IPI4, 6, 1)
    FIELD(IPI5_IDR, IPI3, 5, 1)
    FIELD(IPI5_IDR, IPI2, 4, 1)
    FIELD(IPI5_IDR, IPI1, 3, 1)
    FIELD(IPI5_IDR, IPI0, 2, 1)
    FIELD(IPI5_IDR, PMC, 1, 1)
    FIELD(IPI5_IDR, PSM, 0, 1)
REG32(PMC_NOBUF_TRIG, 0x90000)
    FIELD(PMC_NOBUF_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(PMC_NOBUF_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(PMC_NOBUF_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(PMC_NOBUF_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(PMC_NOBUF_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(PMC_NOBUF_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(PMC_NOBUF_TRIG, IPI6, 9, 1)
    FIELD(PMC_NOBUF_TRIG, PMC_NOBUF, 8, 1)
    FIELD(PMC_NOBUF_TRIG, IPI5, 7, 1)
    FIELD(PMC_NOBUF_TRIG, IPI4, 6, 1)
    FIELD(PMC_NOBUF_TRIG, IPI3, 5, 1)
    FIELD(PMC_NOBUF_TRIG, IPI2, 4, 1)
    FIELD(PMC_NOBUF_TRIG, IPI1, 3, 1)
    FIELD(PMC_NOBUF_TRIG, IPI0, 2, 1)
    FIELD(PMC_NOBUF_TRIG, PMC, 1, 1)
    FIELD(PMC_NOBUF_TRIG, PSM, 0, 1)
REG32(PMC_NOBUF_OBS, 0x90004)
    FIELD(PMC_NOBUF_OBS, IPI_NOBUF6, 15, 1)
    FIELD(PMC_NOBUF_OBS, IPI_NOBUF5, 14, 1)
    FIELD(PMC_NOBUF_OBS, IPI_NOBUF4, 13, 1)
    FIELD(PMC_NOBUF_OBS, IPI_NOBUF3, 12, 1)
    FIELD(PMC_NOBUF_OBS, IPI_NOBUF2, 11, 1)
    FIELD(PMC_NOBUF_OBS, IPI_NOBUF1, 10, 1)
    FIELD(PMC_NOBUF_OBS, IPI6, 9, 1)
    FIELD(PMC_NOBUF_OBS, PMC_NOBUF, 8, 1)
    FIELD(PMC_NOBUF_OBS, IPI5, 7, 1)
    FIELD(PMC_NOBUF_OBS, IPI4, 6, 1)
    FIELD(PMC_NOBUF_OBS, IPI3, 5, 1)
    FIELD(PMC_NOBUF_OBS, IPI2, 4, 1)
    FIELD(PMC_NOBUF_OBS, IPI1, 3, 1)
    FIELD(PMC_NOBUF_OBS, IPI0, 2, 1)
    FIELD(PMC_NOBUF_OBS, PMC, 1, 1)
    FIELD(PMC_NOBUF_OBS, PSM, 0, 1)
REG32(PMC_NOBUF_ISR, 0x90010)
    FIELD(PMC_NOBUF_ISR, IPI_NOBUF6, 15, 1)
    FIELD(PMC_NOBUF_ISR, IPI_NOBUF5, 14, 1)
    FIELD(PMC_NOBUF_ISR, IPI_NOBUF4, 13, 1)
    FIELD(PMC_NOBUF_ISR, IPI_NOBUF3, 12, 1)
    FIELD(PMC_NOBUF_ISR, IPI_NOBUF2, 11, 1)
    FIELD(PMC_NOBUF_ISR, IPI_NOBUF1, 10, 1)
    FIELD(PMC_NOBUF_ISR, IPI6, 9, 1)
    FIELD(PMC_NOBUF_ISR, PMC_NOBUF, 8, 1)
    FIELD(PMC_NOBUF_ISR, IPI5, 7, 1)
    FIELD(PMC_NOBUF_ISR, IPI4, 6, 1)
    FIELD(PMC_NOBUF_ISR, IPI3, 5, 1)
    FIELD(PMC_NOBUF_ISR, IPI2, 4, 1)
    FIELD(PMC_NOBUF_ISR, IPI1, 3, 1)
    FIELD(PMC_NOBUF_ISR, IPI0, 2, 1)
    FIELD(PMC_NOBUF_ISR, PMC, 1, 1)
    FIELD(PMC_NOBUF_ISR, PSM, 0, 1)
REG32(PMC_NOBUF_IMR, 0x90014)
    FIELD(PMC_NOBUF_IMR, IPI_NOBUF6, 15, 1)
    FIELD(PMC_NOBUF_IMR, IPI_NOBUF5, 14, 1)
    FIELD(PMC_NOBUF_IMR, IPI_NOBUF4, 13, 1)
    FIELD(PMC_NOBUF_IMR, IPI_NOBUF3, 12, 1)
    FIELD(PMC_NOBUF_IMR, IPI_NOBUF2, 11, 1)
    FIELD(PMC_NOBUF_IMR, IPI_NOBUF1, 10, 1)
    FIELD(PMC_NOBUF_IMR, IPI6, 9, 1)
    FIELD(PMC_NOBUF_IMR, PMC_NOBUF, 8, 1)
    FIELD(PMC_NOBUF_IMR, IPI5, 7, 1)
    FIELD(PMC_NOBUF_IMR, IPI4, 6, 1)
    FIELD(PMC_NOBUF_IMR, IPI3, 5, 1)
    FIELD(PMC_NOBUF_IMR, IPI2, 4, 1)
    FIELD(PMC_NOBUF_IMR, IPI1, 3, 1)
    FIELD(PMC_NOBUF_IMR, IPI0, 2, 1)
    FIELD(PMC_NOBUF_IMR, PMC, 1, 1)
    FIELD(PMC_NOBUF_IMR, PSM, 0, 1)
REG32(PMC_NOBUF_IER, 0x90018)
    FIELD(PMC_NOBUF_IER, IPI_NOBUF6, 15, 1)
    FIELD(PMC_NOBUF_IER, IPI_NOBUF5, 14, 1)
    FIELD(PMC_NOBUF_IER, IPI_NOBUF4, 13, 1)
    FIELD(PMC_NOBUF_IER, IPI_NOBUF3, 12, 1)
    FIELD(PMC_NOBUF_IER, IPI_NOBUF2, 11, 1)
    FIELD(PMC_NOBUF_IER, IPI_NOBUF1, 10, 1)
    FIELD(PMC_NOBUF_IER, IPI6, 9, 1)
    FIELD(PMC_NOBUF_IER, PMC_NOBUF, 8, 1)
    FIELD(PMC_NOBUF_IER, IPI5, 7, 1)
    FIELD(PMC_NOBUF_IER, IPI4, 6, 1)
    FIELD(PMC_NOBUF_IER, IPI3, 5, 1)
    FIELD(PMC_NOBUF_IER, IPI2, 4, 1)
    FIELD(PMC_NOBUF_IER, IPI1, 3, 1)
    FIELD(PMC_NOBUF_IER, IPI0, 2, 1)
    FIELD(PMC_NOBUF_IER, PMC, 1, 1)
    FIELD(PMC_NOBUF_IER, PSM, 0, 1)
REG32(PMC_NOBUF_IDR, 0x9001c)
    FIELD(PMC_NOBUF_IDR, IPI_NOBUF6, 15, 1)
    FIELD(PMC_NOBUF_IDR, IPI_NOBUF5, 14, 1)
    FIELD(PMC_NOBUF_IDR, IPI_NOBUF4, 13, 1)
    FIELD(PMC_NOBUF_IDR, IPI_NOBUF3, 12, 1)
    FIELD(PMC_NOBUF_IDR, IPI_NOBUF2, 11, 1)
    FIELD(PMC_NOBUF_IDR, IPI_NOBUF1, 10, 1)
    FIELD(PMC_NOBUF_IDR, IPI6, 9, 1)
    FIELD(PMC_NOBUF_IDR, PMC_NOBUF, 8, 1)
    FIELD(PMC_NOBUF_IDR, IPI5, 7, 1)
    FIELD(PMC_NOBUF_IDR, IPI4, 6, 1)
    FIELD(PMC_NOBUF_IDR, IPI3, 5, 1)
    FIELD(PMC_NOBUF_IDR, IPI2, 4, 1)
    FIELD(PMC_NOBUF_IDR, IPI1, 3, 1)
    FIELD(PMC_NOBUF_IDR, IPI0, 2, 1)
    FIELD(PMC_NOBUF_IDR, PMC, 1, 1)
    FIELD(PMC_NOBUF_IDR, PSM, 0, 1)
REG32(IPI6_TRIG, 0xa0000)
    FIELD(IPI6_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI6_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI6_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI6_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI6_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI6_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI6_TRIG, IPI6, 9, 1)
    FIELD(IPI6_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI6_TRIG, IPI5, 7, 1)
    FIELD(IPI6_TRIG, IPI4, 6, 1)
    FIELD(IPI6_TRIG, IPI3, 5, 1)
    FIELD(IPI6_TRIG, IPI2, 4, 1)
    FIELD(IPI6_TRIG, IPI1, 3, 1)
    FIELD(IPI6_TRIG, IPI0, 2, 1)
    FIELD(IPI6_TRIG, PMC, 1, 1)
    FIELD(IPI6_TRIG, PSM, 0, 1)
REG32(IPI6_OBS, 0xa0004)
    FIELD(IPI6_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI6_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI6_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI6_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI6_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI6_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI6_OBS, IPI6, 9, 1)
    FIELD(IPI6_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI6_OBS, IPI5, 7, 1)
    FIELD(IPI6_OBS, IPI4, 6, 1)
    FIELD(IPI6_OBS, IPI3, 5, 1)
    FIELD(IPI6_OBS, IPI2, 4, 1)
    FIELD(IPI6_OBS, IPI1, 3, 1)
    FIELD(IPI6_OBS, IPI0, 2, 1)
    FIELD(IPI6_OBS, PMC, 1, 1)
    FIELD(IPI6_OBS, PSM, 0, 1)
REG32(IPI6_ISR, 0xa0010)
    FIELD(IPI6_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI6_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI6_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI6_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI6_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI6_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI6_ISR, IPI6, 9, 1)
    FIELD(IPI6_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI6_ISR, IPI5, 7, 1)
    FIELD(IPI6_ISR, IPI4, 6, 1)
    FIELD(IPI6_ISR, IPI3, 5, 1)
    FIELD(IPI6_ISR, IPI2, 4, 1)
    FIELD(IPI6_ISR, IPI1, 3, 1)
    FIELD(IPI6_ISR, IPI0, 2, 1)
    FIELD(IPI6_ISR, PMC, 1, 1)
    FIELD(IPI6_ISR, PSM, 0, 1)
REG32(IPI6_IMR, 0xa0014)
    FIELD(IPI6_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI6_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI6_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI6_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI6_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI6_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI6_IMR, IPI6, 9, 1)
    FIELD(IPI6_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI6_IMR, IPI5, 7, 1)
    FIELD(IPI6_IMR, IPI4, 6, 1)
    FIELD(IPI6_IMR, IPI3, 5, 1)
    FIELD(IPI6_IMR, IPI2, 4, 1)
    FIELD(IPI6_IMR, IPI1, 3, 1)
    FIELD(IPI6_IMR, IPI0, 2, 1)
    FIELD(IPI6_IMR, PMC, 1, 1)
    FIELD(IPI6_IMR, PSM, 0, 1)
REG32(IPI6_IER, 0xa0018)
    FIELD(IPI6_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI6_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI6_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI6_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI6_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI6_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI6_IER, IPI6, 9, 1)
    FIELD(IPI6_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI6_IER, IPI5, 7, 1)
    FIELD(IPI6_IER, IPI4, 6, 1)
    FIELD(IPI6_IER, IPI3, 5, 1)
    FIELD(IPI6_IER, IPI2, 4, 1)
    FIELD(IPI6_IER, IPI1, 3, 1)
    FIELD(IPI6_IER, IPI0, 2, 1)
    FIELD(IPI6_IER, PMC, 1, 1)
    FIELD(IPI6_IER, PSM, 0, 1)
REG32(IPI6_IDR, 0xa001c)
    FIELD(IPI6_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI6_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI6_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI6_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI6_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI6_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI6_IDR, IPI6, 9, 1)
    FIELD(IPI6_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI6_IDR, IPI5, 7, 1)
    FIELD(IPI6_IDR, IPI4, 6, 1)
    FIELD(IPI6_IDR, IPI3, 5, 1)
    FIELD(IPI6_IDR, IPI2, 4, 1)
    FIELD(IPI6_IDR, IPI1, 3, 1)
    FIELD(IPI6_IDR, IPI0, 2, 1)
    FIELD(IPI6_IDR, PMC, 1, 1)
    FIELD(IPI6_IDR, PSM, 0, 1)
REG32(IPI_NOBUF1_TRIG, 0xb0000)
    FIELD(IPI_NOBUF1_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI6, 9, 1)
    FIELD(IPI_NOBUF1_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI5, 7, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI4, 6, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI3, 5, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI2, 4, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI1, 3, 1)
    FIELD(IPI_NOBUF1_TRIG, IPI0, 2, 1)
    FIELD(IPI_NOBUF1_TRIG, PMC, 1, 1)
    FIELD(IPI_NOBUF1_TRIG, PSM, 0, 1)
REG32(IPI_NOBUF1_OBS, 0xb0004)
    FIELD(IPI_NOBUF1_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF1_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF1_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF1_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF1_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF1_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF1_OBS, IPI6, 9, 1)
    FIELD(IPI_NOBUF1_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF1_OBS, IPI5, 7, 1)
    FIELD(IPI_NOBUF1_OBS, IPI4, 6, 1)
    FIELD(IPI_NOBUF1_OBS, IPI3, 5, 1)
    FIELD(IPI_NOBUF1_OBS, IPI2, 4, 1)
    FIELD(IPI_NOBUF1_OBS, IPI1, 3, 1)
    FIELD(IPI_NOBUF1_OBS, IPI0, 2, 1)
    FIELD(IPI_NOBUF1_OBS, PMC, 1, 1)
    FIELD(IPI_NOBUF1_OBS, PSM, 0, 1)
REG32(IPI_NOBUF1_ISR, 0xb0010)
    FIELD(IPI_NOBUF1_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF1_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF1_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF1_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF1_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF1_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF1_ISR, IPI6, 9, 1)
    FIELD(IPI_NOBUF1_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF1_ISR, IPI5, 7, 1)
    FIELD(IPI_NOBUF1_ISR, IPI4, 6, 1)
    FIELD(IPI_NOBUF1_ISR, IPI3, 5, 1)
    FIELD(IPI_NOBUF1_ISR, IPI2, 4, 1)
    FIELD(IPI_NOBUF1_ISR, IPI1, 3, 1)
    FIELD(IPI_NOBUF1_ISR, IPI0, 2, 1)
    FIELD(IPI_NOBUF1_ISR, PMC, 1, 1)
    FIELD(IPI_NOBUF1_ISR, PSM, 0, 1)
REG32(IPI_NOBUF1_IMR, 0xb0014)
    FIELD(IPI_NOBUF1_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF1_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF1_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF1_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF1_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF1_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF1_IMR, IPI6, 9, 1)
    FIELD(IPI_NOBUF1_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF1_IMR, IPI5, 7, 1)
    FIELD(IPI_NOBUF1_IMR, IPI4, 6, 1)
    FIELD(IPI_NOBUF1_IMR, IPI3, 5, 1)
    FIELD(IPI_NOBUF1_IMR, IPI2, 4, 1)
    FIELD(IPI_NOBUF1_IMR, IPI1, 3, 1)
    FIELD(IPI_NOBUF1_IMR, IPI0, 2, 1)
    FIELD(IPI_NOBUF1_IMR, PMC, 1, 1)
    FIELD(IPI_NOBUF1_IMR, PSM, 0, 1)
REG32(IPI_NOBUF1_IER, 0xb0018)
    FIELD(IPI_NOBUF1_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF1_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF1_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF1_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF1_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF1_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF1_IER, IPI6, 9, 1)
    FIELD(IPI_NOBUF1_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF1_IER, IPI5, 7, 1)
    FIELD(IPI_NOBUF1_IER, IPI4, 6, 1)
    FIELD(IPI_NOBUF1_IER, IPI3, 5, 1)
    FIELD(IPI_NOBUF1_IER, IPI2, 4, 1)
    FIELD(IPI_NOBUF1_IER, IPI1, 3, 1)
    FIELD(IPI_NOBUF1_IER, IPI0, 2, 1)
    FIELD(IPI_NOBUF1_IER, PMC, 1, 1)
    FIELD(IPI_NOBUF1_IER, PSM, 0, 1)
REG32(IPI_NOBUF1_IDR, 0xb001c)
    FIELD(IPI_NOBUF1_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF1_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF1_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF1_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF1_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF1_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF1_IDR, IPI6, 9, 1)
    FIELD(IPI_NOBUF1_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF1_IDR, IPI5, 7, 1)
    FIELD(IPI_NOBUF1_IDR, IPI4, 6, 1)
    FIELD(IPI_NOBUF1_IDR, IPI3, 5, 1)
    FIELD(IPI_NOBUF1_IDR, IPI2, 4, 1)
    FIELD(IPI_NOBUF1_IDR, IPI1, 3, 1)
    FIELD(IPI_NOBUF1_IDR, IPI0, 2, 1)
    FIELD(IPI_NOBUF1_IDR, PMC, 1, 1)
    FIELD(IPI_NOBUF1_IDR, PSM, 0, 1)
REG32(IPI_NOBUF2_TRIG, 0xb1000)
    FIELD(IPI_NOBUF2_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI6, 9, 1)
    FIELD(IPI_NOBUF2_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI5, 7, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI4, 6, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI3, 5, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI2, 4, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI1, 3, 1)
    FIELD(IPI_NOBUF2_TRIG, IPI0, 2, 1)
    FIELD(IPI_NOBUF2_TRIG, PMC, 1, 1)
    FIELD(IPI_NOBUF2_TRIG, PSM, 0, 1)
REG32(IPI_NOBUF2_OBS, 0xb1004)
    FIELD(IPI_NOBUF2_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF2_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF2_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF2_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF2_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF2_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF2_OBS, IPI6, 9, 1)
    FIELD(IPI_NOBUF2_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF2_OBS, IPI5, 7, 1)
    FIELD(IPI_NOBUF2_OBS, IPI4, 6, 1)
    FIELD(IPI_NOBUF2_OBS, IPI3, 5, 1)
    FIELD(IPI_NOBUF2_OBS, IPI2, 4, 1)
    FIELD(IPI_NOBUF2_OBS, IPI1, 3, 1)
    FIELD(IPI_NOBUF2_OBS, IPI0, 2, 1)
    FIELD(IPI_NOBUF2_OBS, PMC, 1, 1)
    FIELD(IPI_NOBUF2_OBS, PSM, 0, 1)
REG32(IPI_NOBUF2_ISR, 0xb1010)
    FIELD(IPI_NOBUF2_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF2_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF2_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF2_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF2_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF2_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF2_ISR, IPI6, 9, 1)
    FIELD(IPI_NOBUF2_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF2_ISR, IPI5, 7, 1)
    FIELD(IPI_NOBUF2_ISR, IPI4, 6, 1)
    FIELD(IPI_NOBUF2_ISR, IPI3, 5, 1)
    FIELD(IPI_NOBUF2_ISR, IPI2, 4, 1)
    FIELD(IPI_NOBUF2_ISR, IPI1, 3, 1)
    FIELD(IPI_NOBUF2_ISR, IPI0, 2, 1)
    FIELD(IPI_NOBUF2_ISR, PMC, 1, 1)
    FIELD(IPI_NOBUF2_ISR, PSM, 0, 1)
REG32(IPI_NOBUF2_IMR, 0xb1014)
    FIELD(IPI_NOBUF2_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF2_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF2_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF2_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF2_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF2_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF2_IMR, IPI6, 9, 1)
    FIELD(IPI_NOBUF2_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF2_IMR, IPI5, 7, 1)
    FIELD(IPI_NOBUF2_IMR, IPI4, 6, 1)
    FIELD(IPI_NOBUF2_IMR, IPI3, 5, 1)
    FIELD(IPI_NOBUF2_IMR, IPI2, 4, 1)
    FIELD(IPI_NOBUF2_IMR, IPI1, 3, 1)
    FIELD(IPI_NOBUF2_IMR, IPI0, 2, 1)
    FIELD(IPI_NOBUF2_IMR, PMC, 1, 1)
    FIELD(IPI_NOBUF2_IMR, PSM, 0, 1)
REG32(IPI_NOBUF2_IER, 0xb1018)
    FIELD(IPI_NOBUF2_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF2_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF2_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF2_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF2_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF2_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF2_IER, IPI6, 9, 1)
    FIELD(IPI_NOBUF2_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF2_IER, IPI5, 7, 1)
    FIELD(IPI_NOBUF2_IER, IPI4, 6, 1)
    FIELD(IPI_NOBUF2_IER, IPI3, 5, 1)
    FIELD(IPI_NOBUF2_IER, IPI2, 4, 1)
    FIELD(IPI_NOBUF2_IER, IPI1, 3, 1)
    FIELD(IPI_NOBUF2_IER, IPI0, 2, 1)
    FIELD(IPI_NOBUF2_IER, PMC, 1, 1)
    FIELD(IPI_NOBUF2_IER, PSM, 0, 1)
REG32(IPI_NOBUF2_IDR, 0xb101c)
    FIELD(IPI_NOBUF2_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF2_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF2_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF2_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF2_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF2_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF2_IDR, IPI6, 9, 1)
    FIELD(IPI_NOBUF2_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF2_IDR, IPI5, 7, 1)
    FIELD(IPI_NOBUF2_IDR, IPI4, 6, 1)
    FIELD(IPI_NOBUF2_IDR, IPI3, 5, 1)
    FIELD(IPI_NOBUF2_IDR, IPI2, 4, 1)
    FIELD(IPI_NOBUF2_IDR, IPI1, 3, 1)
    FIELD(IPI_NOBUF2_IDR, IPI0, 2, 1)
    FIELD(IPI_NOBUF2_IDR, PMC, 1, 1)
    FIELD(IPI_NOBUF2_IDR, PSM, 0, 1)
REG32(IPI_NOBUF3_TRIG, 0xb2000)
    FIELD(IPI_NOBUF3_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI6, 9, 1)
    FIELD(IPI_NOBUF3_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI5, 7, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI4, 6, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI3, 5, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI2, 4, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI1, 3, 1)
    FIELD(IPI_NOBUF3_TRIG, IPI0, 2, 1)
    FIELD(IPI_NOBUF3_TRIG, PMC, 1, 1)
    FIELD(IPI_NOBUF3_TRIG, PSM, 0, 1)
REG32(IPI_NOBUF3_OBS, 0xb2004)
    FIELD(IPI_NOBUF3_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF3_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF3_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF3_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF3_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF3_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF3_OBS, IPI6, 9, 1)
    FIELD(IPI_NOBUF3_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF3_OBS, IPI5, 7, 1)
    FIELD(IPI_NOBUF3_OBS, IPI4, 6, 1)
    FIELD(IPI_NOBUF3_OBS, IPI3, 5, 1)
    FIELD(IPI_NOBUF3_OBS, IPI2, 4, 1)
    FIELD(IPI_NOBUF3_OBS, IPI1, 3, 1)
    FIELD(IPI_NOBUF3_OBS, IPI0, 2, 1)
    FIELD(IPI_NOBUF3_OBS, PMC, 1, 1)
    FIELD(IPI_NOBUF3_OBS, PSM, 0, 1)
REG32(IPI_NOBUF3_ISR, 0xb2010)
    FIELD(IPI_NOBUF3_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF3_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF3_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF3_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF3_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF3_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF3_ISR, IPI6, 9, 1)
    FIELD(IPI_NOBUF3_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF3_ISR, IPI5, 7, 1)
    FIELD(IPI_NOBUF3_ISR, IPI4, 6, 1)
    FIELD(IPI_NOBUF3_ISR, IPI3, 5, 1)
    FIELD(IPI_NOBUF3_ISR, IPI2, 4, 1)
    FIELD(IPI_NOBUF3_ISR, IPI1, 3, 1)
    FIELD(IPI_NOBUF3_ISR, IPI0, 2, 1)
    FIELD(IPI_NOBUF3_ISR, PMC, 1, 1)
    FIELD(IPI_NOBUF3_ISR, PSM, 0, 1)
REG32(IPI_NOBUF3_IMR, 0xb2014)
    FIELD(IPI_NOBUF3_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF3_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF3_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF3_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF3_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF3_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF3_IMR, IPI6, 9, 1)
    FIELD(IPI_NOBUF3_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF3_IMR, IPI5, 7, 1)
    FIELD(IPI_NOBUF3_IMR, IPI4, 6, 1)
    FIELD(IPI_NOBUF3_IMR, IPI3, 5, 1)
    FIELD(IPI_NOBUF3_IMR, IPI2, 4, 1)
    FIELD(IPI_NOBUF3_IMR, IPI1, 3, 1)
    FIELD(IPI_NOBUF3_IMR, IPI0, 2, 1)
    FIELD(IPI_NOBUF3_IMR, PMC, 1, 1)
    FIELD(IPI_NOBUF3_IMR, PSM, 0, 1)
REG32(IPI_NOBUF3_IER, 0xb2018)
    FIELD(IPI_NOBUF3_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF3_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF3_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF3_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF3_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF3_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF3_IER, IPI6, 9, 1)
    FIELD(IPI_NOBUF3_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF3_IER, IPI5, 7, 1)
    FIELD(IPI_NOBUF3_IER, IPI4, 6, 1)
    FIELD(IPI_NOBUF3_IER, IPI3, 5, 1)
    FIELD(IPI_NOBUF3_IER, IPI2, 4, 1)
    FIELD(IPI_NOBUF3_IER, IPI1, 3, 1)
    FIELD(IPI_NOBUF3_IER, IPI0, 2, 1)
    FIELD(IPI_NOBUF3_IER, PMC, 1, 1)
    FIELD(IPI_NOBUF3_IER, PSM, 0, 1)
REG32(IPI_NOBUF3_IDR, 0xb201c)
    FIELD(IPI_NOBUF3_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF3_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF3_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF3_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF3_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF3_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF3_IDR, IPI6, 9, 1)
    FIELD(IPI_NOBUF3_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF3_IDR, IPI5, 7, 1)
    FIELD(IPI_NOBUF3_IDR, IPI4, 6, 1)
    FIELD(IPI_NOBUF3_IDR, IPI3, 5, 1)
    FIELD(IPI_NOBUF3_IDR, IPI2, 4, 1)
    FIELD(IPI_NOBUF3_IDR, IPI1, 3, 1)
    FIELD(IPI_NOBUF3_IDR, IPI0, 2, 1)
    FIELD(IPI_NOBUF3_IDR, PMC, 1, 1)
    FIELD(IPI_NOBUF3_IDR, PSM, 0, 1)
REG32(IPI_NOBUF4_TRIG, 0xb3000)
    FIELD(IPI_NOBUF4_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI6, 9, 1)
    FIELD(IPI_NOBUF4_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI5, 7, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI4, 6, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI3, 5, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI2, 4, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI1, 3, 1)
    FIELD(IPI_NOBUF4_TRIG, IPI0, 2, 1)
    FIELD(IPI_NOBUF4_TRIG, PMC, 1, 1)
    FIELD(IPI_NOBUF4_TRIG, PSM, 0, 1)
REG32(IPI_NOBUF4_OBS, 0xb3004)
    FIELD(IPI_NOBUF4_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF4_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF4_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF4_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF4_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF4_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF4_OBS, IPI6, 9, 1)
    FIELD(IPI_NOBUF4_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF4_OBS, IPI5, 7, 1)
    FIELD(IPI_NOBUF4_OBS, IPI4, 6, 1)
    FIELD(IPI_NOBUF4_OBS, IPI3, 5, 1)
    FIELD(IPI_NOBUF4_OBS, IPI2, 4, 1)
    FIELD(IPI_NOBUF4_OBS, IPI1, 3, 1)
    FIELD(IPI_NOBUF4_OBS, IPI0, 2, 1)
    FIELD(IPI_NOBUF4_OBS, PMC, 1, 1)
    FIELD(IPI_NOBUF4_OBS, PSM, 0, 1)
REG32(IPI_NOBUF4_ISR, 0xb3010)
    FIELD(IPI_NOBUF4_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF4_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF4_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF4_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF4_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF4_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF4_ISR, IPI6, 9, 1)
    FIELD(IPI_NOBUF4_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF4_ISR, IPI5, 7, 1)
    FIELD(IPI_NOBUF4_ISR, IPI4, 6, 1)
    FIELD(IPI_NOBUF4_ISR, IPI3, 5, 1)
    FIELD(IPI_NOBUF4_ISR, IPI2, 4, 1)
    FIELD(IPI_NOBUF4_ISR, IPI1, 3, 1)
    FIELD(IPI_NOBUF4_ISR, IPI0, 2, 1)
    FIELD(IPI_NOBUF4_ISR, PMC, 1, 1)
    FIELD(IPI_NOBUF4_ISR, PSM, 0, 1)
REG32(IPI_NOBUF4_IMR, 0xb3014)
    FIELD(IPI_NOBUF4_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF4_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF4_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF4_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF4_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF4_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF4_IMR, IPI6, 9, 1)
    FIELD(IPI_NOBUF4_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF4_IMR, IPI5, 7, 1)
    FIELD(IPI_NOBUF4_IMR, IPI4, 6, 1)
    FIELD(IPI_NOBUF4_IMR, IPI3, 5, 1)
    FIELD(IPI_NOBUF4_IMR, IPI2, 4, 1)
    FIELD(IPI_NOBUF4_IMR, IPI1, 3, 1)
    FIELD(IPI_NOBUF4_IMR, IPI0, 2, 1)
    FIELD(IPI_NOBUF4_IMR, PMC, 1, 1)
    FIELD(IPI_NOBUF4_IMR, PSM, 0, 1)
REG32(IPI_NOBUF4_IER, 0xb3018)
    FIELD(IPI_NOBUF4_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF4_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF4_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF4_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF4_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF4_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF4_IER, IPI6, 9, 1)
    FIELD(IPI_NOBUF4_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF4_IER, IPI5, 7, 1)
    FIELD(IPI_NOBUF4_IER, IPI4, 6, 1)
    FIELD(IPI_NOBUF4_IER, IPI3, 5, 1)
    FIELD(IPI_NOBUF4_IER, IPI2, 4, 1)
    FIELD(IPI_NOBUF4_IER, IPI1, 3, 1)
    FIELD(IPI_NOBUF4_IER, IPI0, 2, 1)
    FIELD(IPI_NOBUF4_IER, PMC, 1, 1)
    FIELD(IPI_NOBUF4_IER, PSM, 0, 1)
REG32(IPI_NOBUF4_IDR, 0xb301c)
    FIELD(IPI_NOBUF4_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF4_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF4_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF4_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF4_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF4_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF4_IDR, IPI6, 9, 1)
    FIELD(IPI_NOBUF4_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF4_IDR, IPI5, 7, 1)
    FIELD(IPI_NOBUF4_IDR, IPI4, 6, 1)
    FIELD(IPI_NOBUF4_IDR, IPI3, 5, 1)
    FIELD(IPI_NOBUF4_IDR, IPI2, 4, 1)
    FIELD(IPI_NOBUF4_IDR, IPI1, 3, 1)
    FIELD(IPI_NOBUF4_IDR, IPI0, 2, 1)
    FIELD(IPI_NOBUF4_IDR, PMC, 1, 1)
    FIELD(IPI_NOBUF4_IDR, PSM, 0, 1)
REG32(IPI_NOBUF5_TRIG, 0xb4000)
    FIELD(IPI_NOBUF5_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI6, 9, 1)
    FIELD(IPI_NOBUF5_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI5, 7, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI4, 6, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI3, 5, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI2, 4, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI1, 3, 1)
    FIELD(IPI_NOBUF5_TRIG, IPI0, 2, 1)
    FIELD(IPI_NOBUF5_TRIG, PMC, 1, 1)
    FIELD(IPI_NOBUF5_TRIG, PSM, 0, 1)
REG32(IPI_NOBUF5_OBS, 0xb4004)
    FIELD(IPI_NOBUF5_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF5_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF5_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF5_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF5_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF5_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF5_OBS, IPI6, 9, 1)
    FIELD(IPI_NOBUF5_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF5_OBS, IPI5, 7, 1)
    FIELD(IPI_NOBUF5_OBS, IPI4, 6, 1)
    FIELD(IPI_NOBUF5_OBS, IPI3, 5, 1)
    FIELD(IPI_NOBUF5_OBS, IPI2, 4, 1)
    FIELD(IPI_NOBUF5_OBS, IPI1, 3, 1)
    FIELD(IPI_NOBUF5_OBS, IPI0, 2, 1)
    FIELD(IPI_NOBUF5_OBS, PMC, 1, 1)
    FIELD(IPI_NOBUF5_OBS, PSM, 0, 1)
REG32(IPI_NOBUF5_ISR, 0xb4010)
    FIELD(IPI_NOBUF5_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF5_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF5_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF5_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF5_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF5_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF5_ISR, IPI6, 9, 1)
    FIELD(IPI_NOBUF5_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF5_ISR, IPI5, 7, 1)
    FIELD(IPI_NOBUF5_ISR, IPI4, 6, 1)
    FIELD(IPI_NOBUF5_ISR, IPI3, 5, 1)
    FIELD(IPI_NOBUF5_ISR, IPI2, 4, 1)
    FIELD(IPI_NOBUF5_ISR, IPI1, 3, 1)
    FIELD(IPI_NOBUF5_ISR, IPI0, 2, 1)
    FIELD(IPI_NOBUF5_ISR, PMC, 1, 1)
    FIELD(IPI_NOBUF5_ISR, PSM, 0, 1)
REG32(IPI_NOBUF5_IMR, 0xb4014)
    FIELD(IPI_NOBUF5_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF5_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF5_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF5_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF5_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF5_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF5_IMR, IPI6, 9, 1)
    FIELD(IPI_NOBUF5_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF5_IMR, IPI5, 7, 1)
    FIELD(IPI_NOBUF5_IMR, IPI4, 6, 1)
    FIELD(IPI_NOBUF5_IMR, IPI3, 5, 1)
    FIELD(IPI_NOBUF5_IMR, IPI2, 4, 1)
    FIELD(IPI_NOBUF5_IMR, IPI1, 3, 1)
    FIELD(IPI_NOBUF5_IMR, IPI0, 2, 1)
    FIELD(IPI_NOBUF5_IMR, PMC, 1, 1)
    FIELD(IPI_NOBUF5_IMR, PSM, 0, 1)
REG32(IPI_NOBUF5_IER, 0xb4018)
    FIELD(IPI_NOBUF5_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF5_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF5_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF5_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF5_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF5_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF5_IER, IPI6, 9, 1)
    FIELD(IPI_NOBUF5_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF5_IER, IPI5, 7, 1)
    FIELD(IPI_NOBUF5_IER, IPI4, 6, 1)
    FIELD(IPI_NOBUF5_IER, IPI3, 5, 1)
    FIELD(IPI_NOBUF5_IER, IPI2, 4, 1)
    FIELD(IPI_NOBUF5_IER, IPI1, 3, 1)
    FIELD(IPI_NOBUF5_IER, IPI0, 2, 1)
    FIELD(IPI_NOBUF5_IER, PMC, 1, 1)
    FIELD(IPI_NOBUF5_IER, PSM, 0, 1)
REG32(IPI_NOBUF5_IDR, 0xb401c)
    FIELD(IPI_NOBUF5_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF5_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF5_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF5_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF5_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF5_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF5_IDR, IPI6, 9, 1)
    FIELD(IPI_NOBUF5_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF5_IDR, IPI5, 7, 1)
    FIELD(IPI_NOBUF5_IDR, IPI4, 6, 1)
    FIELD(IPI_NOBUF5_IDR, IPI3, 5, 1)
    FIELD(IPI_NOBUF5_IDR, IPI2, 4, 1)
    FIELD(IPI_NOBUF5_IDR, IPI1, 3, 1)
    FIELD(IPI_NOBUF5_IDR, IPI0, 2, 1)
    FIELD(IPI_NOBUF5_IDR, PMC, 1, 1)
    FIELD(IPI_NOBUF5_IDR, PSM, 0, 1)
REG32(IPI_NOBUF6_TRIG, 0xb5000)
    FIELD(IPI_NOBUF6_TRIG, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI6, 9, 1)
    FIELD(IPI_NOBUF6_TRIG, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI5, 7, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI4, 6, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI3, 5, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI2, 4, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI1, 3, 1)
    FIELD(IPI_NOBUF6_TRIG, IPI0, 2, 1)
    FIELD(IPI_NOBUF6_TRIG, PMC, 1, 1)
    FIELD(IPI_NOBUF6_TRIG, PSM, 0, 1)
REG32(IPI_NOBUF6_OBS, 0xb5004)
    FIELD(IPI_NOBUF6_OBS, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF6_OBS, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF6_OBS, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF6_OBS, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF6_OBS, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF6_OBS, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF6_OBS, IPI6, 9, 1)
    FIELD(IPI_NOBUF6_OBS, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF6_OBS, IPI5, 7, 1)
    FIELD(IPI_NOBUF6_OBS, IPI4, 6, 1)
    FIELD(IPI_NOBUF6_OBS, IPI3, 5, 1)
    FIELD(IPI_NOBUF6_OBS, IPI2, 4, 1)
    FIELD(IPI_NOBUF6_OBS, IPI1, 3, 1)
    FIELD(IPI_NOBUF6_OBS, IPI0, 2, 1)
    FIELD(IPI_NOBUF6_OBS, PMC, 1, 1)
    FIELD(IPI_NOBUF6_OBS, PSM, 0, 1)
REG32(IPI_NOBUF6_ISR, 0xb5010)
    FIELD(IPI_NOBUF6_ISR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF6_ISR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF6_ISR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF6_ISR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF6_ISR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF6_ISR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF6_ISR, IPI6, 9, 1)
    FIELD(IPI_NOBUF6_ISR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF6_ISR, IPI5, 7, 1)
    FIELD(IPI_NOBUF6_ISR, IPI4, 6, 1)
    FIELD(IPI_NOBUF6_ISR, IPI3, 5, 1)
    FIELD(IPI_NOBUF6_ISR, IPI2, 4, 1)
    FIELD(IPI_NOBUF6_ISR, IPI1, 3, 1)
    FIELD(IPI_NOBUF6_ISR, IPI0, 2, 1)
    FIELD(IPI_NOBUF6_ISR, PMC, 1, 1)
    FIELD(IPI_NOBUF6_ISR, PSM, 0, 1)
REG32(IPI_NOBUF6_IMR, 0xb5014)
    FIELD(IPI_NOBUF6_IMR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF6_IMR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF6_IMR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF6_IMR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF6_IMR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF6_IMR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF6_IMR, IPI6, 9, 1)
    FIELD(IPI_NOBUF6_IMR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF6_IMR, IPI5, 7, 1)
    FIELD(IPI_NOBUF6_IMR, IPI4, 6, 1)
    FIELD(IPI_NOBUF6_IMR, IPI3, 5, 1)
    FIELD(IPI_NOBUF6_IMR, IPI2, 4, 1)
    FIELD(IPI_NOBUF6_IMR, IPI1, 3, 1)
    FIELD(IPI_NOBUF6_IMR, IPI0, 2, 1)
    FIELD(IPI_NOBUF6_IMR, PMC, 1, 1)
    FIELD(IPI_NOBUF6_IMR, PSM, 0, 1)
REG32(IPI_NOBUF6_IER, 0xb5018)
    FIELD(IPI_NOBUF6_IER, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF6_IER, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF6_IER, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF6_IER, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF6_IER, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF6_IER, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF6_IER, IPI6, 9, 1)
    FIELD(IPI_NOBUF6_IER, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF6_IER, IPI5, 7, 1)
    FIELD(IPI_NOBUF6_IER, IPI4, 6, 1)
    FIELD(IPI_NOBUF6_IER, IPI3, 5, 1)
    FIELD(IPI_NOBUF6_IER, IPI2, 4, 1)
    FIELD(IPI_NOBUF6_IER, IPI1, 3, 1)
    FIELD(IPI_NOBUF6_IER, IPI0, 2, 1)
    FIELD(IPI_NOBUF6_IER, PMC, 1, 1)
    FIELD(IPI_NOBUF6_IER, PSM, 0, 1)
REG32(IPI_NOBUF6_IDR, 0xb501c)
    FIELD(IPI_NOBUF6_IDR, IPI_NOBUF6, 15, 1)
    FIELD(IPI_NOBUF6_IDR, IPI_NOBUF5, 14, 1)
    FIELD(IPI_NOBUF6_IDR, IPI_NOBUF4, 13, 1)
    FIELD(IPI_NOBUF6_IDR, IPI_NOBUF3, 12, 1)
    FIELD(IPI_NOBUF6_IDR, IPI_NOBUF2, 11, 1)
    FIELD(IPI_NOBUF6_IDR, IPI_NOBUF1, 10, 1)
    FIELD(IPI_NOBUF6_IDR, IPI6, 9, 1)
    FIELD(IPI_NOBUF6_IDR, PMC_NOBUF, 8, 1)
    FIELD(IPI_NOBUF6_IDR, IPI5, 7, 1)
    FIELD(IPI_NOBUF6_IDR, IPI4, 6, 1)
    FIELD(IPI_NOBUF6_IDR, IPI3, 5, 1)
    FIELD(IPI_NOBUF6_IDR, IPI2, 4, 1)
    FIELD(IPI_NOBUF6_IDR, IPI1, 3, 1)
    FIELD(IPI_NOBUF6_IDR, IPI0, 2, 1)
    FIELD(IPI_NOBUF6_IDR, PMC, 1, 1)
    FIELD(IPI_NOBUF6_IDR, PSM, 0, 1)

#define IPI_R_MAX (R_IPI_NOBUF6_IDR + 1)

#define VERSAL_NUM_MASTER_IDS 20
#define VERSAL_NET_NUM_MASTER_IDS    32

typedef struct XlnxVersalIPI {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_psm;
    qemu_irq irq_pmc;
    qemu_irq irq_ipi[7];
    qemu_irq irq_pmc_nobuf;
    qemu_irq irq_ipi_int;
    qemu_irq irq_ipi_nobuf[6];

    struct {
        uint32_t num_master_ids;
    } cfg;

    uint32_t regs[IPI_R_MAX];
    RegisterInfo regs_info[IPI_R_MAX];
} XlnxVersalIPI;

#define MAP_AGENT_TO_REG(agent, reg) \
    [R_PSM_TRIG_ ## agent ##_SHIFT] = R_ ## agent ## _ ## reg
static const hwaddr map_agent_to_isr[] = {
    MAP_AGENT_TO_REG(PSM, ISR),
    MAP_AGENT_TO_REG(PMC, ISR),
    MAP_AGENT_TO_REG(IPI0, ISR),
    MAP_AGENT_TO_REG(IPI1, ISR),
    MAP_AGENT_TO_REG(IPI2, ISR),
    MAP_AGENT_TO_REG(IPI3, ISR),
    MAP_AGENT_TO_REG(IPI4, ISR),
    MAP_AGENT_TO_REG(IPI5, ISR),
    MAP_AGENT_TO_REG(PMC_NOBUF, ISR),
    MAP_AGENT_TO_REG(IPI6, ISR),
    MAP_AGENT_TO_REG(IPI_NOBUF1, ISR),
    MAP_AGENT_TO_REG(IPI_NOBUF2, ISR),
    MAP_AGENT_TO_REG(IPI_NOBUF3, ISR),
    MAP_AGENT_TO_REG(IPI_NOBUF4, ISR),
    MAP_AGENT_TO_REG(IPI_NOBUF5, ISR),
    MAP_AGENT_TO_REG(IPI_NOBUF6, ISR),
};

static const hwaddr map_agent_to_obs[] = {
    MAP_AGENT_TO_REG(PSM, OBS),
    MAP_AGENT_TO_REG(PMC, OBS),
    MAP_AGENT_TO_REG(IPI0, OBS),
    MAP_AGENT_TO_REG(IPI1, OBS),
    MAP_AGENT_TO_REG(IPI2, OBS),
    MAP_AGENT_TO_REG(IPI3, OBS),
    MAP_AGENT_TO_REG(IPI4, OBS),
    MAP_AGENT_TO_REG(IPI5, OBS),
    MAP_AGENT_TO_REG(PMC_NOBUF, OBS),
    MAP_AGENT_TO_REG(IPI6, OBS),
    MAP_AGENT_TO_REG(IPI_NOBUF1, OBS),
    MAP_AGENT_TO_REG(IPI_NOBUF2, OBS),
    MAP_AGENT_TO_REG(IPI_NOBUF3, OBS),
    MAP_AGENT_TO_REG(IPI_NOBUF4, OBS),
    MAP_AGENT_TO_REG(IPI_NOBUF5, OBS),
    MAP_AGENT_TO_REG(IPI_NOBUF6, OBS),
};

/* This maps an IPI agents base register address to agent index.  */
static unsigned int map_base_to_agent(hwaddr addr)
{
#define MAP_BASE_TO_AGENT(agent) \
    case A_ ## agent ## _TRIG: return R_PSM_TRIG_ ## agent ## _SHIFT
    switch (addr) {
    MAP_BASE_TO_AGENT(PSM);
    MAP_BASE_TO_AGENT(PMC);
    MAP_BASE_TO_AGENT(IPI0);
    MAP_BASE_TO_AGENT(IPI1);
    MAP_BASE_TO_AGENT(IPI2);
    MAP_BASE_TO_AGENT(IPI3);
    MAP_BASE_TO_AGENT(IPI4);
    MAP_BASE_TO_AGENT(IPI5);
    MAP_BASE_TO_AGENT(PMC_NOBUF);
    MAP_BASE_TO_AGENT(IPI6);
    MAP_BASE_TO_AGENT(IPI_NOBUF1);
    MAP_BASE_TO_AGENT(IPI_NOBUF2);
    MAP_BASE_TO_AGENT(IPI_NOBUF3);
    MAP_BASE_TO_AGENT(IPI_NOBUF4);
    MAP_BASE_TO_AGENT(IPI_NOBUF5);
    MAP_BASE_TO_AGENT(IPI_NOBUF6);
    default:
        g_assert_not_reached();
    }
    return 0;
}

/* Generate all observer bits.  */
static void ipi_update_obs(XlnxVersalIPI *s)
{
    unsigned int agent2isr[] = {
        R_PSM_ISR,
        R_PMC_ISR,
        R_IPI0_ISR,
        R_IPI1_ISR,
        R_IPI2_ISR,
        R_IPI3_ISR,
        R_IPI4_ISR,
        R_IPI5_ISR,
        R_PMC_NOBUF_ISR,
        R_IPI6_ISR,
        R_IPI_NOBUF1_ISR,
        R_IPI_NOBUF2_ISR,
        R_IPI_NOBUF3_ISR,
        R_IPI_NOBUF4_ISR,
        R_IPI_NOBUF5_ISR,
        R_IPI_NOBUF6_ISR,
    };
    int num_agents = s->cfg.num_master_ids / 2;
    int agent;
    int i;

    for (agent = 0; agent < num_agents; agent++) {
        for (i = 0; i < num_agents; i++) {
            hwaddr target_obs = map_agent_to_obs[i];
            unsigned int r_isr = agent2isr[agent];
            uint32_t isr = s->regs[r_isr];
            bool active;

            active = extract32(isr, i, 1);
            s->regs[target_obs] = deposit32(s->regs[target_obs],
                                            agent, 1, active);
        }
    }
}

/* The IPIs connected between agents.  */
static void x_update_irq(XlnxVersalIPI *s)
{
    struct {
        unsigned int r_isr;
        unsigned int r_imr;
        qemu_irq *irq;
    } irqmap[] = {
        { R_PSM_ISR, R_PSM_IMR, &s->irq_psm },
        { R_PMC_ISR, R_PMC_IMR, &s->irq_pmc },
        { R_IPI0_ISR, R_IPI0_IMR, &s->irq_ipi[0] },
        { R_IPI1_ISR, R_IPI1_IMR, &s->irq_ipi[1] },
        { R_IPI2_ISR, R_IPI2_IMR, &s->irq_ipi[2] },
        { R_IPI3_ISR, R_IPI3_IMR, &s->irq_ipi[3] },
        { R_IPI4_ISR, R_IPI4_IMR, &s->irq_ipi[4] },
        { R_IPI5_ISR, R_IPI5_IMR, &s->irq_ipi[5] },
        { R_PMC_NOBUF_ISR, R_PMC_NOBUF_IMR, &s->irq_pmc_nobuf },
        { R_IPI6_ISR, R_IPI6_IMR, &s->irq_ipi[6] },
        { R_IPI_ISR, R_IPI_IMR, &s->irq_ipi_int },
        { R_IPI_NOBUF1_ISR, R_PMC_NOBUF_IMR, &s->irq_ipi_nobuf[0] },
        { R_IPI_NOBUF2_ISR, R_PMC_NOBUF_IMR, &s->irq_ipi_nobuf[1] },
        { R_IPI_NOBUF3_ISR, R_PMC_NOBUF_IMR, &s->irq_ipi_nobuf[2] },
        { R_IPI_NOBUF4_ISR, R_PMC_NOBUF_IMR, &s->irq_ipi_nobuf[3] },
        { R_IPI_NOBUF5_ISR, R_PMC_NOBUF_IMR, &s->irq_ipi_nobuf[4] },
        { R_IPI_NOBUF6_ISR, R_PMC_NOBUF_IMR, &s->irq_ipi_nobuf[5] },
    };
    int last_idx = s->cfg.num_master_ids / 2;
    int i;

    /* Update the observer registers.  */
    ipi_update_obs(s);

    /* Traverse num_agents + the IPI irq */
    for (i = 0; i <= last_idx; i++) {
        uint32_t isr = s->regs[irqmap[i].r_isr];
        uint32_t imr = s->regs[irqmap[i].r_imr];
        bool pending = isr & ~imr;

        qemu_set_irq(*irqmap[i].irq, pending);
    }
}

static uint64_t ipi_int_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    XlnxVersalIPI *s = XILINX_IPI(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IPI_ISR] |= val;
    x_update_irq(s);
    return 0;
}

static void x_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    XlnxVersalIPI *s = XILINX_IPI(reg->opaque);
    x_update_irq(s);
}

static uint64_t x_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    XlnxVersalIPI *s = XILINX_IPI(reg->opaque);
    unsigned int r_imr = reg->access->addr / 4 - 1;
    uint32_t val = val64;

    s->regs[r_imr] &= ~val;
    x_update_irq(s);
    return 0;
}

static uint64_t x_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    XlnxVersalIPI *s = XILINX_IPI(reg->opaque);
    unsigned int r_imr = reg->access->addr / 4 - 2;
    uint32_t val = val64;

    s->regs[r_imr] |= val;
    x_update_irq(s);
    return 0;
}

static void x_trig_postw(RegisterInfo *reg, uint64_t val64)
{
    XlnxVersalIPI *s = XILINX_IPI(reg->opaque);
    /*
     * Maps agent index to corresponding ISR register.
     */
    int num_agents = s->cfg.num_master_ids / 2;
    uint32_t val = val64;
    int i;

    for (i = 0; i < num_agents; i++) {
        hwaddr target_isr = map_agent_to_isr[i];
        unsigned int target_bit = map_base_to_agent(reg->access->addr);

        if (val & (1 << i)) {
            s->regs[target_isr] |= 1UL << target_bit;
        }
    }

    x_update_irq(s);
}

static const RegisterAccessInfo ipi_regs_info[] = {
    {   .name = "IPI_CTRL",  .addr = A_IPI_CTRL,
    },{ .name = "IPI_INT_TRIG",  .addr = A_IPI_INT_TRIG,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
        .pre_write = ipi_int_trig_prew,
    },{ .name = "IPI_ISR",  .addr = A_IPI_ISR,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
        .w1c = 0xff,
        .post_write = x_isr_postw,
    },{ .name = "IPI_IMR",  .addr = A_IPI_IMR,
        .reset = 0xff,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "IPI_IER",  .addr = A_IPI_IER,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
        .pre_write = x_ier_prew,
    },{ .name = "IPI_IDR",  .addr = A_IPI_IDR,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
        .pre_write = x_idr_prew,
    },{ .name = "IPI_ECO",  .addr = A_IPI_ECO,
    },{ .name = "IPI_PROT_ERR_STATUS1_LOW",  .addr = A_IPI_PROT_ERR_STATUS1_LOW,
        .rsvd = 0xfffff000,
        .ro = 0xffffffff,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    },{ .name = "IPI_PROT_CTRL",  .addr = A_IPI_PROT_CTRL,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
    },{ .name = "IPI_PROT_ERR_STATUS1",  .addr = A_IPI_PROT_ERR_STATUS1,
        .ro = 0xffffffff,
    },{ .name = "IPI_PROT_ERR_STATUS2",  .addr = A_IPI_PROT_ERR_STATUS2,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "MASTER_ID00",  .addr = A_MASTER_ID00,
        .reset = 0xa3ff0238,
        .rsvd = 0x1c00fc00,
        .ro = 0xffffffff,
    },{ .name = "MASTER_ID01",  .addr = A_MASTER_ID01,
        .reset = 0x63ff0238,
        .rsvd = 0x1c00fc00,
        .ro = 0xffffffff,
    },{ .name = "MASTER_ID02",  .addr = A_MASTER_ID02,
        .reset = 0x23ff0247,
        .rsvd = 0x1c00fc00,
        .ro = 0xffffffff,
    },{ .name = "MASTER_ID03",  .addr = A_MASTER_ID03,
        .reset = 0xe3ff0247,
        .rsvd = 0x1c00fc00,
        .ro = 0xffffffff,
    },{ .name = "MASTER_ID04",  .addr = A_MASTER_ID04,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID05",  .addr = A_MASTER_ID05,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID06",  .addr = A_MASTER_ID06,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID07",  .addr = A_MASTER_ID07,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID08",  .addr = A_MASTER_ID08,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID09",  .addr = A_MASTER_ID09,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID10",  .addr = A_MASTER_ID10,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID11",  .addr = A_MASTER_ID11,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID12",  .addr = A_MASTER_ID12,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID13",  .addr = A_MASTER_ID13,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID14",  .addr = A_MASTER_ID14,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID15",  .addr = A_MASTER_ID15,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID16",  .addr = A_MASTER_ID16,
        .reset = 0x83ff0247,
        .rsvd = 0x1c00fc00,
        .ro = 0x1fffffff,
    },{ .name = "MASTER_ID17",  .addr = A_MASTER_ID17,
        .reset = 0x43ff0247,
        .rsvd = 0x1c00fc00,
        .ro = 0x1fffffff,
    },{ .name = "MASTER_ID18",  .addr = A_MASTER_ID18,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "MASTER_ID19",  .addr = A_MASTER_ID19,
        .reset = 0x83ff0040,
        .rsvd = 0x1c00fc00,
        .ro = 0x1c00fc00,
    },{ .name = "LOCK",  .addr = A_LOCK,
    },{ .name = "IPI_ECC_CTRL",  .addr = A_IPI_ECC_CTRL,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
    },{ .name = "IPI_ECC_CE_FFA",  .addr = A_IPI_ECC_CE_FFA,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "IPI_ECC_CE_FFD",  .addr = A_IPI_ECC_CE_FFD,
        .ro = 0xffffffff,
    },{ .name = "IPI_CE_FFE",  .addr = A_IPI_CE_FFE,
        .rsvd = 0xffffff80,
        .ro = 0xffffffff,
    },{ .name = "IPI_ECC_UE_FFA",  .addr = A_IPI_ECC_UE_FFA,
        .rsvd = 0xfffffc00,
        .ro = 0xffffffff,
    },{ .name = "IPI_ECC_UE_FFD",  .addr = A_IPI_ECC_UE_FFD,
        .ro = 0xffffffff,
    },{ .name = "IPI_UE_FFE",  .addr = A_IPI_UE_FFE,
        .rsvd = 0xffffff80,
        .ro = 0xffffffff,
    },{ .name = "IPI_FI_CNTR",  .addr = A_IPI_FI_CNTR,
        .rsvd = 0xff000000,
        .ro = 0xff000000,
    },{ .name = "IPI_FI_D",  .addr = A_IPI_FI_D,
    },{ .name = "IPI_FI_S",  .addr = A_IPI_FI_S,
        .rsvd = 0xffffff80,
        .ro = 0xffffff80,
    },{ .name = "IPI_APER_TZ_000",  .addr = A_IPI_APER_TZ_000,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_001",  .addr = A_IPI_APER_TZ_001,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_002",  .addr = A_IPI_APER_TZ_002,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_003",  .addr = A_IPI_APER_TZ_003,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_004",  .addr = A_IPI_APER_TZ_004,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_005",  .addr = A_IPI_APER_TZ_005,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_006",  .addr = A_IPI_APER_TZ_006,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_007",  .addr = A_IPI_APER_TZ_007,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },{ .name = "IPI_APER_TZ_008",  .addr = A_IPI_APER_TZ_008,
        .rsvd = 0xffff0000,
        .ro = 0xffff0000,
    },

/* Macros to generate IPI registers.  */
#define GEN_IPI_REG(AGENT, REG, RO, W1C, PREW, POSTW) {      \
        .name = stringify(AGENT) "_" stringify(REG),         \
        .addr = A_ ## AGENT ## _ ## REG,                     \
        .rsvd = 0xffff0000,                                  \
        .w1c = W1C,                                          \
        .ro = RO,                                            \
        .pre_write = PREW,                                   \
        .post_write = POSTW,                                 \
    }

#define GEN_IPI_REG_ACCESS_INFO(AGENT)                              \
    GEN_IPI_REG(AGENT, TRIG, 0xffff0000, 0, NULL, x_trig_postw),    \
    GEN_IPI_REG(AGENT, OBS, 0xffffffff, 0, NULL, NULL),             \
    GEN_IPI_REG(AGENT, ISR, 0, 0xffffffff, NULL, x_isr_postw),      \
    GEN_IPI_REG(AGENT, IMR, 0xffffffff, 0, NULL, NULL),             \
    GEN_IPI_REG(AGENT, IER, 0xffff0000, 0, x_ier_prew, NULL),       \
    GEN_IPI_REG(AGENT, IDR, 0xffff0000, 0, x_idr_prew, NULL)

    GEN_IPI_REG_ACCESS_INFO(PSM),
    GEN_IPI_REG_ACCESS_INFO(PMC),
    GEN_IPI_REG_ACCESS_INFO(IPI0),
    GEN_IPI_REG_ACCESS_INFO(IPI1),
    GEN_IPI_REG_ACCESS_INFO(IPI2),
    GEN_IPI_REG_ACCESS_INFO(IPI3),
    GEN_IPI_REG_ACCESS_INFO(IPI4),
    GEN_IPI_REG_ACCESS_INFO(IPI5),
    GEN_IPI_REG_ACCESS_INFO(PMC_NOBUF),
    GEN_IPI_REG_ACCESS_INFO(IPI6),
    GEN_IPI_REG_ACCESS_INFO(IPI_NOBUF1),
    GEN_IPI_REG_ACCESS_INFO(IPI_NOBUF2),
    GEN_IPI_REG_ACCESS_INFO(IPI_NOBUF3),
    GEN_IPI_REG_ACCESS_INFO(IPI_NOBUF4),
    GEN_IPI_REG_ACCESS_INFO(IPI_NOBUF5),
    GEN_IPI_REG_ACCESS_INFO(IPI_NOBUF6),
};

static void ipi_report_error(XlnxVersalIPI *s, hwaddr addr, MemTxAttrs attrs)
{
    /* Report the failed target address.  */
    ARRAY_FIELD_DP32(s->regs, IPI_PROT_ERR_STATUS1_LOW, ADDR, addr);
    s->regs[R_IPI_PROT_ERR_STATUS1] = addr >> 11;
    /* Report the failed SMID.  */
    ARRAY_FIELD_DP32(s->regs, IPI_PROT_ERR_STATUS2, AXI_ID,
                     attrs.requester_id);
}

static bool ipi_valid_access(XlnxVersalIPI *s, hwaddr addr,
                             bool rw, MemTxAttrs attrs)
{
    bool agent_area_access = false;
    bool agent_area_access_err_mid = true;
    bool agent_area_access_err_ro = false;
    bool agent_area_access_err_tz = false;
    bool master_override = false;
    unsigned int agent_area_idx = 0;
    unsigned int r_last_mid;
    unsigned int r;

    /* Compute the agent_area.  */
    if (addr >= A_PSM_TRIG) {
        agent_area_access = true;
        agent_area_idx = addr - A_PSM_TRIG;
        agent_area_idx /= A_PMC_TRIG - A_PSM_TRIG;

        if (!ARRAY_FIELD_EX32(s->regs, IPI_PROT_CTRL, ENABLE)) {
            /* No checking.  */
            return true;
        }
    }

    r_last_mid = (s->cfg.num_master_ids == VERSAL_NUM_MASTER_IDS) ?
                  R_MASTER_ID19 : R_MASTER_ID31;

    /* First match. RW perms need come be first.  */
    for (r = R_MASTER_ID00; r <= r_last_mid; r++) {
        bool midr;
        bool override;
        uint16_t midm;
        uint16_t mid;
        bool secure;
        unsigned int prot_agent;

        /* Skip the registers in between MASTER_ID19 and MASTER_ID20 */
        if (r > R_MASTER_ID19 && r < R_MASTER_ID20) {
            continue;
        }

        midr = FIELD_EX32(s->regs[r], MASTER_ID00, MIDR);
        override = FIELD_EX32(s->regs[r], MASTER_ID00, OVERRIDEEN);
        midm = FIELD_EX32(s->regs[r], MASTER_ID00, MIDM);
        mid = FIELD_EX32(s->regs[r], MASTER_ID00, MID);

        /* 1 write and 1 read-only MASTER_ID per agent */
        if (r <= R_MASTER_ID19) {
            prot_agent = (r - R_MASTER_ID00) / (R_MASTER_ID02 - R_MASTER_ID00);
        } else {
            /* MASTER ID 20 corresond to agent 10 */
            prot_agent = 10;
            prot_agent += (r - R_MASTER_ID20) / (R_MASTER_ID02 - R_MASTER_ID00);
        }

        /* 0 = Secure, 1 = Non-Secure.  */
        secure = !extract32(s->regs[R_IPI_APER_TZ_008], prot_agent, 1);

        /* SMID Match.  */
        if ((mid & midm) == (attrs.requester_id & midm)) {
            agent_area_access_err_mid = false;

            master_override |= override;
            if (master_override && midr) {
                qemu_log_mask(LOG_GUEST_ERROR,
                              "IPI: RO Master_ID%d given override-en!\n", r);
            }

            if (agent_area_access) {
                /* Master override can access all agent areas.  */
                if (master_override) {
                    return true;
                }

                /* Is this master allowed to access a specific agent area?  */
                if (prot_agent == agent_area_idx) {
                    /* Write to read-only area?  */
                    if (rw && midr == 1) {
                        agent_area_access_err_ro = true;
                        break;
                    }

                    /* TZ miss-match?  */
                    if (attrs.secure != secure) {
                        /* Keep looking.  */
                        agent_area_access_err_tz = true;
                        break;
                    }
                    /*
                     * Looks good. Locking does not apply to agent areas
                     * so we can safely return here.
                     *
                     */
                    return true;
                }
            }
        }
    }

    if (agent_area_access) {
        qemu_log_mask(LOG_GUEST_ERROR,
                      "%s: Forbidden access to agent area\n", DEVICE(s)->id);
        ARRAY_FIELD_DP32(s->regs, IPI_ISR, APER_PERM,
                         agent_area_access_err_mid);
        ARRAY_FIELD_DP32(s->regs, IPI_ISR, MID_RO,
                         !agent_area_access_err_ro);
        ARRAY_FIELD_DP32(s->regs, IPI_ISR, APER_TZ,
                         agent_area_access_err_tz);
        ipi_report_error(s, addr, attrs);
        return false;
    }

    /* IPI Global regs only accessible to override-en and secure.  */
    if (!(master_override && attrs.secure)) {
        qemu_log_mask(LOG_GUEST_ERROR,
                      "%s: Forbidden access to global registers\n",
                      DEVICE(s)->id);
        ARRAY_FIELD_DP32(s->regs, IPI_ISR, APER_TZ, !attrs.secure);
        ipi_report_error(s, addr, attrs);
        return false;
    }

    /*
     * At this stage, the master has passed access-control.
     * Check if locking is enabled.
     *
     * Locking applies to global registers except secure access to ISR.
     */
    if (ARRAY_FIELD_EX32(s->regs, LOCK, REGWRDIS)
        && !(addr == A_IPI_ISR && attrs.secure)) {
        qemu_log_mask(LOG_GUEST_ERROR,
                      "%s: Forbidden access to locked global registers\n",
                      DEVICE(s)->id);
        ipi_report_error(s, addr, attrs);
        return false;
    }

    /* All good, allow the access.  */
    return true;
}

static MemTxResult ipi_read(void *opaque, hwaddr addr,
                            uint64_t *data, unsigned size, MemTxAttrs attrs)
{
    RegisterInfoArray *reg_array = opaque;
    XlnxVersalIPI *s = XILINX_IPI(reg_array->r[0]->opaque);
    bool hide_errors = ARRAY_FIELD_EX32(s->regs, IPI_PROT_CTRL, HIDEALLOWED);

    if (!ipi_valid_access(s, addr, false, attrs)) {
        return hide_errors ? MEMTX_OK : MEMTX_ERROR;
    }

    *data = register_read_memory(opaque, addr, size);
    return MEMTX_OK;
}

static MemTxResult ipi_write(void *opaque, hwaddr addr,
                             uint64_t data, unsigned size, MemTxAttrs attrs)
{
    RegisterInfoArray *reg_array = opaque;
    XlnxVersalIPI *s = XILINX_IPI(reg_array->r[0]->opaque);
    bool hide_errors = ARRAY_FIELD_EX32(s->regs, IPI_PROT_CTRL, HIDEALLOWED);

    if (!ipi_valid_access(s, addr, false, attrs)) {
        return hide_errors ? MEMTX_OK : MEMTX_ERROR;
    }

    register_write_memory(opaque, addr, data, size);
    return MEMTX_OK;
}

static const MemoryRegionOps ipi_ops = {
    .read_with_attrs = ipi_read,
    .write_with_attrs = ipi_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void ipi_reset(DeviceState *dev)
{
    XlnxVersalIPI *s = XILINX_IPI(dev);
    unsigned int i;
    int num_agents = s->cfg.num_master_ids / 2;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);

        switch (i) {
        case R_PSM_IMR:
        case R_PMC_IMR:
        case R_IPI0_IMR:
        case R_IPI1_IMR:
        case R_IPI2_IMR:
        case R_IPI3_IMR:
        case R_IPI4_IMR:
        case R_IPI5_IMR:
        case R_PMC_NOBUF_IMR:
        case R_IPI6_IMR:
        case R_IPI_NOBUF1_IMR:
        case R_IPI_NOBUF2_IMR:
        case R_IPI_NOBUF3_IMR:
        case R_IPI_NOBUF4_IMR:
        case R_IPI_NOBUF5_IMR:
        case R_IPI_NOBUF6_IMR:
            s->regs[i] = (1 << num_agents) - 1;
            break;
        };

    }

    x_update_irq(s);
}

static void ipi_realize(DeviceState *dev, Error **errp)
{
    XlnxVersalIPI *s = XILINX_IPI(dev);

    if (s->cfg.num_master_ids != VERSAL_NUM_MASTER_IDS &&
        s->cfg.num_master_ids != VERSAL_NET_NUM_MASTER_IDS) {
        error_setg(errp, "Number of master IDs error");
    }
}

static void ipi_init(Object *obj)
{
    XlnxVersalIPI *s = XILINX_IPI(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;
    int i;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_IPI, IPI_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), ipi_regs_info,
                              ARRAY_SIZE(ipi_regs_info),
                              s->regs_info, s->regs,
                              &ipi_ops,
                              XILINX_IPI_ERR_DEBUG,
                              IPI_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);

    sysbus_init_irq(sbd, &s->irq_psm);
    sysbus_init_irq(sbd, &s->irq_pmc);
    for (i = 0; i < ARRAY_SIZE(s->irq_ipi); i++) {
        sysbus_init_irq(sbd, &s->irq_ipi[i]);
    }
    sysbus_init_irq(sbd, &s->irq_pmc_nobuf);
    sysbus_init_irq(sbd, &s->irq_ipi_int);
    for (i = 0; i < ARRAY_SIZE(s->irq_ipi_nobuf); i++) {
        sysbus_init_irq(sbd, &s->irq_ipi_nobuf[i]);
    }
}

static Property ipi_properties[] = {
    DEFINE_PROP_UINT32("num-master-ids", XlnxVersalIPI,
                     cfg.num_master_ids, VERSAL_NUM_MASTER_IDS),
    DEFINE_PROP_END_OF_LIST(),
};

static const VMStateDescription vmstate_ipi = {
    .name = TYPE_XILINX_IPI,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, XlnxVersalIPI, IPI_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void ipi_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = ipi_reset;
    dc->vmsd = &vmstate_ipi;
    dc->realize = ipi_realize;
    device_class_set_props(dc, ipi_properties);
}

static const TypeInfo ipi_info = {
    .name          = TYPE_XILINX_IPI,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(XlnxVersalIPI),
    .class_init    = ipi_class_init,
    .instance_init = ipi_init,
};

static void ipi_register_types(void)
{
    type_register_static(&ipi_info);
}

type_init(ipi_register_types)
