/*
 * QEMU model of the LPD_SLCR Global system level control registers for the low power domain
 *
 * Copyright (c) 2014-2020 Xilinx Inc.
 *
 * Partially autogenerated by xregqemu.py 2020-02-05.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qapi/qmp/qerror.h"
#include "qapi/error.h"
#include "qemu/log.h"
#include "hw/intc/xlnx_scu_gic.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "hw/fdt_generic_util.h"

#ifndef XILINX_LPD_SLCR_ERR_DEBUG
#define XILINX_LPD_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_LPD_SLCR "xlnx.lpd-slcr"

#define XILINX_LPD_SLCR(obj) \
     OBJECT_CHECK(LPD_SLCR, (obj), TYPE_XILINX_LPD_SLCR)

REG32(WPROT0, 0x0)
    FIELD(WPROT0, ACTIVE, 0, 1)
REG32(CTRL, 0x4)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x8)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0xc)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x10)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x14)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x18)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)
REG32(ECO, 0x1c)
REG32(PERSISTENT0, 0x20)
REG32(PERSISTENT1, 0x24)
REG32(PERSISTENT2, 0x28)
REG32(PERSISTENT3, 0x2c)
REG32(PERSISTENT4, 0x30)
REG32(PERSISTENT5, 0x34)
REG32(PERSISTENT6, 0x38)
REG32(PERSISTENT7, 0x3c)
REG32(SAFETY_CHK0, 0x40)
REG32(SAFETY_CHK1, 0x44)
REG32(SAFETY_CHK2, 0x48)
REG32(SAFETY_CHK3, 0x4c)
REG32(CSUPMU_WDT_CLK_SEL, 0x50)
    FIELD(CSUPMU_WDT_CLK_SEL, SELECT, 0, 1)
REG32(ADMA_CFG, 0x0000200C)
    FIELD(ADMA_CFG, BUS_WIDTH, 5, 2)
    FIELD(ADMA_CFG, NUM_CH, 0, 5)
REG32(ADMA_RAM, 0x00002010)
    FIELD(ADMA_RAM, RAM1_EMAB, 12, 3)
    FIELD(ADMA_RAM, RAM1_EMASA, 11, 1)
    FIELD(ADMA_RAM, RAM1_EMAA, 8, 3)
    FIELD(ADMA_RAM, RAM0_EMAB, 4, 3)
    FIELD(ADMA_RAM, RAM0_EMASA, 3, 1)
    FIELD(ADMA_RAM, RAM0_EMAA, 0, 3)
REG32(ERR_AIBAXI_ISR, 0x00003000)
    FIELD(ERR_AIBAXI_ISR, AFIFS2, 28, 1)
    FIELD(ERR_AIBAXI_ISR, LPD_DDR, 27, 1)
    FIELD(ERR_AIBAXI_ISR, OCMS, 26, 1)
    FIELD(ERR_AIBAXI_ISR, FPD_MAIN, 24, 1)
    FIELD(ERR_AIBAXI_ISR, USB1S, 23, 1)
    FIELD(ERR_AIBAXI_ISR, USB0S, 22, 1)
    FIELD(ERR_AIBAXI_ISR, RPUS1, 19, 1)
    FIELD(ERR_AIBAXI_ISR, RPUS0, 18, 1)
    FIELD(ERR_AIBAXI_ISR, RPUM1, 17, 1)
    FIELD(ERR_AIBAXI_ISR, RPUM0, 16, 1)
    FIELD(ERR_AIBAXI_ISR, FPD_OCM, 3, 1)
    FIELD(ERR_AIBAXI_ISR, FPD_LPDIBS, 2, 1)
    FIELD(ERR_AIBAXI_ISR, AFIFS1, 1, 1)
    FIELD(ERR_AIBAXI_ISR, AFIFS0, 0, 1)
REG32(ERR_AIBAXI_IMR, 0x00003008)
    FIELD(ERR_AIBAXI_IMR, AFIFS2, 28, 1)
    FIELD(ERR_AIBAXI_IMR, LPD_DDR, 27, 1)
    FIELD(ERR_AIBAXI_IMR, OCMS, 26, 1)
    FIELD(ERR_AIBAXI_IMR, FPD_MAIN, 24, 1)
    FIELD(ERR_AIBAXI_IMR, USB1S, 23, 1)
    FIELD(ERR_AIBAXI_IMR, USB0S, 22, 1)
    FIELD(ERR_AIBAXI_IMR, RPUS1, 19, 1)
    FIELD(ERR_AIBAXI_IMR, RPUS0, 18, 1)
    FIELD(ERR_AIBAXI_IMR, RPUM1, 17, 1)
    FIELD(ERR_AIBAXI_IMR, RPUM0, 16, 1)
    FIELD(ERR_AIBAXI_IMR, FPD_OCM, 3, 1)
    FIELD(ERR_AIBAXI_IMR, FPD_LPDIBS, 2, 1)
    FIELD(ERR_AIBAXI_IMR, AFIFS1, 1, 1)
    FIELD(ERR_AIBAXI_IMR, AFIFS0, 0, 1)
REG32(ERR_AIBAXI_IER, 0x00003010)
    FIELD(ERR_AIBAXI_IER, AFIFS2, 28, 1)
    FIELD(ERR_AIBAXI_IER, LPD_DDR, 27, 1)
    FIELD(ERR_AIBAXI_IER, OCMS, 26, 1)
    FIELD(ERR_AIBAXI_IER, FPD_MAIN, 24, 1)
    FIELD(ERR_AIBAXI_IER, USB1S, 23, 1)
    FIELD(ERR_AIBAXI_IER, USB0S, 22, 1)
    FIELD(ERR_AIBAXI_IER, RPUS1, 19, 1)
    FIELD(ERR_AIBAXI_IER, RPUS0, 18, 1)
    FIELD(ERR_AIBAXI_IER, RPUM1, 17, 1)
    FIELD(ERR_AIBAXI_IER, RPUM0, 16, 1)
    FIELD(ERR_AIBAXI_IER, FPD_OCM, 3, 1)
    FIELD(ERR_AIBAXI_IER, FPD_LPDIBS, 2, 1)
    FIELD(ERR_AIBAXI_IER, AFIFS1, 1, 1)
    FIELD(ERR_AIBAXI_IER, AFIFS0, 0, 1)
REG32(ERR_AIBAXI_IDR, 0x00003018)
    FIELD(ERR_AIBAXI_IDR, AFIFS2, 28, 1)
    FIELD(ERR_AIBAXI_IDR, LPD_DDR, 27, 1)
    FIELD(ERR_AIBAXI_IDR, OCMS, 26, 1)
    FIELD(ERR_AIBAXI_IDR, FPD_MAIN, 24, 1)
    FIELD(ERR_AIBAXI_IDR, USB1S, 23, 1)
    FIELD(ERR_AIBAXI_IDR, USB0S, 22, 1)
    FIELD(ERR_AIBAXI_IDR, RPUS1, 19, 1)
    FIELD(ERR_AIBAXI_IDR, RPUS0, 18, 1)
    FIELD(ERR_AIBAXI_IDR, RPUM1, 17, 1)
    FIELD(ERR_AIBAXI_IDR, RPUM0, 16, 1)
    FIELD(ERR_AIBAXI_IDR, FPD_OCM, 3, 1)
    FIELD(ERR_AIBAXI_IDR, FPD_LPDIBS, 2, 1)
    FIELD(ERR_AIBAXI_IDR, AFIFS1, 1, 1)
    FIELD(ERR_AIBAXI_IDR, AFIFS0, 0, 1)
REG32(ERR_AIBAPB_ISR, 0x00003020)
    FIELD(ERR_AIBAPB_ISR, GPU, 0, 1)
REG32(ERR_AIBAPB_IMR, 0x00003024)
    FIELD(ERR_AIBAPB_IMR, GPU, 0, 1)
REG32(ERR_AIBAPB_IER, 0x00003028)
    FIELD(ERR_AIBAPB_IER, GPU, 0, 1)
REG32(ERR_AIBAPB_IDR, 0x0000302C)
    FIELD(ERR_AIBAPB_IDR, GPU, 0, 1)
REG32(ISO_AIBAXI_REQ, 0x00003030)
    FIELD(ISO_AIBAXI_REQ, AFIFS2, 28, 1)
    FIELD(ISO_AIBAXI_REQ, LPD_DDR, 27, 1)
    FIELD(ISO_AIBAXI_REQ, OCMS, 26, 1)
    FIELD(ISO_AIBAXI_REQ, FPD_MAIN, 24, 1)
    FIELD(ISO_AIBAXI_REQ, USB1S, 23, 1)
    FIELD(ISO_AIBAXI_REQ, USB0S, 22, 1)
    FIELD(ISO_AIBAXI_REQ, RPUS1, 19, 1)
    FIELD(ISO_AIBAXI_REQ, RPUS0, 18, 1)
    FIELD(ISO_AIBAXI_REQ, RPUM1, 17, 1)
    FIELD(ISO_AIBAXI_REQ, RPUM0, 16, 1)
    FIELD(ISO_AIBAXI_REQ, FPD_OCM, 3, 1)
    FIELD(ISO_AIBAXI_REQ, FPD_LPDIBS, 2, 1)
    FIELD(ISO_AIBAXI_REQ, AFIFS1, 1, 1)
    FIELD(ISO_AIBAXI_REQ, AFIFS0, 0, 1)
REG32(ISO_AIBAXI_TYPE, 0x00003038)
    FIELD(ISO_AIBAXI_TYPE, AFIFS2, 28, 1)
    FIELD(ISO_AIBAXI_TYPE, LPD_DDR, 27, 1)
    FIELD(ISO_AIBAXI_TYPE, OCMS, 26, 1)
    FIELD(ISO_AIBAXI_TYPE, FPD_MAIN, 24, 1)
    FIELD(ISO_AIBAXI_TYPE, USB1S, 23, 1)
    FIELD(ISO_AIBAXI_TYPE, USB0S, 22, 1)
    FIELD(ISO_AIBAXI_TYPE, RPUS1, 19, 1)
    FIELD(ISO_AIBAXI_TYPE, RPUS0, 18, 1)
    FIELD(ISO_AIBAXI_TYPE, RPUM1, 17, 1)
    FIELD(ISO_AIBAXI_TYPE, RPUM0, 16, 1)
    FIELD(ISO_AIBAXI_TYPE, FPD_OCM, 3, 1)
    FIELD(ISO_AIBAXI_TYPE, FPD_LPDIBS, 2, 1)
    FIELD(ISO_AIBAXI_TYPE, AFIFS1, 1, 1)
    FIELD(ISO_AIBAXI_TYPE, AFIFS0, 0, 1)
REG32(ISO_AIBAXI_ACK, 0x00003040)
    FIELD(ISO_AIBAXI_ACK, AFIFS2, 28, 1)
    FIELD(ISO_AIBAXI_ACK, LPD_DDR, 27, 1)
    FIELD(ISO_AIBAXI_ACK, OCMS, 26, 1)
    FIELD(ISO_AIBAXI_ACK, FPD_MAIN, 24, 1)
    FIELD(ISO_AIBAXI_ACK, USB1S, 23, 1)
    FIELD(ISO_AIBAXI_ACK, USB0S, 22, 1)
    FIELD(ISO_AIBAXI_ACK, RPUS1, 19, 1)
    FIELD(ISO_AIBAXI_ACK, RPUS0, 18, 1)
    FIELD(ISO_AIBAXI_ACK, RPUM1, 17, 1)
    FIELD(ISO_AIBAXI_ACK, RPUM0, 16, 1)
    FIELD(ISO_AIBAXI_ACK, FPD_OCM, 3, 1)
    FIELD(ISO_AIBAXI_ACK, FPD_LPDIBS, 2, 1)
    FIELD(ISO_AIBAXI_ACK, AFIFS1, 1, 1)
    FIELD(ISO_AIBAXI_ACK, AFIFS0, 0, 1)
REG32(ISO_AIBAPB_REQ, 0x00003048)
    FIELD(ISO_AIBAPB_REQ, GPU, 0, 1)
REG32(ISO_AIBAPB_TYPE, 0x0000304C)
    FIELD(ISO_AIBAPB_TYPE, GPU, 0, 1)
REG32(ISO_AIBAPB_ACK, 0x00003050)
    FIELD(ISO_AIBAPB_ACK, GPU, 0, 1)
REG32(ERR_ATB_ISR, 0x00006000)
    FIELD(ERR_ATB_ISR, AFIFS2, 1, 1)
    FIELD(ERR_ATB_ISR, LPDM, 0, 1)
REG32(ERR_ATB_IMR, 0x00006004)
    FIELD(ERR_ATB_IMR, AFIFS2, 1, 1)
    FIELD(ERR_ATB_IMR, LPDM, 0, 1)
REG32(ERR_ATB_IER, 0x00006008)
    FIELD(ERR_ATB_IER, AFIFS2, 1, 1)
    FIELD(ERR_ATB_IER, LPDM, 0, 1)
REG32(ERR_ATB_IDR, 0x0000600C)
    FIELD(ERR_ATB_IDR, AFIFS2, 1, 1)
    FIELD(ERR_ATB_IDR, LPDM, 0, 1)
REG32(ATB_CMD_STORE_EN, 0x00006010)
    FIELD(ATB_CMD_STORE_EN, AFIFS2, 1, 1)
    FIELD(ATB_CMD_STORE_EN, LPDM, 0, 1)
REG32(ATB_RESP_EN, 0x00006014)
    FIELD(ATB_RESP_EN, AFIFS2, 1, 1)
    FIELD(ATB_RESP_EN, LPDM, 0, 1)
REG32(ATB_RESP_TYPE, 0x00006018)
    FIELD(ATB_RESP_TYPE, AFIFS2, 1, 1)
    FIELD(ATB_RESP_TYPE, LPDM, 0, 1)
REG32(ATB_PRESCALE, 0x00006020)
    FIELD(ATB_PRESCALE, ENABLE, 16, 1)
    FIELD(ATB_PRESCALE, VALUE, 0, 16)
REG32(MUTEX0, 0x00007000)
REG32(MUTEX1, 0x00007004)
REG32(MUTEX2, 0x00007008)
REG32(MUTEX3, 0x0000700C)
REG32(GICP0_IRQ_STATUS, 0x00008000)
REG32(GICP0_IRQ_MASK, 0x00008004)
REG32(GICP0_IRQ_ENABLE, 0x00008008)
REG32(GICP0_IRQ_DISABLE, 0x0000800C)
REG32(GICP0_IRQ_TRIGGER, 0x00008010)
REG32(GICP1_IRQ_STATUS, 0x00008014)
REG32(GICP1_IRQ_MASK, 0x00008018)
REG32(GICP1_IRQ_ENABLE, 0x0000801C)
REG32(GICP1_IRQ_DISABLE, 0x00008020)
REG32(GICP1_IRQ_TRIGGER, 0x00008024)
REG32(GICP2_IRQ_STATUS, 0x00008028)
REG32(GICP2_IRQ_MASK, 0x0000802C)
REG32(GICP2_IRQ_ENABLE, 0x00008030)
REG32(GICP2_IRQ_DISABLE, 0x00008034)
REG32(GICP2_IRQ_TRIGGER, 0x00008038)
REG32(GICP3_IRQ_STATUS, 0x0000803C)
REG32(GICP3_IRQ_MASK, 0x00008040)
REG32(GICP3_IRQ_ENABLE, 0x00008044)
REG32(GICP3_IRQ_DISABLE, 0x00008048)
REG32(GICP3_IRQ_TRIGGER, 0x0000804C)
REG32(GICP4_IRQ_STATUS, 0x00008050)
REG32(GICP4_IRQ_MASK, 0x00008054)
REG32(GICP4_IRQ_ENABLE, 0x00008058)
REG32(GICP4_IRQ_DISABLE, 0x0000805C)
REG32(GICP4_IRQ_TRIGGER, 0x00008060)
REG32(GICP_PMU_IRQ_STATUS, 0x000080A0)
REG32(GICP_PMU_IRQ_MASK, 0x000080A4)
REG32(GICP_PMU_IRQ_ENABLE, 0x000080A8)
REG32(GICP_PMU_IRQ_DISABLE, 0x000080AC)
REG32(GICP_PMU_IRQ_TRIGGER, 0x000080B0)
REG32(AFI_FS, 0x00009000)
REG32(LPD_CCI, 0x0000A000)
    FIELD(LPD_CCI, SPARE, 28, 4)
    FIELD(LPD_CCI, QVNVNETS4, 27, 1)
    FIELD(LPD_CCI, QVNVNETS3, 26, 1)
    FIELD(LPD_CCI, QVNVNETS2, 25, 1)
    FIELD(LPD_CCI, QVNVNETS1, 24, 1)
    FIELD(LPD_CCI, QVNVNETS0, 23, 1)
    FIELD(LPD_CCI, QOSOVERRIDE, 18, 5)
    FIELD(LPD_CCI, QVNENABLE_M2, 17, 1)
    FIELD(LPD_CCI, QVNENABLE_M1, 16, 1)
    FIELD(LPD_CCI, STRIPING_GRANULE, 13, 3)
    FIELD(LPD_CCI, ACCHANNELEN4, 12, 1)
    FIELD(LPD_CCI, ACCHANNELEN3, 11, 1)
    FIELD(LPD_CCI, ACCHANNELEN0, 10, 1)
    FIELD(LPD_CCI, ECOREVNUM, 6, 4)
    FIELD(LPD_CCI, ASA2, 5, 1)
    FIELD(LPD_CCI, ASA1, 4, 1)
    FIELD(LPD_CCI, ASA0, 3, 1)
    FIELD(LPD_CCI, OWO2, 2, 1)
    FIELD(LPD_CCI, OWO1, 1, 1)
    FIELD(LPD_CCI, OWO0, 0, 1)
REG32(LPD_CCI_ADDRMAP, 0x0000A004)
    FIELD(LPD_CCI_ADDRMAP, 15, 30, 2)
    FIELD(LPD_CCI_ADDRMAP, 14, 28, 2)
    FIELD(LPD_CCI_ADDRMAP, 13, 26, 2)
    FIELD(LPD_CCI_ADDRMAP, 12, 24, 2)
    FIELD(LPD_CCI_ADDRMAP, 11, 22, 2)
    FIELD(LPD_CCI_ADDRMAP, 10, 20, 2)
    FIELD(LPD_CCI_ADDRMAP, 9, 18, 2)
    FIELD(LPD_CCI_ADDRMAP, 8, 16, 2)
    FIELD(LPD_CCI_ADDRMAP, 7, 14, 2)
    FIELD(LPD_CCI_ADDRMAP, 6, 12, 2)
    FIELD(LPD_CCI_ADDRMAP, 5, 10, 2)
    FIELD(LPD_CCI_ADDRMAP, 4, 8, 2)
    FIELD(LPD_CCI_ADDRMAP, 3, 6, 2)
    FIELD(LPD_CCI_ADDRMAP, 2, 4, 2)
    FIELD(LPD_CCI_ADDRMAP, 1, 2, 2)
    FIELD(LPD_CCI_ADDRMAP, 0, 0, 2)
REG32(LPD_CCI_QVNPREALLOC, 0x0000A008)
    FIELD(LPD_CCI_QVNPREALLOC, WM2, 20, 4)
    FIELD(LPD_CCI_QVNPREALLOC, WM1, 16, 4)
    FIELD(LPD_CCI_QVNPREALLOC, RM2, 8, 4)
    FIELD(LPD_CCI_QVNPREALLOC, RM1, 4, 4)
REG32(LPD_SMMU, 0x0000A020)
    FIELD(LPD_SMMU, INTEG_SEC_OVERRIDE, 7, 1)
    FIELD(LPD_SMMU, CTTW, 6, 1)
    FIELD(LPD_SMMU, SYSBARDISABLE_TBU5, 5, 1)
    FIELD(LPD_SMMU, SYSBARDISABLE_TBU4, 4, 1)
    FIELD(LPD_SMMU, SYSBARDISABLE_TBU3, 3, 1)
    FIELD(LPD_SMMU, SYSBARDISABLE_TBU2, 2, 1)
    FIELD(LPD_SMMU, SYSBARDISABLE_TBU1, 1, 1)
    FIELD(LPD_SMMU, SYSBARDISABLE_TBU0, 0, 1)
REG32(LPD_APU, 0x0000A040)
    FIELD(LPD_APU, BRDC_BARRIER, 3, 1)
    FIELD(LPD_APU, BRDC_CMNT, 2, 1)
    FIELD(LPD_APU, BRDC_INNER, 1, 1)
    FIELD(LPD_APU, BRDC_OUTER, 0, 1)

#define R_MAX (R_LPD_APU + 1)

#define OFFSET_TO_BANK(offset) (((offset >> 2) - R_GICP0_IRQ_STATUS)           \
                                / (R_GICP1_IRQ_STATUS - R_GICP0_IRQ_STATUS))
#define GIC_IRQ_STATUS(n) (R_GICP0_IRQ_STATUS + (0x14 >> 2) * (n))

typedef struct LPD_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_isr;

    /* GIC associated to the RPUs. */
    XlnxSCUGICState *rpu_gic;
    /* GIC associated to the APUs. */
    XlnxSCUGICState *apu_gic;

    uint32_t regs[R_MAX];
    RegisterInfo regs_info[R_MAX];
} LPD_SLCR;

/*
 * This allows to enable/disable the write.
 * All protected register have to set that as a pre_write callback.
 */
static uint64_t protection_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    bool w_dis = ARRAY_FIELD_EX32(s->regs, WPROT0, ACTIVE);

    if (w_dis) {
        val64 = s->regs[reg->access->addr >> 2];
    }

    return val64;
}

static void isr_update_irq(LPD_SLCR *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_isr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    isr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = protection_prew(reg, val64);

    s->regs[R_IMR] &= ~val;
    isr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = protection_prew(reg, val64);

    s->regs[R_IMR] |= val;
    isr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = protection_prew(reg, val64);

    s->regs[R_ISR] |= val;
    isr_update_irq(s);
    return 0;
}

static uint64_t mutex_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = protection_prew(reg, val64);

    if (!val) {
        return 0;
    } else if (!s->regs[reg->access->addr >> 2]) {
        return val;
    } else {
        return s->regs[reg->access->addr >> 2];
    }
}

/* RPU, APU IRQ injection callbacks. */
static void lpd_slcr_peripheral_irq_update(LPD_SLCR *s, uint8_t bank)
{
    xlnx_scu_gic_set_intr(s->rpu_gic, bank, s->regs[GIC_IRQ_STATUS(bank)], 1);
    xlnx_scu_gic_set_intr(s->apu_gic, bank, s->regs[GIC_IRQ_STATUS(bank)], 1);
}

static uint64_t lpd_slcr_ier_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = protection_prew(reg, val64);
    uint32_t mask_offset = (reg->access->addr >> 2)
                         - (R_GICP0_IRQ_ENABLE - R_GICP0_IRQ_MASK);

    s->regs[mask_offset] &= ~val;
    return 0;
}

static uint64_t lpd_slcr_idr_prew(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = protection_prew(reg, val64);
    uint32_t mask_offset = (reg->access->addr >> 2)
                         - (R_GICP0_IRQ_DISABLE - R_GICP0_IRQ_MASK);

    s->regs[mask_offset] |= val;
    return 0;
}

static void lpd_slcr_inttrig_posw(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);
    uint32_t val = val64;
    uint32_t mask_offset = (reg->access->addr >> 2)
                         - (R_GICP0_IRQ_TRIGGER - R_GICP0_IRQ_MASK);
    uint32_t status_offset = (reg->access->addr >> 2)
                           - (R_GICP0_IRQ_TRIGGER - R_GICP0_IRQ_STATUS);
    uint32_t enable = ~(s->regs[mask_offset]) & val;
    s->regs[status_offset] |= enable;

    lpd_slcr_peripheral_irq_update(s, OFFSET_TO_BANK(reg->access->addr));
}

static void lpd_slcr_intstatus_posw(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);

    lpd_slcr_peripheral_irq_update(s, OFFSET_TO_BANK(reg->access->addr));
}

static void iso_aibaxi_req_postw(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);

    bool w_dis = ARRAY_FIELD_EX32(s->regs, WPROT0, ACTIVE);

    if (!w_dis) {
        s->regs[R_ISO_AIBAXI_ACK] = val64;
    }
}

static void iso_aibapb_req_postw(RegisterInfo *reg, uint64_t val64)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(reg->opaque);

    bool w_dis = ARRAY_FIELD_EX32(s->regs, WPROT0, ACTIVE);

    if (!w_dis) {
        s->regs[R_ISO_AIBAPB_ACK] = val64;
    }
}

static RegisterAccessInfo lpd_slcr_regs_info[] = {
    {   .name = "WPROT0",  .addr = A_WPROT0,
        .reset = 0x1,
    },{ .name = "CTRL",  .addr = A_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x1,
        .post_write = isr_postw,
        .pre_write = protection_prew,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .ro = 0x1,
        .pre_write = protection_prew,
    },{ .name = "IER",  .addr = A_IER,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .pre_write = itr_prew,
    },{ .name = "ECO",  .addr = A_ECO,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT0",  .addr = A_PERSISTENT0,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT1",  .addr = A_PERSISTENT1,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT2",  .addr = A_PERSISTENT2,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT3",  .addr = A_PERSISTENT3,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT4",  .addr = A_PERSISTENT4,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT5",  .addr = A_PERSISTENT5,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT6",  .addr = A_PERSISTENT6,
        .pre_write = protection_prew,
    },{ .name = "PERSISTENT7",  .addr = A_PERSISTENT7,
        .pre_write = protection_prew,
    },{ .name = "SAFETY_CHK0",  .addr = A_SAFETY_CHK0,
        .pre_write = protection_prew,
    },{ .name = "SAFETY_CHK1",  .addr = A_SAFETY_CHK1,
        .pre_write = protection_prew,
    },{ .name = "SAFETY_CHK2",  .addr = A_SAFETY_CHK2,
        .pre_write = protection_prew,
    },{ .name = "SAFETY_CHK3",  .addr = A_SAFETY_CHK3,
        .pre_write = protection_prew,
    },{ .name = "CSUPMU_WDT_CLK_SEL", .addr = A_CSUPMU_WDT_CLK_SEL,
        .reset = 0,
        .ro = 0xFFFFFFFE,
        .pre_write = protection_prew,
    },{ .name = "ADMA_CFG", .addr = A_ADMA_CFG,
        .reset = 0x00000028,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ADMA_RAM", .addr = A_ADMA_RAM,
        .reset = 0x00003B3B,
        .ro = 0xFFFFFF00,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAXI_ISR", .addr = A_ERR_AIBAXI_ISR,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
    },{ .name = "ERR_AIBAXI_IMR", .addr = A_ERR_AIBAXI_IMR,
        .reset = 0x1DCF000F,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAXI_IER", .addr = A_ERR_AIBAXI_IER,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAXI_IDR", .addr = A_ERR_AIBAXI_IDR,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAPB_ISR", .addr = A_ERR_AIBAPB_ISR,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAPB_IMR", .addr = A_ERR_AIBAPB_IMR,
        .reset = 0x00000001,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAPB_IER", .addr = A_ERR_AIBAPB_IER,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ERR_AIBAPB_IDR", .addr = A_ERR_AIBAPB_IDR,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ISO_AIBAXI_REQ", .addr = A_ISO_AIBAXI_REQ,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = iso_aibaxi_req_postw,
    },{ .name = "ISO_AIBAXI_TYPE", .addr = A_ISO_AIBAXI_TYPE,
        .reset = 0x19CF000F,
        .pre_write = protection_prew,
    },{ .name = "ISO_AIBAXI_ACK", .addr = A_ISO_AIBAXI_ACK,
        .reset = 0,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ISO_AIBAPB_REQ", .addr = A_ISO_AIBAPB_REQ,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = iso_aibapb_req_postw,
    },{ .name = "ISO_AIBAPB_TYPE", .addr = A_ISO_AIBAPB_TYPE,
        .reset = 0x00000001,
        .pre_write = protection_prew,
    },{ .name = "ISO_AIBAPB_ACK", .addr = A_ISO_AIBAPB_ACK,
        .reset = 0,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ERR_ATB_ISR", .addr = A_ERR_ATB_ISR,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ERR_ATB_IMR", .addr = A_ERR_ATB_IMR,
        .reset = 0x00000003,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "ERR_ATB_IER", .addr = A_ERR_ATB_IER,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ERR_ATB_IDR", .addr = A_ERR_ATB_IDR,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ATB_CMD_STORE_EN", .addr = A_ATB_CMD_STORE_EN,
        .reset = 0x00000003,
        .pre_write = protection_prew,
    },{ .name = "ATB_RESP_EN", .addr = A_ATB_RESP_EN,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "ATB_RESP_TYPE", .addr = A_ATB_RESP_TYPE,
        .reset = 0x00000003,
        .pre_write = protection_prew,
    },{ .name = "ATB_PRESCALE", .addr = A_ATB_PRESCALE,
        .reset = 0x0000FFFF,
        .pre_write = protection_prew,
    },{ .name = "MUTEX0", .addr = A_MUTEX0,
        .reset = 0,
        .pre_write = mutex_prew,
    },{ .name = "MUTEX1", .addr = A_MUTEX1,
        .reset = 0,
        .pre_write = mutex_prew,
    },{ .name = "MUTEX2", .addr = A_MUTEX2,
        .reset = 0,
        .pre_write = mutex_prew,
    },{ .name = "MUTEX3", .addr = A_MUTEX3,
        .reset = 0,
        .pre_write = mutex_prew,
    },{ .name = "GICP0_IRQ_STATUS", .addr = A_GICP0_IRQ_STATUS,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_intstatus_posw,
    },{ .name = "GICP0_IRQ_MASK", .addr = A_GICP0_IRQ_MASK,
        .reset = 0xFFFFFFFF,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "GICP0_IRQ_ENABLE", .addr = A_GICP0_IRQ_ENABLE,
        .reset = 0,
        .pre_write = lpd_slcr_ier_prew,
    },{ .name = "GICP0_IRQ_DISABLE", .addr = A_GICP0_IRQ_DISABLE,
        .reset = 0,
        .pre_write = lpd_slcr_idr_prew,
    },{ .name = "GICP0_IRQ_TRIGGER", .addr = A_GICP0_IRQ_TRIGGER,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_inttrig_posw,
    },{ .name = "GICP1_IRQ_STATUS", .addr = A_GICP1_IRQ_STATUS,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_intstatus_posw,
    },{ .name = "GICP1_IRQ_MASK", .addr = A_GICP1_IRQ_MASK,
        .reset = 0xFFFFFFFF,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "GICP1_IRQ_ENABLE", .addr = A_GICP1_IRQ_ENABLE,
        .reset = 0,
        .pre_write = lpd_slcr_ier_prew,
    },{ .name = "GICP1_IRQ_DISABLE", .addr = A_GICP1_IRQ_DISABLE,
        .reset = 0,
        .pre_write = lpd_slcr_idr_prew,
    },{ .name = "GICP1_IRQ_TRIGGER", .addr = A_GICP1_IRQ_TRIGGER,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_inttrig_posw,
    },{ .name = "GICP2_IRQ_STATUS", .addr = A_GICP2_IRQ_STATUS,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_intstatus_posw,
    },{ .name = "GICP2_IRQ_MASK", .addr = A_GICP2_IRQ_MASK,
        .reset = 0xFFFFFFFF,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "GICP2_IRQ_ENABLE", .addr = A_GICP2_IRQ_ENABLE,
        .reset = 0,
        .pre_write = lpd_slcr_ier_prew,
    },{ .name = "GICP2_IRQ_DISABLE", .addr = A_GICP2_IRQ_DISABLE,
        .reset = 0,
        .pre_write = lpd_slcr_idr_prew,
    },{ .name = "GICP2_IRQ_TRIGGER", .addr = A_GICP2_IRQ_TRIGGER,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_inttrig_posw,
    },{ .name = "GICP3_IRQ_STATUS", .addr = A_GICP3_IRQ_STATUS,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_intstatus_posw,
    },{ .name = "GICP3_IRQ_MASK", .addr = A_GICP3_IRQ_MASK,
        .reset = 0xFFFFFFFF,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "GICP3_IRQ_ENABLE", .addr = A_GICP3_IRQ_ENABLE,
        .reset = 0,
        .pre_write = lpd_slcr_ier_prew,
    },{ .name = "GICP3_IRQ_DISABLE", .addr = A_GICP3_IRQ_DISABLE,
        .reset = 0,
        .pre_write = lpd_slcr_idr_prew,
    },{ .name = "GICP3_IRQ_TRIGGER", .addr = A_GICP3_IRQ_TRIGGER,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_inttrig_posw,
    },{ .name = "GICP4_IRQ_STATUS", .addr = A_GICP4_IRQ_STATUS,
        .reset = 0,
        .w1c = 0xFFFFFFFF,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_intstatus_posw,
    },{ .name = "GICP4_IRQ_MASK", .addr = A_GICP4_IRQ_MASK,
        .reset = 0xFFFFFFFF,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "GICP4_IRQ_ENABLE", .addr = A_GICP4_IRQ_ENABLE,
        .reset = 0,
        .pre_write = lpd_slcr_ier_prew,
    },{ .name = "GICP4_IRQ_DISABLE", .addr = A_GICP4_IRQ_DISABLE,
        .reset = 0,
        .pre_write = lpd_slcr_idr_prew,
    },{ .name = "GICP4_IRQ_TRIGGER", .addr = A_GICP4_IRQ_TRIGGER,
        .reset = 0,
        .pre_write = protection_prew,
        .post_write = lpd_slcr_inttrig_posw,
    },{ .name = "GICP_PMU_IRQ_STATUS", .addr = A_GICP_PMU_IRQ_STATUS,
        .reset = 0,
        .pre_write = protection_prew,
        .w1c = 0xFFFFFFFF,
    },{ .name = "GICP_PMU_IRQ_MASK", .addr = A_GICP_PMU_IRQ_MASK,
        .reset = 0x000000FF,
        .ro = 0xFFFFFFFF,
        .pre_write = protection_prew,
    },{ .name = "GICP_PMU_IRQ_ENABLE", .addr = A_GICP_PMU_IRQ_ENABLE,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "GICP_PMU_IRQ_DISABLE", .addr = A_GICP_PMU_IRQ_DISABLE,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "GICP_PMU_IRQ_TRIGGER", .addr = A_GICP_PMU_IRQ_TRIGGER,
        .reset = 0,
        .pre_write = protection_prew,
    },{ .name = "AFI_FS", .addr = A_AFI_FS,
        .reset = 0x00000200,
        .pre_write = protection_prew,
    },{ .name = "LPD_CCI", .addr = A_LPD_CCI,
        .reset = 0x03801C07,
        .pre_write = protection_prew,
    },{ .name = "LPD_CCI_ADDRMAP", .addr = A_LPD_CCI_ADDRMAP,
        .reset = 0x00C000FF,
        .pre_write = protection_prew,
    },{ .name = "LPD_CCI_QVNPREALLOC", .addr = A_LPD_CCI_QVNPREALLOC,
        .reset = 0x00330330,
        .ro = 0x0000F00F,
        .pre_write = protection_prew,
    },{ .name = "LPD_SMMU", .addr = A_LPD_SMMU,
        .reset = 0x0000003F,
        .pre_write = protection_prew,
    },{ .name = "LPD_APU", .addr = A_LPD_APU,
        .reset = 0x00000001,
        .pre_write = protection_prew,
    },
};

static void lpd_slcr_reset(DeviceState *dev)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    isr_update_irq(s);
}

static const MemoryRegionOps lpd_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void lpd_slcr_realize(DeviceState *dev, Error **errp)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(dev);

    if (!s->rpu_gic) {
        error_set(errp, ERROR_CLASS_GENERIC_ERROR, "gic-for-rpu");
        return;
    }

    if (!s->apu_gic) {
        error_set(errp, ERROR_CLASS_GENERIC_ERROR, "gic-for-apu");
        return;
    }
}

static void lpd_slcr_init(Object *obj)
{
    LPD_SLCR *s = XILINX_LPD_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_LPD_SLCR, R_MAX * 4);

    reg_array =
        register_init_block32(DEVICE(obj), lpd_slcr_regs_info,
                              ARRAY_SIZE(lpd_slcr_regs_info),
                              s->regs_info, s->regs,
                              &lpd_slcr_ops,
                              XILINX_LPD_SLCR_ERR_DEBUG,
                              R_MAX * 4);
    memory_region_add_subregion(&s->iomem, 0x0, &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_isr);

    /* Link to the GIC which allow to inject irq through registers.
     */
    object_property_add_link(obj, "gic-for-rpu", TYPE_XLNX_SCU_GIC,
                             (Object **)&s->rpu_gic,
                             qdev_prop_allow_set_link_before_realize,
                             OBJ_PROP_LINK_STRONG);
    object_property_add_link(obj, "gic-for-apu", TYPE_XLNX_SCU_GIC,
                             (Object **)&s->apu_gic,
                             qdev_prop_allow_set_link_before_realize,
                             OBJ_PROP_LINK_STRONG);
}

static const VMStateDescription vmstate_lpd_slcr = {
    .name = TYPE_XILINX_LPD_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, LPD_SLCR, R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void lpd_slcr_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = lpd_slcr_reset;
    dc->realize = lpd_slcr_realize;
    dc->vmsd = &vmstate_lpd_slcr;
}

static const TypeInfo lpd_slcr_info = {
    .name          = TYPE_XILINX_LPD_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(LPD_SLCR),
    .class_init    = lpd_slcr_class_init,
    .instance_init = lpd_slcr_init,
};

static void lpd_slcr_register_types(void)
{
    type_register_static(&lpd_slcr_info);
}

type_init(lpd_slcr_register_types)
