/*
 * QEMU model of the MMI_CRX MMI Clock and Reset Control Registers
 *
 * Copyright (c) 2024 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2024-11-21.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_MMI_CRX_ERR_DEBUG
#define XILINX_MMI_CRX_ERR_DEBUG 0
#endif

#define TYPE_XILINX_MMI_CRX "xlnx.mmi_crx"

#define XILINX_MMI_CRX(obj) \
     OBJECT_CHECK(MMI_CRX, (obj), TYPE_XILINX_MMI_CRX)

REG32(REG_CTRL, 0x0)
    FIELD(REG_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0x4)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x8)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0xc)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x10)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(WPROTS, 0x30)
    FIELD(WPROTS, ACTIVE, 0, 1)
REG32(WPROTP, 0x34)
    FIELD(WPROTP, ACTIVE, 0, 1)
REG32(MMIPLL_CTRL, 0x40)
    FIELD(MMIPLL_CTRL, POST_SRC, 24, 3)
    FIELD(MMIPLL_CTRL, PRE_SRC, 20, 3)
    FIELD(MMIPLL_CTRL, CLKOUTDIV, 16, 2)
    FIELD(MMIPLL_CTRL, FBDIV, 8, 8)
    FIELD(MMIPLL_CTRL, BYPASS, 3, 1)
    FIELD(MMIPLL_CTRL, RESET, 0, 1)
REG32(MMIPLL_CFG, 0x44)
    FIELD(MMIPLL_CFG, LOCK_DLY, 25, 7)
    FIELD(MMIPLL_CFG, LOCK_CNT, 13, 10)
    FIELD(MMIPLL_CFG, LFHF, 10, 2)
    FIELD(MMIPLL_CFG, CP, 5, 4)
    FIELD(MMIPLL_CFG, RES, 0, 4)
REG32(PLL_STATUS, 0x50)
    FIELD(PLL_STATUS, MMIPLL_STABLE, 2, 1)
    FIELD(PLL_STATUS, MMIPLL_LOCK, 0, 1)
REG32(MMI_GPU_REF_CTRL, 0x100)
    FIELD(MMI_GPU_REF_CTRL, CLKACT, 25, 1)
    FIELD(MMI_GPU_REF_CTRL, DIVISOR0, 8, 10)
REG32(MMI_DBG_REF_CTRL, 0x108)
    FIELD(MMI_DBG_REF_CTRL, CLKACT, 25, 1)
    FIELD(MMI_DBG_REF_CTRL, DIVISOR0, 8, 10)
REG32(SAFETY_CHK, 0x150)
REG32(RST_DBG, 0x300)
    FIELD(RST_DBG, RESET, 0, 1)
REG32(RST_PCIE0, 0x304)
    FIELD(RST_PCIE0, PER_RESET, 1, 1)
    FIELD(RST_PCIE0, RESET, 0, 1)
REG32(RST_PCIE1, 0x308)
    FIELD(RST_PCIE1, PER_RESET, 1, 1)
    FIELD(RST_PCIE1, RESET, 0, 1)
REG32(RST_GTY, 0x30c)
    FIELD(RST_GTY, RESET3, 2, 1)
    FIELD(RST_GTY, RESET2, 1, 1)
    FIELD(RST_GTY, RESET1, 0, 1)
REG32(RST_GEM, 0x310)
    FIELD(RST_GEM, CFG_RESET, 2, 1)
    FIELD(RST_GEM, TSU_RESET, 1, 1)
    FIELD(RST_GEM, RESET, 0, 1)
REG32(RST_PCIE_GEM, 0x314)
    FIELD(RST_PCIE_GEM, SS_CFG_POR, 0, 1)
REG32(RST_DC, 0x318)
    FIELD(RST_DC, SS_CFG_POR, 1, 1)
    FIELD(RST_DC, RESET, 0, 1)
REG32(RST_GPU, 0x31c)
    FIELD(RST_GPU, RECOV_RESET, 1, 1)
    FIELD(RST_GPU, RESET, 0, 1)
REG32(RST_UDH, 0x320)
    FIELD(RST_UDH, SS_CFG_POR, 12, 1)
    FIELD(RST_UDH, TRNG2HDCP_RESET, 11, 1)
    FIELD(RST_UDH, TRNG_RESET, 10, 1)
    FIELD(RST_UDH, HDCPRAM_RESET, 8, 1)
    FIELD(RST_UDH, USB2_RESET, 7, 1)
    FIELD(RST_UDH, USB3_RESET, 5, 1)
    FIELD(RST_UDH, DRD_RESET, 3, 1)
    FIELD(RST_UDH, AUX_RESET, 2, 1)
    FIELD(RST_UDH, DP_RESET, 0, 1)
REG32(RST_SYSMON, 0x348)
    FIELD(RST_SYSMON, CFG_RST, 0, 1)

#define MMI_CRX_R_MAX (R_RST_SYSMON + 1)

typedef struct MMI_CRX {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir;

    uint32_t regs[MMI_CRX_R_MAX];
    RegisterInfo regs_info[MMI_CRX_R_MAX];
} MMI_CRX;

static void ir_update_irq(MMI_CRX *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_CRX *s = XILINX_MMI_CRX(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_CRX *s = XILINX_MMI_CRX(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_CRX *s = XILINX_MMI_CRX(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static const RegisterAccessInfo mmi_crx_regs_info[] = {
    {   .name = "REG_CTRL",  .addr = A_REG_CTRL,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_disable_prew,
    },{ .name = "WPROTS",  .addr = A_WPROTS,
        .reset = 0x1,
    },{ .name = "WPROTP",  .addr = A_WPROTP,
        .reset = 0x1,
    },{ .name = "MMIPLL_CTRL",  .addr = A_MMIPLL_CTRL,
        .reset = 0x14809,
        .rsvd = 0xf88c00f6,
        .ro = 0xf88c00f6,
    },{ .name = "MMIPLL_CFG",  .addr = A_MMIPLL_CFG,
        .reset = 0x7e5dcc6c,
        .rsvd = 0x1801210,
        .ro = 0x1801210,
    },{ .name = "PLL_STATUS",  .addr = A_PLL_STATUS,
        .reset = R_PLL_STATUS_MMIPLL_LOCK_MASK |
                 R_PLL_STATUS_MMIPLL_STABLE_MASK,
        .rsvd = 0xfa,
        .ro = 0xff,
    },{ .name = "MMI_GPU_REF_CTRL",  .addr = A_MMI_GPU_REF_CTRL,
        .reset = 0x2002500,
        .rsvd = 0xfdfc00ff,
        .ro = 0xfdfc00ff,
    },{ .name = "MMI_DBG_REF_CTRL",  .addr = A_MMI_DBG_REF_CTRL,
        .reset = 0x2500,
        .rsvd = 0xfdfc00ff,
        .ro = 0xfdfc00ff,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    },{ .name = "RST_DBG",  .addr = A_RST_DBG,
        .reset = 0x1,
    },{ .name = "RST_PCIE0",  .addr = A_RST_PCIE0,
        .reset = 0x3,
    },{ .name = "RST_PCIE1",  .addr = A_RST_PCIE1,
        .reset = 0x3,
    },{ .name = "RST_GTY",  .addr = A_RST_GTY,
        .reset = 0x7,
    },{ .name = "RST_GEM",  .addr = A_RST_GEM,
        .reset = 0x7,
    },{ .name = "RST_PCIE_GEM",  .addr = A_RST_PCIE_GEM,
        .reset = 0x1,
    },{ .name = "RST_DC",  .addr = A_RST_DC,
        .reset = 0x3,
    },{ .name = "RST_GPU",  .addr = A_RST_GPU,
        .reset = 0x3,
        .rsvd = 0x4,
    },{ .name = "RST_UDH",  .addr = A_RST_UDH,
        .reset = 0x1dad,
        .rsvd = 0x252,
    },{ .name = "RST_SYSMON",  .addr = A_RST_SYSMON,
    }
};

static void mmi_crx_reset_enter(Object *obj, ResetType type)
{
    MMI_CRX *s = XILINX_MMI_CRX(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void mmi_crx_reset_hold(Object *obj)
{
    MMI_CRX *s = XILINX_MMI_CRX(obj);

    ir_update_irq(s);
}

static const MemoryRegionOps mmi_crx_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void mmi_crx_init(Object *obj)
{
    MMI_CRX *s = XILINX_MMI_CRX(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_MMI_CRX, MMI_CRX_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), mmi_crx_regs_info,
                              ARRAY_SIZE(mmi_crx_regs_info),
                              s->regs_info, s->regs,
                              &mmi_crx_ops,
                              XILINX_MMI_CRX_ERR_DEBUG,
                              MMI_CRX_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir);
}

static const VMStateDescription vmstate_mmi_crx = {
    .name = TYPE_XILINX_MMI_CRX,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, MMI_CRX, MMI_CRX_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void mmi_crx_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_mmi_crx;
    rc->phases.enter = mmi_crx_reset_enter;
    rc->phases.hold = mmi_crx_reset_hold;
}

static const TypeInfo mmi_crx_info = {
    .name          = TYPE_XILINX_MMI_CRX,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(MMI_CRX),
    .class_init    = mmi_crx_class_init,
    .instance_init = mmi_crx_init,
};

static void mmi_crx_register_types(void)
{
    type_register_static(&mmi_crx_info);
}

type_init(mmi_crx_register_types)
