/*
 * QEMU model of the PMXC_ERR PMXC Error Management.
 *
 * Copyright (c) 2024 Advanced Micro Devices, Inc.
 *
 * Autogenerated by xregqemu.py 2024-05-31.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "hw/irq.h"
#include "migration/vmstate.h"

#ifndef XILINX_PMXC_ERR_DEBUG
#define XILINX_PMXC_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMXC_ERR "xlnx.pmxc-err-mng"

#define XILINX_PMXC_ERR(obj) \
     OBJECT_CHECK(PMXC_ERR, (obj), TYPE_XILINX_PMXC_ERR)

REG32(PMC_ERR1_STATUS, 0x0)
    FIELD(PMC_ERR1_STATUS, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR1_STATUS, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR1_STATUS, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR1_STATUS, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR1_STATUS, PL3, 27, 1)
    FIELD(PMC_ERR1_STATUS, PL2, 26, 1)
    FIELD(PMC_ERR1_STATUS, PL1, 25, 1)
    FIELD(PMC_ERR1_STATUS, PL0, 24, 1)
    FIELD(PMC_ERR1_STATUS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR1_STATUS, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR1_STATUS, GT_NCR, 21, 1)
    FIELD(PMC_ERR1_STATUS, GT_CR, 20, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR1_STATUS, ME_NCR, 17, 1)
    FIELD(PMC_ERR1_STATUS, ME_CR, 16, 1)
    FIELD(PMC_ERR1_STATUS, MMCM, 15, 1)
    FIELD(PMC_ERR1_STATUS, NOC_USER, 14, 1)
    FIELD(PMC_ERR1_STATUS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR1_STATUS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR1_STATUS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR1_STATUS, CFRAME, 7, 1)
    FIELD(PMC_ERR1_STATUS, CFU, 6, 1)
    FIELD(PMC_ERR1_STATUS, GSW_NCR, 5, 1)
    FIELD(PMC_ERR1_STATUS, GSW_CR, 4, 1)
    FIELD(PMC_ERR1_STATUS, FW_NCR, 3, 1)
    FIELD(PMC_ERR1_STATUS, FW_CR, 2, 1)
    FIELD(PMC_ERR1_STATUS, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR1_STATUS, BOOT_CR, 0, 1)
REG32(PMC_ERR2_STATUS, 0x4)
    FIELD(PMC_ERR2_STATUS, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR2_STATUS, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR2_STATUS, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR2_STATUS, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_ERR2_STATUS, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_ERR2_STATUS, RSRV_ERR0, 26, 1)
    FIELD(PMC_ERR2_STATUS, CLK_MON, 25, 1)
    FIELD(PMC_ERR2_STATUS, PPLL, 24, 1)
    FIELD(PMC_ERR2_STATUS, NPLL, 23, 1)
    FIELD(PMC_ERR2_STATUS, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR2_STATUS, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR2_STATUS, PMX_WWDT, 20, 1)
    FIELD(PMC_ERR2_STATUS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR2_STATUS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR2_STATUS, CFI, 17, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR2_STATUS, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR2_STATUS, PMC_NCR, 6, 1)
    FIELD(PMC_ERR2_STATUS, PMC_CR, 5, 1)
    FIELD(PMC_ERR2_STATUS, RSRV_ERR2, 4, 1)
    FIELD(PMC_ERR2_STATUS, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR2_STATUS, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR2_STATUS, PMC_ROM, 1, 1)
    FIELD(PMC_ERR2_STATUS, PMC_APB, 0, 1)
REG32(PMC_ERR3_STATUS, 0x8)
    FIELD(PMC_ERR3_STATUS, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_ERR3_STATUS, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_ERR3_STATUS, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_ERR3_STATUS, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_ERR3_STATUS, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_ERR3_STATUS, PMC_EAM_GD, 19, 1)
    FIELD(PMC_ERR3_STATUS, ASU_EAM_GD, 18, 1)
    FIELD(PMC_ERR3_STATUS, PSX_EAM_E3, 17, 1)
    FIELD(PMC_ERR3_STATUS, PSX_EAM_E2, 16, 1)
    FIELD(PMC_ERR3_STATUS, PSX_EAM_E1, 15, 1)
    FIELD(PMC_ERR3_STATUS, PSX_EAM_E0, 14, 1)
    FIELD(PMC_ERR3_STATUS, PCR_PAR, 13, 1)
    FIELD(PMC_ERR3_STATUS, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_ERR3_STATUS, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_ERR3_STATUS, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_ERR3_STATUS, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_ERR3_STATUS, DME_PUB_Y, 8, 1)
    FIELD(PMC_ERR3_STATUS, DME_PUB_X, 7, 1)
    FIELD(PMC_ERR3_STATUS, DEVAK_PRIV, 6, 1)
    FIELD(PMC_ERR3_STATUS, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_ERR3_STATUS, DEVIK_PRIV, 4, 1)
    FIELD(PMC_ERR3_STATUS, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_ERR3_STATUS, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_ERR3_STATUS, IOU_NCR, 1, 1)
    FIELD(PMC_ERR3_STATUS, IOU_CR, 0, 1)
REG32(PMC_ERR1_TRIG, 0x10)
    FIELD(PMC_ERR1_TRIG, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR1_TRIG, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR1_TRIG, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR1_TRIG, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR1_TRIG, PL3, 27, 1)
    FIELD(PMC_ERR1_TRIG, PL2, 26, 1)
    FIELD(PMC_ERR1_TRIG, PL1, 25, 1)
    FIELD(PMC_ERR1_TRIG, PL0, 24, 1)
    FIELD(PMC_ERR1_TRIG, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR1_TRIG, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR1_TRIG, GT_NCR, 21, 1)
    FIELD(PMC_ERR1_TRIG, GT_CR, 20, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR1_TRIG, ME_NCR, 17, 1)
    FIELD(PMC_ERR1_TRIG, ME_CR, 16, 1)
    FIELD(PMC_ERR1_TRIG, MMCM, 15, 1)
    FIELD(PMC_ERR1_TRIG, NOC_USER, 14, 1)
    FIELD(PMC_ERR1_TRIG, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR1_TRIG, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR1_TRIG, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR1_TRIG, CFRAME, 7, 1)
    FIELD(PMC_ERR1_TRIG, CFU, 6, 1)
    FIELD(PMC_ERR1_TRIG, GSW_NCR, 5, 1)
    FIELD(PMC_ERR1_TRIG, GSW_CR, 4, 1)
    FIELD(PMC_ERR1_TRIG, FW_NCR, 3, 1)
    FIELD(PMC_ERR1_TRIG, FW_CR, 2, 1)
    FIELD(PMC_ERR1_TRIG, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR1_TRIG, BOOT_CR, 0, 1)
REG32(PMC_ERR2_TRIG, 0x14)
    FIELD(PMC_ERR2_TRIG, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR2_TRIG, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR2_TRIG, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR2_TRIG, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_ERR2_TRIG, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_ERR2_TRIG, RSRV_ERR0, 26, 1)
    FIELD(PMC_ERR2_TRIG, CLK_MON, 25, 1)
    FIELD(PMC_ERR2_TRIG, PPLL, 24, 1)
    FIELD(PMC_ERR2_TRIG, NPLL, 23, 1)
    FIELD(PMC_ERR2_TRIG, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR2_TRIG, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR2_TRIG, PMX_WWDT, 20, 1)
    FIELD(PMC_ERR2_TRIG, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR2_TRIG, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR2_TRIG, CFI, 17, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR2_TRIG, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR2_TRIG, PMC_NCR, 6, 1)
    FIELD(PMC_ERR2_TRIG, PMC_CR, 5, 1)
    FIELD(PMC_ERR2_TRIG, RSRV_ERR2, 4, 1)
    FIELD(PMC_ERR2_TRIG, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR2_TRIG, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR2_TRIG, PMC_ROM, 1, 1)
    FIELD(PMC_ERR2_TRIG, PMC_APB, 0, 1)
REG32(PMC_ERR3_TRIG, 0x18)
    FIELD(PMC_ERR3_TRIG, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_ERR3_TRIG, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_ERR3_TRIG, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_ERR3_TRIG, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_ERR3_TRIG, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_ERR3_TRIG, PMC_EAM_GD, 19, 1)
    FIELD(PMC_ERR3_TRIG, ASU_EAM_GD, 18, 1)
    FIELD(PMC_ERR3_TRIG, PSX_EAM_E3, 17, 1)
    FIELD(PMC_ERR3_TRIG, PSX_EAM_E2, 16, 1)
    FIELD(PMC_ERR3_TRIG, PSX_EAM_E1, 15, 1)
    FIELD(PMC_ERR3_TRIG, PSX_EAM_E0, 14, 1)
    FIELD(PMC_ERR3_TRIG, PCR_PAR, 13, 1)
    FIELD(PMC_ERR3_TRIG, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_ERR3_TRIG, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_ERR3_TRIG, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_ERR3_TRIG, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_ERR3_TRIG, DME_PUB_Y, 8, 1)
    FIELD(PMC_ERR3_TRIG, DME_PUB_X, 7, 1)
    FIELD(PMC_ERR3_TRIG, DEVAK_PRIV, 6, 1)
    FIELD(PMC_ERR3_TRIG, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_ERR3_TRIG, DEVIK_PRIV, 4, 1)
    FIELD(PMC_ERR3_TRIG, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_ERR3_TRIG, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_ERR3_TRIG, IOU_NCR, 1, 1)
    FIELD(PMC_ERR3_TRIG, IOU_CR, 0, 1)
REG32(PMC_ERR_OUT1_MASK, 0x20)
    FIELD(PMC_ERR_OUT1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR_OUT1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR_OUT1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR_OUT1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL3, 27, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL2, 26, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL1, 25, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL0, 24, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR_OUT1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR_OUT1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_ERR_OUT1_MASK, GT_CR, 20, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR_OUT1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_ERR_OUT1_MASK, ME_CR, 16, 1)
    FIELD(PMC_ERR_OUT1_MASK, MMCM, 15, 1)
    FIELD(PMC_ERR_OUT1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_ERR_OUT1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR_OUT1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR_OUT1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR_OUT1_MASK, CFRAME, 7, 1)
    FIELD(PMC_ERR_OUT1_MASK, CFU, 6, 1)
    FIELD(PMC_ERR_OUT1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_ERR_OUT1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_ERR_OUT1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_ERR_OUT1_MASK, FW_CR, 2, 1)
    FIELD(PMC_ERR_OUT1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR_OUT1_MASK, BOOT_CR, 0, 1)
REG32(PMC_ERR_OUT1_EN, 0x24)
    FIELD(PMC_ERR_OUT1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR_OUT1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR_OUT1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR_OUT1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR_OUT1_EN, PL3, 27, 1)
    FIELD(PMC_ERR_OUT1_EN, PL2, 26, 1)
    FIELD(PMC_ERR_OUT1_EN, PL1, 25, 1)
    FIELD(PMC_ERR_OUT1_EN, PL0, 24, 1)
    FIELD(PMC_ERR_OUT1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR_OUT1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR_OUT1_EN, GT_NCR, 21, 1)
    FIELD(PMC_ERR_OUT1_EN, GT_CR, 20, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR_OUT1_EN, ME_NCR, 17, 1)
    FIELD(PMC_ERR_OUT1_EN, ME_CR, 16, 1)
    FIELD(PMC_ERR_OUT1_EN, MMCM, 15, 1)
    FIELD(PMC_ERR_OUT1_EN, NOC_USER, 14, 1)
    FIELD(PMC_ERR_OUT1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR_OUT1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR_OUT1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR_OUT1_EN, CFRAME, 7, 1)
    FIELD(PMC_ERR_OUT1_EN, CFU, 6, 1)
    FIELD(PMC_ERR_OUT1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_ERR_OUT1_EN, GSW_CR, 4, 1)
    FIELD(PMC_ERR_OUT1_EN, FW_NCR, 3, 1)
    FIELD(PMC_ERR_OUT1_EN, FW_CR, 2, 1)
    FIELD(PMC_ERR_OUT1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR_OUT1_EN, BOOT_CR, 0, 1)
REG32(PMC_ERR_OUT1_DIS, 0x28)
    FIELD(PMC_ERR_OUT1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_ERR_OUT1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_ERR_OUT1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_ERR_OUT1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL3, 27, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL2, 26, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL1, 25, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL0, 24, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_ERR_OUT1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_ERR_OUT1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_ERR_OUT1_DIS, GT_CR, 20, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_ERR_OUT1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_ERR_OUT1_DIS, ME_CR, 16, 1)
    FIELD(PMC_ERR_OUT1_DIS, MMCM, 15, 1)
    FIELD(PMC_ERR_OUT1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_ERR_OUT1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_ERR_OUT1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_ERR_OUT1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_ERR_OUT1_DIS, CFRAME, 7, 1)
    FIELD(PMC_ERR_OUT1_DIS, CFU, 6, 1)
    FIELD(PMC_ERR_OUT1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_ERR_OUT1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_ERR_OUT1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_ERR_OUT1_DIS, FW_CR, 2, 1)
    FIELD(PMC_ERR_OUT1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_ERR_OUT1_DIS, BOOT_CR, 0, 1)
REG32(PMC_ERR_OUT2_MASK, 0x30)
    FIELD(PMC_ERR_OUT2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR_OUT2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR_OUT2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR_OUT2_MASK, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_ERR_OUT2_MASK, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_ERR_OUT2_MASK, RSRV_ERR0, 26, 1)
    FIELD(PMC_ERR_OUT2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_ERR_OUT2_MASK, PPLL, 24, 1)
    FIELD(PMC_ERR_OUT2_MASK, NPLL, 23, 1)
    FIELD(PMC_ERR_OUT2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR_OUT2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMX_WWDT, 20, 1)
    FIELD(PMC_ERR_OUT2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR_OUT2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR_OUT2_MASK, CFI, 17, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_ERR_OUT2_MASK, RSRV_ERR2, 4, 1)
    FIELD(PMC_ERR_OUT2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR_OUT2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_ERR_OUT2_MASK, PMC_APB, 0, 1)
REG32(PMC_ERR_OUT2_EN, 0x34)
    FIELD(PMC_ERR_OUT2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR_OUT2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR_OUT2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR_OUT2_EN, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_ERR_OUT2_EN, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_ERR_OUT2_EN, RSRV_ERR0, 26, 1)
    FIELD(PMC_ERR_OUT2_EN, CLK_MON, 25, 1)
    FIELD(PMC_ERR_OUT2_EN, PPLL, 24, 1)
    FIELD(PMC_ERR_OUT2_EN, NPLL, 23, 1)
    FIELD(PMC_ERR_OUT2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR_OUT2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR_OUT2_EN, PMX_WWDT, 20, 1)
    FIELD(PMC_ERR_OUT2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR_OUT2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR_OUT2_EN, CFI, 17, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_CR, 5, 1)
    FIELD(PMC_ERR_OUT2_EN, RSRV_ERR2, 4, 1)
    FIELD(PMC_ERR_OUT2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR_OUT2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_ERR_OUT2_EN, PMC_APB, 0, 1)
REG32(PMC_ERR_OUT2_DIS, 0x38)
    FIELD(PMC_ERR_OUT2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_ERR_OUT2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_ERR_OUT2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_ERR_OUT2_DIS, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_ERR_OUT2_DIS, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_ERR_OUT2_DIS, RSRV_ERR0, 26, 1)
    FIELD(PMC_ERR_OUT2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_ERR_OUT2_DIS, PPLL, 24, 1)
    FIELD(PMC_ERR_OUT2_DIS, NPLL, 23, 1)
    FIELD(PMC_ERR_OUT2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_ERR_OUT2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMX_WWDT, 20, 1)
    FIELD(PMC_ERR_OUT2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_ERR_OUT2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_ERR_OUT2_DIS, CFI, 17, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_ERR_OUT2_DIS, RSRV_ERR2, 4, 1)
    FIELD(PMC_ERR_OUT2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_ERR_OUT2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_ERR_OUT2_DIS, PMC_APB, 0, 1)
REG32(PMC_POR1_MASK, 0x40)
    FIELD(PMC_POR1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_POR1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_POR1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_POR1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_POR1_MASK, PL3, 27, 1)
    FIELD(PMC_POR1_MASK, PL2, 26, 1)
    FIELD(PMC_POR1_MASK, PL1, 25, 1)
    FIELD(PMC_POR1_MASK, PL0, 24, 1)
    FIELD(PMC_POR1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_POR1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_POR1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_POR1_MASK, GT_CR, 20, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_POR1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_POR1_MASK, ME_CR, 16, 1)
    FIELD(PMC_POR1_MASK, MMCM, 15, 1)
    FIELD(PMC_POR1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_POR1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_POR1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_POR1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_POR1_MASK, CFRAME, 7, 1)
    FIELD(PMC_POR1_MASK, CFU, 6, 1)
    FIELD(PMC_POR1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_POR1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_POR1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_POR1_MASK, FW_CR, 2, 1)
    FIELD(PMC_POR1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_POR1_MASK, BOOT_CR, 0, 1)
REG32(PMC_POR1_EN, 0x44)
    FIELD(PMC_POR1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_POR1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_POR1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_POR1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_POR1_EN, PL3, 27, 1)
    FIELD(PMC_POR1_EN, PL2, 26, 1)
    FIELD(PMC_POR1_EN, PL1, 25, 1)
    FIELD(PMC_POR1_EN, PL0, 24, 1)
    FIELD(PMC_POR1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_POR1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_POR1_EN, GT_NCR, 21, 1)
    FIELD(PMC_POR1_EN, GT_CR, 20, 1)
    FIELD(PMC_POR1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_POR1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_POR1_EN, ME_NCR, 17, 1)
    FIELD(PMC_POR1_EN, ME_CR, 16, 1)
    FIELD(PMC_POR1_EN, MMCM, 15, 1)
    FIELD(PMC_POR1_EN, NOC_USER, 14, 1)
    FIELD(PMC_POR1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_POR1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_POR1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_POR1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_POR1_EN, CFRAME, 7, 1)
    FIELD(PMC_POR1_EN, CFU, 6, 1)
    FIELD(PMC_POR1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_POR1_EN, GSW_CR, 4, 1)
    FIELD(PMC_POR1_EN, FW_NCR, 3, 1)
    FIELD(PMC_POR1_EN, FW_CR, 2, 1)
    FIELD(PMC_POR1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_POR1_EN, BOOT_CR, 0, 1)
REG32(PMC_POR1_DIS, 0x48)
    FIELD(PMC_POR1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_POR1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_POR1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_POR1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_POR1_DIS, PL3, 27, 1)
    FIELD(PMC_POR1_DIS, PL2, 26, 1)
    FIELD(PMC_POR1_DIS, PL1, 25, 1)
    FIELD(PMC_POR1_DIS, PL0, 24, 1)
    FIELD(PMC_POR1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_POR1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_POR1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_POR1_DIS, GT_CR, 20, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_POR1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_POR1_DIS, ME_CR, 16, 1)
    FIELD(PMC_POR1_DIS, MMCM, 15, 1)
    FIELD(PMC_POR1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_POR1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_POR1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_POR1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_POR1_DIS, CFRAME, 7, 1)
    FIELD(PMC_POR1_DIS, CFU, 6, 1)
    FIELD(PMC_POR1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_POR1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_POR1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_POR1_DIS, FW_CR, 2, 1)
    FIELD(PMC_POR1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_POR1_DIS, BOOT_CR, 0, 1)
REG32(PMC_POR2_MASK, 0x50)
    FIELD(PMC_POR2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_POR2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_POR2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_POR2_MASK, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_POR2_MASK, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_POR2_MASK, RSRV_ERR0, 26, 1)
    FIELD(PMC_POR2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_POR2_MASK, PPLL, 24, 1)
    FIELD(PMC_POR2_MASK, NPLL, 23, 1)
    FIELD(PMC_POR2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_POR2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_POR2_MASK, PMX_WWDT, 20, 1)
    FIELD(PMC_POR2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_POR2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_POR2_MASK, CFI, 17, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_POR2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_POR2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_POR2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_POR2_MASK, RSRV_ERR2, 4, 1)
    FIELD(PMC_POR2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_POR2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_POR2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_POR2_MASK, PMC_APB, 0, 1)
REG32(PMC_POR2_EN, 0x54)
    FIELD(PMC_POR2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_POR2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_POR2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_POR2_EN, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_POR2_EN, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_POR2_EN, RSRV_ERR0, 26, 1)
    FIELD(PMC_POR2_EN, CLK_MON, 25, 1)
    FIELD(PMC_POR2_EN, PPLL, 24, 1)
    FIELD(PMC_POR2_EN, NPLL, 23, 1)
    FIELD(PMC_POR2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_POR2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_POR2_EN, PMX_WWDT, 20, 1)
    FIELD(PMC_POR2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_POR2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_POR2_EN, CFI, 17, 1)
    FIELD(PMC_POR2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_POR2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_POR2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_POR2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_POR2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_POR2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_POR2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_POR2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_POR2_EN, PMC_CR, 5, 1)
    FIELD(PMC_POR2_EN, RSRV_ERR2, 4, 1)
    FIELD(PMC_POR2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_POR2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_POR2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_POR2_EN, PMC_APB, 0, 1)
REG32(PMC_POR2_DIS, 0x58)
    FIELD(PMC_POR2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_POR2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_POR2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_POR2_DIS, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_POR2_DIS, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_POR2_DIS, RSRV_ERR0, 26, 1)
    FIELD(PMC_POR2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_POR2_DIS, PPLL, 24, 1)
    FIELD(PMC_POR2_DIS, NPLL, 23, 1)
    FIELD(PMC_POR2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_POR2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_POR2_DIS, PMX_WWDT, 20, 1)
    FIELD(PMC_POR2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_POR2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_POR2_DIS, CFI, 17, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_POR2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_POR2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_POR2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_POR2_DIS, RSRV_ERR2, 4, 1)
    FIELD(PMC_POR2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_POR2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_POR2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_POR2_DIS, PMC_APB, 0, 1)
REG32(PMC_IRQ1_MASK, 0x60)
    FIELD(PMC_IRQ1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_IRQ1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_IRQ1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_IRQ1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_IRQ1_MASK, PL3, 27, 1)
    FIELD(PMC_IRQ1_MASK, PL2, 26, 1)
    FIELD(PMC_IRQ1_MASK, PL1, 25, 1)
    FIELD(PMC_IRQ1_MASK, PL0, 24, 1)
    FIELD(PMC_IRQ1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_IRQ1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_IRQ1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_IRQ1_MASK, GT_CR, 20, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_IRQ1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_IRQ1_MASK, ME_CR, 16, 1)
    FIELD(PMC_IRQ1_MASK, MMCM, 15, 1)
    FIELD(PMC_IRQ1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_IRQ1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_IRQ1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_IRQ1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_IRQ1_MASK, CFRAME, 7, 1)
    FIELD(PMC_IRQ1_MASK, CFU, 6, 1)
    FIELD(PMC_IRQ1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_IRQ1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_IRQ1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_IRQ1_MASK, FW_CR, 2, 1)
    FIELD(PMC_IRQ1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_IRQ1_MASK, BOOT_CR, 0, 1)
REG32(PMC_IRQ1_EN, 0x64)
    FIELD(PMC_IRQ1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_IRQ1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_IRQ1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_IRQ1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_IRQ1_EN, PL3, 27, 1)
    FIELD(PMC_IRQ1_EN, PL2, 26, 1)
    FIELD(PMC_IRQ1_EN, PL1, 25, 1)
    FIELD(PMC_IRQ1_EN, PL0, 24, 1)
    FIELD(PMC_IRQ1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_IRQ1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_IRQ1_EN, GT_NCR, 21, 1)
    FIELD(PMC_IRQ1_EN, GT_CR, 20, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_IRQ1_EN, ME_NCR, 17, 1)
    FIELD(PMC_IRQ1_EN, ME_CR, 16, 1)
    FIELD(PMC_IRQ1_EN, MMCM, 15, 1)
    FIELD(PMC_IRQ1_EN, NOC_USER, 14, 1)
    FIELD(PMC_IRQ1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_IRQ1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_IRQ1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_IRQ1_EN, CFRAME, 7, 1)
    FIELD(PMC_IRQ1_EN, CFU, 6, 1)
    FIELD(PMC_IRQ1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_IRQ1_EN, GSW_CR, 4, 1)
    FIELD(PMC_IRQ1_EN, FW_NCR, 3, 1)
    FIELD(PMC_IRQ1_EN, FW_CR, 2, 1)
    FIELD(PMC_IRQ1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_IRQ1_EN, BOOT_CR, 0, 1)
REG32(PMC_IRQ1_DIS, 0x68)
    FIELD(PMC_IRQ1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_IRQ1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_IRQ1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_IRQ1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_IRQ1_DIS, PL3, 27, 1)
    FIELD(PMC_IRQ1_DIS, PL2, 26, 1)
    FIELD(PMC_IRQ1_DIS, PL1, 25, 1)
    FIELD(PMC_IRQ1_DIS, PL0, 24, 1)
    FIELD(PMC_IRQ1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_IRQ1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_IRQ1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_IRQ1_DIS, GT_CR, 20, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_IRQ1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_IRQ1_DIS, ME_CR, 16, 1)
    FIELD(PMC_IRQ1_DIS, MMCM, 15, 1)
    FIELD(PMC_IRQ1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_IRQ1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_IRQ1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_IRQ1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_IRQ1_DIS, CFRAME, 7, 1)
    FIELD(PMC_IRQ1_DIS, CFU, 6, 1)
    FIELD(PMC_IRQ1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_IRQ1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_IRQ1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_IRQ1_DIS, FW_CR, 2, 1)
    FIELD(PMC_IRQ1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_IRQ1_DIS, BOOT_CR, 0, 1)
REG32(PMC_IRQ2_MASK, 0x70)
    FIELD(PMC_IRQ2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_IRQ2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_IRQ2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_IRQ2_MASK, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_IRQ2_MASK, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_IRQ2_MASK, RSRV_ERR0, 26, 1)
    FIELD(PMC_IRQ2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_IRQ2_MASK, PPLL, 24, 1)
    FIELD(PMC_IRQ2_MASK, NPLL, 23, 1)
    FIELD(PMC_IRQ2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_IRQ2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_IRQ2_MASK, PMX_WWDT, 20, 1)
    FIELD(PMC_IRQ2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_IRQ2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_IRQ2_MASK, CFI, 17, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_IRQ2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_IRQ2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_IRQ2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_IRQ2_MASK, RSRV_ERR2, 4, 1)
    FIELD(PMC_IRQ2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_IRQ2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_IRQ2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_IRQ2_MASK, PMC_APB, 0, 1)
REG32(PMC_IRQ2_EN, 0x74)
    FIELD(PMC_IRQ2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_IRQ2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_IRQ2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_IRQ2_EN, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_IRQ2_EN, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_IRQ2_EN, RSRV_ERR0, 26, 1)
    FIELD(PMC_IRQ2_EN, CLK_MON, 25, 1)
    FIELD(PMC_IRQ2_EN, PPLL, 24, 1)
    FIELD(PMC_IRQ2_EN, NPLL, 23, 1)
    FIELD(PMC_IRQ2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_IRQ2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_IRQ2_EN, PMX_WWDT, 20, 1)
    FIELD(PMC_IRQ2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_IRQ2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_IRQ2_EN, CFI, 17, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_IRQ2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_IRQ2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_IRQ2_EN, PMC_CR, 5, 1)
    FIELD(PMC_IRQ2_EN, RSRV_ERR2, 4, 1)
    FIELD(PMC_IRQ2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_IRQ2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_IRQ2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_IRQ2_EN, PMC_APB, 0, 1)
REG32(PMC_IRQ2_DIS, 0x78)
    FIELD(PMC_IRQ2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_IRQ2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_IRQ2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_IRQ2_DIS, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_IRQ2_DIS, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_IRQ2_DIS, RSRV_ERR0, 26, 1)
    FIELD(PMC_IRQ2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_IRQ2_DIS, PPLL, 24, 1)
    FIELD(PMC_IRQ2_DIS, NPLL, 23, 1)
    FIELD(PMC_IRQ2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_IRQ2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_IRQ2_DIS, PMX_WWDT, 20, 1)
    FIELD(PMC_IRQ2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_IRQ2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_IRQ2_DIS, CFI, 17, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_IRQ2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_IRQ2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_IRQ2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_IRQ2_DIS, RSRV_ERR2, 4, 1)
    FIELD(PMC_IRQ2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_IRQ2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_IRQ2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_IRQ2_DIS, PMC_APB, 0, 1)
REG32(PMC_SRST1_MASK, 0x80)
    FIELD(PMC_SRST1_MASK, SSIT_ERR5, 31, 1)
    FIELD(PMC_SRST1_MASK, SSIT_ERR4, 30, 1)
    FIELD(PMC_SRST1_MASK, SSIT_ERR3, 29, 1)
    FIELD(PMC_SRST1_MASK, NPI_ROOT, 28, 1)
    FIELD(PMC_SRST1_MASK, PL3, 27, 1)
    FIELD(PMC_SRST1_MASK, PL2, 26, 1)
    FIELD(PMC_SRST1_MASK, PL1, 25, 1)
    FIELD(PMC_SRST1_MASK, PL0, 24, 1)
    FIELD(PMC_SRST1_MASK, PL_SMON_NCR, 23, 1)
    FIELD(PMC_SRST1_MASK, PL_SMON_CR, 22, 1)
    FIELD(PMC_SRST1_MASK, GT_NCR, 21, 1)
    FIELD(PMC_SRST1_MASK, GT_CR, 20, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_SRST1_MASK, ME_NCR, 17, 1)
    FIELD(PMC_SRST1_MASK, ME_CR, 16, 1)
    FIELD(PMC_SRST1_MASK, MMCM, 15, 1)
    FIELD(PMC_SRST1_MASK, NOC_USER, 14, 1)
    FIELD(PMC_SRST1_MASK, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_SRST1_MASK, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_SRST1_MASK, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_SRST1_MASK, CFRAME, 7, 1)
    FIELD(PMC_SRST1_MASK, CFU, 6, 1)
    FIELD(PMC_SRST1_MASK, GSW_NCR, 5, 1)
    FIELD(PMC_SRST1_MASK, GSW_CR, 4, 1)
    FIELD(PMC_SRST1_MASK, FW_NCR, 3, 1)
    FIELD(PMC_SRST1_MASK, FW_CR, 2, 1)
    FIELD(PMC_SRST1_MASK, BOOT_NCR, 1, 1)
    FIELD(PMC_SRST1_MASK, BOOT_CR, 0, 1)
REG32(PMC_SRST1_EN, 0x84)
    FIELD(PMC_SRST1_EN, SSIT_ERR5, 31, 1)
    FIELD(PMC_SRST1_EN, SSIT_ERR4, 30, 1)
    FIELD(PMC_SRST1_EN, SSIT_ERR3, 29, 1)
    FIELD(PMC_SRST1_EN, NPI_ROOT, 28, 1)
    FIELD(PMC_SRST1_EN, PL3, 27, 1)
    FIELD(PMC_SRST1_EN, PL2, 26, 1)
    FIELD(PMC_SRST1_EN, PL1, 25, 1)
    FIELD(PMC_SRST1_EN, PL0, 24, 1)
    FIELD(PMC_SRST1_EN, PL_SMON_NCR, 23, 1)
    FIELD(PMC_SRST1_EN, PL_SMON_CR, 22, 1)
    FIELD(PMC_SRST1_EN, GT_NCR, 21, 1)
    FIELD(PMC_SRST1_EN, GT_CR, 20, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_SRST1_EN, ME_NCR, 17, 1)
    FIELD(PMC_SRST1_EN, ME_CR, 16, 1)
    FIELD(PMC_SRST1_EN, MMCM, 15, 1)
    FIELD(PMC_SRST1_EN, NOC_USER, 14, 1)
    FIELD(PMC_SRST1_EN, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_SRST1_EN, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_SRST1_EN, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_SRST1_EN, CFRAME, 7, 1)
    FIELD(PMC_SRST1_EN, CFU, 6, 1)
    FIELD(PMC_SRST1_EN, GSW_NCR, 5, 1)
    FIELD(PMC_SRST1_EN, GSW_CR, 4, 1)
    FIELD(PMC_SRST1_EN, FW_NCR, 3, 1)
    FIELD(PMC_SRST1_EN, FW_CR, 2, 1)
    FIELD(PMC_SRST1_EN, BOOT_NCR, 1, 1)
    FIELD(PMC_SRST1_EN, BOOT_CR, 0, 1)
REG32(PMC_SRST1_DIS, 0x88)
    FIELD(PMC_SRST1_DIS, SSIT_ERR5, 31, 1)
    FIELD(PMC_SRST1_DIS, SSIT_ERR4, 30, 1)
    FIELD(PMC_SRST1_DIS, SSIT_ERR3, 29, 1)
    FIELD(PMC_SRST1_DIS, NPI_ROOT, 28, 1)
    FIELD(PMC_SRST1_DIS, PL3, 27, 1)
    FIELD(PMC_SRST1_DIS, PL2, 26, 1)
    FIELD(PMC_SRST1_DIS, PL1, 25, 1)
    FIELD(PMC_SRST1_DIS, PL0, 24, 1)
    FIELD(PMC_SRST1_DIS, PL_SMON_NCR, 23, 1)
    FIELD(PMC_SRST1_DIS, PL_SMON_CR, 22, 1)
    FIELD(PMC_SRST1_DIS, GT_NCR, 21, 1)
    FIELD(PMC_SRST1_DIS, GT_CR, 20, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MC_NCR, 19, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MC_CR, 18, 1)
    FIELD(PMC_SRST1_DIS, ME_NCR, 17, 1)
    FIELD(PMC_SRST1_DIS, ME_CR, 16, 1)
    FIELD(PMC_SRST1_DIS, MMCM, 15, 1)
    FIELD(PMC_SRST1_DIS, NOC_USER, 14, 1)
    FIELD(PMC_SRST1_DIS, NOC_TYPE1_NCR, 13, 1)
    FIELD(PMC_SRST1_DIS, NOC_TYPE1_CR, 12, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MB_NCR, 11, 1)
    FIELD(PMC_SRST1_DIS, DDRMC_MB_CR, 10, 1)
    FIELD(PMC_SRST1_DIS, CFRAME, 7, 1)
    FIELD(PMC_SRST1_DIS, CFU, 6, 1)
    FIELD(PMC_SRST1_DIS, GSW_NCR, 5, 1)
    FIELD(PMC_SRST1_DIS, GSW_CR, 4, 1)
    FIELD(PMC_SRST1_DIS, FW_NCR, 3, 1)
    FIELD(PMC_SRST1_DIS, FW_CR, 2, 1)
    FIELD(PMC_SRST1_DIS, BOOT_NCR, 1, 1)
    FIELD(PMC_SRST1_DIS, BOOT_CR, 0, 1)
REG32(PMC_SRST2_MASK, 0x90)
    FIELD(PMC_SRST2_MASK, SSIT_ERR2, 31, 1)
    FIELD(PMC_SRST2_MASK, SSIT_ERR1, 30, 1)
    FIELD(PMC_SRST2_MASK, SSIT_ERR0, 29, 1)
    FIELD(PMC_SRST2_MASK, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_SRST2_MASK, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_SRST2_MASK, RSRV_ERR0, 26, 1)
    FIELD(PMC_SRST2_MASK, CLK_MON, 25, 1)
    FIELD(PMC_SRST2_MASK, PPLL, 24, 1)
    FIELD(PMC_SRST2_MASK, NPLL, 23, 1)
    FIELD(PMC_SRST2_MASK, RTC_ALARM, 22, 1)
    FIELD(PMC_SRST2_MASK, RSRV_ERR1, 21, 1)
    FIELD(PMC_SRST2_MASK, PMX_WWDT, 20, 1)
    FIELD(PMC_SRST2_MASK, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_SRST2_MASK, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_SRST2_MASK, CFI, 17, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON9, 16, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON8, 15, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON4, 11, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON3, 10, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON2, 9, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON1, 8, 1)
    FIELD(PMC_SRST2_MASK, PMC_SMON0, 7, 1)
    FIELD(PMC_SRST2_MASK, PMC_NCR, 6, 1)
    FIELD(PMC_SRST2_MASK, PMC_CR, 5, 1)
    FIELD(PMC_SRST2_MASK, RSRV_ERR2, 4, 1)
    FIELD(PMC_SRST2_MASK, MB_FATAL1, 3, 1)
    FIELD(PMC_SRST2_MASK, MB_FATAL0, 2, 1)
    FIELD(PMC_SRST2_MASK, PMC_ROM, 1, 1)
    FIELD(PMC_SRST2_MASK, PMC_APB, 0, 1)
REG32(PMC_SRST2_EN, 0x94)
    FIELD(PMC_SRST2_EN, SSIT_ERR2, 31, 1)
    FIELD(PMC_SRST2_EN, SSIT_ERR1, 30, 1)
    FIELD(PMC_SRST2_EN, SSIT_ERR0, 29, 1)
    FIELD(PMC_SRST2_EN, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_SRST2_EN, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_SRST2_EN, RSRV_ERR0, 26, 1)
    FIELD(PMC_SRST2_EN, CLK_MON, 25, 1)
    FIELD(PMC_SRST2_EN, PPLL, 24, 1)
    FIELD(PMC_SRST2_EN, NPLL, 23, 1)
    FIELD(PMC_SRST2_EN, RTC_ALARM, 22, 1)
    FIELD(PMC_SRST2_EN, RSRV_ERR1, 21, 1)
    FIELD(PMC_SRST2_EN, PMX_WWDT, 20, 1)
    FIELD(PMC_SRST2_EN, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_SRST2_EN, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_SRST2_EN, CFI, 17, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON9, 16, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON8, 15, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON4, 11, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON3, 10, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON2, 9, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON1, 8, 1)
    FIELD(PMC_SRST2_EN, PMC_SMON0, 7, 1)
    FIELD(PMC_SRST2_EN, PMC_NCR, 6, 1)
    FIELD(PMC_SRST2_EN, PMC_CR, 5, 1)
    FIELD(PMC_SRST2_EN, RSRV_ERR2, 4, 1)
    FIELD(PMC_SRST2_EN, MB_FATAL1, 3, 1)
    FIELD(PMC_SRST2_EN, MB_FATAL0, 2, 1)
    FIELD(PMC_SRST2_EN, PMC_ROM, 1, 1)
    FIELD(PMC_SRST2_EN, PMC_APB, 0, 1)
REG32(PMC_SRST2_DIS, 0x98)
    FIELD(PMC_SRST2_DIS, SSIT_ERR2, 31, 1)
    FIELD(PMC_SRST2_DIS, SSIT_ERR1, 30, 1)
    FIELD(PMC_SRST2_DIS, SSIT_ERR0, 29, 1)
    FIELD(PMC_SRST2_DIS, INT_PMX_UNCORR_ERR, 28, 1)
    FIELD(PMC_SRST2_DIS, INT_PMX_CORR_ERR, 27, 1)
    FIELD(PMC_SRST2_DIS, RSRV_ERR0, 26, 1)
    FIELD(PMC_SRST2_DIS, CLK_MON, 25, 1)
    FIELD(PMC_SRST2_DIS, PPLL, 24, 1)
    FIELD(PMC_SRST2_DIS, NPLL, 23, 1)
    FIELD(PMC_SRST2_DIS, RTC_ALARM, 22, 1)
    FIELD(PMC_SRST2_DIS, RSRV_ERR1, 21, 1)
    FIELD(PMC_SRST2_DIS, PMX_WWDT, 20, 1)
    FIELD(PMC_SRST2_DIS, CFRAME_SEU_ECC, 19, 1)
    FIELD(PMC_SRST2_DIS, CFRAME_SEU_CRC, 18, 1)
    FIELD(PMC_SRST2_DIS, CFI, 17, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON9, 16, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON8, 15, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON4, 11, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON3, 10, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON2, 9, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON1, 8, 1)
    FIELD(PMC_SRST2_DIS, PMC_SMON0, 7, 1)
    FIELD(PMC_SRST2_DIS, PMC_NCR, 6, 1)
    FIELD(PMC_SRST2_DIS, PMC_CR, 5, 1)
    FIELD(PMC_SRST2_DIS, RSRV_ERR2, 4, 1)
    FIELD(PMC_SRST2_DIS, MB_FATAL1, 3, 1)
    FIELD(PMC_SRST2_DIS, MB_FATAL0, 2, 1)
    FIELD(PMC_SRST2_DIS, PMC_ROM, 1, 1)
    FIELD(PMC_SRST2_DIS, PMC_APB, 0, 1)
REG32(PMC_BOOT_ERR, 0x100)
    FIELD(PMC_BOOT_ERR, DATA, 0, 30)
REG32(PMC_ERR_OUT3_MASK, 0x110)
    FIELD(PMC_ERR_OUT3_MASK, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_ERR_OUT3_MASK, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_ERR_OUT3_MASK, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_ERR_OUT3_MASK, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_ERR_OUT3_MASK, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_ERR_OUT3_MASK, PMC_EAM_GD, 19, 1)
    FIELD(PMC_ERR_OUT3_MASK, ASU_EAM_GD, 18, 1)
    FIELD(PMC_ERR_OUT3_MASK, PSX_EAM_E3, 17, 1)
    FIELD(PMC_ERR_OUT3_MASK, PSX_EAM_E2, 16, 1)
    FIELD(PMC_ERR_OUT3_MASK, PSX_EAM_E1, 15, 1)
    FIELD(PMC_ERR_OUT3_MASK, PSX_EAM_E0, 14, 1)
    FIELD(PMC_ERR_OUT3_MASK, PCR_PAR, 13, 1)
    FIELD(PMC_ERR_OUT3_MASK, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_ERR_OUT3_MASK, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_ERR_OUT3_MASK, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_ERR_OUT3_MASK, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_ERR_OUT3_MASK, DME_PUB_Y, 8, 1)
    FIELD(PMC_ERR_OUT3_MASK, DME_PUB_X, 7, 1)
    FIELD(PMC_ERR_OUT3_MASK, DEVAK_PRIV, 6, 1)
    FIELD(PMC_ERR_OUT3_MASK, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_ERR_OUT3_MASK, DEVIK_PRIV, 4, 1)
    FIELD(PMC_ERR_OUT3_MASK, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_ERR_OUT3_MASK, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_ERR_OUT3_MASK, IOU_NCR, 1, 1)
    FIELD(PMC_ERR_OUT3_MASK, IOU_CR, 0, 1)
REG32(PMC_ERR_OUT3_EN, 0x114)
    FIELD(PMC_ERR_OUT3_EN, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_ERR_OUT3_EN, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_ERR_OUT3_EN, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_ERR_OUT3_EN, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_ERR_OUT3_EN, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_ERR_OUT3_EN, PMC_EAM_GD, 19, 1)
    FIELD(PMC_ERR_OUT3_EN, ASU_EAM_GD, 18, 1)
    FIELD(PMC_ERR_OUT3_EN, PSX_EAM_E3, 17, 1)
    FIELD(PMC_ERR_OUT3_EN, PSX_EAM_E2, 16, 1)
    FIELD(PMC_ERR_OUT3_EN, PSX_EAM_E1, 15, 1)
    FIELD(PMC_ERR_OUT3_EN, PSX_EAM_E0, 14, 1)
    FIELD(PMC_ERR_OUT3_EN, PCR_PAR, 13, 1)
    FIELD(PMC_ERR_OUT3_EN, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_ERR_OUT3_EN, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_ERR_OUT3_EN, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_ERR_OUT3_EN, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_ERR_OUT3_EN, DME_PUB_Y, 8, 1)
    FIELD(PMC_ERR_OUT3_EN, DME_PUB_X, 7, 1)
    FIELD(PMC_ERR_OUT3_EN, DEVAK_PRIV, 6, 1)
    FIELD(PMC_ERR_OUT3_EN, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_ERR_OUT3_EN, DEVIK_PRIV, 4, 1)
    FIELD(PMC_ERR_OUT3_EN, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_ERR_OUT3_EN, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_ERR_OUT3_EN, IOU_NCR, 1, 1)
    FIELD(PMC_ERR_OUT3_EN, IOU_CR, 0, 1)
REG32(PMC_ERR_OUT3_DIS, 0x118)
    FIELD(PMC_ERR_OUT3_DIS, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_ERR_OUT3_DIS, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_ERR_OUT3_DIS, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_ERR_OUT3_DIS, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_ERR_OUT3_DIS, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_ERR_OUT3_DIS, PMC_EAM_GD, 19, 1)
    FIELD(PMC_ERR_OUT3_DIS, ASU_EAM_GD, 18, 1)
    FIELD(PMC_ERR_OUT3_DIS, PSX_EAM_E3, 17, 1)
    FIELD(PMC_ERR_OUT3_DIS, PSX_EAM_E2, 16, 1)
    FIELD(PMC_ERR_OUT3_DIS, PSX_EAM_E1, 15, 1)
    FIELD(PMC_ERR_OUT3_DIS, PSX_EAM_E0, 14, 1)
    FIELD(PMC_ERR_OUT3_DIS, PCR_PAR, 13, 1)
    FIELD(PMC_ERR_OUT3_DIS, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_ERR_OUT3_DIS, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_ERR_OUT3_DIS, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_ERR_OUT3_DIS, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_ERR_OUT3_DIS, DME_PUB_Y, 8, 1)
    FIELD(PMC_ERR_OUT3_DIS, DME_PUB_X, 7, 1)
    FIELD(PMC_ERR_OUT3_DIS, DEVAK_PRIV, 6, 1)
    FIELD(PMC_ERR_OUT3_DIS, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_ERR_OUT3_DIS, DEVIK_PRIV, 4, 1)
    FIELD(PMC_ERR_OUT3_DIS, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_ERR_OUT3_DIS, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_ERR_OUT3_DIS, IOU_NCR, 1, 1)
    FIELD(PMC_ERR_OUT3_DIS, IOU_CR, 0, 1)
REG32(PMC_POR3_MASK, 0x120)
    FIELD(PMC_POR3_MASK, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_POR3_MASK, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_POR3_MASK, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_POR3_MASK, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_POR3_MASK, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_POR3_MASK, PMC_EAM_GD, 19, 1)
    FIELD(PMC_POR3_MASK, ASU_EAM_GD, 18, 1)
    FIELD(PMC_POR3_MASK, PSX_EAM_E3, 17, 1)
    FIELD(PMC_POR3_MASK, PSX_EAM_E2, 16, 1)
    FIELD(PMC_POR3_MASK, PSX_EAM_E1, 15, 1)
    FIELD(PMC_POR3_MASK, PSX_EAM_E0, 14, 1)
    FIELD(PMC_POR3_MASK, PCR_PAR, 13, 1)
    FIELD(PMC_POR3_MASK, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_POR3_MASK, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_POR3_MASK, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_POR3_MASK, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_POR3_MASK, DME_PUB_Y, 8, 1)
    FIELD(PMC_POR3_MASK, DME_PUB_X, 7, 1)
    FIELD(PMC_POR3_MASK, DEVAK_PRIV, 6, 1)
    FIELD(PMC_POR3_MASK, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_POR3_MASK, DEVIK_PRIV, 4, 1)
    FIELD(PMC_POR3_MASK, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_POR3_MASK, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_POR3_MASK, IOU_NCR, 1, 1)
    FIELD(PMC_POR3_MASK, IOU_CR, 0, 1)
REG32(PMC_POR3_EN, 0x124)
    FIELD(PMC_POR3_EN, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_POR3_EN, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_POR3_EN, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_POR3_EN, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_POR3_EN, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_POR3_EN, PMC_EAM_GD, 19, 1)
    FIELD(PMC_POR3_EN, ASU_EAM_GD, 18, 1)
    FIELD(PMC_POR3_EN, PSX_EAM_E3, 17, 1)
    FIELD(PMC_POR3_EN, PSX_EAM_E2, 16, 1)
    FIELD(PMC_POR3_EN, PSX_EAM_E1, 15, 1)
    FIELD(PMC_POR3_EN, PSX_EAM_E0, 14, 1)
    FIELD(PMC_POR3_EN, PCR_PAR, 13, 1)
    FIELD(PMC_POR3_EN, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_POR3_EN, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_POR3_EN, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_POR3_EN, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_POR3_EN, DME_PUB_Y, 8, 1)
    FIELD(PMC_POR3_EN, DME_PUB_X, 7, 1)
    FIELD(PMC_POR3_EN, DEVAK_PRIV, 6, 1)
    FIELD(PMC_POR3_EN, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_POR3_EN, DEVIK_PRIV, 4, 1)
    FIELD(PMC_POR3_EN, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_POR3_EN, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_POR3_EN, IOU_NCR, 1, 1)
    FIELD(PMC_POR3_EN, IOU_CR, 0, 1)
REG32(PMC_POR3_DIS, 0x128)
    FIELD(PMC_POR3_DIS, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_POR3_DIS, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_POR3_DIS, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_POR3_DIS, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_POR3_DIS, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_POR3_DIS, PMC_EAM_GD, 19, 1)
    FIELD(PMC_POR3_DIS, ASU_EAM_GD, 18, 1)
    FIELD(PMC_POR3_DIS, PSX_EAM_E3, 17, 1)
    FIELD(PMC_POR3_DIS, PSX_EAM_E2, 16, 1)
    FIELD(PMC_POR3_DIS, PSX_EAM_E1, 15, 1)
    FIELD(PMC_POR3_DIS, PSX_EAM_E0, 14, 1)
    FIELD(PMC_POR3_DIS, PCR_PAR, 13, 1)
    FIELD(PMC_POR3_DIS, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_POR3_DIS, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_POR3_DIS, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_POR3_DIS, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_POR3_DIS, DME_PUB_Y, 8, 1)
    FIELD(PMC_POR3_DIS, DME_PUB_X, 7, 1)
    FIELD(PMC_POR3_DIS, DEVAK_PRIV, 6, 1)
    FIELD(PMC_POR3_DIS, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_POR3_DIS, DEVIK_PRIV, 4, 1)
    FIELD(PMC_POR3_DIS, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_POR3_DIS, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_POR3_DIS, IOU_NCR, 1, 1)
    FIELD(PMC_POR3_DIS, IOU_CR, 0, 1)
REG32(PMC_IRQ3_MASK, 0x130)
    FIELD(PMC_IRQ3_MASK, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_IRQ3_MASK, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_IRQ3_MASK, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_IRQ3_MASK, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_IRQ3_MASK, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_IRQ3_MASK, PMC_EAM_GD, 19, 1)
    FIELD(PMC_IRQ3_MASK, ASU_EAM_GD, 18, 1)
    FIELD(PMC_IRQ3_MASK, PSX_EAM_E3, 17, 1)
    FIELD(PMC_IRQ3_MASK, PSX_EAM_E2, 16, 1)
    FIELD(PMC_IRQ3_MASK, PSX_EAM_E1, 15, 1)
    FIELD(PMC_IRQ3_MASK, PSX_EAM_E0, 14, 1)
    FIELD(PMC_IRQ3_MASK, PCR_PAR, 13, 1)
    FIELD(PMC_IRQ3_MASK, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_IRQ3_MASK, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_IRQ3_MASK, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_IRQ3_MASK, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_IRQ3_MASK, DME_PUB_Y, 8, 1)
    FIELD(PMC_IRQ3_MASK, DME_PUB_X, 7, 1)
    FIELD(PMC_IRQ3_MASK, DEVAK_PRIV, 6, 1)
    FIELD(PMC_IRQ3_MASK, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_IRQ3_MASK, DEVIK_PRIV, 4, 1)
    FIELD(PMC_IRQ3_MASK, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_IRQ3_MASK, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_IRQ3_MASK, IOU_NCR, 1, 1)
    FIELD(PMC_IRQ3_MASK, IOU_CR, 0, 1)
REG32(PMC_IRQ3_EN, 0x134)
    FIELD(PMC_IRQ3_EN, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_IRQ3_EN, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_IRQ3_EN, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_IRQ3_EN, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_IRQ3_EN, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_IRQ3_EN, PMC_EAM_GD, 19, 1)
    FIELD(PMC_IRQ3_EN, ASU_EAM_GD, 18, 1)
    FIELD(PMC_IRQ3_EN, PSX_EAM_E3, 17, 1)
    FIELD(PMC_IRQ3_EN, PSX_EAM_E2, 16, 1)
    FIELD(PMC_IRQ3_EN, PSX_EAM_E1, 15, 1)
    FIELD(PMC_IRQ3_EN, PSX_EAM_E0, 14, 1)
    FIELD(PMC_IRQ3_EN, PCR_PAR, 13, 1)
    FIELD(PMC_IRQ3_EN, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_IRQ3_EN, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_IRQ3_EN, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_IRQ3_EN, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_IRQ3_EN, DME_PUB_Y, 8, 1)
    FIELD(PMC_IRQ3_EN, DME_PUB_X, 7, 1)
    FIELD(PMC_IRQ3_EN, DEVAK_PRIV, 6, 1)
    FIELD(PMC_IRQ3_EN, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_IRQ3_EN, DEVIK_PRIV, 4, 1)
    FIELD(PMC_IRQ3_EN, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_IRQ3_EN, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_IRQ3_EN, IOU_NCR, 1, 1)
    FIELD(PMC_IRQ3_EN, IOU_CR, 0, 1)
REG32(PMC_IRQ3_DIS, 0x138)
    FIELD(PMC_IRQ3_DIS, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_IRQ3_DIS, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_IRQ3_DIS, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_IRQ3_DIS, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_IRQ3_DIS, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_IRQ3_DIS, PMC_EAM_GD, 19, 1)
    FIELD(PMC_IRQ3_DIS, ASU_EAM_GD, 18, 1)
    FIELD(PMC_IRQ3_DIS, PSX_EAM_E3, 17, 1)
    FIELD(PMC_IRQ3_DIS, PSX_EAM_E2, 16, 1)
    FIELD(PMC_IRQ3_DIS, PSX_EAM_E1, 15, 1)
    FIELD(PMC_IRQ3_DIS, PSX_EAM_E0, 14, 1)
    FIELD(PMC_IRQ3_DIS, PCR_PAR, 13, 1)
    FIELD(PMC_IRQ3_DIS, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_IRQ3_DIS, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_IRQ3_DIS, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_IRQ3_DIS, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_IRQ3_DIS, DME_PUB_Y, 8, 1)
    FIELD(PMC_IRQ3_DIS, DME_PUB_X, 7, 1)
    FIELD(PMC_IRQ3_DIS, DEVAK_PRIV, 6, 1)
    FIELD(PMC_IRQ3_DIS, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_IRQ3_DIS, DEVIK_PRIV, 4, 1)
    FIELD(PMC_IRQ3_DIS, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_IRQ3_DIS, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_IRQ3_DIS, IOU_NCR, 1, 1)
    FIELD(PMC_IRQ3_DIS, IOU_CR, 0, 1)
REG32(PMC_SRST3_MASK, 0x140)
    FIELD(PMC_SRST3_MASK, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_SRST3_MASK, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_SRST3_MASK, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_SRST3_MASK, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_SRST3_MASK, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_SRST3_MASK, PMC_EAM_GD, 19, 1)
    FIELD(PMC_SRST3_MASK, ASU_EAM_GD, 18, 1)
    FIELD(PMC_SRST3_MASK, PSX_EAM_E3, 17, 1)
    FIELD(PMC_SRST3_MASK, PSX_EAM_E2, 16, 1)
    FIELD(PMC_SRST3_MASK, PSX_EAM_E1, 15, 1)
    FIELD(PMC_SRST3_MASK, PSX_EAM_E0, 14, 1)
    FIELD(PMC_SRST3_MASK, PCR_PAR, 13, 1)
    FIELD(PMC_SRST3_MASK, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_SRST3_MASK, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_SRST3_MASK, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_SRST3_MASK, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_SRST3_MASK, DME_PUB_Y, 8, 1)
    FIELD(PMC_SRST3_MASK, DME_PUB_X, 7, 1)
    FIELD(PMC_SRST3_MASK, DEVAK_PRIV, 6, 1)
    FIELD(PMC_SRST3_MASK, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_SRST3_MASK, DEVIK_PRIV, 4, 1)
    FIELD(PMC_SRST3_MASK, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_SRST3_MASK, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_SRST3_MASK, IOU_NCR, 1, 1)
    FIELD(PMC_SRST3_MASK, IOU_CR, 0, 1)
REG32(PMC_SRST3_EN, 0x144)
    FIELD(PMC_SRST3_EN, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_SRST3_EN, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_SRST3_EN, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_SRST3_EN, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_SRST3_EN, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_SRST3_EN, PMC_EAM_GD, 19, 1)
    FIELD(PMC_SRST3_EN, ASU_EAM_GD, 18, 1)
    FIELD(PMC_SRST3_EN, PSX_EAM_E3, 17, 1)
    FIELD(PMC_SRST3_EN, PSX_EAM_E2, 16, 1)
    FIELD(PMC_SRST3_EN, PSX_EAM_E1, 15, 1)
    FIELD(PMC_SRST3_EN, PSX_EAM_E0, 14, 1)
    FIELD(PMC_SRST3_EN, PCR_PAR, 13, 1)
    FIELD(PMC_SRST3_EN, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_SRST3_EN, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_SRST3_EN, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_SRST3_EN, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_SRST3_EN, DME_PUB_Y, 8, 1)
    FIELD(PMC_SRST3_EN, DME_PUB_X, 7, 1)
    FIELD(PMC_SRST3_EN, DEVAK_PRIV, 6, 1)
    FIELD(PMC_SRST3_EN, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_SRST3_EN, DEVIK_PRIV, 4, 1)
    FIELD(PMC_SRST3_EN, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_SRST3_EN, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_SRST3_EN, IOU_NCR, 1, 1)
    FIELD(PMC_SRST3_EN, IOU_CR, 0, 1)
REG32(PMC_SRST3_DIS, 0x148)
    FIELD(PMC_SRST3_DIS, PMC_EAM_UFSFE, 24, 1)
    FIELD(PMC_SRST3_DIS, PMC_EAM_AGERR, 23, 1)
    FIELD(PMC_SRST3_DIS, PMC_EAM_PRAM, 22, 1)
    FIELD(PMC_SRST3_DIS, PMC_EAM_SMIRQ1, 21, 1)
    FIELD(PMC_SRST3_DIS, PMC_EAM_SMIRQ0, 20, 1)
    FIELD(PMC_SRST3_DIS, PMC_EAM_GD, 19, 1)
    FIELD(PMC_SRST3_DIS, ASU_EAM_GD, 18, 1)
    FIELD(PMC_SRST3_DIS, PSX_EAM_E3, 17, 1)
    FIELD(PMC_SRST3_DIS, PSX_EAM_E2, 16, 1)
    FIELD(PMC_SRST3_DIS, PSX_EAM_E1, 15, 1)
    FIELD(PMC_SRST3_DIS, PSX_EAM_E0, 14, 1)
    FIELD(PMC_SRST3_DIS, PCR_PAR, 13, 1)
    FIELD(PMC_SRST3_DIS, DEVIK_PUB_Y, 12, 1)
    FIELD(PMC_SRST3_DIS, DEVIK_PUB_X, 11, 1)
    FIELD(PMC_SRST3_DIS, DEVAK_PUB_Y, 10, 1)
    FIELD(PMC_SRST3_DIS, DEVAK_PUB_X, 9, 1)
    FIELD(PMC_SRST3_DIS, DME_PUB_Y, 8, 1)
    FIELD(PMC_SRST3_DIS, DME_PUB_X, 7, 1)
    FIELD(PMC_SRST3_DIS, DEVAK_PRIV, 6, 1)
    FIELD(PMC_SRST3_DIS, NXTSW_CDI_PAR, 5, 1)
    FIELD(PMC_SRST3_DIS, DEVIK_PRIV, 4, 1)
    FIELD(PMC_SRST3_DIS, DICE_CDI_PAR, 3, 1)
    FIELD(PMC_SRST3_DIS, DFX_UXPT_ACT, 2, 1)
    FIELD(PMC_SRST3_DIS, IOU_NCR, 1, 1)
    FIELD(PMC_SRST3_DIS, IOU_CR, 0, 1)
REG32(ERROR_MANAGEMENT_POR_LOCK, 0x200)
    FIELD(ERROR_MANAGEMENT_POR_LOCK, LOCK, 0, 1)

#define PMXC_ERR_R_MAX (R_ERROR_MANAGEMENT_POR_LOCK + 1)

typedef struct PMXC_ERR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq;

    uint32_t regs[PMXC_ERR_R_MAX];
    RegisterInfo regs_info[PMXC_ERR_R_MAX];
} PMXC_ERR;

static void pmxc_err_int_en(RegisterInfo *reg, uint64_t val)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(reg->opaque);
    uint32_t val32 = val;

    switch (reg->access->addr) {
    case A_PMC_ERR_OUT1_EN:
        s->regs[R_PMC_ERR_OUT1_MASK] &= ~(val32);
        break;
    case A_PMC_ERR_OUT2_EN:
        s->regs[R_PMC_ERR_OUT2_MASK] &= ~(val32);
        break;
    case A_PMC_POR1_EN:
        s->regs[R_PMC_POR1_MASK] &= ~(val32);
        break;
    case A_PMC_POR2_EN:
        s->regs[R_PMC_POR2_MASK] &= ~(val32);
        break;
    case A_PMC_IRQ1_EN:
        s->regs[R_PMC_IRQ1_MASK] &= ~(val32);
        break;
    case A_PMC_IRQ2_EN:
        s->regs[R_PMC_IRQ2_MASK] &= ~(val32);
        break;
    case A_PMC_SRST1_EN:
        s->regs[R_PMC_SRST1_MASK] &= ~(val32);
        break;
    case A_PMC_SRST2_EN:
        s->regs[R_PMC_SRST2_MASK] &= ~(val32);
        break;
    case A_PMC_ERR_OUT3_EN:
        s->regs[R_PMC_ERR_OUT3_MASK] &= ~(val32);
        break;
    case A_PMC_POR3_EN:
        s->regs[R_PMC_POR3_MASK] &= ~(val32);
        break;
    case A_PMC_IRQ3_EN:
        s->regs[R_PMC_IRQ3_MASK] &= ~(val32);
        break;
    case A_PMC_SRST3_EN:
        s->regs[R_PMC_SRST3_MASK] &= ~(val32);
        break;
    };
}

static void pmxc_err_int_dis(RegisterInfo *reg, uint64_t val)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(reg->opaque);
    uint32_t val32 = val;

    switch (reg->access->addr) {
    case A_PMC_ERR_OUT1_DIS:
        s->regs[R_PMC_ERR_OUT1_MASK] |= val32;
        break;
    case A_PMC_ERR_OUT2_DIS:
        s->regs[R_PMC_ERR_OUT2_MASK] |= val32;
        break;
    case A_PMC_POR1_DIS:
        s->regs[R_PMC_POR1_MASK] |= val32;
        break;
    case A_PMC_POR2_DIS:
        s->regs[R_PMC_POR2_MASK] |= val32;
        break;
    case A_PMC_IRQ1_DIS:
        s->regs[R_PMC_IRQ1_MASK] |= val32;
        break;
    case A_PMC_IRQ2_DIS:
        s->regs[R_PMC_IRQ2_MASK] |= val32;
        break;
    case A_PMC_SRST1_DIS:
        s->regs[R_PMC_SRST1_MASK] |= val32;
        break;
    case A_PMC_SRST2_DIS:
        s->regs[R_PMC_SRST2_MASK] |= val32;
        break;
    case A_PMC_ERR_OUT3_DIS:
        s->regs[R_PMC_ERR_OUT3_MASK] |= val32;
        break;
    case A_PMC_POR3_DIS:
        s->regs[R_PMC_POR3_MASK] |= val32;
        break;
    case A_PMC_IRQ3_DIS:
        s->regs[R_PMC_IRQ3_MASK] |= val32;
        break;
    case A_PMC_SRST3_DIS:
        s->regs[R_PMC_SRST3_MASK] |= val32;
        break;
    };
}

static void pmxc_err_update(PMXC_ERR *s)
{
    qemu_set_irq(s->irq, !!(
                               (~(s->regs[R_PMC_IRQ1_MASK]) &
                               s->regs[R_PMC_ERR1_STATUS]) ||
                               (~(s->regs[R_PMC_IRQ2_MASK]) &
                               s->regs[R_PMC_ERR2_STATUS]) ||
                               (~(s->regs[R_PMC_IRQ3_MASK]) &
                               s->regs[R_PMC_ERR3_STATUS])
                               ));

}

static uint64_t pmxc_err1_trig_prew(RegisterInfo *reg, uint64_t val)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(reg->opaque);

    s->regs[R_PMC_ERR1_STATUS] |= val;
    pmxc_err_update(s);
    return 0;
}

static uint64_t pmxc_err2_trig_prew(RegisterInfo *reg, uint64_t val)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(reg->opaque);

    s->regs[R_PMC_ERR2_STATUS] |= val;
    pmxc_err_update(s);
    return 0;
}

static uint64_t pmxc_err3_trig_prew(RegisterInfo *reg, uint64_t val)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(reg->opaque);

    s->regs[R_PMC_ERR3_STATUS] |= val;
    pmxc_err_update(s);
    return 0;
}

static void pmxc_err_status_postw(RegisterInfo *reg, uint64_t val)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(reg->opaque);
    pmxc_err_update(s);
}

static const RegisterAccessInfo pmxc_global_regs_info[] = {
    {   .name = "PMC_ERR1_STATUS",  .addr = A_PMC_ERR1_STATUS,
        .rsvd = 0x300,
        .w1c = 0xffffffff,
        .post_write = pmxc_err_status_postw,
    },{ .name = "PMC_ERR2_STATUS",  .addr = A_PMC_ERR2_STATUS,
        .w1c = 0xffffffff,
        .post_write = pmxc_err_status_postw,
    },{ .name = "PMC_ERR3_STATUS",  .addr = A_PMC_ERR3_STATUS,
        .rsvd = 0xfe000000,
        .w1c = 0xffffffff,
        .post_write = pmxc_err_status_postw,
    },{ .name = "PMC_ERR1_TRIG",  .addr = A_PMC_ERR1_TRIG,
        .rsvd = 0x300,
        .pre_write = pmxc_err1_trig_prew,
    },{ .name = "PMC_ERR2_TRIG",  .addr = A_PMC_ERR2_TRIG,
        .pre_write = pmxc_err2_trig_prew,
    },{ .name = "PMC_ERR3_TRIG",  .addr = A_PMC_ERR3_TRIG,
        .rsvd = 0xfe000000,
        .pre_write = pmxc_err3_trig_prew,
    },{ .name = "PMC_ERR_OUT1_MASK",  .addr = A_PMC_ERR_OUT1_MASK,
        .reset = 0xffffffff,
        .rsvd = 0x300,
        .ro = 0xffffffff,
    },{ .name = "PMC_ERR_OUT1_EN",  .addr = A_PMC_ERR_OUT1_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0x300,
    },{ .name = "PMC_ERR_OUT1_DIS",  .addr = A_PMC_ERR_OUT1_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0x300,
    },{ .name = "PMC_ERR_OUT2_MASK",  .addr = A_PMC_ERR_OUT2_MASK,
        .reset = 0xffefffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_ERR_OUT2_EN",  .addr = A_PMC_ERR_OUT2_EN,
        .post_write = pmxc_err_int_en,
    },{ .name = "PMC_ERR_OUT2_DIS",  .addr = A_PMC_ERR_OUT2_DIS,
        .post_write = pmxc_err_int_dis,
    },{ .name = "PMC_POR1_MASK",  .addr = A_PMC_POR1_MASK,
        .reset = 0xffffffff,
        .rsvd = 0x300,
        .ro = 0xffffffff,
    },{ .name = "PMC_POR1_EN",  .addr = A_PMC_POR1_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0x300,
    },{ .name = "PMC_POR1_DIS",  .addr = A_PMC_POR1_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0x300,
    },{ .name = "PMC_POR2_MASK",  .addr = A_PMC_POR2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_POR2_EN",  .addr = A_PMC_POR2_EN,
        .post_write = pmxc_err_int_en,
    },{ .name = "PMC_POR2_DIS",  .addr = A_PMC_POR2_DIS,
        .post_write = pmxc_err_int_dis,
    },{ .name = "PMC_IRQ1_MASK",  .addr = A_PMC_IRQ1_MASK,
        .reset = 0xffffffff,
        .rsvd = 0x300,
        .ro = 0xffffffff,
    },{ .name = "PMC_IRQ1_EN",  .addr = A_PMC_IRQ1_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0x300,
    },{ .name = "PMC_IRQ1_DIS",  .addr = A_PMC_IRQ1_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0x300,
    },{ .name = "PMC_IRQ2_MASK",  .addr = A_PMC_IRQ2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_IRQ2_EN",  .addr = A_PMC_IRQ2_EN,
        .post_write = pmxc_err_int_en,
    },{ .name = "PMC_IRQ2_DIS",  .addr = A_PMC_IRQ2_DIS,
        .post_write = pmxc_err_int_dis,
    },{ .name = "PMC_SRST1_MASK",  .addr = A_PMC_SRST1_MASK,
        .reset = 0xffffffff,
        .rsvd = 0x300,
        .ro = 0xffffffff,
    },{ .name = "PMC_SRST1_EN",  .addr = A_PMC_SRST1_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0x300,
    },{ .name = "PMC_SRST1_DIS",  .addr = A_PMC_SRST1_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0x300,
    },{ .name = "PMC_SRST2_MASK",  .addr = A_PMC_SRST2_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "PMC_SRST2_EN",  .addr = A_PMC_SRST2_EN,
        .post_write = pmxc_err_int_en,
    },{ .name = "PMC_SRST2_DIS",  .addr = A_PMC_SRST2_DIS,
        .post_write = pmxc_err_int_dis,
    },{ .name = "PMC_BOOT_ERR",  .addr = A_PMC_BOOT_ERR,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "PMC_ERR_OUT3_MASK",  .addr = A_PMC_ERR_OUT3_MASK,
        .reset = 0xffffffff,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "PMC_ERR_OUT3_EN",  .addr = A_PMC_ERR_OUT3_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_ERR_OUT3_DIS",  .addr = A_PMC_ERR_OUT3_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_POR3_MASK",  .addr = A_PMC_POR3_MASK,
        .reset = 0xffffffff,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "PMC_POR3_EN",  .addr = A_PMC_POR3_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_POR3_DIS",  .addr = A_PMC_POR3_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_IRQ3_MASK",  .addr = A_PMC_IRQ3_MASK,
        .reset = 0xffffffff,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "PMC_IRQ3_EN",  .addr = A_PMC_IRQ3_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_IRQ3_DIS",  .addr = A_PMC_IRQ3_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_SRST3_MASK",  .addr = A_PMC_SRST3_MASK,
        .reset = 0xffffffff,
        .rsvd = 0xfe000000,
        .ro = 0xffffffff,
    },{ .name = "PMC_SRST3_EN",  .addr = A_PMC_SRST3_EN,
        .post_write = pmxc_err_int_en,
        .rsvd = 0xfe000000,
    },{ .name = "PMC_SRST3_DIS",  .addr = A_PMC_SRST3_DIS,
        .post_write = pmxc_err_int_dis,
        .rsvd = 0xfe000000,
    },{ .name = "ERROR_MANAGEMENT_POR_LOCK",
        .addr = A_ERROR_MANAGEMENT_POR_LOCK,
    }
};

static void pmxc_global_reset_enter(Object *obj, ResetType type)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void pmx_analog_tamper(void *opaque, int n, int level)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(opaque);

    ARRAY_FIELD_DP32(s->regs, PMC_ERR2_STATUS, PMC_APB, level);
    pmxc_err_update(s);
}

static void pmx_eam_err(void *opaque, int n, int level)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(opaque);

    s->regs[R_PMC_ERR3_STATUS] |=
           level << (n - 1 + R_PMC_ERR3_STATUS_PSX_EAM_E0_SHIFT);
}

static const MemoryRegionOps pmxc_global_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmxc_global_init(Object *obj)
{
    PMXC_ERR *s = XILINX_PMXC_ERR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMXC_ERR,
                        PMXC_ERR_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmxc_global_regs_info,
                              ARRAY_SIZE(pmxc_global_regs_info),
                              s->regs_info, s->regs,
                              &pmxc_global_ops,
                              XILINX_PMXC_ERR_DEBUG,
                              PMXC_ERR_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    qdev_init_gpio_in(DEVICE(obj), pmx_analog_tamper, 1);
    qdev_init_gpio_in(DEVICE(obj), pmx_eam_err, 4);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq);
}

static const VMStateDescription vmstate_pmxc_global = {
    .name = TYPE_XILINX_PMXC_ERR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMXC_ERR, PMXC_ERR_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmxc_global_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_pmxc_global;
    rc->phases.enter = pmxc_global_reset_enter;
}

static const TypeInfo pmxc_global_info = {
    .name          = TYPE_XILINX_PMXC_ERR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMXC_ERR),
    .class_init    = pmxc_global_class_init,
    .instance_init = pmxc_global_init,
};

static void pmxc_global_register_types(void)
{
    type_register_static(&pmxc_global_info);
}

type_init(pmxc_global_register_types)
