/*
 * QEMU model of the PMXC_INTPMX_CONFIG INTPMX Interconnect isolation (reset
 * and status registers)
 *
 * Copyright (c) 2024 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2024-08-29.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"

#define TYPE_XILINX_PMXC_INTPMX_CONFIG "xlnx.pmxc_intpmx_config"

#define XILINX_PMXC_INTPMX_CONFIG(obj) \
     OBJECT_CHECK(PMXC_INTPMX_CONFIG, (obj), TYPE_XILINX_PMXC_INTPMX_CONFIG)

#define XILINX_PMXC_INTPMX_CONFIG_DEBUG 0

REG32(TOP_LVL_CORR_ERR_SRC_REGS, 0x0)
    FIELD(TOP_LVL_CORR_ERR_SRC_REGS, CORR_ERR_SRC_REGS_1, 1, 1)
    FIELD(TOP_LVL_CORR_ERR_SRC_REGS, CORR_ERR_SRC_REGS_0, 0, 1)
REG32(CORR_ERR_SRC_REGS_0, 0x4)
    FIELD(CORR_ERR_SRC_REGS_0, SYSMONROOT_INTPMX_MERB, 31, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PS_PMC_AXI_MERB, 30, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PPU1_INTPMX_MERB, 29, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PPU0_INTPMX_MERB, 28, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMCDMA1_INTPMX_MERB, 27, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMCDMA0_INTPMX_MERB, 26, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMC_PS_AXI_SERB, 25, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMC_NOC_AXI_SERB, 24, 1)
    FIELD(CORR_ERR_SRC_REGS_0, NOC_PMC_AXI_MERB, 23, 1)
    FIELD(CORR_ERR_SRC_REGS_0, JTAG_INTPMX_MERB, 22, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMXIOU_INTPMX_MERB, 21, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_SBI_SERB, 20, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_PPU1MDMSHD_SERB, 19, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_PPU0MDMSHD_SERB, 18, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_PMCOCM_SERB, 17, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_NPI_SERB, 16, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_INTPMXIOU_SERB, 15, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_INTLPXIOU_SERB, 14, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_EFUSE_SERB, 13, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_CFUSTREAM_SERB, 12, 1)
    FIELD(CORR_ERR_SRC_REGS_0, INTPMX_CFU_APB_SERB, 11, 1)
    FIELD(CORR_ERR_SRC_REGS_0, DPC_INTPMX_MERB, 10, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_SYSMON_APB_SERB, 9, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_SECURE_APB_SERB, 8, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_RTC_APB_SERB, 7, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_RST_INTCNTL_APB_SERB, 6, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_POWER_MSERB, 5, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_PPU_APB_SERB, 4, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_LSBUS_CLK_APB_SERB, 3, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_FIREWALL_APB_SERB, 2, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMX_DEBUG_APB_SERB, 1, 1)
    FIELD(CORR_ERR_SRC_REGS_0, PMCGLOBAL_APB_SERB, 0, 1)
REG32(CORR_ERR_SRC_REGS_1, 0x8)
    FIELD(CORR_ERR_SRC_REGS_1, XPPU_NPI_FIREWALL, 4, 1)
    FIELD(CORR_ERR_SRC_REGS_1, XPPU_FIREWALL, 3, 1)
    FIELD(CORR_ERR_SRC_REGS_1, XMPU_SBI_FIREWALL, 2, 1)
    FIELD(CORR_ERR_SRC_REGS_1, XMPU_PRAM_FIREWALL, 1, 1)
    FIELD(CORR_ERR_SRC_REGS_1, XMPU_CFU_FIREWALL, 0, 1)
REG32(TOP_LVL_UNCORR_ERR_SRC_REGS, 0x1000)
    FIELD(TOP_LVL_UNCORR_ERR_SRC_REGS, UNCORR_ERR_SRC_REGS_1, 1, 1)
    FIELD(TOP_LVL_UNCORR_ERR_SRC_REGS, UNCORR_ERR_SRC_REGS_0, 0, 1)
REG32(UNCORR_ERR_SRC_REGS_0, 0x1004)
    FIELD(UNCORR_ERR_SRC_REGS_0, SYSMONROOT_INTPMX_MERB, 31, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PS_PMC_AXI_MERB, 30, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PPU1_INTPMX_MERB, 29, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PPU0_INTPMX_MERB, 28, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMCDMA1_INTPMX_MERB, 27, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMCDMA0_INTPMX_MERB, 26, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMC_PS_AXI_SERB, 25, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMC_NOC_AXI_SERB, 24, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, NOC_PMC_AXI_MERB, 23, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, JTAG_INTPMX_MERB, 22, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMXIOU_INTPMX_MERB, 21, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_SBI_SERB, 20, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_PPU1MDMSHD_SERB, 19, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_PPU0MDMSHD_SERB, 18, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_PMCOCM_SERB, 17, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_NPI_SERB, 16, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_INTPMXIOU_SERB, 15, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_INTLPXIOU_SERB, 14, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_EFUSE_SERB, 13, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_CFUSTREAM_SERB, 12, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, INTPMX_CFU_APB_SERB, 11, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, DPC_INTPMX_MERB, 10, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_SYSMON_APB_SERB, 9, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_SECURE_APB_SERB, 8, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_RTC_APB_SERB, 7, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_RST_INTCNTL_APB_SERB, 6, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_POWER_MSERB, 5, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_PPU_APB_SERB, 4, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_LSBUS_CLK_APB_SERB, 3, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_FIREWALL_APB_SERB, 2, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMX_DEBUG_APB_SERB, 1, 1)
    FIELD(UNCORR_ERR_SRC_REGS_0, PMCGLOBAL_APB_SERB, 0, 1)
REG32(UNCORR_ERR_SRC_REGS_1, 0x1008)
    FIELD(UNCORR_ERR_SRC_REGS_1, XPPU_NPI_FIREWALL, 4, 1)
    FIELD(UNCORR_ERR_SRC_REGS_1, XPPU_FIREWALL, 3, 1)
    FIELD(UNCORR_ERR_SRC_REGS_1, XMPU_SBI_FIREWALL, 2, 1)
    FIELD(UNCORR_ERR_SRC_REGS_1, XMPU_PRAM_FIREWALL, 1, 1)
    FIELD(UNCORR_ERR_SRC_REGS_1, XMPU_CFU_FIREWALL, 0, 1)
REG32(TOP_LVL_INTR_SRC_REGS, 0x2000)
    FIELD(TOP_LVL_INTR_SRC_REGS, TRACE_ALARM_0_REG, 1, 1)
    FIELD(TOP_LVL_INTR_SRC_REGS, INTR_SRC_REGS_0, 0, 1)
REG32(INTR_SRC_REGS_0, 0x2004)
    FIELD(INTR_SRC_REGS_0, SYSMONROOT_INTPMX_MERB, 31, 1)
    FIELD(INTR_SRC_REGS_0, PS_PMC_AXI_MERB, 30, 1)
    FIELD(INTR_SRC_REGS_0, PPU1_INTPMX_MERB, 29, 1)
    FIELD(INTR_SRC_REGS_0, PPU0_INTPMX_MERB, 28, 1)
    FIELD(INTR_SRC_REGS_0, PMCDMA1_INTPMX_MERB, 27, 1)
    FIELD(INTR_SRC_REGS_0, PMCDMA0_INTPMX_MERB, 26, 1)
    FIELD(INTR_SRC_REGS_0, PMC_PS_AXI_SERB, 25, 1)
    FIELD(INTR_SRC_REGS_0, PMC_NOC_AXI_SERB, 24, 1)
    FIELD(INTR_SRC_REGS_0, NOC_PMC_AXI_MERB, 23, 1)
    FIELD(INTR_SRC_REGS_0, JTAG_INTPMX_MERB, 22, 1)
    FIELD(INTR_SRC_REGS_0, INTPMXIOU_INTPMX_MERB, 21, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_SBI_SERB, 20, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_PPU1MDMSHD_SERB, 19, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_PPU0MDMSHD_SERB, 18, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_PMCOCM_SERB, 17, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_NPI_SERB, 16, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_INTPMXIOU_SERB, 15, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_INTLPXIOU_SERB, 14, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_EFUSE_SERB, 13, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_CFUSTREAM_SERB, 12, 1)
    FIELD(INTR_SRC_REGS_0, INTPMX_CFU_APB_SERB, 11, 1)
    FIELD(INTR_SRC_REGS_0, DPC_INTPMX_MERB, 10, 1)
    FIELD(INTR_SRC_REGS_0, PMX_SYSMON_APB_SERB, 9, 1)
    FIELD(INTR_SRC_REGS_0, PMX_SECURE_APB_SERB, 8, 1)
    FIELD(INTR_SRC_REGS_0, PMX_RTC_APB_SERB, 7, 1)
    FIELD(INTR_SRC_REGS_0, PMX_RST_INTCNTL_APB_SERB, 6, 1)
    FIELD(INTR_SRC_REGS_0, PMX_POWER_MSERB, 5, 1)
    FIELD(INTR_SRC_REGS_0, PMX_PPU_APB_SERB, 4, 1)
    FIELD(INTR_SRC_REGS_0, PMX_LSBUS_CLK_APB_SERB, 3, 1)
    FIELD(INTR_SRC_REGS_0, PMX_FIREWALL_APB_SERB, 2, 1)
    FIELD(INTR_SRC_REGS_0, PMX_DEBUG_APB_SERB, 1, 1)
    FIELD(INTR_SRC_REGS_0, PMCGLOBAL_APB_SERB, 0, 1)
REG32(SAFETY_CHK_REG, 0x3000)
REG32(XMPU_CFU_FIREWALL_CNTL_ERR_TYPE, 0x3008)
    FIELD(XMPU_CFU_FIREWALL_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(XMPU_PRAM_FIREWALL_CNTL_ERR_TYPE, 0x300c)
    FIELD(XMPU_PRAM_FIREWALL_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(XMPU_SBI_FIREWALL_CNTL_ERR_TYPE, 0x3010)
    FIELD(XMPU_SBI_FIREWALL_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(XPPU_FIREWALL_CNTL_ERR_TYPE, 0x3014)
    FIELD(XPPU_FIREWALL_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(XPPU_NPI_FIREWALL_CNTL_ERR_TYPE, 0x3018)
    FIELD(XPPU_NPI_FIREWALL_CNTL_ERR_TYPE, ERR_CORR, 0, 1)
REG32(XMPU_CFU_FIREWALL_CNTL_XMPU_ALIGN_CFG, 0x301c)
    FIELD(XMPU_CFU_FIREWALL_CNTL_XMPU_ALIGN_CFG, XMPU_ALIGN_CFG, 0, 1)
REG32(XMPU_PRAM_FIREWALL_CNTL_XMPU_ALIGN_CFG, 0x3020)
    FIELD(XMPU_PRAM_FIREWALL_CNTL_XMPU_ALIGN_CFG, XMPU_ALIGN_CFG, 0, 1)
REG32(XMPU_SBI_FIREWALL_CNTL_XMPU_ALIGN_CFG, 0x3024)
    FIELD(XMPU_SBI_FIREWALL_CNTL_XMPU_ALIGN_CFG, XMPU_ALIGN_CFG, 0, 1)
REG32(INTPMX_CNTL_PARITY_INJ, 0x3028)
    FIELD(INTPMX_CNTL_PARITY_INJ, PARITY_INJ_BYTE, 4, 5)
    FIELD(INTPMX_CNTL_PARITY_INJ, PARITY_INJ_BIT, 0, 4)
REG32(INTPMX_TEST_MODE_CFG, 0x303c)
REG32(PPU1_PARERR_TO_SLVERR, 0x3040)
    FIELD(PPU1_PARERR_TO_SLVERR, PARERR_TO_SLVERR_EN, 0, 1)
REG32(TRACE_THRESHOLD, 0xb000)
    FIELD(TRACE_THRESHOLD, PMC_WR_RESP_PROBE_FIFO_MAINPLDTHRESHOLDVAL, 24, 8)
    FIELD(TRACE_THRESHOLD, PMC_WR_REQ_PROBE_FIFO_MAINPLDTHRESHOLDVAL, 16, 8)
    FIELD(TRACE_THRESHOLD, PMC_RD_RESP_PROBE_FIFO_MAINPLDTHRESHOLDVAL, 8, 8)
    FIELD(TRACE_THRESHOLD, PMC_RD_REQ_PROBE_FIFO_MAINPLDTHRESHOLDVAL, 0, 8)
REG32(TRACE_ALARM_0_ISR_REG, 0xc000)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_WR_RESP_PROBE_FIFO_MAINFIFOFULL, 11, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_WR_REQ_PROBE_FIFO_MAINFIFOFULL, 10, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_RD_RESP_PROBE_FIFO_MAINFIFOFULL, 9, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_RD_REQ_PROBE_FIFO_MAINFIFOFULL, 8, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_WR_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 7,
            1) FIELD(TRACE_ALARM_0_ISR_REG,
                PMC_WR_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 6, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_RD_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 5,
            1) FIELD(TRACE_ALARM_0_ISR_REG,
                PMC_RD_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 4, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_WR_RESP_PROBE_MAINTRACEALARM, 3, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_WR_REQ_PROBE_MAINTRACEALARM, 2, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_RD_RESP_PROBE_MAINTRACEALARM, 1, 1)
    FIELD(TRACE_ALARM_0_ISR_REG, PMC_RD_REQ_PROBE_MAINTRACEALARM, 0, 1)
REG32(TRACE_ALARM_0_IMR_REG, 0xc004)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_WR_RESP_PROBE_FIFO_MAINFIFOFULL, 11, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_WR_REQ_PROBE_FIFO_MAINFIFOFULL, 10, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_RD_RESP_PROBE_FIFO_MAINFIFOFULL, 9, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_RD_REQ_PROBE_FIFO_MAINFIFOFULL, 8, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_WR_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 7,
            1) FIELD(TRACE_ALARM_0_IMR_REG,
                PMC_WR_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 6, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_RD_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 5,
            1) FIELD(TRACE_ALARM_0_IMR_REG,
                PMC_RD_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 4, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_WR_RESP_PROBE_MAINTRACEALARM, 3, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_WR_REQ_PROBE_MAINTRACEALARM, 2, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_RD_RESP_PROBE_MAINTRACEALARM, 1, 1)
    FIELD(TRACE_ALARM_0_IMR_REG, PMC_RD_REQ_PROBE_MAINTRACEALARM, 0, 1)
REG32(TRACE_ALARM_0_IER_REG, 0xc008)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_WR_RESP_PROBE_FIFO_MAINFIFOFULL, 11, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_WR_REQ_PROBE_FIFO_MAINFIFOFULL, 10, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_RD_RESP_PROBE_FIFO_MAINFIFOFULL, 9, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_RD_REQ_PROBE_FIFO_MAINFIFOFULL, 8, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_WR_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 7,
            1) FIELD(TRACE_ALARM_0_IER_REG,
                PMC_WR_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 6, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_RD_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 5,
            1) FIELD(TRACE_ALARM_0_IER_REG,
                PMC_RD_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 4, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_WR_RESP_PROBE_MAINTRACEALARM, 3, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_WR_REQ_PROBE_MAINTRACEALARM, 2, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_RD_RESP_PROBE_MAINTRACEALARM, 1, 1)
    FIELD(TRACE_ALARM_0_IER_REG, PMC_RD_REQ_PROBE_MAINTRACEALARM, 0, 1)
REG32(TRACE_ALARM_0_IDR_REG, 0xc00c)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_WR_RESP_PROBE_FIFO_MAINFIFOFULL, 11, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_WR_REQ_PROBE_FIFO_MAINFIFOFULL, 10, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_RD_RESP_PROBE_FIFO_MAINFIFOFULL, 9, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_RD_REQ_PROBE_FIFO_MAINFIFOFULL, 8, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_WR_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 7,
            1) FIELD(TRACE_ALARM_0_IDR_REG,
                PMC_WR_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 6, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_RD_RESP_PROBE_FIFO_MAINPLDTHRESREACHED, 5,
            1) FIELD(TRACE_ALARM_0_IDR_REG,
                PMC_RD_REQ_PROBE_FIFO_MAINPLDTHRESREACHED, 4, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_WR_RESP_PROBE_MAINTRACEALARM, 3, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_WR_REQ_PROBE_MAINTRACEALARM, 2, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_RD_RESP_PROBE_MAINTRACEALARM, 1, 1)
    FIELD(TRACE_ALARM_0_IDR_REG, PMC_RD_REQ_PROBE_MAINTRACEALARM, 0, 1)
REG32(PMCGLOBAL_APB_SERB_MAIN_CR, 0x10000)
    FIELD(PMCGLOBAL_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ISO_CR, 0x1000c)
    FIELD(PMCGLOBAL_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMCGLOBAL_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ERR_TYP_CR, 0x10010)
    FIELD(PMCGLOBAL_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_TYP_CR, 0x10014)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_EN_CR, 0x10034)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_TEST_CR, 0x10054)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ISO_SR, 0x10074)
    FIELD(PMCGLOBAL_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMCGLOBAL_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMCGLOBAL_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMCGLOBAL_APB_SERB_TOP_ERR_SRC_SR, 0x10078)
    FIELD(PMCGLOBAL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PMCGLOBALREG_APB_ERROR_TYPE, 24, 1)
    FIELD(PMCGLOBAL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR, 16, 1)
    FIELD(PMCGLOBAL_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMCGLOBAL_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ERR_ISR, 0x1007c)
    FIELD(PMCGLOBAL_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMCGLOBAL_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ERR_IMR, 0x10080)
    FIELD(PMCGLOBAL_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMCGLOBAL_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ERR_IER, 0x10084)
    FIELD(PMCGLOBAL_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMCGLOBAL_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMCGLOBAL_APB_SERB_ERR_IDR, 0x10088)
    FIELD(PMCGLOBAL_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMCGLOBAL_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMCGLOBAL_APB_SERB_INTR_ISR, 0x10090)
    FIELD(PMCGLOBAL_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMCGLOBAL_APB_SERB_INTR_IMR, 0x10094)
    FIELD(PMCGLOBAL_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMCGLOBAL_APB_SERB_INTR_IER, 0x10098)
    FIELD(PMCGLOBAL_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMCGLOBAL_APB_SERB_INTR_IDR, 0x1009c)
    FIELD(PMCGLOBAL_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_ISR, 0x100a4)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IMR, 0x100a8)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IER, 0x100ac)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IDR, 0x100b0)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_DEBUG_APB_SERB_MAIN_CR, 0x20000)
    FIELD(PMX_DEBUG_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ISO_CR, 0x2000c)
    FIELD(PMX_DEBUG_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_DEBUG_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ERR_TYP_CR, 0x20010)
    FIELD(PMX_DEBUG_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_ERR_TYP_CR, 0x20014)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_ERR_TYP_CR, 0x20018)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_ERR_EN_CR, 0x20034)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_ERR_EN_CR, 0x20038)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_TEST_CR, 0x20054)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_TEST_CR, 0x20058)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ISO_SR, 0x20074)
    FIELD(PMX_DEBUG_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_DEBUG_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_DEBUG_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR, 0x20078)
    FIELD(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PMCTAP_APB_ERROR_TYPE,
            25, 1) FIELD(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_DAPREG_APB_ERROR_TYPE, 24, 1)
    FIELD(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PMCTAP_APB_INTF_ERR, 17,
            1) FIELD(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_DAPREG_APB_INTF_ERR, 16, 1)
    FIELD(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_DEBUG_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ERR_ISR, 0x2007c)
    FIELD(PMX_DEBUG_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_DEBUG_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ERR_IMR, 0x20080)
    FIELD(PMX_DEBUG_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_DEBUG_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ERR_IER, 0x20084)
    FIELD(PMX_DEBUG_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_DEBUG_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_DEBUG_APB_SERB_ERR_IDR, 0x20088)
    FIELD(PMX_DEBUG_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_DEBUG_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_DEBUG_APB_SERB_INTR_ISR, 0x20090)
    FIELD(PMX_DEBUG_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_DEBUG_APB_SERB_INTR_IMR, 0x20094)
    FIELD(PMX_DEBUG_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_DEBUG_APB_SERB_INTR_IER, 0x20098)
    FIELD(PMX_DEBUG_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_DEBUG_APB_SERB_INTR_IDR, 0x2009c)
    FIELD(PMX_DEBUG_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_ERR_ISR, 0x200a4)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_ERR_IMR, 0x200a8)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_ERR_IER, 0x200ac)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_DAPREG_APB_INTF_ERR_IDR, 0x200b0)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_DAPREG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_ERR_ISR, 0x200b8)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_ERR_IMR, 0x200bc)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_ERR_IER, 0x200c0)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCTAP_APB_INTF_ERR_IDR, 0x200c4)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCTAP_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_MAIN_CR, 0x30000)
    FIELD(PMX_FIREWALL_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ISO_CR, 0x3000c)
    FIELD(PMX_FIREWALL_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ERR_TYP_CR, 0x30010)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_TYP_CR, 0x30014)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_TYP_CR, 0x30018)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_TYP_CR, 0x3001c)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_ERR_TYP_CR, 0x30020)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_TYP_CR, 0x30024)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_EN_CR, 0x30034)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_EN_CR, 0x30038)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_EN_CR, 0x3003c)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_ERR_EN_CR, 0x30040)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_EN_CR, 0x30044)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_TEST_CR, 0x30054)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_TEST_CR, 0x30058)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_TEST_CR, 0x3005c)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_TEST_CR, 0x30060)
    FIELD(IF_INTPMX_XPPU_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_TEST_CR, 0x30064)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ISO_SR, 0x30074)
    FIELD(PMX_FIREWALL_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR, 0x30078)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_XPPU_NPI_APB_ERROR_TYPE, 28, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_XPPU_APB_ERROR_TYPE,
            27, 1) FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_XMPU_SBI_APB_ERROR_TYPE, 26, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_XMPU_PRAM_APB_ERROR_TYPE, 25, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_XMPU_CFU_APB_ERROR_TYPE, 24, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_XPPU_NPI_APB_INTF_ERR, 20, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_XPPU_APB_INTF_ERR,
            19, 1) FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_XMPU_SBI_APB_INTF_ERR, 18, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_XMPU_PRAM_APB_INTF_ERR, 17, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_XMPU_CFU_APB_INTF_ERR, 16, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_FIREWALL_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ERR_ISR, 0x3007c)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ERR_IMR, 0x30080)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ERR_IER, 0x30084)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_ERR_IDR, 0x30088)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_FIREWALL_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_INTR_ISR, 0x30090)
    FIELD(PMX_FIREWALL_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_INTR_IMR, 0x30094)
    FIELD(PMX_FIREWALL_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_INTR_IER, 0x30098)
    FIELD(PMX_FIREWALL_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_FIREWALL_APB_SERB_INTR_IDR, 0x3009c)
    FIELD(PMX_FIREWALL_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_ISR, 0x300a4)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IMR, 0x300a8)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IER, 0x300ac)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IDR, 0x300b0)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_ISR, 0x300b8)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IMR, 0x300bc)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IER, 0x300c0)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IDR, 0x300c4)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_ISR, 0x300cc)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IMR, 0x300d0)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IER, 0x300d4)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IDR, 0x300d8)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_ERR_ISR, 0x300e0)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_ERR_IMR, 0x300e4)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_ERR_IER, 0x300e8)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_APB_INTF_ERR_IDR, 0x300ec)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_ISR, 0x300f4)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IMR, 0x300f8)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IER, 0x300fc)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IDR, 0x30100)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_MAIN_CR, 0x40000)
    FIELD(PMX_LSBUS_CLK_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ISO_CR, 0x4000c)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ERR_TYP_CR, 0x40010)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_ERR_TYP_CR, 0x40014)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_ERR_TYP_CR, 0x40018)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_ERR_TYP_CR, 0x4001c)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_ERR_EN_CR, 0x40034)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_ERR_EN_CR, 0x40038)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_ERR_EN_CR, 0x4003c)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_TEST_CR, 0x40054)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_TEST_CR, 0x40058)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_TEST_CR, 0x4005c)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ISO_SR, 0x40074)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR, 0x40078)
    FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_SBIREG_APB_ERROR_TYPE, 26, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PMCANLG_APB_ERROR_TYPE, 25, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_BBRAM_APB_ERROR_TYPE, 24, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_SBIREG_APB_INTF_ERR,
            18, 1) FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_PMCANLG_APB_INTF_ERR, 17, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_BBRAM_APB_INTF_ERR,
            16, 1) FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE,
                1, 1) FIELD(PMX_LSBUS_CLK_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR,
                    0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ERR_ISR, 0x4007c)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ERR_IMR, 0x40080)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ERR_IER, 0x40084)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_ERR_IDR, 0x40088)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_LSBUS_CLK_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_INTR_ISR, 0x40090)
    FIELD(PMX_LSBUS_CLK_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_INTR_IMR, 0x40094)
    FIELD(PMX_LSBUS_CLK_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_INTR_IER, 0x40098)
    FIELD(PMX_LSBUS_CLK_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_LSBUS_CLK_APB_SERB_INTR_IDR, 0x4009c)
    FIELD(PMX_LSBUS_CLK_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_ERR_ISR, 0x400a4)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_ERR_IMR, 0x400a8)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_ERR_IER, 0x400ac)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_BBRAM_APB_INTF_ERR_IDR, 0x400b0)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_BBRAM_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_ERR_ISR, 0x400b8)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_ERR_IMR, 0x400bc)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_ERR_IER, 0x400c0)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCANLG_APB_INTF_ERR_IDR, 0x400c4)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCANLG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_ERR_ISR, 0x400cc)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_ERR_IMR, 0x400d0)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_ERR_IER, 0x400d4)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_SBIREG_APB_INTF_ERR_IDR, 0x400d8)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SBIREG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_PPU_APB_SERB_MAIN_CR, 0x50000)
    FIELD(PMX_PPU_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_PPU_APB_SERB_ISO_CR, 0x5000c)
    FIELD(PMX_PPU_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_PPU_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_PPU_APB_SERB_ERR_TYP_CR, 0x50010)
    FIELD(PMX_PPU_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_TYP_CR, 0x50014)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_TYP_CR, 0x50018)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_ERR_TYP_CR, 0x5001c)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_TYP_CR, 0x50020)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_EN_CR, 0x50034)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_EN_CR, 0x50038)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_ERR_EN_CR, 0x5003c)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_EN_CR, 0x50040)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_TEST_CR, 0x50054)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_TEST_CR, 0x50058)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_TEST_CR, 0x5005c)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_TEST_CR, 0x50060)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_PPU_APB_SERB_ISO_SR, 0x50074)
    FIELD(PMX_PPU_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_PPU_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_PPU_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, 0x50078)
    FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PPU1TMRTRACE_APB_ERROR_TYPE, 27, 1)
    FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PPU1RAM_APB_ERROR_TYPE,
            26, 1) FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_PPU0TMRTRACE_APB_ERROR_TYPE, 25, 1)
    FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PMCOCMCFG_APB_ERROR_TYPE,
            24, 1) FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR, 19, 1)
    FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PPU1RAM_APB_INTF_ERR, 18,
            1) FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR, 17, 1)
    FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PMCOCMCFG_APB_INTF_ERR,
            16, 1) FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_PPU_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_PPU_APB_SERB_ERR_ISR, 0x5007c)
    FIELD(PMX_PPU_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_PPU_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_PPU_APB_SERB_ERR_IMR, 0x50080)
    FIELD(PMX_PPU_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_PPU_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_PPU_APB_SERB_ERR_IER, 0x50084)
    FIELD(PMX_PPU_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_PPU_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_PPU_APB_SERB_ERR_IDR, 0x50088)
    FIELD(PMX_PPU_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_PPU_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_PPU_APB_SERB_INTR_ISR, 0x50090)
    FIELD(PMX_PPU_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_PPU_APB_SERB_INTR_IMR, 0x50094)
    FIELD(PMX_PPU_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_PPU_APB_SERB_INTR_IER, 0x50098)
    FIELD(PMX_PPU_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_PPU_APB_SERB_INTR_IDR, 0x5009c)
    FIELD(PMX_PPU_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_ISR, 0x500a4)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IMR, 0x500a8)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IER, 0x500ac)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IDR, 0x500b0)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_ISR, 0x500b8)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IMR, 0x500bc)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IER, 0x500c0)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IDR, 0x500c4)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_ERR_ISR, 0x500cc)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IMR, 0x500d0)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IER, 0x500d4)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IDR, 0x500d8)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1RAM_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_ISR, 0x500e0)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IMR, 0x500e4)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IER, 0x500e8)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IDR, 0x500ec)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_MAIN_CR, 0x60000)
    FIELD(PMX_RST_INTCNTL_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ISO_CR, 0x6000c)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ERR_TYP_CR, 0x60010)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_ERR_TYP_CR, 0x60014)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_ERR_TYP_CR, 0x60018)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_TYP_CR, 0x6001c)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_ERR_TYP_CR, 0x60020)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_ERR_EN_CR, 0x60034)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_ERR_EN_CR, 0x60038)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_EN_CR, 0x6003c)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_ERR_EN_CR, 0x60040)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_TEST_CR, 0x60054)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_TEST_CR, 0x60058)
    FIELD(IF_INTPMX_CRP_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_TEST_CR, 0x6005c)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_TEST_CR, 0x60060)
    FIELD(IF_INTPMX_WDT_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ISO_SR, 0x60074)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR, 0x60078)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_WDT_APB_ERROR_TYPE, 27, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_SLCRSECURE_APB_ERROR_TYPE, 26, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_CRP_APB_ERROR_TYPE, 25, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_CONFIG_APB_ERROR_TYPE, 24, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_WDT_APB_INTF_ERR,
            19, 1) FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_SLCRSECURE_APB_INTF_ERR, 18, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_CRP_APB_INTF_ERR,
            17, 1) FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_CONFIG_APB_INTF_ERR, 16, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ERR_ISR, 0x6007c)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ERR_IMR, 0x60080)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ERR_IER, 0x60084)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_ERR_IDR, 0x60088)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RST_INTCNTL_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_INTR_ISR, 0x60090)
    FIELD(PMX_RST_INTCNTL_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_INTR_IMR, 0x60094)
    FIELD(PMX_RST_INTCNTL_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_INTR_IER, 0x60098)
    FIELD(PMX_RST_INTCNTL_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_RST_INTCNTL_APB_SERB_INTR_IDR, 0x6009c)
    FIELD(PMX_RST_INTCNTL_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_ERR_ISR, 0x600a4)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_ERR_IMR, 0x600a8)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_ERR_IER, 0x600ac)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_CONFIG_APB_INTF_ERR_IDR, 0x600b0)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CONFIG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_ERR_ISR, 0x600b8)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_ERR_IMR, 0x600bc)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_ERR_IER, 0x600c0)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_CRP_APB_INTF_ERR_IDR, 0x600c4)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CRP_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_ISR, 0x600cc)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IMR, 0x600d0)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IER, 0x600d4)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IDR, 0x600d8)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_ERR_ISR, 0x600e0)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_ERR_IMR, 0x600e4)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_ERR_IER, 0x600e8)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_WDT_APB_INTF_ERR_IDR, 0x600ec)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_WDT_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_RTC_APB_SERB_MAIN_CR, 0x70000)
    FIELD(PMX_RTC_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_RTC_APB_SERB_ISO_CR, 0x7000c)
    FIELD(PMX_RTC_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_RTC_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_RTC_APB_SERB_ERR_TYP_CR, 0x70010)
    FIELD(PMX_RTC_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_ERR_TYP_CR, 0x70014)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_ERR_EN_CR, 0x70034)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_TEST_CR, 0x70054)
    FIELD(IF_INTPMX_RTC_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_RTC_APB_SERB_ISO_SR, 0x70074)
    FIELD(PMX_RTC_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_RTC_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_RTC_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_RTC_APB_SERB_TOP_ERR_SRC_SR, 0x70078)
    FIELD(PMX_RTC_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_RTC_APB_ERROR_TYPE, 24, 1)
    FIELD(PMX_RTC_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_RTC_APB_INTF_ERR, 16, 1)
    FIELD(PMX_RTC_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_RTC_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_RTC_APB_SERB_ERR_ISR, 0x7007c)
    FIELD(PMX_RTC_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RTC_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_RTC_APB_SERB_ERR_IMR, 0x70080)
    FIELD(PMX_RTC_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RTC_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_RTC_APB_SERB_ERR_IER, 0x70084)
    FIELD(PMX_RTC_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RTC_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_RTC_APB_SERB_ERR_IDR, 0x70088)
    FIELD(PMX_RTC_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_RTC_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_RTC_APB_SERB_INTR_ISR, 0x70090)
    FIELD(PMX_RTC_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_RTC_APB_SERB_INTR_IMR, 0x70094)
    FIELD(PMX_RTC_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_RTC_APB_SERB_INTR_IER, 0x70098)
    FIELD(PMX_RTC_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_RTC_APB_SERB_INTR_IDR, 0x7009c)
    FIELD(PMX_RTC_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_ERR_ISR, 0x700a4)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_ERR_IMR, 0x700a8)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_ERR_IER, 0x700ac)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_RTC_APB_INTF_ERR_IDR, 0x700b0)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_RTC_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_SECURE_APB_SERB_MAIN_CR, 0x80000)
    FIELD(PMX_SECURE_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_SECURE_APB_SERB_ISO_CR, 0x8000c)
    FIELD(PMX_SECURE_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_SECURE_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_SECURE_APB_SERB_ERR_TYP_CR, 0x80010)
    FIELD(PMX_SECURE_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_ERR_TYP_CR, 0x80014)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_ERR_TYP_CR, 0x80018)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_TYP_CR, 0x8001c)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_TYP_CR, 0x80020)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_ERR_TYP_CR, 0x80024)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_ERR_TYP_CR, 0x80028)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_ERR_TYP_CR, 0x8002c)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_ERR_EN_CR, 0x80034)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_ERR_EN_CR, 0x80038)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_EN_CR, 0x8003c)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_EN_CR, 0x80040)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_ERR_EN_CR, 0x80044)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_ERR_EN_CR, 0x80048)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_ERR_EN_CR, 0x8004c)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_TEST_CR, 0x80054)
    FIELD(IF_INTPMX_AES_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_TEST_CR, 0x80058)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_TEST_CR, 0x8005c)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_TEST_CR, 0x80060)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_TEST_CR, 0x80064)
    FIELD(IF_INTPMX_SHA0_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_TEST_CR, 0x80068)
    FIELD(IF_INTPMX_SHA1_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_TEST_CR, 0x8006c)
    FIELD(IF_INTPMX_TRNG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_SECURE_APB_SERB_ISO_SR, 0x80074)
    FIELD(PMX_SECURE_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_SECURE_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_SECURE_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, 0x80078)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_TRNG_APB_ERROR_TYPE,
            30, 1) FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_SHA1_APB_ERROR_TYPE, 29, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_SHA0_APB_ERROR_TYPE,
            28, 1) FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_PMCDMA1REG_APB_ERROR_TYPE, 27, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PMCDMA0REG_APB_ERROR_TYPE, 26, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_ECDSARSA_APB_ERROR_TYPE, 25, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_AES_APB_ERROR_TYPE, 24,
            1) FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_TRNG_APB_INTF_ERR, 22, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_SHA1_APB_INTF_ERR, 21,
            1) FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_SHA0_APB_INTF_ERR, 20, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PMCDMA1REG_APB_INTF_ERR, 19, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PMCDMA0REG_APB_INTF_ERR, 18, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_ECDSARSA_APB_INTF_ERR,
            17, 1) FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_AES_APB_INTF_ERR, 16, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_SECURE_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_SECURE_APB_SERB_ERR_ISR, 0x8007c)
    FIELD(PMX_SECURE_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SECURE_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_SECURE_APB_SERB_ERR_IMR, 0x80080)
    FIELD(PMX_SECURE_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SECURE_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_SECURE_APB_SERB_ERR_IER, 0x80084)
    FIELD(PMX_SECURE_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SECURE_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_SECURE_APB_SERB_ERR_IDR, 0x80088)
    FIELD(PMX_SECURE_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SECURE_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_SECURE_APB_SERB_INTR_ISR, 0x80090)
    FIELD(PMX_SECURE_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_SECURE_APB_SERB_INTR_IMR, 0x80094)
    FIELD(PMX_SECURE_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_SECURE_APB_SERB_INTR_IER, 0x80098)
    FIELD(PMX_SECURE_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_SECURE_APB_SERB_INTR_IDR, 0x8009c)
    FIELD(PMX_SECURE_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_ERR_ISR, 0x800a4)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_ERR_IMR, 0x800a8)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_ERR_IER, 0x800ac)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_AES_APB_INTF_ERR_IDR, 0x800b0)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_AES_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_ERR_ISR, 0x800b8)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IMR, 0x800bc)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IER, 0x800c0)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IDR, 0x800c4)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_ECDSARSA_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_ISR, 0x800cc)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IMR, 0x800d0)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IER, 0x800d4)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IDR, 0x800d8)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_ISR, 0x800e0)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IMR, 0x800e4)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IER, 0x800e8)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IDR, 0x800ec)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_ERR_ISR, 0x800f4)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_ERR_IMR, 0x800f8)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_ERR_IER, 0x800fc)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA0_APB_INTF_ERR_IDR, 0x80100)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA0_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_ERR_ISR, 0x80108)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_ERR_IMR, 0x8010c)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_ERR_IER, 0x80110)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_SHA1_APB_INTF_ERR_IDR, 0x80114)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SHA1_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_ERR_ISR, 0x8011c)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_ERR_IMR, 0x80120)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_ERR_IER, 0x80124)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_TRNG_APB_INTF_ERR_IDR, 0x80128)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_TRNG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_MAIN_CR, 0x90000)
    FIELD(SYSMONROOT_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ROUTE_BIT_CR, 0x90008)
    FIELD(SYSMONROOT_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ISO_CR, 0x9000c)
    FIELD(SYSMONROOT_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ERR_TYP_CR, 0x90010)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_TYP_CR, 0x90014)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_EN_CR, 0x90034)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, 0x90054)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ISO_SR, 0x90074)
    FIELD(SYSMONROOT_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_TOP_ERR_SRC_SR, 0x90078)
    FIELD(SYSMONROOT_INTPMX_MERB_TOP_ERR_SRC_SR,
            IF_SYSMONROOT_INTPMX_AXI_ERROR_TYPE, 24, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_TOP_ERR_SRC_SR,
            IF_SYSMONROOT_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ERR_ISR, 0x9007c)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ERR_IMR, 0x90080)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ERR_IER, 0x90084)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_ERR_IDR, 0x90088)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(SYSMONROOT_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_INTR_ISR, 0x90090)
    FIELD(SYSMONROOT_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_INTR_IMR, 0x90094)
    FIELD(SYSMONROOT_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_INTR_IER, 0x90098)
    FIELD(SYSMONROOT_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(SYSMONROOT_INTPMX_MERB_INTR_IDR, 0x9009c)
    FIELD(SYSMONROOT_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, 0x900a4)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, 0x900a8)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, 0x900ac)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, 0x900b0)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PMX_SYSMON_APB_SERB_MAIN_CR, 0x91000)
    FIELD(PMX_SYSMON_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ISO_CR, 0x9100c)
    FIELD(PMX_SYSMON_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_SYSMON_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ERR_TYP_CR, 0x91010)
    FIELD(PMX_SYSMON_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_TYP_CR, 0x91014)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_EN_CR, 0x91034)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_TEST_CR, 0x91054)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ISO_SR, 0x91074)
    FIELD(PMX_SYSMON_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_SYSMON_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_SYSMON_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_SYSMON_APB_SERB_TOP_ERR_SRC_SR, 0x91078)
    FIELD(PMX_SYSMON_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_SYSMONROOT_APB_ERROR_TYPE, 24, 1)
    FIELD(PMX_SYSMON_APB_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_SYSMONROOT_APB_INTF_ERR, 16, 1)
    FIELD(PMX_SYSMON_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_SYSMON_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ERR_ISR, 0x9107c)
    FIELD(PMX_SYSMON_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SYSMON_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ERR_IMR, 0x91080)
    FIELD(PMX_SYSMON_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SYSMON_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ERR_IER, 0x91084)
    FIELD(PMX_SYSMON_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SYSMON_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_SYSMON_APB_SERB_ERR_IDR, 0x91088)
    FIELD(PMX_SYSMON_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(PMX_SYSMON_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_SYSMON_APB_SERB_INTR_ISR, 0x91090)
    FIELD(PMX_SYSMON_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_SYSMON_APB_SERB_INTR_IMR, 0x91094)
    FIELD(PMX_SYSMON_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_SYSMON_APB_SERB_INTR_IER, 0x91098)
    FIELD(PMX_SYSMON_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_SYSMON_APB_SERB_INTR_IDR, 0x9109c)
    FIELD(PMX_SYSMON_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_ISR, 0x910a4)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IMR, 0x910a8)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IER, 0x910ac)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IDR, 0x910b0)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(PMX_POWER_MSERB_MAIN_CR, 0xa0000)
    FIELD(PMX_POWER_MSERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMX_POWER_MSERB_ISO_CR, 0xa000c)
    FIELD(PMX_POWER_MSERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMX_POWER_MSERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMX_POWER_MSERB_ERR_TYP_CR, 0xa0010)
    FIELD(PMX_POWER_MSERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(PMX_POWER_MSERB_ISO_SR, 0xa0074)
    FIELD(PMX_POWER_MSERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMX_POWER_MSERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMX_POWER_MSERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMX_POWER_MSERB_TOP_ERR_SRC_SR, 0xa0078)
    FIELD(PMX_POWER_MSERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMX_POWER_MSERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMX_POWER_MSERB_ERR_ISR, 0xa007c)
    FIELD(PMX_POWER_MSERB_ERR_ISR, MISSION, 0, 1)
REG32(PMX_POWER_MSERB_ERR_IMR, 0xa0080)
    FIELD(PMX_POWER_MSERB_ERR_IMR, MISSION, 0, 1)
REG32(PMX_POWER_MSERB_ERR_IER, 0xa0084)
    FIELD(PMX_POWER_MSERB_ERR_IER, MISSION, 0, 1)
REG32(PMX_POWER_MSERB_ERR_IDR, 0xa0088)
    FIELD(PMX_POWER_MSERB_ERR_IDR, MISSION, 0, 1)
REG32(PMX_POWER_MSERB_INTR_ISR, 0xa0090)
    FIELD(PMX_POWER_MSERB_INTR_ISR, LATENT, 0, 1)
REG32(PMX_POWER_MSERB_INTR_IMR, 0xa0094)
    FIELD(PMX_POWER_MSERB_INTR_IMR, LATENT, 0, 1)
REG32(PMX_POWER_MSERB_INTR_IER, 0xa0098)
    FIELD(PMX_POWER_MSERB_INTR_IER, LATENT, 0, 1)
REG32(PMX_POWER_MSERB_INTR_IDR, 0xa009c)
    FIELD(PMX_POWER_MSERB_INTR_IDR, LATENT, 0, 1)
REG32(DPC_INTPMX_MERB_MAIN_CR, 0xb0000)
    FIELD(DPC_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(DPC_INTPMX_MERB_ROUTE_BIT_CR, 0xb0008)
    FIELD(DPC_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(DPC_INTPMX_MERB_ISO_CR, 0xb000c)
    FIELD(DPC_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(DPC_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(DPC_INTPMX_MERB_ERR_TYP_CR, 0xb0010)
    FIELD(DPC_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_ERR_TYP_CR, 0xb0014)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_ERR_EN_CR, 0xb0034)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_TEST_CR, 0xb0054)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(DPC_INTPMX_MERB_ISO_SR, 0xb0074)
    FIELD(DPC_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(DPC_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(DPC_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(DPC_INTPMX_MERB_TOP_ERR_SRC_SR, 0xb0078)
    FIELD(DPC_INTPMX_MERB_TOP_ERR_SRC_SR, IF_DPC_INTPMX_AXI_ERROR_TYPE, 24, 1)
    FIELD(DPC_INTPMX_MERB_TOP_ERR_SRC_SR, IF_DPC_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(DPC_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(DPC_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(DPC_INTPMX_MERB_ERR_ISR, 0xb007c)
    FIELD(DPC_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(DPC_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(DPC_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(DPC_INTPMX_MERB_ERR_IMR, 0xb0080)
    FIELD(DPC_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(DPC_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(DPC_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(DPC_INTPMX_MERB_ERR_IER, 0xb0084)
    FIELD(DPC_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(DPC_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(DPC_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(DPC_INTPMX_MERB_ERR_IDR, 0xb0088)
    FIELD(DPC_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(DPC_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(DPC_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(DPC_INTPMX_MERB_INTR_ISR, 0xb0090)
    FIELD(DPC_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(DPC_INTPMX_MERB_INTR_IMR, 0xb0094)
    FIELD(DPC_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(DPC_INTPMX_MERB_INTR_IER, 0xb0098)
    FIELD(DPC_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(DPC_INTPMX_MERB_INTR_IDR, 0xb009c)
    FIELD(DPC_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, 0xb00a4)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, 0xb00a8)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_ERR_IER, 0xb00ac)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, 0xb00b0)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_DPC_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_MAIN_CR, 0xc0000)
    FIELD(INTPMX_CFUSTREAM_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ISO_CR, 0xc000c)
    FIELD(INTPMX_CFUSTREAM_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ERR_TYP_CR, 0xc0010)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_TYP_CR, 0xc0014)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_EN_CR, 0xc0034)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, 0xc0054)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ISO_SR, 0xc0074)
    FIELD(INTPMX_CFUSTREAM_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_TOP_ERR_SRC_SR, 0xc0078)
    FIELD(INTPMX_CFUSTREAM_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_CFUSTREAM_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_CFUSTREAM_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ERR_ISR, 0xc007c)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ERR_IMR, 0xc0080)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ERR_IER, 0xc0084)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_ERR_IDR, 0xc0088)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_CFUSTREAM_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_INTR_ISR, 0xc0090)
    FIELD(INTPMX_CFUSTREAM_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_INTR_IMR, 0xc0094)
    FIELD(INTPMX_CFUSTREAM_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_INTR_IER, 0xc0098)
    FIELD(INTPMX_CFUSTREAM_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_CFUSTREAM_SERB_INTR_IDR, 0xc009c)
    FIELD(INTPMX_CFUSTREAM_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, 0xc00a4)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, 0xc00a8)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, 0xc00ac)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, 0xc00b0)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_CFU_APB_SERB_MAIN_CR, 0xc1000)
    FIELD(INTPMX_CFU_APB_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ISO_CR, 0xc100c)
    FIELD(INTPMX_CFU_APB_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_CFU_APB_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ERR_TYP_CR, 0xc1010)
    FIELD(INTPMX_CFU_APB_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_ERR_TYP_CR, 0xc1014)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_ERR_EN_CR, 0xc1034)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_TEST_CR, 0xc1054)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ISO_SR, 0xc1074)
    FIELD(INTPMX_CFU_APB_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_CFU_APB_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_CFU_APB_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_CFU_APB_SERB_TOP_ERR_SRC_SR, 0xc1078)
    FIELD(INTPMX_CFU_APB_SERB_TOP_ERR_SRC_SR, IF_INTPMX_CFUREG_APB_ERROR_TYPE,
            24, 1) FIELD(INTPMX_CFU_APB_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_CFUREG_APB_INTF_ERR, 16, 1)
    FIELD(INTPMX_CFU_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_CFU_APB_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ERR_ISR, 0xc107c)
    FIELD(INTPMX_CFU_APB_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_CFU_APB_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ERR_IMR, 0xc1080)
    FIELD(INTPMX_CFU_APB_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_CFU_APB_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ERR_IER, 0xc1084)
    FIELD(INTPMX_CFU_APB_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_CFU_APB_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_CFU_APB_SERB_ERR_IDR, 0xc1088)
    FIELD(INTPMX_CFU_APB_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_CFU_APB_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_CFU_APB_SERB_INTR_ISR, 0xc1090)
    FIELD(INTPMX_CFU_APB_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_CFU_APB_SERB_INTR_IMR, 0xc1094)
    FIELD(INTPMX_CFU_APB_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_CFU_APB_SERB_INTR_IER, 0xc1098)
    FIELD(INTPMX_CFU_APB_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_CFU_APB_SERB_INTR_IDR, 0xc109c)
    FIELD(INTPMX_CFU_APB_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_ERR_ISR, 0xc10a4)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_ERR_IMR, 0xc10a8)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_ERR_IER, 0xc10ac)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_CFUREG_APB_INTF_ERR_IDR, 0xc10b0)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_CFUREG_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(INTPMX_EFUSE_SERB_MAIN_CR, 0xd0000)
    FIELD(INTPMX_EFUSE_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_EFUSE_SERB_ISO_CR, 0xd000c)
    FIELD(INTPMX_EFUSE_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_EFUSE_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_EFUSE_SERB_ERR_TYP_CR, 0xd0010)
    FIELD(INTPMX_EFUSE_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_ERR_TYP_CR, 0xd0014)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_ERR_EN_CR, 0xd0034)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_TEST_CR, 0xd0054)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_TEST_CR, INJ_SLVERR_EN, 2, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_TEST_CR, APB_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_TEST_CR, PARITY_INJ_EN, 0, 1)
REG32(INTPMX_EFUSE_SERB_ISO_SR, 0xd0074)
    FIELD(INTPMX_EFUSE_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_EFUSE_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_EFUSE_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_EFUSE_SERB_TOP_ERR_SRC_SR, 0xd0078)
    FIELD(INTPMX_EFUSE_SERB_TOP_ERR_SRC_SR, IF_INTPMX_EFUSE_APB_ERROR_TYPE, 24,
            1) FIELD(INTPMX_EFUSE_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_EFUSE_APB_INTF_ERR, 16, 1)
    FIELD(INTPMX_EFUSE_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_EFUSE_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_EFUSE_SERB_ERR_ISR, 0xd007c)
    FIELD(INTPMX_EFUSE_SERB_ERR_ISR, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_EFUSE_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_EFUSE_SERB_ERR_IMR, 0xd0080)
    FIELD(INTPMX_EFUSE_SERB_ERR_IMR, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_EFUSE_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_EFUSE_SERB_ERR_IER, 0xd0084)
    FIELD(INTPMX_EFUSE_SERB_ERR_IER, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_EFUSE_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_EFUSE_SERB_ERR_IDR, 0xd0088)
    FIELD(INTPMX_EFUSE_SERB_ERR_IDR, TIMEOUT_APB, 16, 1)
    FIELD(INTPMX_EFUSE_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_EFUSE_SERB_INTR_ISR, 0xd0090)
    FIELD(INTPMX_EFUSE_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_EFUSE_SERB_INTR_IMR, 0xd0094)
    FIELD(INTPMX_EFUSE_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_EFUSE_SERB_INTR_IER, 0xd0098)
    FIELD(INTPMX_EFUSE_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_EFUSE_SERB_INTR_IDR, 0xd009c)
    FIELD(INTPMX_EFUSE_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_ERR_ISR, 0xd00a4)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_ISR, POISON, 16, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_ISR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_ISR, SLVERR, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_ERR_IMR, 0xd00a8)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IMR, POISON, 16, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IMR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IMR, SLVERR, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_ERR_IER, 0xd00ac)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IER, POISON, 16, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IER, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IER, SLVERR, 0, 1)
REG32(IF_INTPMX_EFUSE_APB_INTF_ERR_IDR, 0xd00b0)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IDR, POISON, 16, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IDR, PARITY_ERR, 8, 1)
    FIELD(IF_INTPMX_EFUSE_APB_INTF_ERR_IDR, SLVERR, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_MAIN_CR, 0xe0000)
    FIELD(INTPMXIOU_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ISO_CR, 0xe000c)
    FIELD(INTPMXIOU_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ERR_TYP_CR, 0xe0010)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_TYP_CR, 0xe0014)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_EN_CR, 0xe0034)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, 0xe0054)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ISO_SR, 0xe0074)
    FIELD(INTPMXIOU_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_TOP_ERR_SRC_SR, 0xe0078)
    FIELD(INTPMXIOU_INTPMX_MERB_TOP_ERR_SRC_SR,
            IF_INTPMXIOU_INTPMX_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_TOP_ERR_SRC_SR,
            IF_INTPMXIOU_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ERR_ISR, 0xe007c)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ERR_IMR, 0xe0080)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ERR_IER, 0xe0084)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_ERR_IDR, 0xe0088)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMXIOU_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_INTR_ISR, 0xe0090)
    FIELD(INTPMXIOU_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_INTR_IMR, 0xe0094)
    FIELD(INTPMXIOU_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_INTR_IER, 0xe0098)
    FIELD(INTPMXIOU_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMXIOU_INTPMX_MERB_INTR_IDR, 0xe009c)
    FIELD(INTPMXIOU_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, 0xe00a4)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, 0xe00a8)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, 0xe00ac)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, 0xe00b0)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_MAIN_CR, 0xe1000)
    FIELD(INTPMX_INTPMXIOU_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ISO_CR, 0xe100c)
    FIELD(INTPMX_INTPMXIOU_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ERR_TYP_CR, 0xe1010)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_TYP_CR, 0xe1014)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_EN_CR, 0xe1034)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, 0xe1054)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ISO_SR, 0xe1074)
    FIELD(INTPMX_INTPMXIOU_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_TOP_ERR_SRC_SR, 0xe1078)
    FIELD(INTPMX_INTPMXIOU_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_INTPMXIOU_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_INTPMXIOU_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ERR_ISR, 0xe107c)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ERR_IMR, 0xe1080)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ERR_IER, 0xe1084)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_ERR_IDR, 0xe1088)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTPMXIOU_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_INTR_ISR, 0xe1090)
    FIELD(INTPMX_INTPMXIOU_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_INTR_IMR, 0xe1094)
    FIELD(INTPMX_INTPMXIOU_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_INTR_IER, 0xe1098)
    FIELD(INTPMX_INTPMXIOU_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_INTPMXIOU_SERB_INTR_IDR, 0xe109c)
    FIELD(INTPMX_INTPMXIOU_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, 0xe10a4)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, 0xe10a8)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, 0xe10ac)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, 0xe10b0)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_NPI_SERB_MAIN_CR, 0xf0000)
    FIELD(INTPMX_NPI_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_NPI_SERB_ISO_CR, 0xf000c)
    FIELD(INTPMX_NPI_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_NPI_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_NPI_SERB_ERR_TYP_CR, 0xf0010)
    FIELD(INTPMX_NPI_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_ERR_TYP_CR, 0xf0014)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_ERR_EN_CR, 0xf0034)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_TEST_CR, 0xf0054)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_NPI_SERB_ISO_SR, 0xf0074)
    FIELD(INTPMX_NPI_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_NPI_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_NPI_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_NPI_SERB_TOP_ERR_SRC_SR, 0xf0078)
    FIELD(INTPMX_NPI_SERB_TOP_ERR_SRC_SR, IF_INTPMX_NPI_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_NPI_SERB_TOP_ERR_SRC_SR, IF_INTPMX_NPI_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_NPI_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_NPI_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_NPI_SERB_ERR_ISR, 0xf007c)
    FIELD(INTPMX_NPI_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_NPI_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_NPI_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_NPI_SERB_ERR_IMR, 0xf0080)
    FIELD(INTPMX_NPI_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_NPI_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_NPI_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_NPI_SERB_ERR_IER, 0xf0084)
    FIELD(INTPMX_NPI_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_NPI_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_NPI_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_NPI_SERB_ERR_IDR, 0xf0088)
    FIELD(INTPMX_NPI_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_NPI_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_NPI_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_NPI_SERB_INTR_ISR, 0xf0090)
    FIELD(INTPMX_NPI_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_NPI_SERB_INTR_IMR, 0xf0094)
    FIELD(INTPMX_NPI_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_NPI_SERB_INTR_IER, 0xf0098)
    FIELD(INTPMX_NPI_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_NPI_SERB_INTR_IDR, 0xf009c)
    FIELD(INTPMX_NPI_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, 0xf00a4)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, 0xf00a8)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_ERR_IER, 0xf00ac)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, 0xf00b0)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_NPI_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_PMCOCM_SERB_MAIN_CR, 0x100000)
    FIELD(INTPMX_PMCOCM_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ISO_CR, 0x10000c)
    FIELD(INTPMX_PMCOCM_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_PMCOCM_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ERR_TYP_CR, 0x100010)
    FIELD(INTPMX_PMCOCM_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_ERR_TYP_CR, 0x100014)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_ERR_EN_CR, 0x100034)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, 0x100054)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ISO_SR, 0x100074)
    FIELD(INTPMX_PMCOCM_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_PMCOCM_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_PMCOCM_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_PMCOCM_SERB_TOP_ERR_SRC_SR, 0x100078)
    FIELD(INTPMX_PMCOCM_SERB_TOP_ERR_SRC_SR, IF_INTPMX_PMCOCM_AXI_ERROR_TYPE,
            24, 1) FIELD(INTPMX_PMCOCM_SERB_TOP_ERR_SRC_SR,
                IF_INTPMX_PMCOCM_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_PMCOCM_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_PMCOCM_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ERR_ISR, 0x10007c)
    FIELD(INTPMX_PMCOCM_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ERR_IMR, 0x100080)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ERR_IER, 0x100084)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_PMCOCM_SERB_ERR_IDR, 0x100088)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PMCOCM_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_PMCOCM_SERB_INTR_ISR, 0x100090)
    FIELD(INTPMX_PMCOCM_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_PMCOCM_SERB_INTR_IMR, 0x100094)
    FIELD(INTPMX_PMCOCM_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_PMCOCM_SERB_INTR_IER, 0x100098)
    FIELD(INTPMX_PMCOCM_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_PMCOCM_SERB_INTR_IDR, 0x10009c)
    FIELD(INTPMX_PMCOCM_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, 0x1000a4)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, 0x1000a8)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, 0x1000ac)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, 0x1000b0)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PMCOCM_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PPU0_INTPMX_MERB_MAIN_CR, 0x110000)
    FIELD(PPU0_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PPU0_INTPMX_MERB_ROUTE_BIT_CR, 0x110008)
    FIELD(PPU0_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(PPU0_INTPMX_MERB_ISO_CR, 0x11000c)
    FIELD(PPU0_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PPU0_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PPU0_INTPMX_MERB_ERR_TYP_CR, 0x110010)
    FIELD(PPU0_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_ERR_TYP_CR, 0x110014)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_ERR_EN_CR, 0x110034)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, 0x110054)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PPU0_INTPMX_MERB_ISO_SR, 0x110074)
    FIELD(PPU0_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PPU0_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PPU0_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PPU0_INTPMX_MERB_TOP_ERR_SRC_SR, 0x110078)
    FIELD(PPU0_INTPMX_MERB_TOP_ERR_SRC_SR, IF_PPU0_INTPMX_AXI_ERROR_TYPE, 24, 1)
    FIELD(PPU0_INTPMX_MERB_TOP_ERR_SRC_SR, IF_PPU0_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(PPU0_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PPU0_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PPU0_INTPMX_MERB_ERR_ISR, 0x11007c)
    FIELD(PPU0_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(PPU0_INTPMX_MERB_ERR_IMR, 0x110080)
    FIELD(PPU0_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(PPU0_INTPMX_MERB_ERR_IER, 0x110084)
    FIELD(PPU0_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(PPU0_INTPMX_MERB_ERR_IDR, 0x110088)
    FIELD(PPU0_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU0_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(PPU0_INTPMX_MERB_INTR_ISR, 0x110090)
    FIELD(PPU0_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(PPU0_INTPMX_MERB_INTR_IMR, 0x110094)
    FIELD(PPU0_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(PPU0_INTPMX_MERB_INTR_IER, 0x110098)
    FIELD(PPU0_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(PPU0_INTPMX_MERB_INTR_IDR, 0x11009c)
    FIELD(PPU0_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, 0x1100a4)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, 0x1100a8)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, 0x1100ac)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, 0x1100b0)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PPU0_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_MAIN_CR, 0x111000)
    FIELD(INTPMX_PPU0MDMSHD_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ISO_CR, 0x11100c)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ERR_TYP_CR, 0x111010)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_TYP_CR, 0x111014)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_EN_CR, 0x111034)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, 0x111054)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ISO_SR, 0x111074)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_TOP_ERR_SRC_SR, 0x111078)
    FIELD(INTPMX_PPU0MDMSHD_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PPU0MDMSHD_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ERR_ISR, 0x11107c)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ERR_IMR, 0x111080)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ERR_IER, 0x111084)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_ERR_IDR, 0x111088)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU0MDMSHD_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_INTR_ISR, 0x111090)
    FIELD(INTPMX_PPU0MDMSHD_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_INTR_IMR, 0x111094)
    FIELD(INTPMX_PPU0MDMSHD_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_INTR_IER, 0x111098)
    FIELD(INTPMX_PPU0MDMSHD_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_PPU0MDMSHD_SERB_INTR_IDR, 0x11109c)
    FIELD(INTPMX_PPU0MDMSHD_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, 0x1110a4)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, 0x1110a8)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, 0x1110ac)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, 0x1110b0)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PPU1_INTPMX_MERB_MAIN_CR, 0x120000)
    FIELD(PPU1_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PPU1_INTPMX_MERB_ROUTE_BIT_CR, 0x120008)
    FIELD(PPU1_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(PPU1_INTPMX_MERB_ISO_CR, 0x12000c)
    FIELD(PPU1_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PPU1_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PPU1_INTPMX_MERB_ERR_TYP_CR, 0x120010)
    FIELD(PPU1_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_ERR_TYP_CR, 0x120014)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_ERR_EN_CR, 0x120034)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, 0x120054)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PPU1_INTPMX_MERB_ISO_SR, 0x120074)
    FIELD(PPU1_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PPU1_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PPU1_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PPU1_INTPMX_MERB_TOP_ERR_SRC_SR, 0x120078)
    FIELD(PPU1_INTPMX_MERB_TOP_ERR_SRC_SR, IF_PPU1_INTPMX_AXI_ERROR_TYPE, 24, 1)
    FIELD(PPU1_INTPMX_MERB_TOP_ERR_SRC_SR, IF_PPU1_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(PPU1_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PPU1_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PPU1_INTPMX_MERB_ERR_ISR, 0x12007c)
    FIELD(PPU1_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(PPU1_INTPMX_MERB_ERR_IMR, 0x120080)
    FIELD(PPU1_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(PPU1_INTPMX_MERB_ERR_IER, 0x120084)
    FIELD(PPU1_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(PPU1_INTPMX_MERB_ERR_IDR, 0x120088)
    FIELD(PPU1_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PPU1_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(PPU1_INTPMX_MERB_INTR_ISR, 0x120090)
    FIELD(PPU1_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(PPU1_INTPMX_MERB_INTR_IMR, 0x120094)
    FIELD(PPU1_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(PPU1_INTPMX_MERB_INTR_IER, 0x120098)
    FIELD(PPU1_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(PPU1_INTPMX_MERB_INTR_IDR, 0x12009c)
    FIELD(PPU1_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, 0x1200a4)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, 0x1200a8)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, 0x1200ac)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, 0x1200b0)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PPU1_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_MAIN_CR, 0x121000)
    FIELD(INTPMX_PPU1MDMSHD_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ISO_CR, 0x12100c)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ERR_TYP_CR, 0x121010)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_TYP_CR, 0x121014)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_EN_CR, 0x121034)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, 0x121054)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ISO_SR, 0x121074)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_TOP_ERR_SRC_SR, 0x121078)
    FIELD(INTPMX_PPU1MDMSHD_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PPU1MDMSHD_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ERR_ISR, 0x12107c)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ERR_IMR, 0x121080)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ERR_IER, 0x121084)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_ERR_IDR, 0x121088)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_PPU1MDMSHD_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_INTR_ISR, 0x121090)
    FIELD(INTPMX_PPU1MDMSHD_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_INTR_IMR, 0x121094)
    FIELD(INTPMX_PPU1MDMSHD_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_INTR_IER, 0x121098)
    FIELD(INTPMX_PPU1MDMSHD_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_PPU1MDMSHD_SERB_INTR_IDR, 0x12109c)
    FIELD(INTPMX_PPU1MDMSHD_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, 0x1210a4)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, 0x1210a8)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, 0x1210ac)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, 0x1210b0)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_SBI_SERB_MAIN_CR, 0x130000)
    FIELD(INTPMX_SBI_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_SBI_SERB_ISO_CR, 0x13000c)
    FIELD(INTPMX_SBI_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_SBI_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_SBI_SERB_ERR_TYP_CR, 0x130010)
    FIELD(INTPMX_SBI_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_ERR_TYP_CR, 0x130014)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_ERR_EN_CR, 0x130034)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_TEST_CR, 0x130054)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_SBI_SERB_ISO_SR, 0x130074)
    FIELD(INTPMX_SBI_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_SBI_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_SBI_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_SBI_SERB_TOP_ERR_SRC_SR, 0x130078)
    FIELD(INTPMX_SBI_SERB_TOP_ERR_SRC_SR, IF_INTPMX_SBI_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_SBI_SERB_TOP_ERR_SRC_SR, IF_INTPMX_SBI_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_SBI_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_SBI_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_SBI_SERB_ERR_ISR, 0x13007c)
    FIELD(INTPMX_SBI_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_SBI_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_SBI_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_SBI_SERB_ERR_IMR, 0x130080)
    FIELD(INTPMX_SBI_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_SBI_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_SBI_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_SBI_SERB_ERR_IER, 0x130084)
    FIELD(INTPMX_SBI_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_SBI_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_SBI_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_SBI_SERB_ERR_IDR, 0x130088)
    FIELD(INTPMX_SBI_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_SBI_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_SBI_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_SBI_SERB_INTR_ISR, 0x130090)
    FIELD(INTPMX_SBI_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_SBI_SERB_INTR_IMR, 0x130094)
    FIELD(INTPMX_SBI_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_SBI_SERB_INTR_IER, 0x130098)
    FIELD(INTPMX_SBI_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_SBI_SERB_INTR_IDR, 0x13009c)
    FIELD(INTPMX_SBI_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, 0x1300a4)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, 0x1300a8)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_ERR_IER, 0x1300ac)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, 0x1300b0)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_SBI_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(JTAG_INTPMX_MERB_MAIN_CR, 0x140000)
    FIELD(JTAG_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(JTAG_INTPMX_MERB_ROUTE_BIT_CR, 0x140008)
    FIELD(JTAG_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(JTAG_INTPMX_MERB_ISO_CR, 0x14000c)
    FIELD(JTAG_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(JTAG_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(JTAG_INTPMX_MERB_ERR_TYP_CR, 0x140010)
    FIELD(JTAG_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_TYP_CR, 0x140014)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_EN_CR, 0x140034)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, 0x140054)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(JTAG_INTPMX_MERB_ISO_SR, 0x140074)
    FIELD(JTAG_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(JTAG_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(JTAG_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(JTAG_INTPMX_MERB_TOP_ERR_SRC_SR, 0x140078)
    FIELD(JTAG_INTPMX_MERB_TOP_ERR_SRC_SR, IF_JTAGDAP_INTPMX_AXI_ERROR_TYPE,
            24, 1) FIELD(JTAG_INTPMX_MERB_TOP_ERR_SRC_SR,
                IF_JTAGDAP_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(JTAG_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(JTAG_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(JTAG_INTPMX_MERB_ERR_ISR, 0x14007c)
    FIELD(JTAG_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(JTAG_INTPMX_MERB_ERR_IMR, 0x140080)
    FIELD(JTAG_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(JTAG_INTPMX_MERB_ERR_IER, 0x140084)
    FIELD(JTAG_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(JTAG_INTPMX_MERB_ERR_IDR, 0x140088)
    FIELD(JTAG_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(JTAG_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(JTAG_INTPMX_MERB_INTR_ISR, 0x140090)
    FIELD(JTAG_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(JTAG_INTPMX_MERB_INTR_IMR, 0x140094)
    FIELD(JTAG_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(JTAG_INTPMX_MERB_INTR_IER, 0x140098)
    FIELD(JTAG_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(JTAG_INTPMX_MERB_INTR_IDR, 0x14009c)
    FIELD(JTAG_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, 0x1400a4)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, 0x1400a8)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, 0x1400ac)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, 0x1400b0)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PMC_NOC_AXI_SERB_MAIN_CR, 0x150000)
    FIELD(PMC_NOC_AXI_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMC_NOC_AXI_SERB_ISO_CR, 0x15000c)
    FIELD(PMC_NOC_AXI_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMC_NOC_AXI_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMC_NOC_AXI_SERB_ERR_TYP_CR, 0x150010)
    FIELD(PMC_NOC_AXI_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_ERR_TYP_CR, 0x150014)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_ERR_EN_CR, 0x150034)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_TEST_CR, 0x150054)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PMC_NOC_AXI_SERB_ISO_SR, 0x150074)
    FIELD(PMC_NOC_AXI_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMC_NOC_AXI_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMC_NOC_AXI_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMC_NOC_AXI_SERB_TOP_ERR_SRC_SR, 0x150078)
    FIELD(PMC_NOC_AXI_SERB_TOP_ERR_SRC_SR, IF_PMC_NOC_AXI_ERROR_TYPE, 24, 1)
    FIELD(PMC_NOC_AXI_SERB_TOP_ERR_SRC_SR, IF_PMC_NOC_AXI_INTF_ERR, 16, 1)
    FIELD(PMC_NOC_AXI_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMC_NOC_AXI_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMC_NOC_AXI_SERB_ERR_ISR, 0x15007c)
    FIELD(PMC_NOC_AXI_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMC_NOC_AXI_SERB_ERR_IMR, 0x150080)
    FIELD(PMC_NOC_AXI_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMC_NOC_AXI_SERB_ERR_IER, 0x150084)
    FIELD(PMC_NOC_AXI_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMC_NOC_AXI_SERB_ERR_IDR, 0x150088)
    FIELD(PMC_NOC_AXI_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_NOC_AXI_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMC_NOC_AXI_SERB_INTR_ISR, 0x150090)
    FIELD(PMC_NOC_AXI_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMC_NOC_AXI_SERB_INTR_IMR, 0x150094)
    FIELD(PMC_NOC_AXI_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMC_NOC_AXI_SERB_INTR_IER, 0x150098)
    FIELD(PMC_NOC_AXI_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMC_NOC_AXI_SERB_INTR_IDR, 0x15009c)
    FIELD(PMC_NOC_AXI_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_ERR_ISR, 0x1500a4)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_ERR_IMR, 0x1500a8)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_ERR_IER, 0x1500ac)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PMC_NOC_AXI_INTF_ERR_IDR, 0x1500b0)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PMC_NOC_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(NOC_PMC_AXI_MERB_MAIN_CR, 0x151000)
    FIELD(NOC_PMC_AXI_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(NOC_PMC_AXI_MERB_ISO_CR, 0x15100c)
    FIELD(NOC_PMC_AXI_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(NOC_PMC_AXI_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(NOC_PMC_AXI_MERB_ERR_TYP_CR, 0x151010)
    FIELD(NOC_PMC_AXI_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_ERR_TYP_CR, 0x151014)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_ERR_EN_CR, 0x151034)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_TEST_CR, 0x151054)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(NOC_PMC_AXI_MERB_ISO_SR, 0x151074)
    FIELD(NOC_PMC_AXI_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(NOC_PMC_AXI_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(NOC_PMC_AXI_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(NOC_PMC_AXI_MERB_TOP_ERR_SRC_SR, 0x151078)
    FIELD(NOC_PMC_AXI_MERB_TOP_ERR_SRC_SR, IF_NOC_PMC_AXI_ERROR_TYPE, 24, 1)
    FIELD(NOC_PMC_AXI_MERB_TOP_ERR_SRC_SR, IF_NOC_PMC_AXI_INTF_ERR, 16, 1)
    FIELD(NOC_PMC_AXI_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(NOC_PMC_AXI_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(NOC_PMC_AXI_MERB_ERR_ISR, 0x15107c)
    FIELD(NOC_PMC_AXI_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_ISR, MISSION, 0, 1)
REG32(NOC_PMC_AXI_MERB_ERR_IMR, 0x151080)
    FIELD(NOC_PMC_AXI_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_IMR, MISSION, 0, 1)
REG32(NOC_PMC_AXI_MERB_ERR_IER, 0x151084)
    FIELD(NOC_PMC_AXI_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_IER, MISSION, 0, 1)
REG32(NOC_PMC_AXI_MERB_ERR_IDR, 0x151088)
    FIELD(NOC_PMC_AXI_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(NOC_PMC_AXI_MERB_ERR_IDR, MISSION, 0, 1)
REG32(NOC_PMC_AXI_MERB_INTR_ISR, 0x151090)
    FIELD(NOC_PMC_AXI_MERB_INTR_ISR, LATENT, 0, 1)
REG32(NOC_PMC_AXI_MERB_INTR_IMR, 0x151094)
    FIELD(NOC_PMC_AXI_MERB_INTR_IMR, LATENT, 0, 1)
REG32(NOC_PMC_AXI_MERB_INTR_IER, 0x151098)
    FIELD(NOC_PMC_AXI_MERB_INTR_IER, LATENT, 0, 1)
REG32(NOC_PMC_AXI_MERB_INTR_IDR, 0x15109c)
    FIELD(NOC_PMC_AXI_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_ERR_ISR, 0x1510a4)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_ERR_IMR, 0x1510a8)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_ERR_IER, 0x1510ac)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_NOC_PMC_AXI_INTF_ERR_IDR, 0x1510b0)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_NOC_PMC_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PS_PMC_AXI_MERB_MAIN_CR, 0x160000)
    FIELD(PS_PMC_AXI_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PS_PMC_AXI_MERB_ISO_CR, 0x16000c)
    FIELD(PS_PMC_AXI_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PS_PMC_AXI_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PS_PMC_AXI_MERB_ERR_TYP_CR, 0x160010)
    FIELD(PS_PMC_AXI_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_ERR_TYP_CR, 0x160014)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_ERR_EN_CR, 0x160034)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_TEST_CR, 0x160054)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PS_PMC_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PS_PMC_AXI_MERB_ISO_SR, 0x160074)
    FIELD(PS_PMC_AXI_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PS_PMC_AXI_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PS_PMC_AXI_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PS_PMC_AXI_MERB_TOP_ERR_SRC_SR, 0x160078)
    FIELD(PS_PMC_AXI_MERB_TOP_ERR_SRC_SR, IF_PS_PMC_AXI_ERROR_TYPE, 24, 1)
    FIELD(PS_PMC_AXI_MERB_TOP_ERR_SRC_SR, IF_PS_PMC_AXI_INTF_ERR, 16, 1)
    FIELD(PS_PMC_AXI_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PS_PMC_AXI_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PS_PMC_AXI_MERB_ERR_ISR, 0x16007c)
    FIELD(PS_PMC_AXI_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_ISR, MISSION, 0, 1)
REG32(PS_PMC_AXI_MERB_ERR_IMR, 0x160080)
    FIELD(PS_PMC_AXI_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_IMR, MISSION, 0, 1)
REG32(PS_PMC_AXI_MERB_ERR_IER, 0x160084)
    FIELD(PS_PMC_AXI_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_IER, MISSION, 0, 1)
REG32(PS_PMC_AXI_MERB_ERR_IDR, 0x160088)
    FIELD(PS_PMC_AXI_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PS_PMC_AXI_MERB_ERR_IDR, MISSION, 0, 1)
REG32(PS_PMC_AXI_MERB_INTR_ISR, 0x160090)
    FIELD(PS_PMC_AXI_MERB_INTR_ISR, LATENT, 0, 1)
REG32(PS_PMC_AXI_MERB_INTR_IMR, 0x160094)
    FIELD(PS_PMC_AXI_MERB_INTR_IMR, LATENT, 0, 1)
REG32(PS_PMC_AXI_MERB_INTR_IER, 0x160098)
    FIELD(PS_PMC_AXI_MERB_INTR_IER, LATENT, 0, 1)
REG32(PS_PMC_AXI_MERB_INTR_IDR, 0x16009c)
    FIELD(PS_PMC_AXI_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_ERR_ISR, 0x1600a4)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_ERR_IMR, 0x1600a8)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_ERR_IER, 0x1600ac)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PS_PMC_AXI_INTF_ERR_IDR, 0x1600b0)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PS_PMC_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PMC_PS_AXI_SERB_MAIN_CR, 0x161000)
    FIELD(PMC_PS_AXI_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMC_PS_AXI_SERB_ISO_CR, 0x16100c)
    FIELD(PMC_PS_AXI_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMC_PS_AXI_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMC_PS_AXI_SERB_ERR_TYP_CR, 0x161010)
    FIELD(PMC_PS_AXI_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_ERR_TYP_CR, 0x161014)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_ERR_EN_CR, 0x161034)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_TEST_CR, 0x161054)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PMC_PS_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PMC_PS_AXI_SERB_ISO_SR, 0x161074)
    FIELD(PMC_PS_AXI_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMC_PS_AXI_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMC_PS_AXI_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMC_PS_AXI_SERB_TOP_ERR_SRC_SR, 0x161078)
    FIELD(PMC_PS_AXI_SERB_TOP_ERR_SRC_SR, IF_PMC_PS_AXI_ERROR_TYPE, 24, 1)
    FIELD(PMC_PS_AXI_SERB_TOP_ERR_SRC_SR, IF_PMC_PS_AXI_INTF_ERR, 16, 1)
    FIELD(PMC_PS_AXI_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMC_PS_AXI_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMC_PS_AXI_SERB_ERR_ISR, 0x16107c)
    FIELD(PMC_PS_AXI_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_ISR, MISSION, 0, 1)
REG32(PMC_PS_AXI_SERB_ERR_IMR, 0x161080)
    FIELD(PMC_PS_AXI_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_IMR, MISSION, 0, 1)
REG32(PMC_PS_AXI_SERB_ERR_IER, 0x161084)
    FIELD(PMC_PS_AXI_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_IER, MISSION, 0, 1)
REG32(PMC_PS_AXI_SERB_ERR_IDR, 0x161088)
    FIELD(PMC_PS_AXI_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMC_PS_AXI_SERB_ERR_IDR, MISSION, 0, 1)
REG32(PMC_PS_AXI_SERB_INTR_ISR, 0x161090)
    FIELD(PMC_PS_AXI_SERB_INTR_ISR, LATENT, 0, 1)
REG32(PMC_PS_AXI_SERB_INTR_IMR, 0x161094)
    FIELD(PMC_PS_AXI_SERB_INTR_IMR, LATENT, 0, 1)
REG32(PMC_PS_AXI_SERB_INTR_IER, 0x161098)
    FIELD(PMC_PS_AXI_SERB_INTR_IER, LATENT, 0, 1)
REG32(PMC_PS_AXI_SERB_INTR_IDR, 0x16109c)
    FIELD(PMC_PS_AXI_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_ERR_ISR, 0x1610a4)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_ERR_IMR, 0x1610a8)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_ERR_IER, 0x1610ac)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PMC_PS_AXI_INTF_ERR_IDR, 0x1610b0)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PMC_PS_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_MAIN_CR, 0x170000)
    FIELD(PMCDMA0_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ROUTE_BIT_CR, 0x170008)
    FIELD(PMCDMA0_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ISO_CR, 0x17000c)
    FIELD(PMCDMA0_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ERR_TYP_CR, 0x170010)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_TYP_CR, 0x170014)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_EN_CR, 0x170034)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, 0x170054)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ISO_SR, 0x170074)
    FIELD(PMCDMA0_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_TOP_ERR_SRC_SR, 0x170078)
    FIELD(PMCDMA0_INTPMX_MERB_TOP_ERR_SRC_SR, IF_PMCDMA0_INTPMX_AXI_ERROR_TYPE,
            24, 1) FIELD(PMCDMA0_INTPMX_MERB_TOP_ERR_SRC_SR,
                IF_PMCDMA0_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(PMCDMA0_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMCDMA0_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ERR_ISR, 0x17007c)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ERR_IMR, 0x170080)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ERR_IER, 0x170084)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_ERR_IDR, 0x170088)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA0_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_INTR_ISR, 0x170090)
    FIELD(PMCDMA0_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_INTR_IMR, 0x170094)
    FIELD(PMCDMA0_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_INTR_IER, 0x170098)
    FIELD(PMCDMA0_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(PMCDMA0_INTPMX_MERB_INTR_IDR, 0x17009c)
    FIELD(PMCDMA0_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, 0x1700a4)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, 0x1700a8)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, 0x1700ac)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, 0x1700b0)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_MAIN_CR, 0x180000)
    FIELD(PMCDMA1_INTPMX_MERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ROUTE_BIT_CR, 0x180008)
    FIELD(PMCDMA1_INTPMX_MERB_ROUTE_BIT_CR, ROUTING_BIT0, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ISO_CR, 0x18000c)
    FIELD(PMCDMA1_INTPMX_MERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ERR_TYP_CR, 0x180010)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_TYP_CR, 0x180014)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_EN_CR, 0x180034)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, 0x180054)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ISO_SR, 0x180074)
    FIELD(PMCDMA1_INTPMX_MERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_TOP_ERR_SRC_SR, 0x180078)
    FIELD(PMCDMA1_INTPMX_MERB_TOP_ERR_SRC_SR, IF_PMCDMA1_INTPMX_AXI_ERROR_TYPE,
            24, 1) FIELD(PMCDMA1_INTPMX_MERB_TOP_ERR_SRC_SR,
                IF_PMCDMA1_INTPMX_AXI_INTF_ERR, 16, 1)
    FIELD(PMCDMA1_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(PMCDMA1_INTPMX_MERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ERR_ISR, 0x18007c)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_ISR, MISSION, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ERR_IMR, 0x180080)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IMR, MISSION, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ERR_IER, 0x180084)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IER, MISSION, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_ERR_IDR, 0x180088)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(PMCDMA1_INTPMX_MERB_ERR_IDR, MISSION, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_INTR_ISR, 0x180090)
    FIELD(PMCDMA1_INTPMX_MERB_INTR_ISR, LATENT, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_INTR_IMR, 0x180094)
    FIELD(PMCDMA1_INTPMX_MERB_INTR_IMR, LATENT, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_INTR_IER, 0x180098)
    FIELD(PMCDMA1_INTPMX_MERB_INTR_IER, LATENT, 0, 1)
REG32(PMCDMA1_INTPMX_MERB_INTR_IDR, 0x18009c)
    FIELD(PMCDMA1_INTPMX_MERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, 0x1800a4)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, 0x1800a8)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, 0x1800ac)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, 0x1800b0)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_MAIN_CR, 0x190000)
    FIELD(INTPMX_INTLPXIOU_SERB_MAIN_CR, TIMEOUT_EN, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ISO_CR, 0x19000c)
    FIELD(INTPMX_INTLPXIOU_SERB_ISO_CR, POWER_IDLEREQ, 1, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ISO_CR, SOFT_RST_N, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ERR_TYP_CR, 0x190010)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_TYP_CR, 0x190014)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_TYP_CR, ERR_CORR, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_EN_CR, 0x190034)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_EN_CR, INTF_ERR_EN, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, 0x190054)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, RD_INJ_DECERR_EN, 9, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, RD_INJ_SLVERR_EN, 8, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, WR_INJ_DECERR_EN, 7, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, WR_INJ_SLVERR_EN, 6, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, AXI_R_NOT_READY, 5, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, AXI_B_NOT_READY, 4, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, AXI_W_NOT_READY, 3, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, AXI_AR_NOT_READY, 2, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, AXI_AW_NOT_READY, 1, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_TEST_CR, PARITY_ERR_INJ_EN, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ISO_SR, 0x190074)
    FIELD(INTPMX_INTLPXIOU_SERB_ISO_SR, NO_PENDING_TRANS, 2, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ISO_SR, POWER_IDLE, 1, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ISO_SR, POWER_IDLEACK, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_TOP_ERR_SRC_SR, 0x190078)
    FIELD(INTPMX_INTLPXIOU_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_INTLPXIOU_AXI_ERROR_TYPE, 24, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_TOP_ERR_SRC_SR,
            IF_INTPMX_INTLPXIOU_AXI_INTF_ERR, 16, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_TOP_ERR_SRC_SR, ERB_ERROR_TYPE, 1, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_TOP_ERR_SRC_SR, ERB_ERROR, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ERR_ISR, 0x19007c)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_ISR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_ISR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_ISR, MISSION, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ERR_IMR, 0x190080)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IMR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IMR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IMR, MISSION, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ERR_IER, 0x190084)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IER, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IER, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IER, MISSION, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_ERR_IDR, 0x190088)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IDR, TIMEOUT_AXI_WR, 17, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IDR, TIMEOUT_AXI_RD, 16, 1)
    FIELD(INTPMX_INTLPXIOU_SERB_ERR_IDR, MISSION, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_INTR_ISR, 0x190090)
    FIELD(INTPMX_INTLPXIOU_SERB_INTR_ISR, LATENT, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_INTR_IMR, 0x190094)
    FIELD(INTPMX_INTLPXIOU_SERB_INTR_IMR, LATENT, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_INTR_IER, 0x190098)
    FIELD(INTPMX_INTLPXIOU_SERB_INTR_IER, LATENT, 0, 1)
REG32(INTPMX_INTLPXIOU_SERB_INTR_IDR, 0x19009c)
    FIELD(INTPMX_INTLPXIOU_SERB_INTR_IDR, LATENT, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, 0x1900a4)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_ISR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, 0x1900a8)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, 0x1900ac)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IER, WR_SLVERR, 0, 1)
REG32(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, 0x1900b0)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, POISON_R, 17, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, POISON_W, 16, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_B, 12, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_R, 11, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_W, 10, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_AR, 9, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, PARITY_ERR_AW, 8, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, RD_DECERR, 3, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, RD_SLVERR, 2, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, WR_DECERR, 1, 1)
    FIELD(IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR, WR_SLVERR, 0, 1)

#define PMXC_INTPMX_CONFIG_R_MAX (R_IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IDR + 1)

#define DPRINT(x, ...)  \
        if (XILINX_PMXC_INTPMX_CONFIG_DEBUG) {  \
            qemu_log("%s:", __func__);  \
            qemu_log(x, ## __VA_ARGS__); \
        }

typedef struct PMXC_INTPMX_CONFIG {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t intpmx_npi_serb_iso_cr;
    uint32_t intpmx_npi_serb_iso_sr;
} PMXC_INTPMX_CONFIG;

static uint32_t axi_switch_reset(PMXC_INTPMX_CONFIG *s, uint32_t ctrl)
{
    uint32_t ret = 0;

    if (ctrl & R_INTPMX_NPI_SERB_ISO_CR_SOFT_RST_N_MASK) {
        if (ctrl & R_INTPMX_NPI_SERB_ISO_CR_POWER_IDLEREQ_MASK) {
            ret |= R_INTPMX_NPI_SERB_ISO_SR_POWER_IDLE_MASK |
                   R_INTPMX_NPI_SERB_ISO_SR_POWER_IDLEACK_MASK;
        } else {
            ret &= ~(R_INTPMX_NPI_SERB_ISO_SR_POWER_IDLE_MASK |
                     R_INTPMX_NPI_SERB_ISO_SR_POWER_IDLEACK_MASK);
        }
    }
    return ret;
}

static uint64_t pmxc_read_memory(void *opaque, hwaddr addr,
                                 unsigned size)
{
    PMXC_INTPMX_CONFIG *s = XILINX_PMXC_INTPMX_CONFIG(opaque);
    uint32_t ret = 0;

    switch (addr) {
    case A_TRACE_ALARM_0_IMR_REG:
        ret = 0x1fff;
        break;
    case A_PMCGLOBAL_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMCGLOBAL_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMCGLOBAL_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMCGLOBAL_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_PMCGLOBALREG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_DEBUG_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_DEBUG_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_DEBUG_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_DEBUG_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_DAPREG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PMCTAP_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_FIREWALL_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_FIREWALL_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_FIREWALL_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_FIREWALL_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_XMPU_CFU_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_XMPU_PRAM_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_XMPU_SBI_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_XPPU_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_XPPU_NPI_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_LSBUS_CLK_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_LSBUS_CLK_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_LSBUS_CLK_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_LSBUS_CLK_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_BBRAM_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PMCANLG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_SBIREG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_PPU_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_PPU_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_PPU_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_PPU_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_PMCOCMCFG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PPU0TMRTRACE_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PPU1RAM_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PPU1TMRTRACE_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_RST_INTCNTL_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_RST_INTCNTL_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_RST_INTCNTL_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_RST_INTCNTL_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_CONFIG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_CRP_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_SLCRSECURE_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_WDT_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_RTC_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_RTC_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_RTC_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_RTC_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_RTC_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_SECURE_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_SECURE_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_SECURE_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_SECURE_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_AES_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_ECDSARSA_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PMCDMA0REG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_PMCDMA1REG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_SHA0_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_SHA1_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_IF_INTPMX_TRNG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_SYSMONROOT_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_SYSMONROOT_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_SYSMONROOT_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_SYSMONROOT_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_SYSMONROOT_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PMX_SYSMON_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_SYSMON_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_SYSMON_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_PMX_SYSMON_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_SYSMONROOT_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_PMX_POWER_MSERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMX_POWER_MSERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMX_POWER_MSERB_ERR_IMR:
        ret = 0x1;
        break;
    case A_PMX_POWER_MSERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_DPC_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_DPC_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_DPC_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_DPC_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_DPC_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_CFUSTREAM_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_CFUSTREAM_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_CFUSTREAM_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_CFUSTREAM_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_CFUSTREAM_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_CFU_APB_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_CFU_APB_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_CFU_APB_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_INTPMX_CFU_APB_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_CFUREG_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_INTPMX_EFUSE_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_EFUSE_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_EFUSE_SERB_ERR_IMR:
        ret = 0x10001;
        break;
    case A_INTPMX_EFUSE_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_EFUSE_APB_INTF_ERR_IMR:
        ret = 0x10101;
        break;
    case A_INTPMXIOU_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMXIOU_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMXIOU_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMXIOU_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMXIOU_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_INTPMXIOU_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_INTPMXIOU_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_INTPMXIOU_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_INTPMXIOU_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_INTPMXIOU_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_NPI_SERB_ISO_CR:
        ret = s->intpmx_npi_serb_iso_cr;
        break;
    case A_INTPMX_NPI_SERB_ISO_SR:
        ret = s->intpmx_npi_serb_iso_sr;
        break;
    case A_INTPMX_NPI_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_NPI_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_NPI_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_PMCOCM_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_PMCOCM_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_PMCOCM_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_PMCOCM_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_PMCOCM_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PPU0_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PPU0_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PPU0_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PPU0_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PPU0_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_PPU0MDMSHD_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_PPU0MDMSHD_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_PPU0MDMSHD_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_PPU0MDMSHD_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_PPU0MDMSHD_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PPU1_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PPU1_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PPU1_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PPU1_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PPU1_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_PPU1MDMSHD_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_PPU1MDMSHD_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_PPU1MDMSHD_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_PPU1MDMSHD_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_PPU1MDMSHD_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_SBI_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_SBI_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_SBI_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_SBI_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_SBI_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_JTAG_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_JTAG_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_JTAG_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_JTAG_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_JTAGDAP_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PMC_NOC_AXI_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMC_NOC_AXI_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMC_NOC_AXI_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PMC_NOC_AXI_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PMC_NOC_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_NOC_PMC_AXI_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_NOC_PMC_AXI_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_NOC_PMC_AXI_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_NOC_PMC_AXI_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_NOC_PMC_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PS_PMC_AXI_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PS_PMC_AXI_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PS_PMC_AXI_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PS_PMC_AXI_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PS_PMC_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PMC_PS_AXI_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMC_PS_AXI_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMC_PS_AXI_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PMC_PS_AXI_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PMC_PS_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PMCDMA0_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMCDMA0_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMCDMA0_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PMCDMA0_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PMCDMA0_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_PMCDMA1_INTPMX_MERB_ISO_CR:
        ret = 0x1;
        break;
    case A_PMCDMA1_INTPMX_MERB_ISO_SR:
        ret = 0x3;
        break;
    case A_PMCDMA1_INTPMX_MERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_PMCDMA1_INTPMX_MERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_PMCDMA1_INTPMX_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    case A_INTPMX_INTLPXIOU_SERB_ISO_CR:
        ret = 0x1;
        break;
    case A_INTPMX_INTLPXIOU_SERB_ISO_SR:
        ret = 0x3;
        break;
    case A_INTPMX_INTLPXIOU_SERB_ERR_IMR:
        ret = 0x30001;
        break;
    case A_INTPMX_INTLPXIOU_SERB_INTR_IMR:
        ret = 0x3;
        break;
    case A_IF_INTPMX_INTLPXIOU_AXI_INTF_ERR_IMR:
        ret = 0x31f0f;
        break;
    };

    DPRINT("addr: 0x%"HWADDR_PRIx" data:0x%"PRIx32"\n", addr, ret);

    return ret;
}

static void pmxc_write_memory(void *opaque, hwaddr addr,
                              uint64_t data, unsigned size)
{
    PMXC_INTPMX_CONFIG *s = XILINX_PMXC_INTPMX_CONFIG(opaque);

    DPRINT("addr: 0x%"HWADDR_PRIx" data 0x%"PRIx32"\n", addr, (uint32_t)data);
    switch (addr) {
    case A_INTPMX_NPI_SERB_ISO_CR:
        s->intpmx_npi_serb_iso_cr = data;
        s->intpmx_npi_serb_iso_sr = axi_switch_reset(s, data);
        break;
    };
}

static void pmxc_intpmx_config_reset_enter(Object *obj, ResetType type)
{
    PMXC_INTPMX_CONFIG *s = XILINX_PMXC_INTPMX_CONFIG(obj);

    s->intpmx_npi_serb_iso_cr = 0x1;
}

static const MemoryRegionOps pmxc_intpmx_config_ops = {
    .read = pmxc_read_memory,
    .write = pmxc_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmxc_intpmx_config_init(Object *obj)
{
    PMXC_INTPMX_CONFIG *s = XILINX_PMXC_INTPMX_CONFIG(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    memory_region_init_io(&s->iomem, obj, &pmxc_intpmx_config_ops, obj,
            TYPE_XILINX_PMXC_INTPMX_CONFIG, PMXC_INTPMX_CONFIG_R_MAX * 4);
    sysbus_init_mmio(sbd, &s->iomem);
}

static void pmxc_intpmx_config_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);

    rc->phases.enter = pmxc_intpmx_config_reset_enter;
}

static const TypeInfo pmxc_intpmx_config_info = {
    .name          = TYPE_XILINX_PMXC_INTPMX_CONFIG,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMXC_INTPMX_CONFIG),
    .class_init = pmxc_intpmx_config_class_init,
    .instance_init = pmxc_intpmx_config_init,
};

static void pmxc_intpmx_config_register_types(void)
{
    type_register_static(&pmxc_intpmx_config_info);
}

type_init(pmxc_intpmx_config_register_types)
