/*
 * QEMU model of the CCI500 This component definition describes the
 * CCI-500 Cache Coherent Interconnect.
 *
 * Copyright (c) 2019 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2019-04-16.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_CCI500_ERR_DEBUG
#define XILINX_CCI500_ERR_DEBUG 0
#endif

#define TYPE_XILINX_CCI500 "xlnx.cci500"

#define XILINX_CCI500(obj) \
     OBJECT_CHECK(CCI500, (obj), TYPE_XILINX_CCI500)

REG32(CTRL_OVR, 0x0)
    FIELD(CTRL_OVR, DISABLE_CLOCK_GATING, 3, 1)
    FIELD(CTRL_OVR, DISABLE_SNOOP_FILTER, 2, 1)
    FIELD(CTRL_OVR, DVM_MESSAGE_DISABLE, 1, 1)
    FIELD(CTRL_OVR, SNOOP_DISABLE, 0, 1)
REG32(SECR_ACC, 0x8)
    FIELD(SECR_ACC, SECURE_OBSERVATION_OVERRIDE, 2, 1)
    FIELD(SECR_ACC, DEBUG_MONITOR_SECURITY_OVERRIDE, 1, 1)
    FIELD(SECR_ACC, NON_SECURE_REGISTER_ACCESS_OVERRIDE, 0, 1)
REG32(STATUS, 0xc)
    FIELD(STATUS, SF_RAM_STATE_CHANGE_PENDING, 8, 1)
    FIELD(STATUS, SF_RAM_STATE_REQUEST, 5, 3)
    FIELD(STATUS, SF_RAM_STATE, 2, 3)
    FIELD(STATUS, SF_RAM_INITIALIZATION, 1, 1)
    FIELD(STATUS, CHANGE_PENDING, 0, 1)
REG32(IMPR_ERR, 0x10)
    FIELD(IMPR_ERR, RESERVED_2, 23, 9)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI6, 22, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI5, 21, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI4, 20, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI3, 19, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI2, 18, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI1, 17, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_SI0, 16, 1)
    FIELD(IMPR_ERR, RESERVED_1, 6, 10)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_MI5, 5, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_MI4, 4, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_MI3, 3, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_MI2, 2, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_MI1, 1, 1)
    FIELD(IMPR_ERR, IMPRECISE_ERROR_INDICATOR_MI0, 0, 1)
REG32(QOS_THRESHOLD, 0x14)
    FIELD(QOS_THRESHOLD, RESERVED_2, 20, 12)
    FIELD(QOS_THRESHOLD, W_QV_THRESH_HIGH, 16, 4)
    FIELD(QOS_THRESHOLD, RESERVED_1, 4, 12)
    FIELD(QOS_THRESHOLD, R_QV_THRESH_HIGH, 0, 4)
REG32(PMU_CTRL, 0x100)
    FIELD(PMU_CTRL, RESERVED_3, 16, 16)
    FIELD(PMU_CTRL, NUMBER_OF_COUNTERS, 11, 5)
    FIELD(PMU_CTRL, RESERVED_2, 5, 6)
    FIELD(PMU_CTRL, EX, 4, 1)
    FIELD(PMU_CTRL, RESERVED_1, 2, 2)
    FIELD(PMU_CTRL, RST, 1, 1)
    FIELD(PMU_CTRL, CEN, 0, 1)
REG32(DEBUG_CTRL, 0x104)
    FIELD(DEBUG_CTRL, ENABLE_INTERFACE_MONITORS, 0, 1)
REG32(PERIPHERAL_ID4, 0xfd0)
    FIELD(PERIPHERAL_ID4, REGION_COUNT, 4, 4)
    FIELD(PERIPHERAL_ID4, JEDEC_JEP106_CONTINUATOR_CODE, 0, 4)
REG32(PERIPHERAL_ID5, 0xfd4)
    FIELD(PERIPHERAL_ID5, RESERVED_PERIPHERAL_ID5, 0, 8)
REG32(PERIPHERAL_ID6, 0xfd8)
    FIELD(PERIPHERAL_ID6, RESERVED_PERIPHERAL_ID6, 0, 8)
REG32(PERIPHERAL_ID7, 0xfdc)
    FIELD(PERIPHERAL_ID7, RESERVED_PERIPHERAL_ID7, 0, 8)
REG32(PERIPHERAL_ID0, 0xfe0)
    FIELD(PERIPHERAL_ID0, PART_NUMBER_0, 0, 8)
REG32(PERIPHERAL_ID1, 0xfe4)
    FIELD(PERIPHERAL_ID1, JEDEC_ID_0, 4, 4)
    FIELD(PERIPHERAL_ID1, PART_NUMBER_1, 0, 4)
REG32(PERIPHERAL_ID2, 0xfe8)
    FIELD(PERIPHERAL_ID2, REVISION_NUMBER, 4, 4)
    FIELD(PERIPHERAL_ID2, JEDEC_INDICATION, 3, 1)
    FIELD(PERIPHERAL_ID2, JEDEC_ID_1, 0, 3)
REG32(PERIPHERAL_ID3, 0xfec)
    FIELD(PERIPHERAL_ID3, REVAND, 4, 4)
    FIELD(PERIPHERAL_ID3, CUSTOMER_MODIFIED, 0, 4)
REG32(COMPONENT_ID0, 0xff0)
    FIELD(COMPONENT_ID0, COMPONENT_ID0, 0, 8)
REG32(COMPONENT_ID1, 0xff4)
    FIELD(COMPONENT_ID1, COMPONENT_ID1, 0, 8)
REG32(COMPONENT_ID2, 0xff8)
    FIELD(COMPONENT_ID2, COMPONENT_ID2, 0, 8)
REG32(COMPONENT_ID3, 0xffc)
    FIELD(COMPONENT_ID3, COMPONENT_ID3, 0, 8)
REG32(SNOOP_CTRL_SI0, 0x1000)
    FIELD(SNOOP_CTRL_SI0, SUPPORT_DVMS, 31, 1)
    FIELD(SNOOP_CTRL_SI0, SUPPORT_SNOOPS, 30, 1)
    FIELD(SNOOP_CTRL_SI0, ENABLE_DVMS, 1, 1)
    FIELD(SNOOP_CTRL_SI0, ENABLE_SNOOPS, 0, 1)
REG32(SHARE_OVR_SI0, 0x1004)
    FIELD(SHARE_OVR_SI0, SHAREABLE_OVERRIDE, 0, 2)
REG32(ARQOS_OVR_SI0, 0x1100)
    FIELD(ARQOS_OVR_SI0, ARQOS_VALUE, 0, 4)
REG32(AWQOS_OVR_SI0, 0x1104)
    FIELD(AWQOS_OVR_SI0, AWQOS_VALUE, 0, 4)
REG32(QOS_MAX_OT_SI0, 0x1110)
    FIELD(QOS_MAX_OT_SI0, MAX_OT, 0, 8)
REG32(SNOOP_CTRL_SI1, 0x2000)
    FIELD(SNOOP_CTRL_SI1, SUPPORT_DVMS, 31, 1)
    FIELD(SNOOP_CTRL_SI1, SUPPORT_SNOOPS, 30, 1)
    FIELD(SNOOP_CTRL_SI1, ENABLE_DVMS, 1, 1)
    FIELD(SNOOP_CTRL_SI1, ENABLE_SNOOPS, 0, 1)
REG32(SHARE_OVR_SI1, 0x2004)
    FIELD(SHARE_OVR_SI1, SHAREABLE_OVERRIDE, 0, 2)
REG32(ARQOS_OVR_SI1, 0x2100)
    FIELD(ARQOS_OVR_SI1, ARQOS_VALUE, 0, 4)
REG32(AWQOS_OVR_SI1, 0x2104)
    FIELD(AWQOS_OVR_SI1, AWQOS_VALUE, 0, 4)
REG32(QOS_MAX_OT_SI1, 0x2110)
    FIELD(QOS_MAX_OT_SI1, MAX_OT, 0, 8)
REG32(SNOOP_CTRL_SI2, 0x3000)
    FIELD(SNOOP_CTRL_SI2, SUPPORT_DVMS, 31, 1)
    FIELD(SNOOP_CTRL_SI2, SUPPORT_SNOOPS, 30, 1)
    FIELD(SNOOP_CTRL_SI2, ENABLE_DVMS, 1, 1)
    FIELD(SNOOP_CTRL_SI2, ENABLE_SNOOPS, 0, 1)
REG32(SHARE_OVR_SI2, 0x3004)
    FIELD(SHARE_OVR_SI2, SHAREABLE_OVERRIDE, 0, 2)
REG32(ARQOS_OVR_SI2, 0x3100)
    FIELD(ARQOS_OVR_SI2, ARQOS_VALUE, 0, 4)
REG32(AWQOS_OVR_SI2, 0x3104)
    FIELD(AWQOS_OVR_SI2, AWQOS_VALUE, 0, 4)
REG32(QOS_MAX_OT_SI2, 0x3110)
    FIELD(QOS_MAX_OT_SI2, MAX_OT, 0, 8)
REG32(SNOOP_CTRL_SI3, 0x4000)
    FIELD(SNOOP_CTRL_SI3, SUPPORT_DVMS, 31, 1)
    FIELD(SNOOP_CTRL_SI3, SUPPORT_SNOOPS, 30, 1)
    FIELD(SNOOP_CTRL_SI3, ENABLE_DVMS, 1, 1)
    FIELD(SNOOP_CTRL_SI3, ENABLE_SNOOPS, 0, 1)
REG32(SHARE_OVR_SI3, 0x4004)
    FIELD(SHARE_OVR_SI3, SHAREABLE_OVERRIDE, 0, 2)
REG32(ARQOS_OVR_SI3, 0x4100)
    FIELD(ARQOS_OVR_SI3, ARQOS_VALUE, 0, 4)
REG32(AWQOS_OVR_SI3, 0x4104)
    FIELD(AWQOS_OVR_SI3, AWQOS_VALUE, 0, 4)
REG32(QOS_MAX_OT_SI3, 0x4110)
    FIELD(QOS_MAX_OT_SI3, MAX_OT, 0, 8)
REG32(SNOOP_CTRL_SI4, 0x5000)
    FIELD(SNOOP_CTRL_SI4, SUPPORT_DVMS, 31, 1)
    FIELD(SNOOP_CTRL_SI4, SUPPORT_SNOOPS, 30, 1)
    FIELD(SNOOP_CTRL_SI4, ENABLE_DVMS, 1, 1)
    FIELD(SNOOP_CTRL_SI4, ENABLE_SNOOPS, 0, 1)
REG32(SHARE_OVR_SI4, 0x5004)
    FIELD(SHARE_OVR_SI4, SHAREABLE_OVERRIDE, 0, 2)
REG32(ARQOS_OVR_SI4, 0x5100)
    FIELD(ARQOS_OVR_SI4, ARQOS_VALUE, 0, 4)
REG32(AWQOS_OVR_SI4, 0x5104)
    FIELD(AWQOS_OVR_SI4, AWQOS_VALUE, 0, 4)
REG32(QOS_MAX_OT_SI4, 0x5110)
    FIELD(QOS_MAX_OT_SI4, MAX_OT, 0, 8)
REG32(SNOOP_CTRL_SI5, 0x6000)
    FIELD(SNOOP_CTRL_SI5, SUPPORT_DVMS, 31, 1)
    FIELD(SNOOP_CTRL_SI5, SUPPORT_SNOOPS, 30, 1)
    FIELD(SNOOP_CTRL_SI5, ENABLE_DVMS, 1, 1)
    FIELD(SNOOP_CTRL_SI5, ENABLE_SNOOPS, 0, 1)
REG32(SHARE_OVR_SI5, 0x6004)
    FIELD(SHARE_OVR_SI5, SHAREABLE_OVERRIDE, 0, 2)
REG32(ARQOS_OVR_SI5, 0x6100)
    FIELD(ARQOS_OVR_SI5, ARQOS_VALUE, 0, 4)
REG32(AWQOS_OVR_SI5, 0x6104)
    FIELD(AWQOS_OVR_SI5, AWQOS_VALUE, 0, 4)
REG32(QOS_MAX_OT_SI5, 0x6110)
    FIELD(QOS_MAX_OT_SI5, MAX_OT, 0, 8)
REG32(EVNT_SEL_0, 0x10000)
    FIELD(EVNT_SEL_0, MON_INT_0, 5, 4)
    FIELD(EVNT_SEL_0, MON_EVT_0, 0, 5)
REG32(ECNT_DATA_0, 0x10004)
REG32(ECNT_CTRL_0, 0x10008)
    FIELD(ECNT_CTRL_0, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_0, 0x1000c)
    FIELD(ECNT_CLR_OVFL_0, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_1, 0x20000)
    FIELD(EVNT_SEL_1, MON_INT_1, 5, 4)
    FIELD(EVNT_SEL_1, MON_EVT_1, 0, 5)
REG32(ECNT_DATA_1, 0x20004)
REG32(ECNT_CTRL_1, 0x20008)
    FIELD(ECNT_CTRL_1, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_1, 0x2000c)
    FIELD(ECNT_CLR_OVFL_1, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_2, 0x30000)
    FIELD(EVNT_SEL_2, MON_INT_2, 5, 4)
    FIELD(EVNT_SEL_2, MON_EVT_2, 0, 5)
REG32(ECNT_DATA_2, 0x30004)
REG32(ECNT_CTRL_2, 0x30008)
    FIELD(ECNT_CTRL_2, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_2, 0x3000c)
    FIELD(ECNT_CLR_OVFL_2, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_3, 0x40000)
    FIELD(EVNT_SEL_3, MON_INT_3, 5, 4)
    FIELD(EVNT_SEL_3, MON_EVT_3, 0, 5)
REG32(ECNT_DATA_3, 0x40004)
REG32(ECNT_CTRL_3, 0x40008)
    FIELD(ECNT_CTRL_3, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_3, 0x4000c)
    FIELD(ECNT_CLR_OVFL_3, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_4, 0x50000)
    FIELD(EVNT_SEL_4, MON_INT_4, 5, 4)
    FIELD(EVNT_SEL_4, MON_EVT_4, 0, 5)
REG32(ECNT_DATA_4, 0x50004)
REG32(ECNT_CTRL_4, 0x50008)
    FIELD(ECNT_CTRL_4, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_4, 0x5000c)
    FIELD(ECNT_CLR_OVFL_4, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_5, 0x60000)
    FIELD(EVNT_SEL_5, MON_INT_5, 5, 4)
    FIELD(EVNT_SEL_5, MON_EVT_5, 0, 5)
REG32(ECNT_DATA_5, 0x60004)
REG32(ECNT_CTRL_5, 0x60008)
    FIELD(ECNT_CTRL_5, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_5, 0x6000c)
    FIELD(ECNT_CLR_OVFL_5, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_6, 0x70000)
    FIELD(EVNT_SEL_6, MON_INT_6, 5, 4)
    FIELD(EVNT_SEL_6, MON_EVT_6, 0, 5)
REG32(ECNT_DATA_6, 0x70004)
REG32(ECNT_CTRL_6, 0x70008)
    FIELD(ECNT_CTRL_6, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_6, 0x7000c)
    FIELD(ECNT_CLR_OVFL_6, EVENT_COUNTER, 0, 1)
REG32(EVNT_SEL_7, 0x80000)
    FIELD(EVNT_SEL_7, MON_INT_7, 5, 4)
    FIELD(EVNT_SEL_7, MON_EVT_7, 0, 5)
REG32(ECNT_DATA_7, 0x80004)
REG32(ECNT_CTRL_7, 0x80008)
    FIELD(ECNT_CTRL_7, COUNTER_ENABLE, 0, 1)
REG32(ECNT_CLR_OVFL_7, 0x8000c)
    FIELD(ECNT_CLR_OVFL_7, EVENT_COUNTER, 0, 1)
REG32(SLAVE_DEBUG_SI0, 0x90000)
    FIELD(SLAVE_DEBUG_SI0, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI0, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI0, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI0, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI0, STALLED_AR_CHANNEL, 0, 1)
REG32(SLAVE_DEBUG_SI1, 0x90004)
    FIELD(SLAVE_DEBUG_SI1, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI1, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI1, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI1, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI1, STALLED_AR_CHANNEL, 0, 1)
REG32(SLAVE_DEBUG_SI2, 0x90008)
    FIELD(SLAVE_DEBUG_SI2, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI2, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI2, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI2, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI2, STALLED_AR_CHANNEL, 0, 1)
REG32(SLAVE_DEBUG_SI3, 0x9000c)
    FIELD(SLAVE_DEBUG_SI3, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI3, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI3, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI3, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI3, STALLED_AR_CHANNEL, 0, 1)
REG32(SLAVE_DEBUG_SI4, 0x90010)
    FIELD(SLAVE_DEBUG_SI4, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI4, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI4, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI4, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI4, STALLED_AR_CHANNEL, 0, 1)
REG32(SLAVE_DEBUG_SI5, 0x90014)
    FIELD(SLAVE_DEBUG_SI5, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI5, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI5, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI5, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI5, STALLED_AR_CHANNEL, 0, 1)
REG32(SLAVE_DEBUG_SI6, 0x90018)
    FIELD(SLAVE_DEBUG_SI6, OUTSTANDING_SNOOPS, 24, 8)
    FIELD(SLAVE_DEBUG_SI6, OUTSTANDING_WRITES, 16, 8)
    FIELD(SLAVE_DEBUG_SI6, OUTSTANDING_READS, 8, 8)
    FIELD(SLAVE_DEBUG_SI6, STALLED_CD_CHANNEL, 7, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_CR_CHANNEL, 6, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_AC_CHANNEL, 5, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_B_CHANNEL, 4, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_W_CHANNEL, 3, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_AW_CHANNEL, 2, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_R_CHANNEL, 1, 1)
    FIELD(SLAVE_DEBUG_SI6, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI0, 0x90100)
    FIELD(MASTER_DEBUG_MI0, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI0, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI0, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI0, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI0, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI0, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI0, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI0, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI0, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI1, 0x90104)
    FIELD(MASTER_DEBUG_MI1, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI1, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI1, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI1, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI1, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI1, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI1, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI1, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI1, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI2, 0x90108)
    FIELD(MASTER_DEBUG_MI2, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI2, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI2, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI2, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI2, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI2, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI2, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI2, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI2, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI3, 0x9010c)
    FIELD(MASTER_DEBUG_MI3, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI3, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI3, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI3, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI3, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI3, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI3, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI3, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI3, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI4, 0x90110)
    FIELD(MASTER_DEBUG_MI4, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI4, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI4, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI4, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI4, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI4, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI4, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI4, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI4, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI5, 0x90114)
    FIELD(MASTER_DEBUG_MI5, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI5, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI5, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI5, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI5, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI5, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI5, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI5, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI5, STALLED_AR_CHANNEL, 0, 1)
REG32(MASTER_DEBUG_MI6, 0x90118)
    FIELD(MASTER_DEBUG_MI6, RESERVED_2, 24, 8)
    FIELD(MASTER_DEBUG_MI6, OUTSTANDING_WRITES, 16, 8)
    FIELD(MASTER_DEBUG_MI6, OUTSTANDING_READS, 8, 8)
    FIELD(MASTER_DEBUG_MI6, RESERVED_1, 5, 3)
    FIELD(MASTER_DEBUG_MI6, STALLED_B_CHANNEL, 4, 1)
    FIELD(MASTER_DEBUG_MI6, STALLED_W_CHANNEL, 3, 1)
    FIELD(MASTER_DEBUG_MI6, STALLED_AW_CHANNEL, 2, 1)
    FIELD(MASTER_DEBUG_MI6, STALLED_R_CHANNEL, 1, 1)
    FIELD(MASTER_DEBUG_MI6, STALLED_AR_CHANNEL, 0, 1)

#define CCI500_R_MAX (R_MASTER_DEBUG_MI6 + 1)

typedef struct CCI500 {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[CCI500_R_MAX];
    RegisterInfo regs_info[CCI500_R_MAX];
} CCI500;

static const RegisterAccessInfo cci500_regs_info[] = {
    {   .name = "CTRL_OVR",  .addr = A_CTRL_OVR,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "SECR_ACC",  .addr = A_SECR_ACC,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
    },{ .name = "STATUS",  .addr = A_STATUS,
        .rsvd = 0xfffffe00,
        .ro = 0xffffffff,
    },{ .name = "IMPR_ERR",  .addr = A_IMPR_ERR,
        .ro = 0xff80ffc0,
    },{ .name = "QOS_THRESHOLD",  .addr = A_QOS_THRESHOLD,
        .ro = 0xfff0fff0,
    },{ .name = "PMU_CTRL",  .addr = A_PMU_CTRL,
        .reset = 0x4000,
        .ro = 0xffffffec,
    },{ .name = "DEBUG_CTRL",  .addr = A_DEBUG_CTRL,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "PERIPHERAL_ID4",  .addr = A_PERIPHERAL_ID4,
        .reset = 0x84,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID5",  .addr = A_PERIPHERAL_ID5,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID6",  .addr = A_PERIPHERAL_ID6,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID7",  .addr = A_PERIPHERAL_ID7,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID0",  .addr = A_PERIPHERAL_ID0,
        .reset = 0x22,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID1",  .addr = A_PERIPHERAL_ID1,
        .reset = 0xb4,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID2",  .addr = A_PERIPHERAL_ID2,
        .reset = 0x3b,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "PERIPHERAL_ID3",  .addr = A_PERIPHERAL_ID3,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "COMPONENT_ID0",  .addr = A_COMPONENT_ID0,
        .reset = 0xd,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "COMPONENT_ID1",  .addr = A_COMPONENT_ID1,
        .reset = 0xf0,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "COMPONENT_ID2",  .addr = A_COMPONENT_ID2,
        .reset = 0x5,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "COMPONENT_ID3",  .addr = A_COMPONENT_ID3,
        .reset = 0xb1,
        .rsvd = 0xffffff00,
        .ro = 0xffffffff,
    },{ .name = "SNOOP_CTRL_SI0",  .addr = A_SNOOP_CTRL_SI0,
        .rsvd = 0x3ffffffc,
        .ro = 0xfffffffc,
    },{ .name = "SHARE_OVR_SI0",  .addr = A_SHARE_OVR_SI0,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ARQOS_OVR_SI0",  .addr = A_ARQOS_OVR_SI0,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "AWQOS_OVR_SI0",  .addr = A_AWQOS_OVR_SI0,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "QOS_MAX_OT_SI0",  .addr = A_QOS_MAX_OT_SI0,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "SNOOP_CTRL_SI1",  .addr = A_SNOOP_CTRL_SI1,
        .rsvd = 0x3ffffffc,
        .ro = 0xfffffffc,
    },{ .name = "SHARE_OVR_SI1",  .addr = A_SHARE_OVR_SI1,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ARQOS_OVR_SI1",  .addr = A_ARQOS_OVR_SI1,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "AWQOS_OVR_SI1",  .addr = A_AWQOS_OVR_SI1,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "QOS_MAX_OT_SI1",  .addr = A_QOS_MAX_OT_SI1,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "SNOOP_CTRL_SI2",  .addr = A_SNOOP_CTRL_SI2,
        .rsvd = 0x3ffffffc,
        .ro = 0xfffffffc,
    },{ .name = "SHARE_OVR_SI2",  .addr = A_SHARE_OVR_SI2,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ARQOS_OVR_SI2",  .addr = A_ARQOS_OVR_SI2,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "AWQOS_OVR_SI2",  .addr = A_AWQOS_OVR_SI2,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "QOS_MAX_OT_SI2",  .addr = A_QOS_MAX_OT_SI2,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "SNOOP_CTRL_SI3",  .addr = A_SNOOP_CTRL_SI3,
        .rsvd = 0x3ffffffc,
        .ro = 0xfffffffc,
    },{ .name = "SHARE_OVR_SI3",  .addr = A_SHARE_OVR_SI3,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ARQOS_OVR_SI3",  .addr = A_ARQOS_OVR_SI3,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "AWQOS_OVR_SI3",  .addr = A_AWQOS_OVR_SI3,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "QOS_MAX_OT_SI3",  .addr = A_QOS_MAX_OT_SI3,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "SNOOP_CTRL_SI4",  .addr = A_SNOOP_CTRL_SI4,
        .rsvd = 0x3ffffffc,
        .ro = 0xfffffffc,
    },{ .name = "SHARE_OVR_SI4",  .addr = A_SHARE_OVR_SI4,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ARQOS_OVR_SI4",  .addr = A_ARQOS_OVR_SI4,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "AWQOS_OVR_SI4",  .addr = A_AWQOS_OVR_SI4,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "QOS_MAX_OT_SI4",  .addr = A_QOS_MAX_OT_SI4,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "SNOOP_CTRL_SI5",  .addr = A_SNOOP_CTRL_SI5,
        .rsvd = 0x3ffffffc,
        .ro = 0xfffffffc,
    },{ .name = "SHARE_OVR_SI5",  .addr = A_SHARE_OVR_SI5,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ARQOS_OVR_SI5",  .addr = A_ARQOS_OVR_SI5,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "AWQOS_OVR_SI5",  .addr = A_AWQOS_OVR_SI5,
        .rsvd = 0xfffffff0,
        .ro = 0xfffffff0,
    },{ .name = "QOS_MAX_OT_SI5",  .addr = A_QOS_MAX_OT_SI5,
        .rsvd = 0xffffff00,
        .ro = 0xffffff00,
    },{ .name = "EVNT_SEL_0",  .addr = A_EVNT_SEL_0,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_0",  .addr = A_ECNT_DATA_0,
    },{ .name = "ECNT_CTRL_0",  .addr = A_ECNT_CTRL_0,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_0",  .addr = A_ECNT_CLR_OVFL_0,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "EVNT_SEL_1",  .addr = A_EVNT_SEL_1,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_1",  .addr = A_ECNT_DATA_1,
    },{ .name = "ECNT_CTRL_1",  .addr = A_ECNT_CTRL_1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_1",  .addr = A_ECNT_CLR_OVFL_1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "EVNT_SEL_2",  .addr = A_EVNT_SEL_2,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_2",  .addr = A_ECNT_DATA_2,
    },{ .name = "ECNT_CTRL_2",  .addr = A_ECNT_CTRL_2,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_2",  .addr = A_ECNT_CLR_OVFL_2,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "EVNT_SEL_3",  .addr = A_EVNT_SEL_3,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_3",  .addr = A_ECNT_DATA_3,
    },{ .name = "ECNT_CTRL_3",  .addr = A_ECNT_CTRL_3,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_3",  .addr = A_ECNT_CLR_OVFL_3,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "EVNT_SEL_4",  .addr = A_EVNT_SEL_4,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_4",  .addr = A_ECNT_DATA_4,
    },{ .name = "ECNT_CTRL_4",  .addr = A_ECNT_CTRL_4,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_4",  .addr = A_ECNT_CLR_OVFL_4,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "EVNT_SEL_5",  .addr = A_EVNT_SEL_5,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_5",  .addr = A_ECNT_DATA_5,
    },{ .name = "ECNT_CTRL_5",  .addr = A_ECNT_CTRL_5,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_5",  .addr = A_ECNT_CLR_OVFL_5,
        .rsvd = 0xfffffffe,
    },{ .name = "EVNT_SEL_6",  .addr = A_EVNT_SEL_6,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_6",  .addr = A_ECNT_DATA_6,
    },{ .name = "ECNT_CTRL_6",  .addr = A_ECNT_CTRL_6,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_6",  .addr = A_ECNT_CLR_OVFL_6,
        .rsvd = 0xfffffffe,
    },{ .name = "EVNT_SEL_7",  .addr = A_EVNT_SEL_7,
        .rsvd = 0xfffffe00,
        .ro = 0xfffffe00,
    },{ .name = "ECNT_DATA_7",  .addr = A_ECNT_DATA_7,
    },{ .name = "ECNT_CTRL_7",  .addr = A_ECNT_CTRL_7,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "ECNT_CLR_OVFL_7",  .addr = A_ECNT_CLR_OVFL_7,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "SLAVE_DEBUG_SI0",  .addr = A_SLAVE_DEBUG_SI0,
        .ro = 0xffffffff,
    },{ .name = "SLAVE_DEBUG_SI1",  .addr = A_SLAVE_DEBUG_SI1,
        .ro = 0xffffffff,
    },{ .name = "SLAVE_DEBUG_SI2",  .addr = A_SLAVE_DEBUG_SI2,
        .ro = 0xffffffff,
    },{ .name = "SLAVE_DEBUG_SI3",  .addr = A_SLAVE_DEBUG_SI3,
        .ro = 0xffffffff,
    },{ .name = "SLAVE_DEBUG_SI4",  .addr = A_SLAVE_DEBUG_SI4,
        .ro = 0xffffffff,
    },{ .name = "SLAVE_DEBUG_SI5",  .addr = A_SLAVE_DEBUG_SI5,
        .ro = 0xffffffff,
    },{ .name = "SLAVE_DEBUG_SI6",  .addr = A_SLAVE_DEBUG_SI6,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI0",  .addr = A_MASTER_DEBUG_MI0,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI1",  .addr = A_MASTER_DEBUG_MI1,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI2",  .addr = A_MASTER_DEBUG_MI2,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI3",  .addr = A_MASTER_DEBUG_MI3,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI4",  .addr = A_MASTER_DEBUG_MI4,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI5",  .addr = A_MASTER_DEBUG_MI5,
        .ro = 0xffffffff,
    },{ .name = "MASTER_DEBUG_MI6",  .addr = A_MASTER_DEBUG_MI6,
        .ro = 0xffffffff,
    }
};

static void cci500_reset(DeviceState *dev)
{
    CCI500 *s = XILINX_CCI500(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static const MemoryRegionOps cci500_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void cci500_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void cci500_init(Object *obj)
{
    CCI500 *s = XILINX_CCI500(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_CCI500, CCI500_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), cci500_regs_info,
                              ARRAY_SIZE(cci500_regs_info),
                              s->regs_info, s->regs,
                              &cci500_ops,
                              XILINX_CCI500_ERR_DEBUG,
                              CCI500_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_cci500 = {
    .name = TYPE_XILINX_CCI500,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, CCI500, CCI500_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void cci500_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = cci500_reset;
    dc->realize = cci500_realize;
    dc->vmsd = &vmstate_cci500;
}

static const TypeInfo cci500_info = {
    .name          = TYPE_XILINX_CCI500,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(CCI500),
    .class_init    = cci500_class_init,
    .instance_init = cci500_init,
};

static void cci500_register_types(void)
{
    type_register_static(&cci500_info);
}

type_init(cci500_register_types)
