/*
 * QEMU model of the INT_FPD_REGS FPD Interconnect isolation, reset and
 * status registers
 *
 * Copyright (c) 2023, Advanced Micro Devices, Inc.
 *
 * Autogenerated by xregqemu.py 2023-08-02.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "hw/misc/xlnx-serbs.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_INT_FPD_REGS_ERR_DEBUG
#define XILINX_INT_FPD_REGS_ERR_DEBUG 0
#endif

#define TYPE_XILINX_INT_FPD_REGS "xlnx-intfpd-config"

#define XILINX_INT_FPD_REGS(obj) \
     OBJECT_CHECK(INT_FPD_REGS, (obj), TYPE_XILINX_INT_FPD_REGS)

#define AFIFS_SERBS_ID 1

REG32(IR_STATUS, 0x0)
    FIELD(IR_STATUS, FPD_SWITCH_CLK_WR_RESP_PROBE_MAINTRACEALARM, 19, 1)
    FIELD(IR_STATUS, FPD_SWITCH_CLK_WR_REQ_PROBE_MAINTRACEALARM, 18, 1)
    FIELD(IR_STATUS, FPD_SWITCH_CLK_RD_RESP_PROBE_MAINTRACEALARM, 17, 1)
    FIELD(IR_STATUS, FPD_SWITCH_CLK_RD_REQ_PROBE_MAINTRACEALARM, 16, 1)
    FIELD(IR_STATUS, INTFPD_SYSMONSAT_APB_MAINTIMEOUT, 12, 1)
    FIELD(IR_STATUS, INTFPD_DBG_MAINTIMEOUT, 11, 1)
    FIELD(IR_STATUS, INTFPD_INTFPDTCUPROG_MAINTIMEOUT, 10, 1)
    FIELD(IR_STATUS, INTFPD_MAIN_CCI_MAINTIMEOUT, 9, 1)
    FIELD(IR_STATUS, PS_NOC_NCI_AXI1_MAINTIMEOUT, 8, 1)
    FIELD(IR_STATUS, PS_NOC_NCI_AXI0_MAINTIMEOUT, 7, 1)
    FIELD(IR_STATUS, GICSW1_GIC_MAINTIMEOUT, 6, 1)
    FIELD(IR_STATUS, CORESW_AFIFS_SLAVE_MAINTIMEOUT, 5, 1)
    FIELD(IR_STATUS, FPD_SLCR_APB_MAINTIMEOUT, 4, 1)
    FIELD(IR_STATUS, FPD_MISC_APB_MAINTIMEOUT, 3, 1)
    FIELD(IR_STATUS, FPD_APU_APB_MAINTIMEOUT, 2, 1)
    FIELD(IR_STATUS, FPD_AFIFM_APB_MAINTIMEOUT, 1, 1)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x4)
    FIELD(IR_MASK, FPD_SWITCH_CLK_WR_RESP_PROBE_MAINTRACEALARM, 19, 1)
    FIELD(IR_MASK, FPD_SWITCH_CLK_WR_REQ_PROBE_MAINTRACEALARM, 18, 1)
    FIELD(IR_MASK, FPD_SWITCH_CLK_RD_RESP_PROBE_MAINTRACEALARM, 17, 1)
    FIELD(IR_MASK, FPD_SWITCH_CLK_RD_REQ_PROBE_MAINTRACEALARM, 16, 1)
    FIELD(IR_MASK, INTFPD_SYSMONSAT_APB_MAINTIMEOUT, 12, 1)
    FIELD(IR_MASK, INTFPD_DBG_MAINTIMEOUT, 11, 1)
    FIELD(IR_MASK, INTFPD_INTFPDTCUPROG_MAINTIMEOUT, 10, 1)
    FIELD(IR_MASK, INTFPD_MAIN_CCI_MAINTIMEOUT, 9, 1)
    FIELD(IR_MASK, PS_NOC_NCI_AXI1_MAINTIMEOUT, 8, 1)
    FIELD(IR_MASK, PS_NOC_NCI_AXI0_MAINTIMEOUT, 7, 1)
    FIELD(IR_MASK, GICSW1_GIC_MAINTIMEOUT, 6, 1)
    FIELD(IR_MASK, CORESW_AFIFS_SLAVE_MAINTIMEOUT, 5, 1)
    FIELD(IR_MASK, FPD_SLCR_APB_MAINTIMEOUT, 4, 1)
    FIELD(IR_MASK, FPD_MISC_APB_MAINTIMEOUT, 3, 1)
    FIELD(IR_MASK, FPD_APU_APB_MAINTIMEOUT, 2, 1)
    FIELD(IR_MASK, FPD_AFIFM_APB_MAINTIMEOUT, 1, 1)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0x8)
    FIELD(IR_ENABLE, FPD_SWITCH_CLK_WR_RESP_PROBE_MAINTRACEALARM, 19, 1)
    FIELD(IR_ENABLE, FPD_SWITCH_CLK_WR_REQ_PROBE_MAINTRACEALARM, 18, 1)
    FIELD(IR_ENABLE, FPD_SWITCH_CLK_RD_RESP_PROBE_MAINTRACEALARM, 17, 1)
    FIELD(IR_ENABLE, FPD_SWITCH_CLK_RD_REQ_PROBE_MAINTRACEALARM, 16, 1)
    FIELD(IR_ENABLE, INTFPD_SYSMONSAT_APB_MAINTIMEOUT, 12, 1)
    FIELD(IR_ENABLE, INTFPD_DBG_MAINTIMEOUT, 11, 1)
    FIELD(IR_ENABLE, INTFPD_INTFPDTCUPROG_MAINTIMEOUT, 10, 1)
    FIELD(IR_ENABLE, INTFPD_MAIN_CCI_MAINTIMEOUT, 9, 1)
    FIELD(IR_ENABLE, PS_NOC_NCI_AXI1_MAINTIMEOUT, 8, 1)
    FIELD(IR_ENABLE, PS_NOC_NCI_AXI0_MAINTIMEOUT, 7, 1)
    FIELD(IR_ENABLE, GICSW1_GIC_MAINTIMEOUT, 6, 1)
    FIELD(IR_ENABLE, CORESW_AFIFS_SLAVE_MAINTIMEOUT, 5, 1)
    FIELD(IR_ENABLE, FPD_SLCR_APB_MAINTIMEOUT, 4, 1)
    FIELD(IR_ENABLE, FPD_MISC_APB_MAINTIMEOUT, 3, 1)
    FIELD(IR_ENABLE, FPD_APU_APB_MAINTIMEOUT, 2, 1)
    FIELD(IR_ENABLE, FPD_AFIFM_APB_MAINTIMEOUT, 1, 1)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0xc)
    FIELD(IR_DISABLE, FPD_SWITCH_CLK_WR_RESP_PROBE_MAINTRACEALARM, 19, 1)
    FIELD(IR_DISABLE, FPD_SWITCH_CLK_WR_REQ_PROBE_MAINTRACEALARM, 18, 1)
    FIELD(IR_DISABLE, FPD_SWITCH_CLK_RD_RESP_PROBE_MAINTRACEALARM, 17, 1)
    FIELD(IR_DISABLE, FPD_SWITCH_CLK_RD_REQ_PROBE_MAINTRACEALARM, 16, 1)
    FIELD(IR_DISABLE, INTFPD_SYSMONSAT_APB_MAINTIMEOUT, 12, 1)
    FIELD(IR_DISABLE, INTFPD_DBG_MAINTIMEOUT, 11, 1)
    FIELD(IR_DISABLE, INTFPD_INTFPDTCUPROG_MAINTIMEOUT, 10, 1)
    FIELD(IR_DISABLE, INTFPD_MAIN_CCI_MAINTIMEOUT, 9, 1)
    FIELD(IR_DISABLE, PS_NOC_NCI_AXI1_MAINTIMEOUT, 8, 1)
    FIELD(IR_DISABLE, PS_NOC_NCI_AXI0_MAINTIMEOUT, 7, 1)
    FIELD(IR_DISABLE, GICSW1_GIC_MAINTIMEOUT, 6, 1)
    FIELD(IR_DISABLE, CORESW_AFIFS_SLAVE_MAINTIMEOUT, 5, 1)
    FIELD(IR_DISABLE, FPD_SLCR_APB_MAINTIMEOUT, 4, 1)
    FIELD(IR_DISABLE, FPD_MISC_APB_MAINTIMEOUT, 3, 1)
    FIELD(IR_DISABLE, FPD_APU_APB_MAINTIMEOUT, 2, 1)
    FIELD(IR_DISABLE, FPD_AFIFM_APB_MAINTIMEOUT, 1, 1)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(AFIFM_APB, 0x1c)
    FIELD(AFIFM_APB, RAW_RST_N, 4, 1)
    FIELD(AFIFM_APB, POWER_IDLEREQ, 3, 1)
    FIELD(AFIFM_APB, POWER_IDLEACK, 2, 1)
    FIELD(AFIFM_APB, POWER_IDLE, 1, 1)
    FIELD(AFIFM_APB, MAINEXTEN, 0, 1)
REG32(APU_APB, 0x20)
    FIELD(APU_APB, RAW_RST_N, 4, 1)
    FIELD(APU_APB, POWER_IDLEREQ, 3, 1)
    FIELD(APU_APB, POWER_IDLEACK, 2, 1)
    FIELD(APU_APB, POWER_IDLE, 1, 1)
    FIELD(APU_APB, MAINEXTEN, 0, 1)
REG32(MISC_APB, 0x24)
    FIELD(MISC_APB, RAW_RST_N, 4, 1)
    FIELD(MISC_APB, POWER_IDLEREQ, 3, 1)
    FIELD(MISC_APB, POWER_IDLEACK, 2, 1)
    FIELD(MISC_APB, POWER_IDLE, 1, 1)
    FIELD(MISC_APB, MAINEXTEN, 0, 1)
REG32(FPD_SLCR_APB, 0x28)
    FIELD(FPD_SLCR_APB, RAW_RST_N, 4, 1)
    FIELD(FPD_SLCR_APB, POWER_IDLEREQ, 3, 1)
    FIELD(FPD_SLCR_APB, POWER_IDLEACK, 2, 1)
    FIELD(FPD_SLCR_APB, POWER_IDLE, 1, 1)
    FIELD(FPD_SLCR_APB, MAINEXTEN, 0, 1)
REG32(CORESW_AFIFS_SLAVE, 0x2c)
    FIELD(CORESW_AFIFS_SLAVE, RAW_RST_N, 4, 1)
    FIELD(CORESW_AFIFS_SLAVE, POWER_IDLEREQ, 3, 1)
    FIELD(CORESW_AFIFS_SLAVE, POWER_IDLEACK, 2, 1)
    FIELD(CORESW_AFIFS_SLAVE, POWER_IDLE, 1, 1)
    FIELD(CORESW_AFIFS_SLAVE, MAINEXTEN, 0, 1)
REG32(GICSW1_GIC, 0x30)
    FIELD(GICSW1_GIC, RAW_RST_N, 4, 1)
    FIELD(GICSW1_GIC, POWER_IDLEREQ, 3, 1)
    FIELD(GICSW1_GIC, POWER_IDLEACK, 2, 1)
    FIELD(GICSW1_GIC, POWER_IDLE, 1, 1)
    FIELD(GICSW1_GIC, MAINEXTEN, 0, 1)
REG32(PS_NOC_NCI_AXI0, 0x34)
    FIELD(PS_NOC_NCI_AXI0, RAW_RST_N, 4, 1)
    FIELD(PS_NOC_NCI_AXI0, POWER_IDLEREQ, 3, 1)
    FIELD(PS_NOC_NCI_AXI0, POWER_IDLEACK, 2, 1)
    FIELD(PS_NOC_NCI_AXI0, POWER_IDLE, 1, 1)
    FIELD(PS_NOC_NCI_AXI0, MAINEXTEN, 0, 1)
REG32(PS_NOC_NCI_AXI1, 0x38)
    FIELD(PS_NOC_NCI_AXI1, RAW_RST_N, 4, 1)
    FIELD(PS_NOC_NCI_AXI1, POWER_IDLEREQ, 3, 1)
    FIELD(PS_NOC_NCI_AXI1, POWER_IDLEACK, 2, 1)
    FIELD(PS_NOC_NCI_AXI1, POWER_IDLE, 1, 1)
    FIELD(PS_NOC_NCI_AXI1, MAINEXTEN, 0, 1)
REG32(INTFPD_MAIN_CCI, 0x3c)
    FIELD(INTFPD_MAIN_CCI, RAW_RST_N, 4, 1)
    FIELD(INTFPD_MAIN_CCI, POWER_IDLEREQ, 3, 1)
    FIELD(INTFPD_MAIN_CCI, POWER_IDLEACK, 2, 1)
    FIELD(INTFPD_MAIN_CCI, POWER_IDLE, 1, 1)
    FIELD(INTFPD_MAIN_CCI, MAINEXTEN, 0, 1)
REG32(INTFPD_INTFPDTCUPROG, 0x40)
    FIELD(INTFPD_INTFPDTCUPROG, RAW_RST_N, 4, 1)
    FIELD(INTFPD_INTFPDTCUPROG, POWER_IDLEREQ, 3, 1)
    FIELD(INTFPD_INTFPDTCUPROG, POWER_IDLEACK, 2, 1)
    FIELD(INTFPD_INTFPDTCUPROG, POWER_IDLE, 1, 1)
    FIELD(INTFPD_INTFPDTCUPROG, MAINEXTEN, 0, 1)
REG32(INTFPD_SYSMONSAT, 0x44)
    FIELD(INTFPD_SYSMONSAT, RAW_RST_N, 4, 1)
    FIELD(INTFPD_SYSMONSAT, POWER_IDLEREQ, 3, 1)
    FIELD(INTFPD_SYSMONSAT, POWER_IDLEACK, 2, 1)
    FIELD(INTFPD_SYSMONSAT, POWER_IDLE, 1, 1)
    FIELD(INTFPD_SYSMONSAT, MAINEXTEN, 0, 1)
REG32(INTFPD_DBG, 0x48)
    FIELD(INTFPD_DBG, RAW_RST_N, 4, 1)
    FIELD(INTFPD_DBG, POWER_IDLEREQ, 3, 1)
    FIELD(INTFPD_DBG, POWER_IDLEACK, 2, 1)
    FIELD(INTFPD_DBG, POWER_IDLE, 1, 1)
    FIELD(INTFPD_DBG, MAINEXTEN, 0, 1)
REG32(IR_STATUS_PERR, 0x60)
    FIELD(IR_STATUS_PERR, INTFPD_CONFIG_APB_APB, 29, 1)
    FIELD(IR_STATUS_PERR, INTFPD_GP_CCI_APB, 28, 1)
    FIELD(IR_STATUS_PERR, INTFPD_WDT_APB, 27, 1)
    FIELD(IR_STATUS_PERR, INTFPD_SMMU_APB, 26, 1)
    FIELD(IR_STATUS_PERR, INTFPD_MAIN_CCI_APB, 25, 1)
    FIELD(IR_STATUS_PERR, INTFPD_FPDSLCRSECURE_APB, 24, 1)
    FIELD(IR_STATUS_PERR, INTFPD_FPDSLCR_APB, 23, 1)
    FIELD(IR_STATUS_PERR, INTFPD_CLKRTDCTRLF_APB, 22, 1)
    FIELD(IR_STATUS_PERR, INTFPD_APU_APB, 21, 1)
    FIELD(IR_STATUS_PERR, INTFPD_SYSMONSAT_APB, 20, 1)
    FIELD(IR_STATUS_PERR, INTFPD_AFIFM2_APB, 19, 1)
    FIELD(IR_STATUS_PERR, INTFPD_AFIFM0_APB, 18, 1)
    FIELD(IR_STATUS_PERR, INTFPD_INTFPDTCUPROG, 17, 1)
    FIELD(IR_STATUS_PERR, INTFPD_DBG, 16, 1)
    FIELD(IR_STATUS_PERR, CORESW_AFIFS_SLAVE, 15, 1)
    FIELD(IR_STATUS_PERR, PS_NOC_NCI_AXI1, 14, 1)
    FIELD(IR_STATUS_PERR, PS_NOC_NCI_AXI0, 13, 1)
    FIELD(IR_STATUS_PERR, GICSW1_GIC, 12, 1)
    FIELD(IR_STATUS_PERR, GIC_INTFPD, 11, 1)
    FIELD(IR_STATUS_PERR, DBG_INTFPD_AXI, 10, 1)
    FIELD(IR_STATUS_PERR, CCI_NOC_MEM5, 9, 1)
    FIELD(IR_STATUS_PERR, CCI_NOC_MEM4, 8, 1)
    FIELD(IR_STATUS_PERR, CCI_NOC_MEM3, 7, 1)
    FIELD(IR_STATUS_PERR, CCI_NOC_MEM2, 6, 1)
    FIELD(IR_STATUS_PERR, ACE_ADB400_CCI_DATA, 5, 1)
    FIELD(IR_STATUS_PERR, ACE_APU_DATA, 4, 1)
    FIELD(IR_STATUS_PERR, NOC_PS_NCI_AXI0, 3, 1)
    FIELD(IR_STATUS_PERR, NOC_PS_CCI_AXI0, 2, 1)
    FIELD(IR_STATUS_PERR, AFIFM2M_INTFPD, 1, 1)
    FIELD(IR_STATUS_PERR, AFIFM0M_INTFPD, 0, 1)
REG32(IR_MASK_PERR, 0x64)
    FIELD(IR_MASK_PERR, INTFPD_CONFIG_APB_APB, 29, 1)
    FIELD(IR_MASK_PERR, INTFPD_GP_CCI_APB, 28, 1)
    FIELD(IR_MASK_PERR, INTFPD_WDT_APB, 27, 1)
    FIELD(IR_MASK_PERR, INTFPD_SMMU_APB, 26, 1)
    FIELD(IR_MASK_PERR, INTFPD_MAIN_CCI_APB, 25, 1)
    FIELD(IR_MASK_PERR, INTFPD_FPDSLCRSECURE_APB, 24, 1)
    FIELD(IR_MASK_PERR, INTFPD_FPDSLCR_APB, 23, 1)
    FIELD(IR_MASK_PERR, INTFPD_CLKRTDCTRLF_APB, 22, 1)
    FIELD(IR_MASK_PERR, INTFPD_APU_APB, 21, 1)
    FIELD(IR_MASK_PERR, INTFPD_SYSMONSAT_APB, 20, 1)
    FIELD(IR_MASK_PERR, INTFPD_AFIFM2_APB, 19, 1)
    FIELD(IR_MASK_PERR, INTFPD_AFIFM0_APB, 18, 1)
    FIELD(IR_MASK_PERR, INTFPD_INTFPDTCUPROG, 17, 1)
    FIELD(IR_MASK_PERR, INTFPD_DBG, 16, 1)
    FIELD(IR_MASK_PERR, CORESW_AFIFS_SLAVE, 15, 1)
    FIELD(IR_MASK_PERR, PS_NOC_NCI_AXI1, 14, 1)
    FIELD(IR_MASK_PERR, PS_NOC_NCI_AXI0, 13, 1)
    FIELD(IR_MASK_PERR, GICSW1_GIC, 12, 1)
    FIELD(IR_MASK_PERR, GIC_INTFPD, 11, 1)
    FIELD(IR_MASK_PERR, DBG_INTFPD_AXI, 10, 1)
    FIELD(IR_MASK_PERR, CCI_NOC_MEM5, 9, 1)
    FIELD(IR_MASK_PERR, CCI_NOC_MEM4, 8, 1)
    FIELD(IR_MASK_PERR, CCI_NOC_MEM3, 7, 1)
    FIELD(IR_MASK_PERR, CCI_NOC_MEM2, 6, 1)
    FIELD(IR_MASK_PERR, ACE_ADB400_CCI_DATA, 5, 1)
    FIELD(IR_MASK_PERR, ACE_APU_DATA, 4, 1)
    FIELD(IR_MASK_PERR, NOC_PS_NCI_AXI0, 3, 1)
    FIELD(IR_MASK_PERR, NOC_PS_CCI_AXI0, 2, 1)
    FIELD(IR_MASK_PERR, AFIFM2M_INTFPD, 1, 1)
    FIELD(IR_MASK_PERR, AFIFM0M_INTFPD, 0, 1)
REG32(IR_ENABLE_PERR, 0x68)
    FIELD(IR_ENABLE_PERR, INTFPD_CONFIG_APB_APB, 29, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_GP_CCI_APB, 28, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_WDT_APB, 27, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_SMMU_APB, 26, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_MAIN_CCI_APB, 25, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_FPDSLCRSECURE_APB, 24, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_FPDSLCR_APB, 23, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_CLKRTDCTRLF_APB, 22, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_APU_APB, 21, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_SYSMONSAT_APB, 20, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_AFIFM2_APB, 19, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_AFIFM0_APB, 18, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_INTFPDTCUPROG, 17, 1)
    FIELD(IR_ENABLE_PERR, INTFPD_DBG, 16, 1)
    FIELD(IR_ENABLE_PERR, CORESW_AFIFS_SLAVE, 15, 1)
    FIELD(IR_ENABLE_PERR, PS_NOC_NCI_AXI1, 14, 1)
    FIELD(IR_ENABLE_PERR, PS_NOC_NCI_AXI0, 13, 1)
    FIELD(IR_ENABLE_PERR, GICSW1_GIC, 12, 1)
    FIELD(IR_ENABLE_PERR, GIC_INTFPD, 11, 1)
    FIELD(IR_ENABLE_PERR, DBG_INTFPD_AXI, 10, 1)
    FIELD(IR_ENABLE_PERR, CCI_NOC_MEM5, 9, 1)
    FIELD(IR_ENABLE_PERR, CCI_NOC_MEM4, 8, 1)
    FIELD(IR_ENABLE_PERR, CCI_NOC_MEM3, 7, 1)
    FIELD(IR_ENABLE_PERR, CCI_NOC_MEM2, 6, 1)
    FIELD(IR_ENABLE_PERR, ACE_ADB400_CCI_DATA, 5, 1)
    FIELD(IR_ENABLE_PERR, ACE_APU_DATA, 4, 1)
    FIELD(IR_ENABLE_PERR, NOC_PS_NCI_AXI0, 3, 1)
    FIELD(IR_ENABLE_PERR, NOC_PS_CCI_AXI0, 2, 1)
    FIELD(IR_ENABLE_PERR, AFIFM2M_INTFPD, 1, 1)
    FIELD(IR_ENABLE_PERR, AFIFM0M_INTFPD, 0, 1)
REG32(IR_DISABLE_PERR, 0x6c)
    FIELD(IR_DISABLE_PERR, INTFPD_CONFIG_APB_APB, 29, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_GP_CCI_APB, 28, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_WDT_APB, 27, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_SMMU_APB, 26, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_MAIN_CCI_APB, 25, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_FPDSLCRSECURE_APB, 24, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_FPDSLCR_APB, 23, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_CLKRTDCTRLF_APB, 22, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_APU_APB, 21, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_SYSMONSAT_APB, 20, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_AFIFM2_APB, 19, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_AFIFM0_APB, 18, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_INTFPDTCUPROG, 17, 1)
    FIELD(IR_DISABLE_PERR, INTFPD_DBG, 16, 1)
    FIELD(IR_DISABLE_PERR, CORESW_AFIFS_SLAVE, 15, 1)
    FIELD(IR_DISABLE_PERR, PS_NOC_NCI_AXI1, 14, 1)
    FIELD(IR_DISABLE_PERR, PS_NOC_NCI_AXI0, 13, 1)
    FIELD(IR_DISABLE_PERR, GICSW1_GIC, 12, 1)
    FIELD(IR_DISABLE_PERR, GIC_INTFPD, 11, 1)
    FIELD(IR_DISABLE_PERR, DBG_INTFPD_AXI, 10, 1)
    FIELD(IR_DISABLE_PERR, CCI_NOC_MEM5, 9, 1)
    FIELD(IR_DISABLE_PERR, CCI_NOC_MEM4, 8, 1)
    FIELD(IR_DISABLE_PERR, CCI_NOC_MEM3, 7, 1)
    FIELD(IR_DISABLE_PERR, CCI_NOC_MEM2, 6, 1)
    FIELD(IR_DISABLE_PERR, ACE_ADB400_CCI_DATA, 5, 1)
    FIELD(IR_DISABLE_PERR, ACE_APU_DATA, 4, 1)
    FIELD(IR_DISABLE_PERR, NOC_PS_NCI_AXI0, 3, 1)
    FIELD(IR_DISABLE_PERR, NOC_PS_CCI_AXI0, 2, 1)
    FIELD(IR_DISABLE_PERR, AFIFM2M_INTFPD, 1, 1)
    FIELD(IR_DISABLE_PERR, AFIFM0M_INTFPD, 0, 1)
REG32(IR_STATUS_PERR1, 0x74)
    FIELD(IR_STATUS_PERR1, FPD_XMPU, 2, 1)
    FIELD(IR_STATUS_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU4, 1, 1)
    FIELD(IR_STATUS_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU1, 0, 1)
REG32(IR_MASK_PERR1, 0x78)
    FIELD(IR_MASK_PERR1, FPD_XMPU, 2, 1)
    FIELD(IR_MASK_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU4, 1, 1)
    FIELD(IR_MASK_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU1, 0, 1)
REG32(IR_ENABLE_PERR1, 0x7c)
    FIELD(IR_ENABLE_PERR1, FPD_XMPU, 2, 1)
    FIELD(IR_ENABLE_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU4, 1, 1)
    FIELD(IR_ENABLE_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU1, 0, 1)
REG32(IR_DISABLE_PERR1, 0x80)
    FIELD(IR_DISABLE_PERR1, FPD_XMPU, 2, 1)
    FIELD(IR_DISABLE_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU4, 1, 1)
    FIELD(IR_DISABLE_PERR1, AXI_INTFPDMAIN_INTFPDSMMUTBU1, 0, 1)
REG32(FPD_PARITY_STATUS_ENTRY_STATUS, 0x90)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, POISON_ENTRY_INTFPDSMMUTBU4, 22, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, MULT_PERR_ENTRY_INTFPDSMMUTBU4, 21, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, SNGL_PERR_ENTRY_INTFPDSMMUTBU4, 20, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, POISON_ENTRY_INTFPDSMMUTBU1, 18, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, MULT_PERR_ENTRY_INTFPDSMMUTBU1, 17, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, SNGL_PERR_ENTRY_INTFPDSMMUTBU1, 16, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, POISON_ENTRY_CCI_MEM5, 14, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, MULT_PERR_ENTRY_CCI_MEM5, 13, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, SNGL_PERR_ENTRY_CCI_MEM5, 12, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, POISON_ENTRY_CCI_MEM4, 10, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, MULT_PERR_ENTRY_CCI_MEM4, 9, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, SNGL_PERR_ENTRY_CCI_MEM4, 8, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, POISON_ENTRY_CCI_MEM3, 6, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, MULT_PERR_ENTRY_CCI_MEM3, 5, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, SNGL_PERR_ENTRY_CCI_MEM3, 4, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, POISON_ENTRY_CCI_MEM2, 2, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, MULT_PERR_ENTRY_CCI_MEM2, 1, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS, SNGL_PERR_ENTRY_CCI_MEM2, 0, 1)
REG32(FPD_PARITY_STATUS_ENTRY_STATUS_1, 0x94)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, POISON_ENTRY_PS_NOC_NCI_AXI1, 14, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, MULT_PERR_ENTRY_PS_NOC_NCI_AXI1,
          13, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, SNGL_PERR_ENTRY_PS_NOC_NCI_AXI1,
          12, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, POISON_ENTRY_PS_NOC_NCI_AXI0, 10, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, MULT_PERR_ENTRY_PS_NOC_NCI_AXI0,
          9, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, SNGL_PERR_ENTRY_PS_NOC_NCI_AXI0,
          8, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, POISON_ENTRY_NOC_PS_NCI_AXI0,
          6, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, MULT_PERR_ENTRY_NOC_PS_NCI_AXI0,
          5, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, SNGL_PERR_ENTRY_NOC_PS_NCI_AXI0,
          4, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, POISON_ENTRY_NOC_PS_CCI_AXI0, 2, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, MULT_PERR_ENTRY_NOC_PS_CCI_AXI0,
          1, 1)
    FIELD(FPD_PARITY_STATUS_ENTRY_STATUS_1, SNGL_PERR_ENTRY_NOC_PS_CCI_AXI0,
          0, 1)
REG32(FPD_PARITY_STATUS_EXIT_STATUS, 0x98)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, POISON_EXIT_INTFPDSMMUTBU4, 22, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, MULT_PERR_EXIT_INTFPDSMMUTBU4, 21, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, SNGL_PERR_EXIT_INTFPDSMMUTBU4, 20, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, POISON_EXIT_INTFPDSMMUTBU1, 18, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, MULT_PERR_EXIT_INTFPDSMMUTBU1, 17, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, SNGL_PERR_EXIT_INTFPDSMMUTBU1, 16, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, POISON_EXIT_CCI_MEM5, 14, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, MULT_PERR_EXIT_CCI_MEM5, 13, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, SNGL_PERR_EXIT_CCI_MEM5, 12, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, POISON_EXIT_CCI_MEM4, 10, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, MULT_PERR_EXIT_CCI_MEM4, 9, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, SNGL_PERR_EXIT_CCI_MEM4, 8, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, POISON_EXIT_CCI_MEM3, 6, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, MULT_PERR_EXIT_CCI_MEM3, 5, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, SNGL_PERR_EXIT_CCI_MEM3, 4, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, POISON_EXIT_CCI_MEM2, 2, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, MULT_PERR_EXIT_CCI_MEM2, 1, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS, SNGL_PERR_EXIT_CCI_MEM2, 0, 1)
REG32(FPD_PARITY_STATUS_EXIT_STATUS_1, 0x9c)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, POISON_EXIT_PS_NOC_NCI_AXI1, 14, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, MULT_PERR_EXIT_PS_NOC_NCI_AXI1,
          13, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, SNGL_PERR_EXIT_PS_NOC_NCI_AXI1,
          12, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, POISON_EXIT_PS_NOC_NCI_AXI0, 10, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, MULT_PERR_EXIT_PS_NOC_NCI_AXI0, 9, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, SNGL_PERR_EXIT_PS_NOC_NCI_AXI0, 8, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, POISON_EXIT_NOC_PS_NCI_AXI0, 6, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, MULT_PERR_EXIT_NOC_PS_NCI_AXI0, 5, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, SNGL_PERR_EXIT_NOC_PS_NCI_AXI0, 4, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, POISON_EXIT_NOC_PS_CCI_AXI0, 2, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, MULT_PERR_EXIT_NOC_PS_CCI_AXI0, 1, 1)
    FIELD(FPD_PARITY_STATUS_EXIT_STATUS_1, SNGL_PERR_EXIT_NOC_PS_CCI_AXI0, 0, 1)

#define INT_FPD_REGS_R_MAX (R_FPD_PARITY_STATUS_EXIT_STATUS_1 + 1)

typedef struct INT_FPD_REGS {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir_perr1;
    qemu_irq irq_ir;
    qemu_irq irq_ir_perr;

    xlnx_serbs_if *AFIFSSerbs;
    int tov;
    uint32_t regs[INT_FPD_REGS_R_MAX];
    RegisterInfo regs_info[INT_FPD_REGS_R_MAX];
} INT_FPD_REGS;

static void ir_perr1_update_irq(INT_FPD_REGS *s)
{
    bool pending = s->regs[R_IR_STATUS_PERR1] & ~s->regs[R_IR_MASK_PERR1];
    qemu_set_irq(s->irq_ir_perr1, pending);
}

static void ir_status_perr1_postw(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    ir_perr1_update_irq(s);
}

static uint64_t ir_enable_perr1_prew(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK_PERR1] &= ~val;
    ir_perr1_update_irq(s);
    return 0;
}

static uint64_t ir_disable_perr1_prew(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK_PERR1] |= val;
    ir_perr1_update_irq(s);
    return 0;
}

static void ir_update_irq(INT_FPD_REGS *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    bool afifs_timeout = ARRAY_FIELD_EX32(s->regs, IR_STATUS,
                         CORESW_AFIFS_SLAVE_MAINTIMEOUT);

    if (!afifs_timeout && s->AFIFSSerbs) {
        xlnx_serbs_if_timeout_set(s->AFIFSSerbs, AFIFS_SERBS_ID, false);
    }
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static void ir_perr_update_irq(INT_FPD_REGS *s)
{
    bool pending = s->regs[R_IR_STATUS_PERR] & ~s->regs[R_IR_MASK_PERR];
    qemu_set_irq(s->irq_ir_perr, pending);
}

static void ir_status_perr_postw(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    ir_perr_update_irq(s);
}

static uint64_t ir_enable_perr_prew(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK_PERR] &= ~val;
    ir_perr_update_irq(s);
    return 0;
}

static uint64_t ir_disable_perr_prew(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK_PERR] |= val;
    ir_perr_update_irq(s);
    return 0;
}

static void coresw_afifs_slave_postw(RegisterInfo *reg, uint64_t val64)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(reg->opaque);

    if (s->AFIFSSerbs) {
        xlnx_serbs_if_timer_config(s->AFIFSSerbs, AFIFS_SERBS_ID, s->tov,
              ARRAY_FIELD_EX32(s->regs, CORESW_AFIFS_SLAVE, MAINEXTEN));
    }
}

static const RegisterAccessInfo int_fpd_regs_regs_info[] = {
    {   .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xfff0e000,
        .ro = 0xff80e000,
        .w1c = 0x7f1fff,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0xf1fff,
        .rsvd = 0xfff0e000,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xfff0e000,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xfff0e000,
        .pre_write = ir_disable_prew,
    },{ .name = "AFIFM_APB",  .addr = A_AFIFM_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "APU_APB",  .addr = A_APU_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "MISC_APB",  .addr = A_MISC_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "FPD_SLCR_APB",  .addr = A_FPD_SLCR_APB,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "CORESW_AFIFS_SLAVE",  .addr = A_CORESW_AFIFS_SLAVE,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
        .post_write = coresw_afifs_slave_postw,
    },{ .name = "GICSW1_GIC",  .addr = A_GICSW1_GIC,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PS_NOC_NCI_AXI0",  .addr = A_PS_NOC_NCI_AXI0,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "PS_NOC_NCI_AXI1",  .addr = A_PS_NOC_NCI_AXI1,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "INTFPD_MAIN_CCI",  .addr = A_INTFPD_MAIN_CCI,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "INTFPD_INTFPDTCUPROG",  .addr = A_INTFPD_INTFPDTCUPROG,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "INTFPD_SYSMONSAT",  .addr = A_INTFPD_SYSMONSAT,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "INTFPD_DBG",  .addr = A_INTFPD_DBG,
        .reset = 0x16,
        .rsvd = 0xffffffe0,
        .ro = 0x6,
    },{ .name = "IR_STATUS_PERR",  .addr = A_IR_STATUS_PERR,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
        .w1c = 0x3fffffff,
        .post_write = ir_status_perr_postw,
    },{ .name = "IR_MASK_PERR",  .addr = A_IR_MASK_PERR,
        .reset = 0x3fffffff,
        .rsvd = 0xc0000000,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE_PERR",  .addr = A_IR_ENABLE_PERR,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
        .pre_write = ir_enable_perr_prew,
    },{ .name = "IR_DISABLE_PERR",  .addr = A_IR_DISABLE_PERR,
        .rsvd = 0xc0000000,
        .ro = 0xc0000000,
        .pre_write = ir_disable_perr_prew,
    },{ .name = "IR_STATUS_PERR1",  .addr = A_IR_STATUS_PERR1,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
        .w1c = 0x7,
        .post_write = ir_status_perr1_postw,
    },{ .name = "IR_MASK_PERR1",  .addr = A_IR_MASK_PERR1,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE_PERR1",  .addr = A_IR_ENABLE_PERR1,
        .rsvd = 0xfffffff8,
        .pre_write = ir_enable_perr1_prew,
    },{ .name = "IR_DISABLE_PERR1",  .addr = A_IR_DISABLE_PERR1,
        .rsvd = 0xfffffff8,
        .pre_write = ir_disable_perr1_prew,
    },{ .name = "FPD_PARITY_STATUS_ENTRY_STATUS",
        .addr = A_FPD_PARITY_STATUS_ENTRY_STATUS,
        .rsvd = 0xff888888,
        .ro = 0xff888888,
        .w1c = 0x777777,
    },{ .name = "FPD_PARITY_STATUS_ENTRY_STATUS_1",
        .addr = A_FPD_PARITY_STATUS_ENTRY_STATUS_1,
        .rsvd = 0xffff8888,
        .ro = 0xffff8000,
        .w1c = 0x7fff,
    },{ .name = "FPD_PARITY_STATUS_EXIT_STATUS",
        .addr = A_FPD_PARITY_STATUS_EXIT_STATUS,
        .rsvd = 0xff888888,
        .ro = 0xff888888,
        .w1c = 0x777777,
    },{ .name = "FPD_PARITY_STATUS_EXIT_STATUS_1",
        .addr = A_FPD_PARITY_STATUS_EXIT_STATUS_1,
        .rsvd = 0xffff8888,
        .ro = 0xffff8888,
        .w1c = 0x7777,
    }
};

static void int_fpd_regs_reset_enter(Object *obj, ResetType type)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void int_fpd_regs_reset_hold(Object *obj)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(obj);

    ir_perr1_update_irq(s);
    ir_update_irq(s);
    ir_perr_update_irq(s);
}

static void intfpd_afifs_timeout_notify(xlnx_serbs_if *sif, int id, bool level)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(sif);

    switch (id) {
    case AFIFS_SERBS_ID:
        ARRAY_FIELD_DP32(s->regs, IR_STATUS,
                     CORESW_AFIFS_SLAVE_MAINTIMEOUT, level);
        break;
    default:
         g_assert_not_reached();
    };

    ir_update_irq(s);
}

static const MemoryRegionOps int_fpd_regs_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void int_fpd_regs_realize(DeviceState *dev, Error **errp)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(dev);

    if (s->AFIFSSerbs) {
        xlnx_serbs_if_timer_config(s->AFIFSSerbs, AFIFS_SERBS_ID, s->tov,
                                   false);
    }
}

static void int_fpd_regs_init(Object *obj)
{
    INT_FPD_REGS *s = XILINX_INT_FPD_REGS(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_INT_FPD_REGS,
                       INT_FPD_REGS_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), int_fpd_regs_regs_info,
                              ARRAY_SIZE(int_fpd_regs_regs_info),
                              s->regs_info, s->regs,
                              &int_fpd_regs_ops,
                              XILINX_INT_FPD_REGS_ERR_DEBUG,
                              INT_FPD_REGS_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir);
    sysbus_init_irq(sbd, &s->irq_ir_perr1);
    sysbus_init_irq(sbd, &s->irq_ir_perr);
    object_property_add_link(obj, "afifs-serbs", TYPE_XLNX_SERBS_IF,
                             (Object **)&s->AFIFSSerbs,
                             qdev_prop_allow_set_link,
                             OBJ_PROP_LINK_STRONG);
}

static const VMStateDescription vmstate_int_fpd_regs = {
    .name = TYPE_XILINX_INT_FPD_REGS,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, INT_FPD_REGS, INT_FPD_REGS_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static Property intfpd_properties[] = {
    DEFINE_PROP_INT32("timeout", INT_FPD_REGS, tov, 0),
    DEFINE_PROP_END_OF_LIST()
};

static void int_fpd_regs_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);
    xlnx_serbs_if_class *sc = XLNX_SERBS_IF_CLASS(klass);

    dc->realize = int_fpd_regs_realize;
    dc->vmsd = &vmstate_int_fpd_regs;
    rc->phases.enter = int_fpd_regs_reset_enter;
    rc->phases.hold = int_fpd_regs_reset_hold;
    device_class_set_props(dc, intfpd_properties);
    sc->timeout_set = intfpd_afifs_timeout_notify;
}

static const TypeInfo int_fpd_regs_info = {
    .name          = TYPE_XILINX_INT_FPD_REGS,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(INT_FPD_REGS),
    .class_init    = int_fpd_regs_class_init,
    .instance_init = int_fpd_regs_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_XLNX_SERBS_IF },
        { },
    },
};

static void int_fpd_regs_register_types(void)
{
    type_register_static(&int_fpd_regs_info);
}

type_init(int_fpd_regs_register_types)
