/*
 * QEMU model of the NOC_NMU Noc Master Unit
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-03-20.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_NOC_NMU_ERR_DEBUG
#define XILINX_NOC_NMU_ERR_DEBUG 0
#endif

#define TYPE_XILINX_NOC_NMU "xlnx.noc-nmu"

#define XILINX_NOC_NMU(obj) \
     OBJECT_CHECK(NOC_NMU, (obj), TYPE_XILINX_NOC_NMU)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE_NPP, 3, 1)
    FIELD(REG_PCSR_MASK, ODISABLE_AXI, 2, 1)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE_NPP, 3, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE_AXI, 2, 1)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_ISR, 0x30)
    FIELD(REG_ISR, MEM_CLEAR, 28, 1)
    FIELD(REG_ISR, SCAN_CLEAR, 27, 1)
    FIELD(REG_ISR, DATA_PAR_WR, 26, 1)
    FIELD(REG_ISR, ADDR_PAR_WR, 25, 1)
    FIELD(REG_ISR, TIMEOUT_WR, 24, 1)
    FIELD(REG_ISR, ECC_1BIT_WR, 23, 1)
    FIELD(REG_ISR, ECC_2BIT_WR, 22, 1)
    FIELD(REG_ISR, NPP_IN_WR, 21, 1)
    FIELD(REG_ISR, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_ISR, ADDR_MAP_WR, 19, 1)
    FIELD(REG_ISR, XLX_INFOS_WR, 18, 1)
    FIELD(REG_ISR, XLX_RULES_WR, 17, 1)
    FIELD(REG_ISR, AXI_RULES_WR, 16, 1)
    FIELD(REG_ISR, NPP_RPOISON, 15, 1)
    FIELD(REG_ISR, VC_CREDIT_TX, 14, 1)
    FIELD(REG_ISR, VC_CREDIT_RX, 13, 1)
    FIELD(REG_ISR, NPP_UNEXP, 12, 1)
    FIELD(REG_ISR, RROB_CHK_RD, 11, 1)
    FIELD(REG_ISR, DATA_PAR_RD, 10, 1)
    FIELD(REG_ISR, ADDR_PAR_RD, 9, 1)
    FIELD(REG_ISR, TIMEOUT_RD, 8, 1)
    FIELD(REG_ISR, ECC_1BIT_RD, 7, 1)
    FIELD(REG_ISR, ECC_2BIT_RD, 6, 1)
    FIELD(REG_ISR, NPP_IN_RD, 5, 1)
    FIELD(REG_ISR, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_ISR, ADDR_MAP_RD, 3, 1)
    FIELD(REG_ISR, XLX_INFOS_RD, 2, 1)
    FIELD(REG_ISR, XLX_RULES_RD, 1, 1)
    FIELD(REG_ISR, AXI_RULES_RD, 0, 1)
REG32(REG_ITR, 0x34)
    FIELD(REG_ITR, MEM_CLEAR, 28, 1)
    FIELD(REG_ITR, SCAN_CLEAR, 27, 1)
    FIELD(REG_ITR, DATA_PAR_WR, 26, 1)
    FIELD(REG_ITR, ADDR_PAR_WR, 25, 1)
    FIELD(REG_ITR, TIMEOUT_WR, 24, 1)
    FIELD(REG_ITR, ECC_1BIT_WR, 23, 1)
    FIELD(REG_ITR, ECC_2BIT_WR, 22, 1)
    FIELD(REG_ITR, NPP_IN_WR, 21, 1)
    FIELD(REG_ITR, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_ITR, ADDR_MAP_WR, 19, 1)
    FIELD(REG_ITR, XLX_INFOS_WR, 18, 1)
    FIELD(REG_ITR, XLX_RULES_WR, 17, 1)
    FIELD(REG_ITR, AXI_RULES_WR, 16, 1)
    FIELD(REG_ITR, NPP_RPOISON, 15, 1)
    FIELD(REG_ITR, VC_CREDIT_TX, 14, 1)
    FIELD(REG_ITR, VC_CREDIT_RX, 13, 1)
    FIELD(REG_ITR, NPP_UNEXP, 12, 1)
    FIELD(REG_ITR, RROB_CHK_RD, 11, 1)
    FIELD(REG_ITR, DATA_PAR_RD, 10, 1)
    FIELD(REG_ITR, ADDR_PAR_RD, 9, 1)
    FIELD(REG_ITR, TIMEOUT_RD, 8, 1)
    FIELD(REG_ITR, ECC_1BIT_RD, 7, 1)
    FIELD(REG_ITR, ECC_2BIT_RD, 6, 1)
    FIELD(REG_ITR, NPP_IN_RD, 5, 1)
    FIELD(REG_ITR, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_ITR, ADDR_MAP_RD, 3, 1)
    FIELD(REG_ITR, XLX_INFOS_RD, 2, 1)
    FIELD(REG_ITR, XLX_RULES_RD, 1, 1)
    FIELD(REG_ITR, AXI_RULES_RD, 0, 1)
REG32(REG_IMR0, 0x38)
    FIELD(REG_IMR0, MEM_CLEAR, 28, 1)
    FIELD(REG_IMR0, SCAN_CLEAR, 27, 1)
    FIELD(REG_IMR0, DATA_PAR_WR, 26, 1)
    FIELD(REG_IMR0, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IMR0, TIMEOUT_WR, 24, 1)
    FIELD(REG_IMR0, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IMR0, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IMR0, NPP_IN_WR, 21, 1)
    FIELD(REG_IMR0, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IMR0, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IMR0, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IMR0, XLX_RULES_WR, 17, 1)
    FIELD(REG_IMR0, AXI_RULES_WR, 16, 1)
    FIELD(REG_IMR0, NPP_RPOISON, 15, 1)
    FIELD(REG_IMR0, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IMR0, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IMR0, NPP_UNEXP, 12, 1)
    FIELD(REG_IMR0, RROB_CHK_RD, 11, 1)
    FIELD(REG_IMR0, DATA_PAR_RD, 10, 1)
    FIELD(REG_IMR0, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IMR0, TIMEOUT_RD, 8, 1)
    FIELD(REG_IMR0, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IMR0, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IMR0, NPP_IN_RD, 5, 1)
    FIELD(REG_IMR0, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IMR0, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IMR0, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR0, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR0, AXI_RULES_RD, 0, 1)
REG32(REG_IER0, 0x3c)
    FIELD(REG_IER0, MEM_CLEAR, 28, 1)
    FIELD(REG_IER0, SCAN_CLEAR, 27, 1)
    FIELD(REG_IER0, DATA_PAR_WR, 26, 1)
    FIELD(REG_IER0, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IER0, TIMEOUT_WR, 24, 1)
    FIELD(REG_IER0, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IER0, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IER0, NPP_IN_WR, 21, 1)
    FIELD(REG_IER0, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IER0, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IER0, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IER0, XLX_RULES_WR, 17, 1)
    FIELD(REG_IER0, AXI_RULES_WR, 16, 1)
    FIELD(REG_IER0, NPP_RPOISON, 15, 1)
    FIELD(REG_IER0, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IER0, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IER0, NPP_UNEXP, 12, 1)
    FIELD(REG_IER0, RROB_CHK_RD, 11, 1)
    FIELD(REG_IER0, DATA_PAR_RD, 10, 1)
    FIELD(REG_IER0, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IER0, TIMEOUT_RD, 8, 1)
    FIELD(REG_IER0, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IER0, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IER0, NPP_IN_RD, 5, 1)
    FIELD(REG_IER0, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IER0, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IER0, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER0, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER0, AXI_RULES_RD, 0, 1)
REG32(REG_IDR0, 0x40)
    FIELD(REG_IDR0, MEM_CLEAR, 28, 1)
    FIELD(REG_IDR0, SCAN_CLEAR, 27, 1)
    FIELD(REG_IDR0, DATA_PAR_WR, 26, 1)
    FIELD(REG_IDR0, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IDR0, TIMEOUT_WR, 24, 1)
    FIELD(REG_IDR0, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IDR0, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IDR0, NPP_IN_WR, 21, 1)
    FIELD(REG_IDR0, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IDR0, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IDR0, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IDR0, XLX_RULES_WR, 17, 1)
    FIELD(REG_IDR0, AXI_RULES_WR, 16, 1)
    FIELD(REG_IDR0, NPP_RPOISON, 15, 1)
    FIELD(REG_IDR0, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IDR0, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IDR0, NPP_UNEXP, 12, 1)
    FIELD(REG_IDR0, RROB_CHK_RD, 11, 1)
    FIELD(REG_IDR0, DATA_PAR_RD, 10, 1)
    FIELD(REG_IDR0, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IDR0, TIMEOUT_RD, 8, 1)
    FIELD(REG_IDR0, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IDR0, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IDR0, NPP_IN_RD, 5, 1)
    FIELD(REG_IDR0, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IDR0, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IDR0, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR0, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR0, AXI_RULES_RD, 0, 1)
REG32(REG_IMR1, 0x44)
    FIELD(REG_IMR1, MEM_CLEAR, 28, 1)
    FIELD(REG_IMR1, SCAN_CLEAR, 27, 1)
    FIELD(REG_IMR1, DATA_PAR_WR, 26, 1)
    FIELD(REG_IMR1, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IMR1, TIMEOUT_WR, 24, 1)
    FIELD(REG_IMR1, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IMR1, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IMR1, NPP_IN_WR, 21, 1)
    FIELD(REG_IMR1, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IMR1, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IMR1, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IMR1, XLX_RULES_WR, 17, 1)
    FIELD(REG_IMR1, AXI_RULES_WR, 16, 1)
    FIELD(REG_IMR1, NPP_RPOISON, 15, 1)
    FIELD(REG_IMR1, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IMR1, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IMR1, NPP_UNEXP, 12, 1)
    FIELD(REG_IMR1, RROB_CHK_RD, 11, 1)
    FIELD(REG_IMR1, DATA_PAR_RD, 10, 1)
    FIELD(REG_IMR1, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IMR1, TIMEOUT_RD, 8, 1)
    FIELD(REG_IMR1, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IMR1, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IMR1, NPP_IN_RD, 5, 1)
    FIELD(REG_IMR1, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IMR1, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IMR1, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR1, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR1, AXI_RULES_RD, 0, 1)
REG32(REG_IER1, 0x48)
    FIELD(REG_IER1, MEM_CLEAR, 28, 1)
    FIELD(REG_IER1, SCAN_CLEAR, 27, 1)
    FIELD(REG_IER1, DATA_PAR_WR, 26, 1)
    FIELD(REG_IER1, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IER1, TIMEOUT_WR, 24, 1)
    FIELD(REG_IER1, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IER1, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IER1, NPP_IN_WR, 21, 1)
    FIELD(REG_IER1, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IER1, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IER1, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IER1, XLX_RULES_WR, 17, 1)
    FIELD(REG_IER1, AXI_RULES_WR, 16, 1)
    FIELD(REG_IER1, NPP_RPOISON, 15, 1)
    FIELD(REG_IER1, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IER1, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IER1, NPP_UNEXP, 12, 1)
    FIELD(REG_IER1, RROB_CHK_RD, 11, 1)
    FIELD(REG_IER1, DATA_PAR_RD, 10, 1)
    FIELD(REG_IER1, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IER1, TIMEOUT_RD, 8, 1)
    FIELD(REG_IER1, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IER1, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IER1, NPP_IN_RD, 5, 1)
    FIELD(REG_IER1, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IER1, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IER1, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER1, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER1, AXI_RULES_RD, 0, 1)
REG32(REG_IDR1, 0x4c)
    FIELD(REG_IDR1, MEM_CLEAR, 28, 1)
    FIELD(REG_IDR1, SCAN_CLEAR, 27, 1)
    FIELD(REG_IDR1, DATA_PAR_WR, 26, 1)
    FIELD(REG_IDR1, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IDR1, TIMEOUT_WR, 24, 1)
    FIELD(REG_IDR1, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IDR1, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IDR1, NPP_IN_WR, 21, 1)
    FIELD(REG_IDR1, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IDR1, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IDR1, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IDR1, XLX_RULES_WR, 17, 1)
    FIELD(REG_IDR1, AXI_RULES_WR, 16, 1)
    FIELD(REG_IDR1, NPP_RPOISON, 15, 1)
    FIELD(REG_IDR1, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IDR1, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IDR1, NPP_UNEXP, 12, 1)
    FIELD(REG_IDR1, RROB_CHK_RD, 11, 1)
    FIELD(REG_IDR1, DATA_PAR_RD, 10, 1)
    FIELD(REG_IDR1, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IDR1, TIMEOUT_RD, 8, 1)
    FIELD(REG_IDR1, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IDR1, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IDR1, NPP_IN_RD, 5, 1)
    FIELD(REG_IDR1, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IDR1, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IDR1, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR1, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR1, AXI_RULES_RD, 0, 1)
REG32(REG_IMR2, 0x50)
    FIELD(REG_IMR2, MEM_CLEAR, 28, 1)
    FIELD(REG_IMR2, SCAN_CLEAR, 27, 1)
    FIELD(REG_IMR2, DATA_PAR_WR, 26, 1)
    FIELD(REG_IMR2, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IMR2, TIMEOUT_WR, 24, 1)
    FIELD(REG_IMR2, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IMR2, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IMR2, NPP_IN_WR, 21, 1)
    FIELD(REG_IMR2, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IMR2, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IMR2, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IMR2, XLX_RULES_WR, 17, 1)
    FIELD(REG_IMR2, AXI_RULES_WR, 16, 1)
    FIELD(REG_IMR2, NPP_RPOISON, 15, 1)
    FIELD(REG_IMR2, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IMR2, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IMR2, NPP_UNEXP, 12, 1)
    FIELD(REG_IMR2, RROB_CHK_RD, 11, 1)
    FIELD(REG_IMR2, DATA_PAR_RD, 10, 1)
    FIELD(REG_IMR2, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IMR2, TIMEOUT_RD, 8, 1)
    FIELD(REG_IMR2, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IMR2, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IMR2, NPP_IN_RD, 5, 1)
    FIELD(REG_IMR2, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IMR2, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IMR2, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR2, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR2, AXI_RULES_RD, 0, 1)
REG32(REG_IER2, 0x54)
    FIELD(REG_IER2, MEM_CLEAR, 28, 1)
    FIELD(REG_IER2, SCAN_CLEAR, 27, 1)
    FIELD(REG_IER2, DATA_PAR_WR, 26, 1)
    FIELD(REG_IER2, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IER2, TIMEOUT_WR, 24, 1)
    FIELD(REG_IER2, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IER2, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IER2, NPP_IN_WR, 21, 1)
    FIELD(REG_IER2, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IER2, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IER2, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IER2, XLX_RULES_WR, 17, 1)
    FIELD(REG_IER2, AXI_RULES_WR, 16, 1)
    FIELD(REG_IER2, NPP_RPOISON, 15, 1)
    FIELD(REG_IER2, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IER2, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IER2, NPP_UNEXP, 12, 1)
    FIELD(REG_IER2, RROB_CHK_RD, 11, 1)
    FIELD(REG_IER2, DATA_PAR_RD, 10, 1)
    FIELD(REG_IER2, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IER2, TIMEOUT_RD, 8, 1)
    FIELD(REG_IER2, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IER2, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IER2, NPP_IN_RD, 5, 1)
    FIELD(REG_IER2, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IER2, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IER2, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER2, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER2, AXI_RULES_RD, 0, 1)
REG32(REG_IDR2, 0x58)
    FIELD(REG_IDR2, MEM_CLEAR, 28, 1)
    FIELD(REG_IDR2, SCAN_CLEAR, 27, 1)
    FIELD(REG_IDR2, DATA_PAR_WR, 26, 1)
    FIELD(REG_IDR2, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IDR2, TIMEOUT_WR, 24, 1)
    FIELD(REG_IDR2, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IDR2, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IDR2, NPP_IN_WR, 21, 1)
    FIELD(REG_IDR2, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IDR2, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IDR2, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IDR2, XLX_RULES_WR, 17, 1)
    FIELD(REG_IDR2, AXI_RULES_WR, 16, 1)
    FIELD(REG_IDR2, NPP_RPOISON, 15, 1)
    FIELD(REG_IDR2, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IDR2, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IDR2, NPP_UNEXP, 12, 1)
    FIELD(REG_IDR2, RROB_CHK_RD, 11, 1)
    FIELD(REG_IDR2, DATA_PAR_RD, 10, 1)
    FIELD(REG_IDR2, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IDR2, TIMEOUT_RD, 8, 1)
    FIELD(REG_IDR2, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IDR2, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IDR2, NPP_IN_RD, 5, 1)
    FIELD(REG_IDR2, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IDR2, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IDR2, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR2, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR2, AXI_RULES_RD, 0, 1)
REG32(REG_IMR3, 0x5c)
    FIELD(REG_IMR3, MEM_CLEAR, 28, 1)
    FIELD(REG_IMR3, SCAN_CLEAR, 27, 1)
    FIELD(REG_IMR3, DATA_PAR_WR, 26, 1)
    FIELD(REG_IMR3, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IMR3, TIMEOUT_WR, 24, 1)
    FIELD(REG_IMR3, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IMR3, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IMR3, NPP_IN_WR, 21, 1)
    FIELD(REG_IMR3, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IMR3, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IMR3, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IMR3, XLX_RULES_WR, 17, 1)
    FIELD(REG_IMR3, AXI_RULES_WR, 16, 1)
    FIELD(REG_IMR3, NPP_RPOISON, 15, 1)
    FIELD(REG_IMR3, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IMR3, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IMR3, NPP_UNEXP, 12, 1)
    FIELD(REG_IMR3, RROB_CHK_RD, 11, 1)
    FIELD(REG_IMR3, DATA_PAR_RD, 10, 1)
    FIELD(REG_IMR3, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IMR3, TIMEOUT_RD, 8, 1)
    FIELD(REG_IMR3, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IMR3, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IMR3, NPP_IN_RD, 5, 1)
    FIELD(REG_IMR3, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IMR3, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IMR3, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IMR3, XLX_RULES_RD, 1, 1)
    FIELD(REG_IMR3, AXI_RULES_RD, 0, 1)
REG32(REG_IER3, 0x60)
    FIELD(REG_IER3, MEM_CLEAR, 28, 1)
    FIELD(REG_IER3, SCAN_CLEAR, 27, 1)
    FIELD(REG_IER3, DATA_PAR_WR, 26, 1)
    FIELD(REG_IER3, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IER3, TIMEOUT_WR, 24, 1)
    FIELD(REG_IER3, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IER3, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IER3, NPP_IN_WR, 21, 1)
    FIELD(REG_IER3, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IER3, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IER3, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IER3, XLX_RULES_WR, 17, 1)
    FIELD(REG_IER3, AXI_RULES_WR, 16, 1)
    FIELD(REG_IER3, NPP_RPOISON, 15, 1)
    FIELD(REG_IER3, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IER3, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IER3, NPP_UNEXP, 12, 1)
    FIELD(REG_IER3, RROB_CHK_RD, 11, 1)
    FIELD(REG_IER3, DATA_PAR_RD, 10, 1)
    FIELD(REG_IER3, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IER3, TIMEOUT_RD, 8, 1)
    FIELD(REG_IER3, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IER3, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IER3, NPP_IN_RD, 5, 1)
    FIELD(REG_IER3, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IER3, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IER3, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IER3, XLX_RULES_RD, 1, 1)
    FIELD(REG_IER3, AXI_RULES_RD, 0, 1)
REG32(REG_IDR3, 0x64)
    FIELD(REG_IDR3, MEM_CLEAR, 28, 1)
    FIELD(REG_IDR3, SCAN_CLEAR, 27, 1)
    FIELD(REG_IDR3, DATA_PAR_WR, 26, 1)
    FIELD(REG_IDR3, ADDR_PAR_WR, 25, 1)
    FIELD(REG_IDR3, TIMEOUT_WR, 24, 1)
    FIELD(REG_IDR3, ECC_1BIT_WR, 23, 1)
    FIELD(REG_IDR3, ECC_2BIT_WR, 22, 1)
    FIELD(REG_IDR3, NPP_IN_WR, 21, 1)
    FIELD(REG_IDR3, ADDR_REMAP_WR, 20, 1)
    FIELD(REG_IDR3, ADDR_MAP_WR, 19, 1)
    FIELD(REG_IDR3, XLX_INFOS_WR, 18, 1)
    FIELD(REG_IDR3, XLX_RULES_WR, 17, 1)
    FIELD(REG_IDR3, AXI_RULES_WR, 16, 1)
    FIELD(REG_IDR3, NPP_RPOISON, 15, 1)
    FIELD(REG_IDR3, VC_CREDIT_TX, 14, 1)
    FIELD(REG_IDR3, VC_CREDIT_RX, 13, 1)
    FIELD(REG_IDR3, NPP_UNEXP, 12, 1)
    FIELD(REG_IDR3, RROB_CHK_RD, 11, 1)
    FIELD(REG_IDR3, DATA_PAR_RD, 10, 1)
    FIELD(REG_IDR3, ADDR_PAR_RD, 9, 1)
    FIELD(REG_IDR3, TIMEOUT_RD, 8, 1)
    FIELD(REG_IDR3, ECC_1BIT_RD, 7, 1)
    FIELD(REG_IDR3, ECC_2BIT_RD, 6, 1)
    FIELD(REG_IDR3, NPP_IN_RD, 5, 1)
    FIELD(REG_IDR3, ADDR_REMAP_RD, 4, 1)
    FIELD(REG_IDR3, ADDR_MAP_RD, 3, 1)
    FIELD(REG_IDR3, XLX_INFOS_RD, 2, 1)
    FIELD(REG_IDR3, XLX_RULES_RD, 1, 1)
    FIELD(REG_IDR3, AXI_RULES_RD, 0, 1)
REG32(REG_IOR, 0x68)
    FIELD(REG_IOR, OFFSET, 0, 5)
REG32(REG_ADDR_MADDR0, 0x1c0)
REG32(REG_ADDR_MADDR1, 0x1c4)
REG32(REG_ADDR_MADDR2, 0x1c8)
REG32(REG_ADDR_MADDR3, 0x1cc)
REG32(REG_ADDR_MADDR4, 0x1d0)
REG32(REG_ADDR_MADDR5, 0x1d4)
REG32(REG_ADDR_MADDR6, 0x1d8)
REG32(REG_ADDR_MADDR7, 0x1dc)
REG32(REG_ADDR_MADDR8, 0x1e0)
REG32(REG_ADDR_MADDR9, 0x1e4)
REG32(REG_ADDR_MADDR10, 0x1e8)
REG32(REG_ADDR_MADDR11, 0x1ec)
REG32(REG_ADDR_MADDR12, 0x1f0)
REG32(REG_ADDR_MADDR13, 0x1f4)
REG32(REG_ADDR_MADDR14, 0x1f8)
REG32(REG_ADDR_MADDR15, 0x1fc)
REG32(REG_ADDR_MASK0, 0x200)
REG32(REG_ADDR_MASK1, 0x204)
REG32(REG_ADDR_MASK2, 0x208)
REG32(REG_ADDR_MASK3, 0x20c)
REG32(REG_ADDR_MASK4, 0x210)
REG32(REG_ADDR_MASK5, 0x214)
REG32(REG_ADDR_MASK6, 0x218)
REG32(REG_ADDR_MASK7, 0x21c)
REG32(REG_ADDR_MASK8, 0x220)
REG32(REG_ADDR_MASK9, 0x224)
REG32(REG_ADDR_MASK10, 0x228)
REG32(REG_ADDR_MASK11, 0x22c)
REG32(REG_ADDR_MASK12, 0x230)
REG32(REG_ADDR_MASK13, 0x234)
REG32(REG_ADDR_MASK14, 0x238)
REG32(REG_ADDR_MASK15, 0x23c)
REG32(REG_ADDR_RPADDR0, 0x240)
REG32(REG_ADDR_RPADDR1, 0x244)
REG32(REG_ADDR_RPADDR2, 0x248)
REG32(REG_ADDR_RPADDR3, 0x24c)
REG32(REG_ADDR_RPADDR4, 0x250)
REG32(REG_ADDR_RPADDR5, 0x254)
REG32(REG_ADDR_RPADDR6, 0x258)
REG32(REG_ADDR_RPADDR7, 0x25c)
REG32(REG_ADDR_RPADDR8, 0x260)
REG32(REG_ADDR_RPADDR9, 0x264)
REG32(REG_ADDR_RPADDR10, 0x268)
REG32(REG_ADDR_RPADDR11, 0x26c)
REG32(REG_ADDR_RPADDR12, 0x270)
REG32(REG_ADDR_RPADDR13, 0x274)
REG32(REG_ADDR_RPADDR14, 0x278)
REG32(REG_ADDR_RPADDR15, 0x27c)
REG32(REG_ADDR_DST0, 0x280)
    FIELD(REG_ADDR_DST0, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST0, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST0, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST1, 0x284)
    FIELD(REG_ADDR_DST1, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST1, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST1, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST2, 0x288)
    FIELD(REG_ADDR_DST2, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST2, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST2, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST3, 0x28c)
    FIELD(REG_ADDR_DST3, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST3, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST3, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST4, 0x290)
    FIELD(REG_ADDR_DST4, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST4, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST4, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST5, 0x294)
    FIELD(REG_ADDR_DST5, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST5, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST5, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST6, 0x298)
    FIELD(REG_ADDR_DST6, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST6, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST6, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST7, 0x29c)
    FIELD(REG_ADDR_DST7, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST7, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST7, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST8, 0x2a0)
    FIELD(REG_ADDR_DST8, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST8, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST8, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST9, 0x2a4)
    FIELD(REG_ADDR_DST9, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST9, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST9, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST10, 0x2a8)
    FIELD(REG_ADDR_DST10, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST10, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST10, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST11, 0x2ac)
    FIELD(REG_ADDR_DST11, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST11, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST11, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST12, 0x2b0)
    FIELD(REG_ADDR_DST12, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST12, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST12, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST13, 0x2b4)
    FIELD(REG_ADDR_DST13, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST13, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST13, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST14, 0x2b8)
    FIELD(REG_ADDR_DST14, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST14, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST14, REMAP_ID, 0, 12)
REG32(REG_ADDR_DST15, 0x2bc)
    FIELD(REG_ADDR_DST15, REMAP_ITLV_EN, 15, 1)
    FIELD(REG_ADDR_DST15, REMAP_ITLV_IDX, 12, 3)
    FIELD(REG_ADDR_DST15, REMAP_ID, 0, 12)
REG32(REG_ADDR_ENABLE, 0x2c0)
    FIELD(REG_ADDR_ENABLE, REMAP, 0, 16)
REG32(REG_ADDR_REMAP, 0x2c4)
    FIELD(REG_ADDR_REMAP, REMAP, 0, 16)
REG32(REG_MODE_SELECT, 0x2c8)
    FIELD(REG_MODE_SELECT, FIXED_DST_ID_VAL, 4, 12)
    FIELD(REG_MODE_SELECT, FIXED_DST_ID_EN, 2, 1)
    FIELD(REG_MODE_SELECT, PROT, 0, 2)
REG32(REG_CHOPSIZE, 0x2cc)
    FIELD(REG_CHOPSIZE, WR, 2, 2)
    FIELD(REG_CHOPSIZE, RD, 0, 2)
REG32(REG_HBM_MAP_T0_CH0, 0x2d0)
    FIELD(REG_HBM_MAP_T0_CH0, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH1, 0x2d4)
    FIELD(REG_HBM_MAP_T0_CH1, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH2, 0x2d8)
    FIELD(REG_HBM_MAP_T0_CH2, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH3, 0x2dc)
    FIELD(REG_HBM_MAP_T0_CH3, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH4, 0x2e0)
    FIELD(REG_HBM_MAP_T0_CH4, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH5, 0x2e4)
    FIELD(REG_HBM_MAP_T0_CH5, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH6, 0x2e8)
    FIELD(REG_HBM_MAP_T0_CH6, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH7, 0x2ec)
    FIELD(REG_HBM_MAP_T0_CH7, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH8, 0x2f0)
    FIELD(REG_HBM_MAP_T0_CH8, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH9, 0x2f4)
    FIELD(REG_HBM_MAP_T0_CH9, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH10, 0x2f8)
    FIELD(REG_HBM_MAP_T0_CH10, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH11, 0x2fc)
    FIELD(REG_HBM_MAP_T0_CH11, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH12, 0x300)
    FIELD(REG_HBM_MAP_T0_CH12, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH13, 0x304)
    FIELD(REG_HBM_MAP_T0_CH13, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH14, 0x308)
    FIELD(REG_HBM_MAP_T0_CH14, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T0_CH15, 0x30c)
    FIELD(REG_HBM_MAP_T0_CH15, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH0, 0x310)
    FIELD(REG_HBM_MAP_T1_CH0, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH1, 0x314)
    FIELD(REG_HBM_MAP_T1_CH1, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH2, 0x318)
    FIELD(REG_HBM_MAP_T1_CH2, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH3, 0x31c)
    FIELD(REG_HBM_MAP_T1_CH3, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH4, 0x320)
    FIELD(REG_HBM_MAP_T1_CH4, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH5, 0x324)
    FIELD(REG_HBM_MAP_T1_CH5, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH6, 0x328)
    FIELD(REG_HBM_MAP_T1_CH6, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH7, 0x32c)
    FIELD(REG_HBM_MAP_T1_CH7, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH8, 0x330)
    FIELD(REG_HBM_MAP_T1_CH8, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH9, 0x334)
    FIELD(REG_HBM_MAP_T1_CH9, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH10, 0x338)
    FIELD(REG_HBM_MAP_T1_CH10, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH11, 0x33c)
    FIELD(REG_HBM_MAP_T1_CH11, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH12, 0x340)
    FIELD(REG_HBM_MAP_T1_CH12, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH13, 0x344)
    FIELD(REG_HBM_MAP_T1_CH13, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH14, 0x348)
    FIELD(REG_HBM_MAP_T1_CH14, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T1_CH15, 0x34c)
    FIELD(REG_HBM_MAP_T1_CH15, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH0, 0x350)
    FIELD(REG_HBM_MAP_T2_CH0, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH1, 0x354)
    FIELD(REG_HBM_MAP_T2_CH1, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH2, 0x358)
    FIELD(REG_HBM_MAP_T2_CH2, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH3, 0x35c)
    FIELD(REG_HBM_MAP_T2_CH3, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH4, 0x360)
    FIELD(REG_HBM_MAP_T2_CH4, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH5, 0x364)
    FIELD(REG_HBM_MAP_T2_CH5, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH6, 0x368)
    FIELD(REG_HBM_MAP_T2_CH6, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH7, 0x36c)
    FIELD(REG_HBM_MAP_T2_CH7, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH8, 0x370)
    FIELD(REG_HBM_MAP_T2_CH8, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH9, 0x374)
    FIELD(REG_HBM_MAP_T2_CH9, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH10, 0x378)
    FIELD(REG_HBM_MAP_T2_CH10, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH11, 0x37c)
    FIELD(REG_HBM_MAP_T2_CH11, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH12, 0x380)
    FIELD(REG_HBM_MAP_T2_CH12, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH13, 0x384)
    FIELD(REG_HBM_MAP_T2_CH13, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH14, 0x388)
    FIELD(REG_HBM_MAP_T2_CH14, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T2_CH15, 0x38c)
    FIELD(REG_HBM_MAP_T2_CH15, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH0, 0x390)
    FIELD(REG_HBM_MAP_T3_CH0, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH1, 0x394)
    FIELD(REG_HBM_MAP_T3_CH1, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH2, 0x398)
    FIELD(REG_HBM_MAP_T3_CH2, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH3, 0x39c)
    FIELD(REG_HBM_MAP_T3_CH3, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH4, 0x3a0)
    FIELD(REG_HBM_MAP_T3_CH4, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH5, 0x3a4)
    FIELD(REG_HBM_MAP_T3_CH5, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH6, 0x3a8)
    FIELD(REG_HBM_MAP_T3_CH6, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH7, 0x3ac)
    FIELD(REG_HBM_MAP_T3_CH7, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH8, 0x3b0)
    FIELD(REG_HBM_MAP_T3_CH8, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH9, 0x3b4)
    FIELD(REG_HBM_MAP_T3_CH9, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH10, 0x3b8)
    FIELD(REG_HBM_MAP_T3_CH10, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH11, 0x3bc)
    FIELD(REG_HBM_MAP_T3_CH11, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH12, 0x3c0)
    FIELD(REG_HBM_MAP_T3_CH12, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH13, 0x3c4)
    FIELD(REG_HBM_MAP_T3_CH13, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH14, 0x3c8)
    FIELD(REG_HBM_MAP_T3_CH14, DST_ID, 0, 12)
REG32(REG_HBM_MAP_T3_CH15, 0x3cc)
    FIELD(REG_HBM_MAP_T3_CH15, DST_ID, 0, 12)
REG32(REG_DDR_DST_MAP0, 0x3d0)
    FIELD(REG_DDR_DST_MAP0, ID, 0, 12)
REG32(REG_DDR_DST_MAP1, 0x3d4)
    FIELD(REG_DDR_DST_MAP1, ID, 0, 12)
REG32(REG_DDR_DST_MAP2, 0x3d8)
    FIELD(REG_DDR_DST_MAP2, ID, 0, 12)
REG32(REG_DDR_DST_MAP3, 0x3dc)
    FIELD(REG_DDR_DST_MAP3, ID, 0, 12)
REG32(REG_DDR_DST_MAP4, 0x3e0)
    FIELD(REG_DDR_DST_MAP4, ID, 0, 12)
REG32(REG_DDR_DST_MAP5, 0x3e4)
    FIELD(REG_DDR_DST_MAP5, ID, 0, 12)
REG32(REG_DDR_DST_MAP6, 0x3e8)
    FIELD(REG_DDR_DST_MAP6, ID, 0, 12)
REG32(REG_DDR_DST_MAP7, 0x3ec)
    FIELD(REG_DDR_DST_MAP7, ID, 0, 12)
REG32(REG_DDR_ADR_MAP0, 0x3f0)
    FIELD(REG_DDR_ADR_MAP0, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP0, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP0, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP0, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP0, DST_PTR0, 0, 3)
REG32(REG_DDR_ADR_MAP1, 0x3f4)
    FIELD(REG_DDR_ADR_MAP1, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP1, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP1, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP1, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP1, DST_PTR0, 0, 3)
REG32(REG_DDR_ADR_MAP2, 0x3f8)
    FIELD(REG_DDR_ADR_MAP2, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP2, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP2, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP2, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP2, DST_PTR0, 0, 3)
REG32(REG_DDR_ADR_MAP3, 0x3fc)
    FIELD(REG_DDR_ADR_MAP3, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP3, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP3, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP3, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP3, DST_PTR0, 0, 3)
REG32(REG_DDR_ADR_MAP4, 0x400)
    FIELD(REG_DDR_ADR_MAP4, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP4, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP4, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP4, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP4, DST_PTR0, 0, 3)
REG32(REG_DDR_ADR_MAP5, 0x404)
    FIELD(REG_DDR_ADR_MAP5, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP5, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP5, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP5, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP5, DST_PTR0, 0, 3)
REG32(REG_DDR_ADR_MAP6, 0x408)
    FIELD(REG_DDR_ADR_MAP6, ITLV_SIZE, 12, 3)
    FIELD(REG_DDR_ADR_MAP6, DST_PTR3, 9, 3)
    FIELD(REG_DDR_ADR_MAP6, DST_PTR2, 6, 3)
    FIELD(REG_DDR_ADR_MAP6, DST_PTR1, 3, 3)
    FIELD(REG_DDR_ADR_MAP6, DST_PTR0, 0, 3)
REG32(REG_ADR_MAP_XPDS, 0x40c)
    FIELD(REG_ADR_MAP_XPDS, DST_ID, 0, 12)
REG32(REG_ADR_MAP_PMC, 0x410)
    FIELD(REG_ADR_MAP_PMC, DST_ID, 0, 12)
REG32(REG_ADR_MAP_PCIE, 0x414)
    FIELD(REG_ADR_MAP_PCIE, DST_ID, 0, 12)
REG32(REG_ADR_MAP_CPM, 0x418)
    FIELD(REG_ADR_MAP_CPM, DST_ID, 0, 12)
REG32(REG_ADR_MAP_LPD_AFI_FS, 0x41c)
    FIELD(REG_ADR_MAP_LPD_AFI_FS, DST_ID, 0, 12)
REG32(REG_ADR_MAP_FPD_AFI_0, 0x420)
    FIELD(REG_ADR_MAP_FPD_AFI_0, DST_ID, 0, 12)
REG32(REG_ADR_MAP_FPD_AFI_1, 0x424)
    FIELD(REG_ADR_MAP_FPD_AFI_1, DST_ID, 0, 12)
REG32(REG_ADR_MAP_QSPI, 0x428)
    FIELD(REG_ADR_MAP_QSPI, DST_ID, 0, 12)
REG32(REG_ADR_MAP_STM_GIC, 0x42c)
    FIELD(REG_ADR_MAP_STM_GIC, DST_ID, 0, 12)
REG32(REG_ADR_MAP_PMC_ALIAS_0, 0x430)
    FIELD(REG_ADR_MAP_PMC_ALIAS_0, DST_ID, 0, 12)
REG32(REG_ADR_MAP_PMC_ALIAS_1, 0x434)
    FIELD(REG_ADR_MAP_PMC_ALIAS_1, DST_ID, 0, 12)
REG32(REG_ADR_MAP_PMC_ALIAS_2, 0x438)
    FIELD(REG_ADR_MAP_PMC_ALIAS_2, DST_ID, 0, 12)
REG32(REG_ADR_MAP_PMC_ALIAS_3, 0x43c)
    FIELD(REG_ADR_MAP_PMC_ALIAS_3, DST_ID, 0, 12)
REG32(REG_ADR_MAP_ME_ARRAY_0, 0x440)
    FIELD(REG_ADR_MAP_ME_ARRAY_0, DST_ID, 0, 12)
REG32(REG_ADR_MAP_ME_ARRAY_1, 0x444)
    FIELD(REG_ADR_MAP_ME_ARRAY_1, DST_ID, 0, 12)
REG32(REG_ADR_MAP_ME_ARRAY_2, 0x448)
    FIELD(REG_ADR_MAP_ME_ARRAY_2, DST_ID, 0, 12)
REG32(REG_ADR_MAP_ME_ARRAY_3, 0x44c)
    FIELD(REG_ADR_MAP_ME_ARRAY_3, DST_ID, 0, 12)
REG32(REG_SRC, 0x450)
    FIELD(REG_SRC, NMU, 0, 12)
REG32(REG_DWIDTH, 0x454)
    FIELD(REG_DWIDTH, NMU, 0, 3)
REG32(REG_WBUF_LAUNCH_SIZE, 0x458)
    FIELD(REG_WBUF_LAUNCH_SIZE, NMU, 0, 6)
REG32(REG_SMID_SEL, 0x45c)
    FIELD(REG_SMID_SEL, VAL, 10, 10)
    FIELD(REG_SMID_SEL, EN, 0, 10)
REG32(REG_AXI_NON_MOD_DISABLE, 0x460)
    FIELD(REG_AXI_NON_MOD_DISABLE, NMU, 0, 1)
REG32(REG_PRIORITY, 0x464)
    FIELD(REG_PRIORITY, WR, 1, 1)
    FIELD(REG_PRIORITY, RD, 0, 1)
REG32(REG_RD_AXPROT_SEL, 0x468)
    FIELD(REG_RD_AXPROT_SEL, VAL, 3, 3)
    FIELD(REG_RD_AXPROT_SEL, MASK, 0, 3)
REG32(REG_WR_AXPROT_SEL, 0x46c)
    FIELD(REG_WR_AXPROT_SEL, VAL, 3, 3)
    FIELD(REG_WR_AXPROT_SEL, MASK, 0, 3)
REG32(REG_AXI_PAR_CHK, 0x470)
    FIELD(REG_AXI_PAR_CHK, EN, 0, 1)
REG32(REG_OUTSTANDING_RD_TXN, 0x474)
    FIELD(REG_OUTSTANDING_RD_TXN, NMU, 0, 7)
REG32(REG_OUTSTANDING_WR_TXN, 0x478)
    FIELD(REG_OUTSTANDING_WR_TXN, NMU, 0, 7)
REG32(REG_VC_MAP, 0x47c)
    FIELD(REG_VC_MAP, WR_RESP, 9, 3)
    FIELD(REG_VC_MAP, RD_RESP, 6, 3)
    FIELD(REG_VC_MAP, WR_REQ, 3, 3)
    FIELD(REG_VC_MAP, RD_REQ, 0, 3)
REG32(REG_RPOISON_TO_SLVERR, 0x480)
    FIELD(REG_RPOISON_TO_SLVERR, EN, 0, 1)
REG32(REG_NOC_DBI, 0x484)
    FIELD(REG_NOC_DBI, EN, 0, 1)
REG32(REG_RROB_RAM_SETTING, 0x488)
    FIELD(REG_RROB_RAM_SETTING, EXT_DLY, 8, 1)
    FIELD(REG_RROB_RAM_SETTING, STOV, 7, 1)
    FIELD(REG_RROB_RAM_SETTING, EMASA, 6, 1)
    FIELD(REG_RROB_RAM_SETTING, EMAB, 3, 3)
    FIELD(REG_RROB_RAM_SETTING, EMAA, 0, 3)
REG32(REG_WBUF_RAM_SETTING, 0x48c)
    FIELD(REG_WBUF_RAM_SETTING, EXT_DLY, 8, 1)
    FIELD(REG_WBUF_RAM_SETTING, STOV, 7, 1)
    FIELD(REG_WBUF_RAM_SETTING, EMASA, 6, 1)
    FIELD(REG_WBUF_RAM_SETTING, EMAB, 3, 3)
    FIELD(REG_WBUF_RAM_SETTING, EMAA, 0, 3)
REG32(REG_ECC_CHK_EN, 0x490)
    FIELD(REG_ECC_CHK_EN, NMU, 0, 1)
REG32(REG_AXI_LOOPBACK, 0x800)
    FIELD(REG_AXI_LOOPBACK, DMUX, 2, 3)
    FIELD(REG_AXI_LOOPBACK, CMUX, 1, 1)
    FIELD(REG_AXI_LOOPBACK, EN, 0, 1)
REG32(REG_AXI_REQ_REJECT_ENABLE, 0x804)
    FIELD(REG_AXI_REQ_REJECT_ENABLE, NMU, 0, 1)
REG32(REG_NOC_CLK_GATE_DIS, 0x808)
    FIELD(REG_NOC_CLK_GATE_DIS, NMU, 0, 1)
REG32(REG_FAB_CLK_GATE_DIS, 0x80c)
    FIELD(REG_FAB_CLK_GATE_DIS, NMU, 0, 1)
REG32(REG_BUSY, 0x810)
    FIELD(REG_BUSY, NMU, 0, 1)
REG32(REG_1ST_ERR_NUM, 0x814)
    FIELD(REG_1ST_ERR_NUM, VALID, 22, 1)
    FIELD(REG_1ST_ERR_NUM, ETYPE, 20, 2)
    FIELD(REG_1ST_ERR_NUM, COMP, 16, 4)
    FIELD(REG_1ST_ERR_NUM, CATEG, 12, 4)
    FIELD(REG_1ST_ERR_NUM, SUBC0, 8, 4)
    FIELD(REG_1ST_ERR_NUM, SUBC1, 4, 4)
    FIELD(REG_1ST_ERR_NUM, ENUMB, 0, 4)
REG32(REG_1ST_ERR_INFO_0, 0x818)
    FIELD(REG_1ST_ERR_INFO_0, DST, 20, 12)
    FIELD(REG_1ST_ERR_INFO_0, SRC, 8, 12)
    FIELD(REG_1ST_ERR_INFO_0, TAG, 0, 8)
REG32(REG_1ST_ERR_INFO_1, 0x81c)
    FIELD(REG_1ST_ERR_INFO_1, LAST, 24, 1)
    FIELD(REG_1ST_ERR_INFO_1, WSTRB, 8, 16)
    FIELD(REG_1ST_ERR_INFO_1, PRI, 7, 1)
    FIELD(REG_1ST_ERR_INFO_1, DST_PAR, 6, 1)
    FIELD(REG_1ST_ERR_INFO_1, MISC_CTRL, 4, 2)
    FIELD(REG_1ST_ERR_INFO_1, PKT_TYPE, 0, 4)
REG32(REG_1ST_ERR_INFO_2, 0x820)
    FIELD(REG_1ST_ERR_INFO_2, TRK_IDX, 25, 6)
    FIELD(REG_1ST_ERR_INFO_2, NPP_EBIT, 17, 8)
    FIELD(REG_1ST_ERR_INFO_2, TID, 11, 6)
    FIELD(REG_1ST_ERR_INFO_2, TLAST, 10, 1)
    FIELD(REG_1ST_ERR_INFO_2, POISON, 9, 1)
    FIELD(REG_1ST_ERR_INFO_2, DBI, 8, 1)
    FIELD(REG_1ST_ERR_INFO_2, VC, 0, 8)
REG32(REG_1ST_ERR_INFO_3, 0x824)
    FIELD(REG_1ST_ERR_INFO_3, AXCACHE, 28, 4)
    FIELD(REG_1ST_ERR_INFO_3, AXLOCK, 27, 1)
    FIELD(REG_1ST_ERR_INFO_3, AXSIZE, 24, 3)
    FIELD(REG_1ST_ERR_INFO_3, AXLEN, 16, 8)
    FIELD(REG_1ST_ERR_INFO_3, AXID, 0, 16)
REG32(REG_1ST_ERR_INFO_4, 0x828)
    FIELD(REG_1ST_ERR_INFO_4, VC_MAP, 27, 1)
    FIELD(REG_1ST_ERR_INFO_4, CID, 25, 2)
    FIELD(REG_1ST_ERR_INFO_4, AXPROT, 22, 3)
    FIELD(REG_1ST_ERR_INFO_4, AXBURST, 20, 2)
    FIELD(REG_1ST_ERR_INFO_4, AXQOS, 16, 4)
    FIELD(REG_1ST_ERR_INFO_4, AXUSER, 0, 16)
REG32(REG_1ST_ERR_INFO_5, 0x82c)
REG32(REG_1ST_ERR_INFO_6, 0x830)
REG32(REG_1ST_ERR_INFO_7, 0x834)
    FIELD(REG_1ST_ERR_INFO_7, CREDIT_OFL, 28, 4)
    FIELD(REG_1ST_ERR_INFO_7, CREDIT_UFL, 24, 4)
    FIELD(REG_1ST_ERR_INFO_7, ADDR_PAR, 16, 8)
    FIELD(REG_1ST_ERR_INFO_7, REMAP_MATCH_TDEST, 0, 16)
REG32(REG_ERR_LOG_EN, 0x838)
    FIELD(REG_ERR_LOG_EN, NPP_RPOISON, 15, 1)
    FIELD(REG_ERR_LOG_EN, VC_CREDIT, 13, 1)
    FIELD(REG_ERR_LOG_EN, NPP_UNEXP, 12, 1)
    FIELD(REG_ERR_LOG_EN, RROB_CHK, 11, 1)
    FIELD(REG_ERR_LOG_EN, DATA_PAR, 10, 1)
    FIELD(REG_ERR_LOG_EN, ADDR_PAR, 9, 1)
    FIELD(REG_ERR_LOG_EN, TIMEOUT, 8, 1)
    FIELD(REG_ERR_LOG_EN, ECC_1BIT, 7, 1)
    FIELD(REG_ERR_LOG_EN, ECC_2BIT, 6, 1)
    FIELD(REG_ERR_LOG_EN, NPP_IN, 5, 1)
    FIELD(REG_ERR_LOG_EN, ADDR_REMAP, 4, 1)
    FIELD(REG_ERR_LOG_EN, ADDR_MAP, 3, 1)
    FIELD(REG_ERR_LOG_EN, XLX_INFOS, 2, 1)
    FIELD(REG_ERR_LOG_EN, XLX_RULES, 1, 1)
    FIELD(REG_ERR_LOG_EN, AXI_RULES, 0, 1)
REG32(REG_RD_RATE_CREDIT_DROP, 0x83c)
    FIELD(REG_RD_RATE_CREDIT_DROP, NMU, 0, 10)
REG32(REG_RD_RATE_CREDIT_LIMIT, 0x840)
    FIELD(REG_RD_RATE_CREDIT_LIMIT, EN, 12, 1)
    FIELD(REG_RD_RATE_CREDIT_LIMIT, NMU, 0, 12)
REG32(REG_WR_RATE_CREDIT_DROP, 0x844)
    FIELD(REG_WR_RATE_CREDIT_DROP, NMU, 0, 10)
REG32(REG_WR_RATE_CREDIT_LIMIT, 0x848)
    FIELD(REG_WR_RATE_CREDIT_LIMIT, EN, 12, 1)
    FIELD(REG_WR_RATE_CREDIT_LIMIT, NMU, 0, 12)
REG32(REG_RD_VCA_TOKEN0, 0x850)
    FIELD(REG_RD_VCA_TOKEN0, NMU, 0, 8)
REG32(REG_WR_VCA_TOKEN0, 0x854)
    FIELD(REG_WR_VCA_TOKEN0, NMU, 0, 8)
REG32(REG_TBASE_MODE_RLIMIT_RD, 0x858)
    FIELD(REG_TBASE_MODE_RLIMIT_RD, NMU, 0, 3)
REG32(REG_TBASE_MODE_RLIMIT_WR, 0x860)
    FIELD(REG_TBASE_MODE_RLIMIT_WR, NMU, 0, 3)
REG32(REG_TBASE_TRK_TIMEOUT, 0x864)
    FIELD(REG_TBASE_TRK_TIMEOUT, EN, 3, 1)
    FIELD(REG_TBASE_TRK_TIMEOUT, INDEX, 0, 3)
REG32(REG_TBASE_AXI_TIMEOUT, 0x868)
    FIELD(REG_TBASE_AXI_TIMEOUT, EN, 3, 1)
    FIELD(REG_TBASE_AXI_TIMEOUT, INDEX, 0, 3)
REG32(REG_PERF_MON_TBASE, 0x86c)
    FIELD(REG_PERF_MON_TBASE, TSLIDE_LSB, 3, 5)
    FIELD(REG_PERF_MON_TBASE, SEL, 0, 3)
REG32(REG_PERF_MON0_LATENCY_MIN, 0x870)
    FIELD(REG_PERF_MON0_LATENCY_MIN, NMU, 0, 10)
REG32(REG_PERF_MON0_LATENCY_MAX, 0x874)
    FIELD(REG_PERF_MON0_LATENCY_MAX, NMU, 0, 10)
REG32(REG_PERF_MON0_LATENCY_ACC_UPR, 0x878)
    FIELD(REG_PERF_MON0_LATENCY_ACC_UPR, NMU, 0, 8)
REG32(REG_PERF_MON0_LATENCY_ACC_LWR, 0x87c)
REG32(REG_PERF_MON0_BURST_CNT, 0x880)
REG32(REG_PERF_MON0_CNT_AND_OFL, 0x884)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, BYTE_CNT_OFL, 12, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, BURST_CNT_OFL, 11, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, LATENCY_ACC_OFL, 10, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, LATENCY_MAX_OFL, 9, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, LATENCY_MIN_OFL, 8, 1)
    FIELD(REG_PERF_MON0_CNT_AND_OFL, BYTE_CNT_UPR, 0, 8)
REG32(REG_PERF_MON0_BYTE_CNT_LWR, 0x888)
REG32(REG_PERF_MON0_CTRL, 0x88c)
    FIELD(REG_PERF_MON0_CTRL, RW_SEL, 3, 1)
    FIELD(REG_PERF_MON0_CTRL, FLT_SEL, 2, 1)
    FIELD(REG_PERF_MON0_CTRL, LAT_SEL, 1, 1)
    FIELD(REG_PERF_MON0_CTRL, MON_EN, 0, 1)
REG32(REG_PERF_MON1_LATENCY_MIN, 0x890)
    FIELD(REG_PERF_MON1_LATENCY_MIN, NMU, 0, 10)
REG32(REG_PERF_MON1_LATENCY_MAX, 0x894)
    FIELD(REG_PERF_MON1_LATENCY_MAX, NMU, 0, 10)
REG32(REG_PERF_MON1_LATENCY_ACC_UPR, 0x898)
    FIELD(REG_PERF_MON1_LATENCY_ACC_UPR, NMU, 0, 8)
REG32(REG_PERF_MON1_LATENCY_ACC_LWR, 0x89c)
REG32(REG_PERF_MON1_BURST_CNT, 0x8a0)
REG32(REG_PERF_MON1_CNT_AND_OFL, 0x8a4)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, BYTE_CNT_OFL, 12, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, BURST_CNT_OFL, 11, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, LATENCY_ACC_OFL, 10, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, LATENCY_MAX_OFL, 9, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, LATENCY_MIN_OFL, 8, 1)
    FIELD(REG_PERF_MON1_CNT_AND_OFL, BYTE_CNT_UPR, 0, 8)
REG32(REG_PERF_MON1_BYTE_CNT_LWR, 0x8a8)
REG32(REG_PERF_MON1_CTRL, 0x8ac)
    FIELD(REG_PERF_MON1_CTRL, RW_SEL, 3, 1)
    FIELD(REG_PERF_MON1_CTRL, FLT_SEL, 2, 1)
    FIELD(REG_PERF_MON1_CTRL, LAT_SEL, 1, 1)
    FIELD(REG_PERF_MON1_CTRL, MON_EN, 0, 1)
REG32(REG_PERF_FLT0_CMP_S0, 0x8b0)
    FIELD(REG_PERF_FLT0_CMP_S0, AXPROT, 29, 3)
    FIELD(REG_PERF_FLT0_CMP_S0, AXBURST, 27, 2)
    FIELD(REG_PERF_FLT0_CMP_S0, AXSIZE_MIN, 24, 3)
    FIELD(REG_PERF_FLT0_CMP_S0, AXLEN_MIN, 16, 8)
    FIELD(REG_PERF_FLT0_CMP_S0, AXID, 0, 16)
REG32(REG_PERF_FLT0_CMP_S1, 0x8b4)
    FIELD(REG_PERF_FLT0_CMP_S1, TDEST, 21, 10)
    FIELD(REG_PERF_FLT0_CMP_S1, DST_ID, 9, 12)
    FIELD(REG_PERF_FLT0_CMP_S1, AXLOCK, 8, 1)
    FIELD(REG_PERF_FLT0_CMP_S1, AXQOS_MIN, 4, 4)
    FIELD(REG_PERF_FLT0_CMP_S1, AXCACHE, 0, 4)
REG32(REG_PERF_FLT0_CMP_S2, 0x8b8)
    FIELD(REG_PERF_FLT0_CMP_S2, AXSIZE_MAX, 12, 3)
    FIELD(REG_PERF_FLT0_CMP_S2, AXQOS_MAX, 8, 4)
    FIELD(REG_PERF_FLT0_CMP_S2, AXLEN_MAX, 0, 8)
REG32(REG_PERF_FLT0_CMP_EN, 0x8bc)
    FIELD(REG_PERF_FLT0_CMP_EN, TDEST, 9, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, DST_ID, 8, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXLOCK, 7, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXQOS, 6, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXCACHE, 5, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXPROT, 4, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXBURST, 3, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXSIZE, 2, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXLEN, 1, 1)
    FIELD(REG_PERF_FLT0_CMP_EN, AXID, 0, 1)
REG32(REG_PERF_FLT1_CMP_S0, 0x8c0)
    FIELD(REG_PERF_FLT1_CMP_S0, AXPROT, 29, 3)
    FIELD(REG_PERF_FLT1_CMP_S0, AXBURST, 27, 2)
    FIELD(REG_PERF_FLT1_CMP_S0, AXSIZE_MIN, 24, 3)
    FIELD(REG_PERF_FLT1_CMP_S0, AXLEN_MIN, 16, 8)
    FIELD(REG_PERF_FLT1_CMP_S0, AXID, 0, 16)
REG32(REG_PERF_FLT1_CMP_S1, 0x8c4)
    FIELD(REG_PERF_FLT1_CMP_S1, TDEST, 21, 10)
    FIELD(REG_PERF_FLT1_CMP_S1, DST_ID, 9, 12)
    FIELD(REG_PERF_FLT1_CMP_S1, AXLOCK, 8, 1)
    FIELD(REG_PERF_FLT1_CMP_S1, AXQOS_MIN, 4, 4)
    FIELD(REG_PERF_FLT1_CMP_S1, AXCACHE, 0, 4)
REG32(REG_PERF_FLT1_CMP_S2, 0x8c8)
    FIELD(REG_PERF_FLT1_CMP_S2, AXSIZE_MAX, 12, 3)
    FIELD(REG_PERF_FLT1_CMP_S2, AXQOS_MAX, 8, 4)
    FIELD(REG_PERF_FLT1_CMP_S2, AXLEN_MAX, 0, 8)
REG32(REG_PERF_FLT1_CMP_EN, 0x8cc)
    FIELD(REG_PERF_FLT1_CMP_EN, TDEST, 9, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, DST_ID, 8, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXLOCK, 7, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXQOS, 6, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXCACHE, 5, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXPROT, 4, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXBURST, 3, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXSIZE, 2, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXLEN, 1, 1)
    FIELD(REG_PERF_FLT1_CMP_EN, AXID, 0, 1)
REG32(REG_PENDING_BURST, 0x8d0)
    FIELD(REG_PENDING_BURST, CNT_W, 8, 8)
    FIELD(REG_PENDING_BURST, CNT_R, 0, 8)
REG32(REG_DST_TFC_CHK_CTRL, 0x8d4)
    FIELD(REG_DST_TFC_CHK_CTRL, EN, 12, 1)
    FIELD(REG_DST_TFC_CHK_CTRL, DST_ID, 0, 12)
REG32(REG_DST_TFC_CHK_STAT, 0x8d8)
    FIELD(REG_DST_TFC_CHK_STAT, STA_W, 1, 1)
    FIELD(REG_DST_TFC_CHK_STAT, STA_R, 0, 1)
REG32(REG_ERR_INJ_MODE, 0x8dc)
    FIELD(REG_ERR_INJ_MODE, NMU, 0, 1)
REG32(REG_ERR_INJ_EN, 0x8e0)
    FIELD(REG_ERR_INJ_EN, DLY_CNT, 16, 16)
    FIELD(REG_ERR_INJ_EN, PAR_DST_WR, 6, 1)
    FIELD(REG_ERR_INJ_EN, PAR_DST_RD, 5, 1)
    FIELD(REG_ERR_INJ_EN, PAR_DATA_RD, 4, 1)
    FIELD(REG_ERR_INJ_EN, PAR_ADDR_WR_REGEN, 3, 1)
    FIELD(REG_ERR_INJ_EN, PAR_ADDR_RD_REGEN, 2, 1)
    FIELD(REG_ERR_INJ_EN, ECC_WR, 1, 1)
    FIELD(REG_ERR_INJ_EN, ECC_RD, 0, 1)
REG32(REG_ERR_INJ_INDEX_0, 0x8e4)
    FIELD(REG_ERR_INJ_INDEX_0, PAR_DATA, 22, 7)
    FIELD(REG_ERR_INJ_INDEX_0, PAR_ADDR, 16, 6)
    FIELD(REG_ERR_INJ_INDEX_0, ECC_BIT_1, 8, 8)
    FIELD(REG_ERR_INJ_INDEX_0, ECC_BIT_0, 0, 8)
REG32(REG_ERR_INJ_INDEX_1, 0x8e8)
    FIELD(REG_ERR_INJ_INDEX_1, PAR_DST, 0, 4)
REG32(REG_ERR_INJ_STAT, 0x8ec)
    FIELD(REG_ERR_INJ_STAT, PAR_DST_WR, 6, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_DST_RD, 5, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_DATA_RD, 4, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_ADDR_WR_REGEN, 3, 1)
    FIELD(REG_ERR_INJ_STAT, PAR_ADDR_RD_REGEN, 2, 1)
    FIELD(REG_ERR_INJ_STAT, ECC_WR, 1, 1)
    FIELD(REG_ERR_INJ_STAT, ECC_RD, 0, 1)
REG32(REG_2ND_ERR, 0x8f0)
    FIELD(REG_2ND_ERR, ECC_1BIT, 0, 1)
REG32(REG_MBIST_STAT, 0x8f4)
    FIELD(REG_MBIST_STAT, ERROR, 1, 1)
    FIELD(REG_MBIST_STAT, DONE, 0, 1)
REG32(REG_DBG_MUX_SEL, 0x8f8)
    FIELD(REG_DBG_MUX_SEL, TRIG_DONE, 9, 1)
    FIELD(REG_DBG_MUX_SEL, DAT_DISC, 8, 1)
    FIELD(REG_DBG_MUX_SEL, POST_TRIG_CNT, 5, 3)
    FIELD(REG_DBG_MUX_SEL, CLK_DIV, 4, 1)
    FIELD(REG_DBG_MUX_SEL, TRIG_EN, 3, 1)
    FIELD(REG_DBG_MUX_SEL, DBG_EN, 2, 1)
    FIELD(REG_DBG_MUX_SEL, IN_SEL, 1, 1)
    FIELD(REG_DBG_MUX_SEL, OUT_SEL, 0, 1)
REG32(REG_DBG_DATA_SEL, 0x8fc)
    FIELD(REG_DBG_DATA_SEL, NMU, 0, 6)
REG32(REG_DBG_TRIG_MVAL_L, 0x900)
REG32(REG_DBG_TRIG_MVAL_U, 0x904)
REG32(REG_DBG_TRIG_MASK_L, 0x908)
REG32(REG_DBG_TRIG_MASK_U, 0x90c)
REG32(REG_DYN_PROG_DIS, 0x910)
    FIELD(REG_DYN_PROG_DIS, ERR_GRP, 2, 1)
    FIELD(REG_DYN_PROG_DIS, MON_GRP, 1, 1)
    FIELD(REG_DYN_PROG_DIS, TOKEN_GRP, 0, 1)
REG32(REG_SPARE, 0x914)

#define NOC_NMU_R_MAX (0x1000 / 4)

#define LOCK_VAL 0xF9E8D7C6

typedef struct NOC_NMU {
    SysBusDevice parent_obj;
    RegisterInfoArray *reg_array;

    uint32_t regs[NOC_NMU_R_MAX];
    RegisterInfo regs_info[NOC_NMU_R_MAX];
} NOC_NMU;

static void noc_nmu_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    NOC_NMU *s = XILINX_NOC_NMU(reg->opaque);
    bool locked = val64 != LOCK_VAL;

    ARRAY_FIELD_DP32(s->regs, REG_PCSR_STATUS, PCSRLOCK, locked);
}

static const RegisterAccessInfo noc_nmu_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xfee07d30,
        .ro = 0xe07d30,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x10000c4,
        .rsvd = 0xfee07d30,
        .ro = 0xe07d30,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_PCSRLOCK_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_CALDONE_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = noc_nmu_lock_postw
    },{ .name = "REG_ISR",  .addr = A_REG_ISR,
        .rsvd = 0xe0000000,
        .w1c = 0x1fffffff,
    },{ .name = "REG_ITR",  .addr = A_REG_ITR,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IMR0",  .addr = A_REG_IMR0,
        .reset = 0x7ffffff,
        .rsvd = 0xe0000000,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER0",  .addr = A_REG_IER0,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IDR0",  .addr = A_REG_IDR0,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IMR1",  .addr = A_REG_IMR1,
        .reset = 0x1fffffff,
        .rsvd = 0xe0000000,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER1",  .addr = A_REG_IER1,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IDR1",  .addr = A_REG_IDR1,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IMR2",  .addr = A_REG_IMR2,
        .reset = 0x1fffffff,
        .rsvd = 0xe0000000,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER2",  .addr = A_REG_IER2,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IDR2",  .addr = A_REG_IDR2,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IMR3",  .addr = A_REG_IMR3,
        .reset = 0x1fffffff,
        .rsvd = 0xe0000000,
        .ro = 0x1fffffff,
    },{ .name = "REG_IER3",  .addr = A_REG_IER3,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IDR3",  .addr = A_REG_IDR3,
        .rsvd = 0xe0000000,
    },{ .name = "REG_IOR",  .addr = A_REG_IOR,
        .reset = 0x10,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_ADDR_MADDR0",  .addr = A_REG_ADDR_MADDR0,
    },{ .name = "REG_ADDR_MADDR1",  .addr = A_REG_ADDR_MADDR1,
    },{ .name = "REG_ADDR_MADDR2",  .addr = A_REG_ADDR_MADDR2,
    },{ .name = "REG_ADDR_MADDR3",  .addr = A_REG_ADDR_MADDR3,
    },{ .name = "REG_ADDR_MADDR4",  .addr = A_REG_ADDR_MADDR4,
    },{ .name = "REG_ADDR_MADDR5",  .addr = A_REG_ADDR_MADDR5,
    },{ .name = "REG_ADDR_MADDR6",  .addr = A_REG_ADDR_MADDR6,
    },{ .name = "REG_ADDR_MADDR7",  .addr = A_REG_ADDR_MADDR7,
    },{ .name = "REG_ADDR_MADDR8",  .addr = A_REG_ADDR_MADDR8,
    },{ .name = "REG_ADDR_MADDR9",  .addr = A_REG_ADDR_MADDR9,
    },{ .name = "REG_ADDR_MADDR10",  .addr = A_REG_ADDR_MADDR10,
    },{ .name = "REG_ADDR_MADDR11",  .addr = A_REG_ADDR_MADDR11,
    },{ .name = "REG_ADDR_MADDR12",  .addr = A_REG_ADDR_MADDR12,
    },{ .name = "REG_ADDR_MADDR13",  .addr = A_REG_ADDR_MADDR13,
    },{ .name = "REG_ADDR_MADDR14",  .addr = A_REG_ADDR_MADDR14,
    },{ .name = "REG_ADDR_MADDR15",  .addr = A_REG_ADDR_MADDR15,
    },{ .name = "REG_ADDR_MASK0",  .addr = A_REG_ADDR_MASK0,
    },{ .name = "REG_ADDR_MASK1",  .addr = A_REG_ADDR_MASK1,
    },{ .name = "REG_ADDR_MASK2",  .addr = A_REG_ADDR_MASK2,
    },{ .name = "REG_ADDR_MASK3",  .addr = A_REG_ADDR_MASK3,
    },{ .name = "REG_ADDR_MASK4",  .addr = A_REG_ADDR_MASK4,
    },{ .name = "REG_ADDR_MASK5",  .addr = A_REG_ADDR_MASK5,
    },{ .name = "REG_ADDR_MASK6",  .addr = A_REG_ADDR_MASK6,
    },{ .name = "REG_ADDR_MASK7",  .addr = A_REG_ADDR_MASK7,
    },{ .name = "REG_ADDR_MASK8",  .addr = A_REG_ADDR_MASK8,
    },{ .name = "REG_ADDR_MASK9",  .addr = A_REG_ADDR_MASK9,
    },{ .name = "REG_ADDR_MASK10",  .addr = A_REG_ADDR_MASK10,
    },{ .name = "REG_ADDR_MASK11",  .addr = A_REG_ADDR_MASK11,
    },{ .name = "REG_ADDR_MASK12",  .addr = A_REG_ADDR_MASK12,
    },{ .name = "REG_ADDR_MASK13",  .addr = A_REG_ADDR_MASK13,
    },{ .name = "REG_ADDR_MASK14",  .addr = A_REG_ADDR_MASK14,
    },{ .name = "REG_ADDR_MASK15",  .addr = A_REG_ADDR_MASK15,
    },{ .name = "REG_ADDR_RPADDR0",  .addr = A_REG_ADDR_RPADDR0,
    },{ .name = "REG_ADDR_RPADDR1",  .addr = A_REG_ADDR_RPADDR1,
    },{ .name = "REG_ADDR_RPADDR2",  .addr = A_REG_ADDR_RPADDR2,
    },{ .name = "REG_ADDR_RPADDR3",  .addr = A_REG_ADDR_RPADDR3,
    },{ .name = "REG_ADDR_RPADDR4",  .addr = A_REG_ADDR_RPADDR4,
    },{ .name = "REG_ADDR_RPADDR5",  .addr = A_REG_ADDR_RPADDR5,
    },{ .name = "REG_ADDR_RPADDR6",  .addr = A_REG_ADDR_RPADDR6,
    },{ .name = "REG_ADDR_RPADDR7",  .addr = A_REG_ADDR_RPADDR7,
    },{ .name = "REG_ADDR_RPADDR8",  .addr = A_REG_ADDR_RPADDR8,
    },{ .name = "REG_ADDR_RPADDR9",  .addr = A_REG_ADDR_RPADDR9,
    },{ .name = "REG_ADDR_RPADDR10",  .addr = A_REG_ADDR_RPADDR10,
    },{ .name = "REG_ADDR_RPADDR11",  .addr = A_REG_ADDR_RPADDR11,
    },{ .name = "REG_ADDR_RPADDR12",  .addr = A_REG_ADDR_RPADDR12,
    },{ .name = "REG_ADDR_RPADDR13",  .addr = A_REG_ADDR_RPADDR13,
    },{ .name = "REG_ADDR_RPADDR14",  .addr = A_REG_ADDR_RPADDR14,
    },{ .name = "REG_ADDR_RPADDR15",  .addr = A_REG_ADDR_RPADDR15,
    },{ .name = "REG_ADDR_DST0",  .addr = A_REG_ADDR_DST0,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST1",  .addr = A_REG_ADDR_DST1,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST2",  .addr = A_REG_ADDR_DST2,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST3",  .addr = A_REG_ADDR_DST3,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST4",  .addr = A_REG_ADDR_DST4,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST5",  .addr = A_REG_ADDR_DST5,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST6",  .addr = A_REG_ADDR_DST6,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST7",  .addr = A_REG_ADDR_DST7,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST8",  .addr = A_REG_ADDR_DST8,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST9",  .addr = A_REG_ADDR_DST9,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST10",  .addr = A_REG_ADDR_DST10,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST11",  .addr = A_REG_ADDR_DST11,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST12",  .addr = A_REG_ADDR_DST12,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST13",  .addr = A_REG_ADDR_DST13,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST14",  .addr = A_REG_ADDR_DST14,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_DST15",  .addr = A_REG_ADDR_DST15,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_ENABLE",  .addr = A_REG_ADDR_ENABLE,
        .rsvd = 0xffff0000,
    },{ .name = "REG_ADDR_REMAP",  .addr = A_REG_ADDR_REMAP,
        .rsvd = 0xffff0000,
    },{ .name = "REG_MODE_SELECT",  .addr = A_REG_MODE_SELECT,
        .rsvd = 0xffff0008,
        .ro = 0x8,
    },{ .name = "REG_CHOPSIZE",  .addr = A_REG_CHOPSIZE,
        .reset = 0xa,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_HBM_MAP_T0_CH0",  .addr = A_REG_HBM_MAP_T0_CH0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH1",  .addr = A_REG_HBM_MAP_T0_CH1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH2",  .addr = A_REG_HBM_MAP_T0_CH2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH3",  .addr = A_REG_HBM_MAP_T0_CH3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH4",  .addr = A_REG_HBM_MAP_T0_CH4,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH5",  .addr = A_REG_HBM_MAP_T0_CH5,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH6",  .addr = A_REG_HBM_MAP_T0_CH6,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH7",  .addr = A_REG_HBM_MAP_T0_CH7,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH8",  .addr = A_REG_HBM_MAP_T0_CH8,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH9",  .addr = A_REG_HBM_MAP_T0_CH9,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH10",  .addr = A_REG_HBM_MAP_T0_CH10,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH11",  .addr = A_REG_HBM_MAP_T0_CH11,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH12",  .addr = A_REG_HBM_MAP_T0_CH12,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH13",  .addr = A_REG_HBM_MAP_T0_CH13,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH14",  .addr = A_REG_HBM_MAP_T0_CH14,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T0_CH15",  .addr = A_REG_HBM_MAP_T0_CH15,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH0",  .addr = A_REG_HBM_MAP_T1_CH0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH1",  .addr = A_REG_HBM_MAP_T1_CH1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH2",  .addr = A_REG_HBM_MAP_T1_CH2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH3",  .addr = A_REG_HBM_MAP_T1_CH3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH4",  .addr = A_REG_HBM_MAP_T1_CH4,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH5",  .addr = A_REG_HBM_MAP_T1_CH5,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH6",  .addr = A_REG_HBM_MAP_T1_CH6,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH7",  .addr = A_REG_HBM_MAP_T1_CH7,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH8",  .addr = A_REG_HBM_MAP_T1_CH8,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH9",  .addr = A_REG_HBM_MAP_T1_CH9,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH10",  .addr = A_REG_HBM_MAP_T1_CH10,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH11",  .addr = A_REG_HBM_MAP_T1_CH11,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH12",  .addr = A_REG_HBM_MAP_T1_CH12,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH13",  .addr = A_REG_HBM_MAP_T1_CH13,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH14",  .addr = A_REG_HBM_MAP_T1_CH14,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T1_CH15",  .addr = A_REG_HBM_MAP_T1_CH15,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH0",  .addr = A_REG_HBM_MAP_T2_CH0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH1",  .addr = A_REG_HBM_MAP_T2_CH1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH2",  .addr = A_REG_HBM_MAP_T2_CH2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH3",  .addr = A_REG_HBM_MAP_T2_CH3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH4",  .addr = A_REG_HBM_MAP_T2_CH4,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH5",  .addr = A_REG_HBM_MAP_T2_CH5,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH6",  .addr = A_REG_HBM_MAP_T2_CH6,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH7",  .addr = A_REG_HBM_MAP_T2_CH7,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH8",  .addr = A_REG_HBM_MAP_T2_CH8,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH9",  .addr = A_REG_HBM_MAP_T2_CH9,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH10",  .addr = A_REG_HBM_MAP_T2_CH10,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH11",  .addr = A_REG_HBM_MAP_T2_CH11,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH12",  .addr = A_REG_HBM_MAP_T2_CH12,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH13",  .addr = A_REG_HBM_MAP_T2_CH13,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH14",  .addr = A_REG_HBM_MAP_T2_CH14,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T2_CH15",  .addr = A_REG_HBM_MAP_T2_CH15,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH0",  .addr = A_REG_HBM_MAP_T3_CH0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH1",  .addr = A_REG_HBM_MAP_T3_CH1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH2",  .addr = A_REG_HBM_MAP_T3_CH2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH3",  .addr = A_REG_HBM_MAP_T3_CH3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH4",  .addr = A_REG_HBM_MAP_T3_CH4,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH5",  .addr = A_REG_HBM_MAP_T3_CH5,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH6",  .addr = A_REG_HBM_MAP_T3_CH6,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH7",  .addr = A_REG_HBM_MAP_T3_CH7,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH8",  .addr = A_REG_HBM_MAP_T3_CH8,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH9",  .addr = A_REG_HBM_MAP_T3_CH9,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH10",  .addr = A_REG_HBM_MAP_T3_CH10,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH11",  .addr = A_REG_HBM_MAP_T3_CH11,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH12",  .addr = A_REG_HBM_MAP_T3_CH12,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH13",  .addr = A_REG_HBM_MAP_T3_CH13,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH14",  .addr = A_REG_HBM_MAP_T3_CH14,
        .rsvd = 0xfffff000,
    },{ .name = "REG_HBM_MAP_T3_CH15",  .addr = A_REG_HBM_MAP_T3_CH15,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP0",  .addr = A_REG_DDR_DST_MAP0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP1",  .addr = A_REG_DDR_DST_MAP1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP2",  .addr = A_REG_DDR_DST_MAP2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP3",  .addr = A_REG_DDR_DST_MAP3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP4",  .addr = A_REG_DDR_DST_MAP4,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP5",  .addr = A_REG_DDR_DST_MAP5,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP6",  .addr = A_REG_DDR_DST_MAP6,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_DST_MAP7",  .addr = A_REG_DDR_DST_MAP7,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DDR_ADR_MAP0",  .addr = A_REG_DDR_ADR_MAP0,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DDR_ADR_MAP1",  .addr = A_REG_DDR_ADR_MAP1,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DDR_ADR_MAP2",  .addr = A_REG_DDR_ADR_MAP2,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DDR_ADR_MAP3",  .addr = A_REG_DDR_ADR_MAP3,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DDR_ADR_MAP4",  .addr = A_REG_DDR_ADR_MAP4,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DDR_ADR_MAP5",  .addr = A_REG_DDR_ADR_MAP5,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_DDR_ADR_MAP6",  .addr = A_REG_DDR_ADR_MAP6,
        .reset = 0x1000,
        .rsvd = 0xffff8000,
    },{ .name = "REG_ADR_MAP_XPDS",  .addr = A_REG_ADR_MAP_XPDS,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_PMC",  .addr = A_REG_ADR_MAP_PMC,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_PCIE",  .addr = A_REG_ADR_MAP_PCIE,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_CPM",  .addr = A_REG_ADR_MAP_CPM,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_LPD_AFI_FS",  .addr = A_REG_ADR_MAP_LPD_AFI_FS,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_FPD_AFI_0",  .addr = A_REG_ADR_MAP_FPD_AFI_0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_FPD_AFI_1",  .addr = A_REG_ADR_MAP_FPD_AFI_1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_QSPI",  .addr = A_REG_ADR_MAP_QSPI,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_STM_GIC",  .addr = A_REG_ADR_MAP_STM_GIC,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_PMC_ALIAS_0",  .addr = A_REG_ADR_MAP_PMC_ALIAS_0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_PMC_ALIAS_1",  .addr = A_REG_ADR_MAP_PMC_ALIAS_1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_PMC_ALIAS_2",  .addr = A_REG_ADR_MAP_PMC_ALIAS_2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_PMC_ALIAS_3",  .addr = A_REG_ADR_MAP_PMC_ALIAS_3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_ME_ARRAY_0",  .addr = A_REG_ADR_MAP_ME_ARRAY_0,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_ME_ARRAY_1",  .addr = A_REG_ADR_MAP_ME_ARRAY_1,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_ME_ARRAY_2",  .addr = A_REG_ADR_MAP_ME_ARRAY_2,
        .rsvd = 0xfffff000,
    },{ .name = "REG_ADR_MAP_ME_ARRAY_3",  .addr = A_REG_ADR_MAP_ME_ARRAY_3,
        .rsvd = 0xfffff000,
    },{ .name = "REG_SRC",  .addr = A_REG_SRC,
        .rsvd = 0xfffff000,
    },{ .name = "REG_DWIDTH",  .addr = A_REG_DWIDTH,
        .reset = 0x4,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_WBUF_LAUNCH_SIZE",  .addr = A_REG_WBUF_LAUNCH_SIZE,
        .reset = 0x10,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_SMID_SEL",  .addr = A_REG_SMID_SEL,
        .rsvd = 0xfff00000,
    },{ .name = "REG_AXI_NON_MOD_DISABLE",  .addr = A_REG_AXI_NON_MOD_DISABLE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_PRIORITY",  .addr = A_REG_PRIORITY,
        .rsvd = 0xfffffffc,
    },{ .name = "REG_RD_AXPROT_SEL",  .addr = A_REG_RD_AXPROT_SEL,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_WR_AXPROT_SEL",  .addr = A_REG_WR_AXPROT_SEL,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_AXI_PAR_CHK",  .addr = A_REG_AXI_PAR_CHK,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_OUTSTANDING_RD_TXN",  .addr = A_REG_OUTSTANDING_RD_TXN,
        .reset = 0x40,
        .rsvd = 0xffffff80,
    },{ .name = "REG_OUTSTANDING_WR_TXN",  .addr = A_REG_OUTSTANDING_WR_TXN,
        .reset = 0x40,
        .rsvd = 0xffffff80,
    },{ .name = "REG_VC_MAP",  .addr = A_REG_VC_MAP,
        .reset = 0x688,
        .rsvd = 0xfff00000,
    },{ .name = "REG_RPOISON_TO_SLVERR",  .addr = A_REG_RPOISON_TO_SLVERR,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_NOC_DBI",  .addr = A_REG_NOC_DBI,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_RROB_RAM_SETTING",  .addr = A_REG_RROB_RAM_SETTING,
        .reset = 0x12,
        .rsvd = 0xfffffe00,
    },{ .name = "REG_WBUF_RAM_SETTING",  .addr = A_REG_WBUF_RAM_SETTING,
        .reset = 0x12,
        .rsvd = 0xfffffe00,
    },{ .name = "REG_ECC_CHK_EN",  .addr = A_REG_ECC_CHK_EN,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_AXI_LOOPBACK",  .addr = A_REG_AXI_LOOPBACK,
        .rsvd = 0xffffffe0,
    },{ .name = "REG_AXI_REQ_REJECT_ENABLE",
        .addr = A_REG_AXI_REQ_REJECT_ENABLE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_NOC_CLK_GATE_DIS",  .addr = A_REG_NOC_CLK_GATE_DIS,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_FAB_CLK_GATE_DIS",  .addr = A_REG_FAB_CLK_GATE_DIS,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_BUSY",  .addr = A_REG_BUSY,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "REG_1ST_ERR_NUM",  .addr = A_REG_1ST_ERR_NUM,
        .reset = 0x10000,
        .rsvd = 0xff800000,
        .ro = 0x7fffff,
    },{ .name = "REG_1ST_ERR_INFO_0",  .addr = A_REG_1ST_ERR_INFO_0,
        .ro = 0xffffffff,
    },{ .name = "REG_1ST_ERR_INFO_1",  .addr = A_REG_1ST_ERR_INFO_1,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "REG_1ST_ERR_INFO_2",  .addr = A_REG_1ST_ERR_INFO_2,
        .rsvd = 0x80000000,
        .ro = 0x7fffffff,
    },{ .name = "REG_1ST_ERR_INFO_3",  .addr = A_REG_1ST_ERR_INFO_3,
        .ro = 0xffffffff,
    },{ .name = "REG_1ST_ERR_INFO_4",  .addr = A_REG_1ST_ERR_INFO_4,
        .rsvd = 0xf0000000,
        .ro = 0xfffffff,
    },{ .name = "REG_1ST_ERR_INFO_5",  .addr = A_REG_1ST_ERR_INFO_5,
        .ro = 0xffffffff,
    },{ .name = "REG_1ST_ERR_INFO_6",  .addr = A_REG_1ST_ERR_INFO_6,
        .ro = 0xffffffff,
    },{ .name = "REG_1ST_ERR_INFO_7",  .addr = A_REG_1ST_ERR_INFO_7,
        .ro = 0xffffffff,
    },{ .name = "REG_ERR_LOG_EN",  .addr = A_REG_ERR_LOG_EN,
        .reset = 0xbfff,
        .rsvd = 0xffff4000,
        .ro = 0x4000,
    },{ .name = "REG_RD_RATE_CREDIT_DROP",  .addr = A_REG_RD_RATE_CREDIT_DROP,
        .reset = 0x5,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_RD_RATE_CREDIT_LIMIT",  .addr = A_REG_RD_RATE_CREDIT_LIMIT,
        .reset = 0x100,
        .rsvd = 0xffffe000,
    },{ .name = "REG_WR_RATE_CREDIT_DROP",  .addr = A_REG_WR_RATE_CREDIT_DROP,
        .reset = 0x5,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_WR_RATE_CREDIT_LIMIT",  .addr = A_REG_WR_RATE_CREDIT_LIMIT,
        .reset = 0x100,
        .rsvd = 0xffffe000,
    },{ .name = "REG_RD_VCA_TOKEN0",  .addr = A_REG_RD_VCA_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_WR_VCA_TOKEN0",  .addr = A_REG_WR_VCA_TOKEN0,
        .reset = 0x10,
        .rsvd = 0xffffff00,
    },{ .name = "REG_TBASE_MODE_RLIMIT_RD",  .addr = A_REG_TBASE_MODE_RLIMIT_RD,
        .reset = 0x2,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_TBASE_MODE_RLIMIT_WR",  .addr = A_REG_TBASE_MODE_RLIMIT_WR,
        .reset = 0x2,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_TBASE_TRK_TIMEOUT",  .addr = A_REG_TBASE_TRK_TIMEOUT,
        .reset = 0x1,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_TBASE_AXI_TIMEOUT",  .addr = A_REG_TBASE_AXI_TIMEOUT,
        .reset = 0x1,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_PERF_MON_TBASE",  .addr = A_REG_PERF_MON_TBASE,
        .reset = 0x3,
        .rsvd = 0xffffff00,
    },{ .name = "REG_PERF_MON0_LATENCY_MIN",
        .addr = A_REG_PERF_MON0_LATENCY_MIN,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON0_LATENCY_MAX",
        .addr = A_REG_PERF_MON0_LATENCY_MAX,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON0_LATENCY_ACC_UPR",
        .addr = A_REG_PERF_MON0_LATENCY_ACC_UPR,
        .rsvd = 0xffffff00,
    },{ .name = "REG_PERF_MON0_LATENCY_ACC_LWR",
        .addr = A_REG_PERF_MON0_LATENCY_ACC_LWR,
    },{ .name = "REG_PERF_MON0_BURST_CNT",  .addr = A_REG_PERF_MON0_BURST_CNT,
    },{ .name = "REG_PERF_MON0_CNT_AND_OFL",
        .addr = A_REG_PERF_MON0_CNT_AND_OFL,
        .rsvd = 0xffffe000,
    },{ .name = "REG_PERF_MON0_BYTE_CNT_LWR",
        .addr = A_REG_PERF_MON0_BYTE_CNT_LWR,
    },{ .name = "REG_PERF_MON0_CTRL",  .addr = A_REG_PERF_MON0_CTRL,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_PERF_MON1_LATENCY_MIN",
        .addr = A_REG_PERF_MON1_LATENCY_MIN,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON1_LATENCY_MAX",
        .addr = A_REG_PERF_MON1_LATENCY_MAX,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_MON1_LATENCY_ACC_UPR",
        .addr = A_REG_PERF_MON1_LATENCY_ACC_UPR,
        .rsvd = 0xffffff00,
    },{ .name = "REG_PERF_MON1_LATENCY_ACC_LWR",
        .addr = A_REG_PERF_MON1_LATENCY_ACC_LWR,
    },{ .name = "REG_PERF_MON1_BURST_CNT",  .addr = A_REG_PERF_MON1_BURST_CNT,
    },{ .name = "REG_PERF_MON1_CNT_AND_OFL",
        .addr = A_REG_PERF_MON1_CNT_AND_OFL,
        .rsvd = 0xffffe000,
    },{ .name = "REG_PERF_MON1_BYTE_CNT_LWR",
        .addr = A_REG_PERF_MON1_BYTE_CNT_LWR,
    },{ .name = "REG_PERF_MON1_CTRL",  .addr = A_REG_PERF_MON1_CTRL,
        .reset = 0xe,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_PERF_FLT0_CMP_S0",  .addr = A_REG_PERF_FLT0_CMP_S0,
    },{ .name = "REG_PERF_FLT0_CMP_S1",  .addr = A_REG_PERF_FLT0_CMP_S1,
        .rsvd = 0x80000000,
    },{ .name = "REG_PERF_FLT0_CMP_S2",  .addr = A_REG_PERF_FLT0_CMP_S2,
        .rsvd = 0xffff8000,
    },{ .name = "REG_PERF_FLT0_CMP_EN",  .addr = A_REG_PERF_FLT0_CMP_EN,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PERF_FLT1_CMP_S0",  .addr = A_REG_PERF_FLT1_CMP_S0,
    },{ .name = "REG_PERF_FLT1_CMP_S1",  .addr = A_REG_PERF_FLT1_CMP_S1,
        .rsvd = 0x80000000,
    },{ .name = "REG_PERF_FLT1_CMP_S2",  .addr = A_REG_PERF_FLT1_CMP_S2,
        .rsvd = 0xffff8000,
    },{ .name = "REG_PERF_FLT1_CMP_EN",  .addr = A_REG_PERF_FLT1_CMP_EN,
        .rsvd = 0xfffffc00,
    },{ .name = "REG_PENDING_BURST",  .addr = A_REG_PENDING_BURST,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "REG_DST_TFC_CHK_CTRL",  .addr = A_REG_DST_TFC_CHK_CTRL,
        .reset = 0x1000,
        .rsvd = 0xffffe000,
    },{ .name = "REG_DST_TFC_CHK_STAT",  .addr = A_REG_DST_TFC_CHK_STAT,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "REG_ERR_INJ_MODE",  .addr = A_REG_ERR_INJ_MODE,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ERR_INJ_EN",  .addr = A_REG_ERR_INJ_EN,
        .rsvd = 0xff80,
        .ro = 0xff80,
    },{ .name = "REG_ERR_INJ_INDEX_0",  .addr = A_REG_ERR_INJ_INDEX_0,
        .rsvd = 0xe0000000,
    },{ .name = "REG_ERR_INJ_INDEX_1",  .addr = A_REG_ERR_INJ_INDEX_1,
        .rsvd = 0xfffffff0,
    },{ .name = "REG_ERR_INJ_STAT",  .addr = A_REG_ERR_INJ_STAT,
        .rsvd = 0xffffff80,
        .ro = 0x7f,
    },{ .name = "REG_2ND_ERR",  .addr = A_REG_2ND_ERR,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "REG_MBIST_STAT",  .addr = A_REG_MBIST_STAT,
        .reset = R_REG_MBIST_STAT_DONE_MASK,
        .rsvd = 0xfffffffc,
        .ro = 0x3,
    },{ .name = "REG_DBG_MUX_SEL",  .addr = A_REG_DBG_MUX_SEL,
        .rsvd = 0xfffffc00,
        .ro = 0x200,
    },{ .name = "REG_DBG_DATA_SEL",  .addr = A_REG_DBG_DATA_SEL,
        .rsvd = 0xffffffc0,
    },{ .name = "REG_DBG_TRIG_MVAL_L",  .addr = A_REG_DBG_TRIG_MVAL_L,
    },{ .name = "REG_DBG_TRIG_MVAL_U",  .addr = A_REG_DBG_TRIG_MVAL_U,
    },{ .name = "REG_DBG_TRIG_MASK_L",  .addr = A_REG_DBG_TRIG_MASK_L,
    },{ .name = "REG_DBG_TRIG_MASK_U",  .addr = A_REG_DBG_TRIG_MASK_U,
    },{ .name = "REG_DYN_PROG_DIS",  .addr = A_REG_DYN_PROG_DIS,
        .reset = 0x7,
        .rsvd = 0xfffffff8,
    },{ .name = "REG_SPARE",  .addr = A_REG_SPARE,
    }
};

static void noc_nmu_reset(DeviceState *dev)
{
    NOC_NMU *s = XILINX_NOC_NMU(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps noc_nmu_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void noc_nmu_init(Object *obj)
{
    NOC_NMU *s = XILINX_NOC_NMU(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);

    s->reg_array =
        register_init_block32(DEVICE(obj), noc_nmu_regs_info,
                              ARRAY_SIZE(noc_nmu_regs_info),
                              s->regs_info, s->regs,
                              &noc_nmu_ops,
                              XILINX_NOC_NMU_ERR_DEBUG,
                              NOC_NMU_R_MAX * 4);
    sysbus_init_mmio(sbd, &s->reg_array->mem);
}

static const VMStateDescription vmstate_noc_nmu = {
    .name = TYPE_XILINX_NOC_NMU,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, NOC_NMU, NOC_NMU_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void noc_nmu_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = noc_nmu_reset;
    dc->vmsd = &vmstate_noc_nmu;
}

static const TypeInfo noc_nmu_info = {
    .name          = TYPE_XILINX_NOC_NMU,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(NOC_NMU),
    .class_init    = noc_nmu_class_init,
    .instance_init = noc_nmu_init,
};

static void noc_nmu_register_types(void)
{
    type_register_static(&noc_nmu_info);
}

type_init(noc_nmu_register_types)
