/*
 * QEMU model of the NOC NPI Device
 *
 * Copyright (c) 2021 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_NOC_NPI_DEV_ERR_DEBUG
#define XILINX_NOC_NPI_DEV_ERR_DEBUG 0
#endif

#define TYPE_XILINX_NOC_NPI_DEV "xlnx.noc-npi-dev"

#define XILINX_NOC_NPI_DEV(obj) \
     OBJECT_CHECK(NOC_NPI_DEV, (obj), TYPE_XILINX_NOC_NPI_DEV)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, NIDB_DCC_EN, 25, 1)
    FIELD(REG_PCSR_MASK, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE, 2, 4)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, NIDB_DCC_EN, 25, 1)
    FIELD(REG_PCSR_CONTROL, NOC_RST_MASK, 24, 1)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE, 2, 4)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, REMOTE_LINK_READY, 18, 1)
    FIELD(REG_PCSR_STATUS, LOCAL_LINK_READY, 17, 1)
    FIELD(REG_PCSR_STATUS, DCC_READY, 16, 1)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_CLOCK_MUX, 0x10)

#define NOC_NPI_DEV_R_MAX (8)
#define NOC_BLOCK_MASK (0x200 - 1)
#define LOCK_VAL 0xF9E8D7C6

typedef struct NOC_NPI_DEV {
    SysBusDevice parent_obj;
    RegisterInfoArray *reg_array;
    uint64_t map_size;
    bool custom;
    uint32_t pcsr_status;

    uint32_t regs[NOC_NPI_DEV_R_MAX];
    RegisterInfo regs_info[NOC_NPI_DEV_R_MAX];
} NOC_NPI_DEV;

static void noc_npi_dev_lock_postw(RegisterInfo *reg, uint64_t val64)
{
    NOC_NPI_DEV *s = XILINX_NOC_NPI_DEV(reg->opaque);
    bool locked = val64 != LOCK_VAL;

    ARRAY_FIELD_DP32(s->regs, REG_PCSR_STATUS, PCSRLOCK, locked);
}

static const RegisterAccessInfo noc_npi_dev_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xfee47f00,
        .ro = 0xe47f00,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1000000,
        .rsvd = 0xfee47f00,
        .ro = 0xe47f00,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = R_REG_PCSR_STATUS_PCSRLOCK_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_CALDONE_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK \
                 | R_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK \
                 | R_REG_PCSR_STATUS_DCC_READY_MASK \
                 | R_REG_PCSR_STATUS_LOCAL_LINK_READY_MASK \
                 | R_REG_PCSR_STATUS_REMOTE_LINK_READY_MASK,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = noc_npi_dev_lock_postw
    }
};

static const RegisterAccessInfo noc_npi_dev_custom_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1000000,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .post_write = noc_npi_dev_lock_postw
    }
};

static void noc_npi_dev_reset(DeviceState *dev)
{
    NOC_NPI_DEV *s = XILINX_NOC_NPI_DEV(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    if (s->custom) {
        s->regs[R_REG_PCSR_STATUS] = s->pcsr_status;
    }
}

static uint64_t noc_npi_dev_read(void *opaque, hwaddr addr,

                              unsigned size)
{
     uint32_t offset;

     offset = addr & NOC_BLOCK_MASK;
     return register_read_memory(opaque, offset, size);
}

static void noc_npi_dev_write(void *opaque, hwaddr addr,
                           uint64_t value, unsigned size)
{
     uint32_t offset;

     offset = addr & NOC_BLOCK_MASK;
     register_write_memory(opaque, offset, value, size);
}

static const MemoryRegionOps noc_npi_dev_ops = {
    .read = noc_npi_dev_read,
    .write = noc_npi_dev_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 1,
        .max_access_size = 4,
    },
};

static void noc_npi_dev_realize(DeviceState *dev, Error **errp)
{
    NOC_NPI_DEV *s = XILINX_NOC_NPI_DEV(dev);
    SysBusDevice *sbd = SYS_BUS_DEVICE(dev);

    if (s->custom) {
        s->reg_array =
        register_init_block32(dev, noc_npi_dev_custom_regs_info,
                              ARRAY_SIZE(noc_npi_dev_custom_regs_info),
                              s->regs_info, s->regs,
                              &noc_npi_dev_ops,
                              XILINX_NOC_NPI_DEV_ERR_DEBUG,
                              s->custom ? NOC_NPI_DEV_R_MAX * 4 : s->map_size);
    } else {
        s->reg_array =
        register_init_block32(dev, noc_npi_dev_regs_info,
                              ARRAY_SIZE(noc_npi_dev_regs_info),
                              s->regs_info, s->regs,
                              &noc_npi_dev_ops,
                              XILINX_NOC_NPI_DEV_ERR_DEBUG,
                              s->custom ? NOC_NPI_DEV_R_MAX * 4 : s->map_size);
    }
    sysbus_init_mmio(sbd, &s->reg_array->mem);
}

static const VMStateDescription vmstate_noc_npi_dev = {
    .name = TYPE_XILINX_NOC_NPI_DEV,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, NOC_NPI_DEV, NOC_NPI_DEV_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static Property noc_npi_dev_prop[] = {
    DEFINE_PROP_UINT64("map-size", NOC_NPI_DEV, map_size, 0x2000000),
    DEFINE_PROP_BOOL("custom", NOC_NPI_DEV, custom, false),
    DEFINE_PROP_UINT32("pcsr-status", NOC_NPI_DEV, pcsr_status, 0x700d7),
    DEFINE_PROP_END_OF_LIST(),
};

static void noc_npi_dev_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = noc_npi_dev_reset;
    dc->vmsd = &vmstate_noc_npi_dev;
    dc->realize = noc_npi_dev_realize;
    device_class_set_props(dc, noc_npi_dev_prop);
}

static const TypeInfo noc_npi_dev_info = {
    .name          = TYPE_XILINX_NOC_NPI_DEV,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(NOC_NPI_DEV),
    .class_init    = noc_npi_dev_class_init,
};

static void noc_npi_dev_register_types(void)
{
    type_register_static(&noc_npi_dev_info);
}

type_init(noc_npi_dev_register_types)
