/*
 * QEMU model of the Xilinx Versal PMC System Monitor
 *
 * Copyright (c) 2020 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2020-12-07.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "hw/irq.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "qemu/timer.h"
#include "qapi/error.h"
#include "qemu/error-report.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"
#include "hw/nvram/xlnx-efuse.h"
#include "hw/nvram/xlnx-versal-efuse.h"
#include "hw/nvram/xlnx-pmx-efuse.h"
#include "xlnx-versal-ams.h"

#include <math.h>

#ifndef PMC_SYSMON_ERR_DEBUG
#define PMC_SYSMON_ERR_DEBUG 0
#endif

#define TYPE_PMC_SYSMON "xlnx,pmc-sysmon"

#define PMC_SYSMON(obj) \
     OBJECT_CHECK(PMCSysMon, (obj), TYPE_PMC_SYSMON)

REG32(REG_PCSR_MASK, 0x0)
    FIELD(REG_PCSR_MASK, SPARE, 25, 7)
    FIELD(REG_PCSR_MASK, SECURE_EFUSE_START, 24, 1)
    FIELD(REG_PCSR_MASK, PCSR_RESERVED, 21, 3)
    FIELD(REG_PCSR_MASK, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_MASK, SLVERREN, 19, 1)
    FIELD(REG_PCSR_MASK, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_MASK, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_MASK, PWRDN, 14, 1)
    FIELD(REG_PCSR_MASK, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_MASK, APBEN, 12, 1)
    FIELD(REG_PCSR_MASK, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(REG_PCSR_MASK, STARTCAL, 10, 1)
    FIELD(REG_PCSR_MASK, FABRICEN, 9, 1)
    FIELD(REG_PCSR_MASK, TRISTATE, 8, 1)
    FIELD(REG_PCSR_MASK, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_MASK, INITSTATE, 6, 1)
    FIELD(REG_PCSR_MASK, ODISABLE, 2, 4)
    FIELD(REG_PCSR_MASK, GATEREG, 1, 1)
    FIELD(REG_PCSR_MASK, PCOMPLETE, 0, 1)
REG32(REG_PCSR_CONTROL, 0x4)
    FIELD(REG_PCSR_CONTROL, SPARE, 25, 7)
    FIELD(REG_PCSR_CONTROL, SECURE_EFUSE_START, 24, 1)
    FIELD(REG_PCSR_CONTROL, PCSR_RESERVED, 21, 3)
    FIELD(REG_PCSR_CONTROL, TEST_SAFE, 20, 1)
    FIELD(REG_PCSR_CONTROL, SLVERREN, 19, 1)
    FIELD(REG_PCSR_CONTROL, MEM_CLEAR_TRIGGER, 18, 1)
    FIELD(REG_PCSR_CONTROL, SYS_RST_MASK, 15, 3)
    FIELD(REG_PCSR_CONTROL, PWRDN, 14, 1)
    FIELD(REG_PCSR_CONTROL, DISNPICLK, 13, 1)
    FIELD(REG_PCSR_CONTROL, APBEN, 12, 1)
    FIELD(REG_PCSR_CONTROL, SCAN_CLEAR_TRIGGER, 11, 1)
    FIELD(REG_PCSR_CONTROL, STARTCAL, 10, 1)
    FIELD(REG_PCSR_CONTROL, FABRICEN, 9, 1)
    FIELD(REG_PCSR_CONTROL, TRISTATE, 8, 1)
    FIELD(REG_PCSR_CONTROL, HOLDSTATE, 7, 1)
    FIELD(REG_PCSR_CONTROL, INITSTATE, 6, 1)
    FIELD(REG_PCSR_CONTROL, ODISABLE, 2, 4)
    FIELD(REG_PCSR_CONTROL, GATEREG, 1, 1)
    FIELD(REG_PCSR_CONTROL, PCOMPLETE, 0, 1)
REG32(REG_PCSR_STATUS, 0x8)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_OR, 11, 3)
    FIELD(REG_PCSR_STATUS, HARD_FAIL_AND, 8, 3)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_PASS, 7, 1)
    FIELD(REG_PCSR_STATUS, MEM_CLEAR_DONE, 6, 1)
    FIELD(REG_PCSR_STATUS, CALERROR, 5, 1)
    FIELD(REG_PCSR_STATUS, CALDONE, 4, 1)
    FIELD(REG_PCSR_STATUS, INCAL, 3, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_PASS, 2, 1)
    FIELD(REG_PCSR_STATUS, SCAN_CLEAR_DONE, 1, 1)
    FIELD(REG_PCSR_STATUS, PCSRLOCK, 0, 1)
REG32(REG_PCSR_LOCK, 0xc)
    FIELD(REG_PCSR_LOCK, STATE, 0, 1)
REG32(REG_ITR, 0x40)
    FIELD(REG_ITR, SSC_OVERFLOW, 31, 1)
    FIELD(REG_ITR, AXI_TIMEOUT, 30, 1)
    FIELD(REG_ITR, EXT_REF_DOWN, 29, 1)
    FIELD(REG_ITR, GOQ_DONE, 28, 1)
    FIELD(REG_ITR, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_ITR, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_ITR, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_ITR, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_ITR, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_ITR, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_ITR, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_ITR, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_ITR, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_ITR, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_ITR, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_ITR, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_ITR, NEW_DATA3, 15, 1)
    FIELD(REG_ITR, NEW_DATA2, 14, 1)
    FIELD(REG_ITR, NEW_DATA1, 13, 1)
    FIELD(REG_ITR, NEW_DATA0, 12, 1)
    FIELD(REG_ITR, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_ITR, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_ITR, TEMP, 9, 1)
    FIELD(REG_ITR, OT, 8, 1)
    FIELD(REG_ITR, ALARM7, 7, 1)
    FIELD(REG_ITR, ALARM6, 6, 1)
    FIELD(REG_ITR, ALARM5, 5, 1)
    FIELD(REG_ITR, ALARM4, 4, 1)
    FIELD(REG_ITR, ALARM3, 3, 1)
    FIELD(REG_ITR, ALARM2, 2, 1)
    FIELD(REG_ITR, ALARM1, 1, 1)
    FIELD(REG_ITR, ALARM0, 0, 1)
REG32(REG_ISR, 0x44)
    FIELD(REG_ISR, SSC_OVERFLOW, 31, 1)
    FIELD(REG_ISR, AXI_TIMEOUT, 30, 1)
    FIELD(REG_ISR, EXT_REF_DOWN, 29, 1)
    FIELD(REG_ISR, GOQ_DONE, 28, 1)
    FIELD(REG_ISR, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_ISR, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_ISR, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_ISR, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_ISR, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_ISR, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_ISR, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_ISR, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_ISR, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_ISR, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_ISR, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_ISR, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_ISR, NEW_DATA3, 15, 1)
    FIELD(REG_ISR, NEW_DATA2, 14, 1)
    FIELD(REG_ISR, NEW_DATA1, 13, 1)
    FIELD(REG_ISR, NEW_DATA0, 12, 1)
    FIELD(REG_ISR, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_ISR, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_ISR, TEMP, 9, 1)
    FIELD(REG_ISR, OT, 8, 1)
    FIELD(REG_ISR, ALARM7, 7, 1)
    FIELD(REG_ISR, ALARM6, 6, 1)
    FIELD(REG_ISR, ALARM5, 5, 1)
    FIELD(REG_ISR, ALARM4, 4, 1)
    FIELD(REG_ISR, ALARM3, 3, 1)
    FIELD(REG_ISR, ALARM2, 2, 1)
    FIELD(REG_ISR, ALARM1, 1, 1)
    FIELD(REG_ISR, ALARM0, 0, 1)
REG32(REG_IMR0, 0x48)
    FIELD(REG_IMR0, SSC_OVERFLOW, 31, 1)
    FIELD(REG_IMR0, AXI_TIMEOUT, 30, 1)
    FIELD(REG_IMR0, EXT_REF_DOWN, 29, 1)
    FIELD(REG_IMR0, GOQ_DONE, 28, 1)
    FIELD(REG_IMR0, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_IMR0, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_IMR0, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_IMR0, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_IMR0, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_IMR0, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_IMR0, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_IMR0, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_IMR0, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_IMR0, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_IMR0, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_IMR0, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_IMR0, NEW_DATA3, 15, 1)
    FIELD(REG_IMR0, NEW_DATA2, 14, 1)
    FIELD(REG_IMR0, NEW_DATA1, 13, 1)
    FIELD(REG_IMR0, NEW_DATA0, 12, 1)
    FIELD(REG_IMR0, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_IMR0, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_IMR0, TEMP, 9, 1)
    FIELD(REG_IMR0, OT, 8, 1)
    FIELD(REG_IMR0, ALARM7, 7, 1)
    FIELD(REG_IMR0, ALARM6, 6, 1)
    FIELD(REG_IMR0, ALARM5, 5, 1)
    FIELD(REG_IMR0, ALARM4, 4, 1)
    FIELD(REG_IMR0, ALARM3, 3, 1)
    FIELD(REG_IMR0, ALARM2, 2, 1)
    FIELD(REG_IMR0, ALARM1, 1, 1)
    FIELD(REG_IMR0, ALARM0, 0, 1)
REG32(REG_IER0, 0x4c)
    FIELD(REG_IER0, SSC_OVERFLOW, 31, 1)
    FIELD(REG_IER0, AXI_TIMEOUT, 30, 1)
    FIELD(REG_IER0, EXT_REF_DOWN, 29, 1)
    FIELD(REG_IER0, GOQ_DONE, 28, 1)
    FIELD(REG_IER0, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_IER0, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_IER0, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_IER0, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_IER0, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_IER0, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_IER0, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_IER0, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_IER0, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_IER0, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_IER0, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_IER0, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_IER0, NEW_DATA3, 15, 1)
    FIELD(REG_IER0, NEW_DATA2, 14, 1)
    FIELD(REG_IER0, NEW_DATA1, 13, 1)
    FIELD(REG_IER0, NEW_DATA0, 12, 1)
    FIELD(REG_IER0, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_IER0, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_IER0, TEMP, 9, 1)
    FIELD(REG_IER0, OT, 8, 1)
    FIELD(REG_IER0, ALARM7, 7, 1)
    FIELD(REG_IER0, ALARM6, 6, 1)
    FIELD(REG_IER0, ALARM5, 5, 1)
    FIELD(REG_IER0, ALARM4, 4, 1)
    FIELD(REG_IER0, ALARM3, 3, 1)
    FIELD(REG_IER0, ALARM2, 2, 1)
    FIELD(REG_IER0, ALARM1, 1, 1)
    FIELD(REG_IER0, ALARM0, 0, 1)
REG32(REG_IDR0, 0x50)
    FIELD(REG_IDR0, SSC_OVERFLOW, 31, 1)
    FIELD(REG_IDR0, AXI_TIMEOUT, 30, 1)
    FIELD(REG_IDR0, EXT_REF_DOWN, 29, 1)
    FIELD(REG_IDR0, GOQ_DONE, 28, 1)
    FIELD(REG_IDR0, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_IDR0, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_IDR0, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_IDR0, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_IDR0, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_IDR0, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_IDR0, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_IDR0, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_IDR0, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_IDR0, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_IDR0, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_IDR0, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_IDR0, NEW_DATA3, 15, 1)
    FIELD(REG_IDR0, NEW_DATA2, 14, 1)
    FIELD(REG_IDR0, NEW_DATA1, 13, 1)
    FIELD(REG_IDR0, NEW_DATA0, 12, 1)
    FIELD(REG_IDR0, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_IDR0, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_IDR0, TEMP, 9, 1)
    FIELD(REG_IDR0, OT, 8, 1)
    FIELD(REG_IDR0, ALARM7, 7, 1)
    FIELD(REG_IDR0, ALARM6, 6, 1)
    FIELD(REG_IDR0, ALARM5, 5, 1)
    FIELD(REG_IDR0, ALARM4, 4, 1)
    FIELD(REG_IDR0, ALARM3, 3, 1)
    FIELD(REG_IDR0, ALARM2, 2, 1)
    FIELD(REG_IDR0, ALARM1, 1, 1)
    FIELD(REG_IDR0, ALARM0, 0, 1)
REG32(REG_IMR1, 0x54)
    FIELD(REG_IMR1, SSC_OVERFLOW, 31, 1)
    FIELD(REG_IMR1, AXI_TIMEOUT, 30, 1)
    FIELD(REG_IMR1, EXT_REF_DOWN, 29, 1)
    FIELD(REG_IMR1, GOQ_DONE, 28, 1)
    FIELD(REG_IMR1, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_IMR1, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_IMR1, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_IMR1, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_IMR1, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_IMR1, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_IMR1, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_IMR1, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_IMR1, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_IMR1, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_IMR1, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_IMR1, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_IMR1, NEW_DATA3, 15, 1)
    FIELD(REG_IMR1, NEW_DATA2, 14, 1)
    FIELD(REG_IMR1, NEW_DATA1, 13, 1)
    FIELD(REG_IMR1, NEW_DATA0, 12, 1)
    FIELD(REG_IMR1, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_IMR1, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_IMR1, TEMP, 9, 1)
    FIELD(REG_IMR1, OT, 8, 1)
    FIELD(REG_IMR1, ALARM7, 7, 1)
    FIELD(REG_IMR1, ALARM6, 6, 1)
    FIELD(REG_IMR1, ALARM5, 5, 1)
    FIELD(REG_IMR1, ALARM4, 4, 1)
    FIELD(REG_IMR1, ALARM3, 3, 1)
    FIELD(REG_IMR1, ALARM2, 2, 1)
    FIELD(REG_IMR1, ALARM1, 1, 1)
    FIELD(REG_IMR1, ALARM0, 0, 1)
REG32(REG_IER1, 0x58)
    FIELD(REG_IER1, SSC_OVERFLOW, 31, 1)
    FIELD(REG_IER1, AXI_TIMEOUT, 30, 1)
    FIELD(REG_IER1, EXT_REF_DOWN, 29, 1)
    FIELD(REG_IER1, GOQ_DONE, 28, 1)
    FIELD(REG_IER1, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_IER1, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_IER1, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_IER1, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_IER1, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_IER1, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_IER1, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_IER1, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_IER1, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_IER1, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_IER1, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_IER1, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_IER1, NEW_DATA3, 15, 1)
    FIELD(REG_IER1, NEW_DATA2, 14, 1)
    FIELD(REG_IER1, NEW_DATA1, 13, 1)
    FIELD(REG_IER1, NEW_DATA0, 12, 1)
    FIELD(REG_IER1, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_IER1, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_IER1, TEMP, 9, 1)
    FIELD(REG_IER1, OT, 8, 1)
    FIELD(REG_IER1, ALARM7, 7, 1)
    FIELD(REG_IER1, ALARM6, 6, 1)
    FIELD(REG_IER1, ALARM5, 5, 1)
    FIELD(REG_IER1, ALARM4, 4, 1)
    FIELD(REG_IER1, ALARM3, 3, 1)
    FIELD(REG_IER1, ALARM2, 2, 1)
    FIELD(REG_IER1, ALARM1, 1, 1)
    FIELD(REG_IER1, ALARM0, 0, 1)
REG32(REG_IDR1, 0x5c)
    FIELD(REG_IDR1, SSC_OVERFLOW, 31, 1)
    FIELD(REG_IDR1, AXI_TIMEOUT, 30, 1)
    FIELD(REG_IDR1, EXT_REF_DOWN, 29, 1)
    FIELD(REG_IDR1, GOQ_DONE, 28, 1)
    FIELD(REG_IDR1, AXI_ERROR_RESPONSE, 27, 1)
    FIELD(REG_IDR1, AXI_BUFF_OVERFLOW, 26, 1)
    FIELD(REG_IDR1, SSC_VREF_CORRUPT4, 25, 1)
    FIELD(REG_IDR1, SSC_VREF_CORRUPT3, 24, 1)
    FIELD(REG_IDR1, SSC_VREF_CORRUPT2, 23, 1)
    FIELD(REG_IDR1, SSC_VREF_CORRUPT1, 22, 1)
    FIELD(REG_IDR1, SSC_VREF_CORRUPT0, 21, 1)
    FIELD(REG_IDR1, SSC_MRKR_CORRUPT4, 20, 1)
    FIELD(REG_IDR1, SSC_MRKR_CORRUPT3, 19, 1)
    FIELD(REG_IDR1, SSC_MRKR_CORRUPT2, 18, 1)
    FIELD(REG_IDR1, SSC_MRKR_CORRUPT1, 17, 1)
    FIELD(REG_IDR1, SSC_MRKR_CORRUPT0, 16, 1)
    FIELD(REG_IDR1, NEW_DATA3, 15, 1)
    FIELD(REG_IDR1, NEW_DATA2, 14, 1)
    FIELD(REG_IDR1, NEW_DATA1, 13, 1)
    FIELD(REG_IDR1, NEW_DATA0, 12, 1)
    FIELD(REG_IDR1, SECURE_EFUSE_DONE, 11, 1)
    FIELD(REG_IDR1, SECURE_EFUSE_ERROR, 10, 1)
    FIELD(REG_IDR1, TEMP, 9, 1)
    FIELD(REG_IDR1, OT, 8, 1)
    FIELD(REG_IDR1, ALARM7, 7, 1)
    FIELD(REG_IDR1, ALARM6, 6, 1)
    FIELD(REG_IDR1, ALARM5, 5, 1)
    FIELD(REG_IDR1, ALARM4, 4, 1)
    FIELD(REG_IDR1, ALARM3, 3, 1)
    FIELD(REG_IDR1, ALARM2, 2, 1)
    FIELD(REG_IDR1, ALARM1, 1, 1)
    FIELD(REG_IDR1, ALARM0, 0, 1)
REG32(REG_IOR, 0x60)
    FIELD(REG_IOR, OFFSET, 0, 5)
REG32(CONFIG0, 0x100)
    FIELD(CONFIG0, TEMP_AVERAGE, 24, 4)
    FIELD(CONFIG0, RESERVED2, 23, 1)
    FIELD(CONFIG0, TEMP_ALARM_WINDOW_EN, 22, 1)
    FIELD(CONFIG0, AVERAGE, 14, 4)
    FIELD(CONFIG0, RESERVED1, 10, 4)
    FIELD(CONFIG0, I2C_NOT_PMBUS, 9, 1)
    FIELD(CONFIG0, PMBUS_UNRESTRICTED, 8, 1)
    FIELD(CONFIG0, PMBUS_ENABLE, 7, 1)
    FIELD(CONFIG0, PMBUS_ADDRESS, 0, 7)
REG32(TOKEN_MNGR, 0x104)
    FIELD(TOKEN_MNGR, BYPASS_PL, 20, 1)
    FIELD(TOKEN_MNGR, BYPASS_LPD, 19, 1)
    FIELD(TOKEN_MNGR, BYPASS_FPD, 18, 1)
    FIELD(TOKEN_MNGR, BYPASS_SAT1, 17, 1)
    FIELD(TOKEN_MNGR, BYPASS_SAT0, 16, 1)
    FIELD(TOKEN_MNGR, CTRL_TOKEN_COUNT, 8, 8)
    FIELD(TOKEN_MNGR, VREF_TOKEN_COUNT, 0, 8)
REG32(VREF_SSC_COUNT1, 0x108)
    FIELD(VREF_SSC_COUNT1, VAL, 0, 18)
REG32(VREF_SSC_COUNT2, 0x10c)
    FIELD(VREF_SSC_COUNT2, VAL, 0, 18)
REG32(VREF_SSC_COUNT3, 0x110)
    FIELD(VREF_SSC_COUNT3, VAL, 0, 18)
REG32(VREF_SSC_COUNT4, 0x114)
    FIELD(VREF_SSC_COUNT4, VAL, 0, 18)
REG32(GOQ_CONFIG, 0x118)
    FIELD(GOQ_CONFIG, VDAC_SEL, 9, 7)
    FIELD(GOQ_CONFIG, EN_RCAL, 8, 1)
    FIELD(GOQ_CONFIG, NUM_HITS, 1, 7)
    FIELD(GOQ_CONFIG, GOQ_MODE, 0, 1)
REG32(METAL_OPTION_OVERRIDES, 0x11c)
    FIELD(METAL_OPTION_OVERRIDES, MO_BYPASS_EN, 25, 1)
    FIELD(METAL_OPTION_OVERRIDES, MO_CUR_COR_EN_B, 24, 1)
    FIELD(METAL_OPTION_OVERRIDES, MO_VREF_CURVE_COR, 8, 16)
    FIELD(METAL_OPTION_OVERRIDES, MO_SPARE, 0, 8)
REG32(GREF_MODE_SETTING, 0x120)
    FIELD(GREF_MODE_SETTING, FABRIC_MODE, 10, 1)
    FIELD(GREF_MODE_SETTING, SECURE_MODE, 9, 1)
    FIELD(GREF_MODE_SETTING, TRIM_MODE, 8, 1)
    FIELD(GREF_MODE_SETTING, TRIM, 4, 4)
    FIELD(GREF_MODE_SETTING, GOQ, 0, 4)
REG32(AXI_BUFFER_BASE_HIGH, 0x124)
REG32(AXI_BUFFER_OFFSET, 0x128)
    FIELD(AXI_BUFFER_OFFSET, LAST, 16, 16)
    FIELD(AXI_BUFFER_OFFSET, FIRST, 0, 16)
REG32(TEST_ANA_CTRL0, 0x134)
REG32(TEST_ANA_CTRL1, 0x138)
REG32(TEST_REG0, 0x13c)
    FIELD(TEST_REG0, FABRIC_SEL_REG, 0, 2)
REG32(DFX_REG0, 0x15c)
    FIELD(DFX_REG0, DFX_CSSD_TRIG, 0, 2)
REG32(EFUSE_REG0, 0x16c)
REG32(EFUSE_REG1, 0x170)
REG32(EFUSE_REG2, 0x174)
REG32(EFUSE_REG3, 0x178)
    FIELD(EFUSE_REG3, VAL, 0, 19)
REG32(REG_IXPCM_CONF_READY, 0x17c)
    FIELD(REG_IXPCM_CONF_READY, VALUE, 0, 1)
REG32(REG_IXPCM_CONF, 0x180)
    FIELD(REG_IXPCM_CONF, RADDR_IXPCM, 8, 9)
    FIELD(REG_IXPCM_CONF, DELAY, 2, 6)
    FIELD(REG_IXPCM_CONF, MODE, 1, 1)
    FIELD(REG_IXPCM_CONF, ENABLE, 0, 1)
REG32(REG_IXPCM_MEAS_CONF_0, 0x184)
    FIELD(REG_IXPCM_MEAS_CONF_0, SPARE, 27, 5)
    FIELD(REG_IXPCM_MEAS_CONF_0, VDAC1_CODE, 20, 7)
    FIELD(REG_IXPCM_MEAS_CONF_0, VDAC2_CODE, 13, 7)
    FIELD(REG_IXPCM_MEAS_CONF_0, VDAC_REF, 12, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_SENSE_RIDSAT_B, 11, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_SENSE_RIDSAT_A, 10, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_RIDSAT_B, 9, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_RIDSAT_A, 8, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_IDSAT, 7, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_RVTSAT_RESD, 6, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_RVTSAT_RESC, 5, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_RVTSAT_RESB, 4, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_RVTSAT_RESA, 3, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_VTSAT_DUT, 2, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_VTSAT_ID, 1, 1)
    FIELD(REG_IXPCM_MEAS_CONF_0, EN_VTSAT, 0, 1)
REG32(REG_IXPCM_MEAS_CONF_1, 0x188)
    FIELD(REG_IXPCM_MEAS_CONF_1, SPARE, 27, 5)
    FIELD(REG_IXPCM_MEAS_CONF_1, EN_SET, 19, 8)
    FIELD(REG_IXPCM_MEAS_CONF_1, EN_DUT, 3, 16)
    FIELD(REG_IXPCM_MEAS_CONF_1, EN_SENSE_GATE, 2, 1)
    FIELD(REG_IXPCM_MEAS_CONF_1, EN_SENSE_SOURCE, 1, 1)
    FIELD(REG_IXPCM_MEAS_CONF_1, EN_SENSE_DRAIN, 0, 1)
REG32(NEW_DATA_FLAG0, 0x1000)
REG32(NEW_DATA_FLAG1, 0x1004)
REG32(NEW_DATA_FLAG2, 0x1008)
REG32(NEW_DATA_FLAG3, 0x100c)
REG32(NEW_DATA_FLAG4, 0x1010)
REG32(ALARM_FLAG0, 0x1018)
REG32(ALARM_FLAG1, 0x101c)
REG32(ALARM_FLAG2, 0x1020)
REG32(ALARM_FLAG3, 0x1024)
REG32(ALARM_FLAG4, 0x1028)
REG32(DEVICE_TEMP_MAX, 0x1030)
    FIELD(DEVICE_TEMP_MAX, VAL, 0, 16)
REG32(DEVICE_TEMP_MIN, 0x1034)
    FIELD(DEVICE_TEMP_MIN, VAL, 0, 16)
REG32(TEMP_FPD, 0x1038)
    FIELD(TEMP_FPD, VAL, 0, 16)
REG32(TEMP_LPD, 0x103c)
    FIELD(TEMP_LPD, VAL, 0, 16)
REG32(SUPPLY0, 0x1040)
    FIELD(SUPPLY0, VAL, 0, 19)
REG32(SUPPLY1, 0x1044)
    FIELD(SUPPLY1, VAL, 0, 19)
REG32(SUPPLY2, 0x1048)
    FIELD(SUPPLY2, VAL, 0, 19)
REG32(SUPPLY3, 0x104c)
    FIELD(SUPPLY3, VAL, 0, 19)
REG32(SUPPLY4, 0x1050)
    FIELD(SUPPLY4, VAL, 0, 19)
REG32(SUPPLY5, 0x1054)
    FIELD(SUPPLY5, VAL, 0, 19)
REG32(SUPPLY6, 0x1058)
    FIELD(SUPPLY6, VAL, 0, 19)
REG32(SUPPLY7, 0x105c)
    FIELD(SUPPLY7, VAL, 0, 19)
REG32(SUPPLY8, 0x1060)
    FIELD(SUPPLY8, VAL, 0, 19)
REG32(SUPPLY9, 0x1064)
    FIELD(SUPPLY9, VAL, 0, 19)
REG32(SUPPLY10, 0x1068)
    FIELD(SUPPLY10, VAL, 0, 19)
REG32(SUPPLY11, 0x106c)
    FIELD(SUPPLY11, VAL, 0, 19)
REG32(SUPPLY12, 0x1070)
    FIELD(SUPPLY12, VAL, 0, 19)
REG32(SUPPLY13, 0x1074)
    FIELD(SUPPLY13, VAL, 0, 19)
REG32(SUPPLY14, 0x1078)
    FIELD(SUPPLY14, VAL, 0, 19)
REG32(SUPPLY15, 0x107c)
    FIELD(SUPPLY15, VAL, 0, 19)
REG32(SUPPLY16, 0x1080)
    FIELD(SUPPLY16, VAL, 0, 19)
REG32(SUPPLY17, 0x1084)
    FIELD(SUPPLY17, VAL, 0, 19)
REG32(SUPPLY18, 0x1088)
    FIELD(SUPPLY18, VAL, 0, 19)
REG32(SUPPLY19, 0x108c)
    FIELD(SUPPLY19, VAL, 0, 19)
REG32(SUPPLY20, 0x1090)
    FIELD(SUPPLY20, VAL, 0, 19)
REG32(SUPPLY21, 0x1094)
    FIELD(SUPPLY21, VAL, 0, 19)
REG32(SUPPLY22, 0x1098)
    FIELD(SUPPLY22, VAL, 0, 19)
REG32(SUPPLY23, 0x109c)
    FIELD(SUPPLY23, VAL, 0, 19)
REG32(SUPPLY24, 0x10a0)
    FIELD(SUPPLY24, VAL, 0, 19)
REG32(SUPPLY25, 0x10a4)
    FIELD(SUPPLY25, VAL, 0, 19)
REG32(SUPPLY26, 0x10a8)
    FIELD(SUPPLY26, VAL, 0, 19)
REG32(SUPPLY27, 0x10ac)
    FIELD(SUPPLY27, VAL, 0, 19)
REG32(SUPPLY28, 0x10b0)
    FIELD(SUPPLY28, VAL, 0, 19)
REG32(SUPPLY29, 0x10b4)
    FIELD(SUPPLY29, VAL, 0, 19)
REG32(SUPPLY30, 0x10b8)
    FIELD(SUPPLY30, VAL, 0, 19)
REG32(SUPPLY31, 0x10bc)
    FIELD(SUPPLY31, VAL, 0, 19)
REG32(SUPPLY32, 0x10c0)
    FIELD(SUPPLY32, VAL, 0, 19)
REG32(SUPPLY33, 0x10c4)
    FIELD(SUPPLY33, VAL, 0, 19)
REG32(SUPPLY34, 0x10c8)
    FIELD(SUPPLY34, VAL, 0, 19)
REG32(SUPPLY35, 0x10cc)
    FIELD(SUPPLY35, VAL, 0, 19)
REG32(SUPPLY36, 0x10d0)
    FIELD(SUPPLY36, VAL, 0, 19)
REG32(SUPPLY37, 0x10d4)
    FIELD(SUPPLY37, VAL, 0, 19)
REG32(SUPPLY38, 0x10d8)
    FIELD(SUPPLY38, VAL, 0, 19)
REG32(SUPPLY39, 0x10dc)
    FIELD(SUPPLY39, VAL, 0, 19)
REG32(SUPPLY40, 0x10e0)
    FIELD(SUPPLY40, VAL, 0, 19)
REG32(SUPPLY41, 0x10e4)
    FIELD(SUPPLY41, VAL, 0, 19)
REG32(SUPPLY42, 0x10e8)
    FIELD(SUPPLY42, VAL, 0, 19)
REG32(SUPPLY43, 0x10ec)
    FIELD(SUPPLY43, VAL, 0, 19)
REG32(SUPPLY44, 0x10f0)
    FIELD(SUPPLY44, VAL, 0, 19)
REG32(SUPPLY45, 0x10f4)
    FIELD(SUPPLY45, VAL, 0, 19)
REG32(SUPPLY46, 0x10f8)
    FIELD(SUPPLY46, VAL, 0, 19)
REG32(SUPPLY47, 0x10fc)
    FIELD(SUPPLY47, VAL, 0, 19)
REG32(SUPPLY48, 0x1100)
    FIELD(SUPPLY48, VAL, 0, 19)
REG32(SUPPLY49, 0x1104)
    FIELD(SUPPLY49, VAL, 0, 19)
REG32(SUPPLY50, 0x1108)
    FIELD(SUPPLY50, VAL, 0, 19)
REG32(SUPPLY51, 0x110c)
    FIELD(SUPPLY51, VAL, 0, 19)
REG32(SUPPLY52, 0x1110)
    FIELD(SUPPLY52, VAL, 0, 19)
REG32(SUPPLY53, 0x1114)
    FIELD(SUPPLY53, VAL, 0, 19)
REG32(SUPPLY54, 0x1118)
    FIELD(SUPPLY54, VAL, 0, 19)
REG32(SUPPLY55, 0x111c)
    FIELD(SUPPLY55, VAL, 0, 19)
REG32(SUPPLY56, 0x1120)
    FIELD(SUPPLY56, VAL, 0, 19)
REG32(SUPPLY57, 0x1124)
    FIELD(SUPPLY57, VAL, 0, 19)
REG32(SUPPLY58, 0x1128)
    FIELD(SUPPLY58, VAL, 0, 19)
REG32(SUPPLY59, 0x112c)
    FIELD(SUPPLY59, VAL, 0, 19)
REG32(SUPPLY60, 0x1130)
    FIELD(SUPPLY60, VAL, 0, 19)
REG32(SUPPLY61, 0x1134)
    FIELD(SUPPLY61, VAL, 0, 19)
REG32(SUPPLY62, 0x1138)
    FIELD(SUPPLY62, VAL, 0, 19)
REG32(SUPPLY63, 0x113c)
    FIELD(SUPPLY63, VAL, 0, 19)
REG32(SUPPLY64, 0x1140)
    FIELD(SUPPLY64, VAL, 0, 19)
REG32(SUPPLY65, 0x1144)
    FIELD(SUPPLY65, VAL, 0, 19)
REG32(SUPPLY66, 0x1148)
    FIELD(SUPPLY66, VAL, 0, 19)
REG32(SUPPLY67, 0x114c)
    FIELD(SUPPLY67, VAL, 0, 19)
REG32(SUPPLY68, 0x1150)
    FIELD(SUPPLY68, VAL, 0, 19)
REG32(SUPPLY69, 0x1154)
    FIELD(SUPPLY69, VAL, 0, 19)
REG32(SUPPLY70, 0x1158)
    FIELD(SUPPLY70, VAL, 0, 19)
REG32(SUPPLY71, 0x115c)
    FIELD(SUPPLY71, VAL, 0, 19)
REG32(SUPPLY72, 0x1160)
    FIELD(SUPPLY72, VAL, 0, 19)
REG32(SUPPLY73, 0x1164)
    FIELD(SUPPLY73, VAL, 0, 19)
REG32(SUPPLY74, 0x1168)
    FIELD(SUPPLY74, VAL, 0, 19)
REG32(SUPPLY75, 0x116c)
    FIELD(SUPPLY75, VAL, 0, 19)
REG32(SUPPLY76, 0x1170)
    FIELD(SUPPLY76, VAL, 0, 19)
REG32(SUPPLY77, 0x1174)
    FIELD(SUPPLY77, VAL, 0, 19)
REG32(SUPPLY78, 0x1178)
    FIELD(SUPPLY78, VAL, 0, 19)
REG32(SUPPLY79, 0x117c)
    FIELD(SUPPLY79, VAL, 0, 19)
REG32(SUPPLY80, 0x1180)
    FIELD(SUPPLY80, VAL, 0, 19)
REG32(SUPPLY81, 0x1184)
    FIELD(SUPPLY81, VAL, 0, 19)
REG32(SUPPLY82, 0x1188)
    FIELD(SUPPLY82, VAL, 0, 19)
REG32(SUPPLY83, 0x118c)
    FIELD(SUPPLY83, VAL, 0, 19)
REG32(SUPPLY84, 0x1190)
    FIELD(SUPPLY84, VAL, 0, 19)
REG32(SUPPLY85, 0x1194)
    FIELD(SUPPLY85, VAL, 0, 19)
REG32(SUPPLY86, 0x1198)
    FIELD(SUPPLY86, VAL, 0, 19)
REG32(SUPPLY87, 0x119c)
    FIELD(SUPPLY87, VAL, 0, 19)
REG32(SUPPLY88, 0x11a0)
    FIELD(SUPPLY88, VAL, 0, 19)
REG32(SUPPLY89, 0x11a4)
    FIELD(SUPPLY89, VAL, 0, 19)
REG32(SUPPLY90, 0x11a8)
    FIELD(SUPPLY90, VAL, 0, 19)
REG32(SUPPLY91, 0x11ac)
    FIELD(SUPPLY91, VAL, 0, 19)
REG32(SUPPLY92, 0x11b0)
    FIELD(SUPPLY92, VAL, 0, 19)
REG32(SUPPLY93, 0x11b4)
    FIELD(SUPPLY93, VAL, 0, 19)
REG32(SUPPLY94, 0x11b8)
    FIELD(SUPPLY94, VAL, 0, 19)
REG32(SUPPLY95, 0x11bc)
    FIELD(SUPPLY95, VAL, 0, 19)
REG32(SUPPLY96, 0x11c0)
    FIELD(SUPPLY96, VAL, 0, 19)
REG32(SUPPLY97, 0x11c4)
    FIELD(SUPPLY97, VAL, 0, 19)
REG32(SUPPLY98, 0x11c8)
    FIELD(SUPPLY98, VAL, 0, 19)
REG32(SUPPLY99, 0x11cc)
    FIELD(SUPPLY99, VAL, 0, 19)
REG32(SUPPLY100, 0x11d0)
    FIELD(SUPPLY100, VAL, 0, 19)
REG32(SUPPLY101, 0x11d4)
    FIELD(SUPPLY101, VAL, 0, 19)
REG32(SUPPLY102, 0x11d8)
    FIELD(SUPPLY102, VAL, 0, 19)
REG32(SUPPLY103, 0x11dc)
    FIELD(SUPPLY103, VAL, 0, 19)
REG32(SUPPLY104, 0x11e0)
    FIELD(SUPPLY104, VAL, 0, 19)
REG32(SUPPLY105, 0x11e4)
    FIELD(SUPPLY105, VAL, 0, 19)
REG32(SUPPLY106, 0x11e8)
    FIELD(SUPPLY106, VAL, 0, 19)
REG32(SUPPLY107, 0x11ec)
    FIELD(SUPPLY107, VAL, 0, 19)
REG32(SUPPLY108, 0x11f0)
    FIELD(SUPPLY108, VAL, 0, 19)
REG32(SUPPLY109, 0x11f4)
    FIELD(SUPPLY109, VAL, 0, 19)
REG32(SUPPLY110, 0x11f8)
    FIELD(SUPPLY110, VAL, 0, 19)
REG32(SUPPLY111, 0x11fc)
    FIELD(SUPPLY111, VAL, 0, 19)
REG32(SUPPLY112, 0x1200)
    FIELD(SUPPLY112, VAL, 0, 19)
REG32(SUPPLY113, 0x1204)
    FIELD(SUPPLY113, VAL, 0, 19)
REG32(SUPPLY114, 0x1208)
    FIELD(SUPPLY114, VAL, 0, 19)
REG32(SUPPLY115, 0x120c)
    FIELD(SUPPLY115, VAL, 0, 19)
REG32(SUPPLY116, 0x1210)
    FIELD(SUPPLY116, VAL, 0, 19)
REG32(SUPPLY117, 0x1214)
    FIELD(SUPPLY117, VAL, 0, 19)
REG32(SUPPLY118, 0x1218)
    FIELD(SUPPLY118, VAL, 0, 19)
REG32(SUPPLY119, 0x121c)
    FIELD(SUPPLY119, VAL, 0, 19)
REG32(SUPPLY120, 0x1220)
    FIELD(SUPPLY120, VAL, 0, 19)
REG32(SUPPLY121, 0x1224)
    FIELD(SUPPLY121, VAL, 0, 19)
REG32(SUPPLY122, 0x1228)
    FIELD(SUPPLY122, VAL, 0, 19)
REG32(SUPPLY123, 0x122c)
    FIELD(SUPPLY123, VAL, 0, 19)
REG32(SUPPLY124, 0x1230)
    FIELD(SUPPLY124, VAL, 0, 19)
REG32(SUPPLY125, 0x1234)
    FIELD(SUPPLY125, VAL, 0, 19)
REG32(SUPPLY126, 0x1238)
    FIELD(SUPPLY126, VAL, 0, 19)
REG32(SUPPLY127, 0x123c)
    FIELD(SUPPLY127, VAL, 0, 19)
REG32(SUPPLY128, 0x1240)
    FIELD(SUPPLY128, VAL, 0, 19)
REG32(SUPPLY129, 0x1244)
    FIELD(SUPPLY129, VAL, 0, 19)
REG32(SUPPLY130, 0x1248)
    FIELD(SUPPLY130, VAL, 0, 19)
REG32(SUPPLY131, 0x124c)
    FIELD(SUPPLY131, VAL, 0, 19)
REG32(SUPPLY132, 0x1250)
    FIELD(SUPPLY132, VAL, 0, 19)
REG32(SUPPLY133, 0x1254)
    FIELD(SUPPLY133, VAL, 0, 19)
REG32(SUPPLY134, 0x1258)
    FIELD(SUPPLY134, VAL, 0, 19)
REG32(SUPPLY135, 0x125c)
    FIELD(SUPPLY135, VAL, 0, 19)
REG32(SUPPLY136, 0x1260)
    FIELD(SUPPLY136, VAL, 0, 19)
REG32(SUPPLY137, 0x1264)
    FIELD(SUPPLY137, VAL, 0, 19)
REG32(SUPPLY138, 0x1268)
    FIELD(SUPPLY138, VAL, 0, 19)
REG32(SUPPLY139, 0x126c)
    FIELD(SUPPLY139, VAL, 0, 19)
REG32(SUPPLY140, 0x1270)
    FIELD(SUPPLY140, VAL, 0, 19)
REG32(SUPPLY141, 0x1274)
    FIELD(SUPPLY141, VAL, 0, 19)
REG32(SUPPLY142, 0x1278)
    FIELD(SUPPLY142, VAL, 0, 19)
REG32(SUPPLY143, 0x127c)
    FIELD(SUPPLY143, VAL, 0, 19)
REG32(SUPPLY144, 0x1280)
    FIELD(SUPPLY144, VAL, 0, 19)
REG32(SUPPLY145, 0x1284)
    FIELD(SUPPLY145, VAL, 0, 19)
REG32(SUPPLY146, 0x1288)
    FIELD(SUPPLY146, VAL, 0, 19)
REG32(SUPPLY147, 0x128c)
    FIELD(SUPPLY147, VAL, 0, 19)
REG32(SUPPLY148, 0x1290)
    FIELD(SUPPLY148, VAL, 0, 19)
REG32(SUPPLY149, 0x1294)
    FIELD(SUPPLY149, VAL, 0, 19)
REG32(SUPPLY150, 0x1298)
    FIELD(SUPPLY150, VAL, 0, 19)
REG32(SUPPLY151, 0x129c)
    FIELD(SUPPLY151, VAL, 0, 19)
REG32(SUPPLY152, 0x12a0)
    FIELD(SUPPLY152, VAL, 0, 19)
REG32(SUPPLY153, 0x12a4)
    FIELD(SUPPLY153, VAL, 0, 19)
REG32(SUPPLY154, 0x12a8)
    FIELD(SUPPLY154, VAL, 0, 19)
REG32(SUPPLY155, 0x12ac)
    FIELD(SUPPLY155, VAL, 0, 19)
REG32(SUPPLY156, 0x12b0)
    FIELD(SUPPLY156, VAL, 0, 19)
REG32(SUPPLY157, 0x12b4)
    FIELD(SUPPLY157, VAL, 0, 19)
REG32(SUPPLY158, 0x12b8)
    FIELD(SUPPLY158, VAL, 0, 19)
REG32(SUPPLY159, 0x12bc)
    FIELD(SUPPLY159, VAL, 0, 19)
REG32(SUPPLY0_MIN, 0x1340)
    FIELD(SUPPLY0_MIN, VAL, 0, 19)
REG32(SUPPLY1_MIN, 0x1344)
    FIELD(SUPPLY1_MIN, VAL, 0, 19)
REG32(SUPPLY2_MIN, 0x1348)
    FIELD(SUPPLY2_MIN, VAL, 0, 19)
REG32(SUPPLY3_MIN, 0x134c)
    FIELD(SUPPLY3_MIN, VAL, 0, 19)
REG32(SUPPLY4_MIN, 0x1350)
    FIELD(SUPPLY4_MIN, VAL, 0, 19)
REG32(SUPPLY5_MIN, 0x1354)
    FIELD(SUPPLY5_MIN, VAL, 0, 19)
REG32(SUPPLY6_MIN, 0x1358)
    FIELD(SUPPLY6_MIN, VAL, 0, 19)
REG32(SUPPLY7_MIN, 0x135c)
    FIELD(SUPPLY7_MIN, VAL, 0, 19)
REG32(SUPPLY8_MIN, 0x1360)
    FIELD(SUPPLY8_MIN, VAL, 0, 19)
REG32(SUPPLY9_MIN, 0x1364)
    FIELD(SUPPLY9_MIN, VAL, 0, 19)
REG32(SUPPLY10_MIN, 0x1368)
    FIELD(SUPPLY10_MIN, VAL, 0, 19)
REG32(SUPPLY11_MIN, 0x136c)
    FIELD(SUPPLY11_MIN, VAL, 0, 19)
REG32(SUPPLY12_MIN, 0x1370)
    FIELD(SUPPLY12_MIN, VAL, 0, 19)
REG32(SUPPLY13_MIN, 0x1374)
    FIELD(SUPPLY13_MIN, VAL, 0, 19)
REG32(SUPPLY14_MIN, 0x1378)
    FIELD(SUPPLY14_MIN, VAL, 0, 19)
REG32(SUPPLY15_MIN, 0x137c)
    FIELD(SUPPLY15_MIN, VAL, 0, 19)
REG32(SUPPLY16_MIN, 0x1380)
    FIELD(SUPPLY16_MIN, VAL, 0, 19)
REG32(SUPPLY17_MIN, 0x1384)
    FIELD(SUPPLY17_MIN, VAL, 0, 19)
REG32(SUPPLY18_MIN, 0x1388)
    FIELD(SUPPLY18_MIN, VAL, 0, 19)
REG32(SUPPLY19_MIN, 0x138c)
    FIELD(SUPPLY19_MIN, VAL, 0, 19)
REG32(SUPPLY20_MIN, 0x1390)
    FIELD(SUPPLY20_MIN, VAL, 0, 19)
REG32(SUPPLY21_MIN, 0x1394)
    FIELD(SUPPLY21_MIN, VAL, 0, 19)
REG32(SUPPLY22_MIN, 0x1398)
    FIELD(SUPPLY22_MIN, VAL, 0, 19)
REG32(SUPPLY23_MIN, 0x139c)
    FIELD(SUPPLY23_MIN, VAL, 0, 19)
REG32(SUPPLY24_MIN, 0x13a0)
    FIELD(SUPPLY24_MIN, VAL, 0, 19)
REG32(SUPPLY25_MIN, 0x13a4)
    FIELD(SUPPLY25_MIN, VAL, 0, 19)
REG32(SUPPLY26_MIN, 0x13a8)
    FIELD(SUPPLY26_MIN, VAL, 0, 19)
REG32(SUPPLY27_MIN, 0x13ac)
    FIELD(SUPPLY27_MIN, VAL, 0, 19)
REG32(SUPPLY28_MIN, 0x13b0)
    FIELD(SUPPLY28_MIN, VAL, 0, 19)
REG32(SUPPLY29_MIN, 0x13b4)
    FIELD(SUPPLY29_MIN, VAL, 0, 19)
REG32(SUPPLY30_MIN, 0x13b8)
    FIELD(SUPPLY30_MIN, VAL, 0, 19)
REG32(SUPPLY31_MIN, 0x13bc)
    FIELD(SUPPLY31_MIN, VAL, 0, 19)
REG32(SUPPLY32_MIN, 0x13c0)
    FIELD(SUPPLY32_MIN, VAL, 0, 19)
REG32(SUPPLY33_MIN, 0x13c4)
    FIELD(SUPPLY33_MIN, VAL, 0, 19)
REG32(SUPPLY34_MIN, 0x13c8)
    FIELD(SUPPLY34_MIN, VAL, 0, 19)
REG32(SUPPLY35_MIN, 0x13cc)
    FIELD(SUPPLY35_MIN, VAL, 0, 19)
REG32(SUPPLY36_MIN, 0x13d0)
    FIELD(SUPPLY36_MIN, VAL, 0, 19)
REG32(SUPPLY37_MIN, 0x13d4)
    FIELD(SUPPLY37_MIN, VAL, 0, 19)
REG32(SUPPLY38_MIN, 0x13d8)
    FIELD(SUPPLY38_MIN, VAL, 0, 19)
REG32(SUPPLY39_MIN, 0x13dc)
    FIELD(SUPPLY39_MIN, VAL, 0, 19)
REG32(SUPPLY40_MIN, 0x13e0)
    FIELD(SUPPLY40_MIN, VAL, 0, 19)
REG32(SUPPLY41_MIN, 0x13e4)
    FIELD(SUPPLY41_MIN, VAL, 0, 19)
REG32(SUPPLY42_MIN, 0x13e8)
    FIELD(SUPPLY42_MIN, VAL, 0, 19)
REG32(SUPPLY43_MIN, 0x13ec)
    FIELD(SUPPLY43_MIN, VAL, 0, 19)
REG32(SUPPLY44_MIN, 0x13f0)
    FIELD(SUPPLY44_MIN, VAL, 0, 19)
REG32(SUPPLY45_MIN, 0x13f4)
    FIELD(SUPPLY45_MIN, VAL, 0, 19)
REG32(SUPPLY46_MIN, 0x13f8)
    FIELD(SUPPLY46_MIN, VAL, 0, 19)
REG32(SUPPLY47_MIN, 0x13fc)
    FIELD(SUPPLY47_MIN, VAL, 0, 19)
REG32(SUPPLY48_MIN, 0x1400)
    FIELD(SUPPLY48_MIN, VAL, 0, 19)
REG32(SUPPLY49_MIN, 0x1404)
    FIELD(SUPPLY49_MIN, VAL, 0, 19)
REG32(SUPPLY50_MIN, 0x1408)
    FIELD(SUPPLY50_MIN, VAL, 0, 19)
REG32(SUPPLY51_MIN, 0x140c)
    FIELD(SUPPLY51_MIN, VAL, 0, 19)
REG32(SUPPLY52_MIN, 0x1410)
    FIELD(SUPPLY52_MIN, VAL, 0, 19)
REG32(SUPPLY53_MIN, 0x1414)
    FIELD(SUPPLY53_MIN, VAL, 0, 19)
REG32(SUPPLY54_MIN, 0x1418)
    FIELD(SUPPLY54_MIN, VAL, 0, 19)
REG32(SUPPLY55_MIN, 0x141c)
    FIELD(SUPPLY55_MIN, VAL, 0, 19)
REG32(SUPPLY56_MIN, 0x1420)
    FIELD(SUPPLY56_MIN, VAL, 0, 19)
REG32(SUPPLY57_MIN, 0x1424)
    FIELD(SUPPLY57_MIN, VAL, 0, 19)
REG32(SUPPLY58_MIN, 0x1428)
    FIELD(SUPPLY58_MIN, VAL, 0, 19)
REG32(SUPPLY59_MIN, 0x142c)
    FIELD(SUPPLY59_MIN, VAL, 0, 19)
REG32(SUPPLY60_MIN, 0x1430)
    FIELD(SUPPLY60_MIN, VAL, 0, 19)
REG32(SUPPLY61_MIN, 0x1434)
    FIELD(SUPPLY61_MIN, VAL, 0, 19)
REG32(SUPPLY62_MIN, 0x1438)
    FIELD(SUPPLY62_MIN, VAL, 0, 19)
REG32(SUPPLY63_MIN, 0x143c)
    FIELD(SUPPLY63_MIN, VAL, 0, 19)
REG32(SUPPLY64_MIN, 0x1440)
    FIELD(SUPPLY64_MIN, VAL, 0, 19)
REG32(SUPPLY65_MIN, 0x1444)
    FIELD(SUPPLY65_MIN, VAL, 0, 19)
REG32(SUPPLY66_MIN, 0x1448)
    FIELD(SUPPLY66_MIN, VAL, 0, 19)
REG32(SUPPLY67_MIN, 0x144c)
    FIELD(SUPPLY67_MIN, VAL, 0, 19)
REG32(SUPPLY68_MIN, 0x1450)
    FIELD(SUPPLY68_MIN, VAL, 0, 19)
REG32(SUPPLY69_MIN, 0x1454)
    FIELD(SUPPLY69_MIN, VAL, 0, 19)
REG32(SUPPLY70_MIN, 0x1458)
    FIELD(SUPPLY70_MIN, VAL, 0, 19)
REG32(SUPPLY71_MIN, 0x145c)
    FIELD(SUPPLY71_MIN, VAL, 0, 19)
REG32(SUPPLY72_MIN, 0x1460)
    FIELD(SUPPLY72_MIN, VAL, 0, 19)
REG32(SUPPLY73_MIN, 0x1464)
    FIELD(SUPPLY73_MIN, VAL, 0, 19)
REG32(SUPPLY74_MIN, 0x1468)
    FIELD(SUPPLY74_MIN, VAL, 0, 19)
REG32(SUPPLY75_MIN, 0x146c)
    FIELD(SUPPLY75_MIN, VAL, 0, 19)
REG32(SUPPLY76_MIN, 0x1470)
    FIELD(SUPPLY76_MIN, VAL, 0, 19)
REG32(SUPPLY77_MIN, 0x1474)
    FIELD(SUPPLY77_MIN, VAL, 0, 19)
REG32(SUPPLY78_MIN, 0x1478)
    FIELD(SUPPLY78_MIN, VAL, 0, 19)
REG32(SUPPLY79_MIN, 0x147c)
    FIELD(SUPPLY79_MIN, VAL, 0, 19)
REG32(SUPPLY80_MIN, 0x1480)
    FIELD(SUPPLY80_MIN, VAL, 0, 19)
REG32(SUPPLY81_MIN, 0x1484)
    FIELD(SUPPLY81_MIN, VAL, 0, 19)
REG32(SUPPLY82_MIN, 0x1488)
    FIELD(SUPPLY82_MIN, VAL, 0, 19)
REG32(SUPPLY83_MIN, 0x148c)
    FIELD(SUPPLY83_MIN, VAL, 0, 19)
REG32(SUPPLY84_MIN, 0x1490)
    FIELD(SUPPLY84_MIN, VAL, 0, 19)
REG32(SUPPLY85_MIN, 0x1494)
    FIELD(SUPPLY85_MIN, VAL, 0, 19)
REG32(SUPPLY86_MIN, 0x1498)
    FIELD(SUPPLY86_MIN, VAL, 0, 19)
REG32(SUPPLY87_MIN, 0x149c)
    FIELD(SUPPLY87_MIN, VAL, 0, 19)
REG32(SUPPLY88_MIN, 0x14a0)
    FIELD(SUPPLY88_MIN, VAL, 0, 19)
REG32(SUPPLY89_MIN, 0x14a4)
    FIELD(SUPPLY89_MIN, VAL, 0, 19)
REG32(SUPPLY90_MIN, 0x14a8)
    FIELD(SUPPLY90_MIN, VAL, 0, 19)
REG32(SUPPLY91_MIN, 0x14ac)
    FIELD(SUPPLY91_MIN, VAL, 0, 19)
REG32(SUPPLY92_MIN, 0x14b0)
    FIELD(SUPPLY92_MIN, VAL, 0, 19)
REG32(SUPPLY93_MIN, 0x14b4)
    FIELD(SUPPLY93_MIN, VAL, 0, 19)
REG32(SUPPLY94_MIN, 0x14b8)
    FIELD(SUPPLY94_MIN, VAL, 0, 19)
REG32(SUPPLY95_MIN, 0x14bc)
    FIELD(SUPPLY95_MIN, VAL, 0, 19)
REG32(SUPPLY96_MIN, 0x14c0)
    FIELD(SUPPLY96_MIN, VAL, 0, 19)
REG32(SUPPLY97_MIN, 0x14c4)
    FIELD(SUPPLY97_MIN, VAL, 0, 19)
REG32(SUPPLY98_MIN, 0x14c8)
    FIELD(SUPPLY98_MIN, VAL, 0, 19)
REG32(SUPPLY99_MIN, 0x14cc)
    FIELD(SUPPLY99_MIN, VAL, 0, 19)
REG32(SUPPLY100_MIN, 0x14d0)
    FIELD(SUPPLY100_MIN, VAL, 0, 19)
REG32(SUPPLY101_MIN, 0x14d4)
    FIELD(SUPPLY101_MIN, VAL, 0, 19)
REG32(SUPPLY102_MIN, 0x14d8)
    FIELD(SUPPLY102_MIN, VAL, 0, 19)
REG32(SUPPLY103_MIN, 0x14dc)
    FIELD(SUPPLY103_MIN, VAL, 0, 19)
REG32(SUPPLY104_MIN, 0x14e0)
    FIELD(SUPPLY104_MIN, VAL, 0, 19)
REG32(SUPPLY105_MIN, 0x14e4)
    FIELD(SUPPLY105_MIN, VAL, 0, 19)
REG32(SUPPLY106_MIN, 0x14e8)
    FIELD(SUPPLY106_MIN, VAL, 0, 19)
REG32(SUPPLY107_MIN, 0x14ec)
    FIELD(SUPPLY107_MIN, VAL, 0, 19)
REG32(SUPPLY108_MIN, 0x14f0)
    FIELD(SUPPLY108_MIN, VAL, 0, 19)
REG32(SUPPLY109_MIN, 0x14f4)
    FIELD(SUPPLY109_MIN, VAL, 0, 19)
REG32(SUPPLY110_MIN, 0x14f8)
    FIELD(SUPPLY110_MIN, VAL, 0, 19)
REG32(SUPPLY111_MIN, 0x14fc)
    FIELD(SUPPLY111_MIN, VAL, 0, 19)
REG32(SUPPLY112_MIN, 0x1500)
    FIELD(SUPPLY112_MIN, VAL, 0, 19)
REG32(SUPPLY113_MIN, 0x1504)
    FIELD(SUPPLY113_MIN, VAL, 0, 19)
REG32(SUPPLY114_MIN, 0x1508)
    FIELD(SUPPLY114_MIN, VAL, 0, 19)
REG32(SUPPLY115_MIN, 0x150c)
    FIELD(SUPPLY115_MIN, VAL, 0, 19)
REG32(SUPPLY116_MIN, 0x1510)
    FIELD(SUPPLY116_MIN, VAL, 0, 19)
REG32(SUPPLY117_MIN, 0x1514)
    FIELD(SUPPLY117_MIN, VAL, 0, 19)
REG32(SUPPLY118_MIN, 0x1518)
    FIELD(SUPPLY118_MIN, VAL, 0, 19)
REG32(SUPPLY119_MIN, 0x151c)
    FIELD(SUPPLY119_MIN, VAL, 0, 19)
REG32(SUPPLY120_MIN, 0x1520)
    FIELD(SUPPLY120_MIN, VAL, 0, 19)
REG32(SUPPLY121_MIN, 0x1524)
    FIELD(SUPPLY121_MIN, VAL, 0, 19)
REG32(SUPPLY122_MIN, 0x1528)
    FIELD(SUPPLY122_MIN, VAL, 0, 19)
REG32(SUPPLY123_MIN, 0x152c)
    FIELD(SUPPLY123_MIN, VAL, 0, 19)
REG32(SUPPLY124_MIN, 0x1530)
    FIELD(SUPPLY124_MIN, VAL, 0, 19)
REG32(SUPPLY125_MIN, 0x1534)
    FIELD(SUPPLY125_MIN, VAL, 0, 19)
REG32(SUPPLY126_MIN, 0x1538)
    FIELD(SUPPLY126_MIN, VAL, 0, 19)
REG32(SUPPLY127_MIN, 0x153c)
    FIELD(SUPPLY127_MIN, VAL, 0, 19)
REG32(SUPPLY128_MIN, 0x1540)
    FIELD(SUPPLY128_MIN, VAL, 0, 19)
REG32(SUPPLY129_MIN, 0x1544)
    FIELD(SUPPLY129_MIN, VAL, 0, 19)
REG32(SUPPLY130_MIN, 0x1548)
    FIELD(SUPPLY130_MIN, VAL, 0, 19)
REG32(SUPPLY131_MIN, 0x154c)
    FIELD(SUPPLY131_MIN, VAL, 0, 19)
REG32(SUPPLY132_MIN, 0x1550)
    FIELD(SUPPLY132_MIN, VAL, 0, 19)
REG32(SUPPLY133_MIN, 0x1554)
    FIELD(SUPPLY133_MIN, VAL, 0, 19)
REG32(SUPPLY134_MIN, 0x1558)
    FIELD(SUPPLY134_MIN, VAL, 0, 19)
REG32(SUPPLY135_MIN, 0x155c)
    FIELD(SUPPLY135_MIN, VAL, 0, 19)
REG32(SUPPLY136_MIN, 0x1560)
    FIELD(SUPPLY136_MIN, VAL, 0, 19)
REG32(SUPPLY137_MIN, 0x1564)
    FIELD(SUPPLY137_MIN, VAL, 0, 19)
REG32(SUPPLY138_MIN, 0x1568)
    FIELD(SUPPLY138_MIN, VAL, 0, 19)
REG32(SUPPLY139_MIN, 0x156c)
    FIELD(SUPPLY139_MIN, VAL, 0, 19)
REG32(SUPPLY140_MIN, 0x1570)
    FIELD(SUPPLY140_MIN, VAL, 0, 19)
REG32(SUPPLY141_MIN, 0x1574)
    FIELD(SUPPLY141_MIN, VAL, 0, 19)
REG32(SUPPLY142_MIN, 0x1578)
    FIELD(SUPPLY142_MIN, VAL, 0, 19)
REG32(SUPPLY143_MIN, 0x157c)
    FIELD(SUPPLY143_MIN, VAL, 0, 19)
REG32(SUPPLY144_MIN, 0x1580)
    FIELD(SUPPLY144_MIN, VAL, 0, 19)
REG32(SUPPLY145_MIN, 0x1584)
    FIELD(SUPPLY145_MIN, VAL, 0, 19)
REG32(SUPPLY146_MIN, 0x1588)
    FIELD(SUPPLY146_MIN, VAL, 0, 19)
REG32(SUPPLY147_MIN, 0x158c)
    FIELD(SUPPLY147_MIN, VAL, 0, 19)
REG32(SUPPLY148_MIN, 0x1590)
    FIELD(SUPPLY148_MIN, VAL, 0, 19)
REG32(SUPPLY149_MIN, 0x1594)
    FIELD(SUPPLY149_MIN, VAL, 0, 19)
REG32(SUPPLY150_MIN, 0x1598)
    FIELD(SUPPLY150_MIN, VAL, 0, 19)
REG32(SUPPLY151_MIN, 0x159c)
    FIELD(SUPPLY151_MIN, VAL, 0, 19)
REG32(SUPPLY152_MIN, 0x15a0)
    FIELD(SUPPLY152_MIN, VAL, 0, 19)
REG32(SUPPLY153_MIN, 0x15a4)
    FIELD(SUPPLY153_MIN, VAL, 0, 19)
REG32(SUPPLY154_MIN, 0x15a8)
    FIELD(SUPPLY154_MIN, VAL, 0, 19)
REG32(SUPPLY155_MIN, 0x15ac)
    FIELD(SUPPLY155_MIN, VAL, 0, 19)
REG32(SUPPLY156_MIN, 0x15b0)
    FIELD(SUPPLY156_MIN, VAL, 0, 19)
REG32(SUPPLY157_MIN, 0x15b4)
    FIELD(SUPPLY157_MIN, VAL, 0, 19)
REG32(SUPPLY158_MIN, 0x15b8)
    FIELD(SUPPLY158_MIN, VAL, 0, 19)
REG32(SUPPLY159_MIN, 0x15bc)
    FIELD(SUPPLY159_MIN, VAL, 0, 19)
REG32(SUPPLY0_MAX, 0x1640)
    FIELD(SUPPLY0_MAX, VAL, 0, 19)
REG32(SUPPLY1_MAX, 0x1644)
    FIELD(SUPPLY1_MAX, VAL, 0, 19)
REG32(SUPPLY2_MAX, 0x1648)
    FIELD(SUPPLY2_MAX, VAL, 0, 19)
REG32(SUPPLY3_MAX, 0x164c)
    FIELD(SUPPLY3_MAX, VAL, 0, 19)
REG32(SUPPLY4_MAX, 0x1650)
    FIELD(SUPPLY4_MAX, VAL, 0, 19)
REG32(SUPPLY5_MAX, 0x1654)
    FIELD(SUPPLY5_MAX, VAL, 0, 19)
REG32(SUPPLY6_MAX, 0x1658)
    FIELD(SUPPLY6_MAX, VAL, 0, 19)
REG32(SUPPLY7_MAX, 0x165c)
    FIELD(SUPPLY7_MAX, VAL, 0, 19)
REG32(SUPPLY8_MAX, 0x1660)
    FIELD(SUPPLY8_MAX, VAL, 0, 19)
REG32(SUPPLY9_MAX, 0x1664)
    FIELD(SUPPLY9_MAX, VAL, 0, 19)
REG32(SUPPLY10_MAX, 0x1668)
    FIELD(SUPPLY10_MAX, VAL, 0, 19)
REG32(SUPPLY11_MAX, 0x166c)
    FIELD(SUPPLY11_MAX, VAL, 0, 19)
REG32(SUPPLY12_MAX, 0x1670)
    FIELD(SUPPLY12_MAX, VAL, 0, 19)
REG32(SUPPLY13_MAX, 0x1674)
    FIELD(SUPPLY13_MAX, VAL, 0, 19)
REG32(SUPPLY14_MAX, 0x1678)
    FIELD(SUPPLY14_MAX, VAL, 0, 19)
REG32(SUPPLY15_MAX, 0x167c)
    FIELD(SUPPLY15_MAX, VAL, 0, 19)
REG32(SUPPLY16_MAX, 0x1680)
    FIELD(SUPPLY16_MAX, VAL, 0, 19)
REG32(SUPPLY17_MAX, 0x1684)
    FIELD(SUPPLY17_MAX, VAL, 0, 19)
REG32(SUPPLY18_MAX, 0x1688)
    FIELD(SUPPLY18_MAX, VAL, 0, 19)
REG32(SUPPLY19_MAX, 0x168c)
    FIELD(SUPPLY19_MAX, VAL, 0, 19)
REG32(SUPPLY20_MAX, 0x1690)
    FIELD(SUPPLY20_MAX, VAL, 0, 19)
REG32(SUPPLY21_MAX, 0x1694)
    FIELD(SUPPLY21_MAX, VAL, 0, 19)
REG32(SUPPLY22_MAX, 0x1698)
    FIELD(SUPPLY22_MAX, VAL, 0, 19)
REG32(SUPPLY23_MAX, 0x169c)
    FIELD(SUPPLY23_MAX, VAL, 0, 19)
REG32(SUPPLY24_MAX, 0x16a0)
    FIELD(SUPPLY24_MAX, VAL, 0, 19)
REG32(SUPPLY25_MAX, 0x16a4)
    FIELD(SUPPLY25_MAX, VAL, 0, 19)
REG32(SUPPLY26_MAX, 0x16a8)
    FIELD(SUPPLY26_MAX, VAL, 0, 19)
REG32(SUPPLY27_MAX, 0x16ac)
    FIELD(SUPPLY27_MAX, VAL, 0, 19)
REG32(SUPPLY28_MAX, 0x16b0)
    FIELD(SUPPLY28_MAX, VAL, 0, 19)
REG32(SUPPLY29_MAX, 0x16b4)
    FIELD(SUPPLY29_MAX, VAL, 0, 19)
REG32(SUPPLY30_MAX, 0x16b8)
    FIELD(SUPPLY30_MAX, VAL, 0, 19)
REG32(SUPPLY31_MAX, 0x16bc)
    FIELD(SUPPLY31_MAX, VAL, 0, 19)
REG32(SUPPLY32_MAX, 0x16c0)
    FIELD(SUPPLY32_MAX, VAL, 0, 19)
REG32(SUPPLY33_MAX, 0x16c4)
    FIELD(SUPPLY33_MAX, VAL, 0, 19)
REG32(SUPPLY34_MAX, 0x16c8)
    FIELD(SUPPLY34_MAX, VAL, 0, 19)
REG32(SUPPLY35_MAX, 0x16cc)
    FIELD(SUPPLY35_MAX, VAL, 0, 19)
REG32(SUPPLY36_MAX, 0x16d0)
    FIELD(SUPPLY36_MAX, VAL, 0, 19)
REG32(SUPPLY37_MAX, 0x16d4)
    FIELD(SUPPLY37_MAX, VAL, 0, 19)
REG32(SUPPLY38_MAX, 0x16d8)
    FIELD(SUPPLY38_MAX, VAL, 0, 19)
REG32(SUPPLY39_MAX, 0x16dc)
    FIELD(SUPPLY39_MAX, VAL, 0, 19)
REG32(SUPPLY40_MAX, 0x16e0)
    FIELD(SUPPLY40_MAX, VAL, 0, 19)
REG32(SUPPLY41_MAX, 0x16e4)
    FIELD(SUPPLY41_MAX, VAL, 0, 19)
REG32(SUPPLY42_MAX, 0x16e8)
    FIELD(SUPPLY42_MAX, VAL, 0, 19)
REG32(SUPPLY43_MAX, 0x16ec)
    FIELD(SUPPLY43_MAX, VAL, 0, 19)
REG32(SUPPLY44_MAX, 0x16f0)
    FIELD(SUPPLY44_MAX, VAL, 0, 19)
REG32(SUPPLY45_MAX, 0x16f4)
    FIELD(SUPPLY45_MAX, VAL, 0, 19)
REG32(SUPPLY46_MAX, 0x16f8)
    FIELD(SUPPLY46_MAX, VAL, 0, 19)
REG32(SUPPLY47_MAX, 0x16fc)
    FIELD(SUPPLY47_MAX, VAL, 0, 19)
REG32(SUPPLY48_MAX, 0x1700)
    FIELD(SUPPLY48_MAX, VAL, 0, 19)
REG32(SUPPLY49_MAX, 0x1704)
    FIELD(SUPPLY49_MAX, VAL, 0, 19)
REG32(SUPPLY50_MAX, 0x1708)
    FIELD(SUPPLY50_MAX, VAL, 0, 19)
REG32(SUPPLY51_MAX, 0x170c)
    FIELD(SUPPLY51_MAX, VAL, 0, 19)
REG32(SUPPLY52_MAX, 0x1710)
    FIELD(SUPPLY52_MAX, VAL, 0, 19)
REG32(SUPPLY53_MAX, 0x1714)
    FIELD(SUPPLY53_MAX, VAL, 0, 19)
REG32(SUPPLY54_MAX, 0x1718)
    FIELD(SUPPLY54_MAX, VAL, 0, 19)
REG32(SUPPLY55_MAX, 0x171c)
    FIELD(SUPPLY55_MAX, VAL, 0, 19)
REG32(SUPPLY56_MAX, 0x1720)
    FIELD(SUPPLY56_MAX, VAL, 0, 19)
REG32(SUPPLY57_MAX, 0x1724)
    FIELD(SUPPLY57_MAX, VAL, 0, 19)
REG32(SUPPLY58_MAX, 0x1728)
    FIELD(SUPPLY58_MAX, VAL, 0, 19)
REG32(SUPPLY59_MAX, 0x172c)
    FIELD(SUPPLY59_MAX, VAL, 0, 19)
REG32(SUPPLY60_MAX, 0x1730)
    FIELD(SUPPLY60_MAX, VAL, 0, 19)
REG32(SUPPLY61_MAX, 0x1734)
    FIELD(SUPPLY61_MAX, VAL, 0, 19)
REG32(SUPPLY62_MAX, 0x1738)
    FIELD(SUPPLY62_MAX, VAL, 0, 19)
REG32(SUPPLY63_MAX, 0x173c)
    FIELD(SUPPLY63_MAX, VAL, 0, 19)
REG32(SUPPLY64_MAX, 0x1740)
    FIELD(SUPPLY64_MAX, VAL, 0, 19)
REG32(SUPPLY65_MAX, 0x1744)
    FIELD(SUPPLY65_MAX, VAL, 0, 19)
REG32(SUPPLY66_MAX, 0x1748)
    FIELD(SUPPLY66_MAX, VAL, 0, 19)
REG32(SUPPLY67_MAX, 0x174c)
    FIELD(SUPPLY67_MAX, VAL, 0, 19)
REG32(SUPPLY68_MAX, 0x1750)
    FIELD(SUPPLY68_MAX, VAL, 0, 19)
REG32(SUPPLY69_MAX, 0x1754)
    FIELD(SUPPLY69_MAX, VAL, 0, 19)
REG32(SUPPLY70_MAX, 0x1758)
    FIELD(SUPPLY70_MAX, VAL, 0, 19)
REG32(SUPPLY71_MAX, 0x175c)
    FIELD(SUPPLY71_MAX, VAL, 0, 19)
REG32(SUPPLY72_MAX, 0x1760)
    FIELD(SUPPLY72_MAX, VAL, 0, 19)
REG32(SUPPLY73_MAX, 0x1764)
    FIELD(SUPPLY73_MAX, VAL, 0, 19)
REG32(SUPPLY74_MAX, 0x1768)
    FIELD(SUPPLY74_MAX, VAL, 0, 19)
REG32(SUPPLY75_MAX, 0x176c)
    FIELD(SUPPLY75_MAX, VAL, 0, 19)
REG32(SUPPLY76_MAX, 0x1770)
    FIELD(SUPPLY76_MAX, VAL, 0, 19)
REG32(SUPPLY77_MAX, 0x1774)
    FIELD(SUPPLY77_MAX, VAL, 0, 19)
REG32(SUPPLY78_MAX, 0x1778)
    FIELD(SUPPLY78_MAX, VAL, 0, 19)
REG32(SUPPLY79_MAX, 0x177c)
    FIELD(SUPPLY79_MAX, VAL, 0, 19)
REG32(SUPPLY80_MAX, 0x1780)
    FIELD(SUPPLY80_MAX, VAL, 0, 19)
REG32(SUPPLY81_MAX, 0x1784)
    FIELD(SUPPLY81_MAX, VAL, 0, 19)
REG32(SUPPLY82_MAX, 0x1788)
    FIELD(SUPPLY82_MAX, VAL, 0, 19)
REG32(SUPPLY83_MAX, 0x178c)
    FIELD(SUPPLY83_MAX, VAL, 0, 19)
REG32(SUPPLY84_MAX, 0x1790)
    FIELD(SUPPLY84_MAX, VAL, 0, 19)
REG32(SUPPLY85_MAX, 0x1794)
    FIELD(SUPPLY85_MAX, VAL, 0, 19)
REG32(SUPPLY86_MAX, 0x1798)
    FIELD(SUPPLY86_MAX, VAL, 0, 19)
REG32(SUPPLY87_MAX, 0x179c)
    FIELD(SUPPLY87_MAX, VAL, 0, 19)
REG32(SUPPLY88_MAX, 0x17a0)
    FIELD(SUPPLY88_MAX, VAL, 0, 19)
REG32(SUPPLY89_MAX, 0x17a4)
    FIELD(SUPPLY89_MAX, VAL, 0, 19)
REG32(SUPPLY90_MAX, 0x17a8)
    FIELD(SUPPLY90_MAX, VAL, 0, 19)
REG32(SUPPLY91_MAX, 0x17ac)
    FIELD(SUPPLY91_MAX, VAL, 0, 19)
REG32(SUPPLY92_MAX, 0x17b0)
    FIELD(SUPPLY92_MAX, VAL, 0, 19)
REG32(SUPPLY93_MAX, 0x17b4)
    FIELD(SUPPLY93_MAX, VAL, 0, 19)
REG32(SUPPLY94_MAX, 0x17b8)
    FIELD(SUPPLY94_MAX, VAL, 0, 19)
REG32(SUPPLY95_MAX, 0x17bc)
    FIELD(SUPPLY95_MAX, VAL, 0, 19)
REG32(SUPPLY96_MAX, 0x17c0)
    FIELD(SUPPLY96_MAX, VAL, 0, 19)
REG32(SUPPLY97_MAX, 0x17c4)
    FIELD(SUPPLY97_MAX, VAL, 0, 19)
REG32(SUPPLY98_MAX, 0x17c8)
    FIELD(SUPPLY98_MAX, VAL, 0, 19)
REG32(SUPPLY99_MAX, 0x17cc)
    FIELD(SUPPLY99_MAX, VAL, 0, 19)
REG32(SUPPLY100_MAX, 0x17d0)
    FIELD(SUPPLY100_MAX, VAL, 0, 19)
REG32(SUPPLY101_MAX, 0x17d4)
    FIELD(SUPPLY101_MAX, VAL, 0, 19)
REG32(SUPPLY102_MAX, 0x17d8)
    FIELD(SUPPLY102_MAX, VAL, 0, 19)
REG32(SUPPLY103_MAX, 0x17dc)
    FIELD(SUPPLY103_MAX, VAL, 0, 19)
REG32(SUPPLY104_MAX, 0x17e0)
    FIELD(SUPPLY104_MAX, VAL, 0, 19)
REG32(SUPPLY105_MAX, 0x17e4)
    FIELD(SUPPLY105_MAX, VAL, 0, 19)
REG32(SUPPLY106_MAX, 0x17e8)
    FIELD(SUPPLY106_MAX, VAL, 0, 19)
REG32(SUPPLY107_MAX, 0x17ec)
    FIELD(SUPPLY107_MAX, VAL, 0, 19)
REG32(SUPPLY108_MAX, 0x17f0)
    FIELD(SUPPLY108_MAX, VAL, 0, 19)
REG32(SUPPLY109_MAX, 0x17f4)
    FIELD(SUPPLY109_MAX, VAL, 0, 19)
REG32(SUPPLY110_MAX, 0x17f8)
    FIELD(SUPPLY110_MAX, VAL, 0, 19)
REG32(SUPPLY111_MAX, 0x17fc)
    FIELD(SUPPLY111_MAX, VAL, 0, 19)
REG32(SUPPLY112_MAX, 0x1800)
    FIELD(SUPPLY112_MAX, VAL, 0, 19)
REG32(SUPPLY113_MAX, 0x1804)
    FIELD(SUPPLY113_MAX, VAL, 0, 19)
REG32(SUPPLY114_MAX, 0x1808)
    FIELD(SUPPLY114_MAX, VAL, 0, 19)
REG32(SUPPLY115_MAX, 0x180c)
    FIELD(SUPPLY115_MAX, VAL, 0, 19)
REG32(SUPPLY116_MAX, 0x1810)
    FIELD(SUPPLY116_MAX, VAL, 0, 19)
REG32(SUPPLY117_MAX, 0x1814)
    FIELD(SUPPLY117_MAX, VAL, 0, 19)
REG32(SUPPLY118_MAX, 0x1818)
    FIELD(SUPPLY118_MAX, VAL, 0, 19)
REG32(SUPPLY119_MAX, 0x181c)
    FIELD(SUPPLY119_MAX, VAL, 0, 19)
REG32(SUPPLY120_MAX, 0x1820)
    FIELD(SUPPLY120_MAX, VAL, 0, 19)
REG32(SUPPLY121_MAX, 0x1824)
    FIELD(SUPPLY121_MAX, VAL, 0, 19)
REG32(SUPPLY122_MAX, 0x1828)
    FIELD(SUPPLY122_MAX, VAL, 0, 19)
REG32(SUPPLY123_MAX, 0x182c)
    FIELD(SUPPLY123_MAX, VAL, 0, 19)
REG32(SUPPLY124_MAX, 0x1830)
    FIELD(SUPPLY124_MAX, VAL, 0, 19)
REG32(SUPPLY125_MAX, 0x1834)
    FIELD(SUPPLY125_MAX, VAL, 0, 19)
REG32(SUPPLY126_MAX, 0x1838)
    FIELD(SUPPLY126_MAX, VAL, 0, 19)
REG32(SUPPLY127_MAX, 0x183c)
    FIELD(SUPPLY127_MAX, VAL, 0, 19)
REG32(SUPPLY128_MAX, 0x1840)
    FIELD(SUPPLY128_MAX, VAL, 0, 19)
REG32(SUPPLY129_MAX, 0x1844)
    FIELD(SUPPLY129_MAX, VAL, 0, 19)
REG32(SUPPLY130_MAX, 0x1848)
    FIELD(SUPPLY130_MAX, VAL, 0, 19)
REG32(SUPPLY131_MAX, 0x184c)
    FIELD(SUPPLY131_MAX, VAL, 0, 19)
REG32(SUPPLY132_MAX, 0x1850)
    FIELD(SUPPLY132_MAX, VAL, 0, 19)
REG32(SUPPLY133_MAX, 0x1854)
    FIELD(SUPPLY133_MAX, VAL, 0, 19)
REG32(SUPPLY134_MAX, 0x1858)
    FIELD(SUPPLY134_MAX, VAL, 0, 19)
REG32(SUPPLY135_MAX, 0x185c)
    FIELD(SUPPLY135_MAX, VAL, 0, 19)
REG32(SUPPLY136_MAX, 0x1860)
    FIELD(SUPPLY136_MAX, VAL, 0, 19)
REG32(SUPPLY137_MAX, 0x1864)
    FIELD(SUPPLY137_MAX, VAL, 0, 19)
REG32(SUPPLY138_MAX, 0x1868)
    FIELD(SUPPLY138_MAX, VAL, 0, 19)
REG32(SUPPLY139_MAX, 0x186c)
    FIELD(SUPPLY139_MAX, VAL, 0, 19)
REG32(SUPPLY140_MAX, 0x1870)
    FIELD(SUPPLY140_MAX, VAL, 0, 19)
REG32(SUPPLY141_MAX, 0x1874)
    FIELD(SUPPLY141_MAX, VAL, 0, 19)
REG32(SUPPLY142_MAX, 0x1878)
    FIELD(SUPPLY142_MAX, VAL, 0, 19)
REG32(SUPPLY143_MAX, 0x187c)
    FIELD(SUPPLY143_MAX, VAL, 0, 19)
REG32(SUPPLY144_MAX, 0x1880)
    FIELD(SUPPLY144_MAX, VAL, 0, 19)
REG32(SUPPLY145_MAX, 0x1884)
    FIELD(SUPPLY145_MAX, VAL, 0, 19)
REG32(SUPPLY146_MAX, 0x1888)
    FIELD(SUPPLY146_MAX, VAL, 0, 19)
REG32(SUPPLY147_MAX, 0x188c)
    FIELD(SUPPLY147_MAX, VAL, 0, 19)
REG32(SUPPLY148_MAX, 0x1890)
    FIELD(SUPPLY148_MAX, VAL, 0, 19)
REG32(SUPPLY149_MAX, 0x1894)
    FIELD(SUPPLY149_MAX, VAL, 0, 19)
REG32(SUPPLY150_MAX, 0x1898)
    FIELD(SUPPLY150_MAX, VAL, 0, 19)
REG32(SUPPLY151_MAX, 0x189c)
    FIELD(SUPPLY151_MAX, VAL, 0, 19)
REG32(SUPPLY152_MAX, 0x18a0)
    FIELD(SUPPLY152_MAX, VAL, 0, 19)
REG32(SUPPLY153_MAX, 0x18a4)
    FIELD(SUPPLY153_MAX, VAL, 0, 19)
REG32(SUPPLY154_MAX, 0x18a8)
    FIELD(SUPPLY154_MAX, VAL, 0, 19)
REG32(SUPPLY155_MAX, 0x18ac)
    FIELD(SUPPLY155_MAX, VAL, 0, 19)
REG32(SUPPLY156_MAX, 0x18b0)
    FIELD(SUPPLY156_MAX, VAL, 0, 19)
REG32(SUPPLY157_MAX, 0x18b4)
    FIELD(SUPPLY157_MAX, VAL, 0, 19)
REG32(SUPPLY158_MAX, 0x18b8)
    FIELD(SUPPLY158_MAX, VAL, 0, 19)
REG32(SUPPLY159_MAX, 0x18bc)
    FIELD(SUPPLY159_MAX, VAL, 0, 19)
REG32(ALARM_REG0, 0x1940)
REG32(ALARM_REG1, 0x1944)
REG32(ALARM_REG2, 0x1948)
REG32(ALARM_REG3, 0x194c)
REG32(ALARM_REG4, 0x1950)
REG32(EN_AVG_REG0, 0x1958)
REG32(EN_AVG_REG1, 0x195c)
REG32(EN_AVG_REG2, 0x1960)
REG32(EN_AVG_REG3, 0x1964)
REG32(EN_AVG_REG4, 0x1968)
REG32(DEVICE_TEMP_TH_LOWER, 0x1970)
    FIELD(DEVICE_TEMP_TH_LOWER, VAL, 0, 16)
REG32(DEVICE_TEMP_TH_UPPER, 0x1974)
    FIELD(DEVICE_TEMP_TH_UPPER, VAL, 0, 16)
REG32(OT_TEMP_TH_LOWER, 0x1978)
    FIELD(OT_TEMP_TH_LOWER, VAL, 0, 16)
REG32(OT_TEMP_TH_UPPER, 0x197c)
    FIELD(OT_TEMP_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY0_TH_LOWER, 0x1980)
    FIELD(SUPPLY0_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY0_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY1_TH_LOWER, 0x1984)
    FIELD(SUPPLY1_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY1_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY2_TH_LOWER, 0x1988)
    FIELD(SUPPLY2_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY2_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY3_TH_LOWER, 0x198c)
    FIELD(SUPPLY3_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY3_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY4_TH_LOWER, 0x1990)
    FIELD(SUPPLY4_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY4_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY5_TH_LOWER, 0x1994)
    FIELD(SUPPLY5_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY5_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY6_TH_LOWER, 0x1998)
    FIELD(SUPPLY6_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY6_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY7_TH_LOWER, 0x199c)
    FIELD(SUPPLY7_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY7_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY8_TH_LOWER, 0x19a0)
    FIELD(SUPPLY8_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY8_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY9_TH_LOWER, 0x19a4)
    FIELD(SUPPLY9_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY9_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY10_TH_LOWER, 0x19a8)
    FIELD(SUPPLY10_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY10_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY11_TH_LOWER, 0x19ac)
    FIELD(SUPPLY11_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY11_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY12_TH_LOWER, 0x19b0)
    FIELD(SUPPLY12_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY12_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY13_TH_LOWER, 0x19b4)
    FIELD(SUPPLY13_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY13_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY14_TH_LOWER, 0x19b8)
    FIELD(SUPPLY14_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY14_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY15_TH_LOWER, 0x19bc)
    FIELD(SUPPLY15_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY15_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY16_TH_LOWER, 0x19c0)
    FIELD(SUPPLY16_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY16_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY17_TH_LOWER, 0x19c4)
    FIELD(SUPPLY17_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY17_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY18_TH_LOWER, 0x19c8)
    FIELD(SUPPLY18_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY18_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY19_TH_LOWER, 0x19cc)
    FIELD(SUPPLY19_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY19_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY20_TH_LOWER, 0x19d0)
    FIELD(SUPPLY20_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY20_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY21_TH_LOWER, 0x19d4)
    FIELD(SUPPLY21_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY21_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY22_TH_LOWER, 0x19d8)
    FIELD(SUPPLY22_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY22_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY23_TH_LOWER, 0x19dc)
    FIELD(SUPPLY23_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY23_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY24_TH_LOWER, 0x19e0)
    FIELD(SUPPLY24_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY24_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY25_TH_LOWER, 0x19e4)
    FIELD(SUPPLY25_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY25_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY26_TH_LOWER, 0x19e8)
    FIELD(SUPPLY26_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY26_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY27_TH_LOWER, 0x19ec)
    FIELD(SUPPLY27_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY27_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY28_TH_LOWER, 0x19f0)
    FIELD(SUPPLY28_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY28_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY29_TH_LOWER, 0x19f4)
    FIELD(SUPPLY29_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY29_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY30_TH_LOWER, 0x19f8)
    FIELD(SUPPLY30_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY30_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY31_TH_LOWER, 0x19fc)
    FIELD(SUPPLY31_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY31_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY32_TH_LOWER, 0x1a00)
    FIELD(SUPPLY32_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY32_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY33_TH_LOWER, 0x1a04)
    FIELD(SUPPLY33_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY33_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY34_TH_LOWER, 0x1a08)
    FIELD(SUPPLY34_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY34_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY35_TH_LOWER, 0x1a0c)
    FIELD(SUPPLY35_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY35_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY36_TH_LOWER, 0x1a10)
    FIELD(SUPPLY36_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY36_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY37_TH_LOWER, 0x1a14)
    FIELD(SUPPLY37_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY37_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY38_TH_LOWER, 0x1a18)
    FIELD(SUPPLY38_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY38_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY39_TH_LOWER, 0x1a1c)
    FIELD(SUPPLY39_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY39_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY40_TH_LOWER, 0x1a20)
    FIELD(SUPPLY40_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY40_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY41_TH_LOWER, 0x1a24)
    FIELD(SUPPLY41_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY41_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY42_TH_LOWER, 0x1a28)
    FIELD(SUPPLY42_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY42_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY43_TH_LOWER, 0x1a2c)
    FIELD(SUPPLY43_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY43_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY44_TH_LOWER, 0x1a30)
    FIELD(SUPPLY44_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY44_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY45_TH_LOWER, 0x1a34)
    FIELD(SUPPLY45_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY45_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY46_TH_LOWER, 0x1a38)
    FIELD(SUPPLY46_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY46_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY47_TH_LOWER, 0x1a3c)
    FIELD(SUPPLY47_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY47_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY48_TH_LOWER, 0x1a40)
    FIELD(SUPPLY48_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY48_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY49_TH_LOWER, 0x1a44)
    FIELD(SUPPLY49_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY49_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY50_TH_LOWER, 0x1a48)
    FIELD(SUPPLY50_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY50_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY51_TH_LOWER, 0x1a4c)
    FIELD(SUPPLY51_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY51_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY52_TH_LOWER, 0x1a50)
    FIELD(SUPPLY52_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY52_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY53_TH_LOWER, 0x1a54)
    FIELD(SUPPLY53_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY53_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY54_TH_LOWER, 0x1a58)
    FIELD(SUPPLY54_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY54_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY55_TH_LOWER, 0x1a5c)
    FIELD(SUPPLY55_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY55_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY56_TH_LOWER, 0x1a60)
    FIELD(SUPPLY56_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY56_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY57_TH_LOWER, 0x1a64)
    FIELD(SUPPLY57_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY57_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY58_TH_LOWER, 0x1a68)
    FIELD(SUPPLY58_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY58_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY59_TH_LOWER, 0x1a6c)
    FIELD(SUPPLY59_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY59_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY60_TH_LOWER, 0x1a70)
    FIELD(SUPPLY60_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY60_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY61_TH_LOWER, 0x1a74)
    FIELD(SUPPLY61_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY61_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY62_TH_LOWER, 0x1a78)
    FIELD(SUPPLY62_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY62_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY63_TH_LOWER, 0x1a7c)
    FIELD(SUPPLY63_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY63_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY64_TH_LOWER, 0x1a80)
    FIELD(SUPPLY64_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY64_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY65_TH_LOWER, 0x1a84)
    FIELD(SUPPLY65_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY65_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY66_TH_LOWER, 0x1a88)
    FIELD(SUPPLY66_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY66_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY67_TH_LOWER, 0x1a8c)
    FIELD(SUPPLY67_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY67_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY68_TH_LOWER, 0x1a90)
    FIELD(SUPPLY68_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY68_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY69_TH_LOWER, 0x1a94)
    FIELD(SUPPLY69_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY69_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY70_TH_LOWER, 0x1a98)
    FIELD(SUPPLY70_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY70_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY71_TH_LOWER, 0x1a9c)
    FIELD(SUPPLY71_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY71_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY72_TH_LOWER, 0x1aa0)
    FIELD(SUPPLY72_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY72_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY73_TH_LOWER, 0x1aa4)
    FIELD(SUPPLY73_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY73_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY74_TH_LOWER, 0x1aa8)
    FIELD(SUPPLY74_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY74_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY75_TH_LOWER, 0x1aac)
    FIELD(SUPPLY75_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY75_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY76_TH_LOWER, 0x1ab0)
    FIELD(SUPPLY76_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY76_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY77_TH_LOWER, 0x1ab4)
    FIELD(SUPPLY77_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY77_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY78_TH_LOWER, 0x1ab8)
    FIELD(SUPPLY78_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY78_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY79_TH_LOWER, 0x1abc)
    FIELD(SUPPLY79_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY79_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY80_TH_LOWER, 0x1ac0)
    FIELD(SUPPLY80_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY80_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY81_TH_LOWER, 0x1ac4)
    FIELD(SUPPLY81_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY81_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY82_TH_LOWER, 0x1ac8)
    FIELD(SUPPLY82_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY82_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY83_TH_LOWER, 0x1acc)
    FIELD(SUPPLY83_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY83_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY84_TH_LOWER, 0x1ad0)
    FIELD(SUPPLY84_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY84_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY85_TH_LOWER, 0x1ad4)
    FIELD(SUPPLY85_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY85_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY86_TH_LOWER, 0x1ad8)
    FIELD(SUPPLY86_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY86_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY87_TH_LOWER, 0x1adc)
    FIELD(SUPPLY87_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY87_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY88_TH_LOWER, 0x1ae0)
    FIELD(SUPPLY88_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY88_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY89_TH_LOWER, 0x1ae4)
    FIELD(SUPPLY89_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY89_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY90_TH_LOWER, 0x1ae8)
    FIELD(SUPPLY90_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY90_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY91_TH_LOWER, 0x1aec)
    FIELD(SUPPLY91_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY91_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY92_TH_LOWER, 0x1af0)
    FIELD(SUPPLY92_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY92_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY93_TH_LOWER, 0x1af4)
    FIELD(SUPPLY93_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY93_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY94_TH_LOWER, 0x1af8)
    FIELD(SUPPLY94_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY94_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY95_TH_LOWER, 0x1afc)
    FIELD(SUPPLY95_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY95_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY96_TH_LOWER, 0x1b00)
    FIELD(SUPPLY96_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY96_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY97_TH_LOWER, 0x1b04)
    FIELD(SUPPLY97_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY97_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY98_TH_LOWER, 0x1b08)
    FIELD(SUPPLY98_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY98_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY99_TH_LOWER, 0x1b0c)
    FIELD(SUPPLY99_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY99_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY100_TH_LOWER, 0x1b10)
    FIELD(SUPPLY100_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY100_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY101_TH_LOWER, 0x1b14)
    FIELD(SUPPLY101_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY101_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY102_TH_LOWER, 0x1b18)
    FIELD(SUPPLY102_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY102_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY103_TH_LOWER, 0x1b1c)
    FIELD(SUPPLY103_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY103_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY104_TH_LOWER, 0x1b20)
    FIELD(SUPPLY104_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY104_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY105_TH_LOWER, 0x1b24)
    FIELD(SUPPLY105_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY105_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY106_TH_LOWER, 0x1b28)
    FIELD(SUPPLY106_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY106_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY107_TH_LOWER, 0x1b2c)
    FIELD(SUPPLY107_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY107_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY108_TH_LOWER, 0x1b30)
    FIELD(SUPPLY108_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY108_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY109_TH_LOWER, 0x1b34)
    FIELD(SUPPLY109_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY109_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY110_TH_LOWER, 0x1b38)
    FIELD(SUPPLY110_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY110_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY111_TH_LOWER, 0x1b3c)
    FIELD(SUPPLY111_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY111_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY112_TH_LOWER, 0x1b40)
    FIELD(SUPPLY112_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY112_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY113_TH_LOWER, 0x1b44)
    FIELD(SUPPLY113_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY113_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY114_TH_LOWER, 0x1b48)
    FIELD(SUPPLY114_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY114_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY115_TH_LOWER, 0x1b4c)
    FIELD(SUPPLY115_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY115_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY116_TH_LOWER, 0x1b50)
    FIELD(SUPPLY116_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY116_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY117_TH_LOWER, 0x1b54)
    FIELD(SUPPLY117_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY117_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY118_TH_LOWER, 0x1b58)
    FIELD(SUPPLY118_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY118_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY119_TH_LOWER, 0x1b5c)
    FIELD(SUPPLY119_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY119_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY120_TH_LOWER, 0x1b60)
    FIELD(SUPPLY120_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY120_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY121_TH_LOWER, 0x1b64)
    FIELD(SUPPLY121_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY121_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY122_TH_LOWER, 0x1b68)
    FIELD(SUPPLY122_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY122_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY123_TH_LOWER, 0x1b6c)
    FIELD(SUPPLY123_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY123_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY124_TH_LOWER, 0x1b70)
    FIELD(SUPPLY124_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY124_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY125_TH_LOWER, 0x1b74)
    FIELD(SUPPLY125_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY125_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY126_TH_LOWER, 0x1b78)
    FIELD(SUPPLY126_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY126_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY127_TH_LOWER, 0x1b7c)
    FIELD(SUPPLY127_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY127_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY128_TH_LOWER, 0x1b80)
    FIELD(SUPPLY128_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY128_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY129_TH_LOWER, 0x1b84)
    FIELD(SUPPLY129_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY129_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY130_TH_LOWER, 0x1b88)
    FIELD(SUPPLY130_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY130_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY131_TH_LOWER, 0x1b8c)
    FIELD(SUPPLY131_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY131_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY132_TH_LOWER, 0x1b90)
    FIELD(SUPPLY132_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY132_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY133_TH_LOWER, 0x1b94)
    FIELD(SUPPLY133_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY133_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY134_TH_LOWER, 0x1b98)
    FIELD(SUPPLY134_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY134_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY135_TH_LOWER, 0x1b9c)
    FIELD(SUPPLY135_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY135_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY136_TH_LOWER, 0x1ba0)
    FIELD(SUPPLY136_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY136_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY137_TH_LOWER, 0x1ba4)
    FIELD(SUPPLY137_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY137_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY138_TH_LOWER, 0x1ba8)
    FIELD(SUPPLY138_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY138_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY139_TH_LOWER, 0x1bac)
    FIELD(SUPPLY139_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY139_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY140_TH_LOWER, 0x1bb0)
    FIELD(SUPPLY140_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY140_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY141_TH_LOWER, 0x1bb4)
    FIELD(SUPPLY141_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY141_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY142_TH_LOWER, 0x1bb8)
    FIELD(SUPPLY142_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY142_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY143_TH_LOWER, 0x1bbc)
    FIELD(SUPPLY143_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY143_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY144_TH_LOWER, 0x1bc0)
    FIELD(SUPPLY144_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY144_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY145_TH_LOWER, 0x1bc4)
    FIELD(SUPPLY145_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY145_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY146_TH_LOWER, 0x1bc8)
    FIELD(SUPPLY146_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY146_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY147_TH_LOWER, 0x1bcc)
    FIELD(SUPPLY147_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY147_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY148_TH_LOWER, 0x1bd0)
    FIELD(SUPPLY148_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY148_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY149_TH_LOWER, 0x1bd4)
    FIELD(SUPPLY149_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY149_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY150_TH_LOWER, 0x1bd8)
    FIELD(SUPPLY150_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY150_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY151_TH_LOWER, 0x1bdc)
    FIELD(SUPPLY151_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY151_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY152_TH_LOWER, 0x1be0)
    FIELD(SUPPLY152_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY152_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY153_TH_LOWER, 0x1be4)
    FIELD(SUPPLY153_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY153_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY154_TH_LOWER, 0x1be8)
    FIELD(SUPPLY154_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY154_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY155_TH_LOWER, 0x1bec)
    FIELD(SUPPLY155_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY155_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY156_TH_LOWER, 0x1bf0)
    FIELD(SUPPLY156_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY156_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY157_TH_LOWER, 0x1bf4)
    FIELD(SUPPLY157_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY157_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY158_TH_LOWER, 0x1bf8)
    FIELD(SUPPLY158_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY158_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY159_TH_LOWER, 0x1bfc)
    FIELD(SUPPLY159_TH_LOWER, VAL_RO, 16, 3)
    FIELD(SUPPLY159_TH_LOWER, VAL, 0, 16)
REG32(SUPPLY0_TH_UPPER, 0x1c80)
    FIELD(SUPPLY0_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY0_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY1_TH_UPPER, 0x1c84)
    FIELD(SUPPLY1_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY1_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY2_TH_UPPER, 0x1c88)
    FIELD(SUPPLY2_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY2_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY3_TH_UPPER, 0x1c8c)
    FIELD(SUPPLY3_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY3_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY4_TH_UPPER, 0x1c90)
    FIELD(SUPPLY4_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY4_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY5_TH_UPPER, 0x1c94)
    FIELD(SUPPLY5_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY5_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY6_TH_UPPER, 0x1c98)
    FIELD(SUPPLY6_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY6_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY7_TH_UPPER, 0x1c9c)
    FIELD(SUPPLY7_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY7_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY8_TH_UPPER, 0x1ca0)
    FIELD(SUPPLY8_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY8_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY9_TH_UPPER, 0x1ca4)
    FIELD(SUPPLY9_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY9_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY10_TH_UPPER, 0x1ca8)
    FIELD(SUPPLY10_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY10_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY11_TH_UPPER, 0x1cac)
    FIELD(SUPPLY11_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY11_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY12_TH_UPPER, 0x1cb0)
    FIELD(SUPPLY12_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY12_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY13_TH_UPPER, 0x1cb4)
    FIELD(SUPPLY13_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY13_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY14_TH_UPPER, 0x1cb8)
    FIELD(SUPPLY14_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY14_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY15_TH_UPPER, 0x1cbc)
    FIELD(SUPPLY15_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY15_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY16_TH_UPPER, 0x1cc0)
    FIELD(SUPPLY16_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY16_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY17_TH_UPPER, 0x1cc4)
    FIELD(SUPPLY17_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY17_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY18_TH_UPPER, 0x1cc8)
    FIELD(SUPPLY18_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY18_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY19_TH_UPPER, 0x1ccc)
    FIELD(SUPPLY19_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY19_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY20_TH_UPPER, 0x1cd0)
    FIELD(SUPPLY20_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY20_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY21_TH_UPPER, 0x1cd4)
    FIELD(SUPPLY21_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY21_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY22_TH_UPPER, 0x1cd8)
    FIELD(SUPPLY22_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY22_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY23_TH_UPPER, 0x1cdc)
    FIELD(SUPPLY23_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY23_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY24_TH_UPPER, 0x1ce0)
    FIELD(SUPPLY24_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY24_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY25_TH_UPPER, 0x1ce4)
    FIELD(SUPPLY25_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY25_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY26_TH_UPPER, 0x1ce8)
    FIELD(SUPPLY26_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY26_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY27_TH_UPPER, 0x1cec)
    FIELD(SUPPLY27_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY27_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY28_TH_UPPER, 0x1cf0)
    FIELD(SUPPLY28_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY28_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY29_TH_UPPER, 0x1cf4)
    FIELD(SUPPLY29_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY29_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY30_TH_UPPER, 0x1cf8)
    FIELD(SUPPLY30_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY30_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY31_TH_UPPER, 0x1cfc)
    FIELD(SUPPLY31_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY31_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY32_TH_UPPER, 0x1d00)
    FIELD(SUPPLY32_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY32_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY33_TH_UPPER, 0x1d04)
    FIELD(SUPPLY33_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY33_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY34_TH_UPPER, 0x1d08)
    FIELD(SUPPLY34_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY34_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY35_TH_UPPER, 0x1d0c)
    FIELD(SUPPLY35_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY35_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY36_TH_UPPER, 0x1d10)
    FIELD(SUPPLY36_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY36_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY37_TH_UPPER, 0x1d14)
    FIELD(SUPPLY37_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY37_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY38_TH_UPPER, 0x1d18)
    FIELD(SUPPLY38_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY38_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY39_TH_UPPER, 0x1d1c)
    FIELD(SUPPLY39_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY39_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY40_TH_UPPER, 0x1d20)
    FIELD(SUPPLY40_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY40_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY41_TH_UPPER, 0x1d24)
    FIELD(SUPPLY41_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY41_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY42_TH_UPPER, 0x1d28)
    FIELD(SUPPLY42_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY42_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY43_TH_UPPER, 0x1d2c)
    FIELD(SUPPLY43_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY43_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY44_TH_UPPER, 0x1d30)
    FIELD(SUPPLY44_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY44_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY45_TH_UPPER, 0x1d34)
    FIELD(SUPPLY45_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY45_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY46_TH_UPPER, 0x1d38)
    FIELD(SUPPLY46_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY46_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY47_TH_UPPER, 0x1d3c)
    FIELD(SUPPLY47_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY47_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY48_TH_UPPER, 0x1d40)
    FIELD(SUPPLY48_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY48_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY49_TH_UPPER, 0x1d44)
    FIELD(SUPPLY49_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY49_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY50_TH_UPPER, 0x1d48)
    FIELD(SUPPLY50_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY50_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY51_TH_UPPER, 0x1d4c)
    FIELD(SUPPLY51_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY51_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY52_TH_UPPER, 0x1d50)
    FIELD(SUPPLY52_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY52_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY53_TH_UPPER, 0x1d54)
    FIELD(SUPPLY53_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY53_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY54_TH_UPPER, 0x1d58)
    FIELD(SUPPLY54_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY54_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY55_TH_UPPER, 0x1d5c)
    FIELD(SUPPLY55_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY55_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY56_TH_UPPER, 0x1d60)
    FIELD(SUPPLY56_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY56_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY57_TH_UPPER, 0x1d64)
    FIELD(SUPPLY57_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY57_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY58_TH_UPPER, 0x1d68)
    FIELD(SUPPLY58_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY58_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY59_TH_UPPER, 0x1d6c)
    FIELD(SUPPLY59_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY59_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY60_TH_UPPER, 0x1d70)
    FIELD(SUPPLY60_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY60_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY61_TH_UPPER, 0x1d74)
    FIELD(SUPPLY61_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY61_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY62_TH_UPPER, 0x1d78)
    FIELD(SUPPLY62_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY62_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY63_TH_UPPER, 0x1d7c)
    FIELD(SUPPLY63_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY63_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY64_TH_UPPER, 0x1d80)
    FIELD(SUPPLY64_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY64_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY65_TH_UPPER, 0x1d84)
    FIELD(SUPPLY65_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY65_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY66_TH_UPPER, 0x1d88)
    FIELD(SUPPLY66_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY66_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY67_TH_UPPER, 0x1d8c)
    FIELD(SUPPLY67_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY67_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY68_TH_UPPER, 0x1d90)
    FIELD(SUPPLY68_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY68_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY69_TH_UPPER, 0x1d94)
    FIELD(SUPPLY69_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY69_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY70_TH_UPPER, 0x1d98)
    FIELD(SUPPLY70_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY70_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY71_TH_UPPER, 0x1d9c)
    FIELD(SUPPLY71_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY71_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY72_TH_UPPER, 0x1da0)
    FIELD(SUPPLY72_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY72_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY73_TH_UPPER, 0x1da4)
    FIELD(SUPPLY73_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY73_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY74_TH_UPPER, 0x1da8)
    FIELD(SUPPLY74_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY74_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY75_TH_UPPER, 0x1dac)
    FIELD(SUPPLY75_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY75_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY76_TH_UPPER, 0x1db0)
    FIELD(SUPPLY76_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY76_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY77_TH_UPPER, 0x1db4)
    FIELD(SUPPLY77_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY77_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY78_TH_UPPER, 0x1db8)
    FIELD(SUPPLY78_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY78_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY79_TH_UPPER, 0x1dbc)
    FIELD(SUPPLY79_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY79_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY80_TH_UPPER, 0x1dc0)
    FIELD(SUPPLY80_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY80_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY81_TH_UPPER, 0x1dc4)
    FIELD(SUPPLY81_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY81_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY82_TH_UPPER, 0x1dc8)
    FIELD(SUPPLY82_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY82_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY83_TH_UPPER, 0x1dcc)
    FIELD(SUPPLY83_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY83_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY84_TH_UPPER, 0x1dd0)
    FIELD(SUPPLY84_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY84_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY85_TH_UPPER, 0x1dd4)
    FIELD(SUPPLY85_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY85_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY86_TH_UPPER, 0x1dd8)
    FIELD(SUPPLY86_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY86_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY87_TH_UPPER, 0x1ddc)
    FIELD(SUPPLY87_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY87_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY88_TH_UPPER, 0x1de0)
    FIELD(SUPPLY88_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY88_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY89_TH_UPPER, 0x1de4)
    FIELD(SUPPLY89_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY89_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY90_TH_UPPER, 0x1de8)
    FIELD(SUPPLY90_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY90_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY91_TH_UPPER, 0x1dec)
    FIELD(SUPPLY91_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY91_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY92_TH_UPPER, 0x1df0)
    FIELD(SUPPLY92_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY92_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY93_TH_UPPER, 0x1df4)
    FIELD(SUPPLY93_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY93_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY94_TH_UPPER, 0x1df8)
    FIELD(SUPPLY94_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY94_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY95_TH_UPPER, 0x1dfc)
    FIELD(SUPPLY95_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY95_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY96_TH_UPPER, 0x1e00)
    FIELD(SUPPLY96_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY96_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY97_TH_UPPER, 0x1e04)
    FIELD(SUPPLY97_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY97_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY98_TH_UPPER, 0x1e08)
    FIELD(SUPPLY98_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY98_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY99_TH_UPPER, 0x1e0c)
    FIELD(SUPPLY99_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY99_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY100_TH_UPPER, 0x1e10)
    FIELD(SUPPLY100_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY100_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY101_TH_UPPER, 0x1e14)
    FIELD(SUPPLY101_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY101_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY102_TH_UPPER, 0x1e18)
    FIELD(SUPPLY102_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY102_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY103_TH_UPPER, 0x1e1c)
    FIELD(SUPPLY103_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY103_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY104_TH_UPPER, 0x1e20)
    FIELD(SUPPLY104_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY104_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY105_TH_UPPER, 0x1e24)
    FIELD(SUPPLY105_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY105_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY106_TH_UPPER, 0x1e28)
    FIELD(SUPPLY106_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY106_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY107_TH_UPPER, 0x1e2c)
    FIELD(SUPPLY107_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY107_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY108_TH_UPPER, 0x1e30)
    FIELD(SUPPLY108_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY108_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY109_TH_UPPER, 0x1e34)
    FIELD(SUPPLY109_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY109_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY110_TH_UPPER, 0x1e38)
    FIELD(SUPPLY110_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY110_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY111_TH_UPPER, 0x1e3c)
    FIELD(SUPPLY111_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY111_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY112_TH_UPPER, 0x1e40)
    FIELD(SUPPLY112_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY112_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY113_TH_UPPER, 0x1e44)
    FIELD(SUPPLY113_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY113_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY114_TH_UPPER, 0x1e48)
    FIELD(SUPPLY114_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY114_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY115_TH_UPPER, 0x1e4c)
    FIELD(SUPPLY115_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY115_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY116_TH_UPPER, 0x1e50)
    FIELD(SUPPLY116_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY116_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY117_TH_UPPER, 0x1e54)
    FIELD(SUPPLY117_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY117_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY118_TH_UPPER, 0x1e58)
    FIELD(SUPPLY118_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY118_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY119_TH_UPPER, 0x1e5c)
    FIELD(SUPPLY119_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY119_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY120_TH_UPPER, 0x1e60)
    FIELD(SUPPLY120_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY120_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY121_TH_UPPER, 0x1e64)
    FIELD(SUPPLY121_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY121_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY122_TH_UPPER, 0x1e68)
    FIELD(SUPPLY122_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY122_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY123_TH_UPPER, 0x1e6c)
    FIELD(SUPPLY123_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY123_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY124_TH_UPPER, 0x1e70)
    FIELD(SUPPLY124_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY124_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY125_TH_UPPER, 0x1e74)
    FIELD(SUPPLY125_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY125_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY126_TH_UPPER, 0x1e78)
    FIELD(SUPPLY126_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY126_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY127_TH_UPPER, 0x1e7c)
    FIELD(SUPPLY127_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY127_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY128_TH_UPPER, 0x1e80)
    FIELD(SUPPLY128_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY128_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY129_TH_UPPER, 0x1e84)
    FIELD(SUPPLY129_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY129_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY130_TH_UPPER, 0x1e88)
    FIELD(SUPPLY130_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY130_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY131_TH_UPPER, 0x1e8c)
    FIELD(SUPPLY131_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY131_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY132_TH_UPPER, 0x1e90)
    FIELD(SUPPLY132_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY132_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY133_TH_UPPER, 0x1e94)
    FIELD(SUPPLY133_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY133_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY134_TH_UPPER, 0x1e98)
    FIELD(SUPPLY134_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY134_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY135_TH_UPPER, 0x1e9c)
    FIELD(SUPPLY135_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY135_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY136_TH_UPPER, 0x1ea0)
    FIELD(SUPPLY136_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY136_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY137_TH_UPPER, 0x1ea4)
    FIELD(SUPPLY137_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY137_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY138_TH_UPPER, 0x1ea8)
    FIELD(SUPPLY138_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY138_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY139_TH_UPPER, 0x1eac)
    FIELD(SUPPLY139_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY139_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY140_TH_UPPER, 0x1eb0)
    FIELD(SUPPLY140_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY140_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY141_TH_UPPER, 0x1eb4)
    FIELD(SUPPLY141_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY141_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY142_TH_UPPER, 0x1eb8)
    FIELD(SUPPLY142_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY142_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY143_TH_UPPER, 0x1ebc)
    FIELD(SUPPLY143_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY143_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY144_TH_UPPER, 0x1ec0)
    FIELD(SUPPLY144_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY144_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY145_TH_UPPER, 0x1ec4)
    FIELD(SUPPLY145_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY145_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY146_TH_UPPER, 0x1ec8)
    FIELD(SUPPLY146_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY146_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY147_TH_UPPER, 0x1ecc)
    FIELD(SUPPLY147_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY147_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY148_TH_UPPER, 0x1ed0)
    FIELD(SUPPLY148_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY148_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY149_TH_UPPER, 0x1ed4)
    FIELD(SUPPLY149_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY149_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY150_TH_UPPER, 0x1ed8)
    FIELD(SUPPLY150_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY150_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY151_TH_UPPER, 0x1edc)
    FIELD(SUPPLY151_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY151_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY152_TH_UPPER, 0x1ee0)
    FIELD(SUPPLY152_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY152_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY153_TH_UPPER, 0x1ee4)
    FIELD(SUPPLY153_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY153_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY154_TH_UPPER, 0x1ee8)
    FIELD(SUPPLY154_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY154_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY155_TH_UPPER, 0x1eec)
    FIELD(SUPPLY155_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY155_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY156_TH_UPPER, 0x1ef0)
    FIELD(SUPPLY156_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY156_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY157_TH_UPPER, 0x1ef4)
    FIELD(SUPPLY157_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY157_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY158_TH_UPPER, 0x1ef8)
    FIELD(SUPPLY158_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY158_TH_UPPER, VAL, 0, 16)
REG32(SUPPLY159_TH_UPPER, 0x1efc)
    FIELD(SUPPLY159_TH_UPPER, VAL_RO, 16, 3)
    FIELD(SUPPLY159_TH_UPPER, VAL, 0, 16)
REG32(NEW_DATA_INT_SRC, 0x1f80)
    FIELD(NEW_DATA_INT_SRC, ADDR_ID3, 24, 8)
    FIELD(NEW_DATA_INT_SRC, ADDR_ID2, 16, 8)
    FIELD(NEW_DATA_INT_SRC, ADDR_ID1, 8, 8)
    FIELD(NEW_DATA_INT_SRC, ADDR_ID0, 0, 8)
REG32(ALARM_CONFIG, 0x1f84)
    FIELD(ALARM_CONFIG, DEV_ALARM_MODE, 1, 1)
    FIELD(ALARM_CONFIG, OT_ALARM_MODE, 0, 1)
REG32(I2C_STATUS, 0x1f88)
    FIELD(I2C_STATUS, ADDRESSED, 1, 1)
    FIELD(I2C_STATUS, BUS_BUSY, 0, 1)
REG32(DEVICE_TEMP_MIN_MIN, 0x1f8c)
    FIELD(DEVICE_TEMP_MIN_MIN, VAL, 0, 16)
REG32(DEVICE_TEMP_MAX_MAX, 0x1f90)
    FIELD(DEVICE_TEMP_MAX_MAX, VAL, 0, 16)
REG32(STATUS_RESET, 0x1f94)
    FIELD(STATUS_RESET, SUPPLY, 1, 1)
    FIELD(STATUS_RESET, DEVICE_TEMP, 0, 1)
REG32(GREF_STATUS, 0x1f98)
    FIELD(GREF_STATUS, REF_SEL, 1, 4)
    FIELD(GREF_STATUS, EXT_REF_UP, 0, 1)
REG32(AXI_CONFIG, 0x1f9c)
    FIELD(AXI_CONFIG, BUFFER_BASE_B48, 24, 1)
    FIELD(AXI_CONFIG, SUPPLY_EN, 23, 1)
    FIELD(AXI_CONFIG, VCCINT_EN, 22, 1)
    FIELD(AXI_CONFIG, SLICE_TEMP_EN, 21, 1)
    FIELD(AXI_CONFIG, TEMP_EN, 20, 1)
    FIELD(AXI_CONFIG, AWLEN, 12, 8)
    FIELD(AXI_CONFIG, AWQOS, 8, 4)
    FIELD(AXI_CONFIG, AWBURST, 6, 2)
    FIELD(AXI_CONFIG, ENABLE, 5, 1)
    FIELD(AXI_CONFIG, NUM_TRANS, 0, 5)
REG32(CLOCK_GATE_OR, 0x1fa0)
    FIELD(CLOCK_GATE_OR, AXI_CG_OR, 10, 1)
    FIELD(CLOCK_GATE_OR, PMBUS_CG_OR, 7, 3)
    FIELD(CLOCK_GATE_OR, SYS_MEAS_CG_OR, 5, 2)
    FIELD(CLOCK_GATE_OR, SPLY_MEAS_CG_OR, 0, 5)
REG32(VCCINT_FPD, 0x1fa4)
    FIELD(VCCINT_FPD, VAL, 0, 19)
REG32(VCCINT_LPD, 0x1fa8)
    FIELD(VCCINT_LPD, VAL, 0, 19)
REG32(TEMP_SAT1, 0x1fac)
    FIELD(TEMP_SAT1, VAL, 0, 16)
REG32(TEMP_SAT2, 0x1fb0)
    FIELD(TEMP_SAT2, VAL, 0, 16)
REG32(TEMP_SAT3, 0x1fb4)
    FIELD(TEMP_SAT3, VAL, 0, 16)
REG32(TEMP_SAT4, 0x1fb8)
    FIELD(TEMP_SAT4, VAL, 0, 16)
REG32(TEMP_SAT5, 0x1fbc)
    FIELD(TEMP_SAT5, VAL, 0, 16)
REG32(TEMP_SAT6, 0x1fc0)
    FIELD(TEMP_SAT6, VAL, 0, 16)
REG32(TEMP_SAT7, 0x1fc4)
    FIELD(TEMP_SAT7, VAL, 0, 16)
REG32(TEMP_SAT8, 0x1fc8)
    FIELD(TEMP_SAT8, VAL, 0, 16)
REG32(TEMP_SAT9, 0x1fcc)
    FIELD(TEMP_SAT9, VAL, 0, 16)
REG32(TEMP_SAT10, 0x1fd0)
    FIELD(TEMP_SAT10, VAL, 0, 16)
REG32(TEMP_SAT11, 0x1fd4)
    FIELD(TEMP_SAT11, VAL, 0, 16)
REG32(TEMP_SAT12, 0x1fd8)
    FIELD(TEMP_SAT12, VAL, 0, 16)
REG32(TEMP_SAT13, 0x1fdc)
    FIELD(TEMP_SAT13, VAL, 0, 16)
REG32(TEMP_SAT14, 0x1fe0)
    FIELD(TEMP_SAT14, VAL, 0, 16)
REG32(TEMP_SAT15, 0x1fe4)
    FIELD(TEMP_SAT15, VAL, 0, 16)
REG32(TEMP_SAT16, 0x1fe8)
    FIELD(TEMP_SAT16, VAL, 0, 16)
REG32(TEMP_SAT17, 0x1fec)
    FIELD(TEMP_SAT17, VAL, 0, 16)
REG32(TEMP_SAT18, 0x1ff0)
    FIELD(TEMP_SAT18, VAL, 0, 16)
REG32(TEMP_SAT19, 0x1ff4)
    FIELD(TEMP_SAT19, VAL, 0, 16)
REG32(TEMP_SAT20, 0x1ff8)
    FIELD(TEMP_SAT20, VAL, 0, 16)
REG32(TEMP_SAT21, 0x1ffc)
    FIELD(TEMP_SAT21, VAL, 0, 16)
REG32(TEMP_SAT22, 0x2000)
    FIELD(TEMP_SAT22, VAL, 0, 16)
REG32(TEMP_SAT23, 0x2004)
    FIELD(TEMP_SAT23, VAL, 0, 16)
REG32(TEMP_SAT24, 0x2008)
    FIELD(TEMP_SAT24, VAL, 0, 16)
REG32(TEMP_SAT25, 0x200c)
    FIELD(TEMP_SAT25, VAL, 0, 16)
REG32(TEMP_SAT26, 0x2010)
    FIELD(TEMP_SAT26, VAL, 0, 16)
REG32(TEMP_SAT27, 0x2014)
    FIELD(TEMP_SAT27, VAL, 0, 16)
REG32(TEMP_SAT28, 0x2018)
    FIELD(TEMP_SAT28, VAL, 0, 16)
REG32(TEMP_SAT29, 0x201c)
    FIELD(TEMP_SAT29, VAL, 0, 16)
REG32(TEMP_SAT30, 0x2020)
    FIELD(TEMP_SAT30, VAL, 0, 16)
REG32(TEMP_SAT31, 0x2024)
    FIELD(TEMP_SAT31, VAL, 0, 16)
REG32(TEMP_SAT32, 0x2028)
    FIELD(TEMP_SAT32, VAL, 0, 16)
REG32(TEMP_SAT33, 0x202c)
    FIELD(TEMP_SAT33, VAL, 0, 16)
REG32(TEMP_SAT34, 0x2030)
    FIELD(TEMP_SAT34, VAL, 0, 16)
REG32(TEMP_SAT35, 0x2034)
    FIELD(TEMP_SAT35, VAL, 0, 16)
REG32(TEMP_SAT36, 0x2038)
    FIELD(TEMP_SAT36, VAL, 0, 16)
REG32(TEMP_SAT37, 0x203c)
    FIELD(TEMP_SAT37, VAL, 0, 16)
REG32(TEMP_SAT38, 0x2040)
    FIELD(TEMP_SAT38, VAL, 0, 16)
REG32(TEMP_SAT39, 0x2044)
    FIELD(TEMP_SAT39, VAL, 0, 16)
REG32(TEMP_SAT40, 0x2048)
    FIELD(TEMP_SAT40, VAL, 0, 16)
REG32(TEMP_SAT41, 0x204c)
    FIELD(TEMP_SAT41, VAL, 0, 16)
REG32(TEMP_SAT42, 0x2050)
    FIELD(TEMP_SAT42, VAL, 0, 16)
REG32(TEMP_SAT43, 0x2054)
    FIELD(TEMP_SAT43, VAL, 0, 16)
REG32(TEMP_SAT44, 0x2058)
    FIELD(TEMP_SAT44, VAL, 0, 16)
REG32(TEMP_SAT45, 0x205c)
    FIELD(TEMP_SAT45, VAL, 0, 16)
REG32(TEMP_SAT46, 0x2060)
    FIELD(TEMP_SAT46, VAL, 0, 16)
REG32(TEMP_SAT47, 0x2064)
    FIELD(TEMP_SAT47, VAL, 0, 16)
REG32(TEMP_SAT48, 0x2068)
    FIELD(TEMP_SAT48, VAL, 0, 16)
REG32(TEMP_SAT49, 0x206c)
    FIELD(TEMP_SAT49, VAL, 0, 16)
REG32(TEMP_SAT50, 0x2070)
    FIELD(TEMP_SAT50, VAL, 0, 16)
REG32(TEMP_SAT51, 0x2074)
    FIELD(TEMP_SAT51, VAL, 0, 16)
REG32(TEMP_SAT52, 0x2078)
    FIELD(TEMP_SAT52, VAL, 0, 16)
REG32(TEMP_SAT53, 0x207c)
    FIELD(TEMP_SAT53, VAL, 0, 16)
REG32(TEMP_SAT54, 0x2080)
    FIELD(TEMP_SAT54, VAL, 0, 16)
REG32(TEMP_SAT55, 0x2084)
    FIELD(TEMP_SAT55, VAL, 0, 16)
REG32(TEMP_SAT56, 0x2088)
    FIELD(TEMP_SAT56, VAL, 0, 16)
REG32(TEMP_SAT57, 0x208c)
    FIELD(TEMP_SAT57, VAL, 0, 16)
REG32(TEMP_SAT58, 0x2090)
    FIELD(TEMP_SAT58, VAL, 0, 16)
REG32(TEMP_SAT59, 0x2094)
    FIELD(TEMP_SAT59, VAL, 0, 16)
REG32(TEMP_SAT60, 0x2098)
    FIELD(TEMP_SAT60, VAL, 0, 16)
REG32(TEMP_SAT61, 0x209c)
    FIELD(TEMP_SAT61, VAL, 0, 16)
REG32(TEMP_SAT62, 0x20a0)
    FIELD(TEMP_SAT62, VAL, 0, 16)
REG32(VCCINT_SAT1, 0x20a4)
    FIELD(VCCINT_SAT1, VAL, 0, 19)
REG32(VCCINT_SAT2, 0x20a8)
    FIELD(VCCINT_SAT2, VAL, 0, 19)
REG32(VCCINT_SAT3, 0x20ac)
    FIELD(VCCINT_SAT3, VAL, 0, 19)
REG32(VCCINT_SAT4, 0x20b0)
    FIELD(VCCINT_SAT4, VAL, 0, 19)
REG32(VCCINT_SAT5, 0x20b4)
    FIELD(VCCINT_SAT5, VAL, 0, 19)
REG32(VCCINT_SAT6, 0x20b8)
    FIELD(VCCINT_SAT6, VAL, 0, 19)
REG32(VCCINT_SAT7, 0x20bc)
    FIELD(VCCINT_SAT7, VAL, 0, 19)
REG32(VCCINT_SAT8, 0x20c0)
    FIELD(VCCINT_SAT8, VAL, 0, 19)
REG32(VCCINT_SAT9, 0x20c4)
    FIELD(VCCINT_SAT9, VAL, 0, 19)
REG32(VCCINT_SAT10, 0x20c8)
    FIELD(VCCINT_SAT10, VAL, 0, 19)
REG32(VCCINT_SAT11, 0x20cc)
    FIELD(VCCINT_SAT11, VAL, 0, 19)
REG32(VCCINT_SAT12, 0x20d0)
    FIELD(VCCINT_SAT12, VAL, 0, 19)
REG32(VCCINT_SAT13, 0x20d4)
    FIELD(VCCINT_SAT13, VAL, 0, 19)
REG32(VCCINT_SAT14, 0x20d8)
    FIELD(VCCINT_SAT14, VAL, 0, 19)
REG32(VCCINT_SAT15, 0x20dc)
    FIELD(VCCINT_SAT15, VAL, 0, 19)
REG32(VCCINT_SAT16, 0x20e0)
    FIELD(VCCINT_SAT16, VAL, 0, 19)
REG32(VCCINT_SAT17, 0x20e4)
    FIELD(VCCINT_SAT17, VAL, 0, 19)
REG32(VCCINT_SAT18, 0x20e8)
    FIELD(VCCINT_SAT18, VAL, 0, 19)
REG32(VCCINT_SAT19, 0x20ec)
    FIELD(VCCINT_SAT19, VAL, 0, 19)
REG32(VCCINT_SAT20, 0x20f0)
    FIELD(VCCINT_SAT20, VAL, 0, 19)
REG32(VCCINT_SAT21, 0x20f4)
    FIELD(VCCINT_SAT21, VAL, 0, 19)
REG32(VCCINT_SAT22, 0x20f8)
    FIELD(VCCINT_SAT22, VAL, 0, 19)
REG32(VCCINT_SAT23, 0x20fc)
    FIELD(VCCINT_SAT23, VAL, 0, 19)
REG32(VCCINT_SAT24, 0x2100)
    FIELD(VCCINT_SAT24, VAL, 0, 19)
REG32(VCCINT_SAT25, 0x2104)
    FIELD(VCCINT_SAT25, VAL, 0, 19)
REG32(VCCINT_SAT26, 0x2108)
    FIELD(VCCINT_SAT26, VAL, 0, 19)
REG32(VCCINT_SAT27, 0x210c)
    FIELD(VCCINT_SAT27, VAL, 0, 19)
REG32(VCCINT_SAT28, 0x2110)
    FIELD(VCCINT_SAT28, VAL, 0, 19)
REG32(VCCINT_SAT29, 0x2114)
    FIELD(VCCINT_SAT29, VAL, 0, 19)
REG32(VCCINT_SAT30, 0x2118)
    FIELD(VCCINT_SAT30, VAL, 0, 19)
REG32(VCCINT_SAT31, 0x211c)
    FIELD(VCCINT_SAT31, VAL, 0, 19)
REG32(VCCINT_SAT32, 0x2120)
    FIELD(VCCINT_SAT32, VAL, 0, 19)
REG32(VCCINT_SAT33, 0x2124)
    FIELD(VCCINT_SAT33, VAL, 0, 19)
REG32(VCCINT_SAT34, 0x2128)
    FIELD(VCCINT_SAT34, VAL, 0, 19)
REG32(VCCINT_SAT35, 0x212c)
    FIELD(VCCINT_SAT35, VAL, 0, 19)
REG32(VCCINT_SAT36, 0x2130)
    FIELD(VCCINT_SAT36, VAL, 0, 19)
REG32(VCCINT_SAT37, 0x2134)
    FIELD(VCCINT_SAT37, VAL, 0, 19)
REG32(VCCINT_SAT38, 0x2138)
    FIELD(VCCINT_SAT38, VAL, 0, 19)
REG32(VCCINT_SAT39, 0x213c)
    FIELD(VCCINT_SAT39, VAL, 0, 19)
REG32(VCCINT_SAT40, 0x2140)
    FIELD(VCCINT_SAT40, VAL, 0, 19)
REG32(VCCINT_SAT41, 0x2144)
    FIELD(VCCINT_SAT41, VAL, 0, 19)
REG32(VCCINT_SAT42, 0x2148)
    FIELD(VCCINT_SAT42, VAL, 0, 19)
REG32(VCCINT_SAT43, 0x214c)
    FIELD(VCCINT_SAT43, VAL, 0, 19)
REG32(VCCINT_SAT44, 0x2150)
    FIELD(VCCINT_SAT44, VAL, 0, 19)
REG32(VCCINT_SAT45, 0x2154)
    FIELD(VCCINT_SAT45, VAL, 0, 19)
REG32(VCCINT_SAT46, 0x2158)
    FIELD(VCCINT_SAT46, VAL, 0, 19)
REG32(VCCINT_SAT47, 0x215c)
    FIELD(VCCINT_SAT47, VAL, 0, 19)
REG32(VCCINT_SAT48, 0x2160)
    FIELD(VCCINT_SAT48, VAL, 0, 19)
REG32(VCCINT_SAT49, 0x2164)
    FIELD(VCCINT_SAT49, VAL, 0, 19)
REG32(VCCINT_SAT50, 0x2168)
    FIELD(VCCINT_SAT50, VAL, 0, 19)
REG32(VCCINT_SAT51, 0x216c)
    FIELD(VCCINT_SAT51, VAL, 0, 19)
REG32(VCCINT_SAT52, 0x2170)
    FIELD(VCCINT_SAT52, VAL, 0, 19)
REG32(VCCINT_SAT53, 0x2174)
    FIELD(VCCINT_SAT53, VAL, 0, 19)
REG32(VCCINT_SAT54, 0x2178)
    FIELD(VCCINT_SAT54, VAL, 0, 19)
REG32(VCCINT_SAT55, 0x217c)
    FIELD(VCCINT_SAT55, VAL, 0, 19)
REG32(VCCINT_SAT56, 0x2180)
    FIELD(VCCINT_SAT56, VAL, 0, 19)
REG32(VCCINT_SAT57, 0x2184)
    FIELD(VCCINT_SAT57, VAL, 0, 19)
REG32(VCCINT_SAT58, 0x2188)
    FIELD(VCCINT_SAT58, VAL, 0, 19)
REG32(VCCINT_SAT59, 0x218c)
    FIELD(VCCINT_SAT59, VAL, 0, 19)
REG32(VCCINT_SAT60, 0x2190)
    FIELD(VCCINT_SAT60, VAL, 0, 19)
REG32(VCCINT_SAT61, 0x2194)
    FIELD(VCCINT_SAT61, VAL, 0, 19)
REG32(VCCINT_SAT62, 0x2198)
    FIELD(VCCINT_SAT62, VAL, 0, 19)
REG32(SUPPLY0_AVGCALC, 0x219c)
    FIELD(SUPPLY0_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY0_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY1_AVGCALC, 0x21a0)
    FIELD(SUPPLY1_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY1_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY2_AVGCALC, 0x21a4)
    FIELD(SUPPLY2_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY2_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY3_AVGCALC, 0x21a8)
    FIELD(SUPPLY3_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY3_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY4_AVGCALC, 0x21ac)
    FIELD(SUPPLY4_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY4_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY5_AVGCALC, 0x21b0)
    FIELD(SUPPLY5_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY5_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY6_AVGCALC, 0x21b4)
    FIELD(SUPPLY6_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY6_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY7_AVGCALC, 0x21b8)
    FIELD(SUPPLY7_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY7_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY8_AVGCALC, 0x21bc)
    FIELD(SUPPLY8_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY8_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY9_AVGCALC, 0x21c0)
    FIELD(SUPPLY9_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY9_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY10_AVGCALC, 0x21c4)
    FIELD(SUPPLY10_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY10_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY11_AVGCALC, 0x21c8)
    FIELD(SUPPLY11_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY11_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY12_AVGCALC, 0x21cc)
    FIELD(SUPPLY12_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY12_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY13_AVGCALC, 0x21d0)
    FIELD(SUPPLY13_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY13_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY14_AVGCALC, 0x21d4)
    FIELD(SUPPLY14_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY14_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY15_AVGCALC, 0x21d8)
    FIELD(SUPPLY15_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY15_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY16_AVGCALC, 0x21dc)
    FIELD(SUPPLY16_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY16_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY17_AVGCALC, 0x21e0)
    FIELD(SUPPLY17_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY17_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY18_AVGCALC, 0x21e4)
    FIELD(SUPPLY18_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY18_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY19_AVGCALC, 0x21e8)
    FIELD(SUPPLY19_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY19_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY20_AVGCALC, 0x21ec)
    FIELD(SUPPLY20_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY20_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY21_AVGCALC, 0x21f0)
    FIELD(SUPPLY21_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY21_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY22_AVGCALC, 0x21f4)
    FIELD(SUPPLY22_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY22_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY23_AVGCALC, 0x21f8)
    FIELD(SUPPLY23_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY23_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY24_AVGCALC, 0x21fc)
    FIELD(SUPPLY24_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY24_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY25_AVGCALC, 0x2200)
    FIELD(SUPPLY25_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY25_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY26_AVGCALC, 0x2204)
    FIELD(SUPPLY26_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY26_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY27_AVGCALC, 0x2208)
    FIELD(SUPPLY27_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY27_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY28_AVGCALC, 0x220c)
    FIELD(SUPPLY28_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY28_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY29_AVGCALC, 0x2210)
    FIELD(SUPPLY29_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY29_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY30_AVGCALC, 0x2214)
    FIELD(SUPPLY30_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY30_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY31_AVGCALC, 0x2218)
    FIELD(SUPPLY31_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY31_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY32_AVGCALC, 0x221c)
    FIELD(SUPPLY32_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY32_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY33_AVGCALC, 0x2220)
    FIELD(SUPPLY33_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY33_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY34_AVGCALC, 0x2224)
    FIELD(SUPPLY34_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY34_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY35_AVGCALC, 0x2228)
    FIELD(SUPPLY35_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY35_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY36_AVGCALC, 0x222c)
    FIELD(SUPPLY36_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY36_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY37_AVGCALC, 0x2230)
    FIELD(SUPPLY37_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY37_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY38_AVGCALC, 0x2234)
    FIELD(SUPPLY38_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY38_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY39_AVGCALC, 0x2238)
    FIELD(SUPPLY39_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY39_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY40_AVGCALC, 0x223c)
    FIELD(SUPPLY40_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY40_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY41_AVGCALC, 0x2240)
    FIELD(SUPPLY41_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY41_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY42_AVGCALC, 0x2244)
    FIELD(SUPPLY42_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY42_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY43_AVGCALC, 0x2248)
    FIELD(SUPPLY43_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY43_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY44_AVGCALC, 0x224c)
    FIELD(SUPPLY44_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY44_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY45_AVGCALC, 0x2250)
    FIELD(SUPPLY45_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY45_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY46_AVGCALC, 0x2254)
    FIELD(SUPPLY46_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY46_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY47_AVGCALC, 0x2258)
    FIELD(SUPPLY47_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY47_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY48_AVGCALC, 0x225c)
    FIELD(SUPPLY48_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY48_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY49_AVGCALC, 0x2260)
    FIELD(SUPPLY49_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY49_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY50_AVGCALC, 0x2264)
    FIELD(SUPPLY50_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY50_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY51_AVGCALC, 0x2268)
    FIELD(SUPPLY51_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY51_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY52_AVGCALC, 0x226c)
    FIELD(SUPPLY52_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY52_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY53_AVGCALC, 0x2270)
    FIELD(SUPPLY53_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY53_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY54_AVGCALC, 0x2274)
    FIELD(SUPPLY54_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY54_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY55_AVGCALC, 0x2278)
    FIELD(SUPPLY55_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY55_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY56_AVGCALC, 0x227c)
    FIELD(SUPPLY56_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY56_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY57_AVGCALC, 0x2280)
    FIELD(SUPPLY57_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY57_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY58_AVGCALC, 0x2284)
    FIELD(SUPPLY58_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY58_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY59_AVGCALC, 0x2288)
    FIELD(SUPPLY59_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY59_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY60_AVGCALC, 0x228c)
    FIELD(SUPPLY60_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY60_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY61_AVGCALC, 0x2290)
    FIELD(SUPPLY61_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY61_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY62_AVGCALC, 0x2294)
    FIELD(SUPPLY62_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY62_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY63_AVGCALC, 0x2298)
    FIELD(SUPPLY63_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY63_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY64_AVGCALC, 0x229c)
    FIELD(SUPPLY64_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY64_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY65_AVGCALC, 0x22a0)
    FIELD(SUPPLY65_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY65_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY66_AVGCALC, 0x22a4)
    FIELD(SUPPLY66_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY66_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY67_AVGCALC, 0x22a8)
    FIELD(SUPPLY67_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY67_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY68_AVGCALC, 0x22ac)
    FIELD(SUPPLY68_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY68_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY69_AVGCALC, 0x22b0)
    FIELD(SUPPLY69_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY69_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY70_AVGCALC, 0x22b4)
    FIELD(SUPPLY70_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY70_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY71_AVGCALC, 0x22b8)
    FIELD(SUPPLY71_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY71_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY72_AVGCALC, 0x22bc)
    FIELD(SUPPLY72_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY72_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY73_AVGCALC, 0x22c0)
    FIELD(SUPPLY73_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY73_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY74_AVGCALC, 0x22c4)
    FIELD(SUPPLY74_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY74_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY75_AVGCALC, 0x22c8)
    FIELD(SUPPLY75_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY75_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY76_AVGCALC, 0x22cc)
    FIELD(SUPPLY76_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY76_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY77_AVGCALC, 0x22d0)
    FIELD(SUPPLY77_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY77_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY78_AVGCALC, 0x22d4)
    FIELD(SUPPLY78_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY78_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY79_AVGCALC, 0x22d8)
    FIELD(SUPPLY79_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY79_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY80_AVGCALC, 0x22dc)
    FIELD(SUPPLY80_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY80_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY81_AVGCALC, 0x22e0)
    FIELD(SUPPLY81_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY81_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY82_AVGCALC, 0x22e4)
    FIELD(SUPPLY82_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY82_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY83_AVGCALC, 0x22e8)
    FIELD(SUPPLY83_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY83_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY84_AVGCALC, 0x22ec)
    FIELD(SUPPLY84_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY84_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY85_AVGCALC, 0x22f0)
    FIELD(SUPPLY85_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY85_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY86_AVGCALC, 0x22f4)
    FIELD(SUPPLY86_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY86_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY87_AVGCALC, 0x22f8)
    FIELD(SUPPLY87_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY87_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY88_AVGCALC, 0x22fc)
    FIELD(SUPPLY88_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY88_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY89_AVGCALC, 0x2300)
    FIELD(SUPPLY89_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY89_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY90_AVGCALC, 0x2304)
    FIELD(SUPPLY90_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY90_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY91_AVGCALC, 0x2308)
    FIELD(SUPPLY91_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY91_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY92_AVGCALC, 0x230c)
    FIELD(SUPPLY92_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY92_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY93_AVGCALC, 0x2310)
    FIELD(SUPPLY93_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY93_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY94_AVGCALC, 0x2314)
    FIELD(SUPPLY94_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY94_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY95_AVGCALC, 0x2318)
    FIELD(SUPPLY95_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY95_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY96_AVGCALC, 0x231c)
    FIELD(SUPPLY96_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY96_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY97_AVGCALC, 0x2320)
    FIELD(SUPPLY97_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY97_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY98_AVGCALC, 0x2324)
    FIELD(SUPPLY98_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY98_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY99_AVGCALC, 0x2328)
    FIELD(SUPPLY99_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY99_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY100_AVGCALC, 0x232c)
    FIELD(SUPPLY100_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY100_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY101_AVGCALC, 0x2330)
    FIELD(SUPPLY101_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY101_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY102_AVGCALC, 0x2334)
    FIELD(SUPPLY102_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY102_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY103_AVGCALC, 0x2338)
    FIELD(SUPPLY103_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY103_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY104_AVGCALC, 0x233c)
    FIELD(SUPPLY104_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY104_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY105_AVGCALC, 0x2340)
    FIELD(SUPPLY105_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY105_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY106_AVGCALC, 0x2344)
    FIELD(SUPPLY106_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY106_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY107_AVGCALC, 0x2348)
    FIELD(SUPPLY107_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY107_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY108_AVGCALC, 0x234c)
    FIELD(SUPPLY108_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY108_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY109_AVGCALC, 0x2350)
    FIELD(SUPPLY109_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY109_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY110_AVGCALC, 0x2354)
    FIELD(SUPPLY110_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY110_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY111_AVGCALC, 0x2358)
    FIELD(SUPPLY111_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY111_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY112_AVGCALC, 0x235c)
    FIELD(SUPPLY112_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY112_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY113_AVGCALC, 0x2360)
    FIELD(SUPPLY113_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY113_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY114_AVGCALC, 0x2364)
    FIELD(SUPPLY114_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY114_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY115_AVGCALC, 0x2368)
    FIELD(SUPPLY115_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY115_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY116_AVGCALC, 0x236c)
    FIELD(SUPPLY116_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY116_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY117_AVGCALC, 0x2370)
    FIELD(SUPPLY117_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY117_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY118_AVGCALC, 0x2374)
    FIELD(SUPPLY118_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY118_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY119_AVGCALC, 0x2378)
    FIELD(SUPPLY119_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY119_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY120_AVGCALC, 0x237c)
    FIELD(SUPPLY120_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY120_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY121_AVGCALC, 0x2380)
    FIELD(SUPPLY121_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY121_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY122_AVGCALC, 0x2384)
    FIELD(SUPPLY122_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY122_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY123_AVGCALC, 0x2388)
    FIELD(SUPPLY123_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY123_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY124_AVGCALC, 0x238c)
    FIELD(SUPPLY124_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY124_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY125_AVGCALC, 0x2390)
    FIELD(SUPPLY125_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY125_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY126_AVGCALC, 0x2394)
    FIELD(SUPPLY126_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY126_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY127_AVGCALC, 0x2398)
    FIELD(SUPPLY127_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY127_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY128_AVGCALC, 0x239c)
    FIELD(SUPPLY128_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY128_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY129_AVGCALC, 0x23a0)
    FIELD(SUPPLY129_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY129_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY130_AVGCALC, 0x23a4)
    FIELD(SUPPLY130_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY130_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY131_AVGCALC, 0x23a8)
    FIELD(SUPPLY131_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY131_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY132_AVGCALC, 0x23ac)
    FIELD(SUPPLY132_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY132_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY133_AVGCALC, 0x23b0)
    FIELD(SUPPLY133_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY133_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY134_AVGCALC, 0x23b4)
    FIELD(SUPPLY134_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY134_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY135_AVGCALC, 0x23b8)
    FIELD(SUPPLY135_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY135_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY136_AVGCALC, 0x23bc)
    FIELD(SUPPLY136_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY136_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY137_AVGCALC, 0x23c0)
    FIELD(SUPPLY137_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY137_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY138_AVGCALC, 0x23c4)
    FIELD(SUPPLY138_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY138_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY139_AVGCALC, 0x23c8)
    FIELD(SUPPLY139_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY139_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY140_AVGCALC, 0x23cc)
    FIELD(SUPPLY140_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY140_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY141_AVGCALC, 0x23d0)
    FIELD(SUPPLY141_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY141_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY142_AVGCALC, 0x23d4)
    FIELD(SUPPLY142_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY142_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY143_AVGCALC, 0x23d8)
    FIELD(SUPPLY143_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY143_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY144_AVGCALC, 0x23dc)
    FIELD(SUPPLY144_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY144_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY145_AVGCALC, 0x23e0)
    FIELD(SUPPLY145_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY145_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY146_AVGCALC, 0x23e4)
    FIELD(SUPPLY146_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY146_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY147_AVGCALC, 0x23e8)
    FIELD(SUPPLY147_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY147_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY148_AVGCALC, 0x23ec)
    FIELD(SUPPLY148_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY148_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY149_AVGCALC, 0x23f0)
    FIELD(SUPPLY149_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY149_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY150_AVGCALC, 0x23f4)
    FIELD(SUPPLY150_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY150_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY151_AVGCALC, 0x23f8)
    FIELD(SUPPLY151_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY151_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY152_AVGCALC, 0x23fc)
    FIELD(SUPPLY152_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY152_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY153_AVGCALC, 0x2400)
    FIELD(SUPPLY153_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY153_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY154_AVGCALC, 0x2404)
    FIELD(SUPPLY154_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY154_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY155_AVGCALC, 0x2408)
    FIELD(SUPPLY155_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY155_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY156_AVGCALC, 0x240c)
    FIELD(SUPPLY156_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY156_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY157_AVGCALC, 0x2410)
    FIELD(SUPPLY157_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY157_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY158_AVGCALC, 0x2414)
    FIELD(SUPPLY158_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY158_AVGCALC, RAVG, 0, 21)
REG32(SUPPLY159_AVGCALC, 0x2418)
    FIELD(SUPPLY159_AVGCALC, SCOUNT, 21, 4)
    FIELD(SUPPLY159_AVGCALC, RAVG, 0, 21)
REG32(SLICE_TEMP_MAX1, 0x249c)
    FIELD(SLICE_TEMP_MAX1, VAL, 0, 16)
REG32(SLICE_TEMP_MAX2, 0x24a0)
    FIELD(SLICE_TEMP_MAX2, VAL, 0, 16)
REG32(SLICE_TEMP_MAX3, 0x24a4)
    FIELD(SLICE_TEMP_MAX3, VAL, 0, 16)
REG32(SLICE_TEMP_MIN1, 0x24a8)
    FIELD(SLICE_TEMP_MIN1, VAL, 0, 16)
REG32(SLICE_TEMP_MIN2, 0x24ac)
    FIELD(SLICE_TEMP_MIN2, VAL, 0, 16)
REG32(SLICE_TEMP_MIN3, 0x24b0)
    FIELD(SLICE_TEMP_MIN3, VAL, 0, 16)
REG32(EN_AVG_REG8, 0x24b4)
REG32(EN_AVG_REG9, 0x24b8)
REG32(SECURE_EFUSE_RDATA_LOW, 0x24bc)
REG32(SECURE_EFUSE_RDATA_HIGH, 0x24c0)
REG32(AXI_STATUS, 0x24c4)
    FIELD(AXI_STATUS, RESPONSE, 6, 2)
    FIELD(AXI_STATUS, TRANS_OUT, 0, 6)
REG32(AXI_PACKETS0, 0x24c8)
    FIELD(AXI_PACKETS0, FILTERED, 10, 10)
    FIELD(AXI_PACKETS0, DROPPED, 0, 10)
REG32(AXI_PACKETS1, 0x24cc)
    FIELD(AXI_PACKETS1, INCOMING_SSC_MEAS, 10, 10)
    FIELD(AXI_PACKETS1, OUTGOING, 0, 10)
REG32(AXI_PACKETS2, 0x24d0)
    FIELD(AXI_PACKETS2, INCOMING_DEVICE_TEMP_MIN, 10, 10)
    FIELD(AXI_PACKETS2, INCOMING_DEVICE_TEMP_MAX, 0, 10)
REG32(MEAS_PACKETS0, 0x24d4)
    FIELD(MEAS_PACKETS0, FILTERED, 10, 10)
    FIELD(MEAS_PACKETS0, DROPPED, 0, 10)
REG32(MEAS_PACKETS1, 0x24d8)
    FIELD(MEAS_PACKETS1, INCOMING_APB, 10, 10)
    FIELD(MEAS_PACKETS1, OUTGOING, 0, 10)
REG32(MEAS_PACKETS2, 0x24dc)
    FIELD(MEAS_PACKETS2, INCOMING_SAT1, 10, 10)
    FIELD(MEAS_PACKETS2, INCOMING_SAT0, 0, 10)
REG32(MEAS_PACKETS3, 0x24e0)
    FIELD(MEAS_PACKETS3, INCOMING_LPD, 10, 10)
    FIELD(MEAS_PACKETS3, INCOMING_FPD, 0, 10)
REG32(MEAS_PACKETS4, 0x24e4)
    FIELD(MEAS_PACKETS4, INCOMING_PL, 0, 10)
REG32(STATUS_ENABLE, 0x24e8)
    FIELD(STATUS_ENABLE, PACKETS, 0, 1)
REG32(SSC_MEASURE_IF, 0x4000)
    FIELD(SSC_MEASURE_IF, MEAS_VALID, 28, 1)
    FIELD(SSC_MEASURE_IF, MEAS_ID, 19, 9)
    FIELD(SSC_MEASURE_IF, MEAS_DATA, 0, 19)

#define PMC_SYSMON_R_MAX (R_SSC_MEASURE_IF + 1)

/*
 * Multi-word, bit-per-channel.
 *
 * Similar to bit-array support in qemu/bitops.h but operating in
 * uint32_t (instead of 'unsigned long') elements of MMIO registers.
 */
#define CHANNEL_WORD(_I)        ((_I) / 32)
#define CHANNEL_MASK(_I)        (1U << ((_I) % 32))
#define CHANNEL_BIT(_RA, _I)    (!!((_RA)[CHANNEL_WORD(_I)] & CHANNEL_MASK(_I)))
#define CHANNEL_BIT_SET(_RA, _I) do { \
        (_RA)[CHANNEL_WORD(_I)] |= CHANNEL_MASK(_I); \
    } while (0)
#define CHANNEL_BIT_CLR(_RA, _I) do { \
        (_RA)[CHANNEL_WORD(_I)] &= ~CHANNEL_MASK(_I); \
    } while (0)
#define CHANNEL_ID(_B, _R)      (((_R) - (_B)) * 32)

/* Size, in bytes, of WORD array needed to host '_N' bits */
#define CHANNEL_WCNT(_N)        (CHANNEL_WORD((_N) - 1) + 1)
#define CHANNEL_BCNT(_N)        (CHANNEL_WCNT(_N) * sizeof(uint32_t))

/* Access voltage registers by channel id */
#define R_SUPPLY(_I)            (R_SUPPLY0 + (_I))
#define R_SUPPLY_MIN(_I)        (R_SUPPLY0_MIN + (_I))
#define R_SUPPLY_MAX(_I)        (R_SUPPLY0_MAX + (_I))
#define R_SUPPLY_TH_LOWER(_I)   (R_SUPPLY0_TH_LOWER + (_I))
#define R_SUPPLY_TH_UPPER(_I)   (R_SUPPLY0_TH_UPPER + (_I))
#define R_SUPPLY_AVGCALC(_I)    (R_SUPPLY0_AVGCALC + (_I))
#define R_SUPPLY_ISR_MASK(_I)   (R_REG_ISR_ALARM0_MASK << ((_I) / 32))

/* Modified floating point for voltages */
#define MFP19_UNSIGNED(_E, _M) \
    (((((_E) + MFP19_E_OFFSET) << MFP19_E_SHIFT) & MFP19_E_MASK) | \
     ((_M) & MFP19_MANTISSA_MASK))

#define MFP19_SIGNED(_E, _M) \
    (MFP19_UNSIGNED(_E, _M) | MFP19_SIGNED_MASK)

#define MFP19_IS_SIGNED(_F) \
    (!!((_F) & MFP19_SIGNED_MASK))

#define MFP19_SCALE(_F) \
    (((_F) & MFP19_SCALE_MASK) >> MFP19_SCALE_SHIFT)


enum PMCSysMon_const {
    R_REG_PCSR_LOCK_UNLOCK_CODE = 0xF9E8D7C6,

    R_TEMP_SAT_FIRST = R_TEMP_SAT1,
    R_TEMP_SAT_LAST  = R_TEMP_SAT62,
    R_TEMP_SAT_COUNT = 64, /* plus TEMP_FPD and TEMP_LPD */
    R_TEMP_FPD_TID   = 62,
    R_TEMP_LPD_TID   = 63,

    R_VCCINT_SAT_FIRST = R_VCCINT_SAT1,
    R_VCCINT_SAT_LAST  = R_VCCINT_SAT62,
    R_VCCINT_SAT_COUNT = (R_VCCINT_SAT_LAST - R_VCCINT_SAT_FIRST + 1),
    R_VCCINT_FPD_VID   = 62,
    R_VCCINT_LPD_VID   = 63,

    R_SUPPLY_COUNT   = (R_SUPPLY159 + 1 - R_SUPPLY0),

    /* Q8.7 signed fixed-point, for temperature */
    Q8_7_SGN_MASK = 0x8000,
    Q8_7_MASK     = 0xFFFF,
    Q8_7_MIN      = 0x8000,
    Q8_7_MAX      = 0x7FFF,

    /* 19-bit modified floating (no hidden bit) for volts */
    MFP19_MANTISSA_WIDTH = 16,
    MFP19_MANTISSA_MASK  = (1 << MFP19_MANTISSA_WIDTH) - 1,

    MFP19_SIGNED_SHIFT = MFP19_MANTISSA_WIDTH,
    MFP19_SIGNED_MASK  = (1 << MFP19_SIGNED_SHIFT),

    MFP19_E_SHIFT = MFP19_SIGNED_SHIFT + 1,
    MFP19_E_MASK  = (3 << MFP19_E_SHIFT),

    MFP19_MASK = (1 << (MFP19_E_SHIFT + 2)) - 1,

    MFP19_SCALE_SHIFT = MFP19_SIGNED_SHIFT,
    MFP19_SCALE_MASK  = (MFP19_E_MASK | MFP19_SIGNED_MASK),

    /*
     * Mantissa 0 of all exponents are values of 0 in MFP19. To
     * differentiate 'register set to 0' from reset value of a
     * register, model 0 as mantissa 0 with smallest non-zero
     * exponent and/or sign.
     */
    MFP19_E_OFFSET = 16,
    MFP19_UMIN = MFP19_UNSIGNED(-15, 0),
    MFP19_MIN  = MFP19_SIGNED(-13, 0x8000),
    MFP19_SGN0 = MFP19_SIGNED(-16, 0),
    MFP19_MAX  = MFP19_SIGNED(-13, 0x7FFF),
    MFP19_UMAX = MFP19_UNSIGNED(-13, 0xFFFF),
};

/* Widened Q8.7 of various types */
#define Q8_7_I_MIN      ((int)(int16_t)Q8_7_MIN)
#define Q8_7_I_MAX      ((int)(int16_t)Q8_7_MAX)

#define Q8_7_F_INT(_I)  ((double)(_I) / (1 << 7))
#define Q8_7_F_MIN      Q8_7_F_INT(Q8_7_I_MIN)
#define Q8_7_F_MAX      Q8_7_F_INT(Q8_7_I_MAX)

/* Widened MFP19 and Q4.16 of various types */
#define MFP19_I_UMIN    ((int)0)
#define MFP19_I_MIN     ((int)-4 << 16)
#define MFP19_I_MAX     ((int)(MFP19_MAX & MFP19_MANTISSA_MASK) << 3)
#define MFP19_I_UMAX    ((int)(MFP19_UMAX & MFP19_MANTISSA_MASK) << 3)

#define MFP19_F_INT(_I) ((double)(_I) / (1 << 16))
#define MFP19_F_MIN     MFP19_F_INT(MFP19_I_MIN)
#define MFP19_F_MAX     MFP19_F_INT(MFP19_I_MAX)
#define MFP19_F_UMIN    MFP19_F_INT(MFP19_I_UMIN)
#define MFP19_F_UMAX    MFP19_F_INT(MFP19_I_UMAX)

#define PROP_MEAS_FILE  "measurement-file"

typedef struct PMCSysMon_TempAcc {
    uint32_t count:4;   /* samples collected in accum so far */
    int32_t  accum:28;  /* sum of 15 signed Q8.7 values */
} PMCSysMon_TempAcc;

typedef struct PMCSysMon_MeasInj {
    union {
        float flt;
        uint32_t q8_7;
    } meas_val;
    xlnx_ams_sensor_t info;
    bool by_root_id;
    bool played;
    QTAILQ_ENTRY(PMCSysMon_MeasInj) link;
} PMCSysMon_MeasInj;

typedef struct PMCSysMon {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_0;
    qemu_irq irq_1;
    uint32_t events;
    uint32_t reg_prev_value;

    Object *efuse;
    QEMUTimer efuse_throttle_timer;
    uint32_t efuse_throttle_ms;

    Object *ams_sat0;        /* For backward compatibility */
    Object *ams_sat1;

    Object  **ams_sat;       /* An array, with NULL hole(s) possibile */
    uint32_t *ams_sat_ready; /* bit-array, indexed by CHANNEL_xxx macros */
    uint32_t  ams_sat_len;

    Object *tamper_sink;

    char *meas_file;         /* Defer set by -global option */

    double default_volt;
    int32_t default_celsius;

    /*
     * Measurement injection list pending for playback/replay upon
     * a satellite transitioning to ready state.
     *
     * The replay is necessary because injections given through
     * property are not usable until guest software has completed
     * satellite configurations.
     */
    QTAILQ_HEAD(, PMCSysMon_MeasInj) meas_injections;

    /*
     * A FIFO for simulation of periodic refresh of NEW_DATA_FLAG{0..4}
     * without the use of unreliable timer, with [0][] being sticky state.
     * See pmc_sysmon_new_data_flagx_prew() for detail.
     */
    uint32_t ndf_fifo[3][CHANNEL_WORD(R_SUPPLY_COUNT)];

    /* One timer for each VID configured in NEW_DATA_INT_SRC. */
    QEMUTimer ndf_tick[4];
    uint32_t  ndf_tick_ms;

    /*
     * Signed Q15.16 accumulators to avoid repeated encoding
     * and decoding of R_SUPPLYn_AVGCALC.
     */
    int volt_acc[R_SUPPLY_COUNT];

    /*
     * Temperature accumulators, unlike R_SUPPLYn_AVGCALC,
     * are not visible to software.
     */
    PMCSysMon_TempAcc temp_sat_acc[R_TEMP_SAT_COUNT];
    uint32_t temp_sat_set[CHANNEL_WCNT(R_TEMP_SAT_COUNT)];
    uint32_t temp_min_min;
    uint32_t temp_min_max;
    unsigned temp_min_tid;
    unsigned temp_max_tid;

    /*
     * Flag to track 'is defined yet' state of min/max, such
     * that the first sample will be min and max.
     */
    bool temp_min_max_ready;
    uint32_t volt_min_max_ready[CHANNEL_WCNT(R_SUPPLY_COUNT)];

    uint32_t regs[PMC_SYSMON_R_MAX];
    RegisterInfo regs_info[PMC_SYSMON_R_MAX];
} PMCSysMon;

static void pmc_sysmon_init_measurements(PMCSysMon *s, unsigned instance_id);

static int int_compare(int a, int b)
{
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    } else {
        return 0;
    }
}

static void chomp_zero(char *s)
{
    char *p;

    p = s + strlen(s);
    while (p > s) {
        p--;
        switch (p[0]) {
        case '0':
            break;
        case '.':
            p--;  /* fall through to also strip '.' */
        default:
            p[1] = '\0';
            return;
        }
    }

    /* Leave at least 1 untrimmed */
    s[1] = '\0';
}

static int q8_7_int(uint32_t q)
{
    struct {
        int q:16;
    } s;

    s.q = (int)q;
    return s.q;
}

static void q8_7_str(uint32_t q, char *out, size_t len)
{
    int i = q8_7_int(q);

    /*
     * Last binary digit is 1/128 = 0.0078125, i.e., the
     * fraction has maximum of 7 decimal digits.
     */
    snprintf(out, len, "%.7f", Q8_7_F_INT(i));
    chomp_zero(out);
}

static uint32_t q8_7_from_int(int i)
{
    /* Saturate if out of range */
    if (i < Q8_7_I_MIN) {
        return Q8_7_MIN;
    }
    if (i > Q8_7_I_MAX) {
        return Q8_7_MAX;
    }

    return i & Q8_7_MASK;
}

static uint32_t q8_7_from_float(double v)
{
    uint32_t q;

    /* Saturate if out of range */
    if (v < Q8_7_F_MIN) {
        return Q8_7_MIN;
    }
    if (v > Q8_7_F_MAX) {
        return Q8_7_MAX;
    }

    q = (uint32_t)(round(v * (1 << 7)));

    return q & Q8_7_MASK;
}

static int q8_7_compare(uint32_t q1, uint32_t q2)
{
    return int_compare(q8_7_int(q1), q8_7_int(q2));
}

static int mfp19_int(uint32_t f)
{
    /* FP19 to signed Q4.16, signed-extended to 32-bit int */
    union {
        signed int s:MFP19_MANTISSA_WIDTH;
        unsigned int u:MFP19_MANTISSA_WIDTH;
    } m;

    int q;
    int e;

    m.u = f & MFP19_MANTISSA_MASK;

    if (f & MFP19_SIGNED_MASK) {
        q = m.s;  /* sign-extended */
    } else {
        q = m.u;  /* zero-extended */
    }

    e = (f & MFP19_E_MASK) >> MFP19_E_SHIFT;

    return q << e;
}

static void mfp19_str(uint32_t f, char *out, size_t len)
{
    int i = mfp19_int(f);  /* q4.16 */

    /*
     * Last binary digit is 1/(1<<16) = 0.0000152587890625, i.e., the
     * fraction has maximum of 16 decimal digits.
     */
    snprintf(out, len, "%.16f", MFP19_F_INT(i));
    chomp_zero(out);
}

static bool mfp19_same_signess(uint32_t f1, uint32_t f2)
{
    return MFP19_IS_SIGNED(f1) == MFP19_IS_SIGNED(f2);
}

static int mfp19_compare(uint32_t f1, uint32_t f2)
{
    return int_compare(mfp19_int(f1), mfp19_int(f2));
}

static uint32_t mfp19_unsigned(int q)
{
    /* Convert unsigned Q3.16 to unsigned FP19 */
    int e, i;

    static const uint8_t shift[] = {
        /*            qqq.rrrr_rrrr_rrrr_rrrr                 */
        [0] = 0,  /*  000.mmmm_mmmm_mmmm_mmmm - no drops      */
        [1] = 1,  /*  001.mmmm_mmmm_mmmm_mmmT - 1 LSB dropped */
        [2] = 2,  /*  010.mmmm_mmmm_mmmm_mmTT - 2 LSB dropped */
        [3] = 2,  /*  011.mmmm_mmmm_mmmm_mmTT                 */
        [4] = 3,  /*  100.mmmm_mmmm_mmmm_mTTT - 3 LSB dropped */
        [5] = 3,  /*  101.mmmm_mmmm_mmmm_mTTT                 */
        [6] = 3,  /*  110.mmmm_mmmm_mmmm_mTTT                 */
        [7] = 3,  /*  111.mmmm_mmmm_mmmm_mTTT                 */
    };

    /* saturated if out of range */
    if (q <= 0) {
        return MFP19_UMIN;
    }
    if (q > MFP19_I_UMAX) {
        return MFP19_UMAX;
    }

    i = (q >> 16) & 7;
    e = shift[i];
    return MFP19_UNSIGNED((e - MFP19_E_OFFSET), (q >> e));
}

static uint32_t mfp19_signed(int q)
{
    /* Convert signed Q4.16 to signed FP19 */
    int e, i;
    uint32_t m, f;

    /*
     * Optimal E to preserve mantissa sign bit and precision for
     * negative q, i.e., the '1' left of most-significant '0' is
     * the mantissa sign bit.
     */
    static const uint8_t shift[] = {
        /*     <sign:1>_qqq.rrrr_rrrr_rrrr_rrrr                  */
        [15] = 0,  /* 1_111.1_mmm_mmmm_mmmm_mmmm - no drops      */
        [14] = 1,  /* 1_111.0_mmm_mmmm_mmmm_mmmT - 1 LSB dropped */
        [13] = 2,  /* 1_110.1_mmm_mmmm_mmmm_mmTT - 2 LSB dropped */
        [12] = 2,  /* 1_110.0_mmm_mmmm_mmmm_mmTT                 */
        [11] = 3,  /* 1_101.1_mmm_mmmm_mmmm_mTTT - 3 LSB dropped */
        [10] = 3,  /* 1_101.0_mmm_mmmm_mmmm_mTTT                 */
        [9]  = 3,  /* 1_100.1_mmm_mmmm_mmmm_mTTT                 */
        [8]  = 3,  /* 1_100.0_mmm_mmmm_mmmm_mTTT                 */

        [7]  = 4,  /* 1_011.1_mmm_mmmm_mmmm_TTTT - out of range  */
        [6]  = 4,  /* 1_011.0_mmm_mmmm_mmmm_TTTT                 */
        [5]  = 4,  /* 1_010.1_mmm_mmmm_mmmm_TTTT                 */
        [4]  = 4,  /* 1_010.0_mmm_mmmm_mmmm_TTTT                 */
        [3]  = 4,  /* 1_001.1_mmm_mmmm_mmmm_TTTT                 */
        [2]  = 4,  /* 1_001.0_mmm_mmmm_mmmm_TTTT                 */
        [1]  = 4,  /* 1_000.1_mmm_mmmm_mmmm_TTTT                 */
        [0]  = 4,  /* 1_000.0_mmm_mmmm_mmmm_TTTT                 */
    };

    /* saturated if out of range */
    if (q >= MFP19_I_MAX) {
        return MFP19_MAX;
    }
    if (q <= MFP19_I_MIN) {
        return MFP19_MIN;
    }

    /* bipolar 0 */
    if (q == 0) {
        return MFP19_SGN0;
    }

    /*
     * Positive is mostly the same as unsigned, with format-code
     * added and possibly scale adjusted to avoid mantissa overflow.
     */
    if (q > 0) {
        f = mfp19_unsigned(q);
        m = f & MFP19_MANTISSA_MASK;
        if (m > (MFP19_MAX & MFP19_MANTISSA_MASK)) {
            e = (f & MFP19_E_MASK) + (1 << MFP19_E_SHIFT);
            f = e | (m >> 1);
        }

        f |= MFP19_SIGNED_MASK;
    } else {
        i = (q >> 15) & 15;
        e = shift[i];
        assert(e <= 3);

        m = (q >> e) & MFP19_MANTISSA_MASK;
        assert(m >> (MFP19_MANTISSA_WIDTH - 1));

        f = MFP19_SIGNED((e - MFP19_E_OFFSET), m);
    }

    return f;
}

static uint32_t mfp19_from_int(int q, uint32_t template)
{
    return MFP19_IS_SIGNED(template) ? mfp19_signed(q) : mfp19_unsigned(q);
}

static uint32_t mfp19_from_float(double v, bool bipolar, Error **errp)
{
    uint32_t q;

    /* Saturate if out of range */
    if (bipolar) {
        if (v < MFP19_F_MIN) {
            q = MFP19_MIN;
            goto e_range;
        }
        if (v > MFP19_F_MAX) {
            q = MFP19_MAX;
            goto e_range;
        }
    } else {
        if (v <= 0) {
            q = MFP19_UMIN;
            goto e_range;
        }
        if (v > MFP19_F_UMAX) {
            q = MFP19_UMAX;
            goto e_range;
        }
    }

    /* Convert float to q4.16 */
    q = (uint32_t)(round(v * (1 << 16)));

    /* Then, convert q4.16 to MFP19 */
    return bipolar ? mfp19_signed(q) : mfp19_unsigned(q);

 e_range:
    if (errp) {
        error_setg(errp,
                   "Voltage value (%.17g) out of range [%.17g, %.17g]", v,
                   (bipolar ? MFP19_F_MIN : MFP19_F_UMIN),
                   (bipolar ? MFP19_F_MAX : MFP19_F_UMAX));
    }

    return q;
}

static void assert_number_formats(void)
{
    /* Sanity-check the constants and format conversion */
    assert(Q8_7_I_MIN == q8_7_int(Q8_7_MIN));
    assert(Q8_7_I_MAX == q8_7_int(Q8_7_MAX));

    assert(MFP19_I_MIN  == mfp19_int(MFP19_MIN));
    assert(MFP19_I_MAX  == mfp19_int(MFP19_MAX));
    assert(MFP19_I_UMAX == mfp19_int(MFP19_UMAX));

    assert(MFP19_MAX  == mfp19_signed(MFP19_I_MAX));
    assert(MFP19_UMAX == mfp19_unsigned(MFP19_I_UMAX));
}

static void reg_isr_update_irq(PMCSysMon *s)
{
    bool pending_0 = s->regs[R_REG_ISR] & ~s->regs[R_REG_IMR0];
    bool pending_1 = s->regs[R_REG_ISR] & ~s->regs[R_REG_IMR1];

    qemu_set_irq(s->irq_0, !!pending_0);
    qemu_set_irq(s->irq_1, !!pending_1);
}

static uint64_t reg_isr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);

    /* Status remains stuck-at-1 as long as events not cleared */
    return val64 | s->events;
}

static bool pmc_sysmon_root_is_running(PMCSysMon *s)
{
    uint32_t pcsr = s->regs[R_REG_PCSR_CONTROL];

    pcsr &= R_REG_PCSR_CONTROL_INITSTATE_MASK |
            R_REG_PCSR_CONTROL_PCOMPLETE_MASK;

    return pcsr == R_REG_PCSR_CONTROL_PCOMPLETE_MASK;
}

static void pmc_sysmon_event_tamper(PMCSysMon *s, uint32_t isr_mask)
{
    g_autofree Error *err = NULL;
    uint32_t alarms, events;

    static const uint32_t tamper_map[32] = {
        [R_REG_ISR_ALARM0_SHIFT] = XLNX_AMS_VOLT_0_ALARM_MASK,
        [R_REG_ISR_ALARM1_SHIFT] = XLNX_AMS_VOLT_1_ALARM_MASK,
        [R_REG_ISR_ALARM2_SHIFT] = XLNX_AMS_VOLT_2_ALARM_MASK,
        [R_REG_ISR_ALARM3_SHIFT] = XLNX_AMS_VOLT_3_ALARM_MASK,
        [R_REG_ISR_ALARM4_SHIFT] = XLNX_AMS_VOLT_4_ALARM_MASK,
        [R_REG_ISR_ALARM5_SHIFT] = XLNX_AMS_VOLT_5_ALARM_MASK,
        [R_REG_ISR_ALARM6_SHIFT] = XLNX_AMS_VOLT_6_ALARM_MASK,
        [R_REG_ISR_ALARM7_SHIFT] = XLNX_AMS_VOLT_7_ALARM_MASK,
        [R_REG_ISR_OT_SHIFT]     = XLNX_AMS_TEMP_ALARM_MASK,
        [R_REG_ISR_TEMP_SHIFT]   = XLNX_AMS_TEMP_ALARM_MASK,
    };

    if (!s->tamper_sink) {
        return;
    }

    for (events = 0, alarms = isr_mask; alarms; ) {
        uint32_t bit_nr = ctz32(alarms);

        events |= tamper_map[bit_nr];
        alarms &= ~(1 << bit_nr);
    }

    if (!events) {
        return;
    }

    object_property_set_uint(s->tamper_sink,
                             XLNX_AMS_TAMPER_PROP, events, &err);
    if (err) {
        g_autofree char *p_dev = object_get_canonical_path(OBJECT(s));
        g_autofree char *p_sink = object_get_canonical_path(s->tamper_sink);

        warn_report("%s: Fail to send alarms 0x%03x as "
                    "tampering events to %s: %s",
                    p_dev, isr_mask, p_sink, error_get_pretty(err));
    }
}

static void pmc_sysmon_event_clear(PMCSysMon *s, uint32_t isr_mask)
{
    s->events &= ~isr_mask;
}

static void pmc_sysmon_event_set(PMCSysMon *s, uint32_t isr_mask)
{
    pmc_sysmon_event_tamper(s, isr_mask); /* non-maskable */

    s->events |= isr_mask;

    if (!(s->regs[R_REG_ISR] & isr_mask)) {
        s->regs[R_REG_ISR] |= isr_mask;
        reg_isr_update_irq(s);
    }
}

static uint32_t pmc_sysmon_temp_min_min(PMCSysMon *s)
{
    if (ARRAY_FIELD_EX32(s->regs, CONFIG0, RESERVED2)) {
        return s->temp_min_max;
    } else {
        return s->temp_min_min;
    }
}

static void pmc_sysmon_temp_update_alarm(PMCSysMon *s,
                                         uint32_t isr_mask, uint32_t mode_mask,
                                         uint32_t r_th_lo, uint32_t r_th_hi)
{
    int th_lo = q8_7_int(s->regs[r_th_lo]);
    int th_hi = q8_7_int(s->regs[r_th_hi]);
    int t_min;

    bool windowed = !(s->regs[R_ALARM_CONFIG] & mode_mask);

    /* Suppress alarm until min/max has been established */
    if (!s->temp_min_max_ready) {
        return;
    }

    if (q8_7_int(s->regs[R_DEVICE_TEMP_MAX]) > th_hi) {
        pmc_sysmon_event_set(s, isr_mask);        /* too hot! */
        return;
    }

    /* The mode controls the <t_min, th_lo> relationship */
    t_min = q8_7_int(pmc_sysmon_temp_min_min(s));

    if (windowed) {
        /* [th_lo, th_hi] is the only acceptable range */
        if (t_min >= th_lo) {
            pmc_sysmon_event_clear(s, isr_mask);  /* comfy! */
        } else {
            pmc_sysmon_event_set(s, isr_mask);    /* too cold! */
        }
    } else {
        /*
         * [th_lo, th_hi] is a hysteresis range, i.e.,
         * 1. There is no alarm until t_max > th_hi; then,
         * 2. Alarm remains set until t_min < th_lo.
         */
        if (!(s->events & isr_mask)) {
            pmc_sysmon_event_clear(s, isr_mask);  /* getting hot but ok */
        } else if (t_min >= th_lo) {
            pmc_sysmon_event_set(s, isr_mask);    /* need to cool down more */
        } else {
            pmc_sysmon_event_clear(s, isr_mask);  /* has cooled down */
        }
    }
}

static void pmc_sysmon_temp_update_dev_alarm(PMCSysMon *s)
{
    pmc_sysmon_temp_update_alarm(s,
                                 R_REG_ISR_TEMP_MASK,
                                 R_ALARM_CONFIG_DEV_ALARM_MODE_MASK,
                                 R_DEVICE_TEMP_TH_LOWER,
                                 R_DEVICE_TEMP_TH_UPPER);
}

static void pmc_sysmon_temp_update_ot_alarm(PMCSysMon *s)
{
    pmc_sysmon_temp_update_alarm(s,
                                 R_REG_ISR_OT_MASK,
                                 R_ALARM_CONFIG_OT_ALARM_MODE_MASK,
                                 R_OT_TEMP_TH_LOWER,
                                 R_OT_TEMP_TH_UPPER);
}

static void pmc_sysmon_temp_update_alarms(PMCSysMon *s)
{
    pmc_sysmon_temp_update_dev_alarm(s);
    pmc_sysmon_temp_update_ot_alarm(s);
}

static bool pmc_sysmon_temp_set_min(uint32_t *reg, uint32_t val)
{
    if (q8_7_compare(*reg, val) > 0) {
        *reg = val & Q8_7_MASK;
        return true;
    }

    return false;
}

static bool pmc_sysmon_temp_set_max(uint32_t *reg, uint32_t val)
{
    if (q8_7_compare(*reg, val) < 0) {
        *reg = val & Q8_7_MASK;
        return true;
    }

    return false;
}

static unsigned pmc_sysmon_temp_sat_reg(unsigned tid)
{
    assert(tid < R_TEMP_SAT_COUNT);

    switch (tid) {
    case R_TEMP_LPD_TID:
        return R_TEMP_LPD;
    case R_TEMP_FPD_TID:
        return R_TEMP_FPD;
    default:
        return R_TEMP_SAT_FIRST + tid;
    }
}

static void pmc_sysmon_temp_refresh_device(PMCSysMon *s)
{
    uint32_t *r_min = &s->regs[R_DEVICE_TEMP_MIN];
    uint32_t *r_max = &s->regs[R_DEVICE_TEMP_MAX];
    unsigned tid;

    *r_min = Q8_7_MAX;
    *r_max = Q8_7_MIN;
    for (tid = 0; tid < R_TEMP_SAT_COUNT; tid++) {
        unsigned nr;
        uint32_t sv;

        if (!CHANNEL_BIT(s->temp_sat_set, tid)) {
            continue; /* measurement unavailable */
        }

        nr = pmc_sysmon_temp_sat_reg(tid);
        sv = s->regs[nr];
        if (pmc_sysmon_temp_set_min(r_min, sv)) {
            s->temp_min_tid = tid;
        }
        if (pmc_sysmon_temp_set_max(r_max, sv)) {
            s->temp_max_tid = tid;
        }
    }
}

static bool pmc_sysmon_temp_update_device(PMCSysMon *s,
                                          unsigned tid, uint32_t val)
{
    bool changed = false;
    bool refresh = false;

    /*
     * In real hardware, R_DEVICE_TEMP_MIN/_MAX are actually refreshed
     * at the end of each report cycle, where all satellites report
     * their temperature measurements.  That is:
     *   _TEMP_MIN = min(all measurements reported in a cycle)
     *   _TEMP_MAX = max(all measurements reported in a cycle)
     *
     * However, the periodic report cycles are not modelled here to
     * avoid unreliable periodic timer. Instead, once a temp-sat is
     * set, the injected measurement is considered unchanged for all
     * subsequent cycles.
     *
     * So, simulate the refresh with minimal overhead by tracking
     * the TIDs of the current extremes:
     * 1/ If the given <tid, val> alters an extreme, it is taken as
     *    the new extreme.
     * 2/ If the given <tid, val> does not alter an extreme AND
     *    the <tid> is not the same as that of the "current" extreme,
     *    nothing changes, and all is good.
     * 3/ If the given <tid, val> does not alter an extreme BUT
     *    the <tid> is the same as that of the "current" extreme,
     *    it means there is a change of coolest/hottest spots. Thus,
     *    a full re-sort takes place to find the new extremes.
     */
    if (pmc_sysmon_temp_set_min(&s->regs[R_DEVICE_TEMP_MIN], val)) {
        changed |= true;
        refresh |= s->temp_min_tid == tid;
        s->temp_min_tid = tid;
    }
    if (pmc_sysmon_temp_set_max(&s->regs[R_DEVICE_TEMP_MAX], val)) {
        changed |= true;
        refresh |= s->temp_max_tid == tid;
        s->temp_max_tid = tid;
    }

    if (refresh) {
        pmc_sysmon_temp_refresh_device(s);
    }

    return changed;
}

static void pmc_sysmon_temp_init_min_max(PMCSysMon *s,
                                         unsigned tid, uint32_t val)
{
    s->regs[R_DEVICE_TEMP_MIN] = val;
    s->regs[R_DEVICE_TEMP_MAX] = val;
    s->temp_min_tid = tid;
    s->temp_max_tid = tid;

    s->regs[R_DEVICE_TEMP_MAX_MAX] = val;
    s->temp_min_min = val;
    s->temp_min_max = val;

    s->temp_min_max_ready = true;
}

static bool pmc_sysmon_temp_update_min_max(PMCSysMon *s,
                                           unsigned tid, uint32_t val)
{
    bool changed = false;
    uint32_t t_min;

    if (!s->temp_min_max_ready) {
        pmc_sysmon_temp_init_min_max(s, tid, val);
        return true;
    }

    changed |= pmc_sysmon_temp_update_device(s, tid, val);

    pmc_sysmon_temp_set_max(&s->regs[R_DEVICE_TEMP_MAX_MAX],
                            s->regs[R_DEVICE_TEMP_MAX]);

    t_min = pmc_sysmon_temp_min_min(s);
    pmc_sysmon_temp_set_min(&s->temp_min_min, s->regs[R_DEVICE_TEMP_MIN]);
    pmc_sysmon_temp_set_min(&s->temp_min_max, s->regs[R_DEVICE_TEMP_MAX]);
    changed |= (t_min != pmc_sysmon_temp_min_min(s));

    return changed;
}

static void pmc_sysmon_temp_reset_min_max(PMCSysMon *s)
{
    s->temp_min_max_ready = false;
    s->temp_min_min = Q8_7_MAX;
    s->temp_min_max = Q8_7_MAX;
    s->regs[R_DEVICE_TEMP_MIN_MIN] = Q8_7_MAX;
    s->regs[R_DEVICE_TEMP_MAX_MAX] = Q8_7_MIN;

    pmc_sysmon_event_clear(s, R_REG_ISR_TEMP_MASK);
    pmc_sysmon_event_clear(s, R_REG_ISR_OT_MASK);
}

static unsigned pmc_sysmon_temp_sat_avg_count(PMCSysMon *s)
{
    unsigned avg_cnt = ARRAY_FIELD_EX32(s->regs, CONFIG0, TEMP_AVERAGE);

    /* Force invalid count to 1 to simplify dependency */
    switch (avg_cnt) {
    case 1:
    case 2:
    case 4:
    case 8:
        avg_cnt *= 2;
        break;
    case 0:
    default:
        avg_cnt = 1;
    }

    return avg_cnt;
}

static void pmc_sysmon_temp_sat_reset_avg(PMCSysMon *s, unsigned tid)
{
    assert(tid < R_TEMP_SAT_COUNT);

    s->temp_sat_acc[tid].accum = 0;
    s->temp_sat_acc[tid].count = 0;
}

static void pmc_sysmon_temp_sat_set(PMCSysMon *s, unsigned tid, uint32_t val)
{
    unsigned reg = pmc_sysmon_temp_sat_reg(tid);

    s->regs[reg] = val;
    CHANNEL_BIT_SET(s->temp_sat_set, tid);

    if (pmc_sysmon_temp_update_min_max(s, tid, val)) {
        pmc_sysmon_temp_update_alarms(s);
    }
}

static void pmc_sysmon_temp_sat_avg(PMCSysMon *s, unsigned tid, uint32_t val)
{
    unsigned avg_cnt, run_cnt;
    bool avg_en;
    PMCSysMon_TempAcc *avg_acc;

    avg_cnt = pmc_sysmon_temp_sat_avg_count(s);

    avg_en = (avg_cnt > 1) && CHANNEL_BIT(&s->regs[R_EN_AVG_REG8], tid);

    if (!avg_en) {
        pmc_sysmon_temp_sat_set(s, tid, val); /* avg. disabled or sample of 1 */
        return;
    }

    avg_acc = &s->temp_sat_acc[tid];
    avg_acc->accum += q8_7_int(val);

    run_cnt = avg_acc->count + 1;
    if (run_cnt < avg_cnt) {
        avg_acc->count = run_cnt;
    } else {
        /* Enough accumulated; reset for next round */
        int avg = avg_acc->accum / run_cnt;

        val = q8_7_from_int(avg);
        pmc_sysmon_temp_sat_set(s, tid, val);
        pmc_sysmon_temp_sat_reset_avg(s, tid);
    }
}

static void pmc_sysmon_temp_set(PMCSysMon *s, unsigned tid, uint32_t val)
{
    val &= Q8_7_MASK;

    pmc_sysmon_temp_sat_avg(s, tid, val);
}

static void pmc_sysmon_temp_infer(PMCSysMon *s, const xlnx_ams_sensor_t *si)
{
    int lo_int, hi_int;
    uint32_t t_q8_7;

    g_assert(si->meas_id == XLNX_AMS_SAT_MEAS_TYPE_TSENS);

    /*
     * Use mid-point between _TEMP_TH_LOWER/_UPPER if they
     * have been configured; otherwise, use default.
     */
    lo_int = q8_7_int(s->regs[R_DEVICE_TEMP_TH_LOWER]);
    hi_int = q8_7_int(s->regs[R_DEVICE_TEMP_TH_UPPER]);

    if (lo_int >= hi_int) {
        /* If dev-temp is not configured, try ot-temp */
        lo_int = q8_7_int(s->regs[R_OT_TEMP_TH_LOWER]);
        hi_int = q8_7_int(s->regs[R_OT_TEMP_TH_UPPER]);
    }

    if (lo_int >= hi_int) {
        t_q8_7 = q8_7_from_float((double)s->default_celsius);
    } else {
        t_q8_7 = q8_7_from_int((lo_int + hi_int) / 2);
    }

    pmc_sysmon_temp_set(s, si->root_id, t_q8_7);
}

static void pmc_sysmon_temp_dev_th_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    pmc_sysmon_temp_update_dev_alarm(s);
}

static void pmc_sysmon_temp_ot_th_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    pmc_sysmon_temp_update_ot_alarm(s);
}

static void pmc_sysmon_temp_alarm_config_postw(RegisterInfo *reg,
                                               uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t changed = s->reg_prev_value ^ val64;

    if (FIELD_EX32(changed, ALARM_CONFIG, DEV_ALARM_MODE)) {
        pmc_sysmon_temp_update_dev_alarm(s);
    }
    if (FIELD_EX32(changed, ALARM_CONFIG, OT_ALARM_MODE)) {
        pmc_sysmon_temp_update_ot_alarm(s);
    }
}

static void pmc_sysmon_temp_en_avg_reg_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    unsigned nr = reg->access->addr / 4;
    uint32_t changed = s->reg_prev_value ^ val64;

    unsigned tid;

    for (tid = CHANNEL_ID(R_EN_AVG_REG8, nr); changed; changed >>= 1, tid++) {
        if (changed & 1) {
            pmc_sysmon_temp_sat_reset_avg(s, tid);
        }
    }
}

static uint64_t pmc_sysmon_temp_min_min_postr(RegisterInfo *reg, uint64_t val)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);

    val = pmc_sysmon_temp_min_min(s);
    s->regs[R_DEVICE_TEMP_MIN_MIN] = val;

    return val;
}

static uint32_t pmc_sysmon_volt_set_bit(PMCSysMon *s, unsigned r0,
                                        unsigned vid)
{
    unsigned nr = CHANNEL_WORD(vid);
    uint32_t bm = CHANNEL_MASK(vid);

    s->regs[r0 + nr] |= bm;

    return s->regs[r0 + nr];
}

static uint32_t pmc_sysmon_volt_clear_bit(PMCSysMon *s, unsigned r0,
                                          unsigned vid)
{
    unsigned nr = CHANNEL_WORD(vid);
    uint32_t bm = CHANNEL_MASK(vid);

    s->regs[r0 + nr] &= ~bm;

    return s->regs[r0 + nr];
}

static bool pmc_sysmon_volt_get_bit(PMCSysMon *s, unsigned r0, unsigned vid)
{
    unsigned nr = CHANNEL_WORD(vid);
    uint32_t bm = CHANNEL_MASK(vid);

    return !!(s->regs[r0 + nr] & bm);
}

static void pmc_sysmon_volt_clear_alarm(PMCSysMon *s, unsigned vid)
{
    uint32_t isr = R_SUPPLY_ISR_MASK(vid);

    if (pmc_sysmon_volt_clear_bit(s, R_ALARM_FLAG0, vid)) {
        pmc_sysmon_event_set(s, isr);
    } else {
        pmc_sysmon_event_clear(s, isr);
    }
}

static void pmc_sysmon_volt_set_alarm(PMCSysMon *s, unsigned vid)
{
    bool enabled = pmc_sysmon_volt_get_bit(s, R_ALARM_REG0, vid);

    if (enabled) {
        uint32_t isr = R_SUPPLY_ISR_MASK(vid);

        pmc_sysmon_volt_set_bit(s, R_ALARM_FLAG0, vid);
        pmc_sysmon_event_set(s, isr);
    } else {
        pmc_sysmon_volt_clear_alarm(s, vid);
    }
}

static unsigned pmc_sysmon_volt_event_new_vid(PMCSysMon *s, unsigned event_id)
{
    unsigned id_shift = event_id * R_NEW_DATA_INT_SRC_ADDR_ID1_SHIFT;
    uint32_t pool = s->regs[R_NEW_DATA_INT_SRC];

    g_assert(id_shift <= 24);
    pool >>= id_shift;

    return FIELD_EX32(pool, NEW_DATA_INT_SRC, ADDR_ID0);
}

static int pmc_sysmon_volt_event_new_id(PMCSysMon *s, unsigned vid)
{
    unsigned i;

    for (i = 0; i < ARRAY_SIZE(s->ndf_tick); i++) {
        if (pmc_sysmon_volt_event_new_vid(s, i) == vid) {
            return (int)i;
        }
    }

    return -1;
}

static void pmc_sysmon_volt_event_new_sched(PMCSysMon *s, unsigned vid, bool on)
{
    int event_id = pmc_sysmon_volt_event_new_id(s, vid);

    /* Do nothing if vid is not in the event pool */
    if (event_id < 0) {
        return;
    }

    /* Always stop the timer, just in case the kicker is not needed for on */
    timer_del(&s->ndf_tick[event_id]);

    /* Schedule its kicker only if measurement has applied to VID */
    if (on && CHANNEL_BIT(s->ndf_fifo[0], vid)) {
        timer_mod(&s->ndf_tick[event_id], s->ndf_tick_ms);
    }
}

static void pmc_sysmon_volt_event_new(PMCSysMon *s, unsigned vid, bool set)
{
    void (*event_update)(PMCSysMon *s, uint32_t isr_mask);

    event_update = set ? pmc_sysmon_event_set : pmc_sysmon_event_clear;

    if (vid == ARRAY_FIELD_EX32(s->regs, NEW_DATA_INT_SRC, ADDR_ID0)) {
        event_update(s, R_REG_ISR_NEW_DATA0_MASK);
    }
    if (vid == ARRAY_FIELD_EX32(s->regs, NEW_DATA_INT_SRC, ADDR_ID1)) {
        event_update(s, R_REG_ISR_NEW_DATA1_MASK);
    }
    if (vid == ARRAY_FIELD_EX32(s->regs, NEW_DATA_INT_SRC, ADDR_ID2)) {
        event_update(s, R_REG_ISR_NEW_DATA2_MASK);
    }
    if (vid == ARRAY_FIELD_EX32(s->regs, NEW_DATA_INT_SRC, ADDR_ID3)) {
        event_update(s, R_REG_ISR_NEW_DATA3_MASK);
    }
}

static void pmc_sysmon_volt_set_new(PMCSysMon *s, unsigned vid)
{
    size_t nr;

    /*
     * Flood a '1' to all rows of NDF fifo.
     * See comments in pmc_sysmon_new_data_flagx_prew() for detail.
     */
    for (nr = 0; nr < ARRAY_SIZE(s->ndf_fifo); nr++) {
        CHANNEL_BIT_SET(s->ndf_fifo[nr], vid);
    }
    pmc_sysmon_volt_set_bit(s, R_NEW_DATA_FLAG0, vid);
    pmc_sysmon_volt_event_new(s, vid, true);
}

static void pmc_sysmon_volt_clear_new(PMCSysMon *s, unsigned vid)
{
    size_t nr;

    /*
     * Flood a '0' to all but row 0 of NDF fifo.
     * See comments in pmc_sysmon_new_data_flagx_prew() for detail.
     */
    for (nr = 1; nr < ARRAY_SIZE(s->ndf_fifo); nr++) {
        CHANNEL_BIT_CLR(s->ndf_fifo[nr], vid);
    }
    pmc_sysmon_volt_clear_bit(s, R_NEW_DATA_FLAG0, vid);
    pmc_sysmon_volt_event_new(s, vid, false);
}

static void pmc_sysmon_volt_shift_new(PMCSysMon *s, unsigned col)
{
    uint32_t *reg = &s->regs[R_NEW_DATA_FLAG0 + col];
    uint32_t to_0s = *reg, to_1s = *reg;
    uint32_t *row;
    int nr;

    /*
     * Each read shifts the corresponding 32-bit column of the NDF FIFO,
     * with shifted out data captured in NEW_DATA_FLAG[col] register, i.e.,
     *     [0][col] => [1][col] => [2][col] => NEW_DATA_FLAG[col]
     * (with [0][col] remaining intact in each shift).
     *
     * See pmc_sysmon_new_data_flagx_prew() for detail.
     */
    for (row = reg, nr = ARRAY_SIZE(s->ndf_fifo); nr--; ) {
        *row = s->ndf_fifo[nr][col];
        row = &s->ndf_fifo[nr][col];
    }

    /* Any change from 1->0 is a bug */
    to_0s = to_0s & ~(*reg);
    g_assert(!to_0s);

    /* Raise event for those changed from 0->1 */
    to_1s = ~to_1s & *reg;
    for (nr = 32 * col; to_1s; to_1s >>= 1, nr++) {
        if (to_1s & 1) {
            pmc_sysmon_volt_event_new_sched(s, nr, false);
            pmc_sysmon_volt_event_new(s, nr, true);
        }
    }
}

static void pmc_sysmon_volt_kick_new(void *opaque, unsigned event_id)
{
    PMCSysMon *s = PMC_SYSMON(opaque);
    unsigned vid = pmc_sysmon_volt_event_new_vid(s, event_id);

    timer_del(&s->ndf_tick[event_id]);

    /* Do nothing if no measurement has applied to VID yet */
    if (!CHANNEL_BIT(s->ndf_fifo[0], vid)) {
        return;
    }

    /* Do nothing if the '1' state has already recovered */
    if (CHANNEL_BIT(&s->regs[R_NEW_DATA_FLAG0], vid)) {
        return;
    }

    /* Fast-track recovery of the '1' state to its NEW_DATA_FLAG */
    pmc_sysmon_volt_set_new(s, vid);
}

static void pmc_sysmon_volt_kick_new_0(void *opaque)
{
    pmc_sysmon_volt_kick_new(opaque, 0);
}

static void pmc_sysmon_volt_kick_new_1(void *opaque)
{
    pmc_sysmon_volt_kick_new(opaque, 1);
}

static void pmc_sysmon_volt_kick_new_2(void *opaque)
{
    pmc_sysmon_volt_kick_new(opaque, 2);
}

static void pmc_sysmon_volt_kick_new_3(void *opaque)
{
    pmc_sysmon_volt_kick_new(opaque, 3);
}

static void pmc_sysmon_volt_set_min(uint32_t *reg, uint32_t val)
{
    if (mfp19_compare(*reg, val) > 0) {
        *reg = val & MFP19_MASK;
    }
}

static void pmc_sysmon_volt_set_max(uint32_t *reg, uint32_t val)
{
    if (mfp19_compare(*reg, val) < 0) {
        *reg = val & MFP19_MASK;
    }
}

static void pmc_sysmon_volt_update_min_max(PMCSysMon *s, unsigned vid,
                                           uint32_t val)
{
    uint32_t *r_min = &s->regs[R_SUPPLY_MIN(vid)];
    uint32_t *r_max = &s->regs[R_SUPPLY_MAX(vid)];
    uint32_t *ready = &s->volt_min_max_ready[CHANNEL_WORD(vid)];
    uint32_t  ready_mask = CHANNEL_MASK(vid);

    if (!(*ready & ready_mask)) {
        *ready |= ready_mask;
        *r_min = val;
        *r_max = val;
        return;
    }

    /* Alway reinit if format changed */
    if (mfp19_same_signess(*r_min, val)) {
        pmc_sysmon_volt_set_min(r_min, val);
    } else {
        *r_min = val;
    }

    if (mfp19_same_signess(*r_max, val)) {
        pmc_sysmon_volt_set_max(r_max, val);
    } else {
        *r_max = val;
    }
}

static void pmc_sysmon_volt_reset_min_max(PMCSysMon *s)
{
    unsigned vid;

    memset(s->volt_min_max_ready, 0, sizeof(s->volt_min_max_ready));

    for (vid = 0; vid < R_SUPPLY_COUNT; vid++) {
        s->regs[R_SUPPLY_MIN(vid)] = MFP19_MIN;
        s->regs[R_SUPPLY_MAX(vid)] = MFP19_MAX;
        pmc_sysmon_volt_clear_alarm(s, vid);
    }
}

static unsigned pmc_sysmon_volt_avg_count(PMCSysMon *s)
{
    unsigned avg_cnt = ARRAY_FIELD_EX32(s->regs, CONFIG0, AVERAGE);

    /* Force invalid count to 1 to simplify dependency */
    switch (avg_cnt) {
    case 1:
    case 2:
    case 4:
    case 8:
        avg_cnt *= 2;
        break;
    case 0:
    default:
        avg_cnt = 1;
    }

    return avg_cnt;
}

static void pmc_sysmon_volt_reset_avg(PMCSysMon *s, unsigned vid)
{
    s->regs[R_SUPPLY_AVGCALC(vid)] = 0;
}

static bool pmc_sysmon_volt_avg(PMCSysMon *s, unsigned vid, uint32_t val)
{
    uint32_t *reg = &s->regs[R_SUPPLY(vid)];
    uint32_t run = s->regs[R_SUPPLY_AVGCALC(vid)];
    unsigned avg_cnt, run_cnt;
    bool avg_en;

    avg_cnt = pmc_sysmon_volt_avg_count(s);
    avg_en = (avg_cnt > 1) && CHANNEL_BIT(&s->regs[R_EN_AVG_REG0], vid);

    if (!avg_en) {
        *reg = val;   /* avg. disabled or sample of 1 */
        return true;
    }

    s->volt_acc[vid] += mfp19_int(val);

    run_cnt = FIELD_EX32(run, SUPPLY0_AVGCALC, SCOUNT) + 1;
    if (run_cnt < avg_cnt) {
        /* Report intermediate status */
        val = mfp19_from_int(s->volt_acc[vid], val);
        run = FIELD_DP32(run, SUPPLY0_AVGCALC, RAVG, val);
        run = FIELD_DP32(run, SUPPLY0_AVGCALC, SCOUNT, run_cnt);
    } else {
        /* Enough accumulated; reset for next round */
        val = mfp19_from_int((s->volt_acc[vid] / run_cnt), val);
        *reg = val;
        run = 0;
    }

    /* Update avg-run status */
    s->regs[R_SUPPLY_AVGCALC(vid)] = run;

    return !run;
}

static void pmc_sysmon_volt_set(PMCSysMon *s, unsigned vid, uint32_t val)
{
    unsigned scale;
    uint32_t *th_lo, *th_hi;
    int volt;

    assert(vid < R_SUPPLY_COUNT);
    val &= MFP19_MASK;

    /* Update R_SUPPLYn; done if no new avg result yet */
    if (!pmc_sysmon_volt_avg(s, vid, val)) {
        return;
    }

    /* Apply new avg result */
    val = s->regs[R_SUPPLY(vid)];
    volt = mfp19_int(val);
    scale = MFP19_SCALE(val);

    /* Update NEW_DATA_FLAGn and NEW_DATA_INT_SRC */
    pmc_sysmon_volt_set_new(s, vid);

    /* Update min/max and alarm */
    pmc_sysmon_volt_update_min_max(s, vid, val);

    /* Update val_ro field of R_SUPPLYn_TH_LOWER/_UPPER */
    th_lo = &s->regs[R_SUPPLY_TH_LOWER(vid)];
    th_hi = &s->regs[R_SUPPLY_TH_UPPER(vid)];

    *th_lo = FIELD_DP32(*th_lo, SUPPLY0_TH_LOWER, VAL_RO, scale);
    *th_hi = FIELD_DP32(*th_hi, SUPPLY0_TH_UPPER, VAL_RO, scale);

    if (volt < mfp19_int(*th_lo) || volt > mfp19_int(*th_hi)) {
        pmc_sysmon_volt_set_alarm(s, vid);
    } else {
        pmc_sysmon_volt_clear_alarm(s, vid);
    }
}

static void pmc_sysmon_volt_infer(PMCSysMon *s, const xlnx_ams_sensor_t *si)
{
    /* Use mid-point between SUPPLYn_TH_LOWER/_UPPER, scale -16 */
    unsigned vid = si->root_id;
    uint32_t v_mfp19;

    g_assert(vid < R_SUPPLY_COUNT);

    /*
     * Can infer from threshold only if alarm is enabled.  Otherwise,
     * there is no other ways to find out and have to use the default
     * value instead.
     */
    if (!CHANNEL_BIT(&s->regs[R_ALARM_REG0], vid)) {
        v_mfp19 = mfp19_from_float(s->default_volt, si->meas_bipolar, NULL);
    } else {
        uint32_t lo_mfp19, hi_mfp19;
        int lo_q4_16, hi_q4_16, v_q4_16;

        /* Only the mantissa fields of threshold-regs are guest-writable */
        lo_mfp19 = s->regs[R_SUPPLY_TH_LOWER(vid)] & MFP19_MANTISSA_MASK;
        hi_mfp19 = s->regs[R_SUPPLY_TH_UPPER(vid)] & MFP19_MANTISSA_MASK;

        /* Use scale of 0, with sign-ness from sensor-info */
        if (si->meas_bipolar) {
            lo_mfp19 = MFP19_SIGNED(-16, lo_mfp19);
            hi_mfp19 = MFP19_SIGNED(-16, hi_mfp19);
        } else {
            lo_mfp19 = MFP19_UNSIGNED(-16, lo_mfp19);
            hi_mfp19 = MFP19_UNSIGNED(-16, hi_mfp19);
        }

        /* Use Q4.16 to find the mid-point */
        lo_q4_16 = mfp19_int(lo_mfp19);
        hi_q4_16 = mfp19_int(hi_mfp19);
        v_q4_16  = (lo_q4_16 + hi_q4_16) / 2;

        if (si->meas_bipolar) {
            v_mfp19 = mfp19_signed(v_q4_16);
        } else {
            v_mfp19 = mfp19_unsigned(v_q4_16);
        }
    }

    /* Now set it */
    pmc_sysmon_volt_set(s, vid, v_mfp19);
}

static void pmc_sysmon_vccint_set(PMCSysMon *s, unsigned vid, uint32_t val)
{
    switch (vid) {
    case R_VCCINT_FPD_VID:
        s->regs[R_VCCINT_FPD] = val;
        break;
    case R_VCCINT_LPD_VID:
        s->regs[R_VCCINT_LPD] = val;
        break;
    default:
        s->regs[R_VCCINT_SAT1 + vid] = val;
    }
}

static void pmc_sysmon_vccint_infer(PMCSysMon *s, const xlnx_ams_sensor_t *si)
{
    uint32_t v_mfp19;

    g_assert(si->meas_id == XLNX_AMS_SAT_MEAS_TYPE_VCCINT);

    /* TBD. There isn't a good way to infer vccint value */
    v_mfp19 = mfp19_from_float(s->default_volt, false, NULL);
    pmc_sysmon_vccint_set(s, si->root_id, v_mfp19);
}

static void pmc_sysmon_volt_en_avg_reg_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    unsigned nr = reg->access->addr / 4;
    uint32_t changed = s->reg_prev_value ^ val64;

    unsigned vid;

    for (vid = CHANNEL_ID(R_EN_AVG_REG0, nr); changed; changed >>= 1, vid++) {
        if (changed & 1) {
            pmc_sysmon_volt_reset_avg(s, vid);
        }
    }
}

static void pmc_sysmon_alarm_reg_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t changed = s->reg_prev_value ^ val64;
    hwaddr addr = reg->access->addr;
    unsigned nr, vid;

    if (!changed) {
        return;
    }

    assert(addr >= A_ALARM_REG0 && addr <= A_ALARM_REG4);
    nr = (addr - A_ALARM_REG0) / 4;

    vid = nr * 32;
    do {
        if (changed & 1) {
            pmc_sysmon_volt_set_alarm(s, vid);
        }

        vid++;
        changed >>= 1;
    } while (changed);
}

static uint64_t reg_itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t val = val64;

    pmc_sysmon_event_tamper(s, val);

    s->regs[R_REG_ISR] |= val;
    reg_isr_update_irq(s);
    return 0;
}

static uint64_t reg_idr0_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REG_IMR0] |= val;
    reg_isr_update_irq(s);

    return 0;
}

static uint64_t reg_idr1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REG_IMR1] |= val;
    reg_isr_update_irq(s);

    return 0;
}

static void reg_isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    reg_isr_update_irq(s);
}

static uint64_t reg_ier1_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REG_IMR1] &= ~val;
    reg_isr_update_irq(s);

    return 0;
}

static uint64_t reg_ier0_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REG_IMR0] &= ~val;
    reg_isr_update_irq(s);

    return 0;
}

static void pmc_sysmon_efuse_data_put(PMCSysMon *s, XlnxEFuseSysmonData *src)
{
    s->regs[R_SECURE_EFUSE_RDATA_LOW]  = src->rdata_low;
    s->regs[R_SECURE_EFUSE_RDATA_HIGH] = src->rdata_high;
}

static bool pmc_sysmon_efuse_data_xfer(PMCSysMon *s)
{
    XlnxEFuseSysmonData data;
    XlnxEFuse *efuse;
    bool rc;

    /* Check for older DTS releases */
    efuse = (XlnxEFuse *)object_dynamic_cast(s->efuse, TYPE_XLNX_EFUSE);
    if (!efuse) {
        Object *o = object_dynamic_cast(s->efuse, TYPE_XLNX_PMX_EFUSE_CACHE);
        if (o) {
            efuse = XLNX_PMX_EFUSE_CACHE(o)->efuse;
        } else if (s->efuse) {
            efuse = XLNX_VERSAL_EFUSE_CACHE(s->efuse)->efuse;
        }
    }

    rc = xlnx_efuse_get_sysmon(efuse, &data);

    /* Skip updating if in test mode */
    if (!ARRAY_FIELD_EX32(s->regs, REG_PCSR_CONTROL, TEST_SAFE)) {
        pmc_sysmon_efuse_data_put(s, &data);
    }

    return rc; /* status only if in test mode */
}

static void pmc_sysmon_efuse_xfer_start(PMCSysMon *s)
{
    int64_t now_ms = qemu_clock_get_ms(QEMU_CLOCK_VIRTUAL);

    /*
     * The transfer-completion deferral timer serves 2 purposes:
     * 1. For continuous-xfer mode, rate-limit the DONE-event
     *    to avoid interrupt flood.
     * 2. To provide single-xfer mode, by modeling the real
     *    hardware behavior that allows software to make the
     *    START bit transition of 0->1->0 in 2 consecutive
     *    writes to PCSR_CONTROL.
     */
    timer_mod(&s->efuse_throttle_timer, (now_ms + s->efuse_throttle_ms));
}

static void pmc_sysmon_efuse_xfer_done(void *opaque)
{
    PMCSysMon *s = PMC_SYSMON(opaque);

    if (pmc_sysmon_efuse_data_xfer(s)) {
        ARRAY_FIELD_DP32(s->regs, REG_ISR, SECURE_EFUSE_DONE, 1);
    } else {
        ARRAY_FIELD_DP32(s->regs, REG_ISR, SECURE_EFUSE_ERROR, 1);
    }

    reg_isr_update_irq(s);

    if (ARRAY_FIELD_EX32(s->regs, REG_PCSR_CONTROL, SECURE_EFUSE_START)) {
        pmc_sysmon_efuse_xfer_start(s);
    } else {
        timer_del(&s->efuse_throttle_timer);
    }
}

static uint64_t pmc_sysmon_pcsr_control_prew(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t wr_mask, new_val, old_val;
    uint32_t to_1s, to_0s;

    /* Capture mask, because any write to control clears it */
    wr_mask = s->regs[R_REG_PCSR_MASK];
    s->regs[R_REG_PCSR_MASK] = 0;

    /* Control bits blocked by mask cannot be updated */
    old_val = s->regs[R_REG_PCSR_CONTROL];
    new_val = val64;
    new_val = (~wr_mask & old_val) | (wr_mask & new_val);

    /* Save value for applying actions */
    s->regs[R_REG_PCSR_CONTROL] = new_val;

    /* If under test, skip control behavior */
    if (FIELD_EX32(new_val, REG_PCSR_CONTROL, TEST_SAFE)) {
        return new_val;
    }

    /* Apply actions meaningful only when bits changed from 0 to 1 */
    to_1s = ~old_val & new_val;

    if (FIELD_EX32(to_1s, REG_PCSR_CONTROL, SECURE_EFUSE_START)) {
        pmc_sysmon_efuse_xfer_start(s);
    }

    to_0s = old_val & ~new_val;
    if (FIELD_EX32(to_0s, REG_PCSR_CONTROL, INITSTATE) ||
        FIELD_EX32(to_1s, REG_PCSR_CONTROL, PCOMPLETE)) {
        pmc_sysmon_init_measurements(s, s->ams_sat_len);
    }

    return s->regs[R_REG_PCSR_CONTROL];
}

static void pmc_sysmon_config0_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    uint32_t changed = s->reg_prev_value ^ val64;

    /* Issue warning for illegal values */
    switch (ARRAY_FIELD_EX32(s->regs, CONFIG0, TEMP_AVERAGE)) {
    case 0:
    case 1:
    case 2:
    case 4:
    case 8:
        break;
    default:
        warn_report("%s: CONFIG0.temp_average:%u: invalid value!",
                    object_get_canonical_path(OBJECT(s)), (uint32_t)val64);
    }

    switch (ARRAY_FIELD_EX32(s->regs, CONFIG0, AVERAGE)) {
    case 0:
    case 1:
    case 2:
    case 4:
    case 8:
        break;
    default:
        warn_report("%s: CONFIG0.average:%u: invalid value!",
                    object_get_canonical_path(OBJECT(s)), (uint32_t)val64);
    }

    /* Re-compare if temp lower-bound source changed */
    if (FIELD_EX32(changed, CONFIG0, RESERVED2)) {
        pmc_sysmon_temp_update_alarms(s);
    }

    /* Reset averaging if config changed */
    if (FIELD_EX32(changed, CONFIG0, TEMP_AVERAGE)) {
        unsigned tid;

        for (tid = 0; tid < R_TEMP_SAT_COUNT; tid++) {
            pmc_sysmon_temp_sat_reset_avg(s, tid);
        }
    }
    if (FIELD_EX32(changed, CONFIG0, AVERAGE)) {
        unsigned vid;

        for (vid = 0; vid < R_SUPPLY_COUNT; vid++) {
            pmc_sysmon_volt_reset_avg(s, vid);
        }
    }
}

static void pmc_sysmon_status_reset_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);

    if (ARRAY_FIELD_EX32(s->regs, STATUS_RESET, SUPPLY)) {
        pmc_sysmon_volt_reset_min_max(s);
    }

    if (ARRAY_FIELD_EX32(s->regs, STATUS_RESET, DEVICE_TEMP)) {
        pmc_sysmon_temp_reset_min_max(s);
    }
}

static void pmc_sysmon_status_enable_postw(RegisterInfo *reg, uint64_t val64)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    unsigned nr;

    /* Disable also resets counters */
    if (!ARRAY_FIELD_EX32(s->regs, STATUS_ENABLE, PACKETS)) {
        for (nr = R_AXI_PACKETS0; nr <= R_AXI_PACKETS2; nr++) {
            s->regs[nr] = 0;
        }
        for (nr = R_MEAS_PACKETS0; nr <= R_MEAS_PACKETS4; nr++) {
            s->regs[nr] = 0;
        }
    }
}

static uint64_t pmc_sysmon_save_prev_value_prew(RegisterInfo *reg, uint64_t val)
{
    /* Capture pre-existing value for detecting change in post-write */
    PMCSysMon *s = PMC_SYSMON(reg->opaque);

    s->reg_prev_value = s->regs[reg->access->addr / 4];
    return val;
}

static uint64_t new_data_flagx_postr(RegisterInfo *reg, uint64_t val)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    unsigned col = (reg->access->addr - A_NEW_DATA_FLAG0) / 4;

    pmc_sysmon_volt_shift_new(s, col);
    return val;
}

static uint64_t pmc_sysmon_new_data_flagx_prew(RegisterInfo *reg, uint64_t val)
{
    PMCSysMon *s = PMC_SYSMON(reg->opaque);
    unsigned col = (reg->access->addr - A_NEW_DATA_FLAG0) / 4;
    unsigned vid;
    uint32_t v32;

    /*
     * This is write-1-to-clear register.
     *
     * In real hardware, after a write clears a bit (which corresponding
     * to a VID), the bit will be set again when the satellite configured
     * with the VID reports a new measurement in the next round of periodic
     * report cycle.
     *
     * In this simulator, a measurement, once set, is considered sticky,
     * i.e., the same value will be reported in the SUPPLYn register
     * until a new value is applied. In other words, once a NEW_DATA_FLAGx
     * bit is cleared, there will be no new measurement report to set the
     * bit again unless a measurement value is externally injected.
     *
     * One potential solution is to use a QEMU timer to simulate the cyclical
     * reports. However, the use of such a timer is very sensitive to host
     * loading and thus unreliable.  In particular, the sensitivity is quite
     * noticeable if the guest software runs in polling mode, by polling
     * NEW_DATA_FLAG{0..4} registers.
     *
     * The chosen solution is to use each polling read as a trigger to
     * set the cleared bit again. But, it is important to model the
     * typically observation in real hardware, where once a write clears
     * a bit, an immediately following read (or 2) shall see the bit clear.
     *
     * To make sure the polling reads can observe more than 1 time of the
     * bit being cleared, a FIFO is used to delay the recovery of the
     * bit's '1' state:
     * 1. When a NEW_DATA_FLAG{0..4} is read, the FIFO is shifted by 1
     *    layer.
     * 2. When a measurement is applied, the VID's bit is set to '1' in
     *    all layers of the FIFO, so the bit is always observed to be '1'
     *    in all subsequent reads of NEW_DATA_FLAG{0..4}.
     * 3. When the the VID's bit is cleared upon NEW_DATA_FLAG{0..4} being
     *    written, the VID's bit is set to '0' in all but last layers of
     *    the FIFO.
     *
     * Thus, guest software will be able to observe the VID's bit in '0'
     * for N reads, where N is the number of layers in FIFO.
     *
     * In addition to support polling, this also needs to support event
     * driven, where software waits for interrupt from a VID placed into
     * NEW_DATA_INT_SRC. In this mode, the use of timer is unavoidable.
     */
    for (vid = 32 * col, v32 = val; v32; v32 >>= 1, vid++) {
        if (v32 & 1) {
            pmc_sysmon_volt_clear_new(s, vid);
            pmc_sysmon_volt_event_new_sched(s, vid, true);
        }
    }

    return s->regs[R_NEW_DATA_FLAG0 + col];
}

static const RegisterAccessInfo pmc_sysmon_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x1fe,
        .pre_write = pmc_sysmon_pcsr_control_prew,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = 0x1,
        .rsvd = 0xffffc000,
        .ro = 0x3fff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "REG_ITR",  .addr = A_REG_ITR,
        .pre_write = reg_itr_prew,
    },{ .name = "REG_ISR",  .addr = A_REG_ISR,
        .w1c = 0xffffffff,
        .pre_write = reg_isr_prew,
        .post_write = reg_isr_postw,
    },{ .name = "REG_IMR0",  .addr = A_REG_IMR0,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "REG_IER0",  .addr = A_REG_IER0,
        .pre_write = reg_ier0_prew,
    },{ .name = "REG_IDR0",  .addr = A_REG_IDR0,
        .pre_write = reg_idr0_prew,
    },{ .name = "REG_IMR1",  .addr = A_REG_IMR1,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "REG_IER1",  .addr = A_REG_IER1,
        .pre_write = reg_ier1_prew,
    },{ .name = "REG_IDR1",  .addr = A_REG_IDR1,
        .pre_write = reg_idr1_prew,
    },{ .name = "REG_IOR",  .addr = A_REG_IOR,
        .reset = 0xc,
        .rsvd = 0xffffffe0,
    },{ .name = "CONFIG0",  .addr = A_CONFIG0,
        .rsvd = 0xf03c0000,
        .ro = 0x3c0000,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_config0_postw,
    },{ .name = "TOKEN_MNGR",  .addr = A_TOKEN_MNGR,
        .rsvd = 0xffe00000,
    },{ .name = "VREF_SSC_COUNT1",  .addr = A_VREF_SSC_COUNT1,
        .rsvd = 0xfffc0000,
    },{ .name = "VREF_SSC_COUNT2",  .addr = A_VREF_SSC_COUNT2,
        .rsvd = 0xfffc0000,
    },{ .name = "VREF_SSC_COUNT3",  .addr = A_VREF_SSC_COUNT3,
        .rsvd = 0xfffc0000,
    },{ .name = "VREF_SSC_COUNT4",  .addr = A_VREF_SSC_COUNT4,
        .rsvd = 0xfffc0000,
    },{ .name = "GOQ_CONFIG",  .addr = A_GOQ_CONFIG,
        .rsvd = 0xffff0000,
    },{ .name = "METAL_OPTION_OVERRIDES",  .addr = A_METAL_OPTION_OVERRIDES,
        .rsvd = 0xfc000000,
    },{ .name = "GREF_MODE_SETTING",  .addr = A_GREF_MODE_SETTING,
        .reset = 0x200,
        .rsvd = 0xfffff800,
    },{ .name = "AXI_BUFFER_BASE_HIGH",  .addr = A_AXI_BUFFER_BASE_HIGH,
        .reset = 0x1f127,
    },{ .name = "AXI_BUFFER_OFFSET",  .addr = A_AXI_BUFFER_OFFSET,
        .reset = 0x4fff4000,
    },{ .name = "TEST_ANA_CTRL0",  .addr = A_TEST_ANA_CTRL0,
    },{ .name = "TEST_ANA_CTRL1",  .addr = A_TEST_ANA_CTRL1,
    },{ .name = "TEST_REG0",  .addr = A_TEST_REG0,
        .rsvd = 0xfffffffc,
    },{ .name = "DFX_REG0",  .addr = A_DFX_REG0,
        .rsvd = 0xfffffffc,
    },{ .name = "EFUSE_REG0",  .addr = A_EFUSE_REG0,
    },{ .name = "EFUSE_REG1",  .addr = A_EFUSE_REG1,
    },{ .name = "EFUSE_REG2",  .addr = A_EFUSE_REG2,
    },{ .name = "EFUSE_REG3",  .addr = A_EFUSE_REG3,
        .rsvd = 0xfff00000,
    },{ .name = "REG_IXPCM_CONF_READY",  .addr = A_REG_IXPCM_CONF_READY,
    },{ .name = "REG_IXPCM_CONF",  .addr = A_REG_IXPCM_CONF,
    },{ .name = "REG_IXPCM_MEAS_CONF_0",  .addr = A_REG_IXPCM_MEAS_CONF_0,
    },{ .name = "REG_IXPCM_MEAS_CONF_1",  .addr = A_REG_IXPCM_MEAS_CONF_1,
    },{ .name = "NEW_DATA_FLAG0",  .addr = A_NEW_DATA_FLAG0,
        .pre_write = pmc_sysmon_new_data_flagx_prew,
        .post_read = new_data_flagx_postr,
    },{ .name = "NEW_DATA_FLAG1",  .addr = A_NEW_DATA_FLAG1,
        .pre_write = pmc_sysmon_new_data_flagx_prew,
        .post_read = new_data_flagx_postr,
    },{ .name = "NEW_DATA_FLAG2",  .addr = A_NEW_DATA_FLAG2,
        .pre_write = pmc_sysmon_new_data_flagx_prew,
        .post_read = new_data_flagx_postr,
    },{ .name = "NEW_DATA_FLAG3",  .addr = A_NEW_DATA_FLAG3,
        .pre_write = pmc_sysmon_new_data_flagx_prew,
        .post_read = new_data_flagx_postr,
    },{ .name = "NEW_DATA_FLAG4",  .addr = A_NEW_DATA_FLAG4,
        .pre_write = pmc_sysmon_new_data_flagx_prew,
        .post_read = new_data_flagx_postr,
    },{ .name = "ALARM_FLAG0",  .addr = A_ALARM_FLAG0,
        .w1c = 0xffffffff,
    },{ .name = "ALARM_FLAG1",  .addr = A_ALARM_FLAG1,
        .w1c = 0xffffffff,
    },{ .name = "ALARM_FLAG2",  .addr = A_ALARM_FLAG2,
        .w1c = 0xffffffff,
    },{ .name = "ALARM_FLAG3",  .addr = A_ALARM_FLAG3,
        .w1c = 0xffffffff,
    },{ .name = "ALARM_FLAG4",  .addr = A_ALARM_FLAG4,
        .w1c = 0xffffffff,
    },{ .name = "DEVICE_TEMP_MAX",  .addr = A_DEVICE_TEMP_MAX,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "DEVICE_TEMP_MIN",  .addr = A_DEVICE_TEMP_MIN,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_FPD",  .addr = A_TEMP_FPD,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_LPD",  .addr = A_TEMP_LPD,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "SUPPLY0",  .addr = A_SUPPLY0,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY1",  .addr = A_SUPPLY1,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY2",  .addr = A_SUPPLY2,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY3",  .addr = A_SUPPLY3,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY4",  .addr = A_SUPPLY4,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY5",  .addr = A_SUPPLY5,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY6",  .addr = A_SUPPLY6,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY7",  .addr = A_SUPPLY7,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY8",  .addr = A_SUPPLY8,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY9",  .addr = A_SUPPLY9,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY10",  .addr = A_SUPPLY10,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY11",  .addr = A_SUPPLY11,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY12",  .addr = A_SUPPLY12,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY13",  .addr = A_SUPPLY13,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY14",  .addr = A_SUPPLY14,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY15",  .addr = A_SUPPLY15,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY16",  .addr = A_SUPPLY16,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY17",  .addr = A_SUPPLY17,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY18",  .addr = A_SUPPLY18,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY19",  .addr = A_SUPPLY19,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY20",  .addr = A_SUPPLY20,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY21",  .addr = A_SUPPLY21,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY22",  .addr = A_SUPPLY22,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY23",  .addr = A_SUPPLY23,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY24",  .addr = A_SUPPLY24,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY25",  .addr = A_SUPPLY25,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY26",  .addr = A_SUPPLY26,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY27",  .addr = A_SUPPLY27,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY28",  .addr = A_SUPPLY28,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY29",  .addr = A_SUPPLY29,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY30",  .addr = A_SUPPLY30,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY31",  .addr = A_SUPPLY31,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY32",  .addr = A_SUPPLY32,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY33",  .addr = A_SUPPLY33,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY34",  .addr = A_SUPPLY34,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY35",  .addr = A_SUPPLY35,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY36",  .addr = A_SUPPLY36,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY37",  .addr = A_SUPPLY37,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY38",  .addr = A_SUPPLY38,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY39",  .addr = A_SUPPLY39,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY40",  .addr = A_SUPPLY40,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY41",  .addr = A_SUPPLY41,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY42",  .addr = A_SUPPLY42,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY43",  .addr = A_SUPPLY43,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY44",  .addr = A_SUPPLY44,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY45",  .addr = A_SUPPLY45,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY46",  .addr = A_SUPPLY46,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY47",  .addr = A_SUPPLY47,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY48",  .addr = A_SUPPLY48,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY49",  .addr = A_SUPPLY49,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY50",  .addr = A_SUPPLY50,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY51",  .addr = A_SUPPLY51,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY52",  .addr = A_SUPPLY52,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY53",  .addr = A_SUPPLY53,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY54",  .addr = A_SUPPLY54,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY55",  .addr = A_SUPPLY55,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY56",  .addr = A_SUPPLY56,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY57",  .addr = A_SUPPLY57,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY58",  .addr = A_SUPPLY58,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY59",  .addr = A_SUPPLY59,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY60",  .addr = A_SUPPLY60,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY61",  .addr = A_SUPPLY61,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY62",  .addr = A_SUPPLY62,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY63",  .addr = A_SUPPLY63,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY64",  .addr = A_SUPPLY64,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY65",  .addr = A_SUPPLY65,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY66",  .addr = A_SUPPLY66,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY67",  .addr = A_SUPPLY67,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY68",  .addr = A_SUPPLY68,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY69",  .addr = A_SUPPLY69,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY70",  .addr = A_SUPPLY70,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY71",  .addr = A_SUPPLY71,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY72",  .addr = A_SUPPLY72,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY73",  .addr = A_SUPPLY73,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY74",  .addr = A_SUPPLY74,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY75",  .addr = A_SUPPLY75,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY76",  .addr = A_SUPPLY76,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY77",  .addr = A_SUPPLY77,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY78",  .addr = A_SUPPLY78,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY79",  .addr = A_SUPPLY79,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY80",  .addr = A_SUPPLY80,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY81",  .addr = A_SUPPLY81,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY82",  .addr = A_SUPPLY82,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY83",  .addr = A_SUPPLY83,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY84",  .addr = A_SUPPLY84,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY85",  .addr = A_SUPPLY85,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY86",  .addr = A_SUPPLY86,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY87",  .addr = A_SUPPLY87,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY88",  .addr = A_SUPPLY88,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY89",  .addr = A_SUPPLY89,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY90",  .addr = A_SUPPLY90,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY91",  .addr = A_SUPPLY91,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY92",  .addr = A_SUPPLY92,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY93",  .addr = A_SUPPLY93,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY94",  .addr = A_SUPPLY94,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY95",  .addr = A_SUPPLY95,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY96",  .addr = A_SUPPLY96,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY97",  .addr = A_SUPPLY97,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY98",  .addr = A_SUPPLY98,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY99",  .addr = A_SUPPLY99,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY100",  .addr = A_SUPPLY100,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY101",  .addr = A_SUPPLY101,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY102",  .addr = A_SUPPLY102,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY103",  .addr = A_SUPPLY103,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY104",  .addr = A_SUPPLY104,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY105",  .addr = A_SUPPLY105,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY106",  .addr = A_SUPPLY106,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY107",  .addr = A_SUPPLY107,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY108",  .addr = A_SUPPLY108,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY109",  .addr = A_SUPPLY109,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY110",  .addr = A_SUPPLY110,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY111",  .addr = A_SUPPLY111,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY112",  .addr = A_SUPPLY112,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY113",  .addr = A_SUPPLY113,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY114",  .addr = A_SUPPLY114,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY115",  .addr = A_SUPPLY115,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY116",  .addr = A_SUPPLY116,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY117",  .addr = A_SUPPLY117,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY118",  .addr = A_SUPPLY118,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY119",  .addr = A_SUPPLY119,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY120",  .addr = A_SUPPLY120,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY121",  .addr = A_SUPPLY121,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY122",  .addr = A_SUPPLY122,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY123",  .addr = A_SUPPLY123,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY124",  .addr = A_SUPPLY124,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY125",  .addr = A_SUPPLY125,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY126",  .addr = A_SUPPLY126,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY127",  .addr = A_SUPPLY127,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY128",  .addr = A_SUPPLY128,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY129",  .addr = A_SUPPLY129,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY130",  .addr = A_SUPPLY130,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY131",  .addr = A_SUPPLY131,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY132",  .addr = A_SUPPLY132,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY133",  .addr = A_SUPPLY133,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY134",  .addr = A_SUPPLY134,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY135",  .addr = A_SUPPLY135,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY136",  .addr = A_SUPPLY136,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY137",  .addr = A_SUPPLY137,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY138",  .addr = A_SUPPLY138,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY139",  .addr = A_SUPPLY139,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY140",  .addr = A_SUPPLY140,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY141",  .addr = A_SUPPLY141,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY142",  .addr = A_SUPPLY142,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY143",  .addr = A_SUPPLY143,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY144",  .addr = A_SUPPLY144,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY145",  .addr = A_SUPPLY145,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY146",  .addr = A_SUPPLY146,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY147",  .addr = A_SUPPLY147,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY148",  .addr = A_SUPPLY148,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY149",  .addr = A_SUPPLY149,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY150",  .addr = A_SUPPLY150,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY151",  .addr = A_SUPPLY151,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY152",  .addr = A_SUPPLY152,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY153",  .addr = A_SUPPLY153,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY154",  .addr = A_SUPPLY154,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY155",  .addr = A_SUPPLY155,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY156",  .addr = A_SUPPLY156,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY157",  .addr = A_SUPPLY157,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY158",  .addr = A_SUPPLY158,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY159",  .addr = A_SUPPLY159,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY0_MIN",  .addr = A_SUPPLY0_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY1_MIN",  .addr = A_SUPPLY1_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY2_MIN",  .addr = A_SUPPLY2_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY3_MIN",  .addr = A_SUPPLY3_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY4_MIN",  .addr = A_SUPPLY4_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY5_MIN",  .addr = A_SUPPLY5_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY6_MIN",  .addr = A_SUPPLY6_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY7_MIN",  .addr = A_SUPPLY7_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY8_MIN",  .addr = A_SUPPLY8_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY9_MIN",  .addr = A_SUPPLY9_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY10_MIN",  .addr = A_SUPPLY10_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY11_MIN",  .addr = A_SUPPLY11_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY12_MIN",  .addr = A_SUPPLY12_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY13_MIN",  .addr = A_SUPPLY13_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY14_MIN",  .addr = A_SUPPLY14_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY15_MIN",  .addr = A_SUPPLY15_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY16_MIN",  .addr = A_SUPPLY16_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY17_MIN",  .addr = A_SUPPLY17_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY18_MIN",  .addr = A_SUPPLY18_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY19_MIN",  .addr = A_SUPPLY19_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY20_MIN",  .addr = A_SUPPLY20_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY21_MIN",  .addr = A_SUPPLY21_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY22_MIN",  .addr = A_SUPPLY22_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY23_MIN",  .addr = A_SUPPLY23_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY24_MIN",  .addr = A_SUPPLY24_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY25_MIN",  .addr = A_SUPPLY25_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY26_MIN",  .addr = A_SUPPLY26_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY27_MIN",  .addr = A_SUPPLY27_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY28_MIN",  .addr = A_SUPPLY28_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY29_MIN",  .addr = A_SUPPLY29_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY30_MIN",  .addr = A_SUPPLY30_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY31_MIN",  .addr = A_SUPPLY31_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY32_MIN",  .addr = A_SUPPLY32_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY33_MIN",  .addr = A_SUPPLY33_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY34_MIN",  .addr = A_SUPPLY34_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY35_MIN",  .addr = A_SUPPLY35_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY36_MIN",  .addr = A_SUPPLY36_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY37_MIN",  .addr = A_SUPPLY37_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY38_MIN",  .addr = A_SUPPLY38_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY39_MIN",  .addr = A_SUPPLY39_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY40_MIN",  .addr = A_SUPPLY40_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY41_MIN",  .addr = A_SUPPLY41_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY42_MIN",  .addr = A_SUPPLY42_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY43_MIN",  .addr = A_SUPPLY43_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY44_MIN",  .addr = A_SUPPLY44_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY45_MIN",  .addr = A_SUPPLY45_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY46_MIN",  .addr = A_SUPPLY46_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY47_MIN",  .addr = A_SUPPLY47_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY48_MIN",  .addr = A_SUPPLY48_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY49_MIN",  .addr = A_SUPPLY49_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY50_MIN",  .addr = A_SUPPLY50_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY51_MIN",  .addr = A_SUPPLY51_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY52_MIN",  .addr = A_SUPPLY52_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY53_MIN",  .addr = A_SUPPLY53_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY54_MIN",  .addr = A_SUPPLY54_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY55_MIN",  .addr = A_SUPPLY55_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY56_MIN",  .addr = A_SUPPLY56_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY57_MIN",  .addr = A_SUPPLY57_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY58_MIN",  .addr = A_SUPPLY58_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY59_MIN",  .addr = A_SUPPLY59_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY60_MIN",  .addr = A_SUPPLY60_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY61_MIN",  .addr = A_SUPPLY61_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY62_MIN",  .addr = A_SUPPLY62_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY63_MIN",  .addr = A_SUPPLY63_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY64_MIN",  .addr = A_SUPPLY64_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY65_MIN",  .addr = A_SUPPLY65_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY66_MIN",  .addr = A_SUPPLY66_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY67_MIN",  .addr = A_SUPPLY67_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY68_MIN",  .addr = A_SUPPLY68_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY69_MIN",  .addr = A_SUPPLY69_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY70_MIN",  .addr = A_SUPPLY70_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY71_MIN",  .addr = A_SUPPLY71_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY72_MIN",  .addr = A_SUPPLY72_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY73_MIN",  .addr = A_SUPPLY73_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY74_MIN",  .addr = A_SUPPLY74_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY75_MIN",  .addr = A_SUPPLY75_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY76_MIN",  .addr = A_SUPPLY76_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY77_MIN",  .addr = A_SUPPLY77_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY78_MIN",  .addr = A_SUPPLY78_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY79_MIN",  .addr = A_SUPPLY79_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY80_MIN",  .addr = A_SUPPLY80_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY81_MIN",  .addr = A_SUPPLY81_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY82_MIN",  .addr = A_SUPPLY82_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY83_MIN",  .addr = A_SUPPLY83_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY84_MIN",  .addr = A_SUPPLY84_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY85_MIN",  .addr = A_SUPPLY85_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY86_MIN",  .addr = A_SUPPLY86_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY87_MIN",  .addr = A_SUPPLY87_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY88_MIN",  .addr = A_SUPPLY88_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY89_MIN",  .addr = A_SUPPLY89_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY90_MIN",  .addr = A_SUPPLY90_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY91_MIN",  .addr = A_SUPPLY91_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY92_MIN",  .addr = A_SUPPLY92_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY93_MIN",  .addr = A_SUPPLY93_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY94_MIN",  .addr = A_SUPPLY94_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY95_MIN",  .addr = A_SUPPLY95_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY96_MIN",  .addr = A_SUPPLY96_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY97_MIN",  .addr = A_SUPPLY97_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY98_MIN",  .addr = A_SUPPLY98_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY99_MIN",  .addr = A_SUPPLY99_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY100_MIN",  .addr = A_SUPPLY100_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY101_MIN",  .addr = A_SUPPLY101_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY102_MIN",  .addr = A_SUPPLY102_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY103_MIN",  .addr = A_SUPPLY103_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY104_MIN",  .addr = A_SUPPLY104_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY105_MIN",  .addr = A_SUPPLY105_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY106_MIN",  .addr = A_SUPPLY106_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY107_MIN",  .addr = A_SUPPLY107_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY108_MIN",  .addr = A_SUPPLY108_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY109_MIN",  .addr = A_SUPPLY109_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY110_MIN",  .addr = A_SUPPLY110_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY111_MIN",  .addr = A_SUPPLY111_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY112_MIN",  .addr = A_SUPPLY112_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY113_MIN",  .addr = A_SUPPLY113_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY114_MIN",  .addr = A_SUPPLY114_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY115_MIN",  .addr = A_SUPPLY115_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY116_MIN",  .addr = A_SUPPLY116_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY117_MIN",  .addr = A_SUPPLY117_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY118_MIN",  .addr = A_SUPPLY118_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY119_MIN",  .addr = A_SUPPLY119_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY120_MIN",  .addr = A_SUPPLY120_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY121_MIN",  .addr = A_SUPPLY121_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY122_MIN",  .addr = A_SUPPLY122_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY123_MIN",  .addr = A_SUPPLY123_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY124_MIN",  .addr = A_SUPPLY124_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY125_MIN",  .addr = A_SUPPLY125_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY126_MIN",  .addr = A_SUPPLY126_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY127_MIN",  .addr = A_SUPPLY127_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY128_MIN",  .addr = A_SUPPLY128_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY129_MIN",  .addr = A_SUPPLY129_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY130_MIN",  .addr = A_SUPPLY130_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY131_MIN",  .addr = A_SUPPLY131_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY132_MIN",  .addr = A_SUPPLY132_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY133_MIN",  .addr = A_SUPPLY133_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY134_MIN",  .addr = A_SUPPLY134_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY135_MIN",  .addr = A_SUPPLY135_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY136_MIN",  .addr = A_SUPPLY136_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY137_MIN",  .addr = A_SUPPLY137_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY138_MIN",  .addr = A_SUPPLY138_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY139_MIN",  .addr = A_SUPPLY139_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY140_MIN",  .addr = A_SUPPLY140_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY141_MIN",  .addr = A_SUPPLY141_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY142_MIN",  .addr = A_SUPPLY142_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY143_MIN",  .addr = A_SUPPLY143_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY144_MIN",  .addr = A_SUPPLY144_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY145_MIN",  .addr = A_SUPPLY145_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY146_MIN",  .addr = A_SUPPLY146_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY147_MIN",  .addr = A_SUPPLY147_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY148_MIN",  .addr = A_SUPPLY148_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY149_MIN",  .addr = A_SUPPLY149_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY150_MIN",  .addr = A_SUPPLY150_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY151_MIN",  .addr = A_SUPPLY151_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY152_MIN",  .addr = A_SUPPLY152_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY153_MIN",  .addr = A_SUPPLY153_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY154_MIN",  .addr = A_SUPPLY154_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY155_MIN",  .addr = A_SUPPLY155_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY156_MIN",  .addr = A_SUPPLY156_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY157_MIN",  .addr = A_SUPPLY157_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY158_MIN",  .addr = A_SUPPLY158_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY159_MIN",  .addr = A_SUPPLY159_MIN,
        .reset = 0xffff,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY0_MAX",  .addr = A_SUPPLY0_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY1_MAX",  .addr = A_SUPPLY1_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY2_MAX",  .addr = A_SUPPLY2_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY3_MAX",  .addr = A_SUPPLY3_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY4_MAX",  .addr = A_SUPPLY4_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY5_MAX",  .addr = A_SUPPLY5_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY6_MAX",  .addr = A_SUPPLY6_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY7_MAX",  .addr = A_SUPPLY7_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY8_MAX",  .addr = A_SUPPLY8_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY9_MAX",  .addr = A_SUPPLY9_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY10_MAX",  .addr = A_SUPPLY10_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY11_MAX",  .addr = A_SUPPLY11_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY12_MAX",  .addr = A_SUPPLY12_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY13_MAX",  .addr = A_SUPPLY13_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY14_MAX",  .addr = A_SUPPLY14_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY15_MAX",  .addr = A_SUPPLY15_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY16_MAX",  .addr = A_SUPPLY16_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY17_MAX",  .addr = A_SUPPLY17_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY18_MAX",  .addr = A_SUPPLY18_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY19_MAX",  .addr = A_SUPPLY19_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY20_MAX",  .addr = A_SUPPLY20_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY21_MAX",  .addr = A_SUPPLY21_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY22_MAX",  .addr = A_SUPPLY22_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY23_MAX",  .addr = A_SUPPLY23_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY24_MAX",  .addr = A_SUPPLY24_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY25_MAX",  .addr = A_SUPPLY25_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY26_MAX",  .addr = A_SUPPLY26_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY27_MAX",  .addr = A_SUPPLY27_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY28_MAX",  .addr = A_SUPPLY28_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY29_MAX",  .addr = A_SUPPLY29_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY30_MAX",  .addr = A_SUPPLY30_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY31_MAX",  .addr = A_SUPPLY31_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY32_MAX",  .addr = A_SUPPLY32_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY33_MAX",  .addr = A_SUPPLY33_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY34_MAX",  .addr = A_SUPPLY34_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY35_MAX",  .addr = A_SUPPLY35_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY36_MAX",  .addr = A_SUPPLY36_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY37_MAX",  .addr = A_SUPPLY37_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY38_MAX",  .addr = A_SUPPLY38_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY39_MAX",  .addr = A_SUPPLY39_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY40_MAX",  .addr = A_SUPPLY40_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY41_MAX",  .addr = A_SUPPLY41_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY42_MAX",  .addr = A_SUPPLY42_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY43_MAX",  .addr = A_SUPPLY43_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY44_MAX",  .addr = A_SUPPLY44_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY45_MAX",  .addr = A_SUPPLY45_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY46_MAX",  .addr = A_SUPPLY46_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY47_MAX",  .addr = A_SUPPLY47_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY48_MAX",  .addr = A_SUPPLY48_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY49_MAX",  .addr = A_SUPPLY49_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY50_MAX",  .addr = A_SUPPLY50_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY51_MAX",  .addr = A_SUPPLY51_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY52_MAX",  .addr = A_SUPPLY52_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY53_MAX",  .addr = A_SUPPLY53_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY54_MAX",  .addr = A_SUPPLY54_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY55_MAX",  .addr = A_SUPPLY55_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY56_MAX",  .addr = A_SUPPLY56_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY57_MAX",  .addr = A_SUPPLY57_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY58_MAX",  .addr = A_SUPPLY58_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY59_MAX",  .addr = A_SUPPLY59_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY60_MAX",  .addr = A_SUPPLY60_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY61_MAX",  .addr = A_SUPPLY61_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY62_MAX",  .addr = A_SUPPLY62_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY63_MAX",  .addr = A_SUPPLY63_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY64_MAX",  .addr = A_SUPPLY64_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY65_MAX",  .addr = A_SUPPLY65_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY66_MAX",  .addr = A_SUPPLY66_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY67_MAX",  .addr = A_SUPPLY67_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY68_MAX",  .addr = A_SUPPLY68_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY69_MAX",  .addr = A_SUPPLY69_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY70_MAX",  .addr = A_SUPPLY70_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY71_MAX",  .addr = A_SUPPLY71_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY72_MAX",  .addr = A_SUPPLY72_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY73_MAX",  .addr = A_SUPPLY73_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY74_MAX",  .addr = A_SUPPLY74_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY75_MAX",  .addr = A_SUPPLY75_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY76_MAX",  .addr = A_SUPPLY76_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY77_MAX",  .addr = A_SUPPLY77_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY78_MAX",  .addr = A_SUPPLY78_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY79_MAX",  .addr = A_SUPPLY79_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY80_MAX",  .addr = A_SUPPLY80_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY81_MAX",  .addr = A_SUPPLY81_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY82_MAX",  .addr = A_SUPPLY82_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY83_MAX",  .addr = A_SUPPLY83_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY84_MAX",  .addr = A_SUPPLY84_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY85_MAX",  .addr = A_SUPPLY85_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY86_MAX",  .addr = A_SUPPLY86_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY87_MAX",  .addr = A_SUPPLY87_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY88_MAX",  .addr = A_SUPPLY88_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY89_MAX",  .addr = A_SUPPLY89_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY90_MAX",  .addr = A_SUPPLY90_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY91_MAX",  .addr = A_SUPPLY91_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY92_MAX",  .addr = A_SUPPLY92_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY93_MAX",  .addr = A_SUPPLY93_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY94_MAX",  .addr = A_SUPPLY94_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY95_MAX",  .addr = A_SUPPLY95_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY96_MAX",  .addr = A_SUPPLY96_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY97_MAX",  .addr = A_SUPPLY97_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY98_MAX",  .addr = A_SUPPLY98_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY99_MAX",  .addr = A_SUPPLY99_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY100_MAX",  .addr = A_SUPPLY100_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY101_MAX",  .addr = A_SUPPLY101_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY102_MAX",  .addr = A_SUPPLY102_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY103_MAX",  .addr = A_SUPPLY103_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY104_MAX",  .addr = A_SUPPLY104_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY105_MAX",  .addr = A_SUPPLY105_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY106_MAX",  .addr = A_SUPPLY106_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY107_MAX",  .addr = A_SUPPLY107_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY108_MAX",  .addr = A_SUPPLY108_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY109_MAX",  .addr = A_SUPPLY109_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY110_MAX",  .addr = A_SUPPLY110_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY111_MAX",  .addr = A_SUPPLY111_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY112_MAX",  .addr = A_SUPPLY112_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY113_MAX",  .addr = A_SUPPLY113_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY114_MAX",  .addr = A_SUPPLY114_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY115_MAX",  .addr = A_SUPPLY115_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY116_MAX",  .addr = A_SUPPLY116_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY117_MAX",  .addr = A_SUPPLY117_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY118_MAX",  .addr = A_SUPPLY118_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY119_MAX",  .addr = A_SUPPLY119_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY120_MAX",  .addr = A_SUPPLY120_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY121_MAX",  .addr = A_SUPPLY121_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY122_MAX",  .addr = A_SUPPLY122_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY123_MAX",  .addr = A_SUPPLY123_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY124_MAX",  .addr = A_SUPPLY124_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY125_MAX",  .addr = A_SUPPLY125_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY126_MAX",  .addr = A_SUPPLY126_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY127_MAX",  .addr = A_SUPPLY127_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY128_MAX",  .addr = A_SUPPLY128_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY129_MAX",  .addr = A_SUPPLY129_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY130_MAX",  .addr = A_SUPPLY130_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY131_MAX",  .addr = A_SUPPLY131_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY132_MAX",  .addr = A_SUPPLY132_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY133_MAX",  .addr = A_SUPPLY133_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY134_MAX",  .addr = A_SUPPLY134_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY135_MAX",  .addr = A_SUPPLY135_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY136_MAX",  .addr = A_SUPPLY136_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY137_MAX",  .addr = A_SUPPLY137_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY138_MAX",  .addr = A_SUPPLY138_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY139_MAX",  .addr = A_SUPPLY139_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY140_MAX",  .addr = A_SUPPLY140_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY141_MAX",  .addr = A_SUPPLY141_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY142_MAX",  .addr = A_SUPPLY142_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY143_MAX",  .addr = A_SUPPLY143_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY144_MAX",  .addr = A_SUPPLY144_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY145_MAX",  .addr = A_SUPPLY145_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY146_MAX",  .addr = A_SUPPLY146_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY147_MAX",  .addr = A_SUPPLY147_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY148_MAX",  .addr = A_SUPPLY148_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY149_MAX",  .addr = A_SUPPLY149_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY150_MAX",  .addr = A_SUPPLY150_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY151_MAX",  .addr = A_SUPPLY151_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY152_MAX",  .addr = A_SUPPLY152_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY153_MAX",  .addr = A_SUPPLY153_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY154_MAX",  .addr = A_SUPPLY154_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY155_MAX",  .addr = A_SUPPLY155_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY156_MAX",  .addr = A_SUPPLY156_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY157_MAX",  .addr = A_SUPPLY157_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY158_MAX",  .addr = A_SUPPLY158_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY159_MAX",  .addr = A_SUPPLY159_MAX,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "ALARM_REG0",  .addr = A_ALARM_REG0,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_alarm_reg_postw,
    },{ .name = "ALARM_REG1",  .addr = A_ALARM_REG1,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_alarm_reg_postw,
    },{ .name = "ALARM_REG2",  .addr = A_ALARM_REG2,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_alarm_reg_postw,
    },{ .name = "ALARM_REG3",  .addr = A_ALARM_REG3,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_alarm_reg_postw,
    },{ .name = "ALARM_REG4",  .addr = A_ALARM_REG4,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_alarm_reg_postw,
    },{ .name = "EN_AVG_REG0",  .addr = A_EN_AVG_REG0,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_volt_en_avg_reg_postw,
    },{ .name = "EN_AVG_REG1",  .addr = A_EN_AVG_REG1,
    },{ .name = "EN_AVG_REG2",  .addr = A_EN_AVG_REG2,
    },{ .name = "EN_AVG_REG3",  .addr = A_EN_AVG_REG3,
    },{ .name = "EN_AVG_REG4",  .addr = A_EN_AVG_REG4,
    },{ .name = "DEVICE_TEMP_TH_LOWER",  .addr = A_DEVICE_TEMP_TH_LOWER,
        .reset = 0x8000,
        .rsvd = 0xffff0000,
        .post_write = pmc_sysmon_temp_dev_th_postw,
    },{ .name = "DEVICE_TEMP_TH_UPPER",  .addr = A_DEVICE_TEMP_TH_UPPER,
        .reset = 0x7fff,
        .rsvd = 0xffff0000,
        .post_write = pmc_sysmon_temp_dev_th_postw,
    },{ .name = "OT_TEMP_TH_LOWER",  .addr = A_OT_TEMP_TH_LOWER,
        .reset = 0x8000,
        .post_write = pmc_sysmon_temp_ot_th_postw,
        .rsvd = 0xffff0000,
    },{ .name = "OT_TEMP_TH_UPPER",  .addr = A_OT_TEMP_TH_UPPER,
        .reset = 0x3e80,
        .rsvd = 0xffff0000,
        .post_write = pmc_sysmon_temp_ot_th_postw,
    },{ .name = "SUPPLY0_TH_LOWER",  .addr = A_SUPPLY0_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY1_TH_LOWER",  .addr = A_SUPPLY1_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY2_TH_LOWER",  .addr = A_SUPPLY2_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY3_TH_LOWER",  .addr = A_SUPPLY3_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY4_TH_LOWER",  .addr = A_SUPPLY4_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY5_TH_LOWER",  .addr = A_SUPPLY5_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY6_TH_LOWER",  .addr = A_SUPPLY6_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY7_TH_LOWER",  .addr = A_SUPPLY7_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY8_TH_LOWER",  .addr = A_SUPPLY8_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY9_TH_LOWER",  .addr = A_SUPPLY9_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY10_TH_LOWER",  .addr = A_SUPPLY10_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY11_TH_LOWER",  .addr = A_SUPPLY11_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY12_TH_LOWER",  .addr = A_SUPPLY12_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY13_TH_LOWER",  .addr = A_SUPPLY13_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY14_TH_LOWER",  .addr = A_SUPPLY14_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY15_TH_LOWER",  .addr = A_SUPPLY15_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY16_TH_LOWER",  .addr = A_SUPPLY16_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY17_TH_LOWER",  .addr = A_SUPPLY17_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY18_TH_LOWER",  .addr = A_SUPPLY18_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY19_TH_LOWER",  .addr = A_SUPPLY19_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY20_TH_LOWER",  .addr = A_SUPPLY20_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY21_TH_LOWER",  .addr = A_SUPPLY21_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY22_TH_LOWER",  .addr = A_SUPPLY22_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY23_TH_LOWER",  .addr = A_SUPPLY23_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY24_TH_LOWER",  .addr = A_SUPPLY24_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY25_TH_LOWER",  .addr = A_SUPPLY25_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY26_TH_LOWER",  .addr = A_SUPPLY26_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY27_TH_LOWER",  .addr = A_SUPPLY27_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY28_TH_LOWER",  .addr = A_SUPPLY28_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY29_TH_LOWER",  .addr = A_SUPPLY29_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY30_TH_LOWER",  .addr = A_SUPPLY30_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY31_TH_LOWER",  .addr = A_SUPPLY31_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY32_TH_LOWER",  .addr = A_SUPPLY32_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY33_TH_LOWER",  .addr = A_SUPPLY33_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY34_TH_LOWER",  .addr = A_SUPPLY34_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY35_TH_LOWER",  .addr = A_SUPPLY35_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY36_TH_LOWER",  .addr = A_SUPPLY36_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY37_TH_LOWER",  .addr = A_SUPPLY37_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY38_TH_LOWER",  .addr = A_SUPPLY38_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY39_TH_LOWER",  .addr = A_SUPPLY39_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY40_TH_LOWER",  .addr = A_SUPPLY40_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY41_TH_LOWER",  .addr = A_SUPPLY41_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY42_TH_LOWER",  .addr = A_SUPPLY42_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY43_TH_LOWER",  .addr = A_SUPPLY43_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY44_TH_LOWER",  .addr = A_SUPPLY44_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY45_TH_LOWER",  .addr = A_SUPPLY45_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY46_TH_LOWER",  .addr = A_SUPPLY46_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY47_TH_LOWER",  .addr = A_SUPPLY47_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY48_TH_LOWER",  .addr = A_SUPPLY48_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY49_TH_LOWER",  .addr = A_SUPPLY49_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY50_TH_LOWER",  .addr = A_SUPPLY50_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY51_TH_LOWER",  .addr = A_SUPPLY51_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY52_TH_LOWER",  .addr = A_SUPPLY52_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY53_TH_LOWER",  .addr = A_SUPPLY53_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY54_TH_LOWER",  .addr = A_SUPPLY54_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY55_TH_LOWER",  .addr = A_SUPPLY55_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY56_TH_LOWER",  .addr = A_SUPPLY56_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY57_TH_LOWER",  .addr = A_SUPPLY57_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY58_TH_LOWER",  .addr = A_SUPPLY58_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY59_TH_LOWER",  .addr = A_SUPPLY59_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY60_TH_LOWER",  .addr = A_SUPPLY60_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY61_TH_LOWER",  .addr = A_SUPPLY61_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY62_TH_LOWER",  .addr = A_SUPPLY62_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY63_TH_LOWER",  .addr = A_SUPPLY63_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY64_TH_LOWER",  .addr = A_SUPPLY64_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY65_TH_LOWER",  .addr = A_SUPPLY65_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY66_TH_LOWER",  .addr = A_SUPPLY66_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY67_TH_LOWER",  .addr = A_SUPPLY67_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY68_TH_LOWER",  .addr = A_SUPPLY68_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY69_TH_LOWER",  .addr = A_SUPPLY69_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY70_TH_LOWER",  .addr = A_SUPPLY70_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY71_TH_LOWER",  .addr = A_SUPPLY71_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY72_TH_LOWER",  .addr = A_SUPPLY72_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY73_TH_LOWER",  .addr = A_SUPPLY73_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY74_TH_LOWER",  .addr = A_SUPPLY74_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY75_TH_LOWER",  .addr = A_SUPPLY75_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY76_TH_LOWER",  .addr = A_SUPPLY76_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY77_TH_LOWER",  .addr = A_SUPPLY77_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY78_TH_LOWER",  .addr = A_SUPPLY78_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY79_TH_LOWER",  .addr = A_SUPPLY79_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY80_TH_LOWER",  .addr = A_SUPPLY80_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY81_TH_LOWER",  .addr = A_SUPPLY81_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY82_TH_LOWER",  .addr = A_SUPPLY82_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY83_TH_LOWER",  .addr = A_SUPPLY83_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY84_TH_LOWER",  .addr = A_SUPPLY84_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY85_TH_LOWER",  .addr = A_SUPPLY85_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY86_TH_LOWER",  .addr = A_SUPPLY86_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY87_TH_LOWER",  .addr = A_SUPPLY87_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY88_TH_LOWER",  .addr = A_SUPPLY88_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY89_TH_LOWER",  .addr = A_SUPPLY89_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY90_TH_LOWER",  .addr = A_SUPPLY90_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY91_TH_LOWER",  .addr = A_SUPPLY91_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY92_TH_LOWER",  .addr = A_SUPPLY92_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY93_TH_LOWER",  .addr = A_SUPPLY93_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY94_TH_LOWER",  .addr = A_SUPPLY94_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY95_TH_LOWER",  .addr = A_SUPPLY95_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY96_TH_LOWER",  .addr = A_SUPPLY96_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY97_TH_LOWER",  .addr = A_SUPPLY97_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY98_TH_LOWER",  .addr = A_SUPPLY98_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY99_TH_LOWER",  .addr = A_SUPPLY99_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY100_TH_LOWER",  .addr = A_SUPPLY100_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY101_TH_LOWER",  .addr = A_SUPPLY101_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY102_TH_LOWER",  .addr = A_SUPPLY102_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY103_TH_LOWER",  .addr = A_SUPPLY103_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY104_TH_LOWER",  .addr = A_SUPPLY104_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY105_TH_LOWER",  .addr = A_SUPPLY105_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY106_TH_LOWER",  .addr = A_SUPPLY106_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY107_TH_LOWER",  .addr = A_SUPPLY107_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY108_TH_LOWER",  .addr = A_SUPPLY108_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY109_TH_LOWER",  .addr = A_SUPPLY109_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY110_TH_LOWER",  .addr = A_SUPPLY110_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY111_TH_LOWER",  .addr = A_SUPPLY111_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY112_TH_LOWER",  .addr = A_SUPPLY112_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY113_TH_LOWER",  .addr = A_SUPPLY113_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY114_TH_LOWER",  .addr = A_SUPPLY114_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY115_TH_LOWER",  .addr = A_SUPPLY115_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY116_TH_LOWER",  .addr = A_SUPPLY116_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY117_TH_LOWER",  .addr = A_SUPPLY117_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY118_TH_LOWER",  .addr = A_SUPPLY118_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY119_TH_LOWER",  .addr = A_SUPPLY119_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY120_TH_LOWER",  .addr = A_SUPPLY120_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY121_TH_LOWER",  .addr = A_SUPPLY121_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY122_TH_LOWER",  .addr = A_SUPPLY122_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY123_TH_LOWER",  .addr = A_SUPPLY123_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY124_TH_LOWER",  .addr = A_SUPPLY124_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY125_TH_LOWER",  .addr = A_SUPPLY125_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY126_TH_LOWER",  .addr = A_SUPPLY126_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY127_TH_LOWER",  .addr = A_SUPPLY127_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY128_TH_LOWER",  .addr = A_SUPPLY128_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY129_TH_LOWER",  .addr = A_SUPPLY129_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY130_TH_LOWER",  .addr = A_SUPPLY130_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY131_TH_LOWER",  .addr = A_SUPPLY131_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY132_TH_LOWER",  .addr = A_SUPPLY132_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY133_TH_LOWER",  .addr = A_SUPPLY133_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY134_TH_LOWER",  .addr = A_SUPPLY134_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY135_TH_LOWER",  .addr = A_SUPPLY135_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY136_TH_LOWER",  .addr = A_SUPPLY136_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY137_TH_LOWER",  .addr = A_SUPPLY137_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY138_TH_LOWER",  .addr = A_SUPPLY138_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY139_TH_LOWER",  .addr = A_SUPPLY139_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY140_TH_LOWER",  .addr = A_SUPPLY140_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY141_TH_LOWER",  .addr = A_SUPPLY141_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY142_TH_LOWER",  .addr = A_SUPPLY142_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY143_TH_LOWER",  .addr = A_SUPPLY143_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY144_TH_LOWER",  .addr = A_SUPPLY144_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY145_TH_LOWER",  .addr = A_SUPPLY145_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY146_TH_LOWER",  .addr = A_SUPPLY146_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY147_TH_LOWER",  .addr = A_SUPPLY147_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY148_TH_LOWER",  .addr = A_SUPPLY148_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY149_TH_LOWER",  .addr = A_SUPPLY149_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY150_TH_LOWER",  .addr = A_SUPPLY150_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY151_TH_LOWER",  .addr = A_SUPPLY151_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY152_TH_LOWER",  .addr = A_SUPPLY152_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY153_TH_LOWER",  .addr = A_SUPPLY153_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY154_TH_LOWER",  .addr = A_SUPPLY154_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY155_TH_LOWER",  .addr = A_SUPPLY155_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY156_TH_LOWER",  .addr = A_SUPPLY156_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY157_TH_LOWER",  .addr = A_SUPPLY157_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY158_TH_LOWER",  .addr = A_SUPPLY158_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY159_TH_LOWER",  .addr = A_SUPPLY159_TH_LOWER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY0_TH_UPPER",  .addr = A_SUPPLY0_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY1_TH_UPPER",  .addr = A_SUPPLY1_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY2_TH_UPPER",  .addr = A_SUPPLY2_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY3_TH_UPPER",  .addr = A_SUPPLY3_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY4_TH_UPPER",  .addr = A_SUPPLY4_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY5_TH_UPPER",  .addr = A_SUPPLY5_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY6_TH_UPPER",  .addr = A_SUPPLY6_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY7_TH_UPPER",  .addr = A_SUPPLY7_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY8_TH_UPPER",  .addr = A_SUPPLY8_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY9_TH_UPPER",  .addr = A_SUPPLY9_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY10_TH_UPPER",  .addr = A_SUPPLY10_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY11_TH_UPPER",  .addr = A_SUPPLY11_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY12_TH_UPPER",  .addr = A_SUPPLY12_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY13_TH_UPPER",  .addr = A_SUPPLY13_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY14_TH_UPPER",  .addr = A_SUPPLY14_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY15_TH_UPPER",  .addr = A_SUPPLY15_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY16_TH_UPPER",  .addr = A_SUPPLY16_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY17_TH_UPPER",  .addr = A_SUPPLY17_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY18_TH_UPPER",  .addr = A_SUPPLY18_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY19_TH_UPPER",  .addr = A_SUPPLY19_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY20_TH_UPPER",  .addr = A_SUPPLY20_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY21_TH_UPPER",  .addr = A_SUPPLY21_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY22_TH_UPPER",  .addr = A_SUPPLY22_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY23_TH_UPPER",  .addr = A_SUPPLY23_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY24_TH_UPPER",  .addr = A_SUPPLY24_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY25_TH_UPPER",  .addr = A_SUPPLY25_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY26_TH_UPPER",  .addr = A_SUPPLY26_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY27_TH_UPPER",  .addr = A_SUPPLY27_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY28_TH_UPPER",  .addr = A_SUPPLY28_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY29_TH_UPPER",  .addr = A_SUPPLY29_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY30_TH_UPPER",  .addr = A_SUPPLY30_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY31_TH_UPPER",  .addr = A_SUPPLY31_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY32_TH_UPPER",  .addr = A_SUPPLY32_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY33_TH_UPPER",  .addr = A_SUPPLY33_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY34_TH_UPPER",  .addr = A_SUPPLY34_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY35_TH_UPPER",  .addr = A_SUPPLY35_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY36_TH_UPPER",  .addr = A_SUPPLY36_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY37_TH_UPPER",  .addr = A_SUPPLY37_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY38_TH_UPPER",  .addr = A_SUPPLY38_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY39_TH_UPPER",  .addr = A_SUPPLY39_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY40_TH_UPPER",  .addr = A_SUPPLY40_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY41_TH_UPPER",  .addr = A_SUPPLY41_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY42_TH_UPPER",  .addr = A_SUPPLY42_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY43_TH_UPPER",  .addr = A_SUPPLY43_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY44_TH_UPPER",  .addr = A_SUPPLY44_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY45_TH_UPPER",  .addr = A_SUPPLY45_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY46_TH_UPPER",  .addr = A_SUPPLY46_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY47_TH_UPPER",  .addr = A_SUPPLY47_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY48_TH_UPPER",  .addr = A_SUPPLY48_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY49_TH_UPPER",  .addr = A_SUPPLY49_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY50_TH_UPPER",  .addr = A_SUPPLY50_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY51_TH_UPPER",  .addr = A_SUPPLY51_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY52_TH_UPPER",  .addr = A_SUPPLY52_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY53_TH_UPPER",  .addr = A_SUPPLY53_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY54_TH_UPPER",  .addr = A_SUPPLY54_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY55_TH_UPPER",  .addr = A_SUPPLY55_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY56_TH_UPPER",  .addr = A_SUPPLY56_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY57_TH_UPPER",  .addr = A_SUPPLY57_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY58_TH_UPPER",  .addr = A_SUPPLY58_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY59_TH_UPPER",  .addr = A_SUPPLY59_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY60_TH_UPPER",  .addr = A_SUPPLY60_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY61_TH_UPPER",  .addr = A_SUPPLY61_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY62_TH_UPPER",  .addr = A_SUPPLY62_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY63_TH_UPPER",  .addr = A_SUPPLY63_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY64_TH_UPPER",  .addr = A_SUPPLY64_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY65_TH_UPPER",  .addr = A_SUPPLY65_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY66_TH_UPPER",  .addr = A_SUPPLY66_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY67_TH_UPPER",  .addr = A_SUPPLY67_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY68_TH_UPPER",  .addr = A_SUPPLY68_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY69_TH_UPPER",  .addr = A_SUPPLY69_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY70_TH_UPPER",  .addr = A_SUPPLY70_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY71_TH_UPPER",  .addr = A_SUPPLY71_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY72_TH_UPPER",  .addr = A_SUPPLY72_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY73_TH_UPPER",  .addr = A_SUPPLY73_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY74_TH_UPPER",  .addr = A_SUPPLY74_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY75_TH_UPPER",  .addr = A_SUPPLY75_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY76_TH_UPPER",  .addr = A_SUPPLY76_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY77_TH_UPPER",  .addr = A_SUPPLY77_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY78_TH_UPPER",  .addr = A_SUPPLY78_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY79_TH_UPPER",  .addr = A_SUPPLY79_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY80_TH_UPPER",  .addr = A_SUPPLY80_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY81_TH_UPPER",  .addr = A_SUPPLY81_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY82_TH_UPPER",  .addr = A_SUPPLY82_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY83_TH_UPPER",  .addr = A_SUPPLY83_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY84_TH_UPPER",  .addr = A_SUPPLY84_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY85_TH_UPPER",  .addr = A_SUPPLY85_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY86_TH_UPPER",  .addr = A_SUPPLY86_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY87_TH_UPPER",  .addr = A_SUPPLY87_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY88_TH_UPPER",  .addr = A_SUPPLY88_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY89_TH_UPPER",  .addr = A_SUPPLY89_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY90_TH_UPPER",  .addr = A_SUPPLY90_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY91_TH_UPPER",  .addr = A_SUPPLY91_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY92_TH_UPPER",  .addr = A_SUPPLY92_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY93_TH_UPPER",  .addr = A_SUPPLY93_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY94_TH_UPPER",  .addr = A_SUPPLY94_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY95_TH_UPPER",  .addr = A_SUPPLY95_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY96_TH_UPPER",  .addr = A_SUPPLY96_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY97_TH_UPPER",  .addr = A_SUPPLY97_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY98_TH_UPPER",  .addr = A_SUPPLY98_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY99_TH_UPPER",  .addr = A_SUPPLY99_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY100_TH_UPPER",  .addr = A_SUPPLY100_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY101_TH_UPPER",  .addr = A_SUPPLY101_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY102_TH_UPPER",  .addr = A_SUPPLY102_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY103_TH_UPPER",  .addr = A_SUPPLY103_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY104_TH_UPPER",  .addr = A_SUPPLY104_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY105_TH_UPPER",  .addr = A_SUPPLY105_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY106_TH_UPPER",  .addr = A_SUPPLY106_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY107_TH_UPPER",  .addr = A_SUPPLY107_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY108_TH_UPPER",  .addr = A_SUPPLY108_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY109_TH_UPPER",  .addr = A_SUPPLY109_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY110_TH_UPPER",  .addr = A_SUPPLY110_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY111_TH_UPPER",  .addr = A_SUPPLY111_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY112_TH_UPPER",  .addr = A_SUPPLY112_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY113_TH_UPPER",  .addr = A_SUPPLY113_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY114_TH_UPPER",  .addr = A_SUPPLY114_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY115_TH_UPPER",  .addr = A_SUPPLY115_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY116_TH_UPPER",  .addr = A_SUPPLY116_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY117_TH_UPPER",  .addr = A_SUPPLY117_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY118_TH_UPPER",  .addr = A_SUPPLY118_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY119_TH_UPPER",  .addr = A_SUPPLY119_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY120_TH_UPPER",  .addr = A_SUPPLY120_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY121_TH_UPPER",  .addr = A_SUPPLY121_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY122_TH_UPPER",  .addr = A_SUPPLY122_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY123_TH_UPPER",  .addr = A_SUPPLY123_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY124_TH_UPPER",  .addr = A_SUPPLY124_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY125_TH_UPPER",  .addr = A_SUPPLY125_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY126_TH_UPPER",  .addr = A_SUPPLY126_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY127_TH_UPPER",  .addr = A_SUPPLY127_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY128_TH_UPPER",  .addr = A_SUPPLY128_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY129_TH_UPPER",  .addr = A_SUPPLY129_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY130_TH_UPPER",  .addr = A_SUPPLY130_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY131_TH_UPPER",  .addr = A_SUPPLY131_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY132_TH_UPPER",  .addr = A_SUPPLY132_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY133_TH_UPPER",  .addr = A_SUPPLY133_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY134_TH_UPPER",  .addr = A_SUPPLY134_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY135_TH_UPPER",  .addr = A_SUPPLY135_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY136_TH_UPPER",  .addr = A_SUPPLY136_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY137_TH_UPPER",  .addr = A_SUPPLY137_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY138_TH_UPPER",  .addr = A_SUPPLY138_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY139_TH_UPPER",  .addr = A_SUPPLY139_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY140_TH_UPPER",  .addr = A_SUPPLY140_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY141_TH_UPPER",  .addr = A_SUPPLY141_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY142_TH_UPPER",  .addr = A_SUPPLY142_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY143_TH_UPPER",  .addr = A_SUPPLY143_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY144_TH_UPPER",  .addr = A_SUPPLY144_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY145_TH_UPPER",  .addr = A_SUPPLY145_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY146_TH_UPPER",  .addr = A_SUPPLY146_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY147_TH_UPPER",  .addr = A_SUPPLY147_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY148_TH_UPPER",  .addr = A_SUPPLY148_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY149_TH_UPPER",  .addr = A_SUPPLY149_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY150_TH_UPPER",  .addr = A_SUPPLY150_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY151_TH_UPPER",  .addr = A_SUPPLY151_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY152_TH_UPPER",  .addr = A_SUPPLY152_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY153_TH_UPPER",  .addr = A_SUPPLY153_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY154_TH_UPPER",  .addr = A_SUPPLY154_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY155_TH_UPPER",  .addr = A_SUPPLY155_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY156_TH_UPPER",  .addr = A_SUPPLY156_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY157_TH_UPPER",  .addr = A_SUPPLY157_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY158_TH_UPPER",  .addr = A_SUPPLY158_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "SUPPLY159_TH_UPPER",  .addr = A_SUPPLY159_TH_UPPER,
        .rsvd = 0xfff80000,
        .ro = 0x70000,
    },{ .name = "NEW_DATA_INT_SRC",  .addr = A_NEW_DATA_INT_SRC,
    },{ .name = "ALARM_CONFIG",  .addr = A_ALARM_CONFIG,
        .rsvd = 0xfffffffc,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_temp_alarm_config_postw,
    },{ .name = "I2C_STATUS",  .addr = A_I2C_STATUS,
        .ro = 0x3,
    },{ .name = "DEVICE_TEMP_MIN_MIN",  .addr = A_DEVICE_TEMP_MIN_MIN,
        .reset = 0x7fff,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
        .post_read = pmc_sysmon_temp_min_min_postr,
    },{ .name = "DEVICE_TEMP_MAX_MAX",  .addr = A_DEVICE_TEMP_MAX_MAX,
        .reset = 0x8000,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "STATUS_RESET",  .addr = A_STATUS_RESET,
        .rsvd = 0xfffffffc,
        .post_write = pmc_sysmon_status_reset_postw,
    },{ .name = "GREF_STATUS",  .addr = A_GREF_STATUS,
        .rsvd = 0xffffffe0,
        .ro = 0x1f,
    },{ .name = "AXI_CONFIG",  .addr = A_AXI_CONFIG,
        .reset = 0x40,
        .rsvd = 0xfe000000,
    },{ .name = "CLOCK_GATE_OR",  .addr = A_CLOCK_GATE_OR,
        .rsvd = 0xfffff800,
    },{ .name = "VCCINT_FPD",  .addr = A_VCCINT_FPD,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_LPD",  .addr = A_VCCINT_LPD,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "TEMP_SAT1",  .addr = A_TEMP_SAT1,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT2",  .addr = A_TEMP_SAT2,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT3",  .addr = A_TEMP_SAT3,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT4",  .addr = A_TEMP_SAT4,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT5",  .addr = A_TEMP_SAT5,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT6",  .addr = A_TEMP_SAT6,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT7",  .addr = A_TEMP_SAT7,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT8",  .addr = A_TEMP_SAT8,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT9",  .addr = A_TEMP_SAT9,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT10",  .addr = A_TEMP_SAT10,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT11",  .addr = A_TEMP_SAT11,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT12",  .addr = A_TEMP_SAT12,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT13",  .addr = A_TEMP_SAT13,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT14",  .addr = A_TEMP_SAT14,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT15",  .addr = A_TEMP_SAT15,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT16",  .addr = A_TEMP_SAT16,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT17",  .addr = A_TEMP_SAT17,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT18",  .addr = A_TEMP_SAT18,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT19",  .addr = A_TEMP_SAT19,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT20",  .addr = A_TEMP_SAT20,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT21",  .addr = A_TEMP_SAT21,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT22",  .addr = A_TEMP_SAT22,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT23",  .addr = A_TEMP_SAT23,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT24",  .addr = A_TEMP_SAT24,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT25",  .addr = A_TEMP_SAT25,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT26",  .addr = A_TEMP_SAT26,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT27",  .addr = A_TEMP_SAT27,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT28",  .addr = A_TEMP_SAT28,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT29",  .addr = A_TEMP_SAT29,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT30",  .addr = A_TEMP_SAT30,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT31",  .addr = A_TEMP_SAT31,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT32",  .addr = A_TEMP_SAT32,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT33",  .addr = A_TEMP_SAT33,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT34",  .addr = A_TEMP_SAT34,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT35",  .addr = A_TEMP_SAT35,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT36",  .addr = A_TEMP_SAT36,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT37",  .addr = A_TEMP_SAT37,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT38",  .addr = A_TEMP_SAT38,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT39",  .addr = A_TEMP_SAT39,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT40",  .addr = A_TEMP_SAT40,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT41",  .addr = A_TEMP_SAT41,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT42",  .addr = A_TEMP_SAT42,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT43",  .addr = A_TEMP_SAT43,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT44",  .addr = A_TEMP_SAT44,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT45",  .addr = A_TEMP_SAT45,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT46",  .addr = A_TEMP_SAT46,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT47",  .addr = A_TEMP_SAT47,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT48",  .addr = A_TEMP_SAT48,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT49",  .addr = A_TEMP_SAT49,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT50",  .addr = A_TEMP_SAT50,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT51",  .addr = A_TEMP_SAT51,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT52",  .addr = A_TEMP_SAT52,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT53",  .addr = A_TEMP_SAT53,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT54",  .addr = A_TEMP_SAT54,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT55",  .addr = A_TEMP_SAT55,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT56",  .addr = A_TEMP_SAT56,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT57",  .addr = A_TEMP_SAT57,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT58",  .addr = A_TEMP_SAT58,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT59",  .addr = A_TEMP_SAT59,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT60",  .addr = A_TEMP_SAT60,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT61",  .addr = A_TEMP_SAT61,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "TEMP_SAT62",  .addr = A_TEMP_SAT62,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "VCCINT_SAT1",  .addr = A_VCCINT_SAT1,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT2",  .addr = A_VCCINT_SAT2,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT3",  .addr = A_VCCINT_SAT3,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT4",  .addr = A_VCCINT_SAT4,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT5",  .addr = A_VCCINT_SAT5,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT6",  .addr = A_VCCINT_SAT6,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT7",  .addr = A_VCCINT_SAT7,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT8",  .addr = A_VCCINT_SAT8,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT9",  .addr = A_VCCINT_SAT9,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT10",  .addr = A_VCCINT_SAT10,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT11",  .addr = A_VCCINT_SAT11,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT12",  .addr = A_VCCINT_SAT12,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT13",  .addr = A_VCCINT_SAT13,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT14",  .addr = A_VCCINT_SAT14,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT15",  .addr = A_VCCINT_SAT15,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT16",  .addr = A_VCCINT_SAT16,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT17",  .addr = A_VCCINT_SAT17,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT18",  .addr = A_VCCINT_SAT18,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT19",  .addr = A_VCCINT_SAT19,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT20",  .addr = A_VCCINT_SAT20,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT21",  .addr = A_VCCINT_SAT21,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT22",  .addr = A_VCCINT_SAT22,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT23",  .addr = A_VCCINT_SAT23,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT24",  .addr = A_VCCINT_SAT24,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT25",  .addr = A_VCCINT_SAT25,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT26",  .addr = A_VCCINT_SAT26,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT27",  .addr = A_VCCINT_SAT27,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT28",  .addr = A_VCCINT_SAT28,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT29",  .addr = A_VCCINT_SAT29,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT30",  .addr = A_VCCINT_SAT30,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT31",  .addr = A_VCCINT_SAT31,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT32",  .addr = A_VCCINT_SAT32,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT33",  .addr = A_VCCINT_SAT33,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT34",  .addr = A_VCCINT_SAT34,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT35",  .addr = A_VCCINT_SAT35,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT36",  .addr = A_VCCINT_SAT36,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT37",  .addr = A_VCCINT_SAT37,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT38",  .addr = A_VCCINT_SAT38,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT39",  .addr = A_VCCINT_SAT39,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT40",  .addr = A_VCCINT_SAT40,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT41",  .addr = A_VCCINT_SAT41,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT42",  .addr = A_VCCINT_SAT42,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT43",  .addr = A_VCCINT_SAT43,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT44",  .addr = A_VCCINT_SAT44,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT45",  .addr = A_VCCINT_SAT45,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT46",  .addr = A_VCCINT_SAT46,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT47",  .addr = A_VCCINT_SAT47,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT48",  .addr = A_VCCINT_SAT48,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT49",  .addr = A_VCCINT_SAT49,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT50",  .addr = A_VCCINT_SAT50,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT51",  .addr = A_VCCINT_SAT51,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT52",  .addr = A_VCCINT_SAT52,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT53",  .addr = A_VCCINT_SAT53,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT54",  .addr = A_VCCINT_SAT54,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT55",  .addr = A_VCCINT_SAT55,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT56",  .addr = A_VCCINT_SAT56,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT57",  .addr = A_VCCINT_SAT57,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT58",  .addr = A_VCCINT_SAT58,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT59",  .addr = A_VCCINT_SAT59,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT60",  .addr = A_VCCINT_SAT60,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT61",  .addr = A_VCCINT_SAT61,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "VCCINT_SAT62",  .addr = A_VCCINT_SAT62,
        .rsvd = 0xfff80000,
        .ro = 0x7ffff,
    },{ .name = "SUPPLY0_AVGCALC",  .addr = A_SUPPLY0_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY1_AVGCALC",  .addr = A_SUPPLY1_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY2_AVGCALC",  .addr = A_SUPPLY2_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY3_AVGCALC",  .addr = A_SUPPLY3_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY4_AVGCALC",  .addr = A_SUPPLY4_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY5_AVGCALC",  .addr = A_SUPPLY5_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY6_AVGCALC",  .addr = A_SUPPLY6_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY7_AVGCALC",  .addr = A_SUPPLY7_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY8_AVGCALC",  .addr = A_SUPPLY8_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY9_AVGCALC",  .addr = A_SUPPLY9_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY10_AVGCALC",  .addr = A_SUPPLY10_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY11_AVGCALC",  .addr = A_SUPPLY11_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY12_AVGCALC",  .addr = A_SUPPLY12_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY13_AVGCALC",  .addr = A_SUPPLY13_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY14_AVGCALC",  .addr = A_SUPPLY14_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY15_AVGCALC",  .addr = A_SUPPLY15_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY16_AVGCALC",  .addr = A_SUPPLY16_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY17_AVGCALC",  .addr = A_SUPPLY17_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY18_AVGCALC",  .addr = A_SUPPLY18_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY19_AVGCALC",  .addr = A_SUPPLY19_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY20_AVGCALC",  .addr = A_SUPPLY20_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY21_AVGCALC",  .addr = A_SUPPLY21_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY22_AVGCALC",  .addr = A_SUPPLY22_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY23_AVGCALC",  .addr = A_SUPPLY23_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY24_AVGCALC",  .addr = A_SUPPLY24_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY25_AVGCALC",  .addr = A_SUPPLY25_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY26_AVGCALC",  .addr = A_SUPPLY26_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY27_AVGCALC",  .addr = A_SUPPLY27_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY28_AVGCALC",  .addr = A_SUPPLY28_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY29_AVGCALC",  .addr = A_SUPPLY29_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY30_AVGCALC",  .addr = A_SUPPLY30_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY31_AVGCALC",  .addr = A_SUPPLY31_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY32_AVGCALC",  .addr = A_SUPPLY32_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY33_AVGCALC",  .addr = A_SUPPLY33_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY34_AVGCALC",  .addr = A_SUPPLY34_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY35_AVGCALC",  .addr = A_SUPPLY35_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY36_AVGCALC",  .addr = A_SUPPLY36_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY37_AVGCALC",  .addr = A_SUPPLY37_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY38_AVGCALC",  .addr = A_SUPPLY38_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY39_AVGCALC",  .addr = A_SUPPLY39_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY40_AVGCALC",  .addr = A_SUPPLY40_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY41_AVGCALC",  .addr = A_SUPPLY41_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY42_AVGCALC",  .addr = A_SUPPLY42_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY43_AVGCALC",  .addr = A_SUPPLY43_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY44_AVGCALC",  .addr = A_SUPPLY44_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY45_AVGCALC",  .addr = A_SUPPLY45_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY46_AVGCALC",  .addr = A_SUPPLY46_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY47_AVGCALC",  .addr = A_SUPPLY47_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY48_AVGCALC",  .addr = A_SUPPLY48_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY49_AVGCALC",  .addr = A_SUPPLY49_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY50_AVGCALC",  .addr = A_SUPPLY50_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY51_AVGCALC",  .addr = A_SUPPLY51_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY52_AVGCALC",  .addr = A_SUPPLY52_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY53_AVGCALC",  .addr = A_SUPPLY53_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY54_AVGCALC",  .addr = A_SUPPLY54_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY55_AVGCALC",  .addr = A_SUPPLY55_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY56_AVGCALC",  .addr = A_SUPPLY56_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY57_AVGCALC",  .addr = A_SUPPLY57_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY58_AVGCALC",  .addr = A_SUPPLY58_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY59_AVGCALC",  .addr = A_SUPPLY59_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY60_AVGCALC",  .addr = A_SUPPLY60_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY61_AVGCALC",  .addr = A_SUPPLY61_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY62_AVGCALC",  .addr = A_SUPPLY62_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY63_AVGCALC",  .addr = A_SUPPLY63_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY64_AVGCALC",  .addr = A_SUPPLY64_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY65_AVGCALC",  .addr = A_SUPPLY65_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY66_AVGCALC",  .addr = A_SUPPLY66_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY67_AVGCALC",  .addr = A_SUPPLY67_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY68_AVGCALC",  .addr = A_SUPPLY68_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY69_AVGCALC",  .addr = A_SUPPLY69_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY70_AVGCALC",  .addr = A_SUPPLY70_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY71_AVGCALC",  .addr = A_SUPPLY71_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY72_AVGCALC",  .addr = A_SUPPLY72_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY73_AVGCALC",  .addr = A_SUPPLY73_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY74_AVGCALC",  .addr = A_SUPPLY74_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY75_AVGCALC",  .addr = A_SUPPLY75_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY76_AVGCALC",  .addr = A_SUPPLY76_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY77_AVGCALC",  .addr = A_SUPPLY77_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY78_AVGCALC",  .addr = A_SUPPLY78_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY79_AVGCALC",  .addr = A_SUPPLY79_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY80_AVGCALC",  .addr = A_SUPPLY80_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY81_AVGCALC",  .addr = A_SUPPLY81_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY82_AVGCALC",  .addr = A_SUPPLY82_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY83_AVGCALC",  .addr = A_SUPPLY83_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY84_AVGCALC",  .addr = A_SUPPLY84_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY85_AVGCALC",  .addr = A_SUPPLY85_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY86_AVGCALC",  .addr = A_SUPPLY86_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY87_AVGCALC",  .addr = A_SUPPLY87_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY88_AVGCALC",  .addr = A_SUPPLY88_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY89_AVGCALC",  .addr = A_SUPPLY89_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY90_AVGCALC",  .addr = A_SUPPLY90_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY91_AVGCALC",  .addr = A_SUPPLY91_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY92_AVGCALC",  .addr = A_SUPPLY92_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY93_AVGCALC",  .addr = A_SUPPLY93_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY94_AVGCALC",  .addr = A_SUPPLY94_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY95_AVGCALC",  .addr = A_SUPPLY95_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY96_AVGCALC",  .addr = A_SUPPLY96_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY97_AVGCALC",  .addr = A_SUPPLY97_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY98_AVGCALC",  .addr = A_SUPPLY98_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY99_AVGCALC",  .addr = A_SUPPLY99_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY100_AVGCALC",  .addr = A_SUPPLY100_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY101_AVGCALC",  .addr = A_SUPPLY101_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY102_AVGCALC",  .addr = A_SUPPLY102_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY103_AVGCALC",  .addr = A_SUPPLY103_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY104_AVGCALC",  .addr = A_SUPPLY104_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY105_AVGCALC",  .addr = A_SUPPLY105_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY106_AVGCALC",  .addr = A_SUPPLY106_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY107_AVGCALC",  .addr = A_SUPPLY107_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY108_AVGCALC",  .addr = A_SUPPLY108_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY109_AVGCALC",  .addr = A_SUPPLY109_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY110_AVGCALC",  .addr = A_SUPPLY110_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY111_AVGCALC",  .addr = A_SUPPLY111_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY112_AVGCALC",  .addr = A_SUPPLY112_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY113_AVGCALC",  .addr = A_SUPPLY113_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY114_AVGCALC",  .addr = A_SUPPLY114_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY115_AVGCALC",  .addr = A_SUPPLY115_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY116_AVGCALC",  .addr = A_SUPPLY116_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY117_AVGCALC",  .addr = A_SUPPLY117_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY118_AVGCALC",  .addr = A_SUPPLY118_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY119_AVGCALC",  .addr = A_SUPPLY119_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY120_AVGCALC",  .addr = A_SUPPLY120_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY121_AVGCALC",  .addr = A_SUPPLY121_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY122_AVGCALC",  .addr = A_SUPPLY122_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY123_AVGCALC",  .addr = A_SUPPLY123_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY124_AVGCALC",  .addr = A_SUPPLY124_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY125_AVGCALC",  .addr = A_SUPPLY125_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY126_AVGCALC",  .addr = A_SUPPLY126_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY127_AVGCALC",  .addr = A_SUPPLY127_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY128_AVGCALC",  .addr = A_SUPPLY128_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY129_AVGCALC",  .addr = A_SUPPLY129_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY130_AVGCALC",  .addr = A_SUPPLY130_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY131_AVGCALC",  .addr = A_SUPPLY131_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY132_AVGCALC",  .addr = A_SUPPLY132_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY133_AVGCALC",  .addr = A_SUPPLY133_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY134_AVGCALC",  .addr = A_SUPPLY134_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY135_AVGCALC",  .addr = A_SUPPLY135_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY136_AVGCALC",  .addr = A_SUPPLY136_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY137_AVGCALC",  .addr = A_SUPPLY137_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY138_AVGCALC",  .addr = A_SUPPLY138_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY139_AVGCALC",  .addr = A_SUPPLY139_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY140_AVGCALC",  .addr = A_SUPPLY140_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY141_AVGCALC",  .addr = A_SUPPLY141_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY142_AVGCALC",  .addr = A_SUPPLY142_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY143_AVGCALC",  .addr = A_SUPPLY143_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY144_AVGCALC",  .addr = A_SUPPLY144_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY145_AVGCALC",  .addr = A_SUPPLY145_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY146_AVGCALC",  .addr = A_SUPPLY146_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY147_AVGCALC",  .addr = A_SUPPLY147_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY148_AVGCALC",  .addr = A_SUPPLY148_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY149_AVGCALC",  .addr = A_SUPPLY149_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY150_AVGCALC",  .addr = A_SUPPLY150_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY151_AVGCALC",  .addr = A_SUPPLY151_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY152_AVGCALC",  .addr = A_SUPPLY152_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY153_AVGCALC",  .addr = A_SUPPLY153_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY154_AVGCALC",  .addr = A_SUPPLY154_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY155_AVGCALC",  .addr = A_SUPPLY155_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY156_AVGCALC",  .addr = A_SUPPLY156_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY157_AVGCALC",  .addr = A_SUPPLY157_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY158_AVGCALC",  .addr = A_SUPPLY158_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SUPPLY159_AVGCALC",  .addr = A_SUPPLY159_AVGCALC,
        .rsvd = 0xfe000000,
        .ro = 0x1ffffff,
    },{ .name = "SLICE_TEMP_MAX1",  .addr = A_SLICE_TEMP_MAX1,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "SLICE_TEMP_MAX2",  .addr = A_SLICE_TEMP_MAX2,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "SLICE_TEMP_MAX3",  .addr = A_SLICE_TEMP_MAX3,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "SLICE_TEMP_MIN1",  .addr = A_SLICE_TEMP_MIN1,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "SLICE_TEMP_MIN2",  .addr = A_SLICE_TEMP_MIN2,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "SLICE_TEMP_MIN3",  .addr = A_SLICE_TEMP_MIN3,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "EN_AVG_REG8",  .addr = A_EN_AVG_REG8,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_temp_en_avg_reg_postw,
    },{ .name = "EN_AVG_REG9",  .addr = A_EN_AVG_REG9,
        .pre_write = pmc_sysmon_save_prev_value_prew,
        .post_write = pmc_sysmon_temp_en_avg_reg_postw,
    },{ .name = "SECURE_EFUSE_RDATA_LOW",  .addr = A_SECURE_EFUSE_RDATA_LOW,
        .ro = 0xffffffff,
    },{ .name = "SECURE_EFUSE_RDATA_HIGH",  .addr = A_SECURE_EFUSE_RDATA_HIGH,
        .ro = 0xffffffff,
    },{ .name = "AXI_STATUS",  .addr = A_AXI_STATUS,
        .rsvd = 0xffffff00,
        .ro = 0xff,
    },{ .name = "AXI_PACKETS0",  .addr = A_AXI_PACKETS0,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "AXI_PACKETS1",  .addr = A_AXI_PACKETS1,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "AXI_PACKETS2",  .addr = A_AXI_PACKETS2,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "MEAS_PACKETS0",  .addr = A_MEAS_PACKETS0,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "MEAS_PACKETS1",  .addr = A_MEAS_PACKETS1,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "MEAS_PACKETS2",  .addr = A_MEAS_PACKETS2,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "MEAS_PACKETS3",  .addr = A_MEAS_PACKETS3,
        .rsvd = 0xfff00000,
        .ro = 0xfffff,
    },{ .name = "MEAS_PACKETS4",  .addr = A_MEAS_PACKETS4,
        .rsvd = 0xfffffc00,
        .ro = 0x3ff,
    },{ .name = "STATUS_ENABLE",  .addr = A_STATUS_ENABLE,
        .rsvd = 0xfffffffe,
        .post_write = pmc_sysmon_status_enable_postw,
    },{ .name = "SSC_MEASURE_IF",  .addr = A_SSC_MEASURE_IF,
        .rsvd = 0xe0000000,
    }
};

static void pmc_sysmon_reg_write(void *opaque, hwaddr addr, uint64_t data,
                                 unsigned size)
{
    RegisterInfoArray *reg_array = opaque;
    PMCSysMon *s = PMC_SYSMON(reg_array->r[0]->opaque);
    unsigned nr;

    /* Enforce write-lock protection */
    if ((addr == A_REG_PCSR_LOCK) && size == 4) {
        if (data == R_REG_PCSR_LOCK_UNLOCK_CODE) {
            data = 0;
        } else {
            data = R_REG_PCSR_LOCK_STATE_MASK;
        }
    } else if (ARRAY_FIELD_EX32(s->regs, REG_PCSR_LOCK, STATE)) {
        info_report("%s: addr:0x%x: PCSR_LOCK engaged! Write discarded!",
                    object_get_canonical_path(OBJECT(s)), (uint32_t)addr);
        return;
    }

    register_write_memory(opaque, addr, data, size);

    /*
     * Handle post-write action in a maintainable way for the large
     * number of registers with identical post-write behavior.
     */
    nr = addr / 4;
    switch (nr) {
    case R_SUPPLY0_TH_LOWER ... R_SUPPLY159_TH_LOWER:
        pmc_sysmon_volt_set_alarm(s, (nr - R_SUPPLY0_TH_LOWER));
        break;
    case R_SUPPLY0_TH_UPPER ... R_SUPPLY159_TH_UPPER:
        pmc_sysmon_volt_set_alarm(s, (nr - R_SUPPLY0_TH_UPPER));
        break;
    }
}

static const MemoryRegionOps pmc_sysmon_ops = {
    .read = register_read_memory,
    .write = pmc_sysmon_reg_write,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmc_sysmon_realize(DeviceState *dev, Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(dev);
    unsigned nr;

    if (!s->ams_sat || !s->ams_sat_len) {
        /* Legacy binding */
        g_free(s->ams_sat);

        s->ams_sat_len = 2;
        s->ams_sat = g_malloc0(s->ams_sat_len * sizeof(Object *));
        s->ams_sat[0] = s->ams_sat0;
        s->ams_sat[1] = s->ams_sat1;
    }

    s->ams_sat_ready = g_malloc0(CHANNEL_BCNT(s->ams_sat_len));

    for (nr = 0; nr < s->ams_sat_len; nr++) {
        if (s->ams_sat[nr]) {
            xlnx_ams_sat_instance_set(s->ams_sat[nr], nr, OBJECT(s));
        }
    }

    if (!s->tamper_sink) {
        g_autofree char *p = object_get_canonical_path(OBJECT(s));

        warn_report("%s.tamper-sink: Missing link disables "
                    "support for alarm events as tampering", p);
    }

    if (s->meas_file) {
        /* Play set by -global */
        object_property_parse(OBJECT(s), PROP_MEAS_FILE, s->meas_file, errp);
        g_free(s->meas_file);
        s->meas_file = NULL;
    }
}

static void pmc_sysmon_finalize(Object *obj)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    PMCSysMon_MeasInj *item, *next;
    size_t i;

    for (i = 0; i < ARRAY_SIZE(s->ndf_tick); i++) {
        timer_free(&s->ndf_tick[i]);
    }

    QTAILQ_FOREACH_SAFE(item, &s->meas_injections, link, next) {
        QTAILQ_REMOVE(&s->meas_injections, item, link);
        g_free(item);
    }

    g_free(s->ams_sat);
    g_free(s->ams_sat_ready);
}

static void pmc_sysmon_init(Object *obj)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;
    size_t i;

    for (i = 0; i < ARRAY_SIZE(s->ndf_tick); i++) {
        static QEMUTimerCB * const kicker[ARRAY_SIZE(s->ndf_tick)] = {
            pmc_sysmon_volt_kick_new_0,
            pmc_sysmon_volt_kick_new_1,
            pmc_sysmon_volt_kick_new_2,
            pmc_sysmon_volt_kick_new_3,
        };

        g_assert(kicker[i]);
        timer_init_ms(&s->ndf_tick[i], QEMU_CLOCK_VIRTUAL, kicker[i], s);
    }

    QTAILQ_INIT(&s->meas_injections);
    s->default_volt = 1.5;

    memory_region_init(&s->iomem, obj, TYPE_PMC_SYSMON, PMC_SYSMON_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmc_sysmon_regs_info,
                              ARRAY_SIZE(pmc_sysmon_regs_info),
                              s->regs_info, s->regs,
                              &pmc_sysmon_ops,
                              PMC_SYSMON_ERR_DEBUG,
                              PMC_SYSMON_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_0);
    sysbus_init_irq(sbd, &s->irq_1);

    timer_init_ms(&s->efuse_throttle_timer, QEMU_CLOCK_VIRTUAL,
                  pmc_sysmon_efuse_xfer_done, s);
}

static void pmc_sysmon_sat_set_ready(PMCSysMon *s, unsigned instance_id)
{
    if (instance_id >= s->ams_sat_len) {
        return;
    }
    if (!s->ams_sat[instance_id]) {
        return;
    }

    CHANNEL_BIT_SET(s->ams_sat_ready, instance_id);
}

static bool pmc_sysmon_sat_is_ready(PMCSysMon *s, unsigned instance_id)
{
    if (instance_id >= s->ams_sat_len) {
        return false;
    }

    if (!s->ams_sat[instance_id]) {
        return false;
    }

    return CHANNEL_BIT(s->ams_sat_ready, instance_id);
}

static bool pmc_sysmon_sat_cfg_by_root_id(PMCSysMon *s, xlnx_ams_sensor_t *si)
{
    unsigned nr;

    /* Non-configurable sensors are already available */
    switch (si->meas_id) {
    case XLNX_AMS_SAT_MEAS_TYPE_TSENS:
        switch (si->root_id) {
        case R_TEMP_FPD_TID:
        case R_TEMP_LPD_TID:
            si->amux_ctrl = 0;
            si->mode = 0;
            si->meas_bipolar = 1;
            return true;
        }
        break;
    case XLNX_AMS_SAT_MEAS_TYPE_VCCINT:
        switch (si->root_id) {
        case R_VCCINT_FPD_VID:
        case R_VCCINT_LPD_VID:
            si->amux_ctrl = 0;
            si->mode = 0;
            si->meas_bipolar = 0;
            return true;
        }
        break;
    }

    for (nr = 0; nr < s->ams_sat_len; nr++) {
        if (pmc_sysmon_sat_is_ready(s, nr)
            && xlnx_ams_sat_config_by_root_id(s->ams_sat[nr], si)) {
            return true;
        }
    }

    return false;
}

static bool pmc_sysmon_sat_cfg_by_spec(PMCSysMon *s, xlnx_ams_sensor_t *si)
{
    unsigned nr;

    for (nr = 0; nr < s->ams_sat_len; nr++) {
        if (pmc_sysmon_sat_is_ready(s, nr)
            && xlnx_ams_sat_config_by_spec(s->ams_sat[nr], si)) {
            return true;
        }
    }

    return false;
}

static void pmc_sysmon_set_mfp_meas(PMCSysMon *s,
                                    const xlnx_ams_sensor_t *si,
                                    float val, Error **errp)
{
    Error *e_local = NULL;
    uint32_t mfp;

    if (!errp) {
        errp = &e_local;
    }

    mfp = mfp19_from_float(val, si->meas_bipolar, errp);
    if (*errp) {
        return;
    }

    if (si->meas_id == XLNX_AMS_SAT_MEAS_TYPE_VCCINT) {
        pmc_sysmon_vccint_set(s, si->root_id, mfp);
    } else {
        pmc_sysmon_volt_set(s, si->root_id, mfp);
    }
}

static void pmc_sysmon_play_measurement(PMCSysMon *s, PMCSysMon_MeasInj *meas)
{
    xlnx_ams_sensor_t *si = &meas->info;

    /* Apply the injection then mark it as played */
    if (si->meas_id == XLNX_AMS_SAT_MEAS_TYPE_TSENS) {
        pmc_sysmon_temp_set(s, si->root_id, meas->meas_val.q8_7);
    } else {
        pmc_sysmon_set_mfp_meas(s, si, meas->meas_val.flt, NULL);
    }

    meas->played = true;
}

static void pmc_sysmon_play_injections(PMCSysMon *s, unsigned instance_id)
{
    unsigned nr, base = 0, stop = s->ams_sat_len;
    PMCSysMon_MeasInj *item;

    g_assert(pmc_sysmon_root_is_running(s));

    if (instance_id < stop) {
        if (!pmc_sysmon_sat_is_ready(s, instance_id)) {
            return;
        }

        base = instance_id;
        stop = base + 1;
    }

    QTAILQ_FOREACH(item, &s->meas_injections, link) {
        bool (*get_cfg)(Object *, xlnx_ams_sensor_t *);
        xlnx_ams_sensor_t *si = &item->info;

        if (item->played) {
            continue;  /* Skip it to avoid duplicate replay */
        }

        get_cfg = item->by_root_id ? xlnx_ams_sat_config_by_root_id
                                   : xlnx_ams_sat_config_by_spec;

        for (nr = base; nr < stop; nr++) {
            if (pmc_sysmon_sat_is_ready(s, nr) && get_cfg(s->ams_sat[nr], si)) {
                pmc_sysmon_play_measurement(s, item);
                break;
            }
        }
    }
}

static void pmc_sysmon_rewnd_injections(PMCSysMon *s)
{
    PMCSysMon_MeasInj *item;

    QTAILQ_FOREACH(item, &s->meas_injections, link) {
        item->played = false;
    }
}

static void pmc_sysmon_store_injection(PMCSysMon *s,
                                       const xlnx_ams_sensor_t *si,
                                       float val, bool by_root_id, bool played)
{
    PMCSysMon_MeasInj *item;

    /*
     * Store only injections made before SYSMON is realized, and
     * treat those injections as "initial" measurements, i.e., values
     * to be played/replayed upon a satellite's 1st activation after
     * a reset.
     *
     * On the other hand, don't store injections made after SYSMON is
     * realized, because:
     * 1/ After post-reset's 1st activation, guest software may choose
     *    to completely reconfig some or all sensors, and
     * 2/ Post-realized injections are expected to match the reconfigured
     *    sensors, and potentially mismatch to initial configs used for
     *    post-reset's 1st activation, and
     * 3/ There is no reliable way to decide when to replay those
     *    injections intended for reconfigured sensors.
     */
    if (qdev_is_realized(DEVICE(s))) {
        return;
    }

    item = g_new0(PMCSysMon_MeasInj, 1);
    item->played = played;
    item->by_root_id = by_root_id;
    if (si->meas_id == XLNX_AMS_SAT_MEAS_TYPE_TSENS) {
        item->meas_val.q8_7 = q8_7_from_float(val);
    } else {
        item->meas_val.flt = val;
    }
    item->info = *si;

    QTAILQ_INSERT_TAIL(&s->meas_injections, item, link);
}

static void pmc_sysmon_root_infer(PMCSysMon *s)
{
    xlnx_ams_sensor_t info = {0};
    unsigned i;

    static const unsigned tid[] = {R_TEMP_LPD_TID, R_TEMP_FPD_TID};
    static const unsigned vid[] = {R_VCCINT_LPD_VID, R_VCCINT_FPD_VID};

    for (i = 0; i < ARRAY_SIZE(tid); i++) {
        info.meas_id = XLNX_AMS_SAT_MEAS_TYPE_TSENS;
        info.root_id = tid[i];
        pmc_sysmon_temp_infer(s, &info);
    }

    for (i = 0; i < ARRAY_SIZE(tid); i++) {
        info.meas_id = XLNX_AMS_SAT_MEAS_TYPE_VCCINT;
        info.root_id = vid[i];
        pmc_sysmon_volt_infer(s, &info);
    }
}

static void pmc_sysmon_play_inferred(PMCSysMon *s, unsigned instance_id)
{
    unsigned nr, base, stop;

    g_assert(pmc_sysmon_root_is_running(s));

    if (instance_id >= s->ams_sat_len) {
        /* Infer all sensors */
        pmc_sysmon_root_infer(s);
        base = 0;
        stop = s->ams_sat_len;
    } else if (pmc_sysmon_sat_is_ready(s, instance_id)) {
        /* Infer sensors from one satelllite */
        base = instance_id;
        stop = base + 1;
    } else {
        return; /* Requested satellite is not ready */
    }

    for (nr = base; nr < stop; nr++) {
        g_autoptr(GArray) si_list = NULL;
        size_t i;

        if (!pmc_sysmon_sat_is_ready(s, nr)) {
            continue;
        }

        si_list = xlnx_ams_sat_config_list(s->ams_sat[nr]);
        if (!si_list) {
            continue;
        }

        for (i = 0; i < si_list->len; i++) {
            xlnx_ams_sensor_t *si;

            si = &g_array_index(si_list, xlnx_ams_sensor_t, i);
            switch (si->meas_id) {
            case XLNX_AMS_SAT_MEAS_TYPE_TSENS:
                pmc_sysmon_temp_infer(s, si);
                break;
            case XLNX_AMS_SAT_MEAS_TYPE_VCCINT:
                pmc_sysmon_vccint_infer(s, si);
                break;
            default:
                pmc_sysmon_volt_infer(s, si);
            }
        }
    }
}

static void pmc_sysmon_init_measurements(PMCSysMon *s, unsigned instance_id)
{
    /*
     * Vivado-generated cdo.bin typically configures alarm thresholds
     * just before activating the root and after activating all attached
     * satelllites.
     *
     * Thus, to avoid raising alarms erroneously due to unconfigured
     * thresholds, measurements must not applied unless the root is running.
     */
    if (!pmc_sysmon_root_is_running(s)) {
        return;
    }

    pmc_sysmon_play_inferred(s, instance_id);
    pmc_sysmon_play_injections(s, instance_id);
}

static void pmc_sysmon_temp_apply_by_root_id(PMCSysMon *s, unsigned tid,
                                             float val, Error **errp)
{
    bool played = false;
    xlnx_ams_sensor_t info = {
        .meas_id = XLNX_AMS_SAT_MEAS_TYPE_TSENS,
        .root_id = tid,
    };

    if (pmc_sysmon_sat_cfg_by_root_id(s, &info)) {
        uint32_t q = q8_7_from_float(val);

        pmc_sysmon_temp_set(s, tid, q);
        played = true;
    }

    pmc_sysmon_store_injection(s, &info, val, true, played);
}

static void pmc_sysmon_volt_apply_by_root_id(PMCSysMon *s, unsigned reg,
                                             float val, Error **errp)
{
    xlnx_ams_sensor_t info;
    bool played = false;

    /*
     * By-root-id voltage injection is a quick test, useful when
     * Vivado generated '*_sysmon_satellite.csv' file is available.
     *
     * However, it is not a preferred method for QEMU automation
     * because Vivado may change a sensor's root-id when the design
     * is modified such as adding or remove other sensors.
     *
     * Thus, for QEMU automation, the "by-spec" voltage injection
     * is preferred because a sensor's spec is stable for a design.
     */
    memset(&info, 0, sizeof(info));
    switch (reg) {
    case R_VCCINT_FPD:
        info.meas_id = XLNX_AMS_SAT_MEAS_TYPE_VCCINT;
        info.root_id = R_VCCINT_FPD_VID;
        break;
    case R_VCCINT_LPD:
        info.meas_id = XLNX_AMS_SAT_MEAS_TYPE_VCCINT;
        info.root_id = R_VCCINT_LPD_VID;
        break;
    case R_VCCINT_SAT_FIRST ... R_VCCINT_SAT_LAST:
        info.meas_id = XLNX_AMS_SAT_MEAS_TYPE_VCCINT;
        info.root_id = reg - R_VCCINT_SAT_FIRST;
        break;
    default:
        info.root_id = reg - R_SUPPLY0;
    }

    if (pmc_sysmon_sat_cfg_by_root_id(s, &info)) {
        pmc_sysmon_set_mfp_meas(s, &info, val, errp);
        played = errp && !*errp;
    }

    /* Save it for replay */
    pmc_sysmon_store_injection(s, &info, val, true, played);
}

static void pmc_sysmon_volt_apply_by_spec(PMCSysMon *s, xlnx_ams_sensor_t *si,
                                          float val, Error **errp)
{
    bool played = false;

    /*
     * By-spec voltage injection is preferred for QEMU-automation
     * because a sensor's spec is stable for a design.
     *
     * However, there are extra steps required to extract sensor
     * specs from the ams-satellite devices, because Vivado does
     * not reveal the info.
     *
     * To display the spec and root-id from QEMU monitor, use HMP:
     *   qom-get pmc_ams_sat@N sensor-cfgs
     * where N is 0 or 1.
     *
     * If Vivado generated '*_sysmon_satellite.csv' file is
     * available, the root-id can be used to identify the
     * user-friendly names of the sensors.
     */
    if (pmc_sysmon_sat_cfg_by_spec(s, si)) {
        pmc_sysmon_set_mfp_meas(s, si, val, errp);
        played = errp && !*errp;
    }

    /* Save it for replay */
    pmc_sysmon_store_injection(s, si, val, false, played);
}

static void pmc_sysmon_reset_hold(Object *dev)
{
    PMCSysMon *s = PMC_SYSMON(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    reg_isr_update_irq(s);

    memset(s->ams_sat_ready, 0, CHANNEL_BCNT(s->ams_sat_len));
    memset(s->temp_sat_set, 0, sizeof(s->temp_sat_set));
    memset(s->ndf_fifo, 0, sizeof(s->ndf_fifo));

    pmc_sysmon_rewnd_injections(s);
    pmc_sysmon_temp_reset_min_max(s);
}

static void pmc_sysmon_reset_exit(Object *dev)
{
    PMCSysMon *s = PMC_SYSMON(dev);
    PMCSysMon_MeasInj *item;

    /*
     * Play measurements for non-configurable sensors, if any, by
     * their root ids
     */
    QTAILQ_FOREACH(item, &s->meas_injections, link) {
        xlnx_ams_sensor_t *si = &item->info;

        if (!item->by_root_id) {
            continue;
        }

        if (pmc_sysmon_sat_cfg_by_root_id(s, si)) {
            pmc_sysmon_play_measurement(s, item);
        }
    }
}

static void pmc_sysmon_temp_cfg_prop_get(Object *obj, Visitor *v,
                                         const char *name, void *opaque,
                                         Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned tid = (uintptr_t)opaque;

    xlnx_ams_sensor_t info = {
        .meas_id = XLNX_AMS_SAT_MEAS_TYPE_TSENS,
        .root_id = tid,
    };

    char str[32], *p = str;

    if (!pmc_sysmon_sat_cfg_by_root_id(s, &info)) {
        error_setg(errp, "temp_sat[%u] not configured", tid + 1);
        return;
    }

    snprintf(str, sizeof(str), "{ amux:%#x, sat:%u }",
             info.amux_ctrl, info.instance);
    visit_type_str(v, name, &p, errp);
}

static void pmc_sysmon_vccint_cfg_prop_get(Object *obj, Visitor *v,
                                           const char *name, void *opaque,
                                           Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned vid = (uintptr_t)opaque - R_VCCINT_SAT_FIRST;

    xlnx_ams_sensor_t info = {
        .meas_id = XLNX_AMS_SAT_MEAS_TYPE_VCCINT,
        .root_id = vid,
    };

    char str[64], *p = str;

    if (!pmc_sysmon_sat_cfg_by_root_id(s, &info)) {
        error_setg(errp, "vccint_sat[%u] not configured", vid + 1);
        return;
    }

    snprintf(str, sizeof(str), "{ amux:%#x, mode:%#x, type:%s, sat:%u }",
             info.amux_ctrl, info.mode,
             (info.meas_bipolar ? "bipolar" : "unipolar"), info.instance);

    visit_type_str(v, name, &p, errp);
}

static void pmc_sysmon_volt_cfg_prop_get(Object *obj, Visitor *v,
                                         const char *name, void *opaque,
                                         Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned vid = (uintptr_t)opaque - R_SUPPLY0;

    xlnx_ams_sensor_t info = {
        .root_id = vid,
    };

    char str[80], *p = str;

    if (!pmc_sysmon_sat_cfg_by_root_id(s, &info)) {
        error_setg(errp, "supply[%u] not configured", vid);
        return;
    }

    snprintf(str, sizeof(str),
             "{ sat:%u, amux_mode_sw1_sw0:%02x_%02x_%02x_%02x, type:%s }",
             info.instance,
             info.amux_ctrl, info.mode, info.abus_sw1, info.abus_sw0,
             (info.meas_bipolar ? "bipolar" : "unipolar"));
    visit_type_str(v, name, &p, errp);
}

static void pmc_sysmon_temp_prop_get(Object *obj, Visitor *v,
                                     const char *name, void *opaque,
                                     Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned tid = (uintptr_t)opaque;
    unsigned reg = pmc_sysmon_temp_sat_reg(tid);
    char str[32], *p = str;

    q8_7_str(s->regs[reg], str, sizeof(str));
    visit_type_str(v, name, &p, errp);
}

static void pmc_sysmon_volt_prop_get(Object *obj, Visitor *v,
                                     const char *name, void *opaque,
                                     Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned reg = (uintptr_t)opaque;
    char str[32], *p = str;

    mfp19_str(s->regs[reg], str, sizeof(str));
    visit_type_str(v, name, &p, errp);
}

static void pmc_sysmon_temp_prop_set(Object *obj, Visitor *v,
                                     const char *name, void *opaque,
                                     Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned tid = (uintptr_t)opaque;

    double val;

    visit_type_number(v, name, &val, errp);
    if (*errp) {
        return;
    }

    if (val < Q8_7_F_MIN || val > Q8_7_F_MAX) {
        error_setg(errp,
                   "Temperature value (%.17g degC) out of range [%.17g, %.17g]",
                   val, Q8_7_F_MIN, Q8_7_F_MAX);
        return;
    }

    pmc_sysmon_temp_apply_by_root_id(s, tid, val, errp);
}

static void pmc_sysmon_volt_prop_set(Object *obj, Visitor *v,
                                     const char *name, void *opaque,
                                     Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    unsigned reg = (uintptr_t)opaque;
    double val;

    visit_type_number(v, name, &val, errp);
    if (*errp) {
        return;
    }
    if (val < FLT_MIN || val > FLT_MAX) {
        error_setg(errp, "Voltage value out of range");
        return;
    }

    pmc_sysmon_volt_apply_by_root_id(s, reg, (float)val, errp);
}

static void pmc_sysmon_set_supplies_prop_set(Object *obj, Visitor *v,
                                             const char *name, void *opaque,
                                             Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    xlnx_ams_sensor_t info;
    unsigned nr;
    float val;
    char *opts, **args;

    visit_type_str(v, name, &opts, errp);
    if (*errp) {
        return;
    }

    args = g_strsplit(opts, ",", -1);
    for (nr = 0; args[nr]; nr += 2) {
        unsigned amux, mode, sw1, sw0;

        if (!args[nr + 1]) {
            error_setg(errp, "Non-even number of args given");
            return;
        }

        sscanf(args[nr], "%x_%x_%x_%x", &amux, &mode, &sw1, &sw0);
        sscanf(args[nr + 1], "%f", &val);

        memset(&info, 0, sizeof(info));
        info.amux_ctrl = amux;
        info.mode = mode;
        info.abus_sw1 = sw1;
        info.abus_sw0 = sw0;

        pmc_sysmon_volt_apply_by_spec(s, &info, val, errp);
    }

    g_strfreev(args);
}

static void pmc_sysmon_set_supplies_prop_get(Object *obj, Visitor *v,
                                             const char *name, void *opaque,
                                             Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);
    char empty[] = "<empty>", *p = empty;
    GString *str;
    PMCSysMon_MeasInj *item;

    str = g_string_new("");

    /* Show whatever remaining in the replay list */
    QTAILQ_FOREACH(item, &s->meas_injections, link) {
        xlnx_ams_sensor_t *si = &item->info;

        g_string_append_printf(str, ",%02x_%02x_%02x_%02x,%.17g",
                               si->amux_ctrl, si->mode,
                               si->abus_sw1, si->abus_sw0,
                               item->meas_val.flt);
    }

    if (str->str[0] == ',') {
        p = &str->str[1];
    }
    visit_type_str(v, name, &p, errp);
    g_string_free(str, TRUE);
}

static void pmc_sysmon_default_volt_prop_set(Object *obj, Visitor *v,
                                             const char *name, void *opaque,
                                             Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);

    visit_type_number(v, name, &s->default_volt, errp);
}

static void pmc_sysmon_default_volt_prop_get(Object *obj, Visitor *v,
                                             const char *name, void *opaque,
                                             Error **errp)
{
    PMCSysMon *s = PMC_SYSMON(obj);

    visit_type_number(v, name, &s->default_volt, errp);
}

static void pmc_sysmon_measurement_file_inj(Object *obj, const gchar *line,
                                            const char *prefix, size_t ln_num)
{
    g_auto(GStrv) words = NULL;
    const char *emsg = NULL;
    Error *qerr = NULL;
    size_t k, t;

    union {
        gchar *words[5];  /* qom-get PATH PROP VAL <End-of-cmd> */
        struct {
            gchar *hmp;
            gchar *path;
            gchar *prop;
            gchar *value;
            gchar *end;
        };
    } tok;

    g_assert(obj);

    /* Collect words, with multiple in-between spaces skipped */
    memset(&tok, 0, sizeof(tok));
    words = g_strsplit_set(line, " \t", -1);
    for (t = 0, k = 0; words[k] && (t < ARRAY_SIZE(tok.words)); k++) {
        if (strlen(words[k])) {
            tok.words[t++] = words[k];
        }
    }

    /*
     * Silently ignore other HMP cmds to allow same file played to
     * other objects having similar feature.
     *
     * Silently ignore target-object other than self, to:
     * 1. Prevent this becoming a backdoor to execute arbitary qom-set,
     * 2. Allow same file played to other objects having similar feature.
     */
    if (!tok.hmp) {
        return;
    }
    if (strcmp(tok.hmp, "qom-set")) {
        return;
    }
    if (tok.path) {
        Object *o = object_resolve_path(tok.path, NULL);

        if (o != obj) {
            return;
        }
    }

    if (!tok.value) {
        emsg = "Insufficient parameters";
        goto bad_cmd;
    }
    if (tok.end) {
        emsg = "Too many parameters";
        goto bad_cmd;
    }

    /* Execute qom-set */
    object_property_parse(obj, tok.prop, tok.value, &qerr);
    if (qerr) {
        emsg = error_get_pretty(qerr);
        goto bad_cmd;
    }

    /* Success! */
    return;

 bad_cmd:
    warn_report("%s:%zu: %s.", prefix, ln_num, emsg);
    error_free(qerr);
}

static void pmc_sysmon_measurement_file_set(Object *obj, Visitor *v,
                                            const char *name, void *opaque,
                                            Error **errp)
{
    g_autofree char *prefix = object_get_canonical_path(obj);
    g_autofree char *fname = NULL;
    g_autoptr(GError) ferr = NULL;
    g_auto(GStrv) lines = NULL;
    gchar *text = NULL;
    size_t i;

    if (!visit_type_str(v, name, &fname, errp)) {
        return;
    }

    if (!prefix) {
        /* Defer set by -global until realize phase */
        PMCSysMon *s = PMC_SYSMON(obj);

        g_free(s->meas_file);
        s->meas_file = fname;
        fname = NULL;
        return;
    }

    text = prefix;
    prefix = g_strdup_printf("%s." PROP_MEAS_FILE "=%s", prefix, fname);
    g_free(text);

    if (!g_file_get_contents(fname, &text, NULL, &ferr)) {
        error_setg(errp, "%s: %s", prefix, ferr->message);
        return;
    }

    lines = g_strsplit(text, "\n", -1);
    g_free(text);

    for (i = 0; lines[i] != NULL; i++) {
        gchar *line = lines[i];

        g_strstrip(line);
        if (strlen(line)) {
            pmc_sysmon_measurement_file_inj(obj, line, prefix, i);
        }
    }
}

static void pmc_sysmon_class_prop_add(ObjectClass *klass,
                                      const char *name,
                                      const char *type,
                                      const char *desc,
                                      ObjectPropertyAccessor *get,
                                      ObjectPropertyAccessor *set,
                                      void *opaque)
{
    object_class_property_add(klass, name, type, get, set, NULL, opaque);
    object_class_property_set_description(klass, name, desc);
}

static void pmc_sysmon_temp_prop_add(ObjectClass *klass)
{
    unsigned tid;

    static const char type[] = "Celsius:signed-fixed-point-decimal";

    /*
     * There is one, and only one, temp sensor in each satellite, whose
     * root-id, n (as in TEMP_SATn), is configurable.
     *
     * However, there is no reliable way to specify a temp sensor other
     * than the root-id. So, only set-by-root-id is supported, where each
     * satellite temp's root-id displayed by temp_sat[*]-cfg.
     */
    for (tid = 0; tid < R_TEMP_SAT_COUNT - 2; tid++) {
        void *opaque = (void *)(uintptr_t)tid;

        char name[32];

        /* Notational-wise, TEMP_SATn is 1-based */
        snprintf(name, sizeof(name), "temp_sat[%u]", (tid + 1));
        pmc_sysmon_class_prop_add(klass, name, type,
                                  "Satellite temperature",
                                  pmc_sysmon_temp_prop_get,
                                  pmc_sysmon_temp_prop_set,
                                  opaque);

        snprintf(name, sizeof(name), "temp_sat[%u]-cfg", (tid + 1));
        pmc_sysmon_class_prop_add(klass, name, "{amux}:str",
                                  "Satellite temperature config",
                                  pmc_sysmon_temp_cfg_prop_get,
                                  NULL, /* non-settable */
                                  opaque);
    }

    pmc_sysmon_class_prop_add(klass, "TEMP_FPD", type,
                              "FPD temperature",
                              pmc_sysmon_temp_prop_get,
                              pmc_sysmon_temp_prop_set,
                              (void *)(uintptr_t)tid++);

    pmc_sysmon_class_prop_add(klass, "TEMP_LPD", type,
                              "LPD temperature",
                              pmc_sysmon_temp_prop_get,
                              pmc_sysmon_temp_prop_set,
                              (void *)(uintptr_t)tid++);
}

static void pmc_sysmon_volt_prop_add(ObjectClass *klass)
{
    unsigned vid;

    static const char type[] = "Volt:signed-fixed-point-decimal";

    for (vid = 0; vid < R_SUPPLY_COUNT; vid++) {
        void *opaque = (void *)(uintptr_t)(R_SUPPLY0 + vid);

        char name[32];

        /* Notational-wise, SUPPLYn is 0-based */
        snprintf(name, sizeof(name), "supply[%u]", vid);
        pmc_sysmon_class_prop_add(klass, name, type,
                                  "Satellite supply in volts",
                                  pmc_sysmon_volt_prop_get,
                                  pmc_sysmon_volt_prop_set,
                                  opaque);

        snprintf(name, sizeof(name), "supply[%u]-cfg", vid);
        pmc_sysmon_class_prop_add(klass, name,
                                  "{amux, mode, sw1, sw0}:str",
                                  "Satellite supply config",
                                  pmc_sysmon_volt_cfg_prop_get,
                                  NULL, /* non-settable */
                                  opaque);
    }

    /*
     * There is one, and only one, vccint sensor in each satellite, whose
     * root-id, n (as in VCCINT_SATn), is configurable.
     *
     * However, there is no reliable way to specify a vccint sensor other
     * than the root-id. So, only set-by-root-id is supported, where each
     * satellite vccint's root-id displayed by vccint_sat[*]-cfg.
     */
    for (vid = 0; vid < R_VCCINT_SAT_COUNT; vid++) {
        void *opaque = (void *)(uintptr_t)(R_VCCINT_SAT_FIRST + vid);
        char name[32];

        snprintf(name, sizeof(name), "vccint_sat[%u]", (vid + 1));
        pmc_sysmon_class_prop_add(klass, name, type,
                                  "Satellite vccint in volts",
                                  pmc_sysmon_volt_prop_get,
                                  pmc_sysmon_volt_prop_set,
                                  opaque);

        snprintf(name, sizeof(name), "vccint_sat[%u]-cfg", (vid + 1));
        pmc_sysmon_class_prop_add(klass, name, "{amux, mode}:str",
                                  "Satellite vccint config",
                                  pmc_sysmon_vccint_cfg_prop_get,
                                  NULL, /* non-settable */
                                  opaque);
    }

    pmc_sysmon_class_prop_add(klass, "VCCINT_FPD", type,
                              "PS FPD vccint in volts",
                              pmc_sysmon_volt_prop_get,
                              pmc_sysmon_volt_prop_set,
                              (void *)(uintptr_t)R_VCCINT_FPD);

    pmc_sysmon_class_prop_add(klass, "VCCINT_LPD", type,
                              "PS LPD vccint in volts",
                              pmc_sysmon_volt_prop_get,
                              pmc_sysmon_volt_prop_set,
                              (void *)(uintptr_t)R_VCCINT_LPD);

    pmc_sysmon_class_prop_add(klass, "set-supplies",
                              "list of amux_mode_sw1_sw0,volt pairs",
                              "A comma-separated list of supplies",
                              pmc_sysmon_set_supplies_prop_get,
                              pmc_sysmon_set_supplies_prop_set,
                              NULL);

    pmc_sysmon_class_prop_add(klass, "default-voltage", type,
                              "Default measurement value of a voltage sensor",
                              pmc_sysmon_default_volt_prop_get,
                              pmc_sysmon_default_volt_prop_set,
                              NULL);
}

static void pmc_sysmon_file_prop_add(ObjectClass *klass)
{
    pmc_sysmon_class_prop_add(klass, PROP_MEAS_FILE, "file-path",
                              "lines of qom-set HMP commands",
                              NULL, /* no get */
                              pmc_sysmon_measurement_file_set,
                              NULL);
}

static Property pmc_sysmon_properties[] = {
    DEFINE_PROP_INT32("default-celsius", PMCSysMon, default_celsius, 25),
    DEFINE_PROP_UINT32("new-data-flag-timer", PMCSysMon, ndf_tick_ms, 200),
    DEFINE_PROP_UINT32("efuse-transfer-throttle",
                       PMCSysMon, efuse_throttle_ms, 200),
    DEFINE_PROP_LINK("efuse", PMCSysMon, efuse, TYPE_OBJECT, Object *),
    DEFINE_PROP_LINK("ams-sat0", PMCSysMon, ams_sat0, TYPE_OBJECT, Object *),
    DEFINE_PROP_LINK("ams-sat1", PMCSysMon, ams_sat1, TYPE_OBJECT, Object *),
    DEFINE_PROP_ARRAY("ams-sats", PMCSysMon, ams_sat_len, ams_sat,
                      qdev_prop_link, Object *),
    DEFINE_PROP_LINK("tamper-sink", PMCSysMon, tamper_sink,
                     TYPE_OBJECT, Object *),

    DEFINE_PROP_END_OF_LIST(),
};

static const VMStateDescription vmstate_pmc_sysmon = {
    .name = TYPE_PMC_SYSMON,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMCSysMon, PMC_SYSMON_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmc_sysmon_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    ResettableClass *rc = RESETTABLE_CLASS(klass);

    rc->phases.hold = pmc_sysmon_reset_hold;
    rc->phases.exit = pmc_sysmon_reset_exit;

    dc->realize = pmc_sysmon_realize;
    dc->vmsd = &vmstate_pmc_sysmon;
    device_class_set_props(dc, pmc_sysmon_properties);

    /* Support temp & volt injection by the 'qom-set' HMP */
    pmc_sysmon_temp_prop_add(klass);
    pmc_sysmon_volt_prop_add(klass);
    pmc_sysmon_file_prop_add(klass);

    /* Sanity-check number format conversion */
    assert_number_formats();
}

void xlnx_ams_root_sat_config_ready(Object *root, unsigned instance_id)
{
    PMCSysMon *s = PMC_SYSMON(root);

    assert(instance_id < s->ams_sat_len);
    pmc_sysmon_sat_set_ready(s, instance_id);
    pmc_sysmon_init_measurements(s, instance_id);
}

static const TypeInfo pmc_sysmon_info = {
    .name          = TYPE_PMC_SYSMON,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMCSysMon),
    .class_init    = pmc_sysmon_class_init,
    .instance_init = pmc_sysmon_init,
    .instance_finalize = pmc_sysmon_finalize,
};

static void pmc_sysmon_register_types(void)
{
    type_register_static(&pmc_sysmon_info);
}

type_init(pmc_sysmon_register_types)
