/*
 * QEMU model of the PMC_TAMPER PMC Global Power Management Registers
 *
 * Copyright (c) 2018 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2018-01-05.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#ifndef XILINX_PMC_TAMPER_ERR_DEBUG
#define XILINX_PMC_TAMPER_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMC_TAMPER "xlnx.pmc_tamper"

#define XILINX_PMC_TAMPER(obj) \
     OBJECT_CHECK(PmcTamper, (obj), TYPE_XILINX_PMC_TAMPER)

REG32(PMC_TAMPER_0, 0x0)
    FIELD(PMC_TAMPER_0, BBRAM_ERASE, 4, 1)
    FIELD(PMC_TAMPER_0, SEC_LOCKDOWN_1, 3, 1)
    FIELD(PMC_TAMPER_0, SEC_LOCKDOWN_0, 2, 1)
    FIELD(PMC_TAMPER_0, SYS_RESET, 1, 1)
    FIELD(PMC_TAMPER_0, SYS_INTERRUPT, 0, 1)
REG32(PMC_TAMPER_13, 0x3C)
    FIELD(PMC_TAMPER_13, BBRAM_ERASE, 4, 1)
    FIELD(PMC_TAMPER_13, SEC_LOCKDOWN_1, 3, 1)
    FIELD(PMC_TAMPER_13, SEC_LOCKDOWN_0, 2, 1)
    FIELD(PMC_TAMPER_13, SYS_RESET, 1, 1)
    FIELD(PMC_TAMPER_13, SYS_INTERRUPT, 0, 1)

#define R_MAX (R_PMC_TAMPER_13 + 1)

typedef struct PmcTamper {
    SysBusDevice parent_obj;
    MemoryRegion iomem[2];

    uint32_t regs[R_MAX];
    RegisterInfo regs_info[R_MAX];
} PmcTamper;

static RegisterAccessInfo pmc_tamper_regs_info[] = {
#define P(n) \
    {   .name = "PMC_TAMPER_" #n, .addr = A_PMC_TAMPER_0 + n * 4 \
    },
    P(0) P(1) P(2) P(3) P(4) P(5) P(6) P(7) P(8) P(9) P(10) P(11) P(12) P(13)
#undef P
};

static void pmc_tamper_reset(DeviceState *dev)
{
    PmcTamper *s = XILINX_PMC_TAMPER(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

}

static const MemoryRegionOps pmc_tamper_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmc_tamper_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void pmc_tamper_init(Object *obj)
{
    PmcTamper *s = XILINX_PMC_TAMPER(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->iomem); i++) {
        memory_region_init(&s->iomem[i], obj, TYPE_XILINX_PMC_TAMPER, R_MAX * 4);
        reg_array =
            register_init_block32(DEVICE(obj), pmc_tamper_regs_info,
                                  ARRAY_SIZE(pmc_tamper_regs_info),
                                  s->regs_info, s->regs,
                                  &pmc_tamper_ops,
                                  XILINX_PMC_TAMPER_ERR_DEBUG,
                                  R_MAX * 4);
        memory_region_add_subregion(&s->iomem[i],
                                0x0,
                                &reg_array->mem);
       sysbus_init_mmio(sbd, &s->iomem[i]);
    }
}

static const VMStateDescription vmstate_pmc_tamper = {
    .name = TYPE_XILINX_PMC_TAMPER,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PmcTamper, R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmc_tamper_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->reset = pmc_tamper_reset;
    dc->realize = pmc_tamper_realize;
    dc->vmsd = &vmstate_pmc_tamper;
}

static const TypeInfo pmc_tamper_info = {
    .name          = TYPE_XILINX_PMC_TAMPER,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PmcTamper),
    .class_init    = pmc_tamper_class_init,
    .instance_init = pmc_tamper_init,
};

static void pmc_tamper_register_types(void)
{
    type_register_static(&pmc_tamper_info);
}

type_init(pmc_tamper_register_types)
