/*
 * QEMU model of the PMX_IOU_SECURE_SLCR Global system level control registers
 * for the iou.
 *
 * Copyright (c) 2024 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2024-09-30.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_PMX_IOU_SECURE_SLCR_ERR_DEBUG
#define XILINX_PMX_IOU_SECURE_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PMX_IOU_SECURE_SLCR "xlnx.pmx_iou_secure_slcr"

#define XILINX_PMX_IOU_SECURE_SLCR(obj) \
     OBJECT_CHECK(PMX_IOU_SECURE_SLCR, (obj), TYPE_XILINX_PMX_IOU_SECURE_SLCR)

REG32(IOU_AXI_WPRTCN_SD0, 0x0)
    FIELD(IOU_AXI_WPRTCN_SD0, SD0_AXI_AWPROT, 0, 3)
REG32(IOU_AXI_RPRTCN_SD0, 0x4)
    FIELD(IOU_AXI_RPRTCN_SD0, SD0_AXI_ARPROT, 0, 3)
REG32(IOU_AXI_WPRTCN_EMMC, 0x10)
    FIELD(IOU_AXI_WPRTCN_EMMC, EMMC_AXI_AWPROT, 0, 3)
REG32(IOU_AXI_RPRTCN_EMMC, 0x14)
    FIELD(IOU_AXI_RPRTCN_EMMC, EMMC_AXI_ARPROT, 0, 3)
REG32(IOU_AXI_WPRTCN_QSPI, 0x20)
    FIELD(IOU_AXI_WPRTCN_QSPI, QSPI_AXI_AWPROT, 0, 3)
REG32(IOU_AXI_WPRTCN_OSPI, 0x30)
    FIELD(IOU_AXI_WPRTCN_OSPI, OSPI_AXI_AWPROT, 0, 3)
REG32(PMX_I2C_I3C_CTRL, 0x38)
    FIELD(PMX_I2C_I3C_CTRL, I2C_I3C_SELECT, 0, 1)
REG32(CTRL, 0x40)
    FIELD(CTRL, SLVERR_ENABLE, 0, 1)
REG32(ISR, 0x44)
    FIELD(ISR, ADDR_DECODE_ERR, 0, 1)
REG32(IMR, 0x48)
    FIELD(IMR, ADDR_DECODE_ERR, 0, 1)
REG32(IER, 0x4c)
    FIELD(IER, ADDR_DECODE_ERR, 0, 1)
REG32(IDR, 0x50)
    FIELD(IDR, ADDR_DECODE_ERR, 0, 1)
REG32(ITR, 0x54)
    FIELD(ITR, ADDR_DECODE_ERR, 0, 1)
REG32(TZPROT, 0x6c)
    FIELD(TZPROT, ACTIVE, 0, 1)
REG32(PMX_I2C_I3C_LOCK, 0x74)
    FIELD(PMX_I2C_I3C_LOCK, ACTIVE, 0, 1)

#define PMX_IOU_SECURE_SLCR_R_MAX (R_PMX_I2C_I3C_LOCK + 1)

typedef struct PMX_IOU_SECURE_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_imr;

    uint32_t regs[PMX_IOU_SECURE_SLCR_R_MAX];
    RegisterInfo regs_info[PMX_IOU_SECURE_SLCR_R_MAX];
} PMX_IOU_SECURE_SLCR;

static void imr_update_irq(PMX_IOU_SECURE_SLCR *s)
{
    bool pending = s->regs[R_ISR] & ~s->regs[R_IMR];
    qemu_set_irq(s->irq_imr, pending);
}

static void isr_postw(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(reg->opaque);
    imr_update_irq(s);
}

static uint64_t ier_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] &= ~val;
    imr_update_irq(s);
    return 0;
}

static uint64_t idr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IMR] |= val;
    imr_update_irq(s);
    return 0;
}

static uint64_t itr_prew(RegisterInfo *reg, uint64_t val64)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ISR] |= val;
    imr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo pmx_iou_secure_slcr_regs_info[] = {
    {   .name = "IOU_AXI_WPRTCN_SD0",  .addr = A_IOU_AXI_WPRTCN_SD0,
        .rsvd = 0xfffffff8,
    },{ .name = "IOU_AXI_RPRTCN_SD0",  .addr = A_IOU_AXI_RPRTCN_SD0,
        .rsvd = 0xfffffff8,
    },{ .name = "IOU_AXI_WPRTCN_EMMC",  .addr = A_IOU_AXI_WPRTCN_EMMC,
        .rsvd = 0xfffffff8,
    },{ .name = "IOU_AXI_RPRTCN_EMMC",  .addr = A_IOU_AXI_RPRTCN_EMMC,
        .rsvd = 0xfffffff8,
    },{ .name = "IOU_AXI_WPRTCN_QSPI",  .addr = A_IOU_AXI_WPRTCN_QSPI,
        .rsvd = 0xfffffff8,
    },{ .name = "IOU_AXI_WPRTCN_OSPI",  .addr = A_IOU_AXI_WPRTCN_OSPI,
        .rsvd = 0xfffffff8,
    },{ .name = "PMX_I2C_I3C_CTRL",  .addr = A_PMX_I2C_I3C_CTRL,
        .rsvd = 0xfffffffe, .ro = 0x1,
        .reset = 0x1,
    },{ .name = "CTRL",  .addr = A_CTRL,
    },{ .name = "ISR",  .addr = A_ISR,
        .w1c = 0x1,
        .post_write = isr_postw,
    },{ .name = "IMR",  .addr = A_IMR,
        .reset = 0x1,
        .ro = 0x1,
    },{ .name = "IER",  .addr = A_IER,
        .pre_write = ier_prew,
    },{ .name = "IDR",  .addr = A_IDR,
        .pre_write = idr_prew,
    },{ .name = "ITR",  .addr = A_ITR,
        .pre_write = itr_prew,
    },{ .name = "TZPROT",  .addr = A_TZPROT,
    },{ .name = "PMX_I2C_I3C_LOCK",  .addr = A_PMX_I2C_I3C_LOCK,
    }
};

static void pmx_iou_secure_slcr_reset_enter(Object *obj, ResetType type)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void pmx_iou_secure_slcr_reset_hold(Object *obj)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(obj);

    imr_update_irq(s);
}

static const MemoryRegionOps pmx_iou_secure_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pmx_iou_secure_slcr_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void pmx_iou_secure_slcr_init(Object *obj)
{
    PMX_IOU_SECURE_SLCR *s = XILINX_PMX_IOU_SECURE_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PMX_IOU_SECURE_SLCR,
                       PMX_IOU_SECURE_SLCR_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), pmx_iou_secure_slcr_regs_info,
                              ARRAY_SIZE(pmx_iou_secure_slcr_regs_info),
                              s->regs_info, s->regs,
                              &pmx_iou_secure_slcr_ops,
                              XILINX_PMX_IOU_SECURE_SLCR_ERR_DEBUG,
                              PMX_IOU_SECURE_SLCR_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_imr);
}

static const VMStateDescription vmstate_pmx_iou_secure_slcr = {
    .name = TYPE_XILINX_PMX_IOU_SECURE_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PMX_IOU_SECURE_SLCR,
                             PMX_IOU_SECURE_SLCR_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void pmx_iou_secure_slcr_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = pmx_iou_secure_slcr_realize;
    dc->vmsd = &vmstate_pmx_iou_secure_slcr;
    rc->phases.enter = pmx_iou_secure_slcr_reset_enter;
    rc->phases.hold = pmx_iou_secure_slcr_reset_hold;
}

static const TypeInfo pmx_iou_secure_slcr_info = {
    .name          = TYPE_XILINX_PMX_IOU_SECURE_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PMX_IOU_SECURE_SLCR),
    .class_init    = pmx_iou_secure_slcr_class_init,
    .instance_init = pmx_iou_secure_slcr_init,
};

static void pmx_iou_secure_slcr_register_types(void)
{
    type_register_static(&pmx_iou_secure_slcr_info);
}

type_init(pmx_iou_secure_slcr_register_types)
