/*
 * QEMU model of the PSM_GLOBAL_REG This is the database for the
 * PSM Global Register Definitions.
 *
 * Copyright (c) 2018-2022, Xilinx Inc.
 * Copyright (c) 2022-2024, Advanced Micro Devices, Inc.
 *
 * Autogenerated by xregqemu.py 2018-08-20.
 * Written by Edgar E. Iglesias <edgar.iglesias@xilinx.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/qdev-properties.h"

#include "hw/fdt_generic_util.h"

#ifndef XILINX_PSM_GLOBAL_REG_ERR_DEBUG
#define XILINX_PSM_GLOBAL_REG_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSM_GLOBAL_REG "xlnx.psm-global-reg"

#define XILINX_PSM_GLOBAL_REG(obj) \
     OBJECT_CHECK(PSM_GLOBAL_REG, (obj), TYPE_XILINX_PSM_GLOBAL_REG)

REG32(GLOBAL_CNTRL, 0x0)
    FIELD(GLOBAL_CNTRL, MB_CLK_EN_FORCE, 18, 1)
    FIELD(GLOBAL_CNTRL, MB_DBG_WAKE, 17, 1)
    FIELD(GLOBAL_CNTRL, MB_SLEEP, 16, 1)
    FIELD(GLOBAL_CNTRL, WRITE_QOS, 12, 4)
    FIELD(GLOBAL_CNTRL, READ_QOS, 8, 4)
    FIELD(GLOBAL_CNTRL, FW_IS_PRESENT, 4, 1)
    FIELD(GLOBAL_CNTRL, SLVERR_ENABLE, 1, 1)
REG32(APU_PWR_STATUS_INIT, 0x8)
    FIELD(APU_PWR_STATUS_INIT, ACPU1, 1, 1)
    FIELD(APU_PWR_STATUS_INIT, ACPU0, 0, 1)
REG32(ADDR_ERROR_STATUS, 0x10)
    FIELD(ADDR_ERROR_STATUS, STATUS, 0, 1)
REG32(ADDR_ERROR_INT_MASK, 0x14)
    FIELD(ADDR_ERROR_INT_MASK, MASK, 0, 1)
REG32(ADDR_ERROR_INT_EN, 0x18)
    FIELD(ADDR_ERROR_INT_EN, ENABLE, 0, 1)
REG32(ADDR_ERROR_INT_DIS, 0x1c)
    FIELD(ADDR_ERROR_INT_DIS, DISABLE, 0, 1)
REG32(PS_SW_ERR, 0x20)
    FIELD(PS_SW_ERR, NCR_FLAG, 31, 1)
    FIELD(PS_SW_ERR, CR_FLAG, 30, 1)
    FIELD(PS_SW_ERR, DATA, 0, 30)
REG32(PSM_BOOT_SERV_ERR, 0x24)
    FIELD(PSM_BOOT_SERV_ERR, NCR_FLAG, 31, 1)
    FIELD(PSM_BOOT_SERV_ERR, CR_FLAG, 30, 1)
    FIELD(PSM_BOOT_SERV_ERR, DATA, 0, 30)
REG32(GLOBAL_GEN_STORAGE0, 0x30)
REG32(GLOBAL_GEN_STORAGE1, 0x34)
REG32(GLOBAL_GEN_STORAGE2, 0x38)
REG32(GLOBAL_GEN_STORAGE3, 0x3c)
REG32(GLOBAL_GEN_STORAGE4, 0x40)
REG32(GLOBAL_GEN_STORAGE5, 0x44)
REG32(GLOBAL_GEN_STORAGE6, 0x48)
REG32(GLOBAL_GEN_STORAGE7, 0x4c)
REG32(PERS_GLOB_GEN_STORAGE0, 0x50)
REG32(PERS_GLOB_GEN_STORAGE1, 0x54)
REG32(PERS_GLOB_GEN_STORAGE2, 0x58)
REG32(PERS_GLOB_GEN_STORAGE3, 0x5c)
REG32(PERS_GLOB_GEN_STORAGE4, 0x60)
REG32(PERS_GLOB_GEN_STORAGE5, 0x64)
REG32(PERS_GLOB_GEN_STORAGE6, 0x68)
REG32(PERS_GLOB_GEN_STORAGE7, 0x6c)
REG32(PWR_STATE, 0x100)
    FIELD(PWR_STATE, FP, 22, 1)
    FIELD(PWR_STATE, GEM0, 21, 1)
    FIELD(PWR_STATE, GEM1, 20, 1)
    FIELD(PWR_STATE, OCM_BANK3, 19, 1)
    FIELD(PWR_STATE, OCM_BANK2, 18, 1)
    FIELD(PWR_STATE, OCM_BANK1, 17, 1)
    FIELD(PWR_STATE, OCM_BANK0, 16, 1)
    FIELD(PWR_STATE, TCM1B, 15, 1)
    FIELD(PWR_STATE, TCM1A, 14, 1)
    FIELD(PWR_STATE, TCM0B, 13, 1)
    FIELD(PWR_STATE, TCM0A, 12, 1)
    FIELD(PWR_STATE, R5_1, 11, 1)
    FIELD(PWR_STATE, R5_0, 10, 1)
    FIELD(PWR_STATE, L2_BANK0, 7, 1)
    FIELD(PWR_STATE, ACPU1, 1, 1)
    FIELD(PWR_STATE, ACPU0, 0, 1)
REG32(AUX_PWR_STATE, 0x104)
    FIELD(AUX_PWR_STATE, ACPU1_EMULATION, 29, 1)
    FIELD(AUX_PWR_STATE, ACPU0_EMULATION, 28, 1)
    FIELD(AUX_PWR_STATE, RPU_EMULATION, 27, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK3, 19, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK2, 18, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK1, 17, 1)
    FIELD(AUX_PWR_STATE, OCM_BANK0, 16, 1)
    FIELD(AUX_PWR_STATE, TCM1B, 15, 1)
    FIELD(AUX_PWR_STATE, TCM1A, 14, 1)
    FIELD(AUX_PWR_STATE, TCM0B, 13, 1)
    FIELD(AUX_PWR_STATE, TCM0A, 12, 1)
    FIELD(AUX_PWR_STATE, L2_BANK0, 7, 1)
REG32(REQ_PWRUP_STATUS, 0x110)
    FIELD(REQ_PWRUP_STATUS, FP, 22, 1)
    FIELD(REQ_PWRUP_STATUS, GEM0, 21, 1)
    FIELD(REQ_PWRUP_STATUS, GEM1, 20, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_STATUS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_STATUS, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_STATUS, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_STATUS, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_STATUS, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_STATUS, RPU, 10, 1)
    FIELD(REQ_PWRUP_STATUS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_STATUS, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_STATUS, ACPU0, 0, 1)
REG32(REQ_PWRUP_INT_MASK, 0x114)
    FIELD(REQ_PWRUP_INT_MASK, FP, 22, 1)
    FIELD(REQ_PWRUP_INT_MASK, GEM0, 21, 1)
    FIELD(REQ_PWRUP_INT_MASK, GEM1, 20, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_INT_MASK, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_INT_MASK, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_INT_MASK, RPU, 10, 1)
    FIELD(REQ_PWRUP_INT_MASK, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_INT_MASK, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_INT_MASK, ACPU0, 0, 1)
REG32(REQ_PWRUP_INT_EN, 0x118)
    FIELD(REQ_PWRUP_INT_EN, FP, 22, 1)
    FIELD(REQ_PWRUP_INT_EN, GEM0, 21, 1)
    FIELD(REQ_PWRUP_INT_EN, GEM1, 20, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_INT_EN, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_INT_EN, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_INT_EN, RPU, 10, 1)
    FIELD(REQ_PWRUP_INT_EN, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_INT_EN, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_INT_EN, ACPU0, 0, 1)
REG32(REQ_PWRUP_INT_DIS, 0x11c)
    FIELD(REQ_PWRUP_INT_DIS, FP, 22, 1)
    FIELD(REQ_PWRUP_INT_DIS, GEM0, 21, 1)
    FIELD(REQ_PWRUP_INT_DIS, GEM1, 20, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_INT_DIS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_INT_DIS, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_INT_DIS, RPU, 10, 1)
    FIELD(REQ_PWRUP_INT_DIS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_INT_DIS, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_INT_DIS, ACPU0, 0, 1)
REG32(REQ_PWRUP_TRIG, 0x120)
    FIELD(REQ_PWRUP_TRIG, FP, 22, 1)
    FIELD(REQ_PWRUP_TRIG, GEM0, 21, 1)
    FIELD(REQ_PWRUP_TRIG, GEM1, 20, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRUP_TRIG, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRUP_TRIG, TCM1B, 15, 1)
    FIELD(REQ_PWRUP_TRIG, TCM1A, 14, 1)
    FIELD(REQ_PWRUP_TRIG, TCM0B, 13, 1)
    FIELD(REQ_PWRUP_TRIG, TCM0A, 12, 1)
    FIELD(REQ_PWRUP_TRIG, RPU, 10, 1)
    FIELD(REQ_PWRUP_TRIG, L2_BANK0, 7, 1)
    FIELD(REQ_PWRUP_TRIG, ACPU1, 1, 1)
    FIELD(REQ_PWRUP_TRIG, ACPU0, 0, 1)
REG32(REQ_PWRDWN_STATUS, 0x210)
    FIELD(REQ_PWRDWN_STATUS, FP, 22, 1)
    FIELD(REQ_PWRDWN_STATUS, GEM0, 21, 1)
    FIELD(REQ_PWRDWN_STATUS, GEM1, 20, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_STATUS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_STATUS, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_STATUS, RPU, 10, 1)
    FIELD(REQ_PWRDWN_STATUS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_STATUS, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_STATUS, ACPU0, 0, 1)
REG32(REQ_PWRDWN_INT_MASK, 0x214)
    FIELD(REQ_PWRDWN_INT_MASK, FP, 22, 1)
    FIELD(REQ_PWRDWN_INT_MASK, GEM0, 21, 1)
    FIELD(REQ_PWRDWN_INT_MASK, GEM1, 20, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_INT_MASK, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_INT_MASK, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_INT_MASK, RPU, 10, 1)
    FIELD(REQ_PWRDWN_INT_MASK, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_INT_MASK, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_INT_MASK, ACPU0, 0, 1)
REG32(REQ_PWRDWN_INT_EN, 0x218)
    FIELD(REQ_PWRDWN_INT_EN, FP, 22, 1)
    FIELD(REQ_PWRDWN_INT_EN, GEM0, 21, 1)
    FIELD(REQ_PWRDWN_INT_EN, GEM1, 20, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_INT_EN, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_INT_EN, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_INT_EN, RPU, 10, 1)
    FIELD(REQ_PWRDWN_INT_EN, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_INT_EN, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_INT_EN, ACPU0, 0, 1)
REG32(REQ_PWRDWN_INT_DIS, 0x21c)
    FIELD(REQ_PWRDWN_INT_DIS, FP, 22, 1)
    FIELD(REQ_PWRDWN_INT_DIS, GEM0, 21, 1)
    FIELD(REQ_PWRDWN_INT_DIS, GEM1, 20, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_INT_DIS, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_INT_DIS, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_INT_DIS, RPU, 10, 1)
    FIELD(REQ_PWRDWN_INT_DIS, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_INT_DIS, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_INT_DIS, ACPU0, 0, 1)
REG32(REQ_PWRDWN_TRIG, 0x220)
    FIELD(REQ_PWRDWN_TRIG, FP, 22, 1)
    FIELD(REQ_PWRDWN_TRIG, GEM0, 21, 1)
    FIELD(REQ_PWRDWN_TRIG, GEM1, 20, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK3, 19, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK2, 18, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK1, 17, 1)
    FIELD(REQ_PWRDWN_TRIG, OCM_BANK0, 16, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM1B, 15, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM1A, 14, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM0B, 13, 1)
    FIELD(REQ_PWRDWN_TRIG, TCM0A, 12, 1)
    FIELD(REQ_PWRDWN_TRIG, RPU, 10, 1)
    FIELD(REQ_PWRDWN_TRIG, L2_BANK0, 7, 1)
    FIELD(REQ_PWRDWN_TRIG, ACPU1, 1, 1)
    FIELD(REQ_PWRDWN_TRIG, ACPU0, 0, 1)
REG32(REQ_ISO_STATUS, 0x310)
    FIELD(REQ_ISO_STATUS, FP, 0, 1)
REG32(REQ_ISO_INT_MASK, 0x314)
    FIELD(REQ_ISO_INT_MASK, FP, 0, 1)
REG32(REQ_ISO_INT_EN, 0x318)
    FIELD(REQ_ISO_INT_EN, FP, 0, 1)
REG32(REQ_ISO_INT_DIS, 0x31c)
    FIELD(REQ_ISO_INT_DIS, FP, 0, 1)
REG32(REQ_ISO_TRIG, 0x320)
    FIELD(REQ_ISO_TRIG, FP, 0, 1)
REG32(REQ_SWRST_STATUS, 0x410)
    FIELD(REQ_SWRST_STATUS, FP, 30, 1)
    FIELD(REQ_SWRST_STATUS, LP, 29, 1)
    FIELD(REQ_SWRST_STATUS, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_STATUS, IOU, 27, 1)
    FIELD(REQ_SWRST_STATUS, USB0, 24, 1)
    FIELD(REQ_SWRST_STATUS, GEM1, 21, 1)
    FIELD(REQ_SWRST_STATUS, GEM0, 20, 1)
    FIELD(REQ_SWRST_STATUS, LS_R5, 18, 1)
    FIELD(REQ_SWRST_STATUS, APU, 4, 1)
    FIELD(REQ_SWRST_STATUS, ACPU1, 1, 1)
    FIELD(REQ_SWRST_STATUS, ACPU0, 0, 1)
REG32(REQ_SWRST_INT_MASK, 0x414)
    FIELD(REQ_SWRST_INT_MASK, FP, 30, 1)
    FIELD(REQ_SWRST_INT_MASK, LP, 29, 1)
    FIELD(REQ_SWRST_INT_MASK, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_INT_MASK, IOU, 27, 1)
    FIELD(REQ_SWRST_INT_MASK, USB0, 24, 1)
    FIELD(REQ_SWRST_INT_MASK, GEM1, 21, 1)
    FIELD(REQ_SWRST_INT_MASK, GEM0, 20, 1)
    FIELD(REQ_SWRST_INT_MASK, LS_R5, 18, 1)
    FIELD(REQ_SWRST_INT_MASK, APU, 4, 1)
    FIELD(REQ_SWRST_INT_MASK, ACPU1, 1, 1)
    FIELD(REQ_SWRST_INT_MASK, ACPU0, 0, 1)
REG32(REQ_SWRST_INT_EN, 0x418)
    FIELD(REQ_SWRST_INT_EN, FP, 30, 1)
    FIELD(REQ_SWRST_INT_EN, LP, 29, 1)
    FIELD(REQ_SWRST_INT_EN, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_INT_EN, IOU, 27, 1)
    FIELD(REQ_SWRST_INT_EN, USB0, 24, 1)
    FIELD(REQ_SWRST_INT_EN, GEM1, 21, 1)
    FIELD(REQ_SWRST_INT_EN, GEM0, 20, 1)
    FIELD(REQ_SWRST_INT_EN, LS_R5, 18, 1)
    FIELD(REQ_SWRST_INT_EN, APU, 4, 1)
    FIELD(REQ_SWRST_INT_EN, ACPU1, 1, 1)
    FIELD(REQ_SWRST_INT_EN, ACPU0, 0, 1)
REG32(REQ_SWRST_INT_DIS, 0x41c)
    FIELD(REQ_SWRST_INT_DIS, FP, 30, 1)
    FIELD(REQ_SWRST_INT_DIS, LP, 29, 1)
    FIELD(REQ_SWRST_INT_DIS, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_INT_DIS, IOU, 27, 1)
    FIELD(REQ_SWRST_INT_DIS, USB0, 24, 1)
    FIELD(REQ_SWRST_INT_DIS, GEM1, 21, 1)
    FIELD(REQ_SWRST_INT_DIS, GEM0, 20, 1)
    FIELD(REQ_SWRST_INT_DIS, LS_R5, 18, 1)
    FIELD(REQ_SWRST_INT_DIS, APU, 4, 1)
    FIELD(REQ_SWRST_INT_DIS, ACPU1, 1, 1)
    FIELD(REQ_SWRST_INT_DIS, ACPU0, 0, 1)
REG32(REQ_SWRST_TRIG, 0x420)
    FIELD(REQ_SWRST_TRIG, FP, 30, 1)
    FIELD(REQ_SWRST_TRIG, LP, 29, 1)
    FIELD(REQ_SWRST_TRIG, PS_ONLY, 28, 1)
    FIELD(REQ_SWRST_TRIG, IOU, 27, 1)
    FIELD(REQ_SWRST_TRIG, USB0, 24, 1)
    FIELD(REQ_SWRST_TRIG, GEM1, 21, 1)
    FIELD(REQ_SWRST_TRIG, GEM0, 20, 1)
    FIELD(REQ_SWRST_TRIG, LS_R5, 18, 1)
    FIELD(REQ_SWRST_TRIG, APU, 4, 1)
    FIELD(REQ_SWRST_TRIG, ACPU1, 1, 1)
    FIELD(REQ_SWRST_TRIG, ACPU0, 0, 1)
REG32(REQ_AUX_STATUS, 0x510)
    FIELD(REQ_AUX_STATUS, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_STATUS, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_INT_MASK, 0x514)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_INT_MASK, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_INT_EN, 0x518)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_INT_EN, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_INT_DIS, 0x51c)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_INT_DIS, SERV_REQ_0, 0, 1)
REG32(REQ_AUX_TRIG, 0x520)
    FIELD(REQ_AUX_TRIG, SERV_REQ_10, 17, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_9, 16, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_8, 13, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_7, 12, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_6, 10, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_5, 7, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_4, 6, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_3, 3, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_2, 2, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_1, 1, 1)
    FIELD(REQ_AUX_TRIG, SERV_REQ_0, 0, 1)
REG32(MB_FATAL, 0x52c)
    FIELD(MB_FATAL, CPU3, 2, 1)
    FIELD(MB_FATAL, CPU2, 1, 1)
    FIELD(MB_FATAL, CPU1, 0, 1)
REG32(MB1_FAULT_STATUS, 0x530)
    FIELD(MB1_FAULT_STATUS, CPU3, 14, 1)
    FIELD(MB1_FAULT_STATUS, CPU2, 13, 1)
    FIELD(MB1_FAULT_STATUS, CPU1, 12, 1)
    FIELD(MB1_FAULT_STATUS, FT_STATE, 10, 2)
    FIELD(MB1_FAULT_STATUS, WDT_EXP, 9, 1)
    FIELD(MB1_FAULT_STATUS, UNCORR_ERR, 8, 1)
    FIELD(MB1_FAULT_STATUS, VOTER_ERR, 7, 1)
    FIELD(MB1_FAULT_STATUS, FTL_MISMATCH, 4, 3)
    FIELD(MB1_FAULT_STATUS, LS_RECOVER, 3, 1)
    FIELD(MB1_FAULT_STATUS, LS_MISMATCH, 0, 3)
REG32(MB2_FAULT_STATUS, 0x534)
    FIELD(MB2_FAULT_STATUS, CPU3, 14, 1)
    FIELD(MB2_FAULT_STATUS, CPU2, 13, 1)
    FIELD(MB2_FAULT_STATUS, CPU1, 12, 1)
    FIELD(MB2_FAULT_STATUS, FT_STATE, 10, 2)
    FIELD(MB2_FAULT_STATUS, WDT_EXP, 9, 1)
    FIELD(MB2_FAULT_STATUS, UNCORR_ERR, 8, 1)
    FIELD(MB2_FAULT_STATUS, VOTER_ERR, 7, 1)
    FIELD(MB2_FAULT_STATUS, FTL_MISMATCH, 4, 3)
    FIELD(MB2_FAULT_STATUS, LS_RECOVER, 3, 1)
    FIELD(MB2_FAULT_STATUS, LS_MISMATCH, 0, 3)
REG32(MB3_FAULT_STATUS, 0x538)
    FIELD(MB3_FAULT_STATUS, CPU3, 14, 1)
    FIELD(MB3_FAULT_STATUS, CPU2, 13, 1)
    FIELD(MB3_FAULT_STATUS, CPU1, 12, 1)
    FIELD(MB3_FAULT_STATUS, FT_STATE, 10, 2)
    FIELD(MB3_FAULT_STATUS, WDT_EXP, 9, 1)
    FIELD(MB3_FAULT_STATUS, UNCORR_ERR, 8, 1)
    FIELD(MB3_FAULT_STATUS, VOTER_ERR, 7, 1)
    FIELD(MB3_FAULT_STATUS, FTL_MISMATCH, 4, 3)
    FIELD(MB3_FAULT_STATUS, LS_RECOVER, 3, 1)
    FIELD(MB3_FAULT_STATUS, LS_MISMATCH, 0, 3)
REG32(PSM_DEBUG_CTRL, 0x540)
    FIELD(PSM_DEBUG_CTRL, EN, 0, 1)
REG32(WAKEUP_IRQ_STATUS, 0x700)
    FIELD(WAKEUP_IRQ_STATUS, INTFPD, 27, 1)
    FIELD(WAKEUP_IRQ_STATUS, INTLPD, 26, 1)
    FIELD(WAKEUP_IRQ_STATUS, FPD_DBG, 25, 1)
    FIELD(WAKEUP_IRQ_STATUS, R5S_DBG, 24, 1)
    FIELD(WAKEUP_IRQ_STATUS, ACPU1_DBG, 21, 1)
    FIELD(WAKEUP_IRQ_STATUS, ACPU0_DBG, 20, 1)
    FIELD(WAKEUP_IRQ_STATUS, ACPU1_CORESIGHT, 17, 1)
    FIELD(WAKEUP_IRQ_STATUS, ACPU0_CORESIGHT, 16, 1)
    FIELD(WAKEUP_IRQ_STATUS, MIO5, 15, 1)
    FIELD(WAKEUP_IRQ_STATUS, MIO4, 14, 1)
    FIELD(WAKEUP_IRQ_STATUS, MIO3, 13, 1)
    FIELD(WAKEUP_IRQ_STATUS, MIO2, 12, 1)
    FIELD(WAKEUP_IRQ_STATUS, MIO1, 11, 1)
    FIELD(WAKEUP_IRQ_STATUS, MIO0, 10, 1)
    FIELD(WAKEUP_IRQ_STATUS, USB0, 6, 1)
    FIELD(WAKEUP_IRQ_STATUS, R51, 5, 1)
    FIELD(WAKEUP_IRQ_STATUS, R50, 4, 1)
    FIELD(WAKEUP_IRQ_STATUS, ACPU1, 1, 1)
    FIELD(WAKEUP_IRQ_STATUS, ACPU0, 0, 1)
REG32(WAKEUP_IRQ_MASK, 0x704)
    FIELD(WAKEUP_IRQ_MASK, INTFPD, 27, 1)
    FIELD(WAKEUP_IRQ_MASK, INTLPD, 26, 1)
    FIELD(WAKEUP_IRQ_MASK, FPD_DBG, 25, 1)
    FIELD(WAKEUP_IRQ_MASK, R5S_DBG, 24, 1)
    FIELD(WAKEUP_IRQ_MASK, ACPU1_DBG, 21, 1)
    FIELD(WAKEUP_IRQ_MASK, ACPU0_DBG, 20, 1)
    FIELD(WAKEUP_IRQ_MASK, ACPU1_CORESIGHT, 17, 1)
    FIELD(WAKEUP_IRQ_MASK, ACPU0_CORESIGHT, 16, 1)
    FIELD(WAKEUP_IRQ_MASK, MIO5, 15, 1)
    FIELD(WAKEUP_IRQ_MASK, MIO4, 14, 1)
    FIELD(WAKEUP_IRQ_MASK, MIO3, 13, 1)
    FIELD(WAKEUP_IRQ_MASK, MIO2, 12, 1)
    FIELD(WAKEUP_IRQ_MASK, MIO1, 11, 1)
    FIELD(WAKEUP_IRQ_MASK, MIO0, 10, 1)
    FIELD(WAKEUP_IRQ_MASK, USB0, 6, 1)
    FIELD(WAKEUP_IRQ_MASK, R51, 5, 1)
    FIELD(WAKEUP_IRQ_MASK, R50, 4, 1)
    FIELD(WAKEUP_IRQ_MASK, ACPU1, 1, 1)
    FIELD(WAKEUP_IRQ_MASK, ACPU0, 0, 1)
REG32(WAKEUP_IRQ_EN, 0x708)
    FIELD(WAKEUP_IRQ_EN, INTFPD, 27, 1)
    FIELD(WAKEUP_IRQ_EN, INTLPD, 26, 1)
    FIELD(WAKEUP_IRQ_EN, FPD_DBG, 25, 1)
    FIELD(WAKEUP_IRQ_EN, R5S_DBG, 24, 1)
    FIELD(WAKEUP_IRQ_EN, ACPU1_DBG, 21, 1)
    FIELD(WAKEUP_IRQ_EN, ACPU0_DBG, 20, 1)
    FIELD(WAKEUP_IRQ_EN, ACPU1_CORESIGHT, 17, 1)
    FIELD(WAKEUP_IRQ_EN, ACPU0_CORESIGHT, 16, 1)
    FIELD(WAKEUP_IRQ_EN, MIO5, 15, 1)
    FIELD(WAKEUP_IRQ_EN, MIO4, 14, 1)
    FIELD(WAKEUP_IRQ_EN, MIO3, 13, 1)
    FIELD(WAKEUP_IRQ_EN, MIO2, 12, 1)
    FIELD(WAKEUP_IRQ_EN, MIO1, 11, 1)
    FIELD(WAKEUP_IRQ_EN, MIO0, 10, 1)
    FIELD(WAKEUP_IRQ_EN, USB0, 6, 1)
    FIELD(WAKEUP_IRQ_EN, R51, 5, 1)
    FIELD(WAKEUP_IRQ_EN, R50, 4, 1)
    FIELD(WAKEUP_IRQ_EN, ACPU1, 1, 1)
    FIELD(WAKEUP_IRQ_EN, ACPU0, 0, 1)
REG32(WAKEUP_IRQ_DIS, 0x70c)
    FIELD(WAKEUP_IRQ_DIS, INTFPD, 27, 1)
    FIELD(WAKEUP_IRQ_DIS, INTLPD, 26, 1)
    FIELD(WAKEUP_IRQ_DIS, FPD_DBG, 25, 1)
    FIELD(WAKEUP_IRQ_DIS, R5S_DBG, 24, 1)
    FIELD(WAKEUP_IRQ_DIS, ACPU1_DBG, 21, 1)
    FIELD(WAKEUP_IRQ_DIS, ACPU0_DBG, 20, 1)
    FIELD(WAKEUP_IRQ_DIS, ACPU1_CORESIGHT, 17, 1)
    FIELD(WAKEUP_IRQ_DIS, ACPU0_CORESIGHT, 16, 1)
    FIELD(WAKEUP_IRQ_DIS, MIO5, 15, 1)
    FIELD(WAKEUP_IRQ_DIS, MIO4, 14, 1)
    FIELD(WAKEUP_IRQ_DIS, MIO3, 13, 1)
    FIELD(WAKEUP_IRQ_DIS, MIO2, 12, 1)
    FIELD(WAKEUP_IRQ_DIS, MIO1, 11, 1)
    FIELD(WAKEUP_IRQ_DIS, MIO0, 10, 1)
    FIELD(WAKEUP_IRQ_DIS, USB0, 6, 1)
    FIELD(WAKEUP_IRQ_DIS, R51, 5, 1)
    FIELD(WAKEUP_IRQ_DIS, R50, 4, 1)
    FIELD(WAKEUP_IRQ_DIS, ACPU1, 1, 1)
    FIELD(WAKEUP_IRQ_DIS, ACPU0, 0, 1)
REG32(WAKEUP_IRQ_TRIG, 0x710)
    FIELD(WAKEUP_IRQ_TRIG, INTFPD, 27, 1)
    FIELD(WAKEUP_IRQ_TRIG, INTLPD, 26, 1)
    FIELD(WAKEUP_IRQ_TRIG, FPD_DBG, 25, 1)
    FIELD(WAKEUP_IRQ_TRIG, R5S_DBG, 24, 1)
    FIELD(WAKEUP_IRQ_TRIG, ACPU1_DBG, 21, 1)
    FIELD(WAKEUP_IRQ_TRIG, ACPU0_DBG, 20, 1)
    FIELD(WAKEUP_IRQ_TRIG, ACPU1_CORESIGHT, 17, 1)
    FIELD(WAKEUP_IRQ_TRIG, ACPU0_CORESIGHT, 16, 1)
    FIELD(WAKEUP_IRQ_TRIG, MIO5, 15, 1)
    FIELD(WAKEUP_IRQ_TRIG, MIO4, 14, 1)
    FIELD(WAKEUP_IRQ_TRIG, MIO3, 13, 1)
    FIELD(WAKEUP_IRQ_TRIG, MIO2, 12, 1)
    FIELD(WAKEUP_IRQ_TRIG, MIO1, 11, 1)
    FIELD(WAKEUP_IRQ_TRIG, MIO0, 10, 1)
    FIELD(WAKEUP_IRQ_TRIG, USB0, 6, 1)
    FIELD(WAKEUP_IRQ_TRIG, R51, 5, 1)
    FIELD(WAKEUP_IRQ_TRIG, R50, 4, 1)
    FIELD(WAKEUP_IRQ_TRIG, ACPU1, 1, 1)
    FIELD(WAKEUP_IRQ_TRIG, ACPU0, 0, 1)
REG32(PWR_CTRL_IRQ_STATUS, 0x714)
    FIELD(PWR_CTRL_IRQ_STATUS, FPD_SUPPLY, 24, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, APU1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, APU0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, APU1_RST, 17, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, APU0_RST, 16, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, RPU0_DBG, 8, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, R51, 5, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, R50, 4, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, ACPU1, 1, 1)
    FIELD(PWR_CTRL_IRQ_STATUS, ACPU0, 0, 1)
REG32(PWR_CTRL_IRQ_MASK, 0x718)
    FIELD(PWR_CTRL_IRQ_MASK, FPD_SUPPLY, 24, 1)
    FIELD(PWR_CTRL_IRQ_MASK, APU1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL_IRQ_MASK, APU0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL_IRQ_MASK, APU1_RST, 17, 1)
    FIELD(PWR_CTRL_IRQ_MASK, APU0_RST, 16, 1)
    FIELD(PWR_CTRL_IRQ_MASK, RPU0_DBG, 8, 1)
    FIELD(PWR_CTRL_IRQ_MASK, R51, 5, 1)
    FIELD(PWR_CTRL_IRQ_MASK, R50, 4, 1)
    FIELD(PWR_CTRL_IRQ_MASK, ACPU1, 1, 1)
    FIELD(PWR_CTRL_IRQ_MASK, ACPU0, 0, 1)
REG32(PWR_CTRL_IRQ_EN, 0x71c)
    FIELD(PWR_CTRL_IRQ_EN, FPD_SUPPLY, 24, 1)
    FIELD(PWR_CTRL_IRQ_EN, APU1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL_IRQ_EN, APU0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL_IRQ_EN, APU1_RST, 17, 1)
    FIELD(PWR_CTRL_IRQ_EN, APU0_RST, 16, 1)
    FIELD(PWR_CTRL_IRQ_EN, RPU0_DBG, 8, 1)
    FIELD(PWR_CTRL_IRQ_EN, R51, 5, 1)
    FIELD(PWR_CTRL_IRQ_EN, R50, 4, 1)
    FIELD(PWR_CTRL_IRQ_EN, ACPU1, 1, 1)
    FIELD(PWR_CTRL_IRQ_EN, ACPU0, 0, 1)
REG32(PWR_CTRL_IRQ_DIS, 0x720)
    FIELD(PWR_CTRL_IRQ_DIS, FPD_SUPPLY, 24, 1)
    FIELD(PWR_CTRL_IRQ_DIS, APU1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL_IRQ_DIS, APU0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL_IRQ_DIS, APU1_RST, 17, 1)
    FIELD(PWR_CTRL_IRQ_DIS, APU0_RST, 16, 1)
    FIELD(PWR_CTRL_IRQ_DIS, RPU0_DBG, 8, 1)
    FIELD(PWR_CTRL_IRQ_DIS, R51, 5, 1)
    FIELD(PWR_CTRL_IRQ_DIS, R50, 4, 1)
    FIELD(PWR_CTRL_IRQ_DIS, ACPU1, 1, 1)
    FIELD(PWR_CTRL_IRQ_DIS, ACPU0, 0, 1)
REG32(PWR_CTRL_IRQ_TRIG, 0x724)
    FIELD(PWR_CTRL_IRQ_TRIG, FPD_SUPPLY, 24, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, APU1_DBG_RST, 21, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, APU0_DBG_RST, 20, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, APU1_RST, 17, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, APU0_RST, 16, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, RPU0_DBG, 8, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, R51, 5, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, R50, 4, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, ACPU1, 1, 1)
    FIELD(PWR_CTRL_IRQ_TRIG, ACPU0, 0, 1)
REG32(DBG_PWR_ACK, 0x808)
    FIELD(DBG_PWR_ACK, FPD, 3, 1)
    FIELD(DBG_PWR_ACK, R5S, 2, 1)
    FIELD(DBG_PWR_ACK, A72_1, 1, 1)
    FIELD(DBG_PWR_ACK, A72_0, 0, 1)
REG32(MBIST_RSTN, 0x900)
    FIELD(MBIST_RSTN, INT_FPD, 4, 1)
    FIELD(MBIST_RSTN, CCI, 3, 1)
    FIELD(MBIST_RSTN, CPU1, 2, 1)
    FIELD(MBIST_RSTN, CPU0, 1, 1)
    FIELD(MBIST_RSTN, APU, 0, 1)
REG32(MBIST_PG_EN, 0x904)
    FIELD(MBIST_PG_EN, INT_FPD, 4, 1)
    FIELD(MBIST_PG_EN, CCI, 3, 1)
    FIELD(MBIST_PG_EN, CPU1, 2, 1)
    FIELD(MBIST_PG_EN, CPU0, 1, 1)
    FIELD(MBIST_PG_EN, APU, 0, 1)
REG32(MBIST_SETUP, 0x908)
    FIELD(MBIST_SETUP, INT_FPD, 4, 1)
    FIELD(MBIST_SETUP, CCI, 3, 1)
    FIELD(MBIST_SETUP, CPU1, 2, 1)
    FIELD(MBIST_SETUP, CPU0, 1, 1)
    FIELD(MBIST_SETUP, APU, 0, 1)
REG32(MBIST_DONE, 0x910)
    FIELD(MBIST_DONE, INT_FPD, 4, 1)
    FIELD(MBIST_DONE, CCI, 3, 1)
    FIELD(MBIST_DONE, CPU1, 2, 1)
    FIELD(MBIST_DONE, CPU0, 1, 1)
    FIELD(MBIST_DONE, APU, 0, 1)
REG32(MBIST_GO, 0x914)
    FIELD(MBIST_GO, INT_FPD, 4, 1)
    FIELD(MBIST_GO, CCI, 3, 1)
    FIELD(MBIST_GO, CPU1, 2, 1)
    FIELD(MBIST_GO, CPU0, 1, 1)
    FIELD(MBIST_GO, APU, 0, 1)
REG32(SCAN_CLEAR_CPU0, 0x920)
    FIELD(SCAN_CLEAR_CPU0, PASS, 2, 1)
    FIELD(SCAN_CLEAR_CPU0, DONE, 1, 1)
    FIELD(SCAN_CLEAR_CPU0, TRIGGER, 0, 1)
REG32(SCAN_CLEAR_CPU1, 0x924)
    FIELD(SCAN_CLEAR_CPU1, PASS, 2, 1)
    FIELD(SCAN_CLEAR_CPU1, DONE, 1, 1)
    FIELD(SCAN_CLEAR_CPU1, TRIGGER, 0, 1)
REG32(SCAN_CLEAR_APU, 0x928)
    FIELD(SCAN_CLEAR_APU, PASS, 2, 1)
    FIELD(SCAN_CLEAR_APU, DONE, 1, 1)
    FIELD(SCAN_CLEAR_APU, TRIGGER, 0, 1)
REG32(SCAN_CLEAR_FPD, 0x92c)
    FIELD(SCAN_CLEAR_FPD, PASS, 2, 1)
    FIELD(SCAN_CLEAR_FPD, DONE, 1, 1)
    FIELD(SCAN_CLEAR_FPD, TRIGGER, 0, 1)
REG32(SAFETY_CHK, 0xa00)

#define PSM_GLOBAL_REG_R_MAX (R_SAFETY_CHK + 1)

typedef struct PSM_GLOBAL_REG {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_req_pwrdwn_int;
    qemu_irq irq_wakeup_irq;
    qemu_irq irq_req_swrst_int;
    qemu_irq irq_req_pwrup_int;
    qemu_irq irq_req_aux_int;
    qemu_irq irq_addr_error_int;
    qemu_irq irq_pwr_ctrl_irq;
    qemu_irq irq_req_iso_int;

    uint32_t regs[PSM_GLOBAL_REG_R_MAX];
    RegisterInfo regs_info[PSM_GLOBAL_REG_R_MAX];
} PSM_GLOBAL_REG;

static void req_pwrdwn_int_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending;

    pending = s->regs[R_REQ_PWRDWN_STATUS] & ~s->regs[R_REQ_PWRDWN_INT_MASK];
    qemu_set_irq(s->irq_req_pwrdwn_int, pending);
}

static void req_pwrdwn_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    req_pwrdwn_int_update_irq(s);
}

static uint64_t req_pwrdwn_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN_INT_MASK] &= ~val;
    req_pwrdwn_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN_INT_MASK] |= val;
    req_pwrdwn_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrdwn_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRDWN_STATUS] |= val;
    req_pwrdwn_int_update_irq(s);
    return 0;
}

static void wakeup_irq_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending = s->regs[R_WAKEUP_IRQ_STATUS] & ~s->regs[R_WAKEUP_IRQ_MASK];
    qemu_set_irq(s->irq_wakeup_irq, pending);
}

static void wakeup_irq_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    wakeup_irq_update_irq(s);
}

static uint64_t wakeup_irq_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP_IRQ_MASK] &= ~val;
    wakeup_irq_update_irq(s);
    return 0;
}

static uint64_t wakeup_irq_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP_IRQ_MASK] |= val;
    wakeup_irq_update_irq(s);
    return 0;
}

static uint64_t wakeup_irq_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_WAKEUP_IRQ_STATUS] |= val;
    wakeup_irq_update_irq(s);
    return 0;
}

static void req_swrst_int_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_SWRST_STATUS] & ~s->regs[R_REQ_SWRST_INT_MASK];
    qemu_set_irq(s->irq_req_swrst_int, pending);
}

static void req_swrst_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    req_swrst_int_update_irq(s);
}

static uint64_t req_swrst_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_INT_MASK] &= ~val;
    req_swrst_int_update_irq(s);
    return 0;
}

static uint64_t req_swrst_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_INT_MASK] |= val;
    req_swrst_int_update_irq(s);
    return 0;
}

static uint64_t req_swrst_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_SWRST_STATUS] |= val;
    req_swrst_int_update_irq(s);
    return 0;
}

static void req_pwrup_int_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_PWRUP_STATUS] & ~s->regs[R_REQ_PWRUP_INT_MASK];
    qemu_set_irq(s->irq_req_pwrup_int, pending);
}

static void req_pwrup_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    req_pwrup_int_update_irq(s);
}

static uint64_t req_pwrup_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP_INT_MASK] &= ~val;
    req_pwrup_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP_INT_MASK] |= val;
    req_pwrup_int_update_irq(s);
    return 0;
}

static uint64_t req_pwrup_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_PWRUP_STATUS] |= val;
    req_pwrup_int_update_irq(s);
    return 0;
}

static void req_aux_int_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_AUX_STATUS] & ~s->regs[R_REQ_AUX_INT_MASK];
    qemu_set_irq(s->irq_req_aux_int, pending);
}

static void req_aux_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    req_aux_int_update_irq(s);
}

static uint64_t req_aux_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_AUX_INT_MASK] &= ~val;
    req_aux_int_update_irq(s);
    return 0;
}

static uint64_t req_aux_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_AUX_INT_MASK] |= val;
    req_aux_int_update_irq(s);
    return 0;
}

static uint64_t req_aux_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_AUX_STATUS] |= val;
    req_aux_int_update_irq(s);
    return 0;
}

static void addr_error_int_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending;

    pending = s->regs[R_ADDR_ERROR_STATUS] & ~s->regs[R_ADDR_ERROR_INT_MASK];
    qemu_set_irq(s->irq_addr_error_int, pending);
}

static void addr_error_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    addr_error_int_update_irq(s);
}

static uint64_t addr_error_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] &= ~val;
    addr_error_int_update_irq(s);
    return 0;
}

static uint64_t addr_error_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_ADDR_ERROR_INT_MASK] |= val;
    addr_error_int_update_irq(s);
    return 0;
}

static void pwr_ctrl_irq_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending;

    pending = s->regs[R_PWR_CTRL_IRQ_STATUS] & ~s->regs[R_PWR_CTRL_IRQ_MASK];
    qemu_set_irq(s->irq_pwr_ctrl_irq, pending);
}

static void pwr_ctrl_irq_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    pwr_ctrl_irq_update_irq(s);
}

static uint64_t pwr_ctrl_irq_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL_IRQ_MASK] &= ~val;
    pwr_ctrl_irq_update_irq(s);
    return 0;
}

static uint64_t pwr_ctrl_irq_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL_IRQ_MASK] |= val;
    pwr_ctrl_irq_update_irq(s);
    return 0;
}

static uint64_t pwr_ctrl_irq_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_PWR_CTRL_IRQ_STATUS] |= val;
    pwr_ctrl_irq_update_irq(s);
    return 0;
}

static void req_iso_int_update_irq(PSM_GLOBAL_REG *s)
{
    bool pending = s->regs[R_REQ_ISO_STATUS] & ~s->regs[R_REQ_ISO_INT_MASK];
    qemu_set_irq(s->irq_req_iso_int, pending);
}

static void req_iso_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    req_iso_int_update_irq(s);
}

static uint64_t req_iso_int_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_INT_MASK] &= ~val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t req_iso_int_dis_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_INT_MASK] |= val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t req_iso_trig_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;

    s->regs[R_REQ_ISO_STATUS] |= val;
    req_iso_int_update_irq(s);
    return 0;
}

static uint64_t scan_clear_fpd_prew(RegisterInfo *reg, uint64_t val64)
{
    uint32_t val = (uint32_t)val64;

    /*
     * Do a scan. It's always good.
     * SCAN_CLEAR_FPD.TRIGGGER is WO, so clear that bit and set the others.
     */
    if (FIELD_EX32(val, SCAN_CLEAR_FPD, TRIGGER)) {
        val = 0;
        val = FIELD_DP32(val, SCAN_CLEAR_FPD, PASS, 1);
        val = FIELD_DP32(val, SCAN_CLEAR_FPD, DONE, 1);
    }

    return val;
}

#define MBIST_TRIG(dev)                                      \
    if (FIELD_EX32(val, MBIST_PG_EN, dev) &&                 \
        !FIELD_EX32(curr_regval, MBIST_PG_EN, dev)) {        \
        setup = ARRAY_FIELD_EX32(s->regs, MBIST_SETUP, dev); \
        rst = !ARRAY_FIELD_EX32(s->regs, MBIST_RSTN, dev);   \
        if (setup && !rst) {                                 \
            ARRAY_FIELD_DP32(s->regs, MBIST_DONE, dev, 1);   \
            ARRAY_FIELD_DP32(s->regs, MBIST_GO, dev, 1);     \
        }                                                    \
    }

static uint64_t mbist_pg_en_prew(RegisterInfo *reg, uint64_t val64)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(reg->opaque);
    uint32_t val = val64;
    uint32_t curr_regval = s->regs[R_MBIST_PG_EN];
    bool rst;
    bool setup;

    /* Trigger MBIST if we're going from 0 -> 1 */
    MBIST_TRIG(INT_FPD);
    MBIST_TRIG(CCI);
    MBIST_TRIG(CPU0);
    MBIST_TRIG(CPU1);
    MBIST_TRIG(APU);

    return val;
}

static const RegisterAccessInfo psm_global_reg_regs_info[] = {
    {   .name = "GLOBAL_CNTRL",  .addr = A_GLOBAL_CNTRL,
        .reset = 0x8800,
        .rsvd = 0xfff800ed,
        .ro = 0xfffb00ed,
    },{ .name = "APU_PWR_STATUS_INIT",  .addr = A_APU_PWR_STATUS_INIT,
        .rsvd = 0xfffffffc,
        .ro = 0xfffffffc,
    },{ .name = "ADDR_ERROR_STATUS",  .addr = A_ADDR_ERROR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = addr_error_status_postw,
    },{ .name = "ADDR_ERROR_INT_MASK",  .addr = A_ADDR_ERROR_INT_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "ADDR_ERROR_INT_EN",  .addr = A_ADDR_ERROR_INT_EN,
        .pre_write = addr_error_int_en_prew,
    },{ .name = "ADDR_ERROR_INT_DIS",  .addr = A_ADDR_ERROR_INT_DIS,
        .pre_write = addr_error_int_dis_prew,
    },{ .name = "PS_SW_ERR",  .addr = A_PS_SW_ERR,
    },{ .name = "PSM_BOOT_SERV_ERR",  .addr = A_PSM_BOOT_SERV_ERR,
    },{ .name = "GLOBAL_GEN_STORAGE0",  .addr = A_GLOBAL_GEN_STORAGE0,
    },{ .name = "GLOBAL_GEN_STORAGE1",  .addr = A_GLOBAL_GEN_STORAGE1,
    },{ .name = "GLOBAL_GEN_STORAGE2",  .addr = A_GLOBAL_GEN_STORAGE2,
    },{ .name = "GLOBAL_GEN_STORAGE3",  .addr = A_GLOBAL_GEN_STORAGE3,
    },{ .name = "GLOBAL_GEN_STORAGE4",  .addr = A_GLOBAL_GEN_STORAGE4,
    },{ .name = "GLOBAL_GEN_STORAGE5",  .addr = A_GLOBAL_GEN_STORAGE5,
    },{ .name = "GLOBAL_GEN_STORAGE6",  .addr = A_GLOBAL_GEN_STORAGE6,
    },{ .name = "GLOBAL_GEN_STORAGE7",  .addr = A_GLOBAL_GEN_STORAGE7,
    },{ .name = "PERS_GLOB_GEN_STORAGE0",  .addr = A_PERS_GLOB_GEN_STORAGE0,
    },{ .name = "PERS_GLOB_GEN_STORAGE1",  .addr = A_PERS_GLOB_GEN_STORAGE1,
    },{ .name = "PERS_GLOB_GEN_STORAGE2",  .addr = A_PERS_GLOB_GEN_STORAGE2,
    },{ .name = "PERS_GLOB_GEN_STORAGE3",  .addr = A_PERS_GLOB_GEN_STORAGE3,
    },{ .name = "PERS_GLOB_GEN_STORAGE4",  .addr = A_PERS_GLOB_GEN_STORAGE4,
    },{ .name = "PERS_GLOB_GEN_STORAGE5",  .addr = A_PERS_GLOB_GEN_STORAGE5,
    },{ .name = "PERS_GLOB_GEN_STORAGE6",  .addr = A_PERS_GLOB_GEN_STORAGE6,
    },{ .name = "PERS_GLOB_GEN_STORAGE7",  .addr = A_PERS_GLOB_GEN_STORAGE7,
    },{ .name = "PWR_STATE",  .addr = A_PWR_STATE,
        .reset = 0x3ffc83,
        .rsvd = 0xff80037c,
        .ro = 0xffffffff,
    },{ .name = "AUX_PWR_STATE",  .addr = A_AUX_PWR_STATE,
        .reset = 0xff080,
        .rsvd = 0xc7f00f7f,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP_STATUS",  .addr = A_REQ_PWRUP_STATUS,
        .rsvd = 0xff800b7c,
        .w1c = 0xffffffff,
        .post_write = req_pwrup_status_postw,
    },{ .name = "REQ_PWRUP_INT_MASK",  .addr = A_REQ_PWRUP_INT_MASK,
        .reset = 0x7ff483,
        .rsvd = 0xff800b7c,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRUP_INT_EN",  .addr = A_REQ_PWRUP_INT_EN,
        .rsvd = 0xff800b7c,
        .pre_write = req_pwrup_int_en_prew,
    },{ .name = "REQ_PWRUP_INT_DIS",  .addr = A_REQ_PWRUP_INT_DIS,
        .rsvd = 0xff800b7c,
        .pre_write = req_pwrup_int_dis_prew,
    },{ .name = "REQ_PWRUP_TRIG",  .addr = A_REQ_PWRUP_TRIG,
        .rsvd = 0xff800b7c,
        .pre_write = req_pwrup_trig_prew,
    },{ .name = "REQ_PWRDWN_STATUS",  .addr = A_REQ_PWRDWN_STATUS,
        .rsvd = 0xff800b7c,
        .w1c = 0xffffffff,
        .post_write = req_pwrdwn_status_postw,
    },{ .name = "REQ_PWRDWN_INT_MASK",  .addr = A_REQ_PWRDWN_INT_MASK,
        .reset = 0x7ff483,
        .rsvd = 0xff800b7c,
        .ro = 0xffffffff,
    },{ .name = "REQ_PWRDWN_INT_EN",  .addr = A_REQ_PWRDWN_INT_EN,
        .rsvd = 0xff800b7c,
        .pre_write = req_pwrdwn_int_en_prew,
    },{ .name = "REQ_PWRDWN_INT_DIS",  .addr = A_REQ_PWRDWN_INT_DIS,
        .rsvd = 0xff800b7c,
        .pre_write = req_pwrdwn_int_dis_prew,
    },{ .name = "REQ_PWRDWN_TRIG",  .addr = A_REQ_PWRDWN_TRIG,
        .rsvd = 0xff800b7c,
        .pre_write = req_pwrdwn_trig_prew,
    },{ .name = "REQ_ISO_STATUS",  .addr = A_REQ_ISO_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = req_iso_status_postw,
    },{ .name = "REQ_ISO_INT_MASK",  .addr = A_REQ_ISO_INT_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "REQ_ISO_INT_EN",  .addr = A_REQ_ISO_INT_EN,
        .pre_write = req_iso_int_en_prew,
    },{ .name = "REQ_ISO_INT_DIS",  .addr = A_REQ_ISO_INT_DIS,
        .pre_write = req_iso_int_dis_prew,
    },{ .name = "REQ_ISO_TRIG",  .addr = A_REQ_ISO_TRIG,
        .pre_write = req_iso_trig_prew,
    },{ .name = "REQ_SWRST_STATUS",  .addr = A_REQ_SWRST_STATUS,
        .rsvd = 0x86cbffec,
        .ro = 0x86cbffec,
        .w1c = 0x79340013,
        .post_write = req_swrst_status_postw,
    },{ .name = "REQ_SWRST_INT_MASK",  .addr = A_REQ_SWRST_INT_MASK,
        .reset = 0x79340013,
        .rsvd = 0x86cbffec,
        .ro = 0xffffffff,
    },{ .name = "REQ_SWRST_INT_EN",  .addr = A_REQ_SWRST_INT_EN,
        .pre_write = req_swrst_int_en_prew,
    },{ .name = "REQ_SWRST_INT_DIS",  .addr = A_REQ_SWRST_INT_DIS,
        .pre_write = req_swrst_int_dis_prew,
    },{ .name = "REQ_SWRST_TRIG",  .addr = A_REQ_SWRST_TRIG,
        .pre_write = req_swrst_trig_prew,
    },{ .name = "REQ_AUX_STATUS",  .addr = A_REQ_AUX_STATUS,
        .rsvd = 0xfffccb30,
        .ro = 0xfffccb30,
        .w1c = 0x334cf,
        .post_write = req_aux_status_postw,
    },{ .name = "REQ_AUX_INT_MASK",  .addr = A_REQ_AUX_INT_MASK,
        .reset = 0x334cf,
        .rsvd = 0xfffccb30,
        .ro = 0xffffffff,
    },{ .name = "REQ_AUX_INT_EN",  .addr = A_REQ_AUX_INT_EN,
        .pre_write = req_aux_int_en_prew,
    },{ .name = "REQ_AUX_INT_DIS",  .addr = A_REQ_AUX_INT_DIS,
        .pre_write = req_aux_int_dis_prew,
    },{ .name = "REQ_AUX_TRIG",  .addr = A_REQ_AUX_TRIG,
        .pre_write = req_aux_trig_prew,
    },{ .name = "MB_FATAL",  .addr = A_MB_FATAL,
        .rsvd = 0xfffff8,
        .ro = 0xffffff,
    },{ .name = "MB1_FAULT_STATUS",  .addr = A_MB1_FAULT_STATUS,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "MB2_FAULT_STATUS",  .addr = A_MB2_FAULT_STATUS,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "MB3_FAULT_STATUS",  .addr = A_MB3_FAULT_STATUS,
        .rsvd = 0xffff8000,
        .ro = 0xffffffff,
    },{ .name = "PSM_DEBUG_CTRL",  .addr = A_PSM_DEBUG_CTRL,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "WAKEUP_IRQ_STATUS",  .addr = A_WAKEUP_IRQ_STATUS,
        .rsvd = 0xf0cc038c,
        .w1c = 0xffffffff,
        .post_write = wakeup_irq_status_postw,
    },{ .name = "WAKEUP_IRQ_MASK",  .addr = A_WAKEUP_IRQ_MASK,
        .reset = 0xf33fc73,
        .rsvd = 0xf0cc038c,
        .ro = 0xffffffff,
    },{ .name = "WAKEUP_IRQ_EN",  .addr = A_WAKEUP_IRQ_EN,
        .rsvd = 0xf0cc038c,
        .pre_write = wakeup_irq_en_prew,
    },{ .name = "WAKEUP_IRQ_DIS",  .addr = A_WAKEUP_IRQ_DIS,
        .rsvd = 0xf0cc038c,
        .pre_write = wakeup_irq_dis_prew,
    },{ .name = "WAKEUP_IRQ_TRIG",  .addr = A_WAKEUP_IRQ_TRIG,
        .rsvd = 0xf0cc038c,
        .pre_write = wakeup_irq_trig_prew,
    },{ .name = "PWR_CTRL_IRQ_STATUS",  .addr = A_PWR_CTRL_IRQ_STATUS,
        .rsvd = 0xfeccfecc,
        .ro = 0xfeccfecc,
        .w1c = 0x1330133,
        .post_write = pwr_ctrl_irq_status_postw,
    },{ .name = "PWR_CTRL_IRQ_MASK",  .addr = A_PWR_CTRL_IRQ_MASK,
        .reset = 0x1330133,
        .rsvd = 0xfeccfecc,
        .ro = 0xffffffff,
    },{ .name = "PWR_CTRL_IRQ_EN",  .addr = A_PWR_CTRL_IRQ_EN,
        .rsvd = 0xfeccfecc,
        .pre_write = pwr_ctrl_irq_en_prew,
    },{ .name = "PWR_CTRL_IRQ_DIS",  .addr = A_PWR_CTRL_IRQ_DIS,
        .rsvd = 0xfeccfecc,
        .pre_write = pwr_ctrl_irq_dis_prew,
    },{ .name = "PWR_CTRL_IRQ_TRIG",  .addr = A_PWR_CTRL_IRQ_TRIG,
        .rsvd = 0xfeccfecc,
        .pre_write = pwr_ctrl_irq_trig_prew,
    },{ .name = "DBG_PWR_ACK",  .addr = A_DBG_PWR_ACK,
        .rsvd = 0xfffffff0,
    },{ .name = "MBIST_RSTN",  .addr = A_MBIST_RSTN,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffe0,
    },{ .name = "MBIST_PG_EN",  .addr = A_MBIST_PG_EN,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffe0,
        .pre_write = mbist_pg_en_prew,
    },{ .name = "MBIST_SETUP",  .addr = A_MBIST_SETUP,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffe0,
    },{ .name = "MBIST_DONE",  .addr = A_MBIST_DONE,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "MBIST_GO",  .addr = A_MBIST_GO,
        .rsvd = 0xffffffe0,
        .ro = 0xffffffff,
    },{ .name = "SCAN_CLEAR_CPU0",  .addr = A_SCAN_CLEAR_CPU0,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffffe,
    },{ .name = "SCAN_CLEAR_CPU1",  .addr = A_SCAN_CLEAR_CPU1,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffffe,
    },{ .name = "SCAN_CLEAR_APU",  .addr = A_SCAN_CLEAR_APU,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffffe,
    },{ .name = "SCAN_CLEAR_FPD",  .addr = A_SCAN_CLEAR_FPD,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffffe,
        .pre_write = scan_clear_fpd_prew,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    }
};

static void psm_global_reg_reset(DeviceState *dev)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(dev);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }

    req_pwrdwn_int_update_irq(s);
    wakeup_irq_update_irq(s);
    req_swrst_int_update_irq(s);
    req_pwrup_int_update_irq(s);
    req_aux_int_update_irq(s);
    addr_error_int_update_irq(s);
    pwr_ctrl_irq_update_irq(s);
    req_iso_int_update_irq(s);
}

static const MemoryRegionOps psm_global_reg_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void pwr_state_h(void *opaque, int n, int level)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(opaque);

    s->regs[R_PWR_STATE] = deposit32(s->regs[R_PWR_STATE], n, 1, level);
}

static void aux_pwr_state_h(void *opaque, int n, int level)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(opaque);

    s->regs[R_AUX_PWR_STATE] = deposit32(s->regs[R_AUX_PWR_STATE],
                                         n, 1, level);
}

static void pwr_ctrl_h(void *opaque, int n, int level)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(opaque);

    /* Don't clear the fields as they are w1c */
    s->regs[R_PWR_CTRL_IRQ_STATUS] |= (level << n);
    pwr_ctrl_irq_update_irq(s);
}

static void apu_wake_up_req_h(void *opaque, int n, int level)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(opaque);

    s->regs[R_WAKEUP_IRQ_STATUS] |= ((level ? 1 : 0) << n);
    wakeup_irq_update_irq(s);
}

static void rpu_wake_up_req_h(void *opaque, int n, int level)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(opaque);

    s->regs[R_WAKEUP_IRQ_STATUS] |= ((level ? 1 : 0) << (n + 4));
    wakeup_irq_update_irq(s);
}

static void psm_global_reg_init(Object *obj)
{
    PSM_GLOBAL_REG *s = XILINX_PSM_GLOBAL_REG(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSM_GLOBAL_REG,
                       PSM_GLOBAL_REG_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psm_global_reg_regs_info,
                              ARRAY_SIZE(psm_global_reg_regs_info),
                              s->regs_info, s->regs,
                              &psm_global_reg_ops,
                              XILINX_PSM_GLOBAL_REG_ERR_DEBUG,
                              PSM_GLOBAL_REG_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_req_pwrdwn_int);
    sysbus_init_irq(sbd, &s->irq_wakeup_irq);
    sysbus_init_irq(sbd, &s->irq_req_swrst_int);
    sysbus_init_irq(sbd, &s->irq_req_pwrup_int);
    sysbus_init_irq(sbd, &s->irq_pwr_ctrl_irq);
    sysbus_init_irq(sbd, &s->irq_req_iso_int);
    sysbus_init_irq(sbd, &s->irq_addr_error_int);
    sysbus_init_irq(sbd, &s->irq_req_aux_int);

    qdev_init_gpio_in_named(DEVICE(obj), pwr_state_h, "pwr-state", 32);
    qdev_init_gpio_in_named(DEVICE(obj), aux_pwr_state_h, "aux-pwr-state", 32);
    qdev_init_gpio_in_named(DEVICE(obj), pwr_ctrl_h, "pwr-ctrl", 6);
    qdev_init_gpio_in_named(DEVICE(obj), apu_wake_up_req_h,
                            "apu-wakeup-req", 2);
    qdev_init_gpio_in_named(DEVICE(obj), rpu_wake_up_req_h,
                            "rpu-wakeup-req", 2);
}

static const VMStateDescription vmstate_psm_global_reg = {
    .name = TYPE_XILINX_PSM_GLOBAL_REG,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PSM_GLOBAL_REG, PSM_GLOBAL_REG_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet psm_client_gpios[] = {
    {
      .names = &fdt_generic_gpio_name_set_gpio,
      .gpios = (FDTGenericGPIOConnection[]) {
        { .name = "pwr-state", .fdt_index = 0, .range = 32 },
        { .name = "aux-pwr-state", .fdt_index = 32, .range = 32 },
        { .name = "pwr-ctrl", .fdt_index = 64, .range = 6},
        /* Wake up request input from the APU GIC.  */
        { .name = "apu-wakeup-req", .fdt_index = 70, .range = 2},
        { },
      },
    },
    { },
};

static const FDTGenericGPIOSet psm_controller_gpios[] = {
    {
      .names = &fdt_generic_gpio_name_set_gpio,
      .gpios = (FDTGenericGPIOConnection[]) {
        /*
         * Wake up request input from the RPU int-redirect, stay at index 4
         * for backward compatibility.
         */
        { .name = "rpu-wakeup-req", .fdt_index = 4, .range = 2},
        { },
      },
    },
    { },
};

static void psm_global_reg_class_init(ObjectClass *klass, void *data)
{
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->reset = psm_global_reg_reset;
    dc->vmsd = &vmstate_psm_global_reg;
    fggc->client_gpios = psm_client_gpios;
    fggc->controller_gpios = psm_controller_gpios;
}

static const TypeInfo psm_global_reg_info = {
    .name          = TYPE_XILINX_PSM_GLOBAL_REG,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PSM_GLOBAL_REG),
    .class_init    = psm_global_reg_class_init,
    .instance_init = psm_global_reg_init,
    .interfaces    = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void psm_global_reg_register_types(void)
{
    type_register_static(&psm_global_reg_info);
}

type_init(psm_global_reg_register_types)
