/*
 * QEMU model of the AIE2P_S_NPI NPI registers for AIE2PS
 *
 * Copyright (c) 2025 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2025-01-01.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_AIE2P_S_NPI_ERR_DEBUG
#define XILINX_AIE2P_S_NPI_ERR_DEBUG 0
#endif

#define TYPE_XILINX_AIE2P_S_NPI "xlnx.aie2p_s_npi"

#define XILINX_AIE2P_S_NPI(obj) \
     OBJECT_CHECK(AIE2P_S_NPI, (obj), TYPE_XILINX_AIE2P_S_NPI)

REG32(REG_PCSR_MASK, 0x0)
REG32(REG_PCSR_CONTROL, 0x4)
REG32(REG_PCSR_STATUS, 0x8)
REG32(REG_PCSR_LOCK, 0xc)
REG32(ME_ISR, 0x30)
    FIELD(ME_ISR, INTERRUPT4, 3, 1)
    FIELD(ME_ISR, INTERRUPT3, 2, 1)
    FIELD(ME_ISR, INTERRUPT2, 1, 1)
    FIELD(ME_ISR, INTERRUPT1, 0, 1)
REG32(ME_ITR, 0x34)
    FIELD(ME_ITR, INTERRUPT4, 3, 1)
    FIELD(ME_ITR, INTERRUPT3, 2, 1)
    FIELD(ME_ITR, INTERRUPT2, 1, 1)
    FIELD(ME_ITR, INTERRUPT1, 0, 1)
REG32(ME_IMR0, 0x38)
    FIELD(ME_IMR0, INTERRUPT4, 3, 1)
    FIELD(ME_IMR0, INTERRUPT3, 2, 1)
    FIELD(ME_IMR0, INTERRUPT2, 1, 1)
    FIELD(ME_IMR0, INTERRUPT1, 0, 1)
REG32(ME_IER0, 0x3c)
    FIELD(ME_IER0, INTERRUPT4, 3, 1)
    FIELD(ME_IER0, INTERRUPT3, 2, 1)
    FIELD(ME_IER0, INTERRUPT2, 1, 1)
    FIELD(ME_IER0, INTERRUPT1, 0, 1)
REG32(ME_IDR0, 0x40)
    FIELD(ME_IDR0, INTERRUPT4, 3, 1)
    FIELD(ME_IDR0, INTERRUPT3, 2, 1)
    FIELD(ME_IDR0, INTERRUPT2, 1, 1)
    FIELD(ME_IDR0, INTERRUPT1, 0, 1)
REG32(ME_IMR1, 0x44)
    FIELD(ME_IMR1, INTERRUPT4, 3, 1)
    FIELD(ME_IMR1, INTERRUPT3, 2, 1)
    FIELD(ME_IMR1, INTERRUPT2, 1, 1)
    FIELD(ME_IMR1, INTERRUPT1, 0, 1)
REG32(ME_IER1, 0x48)
    FIELD(ME_IER1, INTERRUPT4, 3, 1)
    FIELD(ME_IER1, INTERRUPT3, 2, 1)
    FIELD(ME_IER1, INTERRUPT2, 1, 1)
    FIELD(ME_IER1, INTERRUPT1, 0, 1)
REG32(ME_IDR1, 0x4c)
    FIELD(ME_IDR1, INTERRUPT4, 3, 1)
    FIELD(ME_IDR1, INTERRUPT3, 2, 1)
    FIELD(ME_IDR1, INTERRUPT2, 1, 1)
    FIELD(ME_IDR1, INTERRUPT1, 0, 1)
REG32(ME_IMR2, 0x50)
    FIELD(ME_IMR2, INTERRUPT4, 3, 1)
    FIELD(ME_IMR2, INTERRUPT3, 2, 1)
    FIELD(ME_IMR2, INTERRUPT2, 1, 1)
    FIELD(ME_IMR2, INTERRUPT1, 0, 1)
REG32(ME_IER2, 0x54)
    FIELD(ME_IER2, INTERRUPT4, 3, 1)
    FIELD(ME_IER2, INTERRUPT3, 2, 1)
    FIELD(ME_IER2, INTERRUPT2, 1, 1)
    FIELD(ME_IER2, INTERRUPT1, 0, 1)
REG32(ME_IDR2, 0x58)
    FIELD(ME_IDR2, INTERRUPT4, 3, 1)
    FIELD(ME_IDR2, INTERRUPT3, 2, 1)
    FIELD(ME_IDR2, INTERRUPT2, 1, 1)
    FIELD(ME_IDR2, INTERRUPT1, 0, 1)
REG32(ME_IMR3, 0x5c)
    FIELD(ME_IMR3, INTERRUPT4, 3, 1)
    FIELD(ME_IMR3, INTERRUPT3, 2, 1)
    FIELD(ME_IMR3, INTERRUPT2, 1, 1)
    FIELD(ME_IMR3, INTERRUPT1, 0, 1)
REG32(ME_IER3, 0x60)
    FIELD(ME_IER3, INTERRUPT4, 3, 1)
    FIELD(ME_IER3, INTERRUPT3, 2, 1)
    FIELD(ME_IER3, INTERRUPT2, 1, 1)
    FIELD(ME_IER3, INTERRUPT1, 0, 1)
REG32(ME_IDR3, 0x64)
    FIELD(ME_IDR3, INTERRUPT4, 3, 1)
    FIELD(ME_IDR3, INTERRUPT3, 2, 1)
    FIELD(ME_IDR3, INTERRUPT2, 1, 1)
    FIELD(ME_IDR3, INTERRUPT1, 0, 1)
REG32(ME_IOR, 0x6c)
    FIELD(ME_IOR, OFFSET, 0, 5)
REG32(ME_PLL_STATUS, 0x10c)
    FIELD(ME_PLL_STATUS, MPLL_STABLE, 2, 1)
    FIELD(ME_PLL_STATUS, MPLL_LOCK, 0, 1)
REG32(ME_SECURE_REG, 0x208)
    FIELD(ME_SECURE_REG, ME_SECURE, 0, 1)

#define AIE2P_S_NPI_R_MAX (R_ME_SECURE_REG + 1)

typedef struct AIE2P_S_NPI {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[AIE2P_S_NPI_R_MAX];
    RegisterInfo regs_info[AIE2P_S_NPI_R_MAX];
} AIE2P_S_NPI;

static const RegisterAccessInfo aie2p_s_npi_regs_info[] = {
    {   .name = "REG_PCSR_MASK",  .addr = A_REG_PCSR_MASK,
        .rsvd = 0xf0000000,
    },{ .name = "REG_PCSR_CONTROL",  .addr = A_REG_PCSR_CONTROL,
        .reset = 0x50381fe,
        .rsvd = 0xf0000000,
    },{ .name = "REG_PCSR_STATUS",  .addr = A_REG_PCSR_STATUS,
        .reset = 0x80D7,
        .rsvd = 0xffff0000,
        .ro = 0xffff,
    },{ .name = "REG_PCSR_LOCK",  .addr = A_REG_PCSR_LOCK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "ME_ISR",  .addr = A_ME_ISR,
        .rsvd = 0xfffffff0,
        .w1c = 0xf,
    },{ .name = "ME_ITR",  .addr = A_ME_ITR,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IMR0",  .addr = A_ME_IMR0,
        .reset = 0xe,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "ME_IER0",  .addr = A_ME_IER0,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IDR0",  .addr = A_ME_IDR0,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IMR1",  .addr = A_ME_IMR1,
        .reset = 0xf,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "ME_IER1",  .addr = A_ME_IER1,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IDR1",  .addr = A_ME_IDR1,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IMR2",  .addr = A_ME_IMR2,
        .reset = 0xf,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "ME_IER2",  .addr = A_ME_IER2,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IDR2",  .addr = A_ME_IDR2,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IMR3",  .addr = A_ME_IMR3,
        .reset = 0xf,
        .rsvd = 0xfffffff0,
        .ro = 0xf,
    },{ .name = "ME_IER3",  .addr = A_ME_IER3,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IDR3",  .addr = A_ME_IDR3,
        .rsvd = 0xfffffff0,
    },{ .name = "ME_IOR",  .addr = A_ME_IOR,
        .reset = 0x4,
        .rsvd = 0xffffffe0,
    },{ .name = "ME_PLL_STATUS",  .addr = A_ME_PLL_STATUS,
        .rsvd = 0xfa,
        .ro = 0xff,
    },{ .name = "ME_SECURE_REG",  .addr = A_ME_SECURE_REG,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    }
};

static void aie2p_s_npi_reset_enter(Object *obj, ResetType type)
{
    AIE2P_S_NPI *s = XILINX_AIE2P_S_NPI(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
    /*
     * Passes the AIE_LBIST
     */
    s->regs[R_ME_ISR] = 0xc;
    s->regs[R_ME_PLL_STATUS] = 0x5;
}

static const MemoryRegionOps aie2p_s_npi_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void aie2p_s_npi_init(Object *obj)
{
    AIE2P_S_NPI *s = XILINX_AIE2P_S_NPI(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_AIE2P_S_NPI, AIE2P_S_NPI_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), aie2p_s_npi_regs_info,
                              ARRAY_SIZE(aie2p_s_npi_regs_info),
                              s->regs_info, s->regs,
                              &aie2p_s_npi_ops,
                              XILINX_AIE2P_S_NPI_ERR_DEBUG,
                              AIE2P_S_NPI_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_aie2p_s_npi = {
    .name = TYPE_XILINX_AIE2P_S_NPI,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, AIE2P_S_NPI, AIE2P_S_NPI_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void aie2p_s_npi_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->vmsd = &vmstate_aie2p_s_npi;
    rc->phases.enter = aie2p_s_npi_reset_enter;
}

static const TypeInfo aie2p_s_npi_info = {
    .name          = TYPE_XILINX_AIE2P_S_NPI,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(AIE2P_S_NPI),
    .class_init    = aie2p_s_npi_class_init,
    .instance_init = aie2p_s_npi_init,
};

static void aie2p_s_npi_register_types(void)
{
    type_register_static(&aie2p_s_npi_info);
}

type_init(aie2p_s_npi_register_types)
