/*
 * QEMU model of the ASU_GLOBAL_PMC This is the database for the ASU Global
 * Register Definitions.
 *
 * Copyright (c) 2023 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2023-04-26.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"

#ifndef XILINX_ASU_GLOBAL_PMC_ERR_DEBUG
#define XILINX_ASU_GLOBAL_PMC_ERR_DEBUG 0
#endif

#define TYPE_XILINX_ASU_GLOBAL_PMC "xlnx.asu_global_pmc"

#define XILINX_ASU_GLOBAL_PMC(obj) \
     OBJECT_CHECK(ASU_GLOBAL_PMC, (obj), TYPE_XILINX_ASU_GLOBAL_PMC)

REG32(PMC_CNTRL, 0x0)
    FIELD(PMC_CNTRL, PL_CLK_SELECT, 2, 1)
    FIELD(PMC_CNTRL, PL_DATA_ENABLE, 1, 1)
    FIELD(PMC_CNTRL, PL_KEY_ENABLE, 0, 1)
REG32(TRUST_ZONE_CNTRL, 0x4)
    FIELD(TRUST_ZONE_CNTRL, TZ_RISCV, 7, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_DMA, 6, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_SHA3, 5, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_SHA2, 4, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_ECC, 3, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_TRNG, 2, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_RSA, 1, 1)
    FIELD(TRUST_ZONE_CNTRL, TZ_AES, 0, 1)
REG32(ASU_DMA_SMID_OVRD_EN, 0x8)
    FIELD(ASU_DMA_SMID_OVRD_EN, SMID_OVRD_EN, 0, 1)
REG32(ASU_DMA_SMID_LOCK, 0xc)
    FIELD(ASU_DMA_SMID_LOCK, SMID_LOCK, 0, 1)
REG32(ASU_DMA_SMID_VAL, 0x10)
    FIELD(ASU_DMA_SMID_VAL, SMID_VAL, 0, 10)
REG32(ASU_DMA_SMID_MASK, 0x14)
    FIELD(ASU_DMA_SMID_MASK, SMID_MASK, 0, 10)
REG32(ASU_RISCV_SMID_OVRD_EN, 0x18)
    FIELD(ASU_RISCV_SMID_OVRD_EN, SMID_OVRD_EN, 0, 1)
REG32(ASU_RISCV_SMID_LOCK, 0x1c)
    FIELD(ASU_RISCV_SMID_LOCK, SMID_LOCK, 0, 1)
REG32(ASU_RISCV_SMID_VAL, 0x20)
    FIELD(ASU_RISCV_SMID_VAL, SMID_VAL, 0, 10)
REG32(ASU_RISCV_SMID_MASK, 0x24)
    FIELD(ASU_RISCV_SMID_MASK, SMID_MASK, 0, 10)
REG32(ASU_GD_VCCINT_PMC_VAL_SEL, 0x28)
    FIELD(ASU_GD_VCCINT_PMC_VAL_SEL, VAL, 0, 3)
REG32(ASU_GD_EN_GLITCH_DET_B, 0x2c)
    FIELD(ASU_GD_EN_GLITCH_DET_B, VAL, 0, 1)
REG32(ASU_GD_COMP_SEL, 0x30)
    FIELD(ASU_GD_COMP_SEL, VAL, 0, 2)
REG32(ASU_GD_DEL_SEL, 0x34)
    FIELD(ASU_GD_DEL_SEL, VAL, 0, 4)
REG32(ASU_GD_GLITCH_DET_SPARE_SEL_PMC, 0x38)
    FIELD(ASU_GD_GLITCH_DET_SPARE_SEL_PMC, VAL, 0, 4)
REG32(ASU_GD_GL_DET_TEST_MODE, 0x3c)
    FIELD(ASU_GD_GL_DET_TEST_MODE, VAL, 0, 1)
REG32(ASU_GD_TEST_GLITCH_GEN, 0x40)
    FIELD(ASU_GD_TEST_GLITCH_GEN, VAL, 0, 1)
REG32(ASU_GD_TEST_GLITCH_SEL, 0x44)
    FIELD(ASU_GD_TEST_GLITCH_SEL, VAL, 0, 5)
REG32(ASU_GD_FABRIC_GL_EN, 0x48)
    FIELD(ASU_GD_FABRIC_GL_EN, VAL, 0, 1)
REG32(ASU_GD_VCCINT_PMC_GLITCH_DETECT, 0x4c)
    FIELD(ASU_GD_VCCINT_PMC_GLITCH_DETECT, VAL, 0, 1)

#define ASU_GLOBAL_PMC_R_MAX (R_ASU_GD_VCCINT_PMC_GLITCH_DETECT + 1)

typedef struct ASU_GLOBAL_PMC {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    uint32_t regs[ASU_GLOBAL_PMC_R_MAX];
    RegisterInfo regs_info[ASU_GLOBAL_PMC_R_MAX];
} ASU_GLOBAL_PMC;

static const RegisterAccessInfo asu_global_pmc_regs_info[] = {
    {   .name = "PMC_CNTRL",  .addr = A_PMC_CNTRL,
        .rsvd = 0xfffffff8,
        .ro = 0xfffffff8,
    },{ .name = "TRUST_ZONE_CNTRL",  .addr = A_TRUST_ZONE_CNTRL,
    },{ .name = "ASU_DMA_SMID_OVRD_EN",  .addr = A_ASU_DMA_SMID_OVRD_EN,
    },{ .name = "ASU_DMA_SMID_LOCK",  .addr = A_ASU_DMA_SMID_LOCK,
    },{ .name = "ASU_DMA_SMID_VAL",  .addr = A_ASU_DMA_SMID_VAL,
    },{ .name = "ASU_DMA_SMID_MASK",  .addr = A_ASU_DMA_SMID_MASK,
    },{ .name = "ASU_RISCV_SMID_OVRD_EN",  .addr = A_ASU_RISCV_SMID_OVRD_EN,
    },{ .name = "ASU_RISCV_SMID_LOCK",  .addr = A_ASU_RISCV_SMID_LOCK,
    },{ .name = "ASU_RISCV_SMID_VAL",  .addr = A_ASU_RISCV_SMID_VAL,
    },{ .name = "ASU_RISCV_SMID_MASK",  .addr = A_ASU_RISCV_SMID_MASK,
    },{ .name = "ASU_GD_VCCINT_PMC_VAL_SEL",
        .addr = A_ASU_GD_VCCINT_PMC_VAL_SEL,
    },{ .name = "ASU_GD_EN_GLITCH_DET_B",  .addr = A_ASU_GD_EN_GLITCH_DET_B,
    },{ .name = "ASU_GD_COMP_SEL",  .addr = A_ASU_GD_COMP_SEL,
    },{ .name = "ASU_GD_DEL_SEL",  .addr = A_ASU_GD_DEL_SEL,
    },{ .name = "ASU_GD_GLITCH_DET_SPARE_SEL_PMC",
        .addr = A_ASU_GD_GLITCH_DET_SPARE_SEL_PMC,
    },{ .name = "ASU_GD_GL_DET_TEST_MODE",  .addr = A_ASU_GD_GL_DET_TEST_MODE,
    },{ .name = "ASU_GD_TEST_GLITCH_GEN",  .addr = A_ASU_GD_TEST_GLITCH_GEN,
    },{ .name = "ASU_GD_TEST_GLITCH_SEL",  .addr = A_ASU_GD_TEST_GLITCH_SEL,
    },{ .name = "ASU_GD_FABRIC_GL_EN",  .addr = A_ASU_GD_FABRIC_GL_EN,
    },{ .name = "ASU_GD_VCCINT_PMC_GLITCH_DETECT",
        .addr = A_ASU_GD_VCCINT_PMC_GLITCH_DETECT,
        .w1c = 0x1,
    }
};

static void asu_global_pmc_reset_enter(Object *obj, ResetType type)
{
    ASU_GLOBAL_PMC *s = XILINX_ASU_GLOBAL_PMC(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static const MemoryRegionOps asu_global_pmc_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void asu_global_pmc_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void asu_global_pmc_init(Object *obj)
{
    ASU_GLOBAL_PMC *s = XILINX_ASU_GLOBAL_PMC(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_ASU_GLOBAL_PMC,
                       ASU_GLOBAL_PMC_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), asu_global_pmc_regs_info,
                              ARRAY_SIZE(asu_global_pmc_regs_info),
                              s->regs_info, s->regs,
                              &asu_global_pmc_ops,
                              XILINX_ASU_GLOBAL_PMC_ERR_DEBUG,
                              ASU_GLOBAL_PMC_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_asu_global_pmc = {
    .name = TYPE_XILINX_ASU_GLOBAL_PMC,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, ASU_GLOBAL_PMC, ASU_GLOBAL_PMC_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void asu_global_pmc_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = asu_global_pmc_realize;
    dc->vmsd = &vmstate_asu_global_pmc;
    rc->phases.enter = asu_global_pmc_reset_enter;
}

static const TypeInfo asu_global_pmc_info = {
    .name          = TYPE_XILINX_ASU_GLOBAL_PMC,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(ASU_GLOBAL_PMC),
    .class_init    = asu_global_pmc_class_init,
    .instance_init = asu_global_pmc_init,
};

static void asu_global_pmc_register_types(void)
{
    type_register_static(&asu_global_pmc_info);
}

type_init(asu_global_pmc_register_types)
