/*
 * QEMU model of the MMI_UDH_PLL MMI UDH Clock Control Registers
 *
 * Copyright (c) 2025 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2025-03-04.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_MMI_UDH_PLL_ERR_DEBUG
#define XILINX_MMI_UDH_PLL_ERR_DEBUG 0
#endif

#define TYPE_XILINX_MMI_UDH_PLL "xlnx.mmi_udh_pll"

#define XILINX_MMI_UDH_PLL(obj) \
     OBJECT_CHECK(MMI_UDH_PLL, (obj), TYPE_XILINX_MMI_UDH_PLL)

REG32(REG_CTRL, 0x0)
    FIELD(REG_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0x4)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x8)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0xc)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x10)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(WPROTS, 0x30)
    FIELD(WPROTS, ACTIVE, 0, 1)
REG32(WPROTP, 0x34)
    FIELD(WPROTP, ACTIVE, 0, 1)
REG32(UDH_PLL_CTRL, 0x40)
    FIELD(UDH_PLL_CTRL, PRE_SRC, 20, 3)
    FIELD(UDH_PLL_CTRL, CLKOUTDIV, 16, 2)
    FIELD(UDH_PLL_CTRL, FBDIV, 8, 8)
    FIELD(UDH_PLL_CTRL, BYPASS, 3, 1)
    FIELD(UDH_PLL_CTRL, RESET, 0, 1)
REG32(UDH_PLL_CFG, 0x44)
    FIELD(UDH_PLL_CFG, LOCK_DLY, 25, 7)
    FIELD(UDH_PLL_CFG, LOCK_CNT, 13, 10)
    FIELD(UDH_PLL_CFG, LFHF, 10, 2)
    FIELD(UDH_PLL_CFG, CP, 5, 4)
    FIELD(UDH_PLL_CFG, RES, 0, 4)
REG32(PLL_STATUS, 0x50)
    FIELD(PLL_STATUS, UDH_PLL_STABLE, 2, 1)
    FIELD(PLL_STATUS, UDH_PLL_LOCK, 0, 1)
REG32(USB2PHY_REF_CLK_CTRL, 0x100)
    FIELD(USB2PHY_REF_CLK_CTRL, DIVISOR0, 8, 10)
    FIELD(USB2PHY_REF_CLK_CTRL, RESET_DIV, 0, 1)
REG32(DP_AUX_CLK_CTRL, 0x108)
    FIELD(DP_AUX_CLK_CTRL, CLKACT, 25, 1)
    FIELD(DP_AUX_CLK_CTRL, DIVISOR0, 8, 10)
REG32(DC_27M_CLK_CTRL, 0x10c)
    FIELD(DC_27M_CLK_CTRL, CLKACT, 25, 1)
    FIELD(DC_27M_CLK_CTRL, DIVISOR0, 8, 10)
REG32(SOCDMA_CLK_CTRL, 0x110)
    FIELD(SOCDMA_CLK_CTRL, CLKACT, 25, 1)
    FIELD(SOCDMA_CLK_CTRL, DIVISOR0, 8, 10)
REG32(SAFETY_CHK, 0x150)

#define MMI_UDH_PLL_R_MAX (R_SAFETY_CHK + 1)

typedef struct MMI_UDH_PLL {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir;

    uint32_t regs[MMI_UDH_PLL_R_MAX];
    RegisterInfo regs_info[MMI_UDH_PLL_R_MAX];
} MMI_UDH_PLL;

static void ir_update_irq(MMI_UDH_PLL *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_PLL *s = XILINX_MMI_UDH_PLL(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_PLL *s = XILINX_MMI_UDH_PLL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_PLL *s = XILINX_MMI_UDH_PLL(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static const RegisterAccessInfo mmi_udh_pll_regs_info[] = {
    {   .name = "REG_CTRL",  .addr = A_REG_CTRL,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_disable_prew,
    },{ .name = "WPROTS",  .addr = A_WPROTS,
        .reset = 0x1,
    },{ .name = "WPROTP",  .addr = A_WPROTP,
        .reset = 0x1,
    },{ .name = "UDH_PLL_CTRL",  .addr = A_UDH_PLL_CTRL,
        .reset = 0x14809,
        .rsvd = 0xff8c00f6,
        .ro = 0xff8c00f6,
    },{ .name = "UDH_PLL_CFG",  .addr = A_UDH_PLL_CFG,
        .reset = 0x7e5dcc6c,
        .rsvd = 0x1801210,
        .ro = 0x1801210,
    },{ .name = "PLL_STATUS",  .addr = A_PLL_STATUS,
        .reset = R_PLL_STATUS_UDH_PLL_LOCK_MASK |
                 R_PLL_STATUS_UDH_PLL_STABLE_MASK,
        .rsvd = 0xfa,
        .ro = 0xff,
    },{ .name = "USB2PHY_REF_CLK_CTRL",  .addr = A_USB2PHY_REF_CLK_CTRL,
        .reset = 0x2500,
        .rsvd = 0xfffc00fa,
    },{ .name = "DP_AUX_CLK_CTRL",  .addr = A_DP_AUX_CLK_CTRL,
        .reset = 0x2002500,
        .rsvd = 0xfdfc00ff,
    },{ .name = "DC_27M_CLK_CTRL",  .addr = A_DC_27M_CLK_CTRL,
        .reset = 0x2002500,
        .rsvd = 0xfdfc00ff,
    },{ .name = "SOCDMA_CLK_CTRL",  .addr = A_SOCDMA_CLK_CTRL,
        .reset = 0x2002500,
        .rsvd = 0xfdfc00ff,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    }
};

static void mmi_udh_pll_reset_enter(Object *obj, ResetType type)
{
    MMI_UDH_PLL *s = XILINX_MMI_UDH_PLL(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void mmi_udh_pll_reset_hold(Object *obj)
{
    MMI_UDH_PLL *s = XILINX_MMI_UDH_PLL(obj);

    ir_update_irq(s);
}

static const MemoryRegionOps mmi_udh_pll_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void mmi_udh_pll_realize(DeviceState *dev, Error **errp)
{
    /* Delete this if you don't need it */
}

static void mmi_udh_pll_init(Object *obj)
{
    MMI_UDH_PLL *s = XILINX_MMI_UDH_PLL(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_MMI_UDH_PLL,
                       MMI_UDH_PLL_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), mmi_udh_pll_regs_info,
                              ARRAY_SIZE(mmi_udh_pll_regs_info),
                              s->regs_info, s->regs,
                              &mmi_udh_pll_ops,
                              XILINX_MMI_UDH_PLL_ERR_DEBUG,
                              MMI_UDH_PLL_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir);
}

static const VMStateDescription vmstate_mmi_udh_pll = {
    .name = TYPE_XILINX_MMI_UDH_PLL,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, MMI_UDH_PLL, MMI_UDH_PLL_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void mmi_udh_pll_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = mmi_udh_pll_realize;
    dc->vmsd = &vmstate_mmi_udh_pll;
    rc->phases.enter = mmi_udh_pll_reset_enter;
    rc->phases.hold = mmi_udh_pll_reset_hold;
}

static const TypeInfo mmi_udh_pll_info = {
    .name          = TYPE_XILINX_MMI_UDH_PLL,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(MMI_UDH_PLL),
    .class_init    = mmi_udh_pll_class_init,
    .instance_init = mmi_udh_pll_init,
};

static void mmi_udh_pll_register_types(void)
{
    type_register_static(&mmi_udh_pll_info);
}

type_init(mmi_udh_pll_register_types)
