/*
 * QEMU model of the MMI_UDH_SLCR MMI UDH System Level Control and Status
 * Registers
 *
 * Copyright (c) 2025 Xilinx Inc.
 *
 * Autogenerated by xregqemu.py 2025-03-03.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"

#ifndef XILINX_MMI_UDH_SLCR_ERR_DEBUG
#define XILINX_MMI_UDH_SLCR_ERR_DEBUG 0
#endif

#define TYPE_XILINX_MMI_UDH_SLCR "xlnx.mmi_udh_slcr"

#define XILINX_MMI_UDH_SLCR(obj) \
     OBJECT_CHECK(MMI_UDH_SLCR, (obj), TYPE_XILINX_MMI_UDH_SLCR)

REG32(WPROTS, 0x0)
    FIELD(WPROTS, ACTIVE, 0, 1)
REG32(WPROTP, 0x4)
    FIELD(WPROTP, ACTIVE, 0, 1)
REG32(REG_CTRL, 0x8)
    FIELD(REG_CTRL, SLVERR_ENABLE, 0, 1)
REG32(IR_STATUS, 0xc)
    FIELD(IR_STATUS, ADDR_DECODE_ERR, 0, 1)
REG32(IR_MASK, 0x10)
    FIELD(IR_MASK, ADDR_DECODE_ERR, 0, 1)
REG32(IR_ENABLE, 0x14)
    FIELD(IR_ENABLE, ADDR_DECODE_ERR, 0, 1)
REG32(IR_DISABLE, 0x18)
    FIELD(IR_DISABLE, ADDR_DECODE_ERR, 0, 1)
REG32(SIDDQ, 0x104)
    FIELD(SIDDQ, USB2, 0, 1)
REG32(TESTBURNIN, 0x108)
    FIELD(TESTBURNIN, USB2, 0, 1)
REG32(IR_UDH_CORR_STATUS, 0x138)
    FIELD(IR_UDH_CORR_STATUS, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_CORR_STATUS, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_CORR_STATUS, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_CORR_STATUS, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_CORR_STATUS, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_CORR_STATUS, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_CORR_STATUS, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_CORR_STATUS, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_CORR_STATUS, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_CORR_STATUS, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_CORR_STATUS, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_CORR_STATUS, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_CORR_STATUS, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_CORR_STATUS, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_CORR_STATUS, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_CORR_STATUS, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_CORR_STATUS, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_CORR_STATUS, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_CORR_STATUS, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_CORR_STATUS, APB_ERR, 0, 1)
REG32(IR_UDH_CORR_MASK, 0x13c)
    FIELD(IR_UDH_CORR_MASK, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_CORR_MASK, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_CORR_MASK, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_CORR_MASK, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_CORR_MASK, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_CORR_MASK, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_CORR_MASK, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_CORR_MASK, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_CORR_MASK, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_CORR_MASK, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_CORR_MASK, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_CORR_MASK, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_CORR_MASK, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_CORR_MASK, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_CORR_MASK, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_CORR_MASK, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_CORR_MASK, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_CORR_MASK, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_CORR_MASK, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_CORR_MASK, APB_ERR, 0, 1)
REG32(IR_UDH_CORR_ENABLE, 0x140)
    FIELD(IR_UDH_CORR_ENABLE, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_CORR_ENABLE, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_CORR_ENABLE, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_CORR_ENABLE, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_CORR_ENABLE, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_CORR_ENABLE, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_CORR_ENABLE, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_CORR_ENABLE, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_CORR_ENABLE, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_CORR_ENABLE, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_CORR_ENABLE, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_CORR_ENABLE, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_CORR_ENABLE, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_CORR_ENABLE, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_CORR_ENABLE, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_CORR_ENABLE, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_CORR_ENABLE, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_CORR_ENABLE, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_CORR_ENABLE, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_CORR_ENABLE, APB_ERR, 0, 1)
REG32(IR_UDH_CORR_DISABLE, 0x144)
    FIELD(IR_UDH_CORR_DISABLE, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_CORR_DISABLE, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_CORR_DISABLE, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_CORR_DISABLE, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_CORR_DISABLE, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_CORR_DISABLE, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_CORR_DISABLE, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_CORR_DISABLE, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_CORR_DISABLE, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_CORR_DISABLE, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_CORR_DISABLE, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_CORR_DISABLE, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_CORR_DISABLE, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_CORR_DISABLE, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_CORR_DISABLE, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_CORR_DISABLE, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_CORR_DISABLE, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_CORR_DISABLE, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_CORR_DISABLE, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_CORR_DISABLE, APB_ERR, 0, 1)
REG32(IR_UDH_UNCORR_STATUS, 0x14c)
    FIELD(IR_UDH_UNCORR_STATUS, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_UNCORR_STATUS, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_UNCORR_STATUS, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_UNCORR_STATUS, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_UNCORR_STATUS, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_UNCORR_STATUS, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_UNCORR_STATUS, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_UNCORR_STATUS, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_UNCORR_STATUS, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_UNCORR_STATUS, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_UNCORR_STATUS, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_UNCORR_STATUS, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_UNCORR_STATUS, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_UNCORR_STATUS, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_UNCORR_STATUS, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_UNCORR_STATUS, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_UNCORR_STATUS, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_UNCORR_STATUS, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_UNCORR_STATUS, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_UNCORR_STATUS, APB_ERR, 0, 1)
REG32(IR_UDH_UNCORR_MASK, 0x150)
    FIELD(IR_UDH_UNCORR_MASK, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_UNCORR_MASK, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_UNCORR_MASK, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_UNCORR_MASK, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_UNCORR_MASK, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_UNCORR_MASK, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_UNCORR_MASK, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_UNCORR_MASK, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_UNCORR_MASK, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_UNCORR_MASK, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_UNCORR_MASK, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_UNCORR_MASK, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_UNCORR_MASK, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_UNCORR_MASK, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_UNCORR_MASK, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_UNCORR_MASK, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_UNCORR_MASK, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_UNCORR_MASK, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_UNCORR_MASK, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_UNCORR_MASK, APB_ERR, 0, 1)
REG32(IR_UDH_UNCORR_ENABLE, 0x154)
    FIELD(IR_UDH_UNCORR_ENABLE, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_UNCORR_ENABLE, APB_ERR, 0, 1)
REG32(IR_UDH_UNCORR_DISABLE, 0x158)
    FIELD(IR_UDH_UNCORR_DISABLE, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_UNCORR_DISABLE, APB_ERR, 0, 1)
REG32(IR_UDH_MISC_STATUS, 0x160)
    FIELD(IR_UDH_MISC_STATUS, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_MISC_STATUS, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_MISC_STATUS, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_MISC_STATUS, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_MISC_STATUS, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_MISC_STATUS, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_MISC_STATUS, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_MISC_STATUS, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_MISC_STATUS, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_MISC_STATUS, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_MISC_STATUS, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_MISC_STATUS, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_MISC_STATUS, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_MISC_STATUS, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_MISC_STATUS, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_MISC_STATUS, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_MISC_STATUS, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_MISC_STATUS, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_MISC_STATUS, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_MISC_STATUS, APB_ERR, 0, 1)
REG32(IR_UDH_MISC_MASK, 0x164)
    FIELD(IR_UDH_MISC_MASK, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_MISC_MASK, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_MISC_MASK, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_MISC_MASK, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_MISC_MASK, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_MISC_MASK, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_MISC_MASK, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_MISC_MASK, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_MISC_MASK, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_MISC_MASK, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_MISC_MASK, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_MISC_MASK, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_MISC_MASK, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_MISC_MASK, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_MISC_MASK, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_MISC_MASK, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_MISC_MASK, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_MISC_MASK, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_MISC_MASK, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_MISC_MASK, APB_ERR, 0, 1)
REG32(IR_UDH_MISC_ENABLE, 0x168)
    FIELD(IR_UDH_MISC_ENABLE, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_MISC_ENABLE, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_MISC_ENABLE, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_MISC_ENABLE, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_MISC_ENABLE, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_MISC_ENABLE, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_MISC_ENABLE, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_MISC_ENABLE, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_MISC_ENABLE, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_MISC_ENABLE, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_MISC_ENABLE, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_MISC_ENABLE, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_MISC_ENABLE, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_MISC_ENABLE, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_MISC_ENABLE, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_MISC_ENABLE, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_MISC_ENABLE, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_MISC_ENABLE, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_MISC_ENABLE, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_MISC_ENABLE, APB_ERR, 0, 1)
REG32(IR_UDH_MISC_DISABLE, 0x16c)
    FIELD(IR_UDH_MISC_DISABLE, SECURE_APB_ERR, 19, 1)
    FIELD(IR_UDH_MISC_DISABLE, UDHRAM_UNCORR_ERR, 18, 1)
    FIELD(IR_UDH_MISC_DISABLE, UDHRAM_CORR_ERR, 17, 1)
    FIELD(IR_UDH_MISC_DISABLE, TRNG_APB_PSLVERR, 16, 1)
    FIELD(IR_UDH_MISC_DISABLE, TRNG_IRQ, 15, 1)
    FIELD(IR_UDH_MISC_DISABLE, UDH_PLL_IRQ, 14, 1)
    FIELD(IR_UDH_MISC_DISABLE, LOCK_FORIRQ, 13, 1)
    FIELD(IR_UDH_MISC_DISABLE, DPALT_DISABLE, 12, 1)
    FIELD(IR_UDH_MISC_DISABLE, PIPE_LANE0_POWER_PRESENT, 11, 1)
    FIELD(IR_UDH_MISC_DISABLE, TCA_DRV_HOST_VBUS, 10, 1)
    FIELD(IR_UDH_MISC_DISABLE, TCA_POWERPRESENT, 9, 1)
    FIELD(IR_UDH_MISC_DISABLE, TCA_VBUSVALID, 8, 1)
    FIELD(IR_UDH_MISC_DISABLE, PHY0_SRAM_INIT_DONE, 7, 1)
    FIELD(IR_UDH_MISC_DISABLE, PIPE_LANE0_PHYSTATUS, 6, 1)
    FIELD(IR_UDH_MISC_DISABLE, HOST_LEGACY_SMI_INTERRUPT, 5, 1)
    FIELD(IR_UDH_MISC_DISABLE, HOST_SYSTEM_ERR, 4, 1)
    FIELD(IR_UDH_MISC_DISABLE, DRD_INTERRUPT_1, 3, 1)
    FIELD(IR_UDH_MISC_DISABLE, DRD_INTERRUPT_2, 2, 1)
    FIELD(IR_UDH_MISC_DISABLE, DRD_INTERRUPT_3, 1, 1)
    FIELD(IR_UDH_MISC_DISABLE, APB_ERR, 0, 1)
REG32(IR_UDHRAM_CORR_STATUS, 0x174)
    FIELD(IR_UDHRAM_CORR_STATUS, DP_KSM_RAM_ERR_DETECT, 13, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, HDCP_TCM_B3_RAM_ERR_DETECT, 12, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, HDCP_TCM_B2_RAM_ERR_DETECT, 11, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, HDCP_TCM_B1_RAM_ERR_DETECT, 10, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, HDCP_TCM_B0_RAM_ERR_DETECT, 9, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, DPTX_L3_RAM_ERR_DETECT, 8, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, DPTX_L2_RAM_ERR_DETECT, 7, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, DPTX_L1_RAM_ERR_DETECT, 6, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, DPTX_L0_RAM_ERR_DETECT, 5, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, USB3P_RAM_ERR_DETECT, 4, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, HDCP_AIC_RAM_ERR_DETECT, 3, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, USBC_RAM2_ERR_DETECT, 2, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, USBC_RAM1_ERR_DETECT, 1, 1)
    FIELD(IR_UDHRAM_CORR_STATUS, USBC_RAM0_ERR_DETECT, 0, 1)
REG32(IR_UDHRAM_CORR_MASK, 0x178)
    FIELD(IR_UDHRAM_CORR_MASK, DP_KSM_RAM_ERR_DETECT, 13, 1)
    FIELD(IR_UDHRAM_CORR_MASK, HDCP_TCM_B3_RAM_ERR_DETECT, 12, 1)
    FIELD(IR_UDHRAM_CORR_MASK, HDCP_TCM_B2_RAM_ERR_DETECT, 11, 1)
    FIELD(IR_UDHRAM_CORR_MASK, HDCP_TCM_B1_RAM_ERR_DETECT, 10, 1)
    FIELD(IR_UDHRAM_CORR_MASK, HDCP_TCM_B0_RAM_ERR_DETECT, 9, 1)
    FIELD(IR_UDHRAM_CORR_MASK, DPTX_L3_RAM_ERR_DETECT, 8, 1)
    FIELD(IR_UDHRAM_CORR_MASK, DPTX_L2_RAM_ERR_DETECT, 7, 1)
    FIELD(IR_UDHRAM_CORR_MASK, DPTX_L1_RAM_ERR_DETECT, 6, 1)
    FIELD(IR_UDHRAM_CORR_MASK, DPTX_L0_RAM_ERR_DETECT, 5, 1)
    FIELD(IR_UDHRAM_CORR_MASK, USB3P_RAM_ERR_DETECT, 4, 1)
    FIELD(IR_UDHRAM_CORR_MASK, HDCP_AIC_RAM_ERR_DETECT, 3, 1)
    FIELD(IR_UDHRAM_CORR_MASK, USBC_RAM2_ERR_DETECT, 2, 1)
    FIELD(IR_UDHRAM_CORR_MASK, USBC_RAM1_ERR_DETECT, 1, 1)
    FIELD(IR_UDHRAM_CORR_MASK, USBC_RAM0_ERR_DETECT, 0, 1)
REG32(IR_UDHRAM_CORR_ENABLE, 0x17c)
    FIELD(IR_UDHRAM_CORR_ENABLE, DP_KSM_RAM_ERR_DETECT, 13, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, HDCP_TCM_B3_RAM_ERR_DETECT, 12, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, HDCP_TCM_B2_RAM_ERR_DETECT, 11, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, HDCP_TCM_B1_RAM_ERR_DETECT, 10, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, HDCP_TCM_B0_RAM_ERR_DETECT, 9, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, DPTX_L3_RAM_ERR_DETECT, 8, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, DPTX_L2_RAM_ERR_DETECT, 7, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, DPTX_L1_RAM_ERR_DETECT, 6, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, DPTX_L0_RAM_ERR_DETECT, 5, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, USB3P_RAM_ERR_DETECT, 4, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, HDCP_AIC_RAM_ERR_DETECT, 3, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, USBC_RAM2_ERR_DETECT, 2, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, USBC_RAM1_ERR_DETECT, 1, 1)
    FIELD(IR_UDHRAM_CORR_ENABLE, USBC_RAM0_ERR_DETECT, 0, 1)
REG32(IR_UDHRAM_CORR_DISABLE, 0x180)
    FIELD(IR_UDHRAM_CORR_DISABLE, DP_KSM_RAM_ERR_DETECT, 13, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, HDCP_TCM_B3_RAM_ERR_DETECT, 12, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, HDCP_TCM_B2_RAM_ERR_DETECT, 11, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, HDCP_TCM_B1_RAM_ERR_DETECT, 10, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, HDCP_TCM_B0_RAM_ERR_DETECT, 9, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, DPTX_L3_RAM_ERR_DETECT, 8, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, DPTX_L2_RAM_ERR_DETECT, 7, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, DPTX_L1_RAM_ERR_DETECT, 6, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, DPTX_L0_RAM_ERR_DETECT, 5, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, USB3P_RAM_ERR_DETECT, 4, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, HDCP_AIC_RAM_ERR_DETECT, 3, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, USBC_RAM2_ERR_DETECT, 2, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, USBC_RAM1_ERR_DETECT, 1, 1)
    FIELD(IR_UDHRAM_CORR_DISABLE, USBC_RAM0_ERR_DETECT, 0, 1)
REG32(IR_UDHRAM_UNCORR_STATUS, 0x188)
    FIELD(IR_UDHRAM_UNCORR_STATUS, DP_KSM_RAM_ERR_MULTPL, 13, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, HDCP_TCM_B3_RAM_ERR_MULTPL, 12, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, HDCP_TCM_B2_RAM_ERR_MULTPL, 11, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, HDCP_TCM_B1_RAM_ERR_MULTPL, 10, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, HDCP_TCM_B0_RAM_ERR_MULTPL, 9, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, DPTX_L3_RAM_ERR_MULTPL, 8, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, DPTX_L2_RAM_ERR_MULTPL, 7, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, DPTX_L1_RAM_ERR_MULTPL, 6, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, DPTX_L0_RAM_ERR_MULTPL, 5, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, USB3P_RAM_ERR_MULTPL, 4, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, HDCP_AIC_RAM_ERR_MULTPL, 3, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, USBC_RAM2_ERR_MULTPL, 2, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, USBC_RAM1_ERR_MULTPL, 1, 1)
    FIELD(IR_UDHRAM_UNCORR_STATUS, USBC_RAM0_ERR_MULTPL, 0, 1)
REG32(IR_UDHRAM_UNCORR_MASK, 0x18c)
    FIELD(IR_UDHRAM_UNCORR_MASK, DP_KSM_RAM_ERR_MULTPL, 13, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, HDCP_TCM_B3_RAM_ERR_MULTPL, 12, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, HDCP_TCM_B2_RAM_ERR_MULTPL, 11, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, HDCP_TCM_B1_RAM_ERR_MULTPL, 10, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, HDCP_TCM_B0_RAM_ERR_MULTPL, 9, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, DPTX_L3_RAM_ERR_MULTPL, 8, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, DPTX_L2_RAM_ERR_MULTPL, 7, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, DPTX_L1_RAM_ERR_MULTPL, 6, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, DPTX_L0_RAM_ERR_MULTPL, 5, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, USB3P_RAM_ERR_MULTPL, 4, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, HDCP_AIC_RAM_ERR_MULTPL, 3, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, USBC_RAM2_ERR_MULTPL, 2, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, USBC_RAM1_ERR_MULTPL, 1, 1)
    FIELD(IR_UDHRAM_UNCORR_MASK, USBC_RAM0_ERR_MULTPL, 0, 1)
REG32(IR_UDHRAM_UNCORR_ENABLE, 0x190)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, DP_KSM_RAM_ERR_MULTPL, 13, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, HDCP_TCM_B3_RAM_ERR_MULTPL, 12, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, HDCP_TCM_B2_RAM_ERR_MULTPL, 11, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, HDCP_TCM_B1_RAM_ERR_MULTPL, 10, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, HDCP_TCM_B0_RAM_ERR_MULTPL, 9, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, DPTX_L3_RAM_ERR_MULTPL, 8, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, DPTX_L2_RAM_ERR_MULTPL, 7, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, DPTX_L1_RAM_ERR_MULTPL, 6, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, DPTX_L0_RAM_ERR_MULTPL, 5, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, USB3P_RAM_ERR_MULTPL, 4, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, HDCP_AIC_RAM_ERR_MULTPL, 3, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, USBC_RAM2_ERR_MULTPL, 2, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, USBC_RAM1_ERR_MULTPL, 1, 1)
    FIELD(IR_UDHRAM_UNCORR_ENABLE, USBC_RAM0_ERR_MULTPL, 0, 1)
REG32(IR_UDHRAM_UNCORR_DISABLE, 0x194)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, DP_KSM_RAM_ERR_MULTPL, 13, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, HDCP_TCM_B3_RAM_ERR_MULTPL, 12, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, HDCP_TCM_B2_RAM_ERR_MULTPL, 11, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, HDCP_TCM_B1_RAM_ERR_MULTPL, 10, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, HDCP_TCM_B0_RAM_ERR_MULTPL, 9, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, DPTX_L3_RAM_ERR_MULTPL, 8, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, DPTX_L2_RAM_ERR_MULTPL, 7, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, DPTX_L1_RAM_ERR_MULTPL, 6, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, DPTX_L0_RAM_ERR_MULTPL, 5, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, USB3P_RAM_ERR_MULTPL, 4, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, HDCP_AIC_RAM_ERR_MULTPL, 3, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, USBC_RAM2_ERR_MULTPL, 2, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, USBC_RAM1_ERR_MULTPL, 1, 1)
    FIELD(IR_UDHRAM_UNCORR_DISABLE, USBC_RAM0_ERR_MULTPL, 0, 1)
REG32(UDH, 0x1a4)
    FIELD(UDH, CLK_SELECT, 0, 1)
REG32(UDH_RCLK, 0x1b0)
    FIELD(UDH_RCLK, SELECT, 0, 20)

#define MMI_UDH_SLCR_R_MAX (R_UDH_RCLK + 1)

typedef struct MMI_UDH_SLCR {
    SysBusDevice parent_obj;
    MemoryRegion iomem;
    qemu_irq irq_ir_udh_uncorr;
    qemu_irq irq_ir_udh_corr;
    qemu_irq irq_ir;
    qemu_irq irq_ir_udh_misc;
    qemu_irq irq_ir_udhram_corr;
    qemu_irq irq_ir_udhram_uncorr;

    uint32_t regs[MMI_UDH_SLCR_R_MAX];
    RegisterInfo regs_info[MMI_UDH_SLCR_R_MAX];
} MMI_UDH_SLCR;

static void ir_udh_uncorr_update_irq(MMI_UDH_SLCR *s)
{
    bool pending = s->regs[R_IR_UDH_UNCORR_STATUS] &
                   ~s->regs[R_IR_UDH_UNCORR_MASK];
    qemu_set_irq(s->irq_ir_udh_uncorr, pending);
}

static void ir_udh_uncorr_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    ir_udh_uncorr_update_irq(s);
}

static uint64_t ir_udh_uncorr_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDH_UNCORR_MASK] &= ~val;
    ir_udh_uncorr_update_irq(s);
    return 0;
}

static uint64_t ir_udh_uncorr_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDH_UNCORR_MASK] |= val;
    ir_udh_uncorr_update_irq(s);
    return 0;
}

static void ir_udh_corr_update_irq(MMI_UDH_SLCR *s)
{
    bool pending = s->regs[R_IR_UDH_CORR_STATUS] & ~s->regs[R_IR_UDH_CORR_MASK];
    qemu_set_irq(s->irq_ir_udh_corr, pending);
}

static void ir_udh_corr_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    ir_udh_corr_update_irq(s);
}

static uint64_t ir_udh_corr_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDH_CORR_MASK] &= ~val;
    ir_udh_corr_update_irq(s);
    return 0;
}

static uint64_t ir_udh_corr_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDH_CORR_MASK] |= val;
    ir_udh_corr_update_irq(s);
    return 0;
}

static void ir_update_irq(MMI_UDH_SLCR *s)
{
    bool pending = s->regs[R_IR_STATUS] & ~s->regs[R_IR_MASK];
    qemu_set_irq(s->irq_ir, pending);
}

static void ir_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    ir_update_irq(s);
}

static uint64_t ir_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] &= ~val;
    ir_update_irq(s);
    return 0;
}

static uint64_t ir_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_MASK] |= val;
    ir_update_irq(s);
    return 0;
}

static void ir_udh_misc_update_irq(MMI_UDH_SLCR *s)
{
    bool pending = s->regs[R_IR_UDH_MISC_STATUS] & ~s->regs[R_IR_UDH_MISC_MASK];
    qemu_set_irq(s->irq_ir_udh_misc, pending);
}

static void ir_udh_misc_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    ir_udh_misc_update_irq(s);
}

static uint64_t ir_udh_misc_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDH_MISC_MASK] &= ~val;
    ir_udh_misc_update_irq(s);
    return 0;
}

static uint64_t ir_udh_misc_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDH_MISC_MASK] |= val;
    ir_udh_misc_update_irq(s);
    return 0;
}

static void ir_udhram_corr_update_irq(MMI_UDH_SLCR *s)
{
    bool pending = s->regs[R_IR_UDHRAM_CORR_STATUS] &
                   ~s->regs[R_IR_UDHRAM_CORR_MASK];
    qemu_set_irq(s->irq_ir_udhram_corr, pending);
}

static void ir_udhram_corr_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    ir_udhram_corr_update_irq(s);
}

static uint64_t ir_udhram_corr_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDHRAM_CORR_MASK] &= ~val;
    ir_udhram_corr_update_irq(s);
    return 0;
}

static uint64_t ir_udhram_corr_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDHRAM_CORR_MASK] |= val;
    ir_udhram_corr_update_irq(s);
    return 0;
}

static void ir_udhram_uncorr_update_irq(MMI_UDH_SLCR *s)
{
    bool pending = s->regs[R_IR_UDHRAM_UNCORR_STATUS] &
                   ~s->regs[R_IR_UDHRAM_UNCORR_MASK];
    qemu_set_irq(s->irq_ir_udhram_uncorr, pending);
}

static void ir_udhram_uncorr_status_postw(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    ir_udhram_uncorr_update_irq(s);
}

static uint64_t ir_udhram_uncorr_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDHRAM_UNCORR_MASK] &= ~val;
    ir_udhram_uncorr_update_irq(s);
    return 0;
}

static uint64_t ir_udhram_uncorr_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(reg->opaque);
    uint32_t val = val64;

    s->regs[R_IR_UDHRAM_UNCORR_MASK] |= val;
    ir_udhram_uncorr_update_irq(s);
    return 0;
}

static const RegisterAccessInfo mmi_udh_slcr_regs_info[] = {
    {   .name = "WPROTS",  .addr = A_WPROTS,
        .reset = 0x1,
    },{ .name = "WPROTP",  .addr = A_WPROTP,
        .reset = 0x1,
    },{ .name = "REG_CTRL",  .addr = A_REG_CTRL,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "IR_STATUS",  .addr = A_IR_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .w1c = 0x1,
        .post_write = ir_status_postw,
    },{ .name = "IR_MASK",  .addr = A_IR_MASK,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
        .ro = 0xffffffff,
    },{ .name = "IR_ENABLE",  .addr = A_IR_ENABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_enable_prew,
    },{ .name = "IR_DISABLE",  .addr = A_IR_DISABLE,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
        .pre_write = ir_disable_prew,
    },{ .name = "SIDDQ",  .addr = A_SIDDQ,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "TESTBURNIN",  .addr = A_TESTBURNIN,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "IR_UDH_CORR_STATUS",  .addr = A_IR_UDH_CORR_STATUS,
        .reset = 0x1000,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .w1c = 0xfffff,
        .post_write = ir_udh_corr_status_postw,
    },{ .name = "IR_UDH_CORR_MASK",  .addr = A_IR_UDH_CORR_MASK,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "IR_UDH_CORR_ENABLE",  .addr = A_IR_UDH_CORR_ENABLE,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .pre_write = ir_udh_corr_enable_prew,
    },{ .name = "IR_UDH_CORR_DISABLE",  .addr = A_IR_UDH_CORR_DISABLE,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .pre_write = ir_udh_corr_disable_prew,
    },{ .name = "IR_UDH_UNCORR_STATUS",  .addr = A_IR_UDH_UNCORR_STATUS,
        .reset = 0x1000,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .w1c = 0xfffff,
        .post_write = ir_udh_uncorr_status_postw,
    },{ .name = "IR_UDH_UNCORR_MASK",  .addr = A_IR_UDH_UNCORR_MASK,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "IR_UDH_UNCORR_ENABLE",  .addr = A_IR_UDH_UNCORR_ENABLE,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .pre_write = ir_udh_uncorr_enable_prew,
    },{ .name = "IR_UDH_UNCORR_DISABLE",  .addr = A_IR_UDH_UNCORR_DISABLE,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .pre_write = ir_udh_uncorr_disable_prew,
    },{ .name = "IR_UDH_MISC_STATUS",  .addr = A_IR_UDH_MISC_STATUS,
        .reset = 0x1000,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .w1c = 0xfffff,
        .post_write = ir_udh_misc_status_postw,
    },{ .name = "IR_UDH_MISC_MASK",  .addr = A_IR_UDH_MISC_MASK,
        .reset = 0xfffff,
        .rsvd = 0xfff00000,
        .ro = 0xffffffff,
    },{ .name = "IR_UDH_MISC_ENABLE",  .addr = A_IR_UDH_MISC_ENABLE,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .pre_write = ir_udh_misc_enable_prew,
    },{ .name = "IR_UDH_MISC_DISABLE",  .addr = A_IR_UDH_MISC_DISABLE,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
        .pre_write = ir_udh_misc_disable_prew,
    },{ .name = "IR_UDHRAM_CORR_STATUS",  .addr = A_IR_UDHRAM_CORR_STATUS,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
        .w1c = 0x3fff,
        .post_write = ir_udhram_corr_status_postw,
    },{ .name = "IR_UDHRAM_CORR_MASK",  .addr = A_IR_UDHRAM_CORR_MASK,
        .reset = 0x3fff,
        .rsvd = 0xffffc000,
        .ro = 0xffffffff,
    },{ .name = "IR_UDHRAM_CORR_ENABLE",  .addr = A_IR_UDHRAM_CORR_ENABLE,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
        .pre_write = ir_udhram_corr_enable_prew,
    },{ .name = "IR_UDHRAM_CORR_DISABLE",  .addr = A_IR_UDHRAM_CORR_DISABLE,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
        .pre_write = ir_udhram_corr_disable_prew,
    },{ .name = "IR_UDHRAM_UNCORR_STATUS",  .addr = A_IR_UDHRAM_UNCORR_STATUS,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
        .w1c = 0x3fff,
        .post_write = ir_udhram_uncorr_status_postw,
    },{ .name = "IR_UDHRAM_UNCORR_MASK",  .addr = A_IR_UDHRAM_UNCORR_MASK,
        .reset = 0x3fff,
        .rsvd = 0xffffc000,
        .ro = 0xffffffff,
    },{ .name = "IR_UDHRAM_UNCORR_ENABLE",  .addr = A_IR_UDHRAM_UNCORR_ENABLE,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
        .pre_write = ir_udhram_uncorr_enable_prew,
    },{ .name = "IR_UDHRAM_UNCORR_DISABLE",  .addr = A_IR_UDHRAM_UNCORR_DISABLE,
        .rsvd = 0xffffc000,
        .ro = 0xffffc000,
        .pre_write = ir_udhram_uncorr_disable_prew,
    },{ .name = "UDH",  .addr = A_UDH,
        .rsvd = 0xfffffffe,
        .ro = 0xfffffffe,
    },{ .name = "UDH_RCLK",  .addr = A_UDH_RCLK,
        .rsvd = 0xfff00000,
        .ro = 0xfff00000,
    }
};

static void mmi_udh_slcr_reset_enter(Object *obj, ResetType type)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void mmi_udh_slcr_reset_hold(Object *obj)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(obj);

    ir_udh_uncorr_update_irq(s);
    ir_udh_corr_update_irq(s);
    ir_update_irq(s);
    ir_udh_misc_update_irq(s);
    ir_udhram_corr_update_irq(s);
    ir_udhram_uncorr_update_irq(s);
}

static const MemoryRegionOps mmi_udh_slcr_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void trng_intr_handler(void *opaque, int n, int level)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(opaque);

    s->regs[R_IR_UDH_MISC_STATUS] |=
               level << R_IR_UDH_MISC_MASK_TRNG_IRQ_SHIFT;
    ir_udh_misc_update_irq(s);
}

static void mmi_udh_slcr_realize(DeviceState *dev, Error **errp)
{
    qdev_init_gpio_in(dev, trng_intr_handler, 1);
}

static void mmi_udh_slcr_init(Object *obj)
{
    MMI_UDH_SLCR *s = XILINX_MMI_UDH_SLCR(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_MMI_UDH_SLCR,
                       MMI_UDH_SLCR_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), mmi_udh_slcr_regs_info,
                              ARRAY_SIZE(mmi_udh_slcr_regs_info),
                              s->regs_info, s->regs,
                              &mmi_udh_slcr_ops,
                              XILINX_MMI_UDH_SLCR_ERR_DEBUG,
                              MMI_UDH_SLCR_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);
    sysbus_init_mmio(sbd, &s->iomem);
    sysbus_init_irq(sbd, &s->irq_ir_udh_uncorr);
    sysbus_init_irq(sbd, &s->irq_ir_udh_corr);
    sysbus_init_irq(sbd, &s->irq_ir);
    sysbus_init_irq(sbd, &s->irq_ir_udh_misc);
    sysbus_init_irq(sbd, &s->irq_ir_udhram_corr);
    sysbus_init_irq(sbd, &s->irq_ir_udhram_uncorr);
}

static const VMStateDescription vmstate_mmi_udh_slcr = {
    .name = TYPE_XILINX_MMI_UDH_SLCR,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, MMI_UDH_SLCR, MMI_UDH_SLCR_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static void mmi_udh_slcr_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);

    dc->realize = mmi_udh_slcr_realize;
    dc->vmsd = &vmstate_mmi_udh_slcr;
    rc->phases.enter = mmi_udh_slcr_reset_enter;
    rc->phases.hold = mmi_udh_slcr_reset_hold;
}

static const TypeInfo mmi_udh_slcr_info = {
    .name          = TYPE_XILINX_MMI_UDH_SLCR,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(MMI_UDH_SLCR),
    .class_init    = mmi_udh_slcr_class_init,
    .instance_init = mmi_udh_slcr_init,
};

static void mmi_udh_slcr_register_types(void)
{
    type_register_static(&mmi_udh_slcr_info);
}

type_init(mmi_udh_slcr_register_types)
