/*
 * QEMU model of the PsxcLpxSlcrSecure Global secure system level control
 * registers
 *
 * Copyright (c) 2024, Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "qemu/osdep.h"
#include "hw/sysbus.h"
#include "hw/register.h"
#include "hw/resettable.h"
#include "qemu/bitops.h"
#include "qemu/log.h"
#include "migration/vmstate.h"
#include "hw/irq.h"
#include "hw/fdt_generic_util.h"

#ifndef XILINX_PSXC_LPX_SLCR_SECURE_ERR_DEBUG
#define XILINX_PSXC_LPX_SLCR_SECURE_ERR_DEBUG 0
#endif

#define TYPE_XILINX_PSXC_LPX_SLCR_SECURE "xlnx.versal2-psxc-lpx-slcr-secure"

#define XILINX_PSXC_LPX_SLCR_SECURE(obj) \
     OBJECT_CHECK(PsxcLpxSlcrSecure, (obj), TYPE_XILINX_PSXC_LPX_SLCR_SECURE)

REG32(WPROT0, 0x0)
    FIELD(WPROT0, ACTIVE, 0, 1)
REG32(TZ_OCMBANK0, 0x20)
    FIELD(TZ_OCMBANK0, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK1, 0x24)
    FIELD(TZ_OCMBANK1, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK2, 0x28)
    FIELD(TZ_OCMBANK2, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK3, 0x2c)
    FIELD(TZ_OCMBANK3, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK0_XMPU, 0x30)
    FIELD(TZ_OCMBANK0_XMPU, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK1_XMPU, 0x34)
    FIELD(TZ_OCMBANK1_XMPU, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK2_XMPU, 0x38)
    FIELD(TZ_OCMBANK2_XMPU, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMBANK3_XMPU, 0x3c)
    FIELD(TZ_OCMBANK3_XMPU, TZ_CTRL_N, 0, 1)
REG32(TZ_INTOCM_XMPU_TCM, 0x40)
    FIELD(TZ_INTOCM_XMPU_TCM, TZ_CTRL_N, 0, 1)
REG32(TZ_AFIFS_XMPU, 0x44)
    FIELD(TZ_AFIFS_XMPU, TZ_CTRL_N, 0, 1)
REG32(TZ_AFIFS_CONFIG, 0x48)
    FIELD(TZ_AFIFS_CONFIG, TZ_CTRL_N, 0, 1)
REG32(TZ_OCMSLVS_XMPU, 0x4c)
    FIELD(TZ_OCMSLVS_XMPU, TZ_CTRL_N, 0, 1)
REG32(TZ_XPPU, 0x50)
    FIELD(TZ_XPPU, TZ_CTRL_N, 0, 1)
REG32(SAFETY_CHK, 0x60)
REG32(TZ_MMI_PCSR, 0x64)
    FIELD(TZ_MMI_PCSR, TZ_CTRL_N, 0, 1)
REG32(TZ_IPI, 0x68)
    FIELD(TZ_IPI, TZ_CTRL_N, 0, 1)
REG32(TZ_CRL, 0x6c)
    FIELD(TZ_CRL, TZ_CTRL_N, 0, 1)
REG32(TZ_HSDP, 0x70)
    FIELD(TZ_HSDP, TZ_CTRL_AURORA_N, 2, 1)
    FIELD(TZ_HSDP, TZ_CTRL_N, 1, 1)
    FIELD(TZ_HSDP, TZ_CTRL_APB_N, 0, 1)
REG32(TZ_AFI_FM, 0x74)
    FIELD(TZ_AFI_FM, TZ_CTRL_N, 0, 1)
REG32(TZ_LPD_SLCR, 0x78)
    FIELD(TZ_LPD_SLCR, TZ_CTRL_N, 0, 1)
REG32(TZ_ASU_GLOBAL, 0x7c)
    FIELD(TZ_ASU_GLOBAL, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA0, 0x80)
    FIELD(TZ_ADMA0, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA1, 0x84)
    FIELD(TZ_ADMA1, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA2, 0x88)
    FIELD(TZ_ADMA2, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA3, 0x8c)
    FIELD(TZ_ADMA3, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA4, 0x90)
    FIELD(TZ_ADMA4, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA5, 0x94)
    FIELD(TZ_ADMA5, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA6, 0x98)
    FIELD(TZ_ADMA6, TZ_CTRL_N, 0, 1)
REG32(TZ_ADMA7, 0x9c)
    FIELD(TZ_ADMA7, TZ_CTRL_N, 0, 1)
REG32(LPX_TZ_CNTRL_LOCK, 0xa0)
    FIELD(LPX_TZ_CNTRL_LOCK, TZ_CNTRL_LOCK_N, 0, 1)
REG32(TZ_RPUA, 0xb0)
    FIELD(TZ_RPUA, TZ_CTRL_N, 0, 1)
REG32(TZ_RPUB, 0xb4)
    FIELD(TZ_RPUB, TZ_CTRL_N, 0, 1)
REG32(TZ_RPUC, 0xb8)
    FIELD(TZ_RPUC, TZ_CTRL_N, 0, 1)
REG32(TZ_RPUD, 0xbc)
    FIELD(TZ_RPUD, TZ_CTRL_N, 0, 1)
REG32(TZ_RPUE, 0xc0)
    FIELD(TZ_RPUE, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_A0, 0xd0)
    FIELD(TZ_R52_A0, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_A1, 0xd4)
    FIELD(TZ_R52_A1, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_B0, 0xd8)
    FIELD(TZ_R52_B0, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_B1, 0xdc)
    FIELD(TZ_R52_B1, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_C0, 0xe0)
    FIELD(TZ_R52_C0, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_C1, 0xe4)
    FIELD(TZ_R52_C1, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_D0, 0xe8)
    FIELD(TZ_R52_D0, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_D1, 0xec)
    FIELD(TZ_R52_D1, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_E0, 0xf0)
    FIELD(TZ_R52_E0, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_E1, 0xf4)
    FIELD(TZ_R52_E1, TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_A0, 0x100)
    FIELD(TZ_R52_AXI_A0, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_A1, 0x104)
    FIELD(TZ_R52_AXI_A1, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_B0, 0x108)
    FIELD(TZ_R52_AXI_B0, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_B1, 0x10c)
    FIELD(TZ_R52_AXI_B1, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_C0, 0x110)
    FIELD(TZ_R52_AXI_C0, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_C1, 0x114)
    FIELD(TZ_R52_AXI_C1, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_D0, 0x118)
    FIELD(TZ_R52_AXI_D0, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_D1, 0x11c)
    FIELD(TZ_R52_AXI_D1, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_E0, 0x120)
    FIELD(TZ_R52_AXI_E0, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_R52_AXI_E1, 0x124)
    FIELD(TZ_R52_AXI_E1, AXIM_TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA0, 0x180)
    FIELD(TZ_SDMA0, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA1, 0x184)
    FIELD(TZ_SDMA1, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA2, 0x188)
    FIELD(TZ_SDMA2, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA3, 0x18c)
    FIELD(TZ_SDMA3, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA4, 0x190)
    FIELD(TZ_SDMA4, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA5, 0x194)
    FIELD(TZ_SDMA5, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA6, 0x198)
    FIELD(TZ_SDMA6, TZ_CTRL_N, 0, 1)
REG32(TZ_SDMA7, 0x19c)
    FIELD(TZ_SDMA7, TZ_CTRL_N, 0, 1)
REG32(TZ_INT_LPX_ASILB, 0x1a0)
    FIELD(TZ_INT_LPX_ASILB, TZ_CTRL_N, 0, 1)
REG32(TZ_INT_LPX_ASILD, 0x1a4)
    FIELD(TZ_INT_LPX_ASILD, TZ_CTRL_N, 0, 1)
REG32(TZ_INT_OCM_ASILB, 0x1a8)
    FIELD(TZ_INT_OCM_ASILB, TZ_CTRL_N, 0, 1)
REG32(TZ_INT_OCM_ASILD, 0x1ac)
    FIELD(TZ_INT_OCM_ASILD, TZ_CTRL_N, 0, 1)
REG32(TZ_INT_OCM_SPLIT, 0x1b0)
    FIELD(TZ_INT_OCM_SPLIT, TZ_CTRL_N, 0, 1)
REG32(RPUA0_SMID_LOCK, 0x400)
    FIELD(RPUA0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUA0_SMID_OVRD_EN, 0x404)
    FIELD(RPUA0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUA0_SMID_VAL, 0x408)
    FIELD(RPUA0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUA0_SMID_MASK, 0x40c)
    FIELD(RPUA0_SMID_MASK, MASK, 0, 10)
REG32(RPUA1_SMID_LOCK, 0x410)
    FIELD(RPUA1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUA1_SMID_OVRD_EN, 0x414)
    FIELD(RPUA1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUA1_SMID_VAL, 0x418)
    FIELD(RPUA1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUA1_SMID_MASK, 0x41c)
    FIELD(RPUA1_SMID_MASK, MASK, 0, 10)
REG32(RPUB0_SMID_LOCK, 0x420)
    FIELD(RPUB0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUB0_SMID_OVRD_EN, 0x424)
    FIELD(RPUB0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUB0_SMID_VAL, 0x428)
    FIELD(RPUB0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUB0_SMID_MASK, 0x42c)
    FIELD(RPUB0_SMID_MASK, MASK, 0, 10)
REG32(RPUB1_SMID_LOCK, 0x430)
    FIELD(RPUB1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUB1_SMID_OVRD_EN, 0x434)
    FIELD(RPUB1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUB1_SMID_VAL, 0x438)
    FIELD(RPUB1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUB1_SMID_MASK, 0x43c)
    FIELD(RPUB1_SMID_MASK, MASK, 0, 10)
REG32(RPUC0_SMID_LOCK, 0x440)
    FIELD(RPUC0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUC0_SMID_OVRD_EN, 0x444)
    FIELD(RPUC0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUC0_SMID_VAL, 0x448)
    FIELD(RPUC0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUC0_SMID_MASK, 0x44c)
    FIELD(RPUC0_SMID_MASK, MASK, 0, 10)
REG32(RPUC1_SMID_LOCK, 0x450)
    FIELD(RPUC1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUC1_SMID_OVRD_EN, 0x454)
    FIELD(RPUC1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUC1_SMID_VAL, 0x458)
    FIELD(RPUC1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUC1_SMID_MASK, 0x45c)
    FIELD(RPUC1_SMID_MASK, MASK, 0, 10)
REG32(RPUD0_SMID_LOCK, 0x460)
    FIELD(RPUD0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUD0_SMID_OVRD_EN, 0x464)
    FIELD(RPUD0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUD0_SMID_VAL, 0x468)
    FIELD(RPUD0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUD0_SMID_MASK, 0x46c)
    FIELD(RPUD0_SMID_MASK, MASK, 0, 10)
REG32(RPUD1_SMID_LOCK, 0x470)
    FIELD(RPUD1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUD1_SMID_OVRD_EN, 0x474)
    FIELD(RPUD1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUD1_SMID_VAL, 0x478)
    FIELD(RPUD1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUD1_SMID_MASK, 0x47c)
    FIELD(RPUD1_SMID_MASK, MASK, 0, 10)
REG32(RPUE0_SMID_LOCK, 0x480)
    FIELD(RPUE0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUE0_SMID_OVRD_EN, 0x484)
    FIELD(RPUE0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUE0_SMID_VAL, 0x488)
    FIELD(RPUE0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUE0_SMID_MASK, 0x48c)
    FIELD(RPUE0_SMID_MASK, MASK, 0, 10)
REG32(RPUE1_SMID_LOCK, 0x490)
    FIELD(RPUE1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(RPUE1_SMID_OVRD_EN, 0x494)
    FIELD(RPUE1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(RPUE1_SMID_VAL, 0x498)
    FIELD(RPUE1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(RPUE1_SMID_MASK, 0x49c)
    FIELD(RPUE1_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH0_SMID_LOCK, 0x500)
    FIELD(ADMA_CH0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH0_SMID_OVRD_EN, 0x504)
    FIELD(ADMA_CH0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH0_SMID_VAL, 0x508)
    FIELD(ADMA_CH0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH0_SMID_MASK, 0x50c)
    FIELD(ADMA_CH0_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH1_SMID_LOCK, 0x510)
    FIELD(ADMA_CH1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH1_SMID_OVRD_EN, 0x514)
    FIELD(ADMA_CH1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH1_SMID_VAL, 0x518)
    FIELD(ADMA_CH1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH1_SMID_MASK, 0x51c)
    FIELD(ADMA_CH1_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH2_SMID_LOCK, 0x520)
    FIELD(ADMA_CH2_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH2_SMID_OVRD_EN, 0x524)
    FIELD(ADMA_CH2_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH2_SMID_VAL, 0x528)
    FIELD(ADMA_CH2_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH2_SMID_MASK, 0x52c)
    FIELD(ADMA_CH2_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH3_SMID_LOCK, 0x530)
    FIELD(ADMA_CH3_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH3_SMID_OVRD_EN, 0x534)
    FIELD(ADMA_CH3_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH3_SMID_VAL, 0x538)
    FIELD(ADMA_CH3_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH3_SMID_MASK, 0x53c)
    FIELD(ADMA_CH3_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH4_SMID_LOCK, 0x540)
    FIELD(ADMA_CH4_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH4_SMID_OVRD_EN, 0x544)
    FIELD(ADMA_CH4_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH4_SMID_VAL, 0x548)
    FIELD(ADMA_CH4_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH4_SMID_MASK, 0x54c)
    FIELD(ADMA_CH4_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH5_SMID_LOCK, 0x550)
    FIELD(ADMA_CH5_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH5_SMID_OVRD_EN, 0x554)
    FIELD(ADMA_CH5_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH5_SMID_VAL, 0x558)
    FIELD(ADMA_CH5_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH5_SMID_MASK, 0x55c)
    FIELD(ADMA_CH5_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH6_SMID_LOCK, 0x560)
    FIELD(ADMA_CH6_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH6_SMID_OVRD_EN, 0x564)
    FIELD(ADMA_CH6_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH6_SMID_VAL, 0x568)
    FIELD(ADMA_CH6_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH6_SMID_MASK, 0x56c)
    FIELD(ADMA_CH6_SMID_MASK, MASK, 0, 10)
REG32(ADMA_CH7_SMID_LOCK, 0x570)
    FIELD(ADMA_CH7_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(ADMA_CH7_SMID_OVRD_EN, 0x574)
    FIELD(ADMA_CH7_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(ADMA_CH7_SMID_VAL, 0x578)
    FIELD(ADMA_CH7_SMID_VAL, SMID_VALUE, 0, 10)
REG32(ADMA_CH7_SMID_MASK, 0x57c)
    FIELD(ADMA_CH7_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH0_SMID_LOCK, 0x580)
    FIELD(SDMA_CH0_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH0_SMID_OVRD_EN, 0x584)
    FIELD(SDMA_CH0_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH0_SMID_VAL, 0x588)
    FIELD(SDMA_CH0_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH0_SMID_MASK, 0x58c)
    FIELD(SDMA_CH0_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH1_SMID_LOCK, 0x590)
    FIELD(SDMA_CH1_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH1_SMID_OVRD_EN, 0x594)
    FIELD(SDMA_CH1_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH1_SMID_VAL, 0x598)
    FIELD(SDMA_CH1_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH1_SMID_MASK, 0x59c)
    FIELD(SDMA_CH1_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH2_SMID_LOCK, 0x5a0)
    FIELD(SDMA_CH2_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH2_SMID_OVRD_EN, 0x5a4)
    FIELD(SDMA_CH2_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH2_SMID_VAL, 0x5a8)
    FIELD(SDMA_CH2_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH2_SMID_MASK, 0x5ac)
    FIELD(SDMA_CH2_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH3_SMID_LOCK, 0x5b0)
    FIELD(SDMA_CH3_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH3_SMID_OVRD_EN, 0x5b4)
    FIELD(SDMA_CH3_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH3_SMID_VAL, 0x5b8)
    FIELD(SDMA_CH3_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH3_SMID_MASK, 0x5bc)
    FIELD(SDMA_CH3_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH4_SMID_LOCK, 0x5c0)
    FIELD(SDMA_CH4_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH4_SMID_OVRD_EN, 0x5c4)
    FIELD(SDMA_CH4_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH4_SMID_VAL, 0x5c8)
    FIELD(SDMA_CH4_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH4_SMID_MASK, 0x5cc)
    FIELD(SDMA_CH4_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH5_SMID_LOCK, 0x5d0)
    FIELD(SDMA_CH5_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH5_SMID_OVRD_EN, 0x5d4)
    FIELD(SDMA_CH5_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH5_SMID_VAL, 0x5d8)
    FIELD(SDMA_CH5_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH5_SMID_MASK, 0x5dc)
    FIELD(SDMA_CH5_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH6_SMID_LOCK, 0x5e0)
    FIELD(SDMA_CH6_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH6_SMID_OVRD_EN, 0x5e4)
    FIELD(SDMA_CH6_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH6_SMID_VAL, 0x5e8)
    FIELD(SDMA_CH6_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH6_SMID_MASK, 0x5ec)
    FIELD(SDMA_CH6_SMID_MASK, MASK, 0, 10)
REG32(SDMA_CH7_SMID_LOCK, 0x5f0)
    FIELD(SDMA_CH7_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(SDMA_CH7_SMID_OVRD_EN, 0x5f4)
    FIELD(SDMA_CH7_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(SDMA_CH7_SMID_VAL, 0x5f8)
    FIELD(SDMA_CH7_SMID_VAL, SMID_VALUE, 0, 10)
REG32(SDMA_CH7_SMID_MASK, 0x5fc)
    FIELD(SDMA_CH7_SMID_MASK, MASK, 0, 10)
REG32(HSDP_DMA_SMID_LOCK, 0x600)
    FIELD(HSDP_DMA_SMID_LOCK, SMID_CNTRL_LOCK_N, 0, 1)
REG32(HSDP_DMA_SMID_OVRD_EN, 0x604)
    FIELD(HSDP_DMA_SMID_OVRD_EN, ENABLE, 0, 1)
REG32(HSDP_DMA_SMID_VAL, 0x608)
    FIELD(HSDP_DMA_SMID_VAL, SMID_VALUE, 0, 10)
REG32(HSDP_DMA_SMID_MASK, 0x60c)
    FIELD(HSDP_DMA_SMID_MASK, MASK, 0, 10)
REG32(LPX_SMP_CNTRL_LOCK, 0x800)
    FIELD(LPX_SMP_CNTRL_LOCK, SMP_MODE_CNTRL_LOCK_N, 0, 1)
REG32(MIO_SMP_MODE_STATUS, 0x804)
    FIELD(MIO_SMP_MODE_STATUS, MIO_SMP_MODE, 0, 1)
REG32(LPX_SMP_MODE_OVERRIDE, 0x808)
    FIELD(LPX_SMP_MODE_OVERRIDE, OVER_SMP_MODE, 1, 1)
    FIELD(LPX_SMP_MODE_OVERRIDE, SMP_MODE_OVER_EN, 0, 1)
REG32(LPX_SMP_MODE, 0x80c)
    FIELD(LPX_SMP_MODE, LPD_FPD_SMP_MODE, 0, 1)
REG32(RSTMON0_STATUS, 0x900)
    FIELD(RSTMON0_STATUS, RST31_ERR, 31, 1)
    FIELD(RSTMON0_STATUS, RST30_ERR, 30, 1)
    FIELD(RSTMON0_STATUS, RST29_ERR, 29, 1)
    FIELD(RSTMON0_STATUS, RST28_ERR, 28, 1)
    FIELD(RSTMON0_STATUS, RST27_ERR, 27, 1)
    FIELD(RSTMON0_STATUS, RST26_ERR, 26, 1)
    FIELD(RSTMON0_STATUS, RST25_ERR, 25, 1)
    FIELD(RSTMON0_STATUS, RST24_ERR, 24, 1)
    FIELD(RSTMON0_STATUS, RST23_ERR, 23, 1)
    FIELD(RSTMON0_STATUS, RST22_ERR, 22, 1)
    FIELD(RSTMON0_STATUS, RST21_ERR, 21, 1)
    FIELD(RSTMON0_STATUS, RST20_ERR, 20, 1)
    FIELD(RSTMON0_STATUS, RST19_ERR, 19, 1)
    FIELD(RSTMON0_STATUS, RST18_ERR, 18, 1)
    FIELD(RSTMON0_STATUS, RST17_ERR, 17, 1)
    FIELD(RSTMON0_STATUS, RST16_ERR, 16, 1)
    FIELD(RSTMON0_STATUS, RST15_ERR, 15, 1)
    FIELD(RSTMON0_STATUS, RST14_ERR, 14, 1)
    FIELD(RSTMON0_STATUS, RST13_ERR, 13, 1)
    FIELD(RSTMON0_STATUS, RST12_ERR, 12, 1)
    FIELD(RSTMON0_STATUS, RST11_ERR, 11, 1)
    FIELD(RSTMON0_STATUS, RST10_ERR, 10, 1)
    FIELD(RSTMON0_STATUS, RST9_ERR, 9, 1)
    FIELD(RSTMON0_STATUS, RST8_ERR, 8, 1)
    FIELD(RSTMON0_STATUS, RST7_ERR, 7, 1)
    FIELD(RSTMON0_STATUS, RST6_ERR, 6, 1)
    FIELD(RSTMON0_STATUS, RST5_ERR, 5, 1)
    FIELD(RSTMON0_STATUS, RST4_ERR, 4, 1)
    FIELD(RSTMON0_STATUS, RST3_ERR, 3, 1)
    FIELD(RSTMON0_STATUS, RST2_ERR, 2, 1)
    FIELD(RSTMON0_STATUS, RST1_ERR, 1, 1)
    FIELD(RSTMON0_STATUS, RST0_ERR, 0, 1)
REG32(RSTMON0_MASK, 0x904)
    FIELD(RSTMON0_MASK, RST31_ERR, 31, 1)
    FIELD(RSTMON0_MASK, RST30_ERR, 30, 1)
    FIELD(RSTMON0_MASK, RST29_ERR, 29, 1)
    FIELD(RSTMON0_MASK, RST28_ERR, 28, 1)
    FIELD(RSTMON0_MASK, RST27_ERR, 27, 1)
    FIELD(RSTMON0_MASK, RST26_ERR, 26, 1)
    FIELD(RSTMON0_MASK, RST25_ERR, 25, 1)
    FIELD(RSTMON0_MASK, RST24_ERR, 24, 1)
    FIELD(RSTMON0_MASK, RST23_ERR, 23, 1)
    FIELD(RSTMON0_MASK, RST22_ERR, 22, 1)
    FIELD(RSTMON0_MASK, RST21_ERR, 21, 1)
    FIELD(RSTMON0_MASK, RST20_ERR, 20, 1)
    FIELD(RSTMON0_MASK, RST19_ERR, 19, 1)
    FIELD(RSTMON0_MASK, RST18_ERR, 18, 1)
    FIELD(RSTMON0_MASK, RST17_ERR, 17, 1)
    FIELD(RSTMON0_MASK, RST16_ERR, 16, 1)
    FIELD(RSTMON0_MASK, RST15_ERR, 15, 1)
    FIELD(RSTMON0_MASK, RST14_ERR, 14, 1)
    FIELD(RSTMON0_MASK, RST13_ERR, 13, 1)
    FIELD(RSTMON0_MASK, RST12_ERR, 12, 1)
    FIELD(RSTMON0_MASK, RST11_ERR, 11, 1)
    FIELD(RSTMON0_MASK, RST10_ERR, 10, 1)
    FIELD(RSTMON0_MASK, RST9_ERR, 9, 1)
    FIELD(RSTMON0_MASK, RST8_ERR, 8, 1)
    FIELD(RSTMON0_MASK, RST7_ERR, 7, 1)
    FIELD(RSTMON0_MASK, RST6_ERR, 6, 1)
    FIELD(RSTMON0_MASK, RST5_ERR, 5, 1)
    FIELD(RSTMON0_MASK, RST4_ERR, 4, 1)
    FIELD(RSTMON0_MASK, RST3_ERR, 3, 1)
    FIELD(RSTMON0_MASK, RST2_ERR, 2, 1)
    FIELD(RSTMON0_MASK, RST1_ERR, 1, 1)
    FIELD(RSTMON0_MASK, RST0_ERR, 0, 1)
REG32(RSTMON0_ENABLE, 0x908)
    FIELD(RSTMON0_ENABLE, RST31_ERR, 31, 1)
    FIELD(RSTMON0_ENABLE, RST30_ERR, 30, 1)
    FIELD(RSTMON0_ENABLE, RST29_ERR, 29, 1)
    FIELD(RSTMON0_ENABLE, RST28_ERR, 28, 1)
    FIELD(RSTMON0_ENABLE, RST27_ERR, 27, 1)
    FIELD(RSTMON0_ENABLE, RST26_ERR, 26, 1)
    FIELD(RSTMON0_ENABLE, RST25_ERR, 25, 1)
    FIELD(RSTMON0_ENABLE, RST24_ERR, 24, 1)
    FIELD(RSTMON0_ENABLE, RST23_ERR, 23, 1)
    FIELD(RSTMON0_ENABLE, RST22_ERR, 22, 1)
    FIELD(RSTMON0_ENABLE, RST21_ERR, 21, 1)
    FIELD(RSTMON0_ENABLE, RST20_ERR, 20, 1)
    FIELD(RSTMON0_ENABLE, RST19_ERR, 19, 1)
    FIELD(RSTMON0_ENABLE, RST18_ERR, 18, 1)
    FIELD(RSTMON0_ENABLE, RST17_ERR, 17, 1)
    FIELD(RSTMON0_ENABLE, RST16_ERR, 16, 1)
    FIELD(RSTMON0_ENABLE, RST15_ERR, 15, 1)
    FIELD(RSTMON0_ENABLE, RST14_ERR, 14, 1)
    FIELD(RSTMON0_ENABLE, RST13_ERR, 13, 1)
    FIELD(RSTMON0_ENABLE, RST12_ERR, 12, 1)
    FIELD(RSTMON0_ENABLE, RST11_ERR, 11, 1)
    FIELD(RSTMON0_ENABLE, RST10_ERR, 10, 1)
    FIELD(RSTMON0_ENABLE, RST9_ERR, 9, 1)
    FIELD(RSTMON0_ENABLE, RST8_ERR, 8, 1)
    FIELD(RSTMON0_ENABLE, RST7_ERR, 7, 1)
    FIELD(RSTMON0_ENABLE, RST6_ERR, 6, 1)
    FIELD(RSTMON0_ENABLE, RST5_ERR, 5, 1)
    FIELD(RSTMON0_ENABLE, RST4_ERR, 4, 1)
    FIELD(RSTMON0_ENABLE, RST3_ERR, 3, 1)
    FIELD(RSTMON0_ENABLE, RST2_ERR, 2, 1)
    FIELD(RSTMON0_ENABLE, RST1_ERR, 1, 1)
    FIELD(RSTMON0_ENABLE, RST0_ERR, 0, 1)
REG32(RSTMON0_DISABLE, 0x90c)
    FIELD(RSTMON0_DISABLE, RST31_ERR, 31, 1)
    FIELD(RSTMON0_DISABLE, RST30_ERR, 30, 1)
    FIELD(RSTMON0_DISABLE, RST29_ERR, 29, 1)
    FIELD(RSTMON0_DISABLE, RST28_ERR, 28, 1)
    FIELD(RSTMON0_DISABLE, RST27_ERR, 27, 1)
    FIELD(RSTMON0_DISABLE, RST26_ERR, 26, 1)
    FIELD(RSTMON0_DISABLE, RST25_ERR, 25, 1)
    FIELD(RSTMON0_DISABLE, RST24_ERR, 24, 1)
    FIELD(RSTMON0_DISABLE, RST23_ERR, 23, 1)
    FIELD(RSTMON0_DISABLE, RST22_ERR, 22, 1)
    FIELD(RSTMON0_DISABLE, RST21_ERR, 21, 1)
    FIELD(RSTMON0_DISABLE, RST20_ERR, 20, 1)
    FIELD(RSTMON0_DISABLE, RST19_ERR, 19, 1)
    FIELD(RSTMON0_DISABLE, RST18_ERR, 18, 1)
    FIELD(RSTMON0_DISABLE, RST17_ERR, 17, 1)
    FIELD(RSTMON0_DISABLE, RST16_ERR, 16, 1)
    FIELD(RSTMON0_DISABLE, RST15_ERR, 15, 1)
    FIELD(RSTMON0_DISABLE, RST14_ERR, 14, 1)
    FIELD(RSTMON0_DISABLE, RST13_ERR, 13, 1)
    FIELD(RSTMON0_DISABLE, RST12_ERR, 12, 1)
    FIELD(RSTMON0_DISABLE, RST11_ERR, 11, 1)
    FIELD(RSTMON0_DISABLE, RST10_ERR, 10, 1)
    FIELD(RSTMON0_DISABLE, RST9_ERR, 9, 1)
    FIELD(RSTMON0_DISABLE, RST8_ERR, 8, 1)
    FIELD(RSTMON0_DISABLE, RST7_ERR, 7, 1)
    FIELD(RSTMON0_DISABLE, RST6_ERR, 6, 1)
    FIELD(RSTMON0_DISABLE, RST5_ERR, 5, 1)
    FIELD(RSTMON0_DISABLE, RST4_ERR, 4, 1)
    FIELD(RSTMON0_DISABLE, RST3_ERR, 3, 1)
    FIELD(RSTMON0_DISABLE, RST2_ERR, 2, 1)
    FIELD(RSTMON0_DISABLE, RST1_ERR, 1, 1)
    FIELD(RSTMON0_DISABLE, RST0_ERR, 0, 1)
REG32(RSTMON0_TRIGGER, 0x910)
    FIELD(RSTMON0_TRIGGER, RST31_ERR, 31, 1)
    FIELD(RSTMON0_TRIGGER, RST30_ERR, 30, 1)
    FIELD(RSTMON0_TRIGGER, RST29_ERR, 29, 1)
    FIELD(RSTMON0_TRIGGER, RST28_ERR, 28, 1)
    FIELD(RSTMON0_TRIGGER, RST27_ERR, 27, 1)
    FIELD(RSTMON0_TRIGGER, RST26_ERR, 26, 1)
    FIELD(RSTMON0_TRIGGER, RST25_ERR, 25, 1)
    FIELD(RSTMON0_TRIGGER, RST24_ERR, 24, 1)
    FIELD(RSTMON0_TRIGGER, RST23_ERR, 23, 1)
    FIELD(RSTMON0_TRIGGER, RST22_ERR, 22, 1)
    FIELD(RSTMON0_TRIGGER, RST21_ERR, 21, 1)
    FIELD(RSTMON0_TRIGGER, RST20_ERR, 20, 1)
    FIELD(RSTMON0_TRIGGER, RST19_ERR, 19, 1)
    FIELD(RSTMON0_TRIGGER, RST18_ERR, 18, 1)
    FIELD(RSTMON0_TRIGGER, RST17_ERR, 17, 1)
    FIELD(RSTMON0_TRIGGER, RST16_ERR, 16, 1)
    FIELD(RSTMON0_TRIGGER, RST15_ERR, 15, 1)
    FIELD(RSTMON0_TRIGGER, RST14_ERR, 14, 1)
    FIELD(RSTMON0_TRIGGER, RST13_ERR, 13, 1)
    FIELD(RSTMON0_TRIGGER, RST12_ERR, 12, 1)
    FIELD(RSTMON0_TRIGGER, RST11_ERR, 11, 1)
    FIELD(RSTMON0_TRIGGER, RST10_ERR, 10, 1)
    FIELD(RSTMON0_TRIGGER, RST9_ERR, 9, 1)
    FIELD(RSTMON0_TRIGGER, RST8_ERR, 8, 1)
    FIELD(RSTMON0_TRIGGER, RST7_ERR, 7, 1)
    FIELD(RSTMON0_TRIGGER, RST6_ERR, 6, 1)
    FIELD(RSTMON0_TRIGGER, RST5_ERR, 5, 1)
    FIELD(RSTMON0_TRIGGER, RST4_ERR, 4, 1)
    FIELD(RSTMON0_TRIGGER, RST3_ERR, 3, 1)
    FIELD(RSTMON0_TRIGGER, RST2_ERR, 2, 1)
    FIELD(RSTMON0_TRIGGER, RST1_ERR, 1, 1)
    FIELD(RSTMON0_TRIGGER, RST0_ERR, 0, 1)
REG32(RSTMON1_STATUS, 0x914)
    FIELD(RSTMON1_STATUS, RST60_ERR, 28, 1)
    FIELD(RSTMON1_STATUS, RST59_ERR, 27, 1)
    FIELD(RSTMON1_STATUS, RST58_ERR, 26, 1)
    FIELD(RSTMON1_STATUS, RST57_ERR, 25, 1)
    FIELD(RSTMON1_STATUS, RST56_ERR, 24, 1)
    FIELD(RSTMON1_STATUS, RST55_ERR, 23, 1)
    FIELD(RSTMON1_STATUS, RST54_ERR, 22, 1)
    FIELD(RSTMON1_STATUS, RST53_ERR, 21, 1)
    FIELD(RSTMON1_STATUS, RST52_ERR, 20, 1)
    FIELD(RSTMON1_STATUS, RST51_ERR, 19, 1)
    FIELD(RSTMON1_STATUS, RST50_ERR, 18, 1)
    FIELD(RSTMON1_STATUS, RST49_ERR, 17, 1)
    FIELD(RSTMON1_STATUS, RST48_ERR, 16, 1)
    FIELD(RSTMON1_STATUS, RST47_ERR, 15, 1)
    FIELD(RSTMON1_STATUS, RST46_ERR, 14, 1)
    FIELD(RSTMON1_STATUS, RST45_ERR, 13, 1)
    FIELD(RSTMON1_STATUS, RST44_ERR, 12, 1)
    FIELD(RSTMON1_STATUS, RST43_ERR, 11, 1)
    FIELD(RSTMON1_STATUS, RST42_ERR, 10, 1)
    FIELD(RSTMON1_STATUS, RST41_ERR, 9, 1)
    FIELD(RSTMON1_STATUS, RST40_ERR, 8, 1)
    FIELD(RSTMON1_STATUS, RST39_ERR, 7, 1)
    FIELD(RSTMON1_STATUS, RST38_ERR, 6, 1)
    FIELD(RSTMON1_STATUS, RST37_ERR, 5, 1)
    FIELD(RSTMON1_STATUS, RST36_ERR, 4, 1)
    FIELD(RSTMON1_STATUS, RST35_ERR, 3, 1)
    FIELD(RSTMON1_STATUS, RST34_ERR, 2, 1)
    FIELD(RSTMON1_STATUS, RST33_ERR, 1, 1)
    FIELD(RSTMON1_STATUS, RST32_ERR, 0, 1)
REG32(RSTMON1_MASK, 0x918)
    FIELD(RSTMON1_MASK, RST60_ERR, 28, 1)
    FIELD(RSTMON1_MASK, RST59_ERR, 27, 1)
    FIELD(RSTMON1_MASK, RST58_ERR, 26, 1)
    FIELD(RSTMON1_MASK, RST57_ERR, 25, 1)
    FIELD(RSTMON1_MASK, RST56_ERR, 24, 1)
    FIELD(RSTMON1_MASK, RST55_ERR, 23, 1)
    FIELD(RSTMON1_MASK, RST54_ERR, 22, 1)
    FIELD(RSTMON1_MASK, RST53_ERR, 21, 1)
    FIELD(RSTMON1_MASK, RST52_ERR, 20, 1)
    FIELD(RSTMON1_MASK, RST51_ERR, 19, 1)
    FIELD(RSTMON1_MASK, RST50_ERR, 18, 1)
    FIELD(RSTMON1_MASK, RST49_ERR, 17, 1)
    FIELD(RSTMON1_MASK, RST48_ERR, 16, 1)
    FIELD(RSTMON1_MASK, RST47_ERR, 15, 1)
    FIELD(RSTMON1_MASK, RST46_ERR, 14, 1)
    FIELD(RSTMON1_MASK, RST45_ERR, 13, 1)
    FIELD(RSTMON1_MASK, RST44_ERR, 12, 1)
    FIELD(RSTMON1_MASK, RST43_ERR, 11, 1)
    FIELD(RSTMON1_MASK, RST42_ERR, 10, 1)
    FIELD(RSTMON1_MASK, RST41_ERR, 9, 1)
    FIELD(RSTMON1_MASK, RST40_ERR, 8, 1)
    FIELD(RSTMON1_MASK, RST39_ERR, 7, 1)
    FIELD(RSTMON1_MASK, RST38_ERR, 6, 1)
    FIELD(RSTMON1_MASK, RST37_ERR, 5, 1)
    FIELD(RSTMON1_MASK, RST36_ERR, 4, 1)
    FIELD(RSTMON1_MASK, RST35_ERR, 3, 1)
    FIELD(RSTMON1_MASK, RST34_ERR, 2, 1)
    FIELD(RSTMON1_MASK, RST33_ERR, 1, 1)
    FIELD(RSTMON1_MASK, RST32_ERR, 0, 1)
REG32(RSTMON1_ENABLE, 0x91c)
    FIELD(RSTMON1_ENABLE, RST60_ERR, 28, 1)
    FIELD(RSTMON1_ENABLE, RST59_ERR, 27, 1)
    FIELD(RSTMON1_ENABLE, RST58_ERR, 26, 1)
    FIELD(RSTMON1_ENABLE, RST57_ERR, 25, 1)
    FIELD(RSTMON1_ENABLE, RST56_ERR, 24, 1)
    FIELD(RSTMON1_ENABLE, RST55_ERR, 23, 1)
    FIELD(RSTMON1_ENABLE, RST54_ERR, 22, 1)
    FIELD(RSTMON1_ENABLE, RST53_ERR, 21, 1)
    FIELD(RSTMON1_ENABLE, RST52_ERR, 20, 1)
    FIELD(RSTMON1_ENABLE, RST51_ERR, 19, 1)
    FIELD(RSTMON1_ENABLE, RST50_ERR, 18, 1)
    FIELD(RSTMON1_ENABLE, RST49_ERR, 17, 1)
    FIELD(RSTMON1_ENABLE, RST48_ERR, 16, 1)
    FIELD(RSTMON1_ENABLE, RST47_ERR, 15, 1)
    FIELD(RSTMON1_ENABLE, RST46_ERR, 14, 1)
    FIELD(RSTMON1_ENABLE, RST45_ERR, 13, 1)
    FIELD(RSTMON1_ENABLE, RST44_ERR, 12, 1)
    FIELD(RSTMON1_ENABLE, RST43_ERR, 11, 1)
    FIELD(RSTMON1_ENABLE, RST42_ERR, 10, 1)
    FIELD(RSTMON1_ENABLE, RST41_ERR, 9, 1)
    FIELD(RSTMON1_ENABLE, RST40_ERR, 8, 1)
    FIELD(RSTMON1_ENABLE, RST39_ERR, 7, 1)
    FIELD(RSTMON1_ENABLE, RST38_ERR, 6, 1)
    FIELD(RSTMON1_ENABLE, RST37_ERR, 5, 1)
    FIELD(RSTMON1_ENABLE, RST36_ERR, 4, 1)
    FIELD(RSTMON1_ENABLE, RST35_ERR, 3, 1)
    FIELD(RSTMON1_ENABLE, RST34_ERR, 2, 1)
    FIELD(RSTMON1_ENABLE, RST33_ERR, 1, 1)
    FIELD(RSTMON1_ENABLE, RST32_ERR, 0, 1)
REG32(RSTMON1_DISABLE, 0x920)
    FIELD(RSTMON1_DISABLE, RST60_ERR, 28, 1)
    FIELD(RSTMON1_DISABLE, RST59_ERR, 27, 1)
    FIELD(RSTMON1_DISABLE, RST58_ERR, 26, 1)
    FIELD(RSTMON1_DISABLE, RST57_ERR, 25, 1)
    FIELD(RSTMON1_DISABLE, RST56_ERR, 24, 1)
    FIELD(RSTMON1_DISABLE, RST55_ERR, 23, 1)
    FIELD(RSTMON1_DISABLE, RST54_ERR, 22, 1)
    FIELD(RSTMON1_DISABLE, RST53_ERR, 21, 1)
    FIELD(RSTMON1_DISABLE, RST52_ERR, 20, 1)
    FIELD(RSTMON1_DISABLE, RST51_ERR, 19, 1)
    FIELD(RSTMON1_DISABLE, RST50_ERR, 18, 1)
    FIELD(RSTMON1_DISABLE, RST49_ERR, 17, 1)
    FIELD(RSTMON1_DISABLE, RST48_ERR, 16, 1)
    FIELD(RSTMON1_DISABLE, RST47_ERR, 15, 1)
    FIELD(RSTMON1_DISABLE, RST46_ERR, 14, 1)
    FIELD(RSTMON1_DISABLE, RST45_ERR, 13, 1)
    FIELD(RSTMON1_DISABLE, RST44_ERR, 12, 1)
    FIELD(RSTMON1_DISABLE, RST43_ERR, 11, 1)
    FIELD(RSTMON1_DISABLE, RST42_ERR, 10, 1)
    FIELD(RSTMON1_DISABLE, RST41_ERR, 9, 1)
    FIELD(RSTMON1_DISABLE, RST40_ERR, 8, 1)
    FIELD(RSTMON1_DISABLE, RST39_ERR, 7, 1)
    FIELD(RSTMON1_DISABLE, RST38_ERR, 6, 1)
    FIELD(RSTMON1_DISABLE, RST37_ERR, 5, 1)
    FIELD(RSTMON1_DISABLE, RST36_ERR, 4, 1)
    FIELD(RSTMON1_DISABLE, RST35_ERR, 3, 1)
    FIELD(RSTMON1_DISABLE, RST34_ERR, 2, 1)
    FIELD(RSTMON1_DISABLE, RST33_ERR, 1, 1)
    FIELD(RSTMON1_DISABLE, RST32_ERR, 0, 1)
REG32(RSTMON1_TRIGGER, 0x924)
    FIELD(RSTMON1_TRIGGER, RST60_ERR, 28, 1)
    FIELD(RSTMON1_TRIGGER, RST59_ERR, 27, 1)
    FIELD(RSTMON1_TRIGGER, RST58_ERR, 26, 1)
    FIELD(RSTMON1_TRIGGER, RST57_ERR, 25, 1)
    FIELD(RSTMON1_TRIGGER, RST56_ERR, 24, 1)
    FIELD(RSTMON1_TRIGGER, RST55_ERR, 23, 1)
    FIELD(RSTMON1_TRIGGER, RST54_ERR, 22, 1)
    FIELD(RSTMON1_TRIGGER, RST53_ERR, 21, 1)
    FIELD(RSTMON1_TRIGGER, RST52_ERR, 20, 1)
    FIELD(RSTMON1_TRIGGER, RST51_ERR, 19, 1)
    FIELD(RSTMON1_TRIGGER, RST50_ERR, 18, 1)
    FIELD(RSTMON1_TRIGGER, RST49_ERR, 17, 1)
    FIELD(RSTMON1_TRIGGER, RST48_ERR, 16, 1)
    FIELD(RSTMON1_TRIGGER, RST47_ERR, 15, 1)
    FIELD(RSTMON1_TRIGGER, RST46_ERR, 14, 1)
    FIELD(RSTMON1_TRIGGER, RST45_ERR, 13, 1)
    FIELD(RSTMON1_TRIGGER, RST44_ERR, 12, 1)
    FIELD(RSTMON1_TRIGGER, RST43_ERR, 11, 1)
    FIELD(RSTMON1_TRIGGER, RST42_ERR, 10, 1)
    FIELD(RSTMON1_TRIGGER, RST41_ERR, 9, 1)
    FIELD(RSTMON1_TRIGGER, RST40_ERR, 8, 1)
    FIELD(RSTMON1_TRIGGER, RST39_ERR, 7, 1)
    FIELD(RSTMON1_TRIGGER, RST38_ERR, 6, 1)
    FIELD(RSTMON1_TRIGGER, RST37_ERR, 5, 1)
    FIELD(RSTMON1_TRIGGER, RST36_ERR, 4, 1)
    FIELD(RSTMON1_TRIGGER, RST35_ERR, 3, 1)
    FIELD(RSTMON1_TRIGGER, RST34_ERR, 2, 1)
    FIELD(RSTMON1_TRIGGER, RST33_ERR, 1, 1)
    FIELD(RSTMON1_TRIGGER, RST32_ERR, 0, 1)
REG32(CLKMON_STATUS, 0x930)
    FIELD(CLKMON_STATUS, CNTA15_OVER_ERR, 31, 1)
    FIELD(CLKMON_STATUS, MON15_ERR, 30, 1)
    FIELD(CLKMON_STATUS, CNTA14_OVER_ERR, 29, 1)
    FIELD(CLKMON_STATUS, MON14_ERR, 28, 1)
    FIELD(CLKMON_STATUS, CNTA13_OVER_ERR, 27, 1)
    FIELD(CLKMON_STATUS, MON13_ERR, 26, 1)
    FIELD(CLKMON_STATUS, CNTA12_OVER_ERR, 25, 1)
    FIELD(CLKMON_STATUS, MON12_ERR, 24, 1)
    FIELD(CLKMON_STATUS, CNTA11_OVER_ERR, 23, 1)
    FIELD(CLKMON_STATUS, MON11_ERR, 22, 1)
    FIELD(CLKMON_STATUS, CNTA10_OVER_ERR, 21, 1)
    FIELD(CLKMON_STATUS, MON10_ERR, 20, 1)
    FIELD(CLKMON_STATUS, CNTA9_OVER_ERR, 19, 1)
    FIELD(CLKMON_STATUS, MON9_ERR, 18, 1)
    FIELD(CLKMON_STATUS, CNTA8_OVER_ERR, 17, 1)
    FIELD(CLKMON_STATUS, MON8_ERR, 16, 1)
    FIELD(CLKMON_STATUS, CNTA7_OVER_ERR, 15, 1)
    FIELD(CLKMON_STATUS, MON7_ERR, 14, 1)
    FIELD(CLKMON_STATUS, CNTA6_OVER_ERR, 13, 1)
    FIELD(CLKMON_STATUS, MON6_ERR, 12, 1)
    FIELD(CLKMON_STATUS, CNTA5_OVER_ERR, 11, 1)
    FIELD(CLKMON_STATUS, MON5_ERR, 10, 1)
    FIELD(CLKMON_STATUS, CNTA4_OVER_ERR, 9, 1)
    FIELD(CLKMON_STATUS, MON4_ERR, 8, 1)
    FIELD(CLKMON_STATUS, CNTA3_OVER_ERR, 7, 1)
    FIELD(CLKMON_STATUS, MON3_ERR, 6, 1)
    FIELD(CLKMON_STATUS, CNTA2_OVER_ERR, 5, 1)
    FIELD(CLKMON_STATUS, MON2_ERR, 4, 1)
    FIELD(CLKMON_STATUS, CNTA1_OVER_ERR, 3, 1)
    FIELD(CLKMON_STATUS, MON1_ERR, 2, 1)
    FIELD(CLKMON_STATUS, CNTA0_OVER_ERR, 1, 1)
    FIELD(CLKMON_STATUS, MON0_ERR, 0, 1)
REG32(CLKMON_MASK, 0x934)
    FIELD(CLKMON_MASK, CNTA15_OVER_ERR, 31, 1)
    FIELD(CLKMON_MASK, MON15_ERR, 30, 1)
    FIELD(CLKMON_MASK, CNTA14_OVER_ERR, 29, 1)
    FIELD(CLKMON_MASK, MON14_ERR, 28, 1)
    FIELD(CLKMON_MASK, CNTA13_OVER_ERR, 27, 1)
    FIELD(CLKMON_MASK, MON13_ERR, 26, 1)
    FIELD(CLKMON_MASK, CNTA12_OVER_ERR, 25, 1)
    FIELD(CLKMON_MASK, MON12_ERR, 24, 1)
    FIELD(CLKMON_MASK, CNTA11_OVER_ERR, 23, 1)
    FIELD(CLKMON_MASK, MON11_ERR, 22, 1)
    FIELD(CLKMON_MASK, CNTA10_OVER_ERR, 21, 1)
    FIELD(CLKMON_MASK, MON10_ERR, 20, 1)
    FIELD(CLKMON_MASK, CNTA9_OVER_ERR, 19, 1)
    FIELD(CLKMON_MASK, MON9_ERR, 18, 1)
    FIELD(CLKMON_MASK, CNTA8_OVER_ERR, 17, 1)
    FIELD(CLKMON_MASK, MON8_ERR, 16, 1)
    FIELD(CLKMON_MASK, CNTA7_OVER_ERR, 15, 1)
    FIELD(CLKMON_MASK, MON7_ERR, 14, 1)
    FIELD(CLKMON_MASK, CNTA6_OVER_ERR, 13, 1)
    FIELD(CLKMON_MASK, MON6_ERR, 12, 1)
    FIELD(CLKMON_MASK, CNTA5_OVER_ERR, 11, 1)
    FIELD(CLKMON_MASK, MON5_ERR, 10, 1)
    FIELD(CLKMON_MASK, CNTA4_OVER_ERR, 9, 1)
    FIELD(CLKMON_MASK, MON4_ERR, 8, 1)
    FIELD(CLKMON_MASK, CNTA3_OVER_ERR, 7, 1)
    FIELD(CLKMON_MASK, MON3_ERR, 6, 1)
    FIELD(CLKMON_MASK, CNTA2_OVER_ERR, 5, 1)
    FIELD(CLKMON_MASK, MON2_ERR, 4, 1)
    FIELD(CLKMON_MASK, CNTA1_OVER_ERR, 3, 1)
    FIELD(CLKMON_MASK, MON1_ERR, 2, 1)
    FIELD(CLKMON_MASK, CNTA0_OVER_ERR, 1, 1)
    FIELD(CLKMON_MASK, MON0_ERR, 0, 1)
REG32(CLKMON_ENABLE, 0x938)
    FIELD(CLKMON_ENABLE, CNTA15_OVER_ERR, 31, 1)
    FIELD(CLKMON_ENABLE, MON15_ERR, 30, 1)
    FIELD(CLKMON_ENABLE, CNTA14_OVER_ERR, 29, 1)
    FIELD(CLKMON_ENABLE, MON14_ERR, 28, 1)
    FIELD(CLKMON_ENABLE, CNTA13_OVER_ERR, 27, 1)
    FIELD(CLKMON_ENABLE, MON13_ERR, 26, 1)
    FIELD(CLKMON_ENABLE, CNTA12_OVER_ERR, 25, 1)
    FIELD(CLKMON_ENABLE, MON12_ERR, 24, 1)
    FIELD(CLKMON_ENABLE, CNTA11_OVER_ERR, 23, 1)
    FIELD(CLKMON_ENABLE, MON11_ERR, 22, 1)
    FIELD(CLKMON_ENABLE, CNTA10_OVER_ERR, 21, 1)
    FIELD(CLKMON_ENABLE, MON10_ERR, 20, 1)
    FIELD(CLKMON_ENABLE, CNTA9_OVER_ERR, 19, 1)
    FIELD(CLKMON_ENABLE, MON9_ERR, 18, 1)
    FIELD(CLKMON_ENABLE, CNTA8_OVER_ERR, 17, 1)
    FIELD(CLKMON_ENABLE, MON8_ERR, 16, 1)
    FIELD(CLKMON_ENABLE, CNTA7_OVER_ERR, 15, 1)
    FIELD(CLKMON_ENABLE, MON7_ERR, 14, 1)
    FIELD(CLKMON_ENABLE, CNTA6_OVER_ERR, 13, 1)
    FIELD(CLKMON_ENABLE, MON6_ERR, 12, 1)
    FIELD(CLKMON_ENABLE, CNTA5_OVER_ERR, 11, 1)
    FIELD(CLKMON_ENABLE, MON5_ERR, 10, 1)
    FIELD(CLKMON_ENABLE, CNTA4_OVER_ERR, 9, 1)
    FIELD(CLKMON_ENABLE, MON4_ERR, 8, 1)
    FIELD(CLKMON_ENABLE, CNTA3_OVER_ERR, 7, 1)
    FIELD(CLKMON_ENABLE, MON3_ERR, 6, 1)
    FIELD(CLKMON_ENABLE, CNTA2_OVER_ERR, 5, 1)
    FIELD(CLKMON_ENABLE, MON2_ERR, 4, 1)
    FIELD(CLKMON_ENABLE, CNTA1_OVER_ERR, 3, 1)
    FIELD(CLKMON_ENABLE, MON1_ERR, 2, 1)
    FIELD(CLKMON_ENABLE, CNTA0_OVER_ERR, 1, 1)
    FIELD(CLKMON_ENABLE, MON0_ERR, 0, 1)
REG32(CLKMON_DISABLE, 0x93c)
    FIELD(CLKMON_DISABLE, CNTA15_OVER_ERR, 31, 1)
    FIELD(CLKMON_DISABLE, MON15_ERR, 30, 1)
    FIELD(CLKMON_DISABLE, CNTA14_OVER_ERR, 29, 1)
    FIELD(CLKMON_DISABLE, MON14_ERR, 28, 1)
    FIELD(CLKMON_DISABLE, CNTA13_OVER_ERR, 27, 1)
    FIELD(CLKMON_DISABLE, MON13_ERR, 26, 1)
    FIELD(CLKMON_DISABLE, CNTA12_OVER_ERR, 25, 1)
    FIELD(CLKMON_DISABLE, MON12_ERR, 24, 1)
    FIELD(CLKMON_DISABLE, CNTA11_OVER_ERR, 23, 1)
    FIELD(CLKMON_DISABLE, MON11_ERR, 22, 1)
    FIELD(CLKMON_DISABLE, CNTA10_OVER_ERR, 21, 1)
    FIELD(CLKMON_DISABLE, MON10_ERR, 20, 1)
    FIELD(CLKMON_DISABLE, CNTA9_OVER_ERR, 19, 1)
    FIELD(CLKMON_DISABLE, MON9_ERR, 18, 1)
    FIELD(CLKMON_DISABLE, CNTA8_OVER_ERR, 17, 1)
    FIELD(CLKMON_DISABLE, MON8_ERR, 16, 1)
    FIELD(CLKMON_DISABLE, CNTA7_OVER_ERR, 15, 1)
    FIELD(CLKMON_DISABLE, MON7_ERR, 14, 1)
    FIELD(CLKMON_DISABLE, CNTA6_OVER_ERR, 13, 1)
    FIELD(CLKMON_DISABLE, MON6_ERR, 12, 1)
    FIELD(CLKMON_DISABLE, CNTA5_OVER_ERR, 11, 1)
    FIELD(CLKMON_DISABLE, MON5_ERR, 10, 1)
    FIELD(CLKMON_DISABLE, CNTA4_OVER_ERR, 9, 1)
    FIELD(CLKMON_DISABLE, MON4_ERR, 8, 1)
    FIELD(CLKMON_DISABLE, CNTA3_OVER_ERR, 7, 1)
    FIELD(CLKMON_DISABLE, MON3_ERR, 6, 1)
    FIELD(CLKMON_DISABLE, CNTA2_OVER_ERR, 5, 1)
    FIELD(CLKMON_DISABLE, MON2_ERR, 4, 1)
    FIELD(CLKMON_DISABLE, CNTA1_OVER_ERR, 3, 1)
    FIELD(CLKMON_DISABLE, MON1_ERR, 2, 1)
    FIELD(CLKMON_DISABLE, CNTA0_OVER_ERR, 1, 1)
    FIELD(CLKMON_DISABLE, MON0_ERR, 0, 1)
REG32(CLKMON_TRIGGER, 0x940)
    FIELD(CLKMON_TRIGGER, CNTA15_OVER_ERR, 31, 1)
    FIELD(CLKMON_TRIGGER, MON15_ERR, 30, 1)
    FIELD(CLKMON_TRIGGER, CNTA14_OVER_ERR, 29, 1)
    FIELD(CLKMON_TRIGGER, MON14_ERR, 28, 1)
    FIELD(CLKMON_TRIGGER, CNTA13_OVER_ERR, 27, 1)
    FIELD(CLKMON_TRIGGER, MON13_ERR, 26, 1)
    FIELD(CLKMON_TRIGGER, CNTA12_OVER_ERR, 25, 1)
    FIELD(CLKMON_TRIGGER, MON12_ERR, 24, 1)
    FIELD(CLKMON_TRIGGER, CNTA11_OVER_ERR, 23, 1)
    FIELD(CLKMON_TRIGGER, MON11_ERR, 22, 1)
    FIELD(CLKMON_TRIGGER, CNTA10_OVER_ERR, 21, 1)
    FIELD(CLKMON_TRIGGER, MON10_ERR, 20, 1)
    FIELD(CLKMON_TRIGGER, CNTA9_OVER_ERR, 19, 1)
    FIELD(CLKMON_TRIGGER, MON9_ERR, 18, 1)
    FIELD(CLKMON_TRIGGER, CNTA8_OVER_ERR, 17, 1)
    FIELD(CLKMON_TRIGGER, MON8_ERR, 16, 1)
    FIELD(CLKMON_TRIGGER, CNTA7_OVER_ERR, 15, 1)
    FIELD(CLKMON_TRIGGER, MON7_ERR, 14, 1)
    FIELD(CLKMON_TRIGGER, CNTA6_OVER_ERR, 13, 1)
    FIELD(CLKMON_TRIGGER, MON6_ERR, 12, 1)
    FIELD(CLKMON_TRIGGER, CNTA5_OVER_ERR, 11, 1)
    FIELD(CLKMON_TRIGGER, MON5_ERR, 10, 1)
    FIELD(CLKMON_TRIGGER, CNTA4_OVER_ERR, 9, 1)
    FIELD(CLKMON_TRIGGER, MON4_ERR, 8, 1)
    FIELD(CLKMON_TRIGGER, CNTA3_OVER_ERR, 7, 1)
    FIELD(CLKMON_TRIGGER, MON3_ERR, 6, 1)
    FIELD(CLKMON_TRIGGER, CNTA2_OVER_ERR, 5, 1)
    FIELD(CLKMON_TRIGGER, MON2_ERR, 4, 1)
    FIELD(CLKMON_TRIGGER, CNTA1_OVER_ERR, 3, 1)
    FIELD(CLKMON_TRIGGER, MON1_ERR, 2, 1)
    FIELD(CLKMON_TRIGGER, CNTA0_OVER_ERR, 1, 1)
    FIELD(CLKMON_TRIGGER, MON0_ERR, 0, 1)
REG32(CHKR0_CLKA_UPPER, 0x950)
REG32(CHKR0_CLKA_LOWER, 0x954)
REG32(CHKR0_CLKB_CNT, 0x958)
REG32(CHKR0_CLKA_PRELOAD_CNT, 0x95c)
REG32(CHKR0_CTRL, 0x960)
    FIELD(CHKR0_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR0_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR0_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR0_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR0_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR0_CTRL, ENABLE, 1, 1)
    FIELD(CHKR0_CTRL, RESET, 0, 1)
REG32(CHKR1_CLKA_UPPER, 0x964)
REG32(CHKR1_CLKA_LOWER, 0x968)
REG32(CHKR1_CLKB_CNT, 0x96c)
REG32(CHKR1_CLKA_PRELOAD_CNT, 0x970)
REG32(CHKR1_CTRL, 0x984)
    FIELD(CHKR1_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR1_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR1_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR1_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR1_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR1_CTRL, ENABLE, 1, 1)
    FIELD(CHKR1_CTRL, RESET, 0, 1)
REG32(CHKR2_CLKA_UPPER, 0x988)
REG32(CHKR2_CLKA_LOWER, 0x98c)
REG32(CHKR2_CLKB_CNT, 0x990)
REG32(CHKR2_CLKA_PRELOAD_CNT, 0x994)
REG32(CHKR2_CTRL, 0x998)
    FIELD(CHKR2_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR2_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR2_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR2_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR2_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR2_CTRL, ENABLE, 1, 1)
    FIELD(CHKR2_CTRL, RESET, 0, 1)
REG32(CHKR3_CLKA_UPPER, 0x99c)
REG32(CHKR3_CLKA_LOWER, 0x9a0)
REG32(CHKR3_CLKB_CNT, 0x9a4)
REG32(CHKR3_CLKA_PRELOAD_CNT, 0x9a8)
REG32(CHKR3_CTRL, 0x9ac)
    FIELD(CHKR3_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR3_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR3_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR3_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR3_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR3_CTRL, ENABLE, 1, 1)
    FIELD(CHKR3_CTRL, RESET, 0, 1)
REG32(CHKR4_CLKA_UPPER, 0x9b0)
REG32(CHKR4_CLKA_LOWER, 0x9b4)
REG32(CHKR4_CLKB_CNT, 0x9b8)
REG32(CHKR4_CLKA_PRELOAD_CNT, 0x9bc)
REG32(CHKR4_CTRL, 0x9c0)
    FIELD(CHKR4_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR4_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR4_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR4_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR4_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR4_CTRL, ENABLE, 1, 1)
    FIELD(CHKR4_CTRL, RESET, 0, 1)
REG32(CHKR5_CLKA_UPPER, 0x9c4)
REG32(CHKR5_CLKA_LOWER, 0x9c8)
REG32(CHKR5_CLKB_CNT, 0x9cc)
REG32(CHKR5_CLKA_PRELOAD_CNT, 0x9d0)
REG32(CHKR5_CTRL, 0x9d4)
    FIELD(CHKR5_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR5_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR5_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR5_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR5_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR5_CTRL, ENABLE, 1, 1)
    FIELD(CHKR5_CTRL, RESET, 0, 1)
REG32(CHKR6_CLKA_UPPER, 0x9d8)
REG32(CHKR6_CLKA_LOWER, 0x9dc)
REG32(CHKR6_CLKB_CNT, 0x9e0)
REG32(CHKR6_CLKA_PRELOAD_CNT, 0x9e4)
REG32(CHKR6_CTRL, 0x9e8)
    FIELD(CHKR6_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR6_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR6_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR6_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR6_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR6_CTRL, ENABLE, 1, 1)
    FIELD(CHKR6_CTRL, RESET, 0, 1)
REG32(CHKR7_CLKA_UPPER, 0x9ec)
REG32(CHKR7_CLKA_LOWER, 0x9f0)
REG32(CHKR7_CLKB_CNT, 0x9f4)
REG32(CHKR7_CLKA_PRELOAD_CNT, 0x9f8)
REG32(CHKR7_CTRL, 0x9fc)
    FIELD(CHKR7_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR7_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR7_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR7_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR7_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR7_CTRL, ENABLE, 1, 1)
    FIELD(CHKR7_CTRL, RESET, 0, 1)
REG32(CHKR8_CLKA_UPPER, 0xa00)
REG32(CHKR8_CLKA_LOWER, 0xa04)
REG32(CHKR8_CLKB_CNT, 0xa08)
REG32(CHKR8_CLKA_PRELOAD_CNT, 0xa0c)
REG32(CHKR8_CTRL, 0xa14)
    FIELD(CHKR8_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR8_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR8_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR8_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR8_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR8_CTRL, ENABLE, 1, 1)
    FIELD(CHKR8_CTRL, RESET, 0, 1)
REG32(CHKR9_CLKA_UPPER, 0xa18)
REG32(CHKR9_CLKA_LOWER, 0xa1c)
REG32(CHKR9_CLKB_CNT, 0xa20)
REG32(CHKR9_CLKA_PRELOAD_CNT, 0xa24)
REG32(CHKR9_CTRL, 0xa28)
    FIELD(CHKR9_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR9_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR9_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR9_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR9_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR9_CTRL, ENABLE, 1, 1)
    FIELD(CHKR9_CTRL, RESET, 0, 1)
REG32(CHKR10_CLKA_UPPER, 0xa2c)
REG32(CHKR10_CLKA_LOWER, 0xa30)
REG32(CHKR10_CLKB_CNT, 0xa34)
REG32(CHKR10_CLKA_PRELOAD_CNT, 0xa38)
REG32(CHKR10_CTRL, 0xa3c)
    FIELD(CHKR10_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR10_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR10_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR10_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR10_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR10_CTRL, ENABLE, 1, 1)
    FIELD(CHKR10_CTRL, RESET, 0, 1)
REG32(CHKR11_CLKA_UPPER, 0xa40)
REG32(CHKR11_CLKA_LOWER, 0xa44)
REG32(CHKR11_CLKB_CNT, 0xa48)
REG32(CHKR11_CLKA_PRELOAD_CNT, 0xa4c)
REG32(CHKR11_CTRL, 0xa50)
    FIELD(CHKR11_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR11_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR11_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR11_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR11_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR11_CTRL, ENABLE, 1, 1)
    FIELD(CHKR11_CTRL, RESET, 0, 1)
REG32(CHKR12_CLKA_UPPER, 0xa54)
REG32(CHKR12_CLKA_LOWER, 0xa58)
REG32(CHKR12_CLKB_CNT, 0xa5c)
REG32(CHKR12_CLKA_PRELOAD_CNT, 0xa60)
REG32(CHKR12_CTRL, 0xa64)
    FIELD(CHKR12_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR12_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR12_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR12_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR12_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR12_CTRL, ENABLE, 1, 1)
    FIELD(CHKR12_CTRL, RESET, 0, 1)
REG32(CHKR13_CLKA_UPPER, 0xa68)
REG32(CHKR13_CLKA_LOWER, 0xa6c)
REG32(CHKR13_CLKB_CNT, 0xa70)
REG32(CHKR13_CLKA_PRELOAD_CNT, 0xa74)
REG32(CHKR13_CTRL, 0xa78)
    FIELD(CHKR13_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR13_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR13_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR13_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR13_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR13_CTRL, ENABLE, 1, 1)
    FIELD(CHKR13_CTRL, RESET, 0, 1)
REG32(CHKR14_CLKA_UPPER, 0xa7c)
REG32(CHKR14_CLKA_LOWER, 0xa80)
REG32(CHKR14_CLKB_CNT, 0xa84)
REG32(CHKR14_CLKA_PRELOAD_CNT, 0xa88)
REG32(CHKR14_CTRL, 0xa8c)
    FIELD(CHKR14_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR14_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR14_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR14_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR14_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR14_CTRL, ENABLE, 1, 1)
    FIELD(CHKR14_CTRL, RESET, 0, 1)
REG32(CHKR15_CLKA_UPPER, 0xa90)
REG32(CHKR15_CLKA_LOWER, 0xa94)
REG32(CHKR15_CLKB_CNT, 0xa98)
REG32(CHKR15_CLKA_PRELOAD_CNT, 0xa9c)
REG32(CHKR15_CTRL, 0xaa0)
    FIELD(CHKR15_CTRL, IDLE_STATE, 12, 1)
    FIELD(CHKR15_CTRL, START_SINGLE, 11, 1)
    FIELD(CHKR15_CTRL, START_CONTINUOUS, 10, 1)
    FIELD(CHKR15_CTRL, CLKB_MUX_CTRL, 8, 1)
    FIELD(CHKR15_CTRL, CLKA_MUX_CTRL, 2, 6)
    FIELD(CHKR15_CTRL, ENABLE, 1, 1)
    FIELD(CHKR15_CTRL, RESET, 0, 1)
REG32(SEC_OVER_MMU_TCU, 0xb00)
    FIELD(SEC_OVER_MMU_TCU, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU0, 0xb04)
    FIELD(SEC_OVER_MMU_TBU0, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU1, 0xb08)
    FIELD(SEC_OVER_MMU_TBU1, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU2, 0xb0c)
    FIELD(SEC_OVER_MMU_TBU2, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU3, 0xb10)
    FIELD(SEC_OVER_MMU_TBU3, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU4, 0xb14)
    FIELD(SEC_OVER_MMU_TBU4, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU5, 0xb18)
    FIELD(SEC_OVER_MMU_TBU5, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU6, 0xb1c)
    FIELD(SEC_OVER_MMU_TBU6, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU7, 0xb20)
    FIELD(SEC_OVER_MMU_TBU7, SEC_OVERRIDE, 0, 1)
REG32(SEC_OVER_MMU_TBU8, 0xb24)
    FIELD(SEC_OVER_MMU_TBU8, SEC_OVERRIDE, 0, 1)
REG32(MMUSECSID_CTRL_TBU, 0xb28)
    FIELD(MMUSECSID_CTRL_TBU, TBU8_MMUSECSID_CTRL, 8, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU7_MMUSECSID_CTRL, 7, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU6_MMUSECSID_CTRL, 6, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU5_MMUSECSID_CTRL, 5, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU4_MMUSECSID_CTRL, 4, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU3_MMUSECSID_CTRL, 3, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU2_MMUSECSID_CTRL, 2, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU1_MMUSECSID_CTRL, 1, 1)
    FIELD(MMUSECSID_CTRL_TBU, TBU0_MMUSECSID_CTRL, 0, 1)
REG32(MMU_SEC_OVER, 0xb30)
    FIELD(MMU_SEC_OVER, SEC_OVERRIDE, 0, 9)
REG32(LPX_CMN_INTERNAL_PROG, 0xd00)
    FIELD(LPX_CMN_INTERNAL_PROG, EN, 0, 1)
REG32(LPX_CMN_BYPASS, 0xd04)
    FIELD(LPX_CMN_BYPASS, EN, 0, 1)
REG32(LPX_RN_SAM_STALL_DIS, 0xd08)
    FIELD(LPX_RN_SAM_STALL_DIS, DISABLE, 0, 1)
REG32(RPU_SEC_OVER, 0xd80)
    FIELD(RPU_SEC_OVER, SEC_OVERRIDE, 0, 4)

#define PSXC_LPX_SLCR_SECURE_R_MAX (R_RPU_SEC_OVER + 1)

typedef struct PsxcLpxSlcrSecure {
    SysBusDevice parent_obj;
    MemoryRegion iomem;

    qemu_irq irq_rstmon0;
    qemu_irq irq_rstmon1;
    qemu_irq irq_clkmon;

    qemu_irq adma_secure[8];
    qemu_irq sdma_secure[8];

    uint32_t regs[PSXC_LPX_SLCR_SECURE_R_MAX];
    RegisterInfo regs_info[PSXC_LPX_SLCR_SECURE_R_MAX];
} PsxcLpxSlcrSecure;

static void rstmon0_update_irq(PsxcLpxSlcrSecure *s)
{
    bool pending = s->regs[R_RSTMON0_STATUS] & ~s->regs[R_RSTMON0_MASK];
    qemu_set_irq(s->irq_rstmon0, pending);
}

static void rstmon0_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);

    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon0_update_irq(s);
    }
}

static uint64_t rstmon0_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RSTMON0_MASK] &= ~val;
    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon0_update_irq(s);
    }
    return 0;
}

static uint64_t rstmon0_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RSTMON0_MASK] |= val;
    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon0_update_irq(s);
    }
    return 0;
}

static uint64_t rstmon0_trigger_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RSTMON0_STATUS] |= val;
    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon0_update_irq(s);
    }
    return 0;
}

static void rstmon1_update_irq(PsxcLpxSlcrSecure *s)
{
    bool pending = s->regs[R_RSTMON1_STATUS] & ~s->regs[R_RSTMON1_MASK];
    qemu_set_irq(s->irq_rstmon1, pending);
}

static void rstmon1_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);

    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon1_update_irq(s);
    }
}

static uint64_t rstmon1_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RSTMON1_MASK] &= ~val;
    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon1_update_irq(s);
    }
    return 0;
}

static uint64_t rstmon1_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RSTMON1_MASK] |= val;
    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon1_update_irq(s);
    }
    return 0;
}

static uint64_t rstmon1_trigger_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_RSTMON1_STATUS] |= val;
    if (!resettable_is_in_reset(OBJECT(s))) {
        rstmon1_update_irq(s);
    }
    return 0;
}

static void clkmon_update_irq(PsxcLpxSlcrSecure *s)
{
    bool pending = s->regs[R_CLKMON_STATUS] & ~s->regs[R_CLKMON_MASK];
    qemu_set_irq(s->irq_clkmon, pending);
}

static void clkmon_status_postw(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);

    if (!resettable_is_in_reset(OBJECT(s))) {
        clkmon_update_irq(s);
    }
}

static uint64_t clkmon_enable_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLKMON_MASK] &= ~val;

    if (!resettable_is_in_reset(OBJECT(s))) {
        clkmon_update_irq(s);
    }

    return 0;
}

static uint64_t clkmon_disable_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLKMON_MASK] |= val;

    if (!resettable_is_in_reset(OBJECT(s))) {
        clkmon_update_irq(s);
    }

    return 0;
}

static uint64_t clkmon_trigger_prew(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    uint32_t val = val64;

    s->regs[R_CLKMON_STATUS] |= val;

    if (!resettable_is_in_reset(OBJECT(s))) {
        clkmon_update_irq(s);
    }

    return 0;
}

static void tz_postw(RegisterInfo *reg, uint64_t val64)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(reg->opaque);
    size_t offset;
    uint32_t val = (uint32_t) val64;
    qemu_irq *gpio;

    switch (reg->access->addr) {
    case A_TZ_ADMA0 ... A_TZ_ADMA7:
        offset = (reg->access->addr - A_TZ_ADMA0) / reg->data_size;
        gpio = s->adma_secure;
        break;

    case A_TZ_SDMA0 ... A_TZ_SDMA7:
        offset = (reg->access->addr - A_TZ_SDMA0) / reg->data_size;
        gpio = s->sdma_secure;
        break;

    default:
        g_assert_not_reached();
    }

    if (!resettable_is_in_reset(OBJECT(s))) {
        qemu_set_irq(gpio[offset], !FIELD_EX32(val, TZ_ADMA0, TZ_CTRL_N));
    }
}

static const RegisterAccessInfo psxc_lpx_slcr_secure_regs_info[] = {
    {   .name = "WPROT0",  .addr = A_WPROT0,
        .reset = 0x1,
    },{ .name = "TZ_OCMBANK0",  .addr = A_TZ_OCMBANK0,
        .reset = 0x1,
    },{ .name = "TZ_OCMBANK1",  .addr = A_TZ_OCMBANK1,
        .reset = 0x1,
    },{ .name = "TZ_OCMBANK2",  .addr = A_TZ_OCMBANK2,
        .reset = 0x1,
    },{ .name = "TZ_OCMBANK3",  .addr = A_TZ_OCMBANK3,
        .reset = 0x1,
    },{ .name = "TZ_OCMBANK0_XMPU",  .addr = A_TZ_OCMBANK0_XMPU,
    },{ .name = "TZ_OCMBANK1_XMPU",  .addr = A_TZ_OCMBANK1_XMPU,
    },{ .name = "TZ_OCMBANK2_XMPU",  .addr = A_TZ_OCMBANK2_XMPU,
    },{ .name = "TZ_OCMBANK3_XMPU",  .addr = A_TZ_OCMBANK3_XMPU,
    },{ .name = "TZ_INTOCM_XMPU_TCM",  .addr = A_TZ_INTOCM_XMPU_TCM,
        .reset = 0x1,
    },{ .name = "TZ_AFIFS_XMPU",  .addr = A_TZ_AFIFS_XMPU,
    },{ .name = "TZ_AFIFS_CONFIG",  .addr = A_TZ_AFIFS_CONFIG,
        .reset = 0x1,
    },{ .name = "TZ_OCMSLVS_XMPU",  .addr = A_TZ_OCMSLVS_XMPU,
    },{ .name = "TZ_XPPU",  .addr = A_TZ_XPPU,
    },{ .name = "SAFETY_CHK",  .addr = A_SAFETY_CHK,
    },{ .name = "TZ_MMI_PCSR",  .addr = A_TZ_MMI_PCSR,
        .reset = 0x1,
    },{ .name = "TZ_IPI",  .addr = A_TZ_IPI,
    },{ .name = "TZ_CRL",  .addr = A_TZ_CRL,
        .reset = 0x1,
    },{ .name = "TZ_HSDP",  .addr = A_TZ_HSDP,
        .reset = 0x7,
    },{ .name = "TZ_AFI_FM",  .addr = A_TZ_AFI_FM,
        .reset = 0x1,
    },{ .name = "TZ_LPD_SLCR",  .addr = A_TZ_LPD_SLCR,
        .reset = 0x1,
    },{ .name = "TZ_ASU_GLOBAL",  .addr = A_TZ_ASU_GLOBAL,
        .reset = 0x1,
    },{ .name = "TZ_ADMA0",  .addr = A_TZ_ADMA0,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA1",  .addr = A_TZ_ADMA1,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA2",  .addr = A_TZ_ADMA2,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA3",  .addr = A_TZ_ADMA3,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA4",  .addr = A_TZ_ADMA4,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA5",  .addr = A_TZ_ADMA5,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA6",  .addr = A_TZ_ADMA6,
        .post_write = tz_postw,
    },{ .name = "TZ_ADMA7",  .addr = A_TZ_ADMA7,
        .post_write = tz_postw,
    },{ .name = "LPX_TZ_CNTRL_LOCK",  .addr = A_LPX_TZ_CNTRL_LOCK,
    },{ .name = "TZ_RPUA",  .addr = A_TZ_RPUA,
    },{ .name = "TZ_RPUB",  .addr = A_TZ_RPUB,
    },{ .name = "TZ_RPUC",  .addr = A_TZ_RPUC,
    },{ .name = "TZ_RPUD",  .addr = A_TZ_RPUD,
    },{ .name = "TZ_RPUE",  .addr = A_TZ_RPUE,
    },{ .name = "TZ_R52_A0",  .addr = A_TZ_R52_A0,
    },{ .name = "TZ_R52_A1",  .addr = A_TZ_R52_A1,
    },{ .name = "TZ_R52_B0",  .addr = A_TZ_R52_B0,
    },{ .name = "TZ_R52_B1",  .addr = A_TZ_R52_B1,
    },{ .name = "TZ_R52_C0",  .addr = A_TZ_R52_C0,
    },{ .name = "TZ_R52_C1",  .addr = A_TZ_R52_C1,
    },{ .name = "TZ_R52_D0",  .addr = A_TZ_R52_D0,
    },{ .name = "TZ_R52_D1",  .addr = A_TZ_R52_D1,
    },{ .name = "TZ_R52_E0",  .addr = A_TZ_R52_E0,
    },{ .name = "TZ_R52_E1",  .addr = A_TZ_R52_E1,
    },{ .name = "TZ_R52_AXI_A0",  .addr = A_TZ_R52_AXI_A0,
    },{ .name = "TZ_R52_AXI_A1",  .addr = A_TZ_R52_AXI_A1,
    },{ .name = "TZ_R52_AXI_B0",  .addr = A_TZ_R52_AXI_B0,
    },{ .name = "TZ_R52_AXI_B1",  .addr = A_TZ_R52_AXI_B1,
    },{ .name = "TZ_R52_AXI_C0",  .addr = A_TZ_R52_AXI_C0,
    },{ .name = "TZ_R52_AXI_C1",  .addr = A_TZ_R52_AXI_C1,
    },{ .name = "TZ_R52_AXI_D0",  .addr = A_TZ_R52_AXI_D0,
    },{ .name = "TZ_R52_AXI_D1",  .addr = A_TZ_R52_AXI_D1,
    },{ .name = "TZ_R52_AXI_E0",  .addr = A_TZ_R52_AXI_E0,
    },{ .name = "TZ_R52_AXI_E1",  .addr = A_TZ_R52_AXI_E1,
    },{ .name = "TZ_SDMA0",  .addr = A_TZ_SDMA0,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA1",  .addr = A_TZ_SDMA1,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA2",  .addr = A_TZ_SDMA2,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA3",  .addr = A_TZ_SDMA3,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA4",  .addr = A_TZ_SDMA4,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA5",  .addr = A_TZ_SDMA5,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA6",  .addr = A_TZ_SDMA6,
        .post_write = tz_postw,
    },{ .name = "TZ_SDMA7",  .addr = A_TZ_SDMA7,
        .post_write = tz_postw,
    },{ .name = "TZ_INT_LPX_ASILB",  .addr = A_TZ_INT_LPX_ASILB,
        .reset = 0x1,
    },{ .name = "TZ_INT_LPX_ASILD",  .addr = A_TZ_INT_LPX_ASILD,
        .reset = 0x1,
    },{ .name = "TZ_INT_OCM_ASILB",  .addr = A_TZ_INT_OCM_ASILB,
        .reset = 0x1,
    },{ .name = "TZ_INT_OCM_ASILD",  .addr = A_TZ_INT_OCM_ASILD,
        .reset = 0x1,
    },{ .name = "TZ_INT_OCM_SPLIT",  .addr = A_TZ_INT_OCM_SPLIT,
        .reset = 0x1,
    },{ .name = "RPUA0_SMID_LOCK",  .addr = A_RPUA0_SMID_LOCK,
    },{ .name = "RPUA0_SMID_OVRD_EN",  .addr = A_RPUA0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUA0_SMID_VAL",  .addr = A_RPUA0_SMID_VAL,
        .reset = 0x201,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUA0_SMID_MASK",  .addr = A_RPUA0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUA1_SMID_LOCK",  .addr = A_RPUA1_SMID_LOCK,
    },{ .name = "RPUA1_SMID_OVRD_EN",  .addr = A_RPUA1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUA1_SMID_VAL",  .addr = A_RPUA1_SMID_VAL,
        .reset = 0x209,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUA1_SMID_MASK",  .addr = A_RPUA1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUB0_SMID_LOCK",  .addr = A_RPUB0_SMID_LOCK,
    },{ .name = "RPUB0_SMID_OVRD_EN",  .addr = A_RPUB0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUB0_SMID_VAL",  .addr = A_RPUB0_SMID_VAL,
        .reset = 0x205,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUB0_SMID_MASK",  .addr = A_RPUB0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUB1_SMID_LOCK",  .addr = A_RPUB1_SMID_LOCK,
    },{ .name = "RPUB1_SMID_OVRD_EN",  .addr = A_RPUB1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUB1_SMID_VAL",  .addr = A_RPUB1_SMID_VAL,
        .reset = 0x20d,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUB1_SMID_MASK",  .addr = A_RPUB1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUC0_SMID_LOCK",  .addr = A_RPUC0_SMID_LOCK,
    },{ .name = "RPUC0_SMID_OVRD_EN",  .addr = A_RPUC0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUC0_SMID_VAL",  .addr = A_RPUC0_SMID_VAL,
        .reset = 0x202,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUC0_SMID_MASK",  .addr = A_RPUC0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUC1_SMID_LOCK",  .addr = A_RPUC1_SMID_LOCK,
    },{ .name = "RPUC1_SMID_OVRD_EN",  .addr = A_RPUC1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUC1_SMID_VAL",  .addr = A_RPUC1_SMID_VAL,
        .reset = 0x20a,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUC1_SMID_MASK",  .addr = A_RPUC1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUD0_SMID_LOCK",  .addr = A_RPUD0_SMID_LOCK,
    },{ .name = "RPUD0_SMID_OVRD_EN",  .addr = A_RPUD0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUD0_SMID_VAL",  .addr = A_RPUD0_SMID_VAL,
        .reset = 0x206,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUD0_SMID_MASK",  .addr = A_RPUD0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUD1_SMID_LOCK",  .addr = A_RPUD1_SMID_LOCK,
    },{ .name = "RPUD1_SMID_OVRD_EN",  .addr = A_RPUD1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUD1_SMID_VAL",  .addr = A_RPUD1_SMID_VAL,
        .reset = 0x20e,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUD1_SMID_MASK",  .addr = A_RPUD1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUE0_SMID_LOCK",  .addr = A_RPUE0_SMID_LOCK,
    },{ .name = "RPUE0_SMID_OVRD_EN",  .addr = A_RPUE0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUE0_SMID_VAL",  .addr = A_RPUE0_SMID_VAL,
        .reset = 0x203,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUE0_SMID_MASK",  .addr = A_RPUE0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUE1_SMID_LOCK",  .addr = A_RPUE1_SMID_LOCK,
    },{ .name = "RPUE1_SMID_OVRD_EN",  .addr = A_RPUE1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "RPUE1_SMID_VAL",  .addr = A_RPUE1_SMID_VAL,
        .reset = 0x20b,
        .rsvd = 0xfffffc00,
    },{ .name = "RPUE1_SMID_MASK",  .addr = A_RPUE1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH0_SMID_LOCK",  .addr = A_ADMA_CH0_SMID_LOCK,
    },{ .name = "ADMA_CH0_SMID_OVRD_EN",  .addr = A_ADMA_CH0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH0_SMID_VAL",  .addr = A_ADMA_CH0_SMID_VAL,
        .reset = 0x211,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH0_SMID_MASK",  .addr = A_ADMA_CH0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH1_SMID_LOCK",  .addr = A_ADMA_CH1_SMID_LOCK,
    },{ .name = "ADMA_CH1_SMID_OVRD_EN",  .addr = A_ADMA_CH1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH1_SMID_VAL",  .addr = A_ADMA_CH1_SMID_VAL,
        .reset = 0x212,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH1_SMID_MASK",  .addr = A_ADMA_CH1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH2_SMID_LOCK",  .addr = A_ADMA_CH2_SMID_LOCK,
    },{ .name = "ADMA_CH2_SMID_OVRD_EN",  .addr = A_ADMA_CH2_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH2_SMID_VAL",  .addr = A_ADMA_CH2_SMID_VAL,
        .reset = 0x215,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH2_SMID_MASK",  .addr = A_ADMA_CH2_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH3_SMID_LOCK",  .addr = A_ADMA_CH3_SMID_LOCK,
    },{ .name = "ADMA_CH3_SMID_OVRD_EN",  .addr = A_ADMA_CH3_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH3_SMID_VAL",  .addr = A_ADMA_CH3_SMID_VAL,
        .reset = 0x216,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH3_SMID_MASK",  .addr = A_ADMA_CH3_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH4_SMID_LOCK",  .addr = A_ADMA_CH4_SMID_LOCK,
    },{ .name = "ADMA_CH4_SMID_OVRD_EN",  .addr = A_ADMA_CH4_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH4_SMID_VAL",  .addr = A_ADMA_CH4_SMID_VAL,
        .reset = 0x219,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH4_SMID_MASK",  .addr = A_ADMA_CH4_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH5_SMID_LOCK",  .addr = A_ADMA_CH5_SMID_LOCK,
    },{ .name = "ADMA_CH5_SMID_OVRD_EN",  .addr = A_ADMA_CH5_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH5_SMID_VAL",  .addr = A_ADMA_CH5_SMID_VAL,
        .reset = 0x21a,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH5_SMID_MASK",  .addr = A_ADMA_CH5_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH6_SMID_LOCK",  .addr = A_ADMA_CH6_SMID_LOCK,
    },{ .name = "ADMA_CH6_SMID_OVRD_EN",  .addr = A_ADMA_CH6_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH6_SMID_VAL",  .addr = A_ADMA_CH6_SMID_VAL,
        .reset = 0x21d,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH6_SMID_MASK",  .addr = A_ADMA_CH6_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH7_SMID_LOCK",  .addr = A_ADMA_CH7_SMID_LOCK,
    },{ .name = "ADMA_CH7_SMID_OVRD_EN",  .addr = A_ADMA_CH7_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "ADMA_CH7_SMID_VAL",  .addr = A_ADMA_CH7_SMID_VAL,
        .reset = 0x21e,
        .rsvd = 0xfffffc00,
    },{ .name = "ADMA_CH7_SMID_MASK",  .addr = A_ADMA_CH7_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH0_SMID_LOCK",  .addr = A_SDMA_CH0_SMID_LOCK,
    },{ .name = "SDMA_CH0_SMID_OVRD_EN",  .addr = A_SDMA_CH0_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH0_SMID_VAL",  .addr = A_SDMA_CH0_SMID_VAL,
        .reset = 0x221,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH0_SMID_MASK",  .addr = A_SDMA_CH0_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH1_SMID_LOCK",  .addr = A_SDMA_CH1_SMID_LOCK,
    },{ .name = "SDMA_CH1_SMID_OVRD_EN",  .addr = A_SDMA_CH1_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH1_SMID_VAL",  .addr = A_SDMA_CH1_SMID_VAL,
        .reset = 0x222,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH1_SMID_MASK",  .addr = A_SDMA_CH1_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH2_SMID_LOCK",  .addr = A_SDMA_CH2_SMID_LOCK,
    },{ .name = "SDMA_CH2_SMID_OVRD_EN",  .addr = A_SDMA_CH2_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH2_SMID_VAL",  .addr = A_SDMA_CH2_SMID_VAL,
        .reset = 0x225,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH2_SMID_MASK",  .addr = A_SDMA_CH2_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH3_SMID_LOCK",  .addr = A_SDMA_CH3_SMID_LOCK,
    },{ .name = "SDMA_CH3_SMID_OVRD_EN",  .addr = A_SDMA_CH3_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH3_SMID_VAL",  .addr = A_SDMA_CH3_SMID_VAL,
        .reset = 0x226,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH3_SMID_MASK",  .addr = A_SDMA_CH3_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH4_SMID_LOCK",  .addr = A_SDMA_CH4_SMID_LOCK,
    },{ .name = "SDMA_CH4_SMID_OVRD_EN",  .addr = A_SDMA_CH4_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH4_SMID_VAL",  .addr = A_SDMA_CH4_SMID_VAL,
        .reset = 0x229,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH4_SMID_MASK",  .addr = A_SDMA_CH4_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH5_SMID_LOCK",  .addr = A_SDMA_CH5_SMID_LOCK,
    },{ .name = "SDMA_CH5_SMID_OVRD_EN",  .addr = A_SDMA_CH5_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH5_SMID_VAL",  .addr = A_SDMA_CH5_SMID_VAL,
        .reset = 0x22d,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH5_SMID_MASK",  .addr = A_SDMA_CH5_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH6_SMID_LOCK",  .addr = A_SDMA_CH6_SMID_LOCK,
    },{ .name = "SDMA_CH6_SMID_OVRD_EN",  .addr = A_SDMA_CH6_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH6_SMID_VAL",  .addr = A_SDMA_CH6_SMID_VAL,
        .reset = 0x22d,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH6_SMID_MASK",  .addr = A_SDMA_CH6_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH7_SMID_LOCK",  .addr = A_SDMA_CH7_SMID_LOCK,
    },{ .name = "SDMA_CH7_SMID_OVRD_EN",  .addr = A_SDMA_CH7_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "SDMA_CH7_SMID_VAL",  .addr = A_SDMA_CH7_SMID_VAL,
        .reset = 0x22e,
        .rsvd = 0xfffffc00,
    },{ .name = "SDMA_CH7_SMID_MASK",  .addr = A_SDMA_CH7_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "HSDP_DMA_SMID_LOCK",  .addr = A_HSDP_DMA_SMID_LOCK,
    },{ .name = "HSDP_DMA_SMID_OVRD_EN",  .addr = A_HSDP_DMA_SMID_OVRD_EN,
        .rsvd = 0xfffffffe,
    },{ .name = "HSDP_DMA_SMID_VAL",  .addr = A_HSDP_DMA_SMID_VAL,
        .reset = 0x239,
        .rsvd = 0xfffffc00,
    },{ .name = "HSDP_DMA_SMID_MASK",  .addr = A_HSDP_DMA_SMID_MASK,
        .rsvd = 0xfffffc00,
    },{ .name = "LPX_SMP_CNTRL_LOCK",  .addr = A_LPX_SMP_CNTRL_LOCK,
    },{ .name = "MIO_SMP_MODE_STATUS",  .addr = A_MIO_SMP_MODE_STATUS,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "LPX_SMP_MODE_OVERRIDE",  .addr = A_LPX_SMP_MODE_OVERRIDE,
        .rsvd = 0xfffffffc,
    },{ .name = "LPX_SMP_MODE",  .addr = A_LPX_SMP_MODE,
        .rsvd = 0xfffffffe,
        .ro = 0x1,
    },{ .name = "RSTMON0_STATUS",  .addr = A_RSTMON0_STATUS,
        .w1c = 0xffffffff,
        .post_write = rstmon0_status_postw,
    },{ .name = "RSTMON0_MASK",  .addr = A_RSTMON0_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "RSTMON0_ENABLE",  .addr = A_RSTMON0_ENABLE,
        .pre_write = rstmon0_enable_prew,
    },{ .name = "RSTMON0_DISABLE",  .addr = A_RSTMON0_DISABLE,
        .pre_write = rstmon0_disable_prew,
    },{ .name = "RSTMON0_TRIGGER",  .addr = A_RSTMON0_TRIGGER,
        .pre_write = rstmon0_trigger_prew,
    },{ .name = "RSTMON1_STATUS",  .addr = A_RSTMON1_STATUS,
        .rsvd = 0xe0000000,
        .w1c = 0x1fffffff,
        .post_write = rstmon1_status_postw,
    },{ .name = "RSTMON1_MASK",  .addr = A_RSTMON1_MASK,
        .reset = 0x1fffffff,
        .rsvd = 0xe0000000,
        .ro = 0x1fffffff,
    },{ .name = "RSTMON1_ENABLE",  .addr = A_RSTMON1_ENABLE,
        .rsvd = 0xe0000000,
        .pre_write = rstmon1_enable_prew,
    },{ .name = "RSTMON1_DISABLE",  .addr = A_RSTMON1_DISABLE,
        .rsvd = 0xe0000000,
        .pre_write = rstmon1_disable_prew,
    },{ .name = "RSTMON1_TRIGGER",  .addr = A_RSTMON1_TRIGGER,
        .rsvd = 0xe0000000,
        .pre_write = rstmon1_trigger_prew,
    },{ .name = "CLKMON_STATUS",  .addr = A_CLKMON_STATUS,
        .w1c = 0xffffffff,
        .post_write = clkmon_status_postw,
    },{ .name = "CLKMON_MASK",  .addr = A_CLKMON_MASK,
        .reset = 0xffffffff,
        .ro = 0xffffffff,
    },{ .name = "CLKMON_ENABLE",  .addr = A_CLKMON_ENABLE,
        .pre_write = clkmon_enable_prew,
    },{ .name = "CLKMON_DISABLE",  .addr = A_CLKMON_DISABLE,
        .pre_write = clkmon_disable_prew,
    },{ .name = "CLKMON_TRIGGER",  .addr = A_CLKMON_TRIGGER,
        .pre_write = clkmon_trigger_prew,
    },{ .name = "CHKR0_CLKA_UPPER",  .addr = A_CHKR0_CLKA_UPPER,
    },{ .name = "CHKR0_CLKA_LOWER",  .addr = A_CHKR0_CLKA_LOWER,
    },{ .name = "CHKR0_CLKB_CNT",  .addr = A_CHKR0_CLKB_CNT,
    },{ .name = "CHKR0_CLKA_PRELOAD_CNT",  .addr = A_CHKR0_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR0_CTRL",  .addr = A_CHKR0_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR1_CLKA_UPPER",  .addr = A_CHKR1_CLKA_UPPER,
    },{ .name = "CHKR1_CLKA_LOWER",  .addr = A_CHKR1_CLKA_LOWER,
    },{ .name = "CHKR1_CLKB_CNT",  .addr = A_CHKR1_CLKB_CNT,
    },{ .name = "CHKR1_CLKA_PRELOAD_CNT",  .addr = A_CHKR1_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR1_CTRL",  .addr = A_CHKR1_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR2_CLKA_UPPER",  .addr = A_CHKR2_CLKA_UPPER,
    },{ .name = "CHKR2_CLKA_LOWER",  .addr = A_CHKR2_CLKA_LOWER,
    },{ .name = "CHKR2_CLKB_CNT",  .addr = A_CHKR2_CLKB_CNT,
    },{ .name = "CHKR2_CLKA_PRELOAD_CNT",  .addr = A_CHKR2_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR2_CTRL",  .addr = A_CHKR2_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR3_CLKA_UPPER",  .addr = A_CHKR3_CLKA_UPPER,
    },{ .name = "CHKR3_CLKA_LOWER",  .addr = A_CHKR3_CLKA_LOWER,
    },{ .name = "CHKR3_CLKB_CNT",  .addr = A_CHKR3_CLKB_CNT,
    },{ .name = "CHKR3_CLKA_PRELOAD_CNT",  .addr = A_CHKR3_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR3_CTRL",  .addr = A_CHKR3_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR4_CLKA_UPPER",  .addr = A_CHKR4_CLKA_UPPER,
    },{ .name = "CHKR4_CLKA_LOWER",  .addr = A_CHKR4_CLKA_LOWER,
    },{ .name = "CHKR4_CLKB_CNT",  .addr = A_CHKR4_CLKB_CNT,
    },{ .name = "CHKR4_CLKA_PRELOAD_CNT",  .addr = A_CHKR4_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR4_CTRL",  .addr = A_CHKR4_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR5_CLKA_UPPER",  .addr = A_CHKR5_CLKA_UPPER,
    },{ .name = "CHKR5_CLKA_LOWER",  .addr = A_CHKR5_CLKA_LOWER,
    },{ .name = "CHKR5_CLKB_CNT",  .addr = A_CHKR5_CLKB_CNT,
    },{ .name = "CHKR5_CLKA_PRELOAD_CNT",  .addr = A_CHKR5_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR5_CTRL",  .addr = A_CHKR5_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR6_CLKA_UPPER",  .addr = A_CHKR6_CLKA_UPPER,
    },{ .name = "CHKR6_CLKA_LOWER",  .addr = A_CHKR6_CLKA_LOWER,
    },{ .name = "CHKR6_CLKB_CNT",  .addr = A_CHKR6_CLKB_CNT,
    },{ .name = "CHKR6_CLKA_PRELOAD_CNT",  .addr = A_CHKR6_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR6_CTRL",  .addr = A_CHKR6_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR7_CLKA_UPPER",  .addr = A_CHKR7_CLKA_UPPER,
    },{ .name = "CHKR7_CLKA_LOWER",  .addr = A_CHKR7_CLKA_LOWER,
    },{ .name = "CHKR7_CLKB_CNT",  .addr = A_CHKR7_CLKB_CNT,
    },{ .name = "CHKR7_CLKA_PRELOAD_CNT",  .addr = A_CHKR7_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR7_CTRL",  .addr = A_CHKR7_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR8_CLKA_UPPER",  .addr = A_CHKR8_CLKA_UPPER,
    },{ .name = "CHKR8_CLKA_LOWER",  .addr = A_CHKR8_CLKA_LOWER,
    },{ .name = "CHKR8_CLKB_CNT",  .addr = A_CHKR8_CLKB_CNT,
    },{ .name = "CHKR8_CLKA_PRELOAD_CNT",  .addr = A_CHKR8_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR8_CTRL",  .addr = A_CHKR8_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR9_CLKA_UPPER",  .addr = A_CHKR9_CLKA_UPPER,
    },{ .name = "CHKR9_CLKA_LOWER",  .addr = A_CHKR9_CLKA_LOWER,
    },{ .name = "CHKR9_CLKB_CNT",  .addr = A_CHKR9_CLKB_CNT,
    },{ .name = "CHKR9_CLKA_PRELOAD_CNT",  .addr = A_CHKR9_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR9_CTRL",  .addr = A_CHKR9_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR10_CLKA_UPPER",  .addr = A_CHKR10_CLKA_UPPER,
    },{ .name = "CHKR10_CLKA_LOWER",  .addr = A_CHKR10_CLKA_LOWER,
    },{ .name = "CHKR10_CLKB_CNT",  .addr = A_CHKR10_CLKB_CNT,
    },{ .name = "CHKR10_CLKA_PRELOAD_CNT",  .addr = A_CHKR10_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR10_CTRL",  .addr = A_CHKR10_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR11_CLKA_UPPER",  .addr = A_CHKR11_CLKA_UPPER,
    },{ .name = "CHKR11_CLKA_LOWER",  .addr = A_CHKR11_CLKA_LOWER,
    },{ .name = "CHKR11_CLKB_CNT",  .addr = A_CHKR11_CLKB_CNT,
    },{ .name = "CHKR11_CLKA_PRELOAD_CNT",  .addr = A_CHKR11_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR11_CTRL",  .addr = A_CHKR11_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR12_CLKA_UPPER",  .addr = A_CHKR12_CLKA_UPPER,
    },{ .name = "CHKR12_CLKA_LOWER",  .addr = A_CHKR12_CLKA_LOWER,
    },{ .name = "CHKR12_CLKB_CNT",  .addr = A_CHKR12_CLKB_CNT,
    },{ .name = "CHKR12_CLKA_PRELOAD_CNT",  .addr = A_CHKR12_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR12_CTRL",  .addr = A_CHKR12_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR13_CLKA_UPPER",  .addr = A_CHKR13_CLKA_UPPER,
    },{ .name = "CHKR13_CLKA_LOWER",  .addr = A_CHKR13_CLKA_LOWER,
    },{ .name = "CHKR13_CLKB_CNT",  .addr = A_CHKR13_CLKB_CNT,
    },{ .name = "CHKR13_CLKA_PRELOAD_CNT",  .addr = A_CHKR13_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR13_CTRL",  .addr = A_CHKR13_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR14_CLKA_UPPER",  .addr = A_CHKR14_CLKA_UPPER,
    },{ .name = "CHKR14_CLKA_LOWER",  .addr = A_CHKR14_CLKA_LOWER,
    },{ .name = "CHKR14_CLKB_CNT",  .addr = A_CHKR14_CLKB_CNT,
    },{ .name = "CHKR14_CLKA_PRELOAD_CNT",  .addr = A_CHKR14_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR14_CTRL",  .addr = A_CHKR14_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "CHKR15_CLKA_UPPER",  .addr = A_CHKR15_CLKA_UPPER,
    },{ .name = "CHKR15_CLKA_LOWER",  .addr = A_CHKR15_CLKA_LOWER,
    },{ .name = "CHKR15_CLKB_CNT",  .addr = A_CHKR15_CLKB_CNT,
    },{ .name = "CHKR15_CLKA_PRELOAD_CNT",  .addr = A_CHKR15_CLKA_PRELOAD_CNT,
    },{ .name = "CHKR15_CTRL",  .addr = A_CHKR15_CTRL,
        .reset = 0x1001,
        .rsvd = 0x200,
        .ro = 0x1000,
    },{ .name = "SEC_OVER_MMU_TCU",  .addr = A_SEC_OVER_MMU_TCU,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU0",  .addr = A_SEC_OVER_MMU_TBU0,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU1",  .addr = A_SEC_OVER_MMU_TBU1,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU2",  .addr = A_SEC_OVER_MMU_TBU2,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU3",  .addr = A_SEC_OVER_MMU_TBU3,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU4",  .addr = A_SEC_OVER_MMU_TBU4,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU5",  .addr = A_SEC_OVER_MMU_TBU5,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU6",  .addr = A_SEC_OVER_MMU_TBU6,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU7",  .addr = A_SEC_OVER_MMU_TBU7,
        .rsvd = 0xfffffffe,
    },{ .name = "SEC_OVER_MMU_TBU8",  .addr = A_SEC_OVER_MMU_TBU8,
        .rsvd = 0xfffffffe,
    },{ .name = "MMUSECSID_CTRL_TBU",  .addr = A_MMUSECSID_CTRL_TBU,
        .rsvd = 0xfffffe00,
    },{ .name = "MMU_SEC_OVER",  .addr = A_MMU_SEC_OVER,
        .rsvd = 0xfffffe00,
    },{ .name = "LPX_CMN_INTERNAL_PROG",  .addr = A_LPX_CMN_INTERNAL_PROG,
        .rsvd = 0xfffffffe,
    },{ .name = "LPX_CMN_BYPASS",  .addr = A_LPX_CMN_BYPASS,
        .rsvd = 0xfffffffe,
    },{ .name = "LPX_RN_SAM_STALL_DIS",  .addr = A_LPX_RN_SAM_STALL_DIS,
        .reset = 0x1,
        .rsvd = 0xfffffffe,
    },{ .name = "RPU_SEC_OVER",  .addr = A_RPU_SEC_OVER,
        .rsvd = 0xfffffff0,
    }
};

static void psxc_lpx_slcr_secure_reset_enter(Object *obj, ResetType type)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(obj);
    unsigned int i;

    for (i = 0; i < ARRAY_SIZE(s->regs_info); ++i) {
        register_reset(&s->regs_info[i]);
    }
}

static void psxc_lpx_slcr_secure_reset_hold(Object *obj)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(obj);
    size_t i;

    rstmon0_update_irq(s);
    rstmon1_update_irq(s);
    clkmon_update_irq(s);

    for (i = 0; i < ARRAY_SIZE(s->adma_secure); i++) {
        qemu_set_irq(s->adma_secure[i], 1);
    }

    for (i = 0; i < ARRAY_SIZE(s->sdma_secure); i++) {
        qemu_set_irq(s->sdma_secure[i], 1);
    }
}

static const MemoryRegionOps psxc_lpx_slcr_secure_ops = {
    .read = register_read_memory,
    .write = register_write_memory,
    .endianness = DEVICE_LITTLE_ENDIAN,
    .valid = {
        .min_access_size = 4,
        .max_access_size = 4,
    },
};

static void psxc_lpx_slcr_secure_init(Object *obj)
{
    PsxcLpxSlcrSecure *s = XILINX_PSXC_LPX_SLCR_SECURE(obj);
    SysBusDevice *sbd = SYS_BUS_DEVICE(obj);
    RegisterInfoArray *reg_array;

    memory_region_init(&s->iomem, obj, TYPE_XILINX_PSXC_LPX_SLCR_SECURE,
                       PSXC_LPX_SLCR_SECURE_R_MAX * 4);
    reg_array =
        register_init_block32(DEVICE(obj), psxc_lpx_slcr_secure_regs_info,
                              ARRAY_SIZE(psxc_lpx_slcr_secure_regs_info),
                              s->regs_info, s->regs,
                              &psxc_lpx_slcr_secure_ops,
                              XILINX_PSXC_LPX_SLCR_SECURE_ERR_DEBUG,
                              PSXC_LPX_SLCR_SECURE_R_MAX * 4);
    memory_region_add_subregion(&s->iomem,
                                0x0,
                                &reg_array->mem);

    qdev_init_gpio_out_named(DEVICE(obj), s->adma_secure,
                             "adma-secure", ARRAY_SIZE(s->adma_secure));
    qdev_init_gpio_out_named(DEVICE(obj), s->sdma_secure,
                             "sdma-secure", ARRAY_SIZE(s->sdma_secure));

    sysbus_init_mmio(sbd, &s->iomem);
}

static const VMStateDescription vmstate_psxc_lpx_slcr_secure = {
    .name = TYPE_XILINX_PSXC_LPX_SLCR_SECURE,
    .version_id = 1,
    .minimum_version_id = 1,
    .fields = (VMStateField[]) {
        VMSTATE_UINT32_ARRAY(regs, PsxcLpxSlcrSecure,
                             PSXC_LPX_SLCR_SECURE_R_MAX),
        VMSTATE_END_OF_LIST(),
    }
};

static const FDTGenericGPIOSet psxc_lpx_slcr_secure_gpios[] = {
    {
      .names = &fdt_generic_gpio_name_set_gpio,
      .gpios = (FDTGenericGPIOConnection[]) {
        { .name = "adma-secure", .fdt_index = 0, .range = 8 },
        { .name = "sdma-secure", .fdt_index = 8, .range = 8 },
        { },
      },
    },
    { },
};

static void psxc_lpx_slcr_secure_class_init(ObjectClass *klass, void *data)
{
    ResettableClass *rc = RESETTABLE_CLASS(klass);
    DeviceClass *dc = DEVICE_CLASS(klass);
    FDTGenericGPIOClass *fggc = FDT_GENERIC_GPIO_CLASS(klass);

    dc->vmsd = &vmstate_psxc_lpx_slcr_secure;
    rc->phases.enter = psxc_lpx_slcr_secure_reset_enter;
    rc->phases.hold = psxc_lpx_slcr_secure_reset_hold;
    fggc->controller_gpios = psxc_lpx_slcr_secure_gpios;
}

static const TypeInfo psxc_lpx_slcr_secure_info = {
    .name          = TYPE_XILINX_PSXC_LPX_SLCR_SECURE,
    .parent        = TYPE_SYS_BUS_DEVICE,
    .instance_size = sizeof(PsxcLpxSlcrSecure),
    .class_init    = psxc_lpx_slcr_secure_class_init,
    .instance_init = psxc_lpx_slcr_secure_init,
    .interfaces = (InterfaceInfo[]) {
        { TYPE_FDT_GENERIC_GPIO },
        { }
    },
};

static void psxc_lpx_slcr_secure_register_types(void)
{
    type_register_static(&psxc_lpx_slcr_secure_info);
}

type_init(psxc_lpx_slcr_secure_register_types)
