/******************************************************************************
* Copyright (c) 2018 - 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2024, Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/


#ifndef XPM_REGS_H
#define XPM_REGS_H

#ifdef __cplusplus
extern "C" {
#endif

#include "xil_hw.h"

/**
 * Base Addresses
 */
#define PMC_GPIO_BASEADDR					(0XF1020000U)
#define PMC_ANALOG_BASEADDR					(0XF1160000U)
#define CPM_CRCPM_BASEADDR					(0xFCA00000U)
#define PCIEA_ATTRIB_0_BASEADDR					(0xFCA50000U)
#define PCIEA_ATTRIB_1_BASEADDR					(0xFCA60000U)
#define CRL_BASEADDR						(0xFF5E0000U)
#define NPI_BASEADDR						(0xF6000000U)
#define NOC_PACKET_SWITCH_BASEADDR				(0xF6030000U)
#define XRAM_SLCR_BASEADDR					(0xFF950000U)
#define EFUSE_CACHE_BASEADDR					(0xF1250000U)
#define PMC_SYSMON_BASEADDR					(0xF1270000U)
#define PCIEA_ATTRIB_DMA_BASEADDR				(0xFCA70000U)
#define CPM5_PCIE_ATTRIB_0_BASEADDR				(0xFCE08000U)
#define CFRAME_BCAST_REG_BASEADDR				(0xF12EE000U)
#define LPD_GPIO_BASEADDR					(0xFF0B0000U)
#define LPD_IOU_SLCR_BASEADDR					(0xFF080000U)
#define CPM5_PCIE0_CSR_BASEADDR				(0xFCE00000U)
#define CPM5_PCIE1_CSR_BASEADDR				(0xFCE80000U)
#define CPM5_DMA0_ATTR_BASEADDR				(0xFCE10000U)
#define CPM5_DMA1_ATTR_BASEADDR				(0xFCE90000U)
#define CPM5_SLCR_BASEADDR					(0xFCDD0000U)
#define CPM6_SLCR_BASEADDR					(0xFCDD0000U)

/**
* PMC_IOU_SLCR module
*/
#define PMC_IOU_SLCR_MIO_MST_TRI0				(PMC_IOU_SLCR_BASEADDR + 0x00000200U)
#define PMC_IOU_SLCR_MIO_MST_TRI1				(PMC_IOU_SLCR_BASEADDR + 0x00000204U)

/**
 * PMC_GPIO Module
 */
#define PMC_GPIO_DATA_0_ADDR					(PMC_GPIO_BASEADDR + 0x00000040U)
#define PMC_GPIO_DATA_1_ADDR					(PMC_GPIO_BASEADDR + 0x00000044U)
#define PMC_GPIO_DIRM_0_ADDR					(PMC_GPIO_BASEADDR + 0x00000204U)
#define PMC_GPIO_DIRM_1_ADDR					(PMC_GPIO_BASEADDR + 0x00000244U)
#define PMC_GPIO_OEN_0_ADDR					(PMC_GPIO_BASEADDR + 0x00000208U)
#define PMC_GPIO_OEN_1_ADDR					(PMC_GPIO_BASEADDR + 0x00000248U)

/**
 * LPD GPIO Module
 */
#define LPD_GPIO_DATA_0_ADDR					(LPD_GPIO_BASEADDR + 0x00000040U)
#define LPD_GPIO_DIRM_0_ADDR					(LPD_GPIO_BASEADDR + 0x00000204U)
#define LPD_GPIO_OEN_0_ADDR					(LPD_GPIO_BASEADDR + 0x00000208U)

/**
* LPD IOU SLCR	module
*/
#define LPD_IOU_SLCR_MIO_MST_TRI0				(LPD_IOU_SLCR_BASEADDR + 0x00000204U)

/**
* Register: CRP_RST_GPIO
*/
#define CRP_RST_GPIO						(0xF1260138U)

/**
* Register: CRL_RST_GPIO
*/
#define CRL_RST_GPIO						(0xFF5E033CU)

/**
 * PMC Global module
 */
#define PMC_GLOBAL_GGS4_OFFSET					(0x00000040U)
#define PMC_GLOBAL_PGGS3_OFFSET					(0x0000005CU)
#define DOMAIN_ISO_CTRL_OFFSET					(0x10000U)
#define PMC_GLOBAL_DOMAIN_ISO_CONTROL				( ( PMC_GLOBAL_BASEADDR ) + DOMAIN_ISO_CTRL_OFFSET )
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCAUX_VCCRAM_SHIFT		(18U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCAUX_VCCRAM_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCAUX_VCCRAM_MASK		(0x00040000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCRAM_SOC_SHIFT		(17U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCRAM_SOC_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCRAM_SOC_MASK		(0x00020000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCAUX_SOC_SHIFT		(16U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCAUX_SOC_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_VCCAUX_SOC_MASK		(0x00010000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PL_SOC_SHIFT		(15U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PL_SOC_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PL_SOC_MASK			(0x00008000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_SOC_SHIFT		(14U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_SOC_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_SOC_MASK		(0x00004000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_SOC_NPI_SHIFT		(13U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_SOC_NPI_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_SOC_NPI_MASK		(0x00002000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_SHIFT		(12U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_MASK			(0x00001000U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_TEST_SHIFT		(11U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_TEST_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_CFRAME_SHIFT		(10U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_PL_CFRAME_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_LPD_SHIFT		(9U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_LPD_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_LPD_MASK		(0x00000200U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_LPD_DFX_SHIFT		(8U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_LPD_DFX_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_PMC_LPD_DFX_MASK		(0x00000100U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_SOC_SHIFT		(7U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_SOC_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_SOC_MASK		(0x00000080U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_PL_SHIFT		(6U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_PL_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_PL_MASK			(0x00000040U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_PL_TEST_SHIFT		(5U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_PL_TEST_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_PL_TEST_MASK		(0x00000020U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_CPM_SHIFT		(4U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_CPM_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_CPM_MASK		(0x00000010U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_CPM_DFX_SHIFT		(3U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_CPM_DFX_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_LPD_CPM_DFX_MASK		(0x00000008U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_SOC_SHIFT		(2U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_SOC_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_SOC_MASK		(0x00000004U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_PL_SHIFT		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_PL_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_PL_MASK			(0x00000002U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_PL_TEST_SHIFT		(0U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_PL_TEST_WIDTH		(1U)
#define PMC_GLOBAL_DOMAIN_ISO_CNTRL_FPD_PL_TEST_MASK		(0x00000001U)

#define PWR_SUPPLY_STATUS_OFFSET				(0x10CU)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCINT_RAM_MASK		(0x00000080U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCINT_PL_MASK		(0x00000040U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCAUX_MASK		(0x00000020U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCINT_SOC_MASK		(0x00000010U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCINT_LPD_MASK		(0x00000008U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCINT_FPD_MASK		(0x00000004U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCINT_PMC_MASK		(0x00000002U)
#define PMC_GLOBAL_PWR_SUPPLY_STATUS_VCCAUX_PMC_MASK		(0x00000001U)

#define PMC_GLOBAL_SSIT_NOC_ID_OFFSET				(0x00000950U)
#define PMC_GLOBAL_SSIT_NOC_ID_SWITCHID_WIDTH			(13U)
#define PMC_GLOBAL_SSIT_NOC_ID_SWITCHID_MASK			(0x00003FFFU)

#define PMC_GLOBAL_PUDC_B_OVERRIDE_OFFSET			(0x00010004U)
#define PMC_GLOBAL_PUDC_B_OVERRIDE_VAL_MASK			(0X00000001U)

#define CPM_PCSR_HOLDSTATE_MASK					(0x00000080U)
#define CPM_PCSR_INITSTATE_MASK					(0x00000040U)

#define EFUSE_CACHE_MISC_CTRL_OFFSET				(0x000000A0U)
#define EFUSE_CACHE_MISC_CTRL_LBIST_EN_MASK			(0x00004000U)
#define EFUSE_CACHE_TRIM_CFRM_VGG_0_OFFSET			(0x000001B4U)
#define EFUSE_CACHE_TRIM_CFRM_VGG_1_OFFSET			(0x000001B8U)
#define EFUSE_CACHE_TRIM_CFRM_VGG_2_OFFSET			(0x000001BCU)
#define EFUSE_CACHE_TRIM_CRAM_OFFSET				(0x000001C0U)
#define EFUSE_CACHE_TRIM_BRAM_OFFSET				(0x00000098U)
#define EFUSE_CACHE_TRIM_URAM_OFFSET				(0x0000009CU)
#define EFUSE_CACHE_BISR_RSVD_0_OFFSET				(0x00000300U)
#define EFUSE_CACHE_TBITS1_BISR_RSVD_OFFSET			(0x00000400U)
#define EFUSE_CACHE_TBITS2_BISR_RSVD_OFFSET			(0x00000800U)
#define EFUSE_CACHE_TRIM_AMS_3_OFFSET				(0X00000200U)
#define EFUSE_CACHE_TRIM_AMS_3_TSENS_SLOPE_5_0_SHIFT		(9U)
#define EFUSE_CACHE_TRIM_AMS_3_TSENS_SLOPE_5_0_MASK		(0X00007E00U)
#define EFUSE_CACHE_TRIM_AMS_3_TSENS_INT_OFFSET_5_0_SHIFT	(3U)
#define EFUSE_CACHE_TRIM_AMS_3_TSENS_INT_OFFSET_5_0_MASK	(0X000001F8U)
#define EFUSE_CACHE_TRIM_AMS_3_TSENS_DELTA_16_0_SHIFT		(15U)
#define EFUSE_CACHE_TRIM_AMS_3_TSENS_DELTA_16_0_MASK		(0Xffff8000U)
#define EFUSE_CACHE_TRIM_AMS_4_OFFSET				(0x00000190U)
#define EFUSE_CACHE_TRIM_AMS_11_OFFSET				(0X000001ACU)
#define EFUSE_CACHE_TRIM_AMS_11_IXPCM_PROCESS_15_0_SHIFT	(15U)
#define EFUSE_CACHE_TRIM_AMS_11_IXPCM_PROCESS_15_0_MASK		(0X7FFF8000U)
#define EFUSE_CACHE_TRIM_AMS_11_RES_PROCESS_0_SHIFT		(31U)
#define EFUSE_CACHE_TRIM_AMS_11_RES_PROCESS_0_MASK		(0X80000000U)
#define EFUSE_CACHE_TRIM_AMS_12_OFFSET				(0X000001B0U)
#define EFUSE_CACHE_TRIM_AMS_12_BJT_PROCESS_3_0_SHIFT		(6U)
#define EFUSE_CACHE_TRIM_AMS_12_BJT_PROCESS_3_0_MASK		(0X000003C0U)
#define EFUSE_CACHE_TRIM_AMS_12_RES_PROCESS_6_1_SHIFT		(0U)
#define EFUSE_CACHE_TRIM_AMS_12_RES_PROCESS_6_1_MASK		(0X0000003FU)
#define EFUSE_CACHE_TRIM_AMS_12_TSENS_EXT_OFFSET_5_0_SHIFT	(10U)
#define EFUSE_CACHE_TRIM_AMS_12_TSENS_EXT_OFFSET_5_0_MASK	(0X0000FC00U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_1_0_SHIFT		(16U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_1_0_MASK		(0X00030000U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_14_2_SHIFT		(18U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_14_2_MASK		(0X7ffc0000U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_2_SHIFT		(18U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_2_MASK		(0X00040000U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_6_SHIFT		(22U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_6_MASK		(0X00400000U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_4_3_SHIFT		(19U)
#define EFUSE_CACHE_TRIM_AMS_12_SHARED_SPARE_4_3_MASK		(0X00180000U)
#define EFUSE_CACHE_NIDB_0_OFFSET				(0x000001C4U)
#define EFUSE_CACHE_NIDB_0_NPI_BASE_1_SHIFT			(23U)
#define EFUSE_CACHE_NIDB_0_NPI_BASE_1_WIDTH			(9U)
#define EFUSE_CACHE_NIDB_0_NPI_BASE_1_MASK			(0xFF800000U)
#define EFUSE_CACHE_NIDB_0_NPI_OFFSET_1_SHIFT			(19U)
#define EFUSE_CACHE_NIDB_0_NPI_OFFSET_1_WIDTH			(4U)
#define EFUSE_CACHE_NIDB_0_NPI_OFFSET_1_MASK			(0x00780000U)
#define EFUSE_CACHE_NIDB_0_RDN_CNTRL_0_SHIFT			(13U)
#define EFUSE_CACHE_NIDB_0_RDN_CNTRL_0_WIDTH			(6U)
#define EFUSE_CACHE_NIDB_0_RDN_CNTRL_0_MASK			(0x0007E000U)
#define EFUSE_CACHE_NIDB_0_NPI_BASE_0_SHIFT			(4U)
#define EFUSE_CACHE_NIDB_0_NPI_BASE_0_WIDTH			(9U)
#define EFUSE_CACHE_NIDB_0_NPI_BASE_0_MASK			(0x00001FF0U)
#define EFUSE_CACHE_NIDB_0_NPI_OFFSET_0_SHIFT			(0U)
#define EFUSE_CACHE_NIDB_0_NPI_OFFSET_0_WIDTH			(4U)
#define EFUSE_CACHE_NIDB_0_NPI_OFFSET_0_MASK			(0x0000000FU)
#define EFUSE_CACHE_NIDB_1_OFFSET				(0x000001C8U)
#define EFUSE_CACHE_NIDB_1_NPI_BASE_3_SHIFT			(29U)
#define EFUSE_CACHE_NIDB_1_NPI_BASE_3_WIDTH			(3U)
#define EFUSE_CACHE_NIDB_1_NPI_BASE_3_MASK			(0xE0000000U)
#define EFUSE_CACHE_NIDB_1_NPI_OFFSET_3_SHIFT			(25U)
#define EFUSE_CACHE_NIDB_1_NPI_OFFSET_3_WIDTH			(4U)
#define EFUSE_CACHE_NIDB_1_NPI_OFFSET_3_MASK			(0x1E000000U)
#define EFUSE_CACHE_NIDB_1_RDN_CNTL_2_SHIFT			(19U)
#define EFUSE_CACHE_NIDB_1_RDN_CNTL_2_WIDTH			(6U)
#define EFUSE_CACHE_NIDB_1_RDN_CNTL_2_MASK			(0x01F80000U)
#define EFUSE_CACHE_NIDB_1_NPI_BASE_2_SHIFT			(10U)
#define EFUSE_CACHE_NIDB_1_NPI_BASE_2_WIDTH			(9U)
#define EFUSE_CACHE_NIDB_1_NPI_BASE_2_MASK			(0x0007FC00U)
#define EFUSE_CACHE_NIDB_1_NPI_OFFSET_2_SHIFT			(6U)
#define EFUSE_CACHE_NIDB_1_NPI_OFFSET_2_WIDTH			(4U)
#define EFUSE_CACHE_NIDB_1_NPI_OFFSET_2_MASK			(0x000003C0U)
#define EFUSE_CACHE_NIDB_1_RDN_CNTRL_1_SHIFT			(0U)
#define EFUSE_CACHE_NIDB_1_RDN_CNTRL_1_WIDTH			(6U)
#define EFUSE_CACHE_NIDB_1_RDN_CNTRL_1_MASK			(0x0000003FU)
#define EFUSE_CACHE_NIDB_2_OFFSET				(0x000001CCU)
#define EFUSE_CACHE_NIDB_2_RDN_CNTRL_4_SHIFT			(25U)
#define EFUSE_CACHE_NIDB_2_RDN_CNTRL_4_WIDTH			(6U)
#define EFUSE_CACHE_NIDB_2_RDN_CNTRL_4_MASK			(0x7E000000U)
#define EFUSE_CACHE_NIDB_2_NPI_BASE_4_SHIFT			(16U)
#define EFUSE_CACHE_NIDB_2_NPI_BASE_4_WIDTH			(9U)
#define EFUSE_CACHE_NIDB_2_NPI_BASE_4_MASK			(0x01FF0000U)
#define EFUSE_CACHE_NIDB_2_NPI_OFFSET_4_SHIFT			(12U)
#define EFUSE_CACHE_NIDB_2_NPI_OFFSET_4_WIDTH			(4U)
#define EFUSE_CACHE_NIDB_2_NPI_OFFSET_4_MASK			(0x0000F000U)
#define EFUSE_CACHE_NIDB_2_RDN_CNTL_3_SHIFT			(6U)
#define EFUSE_CACHE_NIDB_2_RDN_CNTL_3_WIDTH			(6U)
#define EFUSE_CACHE_NIDB_2_RDN_CNTL_3_MASK			(0x00000FC0U)
#define EFUSE_CACHE_NIDB_2_NPI_BASE_3_SHIFT			(0U)
#define EFUSE_CACHE_NIDB_2_NPI_BASE_3_WIDTH			(6U)
#define EFUSE_CACHE_NIDB_2_NPI_BASE_3_MASK			(0x0000003FU)

#define EFUSE_CONFIG0_OFFSET					(0x180U)
#define EFUSE_CONFIG0_OFFSET_MASK				(0x3fU)
#define EFUSE_CONFIG0_OFFSET_SHIFT				(0U)
#define EFUSE_CONFIG0_SLOPE_MASK				(0xfc0U)
#define EFUSE_CONFIG0_SLOPE_SHIFT				(6U)
#define EFUSE_CONFIG0_PROCESS_MASK				(0xffff0000U)
#define EFUSE_CONFIG0_DELTA_SHIFT				(12U)
#define EFUSE_CONFIG0_DELTA_MASK				(0x0000f000U)
#define EFUSE_CONFIG0_PROCESS_SHIFT				(16U)
#define EFUSE_CONFIG1_OFFSET					(0x184U)
#define EFUSE_CONFIG1_RESISTOR_MASK				(0x7fU)
#define EFUSE_CONFIG1_RESISTOR_SHIFT				(0U)
#define EFUSE_CONFIG1_BJT_OFFSET_MASK				(0x780U)
#define EFUSE_CONFIG1_BJT_OFFSET_SHIFT				(7U)
#define EFUSE_CONFIG1_EXT_OFFSET_MASK				(0x1f800U)
#define EFUSE_CONFIG1_EXT_OFFSET_SHIFT				(11U)
#define EFUSE_CONFIG1_ANA_SPARE_MASK				(0x00060000U)
#define EFUSE_CONFIG1_ANA_SPARE_SHIFT				(17U)
#define EFUSE_CONFIG1_DIG_SPARE_MASK				(0xfff80000U)
#define EFUSE_CONFIG1_DIG_SPARE_SHIFT				(19U)
#define CAL_SM_BIP_TSENS_OFFSET					(0x144U)
#define CAL_SM_BIP_TSENS_BIP_MASK				(0x00000001U)
#define CAL_SM_BIP_TSENS_BIP_SHIFT				(0U)
#define CAL_SM_BIP_TSENS_TSENS_MASK				(0x00000002U)
#define CAL_SM_BIP_TSENS_TSENS_SHIFT				(1U)
#define TSENS_BIAS_CTRL_OFFSET					(0x17CU)
#define TSENS_BIAS_VAL_MASK					(0x00000003U)
#define TSENS_BIAS_VAL_SHIFT					(0U)

#define DOMAIN_ISO_CTRL_OFFSET					(0x10000U)
#define PMC_GLOBAL_DOMAIN_ISO_CONTROL				( ( PMC_GLOBAL_BASEADDR ) + DOMAIN_ISO_CTRL_OFFSET )

#define PMC_GLOBAL_PERS_GLOB_GEN_STORAGE0			( ( PMC_GLOBAL_BASEADDR ) + 0x00000050U )

#define PMC_GLOBAL_PL_STATUS_OFFSET				(0x00000880U)
#define PMC_GLOBAL_PL_STATUS_POR_PL_B_MASK			(0x00000001U)

#define PMC_GLOBAL_ERR1_STATUS_OFFSET				(0x00020000U)
#define PMC_GLOBAL_ERR1_STATUS_CFU_MASK				(0x00000040U)
#define PMC_GLOBAL_ERR1_STATUS_CFRAME_MASK			(0x00000080U)
#define PMC_GLOBAL_ERR1_STATUS_DDRMC_MC_NCR_MASK		(0x00080000U)
#define PMC_GLOBAL_ERR1_STATUS_NOC_TYPE_1_NCR_MASK		(0x00002000U)
#define PMC_GLOBAL_ERR1_STATUS_NPI_ALL_MASK			(0x003FFC00U)
#define PMC_GLOBAL_ERR1_STATUS_GT_NCR_MASK			(0x00200000U)
#define PMC_GLOBAL_ERR1_STATUS_ALL_MASK		(0xFFFFFFFFU)

#define PMC_GLOBAL_ERR2_STATUS_OFFSET				(0x00020004U)
#define PMC_GLOBAL_ERR2_STATUS_CFI_MASK				(0x00020000U)
#define PMC_GLOBAL_ERR2_STATUS_CFRAME_SEU_CRC_MASK		(0x00040000U)
#define PMC_GLOBAL_ERR2_STATUS_CFRAME_SEU_ECC_MASK		(0x00080000U)

/**
 * PMC Global GIC Proxy Module
 */
#define PMC_GLOBAL_GIC_PROXY_BASE_OFFSET			(0x30000U)
#define GIC_PROXY_GROUP_OFFSET(g)				(0x14U * (g))

#define PMC_GLOBAL_GICP_IRQ_ENABLE_OFFSET			(0x300A8U)
#define PMC_GLOBAL_GICP_IRQ_DISABLE_OFFSET			(0x300ACU)

/**
 * GIC Proxy register offsets
 */
#define GIC_PROXY_IRQ_STATUS_OFFSET				(0x0U)
#define GIC_PROXY_IRQ_MASK_OFFSET				(0x4U)
#define GIC_PROXY_IRQ_ENABLE_OFFSET				(0x8U)
#define GIC_PROXY_IRQ_DISABLE_OFFSET				(0xCU)

#define GIC_PROXY_ALL_MASK					(0xFFFFFFFFU)
#define GICP3_CFU_MASK						(0x01000000U)
#define GICP3_CFRAME_SEU_MASK					(0x02000000U)

/**
 * PMC IOU SLCR Module
 */
#define PMC_IOU_SLCR_SD0_DLL_DIV_MAP0_OFFSET			(0x00000458U)
#define PMC_IOU_SLCR_SD0_DLL_DIV_MAP1_OFFSET			(0x0000045CU)
#define PMC_IOU_SLCR_SD1_DLL_DIV_MAP0_OFFSET			(0x000004D8U)
#define PMC_IOU_SLCR_SD1_DLL_DIV_MAP1_OFFSET			(0x000004DCU)
#define PMC_IOU_SLCR_WPROT0_OFFSET				(0x00000828U)

/**
 * PSM Global Module
 */
#define PSM_GLOBAL_REG						(0xFFC90000U)
#define PSM_GLOBAL_APU_POWER_STATUS_INIT_OFFSET			(0x00000008U)
#define PSM_GLOBAL_SCAN_CLEAR_FPD_OFFSET			(0x0000092CU)

#define PSM_GLOBAL_SCAN_CLEAR_TRIGGER				(0x1U)
#define PSM_GLOBAL_SCAN_CLEAR_DONE_STATUS			(0x2U)
#define PSM_GLOBAL_SCAN_CLEAR_PASS_STATUS			(0x4U)

#define PSM_GLOBAL_MBIST_RST_OFFSET				(0x00000900U)
#define PSM_GLOBAL_MBIST_PG_EN_OFFSET				(0x00000904U)
#define PSM_GLOBAL_MBIST_SETUP_OFFSET				(0x00000908U)
#define PSM_GLOBAL_MBIST_DONE_OFFSET				(0x00000910U)
#define PSM_GLOBAL_MBIST_GO_OFFSET				(0x00000914U)

#define PSM_GLOBAL_MBIST_RST_FPD_MASK				(0x0000001FU)
#define PSM_GLOBAL_MBIST_PG_EN_FPD_MASK				(0x0000001FU)
#define PSM_GLOBAL_MBIST_SETUP_FPD_MASK				(0x0000001FU)
#define PSM_GLOBAL_MBIST_DONE_FPD_MASK				(0x0000001FU)
#define PSM_GLOBAL_MBIST_GO_FPD_MASK				(0x0000001FU)

#define PSM_ERR1_STATUS_OFFSET					(0x1000U)
#define PSM_ERR1_STATUS_APLL_LOCK_MASK				(0x00004000U)
#define PSM_ERR1_STATUS_RPLL_LOCK_MASK				(0x00008000U)

/**
 * PSM Local Module
 */
#define PSM_LOCAL_REG_BASEADDR					(0xFFC88000U)
#define PSM_LOCAL_REG_SIZE						(0x8000U)

/**
 * PSM RAM INSTR CTRL Module
 */
#define PSM_RAM_INSTR_ECC_CTRL_REG_BASEADDR		(0xFFCA0000U)
#define PSM_RAM_INSTR_ECC_CTRL_SIZE				(0x10000U)

/**
 * PSM RAM DATA CTRL Module
 */
#define PSM_RAM_DATA_ECC_CTRL_REG_BASEADDR		(0xFFCB0000U)
#define PSM_RAM_DATA_ECC_CTRL_SIZE				(0x10000U)

/**
 * PSM TMR Manager Module
 */
#define PSM_TMR_MANAGER_REG_BASEADDR			(0xFFCC0000U)
#define PSM_TMR_MANAGER_SIZE					(0x10000U)

/**
 * PSM TMR Inject Module
 */
#define PSM_TMR_INJECT_REG_BASEADDR				(0xFFCD0000U)
#define PSM_TMR_INJECT_SIZE						(0x10000U)

/**
 * LPD IOU SLCR Module
 */
#define LPD_IOU_SLCR_WPROT0_OFFSET				(0x00000728U)

/**
 * LPD SLCR Module
 */
#define LPD_SLCR_WPROT0_OFFSET					(0x00000000U)
#define LPD_SLCR_BISR_CACHE_DATA_0_OFFSET			(0x0000010CU)
#define LPD_SLCR_BISR_CACHE_CTRL_0_OFFSET			(0x00000100U)
#define LPD_SLCR_CACHE_CTRL_0_BISR_TRIGGER_MASK			(0x00000001U)
#define LPD_SLCR_BISR_CACHE_CTRL_1_OFFSET			(0x00000104U)
#define LPD_SLCR_CACHE_CTRL_1_PGEN0_MASK			(0x00000001U)
#define LPD_SLCR_CACHE_CTRL_1_PGEN1_MASK			(0x00000002U)
#define LPD_SLCR_BISR_CACHE_STATUS_OFFSET			(0x00000108U)
#define LPD_SLCR_BISR_PASS_GLOBAL_MASK				(0x80000000U)
#define LPD_SLCR_BISR_DONE_GLOBAL_MASK				(0x40000000U)
#define LPD_SLCR_BISR_PASS_1_MASK				(0x0000008U)
#define LPD_SLCR_BISR_DONE_1_MASK				(0x0000004U)
#define LPD_SLCR_BISR_PASS_0_MASK				(0x0000002U)
#define LPD_SLCR_BISR_DONE_0_MASK				(0x0000001U)

/**
 * Register: LPD_SLCR_SECURE
 */
#define LPD_SLCR_SECURE_WPROT0_OFFSET				(0x00000000U)
#define LPD_SLCR_SECURE_ADMA_0_OFFSET				(0x00000060U)

/**
 * Register: FPD_SLCR_SECURE
 */
#define FPD_SLCR_SECURE_WPROT0_OFFSET				(0x00000000U)

/**
 * FPD_SLCR Module
 */
#define FPD_SLCR_WPROT0_OFFSET					(0x00000000U)
#define FPD_SLCR_BISR_CACHE_DATA_0_OFFSET			(0x0000040CU)
#define FPD_SLCR_BISR_CACHE_CTRL_0_OFFSET			(0x00000400U)
#define FPD_SLCR_CACHE_CTRL_0_BISR_TRIGGER_MASK			(0x00000001U)
#define FPD_SLCR_BISR_CACHE_CTRL_1_OFFSET			(0x00000404U)
#define FPD_SLCR_CACHE_CTRL_1_PGEN0_MASK			(0x00000001U)
#define FPD_SLCR_CACHE_CTRL_1_PGEN1_MASK			(0x00000002U)
#define FPD_SLCR_CACHE_CTRL_1_PGEN2_MASK			(0x00000004U)
#define FPD_SLCR_CACHE_CTRL_1_PGEN3_MASK			(0x00000008U)
#define FPD_SLCR_BISR_CACHE_STATUS_OFFSET			(0x00000408U)
#define FPD_SLCR_BISR_PASS_3_MASK				(0x0000200U)
#define FPD_SLCR_BISR_DONE_3_MASK				(0x0000100U)
#define FPD_SLCR_BISR_PASS_2_MASK				(0x0000080U)
#define FPD_SLCR_BISR_DONE_2_MASK				(0x0000040U)
#define FPD_SLCR_BISR_PASS_1_MASK				(0x0000020U)
#define FPD_SLCR_BISR_DONE_1_MASK				(0x0000010U)
#define FPD_SLCR_BISR_PASS_0_MASK				(0x0000008U)
#define FPD_SLCR_BISR_DONE_0_MASK				(0x0000004U)
#define FPD_SLCR_BISR_PASS_GLOBAL_MASK				(0x0000002U)
#define FPD_SLCR_BISR_DONE_GLOBAL_MASK				(0x0000001U)

#define APU_DUAL_RVBARADDR0L_OFFSET				(0x40U)
#define APU_DUAL_RVBARADDR0H_OFFSET				(0x44U)
#define APU_DUAL_RVBARADDR1L_OFFSET				(0x48U)
#define APU_DUAL_RVBARADDR1H_OFFSET				(0x4CU)

#define RPU_0_CFG_OFFSET					(0x00000100U)
#define RPU_1_CFG_OFFSET					(0x00000200U)
#define RPU_GLBL_CNTL_OFFSET					(0x00000000U)

#define CRL_RCLK_CTRL						(CRL_BASEADDR + 0x000001A0)
#define CRL_RST_OCM2_CTRL					(CRL_BASEADDR + 0x00000364U)
#define CRL_RST_OCM2_CTRL_POR_MASK					(0x1U)
#define CRL_RST_OCM2_CTRL_SRST_MASK					(0x2U)
#define CRL_RCLK_CTRL_CLKACT_GEM_TSU_MASK			(0x1000)
#define CRL_RCLK_CTRL_CLKACT_GEM0_TXRX_MASK			(0x300)
#define CRL_RCLK_CTRL_CLKACT_GEM1_TXRX_MASK			(0xC00)

#define CRL_PSM_RST_MODE_OFFSET					(0x00000370U)

#define FPD_APU_PWRCTL_OFFSET					(0x00000090U)

#define RPU_0_PWRDWN_OFFSET					(0x00000108U)
#define RPU_1_PWRDWN_OFFSET					(0x00000208U)
#define RPU_ERR_INJ_OFFSET					(0x00000020U)

/**
 * AMS_ROOT Module
 */
#define AMS_ROOT_REG_PCSR_MASK_OFFSET				(0x00000000U)
#define AMS_ROOT_SECURE_EFUSE_START_MASK			(0x01000000U)
#define AMS_ROOT_REG_PCSR_CONTROL_OFFSET			(0x00000004U)
#define AMS_ROOT_REG_PCSR_LOCK_OFFSET				(0x0000000CU)
#define AMS_ROOT_REG_ISR_OFFSET					(0x00000044U)
#define AMS_ROOT_REG_ISR_SECURE_EFUSE_DONE_MASK			(0x00000800U)
#define AMS_ROOT_REG_ISR_SECURE_EFUSE_ERR_MASK			(0x00000400U)
#define AMS_ROOT_TOKEN_MNGR_OFFSET				(0x00000104U)
#define AMS_ROOT_TOKEN_MNGR_BYPASS_FPD_MASK			(0x00040000U)
#define AMS_ROOT_TOKEN_MNGR_BYPASS_LPD_MASK			(0x00080000U)
#define AMS_ROOT_TOKEN_MNGR_BYPASS_PL_MASK			(0x00100000U)

/**
 * CFRAME Module
 */
#define CFRAME0_FDRI_BASEADDR			(0xF12D1000U)
#define CFRAME_REG_CMD_OFFSET			(0x00000060U)
#define CFRAME_REG_FAR_OFFSET			(0x00000010U)
#define CFRAME_REG_FRCNT_OFFSET			(0x00000050U)
#define CFRAME_REG_CMD_WCFG			(0x1U)
#define CFRAME_REG_CMD_ROWON			(0x2U)
#define CFRAME_REG_CMD_RCFG			(0x4U)
#define CFRAME0_REG_FAR_BLOCKTYPE_SHIFT		(20U)
#define CFRAME_REG_FAR_MFW_OFFSET		(0X00000030U)
#define FRAME_BLOCK_TYPE_6			(6U)

/**
 * CFU APB Module
 */
#define CFU_APB_CFU_FGCR_OFFSET					(0x00000018U)
#define CFU_APB_CFU_MASK_OFFSET					(0x00000028U)
#define CFU_APB_CFU_MASK_INIT_COMPLETE_ENABLE_MASK		(0x00000001U)
#define CFU_APB_CFU_STATUS_OFFSET				(0x00000100U)
#define CFU_APB_CFU_PROTECT_OFFSET				(0x00000014U)
#define CFU_APB_CFU_ROW_RANGE_OFFSET		   (0x0000006CU)
#define CFU_APB_CFU_ROW_RANGE_HALF_FSR_MASK	       (0x00000020U)
#define CFU_APB_CFU_ROW_RANGE_HALF_FSR_SHIFT	(5U)


/**
 * CPM PCSR Module
 */
#define CPM_PCSR_MASK_OFFSET					(0x00000000U)
#define CPM_PCSR_MASK_SCAN_CLEAR_TRIGGER_WEN_MASK		(0x00000800U)
#define CPM_PCSR_MASK_SCAN_CLEAR_HOLDSTATE_WEN_MASK		(0x00000080U)
#define CPM_PCSR_MASK_SCAN_CLEAR_INITSTATE_WEN_MASK		(0x00000040U)
#define CPM_PCSR_PCR_OFFSET					(0x00000004U)
#define CPM_PCSR_PCR_HOLDSTATE_MASK				(0x00000080U)
#define CPM_PCSR_PCR_INITSTATE_MASK				(0x00000040U)
/* CPM_POR bit is same as ODISABLE3 bit in the PCR register */
#define CPM_POR_MASK						(0x00000020U)
#define CPM_PCSR_PCR_SCAN_CLEAR_TRIGGER_MASK			(0x00000800U)
#define CPM_PCSR_PSR_OFFSET					(0x00000008U)
#define CPM_PCSR_PSR_SCAN_CLEAR_DONE_MASK			(0x00000002U)
#define CPM_PCSR_PSR_SCAN_CLEAR_PASS_MASK			(0x00000004U)
#define CPM_PCSR_ECO_OFFSET					(0x00000020U)

/**
 * CPM CRCPM Module
 */
#define CPM_CRCPM_RST_CPI0					(CPM_CRCPM_BASEADDR + 0x00000324)
#define CPM_CRCPM_RST_CPI0_RESET_SHIFT				(0U)

#define CPM_CRCPM_RST_CPI1					(CPM_CRCPM_BASEADDR + 0x00000328)
#define CPM_CRCPM_RST_CPI1_RESET_SHIFT				(0U)

/**
 * CPM_SLCR Module
 */
#define CPM_SLCR_BISR_CACHE_DATA_0_OFFSET			(0x000003F4U)
#define CPM_SLCR_BISR_CACHE_CTRL_OFFSET				(0x000003F0U)
#define CPM_SLCR_BISR_CACHE_STATUS_OFFSET			(0x000003ECU)
#define CPM_SLCR_BISR_CACHE_CTRL_CLR_MASK			(0x00000010U)
#define CPM_SLCR_BISR_CACHE_CTRL_TRIGGER_MASK			(0x00000001U)
#define CPM_SLCR_BISR_CACHE_STATUS_DONE_MASK			(0x00000001U)
#define CPM_SLCR_BISR_CACHE_STATUS_PASS_MASK			(0x00000002U)

/**
 * CPM5_SLCR Module
 */
#define CPM5_SLCR_WPROTS_OFFSET					(0x00000000U)
#define CPM5_SLCR_WPROTP_OFFSET					(0x00000004U)
#define CPM5_SLCR_BISR_CACHE_STATUS_OFFSET			(0x00000500U)
#define CPM5_SLCR_BISR_CACHE_STATUS_DONE_MASK			(0x00000001U)
#define CPM5_SLCR_BISR_CACHE_STATUS_PASS_MASK			(0x00000002U)
#define CPM5_SLCR_BISR_CACHE_CTRL_OFFSET			(0x00000504U)
#define CPM5_SLCR_BISR_CACHE_CTRL_TRIGGER_MASK			(0x00000001U)
#define CPM5_SLCR_BISR_CACHE_CTRL_CLR_MASK			(0x00000010U)
#define CPM5_SLCR_BISR_CACHE_DATA_0_OFFSET			(0x00000508U)

/**
 * CPM_SLCR_SECURE Module
 */
#define CPM_SLCR_SECURE_WPROT0_OFFSET				(0x00000000U)
#define CPM_SLCR_SECURE_OD_MBIST_RESET_N_OFFSET			(0x00000420U)
#define CPM_SLCR_SECURE_OD_MBIST_PG_EN_OFFSET			(0x00000424U)
#define CPM_SLCR_SECURE_OD_MBIST_SETUP_OFFSET			(0x00000428U)
#define CPM_SLCR_SECURE_OD_MBIST_DONE_OFFSET			(0x0000042CU)
#define CPM_SLCR_SECURE_OD_MBIST_GO_OFFSET			(0x00000430U)

/**
 * CPM5_SLCR_SECURE Module
 */
#define CPM5_SLCR_SECURE_WPROTS_OFFSET				(0x00000000U)
#define CPM5_SLCR_SECURE_WPROTP_OFFSET				(0x00000004U)
#define CPM5_SLCR_SECURE_OD_MBIST_TRIGGER_OFFSET		(0x00000420U)
#define CPM5_SLCR_SECURE_OD_MBIST_TRIGGER_MASK			(0x0007FFFFU)
#define CPM5_SLCR_SECURE_OD_MBIST_DONE_OFFSET			(0x0000042CU)
#define CPM5_SLCR_SECURE_OD_MBIST_DONE_MASK			(0x0007FFFFU)
#define CPM5_SLCR_SECURE_OD_MBIST_PASSOUT_OFFSET		(0x00000430U)
#define CPM5_SLCR_SECURE_OD_MBIST_PASSOUT_MASK			(0x0007FFFFU)

/**
 * GTY PCSR Module
 */
#define GTY_PCSR_LOCK_OFFSET					(0x0000000CU)
#define GTY_PCSR_MASK_OFFSET					(0x00000000U)
#define GTY_PCSR_CONTROL_OFFSET					(0x00000004U)
#define GTY_PCSR_STATUS_OFFSET					(0x00000008U)
#define GTY_PCSR_INITCTRL_MASK					(0x01000000U)
#define GTY_PCSR_MEM_CLEAR_TRIGGER_MASK				(0x00040000U)
#define GTY_PCSR_BISR_TRIGGER_MASK				(0x20000000U)
#define GTY_PCSR_STATUS_MEM_CLEAR_DONE_MASK			(0x00000040U)
#define GTY_PCSR_STATUS_MEM_CLEAR_PASS_MASK			(0x00000080U)
#define GTY_PCSR_STATUS_BISR_DONE_MASK				(0x00080000U)
#define GTY_PCSR_STATUS_BISR_PASS_MASK				(0x00100000U)
#define GTY_PCSR_STATUS_HOUSECLEAN_DONE_MASK			(0x00020000U)

/**
 * EFUSE CACHE Module
 */
#define EFUSE_CACHE_MISC_CTRL_OFFSET				(0x000000A0U)
#define EFUSE_CACHE_MISC_CTRL_LBIST_EN_MASK			(0x00004000U)
#define EFUSE_CACHE_TRIM_CFRM_VGG_0_OFFSET			(0x000001B4U)
#define EFUSE_CACHE_TRIM_CFRM_VGG_1_OFFSET			(0x000001B8U)
#define EFUSE_CACHE_TRIM_CFRM_VGG_2_OFFSET			(0x000001BCU)
#define EFUSE_CACHE_TRIM_CRAM_OFFSET				(0x000001C0U)
#define EFUSE_CACHE_TRIM_BRAM_OFFSET				(0x00000098U)
#define EFUSE_CACHE_TRIM_URAM_OFFSET				(0x0000009CU)
#define EFUSE_CACHE_BISR_RSVD_0_OFFSET				(0x00000300U)
#define EFUSE_CACHE_TBITS1_BISR_RSVD_OFFSET			(0x00000400U)
#define EFUSE_CACHE_TBITS2_BISR_RSVD_OFFSET			(0x00000800U)

/**
 * PCIe controller module
 */
#define PCIEA_ATTRIB_0_FABRICEN					( PCIEA_ATTRIB_0_BASEADDR + 0x00000E84U )
#define PCIEA_ATTRIB_0_FABRICEN_ATTR_SHIFT			(0U)

#define PCIE_ATTRIB_0_TDVSEC_NXT_PTR				( PCIEA_ATTRIB_0_BASEADDR + 0x00000A34U )

#define CPM5_PCIE_ATTRIB_0_TDVSEC_NXT_PTR			( CPM5_PCIE_ATTRIB_0_BASEADDR + 0x00001DFCU )

#define PCIEA_ATTRIB_1_FABRICEN					( PCIEA_ATTRIB_1_BASEADDR + 0x00000E84U )
#define PCIEA_ATTRIB_1_FABRICEN_ATTR_SHIFT			(0U)

#define PCIEA_ATTRIB_DMA_ATTR_DMA_SPARE_3_H			( PCIEA_ATTRIB_DMA_BASEADDR + 0x0000008CU )
#define PCIEA_ATTRIB_DMA_ATTR_DMA_SPARE_3_H_MASK		(0x40000000U)

#define PCIEA_ATTRIB_0_DPLL					( PCIEA_ATTRIB_0_BASEADDR + 0x00000E80U )
#define PCIEA_ATTRIB_1_DPLL					( PCIEA_ATTRIB_1_BASEADDR + 0x00000E80U )
#define PCIEA_ATTRIB_DPLL_DPLL_RESET_MASK			(0x00000003U)

#define CPM5_PCIE0_CSR_FABRICEN					( CPM5_PCIE0_CSR_BASEADDR + 0x00000244U )
#define CPM5_PCIE1_CSR_FABRICEN					( CPM5_PCIE1_CSR_BASEADDR + 0x00000244U )
#define CPM5_PCIEA_CSR_FABRICEN_ATTR_SHIFT			(0U)
#define CPM5_DMA0_ATTRIB_ATTR_DMA_SPARE_3_H		( CPM5_DMA0_ATTR_BASEADDR + 0x00001084U )
#define CPM5_DMA1_ATTRIB_ATTR_DMA_SPARE_3_H		( CPM5_DMA1_ATTR_BASEADDR + 0x00001084U )
#define CPM5_DMA_ATTRIB_ATTR_DMA_SPARE_3_H_MASK	(0x40000000U)
#define CPM5_DMA0_ATTR_WPROTP						( CPM5_DMA0_ATTR_BASEADDR + 0x00000004U )
#define CPM5_DMA1_ATTR_WPROTP						( CPM5_DMA1_ATTR_BASEADDR + 0x00000004U )

/**
 * Register: PCSR_CONTROL
 */
#define NPI_PCSR_UNLOCK_VAL					(0xF9E8D7C6U)
#define NPI_PCSR_LOCK_OFFSET					(0x0000000CU)
#define NPI_PCSR_MASK_OFFSET					(0x00000000U)
#define NPI_PCSR_CONTROL_OFFSET					(0x00000004U)
#define NPI_PCSR_CONTROL_MEM_CLEAR_TRIGGER_MASK			(0x00040000U)
#define NPI_PCSR_CONTROL_ODISABLE_NPP_MASK			(0x00000008U)
#define NPI_PCSR_STATUS_OFFSET					(0x00000008U)
#define NPI_PCSR_STATUS_MEM_CLEAR_DONE_MASK			(0x00000040U)
#define NPI_PCSR_STATUS_MEM_CLEAR_PASS_MASK			(0x00000080U)
#define NPI_PCSR_CONTROL_PCOMPLETE_MASK				(0x00000001U)
#define NOC_DDRMC_UB_CLK_GATE_OFFSET				(0x0000024CU)
#define NOC_DDRMC_UB_CLK_GATE_BISR_EN_MASK			(0x00000040U)
#define NOC_DDRMC_UB_CLK_GATE_ILA_EN_MASK			(0x00000020U)
#define NPI_DDRMC_PSCR_CONTROL_UB_INITSTATE_MASK		(0x01000000U)
#define NOC_NPS_0_REG_CLOCK_MUX_OFFSET				(0x3A4U)

#define DDRMC5_UB_PCSR_MEM_CLEAR_TRIGGER_CRYPTO_MASK		(0x08000000U)
#define DDRMC5_UB_PCSR_MEM_CLEAR_DONE_CRYPTO_MASK		(0x00040000U)
#define DDRMC5_UB_PCSR_MEM_CLEAR_PASS_CRYPTO_MASK		(0x00080000U)

/**
 * Register: NIDB PCSR CONTROL
 */
#define NIDB_PCSR_LOCK_OFFSET				(0x0000000CU)
#define NIDB_PCSR_MASK_OFFSET				(0x00000000U)
#define NIDB_PCSR_MASK_ODISABLE_MASK			(0x00000004U)

#define NIDB_REG_PCSR_MASK_OFFSET			(0x00000000U)
#define NIDB_REG_PCSR_MASK_ODISABLE_MASK		(0x00000004U)
#define NIDB_REG_PCSR_MASK_PCOMPLETE_MASK		(0x00000001U)

#define NIDB_REG_PCSR_CONTROL_OFFSET			(0x00000004U)
#define NIDB_REG_PCSR_CONTROL_PCOMPLETE_MASK		(0x00000001U)

#define NIDB_REG_PCSR_STATUS_OFFSET			(0x00000008U)
#define NIDB_REG_PCSR_STATUS_REMOTE_LINK_READY_MASK	(0x00040000U)
#define NIDB_REG_PCSR_STATUS_LOCAL_LINK_READY_MASK	(0x00020000U)
#define NIDB_REG_PCSR_LOCK_OFFSET			(0x0000000CU)

#define NIDB_REG_RX_REPAIR_LN_0_OFFSET			(0x00000010U)

#define NIDB_REG_REPAIR_LOCK_OFFSET			(0x00000038U)

#define NIDB_0_BASE_ADDRESS				(0xF6620000U)
#define NIDB_8_BASE_ADDRESS				(0xF6F10000U)

/* NPS Nase address */
#define NPS_13_BASE_ADDRESS			(0xF61D2000U)
#define NPS_12_BASE_ADDRESS			(0xF61D0000U)

/* NPS configuration registers */
#define SLR1_NPS_13_REQUEST_PATH_REG_ADDRESS	(0xF61D2180U)
#define SLR1_NPS_13_RESPONSE_PATH_REG_ADDRESS	(0xF61D2320U)
#define SLR1_NPS_12_REQUEST_PATH_REG_ADDRESS	(0xF61D0184U)
#define SLR1_NPS_12_RESPONSE_PATH_REG_ADDRESS	(0xF61D0320U)

#define SLR3_NPS_13_REQUEST_PATH_REG_ADDRESS	(0xF61D2280U)
#define SLR3_NPS_13_RESPONSE_PATH_REG_ADDRESS	(0xF61D2320U)
#define SLR3_NPS_12_REQUEST_PATH_REG_ADDRESS	(0xF61D0284U)
#define SLR3_NPS_12_RESPONSE_PATH_REG_ADDRESS	(0xF61D0320U)
/**
 * Register NPS PCSR CONTROL
 */
#define NPS_REG_PCSR_MASK_OFFSET			(0x00000000U)
#define NPS_REG_PCSR_MASK_ODISABLE_MASK			(0x00000004U)
#define NPS_REG_PCSR_MASK_PCOMPLETE_MASK		(0x00000001U)

#define NPS_REG_PCSR_CONTROL_OFFSET			(0x00000004U)
#define NPS_REG_PCSR_CONTROL_PCOMPLETE_MASK		(0x00000001U)

#define NPS_REG_PCSR_LOCK_OFFSET			(0x0000000CU)
/**
 * Register NSU_1
 */
#define NOC_NSU_1_BASEADDR				(0xF6022000U)

#define NOC_NSU_1_REG_PCSR_MASK_OFFSET			(0x00000000U)
#define NOC_NSU_1_REG_PCSR_MASK_HOLDSTATE_MASK		(0x00000080U)
#define NOC_NSU_1_REG_PCSR_MASK_INITSTATE_MASK		(0x00000040U)
#define NOC_NSU_1_REG_PCSR_MASK_ODISABLE_AXI_MASK	(0x00000004U)
#define NOC_NSU_1_REG_PCSR_MASK_PCOMPLETE_MASK		(0x00000001U)

#define NOC_NSU_1_REG_PCSR_LOCK_OFFSET			(0x0000000CU)

#define NOC_NSU_1_REG_SRC_OFFSET			(0x00000100U)



#define NOC_NSU_1_REG_PCSR_CONTROL_OFFSET	(0x00000004U)
#define NOC2_NMU_0_REG_ISR_OFFSET				(0x00000030U)
#define NOC2_NMU_0_REG_ISR_SCAN_CLEAR_MASK		(0x08000000U)
#define NOC2_NSU_0_REG_ISR_OFFSET				(0x00000044U)
#define NOC2_NSU_0_REG_ISR_SCAN_CLR_ERR_MASK    (0x00200000U)
#define NOC2_NPS_0_REG_ISR_OFFSET				(0x00000044U)
#define NOC2_NPS_0_REG_ISR_SCAN_CLR_MASK    (0x00100000U)

/**
 * DDRMC Registers
 */
#define DDRMC_MAIN_UB_OFFSET					(0x40000U)
#define DDRMC_MAIN_REG_COM_4_OFFSET				(0xC18U)
#define DDRMC_MAIN_DRAM_MODE_REPORT_MASK			(0x1FU)
#define DDRMC_MAIN_SELF_REFRESH_MODE				BIT(2U)
#define DDRMC_UB_PMC2UB_INTERRUPT_OFFSET			(0x228U)
#define DDRMC_UB_UB2PMC_ACK_OFFSET				(0x22CU)
#define DDRMC_UB_UB2PMC_DONE_OFFSET				(0x230U)
#define DDRMC_UB_PMC2UB_INTERRUPT_SPARE_0_MASK			BIT(2U)
#define DDRMC_UB_UB2PMC_ACK_SPARE_0_MASK			BIT(2U)
#define DDRMC_UB_UB2PMC_DONE_SPARE_0_MASK			BIT(2U)
#define DDRMC_UB_PMC2UB_INTERRUPT_SR_EXIT_MASK			BIT(1U)
#define DDRMC_UB_UB2PMC_ACK_SR_EXIT_MASK			BIT(1U)
#define DDRMC_UB_UB2PMC_DONE_SR_EXIT_MASK			BIT(1U)
#define DDRMC_UB_PCSR_CONTROL_PCOMPLETE_MASK			(0x1U)
#define DDRMC_MAIN_DDRMC_ISR_OFFSET 			(0x14U)
#define DDRMC_MAIN_DDRMC_ISR_SCAN_CLEAR_FAIL_MASK (0x80000000U)

/**
 * HBM_PHY_MS
 */
#define HBM_PHY_MS_CFG1_OFFSET					(0x38U)
#define HBM_PHY_MS_CFG2_OFFSET					(0x3CU)
#define HBM_PHY_MS_CFG6_OFFSET					(0x4CU)
#define HBM_PHY_MS_CFG64_OFFSET					(0xF0U)
#define HBM_PHY_MS_CFG66_OFFSET					(0xF8U)

/* HBM Phy MS related macros */
#define HBM_PHY_MS_OFF_FROM_PREV_HBMMC_MC			(0x38000U)
#define HBM_PHY_MS_CFG66_DATA_SHIFT				(24U)
#define HBM_PHY_MS_CFG66_DATA_MASK				(0xFFU)
#define HBM_PHY_MS_CFG66_DATA_VALID_BIT				(0x1U << 7U)

/* Masks/Shifts for HBM Temp Monitoring Registers */
#define XPM_RTCA_HBM_TEMP_CONFIG_STACK0_EN_MASK			(0x1U << 0U)
#define XPM_RTCA_HBM_TEMP_CONFIG_STACK1_EN_MASK			(0x1U << 1U)
#define XPM_RTCA_HBM_TEMP_CONFIG_STACK_EN_MASK			(XPM_RTCA_HBM_TEMP_CONFIG_STACK0_EN_MASK |\
								 XPM_RTCA_HBM_TEMP_CONFIG_STACK1_EN_MASK)
#define XPM_RTCA_HBM_TEMP_CONFIG_STACKS_MAX_TEMP_SHIFT		(16U)
#define XPM_RTCA_HBM_TEMP_CONFIG_STACKS_MAX_TEMP_MASK		(0xFF0000U)
#define XPM_RTCA_HBM_TEMP_VAL_STACK0_TEMP_SHIFT			(0U)
#define XPM_RTCA_HBM_TEMP_VAL_STACK1_TEMP_SHIFT			(8U)
#define XPM_RTCA_HBM_TEMP_THRESHOLD_WIDTH			(0x7U) /**< HBM 7-bit Threshold Temperature Width >*/
#define XPM_RTCA_HBM_TEMP_THRESHOLD_OFFSET			(0x8U) /**< HBM Threshold Temperature Offset > */
#define XPM_RTCA_HBM_TEMP_THRESHOLD_MASK			BITNMASK(XPM_RTCA_HBM_TEMP_THRESHOLD_OFFSET, \
								XPM_RTCA_HBM_TEMP_THRESHOLD_WIDTH) /** < HBM Threshold Temperature Mask > */

/**
 * CRP_RESET_REASON
 */
#define LAST_RESET_REASON_REG					(PGGS_BASEADDR + 0x8U)
#define CRP_RESET_REASON_MASK					(0x0000FFFFU)
#define CRP_RESET_REASON_SLR_SYS_MASK				(0x00000400U)
#define CRP_RESET_REASON_SW_SYS_MASK				(0x00000200U)
#define CRP_RESET_REASON_ERR_SYS_MASK				(0x00000100U)
#define CRP_RESET_REASON_DAP_SYS_MASK				(0x00000080U)
#define CRP_RESET_REASON_ERR_POR_MASK				(0x00000008U)
#define CRP_RESET_REASON_SLR_POR_MASK				(0x00000004U)
#define CRP_RESET_REASON_SW_POR_MASK				(0x00000002U)
#define CRP_RESET_REASON_EXTERNAL_POR_MASK			(0x00000001U)

/**
 * CRP CFU Registers
 */
#define CRP_CFU_REF_CTRL_OFFSET				(0x00000108U)
#define CRP_CFU_REF_CTRL_DIVISOR0_MASK				(0x0003FF00U)
#define CRP_CFU_REF_CTRL_DIVISOR0_MASK_MSB			(0x00020000U)

/**
 * CRP_RST_NONPS
 */
#define CRP_RST_NONPS_NOC_RESET_MASK				(0x00000040U)
#define CRP_RST_NONPS_NOC_POR_MASK				(0x00000020U)
#ifndef CRP_RST_NONPS_NPI_RESET_MASK
	#define CRP_RST_NONPS_NPI_RESET_MASK			(0x00000010U)
#endif

#define CRP_RST_NONPS_SYS_RST_1_MASK				(0x00000004U)
#define CRP_RST_NONPS_SYS_RST_2_MASK				(0x00000002U)
#define CRP_RST_NONPS_SYS_RST_3_MASK				(0x00000001U)

/**
 * Definitions required from pmc_tap.h
 */
#define PMC_TAP_IDCODE_SI_REV_MASK				(0xF0000000U)
#define PMC_TAP_IDCODE_SI_REV_SHIFT				(28U)
#define PMC_TAP_IDCODE_SBFMLY_MASK				(0x001C0000U)
#define PMC_TAP_IDCODE_DEV_MASK					(0x0003F000U)
#define PMC_TAP_IDCODE_DEV_SBFMLY_MASK				(PMC_TAP_IDCODE_SBFMLY_MASK | PMC_TAP_IDCODE_DEV_MASK)

#define PMC_TAP_VERSION_PLATFORM_SHIFT				(24U)
#define PMC_TAP_VERSION_PLATFORM_MASK				(0x0F000000U)
#define PMC_TAP_VERSION_PLATFORM_VERSION_SHIFT			(28U)
#define PMC_TAP_VERSION_PLATFORM_VERSION_MASK			(0xF0000000U)
#define PMC_TAP_VERSION_PMC_VERSION_SHIFT			(0U)

/**
 * SLR TYPES
 */
#define PMC_TAP_SLR_TYPE_OFFSET					(0x00000024U)
#define PMC_TAP_SLR_TYPE_WIDTH					(0x00000002U)
#define PMC_TAP_SLR_TYPE_MASK					(0x00000007U)

/**
 * XPPU registers
 */
#define XPPU_CTRL_OFFSET					(0x0U)
#define XPPU_CTRL_ENABLE_SHIFT					(0U)
#define XPPU_CTRL_ENABLE_MASK					(0x1U)
#define XPPU_CTRL_MID_PARITY_EN_SHIFT				(1U)
#define XPPU_CTRL_MID_PARITY_EN_MASK				(0x2U)
#define XPPU_CTRL_APER_PARITY_EN_SHIFT				(2U)
#define XPPU_CTRL_APER_PARITY_EN_MASK				(0x4U)
#define XPPU_M_APERTURE_64KB_OFFSET				(0x44U)
#define XPPU_M_APERTURE_1MB_OFFSET				(0x48U)
#define XPPU_M_APERTURE_512MB_OFFSET				(0x4CU)
#define XPPU_BASE_64KB_OFFSET					(0x54U)
#define XPPU_BASE_1MB_OFFSET					(0x58U)
#define XPPU_BASE_512MB_OFFSET					(0x5CU)
#define XPPU_APERTURE_0_OFFSET					(0x1000U)
#define XPPU_APERTURE_384_OFFSET				(0x1600U)
#define XPPU_APERTURE_400_OFFSET				(0x1640U)
#define XPPU_APERTURE_PERMISSION_MASK				(0xFFFFFU)
#define XPPU_APERTURE_TRUSTZONE_OFFSET				(27U)
#define XPPU_APERTURE_TRUSTZONE_MASK				(0x8000000U)
#define XPPU_APERTURE_PARITY_SHIFT				(28U)
#define XPPU_APERTURE_PARITY_MASK				(0xF0000000U)
//for ES2
#define	XPPU_DYNAMIC_RECONFIG_APER_ADDR_OFFSET			(0x150U)
#define XPPU_DYNAMIC_RECONFIG_APER_PERM_OFFSET			(0x154U)
#define XPPU_DYNAMIC_RECONFIG_EN_OFFSET				(0xFCU)
//for ES1
#define XPPU_ENABLE_PERM_CHECK_REG00_OFFSET			(0x150U)

/**
 * XMPU registers
 */
#define XMPU_CTRL_OFFSET					(0x0U)
#define XMPU_CTRL_DISABLE_DEFAULT_S_REGION_MASK			(0x10U)
#define XMPU_CTRL_DISABLE_DEFAULT_S_REGION_SHIFT		(0x4U)
#define XMPU_CTRL_ALIGN_CFG_MASK				(0x8U)
#define XMPU_CTRL_ALIGN_CFG_SHIFT				(0x3U)
#define XMPU_R00_START_LO_OFFSET				(0x100U)
#define XMPU_R00_START_HI_OFFSET				(0x104U)
#define XMPU_R00_END_LO_OFFSET					(0x108U)
#define XMPU_R00_END_HI_OFFSET					(0x10CU)
#define XMPU_R00_CONFIG_OFFSET					(0x114U)
#define XMPU_RXX_CONFIG_NSCHECKTYPE_MASK			(0x10U)
#define XMPU_RXX_CONFIG_NSCHECKTYPE_SHIFT			(0x4U)
#define XMPU_RXX_CONFIG_REGIONNS_MASK				(0x8U)
#define XMPU_RXX_CONFIG_REGIONNS_SHIFT				(0x3U)
#define XMPU_RXX_CONFIG_WRALLOWED_MASK				(0x4U)
#define XMPU_RXX_CONFIG_WRALLOWED_SHIFT				(0x2U)
#define XMPU_RXX_CONFIG_RDALLOWED_MASK				(0x2U)
#define XMPU_RXX_CONFIG_RDALLOWED_SHIFT				(0x1U)
#define XMPU_RXX_CONFIG_ENABLE_MASK				(0x1U)
#define XMPU_RXX_CONFIG_ENABLE_SHIFT				(0x0U)

/**
 * OSPI Mux select related macros
 */
#define XPM_OSPI_MUX_SEL_OFFSET					(0x00000504U)
#define XPM_OSPI_MUX_SEL_MASK					(0x2U)
#define XPM_OSPI_MUX_SEL_SHIFT					(0x1U)

/**
 * USB PMU registers
 */
#define XPM_USB_CUR_PWR_OFFSET					(0x00000600U)
#define XPM_USB_PWR_REQ_OFFSET					(0x00000608U)
#define XPM_USB_PWR_MASK					(0x3U)

/**
 * IPI registers
 */
#define IPI_PMC_IER				(IPI_BASEADDR + 0x20018U)
#define IPI_PMC_IDR				(IPI_BASEADDR + 0x2001CU)
#define IPI_ISR_OFFSET				(0x10U)

/**
 * IPI register masks
 */
#define PMC_IPI_MASK						(0x00000002U)
#define IPI_0_MASK						(0x00000004U)
#define IPI_1_MASK						(0x00000008U)
#define IPI_2_MASK						(0x00000010U)
#define IPI_3_MASK						(0x00000020U)
#define IPI_4_MASK						(0x00000040U)
#define IPI_5_MASK						(0x00000080U)
#define IPI_6_MASK						(0x00000200U)

/**
 * XRAM registers
 */
#define XRAM_SLCR_PCSR_MASK_OFFSET					(0x0000U)
#define XRAM_SLCR_PCSR_PCR_OFFSET					(0x0004U)
#define XRAM_SLCR_PCSR_ODISABLE_PL_AXI0_MASK		(0x00000004U)
#define XRAM_SLCR_PCSR_ODISABLE_PL_AXI1_MASK		(0x00000008U)
#define XRAM_SLCR_PCSR_ODISABLE_PL_AXI2_MASK		(0x00000010U)
#define XRAM_SLCR_PCSR_ODISABLE_PL_AXILITE_MASK		(0x00000020U)
#define XRAM_SLCR_PCSR_FABRICEN_MASK				(0x00000200U)
#define XRAM_MEM_CLEAR_TRIGGER_0_MASK				(0x00040000U)
#define XRAM_SLCR_PCSR_PSR_OFFSET					(0x0008U)
#define XRAM_SLCR_PCSR_PSR_MEM_CLEAR_DONE_0_MASK	(0x00000040U)
#define XRAM_SLCR_PCSR_PSR_MEM_CLEAR_DONE_3_TO_1_MASK	(0x000E0000U)
#define XRAM_SLCR_PCSR_PSR_MEM_CLEAR_PASS_0_MASK	(0x00000080U)
#define XRAM_SLCR_PCSR_PSR_MEM_CLEAR_PASS_3_TO_1_MASK	(0x00700000U)
#define XRAM_SLCR_BISR_CACHE_DATA_0_OFFSET			(0xE010U)
#define XRAM_SLCR_PWR_UP_BANK0_OFFSET				(0x1100U)
#define XRAM_SLCR_PWR_UP_BANK1_OFFSET				(0x1110U)
#define XRAM_SLCR_PWR_UP_BANK2_OFFSET				(0x1120U)
#define XRAM_SLCR_PWR_UP_BANK3_OFFSET				(0x1130U)
#define XRAM_SLCR_PWR_DWN_BANK0_OFFSET				(0x1104U)
#define XRAM_SLCR_PWR_DWN_BANK1_OFFSET				(0x1114U)
#define XRAM_SLCR_PWR_DWN_BANK2_OFFSET				(0x1124U)
#define XRAM_SLCR_PWR_DWN_BANK3_OFFSET				(0x1134U)
#define XRAM_SLCR_PWR_STATUS_BANK0_OFFSET			(0x1108U)
#define XRAM_SLCR_PWR_STATUS_BANK1_OFFSET			(0x1118U)
#define XRAM_SLCR_PWR_STATUS_BANK2_OFFSET			(0x1128U)
#define XRAM_SLCR_PWR_STATUS_BANK3_OFFSET			(0x1138U)
#define XRAM_SLCR_APB_CLK_OFFSET				(0x00001004U)
#define XRAM_SLCR_APB_CLK_SRC_AXI_LITE_CLK_MASK			(0x00000001U)
#define XRAM_SLCR_MAIN_CLK_OFFSET				(0x00001000U)
#define XRAM_SLCR_MAIN_CLK_SRC_PL_CLK_MASK			(0x00000001U)
#define XRAM_SLCR_RST_OFFSET					(0x00001010U)
#define XRAM_SLCR_RST_SRC_PL_SRST_MASK				(0x00000001U)

/**
 * NPI Module for SSIT device
 */
#define NPI_NIR_0_OFFSET					(0x00000000U)

/**
 * AIE registers
 */
#ifndef VIVADO_ME_BASEADDR
       #define VIVADO_ME_BASEADDR		       (0x20000000000UL)
#endif

#define ME_NPI_REG_PCSR_STATUS_ME_PWR_SUPPLY_MASK		    0x00008000U
#define ME_NPI_REG_PCSR_STATUS_SCAN_CLEAR_DONE_MASK		    0x00000002U
#define ME_NPI_REG_PCSR_STATUS_SCAN_CLEAR_PASS_MASK		    0x00000004U
#define ME_NPI_REG_PCSR_MASK_ME_SHIM_RESET_MASK			    0x08000000U
#define ME_NPI_REG_PCSR_MASK_ME_ARRAY_RESET_MASK		    0x04000000U
#define ME_NPI_REG_PCSR_MASK_INITSTATE_MASK			    0x00000040U
#define ME_NPI_REG_PCSR_MASK_ME_IPOR_MASK			    0x01000000U
#define ME_NPI_REG_PCSR_MASK_SCAN_CLEAR_TRIGGER_MASK		    0x00000800U
#define ME_NPI_REG_PCSR_MASK_GATEREG_MASK			    0x00000002U
#define ME_NPI_REG_PCSR_MASK_PCOMPLETE_MASK			    0x00000001U
#define ME_NPI_REG_PCSR_MASK_MEM_CLEAR_EN_ALL_MASK		    0x00800000U
#define ME_NPI_REG_PCSR_MASK_OD_BIST_SETUP_1_MASK		    0x00400000U
#define ME_NPI_REG_PCSR_MASK_OD_MBIST_ASYNC_RESET_N_MASK	    0x00200000U
#define ME_NPI_REG_PCSR_MASK_MEM_CLEAR_TRIGGER_MASK		    0x00040000U
#define ME_NPI_REG_PCSR_STATUS_MEM_CLEAR_PASS_MASK		    0x00000080U
#define ME_NPI_REG_PCSR_STATUS_MEM_CLEAR_DONE_MASK		    0x00000040U
#define ME_NPI_ME_TOP_ROW_OFFSET				    0x00000148U
#define ME_NPI_ME_ISR_OFFSET					    0x00000030U
#define ME_NPI_ME_ISR_MASK					    0x0000000FU
#define ME_NPI_ME_SPARE_CTRL_OFFSET				    0x00000200U
#define ME_NPI_ME_SPARE_CTRL_PROTECTED_REG_EN_MASK		    0x00000001U
#define ME_NPI_ME_SMID_REG					    0x00000204U
#define ME_NPI_ME_SECURE_REG					    0x00000208U
#define ME_NPI_REG_PCSR_MASK_ODISABLE_SHIFT	2U
#define ME_NPI_REG_PCSR_MASK_ODISABLE_0_MASK \
					  (1U << (ME_NPI_REG_PCSR_MASK_ODISABLE_SHIFT + 0U))
#define ME_NPI_REG_PCSR_MASK_ODISABLE_1_MASK \
					  (1U << (ME_NPI_REG_PCSR_MASK_ODISABLE_SHIFT + 1U))
#define ME_AXIMM_CONFIG_DECERR_BLOCK_EN_MASK			0x00000008U
#define ME_AXIMM_CONFIG_SLVERR_BLOCK_EN_MASK			0x00000004U

#define AIE_CORE_CONTROL_OFFSET				    0x00032000U
#define AIE_CORE_STATUS_OFFSET					    0x00032004U
#define AIE_CORE_ECC_SCRUB_EVENT_OFFSET			    0x00032110U
#define AIE_PROGRAM_MEM_OFFSET					    0x00020000U
#define AIE_DATA_MEM_OFFSET					    0x00000000U
#define AIE_TILE_CLOCK_CONTROL_OFFSET			    0x00036040U
#define AIE_TILE_CLOCK_CONTROL_CLK_BUFF_EN_MASK			    0x00000001U
#define ME_CORE_REF_CTRL_OFFSET		0x00000138U
#define AIE_DIVISOR0_MASK			0x0003FF00U
#define AIE_DIVISOR0_SHIFT			8U
#define AIE_PL_MODULE_COLUMN_RST_CTRL_OFFSET			0x00036048U
#define AIE_TILE_COL_SHIM_RST_OFFSET				0x0003604CU
#define AIE_NOC_MODULE_ME_AXIMM_CONFIG_OFFSET			0x0001E020U
#define AIE_NOC_MODULE_INTR_CTRL_L2_INTR_OFFSET			0x00015010U

/**
 * AIE2 Registers
 */
#define AIE2_NPI_ME_PROT_REG_CTRL_OFFSET			0x00000200U
#define ME_PROT_REG_CTRL_PROTECTED_REG_EN_MASK			0x00000001U
#define ME_PROT_REG_CTRL_WE_COL_ID_MASK				0x0000007FU
#define ME_PROT_REG_CTRL_WE_COL_ID_LAST_SHIFT			(8U)
#define ME_PROT_REG_CTRL_WE_COL_ID_FIRST_SHIFT			(1U)
#define AIE2_PL_MODULE_COLUMN_CLK_CTRL_OFFSET	0x000FFF20U
#define AIE2_MEM_TILE_MODULE_MEM_CTRL_OFFSET	0x00096048U
#define AIE2_CORE_MODULE_MEM_CTRL_OFFSET		0x00036070U
#define AIE2_MEM_MODULE_MEM_CTRL_OFFSET			0x00016010U
#define AIE2_MEM_TILE_MODULE_MEM_CTRL_MEM_ZEROISATION_MASK	0x00000001U
#define AIE2_CORE_MODULE_MEM_CTRL_MEM_ZEROISATION_MASK		0x00000001U
#define AIE2_MEM_MODULE_MEM_CTRL_MEM_ZEROISATION_MASK		0x00000001U
#define AIE2_PL_MODULE_COLUMN_RST_CTRL_OFFSET			0x000FFF28U
#define AIE2_NOC_MODULE_ME_AXIMM_CONFIG_OFFSET			0x0001E020U
#define AIE2_NOC_MODULE_INTR_CTRL_L2_INTR_OFFSET		0x00015010U

/**
 * PMC Analog Registers
 */
#define PMC_ANLG_CFG_POR_CNT_SKIP_OFFSET		    (0x00000030U)
#define PMC_ANLG_CFG_POR_CNT_SKIP_OFFSET_VAL_MASK	    (0x00000001U)

/**
 * SysMon Registers
 */
#define PMC_SYSMON_SUPPLY0			PMC_SYSMON_BASEADDR + (0x00001040U)
#define PMC_SYSMON_SUPPLY0_TH_LOWER		PMC_SYSMON_BASEADDR + (0x00001980U)
#define PMC_SYSMON_NEW_DATA_FLAG0		PMC_SYSMON_BASEADDR + (0x00001000U)
#define PMC_SYSMON_DEVICE_TEMP_TH_UPPER		PMC_SYSMON_BASEADDR + (0x00001974U)
#define PMC_SYSMON_DEVICE_TEMP_MAX_OFFSET	(0x00001030U)
#define PMC_SYSMON_DEVICE_TEMP_MIN_OFFSET	(0x00001034U)
#define PMC_SYSMON_TEST_ANA_CTRL0		PMC_SYSMON_BASEADDR + (0x00000134U)
#define PMC_SYSMON_TEST_ANA_CTRL1		PMC_SYSMON_BASEADDR + (0x00000138U)

#define CRP_RST_PS_PL_POR_MASK			(0x00000020U)
#define CRP_RST_PS_PS_POR_MASK			(0x00000040U)



/**
 * Register: PMC_ANALOG_OD_MBIST_RST
 */
#define PMC_ANALOG_OD_MBIST_RST			( ( PMC_ANALOG_BASEADDR ) + 0X00020100U )
#define PMC_ANALOG_OD_MBIST_RST_LPD_IOU_MASK	0X00000040U
#define PMC_ANALOG_OD_MBIST_RST_LPD_RPU_MASK	0X00000020U
#define PMC_ANALOG_OD_MBIST_RST_LPD_MASK	0X00000010U

/**
 * Register: PMC_ANALOG_OD_MBIST_PG_EN
 */
#define PMC_ANALOG_OD_MBIST_PG_EN		( ( PMC_ANALOG_BASEADDR ) + 0X00020104U )
#define PMC_ANALOG_OD_MBIST_PG_EN_LPD_IOU_MASK	0X00000040U
#define PMC_ANALOG_OD_MBIST_PG_EN_LPD_RPU_MASK	0X00000020U
#define PMC_ANALOG_OD_MBIST_PG_EN_LPD_MASK	0X00000010U

/**
 * Register: PMC_ANALOG_OD_MBIST_SETUP
 */
#define PMC_ANALOG_OD_MBIST_SETUP		( ( PMC_ANALOG_BASEADDR ) + 0X00020108U )
#define PMC_ANALOG_OD_MBIST_SETUP_LPD_IOU_MASK	0X00000040U
#define PMC_ANALOG_OD_MBIST_SETUP_LPD_RPU_MASK	0X00000020U
#define PMC_ANALOG_OD_MBIST_SETUP_LPD_MASK	0X00000010U

/**
 * Register: PMC_ANALOG_OD_MBIST_DONE
 */
#define PMC_ANALOG_OD_MBIST_DONE		( ( PMC_ANALOG_BASEADDR ) + 0X00020110U )
#define PMC_ANALOG_OD_MBIST_DONE_LPD_IOU_MASK	0X00000040U
#define PMC_ANALOG_OD_MBIST_DONE_LPD_RPU_MASK	0X00000020U
#define PMC_ANALOG_OD_MBIST_DONE_LPD_MASK	0X00000010U

/**
 * Register: PMC_ANALOG_OD_MBIST_GOOD
 */
#define PMC_ANALOG_OD_MBIST_GOOD		( ( PMC_ANALOG_BASEADDR ) + 0X00020114U )
#define PMC_ANALOG_OD_MBIST_GOOD_LPD_IOU_MASK	0X00000040U
#define PMC_ANALOG_OD_MBIST_GOOD_LPD_RPU_MASK	0X00000020U
#define PMC_ANALOG_OD_MBIST_GOOD_LPD_MASK	0X00000010U

/**
 * Register: PMC_ANALOG_SCAN_CLEAR_TRIGGER
 */
#define PMC_ANALOG_SCAN_CLEAR_TRIGGER			( ( PMC_ANALOG_BASEADDR ) + 0X00020120U )
#define PMC_ANALOG_SCAN_CLEAR_TRIGGER_LPD_IOU_MASK	0X00000040U
#define PMC_ANALOG_SCAN_CLEAR_TRIGGER_LPD_RPU_MASK	0X00000020U
#define PMC_ANALOG_SCAN_CLEAR_TRIGGER_LPD_MASK		0X00000010U
#define PMC_ANALOG_SCAN_CLEAR_TRIGGER_NOC_MASK		0X00000100U

/**
 * Register: PMC_ANALOG_SCAN_CLEAR_DONE
 */
#define PMC_ANALOG_SCAN_CLEAR_DONE			( ( PMC_ANALOG_BASEADDR ) + 0X00020128U )
#define PMC_ANALOG_SCAN_CLEAR_DONE_LPD_IOU_MASK		0X00000040U
#define PMC_ANALOG_SCAN_CLEAR_DONE_LPD_RPU_MASK		0X00000020U
#define PMC_ANALOG_SCAN_CLEAR_DONE_LPD_MASK		0X00000010U

/**
 * Register: PMC_ANALOG_SCAN_CLEAR_PASS
 */
#define PMC_ANALOG_SCAN_CLEAR_PASS			( ( PMC_ANALOG_BASEADDR ) + 0X0002012CU )
#define PMC_ANALOG_SCAN_CLEAR_PASS_LPD_IOU_MASK		0X00000040U
#define PMC_ANALOG_SCAN_CLEAR_PASS_LPD_RPU_MASK		0X00000020U
#define PMC_ANALOG_SCAN_CLEAR_PASS_LPD_MASK		0X00000010U

/**
 * Register: PMC_ANALOG_LBIST_ENABLE
 */
#define PMC_ANALOG_LBIST_ENABLE			( ( PMC_ANALOG_BASEADDR ) + 0X00020200U )
#define PMC_ANALOG_LBIST_ENABLE_LPD_RPU_MASK	0X00000002U
#define PMC_ANALOG_LBIST_ENABLE_LPD_MASK	0X00000001U

/**
 * Register: PMC_ANALOG_LBIST_RST_N
 */
#define PMC_ANALOG_LBIST_RST_N			( ( PMC_ANALOG_BASEADDR ) + 0X00020204U )
#define PMC_ANALOG_LBIST_RST_N_LPD_RPU_MASK	0X00000002U
#define PMC_ANALOG_LBIST_ENABLE_LPD_MASK	0X00000001U

/**
 * Register: PMC_ANALOG_LBIST_RST_N
 */
#define PMC_ANALOG_LBIST_RST_N			( ( PMC_ANALOG_BASEADDR ) + 0X00020204U )
#define PMC_ANALOG_LBIST_RST_N_LPD_RPU_MASK	0X00000002U
#define PMC_ANALOG_LBIST_RST_N_LPD_MASK		0X00000001U

/**
 * Register: PMC_ANALOG_LBIST_ISOLATION_EN
 */
#define PMC_ANALOG_LBIST_ISOLATION_EN			( ( PMC_ANALOG_BASEADDR ) + 0X00020208U )
#define PMC_ANALOG_LBIST_ISOLATION_EN_LPD_RPU_MASK	0X00000002U
#define PMC_ANALOG_LBIST_ISOLATION_EN_LPD_MASK		0X00000001U

/**
 * Register: PMC_ANALOG_LBIST_DONE
 */
#define PMC_ANALOG_LBIST_DONE			( ( PMC_ANALOG_BASEADDR ) + 0X00020210U )
#define PMC_ANALOG_LBIST_DONE_LPD_RPU_MASK	0X00000002U
#define PMC_ANALOG_LBIST_DONE_LPD_MASK		0X00000001U

/**
 * PMC RAM Registers reserved for housecleaning disable
 */

#define PM_HOUSECLEAN_DISABLE_REG_1	(0xF2014170U)

#define PM_HOUSECLEAN_DISABLE_LPD_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_LPD_OFFSET	(0U)
#define PM_HOUSECLEAN_DISABLE_LPD_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_LPD_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_LPD_OFFSET, \
							PM_HOUSECLEAN_DISABLE_LPD_WIDTH \
							) \
						)
#define PM_HOUSECLEAN_DISABLE_FPD_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_FPD_OFFSET	(4U)
#define PM_HOUSECLEAN_DISABLE_FPD_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_FPD_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_FPD_OFFSET, \
							PM_HOUSECLEAN_DISABLE_FPD_WIDTH \
							) \
						)
#define PM_HOUSECLEAN_DISABLE_NPD_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_NPD_OFFSET	(8U)
#define PM_HOUSECLEAN_DISABLE_NPD_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_NPD_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_NPD_OFFSET, \
							PM_HOUSECLEAN_DISABLE_NPD_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_CPM_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_CPM_OFFSET	(12U)
#define PM_HOUSECLEAN_DISABLE_CPM_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_CPM_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_CPM_OFFSET, \
							PM_HOUSECLEAN_DISABLE_CPM_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_AIE_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_AIE_OFFSET	(16U)
#define PM_HOUSECLEAN_DISABLE_AIE_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_AIE_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_AIE_OFFSET, \
							PM_HOUSECLEAN_DISABLE_AIE_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_PLD_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_PLD_OFFSET	(20U)
#define PM_HOUSECLEAN_DISABLE_PLD_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_PLD_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_PLD_OFFSET, \
							PM_HOUSECLEAN_DISABLE_PLD_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_VDU_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_VDU_OFFSET	(24U)
#define PM_HOUSECLEAN_DISABLE_VDU_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_VDU_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_VDU_OFFSET, \
							PM_HOUSECLEAN_DISABLE_VDU_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_GT_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_1)
#define PM_HOUSECLEAN_DISABLE_GT_OFFSET		(28U)
#define PM_HOUSECLEAN_DISABLE_GT_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_GT_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_GT_OFFSET, \
							PM_HOUSECLEAN_DISABLE_GT_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_REG_2		(0xF2014174U)

#define PM_HOUSECLEAN_DISABLE_HNIC_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_2)
#define PM_HOUSECLEAN_DISABLE_HNIC_OFFSET	(0U)
#define PM_HOUSECLEAN_DISABLE_HNIC_WIDTH	(4U)
#define PM_HOUSECLEAN_DISABLE_HNIC_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_HNIC_OFFSET, \
							PM_HOUSECLEAN_DISABLE_HNIC_WIDTH \
							) \
						)
#define PM_HOUSECLEAN_DISABLE_DDRMC_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_2)
#define PM_HOUSECLEAN_DISABLE_DDRMC_OFFSET	(4U)
#define PM_HOUSECLEAN_DISABLE_DDRMC_WIDTH	(4U)
#define PM_HOUSECLEAN_DISABLE_DDRMC_MASK	(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_DDRMC_OFFSET, \
							PM_HOUSECLEAN_DISABLE_DDRMC_WIDTH \
							) \
						)
#define PM_HOUSECLEAN_DISABLE_BFR_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_2)
#define PM_HOUSECLEAN_DISABLE_BFR_OFFSET	(8U)
#define PM_HOUSECLEAN_DISABLE_BFR_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_BFR_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_BFR_OFFSET, \
							PM_HOUSECLEAN_DISABLE_BFR_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_SDFEC_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_2)
#define PM_HOUSECLEAN_DISABLE_SDFEC_OFFSET	(12U)
#define PM_HOUSECLEAN_DISABLE_SDFEC_WIDTH	(4U)
#define PM_HOUSECLEAN_DISABLE_SDFEC_MASK	(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_SDFEC_OFFSET, \
							PM_HOUSECLEAN_DISABLE_SDFEC_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_ILKN_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_2)
#define PM_HOUSECLEAN_DISABLE_ILKN_OFFSET	(16U)
#define PM_HOUSECLEAN_DISABLE_ILKN_WIDTH	(4U)
#define PM_HOUSECLEAN_DISABLE_ILKN_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_ILKN_OFFSET, \
							PM_HOUSECLEAN_DISABLE_ILKN_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_PMC_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_2)
#define PM_HOUSECLEAN_DISABLE_PMC_OFFSET	(20U)
#define PM_HOUSECLEAN_DISABLE_PMC_WIDTH		(4U)
#define PM_HOUSECLEAN_DISABLE_PMC_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_PMC_OFFSET, \
							PM_HOUSECLEAN_DISABLE_PMC_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_REG_3		(0xF2014178U)

#define PM_HOUSECLEAN_DISABLE_DAC_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_3)
#define PM_HOUSECLEAN_DISABLE_DAC_OFFSET	(0U)
#define PM_HOUSECLEAN_DISABLE_DAC_WIDTH		(3U)
#define PM_HOUSECLEAN_DISABLE_DAC_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_DAC_OFFSET, \
							PM_HOUSECLEAN_DISABLE_DAC_WIDTH \
							) \
						)

#define PM_HOUSECLEAN_DISABLE_ADC_BASEADDR	(PM_HOUSECLEAN_DISABLE_REG_3)
#define PM_HOUSECLEAN_DISABLE_ADC_OFFSET	(3U)
#define PM_HOUSECLEAN_DISABLE_ADC_WIDTH		(1U)
#define PM_HOUSECLEAN_DISABLE_ADC_MASK		(BITNMASK( \
							PM_HOUSECLEAN_DISABLE_ADC_OFFSET, \
							PM_HOUSECLEAN_DISABLE_ADC_WIDTH \
							) \
						)

#define HOUSECLEAN_DISABLE_DEFAULT_MASK			(0x00000000U)
#define HOUSECLEAN_FUNC_DISABLE_SCAN_MASK		(0x1U)
#define HOUSECLEAN_FUNC_DISABLE_BISR_MASK		(0x2U)
#define HOUSECLEAN_FUNC_DISABLE_MBIST_MASK		(0x4U)
#define HOUSECLEAN_FUNC_DISABLE_LBIST_MASK		(0x8U)
#define HOUSECLEAN_FUNC_DISABLE_PLHC_MASK		(0x8U)


/**
 * VDU Registers
 */
#define VDU_NPI_PCSR_MASK_SCAN_CLEAR_TRIGGER_MASK	(0x00000800U)
#define VDU_NPI_PCSR_STATUS_SCAN_CLEAR_DONE_MASK	(0x00000002U)
#define VDU_NPI_PCSR_STATUS_SCAN_CLEAR_PASS_MASK	(0x00000004U)
#define VDU_NPI_PCSR_MASK_MEM_CLEAR_TRIGGER_MASK	(0x00040000U)
#define VDU_NPI_PCSR_STATUS_MEM_CLEAR_DONE_MASK		(0x00000040U)
#define VDU_NPI_PCSR_STATUS_MEM_CLEAR_PASS_MASK		(0x00000080U)
#define VDU_NPI_PCSR_STATUS_VDU_PWR_SUPPLY_MASK		(0x00040000U)
#define VDU_NPI_PCSR_MASK_VDU_IPOR_MASK			(0x04000000U)
#define VDU_NPI_PCSR_MASK_ISO_2_VDU_PL_MASK		(0x00400000U)
#define VDU_NPI_REG_IDR0_OFFSET				(0x00000030U)
#define VDU_NPI_REG_IDR1_OFFSET				(0x0000003CU)
#define VDU_NPI_REG_IDR2_OFFSET				(0x00000048U)
#define VDU_NPI_REG_ISR_OFFSET				(0x00000024U)
#define VDU_INTERRUPTS_ALL_MASK				(0x0000000FU)
#define VDU_NPI_PCSR_MASK_INITSTATE			(0x00000040U)

/**
 * BFR-B Registers
 */
#define BFR_NPI_PCSR_MASK_PWRDN_MASK			(0x00004000U)
#define BFR_NPI_PCSR_STATUS_POWER_STATE_MASK		(0x00080000U)
#define BFR_NPI_PCSR_MEM_CLEAR_TRIGGER_MASK		(0x00040000U)
#define BFR_NPI_PCSR_STATUS_MEM_CLEAR_DONE_MASK		(0x00000040U)
#define BFR_NPI_PCSR_STATUS_MEM_CLEAR_PASS_MASK		(0x00000080U)
#define BFR_NPI_PCSR_MASK_SCAN_CLEAR_TRIGGER_MASK	(0x00000800U)
#define BFR_NPI_PCSR_STATUS_SCAN_CLEAR_DONE_MASK	(0x00000002U)
#define BFR_NPI_PCSR_STATUS_SCAN_CLEAR_PASS_MASK	(0x00000004U)
#define BFR_NPI_PCSR_MASK_INITSTATE			(0x00000040U)

/**
 * ADC/DAC Masks
*/
/*TBD: update these macro values once regdb is ready*/
#define DAC_NPI_PCSR_MEM_CLEAR_TRIGGER_MASK		(0x80000000U)
#define DAC_NPI_PCSR_STATUS_MEM_CLEAR_DONE_MASK		(0x02000000U)
#define DAC_NPI_PCSR_STATUS_MEM_CLEAR_PASS_MASK		(0x04000000U)
#define DAC_NPI_PCSR_MASK_SCAN_CLEAR_TRIGGER_MASK	(0x00000800U)
#define DAC_NPI_PCSR_STATUS_SCAN_CLEAR_DONE_MASK	(0x00000002U)
#define DAC_NPI_PCSR_STATUS_SCAN_CLEAR_PASS_MASK	(0x00000004U)
#define DAC_NPI_PCSR_MASK_TEST_SAFE_MASK 		(0x00080000U)
#define ADC_NPI_PCSR_MASK_SCAN_CLEAR_TRIGGER_MASK	(0x00000800U)
#define ADC_NPI_PCSR_STATUS_SCAN_CLEAR_DONE_MASK	(0x00000002U)
#define ADC_NPI_PCSR_STATUS_SCAN_CLEAR_PASS_MASK	(0x00000004U)
#define DAC_NPI_PSCR_CONTOL_RST_N_UBLAZE_RFDC_MASK	(0x10000000U)
#define DAC_NPI_PSCR_CONTOL_EN_UBLAZE_CLK_RFDC_MASK	(0x07800000U)
#define DAC_NPI_PSCR_STATUS_SLEEP_UBLAZE_RFDC_MASK	(0x00200000U)
#define ADC_NPI_PCSR_MASK_TEST_SAFE_MASK		(0x00080000U)

/**
 * SSIT Temperature Propagation Masks
 */
#define XPM_RTCA_SSIT_TEMP_PROP_FREQ_MASK		(0x0000FF00U)
#define XPM_RTCA_SSIT_TEMP_PROP_FREQ_SHIFT		(8U)
#define XPM_RTCA_SSIT_TEMP_PROP_ENABLE_MASK		(0x00000001U)

/**
 * PMC-NPI AXI connection Registers
 */
#define PMC_INT_REGS_NPI_AXI				(0xF13A0000U)
#define PMC_INT_REGS_NPI_AXI_POWER_IDLEREQ_MASK		(0x00000008U)
#define PMC_INT_REGS_NPI_AXI_POWER_IDLE_MASK		(0x00000006U)
#define PMC_INT_REGS_NPI_AXI_RAW_RST_N_MASK		(0x00000010U)

/*
 * CPM6 SLCR registers
 */
#define CPM6_SLCR_SECURE_WPROTS_OFFSET			(0x00000000U)
#define CPM6_SLCR_SECURE_MEM_CLR_TRIGGER_OFFSET		(0x00000420U)
#define CPM6_SLCR_SECURE_MEM_CLR_TRIGGER_MASK		(0x0007FFFFU)
#define CPM6_SLCR_SECURE_MEM_CLR_DONE_EXT_OFFSET	(0x0000042CU)
#define CPM6_SLCR_SECURE_MEM_CLR_DONE_EXT_MASK		(0x0007FFFFU)
#define CPM6_SLCR_SECURE_MEM_CLR_PASSOUT_EXT_OFFSET	(0x00000430U)
#define CPM6_SLCR_SECURE_MEM_CLR_PASSOUT_EXT_MASK	(0x0007FFFFU)

/*
 * GTMPW PCSR Registers
 */
#define GTMPW_PCSR_INITCTRL_MASK			(0x01000000U)
#define GTMPW_PCSR_MEM_CLEAR_TRIGGER_MASK		(0x00040000U)
#define GTMPW_PCSR_STATUS_MEM_CLEAR_DONE_MASK		(0x00000040U)
#define GTMPW_PCSR_STATUS_MEM_CLEAR_PASS_MASK		(0x00000080U)

/*
 * CRP Sysmon ref_ctrl
 */
#define CRP_SYSMON_REF_CTRL_OFFSET			(0x00000138U)
#define CRP_SYSMON_REF_CTRL_SRCSEL_NPI_REF_CLK_MASK     (0x00000004U)

/*
 * PPU RAM Memory
*/
#define PPU_RAM_INSTR_CNTLR_BASEADDR			(0xF0200000U)
#define PPU_RAM_INSTR_CNTLR_HIGHADDR			(0xF023FFAFU)
#define PPU_RAM_DATA_CNTLR_BASEADDR			(0xF0240000U)
#define PPU_RAM_DATA_CNTLR_HIGHADDR			(0xF025FFFFU)


#ifdef __cplusplus
}
#endif

#endif /* XPM_REGS_H */
