/******************************************************************************
* Copyright (C) 2018 - 2022 Xilinx, Inc.  All rights reserved.
* Copyright (c) 2022 - 2025 Advanced Micro Devices, Inc. All Rights Reserved.
* SPDX-License-Identifier: MIT
******************************************************************************/

/*****************************************************************************/
/**
*
* @file xospipsv_hw.h
* @addtogroup ospipsv_api OSPIPSV APIs
* @{
*
* The xospipsv_hw.h file contains low level access functions using the base address
* directly without an instance.
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who Date     Changes
* ----- --- -------- -----------------------------------------------.
* 1.0   nsk  02/19/18 First release
*       sk   02/04/19 Added support for SDR+PHY and DDR+PHY modes.
* 1.6   sk   02/07/22 Replaced driver version in addtogroup with Overview.
* 1.8   akm  01/03/23 Use Xil_WaitForEvent() API for register bit polling.
* 1.11  ng  08/20/24 Add spartanup device support
*
* </pre>
*
******************************************************************************/
/** @cond INTERNAL */
#ifndef XOSPIPSV_HW_H_		/**< prevent circular inclusions */
#define XOSPIPSV_HW_H_		/**< by using protection macros */

#ifdef __cplusplus
extern "C" {
#endif

/***************************** Include Files *********************************/

#include "xil_types.h"
#include "xil_assert.h"
#include "xil_io.h"
#include "xparameters.h"

/************************** Constant Definitions *****************************/

/**
 * @name Macros for Bus width
 * @{
 */
/**
 * Bus width macros for Single/Dual/Quad/Octal.
 */
#define DQ0	0U
#define DQ0_1	1U
#define DQ0_3	2U
#define DQ0_7	3U
/** @} */

/**
 * @name Octal-SPI Configuration Register
 * This register contains bits for configuring
 * Octal SPI, PHY, DTR/DDR, DMA, Chip Select, Baud rate,
 * Direct access controller, Dual byte opcode, CPOL, CPHASE,
 * AHB address remap etc.
 * @{
 */
/**
 * Register: XOSPIPSV_CONFIG_REG
 */
#define XOSPIPSV_CONFIG_REG   0X00000000U

#define XOSPIPSV_CONFIG_REG_IDLE_FLD_SHIFT   31
#define XOSPIPSV_CONFIG_REG_IDLE_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_IDLE_FLD_MASK    0X80000000U

#define XOSPIPSV_CONFIG_REG_DUAL_BYTE_OPCODE_EN_FLD_SHIFT   30
#define XOSPIPSV_CONFIG_REG_DUAL_BYTE_OPCODE_EN_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_DUAL_BYTE_OPCODE_EN_FLD_MASK    0X40000000U

#define XOSPIPSV_CONFIG_REG_CRC_ENABLE_FLD_SHIFT   29
#define XOSPIPSV_CONFIG_REG_CRC_ENABLE_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_CRC_ENABLE_FLD_MASK    0X20000000U

#define XOSPIPSV_CONFIG_REG_CONFIG_RESV2_FLD_SHIFT   26
#define XOSPIPSV_CONFIG_REG_CONFIG_RESV2_FLD_WIDTH   3
#define XOSPIPSV_CONFIG_REG_CONFIG_RESV2_FLD_MASK    0X1C000000U

#define XOSPIPSV_CONFIG_REG_PIPELINE_PHY_FLD_SHIFT   25
#define XOSPIPSV_CONFIG_REG_PIPELINE_PHY_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_PIPELINE_PHY_FLD_MASK    0X02000000U

#define XOSPIPSV_CONFIG_REG_ENABLE_DTR_PROTOCOL_FLD_SHIFT   24
#define XOSPIPSV_CONFIG_REG_ENABLE_DTR_PROTOCOL_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENABLE_DTR_PROTOCOL_FLD_MASK    0X01000000U

#define XOSPIPSV_CONFIG_REG_ENABLE_AHB_DECODER_FLD_SHIFT   23
#define XOSPIPSV_CONFIG_REG_ENABLE_AHB_DECODER_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENABLE_AHB_DECODER_FLD_MASK    0X00800000U

#define XOSPIPSV_CONFIG_REG_MSTR_BAUD_DIV_FLD_SHIFT   19
#define XOSPIPSV_CONFIG_REG_MSTR_BAUD_DIV_FLD_WIDTH   4
#define XOSPIPSV_CONFIG_REG_MSTR_BAUD_DIV_FLD_MASK    0X00780000U

#define XOSPIPSV_CONFIG_REG_ENTER_XIP_MODE_IMM_FLD_SHIFT   18
#define XOSPIPSV_CONFIG_REG_ENTER_XIP_MODE_IMM_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENTER_XIP_MODE_IMM_FLD_MASK    0X00040000U

#define XOSPIPSV_CONFIG_REG_ENTER_XIP_MODE_FLD_SHIFT   17
#define XOSPIPSV_CONFIG_REG_ENTER_XIP_MODE_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENTER_XIP_MODE_FLD_MASK    0X00020000U

#define XOSPIPSV_CONFIG_REG_ENB_AHB_ADDR_REMAP_FLD_SHIFT   16
#define XOSPIPSV_CONFIG_REG_ENB_AHB_ADDR_REMAP_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENB_AHB_ADDR_REMAP_FLD_MASK    0X00010000U

#define XOSPIPSV_CONFIG_REG_ENB_DMA_IF_FLD_SHIFT   15
#define XOSPIPSV_CONFIG_REG_ENB_DMA_IF_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENB_DMA_IF_FLD_MASK    0X00008000U

#define XOSPIPSV_CONFIG_REG_WR_PROT_FLASH_FLD_SHIFT   14
#define XOSPIPSV_CONFIG_REG_WR_PROT_FLASH_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_WR_PROT_FLASH_FLD_MASK    0X00004000U

#define XOSPIPSV_CONFIG_REG_PERIPH_CS_LINES_FLD_SHIFT   10
#define XOSPIPSV_CONFIG_REG_PERIPH_CS_LINES_FLD_WIDTH   4
#define XOSPIPSV_CONFIG_REG_PERIPH_CS_LINES_FLD_MASK    0X00003C00U

#define XOSPIPSV_CONFIG_REG_PERIPH_SEL_DEC_FLD_SHIFT   9
#define XOSPIPSV_CONFIG_REG_PERIPH_SEL_DEC_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_PERIPH_SEL_DEC_FLD_MASK    0X00000200U

#define XOSPIPSV_CONFIG_REG_ENB_DIR_ACC_CTLR_FLD_SHIFT   7
#define XOSPIPSV_CONFIG_REG_ENB_DIR_ACC_CTLR_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENB_DIR_ACC_CTLR_FLD_MASK    0X00000080U

#define XOSPIPSV_CONFIG_REG_RESET_CFG_FLD_SHIFT   6
#define XOSPIPSV_CONFIG_REG_RESET_CFG_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_RESET_CFG_FLD_MASK    0X00000040U

#define XOSPIPSV_CONFIG_REG_RESET_PIN_FLD_SHIFT   5
#define XOSPIPSV_CONFIG_REG_RESET_PIN_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_RESET_PIN_FLD_MASK    0X00000020U

#define XOSPIPSV_CONFIG_REG_HOLD_PIN_FLD_SHIFT   4
#define XOSPIPSV_CONFIG_REG_HOLD_PIN_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_HOLD_PIN_FLD_MASK    0X00000010U

#define XOSPIPSV_CONFIG_REG_PHY_MODE_ENABLE_FLD_SHIFT   3
#define XOSPIPSV_CONFIG_REG_PHY_MODE_ENABLE_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_PHY_MODE_ENABLE_FLD_MASK    0X00000008U

#define XOSPIPSV_CONFIG_REG_SEL_CLK_PHASE_FLD_SHIFT   2
#define XOSPIPSV_CONFIG_REG_SEL_CLK_PHASE_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_SEL_CLK_PHASE_FLD_MASK    0X00000004U

#define XOSPIPSV_CONFIG_REG_SEL_CLK_POL_FLD_SHIFT   1
#define XOSPIPSV_CONFIG_REG_SEL_CLK_POL_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_SEL_CLK_POL_FLD_MASK    0X00000002U

#define XOSPIPSV_CONFIG_REG_ENB_SPI_FLD_SHIFT   0
#define XOSPIPSV_CONFIG_REG_ENB_SPI_FLD_WIDTH   1
#define XOSPIPSV_CONFIG_REG_ENB_SPI_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Device Read Instruction Configuration Register
 * This register contains bits for configuring
 * Dummy cycles, Instruction width, Address width, Data width,
 * Read opcode, Mode bits etc. for read operation.
 * @{
 */
/**
 * Register: XOSPIPSV_DEV_INSTR_RD_CONFIG_REG
 */
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG    0X00000004U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV5_FLD_SHIFT   29
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV5_FLD_WIDTH   3
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV5_FLD_MASK    0XE0000000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DUMMY_RD_CLK_CYCLES_FLD_SHIFT   24
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DUMMY_RD_CLK_CYCLES_FLD_WIDTH   5
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DUMMY_RD_CLK_CYCLES_FLD_MASK    0X1F000000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV4_FLD_SHIFT   21
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV4_FLD_WIDTH   3
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV4_FLD_MASK    0X00E00000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_MODE_BIT_ENABLE_FLD_SHIFT   20
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_MODE_BIT_ENABLE_FLD_WIDTH   1
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_MODE_BIT_ENABLE_FLD_MASK    0X00100000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV3_FLD_SHIFT   18
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV3_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV3_FLD_MASK    0X000C0000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DATA_XFER_TYPE_EXT_MODE_FLD_SHIFT   16
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DATA_XFER_TYPE_EXT_MODE_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DATA_XFER_TYPE_EXT_MODE_FLD_MASK    0X00030000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV2_FLD_SHIFT   14
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV2_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_INSTR_RESV2_FLD_MASK    0X0000C000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_ADDR_XFER_TYPE_STD_MODE_FLD_SHIFT   12
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_ADDR_XFER_TYPE_STD_MODE_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_ADDR_XFER_TYPE_STD_MODE_FLD_MASK    0X00003000U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_PRED_DIS_FLD_SHIFT   11
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_PRED_DIS_FLD_WIDTH   1
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_PRED_DIS_FLD_MASK    0X00000800U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DDR_EN_FLD_SHIFT   10
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DDR_EN_FLD_WIDTH   1
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_DDR_EN_FLD_MASK    0X00000400U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_INSTR_TYPE_FLD_SHIFT   8
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_INSTR_TYPE_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_INSTR_TYPE_FLD_MASK    0X00000300U

#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_OPCODE_NON_XIP_FLD_SHIFT   0
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_OPCODE_NON_XIP_FLD_WIDTH   8
#define XOSPIPSV_DEV_INSTR_RD_CONFIG_REG_RD_OPCODE_NON_XIP_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name Device Write Instruction Configuration Register
 * This register contains bits for configuring
 * Address width, Data width, Write opcode,
 * Dummy cycles etc. for write operation.
 * @{
 */
/**
 * Register: XOSPIPSV_DEV_INSTR_WR_CONFIG_REG
 */
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG   0X00000008U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV4_FLD_SHIFT   29
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV4_FLD_WIDTH   3
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV4_FLD_MASK    0XE0000000U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_DUMMY_WR_CLK_CYCLES_FLD_SHIFT   24
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_DUMMY_WR_CLK_CYCLES_FLD_WIDTH   5
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_DUMMY_WR_CLK_CYCLES_FLD_MASK    0X1F000000U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV3_FLD_SHIFT   18
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV3_FLD_WIDTH   6
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV3_FLD_MASK    0X00FC0000U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_DATA_XFER_TYPE_EXT_MODE_FLD_SHIFT   16
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_DATA_XFER_TYPE_EXT_MODE_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_DATA_XFER_TYPE_EXT_MODE_FLD_MASK    0X00030000U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV2_FLD_SHIFT   14
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV2_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV2_FLD_MASK    0X0000C000U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_ADDR_XFER_TYPE_STD_MODE_FLD_SHIFT   12
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_ADDR_XFER_TYPE_STD_MODE_FLD_WIDTH   2
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_ADDR_XFER_TYPE_STD_MODE_FLD_MASK    0X00003000U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV1_FLD_SHIFT   9
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV1_FLD_WIDTH   3
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_INSTR_RESV1_FLD_MASK    0X00000E00U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WEL_DIS_FLD_SHIFT   8
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WEL_DIS_FLD_WIDTH   1
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WEL_DIS_FLD_MASK    0X00000100U

#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_OPCODE_FLD_SHIFT   0
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_DEV_INSTR_WR_CONFIG_REG_WR_OPCODE_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name Octal-SPI Device Delay Register
 * This register is used to introduce relative delays
 * into the generation of the master output signals.
 * All timings are defined in cycles of the SPI REFERENCE
 * CLOCK/ext_clk, defined in this table as SPI master ref clock.
 * @{
 */
/**
 * Register: XOSPIPSV_DEV_DELAY_REG
 */
#define XOSPIPSV_DEV_DELAY_REG    0X0000000CU

#define XOSPIPSV_DEV_DELAY_REG_D_NSS_FLD_SHIFT   24
#define XOSPIPSV_DEV_DELAY_REG_D_NSS_FLD_WIDTH   8
#define XOSPIPSV_DEV_DELAY_REG_D_NSS_FLD_MASK    0XFF000000U

#define XOSPIPSV_DEV_DELAY_REG_D_BTWN_FLD_SHIFT   16
#define XOSPIPSV_DEV_DELAY_REG_D_BTWN_FLD_WIDTH   8
#define XOSPIPSV_DEV_DELAY_REG_D_BTWN_FLD_MASK    0X00FF0000U

#define XOSPIPSV_DEV_DELAY_REG_D_AFTER_FLD_SHIFT   8
#define XOSPIPSV_DEV_DELAY_REG_D_AFTER_FLD_WIDTH   8
#define XOSPIPSV_DEV_DELAY_REG_D_AFTER_FLD_MASK    0X0000FF00U

#define XOSPIPSV_DEV_DELAY_REG_D_INIT_FLD_SHIFT   0
#define XOSPIPSV_DEV_DELAY_REG_D_INIT_FLD_WIDTH   8
#define XOSPIPSV_DEV_DELAY_REG_D_INIT_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name Read Data Capture Register
 * This register contains bits for configuring
 * Read Delay, 	Sample edge, DQS enable bit and
 * DDR read delay.
 * @{
 */
/**
 * Register: XOSPIPSV_RD_DATA_CAPTURE_REG
 */
#define XOSPIPSV_RD_DATA_CAPTURE_REG    0X00000010U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV3_FLD_SHIFT   20
#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV3_FLD_WIDTH   12
#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV3_FLD_MASK    0XFFF00000U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_DDR_READ_DELAY_FLD_SHIFT   16
#define XOSPIPSV_RD_DATA_CAPTURE_REG_DDR_READ_DELAY_FLD_WIDTH   4
#define XOSPIPSV_RD_DATA_CAPTURE_REG_DDR_READ_DELAY_FLD_MASK    0X000F0000U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV2_FLD_SHIFT   9
#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV2_FLD_WIDTH   7
#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV2_FLD_MASK    0X0000FE00U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_DQS_ENABLE_FLD_SHIFT   8
#define XOSPIPSV_RD_DATA_CAPTURE_REG_DQS_ENABLE_FLD_WIDTH   1
#define XOSPIPSV_RD_DATA_CAPTURE_REG_DQS_ENABLE_FLD_MASK    0X00000100U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV1_FLD_SHIFT   6
#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV1_FLD_WIDTH   2
#define XOSPIPSV_RD_DATA_CAPTURE_REG_RD_DATA_RESV1_FLD_MASK    0X000000C0U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_SAMPLE_EDGE_SEL_FLD_SHIFT   5
#define XOSPIPSV_RD_DATA_CAPTURE_REG_SAMPLE_EDGE_SEL_FLD_WIDTH   1
#define XOSPIPSV_RD_DATA_CAPTURE_REG_SAMPLE_EDGE_SEL_FLD_MASK    0X00000020U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_DELAY_FLD_SHIFT   1
#define XOSPIPSV_RD_DATA_CAPTURE_REG_DELAY_FLD_WIDTH   4
#define XOSPIPSV_RD_DATA_CAPTURE_REG_DELAY_FLD_MASK    0X0000001EU

#define XOSPIPSV_RD_DATA_CAPTURE_REG_BYPASS_FLD_SHIFT   0
#define XOSPIPSV_RD_DATA_CAPTURE_REG_BYPASS_FLD_WIDTH   1
#define XOSPIPSV_RD_DATA_CAPTURE_REG_BYPASS_FLD_MASK    0X00000001U

#define XOSPIPSV_RD_DATA_CAPTURE_REG_4_CLK_CYCLES    1U
/** @} */

/**
 * @name Device Size Configuration Register
 * This register contains bits for configuring
 * Number of address bytes, Number of bytes per device page,
 * Number of bytes per Block and memory connected to each CS.
 * @{
 */
/**
 * Register: XOSPIPSV_DEV_SIZE_CONFIG_REG
 */
#define XOSPIPSV_DEV_SIZE_CONFIG_REG    0X00000014U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_DEV_SIZE_RESV_FLD_SHIFT   29
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_DEV_SIZE_RESV_FLD_WIDTH   3
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_DEV_SIZE_RESV_FLD_MASK    0XE0000000U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS3_FLD_SHIFT   27
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS3_FLD_WIDTH   2
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS3_FLD_MASK    0X18000000U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS2_FLD_SHIFT   25
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS2_FLD_WIDTH   2
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS2_FLD_MASK    0X06000000U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS1_FLD_SHIFT   23
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS1_FLD_WIDTH   2
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS1_FLD_MASK    0X01800000U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS0_FLD_SHIFT   21
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS0_FLD_WIDTH   2
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_MEM_SIZE_ON_CS0_FLD_MASK    0X00600000U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_BYTES_PER_SUBSECTOR_FLD_SHIFT   16
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_BYTES_PER_SUBSECTOR_FLD_WIDTH   5
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_BYTES_PER_SUBSECTOR_FLD_MASK    0X001F0000U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_BYTES_PER_DEVICE_PAGE_FLD_SHIFT   4
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_BYTES_PER_DEVICE_PAGE_FLD_WIDTH   12
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_BYTES_PER_DEVICE_PAGE_FLD_MASK    0X0000FFF0U

#define XOSPIPSV_DEV_SIZE_CONFIG_REG_NUM_ADDR_BYTES_FLD_SHIFT   0
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_NUM_ADDR_BYTES_FLD_WIDTH   4
#define XOSPIPSV_DEV_SIZE_CONFIG_REG_NUM_ADDR_BYTES_FLD_MASK    0X0000000FU
/** @} */

/**
 * @name SRAM Partition Configuration Register
 * This register contains bits for configuring
 * Indirect Read Partition Size.
 * @{
 */
/**
 * Register: XOSPIPSV_SRAM_PARTITION_CFG_REG
 */
#define XOSPIPSV_SRAM_PARTITION_CFG_REG    0X00000018U

#define XOSPIPSV_SRAM_PARTITION_CFG_REG_SRAM_PARTITION_RESV_FLD_SHIFT   8
#define XOSPIPSV_SRAM_PARTITION_CFG_REG_SRAM_PARTITION_RESV_FLD_WIDTH   24
#define XOSPIPSV_SRAM_PARTITION_CFG_REG_SRAM_PARTITION_RESV_FLD_MASK    0XFFFFFF00U

#define XOSPIPSV_SRAM_PARTITION_CFG_REG_ADDR_FLD_SHIFT   0
#define XOSPIPSV_SRAM_PARTITION_CFG_REG_ADDR_FLD_WIDTH   8
#define XOSPIPSV_SRAM_PARTITION_CFG_REG_ADDR_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name Indirect AHB Address Trigger Register
 * This register contains bits for configuring
 * base address that will be used by the AHB controller.
 * @{
 */
/**
 * Register: XOSPIPSV_IND_AHB_ADDR_TRIGGER_REG
 */
#define XOSPIPSV_IND_AHB_ADDR_TRIGGER_REG    0X0000001CU

#define XOSPIPSV_IND_AHB_ADDR_TRIGGER_REG_ADDR_FLD_SHIFT   0
#define XOSPIPSV_IND_AHB_ADDR_TRIGGER_REG_ADDR_FLD_WIDTH   32
#define XOSPIPSV_IND_AHB_ADDR_TRIGGER_REG_ADDR_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name DMA Peripheral Configuration Register
 * This register contains bits for configuring
 * Number of Single Bytes and Number of Burst Bytes.
 * @{
 */
/**
 * Register: XOSPIPSV_DMA_PERIPH_CONFIG_REG
 */
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG    0X00000020U

#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_DMA_PERIPH_RESV2_FLD_SHIFT   12
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_DMA_PERIPH_RESV2_FLD_WIDTH   20
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_DMA_PERIPH_RESV2_FLD_MASK    0XFFFFF000U

#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_NUM_BURST_REQ_BYTES_FLD_SHIFT   8
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_NUM_BURST_REQ_BYTES_FLD_WIDTH   4
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_NUM_BURST_REQ_BYTES_FLD_MASK    0X00000F00U

#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_DMA_PERIPH_RESV1_FLD_SHIFT   4
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_DMA_PERIPH_RESV1_FLD_WIDTH   4
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_DMA_PERIPH_RESV1_FLD_MASK    0X000000F0U

#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_NUM_SINGLE_REQ_BYTES_FLD_SHIFT   0
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_NUM_SINGLE_REQ_BYTES_FLD_WIDTH   4
#define XOSPIPSV_DMA_PERIPH_CONFIG_REG_NUM_SINGLE_REQ_BYTES_FLD_MASK    0X0000000FU
/** @} */

/**
 * @name Remap Address Register
 * This register contains bits for configuring
 * value used to remap an incoming AHB address to a
 * different address used by the FLASH device.
 * @{
 */
/**
 * Register: XOSPIPSV_REMAP_ADDR_REG
 */
#define XOSPIPSV_REMAP_ADDR_REG    0X00000024U

#define XOSPIPSV_REMAP_ADDR_REG_VALUE_FLD_SHIFT   0
#define XOSPIPSV_REMAP_ADDR_REG_VALUE_FLD_WIDTH   32
#define XOSPIPSV_REMAP_ADDR_REG_VALUE_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Mode Bit Configuration Register
 * This register contains bits for configuring
 * Mode bits, CRC and Chunk size.
 * @{
 */
/**
 * Register: XOSPIPSV_MODE_BIT_CONFIG_REG
 */
#define XOSPIPSV_MODE_BIT_CONFIG_REG    0X00000028U

#define XOSPIPSV_MODE_BIT_CONFIG_REG_RX_CRC_DATA_LOW_FLD_SHIFT   24
#define XOSPIPSV_MODE_BIT_CONFIG_REG_RX_CRC_DATA_LOW_FLD_WIDTH   8
#define XOSPIPSV_MODE_BIT_CONFIG_REG_RX_CRC_DATA_LOW_FLD_MASK    0XFF000000U

#define XOSPIPSV_MODE_BIT_CONFIG_REG_RX_CRC_DATA_UP_FLD_SHIFT   16
#define XOSPIPSV_MODE_BIT_CONFIG_REG_RX_CRC_DATA_UP_FLD_WIDTH   8
#define XOSPIPSV_MODE_BIT_CONFIG_REG_RX_CRC_DATA_UP_FLD_MASK    0X00FF0000U

#define XOSPIPSV_MODE_BIT_CONFIG_REG_CRC_OUT_ENABLE_FLD_SHIFT   15
#define XOSPIPSV_MODE_BIT_CONFIG_REG_CRC_OUT_ENABLE_FLD_WIDTH   1
#define XOSPIPSV_MODE_BIT_CONFIG_REG_CRC_OUT_ENABLE_FLD_MASK    0X00008000U

#define XOSPIPSV_MODE_BIT_CONFIG_REG_MODE_BIT_RESV1_FLD_SHIFT   11
#define XOSPIPSV_MODE_BIT_CONFIG_REG_MODE_BIT_RESV1_FLD_WIDTH   4
#define XOSPIPSV_MODE_BIT_CONFIG_REG_MODE_BIT_RESV1_FLD_MASK    0X00007800U

#define XOSPIPSV_MODE_BIT_CONFIG_REG_CHUNK_SIZE_FLD_SHIFT   8
#define XOSPIPSV_MODE_BIT_CONFIG_REG_CHUNK_SIZE_FLD_WIDTH   3
#define XOSPIPSV_MODE_BIT_CONFIG_REG_CHUNK_SIZE_FLD_MASK    0X00000700U

#define XOSPIPSV_MODE_BIT_CONFIG_REG_MODE_FLD_SHIFT   0
#define XOSPIPSV_MODE_BIT_CONFIG_REG_MODE_FLD_WIDTH   8
#define XOSPIPSV_MODE_BIT_CONFIG_REG_MODE_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name SRAM Fill Register
 * This register contains bits for configuring
 * SRAM Fill Level for Indirect read and write operations.
 * @{
 */
/**
 * Register: XOSPIPSV_SRAM_FILL_REG
 */
#define XOSPIPSV_SRAM_FILL_REG    0X0000002CU

#define XOSPIPSV_SRAM_FILL_REG_SRAM_FILL_INDAC_WRITE_FLD_SHIFT   16
#define XOSPIPSV_SRAM_FILL_REG_SRAM_FILL_INDAC_WRITE_FLD_WIDTH   16
#define XOSPIPSV_SRAM_FILL_REG_SRAM_FILL_INDAC_WRITE_FLD_MASK    0XFFFF0000U

#define XOSPIPSV_SRAM_FILL_REG_SRAM_FILL_INDAC_READ_FLD_SHIFT   0
#define XOSPIPSV_SRAM_FILL_REG_SRAM_FILL_INDAC_READ_FLD_WIDTH   16
#define XOSPIPSV_SRAM_FILL_REG_SRAM_FILL_INDAC_READ_FLD_MASK    0X0000FFFFU
/** @} */

/**
 * @name TX Threshold Register
 * This register contains bits for configuring
 * the level at which the small TX FIFO not full
 * interrupt is generated.
 * @{
 */
/**
 * Register: XOSPIPSV_TX_THRESH_REG
 */
#define XOSPIPSV_TX_THRESH_REG    0X00000030U

#define XOSPIPSV_TX_THRESH_REG_TX_THRESH_RESV_FLD_SHIFT   5
#define XOSPIPSV_TX_THRESH_REG_TX_THRESH_RESV_FLD_WIDTH   27
#define XOSPIPSV_TX_THRESH_REG_TX_THRESH_RESV_FLD_MASK    0XFFFFFFE0U

#define XOSPIPSV_TX_THRESH_REG_LEVEL_FLD_SHIFT   0
#define XOSPIPSV_TX_THRESH_REG_LEVEL_FLD_WIDTH   5
#define XOSPIPSV_TX_THRESH_REG_LEVEL_FLD_MASK    0X0000001FU
/** @} */

/**
 * @name RX Threshold Register
 * This register contains bits for configuring
 * the level at which the small RX FIFO not empty
 * interrupt is generated.
 * @{
 */
/**
 * Register: XOSPIPSV_RX_THRESH_REG
 */
#define XOSPIPSV_RX_THRESH_REG    0X00000034U

#define XOSPIPSV_RX_THRESH_REG_RX_THRESH_RESV_FLD_SHIFT   5
#define XOSPIPSV_RX_THRESH_REG_RX_THRESH_RESV_FLD_WIDTH   27
#define XOSPIPSV_RX_THRESH_REG_RX_THRESH_RESV_FLD_MASK    0XFFFFFFE0U

#define XOSPIPSV_RX_THRESH_REG_LEVEL_FLD_SHIFT   0
#define XOSPIPSV_RX_THRESH_REG_LEVEL_FLD_WIDTH   5
#define XOSPIPSV_RX_THRESH_REG_LEVEL_FLD_MASK    0X0000001FU
/** @} */

/**
 * @name Write Completion Control Register
 * This register contains bits for configuring
 * how the controller will poll the device following
 * a write transfer like Opcode, Polling count etc.
 * @{
 */
/**
 * Register: XOSPIPSV_WRITE_COMPLETION_CTRL_REG
 */
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG    0X00000038U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLL_REP_DELAY_FLD_SHIFT   24
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLL_REP_DELAY_FLD_WIDTH   8
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLL_REP_DELAY_FLD_MASK    0XFF000000U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLL_COUNT_FLD_SHIFT   16
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLL_COUNT_FLD_WIDTH   8
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLL_COUNT_FLD_MASK    0X00FF0000U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_ENABLE_POLLING_EXP_FLD_SHIFT   15
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_ENABLE_POLLING_EXP_FLD_WIDTH   1
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_ENABLE_POLLING_EXP_FLD_MASK    0X00008000U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_DISABLE_POLLING_FLD_SHIFT   14
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_DISABLE_POLLING_FLD_WIDTH   1
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_DISABLE_POLLING_FLD_MASK    0X00004000U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_POLARITY_FLD_SHIFT   13
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_POLARITY_FLD_WIDTH   1
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_POLARITY_FLD_MASK    0X00002000U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_WR_COMP_CTRL_RESV1_FLD_SHIFT   12
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_WR_COMP_CTRL_RESV1_FLD_WIDTH   1
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_WR_COMP_CTRL_RESV1_FLD_MASK    0X00001000U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_ADDR_EN_FLD_SHIFT   11
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_ADDR_EN_FLD_WIDTH   1
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_ADDR_EN_FLD_MASK    0X00000800U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_BIT_INDEX_FLD_SHIFT   8
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_BIT_INDEX_FLD_WIDTH   3
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_POLLING_BIT_INDEX_FLD_MASK    0X00000700U

#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_OPCODE_FLD_SHIFT   0
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_WRITE_COMPLETION_CTRL_REG_OPCODE_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name Polling Expiration Register
 * This register contains bits for configuring
 * Number of polls cycles before expiration.
 * @{
 */
/**
 * Register: XOSPIPSV_NO_OF_POLLS_BEF_EXP_REG
 */
#define XOSPIPSV_NO_OF_POLLS_BEF_EXP_REG    0X0000003CU

#define XOSPIPSV_NO_OF_POLLS_BEF_EXP_REG_NO_OF_POLLS_BEF_EXP_FLD_SHIFT   0
#define XOSPIPSV_NO_OF_POLLS_BEF_EXP_REG_NO_OF_POLLS_BEF_EXP_FLD_WIDTH   32
#define XOSPIPSV_NO_OF_POLLS_BEF_EXP_REG_NO_OF_POLLS_BEF_EXP_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Interrupt Status Register
 * This register contains status bits and these fields
 * are set when the described event occurs and the interrupt
 * is enabled in the mask register. When any of these bit fields
 * are set, the interrupt output is asserted high. The fields
 * are each cleared by writing a 1 to the field.
 * @{
 */
/**
 * Register: XOSPIPSV_IRQ_STATUS_REG
 */
#define XOSPIPSV_IRQ_STATUS_REG    0X00000040U

#define XOSPIPSV_IRQ_STATUS_REG_IRQ_STAT_RESV_FLD_SHIFT   20
#define XOSPIPSV_IRQ_STATUS_REG_IRQ_STAT_RESV_FLD_WIDTH   12
#define XOSPIPSV_IRQ_STATUS_REG_IRQ_STAT_RESV_FLD_MASK    0XFFF00000U

#define XOSPIPSV_IRQ_STATUS_REG_ECC_FAIL_FLD_SHIFT   19
#define XOSPIPSV_IRQ_STATUS_REG_ECC_FAIL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_ECC_FAIL_FLD_MASK    0X00080000U

#define XOSPIPSV_IRQ_STATUS_REG_TX_CRC_CHUNK_BRK_FLD_SHIFT   18
#define XOSPIPSV_IRQ_STATUS_REG_TX_CRC_CHUNK_BRK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_TX_CRC_CHUNK_BRK_FLD_MASK    0X00040000U

#define XOSPIPSV_IRQ_STATUS_REG_RX_CRC_DATA_VAL_FLD_SHIFT   17
#define XOSPIPSV_IRQ_STATUS_REG_RX_CRC_DATA_VAL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_RX_CRC_DATA_VAL_FLD_MASK    0X00020000U

#define XOSPIPSV_IRQ_STATUS_REG_RX_CRC_DATA_ERR_FLD_SHIFT   16
#define XOSPIPSV_IRQ_STATUS_REG_RX_CRC_DATA_ERR_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_RX_CRC_DATA_ERR_FLD_MASK    0X00010000U

#define XOSPIPSV_IRQ_STATUS_REG_IRQ_STAT_RESV1_FLD_SHIFT   15
#define XOSPIPSV_IRQ_STATUS_REG_IRQ_STAT_RESV1_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_IRQ_STAT_RESV1_FLD_MASK    0X00008000U

#define XOSPIPSV_IRQ_STATUS_REG_STIG_REQ_INT_FLD_SHIFT   14
#define XOSPIPSV_IRQ_STATUS_REG_STIG_REQ_INT_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_STIG_REQ_INT_FLD_MASK    0X00004000U

#define XOSPIPSV_IRQ_STATUS_REG_POLL_EXP_INT_FLD_SHIFT   13
#define XOSPIPSV_IRQ_STATUS_REG_POLL_EXP_INT_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_POLL_EXP_INT_FLD_MASK    0X00002000U

#define XOSPIPSV_IRQ_STATUS_REG_INDRD_SRAM_FULL_FLD_SHIFT   12
#define XOSPIPSV_IRQ_STATUS_REG_INDRD_SRAM_FULL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_INDRD_SRAM_FULL_FLD_MASK    0X00001000U

#define XOSPIPSV_IRQ_STATUS_REG_RX_FIFO_FULL_FLD_SHIFT   11
#define XOSPIPSV_IRQ_STATUS_REG_RX_FIFO_FULL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_RX_FIFO_FULL_FLD_MASK    0X00000800U

#define XOSPIPSV_IRQ_STATUS_REG_RX_FIFO_NOT_EMPTY_FLD_SHIFT   10
#define XOSPIPSV_IRQ_STATUS_REG_RX_FIFO_NOT_EMPTY_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_RX_FIFO_NOT_EMPTY_FLD_MASK    0X00000400U

#define XOSPIPSV_IRQ_STATUS_REG_TX_FIFO_FULL_FLD_SHIFT   9
#define XOSPIPSV_IRQ_STATUS_REG_TX_FIFO_FULL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_TX_FIFO_FULL_FLD_MASK    0X00000200U

#define XOSPIPSV_IRQ_STATUS_REG_TX_FIFO_NOT_FULL_FLD_SHIFT   8
#define XOSPIPSV_IRQ_STATUS_REG_TX_FIFO_NOT_FULL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_TX_FIFO_NOT_FULL_FLD_MASK    0X00000100U

#define XOSPIPSV_IRQ_STATUS_REG_RECV_OVERFLOW_FLD_SHIFT   7
#define XOSPIPSV_IRQ_STATUS_REG_RECV_OVERFLOW_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_RECV_OVERFLOW_FLD_MASK    0X00000080U

#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_XFER_LEVEL_BREACH_FLD_SHIFT   6
#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_XFER_LEVEL_BREACH_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_XFER_LEVEL_BREACH_FLD_MASK    0X00000040U

#define XOSPIPSV_IRQ_STATUS_REG_ILLEGAL_ACCESS_DET_FLD_SHIFT   5
#define XOSPIPSV_IRQ_STATUS_REG_ILLEGAL_ACCESS_DET_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_ILLEGAL_ACCESS_DET_FLD_MASK    0X00000020U

#define XOSPIPSV_IRQ_STATUS_REG_PROT_WR_ATTEMPT_FLD_SHIFT   4
#define XOSPIPSV_IRQ_STATUS_REG_PROT_WR_ATTEMPT_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_PROT_WR_ATTEMPT_FLD_MASK    0X00000010U

#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_TRANSFER_REJECT_FLD_SHIFT   3
#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_TRANSFER_REJECT_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_TRANSFER_REJECT_FLD_MASK    0X00000008U

#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_OP_DONE_FLD_SHIFT   2
#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_OP_DONE_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_INDIRECT_OP_DONE_FLD_MASK    0X00000004U

#define XOSPIPSV_IRQ_STATUS_REG_UNDERFLOW_DET_FLD_SHIFT   1
#define XOSPIPSV_IRQ_STATUS_REG_UNDERFLOW_DET_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_UNDERFLOW_DET_FLD_MASK    0X00000002U

#define XOSPIPSV_IRQ_STATUS_REG_MODE_M_FAIL_FLD_SHIFT   0
#define XOSPIPSV_IRQ_STATUS_REG_MODE_M_FAIL_FLD_WIDTH   1
#define XOSPIPSV_IRQ_STATUS_REG_MODE_M_FAIL_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Interrupt Mask Register
 * This register contains mask bits for all the interrupts.
 * 0 : Interrupt for the corresponding interrupt status
 * register bit is disabled.
 * 1 : Interrupt for the corresponding interrupt status
 * register bit is enabled.
 * @{
 */
/**
 * Register: XOSPIPSV_IRQ_MASK_REG
 */
#define XOSPIPSV_IRQ_MASK_REG    0X00000044U

#define XOSPIPSV_IRQ_MASK_REG_IRQ_MASK_RESV_FLD_SHIFT   20
#define XOSPIPSV_IRQ_MASK_REG_IRQ_MASK_RESV_FLD_WIDTH   12
#define XOSPIPSV_IRQ_MASK_REG_IRQ_MASK_RESV_FLD_MASK    0XFFF00000U

#define XOSPIPSV_IRQ_MASK_REG_TX_CRC_CHUNK_BRK_MASK_FLD_SHIFT   18
#define XOSPIPSV_IRQ_MASK_REG_TX_CRC_CHUNK_BRK_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_TX_CRC_CHUNK_BRK_MASK_FLD_MASK    0X00040000U

#define XOSPIPSV_IRQ_MASK_REG_RX_CRC_DATA_VAL_MASK_FLD_SHIFT   17
#define XOSPIPSV_IRQ_MASK_REG_RX_CRC_DATA_VAL_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_RX_CRC_DATA_VAL_MASK_FLD_MASK    0X00020000U

#define XOSPIPSV_IRQ_MASK_REG_RX_CRC_DATA_ERR_MASK_FLD_SHIFT   16
#define XOSPIPSV_IRQ_MASK_REG_RX_CRC_DATA_ERR_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_RX_CRC_DATA_ERR_MASK_FLD_MASK    0X00010000U

#define XOSPIPSV_IRQ_MASK_REG_IRQ_MASK_RESV1_FLD_SHIFT   15
#define XOSPIPSV_IRQ_MASK_REG_IRQ_MASK_RESV1_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_IRQ_MASK_RESV1_FLD_MASK    0X00008000U

#define XOSPIPSV_IRQ_MASK_REG_STIG_REQ_MASK_FLD_SHIFT   14
#define XOSPIPSV_IRQ_MASK_REG_STIG_REQ_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_STIG_REQ_MASK_FLD_MASK    0X00004000U

#define XOSPIPSV_IRQ_MASK_REG_POLL_EXP_INT_MASK_FLD_SHIFT   13
#define XOSPIPSV_IRQ_MASK_REG_POLL_EXP_INT_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_POLL_EXP_INT_MASK_FLD_MASK    0X00002000U

#define XOSPIPSV_IRQ_MASK_REG_INDRD_SRAM_FULL_MASK_FLD_SHIFT   12
#define XOSPIPSV_IRQ_MASK_REG_INDRD_SRAM_FULL_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_INDRD_SRAM_FULL_MASK_FLD_MASK    0X00001000U

#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_XFER_LEVEL_BREACH_MASK_FLD_SHIFT   6
#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_XFER_LEVEL_BREACH_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_XFER_LEVEL_BREACH_MASK_FLD_MASK    0X00000040U

#define XOSPIPSV_IRQ_MASK_REG_ILLEGAL_ACCESS_DET_MASK_FLD_SHIFT   5
#define XOSPIPSV_IRQ_MASK_REG_ILLEGAL_ACCESS_DET_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_ILLEGAL_ACCESS_DET_MASK_FLD_MASK    0X00000020U

#define XOSPIPSV_IRQ_MASK_REG_PROT_WR_ATTEMPT_MASK_FLD_SHIFT   4
#define XOSPIPSV_IRQ_MASK_REG_PROT_WR_ATTEMPT_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_PROT_WR_ATTEMPT_MASK_FLD_MASK    0X00000010U

#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_TRANSFER_REJECT_MASK_FLD_SHIFT   3
#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_TRANSFER_REJECT_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_TRANSFER_REJECT_MASK_FLD_MASK    0X00000008U

#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_OP_DONE_MASK_FLD_SHIFT   2
#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_OP_DONE_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_INDIRECT_OP_DONE_MASK_FLD_MASK    0X00000004U

#define XOSPIPSV_IRQ_MASK_REG_UNDERFLOW_DET_MASK_FLD_SHIFT   1
#define XOSPIPSV_IRQ_MASK_REG_UNDERFLOW_DET_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_UNDERFLOW_DET_MASK_FLD_MASK    0X00000002U

#define XOSPIPSV_IRQ_MASK_REG_MODE_M_FAIL_MASK_FLD_SHIFT   0
#define XOSPIPSV_IRQ_MASK_REG_MODE_M_FAIL_MASK_FLD_WIDTH   1
#define XOSPIPSV_IRQ_MASK_REG_MODE_M_FAIL_MASK_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Tap Granularity select
 * This register contains bits for configuring tap
 * delay granularity.
 * @{
 */
/**
 * Register: XOSPIPSV_ECO_REG
 */
#define XOSPIPSV_ECO_REG		0X00000048U

#define XOSPIPSV_ECO_REG_FIELD_SHIFT   0
#define XOSPIPSV_ECO_REG_FIELD_WIDTH   1
#define XOSPIPSV_ECO_REG_FIELD_MASK    0X00000001U
/** @} */

/**
 * @name Lower Write Protection Register
 * This register contains bits for configuring block
 * number that defines the lower block in the range of
 * blocks that is to be locked from writing. The definition
 * of a block in terms of number of bytes is programmable
 * via the Device Size Configuration register.
 * @{
 */
/**
 * Register: XOSPIPSV_LOWER_WR_PROT_REG
 */
#define XOSPIPSV_LOWER_WR_PROT_REG    0X00000050U

#define XOSPIPSV_LOWER_WR_PROT_REG_SUBSECTOR_FLD_SHIFT   0
#define XOSPIPSV_LOWER_WR_PROT_REG_SUBSECTOR_FLD_WIDTH   32
#define XOSPIPSV_LOWER_WR_PROT_REG_SUBSECTOR_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Upper Write Protection Register
 * This register contains bits for configuring block
 * number that defines the upper block in the range of
 * blocks that is to be locked from writing. The definition
 * of a block in terms of number of bytes is programmable
 * via the Device Size Configuration register.
 * @{
 */
/**
 * Register: XOSPIPSV_UPPER_WR_PROT_REG
 */
#define XOSPIPSV_UPPER_WR_PROT_REG    0X00000054U

#define XOSPIPSV_UPPER_WR_PROT_REG_SUBSECTOR_FLD_SHIFT   0
#define XOSPIPSV_UPPER_WR_PROT_REG_SUBSECTOR_FLD_WIDTH   32
#define XOSPIPSV_UPPER_WR_PROT_REG_SUBSECTOR_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Write Protection Control Register
 * This register contains bits for configuring
 * Write Protection Inversion and Write Protection Enable.
 * @{
 */
/**
 * Register: XOSPIPSV_WR_PROT_CTRL_REG
 */
#define XOSPIPSV_WR_PROT_CTRL_REG   0X00000058U

#define XOSPIPSV_WR_PROT_CTRL_REG_WR_PROT_CTRL_RESV_FLD_SHIFT   2
#define XOSPIPSV_WR_PROT_CTRL_REG_WR_PROT_CTRL_RESV_FLD_WIDTH   30
#define XOSPIPSV_WR_PROT_CTRL_REG_WR_PROT_CTRL_RESV_FLD_MASK    0XFFFFFFFCU

#define XOSPIPSV_WR_PROT_CTRL_REG_ENB_FLD_SHIFT   1
#define XOSPIPSV_WR_PROT_CTRL_REG_ENB_FLD_WIDTH   1
#define XOSPIPSV_WR_PROT_CTRL_REG_ENB_FLD_MASK    0X00000002U

#define XOSPIPSV_WR_PROT_CTRL_REG_INV_FLD_SHIFT   0
#define XOSPIPSV_WR_PROT_CTRL_REG_INV_FLD_WIDTH   1
#define XOSPIPSV_WR_PROT_CTRL_REG_INV_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Indirect Read Transfer Control Register
 * This register contains bits for configuring
 * Start Indirect Read, Cancel Indirect Read, Indirect Read
 * Status, Completion status, number of Indirect operations done etc.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG
 */
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG    0X00000060U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_INDIR_RD_XFER_RESV_FLD_SHIFT   8
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_INDIR_RD_XFER_RESV_FLD_WIDTH   24
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_INDIR_RD_XFER_RESV_FLD_MASK    0XFFFFFF00U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_NUM_IND_OPS_DONE_FLD_SHIFT   6
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_NUM_IND_OPS_DONE_FLD_WIDTH   2
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_NUM_IND_OPS_DONE_FLD_MASK    0X000000C0U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_IND_OPS_DONE_STATUS_FLD_SHIFT   5
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_IND_OPS_DONE_STATUS_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_IND_OPS_DONE_STATUS_FLD_MASK    0X00000020U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_RD_QUEUED_FLD_SHIFT   4
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_RD_QUEUED_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_RD_QUEUED_FLD_MASK    0X00000010U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_SRAM_FULL_FLD_SHIFT   3
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_SRAM_FULL_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_SRAM_FULL_FLD_MASK    0X00000008U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_RD_STATUS_FLD_SHIFT   2
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_RD_STATUS_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_RD_STATUS_FLD_MASK    0X00000004U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_CANCEL_FLD_SHIFT   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_CANCEL_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_CANCEL_FLD_MASK    0X00000002U

#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_START_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_START_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_READ_XFER_CTRL_REG_START_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Indirect Read Transfer Watermark Register
 * This register contains bits for configuring
 * Watermark level (minimum fill level of the SRAM) for indirect
 * read operation.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_READ_XFER_WATERMARK_REG
 */
#define XOSPIPSV_INDIRECT_READ_XFER_WATERMARK_REG    0X00000064U

#define XOSPIPSV_INDIRECT_READ_XFER_WATERMARK_REG_LEVEL_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_READ_XFER_WATERMARK_REG_LEVEL_FLD_WIDTH   32
#define XOSPIPSV_INDIRECT_READ_XFER_WATERMARK_REG_LEVEL_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Indirect Read Transfer Start Address Register
 * This register contains bits for configuring
 * start address from which the indirect access will
 * commence its READ operation.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_READ_XFER_START_REG
 */
#define XOSPIPSV_INDIRECT_READ_XFER_START_REG    0X00000068U

#define XOSPIPSV_INDIRECT_READ_XFER_START_REG_ADDR_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_READ_XFER_START_REG_ADDR_FLD_WIDTH   32
#define XOSPIPSV_INDIRECT_READ_XFER_START_REG_ADDR_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Indirect Read Transfer Number Bytes Register
 * This register contains bits for configuring
 * number of bytes that the indirect access will consume.
 * This can be bigger than the configured size of SRAM.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_READ_XFER_NUM_BYTES_REG
 */
#define XOSPIPSV_INDIRECT_READ_XFER_NUM_BYTES_REG   0X0000006CU

#define XOSPIPSV_INDIRECT_READ_XFER_NUM_BYTES_REG_VALUE_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_READ_XFER_NUM_BYTES_REG_VALUE_FLD_WIDTH   32
#define XOSPIPSV_INDIRECT_READ_XFER_NUM_BYTES_REG_VALUE_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Indirect Write Transfer Control Register
 * This register contains bits for configuring
 * Start Indirect Write, Cancel Indirect Write, Indirect Write
 * Status, Completion status, number of Indirect operations done etc.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG
 */
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG    0X00000070U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_INDIR_WR_XFER_RESV2_FLD_SHIFT   8
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_INDIR_WR_XFER_RESV2_FLD_WIDTH   24
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_INDIR_WR_XFER_RESV2_FLD_MASK    0XFFFFFF00U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_NUM_IND_OPS_DONE_FLD_SHIFT   6
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_NUM_IND_OPS_DONE_FLD_WIDTH   2
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_NUM_IND_OPS_DONE_FLD_MASK    0X000000C0U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_IND_OPS_DONE_STATUS_FLD_SHIFT   5
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_IND_OPS_DONE_STATUS_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_IND_OPS_DONE_STATUS_FLD_MASK    0X00000020U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_WR_QUEUED_FLD_SHIFT   4
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_WR_QUEUED_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_WR_QUEUED_FLD_MASK    0X00000010U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_INDIR_WR_XFER_RESV1_FLD_SHIFT   3
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_INDIR_WR_XFER_RESV1_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_INDIR_WR_XFER_RESV1_FLD_MASK    0X00000008

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_WR_STATUS_FLD_SHIFT   2
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_WR_STATUS_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_WR_STATUS_FLD_MASK    0X00000004U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_CANCEL_FLD_SHIFT   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_CANCEL_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_CANCEL_FLD_MASK    0X00000002U

#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_START_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_START_FLD_WIDTH   1
#define XOSPIPSV_INDIRECT_WRITE_XFER_CTRL_REG_START_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Indirect Write Transfer Watermark Register
 * This register contains bits for configuring
 * Watermark level (maximum fill level of the SRAM) for indirect
 * write operation.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_WRITE_XFER_WATERMARK_REG
 */
#define XOSPIPSV_INDIRECT_WRITE_XFER_WATERMARK_REG    0X00000074U

#define XOSPIPSV_INDIRECT_WRITE_XFER_WATERMARK_REG_LEVEL_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_WRITE_XFER_WATERMARK_REG_LEVEL_FLD_WIDTH   32
#define XOSPIPSV_INDIRECT_WRITE_XFER_WATERMARK_REG_LEVEL_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Indirect Write Transfer Start Address Register
 * This register contains bits for configuring
 * start address from which the indirect access will
 * commence its WRITE operation.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_WRITE_XFER_START_REG
 */
#define XOSPIPSV_INDIRECT_WRITE_XFER_START_REG    0X00000078U

#define XOSPIPSV_INDIRECT_WRITE_XFER_START_REG_ADDR_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_WRITE_XFER_START_REG_ADDR_FLD_WIDTH   32
#define XOSPIPSV_INDIRECT_WRITE_XFER_START_REG_ADDR_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Indirect Write Transfer Number Bytes Register
 * This register contains bits for configuring
 * number of bytes that the indirect access will consume.
 * This can be bigger than the configured size of SRAM.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_WRITE_XFER_NUM_BYTES_REG
 */
#define XOSPIPSV_INDIRECT_WRITE_XFER_NUM_BYTES_REG    0X0000007CU

#define XOSPIPSV_INDIRECT_WRITE_XFER_NUM_BYTES_REG_VALUE_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_WRITE_XFER_NUM_BYTES_REG_VALUE_FLD_WIDTH   32
#define XOSPIPSV_INDIRECT_WRITE_XFER_NUM_BYTES_REG_VALUE_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Indirect Trigger Address Range Register
 * This register contains bits for configuring
 * address offset of Indirect Trigger Address Register.
 * @{
 */
/**
 * Register: XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG
 */
#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG    0X00000080U

#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG_IND_RANGE_RESV1_FLD_SHIFT   4
#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG_IND_RANGE_RESV1_FLD_WIDTH   28
#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG_IND_RANGE_RESV1_FLD_MASK    0XFFFFFFF0U

#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG_IND_RANGE_WIDTH_FLD_SHIFT   0
#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG_IND_RANGE_WIDTH_FLD_WIDTH   4
#define XOSPIPSV_INDIRECT_TRIGGER_ADDR_RANGE_REG_IND_RANGE_WIDTH_FLD_MASK    0X0000000FU
/** @} */

/**
 * @name Flash Command Control Memory Register
 * This register contains bits for configuring
 * Start the Memory Bank data request, Memory Bank address field etc.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG
 */
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG    0X0000008CU

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV1_FLD_SHIFT   29
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV1_FLD_WIDTH   3
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV1_FLD_MASK    0XE0000000U

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_MEM_BANK_ADDR_FLD_SHIFT   20
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_MEM_BANK_ADDR_FLD_WIDTH   9
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_MEM_BANK_ADDR_FLD_MASK    0X1FF00000U

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV2_FLD_SHIFT   19
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV2_FLD_WIDTH   1
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV2_FLD_MASK    0X00080000U

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_NB_OF_STIG_READ_BYTES_FLD_SHIFT   16
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_NB_OF_STIG_READ_BYTES_FLD_WIDTH   3
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_NB_OF_STIG_READ_BYTES_FLD_MASK    0X00070000U

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_MEM_BANK_READ_DATA_FLD_SHIFT   8
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_MEM_BANK_READ_DATA_FLD_WIDTH   8
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_MEM_BANK_READ_DATA_FLD_MASK    0X0000FF00U

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV3_FLD_SHIFT   2
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV3_FLD_WIDTH   6
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_RESV3_FLD_MASK    0X000000FCU

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_BANK_REQ_IN_PROGRESS_FLD_SHIFT   1
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_BANK_REQ_IN_PROGRESS_FLD_WIDTH   1
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_BANK_REQ_IN_PROGRESS_FLD_MASK    0X00000002U

#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_TRIGGER_MEM_BANK_REQ_FLD_SHIFT   0
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_TRIGGER_MEM_BANK_REQ_FLD_WIDTH   1
#define XOSPIPSV_FLASH_COMMAND_CTRL_MEM_REG_TRIGGER_MEM_BANK_REQ_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Flash Command Control Register
 * This register contains bits for configuring
 * STIG Memory Bank, Dummy cycles, Write data bytes, Write data enable,
 * Address bytes, Read data bytes, Read data enable, Opcode etc.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_CMD_CTRL_REG
 */
#define XOSPIPSV_FLASH_CMD_CTRL_REG    0X00000090U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_OPCODE_FLD_SHIFT   24
#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_OPCODE_FLD_MASK    0XFF000000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_READ_DATA_FLD_SHIFT   23
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_READ_DATA_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_READ_DATA_FLD_MASK    0X00800000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_RD_DATA_BYTES_FLD_SHIFT   20
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_RD_DATA_BYTES_FLD_WIDTH   3
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_RD_DATA_BYTES_FLD_MASK    0X00700000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_COMD_ADDR_FLD_SHIFT   19
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_COMD_ADDR_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_COMD_ADDR_FLD_MASK    0X00080000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_MODE_BIT_FLD_SHIFT   18
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_MODE_BIT_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_MODE_BIT_FLD_MASK    0X00040000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_ADDR_BYTES_FLD_SHIFT   16
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_ADDR_BYTES_FLD_WIDTH   2
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_ADDR_BYTES_FLD_MASK    0X00030000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_WRITE_DATA_FLD_SHIFT   15
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_WRITE_DATA_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_ENB_WRITE_DATA_FLD_MASK    0X00008000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_WR_DATA_BYTES_FLD_SHIFT   12
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_WR_DATA_BYTES_FLD_WIDTH   3
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_WR_DATA_BYTES_FLD_MASK    0X00007000U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_DUMMY_CYCLES_FLD_SHIFT   7
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_DUMMY_CYCLES_FLD_WIDTH   5
#define XOSPIPSV_FLASH_CMD_CTRL_REG_NUM_DUMMY_CYCLES_FLD_MASK    0X00000F80U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_FLASH_CMD_CTRL_RESV1_FLD_SHIFT   3
#define XOSPIPSV_FLASH_CMD_CTRL_REG_FLASH_CMD_CTRL_RESV1_FLD_WIDTH   4
#define XOSPIPSV_FLASH_CMD_CTRL_REG_FLASH_CMD_CTRL_RESV1_FLD_MASK    0X00000078U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_STIG_MEM_BANK_EN_FLD_SHIFT   2
#define XOSPIPSV_FLASH_CMD_CTRL_REG_STIG_MEM_BANK_EN_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_STIG_MEM_BANK_EN_FLD_MASK    0X00000004U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_EXEC_STATUS_FLD_SHIFT   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_EXEC_STATUS_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_EXEC_STATUS_FLD_MASK    0X00000002U

#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_EXEC_FLD_SHIFT   0
#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_EXEC_FLD_WIDTH   1
#define XOSPIPSV_FLASH_CMD_CTRL_REG_CMD_EXEC_FLD_MASK    0X00000001U
/** @} */

/**
 * @name Flash Command Address Register
 * This register contains bits for configuring
 * Command Address.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_CMD_ADDR_REG
 */
#define XOSPIPSV_FLASH_CMD_ADDR_REG    0X00000094U

#define XOSPIPSV_FLASH_CMD_ADDR_REG_ADDR_FLD_SHIFT   0
#define XOSPIPSV_FLASH_CMD_ADDR_REG_ADDR_FLD_WIDTH   32
#define XOSPIPSV_FLASH_CMD_ADDR_REG_ADDR_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Flash Command Read Data Register (Lower)
 * This register contains data that is returned by
 * the flash device for any status or configuration read operation
 * carried out by triggering the event in the control register.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_RD_DATA_LOWER_REG
 */
#define XOSPIPSV_FLASH_RD_DATA_LOWER_REG    0X000000A0U

#define XOSPIPSV_FLASH_RD_DATA_LOWER_REG_DATA_FLD_SHIFT   0
#define XOSPIPSV_FLASH_RD_DATA_LOWER_REG_DATA_FLD_WIDTH   32
#define XOSPIPSV_FLASH_RD_DATA_LOWER_REG_DATA_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Flash Command Read Data Register (Upper)
 * This register contains data that is returned by
 * the flash device for any status or configuration read operation
 * carried out by triggering the event in the control register.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_RD_DATA_UPPER_REG
 */
#define XOSPIPSV_FLASH_RD_DATA_UPPER_REG    0X000000A4U

#define XOSPIPSV_FLASH_RD_DATA_UPPER_REG_DATA_FLD_SHIFT   0
#define XOSPIPSV_FLASH_RD_DATA_UPPER_REG_DATA_FLD_WIDTH   32
#define XOSPIPSV_FLASH_RD_DATA_UPPER_REG_DATA_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Flash Command Write Data Register (Lower)
 * This register contains Command Write Data Lower Byte.
 * This should be setup before triggering the command with execute
 * field (bit 0) of the Flash Command Control register.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_WR_DATA_LOWER_REG
 */
#define XOSPIPSV_FLASH_WR_DATA_LOWER_REG    0X000000A8U

#define XOSPIPSV_FLASH_WR_DATA_LOWER_REG_DATA_FLD_SHIFT   0
#define XOSPIPSV_FLASH_WR_DATA_LOWER_REG_DATA_FLD_WIDTH   32
#define XOSPIPSV_FLASH_WR_DATA_LOWER_REG_DATA_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Flash Command Write Data Register (Upper)
 * This register contains Command Write Data Upper Byte.
 * This should be setup before triggering the command with execute
 * field (bit 0) of the Flash Command Control register.
 * @{
 */
/**
 * Register: XOSPIPSV_FLASH_WR_DATA_UPPER_REG
 */
#define XOSPIPSV_FLASH_WR_DATA_UPPER_REG    0X000000ACU

#define XOSPIPSV_FLASH_WR_DATA_UPPER_REG_DATA_FLD_SHIFT   0
#define XOSPIPSV_FLASH_WR_DATA_UPPER_REG_DATA_FLD_WIDTH   32
#define XOSPIPSV_FLASH_WR_DATA_UPPER_REG_DATA_FLD_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Polling Flash Status Register
 * This register contains bits for configuring
 * Number of dummy cycles for auto-polling and contains
 * Device Status information.
 * @{
 */
/**
 * Register: XOSPIPSV_POLLING_FLASH_STATUS_REG
 */
#define XOSPIPSV_POLLING_FLASH_STATUS_REG    0X000000B0U

#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_RSVD_FLD2_SHIFT   21
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_RSVD_FLD2_WIDTH   11
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_RSVD_FLD2_MASK    0XFFE00000U

#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_NB_DUMMY_SHIFT   16
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_NB_DUMMY_WIDTH   5
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_NB_DUMMY_MASK    0X001F0000U

#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_RSVD_FLD1_SHIFT   9
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_RSVD_FLD1_WIDTH   7
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_RSVD_FLD1_MASK    0X0000FE00U

#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_VALID_FLD_SHIFT   8
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_VALID_FLD_WIDTH   1
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_VALID_FLD_MASK    0X00000100U

#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_FLD_SHIFT   0
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_FLD_WIDTH   8
#define XOSPIPSV_POLLING_FLASH_STATUS_REG_DEVICE_STATUS_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name PHY Configuration Register
 * This register contains bits for configuring
 * RX DLL Delay, TX DLL Delay and DLL Bypass field.
 * @{
 */
/**
 * Register: XOSPIPSV_PHY_CONFIGURATION_REG
 */
#define XOSPIPSV_PHY_CONFIGURATION_REG    0X000000B4U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESYNC_FLD_SHIFT   31
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESYNC_FLD_WIDTH   1
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESYNC_FLD_MASK    0X80000000U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESET_FLD_SHIFT   30
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESET_FLD_WIDTH   1
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESET_FLD_MASK    0X40000000U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RX_DLL_BYPASS_FLD_SHIFT   29
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RX_DLL_BYPASS_FLD_WIDTH   1
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RX_DLL_BYPASS_FLD_MASK    0X20000000U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESV2_FLD_SHIFT   23
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESV2_FLD_WIDTH   6
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESV2_FLD_MASK    0X1F800000U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_TX_DLL_DELAY_FLD_SHIFT   16
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_TX_DLL_DELAY_FLD_WIDTH   7
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_TX_DLL_DELAY_FLD_MASK    0X007F0000U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESV1_FLD_SHIFT   7
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESV1_FLD_WIDTH   9
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RESV1_FLD_MASK    0X0000FF80U

#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RX_DLL_DELAY_FLD_SHIFT   0
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RX_DLL_DELAY_FLD_WIDTH   7
#define XOSPIPSV_PHY_CONFIGURATION_REG_PHY_CONFIG_RX_DLL_DELAY_FLD_MASK    0X0000007FU
/** @} */

/**
 * @name PHY DLL Master Control Register
 * This register contains bits for configuring
 * Master initial delay, Number of consecutive increment or
 * decrement indications, Master phase detect selector,
 * Master lock mode, Master bypass mode.
 * @{
 */
/**
 * Register: XOSPIPSV_PHY_MASTER_CONTROL_REG
 */
#define XOSPIPSV_PHY_MASTER_CONTROL_REG    0X000000B8U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV3_FLD_SHIFT   25
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV3_FLD_WIDTH   7
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV3_FLD_MASK    0XFE000000U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_LOCK_MODE_FLD_SHIFT   24
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_LOCK_MODE_FLD_WIDTH   1
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_LOCK_MODE_FLD_MASK    0X01000000U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_BYPASS_MODE_FLD_SHIFT   23
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_BYPASS_MODE_FLD_WIDTH   1
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_BYPASS_MODE_FLD_MASK    0X00800000U

#define XOSPIPSV_PHY_MASTER_PHASE_DETECT_SELECTOR_FLD_SHIFT   20
#define XOSPIPSV_PHY_MASTER_PHASE_DETECT_SELECTOR_FLD_WIDTH   3
#define XOSPIPSV_PHY_MASTER_PHASE_DETECT_SELECTOR_FLD_MASK    0X00700000U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV2_FLD_SHIFT   19
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV2_FLD_WIDTH   1
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV2_FLD_MASK    0X00080000U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_NB_INDICATIONS_FLD_SHIFT   16
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_NB_INDICATIONS_FLD_WIDTH   3
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_NB_INDICATIONS_FLD_MASK    0X00070000U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV1_FLD_SHIFT   7
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV1_FLD_WIDTH   9
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_CONTROL_RESV1_FLD_MASK    0X0000FF80U

#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_INITIAL_DELAY_FLD_SHIFT   0
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_INITIAL_DELAY_FLD_WIDTH   7
#define XOSPIPSV_PHY_MASTER_CONTROL_REG_PHY_MASTER_INITIAL_DELAY_FLD_MASK    0X0000007FU
/** @} */

/**
 * @name DLL Observable Register Lower
 * This register contains information about Lower DLL lock,
 * Lock mode, Unlock counter, Lock value etc.
 * @{
 */
/**
 * Register: XOSPIPSV_DLL_OBSERVABLE_LOWER_REG
 */
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_REG    0X000000BCU

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_INC_FLD_SHIFT   24
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_INC_FLD_WIDTH   8
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_INC_FLD_MASK    0XFF000000U

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_DEC_FLD_SHIFT   16
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_DEC_FLD_WIDTH   8
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_DEC_FLD_MASK    0X00FF0000U

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOOPBACK_LOCK_FLD_SHIFT   15
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOOPBACK_LOCK_FLD_WIDTH   1
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOOPBACK_LOCK_FLD_MASK    0X00008000U

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOCK_VALUE_FLD_SHIFT   8
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOCK_VALUE_FLD_WIDTH   7
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOCK_VALUE_FLD_MASK    0X00007F00U

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_UNLOCK_COUNTER_FLD_SHIFT   3
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_UNLOCK_COUNTER_FLD_WIDTH   5
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_UNLOCK_COUNTER_FLD_MASK    0X000000F8U

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOCK_MODE_FLD_SHIFT   1
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOCK_MODE_FLD_WIDTH   2
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_LOCK_MODE_FLD_MASK    0X00000006U

#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_FLD_SHIFT   0
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_FLD_WIDTH   1
#define XOSPIPSV_DLL_OBSERVABLE_LOWER_DLL_LOCK_FLD_MASK    0X00000001U
/** @} */

/**
 * @name DLL Observable Register Upper
 * This register contains information about RX decoder
 * output, TX decoder output.
 * @{
 */
/**
 * Register: XOSPIPSV_DLL_OBSERVABLE_UPPER_REG
 */
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_REG    0X000000C0U

#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RESV2_FLD_SHIFT   23
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RESV2_FLD_WIDTH   9
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RESV2_FLD_MASK    0XFF800000U

#define XOSPIPSV_DLL_OBSERVABLE_UPPER_TX_DECODER_OUTPUT_FLD_SHIFT   16
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_TX_DECODER_OUTPUT_FLD_WIDTH   7
#define XOSPIPSV_DLL_DLL_OBSERVABLE_UPPER_TX_DECODER_OUTPUT_FLD_MASK    0X007F0000U

#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RESV1_FLD_SHIFT   7
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RESV1_FLD_WIDTH   9
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RESV1_FLD_MASK    0X0000FF80U

#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RX_DECODER_OUTPUT_FLD_SHIFT   0
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RX_DECODER_OUTPUT_FLD_WIDTH   7
#define XOSPIPSV_DLL_OBSERVABLE_UPPER_RX_DECODER_OUTPUT_FLD_MASK    0X0000007FU
/** @} */

/**
 * @name Opcode Extension Register (Lower)
 * This register contains bits for configuring
 * Dual byte opcode for stig, poll, read and write operations.
 * @{
 */
/**
 * Register: XOSPIPSV_OPCODE_EXT_LOWER_REG
 */
#define XOSPIPSV_OPCODE_EXT_LOWER_REG    0X000000E0U

#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_READ_OPCODE_FLD_SHIFT   24
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_READ_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_READ_OPCODE_FLD_MASK    0XFF000000U

#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_WRITE_OPCODE_FLD_SHIFT   16
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_WRITE_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_WRITE_OPCODE_FLD_MASK    0X00FF0000U

#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_POLL_OPCODE_FLD_SHIFT   8
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_POLL_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_POLL_OPCODE_FLD_MASK    0X0000FF00U

#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_STIG_OPCODE_FLD_SHIFT   0
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_STIG_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_OPCODE_EXT_LOWER_REG_EXT_STIG_OPCODE_FLD_MASK    0X000000FFU
/** @} */

/**
 * @name Opcode Extension Register (Upper)
 * This register contains bits for configuring
 * first byte of WEL opcode and Supplement byte of WEL opcode.
 * @{
 */
/**
 * Register: XOSPIPSV_OPCODE_EXT_UPPER_REG
 */
#define XOSPIPSV_OPCODE_EXT_UPPER_REG    0X000000E4U

#define XOSPIPSV_OPCODE_EXT_UPPER_REG_WEL_OPCODE_FLD_SHIFT   24
#define XOSPIPSV_OPCODE_EXT_UPPER_REG_WEL_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_OPCODE_EXT_UPPER_REG_WEL_OPCODE_FLD_MASK    0XFF000000U

#define XOSPIPSV_OPCODE_EXT_UPPER_REG_EXT_WEL_OPCODE_FLD_SHIFT   16
#define XOSPIPSV_OPCODE_EXT_UPPER_REG_EXT_WEL_OPCODE_FLD_WIDTH   8
#define XOSPIPSV_OPCODE_EXT_UPPER_REG_EXT_WEL_OPCODE_FLD_MASK    0X00FF0000U

#define XOSPIPSV_OPCODE_EXT_UPPER_REG_OPCODE_EXT_UPPER_RESV1_FLD_SHIFT   0
#define XOSPIPSV_OPCODE_EXT_UPPER_REG_OPCODE_EXT_UPPER_RESV1_FLD_WIDTH   16
#define XOSPIPSV_OPCODE_EXT_UPPER_REG_OPCODE_EXT_UPPER_RESV1_FLD_MASK    0X0000FFFFU
/** @} */

/**
 * @name Module ID Register
 * This register contains information about Configuration
 * ID number, Module/Revision ID number and Fix/patch number.
 * @{
 */
/**
 * Register: XOSPIPSV_MODULE_ID_REG
 */
#define XOSPIPSV_MODULE_ID_REG    0X000000FCU

#define XOSPIPSV_MODULE_ID_REG_FIX_PATCH_FLD_SHIFT   24
#define XOSPIPSV_MODULE_ID_REG_FIX_PATCH_FLD_WIDTH   8
#define XOSPIPSV_MODULE_ID_REG_FIX_PATCH_FLD_MASK    0XFF000000U

#define XOSPIPSV_MODULE_ID_REG_MODULE_ID_FLD_SHIFT   8
#define XOSPIPSV_MODULE_ID_REG_MODULE_ID_FLD_WIDTH   16
#define XOSPIPSV_MODULE_ID_REG_MODULE_ID_FLD_MASK    0X00FFFF00U

#define XOSPIPSV_MODULE_ID_REG_MODULE_ID_RESV_FLD_SHIFT   2
#define XOSPIPSV_MODULE_ID_REG_MODULE_ID_RESV_FLD_WIDTH   6
#define XOSPIPSV_MODULE_ID_REG_MODULE_ID_RESV_FLD_MASK    0X000000FCU

#define XOSPIPSV_MODULE_ID_REG_CONF_FLD_SHIFT   0
#define XOSPIPSV_MODULE_ID_REG_CONF_FLD_WIDTH   2
#define XOSPIPSV_MODULE_ID_REG_CONF_FLD_MASK    0X00000003U
/** @} */

/**
 * @name Source mem address (lsbs) for DMA memory->stream data transfer
 * This register contains bits for configuring
 * Read address for the AXI read from Cadence OSPI SRAM.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_RD_ADDR
 */
#define XOSPIPSV_OSPIDMA_SRC_RD_ADDR    0X00001000U

#define XOSPIPSV_OSPIDMA_SRC_RD_ADDR_ADDR_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_RD_ADDR_ADDR_WIDTH   32
#define XOSPIPSV_OSPIDMA_SRC_RD_ADDR_ADDR_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Source mem size for DMA memory->stream data transfer
 * This register contains bits for configuring
 * Read size for the AXI read from Cadence OSPI SRAM.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_SIZE
 */
#define XOSPIPSV_OSPIDMA_SRC_SIZE    0X00001004U

#define XOSPIPSV_OSPIDMA_SRC_SIZE_SIZE_SHIFT   2
#define XOSPIPSV_OSPIDMA_SRC_SIZE_SIZE_WIDTH   27
#define XOSPIPSV_OSPIDMA_SRC_SIZE_SIZE_MASK    0X1FFFFFFCU
/** @} */

/**
 * @name General SRC DMA Status
 * This register contains Status information like
 * Busy, Number of outstanding transactions, Number of
 * completed transactions etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_STS
 */
#define XOSPIPSV_OSPIDMA_SRC_STS   0X00001008U

#define XOSPIPSV_OSPIDMA_SRC_STS_DONE_CNT_SHIFT   13
#define XOSPIPSV_OSPIDMA_SRC_STS_DONE_CNT_WIDTH   3
#define XOSPIPSV_OSPIDMA_SRC_STS_DONE_CNT_MASK    0X0000E000U

#define XOSPIPSV_OSPIDMA_SRC_STS_SRC_FIFO_LEVEL_SHIFT   5
#define XOSPIPSV_OSPIDMA_SRC_STS_SRC_FIFO_LEVEL_WIDTH   8
#define XOSPIPSV_OSPIDMA_SRC_STS_SRC_FIFO_LEVEL_MASK    0X00001FE0U

#define XOSPIPSV_OSPIDMA_SRC_STS_RD_OUTSTANDING_SHIFT   1
#define XOSPIPSV_OSPIDMA_SRC_STS_RD_OUTSTANDING_WIDTH   4
#define XOSPIPSV_OSPIDMA_SRC_STS_RD_OUTSTANDING_MASK    0X0000001EU

#define XOSPIPSV_OSPIDMA_SRC_STS_BUSY_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_STS_BUSY_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_STS_BUSY_MASK    0X00000001U
/** @} */

/**
 * @name General SRC DMA Control Register 1
 * This register contains bits for configuring
 * Pause MEM, Pause STRM, FIFO Threshold, Timeout value,
 * Endianness, APB error response.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_CTRL
 */
#define XOSPIPSV_OSPIDMA_SRC_CTRL    0X0000100CU

#define XOSPIPSV_OSPIDMA_SRC_CTRL_APB_ERR_RESP_SHIFT   24
#define XOSPIPSV_OSPIDMA_SRC_CTRL_APB_ERR_RESP_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL_APB_ERR_RESP_MASK    0X01000000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL_ENDIANNESS_SHIFT   23
#define XOSPIPSV_OSPIDMA_SRC_CTRL_ENDIANNESS_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL_ENDIANNESS_MASK    0X00800000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL_AXI_BRST_TYPE_SHIFT   22
#define XOSPIPSV_OSPIDMA_SRC_CTRL_AXI_BRST_TYPE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL_AXI_BRST_TYPE_MASK    0X00400000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL_TIMEOUT_VAL_SHIFT   10
#define XOSPIPSV_OSPIDMA_SRC_CTRL_TIMEOUT_VAL_WIDTH   12
#define XOSPIPSV_OSPIDMA_SRC_CTRL_TIMEOUT_VAL_MASK    0X003FFC00U

#define XOSPIPSV_OSPIDMA_SRC_CTRL_FIFO_THRESH_SHIFT   2
#define XOSPIPSV_OSPIDMA_SRC_CTRL_FIFO_THRESH_WIDTH   8
#define XOSPIPSV_OSPIDMA_SRC_CTRL_FIFO_THRESH_MASK    0X000003FCU

#define XOSPIPSV_OSPIDMA_SRC_CTRL_PAUSE_STRM_SHIFT   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL_PAUSE_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL_PAUSE_STRM_MASK    0X00000002U

#define XOSPIPSV_OSPIDMA_SRC_CTRL_PAUSE_MEM_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_CTRL_PAUSE_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL_PAUSE_MEM_MASK    0X00000001U
/** @} */

/**
 * @name SRC DMA Pseudo CRC
 * This register contains bits for configuring
 * Pseudo CRC (Chksum) value on all data read from AXI memory.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_CRC
 */
#define XOSPIPSV_OSPIDMA_SRC_CRC   0X00001010U

#define XOSPIPSV_OSPIDMA_SRC_CRC_CRC_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_CRC_CRC_WIDTH   32
#define XOSPIPSV_OSPIDMA_SRC_CRC_CRC_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name SRC DMA Interrupt Status Register
 * This register contains status bits for DMA interrupts
 * like DONE, MEM_DONE etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_I_STS
 */
#define XOSPIPSV_OSPIDMA_SRC_I_STS    0X00001014U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_SRC_I_STS_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_SRC_I_STS_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_SRC_I_STS_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_SRC_I_STS_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_AXI_RDERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_SRC_I_STS_AXI_RDERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_AXI_RDERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_DONE_MASK    0X00000002U

#define XOSPIPSV_OSPIDMA_SRC_I_STS_MEM_DONE_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_I_STS_MEM_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_STS_MEM_DONE_MASK    0X00000001U
/** @} */

/**
 * @name SRC DMA Interrupt Enable Register
 * This register contains bits to enable DMA interrupts
 * like DONE, MEM_DONE etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_I_EN
 */
#define XOSPIPSV_OSPIDMA_SRC_I_EN    0X00001018U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_SRC_I_EN_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_SRC_I_EN_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_SRC_I_EN_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_SRC_I_EN_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_AXI_RDERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_SRC_I_EN_AXI_RDERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_AXI_RDERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_DONE_MASK    0X00000002U

#define XOSPIPSV_OSPIDMA_SRC_I_EN_MEM_DONE_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_I_EN_MEM_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_EN_MEM_DONE_MASK    0X00000001U
/** @} */

/**
 * @name SRC DMA Interrupt Disable Register
 * This register contains bits to disable DMA interrupts
 * like DONE, MEM_DONE etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_I_DIS
 */
#define XOSPIPSV_OSPIDMA_SRC_I_DIS    0X0000101CU

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_AXI_RDERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_AXI_RDERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_AXI_RDERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_DONE_MASK    0X00000002U

#define XOSPIPSV_OSPIDMA_SRC_I_DIS_MEM_DONE_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_MEM_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_DIS_MEM_DONE_MASK    0X00000001U
/** @} */

/**
 * @name SRC DMA Interrupt Mask Register
 * This register contains information about DMA interrupts
 * like DONE, MEM_DONE etc.
 * 1 indicates mask the interrupt, do not pass it along
 * 0 indicates do not mask the interrupt, pass it along as is.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_I_MASK
 */
#define XOSPIPSV_OSPIDMA_SRC_I_MASK    0X00001020U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_AXI_RDERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_AXI_RDERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_AXI_RDERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_DONE_MASK    0X00000002U

#define XOSPIPSV_OSPIDMA_SRC_I_MASK_MEM_DONE_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_MEM_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_I_MASK_MEM_DONE_MASK    0X00000001U
/** @} */

/**
 * @name General SRC DMA Control Register 2
 * This register contains bits for configuring
 * Maximum number of outstanding AXI read commands issued,
 * prescaler value for the timeout in clk (~2.5ns) cycles,
 * ARCACHE bits on the AXI Read channel and Timeout enable.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SRC_CTRL2
 */
#define XOSPIPSV_OSPIDMA_SRC_CTRL2    0X00001024U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMASA_SHIFT   27
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMASA_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMASA_MASK    0X08000000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_ARCACHE_SHIFT   24
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_ARCACHE_WIDTH   3
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_ARCACHE_MASK    0X07000000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_TIMEOUT_EN_SHIFT   22
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_TIMEOUT_EN_WIDTH   1
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_TIMEOUT_EN_MASK    0X00400000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMAB_SHIFT   19
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMAB_WIDTH   3
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMAB_MASK    0X00380000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMAA_SHIFT   16
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMAA_WIDTH   3
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_RAM_EMAA_MASK    0X00070000U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_TIMEOUT_PRE_SHIFT   4
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_TIMEOUT_PRE_WIDTH   12
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_TIMEOUT_PRE_MASK    0X0000FFF0U

#define XOSPIPSV_OSPIDMA_SRC_CTRL2_MAX_OUTS_CMDS_SHIFT   0
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_MAX_OUTS_CMDS_WIDTH   4
#define XOSPIPSV_OSPIDMA_SRC_CTRL2_MAX_OUTS_CMDS_MASK    0X0000000FU
/** @} */

/**
 * @name Destination mem address (lsbs) for DMA stream->memory data transfer
 * This register contains bits for configuring
 * Destination memory address (lsbs) for DMA stream to memory
 * data transfer
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_ADDR
 */
#define XOSPIPSV_OSPIDMA_DST_ADDR    0X00001800U

#define XOSPIPSV_OSPIDMA_DST_ADDR_ADDR_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_ADDR_ADDR_WIDTH   30
#define XOSPIPSV_OSPIDMA_DST_ADDR_ADDR_MASK    0XFFFFFFFCU
/** @} */

/**
 * @name DMA transfer payload for DMA stream-> memory data transfer
 * This register contains bits for configuring the
 * number of 4-byte words the DMA will transfer from stream to memory.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_SIZE
 */
#define XOSPIPSV_OSPIDMA_DST_SIZE    0X00001804U

#define XOSPIPSV_OSPIDMA_DST_SIZE_SIZE_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_SIZE_SIZE_WIDTH   27
#define XOSPIPSV_OSPIDMA_DST_SIZE_SIZE_MASK    0X1FFFFFFCU
/** @} */

/**
 * @name General DST DMA Status
 * This register contains Status information like
 * Busy, Number of outstanding transactions, Number of
 * completed transactions and Destination FIFO level.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_STS
 */
#define XOSPIPSV_OSPIDMA_DST_STS    0X00001808U

#define XOSPIPSV_OSPIDMA_DST_STS_DONE_CNT_SHIFT   13
#define XOSPIPSV_OSPIDMA_DST_STS_DONE_CNT_WIDTH   3
#define XOSPIPSV_OSPIDMA_DST_STS_DONE_CNT_MASK    0X0000E000U

#define XOSPIPSV_OSPIDMA_DST_STS_DST_FIFO_LEVEL_SHIFT   5
#define XOSPIPSV_OSPIDMA_DST_STS_DST_FIFO_LEVEL_WIDTH   8
#define XOSPIPSV_OSPIDMA_DST_STS_DST_FIFO_LEVEL_MASK    0X00001FE0U

#define XOSPIPSV_OSPIDMA_DST_STS_WR_OUTSTANDING_SHIFT   1
#define XOSPIPSV_OSPIDMA_DST_STS_WR_OUTSTANDING_WIDTH   4
#define XOSPIPSV_OSPIDMA_DST_STS_WR_OUTSTANDING_MASK    0X0000001EU

#define XOSPIPSV_OSPIDMA_DST_STS_BUSY_SHIFT   0
#define XOSPIPSV_OSPIDMA_DST_STS_BUSY_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_STS_BUSY_MASK    0X00000001U
/** @} */

/**
 * @name General DST DMA Control
 * This register contains bits for configuring
 * Pause MEM, Pause STRM, FIFO Threshold, Timeout value,
 * Endianness, APB error response etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_CTRL
 */
#define XOSPIPSV_OSPIDMA_DST_CTRL    0X0000180CU

#define XOSPIPSV_OSPIDMA_DST_CTRL_SSS_FIFOTHRESH_SHIFT   25
#define XOSPIPSV_OSPIDMA_DST_CTRL_SSS_FIFOTHRESH_WIDTH   7
#define XOSPIPSV_OSPIDMA_DST_CTRL_SSS_FIFOTHRESH_MASK    0XFE000000U

#define XOSPIPSV_OSPIDMA_DST_CTRL_APB_ERR_RESP_SHIFT   24
#define XOSPIPSV_OSPIDMA_DST_CTRL_APB_ERR_RESP_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL_APB_ERR_RESP_MASK    0X01000000U

#define XOSPIPSV_OSPIDMA_DST_CTRL_ENDIANNESS_SHIFT   23
#define XOSPIPSV_OSPIDMA_DST_CTRL_ENDIANNESS_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL_ENDIANNESS_MASK    0X00800000U

#define XOSPIPSV_OSPIDMA_DST_CTRL_AXI_BRST_TYPE_SHIFT   22
#define XOSPIPSV_OSPIDMA_DST_CTRL_AXI_BRST_TYPE_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL_AXI_BRST_TYPE_MASK    0X00400000U

#define XOSPIPSV_OSPIDMA_DST_CTRL_TIMEOUT_VAL_SHIFT   10
#define XOSPIPSV_OSPIDMA_DST_CTRL_TIMEOUT_VAL_WIDTH   12
#define XOSPIPSV_OSPIDMA_DST_CTRL_TIMEOUT_VAL_MASK    0X003FFC00U

#define XOSPIPSV_OSPIDMA_DST_CTRL_FIFO_THRESH_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_CTRL_FIFO_THRESH_WIDTH   8
#define XOSPIPSV_OSPIDMA_DST_CTRL_FIFO_THRESH_MASK    0X000003FCU

#define XOSPIPSV_OSPIDMA_DST_CTRL_PAUSE_STRM_SHIFT   1
#define XOSPIPSV_OSPIDMA_DST_CTRL_PAUSE_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL_PAUSE_STRM_MASK    0X00000002U

#define XOSPIPSV_OSPIDMA_DST_CTRL_PAUSE_MEM_SHIFT   0
#define XOSPIPSV_OSPIDMA_DST_CTRL_PAUSE_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL_PAUSE_MEM_MASK    0X00000001U
/** @} */

/**
 * @name DST DMA Interrupt Status Register
 * This register contains status bits for DMA interrupts
 * like DONE, TIMEOUT_MEM, FIFO Overflow etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_I_STS
 */
#define XOSPIPSV_OSPIDMA_DST_I_STS    0X00001814U

#define XOSPIPSV_OSPIDMA_DST_I_STS_FIFO_OVERFLOW_SHIFT   7
#define XOSPIPSV_OSPIDMA_DST_I_STS_FIFO_OVERFLOW_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_FIFO_OVERFLOW_MASK    0X00000080U

#define XOSPIPSV_OSPIDMA_DST_I_STS_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_DST_I_STS_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_DST_I_STS_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_DST_I_STS_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_DST_I_STS_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_DST_I_STS_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_DST_I_STS_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_DST_I_STS_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_DST_I_STS_AXI_BRESP_ERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_I_STS_AXI_BRESP_ERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_AXI_BRESP_ERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_DST_I_STS_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_STS_DONE_MASK    0X00000002U
/** @} */

/**
 * @name DST DMA Interrupt Enable Register
 * This register contains bits for enable DMA interrupts
 * like DONE, TIMEOUT_MEM, FIFO Overflow etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_I_EN
 */
#define XOSPIPSV_OSPIDMA_DST_I_EN    0X00001818U

#define XOSPIPSV_OSPIDMA_DST_I_EN_FIFO_OVERFLOW_SHIFT   7
#define XOSPIPSV_OSPIDMA_DST_I_EN_FIFO_OVERFLOW_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_FIFO_OVERFLOW_MASK    0X00000080U

#define XOSPIPSV_OSPIDMA_DST_I_EN_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_DST_I_EN_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_DST_I_EN_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_DST_I_EN_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_DST_I_EN_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_DST_I_EN_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_DST_I_EN_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_DST_I_EN_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_DST_I_EN_AXI_BRESP_ERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_I_EN_AXI_BRESP_ERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_AXI_BRESP_ERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_DST_I_EN_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_EN_DONE_MASK    0X00000002U
/** @} */

/**
 * @name DST DMA Interrupt Disable Register
 * This register contains bits for disable DMA interrupts
 * like DONE, TIMEOUT_MEM, FIFO Overflow etc.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_I_DIS
 */
#define XOSPIPSV_OSPIDMA_DST_I_DIS    0X0000181CU

#define XOSPIPSV_OSPIDMA_DST_I_DIS_FIFO_OVERFLOW_SHIFT   7
#define XOSPIPSV_OSPIDMA_DST_I_DIS_FIFO_OVERFLOW_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_FIFO_OVERFLOW_MASK    0X00000080U

#define XOSPIPSV_OSPIDMA_DST_I_DIS_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_DST_I_DIS_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_DST_I_DIS_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_DST_I_DIS_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_DST_I_DIS_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_DST_I_DIS_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_DST_I_DIS_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_DST_I_DIS_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_DST_I_DIS_AXI_BRESP_ERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_I_DIS_AXI_BRESP_ERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_AXI_BRESP_ERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_DST_I_DIS_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_DIS_DONE_MASK    0X00000002U
/** @} */

/**
 * @name SRC DMA Interrupt Mask Register
 * This register contains information about DMA interrupts
 * like DONE, TIMEOUT_MEM, FIFO Overflow etc.
 * 1 indicates mask the interrupt, do not pass it along
 * 0 indicates do not mask the interrupt, pass it along as is.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_I_MASK
 */
#define XOSPIPSV_OSPIDMA_DST_I_MASK    0X00001820U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_FIFO_OVERFLOW_SHIFT   7
#define XOSPIPSV_OSPIDMA_DST_I_MASK_FIFO_OVERFLOW_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_FIFO_OVERFLOW_MASK    0X00000080U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_INVALID_APB_SHIFT   6
#define XOSPIPSV_OSPIDMA_DST_I_MASK_INVALID_APB_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_INVALID_APB_MASK    0X00000040U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_THRESH_HIT_SHIFT   5
#define XOSPIPSV_OSPIDMA_DST_I_MASK_THRESH_HIT_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_THRESH_HIT_MASK    0X00000020U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_TIMEOUT_MEM_SHIFT   4
#define XOSPIPSV_OSPIDMA_DST_I_MASK_TIMEOUT_MEM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_TIMEOUT_MEM_MASK    0X00000010U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_TIMEOUT_STRM_SHIFT   3
#define XOSPIPSV_OSPIDMA_DST_I_MASK_TIMEOUT_STRM_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_TIMEOUT_STRM_MASK    0X00000008U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_AXI_BRESP_ERR_SHIFT   2
#define XOSPIPSV_OSPIDMA_DST_I_MASK_AXI_BRESP_ERR_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_AXI_BRESP_ERR_MASK    0X00000004U

#define XOSPIPSV_OSPIDMA_DST_I_MASK_DONE_SHIFT   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_DONE_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_I_MASK_DONE_MASK    0X00000002U
/** @} */

/**
 * @name General DST DMA Control Register 2
 * This register contains bits for configuring
 * Maximum number of outstanding AXI write commands issued,
 * prescaler value for the timeout in clk (~2.5ns) cycles,
 * AWCACHE bits on the AXI Write channel and Timeout enable.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_CTRL2
 */
#define XOSPIPSV_OSPIDMA_DST_CTRL2    0X00001824U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMASA_SHIFT   27
#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMASA_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMASA_MASK    0X08000000U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_AWCACHE_SHIFT   24
#define XOSPIPSV_OSPIDMA_DST_CTRL2_AWCACHE_WIDTH   3
#define XOSPIPSV_OSPIDMA_DST_CTRL2_AWCACHE_MASK    0X07000000U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_TIMEOUT_EN_SHIFT   22
#define XOSPIPSV_OSPIDMA_DST_CTRL2_TIMEOUT_EN_WIDTH   1
#define XOSPIPSV_OSPIDMA_DST_CTRL2_TIMEOUT_EN_MASK    0X00400000U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMAB_SHIFT   19
#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMAB_WIDTH   3
#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMAB_MASK    0X00380000U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMAA_SHIFT   16
#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMAA_WIDTH   3
#define XOSPIPSV_OSPIDMA_DST_CTRL2_RAM_EMAA_MASK    0X00070000U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_TIMEOUT_PRE_SHIFT   4
#define XOSPIPSV_OSPIDMA_DST_CTRL2_TIMEOUT_PRE_WIDTH   12
#define XOSPIPSV_OSPIDMA_DST_CTRL2_TIMEOUT_PRE_MASK    0X0000FFF0U

#define XOSPIPSV_OSPIDMA_DST_CTRL2_MAX_OUTS_CMDS_SHIFT   0
#define XOSPIPSV_OSPIDMA_DST_CTRL2_MAX_OUTS_CMDS_WIDTH   4
#define XOSPIPSV_OSPIDMA_DST_CTRL2_MAX_OUTS_CMDS_MASK    0X0000000F
/** @} */

/**
 * @name Destination mem address (msbs) for DMA stream->memory data transfer
 * This register contains bits for configuring
 * Destination memory address (msbs) for DMA stream to memory data transfer.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_DST_ADDR_MSB
 */
#define XOSPIPSV_OSPIDMA_DST_ADDR_MSB    0X00001828U

#define XOSPIPSV_OSPIDMA_DST_ADDR_MSB_ADDR_MSB_SHIFT   0
#define XOSPIPSV_OSPIDMA_DST_ADDR_MSB_ADDR_MSB_WIDTH   17
#define XOSPIPSV_OSPIDMA_DST_ADDR_MSB_ADDR_MSB_MASK    0X0001FFFFU
/** @} */

/**
 * @name Safety endpoint connectivity check Register
 * This register contains bits for configuring
 * Safety check field.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_SAFETY_CHK
 */
#define XOSPIPSV_OSPIDMA_SAFETY_CHK   0X00001FF8U

#define XOSPIPSV_OSPIDMA_SAFETY_CHK_CHK_VAL_SHIFT   0
#define XOSPIPSV_OSPIDMA_SAFETY_CHK_CHK_VAL_WIDTH   32
#define XOSPIPSV_OSPIDMA_SAFETY_CHK_CHK_VAL_MASK    0XFFFFFFFFU
/** @} */

/**
 * @name Future potential ECO Register
 * This register is defined for Future potential ECO.
 * @{
 */
/**
 * Register: XOSPIPSV_OSPIDMA_FUTURE_ECO
 */
#define XOSPIPSV_OSPIDMA_FUTURE_ECO    0X00001FFCU

#define XOSPIPSV_OSPIDMA_FUTURE_ECO_VAL_SHIFT   0
#define XOSPIPSV_OSPIDMA_FUTURE_ECO_VAL_WIDTH   32
#define XOSPIPSV_OSPIDMA_FUTURE_ECO_VAL_MASK    0XFFFFFFFFU
/** @} */

/**
 * Register: OSPI_AXI_MODE_SEL
 */
#define OSPI_AXI_MODE_SEL  0x00002004U
#define OSPI_AXI_MODE_SEL_FULLMASK 0x00000001U
#define OSPI_AXI_MODE_SEL_FULLRWMASK 0x00000001U
#define OSPI_AXI_MODE_SEL_DEFVAL 0x0U

/* access_type: rw */
#define OSPI_AXI_MODE_SEL_AXIS_MODE_SEL_SHIFT 0U
#define OSPI_AXI_MODE_SEL_AXIS_MODE_SEL_WIDTH 1U
#define OSPI_AXI_MODE_SEL_AXIS_MODE_SEL_MASK 0x00000001U
#define OSPI_AXI_MODE_SEL_AXIS_MODE_SEL_DEFVAL 0x0U

/**
 * @name Macros for Default configurations
 * @{
 */
/**
 * Default configurations provided by design team.
 */
#define XOSPIPSV_IND_TRIGGAHB_BASE 0xC0000000U
#define XOSPIPSV_IND_TRIGGER_RANGE 0x6
#define XOSPIPSV_DMA_PERIPH_CONFIG_VAL 0x602
#define XOSPIPSV_SRAM_PARTITION_CFG_VAL 0xFE
#define SIZE_512MB (512U*1024U*1024U)
#define XOSPIPSV_RXWATER_MARK_DEF 0x0
#define XOSPIPSV_DMA_DST_CTRL_DEF	0xF43FFA00U
#define XOSPIPSV_LINEAR_ADDR_BASE	0xC0000000U
#define XOSPIPSV_DELY_DEF_VALUE		0x00000101U
/** @} */

/**
 * @name BaseAddress macros outside controller space
 * @{
 */
/**
 * Macros defined for addresses which are outside the
 * controller space.
 */
#define XPMC_IOU_SLCR_BASEADDR		0xF1060000U
#define XPMC_IOU_SLCR_OSPI_MUX_SEL		0x00000504U
#define XPMC_IOU_SLCR_OSPI_MUX_SEL_DAC_MASK		0x00000002U

#define XPMC_MIO12_MASK		0x1000U
#define XPMC_GPIO_DIRM		0xF1020204U
#define XPMC_GPIO_OUTEN		0xF1020208U
#define XPMC_GPIO_DATA		0xF1020000U
#define XPMC_BNK0_EN_RX_SCHMITT_HYST	0xF106010CU
#define XPMC_IOU_MIO_TRI0				0xF1060200U
#define XPMC_MIO12_DATA_MASK_LSW_SHIFT		16
#define XPMC_MIO12_DATA_MASK_LSW	0xEFFFU
/** @} */

/**
 * @name Ref-Clock Delay Control Register
 * This register contains bits to control clock for
 * first stage receiver flops in Non-Phy Mode.
 * @{
 */
/**
 * Register: XOSPIPSV_REFCLK_DLY_CTRL
 */
#define XOSPIPSV_REFCLK_DLY_CTRL_REG    0X00002014U

#define XOSPIPSV_REFCLK_DLY_DEFAULT_VAL   0X00000013U
/** @} */

#ifdef __cplusplus
}
#endif

#endif /* XOSPIPSV_H_ */
/** @endcond */
/** @} */
