/* auto-generated, do not modify */
#include "config.h"

#include "fu-cab-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_cab_compression_to_string(FuCabCompression val)
{
    if (val == FU_CAB_COMPRESSION_NONE)
        return "none";
    if (val == FU_CAB_COMPRESSION_MSZIP)
        return "mszip";
    if (val == FU_CAB_COMPRESSION_QUANTUM)
        return "quantum";
    if (val == FU_CAB_COMPRESSION_LZX)
        return "lzx";
    return NULL;
}

static const gchar *
fu_cab_file_attribute_to_string(FuCabFileAttribute val)
{
    if (val == FU_CAB_FILE_ATTRIBUTE_NONE)
        return "none";
    if (val == FU_CAB_FILE_ATTRIBUTE_READONLY)
        return "readonly";
    if (val == FU_CAB_FILE_ATTRIBUTE_HIDDEN)
        return "hidden";
    if (val == FU_CAB_FILE_ATTRIBUTE_SYSTEM)
        return "system";
    if (val == FU_CAB_FILE_ATTRIBUTE_ARCH)
        return "arch";
    if (val == FU_CAB_FILE_ATTRIBUTE_EXEC)
        return "exec";
    if (val == FU_CAB_FILE_ATTRIBUTE_NAME_UTF8)
        return "name-utf8";
    return NULL;
}
/* getters */
/**
 * fu_struct_cab_data_get_checksum: (skip):
 **/
guint32
fu_struct_cab_data_get_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_get_comp: (skip):
 **/
guint16
fu_struct_cab_data_get_comp(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_get_uncomp: (skip):
 **/
guint16
fu_struct_cab_data_get_uncomp(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cab_data_set_checksum: (skip):
 **/
void
fu_struct_cab_data_set_checksum(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_set_comp: (skip):
 **/
void
fu_struct_cab_data_set_comp(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_set_uncomp: (skip):
 **/
void
fu_struct_cab_data_set_uncomp(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_data_new: (skip):
 **/
GByteArray *
fu_struct_cab_data_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_cab_data_to_string: (skip):
 **/
static gchar *
fu_struct_cab_data_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CabData:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_cab_data_get_checksum(st));
    g_string_append_printf(str, "  comp: 0x%x\n",
                           (guint) fu_struct_cab_data_get_comp(st));
    g_string_append_printf(str, "  uncomp: 0x%x\n",
                           (guint) fu_struct_cab_data_get_uncomp(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cab_data_parse: (skip):
 **/
static GByteArray *
fu_struct_cab_data_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct CabData: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_cab_data_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_data_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cab_data_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cab_data_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_cab_file_get_usize: (skip):
 **/
guint32
fu_struct_cab_file_get_usize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_uoffset: (skip):
 **/
guint32
fu_struct_cab_file_get_uoffset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_index: (skip):
 **/
guint16
fu_struct_cab_file_get_index(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_date: (skip):
 **/
guint16
fu_struct_cab_file_get_date(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_time: (skip):
 **/
guint16
fu_struct_cab_file_get_time(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_get_fattr: (skip):
 **/
FuCabFileAttribute
fu_struct_cab_file_get_fattr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_BYTE_ORDER);
}

/* setters */
/**
 * fu_struct_cab_file_set_usize: (skip):
 **/
void
fu_struct_cab_file_set_usize(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_uoffset: (skip):
 **/
void
fu_struct_cab_file_set_uoffset(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_index: (skip):
 **/
void
fu_struct_cab_file_set_index(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_date: (skip):
 **/
void
fu_struct_cab_file_set_date(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_time: (skip):
 **/
void
fu_struct_cab_file_set_time(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_file_set_fattr: (skip):
 **/
void
fu_struct_cab_file_set_fattr(GByteArray *st, FuCabFileAttribute value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 14, value, G_BYTE_ORDER);
}
/**
 * fu_struct_cab_file_new: (skip):
 **/
GByteArray *
fu_struct_cab_file_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    return st;
}
/**
 * fu_struct_cab_file_to_string: (skip):
 **/
static gchar *
fu_struct_cab_file_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CabFile:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  usize: 0x%x\n",
                           (guint) fu_struct_cab_file_get_usize(st));
    g_string_append_printf(str, "  uoffset: 0x%x\n",
                           (guint) fu_struct_cab_file_get_uoffset(st));
    g_string_append_printf(str, "  index: 0x%x\n",
                           (guint) fu_struct_cab_file_get_index(st));
    g_string_append_printf(str, "  date: 0x%x\n",
                           (guint) fu_struct_cab_file_get_date(st));
    g_string_append_printf(str, "  time: 0x%x\n",
                           (guint) fu_struct_cab_file_get_time(st));
    {
        const gchar *tmp = fu_cab_file_attribute_to_string(fu_struct_cab_file_get_fattr(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  fattr: 0x%x [%s]\n", (guint) fu_struct_cab_file_get_fattr(st), tmp);
        } else {
            g_string_append_printf(str, "  fattr: 0x%x\n", (guint) fu_struct_cab_file_get_fattr(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cab_file_parse: (skip):
 **/
static GByteArray *
fu_struct_cab_file_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct CabFile: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_cab_file_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_file_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cab_file_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cab_file_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_cab_folder_get_offset: (skip):
 **/
guint32
fu_struct_cab_folder_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_get_ndatab: (skip):
 **/
guint16
fu_struct_cab_folder_get_ndatab(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_get_compression: (skip):
 **/
FuCabCompression
fu_struct_cab_folder_get_compression(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_BYTE_ORDER);
}

/* setters */
/**
 * fu_struct_cab_folder_set_offset: (skip):
 **/
void
fu_struct_cab_folder_set_offset(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_set_ndatab: (skip):
 **/
void
fu_struct_cab_folder_set_ndatab(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_folder_set_compression: (skip):
 **/
void
fu_struct_cab_folder_set_compression(GByteArray *st, FuCabCompression value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_BYTE_ORDER);
}
/**
 * fu_struct_cab_folder_new: (skip):
 **/
GByteArray *
fu_struct_cab_folder_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_cab_folder_to_string: (skip):
 **/
static gchar *
fu_struct_cab_folder_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CabFolder:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_cab_folder_get_offset(st));
    g_string_append_printf(str, "  ndatab: 0x%x\n",
                           (guint) fu_struct_cab_folder_get_ndatab(st));
    {
        const gchar *tmp = fu_cab_compression_to_string(fu_struct_cab_folder_get_compression(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  compression: 0x%x [%s]\n", (guint) fu_struct_cab_folder_get_compression(st), tmp);
        } else {
            g_string_append_printf(str, "  compression: 0x%x\n", (guint) fu_struct_cab_folder_get_compression(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cab_folder_parse: (skip):
 **/
static GByteArray *
fu_struct_cab_folder_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct CabFolder: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_cab_folder_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_folder_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cab_folder_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cab_folder_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_cab_header_get_size: (skip):
 **/
guint32
fu_struct_cab_header_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_off_cffile: (skip):
 **/
guint32
fu_struct_cab_header_get_off_cffile(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_version_minor: (skip):
 **/
static guint8
fu_struct_cab_header_get_version_minor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[24];
}
/**
 * fu_struct_cab_header_get_version_major: (skip):
 **/
static guint8
fu_struct_cab_header_get_version_major(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[25];
}
/**
 * fu_struct_cab_header_get_nr_folders: (skip):
 **/
guint16
fu_struct_cab_header_get_nr_folders(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_nr_files: (skip):
 **/
guint16
fu_struct_cab_header_get_nr_files(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_flags: (skip):
 **/
guint16
fu_struct_cab_header_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 30, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_set_id: (skip):
 **/
guint16
fu_struct_cab_header_get_set_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_get_idx_cabinet: (skip):
 **/
guint16
fu_struct_cab_header_get_idx_cabinet(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 34, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_cab_header_set_signature: (skip):
 **/
static gboolean
fu_struct_cab_header_set_signature(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 4);
        return TRUE;
    }
    len = strlen(value);
    if (len > 4) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in CabHeader.signature (0x%x bytes)",
                    value, (guint) len, (guint) 4);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_cab_header_set_size: (skip):
 **/
void
fu_struct_cab_header_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_off_cffile: (skip):
 **/
void
fu_struct_cab_header_set_off_cffile(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_version_minor: (skip):
 **/
static void
fu_struct_cab_header_set_version_minor(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[24] = value;
}
/**
 * fu_struct_cab_header_set_version_major: (skip):
 **/
static void
fu_struct_cab_header_set_version_major(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[25] = value;
}
/**
 * fu_struct_cab_header_set_nr_folders: (skip):
 **/
void
fu_struct_cab_header_set_nr_folders(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_nr_files: (skip):
 **/
void
fu_struct_cab_header_set_nr_files(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_flags: (skip):
 **/
void
fu_struct_cab_header_set_flags(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 30, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_set_id: (skip):
 **/
void
fu_struct_cab_header_set_set_id(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_set_idx_cabinet: (skip):
 **/
void
fu_struct_cab_header_set_idx_cabinet(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 34, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_new: (skip):
 **/
GByteArray *
fu_struct_cab_header_new(void)
{
    GByteArray *st = g_byte_array_sized_new(36);
    fu_byte_array_set_size(st, 36, 0x0);
    fu_struct_cab_header_set_signature(st, "MSCF", NULL);
    fu_struct_cab_header_set_version_minor(st, 3);
    fu_struct_cab_header_set_version_major(st, 1);
    fu_struct_cab_header_set_nr_folders(st, 1);
    return st;
}
/**
 * fu_struct_cab_header_to_string: (skip):
 **/
static gchar *
fu_struct_cab_header_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CabHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_cab_header_get_size(st));
    g_string_append_printf(str, "  off_cffile: 0x%x\n",
                           (guint) fu_struct_cab_header_get_off_cffile(st));
    g_string_append_printf(str, "  nr_folders: 0x%x\n",
                           (guint) fu_struct_cab_header_get_nr_folders(st));
    g_string_append_printf(str, "  nr_files: 0x%x\n",
                           (guint) fu_struct_cab_header_get_nr_files(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_cab_header_get_flags(st));
    g_string_append_printf(str, "  set_id: 0x%x\n",
                           (guint) fu_struct_cab_header_get_set_id(st));
    g_string_append_printf(str, "  idx_cabinet: 0x%x\n",
                           (guint) fu_struct_cab_header_get_idx_cabinet(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cab_header_parse: (skip):
 **/
static GByteArray *
fu_struct_cab_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 36, error)) {
        g_prefix_error(error, "invalid struct CabHeader: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 36);
    if (strncmp((const gchar *) (st->data + 0), "MSCF", 4) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant CabHeader.signature was not valid, expected MSCF");
        return NULL;
    }
    if (fu_struct_cab_header_get_version_minor(st) != 3) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant CabHeader.version_minor was not valid, expected 3");
        return NULL;
    }
    if (fu_struct_cab_header_get_version_major(st) != 1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant CabHeader.version_major was not valid, expected 1");
        return NULL;
    }
    str = fu_struct_cab_header_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_header_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cab_header_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cab_header_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_cab_header_validate: (skip):
 **/
static gboolean
fu_struct_cab_header_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 36, error)) {
        g_prefix_error(error, "invalid struct CabHeader: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 0), "MSCF", 4) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant CabHeader.signature was not valid");
        return FALSE;
    }
    if (fu_struct_cab_header_get_version_minor(&st) != 3) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant CabHeader.version_minor was not valid");
        return FALSE;
    }
    if (fu_struct_cab_header_get_version_major(&st) != 1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant CabHeader.version_major was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_cab_header_validate_bytes: (skip):
 **/
gboolean
fu_struct_cab_header_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cab_header_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_cab_header_reserve_get_rsvd_hdr: (skip):
 **/
guint16
fu_struct_cab_header_reserve_get_rsvd_hdr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_reserve_get_rsvd_folder: (skip):
 **/
guint8
fu_struct_cab_header_reserve_get_rsvd_folder(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_cab_header_reserve_get_rsvd_block: (skip):
 **/
guint8
fu_struct_cab_header_reserve_get_rsvd_block(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}

/* setters */
/**
 * fu_struct_cab_header_reserve_set_rsvd_hdr: (skip):
 **/
void
fu_struct_cab_header_reserve_set_rsvd_hdr(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_cab_header_reserve_set_rsvd_folder: (skip):
 **/
void
fu_struct_cab_header_reserve_set_rsvd_folder(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_cab_header_reserve_set_rsvd_block: (skip):
 **/
void
fu_struct_cab_header_reserve_set_rsvd_block(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_cab_header_reserve_new: (skip):
 **/
GByteArray *
fu_struct_cab_header_reserve_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    return st;
}
/**
 * fu_struct_cab_header_reserve_to_string: (skip):
 **/
static gchar *
fu_struct_cab_header_reserve_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("CabHeaderReserve:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  rsvd_hdr: 0x%x\n",
                           (guint) fu_struct_cab_header_reserve_get_rsvd_hdr(st));
    g_string_append_printf(str, "  rsvd_folder: 0x%x\n",
                           (guint) fu_struct_cab_header_reserve_get_rsvd_folder(st));
    g_string_append_printf(str, "  rsvd_block: 0x%x\n",
                           (guint) fu_struct_cab_header_reserve_get_rsvd_block(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_cab_header_reserve_parse: (skip):
 **/
static GByteArray *
fu_struct_cab_header_reserve_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct CabHeaderReserve: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 4);
    str = fu_struct_cab_header_reserve_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_cab_header_reserve_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_cab_header_reserve_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_cab_header_reserve_parse(buf, bufsz, offset, error);
}
