/* auto-generated, do not modify */
#include "config.h"

#include "fu-dfu-firmware-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_dfu_ftr_get_release: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_release(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_pid: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_pid(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_vid: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_vid(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_ver: (skip):
 **/
guint16
fu_struct_dfu_ftr_get_ver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_get_len: (skip):
 **/
guint8
fu_struct_dfu_ftr_get_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_dfu_ftr_get_crc: (skip):
 **/
guint32
fu_struct_dfu_ftr_get_crc(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfu_ftr_set_release: (skip):
 **/
void
fu_struct_dfu_ftr_set_release(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_pid: (skip):
 **/
void
fu_struct_dfu_ftr_set_pid(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_vid: (skip):
 **/
void
fu_struct_dfu_ftr_set_vid(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_ver: (skip):
 **/
void
fu_struct_dfu_ftr_set_ver(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_set_sig: (skip):
 **/
static gboolean
fu_struct_dfu_ftr_set_sig(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 8, 0x0, 3);
        return TRUE;
    }
    len = strlen(value);
    if (len > 3) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in DfuFtr.sig (0x%x bytes)",
                    value, (guint) len, (guint) 3);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfu_ftr_set_len: (skip):
 **/
void
fu_struct_dfu_ftr_set_len(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[11] = value;
}
/**
 * fu_struct_dfu_ftr_set_crc: (skip):
 **/
void
fu_struct_dfu_ftr_set_crc(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_ftr_new: (skip):
 **/
GByteArray *
fu_struct_dfu_ftr_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    fu_struct_dfu_ftr_set_sig(st, "UFD", NULL);
    fu_struct_dfu_ftr_set_len(st, 16);
    return st;
}
/**
 * fu_struct_dfu_ftr_to_string: (skip):
 **/
static gchar *
fu_struct_dfu_ftr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("DfuFtr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  release: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_release(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_pid(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_vid(st));
    g_string_append_printf(str, "  ver: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_ver(st));
    g_string_append_printf(str, "  len: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_len(st));
    g_string_append_printf(str, "  crc: 0x%x\n",
                           (guint) fu_struct_dfu_ftr_get_crc(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfu_ftr_parse: (skip):
 **/
GByteArray *
fu_struct_dfu_ftr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct DfuFtr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    if (strncmp((const gchar *) (st->data + 8), "UFD", 3) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuFtr.sig was not valid, expected UFD");
        return NULL;
    }
    str = fu_struct_dfu_ftr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfu_ftr_validate: (skip):
 **/
static gboolean
fu_struct_dfu_ftr_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct DfuFtr: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 8), "UFD", 3) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuFtr.sig was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dfu_ftr_validate_bytes: (skip):
 **/
gboolean
fu_struct_dfu_ftr_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_dfu_ftr_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_dfuse_hdr_get_ver: (skip):
 **/
static guint8
fu_struct_dfuse_hdr_get_ver(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[5];
}
/**
 * fu_struct_dfuse_hdr_get_image_size: (skip):
 **/
guint32
fu_struct_dfuse_hdr_get_image_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_hdr_get_targets: (skip):
 **/
guint8
fu_struct_dfuse_hdr_get_targets(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}

/* setters */
/**
 * fu_struct_dfuse_hdr_set_sig: (skip):
 **/
static gboolean
fu_struct_dfuse_hdr_set_sig(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 5);
        return TRUE;
    }
    len = strlen(value);
    if (len > 5) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in DfuseHdr.sig (0x%x bytes)",
                    value, (guint) len, (guint) 5);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfuse_hdr_set_ver: (skip):
 **/
static void
fu_struct_dfuse_hdr_set_ver(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[5] = value;
}
/**
 * fu_struct_dfuse_hdr_set_image_size: (skip):
 **/
void
fu_struct_dfuse_hdr_set_image_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_hdr_set_targets: (skip):
 **/
void
fu_struct_dfuse_hdr_set_targets(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[10] = value;
}
/**
 * fu_struct_dfuse_hdr_new: (skip):
 **/
GByteArray *
fu_struct_dfuse_hdr_new(void)
{
    GByteArray *st = g_byte_array_sized_new(11);
    fu_byte_array_set_size(st, 11, 0x0);
    fu_struct_dfuse_hdr_set_sig(st, "DfuSe", NULL);
    fu_struct_dfuse_hdr_set_ver(st, 0x01);
    return st;
}
/**
 * fu_struct_dfuse_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_dfuse_hdr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("DfuseHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  image_size: 0x%x\n",
                           (guint) fu_struct_dfuse_hdr_get_image_size(st));
    g_string_append_printf(str, "  targets: 0x%x\n",
                           (guint) fu_struct_dfuse_hdr_get_targets(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfuse_hdr_parse: (skip):
 **/
static GByteArray *
fu_struct_dfuse_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 11, error)) {
        g_prefix_error(error, "invalid struct DfuseHdr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 11);
    if (strncmp((const gchar *) (st->data + 0), "DfuSe", 5) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuseHdr.sig was not valid, expected DfuSe");
        return NULL;
    }
    if (fu_struct_dfuse_hdr_get_ver(st) != 0x01) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuseHdr.ver was not valid, expected 0x01");
        return NULL;
    }
    str = fu_struct_dfuse_hdr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfuse_hdr_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_dfuse_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_dfuse_hdr_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_dfuse_hdr_validate: (skip):
 **/
static gboolean
fu_struct_dfuse_hdr_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 11, error)) {
        g_prefix_error(error, "invalid struct DfuseHdr: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 0), "DfuSe", 5) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuseHdr.sig was not valid");
        return FALSE;
    }
    if (fu_struct_dfuse_hdr_get_ver(&st) != 0x01) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuseHdr.ver was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dfuse_hdr_validate_bytes: (skip):
 **/
gboolean
fu_struct_dfuse_hdr_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_dfuse_hdr_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_dfuse_image_get_alt_setting: (skip):
 **/
guint8
fu_struct_dfuse_image_get_alt_setting(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[6];
}
/**
 * fu_struct_dfuse_image_get_target_named: (skip):
 **/
guint32
fu_struct_dfuse_image_get_target_named(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 7, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_get_target_name: (skip):
 **/
gchar *
fu_struct_dfuse_image_get_target_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 11, 255, NULL);
}
/**
 * fu_struct_dfuse_image_get_target_size: (skip):
 **/
guint32
fu_struct_dfuse_image_get_target_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 266, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_get_chunks: (skip):
 **/
guint32
fu_struct_dfuse_image_get_chunks(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 270, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfuse_image_set_sig: (skip):
 **/
static gboolean
fu_struct_dfuse_image_set_sig(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 6);
        return TRUE;
    }
    len = strlen(value);
    if (len > 6) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in DfuseImage.sig (0x%x bytes)",
                    value, (guint) len, (guint) 6);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfuse_image_set_alt_setting: (skip):
 **/
void
fu_struct_dfuse_image_set_alt_setting(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[6] = value;
}
/**
 * fu_struct_dfuse_image_set_target_named: (skip):
 **/
void
fu_struct_dfuse_image_set_target_named(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 7, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_set_target_name: (skip):
 **/
gboolean
fu_struct_dfuse_image_set_target_name(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 11, 0x0, 255);
        return TRUE;
    }
    len = strlen(value);
    if (len > 255) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in DfuseImage.target_name (0x%x bytes)",
                    value, (guint) len, (guint) 255);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 11, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_dfuse_image_set_target_size: (skip):
 **/
void
fu_struct_dfuse_image_set_target_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 266, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_set_chunks: (skip):
 **/
void
fu_struct_dfuse_image_set_chunks(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 270, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_image_new: (skip):
 **/
GByteArray *
fu_struct_dfuse_image_new(void)
{
    GByteArray *st = g_byte_array_sized_new(274);
    fu_byte_array_set_size(st, 274, 0x0);
    fu_struct_dfuse_image_set_sig(st, "Target", NULL);
    return st;
}
/**
 * fu_struct_dfuse_image_to_string: (skip):
 **/
static gchar *
fu_struct_dfuse_image_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("DfuseImage:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  alt_setting: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_alt_setting(st));
    g_string_append_printf(str, "  target_named: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_target_named(st));
    {
        g_autofree gchar *tmp = fu_struct_dfuse_image_get_target_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  target_name: %s\n", tmp);
    }
    g_string_append_printf(str, "  target_size: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_target_size(st));
    g_string_append_printf(str, "  chunks: 0x%x\n",
                           (guint) fu_struct_dfuse_image_get_chunks(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfuse_image_parse: (skip):
 **/
static GByteArray *
fu_struct_dfuse_image_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 274, error)) {
        g_prefix_error(error, "invalid struct DfuseImage: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 274);
    if (strncmp((const gchar *) (st->data + 0), "Target", 6) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuseImage.sig was not valid, expected Target");
        return NULL;
    }
    str = fu_struct_dfuse_image_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfuse_image_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_dfuse_image_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_dfuse_image_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_dfuse_image_validate: (skip):
 **/
gboolean
fu_struct_dfuse_image_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 274, error)) {
        g_prefix_error(error, "invalid struct DfuseImage: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 0), "Target", 6) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuseImage.sig was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_dfuse_element_get_address: (skip):
 **/
guint32
fu_struct_dfuse_element_get_address(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_element_get_size: (skip):
 **/
guint32
fu_struct_dfuse_element_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfuse_element_set_address: (skip):
 **/
void
fu_struct_dfuse_element_set_address(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_element_set_size: (skip):
 **/
void
fu_struct_dfuse_element_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfuse_element_new: (skip):
 **/
GByteArray *
fu_struct_dfuse_element_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_dfuse_element_to_string: (skip):
 **/
static gchar *
fu_struct_dfuse_element_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("DfuseElement:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  address: 0x%x\n",
                           (guint) fu_struct_dfuse_element_get_address(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_dfuse_element_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfuse_element_parse: (skip):
 **/
GByteArray *
fu_struct_dfuse_element_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct DfuseElement: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_dfuse_element_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfuse_element_validate: (skip):
 **/
gboolean
fu_struct_dfuse_element_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct DfuseElement: ");
        return FALSE;
    }
    return TRUE;
}
