/* auto-generated, do not modify */
#include "config.h"

#include "fu-efi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_efi_signature_kind_to_string(FuEfiSignatureKind val)
{
    if (val == FU_EFI_SIGNATURE_KIND_UNKNOWN)
        return "unknown";
    if (val == FU_EFI_SIGNATURE_KIND_SHA256)
        return "sha256";
    if (val == FU_EFI_SIGNATURE_KIND_X509)
        return "x509";
    return NULL;
}


const gchar *
fu_efi_file_type_to_string(FuEfiFileType val)
{
    if (val == FU_EFI_FILE_TYPE_ALL)
        return "all";
    if (val == FU_EFI_FILE_TYPE_RAW)
        return "raw";
    if (val == FU_EFI_FILE_TYPE_FREEFORM)
        return "freeform";
    if (val == FU_EFI_FILE_TYPE_SECURITY_CORE)
        return "security-core";
    if (val == FU_EFI_FILE_TYPE_PEI_CORE)
        return "pei-core";
    if (val == FU_EFI_FILE_TYPE_DXE_CORE)
        return "dxe-core";
    if (val == FU_EFI_FILE_TYPE_PEIM)
        return "peim";
    if (val == FU_EFI_FILE_TYPE_DRIVER)
        return "driver";
    if (val == FU_EFI_FILE_TYPE_COMBINED_PEIM_DRIVER)
        return "combined-peim-driver";
    if (val == FU_EFI_FILE_TYPE_APPLICATION)
        return "application";
    if (val == FU_EFI_FILE_TYPE_MM)
        return "mm";
    if (val == FU_EFI_FILE_TYPE_FIRMWARE_VOLUME_IMAGE)
        return "firmware-volume-image";
    if (val == FU_EFI_FILE_TYPE_COMBINED_MM_DXE)
        return "combined-mm-dxe";
    if (val == FU_EFI_FILE_TYPE_MM_CORE)
        return "mm-core";
    if (val == FU_EFI_FILE_TYPE_MM_STANDALONE)
        return "mm-standalone";
    if (val == FU_EFI_FILE_TYPE_MM_CORE_STANDALONE)
        return "mm-core-standalone";
    if (val == FU_EFI_FILE_TYPE_FFS_PAD)
        return "ffs-pad";
    return NULL;
}

const gchar *
fu_efi_section_type_to_string(FuEfiSectionType val)
{
    if (val == FU_EFI_SECTION_TYPE_COMPRESSION)
        return "compression";
    if (val == FU_EFI_SECTION_TYPE_GUID_DEFINED)
        return "guid-defined";
    if (val == FU_EFI_SECTION_TYPE_DISPOSABLE)
        return "disposable";
    if (val == FU_EFI_SECTION_TYPE_PE32)
        return "pe32";
    if (val == FU_EFI_SECTION_TYPE_PIC)
        return "pic";
    if (val == FU_EFI_SECTION_TYPE_TE)
        return "te";
    if (val == FU_EFI_SECTION_TYPE_DXE_DEPEX)
        return "dxe-depex";
    if (val == FU_EFI_SECTION_TYPE_VERSION)
        return "version";
    if (val == FU_EFI_SECTION_TYPE_USER_INTERFACE)
        return "user-interface";
    if (val == FU_EFI_SECTION_TYPE_COMPATIBILITY16)
        return "compatibility16";
    if (val == FU_EFI_SECTION_TYPE_VOLUME_IMAGE)
        return "volume-image";
    if (val == FU_EFI_SECTION_TYPE_FREEFORM_SUBTYPE_GUID)
        return "freeform-subtype-guid";
    if (val == FU_EFI_SECTION_TYPE_RAW)
        return "raw";
    if (val == FU_EFI_SECTION_TYPE_PEI_DEPEX)
        return "pei-depex";
    if (val == FU_EFI_SECTION_TYPE_MM_DEPEX)
        return "mm-depex";
    return NULL;
}

static const gchar *
fu_efi_load_option_attrs_to_string(FuEfiLoadOptionAttrs val)
{
    if (val == FU_EFI_LOAD_OPTION_ATTRS_ACTIVE)
        return "active";
    if (val == FU_EFI_LOAD_OPTION_ATTRS_FORCE_RECONNECT)
        return "force-reconnect";
    if (val == FU_EFI_LOAD_OPTION_ATTRS_HIDDEN)
        return "hidden";
    if (val == FU_EFI_LOAD_OPTION_ATTRS_CATEGORY)
        return "category";
    if (val == FU_EFI_LOAD_OPTION_ATTRS_CATEGORY_BOOT)
        return "category-boot";
    if (val == FU_EFI_LOAD_OPTION_ATTRS_CATEGORY_AP)
        return "category-ap";
    return NULL;
}

static const gchar *
fu_efi_device_path_type_to_string(FuEfiDevicePathType val)
{
    if (val == FU_EFI_DEVICE_PATH_TYPE_HARDWARE)
        return "hardware";
    if (val == FU_EFI_DEVICE_PATH_TYPE_ACPI)
        return "acpi";
    if (val == FU_EFI_DEVICE_PATH_TYPE_MESSAGE)
        return "message";
    if (val == FU_EFI_DEVICE_PATH_TYPE_MEDIA)
        return "media";
    if (val == FU_EFI_DEVICE_PATH_TYPE_BIOS_BOOT)
        return "bios-boot";
    if (val == FU_EFI_DEVICE_PATH_TYPE_END)
        return "end";
    return NULL;
}

static const gchar *
fu_efi_hard_drive_device_path_subtype_to_string(FuEfiHardDriveDevicePathSubtype val)
{
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_HARD_DRIVE)
        return "hard-drive";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_CDROM)
        return "cdrom";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_VENDOR)
        return "vendor";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_FILE_PATH)
        return "file-path";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_MEDIA_PROTOCOL)
        return "media-protocol";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_PIWG_FIRMWARE_FILE)
        return "piwg-firmware-file";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_PIWG_FIRMWARE_VOLUME)
        return "piwg-firmware-volume";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_RELATIVE_OFFSET_RANGE)
        return "relative-offset-range";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_RAM_DISK_DEVICE_PATH)
        return "ram-disk-device-path";
    return NULL;
}

const gchar *
fu_efi_hard_drive_device_path_partition_format_to_string(FuEfiHardDriveDevicePathPartitionFormat val)
{
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_LEGACY_MBR)
        return "legacy-mbr";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE)
        return "guid-partition-table";
    return NULL;
}
FuEfiHardDriveDevicePathPartitionFormat
fu_efi_hard_drive_device_path_partition_format_from_string(const gchar *val)
{
    if (g_strcmp0(val, "legacy-mbr") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_LEGACY_MBR;
    if (g_strcmp0(val, "guid-partition-table") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE;
    return FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_LEGACY_MBR;
}

const gchar *
fu_efi_hard_drive_device_path_signature_type_to_string(FuEfiHardDriveDevicePathSignatureType val)
{
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_NONE)
        return "none";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_ADDR1B8)
        return "addr1b8";
    if (val == FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_GUID)
        return "guid";
    return NULL;
}
FuEfiHardDriveDevicePathSignatureType
fu_efi_hard_drive_device_path_signature_type_from_string(const gchar *val)
{
    if (g_strcmp0(val, "none") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_NONE;
    if (g_strcmp0(val, "addr1b8") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_ADDR1B8;
    if (g_strcmp0(val, "guid") == 0)
        return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_GUID;
    return FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_NONE;
}
/* getters */
/**
 * fu_struct_efi_file_get_name: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_file_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 0);
}
/**
 * fu_struct_efi_file_get_hdr_checksum: (skip):
 **/
guint8
fu_struct_efi_file_get_hdr_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[16];
}
/**
 * fu_struct_efi_file_get_data_checksum: (skip):
 **/
guint8
fu_struct_efi_file_get_data_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[17];
}
/**
 * fu_struct_efi_file_get_type: (skip):
 **/
FuEfiFileType
fu_struct_efi_file_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[18];
}
/**
 * fu_struct_efi_file_get_attrs: (skip):
 **/
guint8
fu_struct_efi_file_get_attrs(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[19];
}
/**
 * fu_struct_efi_file_get_size: (skip):
 **/
guint32
fu_struct_efi_file_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_file_get_state: (skip):
 **/
static guint8
fu_struct_efi_file_get_state(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[23];
}

/* setters */
/**
 * fu_struct_efi_file_set_name: (skip):
 **/
void
fu_struct_efi_file_set_name(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 0, value, sizeof(*value));
}
/**
 * fu_struct_efi_file_set_hdr_checksum: (skip):
 **/
void
fu_struct_efi_file_set_hdr_checksum(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[16] = value;
}
/**
 * fu_struct_efi_file_set_data_checksum: (skip):
 **/
void
fu_struct_efi_file_set_data_checksum(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[17] = value;
}
/**
 * fu_struct_efi_file_set_type: (skip):
 **/
void
fu_struct_efi_file_set_type(GByteArray *st, FuEfiFileType value)
{
    g_return_if_fail(st != NULL);
    st->data[18] = value;
}
/**
 * fu_struct_efi_file_set_attrs: (skip):
 **/
void
fu_struct_efi_file_set_attrs(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[19] = value;
}
/**
 * fu_struct_efi_file_set_size: (skip):
 **/
void
fu_struct_efi_file_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_file_set_state: (skip):
 **/
static void
fu_struct_efi_file_set_state(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[23] = value;
}
/**
 * fu_struct_efi_file_new: (skip):
 **/
GByteArray *
fu_struct_efi_file_new(void)
{
    GByteArray *st = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st, 24, 0x0);
    fu_struct_efi_file_set_state(st, 0xF8);
    return st;
}
/**
 * fu_struct_efi_file_to_string: (skip):
 **/
static gchar *
fu_struct_efi_file_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiFile:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_file_get_name(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  hdr_checksum: 0x%x\n",
                           (guint) fu_struct_efi_file_get_hdr_checksum(st));
    g_string_append_printf(str, "  data_checksum: 0x%x\n",
                           (guint) fu_struct_efi_file_get_data_checksum(st));
    {
        const gchar *tmp = fu_efi_file_type_to_string(fu_struct_efi_file_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_file_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_file_get_type(st));
        }
    }
    g_string_append_printf(str, "  attrs: 0x%x\n",
                           (guint) fu_struct_efi_file_get_attrs(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_file_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_file_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_file_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error(error, "invalid struct EfiFile: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 24);
    if (fu_struct_efi_file_get_state(st) != 0xF8) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiFile.state was not valid, expected 0xF8");
        return NULL;
    }
    str = fu_struct_efi_file_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_file_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_file_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_file_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_efi_file_validate: (skip):
 **/
gboolean
fu_struct_efi_file_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error(error, "invalid struct EfiFile: ");
        return FALSE;
    }
    if (fu_struct_efi_file_get_state(&st) != 0xF8) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiFile.state was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_efi_section_get_size: (skip):
 **/
guint32
fu_struct_efi_section_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint24(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_get_type: (skip):
 **/
FuEfiSectionType
fu_struct_efi_section_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}

/* setters */
/**
 * fu_struct_efi_section_set_size: (skip):
 **/
void
fu_struct_efi_section_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint24(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_set_type: (skip):
 **/
void
fu_struct_efi_section_set_type(GByteArray *st, FuEfiSectionType value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_efi_section_new: (skip):
 **/
GByteArray *
fu_struct_efi_section_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    return st;
}
/**
 * fu_struct_efi_section_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiSection:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_section_get_size(st));
    {
        const gchar *tmp = fu_efi_section_type_to_string(fu_struct_efi_section_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_section_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_section_get_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_section_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_section_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct EfiSection: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 4);
    str = fu_struct_efi_section_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_section_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_section_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_efi_section_validate: (skip):
 **/
gboolean
fu_struct_efi_section_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct EfiSection: ");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_efi_section_guid_defined_get_name: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_section_guid_defined_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 0);
}
/**
 * fu_struct_efi_section_guid_defined_get_offset: (skip):
 **/
guint16
fu_struct_efi_section_guid_defined_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_guid_defined_get_attr: (skip):
 **/
guint16
fu_struct_efi_section_guid_defined_get_attr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 18, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_section_guid_defined_set_name: (skip):
 **/
void
fu_struct_efi_section_guid_defined_set_name(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 0, value, sizeof(*value));
}
/**
 * fu_struct_efi_section_guid_defined_set_offset: (skip):
 **/
void
fu_struct_efi_section_guid_defined_set_offset(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_guid_defined_set_attr: (skip):
 **/
void
fu_struct_efi_section_guid_defined_set_attr(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_section_guid_defined_new: (skip):
 **/
GByteArray *
fu_struct_efi_section_guid_defined_new(void)
{
    GByteArray *st = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st, 20, 0x0);
    return st;
}
/**
 * fu_struct_efi_section_guid_defined_to_string: (skip):
 **/
static gchar *
fu_struct_efi_section_guid_defined_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiSectionGuidDefined:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_section_guid_defined_get_name(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_efi_section_guid_defined_get_offset(st));
    g_string_append_printf(str, "  attr: 0x%x\n",
                           (guint) fu_struct_efi_section_guid_defined_get_attr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_section_guid_defined_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_section_guid_defined_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error(error, "invalid struct EfiSectionGuidDefined: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 20);
    str = fu_struct_efi_section_guid_defined_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_section_guid_defined_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_section_guid_defined_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_section_guid_defined_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_efi_section_guid_defined_validate: (skip):
 **/
gboolean
fu_struct_efi_section_guid_defined_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error(error, "invalid struct EfiSectionGuidDefined: ");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_efi_volume_get_zero_vector: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_volume_get_zero_vector(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 0);
}
/**
 * fu_struct_efi_volume_get_guid: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_volume_get_guid(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 16);
}
/**
 * fu_struct_efi_volume_get_length: (skip):
 **/
guint64
fu_struct_efi_volume_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_signature: (skip):
 **/
static guint32
fu_struct_efi_volume_get_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_attrs: (skip):
 **/
guint32
fu_struct_efi_volume_get_attrs(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_hdr_len: (skip):
 **/
guint16
fu_struct_efi_volume_get_hdr_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 48, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_checksum: (skip):
 **/
guint16
fu_struct_efi_volume_get_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 50, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_ext_hdr: (skip):
 **/
guint16
fu_struct_efi_volume_get_ext_hdr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 52, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_get_revision: (skip):
 **/
static guint8
fu_struct_efi_volume_get_revision(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[55];
}

/* setters */
/**
 * fu_struct_efi_volume_set_zero_vector: (skip):
 **/
void
fu_struct_efi_volume_set_zero_vector(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 0, value, sizeof(*value));
}
/**
 * fu_struct_efi_volume_set_guid: (skip):
 **/
void
fu_struct_efi_volume_set_guid(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 16, value, sizeof(*value));
}
/**
 * fu_struct_efi_volume_set_length: (skip):
 **/
void
fu_struct_efi_volume_set_length(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_signature: (skip):
 **/
static void
fu_struct_efi_volume_set_signature(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_attrs: (skip):
 **/
void
fu_struct_efi_volume_set_attrs(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 44, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_hdr_len: (skip):
 **/
void
fu_struct_efi_volume_set_hdr_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 48, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_checksum: (skip):
 **/
void
fu_struct_efi_volume_set_checksum(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 50, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_ext_hdr: (skip):
 **/
void
fu_struct_efi_volume_set_ext_hdr(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 52, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_set_revision: (skip):
 **/
static void
fu_struct_efi_volume_set_revision(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[55] = value;
}
/**
 * fu_struct_efi_volume_new: (skip):
 **/
GByteArray *
fu_struct_efi_volume_new(void)
{
    GByteArray *st = g_byte_array_sized_new(56);
    fu_byte_array_set_size(st, 56, 0x0);
    fu_struct_efi_volume_set_signature(st, 0x4856465F);
    fu_struct_efi_volume_set_revision(st, 0x02);
    return st;
}
/**
 * fu_struct_efi_volume_to_string: (skip):
 **/
static gchar *
fu_struct_efi_volume_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiVolume:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_volume_get_zero_vector(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  zero_vector: %s\n", tmp);
    }
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_volume_get_guid(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  guid: %s\n", tmp);
    }
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_length(st));
    g_string_append_printf(str, "  attrs: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_attrs(st));
    g_string_append_printf(str, "  hdr_len: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_hdr_len(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_checksum(st));
    g_string_append_printf(str, "  ext_hdr: 0x%x\n",
                           (guint) fu_struct_efi_volume_get_ext_hdr(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_volume_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_volume_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 56, error)) {
        g_prefix_error(error, "invalid struct EfiVolume: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 56);
    if (fu_struct_efi_volume_get_signature(st) != 0x4856465F) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiVolume.signature was not valid, expected 0x4856465F");
        return NULL;
    }
    if (fu_struct_efi_volume_get_revision(st) != 0x02) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiVolume.revision was not valid, expected 0x02");
        return NULL;
    }
    str = fu_struct_efi_volume_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_volume_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_volume_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_volume_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_efi_volume_validate: (skip):
 **/
static gboolean
fu_struct_efi_volume_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 56, error)) {
        g_prefix_error(error, "invalid struct EfiVolume: ");
        return FALSE;
    }
    if (fu_struct_efi_volume_get_signature(&st) != 0x4856465F) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiVolume.signature was not valid");
        return FALSE;
    }
    if (fu_struct_efi_volume_get_revision(&st) != 0x02) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiVolume.revision was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_efi_volume_validate_bytes: (skip):
 **/
gboolean
fu_struct_efi_volume_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_volume_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_efi_volume_block_map_get_num_blocks: (skip):
 **/
guint32
fu_struct_efi_volume_block_map_get_num_blocks(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_block_map_get_length: (skip):
 **/
guint32
fu_struct_efi_volume_block_map_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_volume_block_map_set_num_blocks: (skip):
 **/
void
fu_struct_efi_volume_block_map_set_num_blocks(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_block_map_set_length: (skip):
 **/
void
fu_struct_efi_volume_block_map_set_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_volume_block_map_new: (skip):
 **/
GByteArray *
fu_struct_efi_volume_block_map_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_efi_volume_block_map_to_string: (skip):
 **/
static gchar *
fu_struct_efi_volume_block_map_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiVolumeBlockMap:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  num_blocks: 0x%x\n",
                           (guint) fu_struct_efi_volume_block_map_get_num_blocks(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_volume_block_map_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_volume_block_map_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_volume_block_map_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct EfiVolumeBlockMap: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_efi_volume_block_map_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_volume_block_map_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_volume_block_map_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_volume_block_map_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_efi_volume_block_map_validate: (skip):
 **/
gboolean
fu_struct_efi_volume_block_map_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct EfiVolumeBlockMap: ");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_efi_signature_list_get_type: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_signature_list_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 0);
}
/**
 * fu_struct_efi_signature_list_get_list_size: (skip):
 **/
guint32
fu_struct_efi_signature_list_get_list_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_get_header_size: (skip):
 **/
guint32
fu_struct_efi_signature_list_get_header_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_get_size: (skip):
 **/
guint32
fu_struct_efi_signature_list_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_signature_list_set_type: (skip):
 **/
void
fu_struct_efi_signature_list_set_type(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 0, value, sizeof(*value));
}
/**
 * fu_struct_efi_signature_list_set_list_size: (skip):
 **/
void
fu_struct_efi_signature_list_set_list_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_set_header_size: (skip):
 **/
void
fu_struct_efi_signature_list_set_header_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_set_size: (skip):
 **/
void
fu_struct_efi_signature_list_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_signature_list_new: (skip):
 **/
GByteArray *
fu_struct_efi_signature_list_new(void)
{
    GByteArray *st = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st, 28, 0x0);
    return st;
}
/**
 * fu_struct_efi_signature_list_to_string: (skip):
 **/
static gchar *
fu_struct_efi_signature_list_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiSignatureList:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_signature_list_get_type(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  type: %s\n", tmp);
    }
    g_string_append_printf(str, "  list_size: 0x%x\n",
                           (guint) fu_struct_efi_signature_list_get_list_size(st));
    g_string_append_printf(str, "  header_size: 0x%x\n",
                           (guint) fu_struct_efi_signature_list_get_header_size(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_efi_signature_list_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_signature_list_parse: (skip):
 **/
GByteArray *
fu_struct_efi_signature_list_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error(error, "invalid struct EfiSignatureList: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 28);
    str = fu_struct_efi_signature_list_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_signature_list_validate: (skip):
 **/
gboolean
fu_struct_efi_signature_list_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error(error, "invalid struct EfiSignatureList: ");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_efi_load_option_get_attrs: (skip):
 **/
FuEfiLoadOptionAttrs
fu_struct_efi_load_option_get_attrs(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_load_option_get_dp_size: (skip):
 **/
guint16
fu_struct_efi_load_option_get_dp_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_load_option_set_attrs: (skip):
 **/
void
fu_struct_efi_load_option_set_attrs(GByteArray *st, FuEfiLoadOptionAttrs value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_load_option_set_dp_size: (skip):
 **/
void
fu_struct_efi_load_option_set_dp_size(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_load_option_new: (skip):
 **/
GByteArray *
fu_struct_efi_load_option_new(void)
{
    GByteArray *st = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st, 6, 0x0);
    return st;
}
/**
 * fu_struct_efi_load_option_to_string: (skip):
 **/
static gchar *
fu_struct_efi_load_option_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiLoadOption:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_load_option_attrs_to_string(fu_struct_efi_load_option_get_attrs(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  attrs: 0x%x [%s]\n", (guint) fu_struct_efi_load_option_get_attrs(st), tmp);
        } else {
            g_string_append_printf(str, "  attrs: 0x%x\n", (guint) fu_struct_efi_load_option_get_attrs(st));
        }
    }
    g_string_append_printf(str, "  dp_size: 0x%x\n",
                           (guint) fu_struct_efi_load_option_get_dp_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_load_option_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_load_option_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error(error, "invalid struct EfiLoadOption: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 6);
    str = fu_struct_efi_load_option_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_load_option_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_load_option_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_load_option_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_efi_device_path_get_type: (skip):
 **/
FuEfiDevicePathType
fu_struct_efi_device_path_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_efi_device_path_get_subtype: (skip):
 **/
guint8
fu_struct_efi_device_path_get_subtype(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_efi_device_path_get_length: (skip):
 **/
guint16
fu_struct_efi_device_path_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_efi_device_path_set_type: (skip):
 **/
void
fu_struct_efi_device_path_set_type(GByteArray *st, FuEfiDevicePathType value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_efi_device_path_set_subtype: (skip):
 **/
void
fu_struct_efi_device_path_set_subtype(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_efi_device_path_set_length: (skip):
 **/
void
fu_struct_efi_device_path_set_length(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_device_path_new: (skip):
 **/
GByteArray *
fu_struct_efi_device_path_new(void)
{
    GByteArray *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_efi_device_path_set_subtype(st, 0xFF);
    fu_struct_efi_device_path_set_length(st, 4);
    return st;
}
/**
 * fu_struct_efi_device_path_to_string: (skip):
 **/
static gchar *
fu_struct_efi_device_path_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiDevicePath:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_device_path_type_to_string(fu_struct_efi_device_path_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_efi_device_path_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_efi_device_path_get_type(st));
        }
    }
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_efi_device_path_get_subtype(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_efi_device_path_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_device_path_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_device_path_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 4, error)) {
        g_prefix_error(error, "invalid struct EfiDevicePath: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 4);
    str = fu_struct_efi_device_path_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_device_path_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_device_path_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_device_path_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_efi_hard_drive_device_path_get_type: (skip):
 **/
static FuEfiDevicePathType
fu_struct_efi_hard_drive_device_path_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_efi_hard_drive_device_path_get_subtype: (skip):
 **/
FuEfiHardDriveDevicePathSubtype
fu_struct_efi_hard_drive_device_path_get_subtype(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_efi_hard_drive_device_path_get_length: (skip):
 **/
static guint16
fu_struct_efi_hard_drive_device_path_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_number: (skip):
 **/
guint32
fu_struct_efi_hard_drive_device_path_get_partition_number(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_start: (skip):
 **/
guint64
fu_struct_efi_hard_drive_device_path_get_partition_start(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_size: (skip):
 **/
guint64
fu_struct_efi_hard_drive_device_path_get_partition_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_signature: (skip):
 **/
const fwupd_guid_t *
fu_struct_efi_hard_drive_device_path_get_partition_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return (const fwupd_guid_t *) (st->data + 24);
}
/**
 * fu_struct_efi_hard_drive_device_path_get_partition_format: (skip):
 **/
FuEfiHardDriveDevicePathPartitionFormat
fu_struct_efi_hard_drive_device_path_get_partition_format(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[40];
}
/**
 * fu_struct_efi_hard_drive_device_path_get_signature_type: (skip):
 **/
FuEfiHardDriveDevicePathSignatureType
fu_struct_efi_hard_drive_device_path_get_signature_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[41];
}

/* setters */
/**
 * fu_struct_efi_hard_drive_device_path_set_type: (skip):
 **/
static void
fu_struct_efi_hard_drive_device_path_set_type(GByteArray *st, FuEfiDevicePathType value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_set_subtype: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_subtype(GByteArray *st, FuEfiHardDriveDevicePathSubtype value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_set_length: (skip):
 **/
static void
fu_struct_efi_hard_drive_device_path_set_length(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_number: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_number(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_start: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_start(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_size: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_size(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_signature: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_signature(GByteArray *st, const fwupd_guid_t *value)
{
    g_return_if_fail(st != NULL);
    g_return_if_fail(value != NULL);
    memcpy(st->data + 24, value, sizeof(*value));
}
/**
 * fu_struct_efi_hard_drive_device_path_set_partition_format: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_partition_format(GByteArray *st, FuEfiHardDriveDevicePathPartitionFormat value)
{
    g_return_if_fail(st != NULL);
    st->data[40] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_set_signature_type: (skip):
 **/
void
fu_struct_efi_hard_drive_device_path_set_signature_type(GByteArray *st, FuEfiHardDriveDevicePathSignatureType value)
{
    g_return_if_fail(st != NULL);
    st->data[41] = value;
}
/**
 * fu_struct_efi_hard_drive_device_path_new: (skip):
 **/
GByteArray *
fu_struct_efi_hard_drive_device_path_new(void)
{
    GByteArray *st = g_byte_array_sized_new(42);
    fu_byte_array_set_size(st, 42, 0x0);
    fu_struct_efi_hard_drive_device_path_set_type(st, FU_EFI_DEVICE_PATH_TYPE_MEDIA);
    fu_struct_efi_hard_drive_device_path_set_subtype(st, FU_EFI_HARD_DRIVE_DEVICE_PATH_SUBTYPE_HARD_DRIVE);
    fu_struct_efi_hard_drive_device_path_set_length(st, 42);
    fu_struct_efi_hard_drive_device_path_set_partition_format(st, FU_EFI_HARD_DRIVE_DEVICE_PATH_PARTITION_FORMAT_GUID_PARTITION_TABLE);
    fu_struct_efi_hard_drive_device_path_set_signature_type(st, FU_EFI_HARD_DRIVE_DEVICE_PATH_SIGNATURE_TYPE_GUID);
    return st;
}
/**
 * fu_struct_efi_hard_drive_device_path_to_string: (skip):
 **/
static gchar *
fu_struct_efi_hard_drive_device_path_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EfiHardDriveDevicePath:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_efi_hard_drive_device_path_subtype_to_string(fu_struct_efi_hard_drive_device_path_get_subtype(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  subtype: 0x%x [%s]\n", (guint) fu_struct_efi_hard_drive_device_path_get_subtype(st), tmp);
        } else {
            g_string_append_printf(str, "  subtype: 0x%x\n", (guint) fu_struct_efi_hard_drive_device_path_get_subtype(st));
        }
    }
    g_string_append_printf(str, "  partition_number: 0x%x\n",
                           (guint) fu_struct_efi_hard_drive_device_path_get_partition_number(st));
    g_string_append_printf(str, "  partition_start: 0x%x\n",
                           (guint) fu_struct_efi_hard_drive_device_path_get_partition_start(st));
    g_string_append_printf(str, "  partition_size: 0x%x\n",
                           (guint) fu_struct_efi_hard_drive_device_path_get_partition_size(st));
    {
        g_autofree gchar *tmp = fwupd_guid_to_string(fu_struct_efi_hard_drive_device_path_get_partition_signature(st), FWUPD_GUID_FLAG_MIXED_ENDIAN);
        g_string_append_printf(str, "  partition_signature: %s\n", tmp);
    }
    {
        const gchar *tmp = fu_efi_hard_drive_device_path_partition_format_to_string(fu_struct_efi_hard_drive_device_path_get_partition_format(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  partition_format: 0x%x [%s]\n", (guint) fu_struct_efi_hard_drive_device_path_get_partition_format(st), tmp);
        } else {
            g_string_append_printf(str, "  partition_format: 0x%x\n", (guint) fu_struct_efi_hard_drive_device_path_get_partition_format(st));
        }
    }
    {
        const gchar *tmp = fu_efi_hard_drive_device_path_signature_type_to_string(fu_struct_efi_hard_drive_device_path_get_signature_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  signature_type: 0x%x [%s]\n", (guint) fu_struct_efi_hard_drive_device_path_get_signature_type(st), tmp);
        } else {
            g_string_append_printf(str, "  signature_type: 0x%x\n", (guint) fu_struct_efi_hard_drive_device_path_get_signature_type(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_efi_hard_drive_device_path_parse: (skip):
 **/
static GByteArray *
fu_struct_efi_hard_drive_device_path_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 42, error)) {
        g_prefix_error(error, "invalid struct EfiHardDriveDevicePath: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 42);
    if (fu_struct_efi_hard_drive_device_path_get_type(st) != FU_EFI_DEVICE_PATH_TYPE_MEDIA) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiHardDriveDevicePath.type was not valid, expected FU_EFI_DEVICE_PATH_TYPE_MEDIA");
        return NULL;
    }
    if (fu_struct_efi_hard_drive_device_path_get_length(st) != 42) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant EfiHardDriveDevicePath.length was not valid, expected 42");
        return NULL;
    }
    str = fu_struct_efi_hard_drive_device_path_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_efi_hard_drive_device_path_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_efi_hard_drive_device_path_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_efi_hard_drive_device_path_parse(buf, bufsz, offset, error);
}
