/* auto-generated, do not modify */
#include "config.h"

#include "fu-elf-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_elf_file_header_type_to_string(FuElfFileHeaderType val)
{
    if (val == FU_ELF_FILE_HEADER_TYPE_NONE)
        return "none";
    if (val == FU_ELF_FILE_HEADER_TYPE_REL)
        return "rel";
    if (val == FU_ELF_FILE_HEADER_TYPE_EXEC)
        return "exec";
    if (val == FU_ELF_FILE_HEADER_TYPE_DYN)
        return "dyn";
    if (val == FU_ELF_FILE_HEADER_TYPE_CORE)
        return "core";
    return NULL;
}

static const gchar *
fu_elf_section_header_type_to_string(FuElfSectionHeaderType val)
{
    if (val == FU_ELF_SECTION_HEADER_TYPE_NULL)
        return "null";
    if (val == FU_ELF_SECTION_HEADER_TYPE_PROGBITS)
        return "progbits";
    if (val == FU_ELF_SECTION_HEADER_TYPE_SYMTAB)
        return "symtab";
    if (val == FU_ELF_SECTION_HEADER_TYPE_STRTAB)
        return "strtab";
    if (val == FU_ELF_SECTION_HEADER_TYPE_RELA)
        return "rela";
    if (val == FU_ELF_SECTION_HEADER_TYPE_HASH)
        return "hash";
    if (val == FU_ELF_SECTION_HEADER_TYPE_DYNAMIC)
        return "dynamic";
    if (val == FU_ELF_SECTION_HEADER_TYPE_NOTE)
        return "note";
    if (val == FU_ELF_SECTION_HEADER_TYPE_NOBITS)
        return "nobits";
    if (val == FU_ELF_SECTION_HEADER_TYPE_REL)
        return "rel";
    if (val == FU_ELF_SECTION_HEADER_TYPE_SHLIB)
        return "shlib";
    if (val == FU_ELF_SECTION_HEADER_TYPE_DYNSYM)
        return "dynsym";
    if (val == FU_ELF_SECTION_HEADER_TYPE_INIT_ARRAY)
        return "init-array";
    if (val == FU_ELF_SECTION_HEADER_TYPE_FINI_ARRAY)
        return "fini-array";
    if (val == FU_ELF_SECTION_HEADER_TYPE_PREINIT_ARRAY)
        return "preinit-array";
    if (val == FU_ELF_SECTION_HEADER_TYPE_GROUP)
        return "group";
    if (val == FU_ELF_SECTION_HEADER_TYPE_SYMTAB_SHNDX)
        return "symtab-shndx";
    if (val == FU_ELF_SECTION_HEADER_TYPE_NUM)
        return "num";
    return NULL;
}
/* getters */
/**
 * fu_struct_elf_file_header64le_get_ei_class: (skip):
 **/
static guint8
fu_struct_elf_file_header64le_get_ei_class(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[4];
}
/**
 * fu_struct_elf_file_header64le_get_ei_data: (skip):
 **/
static guint8
fu_struct_elf_file_header64le_get_ei_data(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[5];
}
/**
 * fu_struct_elf_file_header64le_get_ei_version: (skip):
 **/
static guint8
fu_struct_elf_file_header64le_get_ei_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[6];
}
/**
 * fu_struct_elf_file_header64le_get_ei_osabi: (skip):
 **/
guint8
fu_struct_elf_file_header64le_get_ei_osabi(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[7];
}
/**
 * fu_struct_elf_file_header64le_get_ei_abiversion: (skip):
 **/
guint8
fu_struct_elf_file_header64le_get_ei_abiversion(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_elf_file_header64le_get_type: (skip):
 **/
FuElfFileHeaderType
fu_struct_elf_file_header64le_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_machine: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_machine(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_version: (skip):
 **/
static guint32
fu_struct_elf_file_header64le_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_entry: (skip):
 **/
guint64
fu_struct_elf_file_header64le_get_entry(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_phoff: (skip):
 **/
guint64
fu_struct_elf_file_header64le_get_phoff(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shoff: (skip):
 **/
guint64
fu_struct_elf_file_header64le_get_shoff(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_flags: (skip):
 **/
guint32
fu_struct_elf_file_header64le_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 48, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_ehsize: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_ehsize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 52, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_phentsize: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_phentsize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 54, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_phnum: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_phnum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 56, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shentsize: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_shentsize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 58, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shnum: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_shnum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 60, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_file_header64le_get_shstrndx: (skip):
 **/
guint16
fu_struct_elf_file_header64le_get_shstrndx(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 62, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_elf_file_header64le_to_string: (skip):
 **/
static gchar *
fu_struct_elf_file_header64le_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("ElfFileHeader64le:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  ei_osabi: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_ei_osabi(st));
    g_string_append_printf(str, "  ei_abiversion: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_ei_abiversion(st));
    {
        const gchar *tmp = fu_elf_file_header_type_to_string(fu_struct_elf_file_header64le_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_elf_file_header64le_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_elf_file_header64le_get_type(st));
        }
    }
    g_string_append_printf(str, "  machine: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_machine(st));
    g_string_append_printf(str, "  entry: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_entry(st));
    g_string_append_printf(str, "  phoff: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_phoff(st));
    g_string_append_printf(str, "  shoff: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shoff(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_flags(st));
    g_string_append_printf(str, "  ehsize: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_ehsize(st));
    g_string_append_printf(str, "  phentsize: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_phentsize(st));
    g_string_append_printf(str, "  phnum: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_phnum(st));
    g_string_append_printf(str, "  shentsize: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shentsize(st));
    g_string_append_printf(str, "  shnum: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shnum(st));
    g_string_append_printf(str, "  shstrndx: 0x%x\n",
                           (guint) fu_struct_elf_file_header64le_get_shstrndx(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_elf_file_header64le_parse: (skip):
 **/
static GByteArray *
fu_struct_elf_file_header64le_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct ElfFileHeader64le: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 64);
    if (strncmp((const gchar *) (st->data + 0), "\x7F\x45\x4C\x46", 4) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_magic was not valid, expected \x7F\x45\x4C\x46");
        return NULL;
    }
    if (fu_struct_elf_file_header64le_get_ei_class(st) != 0x2) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_class was not valid, expected 0x2");
        return NULL;
    }
    if (fu_struct_elf_file_header64le_get_ei_data(st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_data was not valid, expected 0x1");
        return NULL;
    }
    if (fu_struct_elf_file_header64le_get_ei_version(st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_version was not valid, expected 0x1");
        return NULL;
    }
    if (fu_struct_elf_file_header64le_get_version(st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.version was not valid, expected 0x1");
        return NULL;
    }
    str = fu_struct_elf_file_header64le_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elf_file_header64le_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_elf_file_header64le_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_elf_file_header64le_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_elf_file_header64le_validate: (skip):
 **/
static gboolean
fu_struct_elf_file_header64le_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct ElfFileHeader64le: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 0), "\x7F\x45\x4C\x46", 4) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_magic was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_ei_class(&st) != 0x2) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_class was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_ei_data(&st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_data was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_ei_version(&st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.ei_version was not valid");
        return FALSE;
    }
    if (fu_struct_elf_file_header64le_get_version(&st) != 0x1) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant ElfFileHeader64le.version was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_elf_file_header64le_validate_bytes: (skip):
 **/
gboolean
fu_struct_elf_file_header64le_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_elf_file_header64le_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_elf_program_header64le_get_flags: (skip):
 **/
guint32
fu_struct_elf_program_header64le_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_offset: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_vaddr: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_vaddr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_paddr: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_paddr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_filesz: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_filesz(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_memsz: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_memsz(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_flags2: (skip):
 **/
guint32
fu_struct_elf_program_header64le_get_flags2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_program_header64le_get_align: (skip):
 **/
guint64
fu_struct_elf_program_header64le_get_align(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 48, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_elf_program_header64le_to_string: (skip):
 **/
static gchar *
fu_struct_elf_program_header64le_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("ElfProgramHeader64le:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_flags(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_offset(st));
    g_string_append_printf(str, "  vaddr: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_vaddr(st));
    g_string_append_printf(str, "  paddr: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_paddr(st));
    g_string_append_printf(str, "  filesz: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_filesz(st));
    g_string_append_printf(str, "  memsz: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_memsz(st));
    g_string_append_printf(str, "  flags2: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_flags2(st));
    g_string_append_printf(str, "  align: 0x%x\n",
                           (guint) fu_struct_elf_program_header64le_get_align(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_elf_program_header64le_parse: (skip):
 **/
static GByteArray *
fu_struct_elf_program_header64le_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 56, error)) {
        g_prefix_error(error, "invalid struct ElfProgramHeader64le: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 56);
    str = fu_struct_elf_program_header64le_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elf_program_header64le_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_elf_program_header64le_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_elf_program_header64le_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_elf_section_header64le_get_name: (skip):
 **/
guint32
fu_struct_elf_section_header64le_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_type: (skip):
 **/
FuElfSectionHeaderType
fu_struct_elf_section_header64le_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_flags: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_addr: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_addr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_offset: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_size: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_link: (skip):
 **/
guint32
fu_struct_elf_section_header64le_get_link(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_info: (skip):
 **/
guint32
fu_struct_elf_section_header64le_get_info(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 44, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_addralign: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_addralign(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 48, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_elf_section_header64le_get_entsize: (skip):
 **/
guint64
fu_struct_elf_section_header64le_get_entsize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 56, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_elf_section_header64le_to_string: (skip):
 **/
static gchar *
fu_struct_elf_section_header64le_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("ElfSectionHeader64le:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  name: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_name(st));
    {
        const gchar *tmp = fu_elf_section_header_type_to_string(fu_struct_elf_section_header64le_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_elf_section_header64le_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_elf_section_header64le_get_type(st));
        }
    }
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_flags(st));
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_addr(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_offset(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_size(st));
    g_string_append_printf(str, "  link: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_link(st));
    g_string_append_printf(str, "  info: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_info(st));
    g_string_append_printf(str, "  addralign: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_addralign(st));
    g_string_append_printf(str, "  entsize: 0x%x\n",
                           (guint) fu_struct_elf_section_header64le_get_entsize(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_elf_section_header64le_parse: (skip):
 **/
static GByteArray *
fu_struct_elf_section_header64le_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 64, error)) {
        g_prefix_error(error, "invalid struct ElfSectionHeader64le: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 64);
    str = fu_struct_elf_section_header64le_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_elf_section_header64le_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_elf_section_header64le_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_elf_section_header64le_parse(buf, bufsz, offset, error);
}
