/* auto-generated, do not modify */
#include "config.h"

#include "fu-ifd-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_ifd_region_to_string(FuIfdRegion val)
{
    if (val == FU_IFD_REGION_DESC)
        return "desc";
    if (val == FU_IFD_REGION_BIOS)
        return "bios";
    if (val == FU_IFD_REGION_ME)
        return "me";
    if (val == FU_IFD_REGION_GBE)
        return "gbe";
    if (val == FU_IFD_REGION_PLATFORM)
        return "platform";
    if (val == FU_IFD_REGION_DEVEXP)
        return "devexp";
    if (val == FU_IFD_REGION_BIOS2)
        return "bios2";
    if (val == FU_IFD_REGION_EC)
        return "ec";
    if (val == FU_IFD_REGION_IE)
        return "ie";
    if (val == FU_IFD_REGION_10GBE)
        return "10gbe";
    if (val == FU_IFD_REGION_MAX)
        return "max";
    return NULL;
}
/* getters */
/**
 * fu_struct_ifd_fdbar_get_signature: (skip):
 **/
static guint32
fu_struct_ifd_fdbar_get_signature(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_get_descriptor_map0: (skip):
 **/
guint32
fu_struct_ifd_fdbar_get_descriptor_map0(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_get_descriptor_map1: (skip):
 **/
guint32
fu_struct_ifd_fdbar_get_descriptor_map1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_get_descriptor_map2: (skip):
 **/
guint32
fu_struct_ifd_fdbar_get_descriptor_map2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifd_fdbar_set_signature: (skip):
 **/
static void
fu_struct_ifd_fdbar_set_signature(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_set_descriptor_map0: (skip):
 **/
void
fu_struct_ifd_fdbar_set_descriptor_map0(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_set_descriptor_map1: (skip):
 **/
void
fu_struct_ifd_fdbar_set_descriptor_map1(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_set_descriptor_map2: (skip):
 **/
void
fu_struct_ifd_fdbar_set_descriptor_map2(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fdbar_new: (skip):
 **/
GByteArray *
fu_struct_ifd_fdbar_new(void)
{
    GByteArray *st = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st, 32, 0x0);
    memcpy(st->data + 0x0, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 16);
    fu_struct_ifd_fdbar_set_signature(st, 0x0FF0A55A);
    return st;
}
/**
 * fu_struct_ifd_fdbar_to_string: (skip):
 **/
static gchar *
fu_struct_ifd_fdbar_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfdFdbar:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  descriptor_map0: 0x%x\n",
                           (guint) fu_struct_ifd_fdbar_get_descriptor_map0(st));
    g_string_append_printf(str, "  descriptor_map1: 0x%x\n",
                           (guint) fu_struct_ifd_fdbar_get_descriptor_map1(st));
    g_string_append_printf(str, "  descriptor_map2: 0x%x\n",
                           (guint) fu_struct_ifd_fdbar_get_descriptor_map2(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifd_fdbar_parse: (skip):
 **/
static GByteArray *
fu_struct_ifd_fdbar_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct IfdFdbar: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 32);
    if (fu_struct_ifd_fdbar_get_signature(st) != 0x0FF0A55A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfdFdbar.signature was not valid, expected 0x0FF0A55A");
        return NULL;
    }
    str = fu_struct_ifd_fdbar_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifd_fdbar_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifd_fdbar_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifd_fdbar_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_ifd_fdbar_validate: (skip):
 **/
static gboolean
fu_struct_ifd_fdbar_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct IfdFdbar: ");
        return FALSE;
    }
    if (fu_struct_ifd_fdbar_get_signature(&st) != 0x0FF0A55A) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfdFdbar.signature was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ifd_fdbar_validate_bytes: (skip):
 **/
gboolean
fu_struct_ifd_fdbar_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifd_fdbar_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ifd_fcba_get_flcomp: (skip):
 **/
guint32
fu_struct_ifd_fcba_get_flcomp(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_get_flill: (skip):
 **/
guint32
fu_struct_ifd_fcba_get_flill(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_get_flill1: (skip):
 **/
guint32
fu_struct_ifd_fcba_get_flill1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifd_fcba_set_flcomp: (skip):
 **/
void
fu_struct_ifd_fcba_set_flcomp(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_set_flill: (skip):
 **/
void
fu_struct_ifd_fcba_set_flill(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_set_flill1: (skip):
 **/
void
fu_struct_ifd_fcba_set_flill1(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifd_fcba_new: (skip):
 **/
GByteArray *
fu_struct_ifd_fcba_new(void)
{
    GByteArray *st = g_byte_array_sized_new(12);
    fu_byte_array_set_size(st, 12, 0x0);
    return st;
}
/**
 * fu_struct_ifd_fcba_to_string: (skip):
 **/
static gchar *
fu_struct_ifd_fcba_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfdFcba:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  flcomp: 0x%x\n",
                           (guint) fu_struct_ifd_fcba_get_flcomp(st));
    g_string_append_printf(str, "  flill: 0x%x\n",
                           (guint) fu_struct_ifd_fcba_get_flill(st));
    g_string_append_printf(str, "  flill1: 0x%x\n",
                           (guint) fu_struct_ifd_fcba_get_flill1(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifd_fcba_parse: (skip):
 **/
static GByteArray *
fu_struct_ifd_fcba_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 12, error)) {
        g_prefix_error(error, "invalid struct IfdFcba: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 12);
    str = fu_struct_ifd_fcba_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifd_fcba_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifd_fcba_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifd_fcba_parse(buf, bufsz, offset, error);
}
