/* auto-generated, do not modify */
#include "config.h"

#include "fu-ifwi-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/* getters */
/**
 * fu_struct_ifwi_cpd_get_header_marker: (skip):
 **/
static guint32
fu_struct_ifwi_cpd_get_header_marker(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_get_num_of_entries: (skip):
 **/
guint32
fu_struct_ifwi_cpd_get_num_of_entries(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_get_header_version: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_header_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_ifwi_cpd_get_entry_version: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_entry_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_ifwi_cpd_get_header_length: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_header_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_ifwi_cpd_get_checksum: (skip):
 **/
guint8
fu_struct_ifwi_cpd_get_checksum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_ifwi_cpd_get_partition_name: (skip):
 **/
guint32
fu_struct_ifwi_cpd_get_partition_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_get_crc32: (skip):
 **/
guint32
fu_struct_ifwi_cpd_get_crc32(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_set_header_marker: (skip):
 **/
static void
fu_struct_ifwi_cpd_set_header_marker(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_set_num_of_entries: (skip):
 **/
void
fu_struct_ifwi_cpd_set_num_of_entries(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_set_header_version: (skip):
 **/
void
fu_struct_ifwi_cpd_set_header_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[8] = value;
}
/**
 * fu_struct_ifwi_cpd_set_entry_version: (skip):
 **/
void
fu_struct_ifwi_cpd_set_entry_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[9] = value;
}
/**
 * fu_struct_ifwi_cpd_set_header_length: (skip):
 **/
void
fu_struct_ifwi_cpd_set_header_length(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[10] = value;
}
/**
 * fu_struct_ifwi_cpd_set_checksum: (skip):
 **/
void
fu_struct_ifwi_cpd_set_checksum(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[11] = value;
}
/**
 * fu_struct_ifwi_cpd_set_partition_name: (skip):
 **/
void
fu_struct_ifwi_cpd_set_partition_name(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_set_crc32: (skip):
 **/
void
fu_struct_ifwi_cpd_set_crc32(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_new: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_new(void)
{
    GByteArray *st = g_byte_array_sized_new(20);
    fu_byte_array_set_size(st, 20, 0x0);
    fu_struct_ifwi_cpd_set_header_marker(st, 0x44504324);
    fu_struct_ifwi_cpd_set_header_length(st, 20);
    return st;
}
/**
 * fu_struct_ifwi_cpd_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfwiCpd:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  num_of_entries: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_num_of_entries(st));
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_header_version(st));
    g_string_append_printf(str, "  entry_version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_entry_version(st));
    g_string_append_printf(str, "  header_length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_header_length(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_checksum(st));
    g_string_append_printf(str, "  partition_name: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_partition_name(st));
    g_string_append_printf(str, "  crc32: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_get_crc32(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifwi_cpd_parse: (skip):
 **/
static GByteArray *
fu_struct_ifwi_cpd_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error(error, "invalid struct IfwiCpd: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 20);
    if (fu_struct_ifwi_cpd_get_header_marker(st) != 0x44504324) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfwiCpd.header_marker was not valid, expected 0x44504324");
        return NULL;
    }
    str = fu_struct_ifwi_cpd_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_cpd_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_ifwi_cpd_validate: (skip):
 **/
static gboolean
fu_struct_ifwi_cpd_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 20, error)) {
        g_prefix_error(error, "invalid struct IfwiCpd: ");
        return FALSE;
    }
    if (fu_struct_ifwi_cpd_get_header_marker(&st) != 0x44504324) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfwiCpd.header_marker was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ifwi_cpd_validate_bytes: (skip):
 **/
gboolean
fu_struct_ifwi_cpd_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_cpd_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ifwi_cpd_entry_get_name: (skip):
 **/
gchar *
fu_struct_ifwi_cpd_entry_get_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 12, NULL);
}
/**
 * fu_struct_ifwi_cpd_entry_get_offset: (skip):
 **/
guint32
fu_struct_ifwi_cpd_entry_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_entry_get_length: (skip):
 **/
guint32
fu_struct_ifwi_cpd_entry_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_entry_set_name: (skip):
 **/
gboolean
fu_struct_ifwi_cpd_entry_set_name(GByteArray *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->data + 0, 0x0, 12);
        return TRUE;
    }
    len = strlen(value);
    if (len > 12) {
        g_set_error(error,
                    G_IO_ERROR,
                    G_IO_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in IfwiCpdEntry.name (0x%x bytes)",
                    value, (guint) len, (guint) 12);
        return FALSE;
    }
    return fu_memcpy_safe(st->data, st->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_ifwi_cpd_entry_set_offset: (skip):
 **/
void
fu_struct_ifwi_cpd_entry_set_offset(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_entry_set_length: (skip):
 **/
void
fu_struct_ifwi_cpd_entry_set_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_entry_new: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_entry_new(void)
{
    GByteArray *st = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st, 24, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_cpd_entry_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_entry_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfwiCpdEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autofree gchar *tmp = fu_struct_ifwi_cpd_entry_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_entry_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_entry_get_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifwi_cpd_entry_parse: (skip):
 **/
static GByteArray *
fu_struct_ifwi_cpd_entry_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error(error, "invalid struct IfwiCpdEntry: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 24);
    str = fu_struct_ifwi_cpd_entry_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_entry_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_entry_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_cpd_entry_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ifwi_cpd_manifest_get_header_type: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_header_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_header_length: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_header_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_header_version: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_header_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_flags: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_vendor: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_vendor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_date: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_date(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_size: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_id: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_rsvd: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_rsvd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 32, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_version: (skip):
 **/
guint64
fu_struct_ifwi_cpd_manifest_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_get_svn: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_get_svn(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 44, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_manifest_set_header_type: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_header_type(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_header_length: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_header_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_header_version: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_header_version(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_flags: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_flags(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_vendor: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_vendor(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_date: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_date(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_size: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_id: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_id(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_rsvd: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_rsvd(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 32, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_version: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_version(GByteArray *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->data + 36, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_set_svn: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_set_svn(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 44, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_new: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_manifest_new(void)
{
    GByteArray *st = g_byte_array_sized_new(48);
    fu_byte_array_set_size(st, 48, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_cpd_manifest_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_manifest_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfwiCpdManifest:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  header_type: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_header_type(st));
    g_string_append_printf(str, "  header_length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_header_length(st));
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_header_version(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_flags(st));
    g_string_append_printf(str, "  vendor: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_vendor(st));
    g_string_append_printf(str, "  date: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_date(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_size(st));
    g_string_append_printf(str, "  id: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_id(st));
    g_string_append_printf(str, "  rsvd: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_rsvd(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_version(st));
    g_string_append_printf(str, "  svn: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_get_svn(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifwi_cpd_manifest_parse: (skip):
 **/
static GByteArray *
fu_struct_ifwi_cpd_manifest_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 48, error)) {
        g_prefix_error(error, "invalid struct IfwiCpdManifest: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 48);
    str = fu_struct_ifwi_cpd_manifest_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_manifest_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_manifest_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_cpd_manifest_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ifwi_cpd_manifest_ext_get_extension_type: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_ext_get_extension_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_get_extension_length: (skip):
 **/
guint32
fu_struct_ifwi_cpd_manifest_ext_get_extension_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_cpd_manifest_ext_set_extension_type: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_ext_set_extension_type(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_set_extension_length: (skip):
 **/
void
fu_struct_ifwi_cpd_manifest_ext_set_extension_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_new: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_manifest_ext_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_cpd_manifest_ext_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfwiCpdManifestExt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  extension_type: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_ext_get_extension_type(st));
    g_string_append_printf(str, "  extension_length: 0x%x\n",
                           (guint) fu_struct_ifwi_cpd_manifest_ext_get_extension_length(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_parse: (skip):
 **/
static GByteArray *
fu_struct_ifwi_cpd_manifest_ext_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct IfwiCpdManifestExt: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_ifwi_cpd_manifest_ext_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_cpd_manifest_ext_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifwi_cpd_manifest_ext_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_cpd_manifest_ext_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ifwi_fpt_get_header_marker: (skip):
 **/
static guint32
fu_struct_ifwi_fpt_get_header_marker(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_num_of_entries: (skip):
 **/
guint32
fu_struct_ifwi_fpt_get_num_of_entries(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_header_version: (skip):
 **/
guint8
fu_struct_ifwi_fpt_get_header_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}
/**
 * fu_struct_ifwi_fpt_get_entry_version: (skip):
 **/
static guint8
fu_struct_ifwi_fpt_get_entry_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[9];
}
/**
 * fu_struct_ifwi_fpt_get_header_length: (skip):
 **/
guint8
fu_struct_ifwi_fpt_get_header_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[10];
}
/**
 * fu_struct_ifwi_fpt_get_flags: (skip):
 **/
guint8
fu_struct_ifwi_fpt_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[11];
}
/**
 * fu_struct_ifwi_fpt_get_ticks_to_add: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_ticks_to_add(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_tokens_to_add: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_tokens_to_add(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_uma_size: (skip):
 **/
guint32
fu_struct_ifwi_fpt_get_uma_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_crc32: (skip):
 **/
guint32
fu_struct_ifwi_fpt_get_crc32(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_major: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_major(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 24, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_minor: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_minor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 26, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_hotfix: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_hotfix(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_get_fitc_build: (skip):
 **/
guint16
fu_struct_ifwi_fpt_get_fitc_build(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 30, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_fpt_set_header_marker: (skip):
 **/
static void
fu_struct_ifwi_fpt_set_header_marker(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_num_of_entries: (skip):
 **/
void
fu_struct_ifwi_fpt_set_num_of_entries(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_header_version: (skip):
 **/
void
fu_struct_ifwi_fpt_set_header_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[8] = value;
}
/**
 * fu_struct_ifwi_fpt_set_entry_version: (skip):
 **/
static void
fu_struct_ifwi_fpt_set_entry_version(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[9] = value;
}
/**
 * fu_struct_ifwi_fpt_set_header_length: (skip):
 **/
void
fu_struct_ifwi_fpt_set_header_length(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[10] = value;
}
/**
 * fu_struct_ifwi_fpt_set_flags: (skip):
 **/
void
fu_struct_ifwi_fpt_set_flags(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[11] = value;
}
/**
 * fu_struct_ifwi_fpt_set_ticks_to_add: (skip):
 **/
void
fu_struct_ifwi_fpt_set_ticks_to_add(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_tokens_to_add: (skip):
 **/
void
fu_struct_ifwi_fpt_set_tokens_to_add(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 14, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_uma_size: (skip):
 **/
void
fu_struct_ifwi_fpt_set_uma_size(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 16, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_crc32: (skip):
 **/
void
fu_struct_ifwi_fpt_set_crc32(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 20, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_major: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_major(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 24, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_minor: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_minor(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 26, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_hotfix: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_hotfix(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_set_fitc_build: (skip):
 **/
void
fu_struct_ifwi_fpt_set_fitc_build(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 30, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_new: (skip):
 **/
GByteArray *
fu_struct_ifwi_fpt_new(void)
{
    GByteArray *st = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st, 32, 0x0);
    fu_struct_ifwi_fpt_set_header_marker(st, 0x54504624);
    fu_struct_ifwi_fpt_set_header_version(st, 0x20);
    fu_struct_ifwi_fpt_set_entry_version(st, 0x10);
    fu_struct_ifwi_fpt_set_header_length(st, 32);
    return st;
}
/**
 * fu_struct_ifwi_fpt_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_fpt_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfwiFpt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  num_of_entries: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_num_of_entries(st));
    g_string_append_printf(str, "  header_version: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_header_version(st));
    g_string_append_printf(str, "  header_length: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_header_length(st));
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_flags(st));
    g_string_append_printf(str, "  ticks_to_add: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_ticks_to_add(st));
    g_string_append_printf(str, "  tokens_to_add: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_tokens_to_add(st));
    g_string_append_printf(str, "  uma_size: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_uma_size(st));
    g_string_append_printf(str, "  crc32: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_crc32(st));
    g_string_append_printf(str, "  fitc_major: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_major(st));
    g_string_append_printf(str, "  fitc_minor: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_minor(st));
    g_string_append_printf(str, "  fitc_hotfix: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_hotfix(st));
    g_string_append_printf(str, "  fitc_build: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_get_fitc_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifwi_fpt_parse: (skip):
 **/
static GByteArray *
fu_struct_ifwi_fpt_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct IfwiFpt: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 32);
    if (fu_struct_ifwi_fpt_get_header_marker(st) != 0x54504624) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfwiFpt.header_marker was not valid, expected 0x54504624");
        return NULL;
    }
    if (fu_struct_ifwi_fpt_get_entry_version(st) != 0x10) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfwiFpt.entry_version was not valid, expected 0x10");
        return NULL;
    }
    str = fu_struct_ifwi_fpt_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_fpt_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifwi_fpt_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_fpt_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_ifwi_fpt_validate: (skip):
 **/
static gboolean
fu_struct_ifwi_fpt_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct IfwiFpt: ");
        return FALSE;
    }
    if (fu_struct_ifwi_fpt_get_header_marker(&st) != 0x54504624) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfwiFpt.header_marker was not valid");
        return FALSE;
    }
    if (fu_struct_ifwi_fpt_get_entry_version(&st) != 0x10) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant IfwiFpt.entry_version was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ifwi_fpt_validate_bytes: (skip):
 **/
gboolean
fu_struct_ifwi_fpt_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_fpt_validate(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ifwi_fpt_entry_get_partition_name: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_partition_name(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_get_offset: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_get_length: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_length(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_get_partition_type: (skip):
 **/
guint32
fu_struct_ifwi_fpt_entry_get_partition_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ifwi_fpt_entry_set_partition_name: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_partition_name(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_set_offset: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_offset(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_set_length: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_length(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_set_partition_type: (skip):
 **/
void
fu_struct_ifwi_fpt_entry_set_partition_type(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 28, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ifwi_fpt_entry_new: (skip):
 **/
GByteArray *
fu_struct_ifwi_fpt_entry_new(void)
{
    GByteArray *st = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st, 32, 0x0);
    return st;
}
/**
 * fu_struct_ifwi_fpt_entry_to_string: (skip):
 **/
static gchar *
fu_struct_ifwi_fpt_entry_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("IfwiFptEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  partition_name: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_partition_name(st));
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_offset(st));
    g_string_append_printf(str, "  length: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_length(st));
    g_string_append_printf(str, "  partition_type: 0x%x\n",
                           (guint) fu_struct_ifwi_fpt_entry_get_partition_type(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ifwi_fpt_entry_parse: (skip):
 **/
static GByteArray *
fu_struct_ifwi_fpt_entry_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error(error, "invalid struct IfwiFptEntry: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 32);
    str = fu_struct_ifwi_fpt_entry_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ifwi_fpt_entry_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ifwi_fpt_entry_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ifwi_fpt_entry_parse(buf, bufsz, offset, error);
}
