/*
 * Copyright (C) 2021 Richard Hughes <richard@hughsie.com>
 *
 * SPDX-License-Identifier: LGPL-2.1+
 */

#pragma once

#include <glib.h>

/* clang-format off */
/**
 * FU_MAJOR_VERSION:
 *
 * The compile-time major version
 */
#define FU_MAJOR_VERSION 1

/**
 * FU_MINOR_VERSION:
 *
 * The compile-time minor version
 */
#define FU_MINOR_VERSION 9

/**
 * FU_MICRO_VERSION:
 *
 * The compile-time micro version
 */
#define FU_MICRO_VERSION 18
/* clang-format on */

/**
 * FU_CHECK_VERSION:
 * @major: Major version number
 * @minor: Minor version number
 * @micro: Micro version number
 *
 * Check whether a fwupd version equal to or greater than
 * major.minor.micro.
 *
 * These compile time macros allow the user to enable parts of client code
 * depending on the version of libfwupd installed.
 */
#define FU_CHECK_VERSION(major, minor, micro)                                             \
	(FU_MAJOR_VERSION > major ||                                                      \
	 (FU_MAJOR_VERSION == major && FU_MINOR_VERSION > minor) ||              \
	 (FU_MAJOR_VERSION == major && FU_MINOR_VERSION == minor &&              \
	  FU_MICRO_VERSION >= micro))

const gchar *
fu_version_string(void);
