/* auto-generated, do not modify */
#include "config.h"

#include "fu-dfu-csr-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


/* getters */
/**
 * fu_struct_dfu_csr_file_get_file_version: (skip):
 **/
static guint16
fu_struct_dfu_csr_file_get_file_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_csr_file_get_file_len: (skip):
 **/
guint32
fu_struct_dfu_csr_file_get_file_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_csr_file_get_file_hdr_len: (skip):
 **/
guint16
fu_struct_dfu_csr_file_get_file_hdr_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_dfu_csr_file_to_string: (skip):
 **/
static gchar *
fu_struct_dfu_csr_file_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("DfuCsrFile:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  file_len: 0x%x\n",
                           (guint) fu_struct_dfu_csr_file_get_file_len(st));
    g_string_append_printf(str, "  file_hdr_len: 0x%x\n",
                           (guint) fu_struct_dfu_csr_file_get_file_hdr_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_dfu_csr_file_parse: (skip):
 **/
static GByteArray *
fu_struct_dfu_csr_file_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct DfuCsrFile: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    if (strncmp((const gchar *) (st->data + 0), "CSR-dfu2", 8) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuCsrFile.file_id was not valid, expected CSR-dfu2");
        return NULL;
    }
    if (fu_struct_dfu_csr_file_get_file_version(st) != 0x02) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuCsrFile.file_version was not valid, expected 0x02");
        return NULL;
    }
    str = fu_struct_dfu_csr_file_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_dfu_csr_file_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_dfu_csr_file_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_dfu_csr_file_parse(buf, bufsz, offset, error);
}
/**
 * fu_struct_dfu_csr_file_validate: (skip):
 **/
static gboolean
fu_struct_dfu_csr_file_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct DfuCsrFile: ");
        return FALSE;
    }
    if (strncmp((const gchar *) (st.data + 0), "CSR-dfu2", 8) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuCsrFile.file_id was not valid");
        return FALSE;
    }
    if (fu_struct_dfu_csr_file_get_file_version(&st) != 0x02) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant DfuCsrFile.file_version was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_dfu_csr_file_validate_bytes: (skip):
 **/
gboolean
fu_struct_dfu_csr_file_validate_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_dfu_csr_file_validate(buf, bufsz, offset, error);
}
/* getters */

/* setters */
/**
 * fu_struct_dfu_csr_command_header_set_report_id: (skip):
 **/
void
fu_struct_dfu_csr_command_header_set_report_id(GByteArray *st, FuDfuCsrReportId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_dfu_csr_command_header_set_command: (skip):
 **/
void
fu_struct_dfu_csr_command_header_set_command(GByteArray *st, FuDfuCsrCommand value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_dfu_csr_command_header_set_idx: (skip):
 **/
void
fu_struct_dfu_csr_command_header_set_idx(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_csr_command_header_set_chunk_sz: (skip):
 **/
void
fu_struct_dfu_csr_command_header_set_chunk_sz(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_dfu_csr_command_header_new: (skip):
 **/
GByteArray *
fu_struct_dfu_csr_command_header_new(void)
{
    GByteArray *st = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st, 6, 0x0);
    return st;
}
