/* auto-generated, do not modify */
#include "config.h"

#include "fu-ebitdo-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_ebitdo_pkt_type_to_string(FuEbitdoPktType val)
{
    if (val == FU_EBITDO_PKT_TYPE_USER_CMD)
        return "user-cmd";
    if (val == FU_EBITDO_PKT_TYPE_USER_DATA)
        return "user-data";
    if (val == FU_EBITDO_PKT_TYPE_MID_CMD)
        return "mid-cmd";
    return NULL;
}

const gchar *
fu_ebitdo_pkt_cmd_to_string(FuEbitdoPktCmd val)
{
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_DATA)
        return "fw-update-data";
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_HEADER)
        return "fw-update-header";
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_OK)
        return "fw-update-ok";
    if (val == FU_EBITDO_PKT_CMD_FW_UPDATE_ERROR)
        return "fw-update-error";
    if (val == FU_EBITDO_PKT_CMD_FW_GET_VERSION)
        return "fw-get-version";
    if (val == FU_EBITDO_PKT_CMD_FW_SET_VERSION)
        return "fw-set-version";
    if (val == FU_EBITDO_PKT_CMD_FW_SET_ENCODE_ID)
        return "fw-set-encode-id";
    if (val == FU_EBITDO_PKT_CMD_ACK)
        return "ack";
    if (val == FU_EBITDO_PKT_CMD_NAK)
        return "nak";
    if (val == FU_EBITDO_PKT_CMD_UPDATE_FIRMWARE_DATA)
        return "update-firmware-data";
    if (val == FU_EBITDO_PKT_CMD_TRANSFER_ABORT)
        return "transfer-abort";
    if (val == FU_EBITDO_PKT_CMD_VERIFICATION_ID)
        return "verification-id";
    if (val == FU_EBITDO_PKT_CMD_GET_VERIFICATION_ID)
        return "get-verification-id";
    if (val == FU_EBITDO_PKT_CMD_VERIFY_ERROR)
        return "verify-error";
    if (val == FU_EBITDO_PKT_CMD_VERIFY_OK)
        return "verify-ok";
    if (val == FU_EBITDO_PKT_CMD_TRANSFER_TIMEOUT)
        return "transfer-timeout";
    if (val == FU_EBITDO_PKT_CMD_GET_VERSION)
        return "get-version";
    if (val == FU_EBITDO_PKT_CMD_GET_VERSION_RESPONSE)
        return "get-version-response";
    return NULL;
}
/* getters */
/**
 * fu_struct_ebitdo_hdr_get_version: (skip):
 **/
guint32
fu_struct_ebitdo_hdr_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_get_destination_addr: (skip):
 **/
guint32
fu_struct_ebitdo_hdr_get_destination_addr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_get_destination_len: (skip):
 **/
guint32
fu_struct_ebitdo_hdr_get_destination_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ebitdo_hdr_set_version: (skip):
 **/
void
fu_struct_ebitdo_hdr_set_version(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_set_destination_addr: (skip):
 **/
void
fu_struct_ebitdo_hdr_set_destination_addr(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_set_destination_len: (skip):
 **/
void
fu_struct_ebitdo_hdr_set_destination_len(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_hdr_new: (skip):
 **/
GByteArray *
fu_struct_ebitdo_hdr_new(void)
{
    GByteArray *st = g_byte_array_sized_new(28);
    fu_byte_array_set_size(st, 28, 0x0);
    return st;
}
/**
 * fu_struct_ebitdo_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_ebitdo_hdr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EbitdoHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_ebitdo_hdr_get_version(st));
    g_string_append_printf(str, "  destination_addr: 0x%x\n",
                           (guint) fu_struct_ebitdo_hdr_get_destination_addr(st));
    g_string_append_printf(str, "  destination_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_hdr_get_destination_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ebitdo_hdr_parse: (skip):
 **/
static GByteArray *
fu_struct_ebitdo_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error(error, "invalid struct EbitdoHdr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 28);
    str = fu_struct_ebitdo_hdr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ebitdo_hdr_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_ebitdo_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_ebitdo_hdr_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_ebitdo_pkt_get_pkt_len: (skip):
 **/
guint8
fu_struct_ebitdo_pkt_get_pkt_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_ebitdo_pkt_get_type: (skip):
 **/
FuEbitdoPktType
fu_struct_ebitdo_pkt_get_type(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_ebitdo_pkt_get_subtype: (skip):
 **/
guint8
fu_struct_ebitdo_pkt_get_subtype(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_ebitdo_pkt_get_cmd_len: (skip):
 **/
guint16
fu_struct_ebitdo_pkt_get_cmd_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_pkt_get_cmd: (skip):
 **/
FuEbitdoPktCmd
fu_struct_ebitdo_pkt_get_cmd(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[5];
}
/**
 * fu_struct_ebitdo_pkt_get_payload_len: (skip):
 **/
guint16
fu_struct_ebitdo_pkt_get_payload_len(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_ebitdo_pkt_set_pkt_len: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_pkt_len(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_type: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_type(GByteArray *st, FuEbitdoPktType value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_subtype: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_subtype(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_cmd_len: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_cmd_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_pkt_set_cmd: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_cmd(GByteArray *st, FuEbitdoPktCmd value)
{
    g_return_if_fail(st != NULL);
    st->data[5] = value;
}
/**
 * fu_struct_ebitdo_pkt_set_payload_len: (skip):
 **/
void
fu_struct_ebitdo_pkt_set_payload_len(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ebitdo_pkt_new: (skip):
 **/
GByteArray *
fu_struct_ebitdo_pkt_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    return st;
}
/**
 * fu_struct_ebitdo_pkt_to_string: (skip):
 **/
static gchar *
fu_struct_ebitdo_pkt_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("EbitdoPkt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  pkt_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_pkt_len(st));
    {
        const gchar *tmp = fu_ebitdo_pkt_type_to_string(fu_struct_ebitdo_pkt_get_type(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  type: 0x%x [%s]\n", (guint) fu_struct_ebitdo_pkt_get_type(st), tmp);
        } else {
            g_string_append_printf(str, "  type: 0x%x\n", (guint) fu_struct_ebitdo_pkt_get_type(st));
        }
    }
    g_string_append_printf(str, "  subtype: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_subtype(st));
    g_string_append_printf(str, "  cmd_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_cmd_len(st));
    {
        const gchar *tmp = fu_ebitdo_pkt_cmd_to_string(fu_struct_ebitdo_pkt_get_cmd(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  cmd: 0x%x [%s]\n", (guint) fu_struct_ebitdo_pkt_get_cmd(st), tmp);
        } else {
            g_string_append_printf(str, "  cmd: 0x%x\n", (guint) fu_struct_ebitdo_pkt_get_cmd(st));
        }
    }
    g_string_append_printf(str, "  payload_len: 0x%x\n",
                           (guint) fu_struct_ebitdo_pkt_get_payload_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_ebitdo_pkt_parse: (skip):
 **/
GByteArray *
fu_struct_ebitdo_pkt_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct EbitdoPkt: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_ebitdo_pkt_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
