/* auto-generated, do not modify */
#include "config.h"

#include "fu-synaprom-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_synaprom_firmware_tag_to_string(FuSynapromFirmwareTag val)
{
    if (val == FU_SYNAPROM_FIRMWARE_TAG_MFW_UPDATE_HEADER)
        return "mfw-update-header";
    if (val == FU_SYNAPROM_FIRMWARE_TAG_MFW_UPDATE_PAYLOAD)
        return "mfw-update-payload";
    if (val == FU_SYNAPROM_FIRMWARE_TAG_CFG_UPDATE_HEADER)
        return "cfg-update-header";
    if (val == FU_SYNAPROM_FIRMWARE_TAG_CFG_UPDATE_PAYLOAD)
        return "cfg-update-payload";
    return NULL;
}
/* getters */
/**
 * fu_struct_synaprom_mfw_hdr_get_product: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_product(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_id: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_id(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_buildtime: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_buildtime(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_buildnum: (skip):
 **/
guint32
fu_struct_synaprom_mfw_hdr_get_buildnum(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_get_vmajor: (skip):
 **/
guint8
fu_struct_synaprom_mfw_hdr_get_vmajor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[16];
}
/**
 * fu_struct_synaprom_mfw_hdr_get_vminor: (skip):
 **/
guint8
fu_struct_synaprom_mfw_hdr_get_vminor(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[17];
}
/**
 * fu_struct_synaprom_mfw_hdr_get_unused: (skip):
 **/
const guint8 *
fu_struct_synaprom_mfw_hdr_get_unused(const GByteArray *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->data + 18;
}

/* setters */
/**
 * fu_struct_synaprom_mfw_hdr_set_product: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_product(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_id: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_id(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_buildtime: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_buildtime(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_buildnum: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_buildnum(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_mfw_hdr_set_vmajor: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_vmajor(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[16] = value;
}
/**
 * fu_struct_synaprom_mfw_hdr_set_vminor: (skip):
 **/
void
fu_struct_synaprom_mfw_hdr_set_vminor(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[17] = value;
}
/**
 * fu_struct_synaprom_mfw_hdr_set_unused: (skip):
 **/
gboolean
fu_struct_synaprom_mfw_hdr_set_unused(GByteArray *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 18, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_synaprom_mfw_hdr_new: (skip):
 **/
GByteArray *
fu_struct_synaprom_mfw_hdr_new(void)
{
    GByteArray *st = g_byte_array_sized_new(24);
    fu_byte_array_set_size(st, 24, 0x0);
    fu_struct_synaprom_mfw_hdr_set_id(st, 0xFF);
    fu_struct_synaprom_mfw_hdr_set_buildtime(st, 0xFF);
    fu_struct_synaprom_mfw_hdr_set_buildnum(st, 0xFF);
    fu_struct_synaprom_mfw_hdr_set_vmajor(st, 10);
    fu_struct_synaprom_mfw_hdr_set_vminor(st, 1);
    return st;
}
/**
 * fu_struct_synaprom_mfw_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_mfw_hdr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapromMfwHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  product: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_product(st));
    g_string_append_printf(str, "  id: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_id(st));
    g_string_append_printf(str, "  buildtime: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_buildtime(st));
    g_string_append_printf(str, "  buildnum: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_buildnum(st));
    g_string_append_printf(str, "  vmajor: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_vmajor(st));
    g_string_append_printf(str, "  vminor: 0x%x\n",
                           (guint) fu_struct_synaprom_mfw_hdr_get_vminor(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_synaprom_mfw_hdr_get_unused(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  unused: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaprom_mfw_hdr_parse: (skip):
 **/
GByteArray *
fu_struct_synaprom_mfw_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 24, error)) {
        g_prefix_error(error, "invalid struct SynapromMfwHdr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 24);
    str = fu_struct_synaprom_mfw_hdr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaprom_hdr_get_tag: (skip):
 **/
FuSynapromFirmwareTag
fu_struct_synaprom_hdr_get_tag(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_hdr_get_bufsz: (skip):
 **/
guint32
fu_struct_synaprom_hdr_get_bufsz(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_hdr_set_tag: (skip):
 **/
void
fu_struct_synaprom_hdr_set_tag(GByteArray *st, FuSynapromFirmwareTag value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_hdr_set_bufsz: (skip):
 **/
void
fu_struct_synaprom_hdr_set_bufsz(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_hdr_new: (skip):
 **/
GByteArray *
fu_struct_synaprom_hdr_new(void)
{
    GByteArray *st = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st, 6, 0x0);
    return st;
}
/**
 * fu_struct_synaprom_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_hdr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapromHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_synaprom_firmware_tag_to_string(fu_struct_synaprom_hdr_get_tag(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  tag: 0x%x [%s]\n", (guint) fu_struct_synaprom_hdr_get_tag(st), tmp);
        } else {
            g_string_append_printf(str, "  tag: 0x%x\n", (guint) fu_struct_synaprom_hdr_get_tag(st));
        }
    }
    g_string_append_printf(str, "  bufsz: 0x%x\n",
                           (guint) fu_struct_synaprom_hdr_get_bufsz(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaprom_hdr_parse: (skip):
 **/
GByteArray *
fu_struct_synaprom_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error(error, "invalid struct SynapromHdr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 6);
    str = fu_struct_synaprom_hdr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaprom_cfg_hdr_get_product: (skip):
 **/
guint32
fu_struct_synaprom_cfg_hdr_get_product(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cfg_hdr_get_id1: (skip):
 **/
guint32
fu_struct_synaprom_cfg_hdr_get_id1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cfg_hdr_get_id2: (skip):
 **/
guint32
fu_struct_synaprom_cfg_hdr_get_id2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cfg_hdr_get_version: (skip):
 **/
guint16
fu_struct_synaprom_cfg_hdr_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_cfg_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_cfg_hdr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapromCfgHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  product: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_product(st));
    g_string_append_printf(str, "  id1: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_id1(st));
    g_string_append_printf(str, "  id2: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_id2(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_synaprom_cfg_hdr_get_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaprom_cfg_hdr_parse: (skip):
 **/
static GByteArray *
fu_struct_synaprom_cfg_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct SynapromCfgHdr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_synaprom_cfg_hdr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/**
 * fu_struct_synaprom_cfg_hdr_parse_bytes: (skip):
 **/
GByteArray *
fu_struct_synaprom_cfg_hdr_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_synaprom_cfg_hdr_parse(buf, bufsz, offset, error);
}
/* getters */
/**
 * fu_struct_synaprom_iota_config_version_get_config_id1: (skip):
 **/
guint32
fu_struct_synaprom_iota_config_version_get_config_id1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_iota_config_version_get_config_id2: (skip):
 **/
guint32
fu_struct_synaprom_iota_config_version_get_config_id2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_iota_config_version_get_version: (skip):
 **/
guint16
fu_struct_synaprom_iota_config_version_get_version(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_iota_config_version_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_iota_config_version_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapromIotaConfigVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  config_id1: 0x%x\n",
                           (guint) fu_struct_synaprom_iota_config_version_get_config_id1(st));
    g_string_append_printf(str, "  config_id2: 0x%x\n",
                           (guint) fu_struct_synaprom_iota_config_version_get_config_id2(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_synaprom_iota_config_version_get_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaprom_iota_config_version_parse: (skip):
 **/
GByteArray *
fu_struct_synaprom_iota_config_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error(error, "invalid struct SynapromIotaConfigVersion: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    str = fu_struct_synaprom_iota_config_version_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_status: (skip):
 **/
guint16
fu_struct_synaprom_reply_iota_find_hdr_get_status(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_fullsize: (skip):
 **/
guint32
fu_struct_synaprom_reply_iota_find_hdr_get_fullsize(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_nbytes: (skip):
 **/
guint16
fu_struct_synaprom_reply_iota_find_hdr_get_nbytes(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 6, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_get_itype: (skip):
 **/
guint16
fu_struct_synaprom_reply_iota_find_hdr_get_itype(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 8, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_reply_iota_find_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_synaprom_reply_iota_find_hdr_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("SynapromReplyIotaFindHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  status: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_status(st));
    g_string_append_printf(str, "  fullsize: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_fullsize(st));
    g_string_append_printf(str, "  nbytes: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_nbytes(st));
    g_string_append_printf(str, "  itype: 0x%x\n",
                           (guint) fu_struct_synaprom_reply_iota_find_hdr_get_itype(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_synaprom_reply_iota_find_hdr_parse: (skip):
 **/
GByteArray *
fu_struct_synaprom_reply_iota_find_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 10, error)) {
        g_prefix_error(error, "invalid struct SynapromReplyIotaFindHdr: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 10);
    str = fu_struct_synaprom_reply_iota_find_hdr_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_synaprom_cmd_iota_find_get_itype: (skip):
 **/
guint16
fu_struct_synaprom_cmd_iota_find_get_itype(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_flags: (skip):
 **/
guint16
fu_struct_synaprom_cmd_iota_find_get_flags(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_maxniotas: (skip):
 **/
guint8
fu_struct_synaprom_cmd_iota_find_get_maxniotas(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[4];
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_firstidx: (skip):
 **/
guint8
fu_struct_synaprom_cmd_iota_find_get_firstidx(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[5];
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_offset: (skip):
 **/
guint32
fu_struct_synaprom_cmd_iota_find_get_offset(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_get_nbytes: (skip):
 **/
guint32
fu_struct_synaprom_cmd_iota_find_get_nbytes(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_synaprom_cmd_iota_find_set_itype: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_itype(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_flags: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_flags(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_maxniotas: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_maxniotas(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[4] = value;
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_firstidx: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_firstidx(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[5] = value;
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_offset: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_offset(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_set_nbytes: (skip):
 **/
void
fu_struct_synaprom_cmd_iota_find_set_nbytes(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_synaprom_cmd_iota_find_new: (skip):
 **/
GByteArray *
fu_struct_synaprom_cmd_iota_find_new(void)
{
    GByteArray *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    return st;
}
