/* auto-generated, do not modify */
#include "config.h"

#include "fu-wac-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_wac_report_id_to_string(FuWacReportId val)
{
    if (val == FU_WAC_REPORT_ID_FW_DESCRIPTOR)
        return "fw-descriptor";
    if (val == FU_WAC_REPORT_ID_SWITCH_TO_FLASH_LOADER)
        return "switch-to-flash-loader";
    if (val == FU_WAC_REPORT_ID_QUIT_AND_RESET)
        return "quit-and-reset";
    if (val == FU_WAC_REPORT_ID_READ_BLOCK_DATA)
        return "read-block-data";
    if (val == FU_WAC_REPORT_ID_WRITE_BLOCK)
        return "write-block";
    if (val == FU_WAC_REPORT_ID_ERASE_BLOCK)
        return "erase-block";
    if (val == FU_WAC_REPORT_ID_SET_READ_ADDRESS)
        return "set-read-address";
    if (val == FU_WAC_REPORT_ID_GET_STATUS)
        return "get-status";
    if (val == FU_WAC_REPORT_ID_UPDATE_RESET)
        return "update-reset";
    if (val == FU_WAC_REPORT_ID_WRITE_WORD)
        return "write-word";
    if (val == FU_WAC_REPORT_ID_GET_PARAMETERS)
        return "get-parameters";
    if (val == FU_WAC_REPORT_ID_GET_FLASH_DESCRIPTOR)
        return "get-flash-descriptor";
    if (val == FU_WAC_REPORT_ID_GET_CHECKSUMS)
        return "get-checksums";
    if (val == FU_WAC_REPORT_ID_SET_CHECKSUM_FOR_BLOCK)
        return "set-checksum-for-block";
    if (val == FU_WAC_REPORT_ID_CALCULATE_CHECKSUM_FOR_BLOCK)
        return "calculate-checksum-for-block";
    if (val == FU_WAC_REPORT_ID_WRITE_CHECKSUM_TABLE)
        return "write-checksum-table";
    if (val == FU_WAC_REPORT_ID_GET_CURRENT_FIRMWARE_IDX)
        return "get-current-firmware-idx";
    if (val == FU_WAC_REPORT_ID_MODULE)
        return "module";
    return NULL;
}

const gchar *
fu_wac_module_fw_type_to_string(FuWacModuleFwType val)
{
    if (val == FU_WAC_MODULE_FW_TYPE_TOUCH)
        return "touch";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH)
        return "bluetooth";
    if (val == FU_WAC_MODULE_FW_TYPE_EMR_CORRECTION)
        return "emr-correction";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH_HID)
        return "bluetooth-hid";
    if (val == FU_WAC_MODULE_FW_TYPE_SCALER)
        return "scaler";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH_ID6)
        return "bluetooth-id6";
    if (val == FU_WAC_MODULE_FW_TYPE_TOUCH_ID7)
        return "touch-id7";
    if (val == FU_WAC_MODULE_FW_TYPE_BLUETOOTH_ID9)
        return "bluetooth-id9";
    if (val == FU_WAC_MODULE_FW_TYPE_MAIN)
        return "main";
    return NULL;
}

const gchar *
fu_wac_module_command_to_string(FuWacModuleCommand val)
{
    if (val == FU_WAC_MODULE_COMMAND_START)
        return "start";
    if (val == FU_WAC_MODULE_COMMAND_DATA)
        return "data";
    if (val == FU_WAC_MODULE_COMMAND_END)
        return "end";
    return NULL;
}

const gchar *
fu_wac_module_status_to_string(FuWacModuleStatus val)
{
    if (val == FU_WAC_MODULE_STATUS_OK)
        return "ok";
    if (val == FU_WAC_MODULE_STATUS_BUSY)
        return "busy";
    if (val == FU_WAC_MODULE_STATUS_ERR_CRC)
        return "err-crc";
    if (val == FU_WAC_MODULE_STATUS_ERR_CMD)
        return "err-cmd";
    if (val == FU_WAC_MODULE_STATUS_ERR_HW_ACCESS_FAIL)
        return "err-hw-access-fail";
    if (val == FU_WAC_MODULE_STATUS_ERR_FLASH_NO_SUPPORT)
        return "err-flash-no-support";
    if (val == FU_WAC_MODULE_STATUS_ERR_MODE_WRONG)
        return "err-mode-wrong";
    if (val == FU_WAC_MODULE_STATUS_ERR_MPU_NO_SUPPORT)
        return "err-mpu-no-support";
    if (val == FU_WAC_MODULE_STATUS_ERR_VERSION_NO_SUPPORT)
        return "err-version-no-support";
    if (val == FU_WAC_MODULE_STATUS_ERR_ERASE)
        return "err-erase";
    if (val == FU_WAC_MODULE_STATUS_ERR_WRITE)
        return "err-write";
    if (val == FU_WAC_MODULE_STATUS_ERR_EXIT)
        return "err-exit";
    if (val == FU_WAC_MODULE_STATUS_ERR)
        return "err";
    if (val == FU_WAC_MODULE_STATUS_ERR_INVALID_OP)
        return "err-invalid-op";
    if (val == FU_WAC_MODULE_STATUS_ERR_WRONG_IMAGE)
        return "err-wrong-image";
    return NULL;
}

gchar *
fu_wac_device_status_to_string(FuWacDeviceStatus val)
{
    const gchar *data[6] = {0};
    guint idx = 0;
    if (val == FU_WAC_DEVICE_STATUS_UNKNOWN)
        return g_strdup("unknown");
    if (val & FU_WAC_DEVICE_STATUS_WRITING)
        data[idx++] = "writing";
    if (val & FU_WAC_DEVICE_STATUS_ERASING)
        data[idx++] = "erasing";
    if (val & FU_WAC_DEVICE_STATUS_ERROR_WRITE)
        data[idx++] = "error-write";
    if (val & FU_WAC_DEVICE_STATUS_ERROR_ERASE)
        data[idx++] = "error-erase";
    if (val & FU_WAC_DEVICE_STATUS_WRITE_PROTECTED)
        data[idx++] = "write-protected";
    return g_strjoinv(",", (gchar **)data);
}
/* getters */
/**
 * fu_struct_wta_block_header_get_block_start: (skip):
 **/
guint32
fu_struct_wta_block_header_get_block_start(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wta_block_header_get_block_size: (skip):
 **/
guint32
fu_struct_wta_block_header_get_block_size(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_wta_block_header_to_string: (skip):
 **/
static gchar *
fu_struct_wta_block_header_to_string(const GByteArray *st)
{
    g_autoptr(GString) str = g_string_new("WtaBlockHeader:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  block_start: 0x%x\n",
                           (guint) fu_struct_wta_block_header_get_block_start(st));
    g_string_append_printf(str, "  block_size: 0x%x\n",
                           (guint) fu_struct_wta_block_header_get_block_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
/**
 * fu_struct_wta_block_header_parse: (skip):
 **/
GByteArray *
fu_struct_wta_block_header_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_autofree gchar *str = NULL;
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct WtaBlockHeader: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 8);
    str = fu_struct_wta_block_header_to_string(st);
    g_debug("%s", str);
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_id9_unknown_cmd_get_unknown1: (skip):
 **/
static guint16
fu_struct_id9_unknown_cmd_get_unknown1(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_get_unknown2: (skip):
 **/
static guint32
fu_struct_id9_unknown_cmd_get_unknown2(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 2, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_id9_unknown_cmd_set_unknown1: (skip):
 **/
static void
fu_struct_id9_unknown_cmd_set_unknown1(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_set_unknown2: (skip):
 **/
static void
fu_struct_id9_unknown_cmd_set_unknown2(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 2, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_set_size: (skip):
 **/
void
fu_struct_id9_unknown_cmd_set_size(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 6, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_unknown_cmd_new: (skip):
 **/
GByteArray *
fu_struct_id9_unknown_cmd_new(void)
{
    GByteArray *st = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st, 8, 0x0);
    fu_struct_id9_unknown_cmd_set_unknown1(st, 0x7050);
    fu_struct_id9_unknown_cmd_set_unknown2(st, 0);
    return st;
}
/**
 * fu_struct_id9_unknown_cmd_validate: (skip):
 **/
static gboolean
fu_struct_id9_unknown_cmd_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error(error, "invalid struct Id9UnknownCmd: ");
        return FALSE;
    }
    if (fu_struct_id9_unknown_cmd_get_unknown1(&st) != 0x7050) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Id9UnknownCmd.unknown1 was not valid");
        return FALSE;
    }
    if (fu_struct_id9_unknown_cmd_get_unknown2(&st) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Id9UnknownCmd.unknown2 was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */
/**
 * fu_struct_id9_spi_cmd_get_command: (skip):
 **/
static guint8
fu_struct_id9_spi_cmd_get_command(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_id9_spi_cmd_get_start_addr: (skip):
 **/
static guint32
fu_struct_id9_spi_cmd_get_start_addr(const GByteArray *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_id9_spi_cmd_set_command: (skip):
 **/
static void
fu_struct_id9_spi_cmd_set_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_id9_spi_cmd_set_start_addr: (skip):
 **/
static void
fu_struct_id9_spi_cmd_set_start_addr(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_spi_cmd_set_size: (skip):
 **/
void
fu_struct_id9_spi_cmd_set_size(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 5, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_spi_cmd_set_data: (skip):
 **/
gboolean
fu_struct_id9_spi_cmd_set_data(GByteArray *st, GByteArray *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, FU_STRUCT_ID9_SPI_CMD_OFFSET_DATA, /* dst */
                          st_donor->data, st_donor->len, 0x0, /* src */
                          8, error);
}
/**
 * fu_struct_id9_spi_cmd_new: (skip):
 **/
GByteArray *
fu_struct_id9_spi_cmd_new(void)
{
    GByteArray *st = g_byte_array_sized_new(15);
    fu_byte_array_set_size(st, 15, 0x0);
    {
        g_autoptr(GByteArray) st_donor = fu_struct_id9_unknown_cmd_new();
        memcpy(st->data + 0x7, st_donor->data, st_donor->len);
    }
    fu_struct_id9_spi_cmd_set_command(st, 0x91);
    fu_struct_id9_spi_cmd_set_start_addr(st, 0);
    return st;
}
/**
 * fu_struct_id9_spi_cmd_validate: (skip):
 **/
static gboolean
fu_struct_id9_spi_cmd_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 15, error)) {
        g_prefix_error(error, "invalid struct Id9SpiCmd: ");
        return FALSE;
    }
    if (!fu_struct_id9_unknown_cmd_validate(buf, bufsz, offset + FU_STRUCT_ID9_SPI_CMD_OFFSET_DATA, error))
        return FALSE;
    if (fu_struct_id9_spi_cmd_get_command(&st) != 0x91) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Id9SpiCmd.command was not valid");
        return FALSE;
    }
    if (fu_struct_id9_spi_cmd_get_start_addr(&st) != 0) {
        g_set_error_literal(error,
                            G_IO_ERROR,
                            G_IO_ERROR_INVALID_DATA,
                            "constant Id9SpiCmd.start_addr was not valid");
        return FALSE;
    }
    return TRUE;
}
/* getters */

/* setters */
/**
 * fu_struct_id9_loader_cmd_set_command: (skip):
 **/
void
fu_struct_id9_loader_cmd_set_command(GByteArray *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_id9_loader_cmd_set_size: (skip):
 **/
void
fu_struct_id9_loader_cmd_set_size(GByteArray *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_loader_cmd_set_crc: (skip):
 **/
void
fu_struct_id9_loader_cmd_set_crc(GByteArray *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 3, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_id9_loader_cmd_set_data: (skip):
 **/
gboolean
fu_struct_id9_loader_cmd_set_data(GByteArray *st, GByteArray *st_donor, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(st_donor != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, FU_STRUCT_ID9_LOADER_CMD_OFFSET_DATA, /* dst */
                          st_donor->data, st_donor->len, 0x0, /* src */
                          15, error);
}
/**
 * fu_struct_id9_loader_cmd_new: (skip):
 **/
GByteArray *
fu_struct_id9_loader_cmd_new(void)
{
    GByteArray *st = g_byte_array_sized_new(22);
    fu_byte_array_set_size(st, 22, 0x0);
    {
        g_autoptr(GByteArray) st_donor = fu_struct_id9_spi_cmd_new();
        memcpy(st->data + 0x7, st_donor->data, st_donor->len);
    }
    return st;
}
/**
 * fu_struct_id9_loader_cmd_validate: (skip):
 **/
gboolean
fu_struct_id9_loader_cmd_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 22, error)) {
        g_prefix_error(error, "invalid struct Id9LoaderCmd: ");
        return FALSE;
    }
    if (!fu_struct_id9_spi_cmd_validate(buf, bufsz, offset + FU_STRUCT_ID9_LOADER_CMD_OFFSET_DATA, error))
        return FALSE;
    return TRUE;
}
